/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.app.BroadcastOptions;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.net.INetworkPolicyManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.Rlog;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionPlan;
import android.telephony.TelephonyManager;
import android.telephony.UiccAccessRule;
import android.util.DisplayMetrics;
import com.android.internal.telephony.IOnSubscriptionsChangedListener;
import com.android.internal.telephony.ISub;
import com.android.internal.telephony.ITelephonyRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SubscriptionManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "SubscriptionManager";
    private static boolean DBG = false;
    private static boolean VDBG = false;
    public static int INVALID_SUBSCRIPTION_ID = -1;
    public static int DUMMY_SUBSCRIPTION_ID_BASE = -2;
    public static int INVALID_PHONE_INDEX = -1;
    public static int INVALID_SIM_SLOT_INDEX = -1;
    public static int DEFAULT_SUBSCRIPTION_ID = Integer.MAX_VALUE;
    public static int DEFAULT_PHONE_INDEX = Integer.MAX_VALUE;
    public static int DEFAULT_SIM_SLOT_INDEX = Integer.MAX_VALUE;
    public static int MIN_SUBSCRIPTION_ID_VALUE = 0;
    public static int MAX_SUBSCRIPTION_ID_VALUE = 0x7FFFFFFE;
    public static Uri CONTENT_URI;
    public static String UNIQUE_KEY_SUBSCRIPTION_ID = "_id";
    public static String ICC_ID = "icc_id";
    public static String SIM_SLOT_INDEX = "sim_id";
    public static int SIM_NOT_INSERTED = -1;
    public static String DISPLAY_NAME = "display_name";
    public static String CARRIER_NAME = "carrier_name";
    public static int DEFAULT_NAME_RES = 17039374;
    public static String NAME_SOURCE = "name_source";
    public static int NAME_SOURCE_UNDEFINDED = -1;
    public static int NAME_SOURCE_DEFAULT_SOURCE = 0;
    public static int NAME_SOURCE_SIM_SOURCE = 1;
    public static int NAME_SOURCE_USER_INPUT = 2;
    public static String COLOR = "color";
    public static int COLOR_1 = 0;
    public static int COLOR_2 = 1;
    public static int COLOR_3 = 2;
    public static int COLOR_4 = 3;
    public static int COLOR_DEFAULT = 0;
    public static String NUMBER = "number";
    public static String DISPLAY_NUMBER_FORMAT = "display_number_format";
    public static int DISPLAY_NUMBER_NONE = 0;
    public static int DISPLAY_NUMBER_FIRST = 1;
    public static int DISPLAY_NUMBER_LAST = 2;
    public static int DISPLAY_NUMBER_DEFAULT = 1;
    public static String DATA_ROAMING = "data_roaming";
    public static int DATA_ROAMING_ENABLE = 1;
    public static int DATA_ROAMING_DISABLE = 0;
    public static int DATA_ROAMING_DEFAULT = 0;
    public static int SIM_PROVISIONED = 0;
    public static String MCC = "mcc";
    public static String MNC = "mnc";
    public static String SIM_PROVISIONING_STATUS = "sim_provisioning_status";
    public static String IS_EMBEDDED = "is_embedded";
    public static String CARD_ID = "card_id";
    public static String ACCESS_RULES = "access_rules";
    public static String IS_REMOVABLE = "is_removable";
    public static String CB_EXTREME_THREAT_ALERT = "enable_cmas_extreme_threat_alerts";
    public static String CB_SEVERE_THREAT_ALERT = "enable_cmas_severe_threat_alerts";
    public static String CB_AMBER_ALERT = "enable_cmas_amber_alerts";
    public static String CB_EMERGENCY_ALERT = "enable_emergency_alerts";
    public static String CB_ALERT_SOUND_DURATION = "alert_sound_duration";
    public static String CB_ALERT_REMINDER_INTERVAL = "alert_reminder_interval";
    public static String CB_ALERT_VIBRATE = "enable_alert_vibrate";
    public static String CB_ALERT_SPEECH = "enable_alert_speech";
    public static String CB_ETWS_TEST_ALERT = "enable_etws_test_alerts";
    public static String CB_CHANNEL_50_ALERT = "enable_channel_50_alerts";
    public static String CB_CMAS_TEST_ALERT = "enable_cmas_test_alerts";
    public static String CB_OPT_OUT_DIALOG = "show_cmas_opt_out_dialog";
    public static String ENHANCED_4G_MODE_ENABLED = "volte_vt_enabled";
    public static String VT_IMS_ENABLED = "vt_ims_enabled";
    public static String WFC_IMS_ENABLED = "wfc_ims_enabled";
    public static String WFC_IMS_MODE = "wfc_ims_mode";
    public static String WFC_IMS_ROAMING_MODE = "wfc_ims_roaming_mode";
    public static String WFC_IMS_ROAMING_ENABLED = "wfc_ims_roaming_enabled";
    public static String SUB_DEFAULT_CHANGED_ACTION = "android.intent.action.SUB_DEFAULT_CHANGED";
    public static String ACTION_DEFAULT_SUBSCRIPTION_CHANGED = "android.telephony.action.DEFAULT_SUBSCRIPTION_CHANGED";
    public static String ACTION_DEFAULT_SMS_SUBSCRIPTION_CHANGED = "android.telephony.action.DEFAULT_SMS_SUBSCRIPTION_CHANGED";
    @SystemApi
    public static String ACTION_MANAGE_SUBSCRIPTION_PLANS = "android.telephony.action.MANAGE_SUBSCRIPTION_PLANS";
    @SystemApi
    public static String ACTION_REFRESH_SUBSCRIPTION_PLANS = "android.telephony.action.REFRESH_SUBSCRIPTION_PLANS";
    public static String ACTION_SUBSCRIPTION_PLANS_CHANGED = "android.telephony.action.SUBSCRIPTION_PLANS_CHANGED";
    public static String EXTRA_SUBSCRIPTION_INDEX = "android.telephony.extra.SUBSCRIPTION_INDEX";
    private Context mContext;
    private volatile INetworkPolicyManager mNetworkPolicy;

    private void $$robo$$android_telephony_SubscriptionManager$__constructor__(Context context) {
        this.mContext = context;
    }

    @Deprecated
    private static final SubscriptionManager $$robo$$android_telephony_SubscriptionManager$from(Context context) {
        return (SubscriptionManager)context.getSystemService("telephony_subscription_service");
    }

    private final INetworkPolicyManager $$robo$$android_telephony_SubscriptionManager$getNetworkPolicy() {
        if (this.mNetworkPolicy == null) {
            this.mNetworkPolicy = INetworkPolicyManager.Stub.asInterface(ServiceManager.getService("netpolicy"));
        }
        return this.mNetworkPolicy;
    }

    private final void $$robo$$android_telephony_SubscriptionManager$addOnSubscriptionsChangedListener(OnSubscriptionsChangedListener listener) {
        String pkgName = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
        try {
            ITelephonyRegistry tr = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
            if (tr != null) {
                tr.addOnSubscriptionsChangedListener(pkgName, listener.callback);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_SubscriptionManager$removeOnSubscriptionsChangedListener(OnSubscriptionsChangedListener listener) {
        String pkgForDebug = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
        try {
            ITelephonyRegistry tr = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
            if (tr != null) {
                tr.removeOnSubscriptionsChangedListener(pkgForDebug, listener.callback);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final SubscriptionInfo $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfo(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            return null;
        }
        SubscriptionInfo subInfo = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subInfo = iSub.getActiveSubscriptionInfo(subId, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subInfo;
    }

    private final SubscriptionInfo $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfoForIccIndex(String iccId) {
        if (iccId == null) {
            SubscriptionManager.logd("[getActiveSubscriptionInfoForIccIndex]- null iccid");
            return null;
        }
        SubscriptionInfo result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubscriptionInfoForIccId(iccId, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private final SubscriptionInfo $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfoForSimSlotIndex(int slotIndex) {
        if (!SubscriptionManager.isValidSlotIndex(slotIndex)) {
            SubscriptionManager.logd("[getActiveSubscriptionInfoForSimSlotIndex]- invalid slotIndex");
            return null;
        }
        SubscriptionInfo result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubscriptionInfoForSimSlotIndex(slotIndex, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private final List<SubscriptionInfo> $$robo$$android_telephony_SubscriptionManager$getAllSubscriptionInfoList() {
        List<Object> result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getAllSubInfoList(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    private final List<SubscriptionInfo> $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfoList() {
        List<SubscriptionInfo> result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubscriptionInfoList(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    @SystemApi
    private final List<SubscriptionInfo> $$robo$$android_telephony_SubscriptionManager$getAvailableSubscriptionInfoList() {
        List<SubscriptionInfo> result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getAvailableSubscriptionInfoList(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private final List<SubscriptionInfo> $$robo$$android_telephony_SubscriptionManager$getAccessibleSubscriptionInfoList() {
        List<SubscriptionInfo> result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getAccessibleSubscriptionInfoList(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    @SystemApi
    private final void $$robo$$android_telephony_SubscriptionManager$requestEmbeddedSubscriptionInfoListRefresh() {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.requestEmbeddedSubscriptionInfoListRefresh();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final int $$robo$$android_telephony_SubscriptionManager$getAllSubscriptionInfoCount() {
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getAllSubInfoCount(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private final int $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfoCount() {
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubInfoCount(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private final int $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfoCountMax() {
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubInfoCountMax();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private final Uri $$robo$$android_telephony_SubscriptionManager$addSubscriptionInfoRecord(String iccId, int slotIndex) {
        if (iccId == null) {
            SubscriptionManager.logd("[addSubscriptionInfoRecord]- null iccId");
        }
        if (!SubscriptionManager.isValidSlotIndex(slotIndex)) {
            SubscriptionManager.logd("[addSubscriptionInfoRecord]- invalid slotIndex");
        }
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.addSubInfoRecord(iccId, slotIndex);
            } else {
                SubscriptionManager.logd("[addSubscriptionInfoRecord]- ISub service is null");
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    private final int $$robo$$android_telephony_SubscriptionManager$setIconTint(int tint, int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            SubscriptionManager.logd("[setIconTint]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setIconTint(tint, subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private final int $$robo$$android_telephony_SubscriptionManager$setDisplayName(String displayName, int subId) {
        return this.setDisplayName(displayName, subId, -1L);
    }

    private final int $$robo$$android_telephony_SubscriptionManager$setDisplayName(String displayName, int subId, long nameSource) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            SubscriptionManager.logd("[setDisplayName]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setDisplayNameUsingSrc(displayName, subId, nameSource);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private final int $$robo$$android_telephony_SubscriptionManager$setDisplayNumber(String number, int subId) {
        if (number == null || !SubscriptionManager.isValidSubscriptionId(subId)) {
            SubscriptionManager.logd("[setDisplayNumber]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setDisplayNumber(number, subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private final int $$robo$$android_telephony_SubscriptionManager$setDataRoaming(int roaming, int subId) {
        if (roaming < 0 || !SubscriptionManager.isValidSubscriptionId(subId)) {
            SubscriptionManager.logd("[setDataRoaming]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setDataRoaming(roaming, subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getSlotIndex(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            // empty if block
        }
        int result = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getSlotIndex(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private static final int[] $$robo$$android_telephony_SubscriptionManager$getSubId(int slotIndex) {
        if (!SubscriptionManager.isValidSlotIndex(slotIndex)) {
            SubscriptionManager.logd("[getSubId]- fail");
            return null;
        }
        int[] subId = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getSubId(slotIndex);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getPhoneId(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            return -1;
        }
        int result = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getPhoneId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private static final void $$robo$$android_telephony_SubscriptionManager$logd(String msg) {
        Rlog.d("SubscriptionManager", msg);
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getDefaultSubscriptionId() {
        int subId = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getDefaultVoiceSubscriptionId() {
        int subId = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultVoiceSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    private final void $$robo$$android_telephony_SubscriptionManager$setDefaultVoiceSubId(int subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setDefaultVoiceSubId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final SubscriptionInfo $$robo$$android_telephony_SubscriptionManager$getDefaultVoiceSubscriptionInfo() {
        return this.getActiveSubscriptionInfo(SubscriptionManager.getDefaultVoiceSubscriptionId());
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getDefaultVoicePhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultVoiceSubscriptionId());
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getDefaultSmsSubscriptionId() {
        int subId = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultSmsSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    private final void $$robo$$android_telephony_SubscriptionManager$setDefaultSmsSubId(int subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setDefaultSmsSubId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final SubscriptionInfo $$robo$$android_telephony_SubscriptionManager$getDefaultSmsSubscriptionInfo() {
        return this.getActiveSubscriptionInfo(SubscriptionManager.getDefaultSmsSubscriptionId());
    }

    private final int $$robo$$android_telephony_SubscriptionManager$getDefaultSmsPhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultSmsSubscriptionId());
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getDefaultDataSubscriptionId() {
        int subId = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultDataSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    private final void $$robo$$android_telephony_SubscriptionManager$setDefaultDataSubId(int subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setDefaultDataSubId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final SubscriptionInfo $$robo$$android_telephony_SubscriptionManager$getDefaultDataSubscriptionInfo() {
        return this.getActiveSubscriptionInfo(SubscriptionManager.getDefaultDataSubscriptionId());
    }

    private final int $$robo$$android_telephony_SubscriptionManager$getDefaultDataPhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultDataSubscriptionId());
    }

    private final void $$robo$$android_telephony_SubscriptionManager$clearSubscriptionInfo() {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.clearSubInfo();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final boolean $$robo$$android_telephony_SubscriptionManager$allDefaultsSelected() {
        if (!SubscriptionManager.isValidSubscriptionId(SubscriptionManager.getDefaultDataSubscriptionId())) {
            return false;
        }
        if (!SubscriptionManager.isValidSubscriptionId(SubscriptionManager.getDefaultSmsSubscriptionId())) {
            return false;
        }
        return SubscriptionManager.isValidSubscriptionId(SubscriptionManager.getDefaultVoiceSubscriptionId());
    }

    private final void $$robo$$android_telephony_SubscriptionManager$clearDefaultsForInactiveSubIds() {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.clearDefaultsForInactiveSubIds();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final boolean $$robo$$android_telephony_SubscriptionManager$isValidSubscriptionId(int subId) {
        return subId > -1;
    }

    private static final boolean $$robo$$android_telephony_SubscriptionManager$isUsableSubIdValue(int subId) {
        return subId >= 0 && subId <= 0x7FFFFFFE;
    }

    private static final boolean $$robo$$android_telephony_SubscriptionManager$isValidSlotIndex(int slotIndex) {
        return slotIndex >= 0 && slotIndex < TelephonyManager.getDefault().getSimCount();
    }

    private static final boolean $$robo$$android_telephony_SubscriptionManager$isValidPhoneId(int phoneId) {
        return phoneId >= 0 && phoneId < TelephonyManager.getDefault().getPhoneCount();
    }

    private static final void $$robo$$android_telephony_SubscriptionManager$putPhoneIdAndSubIdExtra(Intent intent, int phoneId) {
        int[] subIds = SubscriptionManager.getSubId(phoneId);
        if (subIds != null && subIds.length > 0) {
            SubscriptionManager.putPhoneIdAndSubIdExtra(intent, phoneId, subIds[0]);
        } else {
            SubscriptionManager.logd("putPhoneIdAndSubIdExtra: no valid subs");
        }
    }

    private static final void $$robo$$android_telephony_SubscriptionManager$putPhoneIdAndSubIdExtra(Intent intent, int phoneId, int subId) {
        intent.putExtra("subscription", subId);
        intent.putExtra("android.telephony.extra.SUBSCRIPTION_INDEX", subId);
        intent.putExtra("phone", phoneId);
        intent.putExtra("slot", phoneId);
    }

    private final int[] $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionIdList() {
        int[] subId = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getActiveSubIdList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (subId == null) {
            subId = new int[]{};
        }
        return subId;
    }

    private final boolean $$robo$$android_telephony_SubscriptionManager$isNetworkRoaming(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        if (phoneId < 0) {
            return false;
        }
        return TelephonyManager.getDefault().isNetworkRoaming(subId);
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getSimStateForSlotIndex(int slotIndex) {
        int simState = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                simState = iSub.getSimStateForSlotIndex(slotIndex);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return simState;
    }

    private static final void $$robo$$android_telephony_SubscriptionManager$setSubscriptionProperty(int subId, String propKey, String propValue) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setSubscriptionProperty(subId, propKey, propValue);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final String $$robo$$android_telephony_SubscriptionManager$getSubscriptionProperty(int subId, String propKey, Context context) {
        String resultValue = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                resultValue = iSub.getSubscriptionProperty(subId, propKey, context.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return resultValue;
    }

    private static final boolean $$robo$$android_telephony_SubscriptionManager$getBooleanSubscriptionProperty(int subId, String propKey, boolean defValue, Context context) {
        String result = SubscriptionManager.getSubscriptionProperty(subId, propKey, context);
        if (result != null) {
            try {
                return Integer.parseInt(result) == 1;
            }
            catch (NumberFormatException err) {
                SubscriptionManager.logd("getBooleanSubscriptionProperty NumberFormat exception");
            }
        }
        return defValue;
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getIntegerSubscriptionProperty(int subId, String propKey, int defValue, Context context) {
        String result = SubscriptionManager.getSubscriptionProperty(subId, propKey, context);
        if (result != null) {
            try {
                return Integer.parseInt(result);
            }
            catch (NumberFormatException err) {
                SubscriptionManager.logd("getBooleanSubscriptionProperty NumberFormat exception");
            }
        }
        return defValue;
    }

    private static final Resources $$robo$$android_telephony_SubscriptionManager$getResourcesForSubId(Context context, int subId) {
        SubscriptionInfo subInfo = SubscriptionManager.from(context).getActiveSubscriptionInfo(subId);
        Configuration config = context.getResources().getConfiguration();
        Configuration newConfig = new Configuration();
        newConfig.setTo(config);
        if (subInfo != null) {
            newConfig.mcc = subInfo.getMcc();
            newConfig.mnc = subInfo.getMnc();
            if (newConfig.mnc == 0) {
                newConfig.mnc = 65535;
            }
        }
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        DisplayMetrics newMetrics = new DisplayMetrics();
        newMetrics.setTo(metrics);
        return new Resources(context.getResources().getAssets(), newMetrics, newConfig);
    }

    private final boolean $$robo$$android_telephony_SubscriptionManager$isActiveSubId(int subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                return iSub.isActiveSubId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    @SystemApi
    private final List<SubscriptionPlan> $$robo$$android_telephony_SubscriptionManager$getSubscriptionPlans(int subId) {
        try {
            SubscriptionPlan[] subscriptionPlans = this.getNetworkPolicy().getSubscriptionPlans(subId, this.mContext.getOpPackageName());
            return subscriptionPlans == null ? Collections.emptyList() : Arrays.asList(subscriptionPlans);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final void $$robo$$android_telephony_SubscriptionManager$setSubscriptionPlans(int subId, List<SubscriptionPlan> plans) {
        try {
            this.getNetworkPolicy().setSubscriptionPlans(subId, plans.toArray(new SubscriptionPlan[plans.size()]), this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String $$robo$$android_telephony_SubscriptionManager$getSubscriptionPlansOwner(int subId) {
        try {
            return this.getNetworkPolicy().getSubscriptionPlansOwner(subId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final void $$robo$$android_telephony_SubscriptionManager$setSubscriptionOverrideUnmetered(int subId, boolean overrideUnmetered, long timeoutMillis) {
        try {
            int overrideValue = overrideUnmetered ? 1 : 0;
            this.getNetworkPolicy().setSubscriptionOverride(subId, 1, overrideValue, timeoutMillis, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final void $$robo$$android_telephony_SubscriptionManager$setSubscriptionOverrideCongested(int subId, boolean overrideCongested, long timeoutMillis) {
        try {
            int overrideValue = overrideCongested ? 2 : 0;
            this.getNetworkPolicy().setSubscriptionOverride(subId, 2, overrideValue, timeoutMillis, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Intent $$robo$$android_telephony_SubscriptionManager$createManageSubscriptionIntent(int subId) {
        String owner = this.getSubscriptionPlansOwner(subId);
        if (owner == null) {
            return null;
        }
        List<SubscriptionPlan> plans = this.getSubscriptionPlans(subId);
        if (plans.isEmpty()) {
            return null;
        }
        Intent intent = new Intent("android.telephony.action.MANAGE_SUBSCRIPTION_PLANS");
        intent.setPackage(owner);
        intent.putExtra("android.telephony.extra.SUBSCRIPTION_INDEX", subId);
        if (this.mContext.getPackageManager().queryIntentActivities(intent, 65536).isEmpty()) {
            return null;
        }
        return intent;
    }

    private final Intent $$robo$$android_telephony_SubscriptionManager$createRefreshSubscriptionIntent(int subId) {
        String owner = this.getSubscriptionPlansOwner(subId);
        if (owner == null) {
            return null;
        }
        List<SubscriptionPlan> plans = this.getSubscriptionPlans(subId);
        if (plans.isEmpty()) {
            return null;
        }
        Intent intent = new Intent("android.telephony.action.REFRESH_SUBSCRIPTION_PLANS");
        intent.addFlags(0x10000000);
        intent.setPackage(owner);
        intent.putExtra("android.telephony.extra.SUBSCRIPTION_INDEX", subId);
        if (this.mContext.getPackageManager().queryBroadcastReceivers(intent, 0).isEmpty()) {
            return null;
        }
        return intent;
    }

    private final boolean $$robo$$android_telephony_SubscriptionManager$isSubscriptionPlansRefreshSupported(int subId) {
        return this.createRefreshSubscriptionIntent(subId) != null;
    }

    private final void $$robo$$android_telephony_SubscriptionManager$requestSubscriptionPlansRefresh(int subId) {
        Intent intent = this.createRefreshSubscriptionIntent(subId);
        BroadcastOptions options = BroadcastOptions.makeBasic();
        options.setTemporaryAppWhitelistDuration(TimeUnit.MINUTES.toMillis(1L));
        this.mContext.sendBroadcast(intent, null, options.toBundle());
    }

    private final boolean $$robo$$android_telephony_SubscriptionManager$canManageSubscription(SubscriptionInfo info) {
        return this.canManageSubscription(info, this.mContext.getPackageName());
    }

    private final boolean $$robo$$android_telephony_SubscriptionManager$canManageSubscription(SubscriptionInfo info, String packageName) {
        PackageInfo packageInfo;
        if (!info.isEmbedded()) {
            throw new IllegalArgumentException("Not an embedded subscription");
        }
        if (info.getAccessRules() == null) {
            return false;
        }
        PackageManager packageManager = this.mContext.getPackageManager();
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalArgumentException("Unknown package: " + packageName, e);
        }
        for (UiccAccessRule rule : info.getAccessRules()) {
            if (rule.getCarrierPrivilegeStatus(packageInfo) != 1) continue;
            return true;
        }
        return false;
    }

    static void __staticInitializer__() {
        CONTENT_URI = Uri.parse("content://telephony/siminfo");
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_telephony_SubscriptionManager$__constructor__(context);
    }

    public SubscriptionManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SubscriptionManager$__constructor__(android.content.Context ), 0, this, context);
    }

    @Deprecated
    public static SubscriptionManager from(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$android_telephony_SubscriptionManager$from(android.content.Context ), 0, (Context)context);
    }

    private INetworkPolicyManager getNetworkPolicy() {
        return InvokeDynamicSupport.bootstrap("getNetworkPolicy", $$robo$$android_telephony_SubscriptionManager$getNetworkPolicy(), 0, this);
    }

    public void addOnSubscriptionsChangedListener(OnSubscriptionsChangedListener onSubscriptionsChangedListener) {
        InvokeDynamicSupport.bootstrap("addOnSubscriptionsChangedListener", $$robo$$android_telephony_SubscriptionManager$addOnSubscriptionsChangedListener(android.telephony.SubscriptionManager$OnSubscriptionsChangedListener ), 0, this, onSubscriptionsChangedListener);
    }

    public void removeOnSubscriptionsChangedListener(OnSubscriptionsChangedListener onSubscriptionsChangedListener) {
        InvokeDynamicSupport.bootstrap("removeOnSubscriptionsChangedListener", $$robo$$android_telephony_SubscriptionManager$removeOnSubscriptionsChangedListener(android.telephony.SubscriptionManager$OnSubscriptionsChangedListener ), 0, this, onSubscriptionsChangedListener);
    }

    public SubscriptionInfo getActiveSubscriptionInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getActiveSubscriptionInfo", $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfo(int ), 0, this, n);
    }

    public SubscriptionInfo getActiveSubscriptionInfoForIccIndex(String string2) {
        return InvokeDynamicSupport.bootstrap("getActiveSubscriptionInfoForIccIndex", $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfoForIccIndex(java.lang.String ), 0, this, string2);
    }

    public SubscriptionInfo getActiveSubscriptionInfoForSimSlotIndex(int n) {
        return InvokeDynamicSupport.bootstrap("getActiveSubscriptionInfoForSimSlotIndex", $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfoForSimSlotIndex(int ), 0, this, n);
    }

    public List<SubscriptionInfo> getAllSubscriptionInfoList() {
        return InvokeDynamicSupport.bootstrap("getAllSubscriptionInfoList", $$robo$$android_telephony_SubscriptionManager$getAllSubscriptionInfoList(), 0, this);
    }

    public List<SubscriptionInfo> getActiveSubscriptionInfoList() {
        return InvokeDynamicSupport.bootstrap("getActiveSubscriptionInfoList", $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfoList(), 0, this);
    }

    @SystemApi
    public List<SubscriptionInfo> getAvailableSubscriptionInfoList() {
        return InvokeDynamicSupport.bootstrap("getAvailableSubscriptionInfoList", $$robo$$android_telephony_SubscriptionManager$getAvailableSubscriptionInfoList(), 0, this);
    }

    public List<SubscriptionInfo> getAccessibleSubscriptionInfoList() {
        return InvokeDynamicSupport.bootstrap("getAccessibleSubscriptionInfoList", $$robo$$android_telephony_SubscriptionManager$getAccessibleSubscriptionInfoList(), 0, this);
    }

    @SystemApi
    public void requestEmbeddedSubscriptionInfoListRefresh() {
        InvokeDynamicSupport.bootstrap("requestEmbeddedSubscriptionInfoListRefresh", $$robo$$android_telephony_SubscriptionManager$requestEmbeddedSubscriptionInfoListRefresh(), 0, this);
    }

    public int getAllSubscriptionInfoCount() {
        return (int)InvokeDynamicSupport.bootstrap("getAllSubscriptionInfoCount", $$robo$$android_telephony_SubscriptionManager$getAllSubscriptionInfoCount(), 0, this);
    }

    public int getActiveSubscriptionInfoCount() {
        return (int)InvokeDynamicSupport.bootstrap("getActiveSubscriptionInfoCount", $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfoCount(), 0, this);
    }

    public int getActiveSubscriptionInfoCountMax() {
        return (int)InvokeDynamicSupport.bootstrap("getActiveSubscriptionInfoCountMax", $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfoCountMax(), 0, this);
    }

    public Uri addSubscriptionInfoRecord(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("addSubscriptionInfoRecord", $$robo$$android_telephony_SubscriptionManager$addSubscriptionInfoRecord(java.lang.String int ), 0, this, string2, n);
    }

    public int setIconTint(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("setIconTint", $$robo$$android_telephony_SubscriptionManager$setIconTint(int int ), 0, this, n, n2);
    }

    public int setDisplayName(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("setDisplayName", $$robo$$android_telephony_SubscriptionManager$setDisplayName(java.lang.String int ), 0, this, string2, n);
    }

    public int setDisplayName(String string2, int n, long l) {
        return (int)InvokeDynamicSupport.bootstrap("setDisplayName", $$robo$$android_telephony_SubscriptionManager$setDisplayName(java.lang.String int long ), 0, this, string2, n, l);
    }

    public int setDisplayNumber(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("setDisplayNumber", $$robo$$android_telephony_SubscriptionManager$setDisplayNumber(java.lang.String int ), 0, this, string2, n);
    }

    public int setDataRoaming(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("setDataRoaming", $$robo$$android_telephony_SubscriptionManager$setDataRoaming(int int ), 0, this, n, n2);
    }

    public static int getSlotIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSlotIndex", $$robo$$android_telephony_SubscriptionManager$getSlotIndex(int ), 0, (int)n);
    }

    public static int[] getSubId(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getSubId", $$robo$$android_telephony_SubscriptionManager$getSubId(int ), 0, (int)n);
    }

    public static int getPhoneId(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getPhoneId", $$robo$$android_telephony_SubscriptionManager$getPhoneId(int ), 0, (int)n);
    }

    private static void logd(String string2) {
        InvokeDynamicSupport.bootstrapStatic("logd", $$robo$$android_telephony_SubscriptionManager$logd(java.lang.String ), 0, (String)string2);
    }

    public static int getDefaultSubscriptionId() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultSubscriptionId", $$robo$$android_telephony_SubscriptionManager$getDefaultSubscriptionId(), 0);
    }

    public static int getDefaultVoiceSubscriptionId() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultVoiceSubscriptionId", $$robo$$android_telephony_SubscriptionManager$getDefaultVoiceSubscriptionId(), 0);
    }

    public void setDefaultVoiceSubId(int n) {
        InvokeDynamicSupport.bootstrap("setDefaultVoiceSubId", $$robo$$android_telephony_SubscriptionManager$setDefaultVoiceSubId(int ), 0, this, n);
    }

    public SubscriptionInfo getDefaultVoiceSubscriptionInfo() {
        return InvokeDynamicSupport.bootstrap("getDefaultVoiceSubscriptionInfo", $$robo$$android_telephony_SubscriptionManager$getDefaultVoiceSubscriptionInfo(), 0, this);
    }

    public static int getDefaultVoicePhoneId() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultVoicePhoneId", $$robo$$android_telephony_SubscriptionManager$getDefaultVoicePhoneId(), 0);
    }

    public static int getDefaultSmsSubscriptionId() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultSmsSubscriptionId", $$robo$$android_telephony_SubscriptionManager$getDefaultSmsSubscriptionId(), 0);
    }

    public void setDefaultSmsSubId(int n) {
        InvokeDynamicSupport.bootstrap("setDefaultSmsSubId", $$robo$$android_telephony_SubscriptionManager$setDefaultSmsSubId(int ), 0, this, n);
    }

    public SubscriptionInfo getDefaultSmsSubscriptionInfo() {
        return InvokeDynamicSupport.bootstrap("getDefaultSmsSubscriptionInfo", $$robo$$android_telephony_SubscriptionManager$getDefaultSmsSubscriptionInfo(), 0, this);
    }

    public int getDefaultSmsPhoneId() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultSmsPhoneId", $$robo$$android_telephony_SubscriptionManager$getDefaultSmsPhoneId(), 0, this);
    }

    public static int getDefaultDataSubscriptionId() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultDataSubscriptionId", $$robo$$android_telephony_SubscriptionManager$getDefaultDataSubscriptionId(), 0);
    }

    public void setDefaultDataSubId(int n) {
        InvokeDynamicSupport.bootstrap("setDefaultDataSubId", $$robo$$android_telephony_SubscriptionManager$setDefaultDataSubId(int ), 0, this, n);
    }

    public SubscriptionInfo getDefaultDataSubscriptionInfo() {
        return InvokeDynamicSupport.bootstrap("getDefaultDataSubscriptionInfo", $$robo$$android_telephony_SubscriptionManager$getDefaultDataSubscriptionInfo(), 0, this);
    }

    public int getDefaultDataPhoneId() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultDataPhoneId", $$robo$$android_telephony_SubscriptionManager$getDefaultDataPhoneId(), 0, this);
    }

    public void clearSubscriptionInfo() {
        InvokeDynamicSupport.bootstrap("clearSubscriptionInfo", $$robo$$android_telephony_SubscriptionManager$clearSubscriptionInfo(), 0, this);
    }

    public boolean allDefaultsSelected() {
        return (boolean)InvokeDynamicSupport.bootstrap("allDefaultsSelected", $$robo$$android_telephony_SubscriptionManager$allDefaultsSelected(), 0, this);
    }

    public void clearDefaultsForInactiveSubIds() {
        InvokeDynamicSupport.bootstrap("clearDefaultsForInactiveSubIds", $$robo$$android_telephony_SubscriptionManager$clearDefaultsForInactiveSubIds(), 0, this);
    }

    public static boolean isValidSubscriptionId(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidSubscriptionId", $$robo$$android_telephony_SubscriptionManager$isValidSubscriptionId(int ), 0, (int)n);
    }

    public static boolean isUsableSubIdValue(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isUsableSubIdValue", $$robo$$android_telephony_SubscriptionManager$isUsableSubIdValue(int ), 0, (int)n);
    }

    public static boolean isValidSlotIndex(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidSlotIndex", $$robo$$android_telephony_SubscriptionManager$isValidSlotIndex(int ), 0, (int)n);
    }

    public static boolean isValidPhoneId(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidPhoneId", $$robo$$android_telephony_SubscriptionManager$isValidPhoneId(int ), 0, (int)n);
    }

    public static void putPhoneIdAndSubIdExtra(Intent intent, int n) {
        InvokeDynamicSupport.bootstrapStatic("putPhoneIdAndSubIdExtra", $$robo$$android_telephony_SubscriptionManager$putPhoneIdAndSubIdExtra(android.content.Intent int ), 0, (Intent)intent, (int)n);
    }

    public static void putPhoneIdAndSubIdExtra(Intent intent, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("putPhoneIdAndSubIdExtra", $$robo$$android_telephony_SubscriptionManager$putPhoneIdAndSubIdExtra(android.content.Intent int int ), 0, (Intent)intent, (int)n, (int)n2);
    }

    public int[] getActiveSubscriptionIdList() {
        return InvokeDynamicSupport.bootstrap("getActiveSubscriptionIdList", $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionIdList(), 0, this);
    }

    public boolean isNetworkRoaming(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isNetworkRoaming", $$robo$$android_telephony_SubscriptionManager$isNetworkRoaming(int ), 0, this, n);
    }

    public static int getSimStateForSlotIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSimStateForSlotIndex", $$robo$$android_telephony_SubscriptionManager$getSimStateForSlotIndex(int ), 0, (int)n);
    }

    public static void setSubscriptionProperty(int n, String string2, String string3) {
        InvokeDynamicSupport.bootstrapStatic("setSubscriptionProperty", $$robo$$android_telephony_SubscriptionManager$setSubscriptionProperty(int java.lang.String java.lang.String ), 0, (int)n, (String)string2, (String)string3);
    }

    private static String getSubscriptionProperty(int n, String string2, Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getSubscriptionProperty", $$robo$$android_telephony_SubscriptionManager$getSubscriptionProperty(int java.lang.String android.content.Context ), 0, (int)n, (String)string2, (Context)context);
    }

    public static boolean getBooleanSubscriptionProperty(int n, String string2, boolean bl, Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("getBooleanSubscriptionProperty", $$robo$$android_telephony_SubscriptionManager$getBooleanSubscriptionProperty(int java.lang.String boolean android.content.Context ), 0, (int)n, (String)string2, (boolean)bl, (Context)context);
    }

    public static int getIntegerSubscriptionProperty(int n, String string2, int n2, Context context) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getIntegerSubscriptionProperty", $$robo$$android_telephony_SubscriptionManager$getIntegerSubscriptionProperty(int java.lang.String int android.content.Context ), 0, (int)n, (String)string2, (int)n2, (Context)context);
    }

    public static Resources getResourcesForSubId(Context context, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getResourcesForSubId", $$robo$$android_telephony_SubscriptionManager$getResourcesForSubId(android.content.Context int ), 0, (Context)context, (int)n);
    }

    public boolean isActiveSubId(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isActiveSubId", $$robo$$android_telephony_SubscriptionManager$isActiveSubId(int ), 0, this, n);
    }

    @SystemApi
    public List<SubscriptionPlan> getSubscriptionPlans(int n) {
        return InvokeDynamicSupport.bootstrap("getSubscriptionPlans", $$robo$$android_telephony_SubscriptionManager$getSubscriptionPlans(int ), 0, this, n);
    }

    @SystemApi
    public void setSubscriptionPlans(int n, List<SubscriptionPlan> list) {
        InvokeDynamicSupport.bootstrap("setSubscriptionPlans", $$robo$$android_telephony_SubscriptionManager$setSubscriptionPlans(int java.util.List<android.telephony.SubscriptionPlan> ), 0, this, n, list);
    }

    private String getSubscriptionPlansOwner(int n) {
        return InvokeDynamicSupport.bootstrap("getSubscriptionPlansOwner", $$robo$$android_telephony_SubscriptionManager$getSubscriptionPlansOwner(int ), 0, this, n);
    }

    @SystemApi
    public void setSubscriptionOverrideUnmetered(int n, boolean bl, long l) {
        InvokeDynamicSupport.bootstrap("setSubscriptionOverrideUnmetered", $$robo$$android_telephony_SubscriptionManager$setSubscriptionOverrideUnmetered(int boolean long ), 0, this, n, bl, l);
    }

    @SystemApi
    public void setSubscriptionOverrideCongested(int n, boolean bl, long l) {
        InvokeDynamicSupport.bootstrap("setSubscriptionOverrideCongested", $$robo$$android_telephony_SubscriptionManager$setSubscriptionOverrideCongested(int boolean long ), 0, this, n, bl, l);
    }

    public Intent createManageSubscriptionIntent(int n) {
        return InvokeDynamicSupport.bootstrap("createManageSubscriptionIntent", $$robo$$android_telephony_SubscriptionManager$createManageSubscriptionIntent(int ), 0, this, n);
    }

    private Intent createRefreshSubscriptionIntent(int n) {
        return InvokeDynamicSupport.bootstrap("createRefreshSubscriptionIntent", $$robo$$android_telephony_SubscriptionManager$createRefreshSubscriptionIntent(int ), 0, this, n);
    }

    public boolean isSubscriptionPlansRefreshSupported(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSubscriptionPlansRefreshSupported", $$robo$$android_telephony_SubscriptionManager$isSubscriptionPlansRefreshSupported(int ), 0, this, n);
    }

    public void requestSubscriptionPlansRefresh(int n) {
        InvokeDynamicSupport.bootstrap("requestSubscriptionPlansRefresh", $$robo$$android_telephony_SubscriptionManager$requestSubscriptionPlansRefresh(int ), 0, this, n);
    }

    public boolean canManageSubscription(SubscriptionInfo subscriptionInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("canManageSubscription", $$robo$$android_telephony_SubscriptionManager$canManageSubscription(android.telephony.SubscriptionInfo ), 0, this, subscriptionInfo);
    }

    public boolean canManageSubscription(SubscriptionInfo subscriptionInfo, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("canManageSubscription", $$robo$$android_telephony_SubscriptionManager$canManageSubscription(android.telephony.SubscriptionInfo java.lang.String ), 0, this, subscriptionInfo, string2);
    }

    static {
        RobolectricInternals.classInitializing(SubscriptionManager.class);
    }

    public /* synthetic */ SubscriptionManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SubscriptionManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class OnSubscriptionsChangedListener
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Handler mHandler;
        IOnSubscriptionsChangedListener callback;

        private void $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener$__constructor__() {
            this.callback = new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ OnSubscriptionsChangedListener this$0;

                private void $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_1$__constructor__(OnSubscriptionsChangedListener this$0) {
                }

                private final void $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_1$onSubscriptionsChanged() {
                    this.this$0.mHandler.sendEmptyMessage(0);
                }

                private void __constructor__(OnSubscriptionsChangedListener onSubscriptionsChangedListener) {
                    this.$$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_1$__constructor__(onSubscriptionsChangedListener);
                }
                {
                    this.this$0 = onSubscriptionsChangedListener;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_1$__constructor__(android.telephony.SubscriptionManager$OnSubscriptionsChangedListener ), 0, this, onSubscriptionsChangedListener);
                }

                @Override
                public void onSubscriptionsChanged() {
                    InvokeDynamicSupport.bootstrap("onSubscriptionsChanged", $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_1$onSubscriptionsChanged(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mHandler = new OnSubscriptionsChangedListenerHandler(this);
        }

        private void $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener$__constructor__(Looper looper) {
            this.callback = new /* invalid duplicate definition of identical inner class */;
            this.mHandler = new OnSubscriptionsChangedListenerHandler(this, looper);
        }

        private final void $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener$onSubscriptionsChanged() {
        }

        private final void $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener$log(String s) {
            Rlog.d("SubscriptionManager", s);
        }

        private void __constructor__() {
            this.$$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener$__constructor__();
        }

        public OnSubscriptionsChangedListener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener$__constructor__(), 0, this);
        }

        private void __constructor__(Looper looper) {
            this.$$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener$__constructor__(looper);
        }

        public OnSubscriptionsChangedListener(Looper looper) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener$__constructor__(android.os.Looper ), 0, this, looper);
        }

        public void onSubscriptionsChanged() {
            InvokeDynamicSupport.bootstrap("onSubscriptionsChanged", $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener$onSubscriptionsChanged(), 0, this);
        }

        private void log(String string2) {
            InvokeDynamicSupport.bootstrap("log", $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener$log(java.lang.String ), 0, this, string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OnSubscriptionsChangedListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class OnSubscriptionsChangedListenerHandler
        extends Handler
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ OnSubscriptionsChangedListener this$0;

            private void $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_OnSubscriptionsChangedListenerHandler$__constructor__(OnSubscriptionsChangedListener onSubscriptionsChangedListener) {
            }

            private void $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_OnSubscriptionsChangedListenerHandler$__constructor__(OnSubscriptionsChangedListener onSubscriptionsChangedListener, Looper looper) {
            }

            private final void $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_OnSubscriptionsChangedListenerHandler$handleMessage(Message msg) {
                this.this$0.onSubscriptionsChanged();
            }

            private void __constructor__(OnSubscriptionsChangedListener onSubscriptionsChangedListener) {
                this.$$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_OnSubscriptionsChangedListenerHandler$__constructor__(onSubscriptionsChangedListener);
            }

            OnSubscriptionsChangedListenerHandler(OnSubscriptionsChangedListener onSubscriptionsChangedListener) {
                this.this$0 = onSubscriptionsChangedListener;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_OnSubscriptionsChangedListenerHandler$__constructor__(android.telephony.SubscriptionManager$OnSubscriptionsChangedListener ), 0, this, onSubscriptionsChangedListener);
            }

            private void __constructor__(OnSubscriptionsChangedListener onSubscriptionsChangedListener, Looper looper) {
                this.$$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_OnSubscriptionsChangedListenerHandler$__constructor__(onSubscriptionsChangedListener, looper);
            }

            OnSubscriptionsChangedListenerHandler(OnSubscriptionsChangedListener onSubscriptionsChangedListener, Looper looper) {
                this.this$0 = onSubscriptionsChangedListener;
                super(looper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_OnSubscriptionsChangedListenerHandler$__constructor__(android.telephony.SubscriptionManager$OnSubscriptionsChangedListener android.os.Looper ), 0, this, onSubscriptionsChangedListener, looper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_OnSubscriptionsChangedListenerHandler$handleMessage(android.os.Message ), 0, this, message);
            }

            public /* synthetic */ OnSubscriptionsChangedListenerHandler() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OnSubscriptionsChangedListenerHandler)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

