/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.Rlog;
import android.text.TextUtils;
import com.android.internal.telephony.uicc.IccUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class UiccAccessRule
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "UiccAccessRule";
    private static int ENCODING_VERSION = 1;
    public static Parcelable.Creator<UiccAccessRule> CREATOR;
    private byte[] mCertificateHash;
    private String mPackageName;
    private long mAccessType;

    private static final byte[] $$robo$$android_telephony_UiccAccessRule$encodeRules(UiccAccessRule[] accessRules) {
        if (accessRules == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(baos);
            output.writeInt(1);
            output.writeInt(accessRules.length);
            for (UiccAccessRule accessRule : accessRules) {
                output.writeInt(accessRule.mCertificateHash.length);
                output.write(accessRule.mCertificateHash);
                if (accessRule.mPackageName != null) {
                    output.writeBoolean(true);
                    output.writeUTF(accessRule.mPackageName);
                } else {
                    output.writeBoolean(false);
                }
                output.writeLong(accessRule.mAccessType);
            }
            output.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException("ByteArrayOutputStream should never lead to an IOException", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final UiccAccessRule[] $$robo$$android_telephony_UiccAccessRule$decodeRules(byte[] encodedRules) {
        if (encodedRules == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(encodedRules);
        try (DataInputStream input = new DataInputStream(bais);){
            input.readInt();
            int count = input.readInt();
            UiccAccessRule[] accessRules = new UiccAccessRule[count];
            for (int i = 0; i < count; ++i) {
                int certificateHashLength = input.readInt();
                byte[] certificateHash = new byte[certificateHashLength];
                input.readFully(certificateHash);
                String packageName = input.readBoolean() ? input.readUTF() : null;
                long accessType = input.readLong();
                accessRules[i] = new UiccAccessRule(certificateHash, packageName, accessType);
            }
            input.close();
            UiccAccessRule[] uiccAccessRuleArray = accessRules;
            return uiccAccessRuleArray;
        }
        catch (IOException e) {
            throw new IllegalStateException("ByteArrayInputStream should never lead to an IOException", e);
        }
    }

    private void $$robo$$android_telephony_UiccAccessRule$__constructor__(byte[] certificateHash, String packageName, long accessType) {
        this.mCertificateHash = certificateHash;
        this.mPackageName = packageName;
        this.mAccessType = accessType;
    }

    private void $$robo$$android_telephony_UiccAccessRule$__constructor__(Parcel in) {
        this.mCertificateHash = in.createByteArray();
        this.mPackageName = in.readString();
        this.mAccessType = in.readLong();
    }

    private final void $$robo$$android_telephony_UiccAccessRule$writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(this.mCertificateHash);
        dest.writeString(this.mPackageName);
        dest.writeLong(this.mAccessType);
    }

    private final String $$robo$$android_telephony_UiccAccessRule$getPackageName() {
        return this.mPackageName;
    }

    private final String $$robo$$android_telephony_UiccAccessRule$getCertificateHexString() {
        return IccUtils.bytesToHexString(this.mCertificateHash);
    }

    private final int $$robo$$android_telephony_UiccAccessRule$getCarrierPrivilegeStatus(PackageInfo packageInfo) {
        if (packageInfo.signatures == null || packageInfo.signatures.length == 0) {
            throw new IllegalArgumentException("Must use GET_SIGNATURES when looking up package info");
        }
        for (Signature sig : packageInfo.signatures) {
            int accessStatus = this.getCarrierPrivilegeStatus(sig, packageInfo.packageName);
            if (accessStatus == 0) continue;
            return accessStatus;
        }
        return 0;
    }

    private final int $$robo$$android_telephony_UiccAccessRule$getCarrierPrivilegeStatus(Signature signature, String packageName) {
        byte[] certHash = UiccAccessRule.getCertHash(signature, "SHA-1");
        byte[] certHash256 = UiccAccessRule.getCertHash(signature, "SHA-256");
        if (this.matches(certHash, packageName) || this.matches(certHash256, packageName)) {
            return 1;
        }
        return 0;
    }

    private final boolean $$robo$$android_telephony_UiccAccessRule$matches(byte[] certHash, String packageName) {
        return certHash != null && Arrays.equals(this.mCertificateHash, certHash) && (TextUtils.isEmpty(this.mPackageName) || this.mPackageName.equals(packageName));
    }

    private final boolean $$robo$$android_telephony_UiccAccessRule$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UiccAccessRule that = (UiccAccessRule)obj;
        return Arrays.equals(this.mCertificateHash, that.mCertificateHash) && Objects.equals(this.mPackageName, that.mPackageName) && this.mAccessType == that.mAccessType;
    }

    private final int $$robo$$android_telephony_UiccAccessRule$hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.mCertificateHash);
        result = 31 * result + Objects.hashCode(this.mPackageName);
        result = 31 * result + Objects.hashCode(this.mAccessType);
        return result;
    }

    private final String $$robo$$android_telephony_UiccAccessRule$toString() {
        return "cert: " + IccUtils.bytesToHexString(this.mCertificateHash) + " pkg: " + this.mPackageName + " access: " + this.mAccessType;
    }

    private final int $$robo$$android_telephony_UiccAccessRule$describeContents() {
        return 0;
    }

    private static final byte[] $$robo$$android_telephony_UiccAccessRule$getCertHash(Signature signature, String algo) {
        try {
            MessageDigest md = MessageDigest.getInstance(algo);
            return md.digest(signature.toByteArray());
        }
        catch (NoSuchAlgorithmException ex) {
            Rlog.e("UiccAccessRule", "NoSuchAlgorithmException: " + ex);
            return null;
        }
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<UiccAccessRule>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_telephony_UiccAccessRule_1$__constructor__() {
            }

            private final UiccAccessRule $$robo$$android_telephony_UiccAccessRule_1$createFromParcel(Parcel in) {
                return new UiccAccessRule(in);
            }

            private final UiccAccessRule[] $$robo$$android_telephony_UiccAccessRule_1$newArray(int size) {
                return new UiccAccessRule[size];
            }

            private void __constructor__() {
                this.$$robo$$android_telephony_UiccAccessRule_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_UiccAccessRule_1$__constructor__(), 0, this);
            }

            @Override
            public UiccAccessRule createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_telephony_UiccAccessRule_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public UiccAccessRule[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_telephony_UiccAccessRule_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static byte[] encodeRules(UiccAccessRule[] uiccAccessRuleArray) {
        return InvokeDynamicSupport.bootstrapStatic("encodeRules", $$robo$$android_telephony_UiccAccessRule$encodeRules(android.telephony.UiccAccessRule[] ), 0, (UiccAccessRule[])uiccAccessRuleArray);
    }

    public static UiccAccessRule[] decodeRules(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("decodeRules", $$robo$$android_telephony_UiccAccessRule$decodeRules(byte[] ), 0, (byte[])byArray);
    }

    private void __constructor__(byte[] byArray, String string2, long l) {
        this.$$robo$$android_telephony_UiccAccessRule$__constructor__(byArray, string2, l);
    }

    public UiccAccessRule(byte[] byArray, String string2, long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_UiccAccessRule$__constructor__(byte[] java.lang.String long ), 0, this, byArray, string2, l);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_telephony_UiccAccessRule$__constructor__(parcel);
    }

    UiccAccessRule(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_UiccAccessRule$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_telephony_UiccAccessRule$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public String getPackageName() {
        return InvokeDynamicSupport.bootstrap("getPackageName", $$robo$$android_telephony_UiccAccessRule$getPackageName(), 0, this);
    }

    public String getCertificateHexString() {
        return InvokeDynamicSupport.bootstrap("getCertificateHexString", $$robo$$android_telephony_UiccAccessRule$getCertificateHexString(), 0, this);
    }

    public int getCarrierPrivilegeStatus(PackageInfo packageInfo) {
        return (int)InvokeDynamicSupport.bootstrap("getCarrierPrivilegeStatus", $$robo$$android_telephony_UiccAccessRule$getCarrierPrivilegeStatus(android.content.pm.PackageInfo ), 0, this, packageInfo);
    }

    public int getCarrierPrivilegeStatus(Signature signature, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getCarrierPrivilegeStatus", $$robo$$android_telephony_UiccAccessRule$getCarrierPrivilegeStatus(android.content.pm.Signature java.lang.String ), 0, this, signature, string2);
    }

    private boolean matches(byte[] byArray, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_telephony_UiccAccessRule$matches(byte[] java.lang.String ), 0, this, byArray, string2);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_telephony_UiccAccessRule$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_telephony_UiccAccessRule$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telephony_UiccAccessRule$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_telephony_UiccAccessRule$describeContents(), 0, this);
    }

    private static byte[] getCertHash(Signature signature, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getCertHash", $$robo$$android_telephony_UiccAccessRule$getCertHash(android.content.pm.Signature java.lang.String ), 0, (Signature)signature, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(UiccAccessRule.class);
    }

    public /* synthetic */ UiccAccessRule() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UiccAccessRule)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

