/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.data;

import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.ServiceState;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ApnSetting
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "ApnSetting";
    private static boolean VDBG = false;
    private static Map<String, Integer> APN_TYPE_STRING_MAP;
    private static Map<Integer, String> APN_TYPE_INT_MAP;
    private static Map<String, Integer> PROTOCOL_STRING_MAP;
    private static Map<Integer, String> PROTOCOL_INT_MAP;
    private static Map<String, Integer> MVNO_TYPE_STRING_MAP;
    private static Map<Integer, String> MVNO_TYPE_INT_MAP;
    private static int NOT_IN_MAP_INT = -1;
    private static int NO_PORT_SPECIFIED = -1;
    private static int TYPE_ALL_BUT_IA = 767;
    public static int TYPE_DEFAULT = 17;
    public static int TYPE_MMS = 2;
    public static int TYPE_SUPL = 4;
    public static int TYPE_DUN = 8;
    public static int TYPE_HIPRI = 16;
    public static int TYPE_FOTA = 32;
    public static int TYPE_IMS = 64;
    public static int TYPE_CBS = 128;
    public static int TYPE_IA = 256;
    public static int TYPE_EMERGENCY = 512;
    public static int AUTH_TYPE_NONE = 0;
    public static int AUTH_TYPE_PAP = 1;
    public static int AUTH_TYPE_CHAP = 2;
    public static int AUTH_TYPE_PAP_OR_CHAP = 3;
    public static int PROTOCOL_IP = 0;
    public static int PROTOCOL_IPV6 = 1;
    public static int PROTOCOL_IPV4V6 = 2;
    public static int PROTOCOL_PPP = 3;
    public static int MVNO_TYPE_SPN = 0;
    public static int MVNO_TYPE_IMSI = 1;
    public static int MVNO_TYPE_GID = 2;
    public static int MVNO_TYPE_ICCID = 3;
    private String mEntryName;
    private String mApnName;
    private InetAddress mProxyAddress;
    private int mProxyPort;
    private Uri mMmsc;
    private InetAddress mMmsProxyAddress;
    private int mMmsProxyPort;
    private String mUser;
    private String mPassword;
    private int mAuthType;
    private int mApnTypeBitmask;
    private int mId;
    private String mOperatorNumeric;
    private int mProtocol;
    private int mRoamingProtocol;
    private int mMtu;
    private boolean mCarrierEnabled;
    private int mNetworkTypeBitmask;
    private int mProfileId;
    private boolean mModemCognitive;
    private int mMaxConns;
    private int mWaitTime;
    private int mMaxConnsTime;
    private int mMvnoType;
    private String mMvnoMatchData;
    private boolean mPermanentFailed;
    public static Parcelable.Creator<ApnSetting> CREATOR;

    private final int $$robo$$android_telephony_data_ApnSetting$getMtu() {
        return this.mMtu;
    }

    private final int $$robo$$android_telephony_data_ApnSetting$getProfileId() {
        return this.mProfileId;
    }

    private final boolean $$robo$$android_telephony_data_ApnSetting$getModemCognitive() {
        return this.mModemCognitive;
    }

    private final int $$robo$$android_telephony_data_ApnSetting$getMaxConns() {
        return this.mMaxConns;
    }

    private final int $$robo$$android_telephony_data_ApnSetting$getWaitTime() {
        return this.mWaitTime;
    }

    private final int $$robo$$android_telephony_data_ApnSetting$getMaxConnsTime() {
        return this.mMaxConnsTime;
    }

    private final String $$robo$$android_telephony_data_ApnSetting$getMvnoMatchData() {
        return this.mMvnoMatchData;
    }

    private final boolean $$robo$$android_telephony_data_ApnSetting$getPermanentFailed() {
        return this.mPermanentFailed;
    }

    private final void $$robo$$android_telephony_data_ApnSetting$setPermanentFailed(boolean permanentFailed) {
        this.mPermanentFailed = permanentFailed;
    }

    private final String $$robo$$android_telephony_data_ApnSetting$getEntryName() {
        return this.mEntryName;
    }

    private final String $$robo$$android_telephony_data_ApnSetting$getApnName() {
        return this.mApnName;
    }

    private final InetAddress $$robo$$android_telephony_data_ApnSetting$getProxyAddress() {
        return this.mProxyAddress;
    }

    private final int $$robo$$android_telephony_data_ApnSetting$getProxyPort() {
        return this.mProxyPort;
    }

    private final Uri $$robo$$android_telephony_data_ApnSetting$getMmsc() {
        return this.mMmsc;
    }

    private final InetAddress $$robo$$android_telephony_data_ApnSetting$getMmsProxyAddress() {
        return this.mMmsProxyAddress;
    }

    private final int $$robo$$android_telephony_data_ApnSetting$getMmsProxyPort() {
        return this.mMmsProxyPort;
    }

    private final String $$robo$$android_telephony_data_ApnSetting$getUser() {
        return this.mUser;
    }

    private final String $$robo$$android_telephony_data_ApnSetting$getPassword() {
        return this.mPassword;
    }

    private final int $$robo$$android_telephony_data_ApnSetting$getAuthType() {
        return this.mAuthType;
    }

    private final int $$robo$$android_telephony_data_ApnSetting$getApnTypeBitmask() {
        return this.mApnTypeBitmask;
    }

    private final int $$robo$$android_telephony_data_ApnSetting$getId() {
        return this.mId;
    }

    private final String $$robo$$android_telephony_data_ApnSetting$getOperatorNumeric() {
        return this.mOperatorNumeric;
    }

    private final int $$robo$$android_telephony_data_ApnSetting$getProtocol() {
        return this.mProtocol;
    }

    private final int $$robo$$android_telephony_data_ApnSetting$getRoamingProtocol() {
        return this.mRoamingProtocol;
    }

    private final boolean $$robo$$android_telephony_data_ApnSetting$isEnabled() {
        return this.mCarrierEnabled;
    }

    private final int $$robo$$android_telephony_data_ApnSetting$getNetworkTypeBitmask() {
        return this.mNetworkTypeBitmask;
    }

    private final int $$robo$$android_telephony_data_ApnSetting$getMvnoType() {
        return this.mMvnoType;
    }

    private void $$robo$$android_telephony_data_ApnSetting$__constructor__(Builder builder) {
        this.mPermanentFailed = false;
        this.mEntryName = builder.mEntryName;
        this.mApnName = builder.mApnName;
        this.mProxyAddress = builder.mProxyAddress;
        this.mProxyPort = builder.mProxyPort;
        this.mMmsc = builder.mMmsc;
        this.mMmsProxyAddress = builder.mMmsProxyAddress;
        this.mMmsProxyPort = builder.mMmsProxyPort;
        this.mUser = builder.mUser;
        this.mPassword = builder.mPassword;
        this.mAuthType = builder.mAuthType;
        this.mApnTypeBitmask = builder.mApnTypeBitmask;
        this.mId = builder.mId;
        this.mOperatorNumeric = builder.mOperatorNumeric;
        this.mProtocol = builder.mProtocol;
        this.mRoamingProtocol = builder.mRoamingProtocol;
        this.mMtu = builder.mMtu;
        this.mCarrierEnabled = builder.mCarrierEnabled;
        this.mNetworkTypeBitmask = builder.mNetworkTypeBitmask;
        this.mProfileId = builder.mProfileId;
        this.mModemCognitive = builder.mModemCognitive;
        this.mMaxConns = builder.mMaxConns;
        this.mWaitTime = builder.mWaitTime;
        this.mMaxConnsTime = builder.mMaxConnsTime;
        this.mMvnoType = builder.mMvnoType;
        this.mMvnoMatchData = builder.mMvnoMatchData;
    }

    private static final ApnSetting $$robo$$android_telephony_data_ApnSetting$makeApnSetting(int id2, String operatorNumeric, String entryName, String apnName, InetAddress proxy, int port, Uri mmsc, InetAddress mmsProxy, int mmsPort, String user, String password, int authType, int mApnTypeBitmask, int protocol, int roamingProtocol, boolean carrierEnabled, int networkTypeBitmask, int profileId, boolean modemCognitive, int maxConns, int waitTime, int maxConnsTime, int mtu, int mvnoType, String mvnoMatchData) {
        return new Builder().setId(id2).setOperatorNumeric(operatorNumeric).setEntryName(entryName).setApnName(apnName).setProxyAddress(proxy).setProxyPort(port).setMmsc(mmsc).setMmsProxyAddress(mmsProxy).setMmsProxyPort(mmsPort).setUser(user).setPassword(password).setAuthType(authType).setApnTypeBitmask(mApnTypeBitmask).setProtocol(protocol).setRoamingProtocol(roamingProtocol).setCarrierEnabled(carrierEnabled).setNetworkTypeBitmask(networkTypeBitmask).setProfileId(profileId).setModemCognitive(modemCognitive).setMaxConns(maxConns).setWaitTime(waitTime).setMaxConnsTime(maxConnsTime).setMtu(mtu).setMvnoType(mvnoType).setMvnoMatchData(mvnoMatchData).build();
    }

    private static final ApnSetting $$robo$$android_telephony_data_ApnSetting$makeApnSetting(Cursor cursor) {
        int apnTypesBitmask = ApnSetting.parseTypes(cursor.getString(cursor.getColumnIndexOrThrow("type")));
        int networkTypeBitmask = cursor.getInt(cursor.getColumnIndexOrThrow("network_type_bitmask"));
        if (networkTypeBitmask == 0) {
            int bearerBitmask = cursor.getInt(cursor.getColumnIndexOrThrow("bearer_bitmask"));
            networkTypeBitmask = ServiceState.convertBearerBitmaskToNetworkTypeBitmask(bearerBitmask);
        }
        return ApnSetting.makeApnSetting(cursor.getInt(cursor.getColumnIndexOrThrow("_id")), cursor.getString(cursor.getColumnIndexOrThrow("numeric")), cursor.getString(cursor.getColumnIndexOrThrow("name")), cursor.getString(cursor.getColumnIndexOrThrow("apn")), ApnSetting.inetAddressFromString(cursor.getString(cursor.getColumnIndexOrThrow("proxy"))), ApnSetting.portFromString(cursor.getString(cursor.getColumnIndexOrThrow("port"))), ApnSetting.UriFromString(cursor.getString(cursor.getColumnIndexOrThrow("mmsc"))), ApnSetting.inetAddressFromString(cursor.getString(cursor.getColumnIndexOrThrow("mmsproxy"))), ApnSetting.portFromString(cursor.getString(cursor.getColumnIndexOrThrow("mmsport"))), cursor.getString(cursor.getColumnIndexOrThrow("user")), cursor.getString(cursor.getColumnIndexOrThrow("password")), cursor.getInt(cursor.getColumnIndexOrThrow("authtype")), apnTypesBitmask, ApnSetting.nullToNotInMapInt(PROTOCOL_STRING_MAP.get(cursor.getString(cursor.getColumnIndexOrThrow("protocol")))), ApnSetting.nullToNotInMapInt(PROTOCOL_STRING_MAP.get(cursor.getString(cursor.getColumnIndexOrThrow("roaming_protocol")))), cursor.getInt(cursor.getColumnIndexOrThrow("carrier_enabled")) == 1, networkTypeBitmask, cursor.getInt(cursor.getColumnIndexOrThrow("profile_id")), cursor.getInt(cursor.getColumnIndexOrThrow("modem_cognitive")) == 1, cursor.getInt(cursor.getColumnIndexOrThrow("max_conns")), cursor.getInt(cursor.getColumnIndexOrThrow("wait_time")), cursor.getInt(cursor.getColumnIndexOrThrow("max_conns_time")), cursor.getInt(cursor.getColumnIndexOrThrow("mtu")), ApnSetting.nullToNotInMapInt(MVNO_TYPE_STRING_MAP.get(cursor.getString(cursor.getColumnIndexOrThrow("mvno_type")))), cursor.getString(cursor.getColumnIndexOrThrow("mvno_match_data")));
    }

    private static final ApnSetting $$robo$$android_telephony_data_ApnSetting$makeApnSetting(ApnSetting apn) {
        return ApnSetting.makeApnSetting(apn.mId, apn.mOperatorNumeric, apn.mEntryName, apn.mApnName, apn.mProxyAddress, apn.mProxyPort, apn.mMmsc, apn.mMmsProxyAddress, apn.mMmsProxyPort, apn.mUser, apn.mPassword, apn.mAuthType, apn.mApnTypeBitmask, apn.mProtocol, apn.mRoamingProtocol, apn.mCarrierEnabled, apn.mNetworkTypeBitmask, apn.mProfileId, apn.mModemCognitive, apn.mMaxConns, apn.mWaitTime, apn.mMaxConnsTime, apn.mMtu, apn.mMvnoType, apn.mMvnoMatchData);
    }

    private final String $$robo$$android_telephony_data_ApnSetting$toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ApnSettingV4] ").append(this.mEntryName).append(", ").append(this.mId).append(", ").append(this.mOperatorNumeric).append(", ").append(this.mApnName).append(", ").append(ApnSetting.inetAddressToString(this.mProxyAddress)).append(", ").append(ApnSetting.UriToString(this.mMmsc)).append(", ").append(ApnSetting.inetAddressToString(this.mMmsProxyAddress)).append(", ").append(ApnSetting.portToString(this.mMmsProxyPort)).append(", ").append(ApnSetting.portToString(this.mProxyPort)).append(", ").append(this.mAuthType).append(", ");
        Object[] types = this.deParseTypes(this.mApnTypeBitmask).split(",");
        sb.append(TextUtils.join((CharSequence)" | ", types)).append(", ");
        sb.append(", ").append(this.mProtocol);
        sb.append(", ").append(this.mRoamingProtocol);
        sb.append(", ").append(this.mCarrierEnabled);
        sb.append(", ").append(this.mProfileId);
        sb.append(", ").append(this.mModemCognitive);
        sb.append(", ").append(this.mMaxConns);
        sb.append(", ").append(this.mWaitTime);
        sb.append(", ").append(this.mMaxConnsTime);
        sb.append(", ").append(this.mMtu);
        sb.append(", ").append(this.mMvnoType);
        sb.append(", ").append(this.mMvnoMatchData);
        sb.append(", ").append(this.mPermanentFailed);
        sb.append(", ").append(this.mNetworkTypeBitmask);
        return sb.toString();
    }

    private final boolean $$robo$$android_telephony_data_ApnSetting$hasMvnoParams() {
        return this.mMvnoType != -1 && !TextUtils.isEmpty(this.mMvnoMatchData);
    }

    private final boolean $$robo$$android_telephony_data_ApnSetting$canHandleType(int type) {
        return this.mCarrierEnabled && (this.mApnTypeBitmask & type) == type;
    }

    private final boolean $$robo$$android_telephony_data_ApnSetting$typeSameAny(ApnSetting first, ApnSetting second) {
        return (first.mApnTypeBitmask & second.mApnTypeBitmask) != 0;
    }

    private final boolean $$robo$$android_telephony_data_ApnSetting$equals(Object o) {
        if (!(o instanceof ApnSetting)) {
            return false;
        }
        ApnSetting other = (ApnSetting)o;
        return this.mEntryName.equals(other.mEntryName) && Objects.equals(this.mId, other.mId) && Objects.equals(this.mOperatorNumeric, other.mOperatorNumeric) && Objects.equals(this.mApnName, other.mApnName) && Objects.equals(this.mProxyAddress, other.mProxyAddress) && Objects.equals(this.mMmsc, other.mMmsc) && Objects.equals(this.mMmsProxyAddress, other.mMmsProxyAddress) && Objects.equals(this.mMmsProxyPort, other.mMmsProxyPort) && Objects.equals(this.mProxyPort, other.mProxyPort) && Objects.equals(this.mUser, other.mUser) && Objects.equals(this.mPassword, other.mPassword) && Objects.equals(this.mAuthType, other.mAuthType) && Objects.equals(this.mApnTypeBitmask, other.mApnTypeBitmask) && Objects.equals(this.mProtocol, other.mProtocol) && Objects.equals(this.mRoamingProtocol, other.mRoamingProtocol) && Objects.equals(this.mCarrierEnabled, other.mCarrierEnabled) && Objects.equals(this.mProfileId, other.mProfileId) && Objects.equals(this.mModemCognitive, other.mModemCognitive) && Objects.equals(this.mMaxConns, other.mMaxConns) && Objects.equals(this.mWaitTime, other.mWaitTime) && Objects.equals(this.mMaxConnsTime, other.mMaxConnsTime) && Objects.equals(this.mMtu, other.mMtu) && Objects.equals(this.mMvnoType, other.mMvnoType) && Objects.equals(this.mMvnoMatchData, other.mMvnoMatchData) && Objects.equals(this.mNetworkTypeBitmask, other.mNetworkTypeBitmask);
    }

    private final boolean $$robo$$android_telephony_data_ApnSetting$equals(Object o, boolean isDataRoaming) {
        if (!(o instanceof ApnSetting)) {
            return false;
        }
        ApnSetting other = (ApnSetting)o;
        return !(!this.mEntryName.equals(other.mEntryName) || !Objects.equals(this.mOperatorNumeric, other.mOperatorNumeric) || !Objects.equals(this.mApnName, other.mApnName) || !Objects.equals(this.mProxyAddress, other.mProxyAddress) || !Objects.equals(this.mMmsc, other.mMmsc) || !Objects.equals(this.mMmsProxyAddress, other.mMmsProxyAddress) || !Objects.equals(this.mMmsProxyPort, other.mMmsProxyPort) || !Objects.equals(this.mProxyPort, other.mProxyPort) || !Objects.equals(this.mUser, other.mUser) || !Objects.equals(this.mPassword, other.mPassword) || !Objects.equals(this.mAuthType, other.mAuthType) || !Objects.equals(this.mApnTypeBitmask, other.mApnTypeBitmask) || !isDataRoaming && !Objects.equals(this.mProtocol, other.mProtocol) || isDataRoaming && !Objects.equals(this.mRoamingProtocol, other.mRoamingProtocol) || !Objects.equals(this.mCarrierEnabled, other.mCarrierEnabled) || !Objects.equals(this.mProfileId, other.mProfileId) || !Objects.equals(this.mModemCognitive, other.mModemCognitive) || !Objects.equals(this.mMaxConns, other.mMaxConns) || !Objects.equals(this.mWaitTime, other.mWaitTime) || !Objects.equals(this.mMaxConnsTime, other.mMaxConnsTime) || !Objects.equals(this.mMtu, other.mMtu) || !Objects.equals(this.mMvnoType, other.mMvnoType) || !Objects.equals(this.mMvnoMatchData, other.mMvnoMatchData));
    }

    private final boolean $$robo$$android_telephony_data_ApnSetting$similar(ApnSetting other) {
        return !this.canHandleType(8) && !other.canHandleType(8) && Objects.equals(this.mApnName, other.mApnName) && !this.typeSameAny(this, other) && this.xorEquals(this.mProxyAddress, other.mProxyAddress) && this.xorEqualsPort(this.mProxyPort, other.mProxyPort) && this.xorEquals(this.mProtocol, other.mProtocol) && this.xorEquals(this.mRoamingProtocol, other.mRoamingProtocol) && Objects.equals(this.mCarrierEnabled, other.mCarrierEnabled) && Objects.equals(this.mProfileId, other.mProfileId) && Objects.equals(this.mMvnoType, other.mMvnoType) && Objects.equals(this.mMvnoMatchData, other.mMvnoMatchData) && this.xorEquals(this.mMmsc, other.mMmsc) && this.xorEquals(this.mMmsProxyAddress, other.mMmsProxyAddress) && this.xorEqualsPort(this.mMmsProxyPort, other.mMmsProxyPort) && Objects.equals(this.mNetworkTypeBitmask, other.mNetworkTypeBitmask);
    }

    private final boolean $$robo$$android_telephony_data_ApnSetting$xorEquals(String first, String second) {
        return Objects.equals(first, second) || TextUtils.isEmpty(first) || TextUtils.isEmpty(second);
    }

    private final boolean $$robo$$android_telephony_data_ApnSetting$xorEquals(Object first, Object second) {
        return first == null || second == null || first.equals(second);
    }

    private final boolean $$robo$$android_telephony_data_ApnSetting$xorEqualsPort(int first, int second) {
        return first == -1 || second == -1 || Objects.equals(first, second);
    }

    private final String $$robo$$android_telephony_data_ApnSetting$deParseTypes(int apnTypeBitmask) {
        ArrayList<String> types = new ArrayList<String>();
        for (Integer type : APN_TYPE_INT_MAP.keySet()) {
            if ((apnTypeBitmask & type) != type) continue;
            types.add(APN_TYPE_INT_MAP.get(type));
        }
        return TextUtils.join((CharSequence)",", types);
    }

    private final String $$robo$$android_telephony_data_ApnSetting$nullToEmpty(String stringValue) {
        return stringValue == null ? "" : stringValue;
    }

    private final ContentValues $$robo$$android_telephony_data_ApnSetting$toContentValues() {
        ContentValues apnValue = new ContentValues();
        apnValue.put("numeric", this.nullToEmpty(this.mOperatorNumeric));
        apnValue.put("name", this.nullToEmpty(this.mEntryName));
        apnValue.put("apn", this.nullToEmpty(this.mApnName));
        apnValue.put("proxy", this.mProxyAddress == null ? "" : ApnSetting.inetAddressToString(this.mProxyAddress));
        apnValue.put("port", ApnSetting.portToString(this.mProxyPort));
        apnValue.put("mmsc", this.mMmsc == null ? "" : ApnSetting.UriToString(this.mMmsc));
        apnValue.put("mmsport", ApnSetting.portToString(this.mMmsProxyPort));
        apnValue.put("mmsproxy", this.mMmsProxyAddress == null ? "" : ApnSetting.inetAddressToString(this.mMmsProxyAddress));
        apnValue.put("user", this.nullToEmpty(this.mUser));
        apnValue.put("password", this.nullToEmpty(this.mPassword));
        apnValue.put("authtype", this.mAuthType);
        String apnType = this.deParseTypes(this.mApnTypeBitmask);
        apnValue.put("type", this.nullToEmpty(apnType));
        apnValue.put("protocol", this.nullToEmpty(PROTOCOL_INT_MAP.get(this.mProtocol)));
        apnValue.put("roaming_protocol", this.nullToEmpty(PROTOCOL_INT_MAP.get(this.mRoamingProtocol)));
        apnValue.put("carrier_enabled", this.mCarrierEnabled);
        apnValue.put("mvno_type", this.nullToEmpty(MVNO_TYPE_INT_MAP.get(this.mMvnoType)));
        apnValue.put("network_type_bitmask", this.mNetworkTypeBitmask);
        return apnValue;
    }

    private static final int $$robo$$android_telephony_data_ApnSetting$parseTypes(String types) {
        if (TextUtils.isEmpty(types)) {
            return 767;
        }
        int result = 0;
        for (String str : types.split(",")) {
            Integer type = APN_TYPE_STRING_MAP.get(str);
            if (type == null) continue;
            result |= type.intValue();
        }
        return result;
    }

    private static final Uri $$robo$$android_telephony_data_ApnSetting$UriFromString(String uri) {
        return TextUtils.isEmpty(uri) ? null : Uri.parse(uri);
    }

    private static final String $$robo$$android_telephony_data_ApnSetting$UriToString(Uri uri) {
        return uri == null ? "" : uri.toString();
    }

    private static final InetAddress $$robo$$android_telephony_data_ApnSetting$inetAddressFromString(String inetAddress) {
        if (TextUtils.isEmpty(inetAddress)) {
            return null;
        }
        try {
            return InetAddress.getByName(inetAddress);
        }
        catch (UnknownHostException e) {
            Log.e("ApnSetting", "Can't parse InetAddress from string: unknown host.");
            return null;
        }
    }

    private static final String $$robo$$android_telephony_data_ApnSetting$inetAddressToString(InetAddress inetAddress) {
        if (inetAddress == null) {
            return null;
        }
        String inetAddressString = inetAddress.toString();
        if (TextUtils.isEmpty(inetAddressString)) {
            return null;
        }
        String hostName = inetAddressString.substring(0, inetAddressString.indexOf("/"));
        String address = inetAddressString.substring(inetAddressString.indexOf("/") + 1);
        if (TextUtils.isEmpty(hostName) && TextUtils.isEmpty(address)) {
            return null;
        }
        return TextUtils.isEmpty(hostName) ? address : hostName;
    }

    private static final int $$robo$$android_telephony_data_ApnSetting$portFromString(String strPort) {
        int port = -1;
        if (!TextUtils.isEmpty(strPort)) {
            try {
                port = Integer.parseInt(strPort);
            }
            catch (NumberFormatException e) {
                Log.e("ApnSetting", "Can't parse port from String");
            }
        }
        return port;
    }

    private static final String $$robo$$android_telephony_data_ApnSetting$portToString(int port) {
        return port == -1 ? "" : Integer.toString(port);
    }

    private final int $$robo$$android_telephony_data_ApnSetting$describeContents() {
        return 0;
    }

    private final void $$robo$$android_telephony_data_ApnSetting$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeString(this.mOperatorNumeric);
        dest.writeString(this.mEntryName);
        dest.writeString(this.mApnName);
        dest.writeValue(this.mProxyAddress);
        dest.writeInt(this.mProxyPort);
        dest.writeValue(this.mMmsc);
        dest.writeValue(this.mMmsProxyAddress);
        dest.writeInt(this.mMmsProxyPort);
        dest.writeString(this.mUser);
        dest.writeString(this.mPassword);
        dest.writeInt(this.mAuthType);
        dest.writeInt(this.mApnTypeBitmask);
        dest.writeInt(this.mProtocol);
        dest.writeInt(this.mRoamingProtocol);
        dest.writeInt(this.mCarrierEnabled ? 1 : 0);
        dest.writeInt(this.mMvnoType);
        dest.writeInt(this.mNetworkTypeBitmask);
    }

    private static final ApnSetting $$robo$$android_telephony_data_ApnSetting$readFromParcel(Parcel in) {
        int id2 = in.readInt();
        String operatorNumeric = in.readString();
        String entryName = in.readString();
        String apnName = in.readString();
        InetAddress proxy = (InetAddress)in.readValue(InetAddress.class.getClassLoader());
        int port = in.readInt();
        Uri mmsc = (Uri)in.readValue(Uri.class.getClassLoader());
        InetAddress mmsProxy = (InetAddress)in.readValue(InetAddress.class.getClassLoader());
        int mmsPort = in.readInt();
        String user = in.readString();
        String password = in.readString();
        int authType = in.readInt();
        int apnTypesBitmask = in.readInt();
        int protocol = in.readInt();
        int roamingProtocol = in.readInt();
        boolean carrierEnabled = in.readInt() > 0;
        int mvnoType = in.readInt();
        int networkTypeBitmask = in.readInt();
        return ApnSetting.makeApnSetting(id2, operatorNumeric, entryName, apnName, proxy, port, mmsc, mmsProxy, mmsPort, user, password, authType, apnTypesBitmask, protocol, roamingProtocol, carrierEnabled, networkTypeBitmask, 0, false, 0, 0, 0, 0, mvnoType, null);
    }

    private static final int $$robo$$android_telephony_data_ApnSetting$nullToNotInMapInt(Integer value) {
        return value == null ? -1 : value;
    }

    private /* synthetic */ void $$robo$$android_telephony_data_ApnSetting$__constructor__(Builder x0, 1 x1) {
    }

    static void __staticInitializer__() {
        APN_TYPE_STRING_MAP = new ArrayMap<String, Integer>();
        APN_TYPE_STRING_MAP.put("*", 767);
        APN_TYPE_STRING_MAP.put("default", 17);
        APN_TYPE_STRING_MAP.put("mms", 2);
        APN_TYPE_STRING_MAP.put("supl", 4);
        APN_TYPE_STRING_MAP.put("dun", 8);
        APN_TYPE_STRING_MAP.put("hipri", 16);
        APN_TYPE_STRING_MAP.put("fota", 32);
        APN_TYPE_STRING_MAP.put("ims", 64);
        APN_TYPE_STRING_MAP.put("cbs", 128);
        APN_TYPE_STRING_MAP.put("ia", 256);
        APN_TYPE_STRING_MAP.put("emergency", 512);
        APN_TYPE_INT_MAP = new ArrayMap<Integer, String>();
        APN_TYPE_INT_MAP.put(17, "default");
        APN_TYPE_INT_MAP.put(2, "mms");
        APN_TYPE_INT_MAP.put(4, "supl");
        APN_TYPE_INT_MAP.put(8, "dun");
        APN_TYPE_INT_MAP.put(16, "hipri");
        APN_TYPE_INT_MAP.put(32, "fota");
        APN_TYPE_INT_MAP.put(64, "ims");
        APN_TYPE_INT_MAP.put(128, "cbs");
        APN_TYPE_INT_MAP.put(256, "ia");
        APN_TYPE_INT_MAP.put(512, "emergency");
        PROTOCOL_STRING_MAP = new ArrayMap<String, Integer>();
        PROTOCOL_STRING_MAP.put("IP", 0);
        PROTOCOL_STRING_MAP.put("IPV6", 1);
        PROTOCOL_STRING_MAP.put("IPV4V6", 2);
        PROTOCOL_STRING_MAP.put("PPP", 3);
        PROTOCOL_INT_MAP = new ArrayMap<Integer, String>();
        PROTOCOL_INT_MAP.put(0, "IP");
        PROTOCOL_INT_MAP.put(1, "IPV6");
        PROTOCOL_INT_MAP.put(2, "IPV4V6");
        PROTOCOL_INT_MAP.put(3, "PPP");
        MVNO_TYPE_STRING_MAP = new ArrayMap<String, Integer>();
        MVNO_TYPE_STRING_MAP.put("spn", 0);
        MVNO_TYPE_STRING_MAP.put("imsi", 1);
        MVNO_TYPE_STRING_MAP.put("gid", 2);
        MVNO_TYPE_STRING_MAP.put("iccid", 3);
        MVNO_TYPE_INT_MAP = new ArrayMap<Integer, String>();
        MVNO_TYPE_INT_MAP.put(0, "spn");
        MVNO_TYPE_INT_MAP.put(1, "imsi");
        MVNO_TYPE_INT_MAP.put(2, "gid");
        MVNO_TYPE_INT_MAP.put(3, "iccid");
        CREATOR = new Parcelable.Creator<ApnSetting>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_telephony_data_ApnSetting_1$__constructor__() {
            }

            private final ApnSetting $$robo$$android_telephony_data_ApnSetting_1$createFromParcel(Parcel in) {
                return ApnSetting.readFromParcel(in);
            }

            private final ApnSetting[] $$robo$$android_telephony_data_ApnSetting_1$newArray(int size) {
                return new ApnSetting[size];
            }

            private void __constructor__() {
                this.$$robo$$android_telephony_data_ApnSetting_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_data_ApnSetting_1$__constructor__(), 0, this);
            }

            @Override
            public ApnSetting createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_telephony_data_ApnSetting_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public ApnSetting[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_telephony_data_ApnSetting_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public int getMtu() {
        return (int)InvokeDynamicSupport.bootstrap("getMtu", $$robo$$android_telephony_data_ApnSetting$getMtu(), 0, this);
    }

    public int getProfileId() {
        return (int)InvokeDynamicSupport.bootstrap("getProfileId", $$robo$$android_telephony_data_ApnSetting$getProfileId(), 0, this);
    }

    public boolean getModemCognitive() {
        return (boolean)InvokeDynamicSupport.bootstrap("getModemCognitive", $$robo$$android_telephony_data_ApnSetting$getModemCognitive(), 0, this);
    }

    public int getMaxConns() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxConns", $$robo$$android_telephony_data_ApnSetting$getMaxConns(), 0, this);
    }

    public int getWaitTime() {
        return (int)InvokeDynamicSupport.bootstrap("getWaitTime", $$robo$$android_telephony_data_ApnSetting$getWaitTime(), 0, this);
    }

    public int getMaxConnsTime() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxConnsTime", $$robo$$android_telephony_data_ApnSetting$getMaxConnsTime(), 0, this);
    }

    public String getMvnoMatchData() {
        return InvokeDynamicSupport.bootstrap("getMvnoMatchData", $$robo$$android_telephony_data_ApnSetting$getMvnoMatchData(), 0, this);
    }

    public boolean getPermanentFailed() {
        return (boolean)InvokeDynamicSupport.bootstrap("getPermanentFailed", $$robo$$android_telephony_data_ApnSetting$getPermanentFailed(), 0, this);
    }

    public void setPermanentFailed(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPermanentFailed", $$robo$$android_telephony_data_ApnSetting$setPermanentFailed(boolean ), 0, this, bl);
    }

    public String getEntryName() {
        return InvokeDynamicSupport.bootstrap("getEntryName", $$robo$$android_telephony_data_ApnSetting$getEntryName(), 0, this);
    }

    public String getApnName() {
        return InvokeDynamicSupport.bootstrap("getApnName", $$robo$$android_telephony_data_ApnSetting$getApnName(), 0, this);
    }

    public InetAddress getProxyAddress() {
        return InvokeDynamicSupport.bootstrap("getProxyAddress", $$robo$$android_telephony_data_ApnSetting$getProxyAddress(), 0, this);
    }

    public int getProxyPort() {
        return (int)InvokeDynamicSupport.bootstrap("getProxyPort", $$robo$$android_telephony_data_ApnSetting$getProxyPort(), 0, this);
    }

    public Uri getMmsc() {
        return InvokeDynamicSupport.bootstrap("getMmsc", $$robo$$android_telephony_data_ApnSetting$getMmsc(), 0, this);
    }

    public InetAddress getMmsProxyAddress() {
        return InvokeDynamicSupport.bootstrap("getMmsProxyAddress", $$robo$$android_telephony_data_ApnSetting$getMmsProxyAddress(), 0, this);
    }

    public int getMmsProxyPort() {
        return (int)InvokeDynamicSupport.bootstrap("getMmsProxyPort", $$robo$$android_telephony_data_ApnSetting$getMmsProxyPort(), 0, this);
    }

    public String getUser() {
        return InvokeDynamicSupport.bootstrap("getUser", $$robo$$android_telephony_data_ApnSetting$getUser(), 0, this);
    }

    public String getPassword() {
        return InvokeDynamicSupport.bootstrap("getPassword", $$robo$$android_telephony_data_ApnSetting$getPassword(), 0, this);
    }

    public int getAuthType() {
        return (int)InvokeDynamicSupport.bootstrap("getAuthType", $$robo$$android_telephony_data_ApnSetting$getAuthType(), 0, this);
    }

    public int getApnTypeBitmask() {
        return (int)InvokeDynamicSupport.bootstrap("getApnTypeBitmask", $$robo$$android_telephony_data_ApnSetting$getApnTypeBitmask(), 0, this);
    }

    public int getId() {
        return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_telephony_data_ApnSetting$getId(), 0, this);
    }

    public String getOperatorNumeric() {
        return InvokeDynamicSupport.bootstrap("getOperatorNumeric", $$robo$$android_telephony_data_ApnSetting$getOperatorNumeric(), 0, this);
    }

    public int getProtocol() {
        return (int)InvokeDynamicSupport.bootstrap("getProtocol", $$robo$$android_telephony_data_ApnSetting$getProtocol(), 0, this);
    }

    public int getRoamingProtocol() {
        return (int)InvokeDynamicSupport.bootstrap("getRoamingProtocol", $$robo$$android_telephony_data_ApnSetting$getRoamingProtocol(), 0, this);
    }

    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_telephony_data_ApnSetting$isEnabled(), 0, this);
    }

    public int getNetworkTypeBitmask() {
        return (int)InvokeDynamicSupport.bootstrap("getNetworkTypeBitmask", $$robo$$android_telephony_data_ApnSetting$getNetworkTypeBitmask(), 0, this);
    }

    public int getMvnoType() {
        return (int)InvokeDynamicSupport.bootstrap("getMvnoType", $$robo$$android_telephony_data_ApnSetting$getMvnoType(), 0, this);
    }

    private void __constructor__(Builder builder) {
        this.$$robo$$android_telephony_data_ApnSetting$__constructor__(builder);
    }

    private ApnSetting(Builder builder) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_data_ApnSetting$__constructor__(android.telephony.data.ApnSetting$Builder ), 0, this, builder);
    }

    public static ApnSetting makeApnSetting(int n, String string2, String string3, String string4, InetAddress inetAddress, int n2, Uri uri, InetAddress inetAddress2, int n3, String string5, String string6, int n4, int n5, int n6, int n7, boolean bl, int n8, int n9, boolean bl2, int n10, int n11, int n12, int n13, int n14, String string7) {
        return InvokeDynamicSupport.bootstrapStatic("makeApnSetting", $$robo$$android_telephony_data_ApnSetting$makeApnSetting(int java.lang.String java.lang.String java.lang.String java.net.InetAddress int android.net.Uri java.net.InetAddress int java.lang.String java.lang.String int int int int boolean int int boolean int int int int int java.lang.String ), 0, (int)n, (String)string2, (String)string3, (String)string4, (InetAddress)inetAddress, (int)n2, (Uri)uri, (InetAddress)inetAddress2, (int)n3, (String)string5, (String)string6, (int)n4, (int)n5, (int)n6, (int)n7, (boolean)bl, (int)n8, (int)n9, (boolean)bl2, (int)n10, (int)n11, (int)n12, (int)n13, (int)n14, (String)string7);
    }

    public static ApnSetting makeApnSetting(Cursor cursor) {
        return InvokeDynamicSupport.bootstrapStatic("makeApnSetting", $$robo$$android_telephony_data_ApnSetting$makeApnSetting(android.database.Cursor ), 0, (Cursor)cursor);
    }

    public static ApnSetting makeApnSetting(ApnSetting apnSetting) {
        return InvokeDynamicSupport.bootstrapStatic("makeApnSetting", $$robo$$android_telephony_data_ApnSetting$makeApnSetting(android.telephony.data.ApnSetting ), 0, (ApnSetting)apnSetting);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telephony_data_ApnSetting$toString(), 0, this);
    }

    public boolean hasMvnoParams() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMvnoParams", $$robo$$android_telephony_data_ApnSetting$hasMvnoParams(), 0, this);
    }

    public boolean canHandleType(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("canHandleType", $$robo$$android_telephony_data_ApnSetting$canHandleType(int ), 0, this, n);
    }

    private boolean typeSameAny(ApnSetting apnSetting, ApnSetting apnSetting2) {
        return (boolean)InvokeDynamicSupport.bootstrap("typeSameAny", $$robo$$android_telephony_data_ApnSetting$typeSameAny(android.telephony.data.ApnSetting android.telephony.data.ApnSetting ), 0, this, apnSetting, apnSetting2);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_telephony_data_ApnSetting$equals(java.lang.Object ), 0, this, object);
    }

    public boolean equals(Object object, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_telephony_data_ApnSetting$equals(java.lang.Object boolean ), 0, this, object, bl);
    }

    public boolean similar(ApnSetting apnSetting) {
        return (boolean)InvokeDynamicSupport.bootstrap("similar", $$robo$$android_telephony_data_ApnSetting$similar(android.telephony.data.ApnSetting ), 0, this, apnSetting);
    }

    private boolean xorEquals(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("xorEquals", $$robo$$android_telephony_data_ApnSetting$xorEquals(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private boolean xorEquals(Object object, Object object2) {
        return (boolean)InvokeDynamicSupport.bootstrap("xorEquals", $$robo$$android_telephony_data_ApnSetting$xorEquals(java.lang.Object java.lang.Object ), 0, this, object, object2);
    }

    private boolean xorEqualsPort(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("xorEqualsPort", $$robo$$android_telephony_data_ApnSetting$xorEqualsPort(int int ), 0, this, n, n2);
    }

    private String deParseTypes(int n) {
        return InvokeDynamicSupport.bootstrap("deParseTypes", $$robo$$android_telephony_data_ApnSetting$deParseTypes(int ), 0, this, n);
    }

    private String nullToEmpty(String string2) {
        return InvokeDynamicSupport.bootstrap("nullToEmpty", $$robo$$android_telephony_data_ApnSetting$nullToEmpty(java.lang.String ), 0, this, string2);
    }

    public ContentValues toContentValues() {
        return InvokeDynamicSupport.bootstrap("toContentValues", $$robo$$android_telephony_data_ApnSetting$toContentValues(), 0, this);
    }

    public static int parseTypes(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parseTypes", $$robo$$android_telephony_data_ApnSetting$parseTypes(java.lang.String ), 0, (String)string2);
    }

    private static Uri UriFromString(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("UriFromString", $$robo$$android_telephony_data_ApnSetting$UriFromString(java.lang.String ), 0, (String)string2);
    }

    private static String UriToString(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("UriToString", $$robo$$android_telephony_data_ApnSetting$UriToString(android.net.Uri ), 0, (Uri)uri);
    }

    private static InetAddress inetAddressFromString(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("inetAddressFromString", $$robo$$android_telephony_data_ApnSetting$inetAddressFromString(java.lang.String ), 0, (String)string2);
    }

    private static String inetAddressToString(InetAddress inetAddress) {
        return InvokeDynamicSupport.bootstrapStatic("inetAddressToString", $$robo$$android_telephony_data_ApnSetting$inetAddressToString(java.net.InetAddress ), 0, (InetAddress)inetAddress);
    }

    private static int portFromString(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("portFromString", $$robo$$android_telephony_data_ApnSetting$portFromString(java.lang.String ), 0, (String)string2);
    }

    private static String portToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("portToString", $$robo$$android_telephony_data_ApnSetting$portToString(int ), 0, (int)n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_telephony_data_ApnSetting$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_telephony_data_ApnSetting$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private static ApnSetting readFromParcel(Parcel parcel) {
        return InvokeDynamicSupport.bootstrapStatic("readFromParcel", $$robo$$android_telephony_data_ApnSetting$readFromParcel(android.os.Parcel ), 0, (Parcel)parcel);
    }

    private static int nullToNotInMapInt(Integer n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nullToNotInMapInt", $$robo$$android_telephony_data_ApnSetting$nullToNotInMapInt(java.lang.Integer ), 0, (Integer)n);
    }

    private /* synthetic */ void __constructor__(Builder builder, 1 var2_2) {
        this.$$robo$$android_telephony_data_ApnSetting$__constructor__(builder, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(ApnSetting.class);
    }

    public /* synthetic */ ApnSetting() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApnSetting)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mEntryName;
        private String mApnName;
        private InetAddress mProxyAddress;
        private int mProxyPort;
        private Uri mMmsc;
        private InetAddress mMmsProxyAddress;
        private int mMmsProxyPort;
        private String mUser;
        private String mPassword;
        private int mAuthType;
        private int mApnTypeBitmask;
        private int mId;
        private String mOperatorNumeric;
        private int mProtocol;
        private int mRoamingProtocol;
        private int mMtu;
        private int mNetworkTypeBitmask;
        private boolean mCarrierEnabled;
        private int mProfileId;
        private boolean mModemCognitive;
        private int mMaxConns;
        private int mWaitTime;
        private int mMaxConnsTime;
        private int mMvnoType;
        private String mMvnoMatchData;

        private void $$robo$$android_telephony_data_ApnSetting_Builder$__constructor__() {
            this.mProxyPort = -1;
            this.mMmsProxyPort = -1;
            this.mProtocol = -1;
            this.mRoamingProtocol = -1;
            this.mMvnoType = -1;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setId(int id2) {
            this.mId = id2;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setMtu(int mtu) {
            this.mMtu = mtu;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setProfileId(int profileId) {
            this.mProfileId = profileId;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setModemCognitive(boolean modemCognitive) {
            this.mModemCognitive = modemCognitive;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setMaxConns(int maxConns) {
            this.mMaxConns = maxConns;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setWaitTime(int waitTime) {
            this.mWaitTime = waitTime;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setMaxConnsTime(int maxConnsTime) {
            this.mMaxConnsTime = maxConnsTime;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setMvnoMatchData(String mvnoMatchData) {
            this.mMvnoMatchData = mvnoMatchData;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setEntryName(String entryName) {
            this.mEntryName = entryName;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setApnName(String apnName) {
            this.mApnName = apnName;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setProxyAddress(InetAddress proxy) {
            this.mProxyAddress = proxy;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setProxyPort(int port) {
            this.mProxyPort = port;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setMmsc(Uri mmsc) {
            this.mMmsc = mmsc;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setMmsProxyAddress(InetAddress mmsProxy) {
            this.mMmsProxyAddress = mmsProxy;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setMmsProxyPort(int mmsPort) {
            this.mMmsProxyPort = mmsPort;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setUser(String user) {
            this.mUser = user;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setPassword(String password) {
            this.mPassword = password;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setAuthType(int authType) {
            this.mAuthType = authType;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setApnTypeBitmask(int apnTypeBitmask) {
            this.mApnTypeBitmask = apnTypeBitmask;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setOperatorNumeric(String operatorNumeric) {
            this.mOperatorNumeric = operatorNumeric;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setProtocol(int protocol) {
            this.mProtocol = protocol;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setRoamingProtocol(int roamingProtocol) {
            this.mRoamingProtocol = roamingProtocol;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setCarrierEnabled(boolean carrierEnabled) {
            this.mCarrierEnabled = carrierEnabled;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setNetworkTypeBitmask(int networkTypeBitmask) {
            this.mNetworkTypeBitmask = networkTypeBitmask;
            return this;
        }

        private final Builder $$robo$$android_telephony_data_ApnSetting_Builder$setMvnoType(int mvnoType) {
            this.mMvnoType = mvnoType;
            return this;
        }

        private final ApnSetting $$robo$$android_telephony_data_ApnSetting_Builder$build() {
            if ((this.mApnTypeBitmask & 0x3FF) == 0 || TextUtils.isEmpty(this.mApnName) || TextUtils.isEmpty(this.mEntryName)) {
                return null;
            }
            return new ApnSetting(this);
        }

        private void __constructor__() {
            this.$$robo$$android_telephony_data_ApnSetting_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_data_ApnSetting_Builder$__constructor__(), 0, this);
        }

        private Builder setId(int n) {
            return InvokeDynamicSupport.bootstrap("setId", $$robo$$android_telephony_data_ApnSetting_Builder$setId(int ), 0, this, n);
        }

        public Builder setMtu(int n) {
            return InvokeDynamicSupport.bootstrap("setMtu", $$robo$$android_telephony_data_ApnSetting_Builder$setMtu(int ), 0, this, n);
        }

        public Builder setProfileId(int n) {
            return InvokeDynamicSupport.bootstrap("setProfileId", $$robo$$android_telephony_data_ApnSetting_Builder$setProfileId(int ), 0, this, n);
        }

        public Builder setModemCognitive(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setModemCognitive", $$robo$$android_telephony_data_ApnSetting_Builder$setModemCognitive(boolean ), 0, this, bl);
        }

        public Builder setMaxConns(int n) {
            return InvokeDynamicSupport.bootstrap("setMaxConns", $$robo$$android_telephony_data_ApnSetting_Builder$setMaxConns(int ), 0, this, n);
        }

        public Builder setWaitTime(int n) {
            return InvokeDynamicSupport.bootstrap("setWaitTime", $$robo$$android_telephony_data_ApnSetting_Builder$setWaitTime(int ), 0, this, n);
        }

        public Builder setMaxConnsTime(int n) {
            return InvokeDynamicSupport.bootstrap("setMaxConnsTime", $$robo$$android_telephony_data_ApnSetting_Builder$setMaxConnsTime(int ), 0, this, n);
        }

        public Builder setMvnoMatchData(String string2) {
            return InvokeDynamicSupport.bootstrap("setMvnoMatchData", $$robo$$android_telephony_data_ApnSetting_Builder$setMvnoMatchData(java.lang.String ), 0, this, string2);
        }

        public Builder setEntryName(String string2) {
            return InvokeDynamicSupport.bootstrap("setEntryName", $$robo$$android_telephony_data_ApnSetting_Builder$setEntryName(java.lang.String ), 0, this, string2);
        }

        public Builder setApnName(String string2) {
            return InvokeDynamicSupport.bootstrap("setApnName", $$robo$$android_telephony_data_ApnSetting_Builder$setApnName(java.lang.String ), 0, this, string2);
        }

        public Builder setProxyAddress(InetAddress inetAddress) {
            return InvokeDynamicSupport.bootstrap("setProxyAddress", $$robo$$android_telephony_data_ApnSetting_Builder$setProxyAddress(java.net.InetAddress ), 0, this, inetAddress);
        }

        public Builder setProxyPort(int n) {
            return InvokeDynamicSupport.bootstrap("setProxyPort", $$robo$$android_telephony_data_ApnSetting_Builder$setProxyPort(int ), 0, this, n);
        }

        public Builder setMmsc(Uri uri) {
            return InvokeDynamicSupport.bootstrap("setMmsc", $$robo$$android_telephony_data_ApnSetting_Builder$setMmsc(android.net.Uri ), 0, this, uri);
        }

        public Builder setMmsProxyAddress(InetAddress inetAddress) {
            return InvokeDynamicSupport.bootstrap("setMmsProxyAddress", $$robo$$android_telephony_data_ApnSetting_Builder$setMmsProxyAddress(java.net.InetAddress ), 0, this, inetAddress);
        }

        public Builder setMmsProxyPort(int n) {
            return InvokeDynamicSupport.bootstrap("setMmsProxyPort", $$robo$$android_telephony_data_ApnSetting_Builder$setMmsProxyPort(int ), 0, this, n);
        }

        public Builder setUser(String string2) {
            return InvokeDynamicSupport.bootstrap("setUser", $$robo$$android_telephony_data_ApnSetting_Builder$setUser(java.lang.String ), 0, this, string2);
        }

        public Builder setPassword(String string2) {
            return InvokeDynamicSupport.bootstrap("setPassword", $$robo$$android_telephony_data_ApnSetting_Builder$setPassword(java.lang.String ), 0, this, string2);
        }

        public Builder setAuthType(int n) {
            return InvokeDynamicSupport.bootstrap("setAuthType", $$robo$$android_telephony_data_ApnSetting_Builder$setAuthType(int ), 0, this, n);
        }

        public Builder setApnTypeBitmask(int n) {
            return InvokeDynamicSupport.bootstrap("setApnTypeBitmask", $$robo$$android_telephony_data_ApnSetting_Builder$setApnTypeBitmask(int ), 0, this, n);
        }

        public Builder setOperatorNumeric(String string2) {
            return InvokeDynamicSupport.bootstrap("setOperatorNumeric", $$robo$$android_telephony_data_ApnSetting_Builder$setOperatorNumeric(java.lang.String ), 0, this, string2);
        }

        public Builder setProtocol(int n) {
            return InvokeDynamicSupport.bootstrap("setProtocol", $$robo$$android_telephony_data_ApnSetting_Builder$setProtocol(int ), 0, this, n);
        }

        public Builder setRoamingProtocol(int n) {
            return InvokeDynamicSupport.bootstrap("setRoamingProtocol", $$robo$$android_telephony_data_ApnSetting_Builder$setRoamingProtocol(int ), 0, this, n);
        }

        public Builder setCarrierEnabled(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setCarrierEnabled", $$robo$$android_telephony_data_ApnSetting_Builder$setCarrierEnabled(boolean ), 0, this, bl);
        }

        public Builder setNetworkTypeBitmask(int n) {
            return InvokeDynamicSupport.bootstrap("setNetworkTypeBitmask", $$robo$$android_telephony_data_ApnSetting_Builder$setNetworkTypeBitmask(int ), 0, this, n);
        }

        public Builder setMvnoType(int n) {
            return InvokeDynamicSupport.bootstrap("setMvnoType", $$robo$$android_telephony_data_ApnSetting_Builder$setMvnoType(int ), 0, this, n);
        }

        public ApnSetting build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_telephony_data_ApnSetting_Builder$build(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MvnoType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProtocolType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AuthType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ApnType {
    }
}

