/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.data;

import android.app.Service;
import android.content.Intent;
import android.net.LinkProperties;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.telephony.Rlog;
import android.telephony.data.DataCallResponse;
import android.telephony.data.DataProfile;
import android.telephony.data.DataServiceCallback;
import android.telephony.data.IDataService;
import android.telephony.data.IDataServiceCallback;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class DataService
extends Service
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    public static String DATA_SERVICE_INTERFACE = "android.telephony.data.DataService";
    public static String DATA_SERVICE_EXTRA_SLOT_ID = "android.telephony.data.extra.SLOT_ID";
    public static int REQUEST_REASON_NORMAL = 1;
    public static int REQUEST_REASON_SHUTDOWN = 2;
    public static int REQUEST_REASON_HANDOVER = 3;
    private static int DATA_SERVICE_CREATE_DATA_SERVICE_PROVIDER = 1;
    private static int DATA_SERVICE_REMOVE_DATA_SERVICE_PROVIDER = 2;
    private static int DATA_SERVICE_REMOVE_ALL_DATA_SERVICE_PROVIDERS = 3;
    private static int DATA_SERVICE_REQUEST_SETUP_DATA_CALL = 4;
    private static int DATA_SERVICE_REQUEST_DEACTIVATE_DATA_CALL = 5;
    private static int DATA_SERVICE_REQUEST_SET_INITIAL_ATTACH_APN = 6;
    private static int DATA_SERVICE_REQUEST_SET_DATA_PROFILE = 7;
    private static int DATA_SERVICE_REQUEST_GET_DATA_CALL_LIST = 8;
    private static int DATA_SERVICE_REQUEST_REGISTER_DATA_CALL_LIST_CHANGED = 9;
    private static int DATA_SERVICE_REQUEST_UNREGISTER_DATA_CALL_LIST_CHANGED = 10;
    private static int DATA_SERVICE_INDICATION_DATA_CALL_LIST_CHANGED = 11;
    private HandlerThread mHandlerThread;
    private DataServiceHandler mHandler;
    private SparseArray<DataServiceProvider> mServiceMap;
    @VisibleForTesting
    public IDataServiceWrapper mBinder;

    private void $$robo$$android_telephony_data_DataService$__constructor__() {
        this.mServiceMap = new SparseArray();
        this.mBinder = new IDataServiceWrapper(this);
        this.mHandlerThread = new HandlerThread(TAG);
        this.mHandlerThread.start();
        this.mHandler = new DataServiceHandler(this, this.mHandlerThread.getLooper());
        this.log("Data service created");
    }

    public abstract DataServiceProvider createDataServiceProvider(int var1);

    private final IBinder $$robo$$android_telephony_data_DataService$onBind(Intent intent) {
        if (intent == null || !"android.telephony.data.DataService".equals(intent.getAction())) {
            this.loge("Unexpected intent " + intent);
            return null;
        }
        return this.mBinder;
    }

    private final boolean $$robo$$android_telephony_data_DataService$onUnbind(Intent intent) {
        this.mHandler.obtainMessage(3).sendToTarget();
        return false;
    }

    private final void $$robo$$android_telephony_data_DataService$onDestroy() {
        this.mHandlerThread.quit();
    }

    private final void $$robo$$android_telephony_data_DataService$log(String s) {
        Rlog.d(TAG, s);
    }

    private final void $$robo$$android_telephony_data_DataService$loge(String s) {
        Rlog.e(TAG, s);
    }

    static void __staticInitializer__() {
        TAG = DataService.class.getSimpleName();
    }

    private void __constructor__() {
        this.$$robo$$android_telephony_data_DataService$__constructor__();
    }

    public DataService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_data_DataService$__constructor__(), 0, this);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_telephony_data_DataService$onBind(android.content.Intent ), 0, this, intent);
    }

    @Override
    public boolean onUnbind(Intent intent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onUnbind", $$robo$$android_telephony_data_DataService$onUnbind(android.content.Intent ), 0, this, intent);
    }

    @Override
    public void onDestroy() {
        InvokeDynamicSupport.bootstrap("onDestroy", $$robo$$android_telephony_data_DataService$onDestroy(), 0, this);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$android_telephony_data_DataService$log(java.lang.String ), 0, this, string2);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$android_telephony_data_DataService$loge(java.lang.String ), 0, this, string2);
    }

    static {
        RobolectricInternals.classInitializing(DataService.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DataService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class IDataServiceWrapper
    extends IDataService.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DataService this$0;

        private void $$robo$$android_telephony_data_DataService_IDataServiceWrapper$__constructor__(DataService dataService) {
        }

        private final void $$robo$$android_telephony_data_DataService_IDataServiceWrapper$createDataServiceProvider(int slotId) {
            this.this$0.mHandler.obtainMessage(1, slotId, 0).sendToTarget();
        }

        private final void $$robo$$android_telephony_data_DataService_IDataServiceWrapper$removeDataServiceProvider(int slotId) {
            this.this$0.mHandler.obtainMessage(2, slotId, 0).sendToTarget();
        }

        private final void $$robo$$android_telephony_data_DataService_IDataServiceWrapper$setupDataCall(int slotId, int accessNetworkType, DataProfile dataProfile, boolean isRoaming, boolean allowRoaming, int reason, LinkProperties linkProperties, IDataServiceCallback callback) {
            this.this$0.mHandler.obtainMessage(4, slotId, 0, new SetupDataCallRequest(accessNetworkType, dataProfile, isRoaming, allowRoaming, reason, linkProperties, callback)).sendToTarget();
        }

        private final void $$robo$$android_telephony_data_DataService_IDataServiceWrapper$deactivateDataCall(int slotId, int cid, int reason, IDataServiceCallback callback) {
            this.this$0.mHandler.obtainMessage(5, slotId, 0, new DeactivateDataCallRequest(cid, reason, callback)).sendToTarget();
        }

        private final void $$robo$$android_telephony_data_DataService_IDataServiceWrapper$setInitialAttachApn(int slotId, DataProfile dataProfile, boolean isRoaming, IDataServiceCallback callback) {
            this.this$0.mHandler.obtainMessage(6, slotId, 0, new SetInitialAttachApnRequest(dataProfile, isRoaming, callback)).sendToTarget();
        }

        private final void $$robo$$android_telephony_data_DataService_IDataServiceWrapper$setDataProfile(int slotId, List<DataProfile> dps, boolean isRoaming, IDataServiceCallback callback) {
            this.this$0.mHandler.obtainMessage(7, slotId, 0, new SetDataProfileRequest(dps, isRoaming, callback)).sendToTarget();
        }

        private final void $$robo$$android_telephony_data_DataService_IDataServiceWrapper$getDataCallList(int slotId, IDataServiceCallback callback) {
            if (callback == null) {
                this.this$0.loge("getDataCallList: callback is null");
                return;
            }
            this.this$0.mHandler.obtainMessage(8, slotId, 0, callback).sendToTarget();
        }

        private final void $$robo$$android_telephony_data_DataService_IDataServiceWrapper$registerForDataCallListChanged(int slotId, IDataServiceCallback callback) {
            if (callback == null) {
                this.this$0.loge("registerForDataCallListChanged: callback is null");
                return;
            }
            this.this$0.mHandler.obtainMessage(9, slotId, 0, callback).sendToTarget();
        }

        private final void $$robo$$android_telephony_data_DataService_IDataServiceWrapper$unregisterForDataCallListChanged(int slotId, IDataServiceCallback callback) {
            if (callback == null) {
                this.this$0.loge("unregisterForDataCallListChanged: callback is null");
                return;
            }
            this.this$0.mHandler.obtainMessage(10, slotId, 0, callback).sendToTarget();
        }

        private /* synthetic */ void $$robo$$android_telephony_data_DataService_IDataServiceWrapper$__constructor__(DataService x0, 1 x1) {
        }

        private void __constructor__(DataService dataService) {
            this.$$robo$$android_telephony_data_DataService_IDataServiceWrapper$__constructor__(dataService);
        }

        private IDataServiceWrapper(DataService dataService) {
            this.this$0 = dataService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_data_DataService_IDataServiceWrapper$__constructor__(android.telephony.data.DataService ), 0, this, dataService);
        }

        @Override
        public void createDataServiceProvider(int n) {
            InvokeDynamicSupport.bootstrap("createDataServiceProvider", $$robo$$android_telephony_data_DataService_IDataServiceWrapper$createDataServiceProvider(int ), 0, this, n);
        }

        @Override
        public void removeDataServiceProvider(int n) {
            InvokeDynamicSupport.bootstrap("removeDataServiceProvider", $$robo$$android_telephony_data_DataService_IDataServiceWrapper$removeDataServiceProvider(int ), 0, this, n);
        }

        @Override
        public void setupDataCall(int n, int n2, DataProfile dataProfile, boolean bl, boolean bl2, int n3, LinkProperties linkProperties, IDataServiceCallback iDataServiceCallback) {
            InvokeDynamicSupport.bootstrap("setupDataCall", $$robo$$android_telephony_data_DataService_IDataServiceWrapper$setupDataCall(int int android.telephony.data.DataProfile boolean boolean int android.net.LinkProperties android.telephony.data.IDataServiceCallback ), 0, this, n, n2, dataProfile, bl, bl2, n3, linkProperties, iDataServiceCallback);
        }

        @Override
        public void deactivateDataCall(int n, int n2, int n3, IDataServiceCallback iDataServiceCallback) {
            InvokeDynamicSupport.bootstrap("deactivateDataCall", $$robo$$android_telephony_data_DataService_IDataServiceWrapper$deactivateDataCall(int int int android.telephony.data.IDataServiceCallback ), 0, this, n, n2, n3, iDataServiceCallback);
        }

        @Override
        public void setInitialAttachApn(int n, DataProfile dataProfile, boolean bl, IDataServiceCallback iDataServiceCallback) {
            InvokeDynamicSupport.bootstrap("setInitialAttachApn", $$robo$$android_telephony_data_DataService_IDataServiceWrapper$setInitialAttachApn(int android.telephony.data.DataProfile boolean android.telephony.data.IDataServiceCallback ), 0, this, n, dataProfile, bl, iDataServiceCallback);
        }

        @Override
        public void setDataProfile(int n, List<DataProfile> list, boolean bl, IDataServiceCallback iDataServiceCallback) {
            InvokeDynamicSupport.bootstrap("setDataProfile", $$robo$$android_telephony_data_DataService_IDataServiceWrapper$setDataProfile(int java.util.List<android.telephony.data.DataProfile> boolean android.telephony.data.IDataServiceCallback ), 0, this, n, list, bl, iDataServiceCallback);
        }

        @Override
        public void getDataCallList(int n, IDataServiceCallback iDataServiceCallback) {
            InvokeDynamicSupport.bootstrap("getDataCallList", $$robo$$android_telephony_data_DataService_IDataServiceWrapper$getDataCallList(int android.telephony.data.IDataServiceCallback ), 0, this, n, iDataServiceCallback);
        }

        @Override
        public void registerForDataCallListChanged(int n, IDataServiceCallback iDataServiceCallback) {
            InvokeDynamicSupport.bootstrap("registerForDataCallListChanged", $$robo$$android_telephony_data_DataService_IDataServiceWrapper$registerForDataCallListChanged(int android.telephony.data.IDataServiceCallback ), 0, this, n, iDataServiceCallback);
        }

        @Override
        public void unregisterForDataCallListChanged(int n, IDataServiceCallback iDataServiceCallback) {
            InvokeDynamicSupport.bootstrap("unregisterForDataCallListChanged", $$robo$$android_telephony_data_DataService_IDataServiceWrapper$unregisterForDataCallListChanged(int android.telephony.data.IDataServiceCallback ), 0, this, n, iDataServiceCallback);
        }

        private /* synthetic */ void __constructor__(DataService dataService, 1 var2_2) {
            this.$$robo$$android_telephony_data_DataService_IDataServiceWrapper$__constructor__(dataService, var2_2);
        }

        public /* synthetic */ IDataServiceWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IDataServiceWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class DataServiceHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DataService this$0;

        private void $$robo$$android_telephony_data_DataService_DataServiceHandler$__constructor__(DataService dataService, Looper looper) {
        }

        private final void $$robo$$android_telephony_data_DataService_DataServiceHandler$handleMessage(Message message) {
            int slotId = message.arg1;
            DataServiceProvider serviceProvider = (DataServiceProvider)this.this$0.mServiceMap.get(slotId);
            switch (message.what) {
                case 1: {
                    serviceProvider = this.this$0.createDataServiceProvider(message.arg1);
                    if (serviceProvider == null) break;
                    this.this$0.mServiceMap.put(slotId, serviceProvider);
                    break;
                }
                case 2: {
                    if (serviceProvider == null) break;
                    serviceProvider.onDestroy();
                    this.this$0.mServiceMap.remove(slotId);
                    break;
                }
                case 3: {
                    for (int i = 0; i < this.this$0.mServiceMap.size(); ++i) {
                        serviceProvider = (DataServiceProvider)this.this$0.mServiceMap.get(i);
                        if (serviceProvider == null) continue;
                        serviceProvider.onDestroy();
                    }
                    this.this$0.mServiceMap.clear();
                    break;
                }
                case 4: {
                    if (serviceProvider == null) break;
                    SetupDataCallRequest setupDataCallRequest = (SetupDataCallRequest)message.obj;
                    serviceProvider.setupDataCall(setupDataCallRequest.accessNetworkType, setupDataCallRequest.dataProfile, setupDataCallRequest.isRoaming, setupDataCallRequest.allowRoaming, setupDataCallRequest.reason, setupDataCallRequest.linkProperties, setupDataCallRequest.callback != null ? new DataServiceCallback(setupDataCallRequest.callback) : null);
                    break;
                }
                case 5: {
                    if (serviceProvider == null) break;
                    DeactivateDataCallRequest deactivateDataCallRequest = (DeactivateDataCallRequest)message.obj;
                    serviceProvider.deactivateDataCall(deactivateDataCallRequest.cid, deactivateDataCallRequest.reason, deactivateDataCallRequest.callback != null ? new DataServiceCallback(deactivateDataCallRequest.callback) : null);
                    break;
                }
                case 6: {
                    if (serviceProvider == null) break;
                    SetInitialAttachApnRequest setInitialAttachApnRequest = (SetInitialAttachApnRequest)message.obj;
                    serviceProvider.setInitialAttachApn(setInitialAttachApnRequest.dataProfile, setInitialAttachApnRequest.isRoaming, setInitialAttachApnRequest.callback != null ? new DataServiceCallback(setInitialAttachApnRequest.callback) : null);
                    break;
                }
                case 7: {
                    if (serviceProvider == null) break;
                    SetDataProfileRequest setDataProfileRequest = (SetDataProfileRequest)message.obj;
                    serviceProvider.setDataProfile(setDataProfileRequest.dps, setDataProfileRequest.isRoaming, setDataProfileRequest.callback != null ? new DataServiceCallback(setDataProfileRequest.callback) : null);
                    break;
                }
                case 8: {
                    if (serviceProvider == null) break;
                    serviceProvider.getDataCallList(new DataServiceCallback((IDataServiceCallback)message.obj));
                    break;
                }
                case 9: {
                    if (serviceProvider == null) break;
                    serviceProvider.registerForDataCallListChanged((IDataServiceCallback)message.obj);
                    break;
                }
                case 10: {
                    if (serviceProvider == null) break;
                    IDataServiceCallback callback = (IDataServiceCallback)message.obj;
                    serviceProvider.unregisterForDataCallListChanged(callback);
                    break;
                }
                case 11: {
                    if (serviceProvider == null) break;
                    DataCallListChangedIndication indication = (DataCallListChangedIndication)message.obj;
                    try {
                        indication.callback.onDataCallListChanged(indication.dataCallList);
                        break;
                    }
                    catch (RemoteException e) {
                        this.this$0.loge("Failed to call onDataCallListChanged. " + e);
                    }
                }
            }
        }

        private void __constructor__(DataService dataService, Looper looper) {
            this.$$robo$$android_telephony_data_DataService_DataServiceHandler$__constructor__(dataService, looper);
        }

        DataServiceHandler(DataService dataService, Looper looper) {
            this.this$0 = dataService;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_data_DataService_DataServiceHandler$__constructor__(android.telephony.data.DataService android.os.Looper ), 0, this, dataService, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_telephony_data_DataService_DataServiceHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ DataServiceHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DataServiceHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class DataCallListChangedIndication
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public List<DataCallResponse> dataCallList;
        public IDataServiceCallback callback;

        private void $$robo$$android_telephony_data_DataService_DataCallListChangedIndication$__constructor__(List<DataCallResponse> dataCallList, IDataServiceCallback callback) {
            this.dataCallList = dataCallList;
            this.callback = callback;
        }

        private void __constructor__(List<DataCallResponse> list, IDataServiceCallback iDataServiceCallback) {
            this.$$robo$$android_telephony_data_DataService_DataCallListChangedIndication$__constructor__(list, iDataServiceCallback);
        }

        DataCallListChangedIndication(List<DataCallResponse> list, IDataServiceCallback iDataServiceCallback) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_data_DataService_DataCallListChangedIndication$__constructor__(java.util.List<android.telephony.data.DataCallResponse> android.telephony.data.IDataServiceCallback ), 0, this, list, iDataServiceCallback);
        }

        public /* synthetic */ DataCallListChangedIndication() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DataCallListChangedIndication)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class SetDataProfileRequest
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public List<DataProfile> dps;
        public boolean isRoaming;
        public IDataServiceCallback callback;

        private void $$robo$$android_telephony_data_DataService_SetDataProfileRequest$__constructor__(List<DataProfile> dps, boolean isRoaming, IDataServiceCallback callback) {
            this.dps = dps;
            this.isRoaming = isRoaming;
            this.callback = callback;
        }

        private void __constructor__(List<DataProfile> list, boolean bl, IDataServiceCallback iDataServiceCallback) {
            this.$$robo$$android_telephony_data_DataService_SetDataProfileRequest$__constructor__(list, bl, iDataServiceCallback);
        }

        SetDataProfileRequest(List<DataProfile> list, boolean bl, IDataServiceCallback iDataServiceCallback) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_data_DataService_SetDataProfileRequest$__constructor__(java.util.List<android.telephony.data.DataProfile> boolean android.telephony.data.IDataServiceCallback ), 0, this, list, bl, iDataServiceCallback);
        }

        public /* synthetic */ SetDataProfileRequest() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SetDataProfileRequest)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class SetInitialAttachApnRequest
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public DataProfile dataProfile;
        public boolean isRoaming;
        public IDataServiceCallback callback;

        private void $$robo$$android_telephony_data_DataService_SetInitialAttachApnRequest$__constructor__(DataProfile dataProfile, boolean isRoaming, IDataServiceCallback callback) {
            this.dataProfile = dataProfile;
            this.isRoaming = isRoaming;
            this.callback = callback;
        }

        private void __constructor__(DataProfile dataProfile, boolean bl, IDataServiceCallback iDataServiceCallback) {
            this.$$robo$$android_telephony_data_DataService_SetInitialAttachApnRequest$__constructor__(dataProfile, bl, iDataServiceCallback);
        }

        SetInitialAttachApnRequest(DataProfile dataProfile, boolean bl, IDataServiceCallback iDataServiceCallback) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_data_DataService_SetInitialAttachApnRequest$__constructor__(android.telephony.data.DataProfile boolean android.telephony.data.IDataServiceCallback ), 0, this, dataProfile, bl, iDataServiceCallback);
        }

        public /* synthetic */ SetInitialAttachApnRequest() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SetInitialAttachApnRequest)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class DeactivateDataCallRequest
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int cid;
        public int reason;
        public IDataServiceCallback callback;

        private void $$robo$$android_telephony_data_DataService_DeactivateDataCallRequest$__constructor__(int cid, int reason, IDataServiceCallback callback) {
            this.cid = cid;
            this.reason = reason;
            this.callback = callback;
        }

        private void __constructor__(int n, int n2, IDataServiceCallback iDataServiceCallback) {
            this.$$robo$$android_telephony_data_DataService_DeactivateDataCallRequest$__constructor__(n, n2, iDataServiceCallback);
        }

        DeactivateDataCallRequest(int n, int n2, IDataServiceCallback iDataServiceCallback) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_data_DataService_DeactivateDataCallRequest$__constructor__(int int android.telephony.data.IDataServiceCallback ), 0, this, n, n2, iDataServiceCallback);
        }

        public /* synthetic */ DeactivateDataCallRequest() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DeactivateDataCallRequest)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class SetupDataCallRequest
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int accessNetworkType;
        public DataProfile dataProfile;
        public boolean isRoaming;
        public boolean allowRoaming;
        public int reason;
        public LinkProperties linkProperties;
        public IDataServiceCallback callback;

        private void $$robo$$android_telephony_data_DataService_SetupDataCallRequest$__constructor__(int accessNetworkType, DataProfile dataProfile, boolean isRoaming, boolean allowRoaming, int reason, LinkProperties linkProperties, IDataServiceCallback callback) {
            this.accessNetworkType = accessNetworkType;
            this.dataProfile = dataProfile;
            this.isRoaming = isRoaming;
            this.allowRoaming = allowRoaming;
            this.linkProperties = linkProperties;
            this.reason = reason;
            this.callback = callback;
        }

        private void __constructor__(int n, DataProfile dataProfile, boolean bl, boolean bl2, int n2, LinkProperties linkProperties, IDataServiceCallback iDataServiceCallback) {
            this.$$robo$$android_telephony_data_DataService_SetupDataCallRequest$__constructor__(n, dataProfile, bl, bl2, n2, linkProperties, iDataServiceCallback);
        }

        SetupDataCallRequest(int n, DataProfile dataProfile, boolean bl, boolean bl2, int n2, LinkProperties linkProperties, IDataServiceCallback iDataServiceCallback) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_data_DataService_SetupDataCallRequest$__constructor__(int android.telephony.data.DataProfile boolean boolean int android.net.LinkProperties android.telephony.data.IDataServiceCallback ), 0, this, n, dataProfile, bl, bl2, n2, linkProperties, iDataServiceCallback);
        }

        public /* synthetic */ SetupDataCallRequest() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SetupDataCallRequest)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class DataServiceProvider
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mSlotId;
        private List<IDataServiceCallback> mDataCallListChangedCallbacks;
        /* synthetic */ DataService this$0;

        private void $$robo$$android_telephony_data_DataService_DataServiceProvider$__constructor__(DataService this$0, int slotId) {
            this.mDataCallListChangedCallbacks = new ArrayList<IDataServiceCallback>();
            this.mSlotId = slotId;
        }

        private final int $$robo$$android_telephony_data_DataService_DataServiceProvider$getSlotId() {
            return this.mSlotId;
        }

        private final void $$robo$$android_telephony_data_DataService_DataServiceProvider$setupDataCall(int accessNetworkType, DataProfile dataProfile, boolean isRoaming, boolean allowRoaming, int reason, LinkProperties linkProperties, DataServiceCallback callback) {
            callback.onSetupDataCallComplete(1, null);
        }

        private final void $$robo$$android_telephony_data_DataService_DataServiceProvider$deactivateDataCall(int cid, int reason, DataServiceCallback callback) {
            callback.onDeactivateDataCallComplete(1);
        }

        private final void $$robo$$android_telephony_data_DataService_DataServiceProvider$setInitialAttachApn(DataProfile dataProfile, boolean isRoaming, DataServiceCallback callback) {
            callback.onSetInitialAttachApnComplete(1);
        }

        private final void $$robo$$android_telephony_data_DataService_DataServiceProvider$setDataProfile(List<DataProfile> dps, boolean isRoaming, DataServiceCallback callback) {
            callback.onSetDataProfileComplete(1);
        }

        private final void $$robo$$android_telephony_data_DataService_DataServiceProvider$getDataCallList(DataServiceCallback callback) {
            callback.onGetDataCallListComplete(1, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_telephony_data_DataService_DataServiceProvider$registerForDataCallListChanged(IDataServiceCallback callback) {
            List<IDataServiceCallback> list = this.mDataCallListChangedCallbacks;
            synchronized (list) {
                this.mDataCallListChangedCallbacks.add(callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_telephony_data_DataService_DataServiceProvider$unregisterForDataCallListChanged(IDataServiceCallback callback) {
            List<IDataServiceCallback> list = this.mDataCallListChangedCallbacks;
            synchronized (list) {
                this.mDataCallListChangedCallbacks.remove(callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_telephony_data_DataService_DataServiceProvider$notifyDataCallListChanged(List<DataCallResponse> dataCallList) {
            List<IDataServiceCallback> list = this.mDataCallListChangedCallbacks;
            synchronized (list) {
                for (IDataServiceCallback callback : this.mDataCallListChangedCallbacks) {
                    this.this$0.mHandler.obtainMessage(11, this.mSlotId, 0, new DataCallListChangedIndication(dataCallList, callback)).sendToTarget();
                }
            }
        }

        private final void $$robo$$android_telephony_data_DataService_DataServiceProvider$onDestroy() {
            this.mDataCallListChangedCallbacks.clear();
        }

        private void __constructor__(DataService dataService, int n) {
            this.$$robo$$android_telephony_data_DataService_DataServiceProvider$__constructor__(dataService, n);
        }

        public DataServiceProvider(DataService dataService, int n) {
            this.this$0 = dataService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_data_DataService_DataServiceProvider$__constructor__(android.telephony.data.DataService int ), 0, this, dataService, n);
        }

        public int getSlotId() {
            return (int)InvokeDynamicSupport.bootstrap("getSlotId", $$robo$$android_telephony_data_DataService_DataServiceProvider$getSlotId(), 0, this);
        }

        public void setupDataCall(int n, DataProfile dataProfile, boolean bl, boolean bl2, int n2, LinkProperties linkProperties, DataServiceCallback dataServiceCallback) {
            InvokeDynamicSupport.bootstrap("setupDataCall", $$robo$$android_telephony_data_DataService_DataServiceProvider$setupDataCall(int android.telephony.data.DataProfile boolean boolean int android.net.LinkProperties android.telephony.data.DataServiceCallback ), 0, this, n, dataProfile, bl, bl2, n2, linkProperties, dataServiceCallback);
        }

        public void deactivateDataCall(int n, int n2, DataServiceCallback dataServiceCallback) {
            InvokeDynamicSupport.bootstrap("deactivateDataCall", $$robo$$android_telephony_data_DataService_DataServiceProvider$deactivateDataCall(int int android.telephony.data.DataServiceCallback ), 0, this, n, n2, dataServiceCallback);
        }

        public void setInitialAttachApn(DataProfile dataProfile, boolean bl, DataServiceCallback dataServiceCallback) {
            InvokeDynamicSupport.bootstrap("setInitialAttachApn", $$robo$$android_telephony_data_DataService_DataServiceProvider$setInitialAttachApn(android.telephony.data.DataProfile boolean android.telephony.data.DataServiceCallback ), 0, this, dataProfile, bl, dataServiceCallback);
        }

        public void setDataProfile(List<DataProfile> list, boolean bl, DataServiceCallback dataServiceCallback) {
            InvokeDynamicSupport.bootstrap("setDataProfile", $$robo$$android_telephony_data_DataService_DataServiceProvider$setDataProfile(java.util.List<android.telephony.data.DataProfile> boolean android.telephony.data.DataServiceCallback ), 0, this, list, bl, dataServiceCallback);
        }

        public void getDataCallList(DataServiceCallback dataServiceCallback) {
            InvokeDynamicSupport.bootstrap("getDataCallList", $$robo$$android_telephony_data_DataService_DataServiceProvider$getDataCallList(android.telephony.data.DataServiceCallback ), 0, this, dataServiceCallback);
        }

        private void registerForDataCallListChanged(IDataServiceCallback iDataServiceCallback) {
            InvokeDynamicSupport.bootstrap("registerForDataCallListChanged", $$robo$$android_telephony_data_DataService_DataServiceProvider$registerForDataCallListChanged(android.telephony.data.IDataServiceCallback ), 0, this, iDataServiceCallback);
        }

        private void unregisterForDataCallListChanged(IDataServiceCallback iDataServiceCallback) {
            InvokeDynamicSupport.bootstrap("unregisterForDataCallListChanged", $$robo$$android_telephony_data_DataService_DataServiceProvider$unregisterForDataCallListChanged(android.telephony.data.IDataServiceCallback ), 0, this, iDataServiceCallback);
        }

        public void notifyDataCallListChanged(List<DataCallResponse> list) {
            InvokeDynamicSupport.bootstrap("notifyDataCallListChanged", $$robo$$android_telephony_data_DataService_DataServiceProvider$notifyDataCallListChanged(java.util.List<android.telephony.data.DataCallResponse> ), 0, this, list);
        }

        protected void onDestroy() {
            InvokeDynamicSupport.bootstrap("onDestroy", $$robo$$android_telephony_data_DataService_DataServiceProvider$onDestroy(), 0, this);
        }

        public /* synthetic */ DataServiceProvider() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DataServiceProvider)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeactivateDataReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetupDataReason {
    }
}

