/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.SystemApi;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.VideoProfile;
import android.telephony.ims.ImsStreamMediaProfile;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ImsCallProfile
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ImsCallProfile";
    public static int SERVICE_TYPE_NONE = 0;
    public static int SERVICE_TYPE_NORMAL = 1;
    public static int SERVICE_TYPE_EMERGENCY = 2;
    public static int CALL_TYPE_VOICE_N_VIDEO = 1;
    public static int CALL_TYPE_VOICE = 2;
    public static int CALL_TYPE_VIDEO_N_VOICE = 3;
    public static int CALL_TYPE_VT = 4;
    public static int CALL_TYPE_VT_TX = 5;
    public static int CALL_TYPE_VT_RX = 6;
    public static int CALL_TYPE_VT_NODIR = 7;
    public static int CALL_TYPE_VS = 8;
    public static int CALL_TYPE_VS_TX = 9;
    public static int CALL_TYPE_VS_RX = 10;
    public static String EXTRA_CONFERENCE = "conference";
    public static String EXTRA_E_CALL = "e_call";
    public static String EXTRA_VMS = "vms";
    public static String EXTRA_CALL_MODE_CHANGEABLE = "call_mode_changeable";
    public static String EXTRA_CONFERENCE_AVAIL = "conference_avail";
    public static String EXTRA_OEM_EXTRAS = "OemCallExtras";
    public static String EXTRA_OIR = "oir";
    public static String EXTRA_CNAP = "cnap";
    public static String EXTRA_DIALSTRING = "dialstring";
    public static int OIR_DEFAULT = 0;
    public static int OIR_PRESENTATION_RESTRICTED = 1;
    public static int OIR_PRESENTATION_NOT_RESTRICTED = 2;
    public static int OIR_PRESENTATION_UNKNOWN = 3;
    public static int OIR_PRESENTATION_PAYPHONE = 4;
    public static int DIALSTRING_NORMAL = 0;
    public static int DIALSTRING_SS_CONF = 1;
    public static int DIALSTRING_USSD = 2;
    public static int CALL_RESTRICT_CAUSE_NONE = 0;
    public static int CALL_RESTRICT_CAUSE_RAT = 1;
    public static int CALL_RESTRICT_CAUSE_DISABLED = 2;
    public static int CALL_RESTRICT_CAUSE_HD = 3;
    public static String EXTRA_OI = "oi";
    public static String EXTRA_CNA = "cna";
    public static String EXTRA_USSD = "ussd";
    public static String EXTRA_REMOTE_URI = "remote_uri";
    public static String EXTRA_CHILD_NUMBER = "ChildNum";
    public static String EXTRA_CODEC = "Codec";
    public static String EXTRA_DISPLAY_TEXT = "DisplayText";
    public static String EXTRA_ADDITIONAL_CALL_INFO = "AdditionalCallInfo";
    public static String EXTRA_IS_CALL_PULL = "CallPull";
    public static String EXTRA_CALL_RAT_TYPE = "CallRadioTech";
    public static String EXTRA_CALL_RAT_TYPE_ALT = "callRadioTech";
    public int mServiceType;
    public int mCallType;
    public int mRestrictCause;
    public Bundle mCallExtras;
    public ImsStreamMediaProfile mMediaProfile;
    public static Parcelable.Creator<ImsCallProfile> CREATOR;

    private void $$robo$$android_telephony_ims_ImsCallProfile$__constructor__(Parcel in) {
        this.mRestrictCause = 0;
        this.readFromParcel(in);
    }

    private void $$robo$$android_telephony_ims_ImsCallProfile$__constructor__() {
        this.mRestrictCause = 0;
        this.mServiceType = 1;
        this.mCallType = 1;
        this.mCallExtras = new Bundle();
        this.mMediaProfile = new ImsStreamMediaProfile();
    }

    private void $$robo$$android_telephony_ims_ImsCallProfile$__constructor__(int serviceType, int callType) {
        this.mRestrictCause = 0;
        this.mServiceType = serviceType;
        this.mCallType = callType;
        this.mCallExtras = new Bundle();
        this.mMediaProfile = new ImsStreamMediaProfile();
    }

    private void $$robo$$android_telephony_ims_ImsCallProfile$__constructor__(int serviceType, int callType, Bundle callExtras, ImsStreamMediaProfile mediaProfile) {
        this.mRestrictCause = 0;
        this.mServiceType = serviceType;
        this.mCallType = callType;
        this.mCallExtras = callExtras;
        this.mMediaProfile = mediaProfile;
    }

    private final String $$robo$$android_telephony_ims_ImsCallProfile$getCallExtra(String name) {
        return this.getCallExtra(name, "");
    }

    private final String $$robo$$android_telephony_ims_ImsCallProfile$getCallExtra(String name, String defaultValue) {
        if (this.mCallExtras == null) {
            return defaultValue;
        }
        return this.mCallExtras.getString(name, defaultValue);
    }

    private final boolean $$robo$$android_telephony_ims_ImsCallProfile$getCallExtraBoolean(String name) {
        return this.getCallExtraBoolean(name, false);
    }

    private final boolean $$robo$$android_telephony_ims_ImsCallProfile$getCallExtraBoolean(String name, boolean defaultValue) {
        if (this.mCallExtras == null) {
            return defaultValue;
        }
        return this.mCallExtras.getBoolean(name, defaultValue);
    }

    private final int $$robo$$android_telephony_ims_ImsCallProfile$getCallExtraInt(String name) {
        return this.getCallExtraInt(name, -1);
    }

    private final int $$robo$$android_telephony_ims_ImsCallProfile$getCallExtraInt(String name, int defaultValue) {
        if (this.mCallExtras == null) {
            return defaultValue;
        }
        return this.mCallExtras.getInt(name, defaultValue);
    }

    private final void $$robo$$android_telephony_ims_ImsCallProfile$setCallExtra(String name, String value) {
        if (this.mCallExtras != null) {
            this.mCallExtras.putString(name, value);
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallProfile$setCallExtraBoolean(String name, boolean value) {
        if (this.mCallExtras != null) {
            this.mCallExtras.putBoolean(name, value);
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallProfile$setCallExtraInt(String name, int value) {
        if (this.mCallExtras != null) {
            this.mCallExtras.putInt(name, value);
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallProfile$updateCallType(ImsCallProfile profile) {
        this.mCallType = profile.mCallType;
    }

    private final void $$robo$$android_telephony_ims_ImsCallProfile$updateCallExtras(ImsCallProfile profile) {
        this.mCallExtras.clear();
        this.mCallExtras = (Bundle)profile.mCallExtras.clone();
    }

    private final void $$robo$$android_telephony_ims_ImsCallProfile$updateMediaProfile(ImsCallProfile profile) {
        this.mMediaProfile = profile.mMediaProfile;
    }

    private final String $$robo$$android_telephony_ims_ImsCallProfile$toString() {
        return "{ serviceType=" + this.mServiceType + ", callType=" + this.mCallType + ", restrictCause=" + this.mRestrictCause + ", mediaProfile=" + this.mMediaProfile.toString() + " }";
    }

    private final int $$robo$$android_telephony_ims_ImsCallProfile$describeContents() {
        return 0;
    }

    private final void $$robo$$android_telephony_ims_ImsCallProfile$writeToParcel(Parcel out, int flags) {
        Bundle filteredExtras = this.maybeCleanseExtras(this.mCallExtras);
        out.writeInt(this.mServiceType);
        out.writeInt(this.mCallType);
        out.writeBundle(filteredExtras);
        out.writeParcelable(this.mMediaProfile, 0);
    }

    private final void $$robo$$android_telephony_ims_ImsCallProfile$readFromParcel(Parcel in) {
        this.mServiceType = in.readInt();
        this.mCallType = in.readInt();
        this.mCallExtras = in.readBundle();
        this.mMediaProfile = (ImsStreamMediaProfile)in.readParcelable(ImsStreamMediaProfile.class.getClassLoader());
    }

    private final int $$robo$$android_telephony_ims_ImsCallProfile$getServiceType() {
        return this.mServiceType;
    }

    private final int $$robo$$android_telephony_ims_ImsCallProfile$getCallType() {
        return this.mCallType;
    }

    private final int $$robo$$android_telephony_ims_ImsCallProfile$getRestrictCause() {
        return this.mRestrictCause;
    }

    private final Bundle $$robo$$android_telephony_ims_ImsCallProfile$getCallExtras() {
        return this.mCallExtras;
    }

    private final ImsStreamMediaProfile $$robo$$android_telephony_ims_ImsCallProfile$getMediaProfile() {
        return this.mMediaProfile;
    }

    private static final int $$robo$$android_telephony_ims_ImsCallProfile$getVideoStateFromImsCallProfile(ImsCallProfile callProfile) {
        int videostate = ImsCallProfile.getVideoStateFromCallType(callProfile.mCallType);
        videostate = callProfile.isVideoPaused() && !VideoProfile.isAudioOnly(videostate) ? (videostate |= 4) : (videostate &= 0xFFFFFFFB);
        return videostate;
    }

    private static final int $$robo$$android_telephony_ims_ImsCallProfile$getVideoStateFromCallType(int callType) {
        int videostate = 0;
        switch (callType) {
            case 5: {
                videostate = 1;
                break;
            }
            case 6: {
                videostate = 2;
                break;
            }
            case 4: {
                videostate = 3;
                break;
            }
            case 2: {
                videostate = 0;
                break;
            }
            default: {
                videostate = 0;
            }
        }
        return videostate;
    }

    private static final int $$robo$$android_telephony_ims_ImsCallProfile$getCallTypeFromVideoState(int videoState) {
        boolean videoTx = ImsCallProfile.isVideoStateSet(videoState, 1);
        boolean videoRx = ImsCallProfile.isVideoStateSet(videoState, 2);
        boolean isPaused = ImsCallProfile.isVideoStateSet(videoState, 4);
        if (isPaused) {
            return 7;
        }
        if (videoTx && !videoRx) {
            return 5;
        }
        if (!videoTx && videoRx) {
            return 6;
        }
        if (videoTx && videoRx) {
            return 4;
        }
        return 2;
    }

    private static final int $$robo$$android_telephony_ims_ImsCallProfile$presentationToOIR(int presentation) {
        switch (presentation) {
            case 2: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    private static final int $$robo$$android_telephony_ims_ImsCallProfile$presentationToOir(int presentation) {
        return ImsCallProfile.presentationToOIR(presentation);
    }

    private static final int $$robo$$android_telephony_ims_ImsCallProfile$OIRToPresentation(int oir) {
        switch (oir) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 3: {
                return 3;
            }
        }
        return 3;
    }

    private final boolean $$robo$$android_telephony_ims_ImsCallProfile$isVideoPaused() {
        return this.mMediaProfile.mVideoDirection == 0;
    }

    private final boolean $$robo$$android_telephony_ims_ImsCallProfile$isVideoCall() {
        return VideoProfile.isVideo(ImsCallProfile.getVideoStateFromCallType(this.mCallType));
    }

    private final Bundle $$robo$$android_telephony_ims_ImsCallProfile$maybeCleanseExtras(Bundle extras) {
        Bundle filtered;
        int endSize;
        if (extras == null) {
            return null;
        }
        int startSize = extras.size();
        if (startSize != (endSize = (filtered = extras.filterValues()).size())) {
            Log.i("ImsCallProfile", "maybeCleanseExtras: " + (startSize - endSize) + " extra values were removed - only primitive types and system parcelables are permitted.");
        }
        return filtered;
    }

    private static final boolean $$robo$$android_telephony_ims_ImsCallProfile$isVideoStateSet(int videoState, int videoStateToCheck) {
        return (videoState & videoStateToCheck) == videoStateToCheck;
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<ImsCallProfile>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_telephony_ims_ImsCallProfile_1$__constructor__() {
            }

            private final ImsCallProfile $$robo$$android_telephony_ims_ImsCallProfile_1$createFromParcel(Parcel in) {
                return new ImsCallProfile(in);
            }

            private final ImsCallProfile[] $$robo$$android_telephony_ims_ImsCallProfile_1$newArray(int size) {
                return new ImsCallProfile[size];
            }

            private void __constructor__() {
                this.$$robo$$android_telephony_ims_ImsCallProfile_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ims_ImsCallProfile_1$__constructor__(), 0, this);
            }

            @Override
            public ImsCallProfile createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_telephony_ims_ImsCallProfile_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public ImsCallProfile[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_telephony_ims_ImsCallProfile_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_telephony_ims_ImsCallProfile$__constructor__(parcel);
    }

    public ImsCallProfile(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ims_ImsCallProfile$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    private void __constructor__() {
        this.$$robo$$android_telephony_ims_ImsCallProfile$__constructor__();
    }

    public ImsCallProfile() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ims_ImsCallProfile$__constructor__(), 0, this);
    }

    private void __constructor__(int n, int n2) {
        this.$$robo$$android_telephony_ims_ImsCallProfile$__constructor__(n, n2);
    }

    public ImsCallProfile(int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ims_ImsCallProfile$__constructor__(int int ), 0, this, n, n2);
    }

    private void __constructor__(int n, int n2, Bundle bundle, ImsStreamMediaProfile imsStreamMediaProfile) {
        this.$$robo$$android_telephony_ims_ImsCallProfile$__constructor__(n, n2, bundle, imsStreamMediaProfile);
    }

    public ImsCallProfile(int n, int n2, Bundle bundle, ImsStreamMediaProfile imsStreamMediaProfile) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ims_ImsCallProfile$__constructor__(int int android.os.Bundle android.telephony.ims.ImsStreamMediaProfile ), 0, this, n, n2, bundle, imsStreamMediaProfile);
    }

    public String getCallExtra(String string2) {
        return InvokeDynamicSupport.bootstrap("getCallExtra", $$robo$$android_telephony_ims_ImsCallProfile$getCallExtra(java.lang.String ), 0, this, string2);
    }

    public String getCallExtra(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getCallExtra", $$robo$$android_telephony_ims_ImsCallProfile$getCallExtra(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public boolean getCallExtraBoolean(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("getCallExtraBoolean", $$robo$$android_telephony_ims_ImsCallProfile$getCallExtraBoolean(java.lang.String ), 0, this, string2);
    }

    public boolean getCallExtraBoolean(String string2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("getCallExtraBoolean", $$robo$$android_telephony_ims_ImsCallProfile$getCallExtraBoolean(java.lang.String boolean ), 0, this, string2, bl);
    }

    public int getCallExtraInt(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getCallExtraInt", $$robo$$android_telephony_ims_ImsCallProfile$getCallExtraInt(java.lang.String ), 0, this, string2);
    }

    public int getCallExtraInt(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCallExtraInt", $$robo$$android_telephony_ims_ImsCallProfile$getCallExtraInt(java.lang.String int ), 0, this, string2, n);
    }

    public void setCallExtra(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setCallExtra", $$robo$$android_telephony_ims_ImsCallProfile$setCallExtra(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void setCallExtraBoolean(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setCallExtraBoolean", $$robo$$android_telephony_ims_ImsCallProfile$setCallExtraBoolean(java.lang.String boolean ), 0, this, string2, bl);
    }

    public void setCallExtraInt(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setCallExtraInt", $$robo$$android_telephony_ims_ImsCallProfile$setCallExtraInt(java.lang.String int ), 0, this, string2, n);
    }

    public void updateCallType(ImsCallProfile imsCallProfile) {
        InvokeDynamicSupport.bootstrap("updateCallType", $$robo$$android_telephony_ims_ImsCallProfile$updateCallType(android.telephony.ims.ImsCallProfile ), 0, this, imsCallProfile);
    }

    public void updateCallExtras(ImsCallProfile imsCallProfile) {
        InvokeDynamicSupport.bootstrap("updateCallExtras", $$robo$$android_telephony_ims_ImsCallProfile$updateCallExtras(android.telephony.ims.ImsCallProfile ), 0, this, imsCallProfile);
    }

    public void updateMediaProfile(ImsCallProfile imsCallProfile) {
        InvokeDynamicSupport.bootstrap("updateMediaProfile", $$robo$$android_telephony_ims_ImsCallProfile$updateMediaProfile(android.telephony.ims.ImsCallProfile ), 0, this, imsCallProfile);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telephony_ims_ImsCallProfile$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_telephony_ims_ImsCallProfile$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_telephony_ims_ImsCallProfile$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private void readFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_telephony_ims_ImsCallProfile$readFromParcel(android.os.Parcel ), 0, this, parcel);
    }

    public int getServiceType() {
        return (int)InvokeDynamicSupport.bootstrap("getServiceType", $$robo$$android_telephony_ims_ImsCallProfile$getServiceType(), 0, this);
    }

    public int getCallType() {
        return (int)InvokeDynamicSupport.bootstrap("getCallType", $$robo$$android_telephony_ims_ImsCallProfile$getCallType(), 0, this);
    }

    public int getRestrictCause() {
        return (int)InvokeDynamicSupport.bootstrap("getRestrictCause", $$robo$$android_telephony_ims_ImsCallProfile$getRestrictCause(), 0, this);
    }

    public Bundle getCallExtras() {
        return InvokeDynamicSupport.bootstrap("getCallExtras", $$robo$$android_telephony_ims_ImsCallProfile$getCallExtras(), 0, this);
    }

    public ImsStreamMediaProfile getMediaProfile() {
        return InvokeDynamicSupport.bootstrap("getMediaProfile", $$robo$$android_telephony_ims_ImsCallProfile$getMediaProfile(), 0, this);
    }

    public static int getVideoStateFromImsCallProfile(ImsCallProfile imsCallProfile) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getVideoStateFromImsCallProfile", $$robo$$android_telephony_ims_ImsCallProfile$getVideoStateFromImsCallProfile(android.telephony.ims.ImsCallProfile ), 0, (ImsCallProfile)imsCallProfile);
    }

    public static int getVideoStateFromCallType(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getVideoStateFromCallType", $$robo$$android_telephony_ims_ImsCallProfile$getVideoStateFromCallType(int ), 0, (int)n);
    }

    public static int getCallTypeFromVideoState(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCallTypeFromVideoState", $$robo$$android_telephony_ims_ImsCallProfile$getCallTypeFromVideoState(int ), 0, (int)n);
    }

    public static int presentationToOIR(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("presentationToOIR", $$robo$$android_telephony_ims_ImsCallProfile$presentationToOIR(int ), 0, (int)n);
    }

    public static int presentationToOir(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("presentationToOir", $$robo$$android_telephony_ims_ImsCallProfile$presentationToOir(int ), 0, (int)n);
    }

    public static int OIRToPresentation(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("OIRToPresentation", $$robo$$android_telephony_ims_ImsCallProfile$OIRToPresentation(int ), 0, (int)n);
    }

    public boolean isVideoPaused() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVideoPaused", $$robo$$android_telephony_ims_ImsCallProfile$isVideoPaused(), 0, this);
    }

    public boolean isVideoCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVideoCall", $$robo$$android_telephony_ims_ImsCallProfile$isVideoCall(), 0, this);
    }

    private Bundle maybeCleanseExtras(Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("maybeCleanseExtras", $$robo$$android_telephony_ims_ImsCallProfile$maybeCleanseExtras(android.os.Bundle ), 0, this, bundle);
    }

    private static boolean isVideoStateSet(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isVideoStateSet", $$robo$$android_telephony_ims_ImsCallProfile$isVideoStateSet(int int ), 0, (int)n, (int)n2);
    }

    static {
        RobolectricInternals.classInitializing(ImsCallProfile.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsCallProfile)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

