/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.os.Message;
import android.os.RemoteException;
import android.telephony.ims.ImsCallProfile;
import android.telephony.ims.ImsConferenceState;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.ImsStreamMediaProfile;
import android.telephony.ims.ImsSuppServiceNotification;
import android.telephony.ims.aidl.IImsCallSessionListener;
import android.util.Log;
import com.android.ims.internal.IImsCallSession;
import com.android.ims.internal.IImsVideoCallProvider;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImsCallSession
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ImsCallSession";
    private IImsCallSession miSession;
    private boolean mClosed;
    private Listener mListener;

    private void $$robo$$android_telephony_ims_ImsCallSession$__constructor__(IImsCallSession iSession) {
        this.mClosed = false;
        this.miSession = iSession;
        if (iSession != null) {
            try {
                iSession.setListener(new IImsCallSessionListenerProxy(this));
            }
            catch (RemoteException remoteException) {}
        } else {
            this.mClosed = true;
        }
    }

    private void $$robo$$android_telephony_ims_ImsCallSession$__constructor__(IImsCallSession iSession, Listener listener) {
        this.setListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telephony_ims_ImsCallSession$close() {
        ImsCallSession imsCallSession = this;
        synchronized (imsCallSession) {
            if (this.mClosed) {
                return;
            }
            try {
                this.miSession.close();
                this.mClosed = true;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private final String $$robo$$android_telephony_ims_ImsCallSession$getCallId() {
        if (this.mClosed) {
            return null;
        }
        try {
            return this.miSession.getCallId();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final ImsCallProfile $$robo$$android_telephony_ims_ImsCallSession$getCallProfile() {
        if (this.mClosed) {
            return null;
        }
        try {
            return this.miSession.getCallProfile();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final ImsCallProfile $$robo$$android_telephony_ims_ImsCallSession$getLocalCallProfile() {
        if (this.mClosed) {
            return null;
        }
        try {
            return this.miSession.getLocalCallProfile();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final ImsCallProfile $$robo$$android_telephony_ims_ImsCallSession$getRemoteCallProfile() {
        if (this.mClosed) {
            return null;
        }
        try {
            return this.miSession.getRemoteCallProfile();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final IImsVideoCallProvider $$robo$$android_telephony_ims_ImsCallSession$getVideoCallProvider() {
        if (this.mClosed) {
            return null;
        }
        try {
            return this.miSession.getVideoCallProvider();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_ims_ImsCallSession$getProperty(String name) {
        if (this.mClosed) {
            return null;
        }
        try {
            return this.miSession.getProperty(name);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final int $$robo$$android_telephony_ims_ImsCallSession$getState() {
        if (this.mClosed) {
            return -1;
        }
        try {
            return this.miSession.getState();
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    private final boolean $$robo$$android_telephony_ims_ImsCallSession$isAlive() {
        if (this.mClosed) {
            return false;
        }
        int state = this.getState();
        switch (state) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    private final IImsCallSession $$robo$$android_telephony_ims_ImsCallSession$getSession() {
        return this.miSession;
    }

    private final boolean $$robo$$android_telephony_ims_ImsCallSession$isInCall() {
        if (this.mClosed) {
            return false;
        }
        try {
            return this.miSession.isInCall();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallSession$setListener(Listener listener) {
        this.mListener = listener;
    }

    private final void $$robo$$android_telephony_ims_ImsCallSession$setMute(boolean muted) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.setMute(muted);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallSession$start(String callee, ImsCallProfile profile) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.start(callee, profile);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallSession$start(String[] participants, ImsCallProfile profile) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.startConference(participants, profile);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallSession$accept(int callType, ImsStreamMediaProfile profile) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.accept(callType, profile);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallSession$deflect(String number) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.deflect(number);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallSession$reject(int reason) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.reject(reason);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallSession$terminate(int reason) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.terminate(reason);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallSession$hold(ImsStreamMediaProfile profile) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.hold(profile);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallSession$resume(ImsStreamMediaProfile profile) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.resume(profile);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallSession$merge() {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.merge();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallSession$update(int callType, ImsStreamMediaProfile profile) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.update(callType, profile);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallSession$extendToConference(String[] participants) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.extendToConference(participants);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallSession$inviteParticipants(String[] participants) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.inviteParticipants(participants);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallSession$removeParticipants(String[] participants) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.removeParticipants(participants);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallSession$sendDtmf(char c, Message result) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.sendDtmf(c, result);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallSession$startDtmf(char c) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.startDtmf(c);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallSession$stopDtmf() {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.stopDtmf();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallSession$sendUssd(String ussdMessage) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.sendUssd(ussdMessage);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final boolean $$robo$$android_telephony_ims_ImsCallSession$isMultiparty() {
        if (this.mClosed) {
            return false;
        }
        try {
            return this.miSession.isMultiparty();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallSession$sendRttMessage(String rttMessage) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.sendRttMessage(rttMessage);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallSession$sendRttModifyRequest(ImsCallProfile to) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.sendRttModifyRequest(to);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_ims_ImsCallSession$sendRttModifyResponse(boolean response) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.sendRttModifyResponse(response);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final String $$robo$$android_telephony_ims_ImsCallSession$toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ImsCallSession objId:");
        sb.append(System.identityHashCode(this));
        sb.append(" state:");
        sb.append(State.toString(this.getState()));
        sb.append(" callId:");
        sb.append(this.getCallId());
        sb.append("]");
        return sb.toString();
    }

    private void __constructor__(IImsCallSession iImsCallSession) {
        this.$$robo$$android_telephony_ims_ImsCallSession$__constructor__(iImsCallSession);
    }

    public ImsCallSession(IImsCallSession iImsCallSession) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ims_ImsCallSession$__constructor__(com.android.ims.internal.IImsCallSession ), 0, this, iImsCallSession);
    }

    private void __constructor__(IImsCallSession iImsCallSession, Listener listener) {
        this.$$robo$$android_telephony_ims_ImsCallSession$__constructor__(iImsCallSession, listener);
    }

    public ImsCallSession(IImsCallSession iImsCallSession, Listener listener) {
        this(iImsCallSession);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ims_ImsCallSession$__constructor__(com.android.ims.internal.IImsCallSession android.telephony.ims.ImsCallSession$Listener ), 0, this, iImsCallSession, listener);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_telephony_ims_ImsCallSession$close(), 0, this);
    }

    public String getCallId() {
        return InvokeDynamicSupport.bootstrap("getCallId", $$robo$$android_telephony_ims_ImsCallSession$getCallId(), 0, this);
    }

    public ImsCallProfile getCallProfile() {
        return InvokeDynamicSupport.bootstrap("getCallProfile", $$robo$$android_telephony_ims_ImsCallSession$getCallProfile(), 0, this);
    }

    public ImsCallProfile getLocalCallProfile() {
        return InvokeDynamicSupport.bootstrap("getLocalCallProfile", $$robo$$android_telephony_ims_ImsCallSession$getLocalCallProfile(), 0, this);
    }

    public ImsCallProfile getRemoteCallProfile() {
        return InvokeDynamicSupport.bootstrap("getRemoteCallProfile", $$robo$$android_telephony_ims_ImsCallSession$getRemoteCallProfile(), 0, this);
    }

    public IImsVideoCallProvider getVideoCallProvider() {
        return InvokeDynamicSupport.bootstrap("getVideoCallProvider", $$robo$$android_telephony_ims_ImsCallSession$getVideoCallProvider(), 0, this);
    }

    public String getProperty(String string2) {
        return InvokeDynamicSupport.bootstrap("getProperty", $$robo$$android_telephony_ims_ImsCallSession$getProperty(java.lang.String ), 0, this, string2);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_telephony_ims_ImsCallSession$getState(), 0, this);
    }

    public boolean isAlive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAlive", $$robo$$android_telephony_ims_ImsCallSession$isAlive(), 0, this);
    }

    public IImsCallSession getSession() {
        return InvokeDynamicSupport.bootstrap("getSession", $$robo$$android_telephony_ims_ImsCallSession$getSession(), 0, this);
    }

    public boolean isInCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInCall", $$robo$$android_telephony_ims_ImsCallSession$isInCall(), 0, this);
    }

    public void setListener(Listener listener) {
        InvokeDynamicSupport.bootstrap("setListener", $$robo$$android_telephony_ims_ImsCallSession$setListener(android.telephony.ims.ImsCallSession$Listener ), 0, this, listener);
    }

    public void setMute(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMute", $$robo$$android_telephony_ims_ImsCallSession$setMute(boolean ), 0, this, bl);
    }

    public void start(String string2, ImsCallProfile imsCallProfile) {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_telephony_ims_ImsCallSession$start(java.lang.String android.telephony.ims.ImsCallProfile ), 0, this, string2, imsCallProfile);
    }

    public void start(String[] stringArray, ImsCallProfile imsCallProfile) {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_telephony_ims_ImsCallSession$start(java.lang.String[] android.telephony.ims.ImsCallProfile ), 0, this, stringArray, imsCallProfile);
    }

    public void accept(int n, ImsStreamMediaProfile imsStreamMediaProfile) {
        InvokeDynamicSupport.bootstrap("accept", $$robo$$android_telephony_ims_ImsCallSession$accept(int android.telephony.ims.ImsStreamMediaProfile ), 0, this, n, imsStreamMediaProfile);
    }

    public void deflect(String string2) {
        InvokeDynamicSupport.bootstrap("deflect", $$robo$$android_telephony_ims_ImsCallSession$deflect(java.lang.String ), 0, this, string2);
    }

    public void reject(int n) {
        InvokeDynamicSupport.bootstrap("reject", $$robo$$android_telephony_ims_ImsCallSession$reject(int ), 0, this, n);
    }

    public void terminate(int n) {
        InvokeDynamicSupport.bootstrap("terminate", $$robo$$android_telephony_ims_ImsCallSession$terminate(int ), 0, this, n);
    }

    public void hold(ImsStreamMediaProfile imsStreamMediaProfile) {
        InvokeDynamicSupport.bootstrap("hold", $$robo$$android_telephony_ims_ImsCallSession$hold(android.telephony.ims.ImsStreamMediaProfile ), 0, this, imsStreamMediaProfile);
    }

    public void resume(ImsStreamMediaProfile imsStreamMediaProfile) {
        InvokeDynamicSupport.bootstrap("resume", $$robo$$android_telephony_ims_ImsCallSession$resume(android.telephony.ims.ImsStreamMediaProfile ), 0, this, imsStreamMediaProfile);
    }

    public void merge() {
        InvokeDynamicSupport.bootstrap("merge", $$robo$$android_telephony_ims_ImsCallSession$merge(), 0, this);
    }

    public void update(int n, ImsStreamMediaProfile imsStreamMediaProfile) {
        InvokeDynamicSupport.bootstrap("update", $$robo$$android_telephony_ims_ImsCallSession$update(int android.telephony.ims.ImsStreamMediaProfile ), 0, this, n, imsStreamMediaProfile);
    }

    public void extendToConference(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("extendToConference", $$robo$$android_telephony_ims_ImsCallSession$extendToConference(java.lang.String[] ), 0, this, stringArray);
    }

    public void inviteParticipants(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("inviteParticipants", $$robo$$android_telephony_ims_ImsCallSession$inviteParticipants(java.lang.String[] ), 0, this, stringArray);
    }

    public void removeParticipants(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("removeParticipants", $$robo$$android_telephony_ims_ImsCallSession$removeParticipants(java.lang.String[] ), 0, this, stringArray);
    }

    public void sendDtmf(char c, Message message) {
        InvokeDynamicSupport.bootstrap("sendDtmf", $$robo$$android_telephony_ims_ImsCallSession$sendDtmf(char android.os.Message ), 0, this, c, message);
    }

    public void startDtmf(char c) {
        InvokeDynamicSupport.bootstrap("startDtmf", $$robo$$android_telephony_ims_ImsCallSession$startDtmf(char ), 0, this, c);
    }

    public void stopDtmf() {
        InvokeDynamicSupport.bootstrap("stopDtmf", $$robo$$android_telephony_ims_ImsCallSession$stopDtmf(), 0, this);
    }

    public void sendUssd(String string2) {
        InvokeDynamicSupport.bootstrap("sendUssd", $$robo$$android_telephony_ims_ImsCallSession$sendUssd(java.lang.String ), 0, this, string2);
    }

    public boolean isMultiparty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMultiparty", $$robo$$android_telephony_ims_ImsCallSession$isMultiparty(), 0, this);
    }

    public void sendRttMessage(String string2) {
        InvokeDynamicSupport.bootstrap("sendRttMessage", $$robo$$android_telephony_ims_ImsCallSession$sendRttMessage(java.lang.String ), 0, this, string2);
    }

    public void sendRttModifyRequest(ImsCallProfile imsCallProfile) {
        InvokeDynamicSupport.bootstrap("sendRttModifyRequest", $$robo$$android_telephony_ims_ImsCallSession$sendRttModifyRequest(android.telephony.ims.ImsCallProfile ), 0, this, imsCallProfile);
    }

    public void sendRttModifyResponse(boolean bl) {
        InvokeDynamicSupport.bootstrap("sendRttModifyResponse", $$robo$$android_telephony_ims_ImsCallSession$sendRttModifyResponse(boolean ), 0, this, bl);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telephony_ims_ImsCallSession$toString(), 0, this);
    }

    public /* synthetic */ ImsCallSession() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsCallSession)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class IImsCallSessionListenerProxy
    extends IImsCallSessionListener.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ImsCallSession this$0;

        private void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$__constructor__(ImsCallSession imsCallSession) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionProgressing(ImsStreamMediaProfile profile) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionProgressing(this.this$0, profile);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionInitiated(ImsCallProfile profile) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionStarted(this.this$0, profile);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionInitiatedFailed(ImsReasonInfo reasonInfo) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionStartFailed(this.this$0, reasonInfo);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionTerminated(ImsReasonInfo reasonInfo) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionTerminated(this.this$0, reasonInfo);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionHeld(ImsCallProfile profile) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionHeld(this.this$0, profile);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionHoldFailed(ImsReasonInfo reasonInfo) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionHoldFailed(this.this$0, reasonInfo);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionHoldReceived(ImsCallProfile profile) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionHoldReceived(this.this$0, profile);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionResumed(ImsCallProfile profile) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionResumed(this.this$0, profile);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionResumeFailed(ImsReasonInfo reasonInfo) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionResumeFailed(this.this$0, reasonInfo);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionResumeReceived(ImsCallProfile profile) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionResumeReceived(this.this$0, profile);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionMergeStarted(IImsCallSession newSession, ImsCallProfile profile) {
            Log.d("ImsCallSession", "callSessionMergeStarted");
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionMergeComplete(IImsCallSession newSession) {
            if (this.this$0.mListener != null) {
                if (newSession != null) {
                    ImsCallSession validActiveSession = this.this$0;
                    try {
                        if (!Objects.equals(this.this$0.miSession.getCallId(), newSession.getCallId())) {
                            validActiveSession = new ImsCallSession(newSession);
                        }
                    }
                    catch (RemoteException rex) {
                        Log.e("ImsCallSession", "callSessionMergeComplete: exception for getCallId!");
                    }
                    this.this$0.mListener.callSessionMergeComplete(validActiveSession);
                } else {
                    this.this$0.mListener.callSessionMergeComplete(null);
                }
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionMergeFailed(ImsReasonInfo reasonInfo) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionMergeFailed(this.this$0, reasonInfo);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionUpdated(ImsCallProfile profile) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionUpdated(this.this$0, profile);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionUpdateFailed(ImsReasonInfo reasonInfo) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionUpdateFailed(this.this$0, reasonInfo);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionUpdateReceived(ImsCallProfile profile) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionUpdateReceived(this.this$0, profile);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionConferenceExtended(IImsCallSession newSession, ImsCallProfile profile) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionConferenceExtended(this.this$0, new ImsCallSession(newSession), profile);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionConferenceExtendFailed(ImsReasonInfo reasonInfo) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionConferenceExtendFailed(this.this$0, reasonInfo);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionConferenceExtendReceived(IImsCallSession newSession, ImsCallProfile profile) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionConferenceExtendReceived(this.this$0, new ImsCallSession(newSession), profile);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionInviteParticipantsRequestDelivered() {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionInviteParticipantsRequestDelivered(this.this$0);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionInviteParticipantsRequestFailed(ImsReasonInfo reasonInfo) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionInviteParticipantsRequestFailed(this.this$0, reasonInfo);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionRemoveParticipantsRequestDelivered() {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionRemoveParticipantsRequestDelivered(this.this$0);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionRemoveParticipantsRequestFailed(ImsReasonInfo reasonInfo) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionRemoveParticipantsRequestFailed(this.this$0, reasonInfo);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionConferenceStateUpdated(ImsConferenceState state) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionConferenceStateUpdated(this.this$0, state);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionUssdMessageReceived(int mode, String ussdMessage) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionUssdMessageReceived(this.this$0, mode, ussdMessage);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionMayHandover(int srcAccessTech, int targetAccessTech) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionMayHandover(this.this$0, srcAccessTech, targetAccessTech);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionHandover(int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionHandover(this.this$0, srcAccessTech, targetAccessTech, reasonInfo);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionHandoverFailed(int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionHandoverFailed(this.this$0, srcAccessTech, targetAccessTech, reasonInfo);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionTtyModeReceived(int mode) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionTtyModeReceived(this.this$0, mode);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionMultipartyStateChanged(boolean isMultiParty) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionMultipartyStateChanged(this.this$0, isMultiParty);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionSuppServiceReceived(ImsSuppServiceNotification suppServiceInfo) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionSuppServiceReceived(this.this$0, suppServiceInfo);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionRttModifyRequestReceived(ImsCallProfile callProfile) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionRttModifyRequestReceived(this.this$0, callProfile);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionRttModifyResponseReceived(int status) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionRttModifyResponseReceived(status);
            }
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionRttMessageReceived(String rttMessage) {
            if (this.this$0.mListener != null) {
                this.this$0.mListener.callSessionRttMessageReceived(rttMessage);
            }
        }

        private /* synthetic */ void $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$__constructor__(ImsCallSession x0, 1 x1) {
        }

        private void __constructor__(ImsCallSession imsCallSession) {
            this.$$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$__constructor__(imsCallSession);
        }

        private IImsCallSessionListenerProxy(ImsCallSession imsCallSession) {
            this.this$0 = imsCallSession;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$__constructor__(android.telephony.ims.ImsCallSession ), 0, this, imsCallSession);
        }

        @Override
        public void callSessionProgressing(ImsStreamMediaProfile imsStreamMediaProfile) {
            InvokeDynamicSupport.bootstrap("callSessionProgressing", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionProgressing(android.telephony.ims.ImsStreamMediaProfile ), 0, this, imsStreamMediaProfile);
        }

        @Override
        public void callSessionInitiated(ImsCallProfile imsCallProfile) {
            InvokeDynamicSupport.bootstrap("callSessionInitiated", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionInitiated(android.telephony.ims.ImsCallProfile ), 0, this, imsCallProfile);
        }

        @Override
        public void callSessionInitiatedFailed(ImsReasonInfo imsReasonInfo) {
            InvokeDynamicSupport.bootstrap("callSessionInitiatedFailed", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionInitiatedFailed(android.telephony.ims.ImsReasonInfo ), 0, this, imsReasonInfo);
        }

        @Override
        public void callSessionTerminated(ImsReasonInfo imsReasonInfo) {
            InvokeDynamicSupport.bootstrap("callSessionTerminated", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionTerminated(android.telephony.ims.ImsReasonInfo ), 0, this, imsReasonInfo);
        }

        @Override
        public void callSessionHeld(ImsCallProfile imsCallProfile) {
            InvokeDynamicSupport.bootstrap("callSessionHeld", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionHeld(android.telephony.ims.ImsCallProfile ), 0, this, imsCallProfile);
        }

        @Override
        public void callSessionHoldFailed(ImsReasonInfo imsReasonInfo) {
            InvokeDynamicSupport.bootstrap("callSessionHoldFailed", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionHoldFailed(android.telephony.ims.ImsReasonInfo ), 0, this, imsReasonInfo);
        }

        @Override
        public void callSessionHoldReceived(ImsCallProfile imsCallProfile) {
            InvokeDynamicSupport.bootstrap("callSessionHoldReceived", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionHoldReceived(android.telephony.ims.ImsCallProfile ), 0, this, imsCallProfile);
        }

        @Override
        public void callSessionResumed(ImsCallProfile imsCallProfile) {
            InvokeDynamicSupport.bootstrap("callSessionResumed", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionResumed(android.telephony.ims.ImsCallProfile ), 0, this, imsCallProfile);
        }

        @Override
        public void callSessionResumeFailed(ImsReasonInfo imsReasonInfo) {
            InvokeDynamicSupport.bootstrap("callSessionResumeFailed", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionResumeFailed(android.telephony.ims.ImsReasonInfo ), 0, this, imsReasonInfo);
        }

        @Override
        public void callSessionResumeReceived(ImsCallProfile imsCallProfile) {
            InvokeDynamicSupport.bootstrap("callSessionResumeReceived", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionResumeReceived(android.telephony.ims.ImsCallProfile ), 0, this, imsCallProfile);
        }

        @Override
        public void callSessionMergeStarted(IImsCallSession iImsCallSession, ImsCallProfile imsCallProfile) {
            InvokeDynamicSupport.bootstrap("callSessionMergeStarted", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionMergeStarted(com.android.ims.internal.IImsCallSession android.telephony.ims.ImsCallProfile ), 0, this, iImsCallSession, imsCallProfile);
        }

        @Override
        public void callSessionMergeComplete(IImsCallSession iImsCallSession) {
            InvokeDynamicSupport.bootstrap("callSessionMergeComplete", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionMergeComplete(com.android.ims.internal.IImsCallSession ), 0, this, iImsCallSession);
        }

        @Override
        public void callSessionMergeFailed(ImsReasonInfo imsReasonInfo) {
            InvokeDynamicSupport.bootstrap("callSessionMergeFailed", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionMergeFailed(android.telephony.ims.ImsReasonInfo ), 0, this, imsReasonInfo);
        }

        @Override
        public void callSessionUpdated(ImsCallProfile imsCallProfile) {
            InvokeDynamicSupport.bootstrap("callSessionUpdated", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionUpdated(android.telephony.ims.ImsCallProfile ), 0, this, imsCallProfile);
        }

        @Override
        public void callSessionUpdateFailed(ImsReasonInfo imsReasonInfo) {
            InvokeDynamicSupport.bootstrap("callSessionUpdateFailed", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionUpdateFailed(android.telephony.ims.ImsReasonInfo ), 0, this, imsReasonInfo);
        }

        @Override
        public void callSessionUpdateReceived(ImsCallProfile imsCallProfile) {
            InvokeDynamicSupport.bootstrap("callSessionUpdateReceived", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionUpdateReceived(android.telephony.ims.ImsCallProfile ), 0, this, imsCallProfile);
        }

        @Override
        public void callSessionConferenceExtended(IImsCallSession iImsCallSession, ImsCallProfile imsCallProfile) {
            InvokeDynamicSupport.bootstrap("callSessionConferenceExtended", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionConferenceExtended(com.android.ims.internal.IImsCallSession android.telephony.ims.ImsCallProfile ), 0, this, iImsCallSession, imsCallProfile);
        }

        @Override
        public void callSessionConferenceExtendFailed(ImsReasonInfo imsReasonInfo) {
            InvokeDynamicSupport.bootstrap("callSessionConferenceExtendFailed", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionConferenceExtendFailed(android.telephony.ims.ImsReasonInfo ), 0, this, imsReasonInfo);
        }

        @Override
        public void callSessionConferenceExtendReceived(IImsCallSession iImsCallSession, ImsCallProfile imsCallProfile) {
            InvokeDynamicSupport.bootstrap("callSessionConferenceExtendReceived", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionConferenceExtendReceived(com.android.ims.internal.IImsCallSession android.telephony.ims.ImsCallProfile ), 0, this, iImsCallSession, imsCallProfile);
        }

        @Override
        public void callSessionInviteParticipantsRequestDelivered() {
            InvokeDynamicSupport.bootstrap("callSessionInviteParticipantsRequestDelivered", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionInviteParticipantsRequestDelivered(), 0, this);
        }

        @Override
        public void callSessionInviteParticipantsRequestFailed(ImsReasonInfo imsReasonInfo) {
            InvokeDynamicSupport.bootstrap("callSessionInviteParticipantsRequestFailed", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionInviteParticipantsRequestFailed(android.telephony.ims.ImsReasonInfo ), 0, this, imsReasonInfo);
        }

        @Override
        public void callSessionRemoveParticipantsRequestDelivered() {
            InvokeDynamicSupport.bootstrap("callSessionRemoveParticipantsRequestDelivered", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionRemoveParticipantsRequestDelivered(), 0, this);
        }

        @Override
        public void callSessionRemoveParticipantsRequestFailed(ImsReasonInfo imsReasonInfo) {
            InvokeDynamicSupport.bootstrap("callSessionRemoveParticipantsRequestFailed", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionRemoveParticipantsRequestFailed(android.telephony.ims.ImsReasonInfo ), 0, this, imsReasonInfo);
        }

        @Override
        public void callSessionConferenceStateUpdated(ImsConferenceState imsConferenceState) {
            InvokeDynamicSupport.bootstrap("callSessionConferenceStateUpdated", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionConferenceStateUpdated(android.telephony.ims.ImsConferenceState ), 0, this, imsConferenceState);
        }

        @Override
        public void callSessionUssdMessageReceived(int n, String string2) {
            InvokeDynamicSupport.bootstrap("callSessionUssdMessageReceived", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionUssdMessageReceived(int java.lang.String ), 0, this, n, string2);
        }

        @Override
        public void callSessionMayHandover(int n, int n2) {
            InvokeDynamicSupport.bootstrap("callSessionMayHandover", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionMayHandover(int int ), 0, this, n, n2);
        }

        @Override
        public void callSessionHandover(int n, int n2, ImsReasonInfo imsReasonInfo) {
            InvokeDynamicSupport.bootstrap("callSessionHandover", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionHandover(int int android.telephony.ims.ImsReasonInfo ), 0, this, n, n2, imsReasonInfo);
        }

        @Override
        public void callSessionHandoverFailed(int n, int n2, ImsReasonInfo imsReasonInfo) {
            InvokeDynamicSupport.bootstrap("callSessionHandoverFailed", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionHandoverFailed(int int android.telephony.ims.ImsReasonInfo ), 0, this, n, n2, imsReasonInfo);
        }

        @Override
        public void callSessionTtyModeReceived(int n) {
            InvokeDynamicSupport.bootstrap("callSessionTtyModeReceived", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionTtyModeReceived(int ), 0, this, n);
        }

        @Override
        public void callSessionMultipartyStateChanged(boolean bl) {
            InvokeDynamicSupport.bootstrap("callSessionMultipartyStateChanged", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionMultipartyStateChanged(boolean ), 0, this, bl);
        }

        @Override
        public void callSessionSuppServiceReceived(ImsSuppServiceNotification imsSuppServiceNotification) {
            InvokeDynamicSupport.bootstrap("callSessionSuppServiceReceived", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionSuppServiceReceived(android.telephony.ims.ImsSuppServiceNotification ), 0, this, imsSuppServiceNotification);
        }

        @Override
        public void callSessionRttModifyRequestReceived(ImsCallProfile imsCallProfile) {
            InvokeDynamicSupport.bootstrap("callSessionRttModifyRequestReceived", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionRttModifyRequestReceived(android.telephony.ims.ImsCallProfile ), 0, this, imsCallProfile);
        }

        @Override
        public void callSessionRttModifyResponseReceived(int n) {
            InvokeDynamicSupport.bootstrap("callSessionRttModifyResponseReceived", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionRttModifyResponseReceived(int ), 0, this, n);
        }

        @Override
        public void callSessionRttMessageReceived(String string2) {
            InvokeDynamicSupport.bootstrap("callSessionRttMessageReceived", $$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$callSessionRttMessageReceived(java.lang.String ), 0, this, string2);
        }

        private /* synthetic */ void __constructor__(ImsCallSession imsCallSession, 1 var2_2) {
            this.$$robo$$android_telephony_ims_ImsCallSession_IImsCallSessionListenerProxy$__constructor__(imsCallSession, var2_2);
        }

        public /* synthetic */ IImsCallSessionListenerProxy() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IImsCallSessionListenerProxy)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Listener
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_telephony_ims_ImsCallSession_Listener$__constructor__() {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionProgressing(ImsCallSession session, ImsStreamMediaProfile profile) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionStarted(ImsCallSession session, ImsCallProfile profile) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionStartFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionTerminated(ImsCallSession session, ImsReasonInfo reasonInfo) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionHeld(ImsCallSession session, ImsCallProfile profile) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionHoldFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionHoldReceived(ImsCallSession session, ImsCallProfile profile) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionResumed(ImsCallSession session, ImsCallProfile profile) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionResumeFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionResumeReceived(ImsCallSession session, ImsCallProfile profile) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionMergeStarted(ImsCallSession session, ImsCallSession newSession, ImsCallProfile profile) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionMergeComplete(ImsCallSession session) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionMergeFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionUpdated(ImsCallSession session, ImsCallProfile profile) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionUpdateFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionUpdateReceived(ImsCallSession session, ImsCallProfile profile) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionConferenceExtended(ImsCallSession session, ImsCallSession newSession, ImsCallProfile profile) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionConferenceExtendFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionConferenceExtendReceived(ImsCallSession session, ImsCallSession newSession, ImsCallProfile profile) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionInviteParticipantsRequestDelivered(ImsCallSession session) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionInviteParticipantsRequestFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionRemoveParticipantsRequestDelivered(ImsCallSession session) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionRemoveParticipantsRequestFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionConferenceStateUpdated(ImsCallSession session, ImsConferenceState state) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionUssdMessageReceived(ImsCallSession session, int mode, String ussdMessage) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionMayHandover(ImsCallSession session, int srcAccessTech, int targetAccessTech) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionHandover(ImsCallSession session, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionHandoverFailed(ImsCallSession session, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionTtyModeReceived(ImsCallSession session, int mode) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionMultipartyStateChanged(ImsCallSession session, boolean isMultiParty) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionSuppServiceReceived(ImsCallSession session, ImsSuppServiceNotification suppServiceInfo) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionRttModifyRequestReceived(ImsCallSession session, ImsCallProfile callProfile) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionRttModifyResponseReceived(int status) {
        }

        private final void $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionRttMessageReceived(String rttMessage) {
        }

        private void __constructor__() {
            this.$$robo$$android_telephony_ims_ImsCallSession_Listener$__constructor__();
        }

        public Listener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ims_ImsCallSession_Listener$__constructor__(), 0, this);
        }

        public void callSessionProgressing(ImsCallSession imsCallSession, ImsStreamMediaProfile imsStreamMediaProfile) {
            InvokeDynamicSupport.bootstrap("callSessionProgressing", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionProgressing(android.telephony.ims.ImsCallSession android.telephony.ims.ImsStreamMediaProfile ), 0, this, imsCallSession, imsStreamMediaProfile);
        }

        public void callSessionStarted(ImsCallSession imsCallSession, ImsCallProfile imsCallProfile) {
            InvokeDynamicSupport.bootstrap("callSessionStarted", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionStarted(android.telephony.ims.ImsCallSession android.telephony.ims.ImsCallProfile ), 0, this, imsCallSession, imsCallProfile);
        }

        public void callSessionStartFailed(ImsCallSession imsCallSession, ImsReasonInfo imsReasonInfo) {
            InvokeDynamicSupport.bootstrap("callSessionStartFailed", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionStartFailed(android.telephony.ims.ImsCallSession android.telephony.ims.ImsReasonInfo ), 0, this, imsCallSession, imsReasonInfo);
        }

        public void callSessionTerminated(ImsCallSession imsCallSession, ImsReasonInfo imsReasonInfo) {
            InvokeDynamicSupport.bootstrap("callSessionTerminated", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionTerminated(android.telephony.ims.ImsCallSession android.telephony.ims.ImsReasonInfo ), 0, this, imsCallSession, imsReasonInfo);
        }

        public void callSessionHeld(ImsCallSession imsCallSession, ImsCallProfile imsCallProfile) {
            InvokeDynamicSupport.bootstrap("callSessionHeld", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionHeld(android.telephony.ims.ImsCallSession android.telephony.ims.ImsCallProfile ), 0, this, imsCallSession, imsCallProfile);
        }

        public void callSessionHoldFailed(ImsCallSession imsCallSession, ImsReasonInfo imsReasonInfo) {
            InvokeDynamicSupport.bootstrap("callSessionHoldFailed", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionHoldFailed(android.telephony.ims.ImsCallSession android.telephony.ims.ImsReasonInfo ), 0, this, imsCallSession, imsReasonInfo);
        }

        public void callSessionHoldReceived(ImsCallSession imsCallSession, ImsCallProfile imsCallProfile) {
            InvokeDynamicSupport.bootstrap("callSessionHoldReceived", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionHoldReceived(android.telephony.ims.ImsCallSession android.telephony.ims.ImsCallProfile ), 0, this, imsCallSession, imsCallProfile);
        }

        public void callSessionResumed(ImsCallSession imsCallSession, ImsCallProfile imsCallProfile) {
            InvokeDynamicSupport.bootstrap("callSessionResumed", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionResumed(android.telephony.ims.ImsCallSession android.telephony.ims.ImsCallProfile ), 0, this, imsCallSession, imsCallProfile);
        }

        public void callSessionResumeFailed(ImsCallSession imsCallSession, ImsReasonInfo imsReasonInfo) {
            InvokeDynamicSupport.bootstrap("callSessionResumeFailed", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionResumeFailed(android.telephony.ims.ImsCallSession android.telephony.ims.ImsReasonInfo ), 0, this, imsCallSession, imsReasonInfo);
        }

        public void callSessionResumeReceived(ImsCallSession imsCallSession, ImsCallProfile imsCallProfile) {
            InvokeDynamicSupport.bootstrap("callSessionResumeReceived", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionResumeReceived(android.telephony.ims.ImsCallSession android.telephony.ims.ImsCallProfile ), 0, this, imsCallSession, imsCallProfile);
        }

        public void callSessionMergeStarted(ImsCallSession imsCallSession, ImsCallSession imsCallSession2, ImsCallProfile imsCallProfile) {
            InvokeDynamicSupport.bootstrap("callSessionMergeStarted", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionMergeStarted(android.telephony.ims.ImsCallSession android.telephony.ims.ImsCallSession android.telephony.ims.ImsCallProfile ), 0, this, imsCallSession, imsCallSession2, imsCallProfile);
        }

        public void callSessionMergeComplete(ImsCallSession imsCallSession) {
            InvokeDynamicSupport.bootstrap("callSessionMergeComplete", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionMergeComplete(android.telephony.ims.ImsCallSession ), 0, this, imsCallSession);
        }

        public void callSessionMergeFailed(ImsCallSession imsCallSession, ImsReasonInfo imsReasonInfo) {
            InvokeDynamicSupport.bootstrap("callSessionMergeFailed", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionMergeFailed(android.telephony.ims.ImsCallSession android.telephony.ims.ImsReasonInfo ), 0, this, imsCallSession, imsReasonInfo);
        }

        public void callSessionUpdated(ImsCallSession imsCallSession, ImsCallProfile imsCallProfile) {
            InvokeDynamicSupport.bootstrap("callSessionUpdated", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionUpdated(android.telephony.ims.ImsCallSession android.telephony.ims.ImsCallProfile ), 0, this, imsCallSession, imsCallProfile);
        }

        public void callSessionUpdateFailed(ImsCallSession imsCallSession, ImsReasonInfo imsReasonInfo) {
            InvokeDynamicSupport.bootstrap("callSessionUpdateFailed", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionUpdateFailed(android.telephony.ims.ImsCallSession android.telephony.ims.ImsReasonInfo ), 0, this, imsCallSession, imsReasonInfo);
        }

        public void callSessionUpdateReceived(ImsCallSession imsCallSession, ImsCallProfile imsCallProfile) {
            InvokeDynamicSupport.bootstrap("callSessionUpdateReceived", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionUpdateReceived(android.telephony.ims.ImsCallSession android.telephony.ims.ImsCallProfile ), 0, this, imsCallSession, imsCallProfile);
        }

        public void callSessionConferenceExtended(ImsCallSession imsCallSession, ImsCallSession imsCallSession2, ImsCallProfile imsCallProfile) {
            InvokeDynamicSupport.bootstrap("callSessionConferenceExtended", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionConferenceExtended(android.telephony.ims.ImsCallSession android.telephony.ims.ImsCallSession android.telephony.ims.ImsCallProfile ), 0, this, imsCallSession, imsCallSession2, imsCallProfile);
        }

        public void callSessionConferenceExtendFailed(ImsCallSession imsCallSession, ImsReasonInfo imsReasonInfo) {
            InvokeDynamicSupport.bootstrap("callSessionConferenceExtendFailed", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionConferenceExtendFailed(android.telephony.ims.ImsCallSession android.telephony.ims.ImsReasonInfo ), 0, this, imsCallSession, imsReasonInfo);
        }

        public void callSessionConferenceExtendReceived(ImsCallSession imsCallSession, ImsCallSession imsCallSession2, ImsCallProfile imsCallProfile) {
            InvokeDynamicSupport.bootstrap("callSessionConferenceExtendReceived", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionConferenceExtendReceived(android.telephony.ims.ImsCallSession android.telephony.ims.ImsCallSession android.telephony.ims.ImsCallProfile ), 0, this, imsCallSession, imsCallSession2, imsCallProfile);
        }

        public void callSessionInviteParticipantsRequestDelivered(ImsCallSession imsCallSession) {
            InvokeDynamicSupport.bootstrap("callSessionInviteParticipantsRequestDelivered", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionInviteParticipantsRequestDelivered(android.telephony.ims.ImsCallSession ), 0, this, imsCallSession);
        }

        public void callSessionInviteParticipantsRequestFailed(ImsCallSession imsCallSession, ImsReasonInfo imsReasonInfo) {
            InvokeDynamicSupport.bootstrap("callSessionInviteParticipantsRequestFailed", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionInviteParticipantsRequestFailed(android.telephony.ims.ImsCallSession android.telephony.ims.ImsReasonInfo ), 0, this, imsCallSession, imsReasonInfo);
        }

        public void callSessionRemoveParticipantsRequestDelivered(ImsCallSession imsCallSession) {
            InvokeDynamicSupport.bootstrap("callSessionRemoveParticipantsRequestDelivered", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionRemoveParticipantsRequestDelivered(android.telephony.ims.ImsCallSession ), 0, this, imsCallSession);
        }

        public void callSessionRemoveParticipantsRequestFailed(ImsCallSession imsCallSession, ImsReasonInfo imsReasonInfo) {
            InvokeDynamicSupport.bootstrap("callSessionRemoveParticipantsRequestFailed", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionRemoveParticipantsRequestFailed(android.telephony.ims.ImsCallSession android.telephony.ims.ImsReasonInfo ), 0, this, imsCallSession, imsReasonInfo);
        }

        public void callSessionConferenceStateUpdated(ImsCallSession imsCallSession, ImsConferenceState imsConferenceState) {
            InvokeDynamicSupport.bootstrap("callSessionConferenceStateUpdated", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionConferenceStateUpdated(android.telephony.ims.ImsCallSession android.telephony.ims.ImsConferenceState ), 0, this, imsCallSession, imsConferenceState);
        }

        public void callSessionUssdMessageReceived(ImsCallSession imsCallSession, int n, String string2) {
            InvokeDynamicSupport.bootstrap("callSessionUssdMessageReceived", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionUssdMessageReceived(android.telephony.ims.ImsCallSession int java.lang.String ), 0, this, imsCallSession, n, string2);
        }

        public void callSessionMayHandover(ImsCallSession imsCallSession, int n, int n2) {
            InvokeDynamicSupport.bootstrap("callSessionMayHandover", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionMayHandover(android.telephony.ims.ImsCallSession int int ), 0, this, imsCallSession, n, n2);
        }

        public void callSessionHandover(ImsCallSession imsCallSession, int n, int n2, ImsReasonInfo imsReasonInfo) {
            InvokeDynamicSupport.bootstrap("callSessionHandover", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionHandover(android.telephony.ims.ImsCallSession int int android.telephony.ims.ImsReasonInfo ), 0, this, imsCallSession, n, n2, imsReasonInfo);
        }

        public void callSessionHandoverFailed(ImsCallSession imsCallSession, int n, int n2, ImsReasonInfo imsReasonInfo) {
            InvokeDynamicSupport.bootstrap("callSessionHandoverFailed", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionHandoverFailed(android.telephony.ims.ImsCallSession int int android.telephony.ims.ImsReasonInfo ), 0, this, imsCallSession, n, n2, imsReasonInfo);
        }

        public void callSessionTtyModeReceived(ImsCallSession imsCallSession, int n) {
            InvokeDynamicSupport.bootstrap("callSessionTtyModeReceived", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionTtyModeReceived(android.telephony.ims.ImsCallSession int ), 0, this, imsCallSession, n);
        }

        public void callSessionMultipartyStateChanged(ImsCallSession imsCallSession, boolean bl) {
            InvokeDynamicSupport.bootstrap("callSessionMultipartyStateChanged", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionMultipartyStateChanged(android.telephony.ims.ImsCallSession boolean ), 0, this, imsCallSession, bl);
        }

        public void callSessionSuppServiceReceived(ImsCallSession imsCallSession, ImsSuppServiceNotification imsSuppServiceNotification) {
            InvokeDynamicSupport.bootstrap("callSessionSuppServiceReceived", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionSuppServiceReceived(android.telephony.ims.ImsCallSession android.telephony.ims.ImsSuppServiceNotification ), 0, this, imsCallSession, imsSuppServiceNotification);
        }

        public void callSessionRttModifyRequestReceived(ImsCallSession imsCallSession, ImsCallProfile imsCallProfile) {
            InvokeDynamicSupport.bootstrap("callSessionRttModifyRequestReceived", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionRttModifyRequestReceived(android.telephony.ims.ImsCallSession android.telephony.ims.ImsCallProfile ), 0, this, imsCallSession, imsCallProfile);
        }

        public void callSessionRttModifyResponseReceived(int n) {
            InvokeDynamicSupport.bootstrap("callSessionRttModifyResponseReceived", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionRttModifyResponseReceived(int ), 0, this, n);
        }

        public void callSessionRttMessageReceived(String string2) {
            InvokeDynamicSupport.bootstrap("callSessionRttMessageReceived", $$robo$$android_telephony_ims_ImsCallSession_Listener$callSessionRttMessageReceived(java.lang.String ), 0, this, string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Listener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int IDLE = 0;
        public static int INITIATED = 1;
        public static int NEGOTIATING = 2;
        public static int ESTABLISHING = 3;
        public static int ESTABLISHED = 4;
        public static int RENEGOTIATING = 5;
        public static int REESTABLISHING = 6;
        public static int TERMINATING = 7;
        public static int TERMINATED = 8;
        public static int INVALID = -1;

        private static final String $$robo$$android_telephony_ims_ImsCallSession_State$toString(int state) {
            switch (state) {
                case 0: {
                    return "IDLE";
                }
                case 1: {
                    return "INITIATED";
                }
                case 2: {
                    return "NEGOTIATING";
                }
                case 3: {
                    return "ESTABLISHING";
                }
                case 4: {
                    return "ESTABLISHED";
                }
                case 5: {
                    return "RENEGOTIATING";
                }
                case 6: {
                    return "REESTABLISHING";
                }
                case 7: {
                    return "TERMINATING";
                }
                case 8: {
                    return "TERMINATED";
                }
            }
            return "UNKNOWN";
        }

        private void $$robo$$android_telephony_ims_ImsCallSession_State$__constructor__() {
        }

        public static String toString(int n) {
            return InvokeDynamicSupport.bootstrapStatic("toString", $$robo$$android_telephony_ims_ImsCallSession_State$toString(int ), 0, (int)n);
        }

        private void __constructor__() {
            this.$$robo$$android_telephony_ims_ImsCallSession_State$__constructor__();
        }

        private State() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ims_ImsCallSession_State$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (State)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

