/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.mbms;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.telephony.mbms.MbmsUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MbmsTempFileProvider
extends ContentProvider
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String TEMP_FILE_ROOT_PREF_FILE_NAME = "MbmsTempFileRootPrefs";
    public static String TEMP_FILE_ROOT_PREF_NAME = "mbms_temp_file_root";
    private String mAuthority;
    private Context mContext;

    private void $$robo$$android_telephony_mbms_MbmsTempFileProvider$__constructor__() {
    }

    private final boolean $$robo$$android_telephony_mbms_MbmsTempFileProvider$onCreate() {
        return true;
    }

    private final Cursor $$robo$$android_telephony_mbms_MbmsTempFileProvider$query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        throw new UnsupportedOperationException("No querying supported");
    }

    private final String $$robo$$android_telephony_mbms_MbmsTempFileProvider$getType(Uri uri) {
        return "application/octet-stream";
    }

    private final Uri $$robo$$android_telephony_mbms_MbmsTempFileProvider$insert(Uri uri, ContentValues values) {
        throw new UnsupportedOperationException("No inserting supported");
    }

    private final int $$robo$$android_telephony_mbms_MbmsTempFileProvider$delete(Uri uri, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("No deleting supported");
    }

    private final int $$robo$$android_telephony_mbms_MbmsTempFileProvider$update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("No updating supported");
    }

    private final ParcelFileDescriptor $$robo$$android_telephony_mbms_MbmsTempFileProvider$openFile(Uri uri, String mode) throws FileNotFoundException {
        File file = MbmsTempFileProvider.getFileForUri(this.mContext, this.mAuthority, uri);
        int fileMode = ParcelFileDescriptor.parseMode(mode);
        return ParcelFileDescriptor.open(file, fileMode);
    }

    private final void $$robo$$android_telephony_mbms_MbmsTempFileProvider$attachInfo(Context context, ProviderInfo info) {
        super.attachInfo(context, info);
        if (info.exported) {
            throw new SecurityException("Provider must not be exported");
        }
        if (!info.grantUriPermissions) {
            throw new SecurityException("Provider must grant uri permissions");
        }
        this.mAuthority = info.authority;
        this.mContext = context;
    }

    private static final Uri $$robo$$android_telephony_mbms_MbmsTempFileProvider$getUriForFile(Context context, String authority, File file) {
        String tempFileDirPath;
        String filePath;
        try {
            filePath = file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not get canonical path for file " + file);
        }
        File tempFileDir = MbmsTempFileProvider.getEmbmsTempFileDir(context);
        if (!MbmsUtils.isContainedIn(tempFileDir, file)) {
            throw new IllegalArgumentException("File " + file + " is not contained in the temp file directory, which is " + tempFileDir);
        }
        try {
            tempFileDirPath = tempFileDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get canonical path for temp file root dir " + tempFileDir);
        }
        String pathFragment = tempFileDirPath.endsWith("/") ? filePath.substring(tempFileDirPath.length()) : filePath.substring(tempFileDirPath.length() + 1);
        String encodedPath = Uri.encode(pathFragment);
        return new Uri.Builder().scheme("content").authority(authority).encodedPath(encodedPath).build();
    }

    private static final File $$robo$$android_telephony_mbms_MbmsTempFileProvider$getFileForUri(Context context, String authority, Uri uri) throws FileNotFoundException {
        File file;
        File tempFileDir;
        if (!"content".equals(uri.getScheme())) {
            throw new IllegalArgumentException("Uri must have scheme content");
        }
        if (!Objects.equals(authority, uri.getAuthority())) {
            throw new IllegalArgumentException("Uri does not have a matching authority: " + authority + ", " + uri.getAuthority());
        }
        String relPath = Uri.decode(uri.getEncodedPath());
        try {
            tempFileDir = MbmsTempFileProvider.getEmbmsTempFileDir(context).getCanonicalFile();
            file = new File(tempFileDir, relPath).getCanonicalFile();
        }
        catch (IOException e) {
            throw new FileNotFoundException("Could not resolve paths");
        }
        if (!file.getPath().startsWith(tempFileDir.getPath())) {
            throw new SecurityException("Resolved path jumped beyond configured root");
        }
        return file;
    }

    private static final File $$robo$$android_telephony_mbms_MbmsTempFileProvider$getEmbmsTempFileDir(Context context) {
        SharedPreferences prefs = context.getSharedPreferences("MbmsTempFileRootPrefs", 0);
        String storedTempFileRoot = prefs.getString("mbms_temp_file_root", null);
        try {
            if (storedTempFileRoot != null) {
                return new File(storedTempFileRoot).getCanonicalFile();
            }
            return new File(context.getFilesDir(), "androidMbmsTempFileRoot").getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to canonicalize temp file root path " + e);
        }
    }

    private void __constructor__() {
        this.$$robo$$android_telephony_mbms_MbmsTempFileProvider$__constructor__();
    }

    public MbmsTempFileProvider() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_mbms_MbmsTempFileProvider$__constructor__(), 0, this);
    }

    @Override
    public boolean onCreate() {
        return (boolean)InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_telephony_mbms_MbmsTempFileProvider$onCreate(), 0, this);
    }

    @Override
    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_telephony_mbms_MbmsTempFileProvider$query(android.net.Uri java.lang.String[] java.lang.String java.lang.String[] java.lang.String ), 0, this, uri, stringArray, string2, stringArray2, string3);
    }

    @Override
    public String getType(Uri uri) {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_telephony_mbms_MbmsTempFileProvider$getType(android.net.Uri ), 0, this, uri);
    }

    @Override
    public Uri insert(Uri uri, ContentValues contentValues) {
        return InvokeDynamicSupport.bootstrap("insert", $$robo$$android_telephony_mbms_MbmsTempFileProvider$insert(android.net.Uri android.content.ContentValues ), 0, this, uri, contentValues);
    }

    @Override
    public int delete(Uri uri, String string2, String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrap("delete", $$robo$$android_telephony_mbms_MbmsTempFileProvider$delete(android.net.Uri java.lang.String java.lang.String[] ), 0, this, uri, string2, stringArray);
    }

    @Override
    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrap("update", $$robo$$android_telephony_mbms_MbmsTempFileProvider$update(android.net.Uri android.content.ContentValues java.lang.String java.lang.String[] ), 0, this, uri, contentValues, string2, stringArray);
    }

    @Override
    public ParcelFileDescriptor openFile(Uri uri, String string2) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openFile", $$robo$$android_telephony_mbms_MbmsTempFileProvider$openFile(android.net.Uri java.lang.String ), 0, this, uri, string2);
    }

    @Override
    public void attachInfo(Context context, ProviderInfo providerInfo) {
        InvokeDynamicSupport.bootstrap("attachInfo", $$robo$$android_telephony_mbms_MbmsTempFileProvider$attachInfo(android.content.Context android.content.pm.ProviderInfo ), 0, this, context, providerInfo);
    }

    public static Uri getUriForFile(Context context, String string2, File file) {
        return InvokeDynamicSupport.bootstrapStatic("getUriForFile", $$robo$$android_telephony_mbms_MbmsTempFileProvider$getUriForFile(android.content.Context java.lang.String java.io.File ), 0, (Context)context, (String)string2, (File)file);
    }

    public static File getFileForUri(Context context, String string2, Uri uri) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("getFileForUri", $$robo$$android_telephony_mbms_MbmsTempFileProvider$getFileForUri(android.content.Context java.lang.String android.net.Uri ), 0, (Context)context, (String)string2, (Uri)uri);
    }

    public static File getEmbmsTempFileDir(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getEmbmsTempFileDir", $$robo$$android_telephony_mbms_MbmsTempFileProvider$getEmbmsTempFileDir(android.content.Context ), 0, (Context)context);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MbmsTempFileProvider)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

