/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.text.Layout;
import android.text.Spanned;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextLine;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.ParagraphStyle;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BoringLayout
extends Layout
implements TextUtils.EllipsizeCallback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String mDirect;
    private Paint mPaint;
    int mBottom;
    int mDesc;
    private int mTopPadding;
    private int mBottomPadding;
    private float mMax;
    private int mEllipsizedWidth;
    private int mEllipsizedStart;
    private int mEllipsizedCount;

    private static final BoringLayout $$robo$$android_text_BoringLayout$make(CharSequence source, TextPaint paint, int outerWidth, Layout.Alignment align, float spacingMult, float spacingAdd, Metrics metrics, boolean includePad) {
        return new BoringLayout(source, paint, outerWidth, align, spacingMult, spacingAdd, metrics, includePad);
    }

    private static final BoringLayout $$robo$$android_text_BoringLayout$make(CharSequence source, TextPaint paint, int outerWidth, Layout.Alignment align, float spacingmult, float spacingadd, Metrics metrics, boolean includePad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth) {
        return new BoringLayout(source, paint, outerWidth, align, spacingmult, spacingadd, metrics, includePad, ellipsize, ellipsizedWidth);
    }

    private final BoringLayout $$robo$$android_text_BoringLayout$replaceOrMake(CharSequence source, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingMult, float spacingAdd, Metrics metrics, boolean includePad) {
        this.replaceWith(source, paint, outerwidth, align, spacingMult, spacingAdd);
        this.mEllipsizedWidth = outerwidth;
        this.mEllipsizedStart = 0;
        this.mEllipsizedCount = 0;
        this.init(source, paint, align, metrics, includePad, true);
        return this;
    }

    private final BoringLayout $$robo$$android_text_BoringLayout$replaceOrMake(CharSequence source, TextPaint paint, int outerWidth, Layout.Alignment align, float spacingMult, float spacingAdd, Metrics metrics, boolean includePad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth) {
        boolean trust;
        if (ellipsize == null || ellipsize == TextUtils.TruncateAt.MARQUEE) {
            this.replaceWith(source, paint, outerWidth, align, spacingMult, spacingAdd);
            this.mEllipsizedWidth = outerWidth;
            this.mEllipsizedStart = 0;
            this.mEllipsizedCount = 0;
            trust = true;
        } else {
            this.replaceWith(TextUtils.ellipsize(source, paint, ellipsizedWidth, ellipsize, true, this), paint, outerWidth, align, spacingMult, spacingAdd);
            this.mEllipsizedWidth = ellipsizedWidth;
            trust = false;
        }
        this.init(this.getText(), paint, align, metrics, includePad, trust);
        return this;
    }

    private void $$robo$$android_text_BoringLayout$__constructor__(CharSequence source, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingMult, float spacingAdd, Metrics metrics, boolean includePad) {
        this.mEllipsizedWidth = outerwidth;
        this.mEllipsizedStart = 0;
        this.mEllipsizedCount = 0;
        this.init(source, paint, align, metrics, includePad, true);
    }

    private void $$robo$$android_text_BoringLayout$__constructor__(CharSequence source, TextPaint paint, int outerWidth, Layout.Alignment align, float spacingMult, float spacingAdd, Metrics metrics, boolean includePad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth) {
        boolean trust;
        if (ellipsize == null || ellipsize == TextUtils.TruncateAt.MARQUEE) {
            this.mEllipsizedWidth = outerWidth;
            this.mEllipsizedStart = 0;
            this.mEllipsizedCount = 0;
            trust = true;
        } else {
            this.replaceWith(TextUtils.ellipsize(source, paint, ellipsizedWidth, ellipsize, true, this), paint, outerWidth, align, spacingMult, spacingAdd);
            this.mEllipsizedWidth = ellipsizedWidth;
            trust = false;
        }
        this.init(this.getText(), paint, align, metrics, includePad, trust);
    }

    private final void $$robo$$android_text_BoringLayout$init(CharSequence source, TextPaint paint, Layout.Alignment align, Metrics metrics, boolean includePad, boolean trustWidth) {
        int spacing;
        this.mDirect = source instanceof String && align == Layout.Alignment.ALIGN_NORMAL ? source.toString() : null;
        this.mPaint = paint;
        if (includePad) {
            spacing = metrics.bottom - metrics.top;
            this.mDesc = metrics.bottom;
        } else {
            spacing = metrics.descent - metrics.ascent;
            this.mDesc = metrics.descent;
        }
        this.mBottom = spacing;
        if (trustWidth) {
            this.mMax = metrics.width;
        } else {
            TextLine line = TextLine.obtain();
            line.set(paint, source, 0, source.length(), 1, Layout.DIRS_ALL_LEFT_TO_RIGHT, false, null);
            this.mMax = (int)Math.ceil(line.metrics(null));
            TextLine.recycle(line);
        }
        if (includePad) {
            this.mTopPadding = metrics.top - metrics.ascent;
            this.mBottomPadding = metrics.bottom - metrics.descent;
        }
    }

    private static final Metrics $$robo$$android_text_BoringLayout$isBoring(CharSequence text, TextPaint paint) {
        return BoringLayout.isBoring(text, paint, TextDirectionHeuristics.FIRSTSTRONG_LTR, null);
    }

    private static final Metrics $$robo$$android_text_BoringLayout$isBoring(CharSequence text, TextPaint paint, Metrics metrics) {
        return BoringLayout.isBoring(text, paint, TextDirectionHeuristics.FIRSTSTRONG_LTR, metrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean $$robo$$android_text_BoringLayout$hasAnyInterestingChars(CharSequence text, int textLength) {
        int MAX_BUF_LEN = 500;
        char[] buffer = TextUtils.obtain(500);
        try {
            for (int start = 0; start < textLength; start += 500) {
                int end = Math.min(start + 500, textLength);
                TextUtils.getChars(text, start, end, buffer, 0);
                int len = end - start;
                for (int i = 0; i < len; ++i) {
                    char c = buffer[i];
                    if (c != '\n' && c != '\t' && !TextUtils.couldAffectRtl(c)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            TextUtils.recycle(buffer);
        }
    }

    private static final Metrics $$robo$$android_text_BoringLayout$isBoring(CharSequence text, TextPaint paint, TextDirectionHeuristic textDir, Metrics metrics) {
        Spanned sp;
        ParagraphStyle[] styles;
        int textLength = text.length();
        if (BoringLayout.hasAnyInterestingChars(text, textLength)) {
            return null;
        }
        if (textDir != null && textDir.isRtl(text, 0, textLength)) {
            return null;
        }
        if (text instanceof Spanned && (styles = (sp = (Spanned)text).getSpans(0, textLength, ParagraphStyle.class)).length > 0) {
            return null;
        }
        Metrics fm = metrics;
        if (fm == null) {
            fm = new Metrics();
        } else {
            fm.reset();
        }
        TextLine line = TextLine.obtain();
        line.set(paint, text, 0, textLength, 1, Layout.DIRS_ALL_LEFT_TO_RIGHT, false, null);
        fm.width = (int)Math.ceil(line.metrics(fm));
        TextLine.recycle(line);
        return fm;
    }

    private final int $$robo$$android_text_BoringLayout$getHeight() {
        return this.mBottom;
    }

    private final int $$robo$$android_text_BoringLayout$getLineCount() {
        return 1;
    }

    private final int $$robo$$android_text_BoringLayout$getLineTop(int line) {
        if (line == 0) {
            return 0;
        }
        return this.mBottom;
    }

    private final int $$robo$$android_text_BoringLayout$getLineDescent(int line) {
        return this.mDesc;
    }

    private final int $$robo$$android_text_BoringLayout$getLineStart(int line) {
        if (line == 0) {
            return 0;
        }
        return this.getText().length();
    }

    private final int $$robo$$android_text_BoringLayout$getParagraphDirection(int line) {
        return 1;
    }

    private final boolean $$robo$$android_text_BoringLayout$getLineContainsTab(int line) {
        return false;
    }

    private final float $$robo$$android_text_BoringLayout$getLineMax(int line) {
        return this.mMax;
    }

    private final float $$robo$$android_text_BoringLayout$getLineWidth(int line) {
        return line == 0 ? this.mMax : 0.0f;
    }

    private final Layout.Directions $$robo$$android_text_BoringLayout$getLineDirections(int line) {
        return Layout.DIRS_ALL_LEFT_TO_RIGHT;
    }

    private final int $$robo$$android_text_BoringLayout$getTopPadding() {
        return this.mTopPadding;
    }

    private final int $$robo$$android_text_BoringLayout$getBottomPadding() {
        return this.mBottomPadding;
    }

    private final int $$robo$$android_text_BoringLayout$getEllipsisCount(int line) {
        return this.mEllipsizedCount;
    }

    private final int $$robo$$android_text_BoringLayout$getEllipsisStart(int line) {
        return this.mEllipsizedStart;
    }

    private final int $$robo$$android_text_BoringLayout$getEllipsizedWidth() {
        return this.mEllipsizedWidth;
    }

    private final void $$robo$$android_text_BoringLayout$draw(Canvas c, Path highlight, Paint highlightpaint, int cursorOffset) {
        if (this.mDirect != null && highlight == null) {
            c.drawText(this.mDirect, 0.0f, this.mBottom - this.mDesc, this.mPaint);
        } else {
            super.draw(c, highlight, highlightpaint, cursorOffset);
        }
    }

    private final void $$robo$$android_text_BoringLayout$ellipsized(int start, int end) {
        this.mEllipsizedStart = start;
        this.mEllipsizedCount = end - start;
    }

    public static BoringLayout make(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, Metrics metrics, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("make", $$robo$$android_text_BoringLayout$make(java.lang.CharSequence android.text.TextPaint int android.text.Layout$Alignment float float android.text.BoringLayout$Metrics boolean ), 0, (CharSequence)charSequence, (TextPaint)textPaint, (int)n, (Layout.Alignment)alignment, (float)f, (float)f2, (Metrics)metrics, (boolean)bl);
    }

    public static BoringLayout make(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, Metrics metrics, boolean bl, TextUtils.TruncateAt truncateAt, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("make", $$robo$$android_text_BoringLayout$make(java.lang.CharSequence android.text.TextPaint int android.text.Layout$Alignment float float android.text.BoringLayout$Metrics boolean android.text.TextUtils$TruncateAt int ), 0, (CharSequence)charSequence, (TextPaint)textPaint, (int)n, (Layout.Alignment)alignment, (float)f, (float)f2, (Metrics)metrics, (boolean)bl, (TextUtils.TruncateAt)truncateAt, (int)n2);
    }

    public BoringLayout replaceOrMake(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, Metrics metrics, boolean bl) {
        return InvokeDynamicSupport.bootstrap("replaceOrMake", $$robo$$android_text_BoringLayout$replaceOrMake(java.lang.CharSequence android.text.TextPaint int android.text.Layout$Alignment float float android.text.BoringLayout$Metrics boolean ), 0, this, charSequence, textPaint, n, alignment, f, f2, metrics, bl);
    }

    public BoringLayout replaceOrMake(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, Metrics metrics, boolean bl, TextUtils.TruncateAt truncateAt, int n2) {
        return InvokeDynamicSupport.bootstrap("replaceOrMake", $$robo$$android_text_BoringLayout$replaceOrMake(java.lang.CharSequence android.text.TextPaint int android.text.Layout$Alignment float float android.text.BoringLayout$Metrics boolean android.text.TextUtils$TruncateAt int ), 0, this, charSequence, textPaint, n, alignment, f, f2, metrics, bl, truncateAt, n2);
    }

    private void __constructor__(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, Metrics metrics, boolean bl) {
        this.$$robo$$android_text_BoringLayout$__constructor__(charSequence, textPaint, n, alignment, f, f2, metrics, bl);
    }

    public BoringLayout(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, Metrics metrics, boolean bl) {
        super(charSequence, textPaint, n, alignment, f, f2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_BoringLayout$__constructor__(java.lang.CharSequence android.text.TextPaint int android.text.Layout$Alignment float float android.text.BoringLayout$Metrics boolean ), 0, this, charSequence, textPaint, n, alignment, f, f2, metrics, bl);
    }

    private void __constructor__(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, Metrics metrics, boolean bl, TextUtils.TruncateAt truncateAt, int n2) {
        this.$$robo$$android_text_BoringLayout$__constructor__(charSequence, textPaint, n, alignment, f, f2, metrics, bl, truncateAt, n2);
    }

    public BoringLayout(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, Metrics metrics, boolean bl, TextUtils.TruncateAt truncateAt, int n2) {
        super(charSequence, textPaint, n, alignment, f, f2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_BoringLayout$__constructor__(java.lang.CharSequence android.text.TextPaint int android.text.Layout$Alignment float float android.text.BoringLayout$Metrics boolean android.text.TextUtils$TruncateAt int ), 0, this, charSequence, textPaint, n, alignment, f, f2, metrics, bl, truncateAt, n2);
    }

    void init(CharSequence charSequence, TextPaint textPaint, Layout.Alignment alignment, Metrics metrics, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_text_BoringLayout$init(java.lang.CharSequence android.text.TextPaint android.text.Layout$Alignment android.text.BoringLayout$Metrics boolean boolean ), 0, this, charSequence, textPaint, alignment, metrics, bl, bl2);
    }

    public static Metrics isBoring(CharSequence charSequence, TextPaint textPaint) {
        return InvokeDynamicSupport.bootstrapStatic("isBoring", $$robo$$android_text_BoringLayout$isBoring(java.lang.CharSequence android.text.TextPaint ), 0, (CharSequence)charSequence, (TextPaint)textPaint);
    }

    public static Metrics isBoring(CharSequence charSequence, TextPaint textPaint, Metrics metrics) {
        return InvokeDynamicSupport.bootstrapStatic("isBoring", $$robo$$android_text_BoringLayout$isBoring(java.lang.CharSequence android.text.TextPaint android.text.BoringLayout$Metrics ), 0, (CharSequence)charSequence, (TextPaint)textPaint, (Metrics)metrics);
    }

    private static boolean hasAnyInterestingChars(CharSequence charSequence, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasAnyInterestingChars", $$robo$$android_text_BoringLayout$hasAnyInterestingChars(java.lang.CharSequence int ), 0, (CharSequence)charSequence, (int)n);
    }

    public static Metrics isBoring(CharSequence charSequence, TextPaint textPaint, TextDirectionHeuristic textDirectionHeuristic, Metrics metrics) {
        return InvokeDynamicSupport.bootstrapStatic("isBoring", $$robo$$android_text_BoringLayout$isBoring(java.lang.CharSequence android.text.TextPaint android.text.TextDirectionHeuristic android.text.BoringLayout$Metrics ), 0, (CharSequence)charSequence, (TextPaint)textPaint, (TextDirectionHeuristic)textDirectionHeuristic, (Metrics)metrics);
    }

    @Override
    public int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_text_BoringLayout$getHeight(), 0, this);
    }

    @Override
    public int getLineCount() {
        return (int)InvokeDynamicSupport.bootstrap("getLineCount", $$robo$$android_text_BoringLayout$getLineCount(), 0, this);
    }

    @Override
    public int getLineTop(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLineTop", $$robo$$android_text_BoringLayout$getLineTop(int ), 0, this, n);
    }

    @Override
    public int getLineDescent(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLineDescent", $$robo$$android_text_BoringLayout$getLineDescent(int ), 0, this, n);
    }

    @Override
    public int getLineStart(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLineStart", $$robo$$android_text_BoringLayout$getLineStart(int ), 0, this, n);
    }

    @Override
    public int getParagraphDirection(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getParagraphDirection", $$robo$$android_text_BoringLayout$getParagraphDirection(int ), 0, this, n);
    }

    @Override
    public boolean getLineContainsTab(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getLineContainsTab", $$robo$$android_text_BoringLayout$getLineContainsTab(int ), 0, this, n);
    }

    @Override
    public float getLineMax(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getLineMax", $$robo$$android_text_BoringLayout$getLineMax(int ), 0, this, n);
    }

    @Override
    public float getLineWidth(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getLineWidth", $$robo$$android_text_BoringLayout$getLineWidth(int ), 0, this, n);
    }

    @Override
    public Layout.Directions getLineDirections(int n) {
        return InvokeDynamicSupport.bootstrap("getLineDirections", $$robo$$android_text_BoringLayout$getLineDirections(int ), 0, this, n);
    }

    @Override
    public int getTopPadding() {
        return (int)InvokeDynamicSupport.bootstrap("getTopPadding", $$robo$$android_text_BoringLayout$getTopPadding(), 0, this);
    }

    @Override
    public int getBottomPadding() {
        return (int)InvokeDynamicSupport.bootstrap("getBottomPadding", $$robo$$android_text_BoringLayout$getBottomPadding(), 0, this);
    }

    @Override
    public int getEllipsisCount(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getEllipsisCount", $$robo$$android_text_BoringLayout$getEllipsisCount(int ), 0, this, n);
    }

    @Override
    public int getEllipsisStart(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getEllipsisStart", $$robo$$android_text_BoringLayout$getEllipsisStart(int ), 0, this, n);
    }

    @Override
    public int getEllipsizedWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getEllipsizedWidth", $$robo$$android_text_BoringLayout$getEllipsizedWidth(), 0, this);
    }

    @Override
    public void draw(Canvas canvas, Path path, Paint paint, int n) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_text_BoringLayout$draw(android.graphics.Canvas android.graphics.Path android.graphics.Paint int ), 0, this, canvas, path, paint, n);
    }

    @Override
    public void ellipsized(int n, int n2) {
        InvokeDynamicSupport.bootstrap("ellipsized", $$robo$$android_text_BoringLayout$ellipsized(int int ), 0, this, n, n2);
    }

    public /* synthetic */ BoringLayout() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BoringLayout)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Metrics
    extends Paint.FontMetricsInt
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int width;

        private void $$robo$$android_text_BoringLayout_Metrics$__constructor__() {
        }

        private final String $$robo$$android_text_BoringLayout_Metrics$toString() {
            return super.toString() + " width=" + this.width;
        }

        private final void $$robo$$android_text_BoringLayout_Metrics$reset() {
            this.top = 0;
            this.bottom = 0;
            this.ascent = 0;
            this.descent = 0;
            this.width = 0;
            this.leading = 0;
        }

        private void __constructor__() {
            this.$$robo$$android_text_BoringLayout_Metrics$__constructor__();
        }

        public Metrics() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_BoringLayout_Metrics$__constructor__(), 0, this);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_text_BoringLayout_Metrics$toString(), 0, this);
        }

        private void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_text_BoringLayout_Metrics$reset(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Metrics)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

