/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import com.android.internal.util.Preconditions;
import java.util.Locale;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public interface InputFilter
extends InstrumentedInterface {
    public CharSequence filter(CharSequence var1, int var2, int var3, Spanned var4, int var5, int var6);

    public static class LengthFilter
    implements InputFilter,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mMax;

        private void $$robo$$android_text_InputFilter_LengthFilter$__constructor__(int max) {
            this.mMax = max;
        }

        private final CharSequence $$robo$$android_text_InputFilter_LengthFilter$filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            int keep = this.mMax - (dest.length() - (dend - dstart));
            if (keep <= 0) {
                return "";
            }
            if (keep >= end - start) {
                return null;
            }
            if (Character.isHighSurrogate(source.charAt((keep += start) - 1)) && --keep == start) {
                return "";
            }
            return source.subSequence(start, keep);
        }

        private final int $$robo$$android_text_InputFilter_LengthFilter$getMax() {
            return this.mMax;
        }

        private void __constructor__(int n) {
            this.$$robo$$android_text_InputFilter_LengthFilter$__constructor__(n);
        }

        public LengthFilter(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_InputFilter_LengthFilter$__constructor__(int ), 0, this, n);
        }

        @Override
        public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned spanned, int n3, int n4) {
            return InvokeDynamicSupport.bootstrap("filter", $$robo$$android_text_InputFilter_LengthFilter$filter(java.lang.CharSequence int int android.text.Spanned int int ), 0, this, charSequence, n, n2, spanned, n3, n4);
        }

        public int getMax() {
            return (int)InvokeDynamicSupport.bootstrap("getMax", $$robo$$android_text_InputFilter_LengthFilter$getMax(), 0, this);
        }

        public /* synthetic */ LengthFilter() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LengthFilter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AllCaps
    implements InputFilter,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Locale mLocale;

        private void $$robo$$android_text_InputFilter_AllCaps$__constructor__() {
            this.mLocale = null;
        }

        private void $$robo$$android_text_InputFilter_AllCaps$__constructor__(Locale locale) {
            Preconditions.checkNotNull(locale);
            this.mLocale = locale;
        }

        private final CharSequence $$robo$$android_text_InputFilter_AllCaps$filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            int cp;
            CharSequenceWrapper wrapper = new CharSequenceWrapper(source, start, end);
            boolean lowerOrTitleFound = false;
            int length = end - start;
            for (int i = 0; i < length; i += Character.charCount(cp)) {
                cp = Character.codePointAt(wrapper, i);
                if (!Character.isLowerCase(cp) && !Character.isTitleCase(cp)) continue;
                lowerOrTitleFound = true;
                break;
            }
            if (!lowerOrTitleFound) {
                return null;
            }
            boolean copySpans = source instanceof Spanned;
            CharSequence upper = TextUtils.toUpperCase(this.mLocale, wrapper, copySpans);
            if (upper == wrapper) {
                return null;
            }
            return copySpans ? new SpannableString(upper) : upper.toString();
        }

        private void __constructor__() {
            this.$$robo$$android_text_InputFilter_AllCaps$__constructor__();
        }

        public AllCaps() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_InputFilter_AllCaps$__constructor__(), 0, this);
        }

        private void __constructor__(Locale locale) {
            this.$$robo$$android_text_InputFilter_AllCaps$__constructor__(locale);
        }

        public AllCaps(Locale locale) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_InputFilter_AllCaps$__constructor__(java.util.Locale ), 0, this, locale);
        }

        @Override
        public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned spanned, int n3, int n4) {
            return InvokeDynamicSupport.bootstrap("filter", $$robo$$android_text_InputFilter_AllCaps$filter(java.lang.CharSequence int int android.text.Spanned int int ), 0, this, charSequence, n, n2, spanned, n3, n4);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AllCaps)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class CharSequenceWrapper
        implements CharSequence,
        Spanned,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private CharSequence mSource;
            private int mStart;
            private int mEnd;
            private int mLength;

            private void $$robo$$android_text_InputFilter_AllCaps_CharSequenceWrapper$__constructor__(CharSequence source, int start, int end) {
                this.mSource = source;
                this.mStart = start;
                this.mEnd = end;
                this.mLength = end - start;
            }

            private final int $$robo$$android_text_InputFilter_AllCaps_CharSequenceWrapper$length() {
                return this.mLength;
            }

            private final char $$robo$$android_text_InputFilter_AllCaps_CharSequenceWrapper$charAt(int index) {
                if (index < 0 || index >= this.mLength) {
                    throw new IndexOutOfBoundsException();
                }
                return this.mSource.charAt(this.mStart + index);
            }

            private final CharSequence $$robo$$android_text_InputFilter_AllCaps_CharSequenceWrapper$subSequence(int start, int end) {
                if (start < 0 || end < 0 || end > this.mLength || start > end) {
                    throw new IndexOutOfBoundsException();
                }
                return new CharSequenceWrapper(this.mSource, this.mStart + start, this.mStart + end);
            }

            private final String $$robo$$android_text_InputFilter_AllCaps_CharSequenceWrapper$toString() {
                return this.mSource.subSequence(this.mStart, this.mEnd).toString();
            }

            private final <T> T[] $$robo$$android_text_InputFilter_AllCaps_CharSequenceWrapper$getSpans(int start, int end, Class<T> type) {
                return ((Spanned)this.mSource).getSpans(this.mStart + start, this.mStart + end, type);
            }

            private final int $$robo$$android_text_InputFilter_AllCaps_CharSequenceWrapper$getSpanStart(Object tag) {
                return ((Spanned)this.mSource).getSpanStart(tag) - this.mStart;
            }

            private final int $$robo$$android_text_InputFilter_AllCaps_CharSequenceWrapper$getSpanEnd(Object tag) {
                return ((Spanned)this.mSource).getSpanEnd(tag) - this.mStart;
            }

            private final int $$robo$$android_text_InputFilter_AllCaps_CharSequenceWrapper$getSpanFlags(Object tag) {
                return ((Spanned)this.mSource).getSpanFlags(tag);
            }

            private final int $$robo$$android_text_InputFilter_AllCaps_CharSequenceWrapper$nextSpanTransition(int start, int limit, Class type) {
                return ((Spanned)this.mSource).nextSpanTransition(this.mStart + start, this.mStart + limit, type) - this.mStart;
            }

            private void __constructor__(CharSequence charSequence, int n, int n2) {
                this.$$robo$$android_text_InputFilter_AllCaps_CharSequenceWrapper$__constructor__(charSequence, n, n2);
            }

            CharSequenceWrapper(CharSequence charSequence, int n, int n2) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_InputFilter_AllCaps_CharSequenceWrapper$__constructor__(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
            }

            @Override
            public int length() {
                return (int)InvokeDynamicSupport.bootstrap("length", $$robo$$android_text_InputFilter_AllCaps_CharSequenceWrapper$length(), 0, this);
            }

            @Override
            public char charAt(int n) {
                return (char)InvokeDynamicSupport.bootstrap("charAt", $$robo$$android_text_InputFilter_AllCaps_CharSequenceWrapper$charAt(int ), 0, this, n);
            }

            @Override
            public CharSequence subSequence(int n, int n2) {
                return InvokeDynamicSupport.bootstrap("subSequence", $$robo$$android_text_InputFilter_AllCaps_CharSequenceWrapper$subSequence(int int ), 0, this, n, n2);
            }

            @Override
            public String toString() {
                return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_text_InputFilter_AllCaps_CharSequenceWrapper$toString(), 0, this);
            }

            @Override
            public <T> T[] getSpans(int n, int n2, Class<T> clazz) {
                return InvokeDynamicSupport.bootstrap("getSpans", $$robo$$android_text_InputFilter_AllCaps_CharSequenceWrapper$getSpans(int int java.lang.Class<T> ), 0, this, n, n2, clazz);
            }

            @Override
            public int getSpanStart(Object object) {
                return (int)InvokeDynamicSupport.bootstrap("getSpanStart", $$robo$$android_text_InputFilter_AllCaps_CharSequenceWrapper$getSpanStart(java.lang.Object ), 0, this, object);
            }

            @Override
            public int getSpanEnd(Object object) {
                return (int)InvokeDynamicSupport.bootstrap("getSpanEnd", $$robo$$android_text_InputFilter_AllCaps_CharSequenceWrapper$getSpanEnd(java.lang.Object ), 0, this, object);
            }

            @Override
            public int getSpanFlags(Object object) {
                return (int)InvokeDynamicSupport.bootstrap("getSpanFlags", $$robo$$android_text_InputFilter_AllCaps_CharSequenceWrapper$getSpanFlags(java.lang.Object ), 0, this, object);
            }

            @Override
            public int nextSpanTransition(int n, int n2, Class clazz) {
                return (int)InvokeDynamicSupport.bootstrap("nextSpanTransition", $$robo$$android_text_InputFilter_AllCaps_CharSequenceWrapper$nextSpanTransition(int int java.lang.Class ), 0, this, n, n2, clazz);
            }

            public /* synthetic */ CharSequenceWrapper() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CharSequenceWrapper)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

