/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.icu.text.MeasureFormat;
import android.icu.util.Measure;
import android.icu.util.MeasureUnit;
import android.text.format.DateFormat;
import android.text.format.Time;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.Date;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import libcore.icu.DateIntervalFormat;
import libcore.icu.LocaleData;
import libcore.icu.RelativeDateTimeFormatter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DateUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static Object sLock;
    private static Configuration sLastConfig;
    private static String sElapsedFormatMMSS;
    private static String sElapsedFormatHMMSS;
    public static long SECOND_IN_MILLIS = 1000L;
    public static long MINUTE_IN_MILLIS = 60000L;
    public static long HOUR_IN_MILLIS = 3600000L;
    public static long DAY_IN_MILLIS = 86400000L;
    public static long WEEK_IN_MILLIS = 604800000L;
    public static long YEAR_IN_MILLIS = 31449600000L;
    public static int FORMAT_SHOW_TIME = 1;
    public static int FORMAT_SHOW_WEEKDAY = 2;
    public static int FORMAT_SHOW_YEAR = 4;
    public static int FORMAT_NO_YEAR = 8;
    public static int FORMAT_SHOW_DATE = 16;
    public static int FORMAT_NO_MONTH_DAY = 32;
    @Deprecated
    public static int FORMAT_12HOUR = 64;
    @Deprecated
    public static int FORMAT_24HOUR = 128;
    @Deprecated
    public static int FORMAT_CAP_AMPM = 256;
    public static int FORMAT_NO_NOON = 512;
    @Deprecated
    public static int FORMAT_CAP_NOON = 1024;
    public static int FORMAT_NO_MIDNIGHT = 2048;
    @Deprecated
    public static int FORMAT_CAP_MIDNIGHT = 4096;
    @Deprecated
    public static int FORMAT_UTC = 8192;
    public static int FORMAT_ABBREV_TIME = 16384;
    public static int FORMAT_ABBREV_WEEKDAY = 32768;
    public static int FORMAT_ABBREV_MONTH = 65536;
    public static int FORMAT_NUMERIC_DATE = 131072;
    public static int FORMAT_ABBREV_RELATIVE = 262144;
    public static int FORMAT_ABBREV_ALL = 524288;
    @Deprecated
    public static int FORMAT_CAP_NOON_MIDNIGHT = 5120;
    @Deprecated
    public static int FORMAT_NO_NOON_MIDNIGHT = 2560;
    @Deprecated
    public static String HOUR_MINUTE_24 = "%H:%M";
    public static String MONTH_FORMAT = "%B";
    @Deprecated
    public static String ABBREV_MONTH_FORMAT = "%b";
    public static String NUMERIC_MONTH_FORMAT = "%m";
    public static String MONTH_DAY_FORMAT = "%-d";
    public static String YEAR_FORMAT = "%Y";
    public static String YEAR_FORMAT_TWO_DIGITS = "%g";
    public static String WEEKDAY_FORMAT = "%A";
    public static String ABBREV_WEEKDAY_FORMAT = "%a";
    @Deprecated
    public static int[] sameYearTable;
    @Deprecated
    public static int[] sameMonthTable;
    @Deprecated
    public static int LENGTH_LONG = 10;
    @Deprecated
    public static int LENGTH_MEDIUM = 20;
    @Deprecated
    public static int LENGTH_SHORT = 30;
    @Deprecated
    public static int LENGTH_SHORTER = 40;
    @Deprecated
    public static int LENGTH_SHORTEST = 50;
    private static Time sNowTime;
    private static Time sThenTime;

    private void $$robo$$android_text_format_DateUtils$__constructor__() {
    }

    @Deprecated
    private static final String $$robo$$android_text_format_DateUtils$getDayOfWeekString(int dayOfWeek, int abbrev) {
        String[] names;
        LocaleData d = LocaleData.get(Locale.getDefault());
        switch (abbrev) {
            case 10: {
                names = d.longWeekdayNames;
                break;
            }
            case 20: {
                names = d.shortWeekdayNames;
                break;
            }
            case 30: {
                names = d.shortWeekdayNames;
                break;
            }
            case 40: {
                names = d.shortWeekdayNames;
                break;
            }
            case 50: {
                names = d.tinyWeekdayNames;
                break;
            }
            default: {
                names = d.shortWeekdayNames;
            }
        }
        return names[dayOfWeek];
    }

    @Deprecated
    private static final String $$robo$$android_text_format_DateUtils$getAMPMString(int ampm) {
        return LocaleData.get((Locale)Locale.getDefault()).amPm[ampm - 0];
    }

    @Deprecated
    private static final String $$robo$$android_text_format_DateUtils$getMonthString(int month, int abbrev) {
        String[] names;
        LocaleData d = LocaleData.get(Locale.getDefault());
        switch (abbrev) {
            case 10: {
                names = d.longMonthNames;
                break;
            }
            case 20: {
                names = d.shortMonthNames;
                break;
            }
            case 30: {
                names = d.shortMonthNames;
                break;
            }
            case 40: {
                names = d.shortMonthNames;
                break;
            }
            case 50: {
                names = d.tinyMonthNames;
                break;
            }
            default: {
                names = d.shortMonthNames;
            }
        }
        return names[month];
    }

    private static final CharSequence $$robo$$android_text_format_DateUtils$getRelativeTimeSpanString(long startTime) {
        return DateUtils.getRelativeTimeSpanString(startTime, (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"), 60000L);
    }

    private static final CharSequence $$robo$$android_text_format_DateUtils$getRelativeTimeSpanString(long time, long now, long minResolution) {
        int flags = 65556;
        return DateUtils.getRelativeTimeSpanString(time, now, minResolution, flags);
    }

    private static final CharSequence $$robo$$android_text_format_DateUtils$getRelativeTimeSpanString(long time, long now, long minResolution, int flags) {
        return RelativeDateTimeFormatter.getRelativeTimeSpanString(Locale.getDefault(), TimeZone.getDefault(), time, now, minResolution, flags);
    }

    private static final CharSequence $$robo$$android_text_format_DateUtils$getRelativeDateTimeString(Context c, long time, long minResolution, long transitionResolution, int flags) {
        if ((flags & 0xC1) == 1) {
            flags |= DateFormat.is24HourFormat(c) ? 128 : 64;
        }
        return RelativeDateTimeFormatter.getRelativeDateTimeString(Locale.getDefault(), TimeZone.getDefault(), time, (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"), minResolution, transitionResolution, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_text_format_DateUtils$initFormatStrings() {
        Object object = sLock;
        synchronized (object) {
            DateUtils.initFormatStringsLocked();
        }
    }

    private static final void $$robo$$android_text_format_DateUtils$initFormatStringsLocked() {
        Resources r = Resources.getSystem();
        Configuration cfg = r.getConfiguration();
        if (sLastConfig == null || !sLastConfig.equals(cfg)) {
            sLastConfig = cfg;
            sElapsedFormatMMSS = r.getString(17039816);
            sElapsedFormatHMMSS = r.getString(17039815);
        }
    }

    private static final CharSequence $$robo$$android_text_format_DateUtils$formatDuration(long millis) {
        return DateUtils.formatDuration(millis, 10);
    }

    private static final CharSequence $$robo$$android_text_format_DateUtils$formatDuration(long millis, int abbrev) {
        MeasureFormat.FormatWidth width;
        switch (abbrev) {
            case 10: {
                width = MeasureFormat.FormatWidth.WIDE;
                break;
            }
            case 20: 
            case 30: 
            case 40: {
                width = MeasureFormat.FormatWidth.SHORT;
                break;
            }
            case 50: {
                width = MeasureFormat.FormatWidth.NARROW;
                break;
            }
            default: {
                width = MeasureFormat.FormatWidth.WIDE;
            }
        }
        MeasureFormat formatter = MeasureFormat.getInstance(Locale.getDefault(), width);
        if (millis >= 3600000L) {
            int hours = (int)((millis + 1800000L) / 3600000L);
            return formatter.format(new Measure(hours, MeasureUnit.HOUR));
        }
        if (millis >= 60000L) {
            int minutes = (int)((millis + 30000L) / 60000L);
            return formatter.format(new Measure(minutes, MeasureUnit.MINUTE));
        }
        int seconds = (int)((millis + 500L) / 1000L);
        return formatter.format(new Measure(seconds, MeasureUnit.SECOND));
    }

    private static final String $$robo$$android_text_format_DateUtils$formatElapsedTime(long elapsedSeconds) {
        return DateUtils.formatElapsedTime(null, elapsedSeconds);
    }

    private static final String $$robo$$android_text_format_DateUtils$formatElapsedTime(StringBuilder recycle, long elapsedSeconds) {
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        if (elapsedSeconds >= 3600L) {
            hours = elapsedSeconds / 3600L;
            elapsedSeconds -= hours * 3600L;
        }
        if (elapsedSeconds >= 60L) {
            minutes = elapsedSeconds / 60L;
            elapsedSeconds -= minutes * 60L;
        }
        seconds = elapsedSeconds;
        StringBuilder sb = recycle;
        if (sb == null) {
            sb = new StringBuilder(8);
        } else {
            sb.setLength(0);
        }
        Formatter f = new Formatter(sb, Locale.getDefault());
        DateUtils.initFormatStrings();
        if (hours > 0L) {
            return f.format(sElapsedFormatHMMSS, hours, minutes, seconds).toString();
        }
        return f.format(sElapsedFormatMMSS, minutes, seconds).toString();
    }

    private static final CharSequence $$robo$$android_text_format_DateUtils$formatSameDayTime(long then, long now, int dateStyle, int timeStyle) {
        GregorianCalendar thenCal = new GregorianCalendar();
        thenCal.setTimeInMillis(then);
        Date thenDate = thenCal.getTime();
        GregorianCalendar nowCal = new GregorianCalendar();
        nowCal.setTimeInMillis(now);
        java.text.DateFormat f = thenCal.get(1) == nowCal.get(1) && thenCal.get(2) == nowCal.get(2) && thenCal.get(5) == nowCal.get(5) ? java.text.DateFormat.getTimeInstance(timeStyle) : java.text.DateFormat.getDateInstance(dateStyle);
        return f.format(thenDate);
    }

    private static final boolean $$robo$$android_text_format_DateUtils$isToday(long when) {
        Time time = new Time();
        time.set(when);
        int thenYear = time.year;
        int thenMonth = time.month;
        int thenMonthDay = time.monthDay;
        time.set((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
        return thenYear == time.year && thenMonth == time.month && thenMonthDay == time.monthDay;
    }

    private static final String $$robo$$android_text_format_DateUtils$formatDateRange(Context context, long startMillis, long endMillis, int flags) {
        Formatter f = new Formatter(new StringBuilder(50), Locale.getDefault());
        return DateUtils.formatDateRange(context, f, startMillis, endMillis, flags).toString();
    }

    private static final Formatter $$robo$$android_text_format_DateUtils$formatDateRange(Context context, Formatter formatter, long startMillis, long endMillis, int flags) {
        return DateUtils.formatDateRange(context, formatter, startMillis, endMillis, flags, null);
    }

    private static final Formatter $$robo$$android_text_format_DateUtils$formatDateRange(Context context, Formatter formatter, long startMillis, long endMillis, int flags, String timeZone) {
        if ((flags & 0xC1) == 1) {
            flags |= DateFormat.is24HourFormat(context) ? 128 : 64;
        }
        String range = DateIntervalFormat.formatDateRange(startMillis, endMillis, flags, timeZone);
        try {
            formatter.out().append(range);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
        return formatter;
    }

    private static final String $$robo$$android_text_format_DateUtils$formatDateTime(Context context, long millis, int flags) {
        return DateUtils.formatDateRange(context, millis, millis, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final CharSequence $$robo$$android_text_format_DateUtils$getRelativeTimeSpanString(Context c, long millis, boolean withPreposition) {
        CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        long span = Math.abs((long)(now - millis));
        Class<DateUtils> clazz = DateUtils.class;
        synchronized (DateUtils.class) {
            int prepositionId;
            String result;
            int flags;
            if (sNowTime == null) {
                sNowTime = new Time();
            }
            if (sThenTime == null) {
                sThenTime = new Time();
            }
            sNowTime.set((long)now);
            sThenTime.set(millis);
            if (span < 86400000L && DateUtils.sNowTime.weekDay == DateUtils.sThenTime.weekDay) {
                flags = 1;
                result = DateUtils.formatDateRange(c, millis, millis, flags);
                prepositionId = 17040727;
            } else if (DateUtils.sNowTime.year != DateUtils.sThenTime.year) {
                flags = 131092;
                result = DateUtils.formatDateRange(c, millis, millis, flags);
                prepositionId = 17040726;
            } else {
                flags = 65552;
                result = DateUtils.formatDateRange(c, millis, millis, flags);
                prepositionId = 17040726;
            }
            if (withPreposition) {
                Resources res = c.getResources();
                result = res.getString(prepositionId, result);
            }
            // ** MonitorExit[var9_5] (shouldn't be in output)
            return result;
        }
    }

    private static final CharSequence $$robo$$android_text_format_DateUtils$getRelativeTimeSpanString(Context c, long millis) {
        return DateUtils.getRelativeTimeSpanString(c, millis, false);
    }

    static void __staticInitializer__() {
        sLock = new Object();
        sameYearTable = null;
        sameMonthTable = null;
    }

    private void __constructor__() {
        this.$$robo$$android_text_format_DateUtils$__constructor__();
    }

    public DateUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_format_DateUtils$__constructor__(), 0, this);
    }

    @Deprecated
    public static String getDayOfWeekString(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getDayOfWeekString", $$robo$$android_text_format_DateUtils$getDayOfWeekString(int int ), 0, (int)n, (int)n2);
    }

    @Deprecated
    public static String getAMPMString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getAMPMString", $$robo$$android_text_format_DateUtils$getAMPMString(int ), 0, (int)n);
    }

    @Deprecated
    public static String getMonthString(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getMonthString", $$robo$$android_text_format_DateUtils$getMonthString(int int ), 0, (int)n, (int)n2);
    }

    public static CharSequence getRelativeTimeSpanString(long l) {
        return InvokeDynamicSupport.bootstrapStatic("getRelativeTimeSpanString", $$robo$$android_text_format_DateUtils$getRelativeTimeSpanString(long ), 0, (long)l);
    }

    public static CharSequence getRelativeTimeSpanString(long l, long l2, long l3) {
        return InvokeDynamicSupport.bootstrapStatic("getRelativeTimeSpanString", $$robo$$android_text_format_DateUtils$getRelativeTimeSpanString(long long long ), 0, (long)l, (long)l2, (long)l3);
    }

    public static CharSequence getRelativeTimeSpanString(long l, long l2, long l3, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getRelativeTimeSpanString", $$robo$$android_text_format_DateUtils$getRelativeTimeSpanString(long long long int ), 0, (long)l, (long)l2, (long)l3, (int)n);
    }

    public static CharSequence getRelativeDateTimeString(Context context, long l, long l2, long l3, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getRelativeDateTimeString", $$robo$$android_text_format_DateUtils$getRelativeDateTimeString(android.content.Context long long long int ), 0, (Context)context, (long)l, (long)l2, (long)l3, (int)n);
    }

    private static void initFormatStrings() {
        InvokeDynamicSupport.bootstrapStatic("initFormatStrings", $$robo$$android_text_format_DateUtils$initFormatStrings(), 0);
    }

    private static void initFormatStringsLocked() {
        InvokeDynamicSupport.bootstrapStatic("initFormatStringsLocked", $$robo$$android_text_format_DateUtils$initFormatStringsLocked(), 0);
    }

    public static CharSequence formatDuration(long l) {
        return InvokeDynamicSupport.bootstrapStatic("formatDuration", $$robo$$android_text_format_DateUtils$formatDuration(long ), 0, (long)l);
    }

    public static CharSequence formatDuration(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("formatDuration", $$robo$$android_text_format_DateUtils$formatDuration(long int ), 0, (long)l, (int)n);
    }

    public static String formatElapsedTime(long l) {
        return InvokeDynamicSupport.bootstrapStatic("formatElapsedTime", $$robo$$android_text_format_DateUtils$formatElapsedTime(long ), 0, (long)l);
    }

    public static String formatElapsedTime(StringBuilder stringBuilder, long l) {
        return InvokeDynamicSupport.bootstrapStatic("formatElapsedTime", $$robo$$android_text_format_DateUtils$formatElapsedTime(java.lang.StringBuilder long ), 0, (StringBuilder)stringBuilder, (long)l);
    }

    public static CharSequence formatSameDayTime(long l, long l2, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("formatSameDayTime", $$robo$$android_text_format_DateUtils$formatSameDayTime(long long int int ), 0, (long)l, (long)l2, (int)n, (int)n2);
    }

    public static boolean isToday(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isToday", $$robo$$android_text_format_DateUtils$isToday(long ), 0, (long)l);
    }

    public static String formatDateRange(Context context, long l, long l2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("formatDateRange", $$robo$$android_text_format_DateUtils$formatDateRange(android.content.Context long long int ), 0, (Context)context, (long)l, (long)l2, (int)n);
    }

    public static Formatter formatDateRange(Context context, Formatter formatter, long l, long l2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("formatDateRange", $$robo$$android_text_format_DateUtils$formatDateRange(android.content.Context java.util.Formatter long long int ), 0, (Context)context, (Formatter)formatter, (long)l, (long)l2, (int)n);
    }

    public static Formatter formatDateRange(Context context, Formatter formatter, long l, long l2, int n, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("formatDateRange", $$robo$$android_text_format_DateUtils$formatDateRange(android.content.Context java.util.Formatter long long int java.lang.String ), 0, (Context)context, (Formatter)formatter, (long)l, (long)l2, (int)n, (String)string2);
    }

    public static String formatDateTime(Context context, long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("formatDateTime", $$robo$$android_text_format_DateUtils$formatDateTime(android.content.Context long int ), 0, (Context)context, (long)l, (int)n);
    }

    public static CharSequence getRelativeTimeSpanString(Context context, long l, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getRelativeTimeSpanString", $$robo$$android_text_format_DateUtils$getRelativeTimeSpanString(android.content.Context long boolean ), 0, (Context)context, (long)l, (boolean)bl);
    }

    public static CharSequence getRelativeTimeSpanString(Context context, long l) {
        return InvokeDynamicSupport.bootstrapStatic("getRelativeTimeSpanString", $$robo$$android_text_format_DateUtils$getRelativeTimeSpanString(android.content.Context long ), 0, (Context)context, (long)l);
    }

    static {
        RobolectricInternals.classInitializing(DateUtils.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DateUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

