/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.ParcelableSpan;
import android.text.TextPaint;
import android.text.style.CharacterStyle;
import android.util.Log;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.R;
import java.util.Arrays;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SuggestionSpan
extends CharacterStyle
implements ParcelableSpan,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SuggestionSpan";
    public static int FLAG_EASY_CORRECT = 1;
    public static int FLAG_MISSPELLED = 2;
    public static int FLAG_AUTO_CORRECTION = 4;
    public static String ACTION_SUGGESTION_PICKED = "android.text.style.SUGGESTION_PICKED";
    public static String SUGGESTION_SPAN_PICKED_AFTER = "after";
    public static String SUGGESTION_SPAN_PICKED_BEFORE = "before";
    public static String SUGGESTION_SPAN_PICKED_HASHCODE = "hashcode";
    public static int SUGGESTIONS_MAX_SIZE = 5;
    private int mFlags;
    private String[] mSuggestions;
    private String mLocaleStringForCompatibility;
    private String mLanguageTag;
    private String mNotificationTargetClassName;
    private String mNotificationTargetPackageName;
    private int mHashCode;
    private float mEasyCorrectUnderlineThickness;
    private int mEasyCorrectUnderlineColor;
    private float mMisspelledUnderlineThickness;
    private int mMisspelledUnderlineColor;
    private float mAutoCorrectionUnderlineThickness;
    private int mAutoCorrectionUnderlineColor;
    public static Parcelable.Creator<SuggestionSpan> CREATOR;

    private void $$robo$$android_text_style_SuggestionSpan$__constructor__(Context context, String[] suggestions, int flags) {
    }

    private void $$robo$$android_text_style_SuggestionSpan$__constructor__(Locale locale, String[] suggestions, int flags) {
    }

    private void $$robo$$android_text_style_SuggestionSpan$__constructor__(Context context, Locale locale, String[] suggestions, int flags, Class<?> notificationTargetClass) {
        Locale sourceLocale;
        int N = Math.min(5, suggestions.length);
        this.mSuggestions = Arrays.copyOf(suggestions, N);
        this.mFlags = flags;
        if (locale != null) {
            sourceLocale = locale;
        } else if (context != null) {
            sourceLocale = context.getResources().getConfiguration().locale;
        } else {
            Log.e("SuggestionSpan", "No locale or context specified in SuggestionSpan constructor");
            sourceLocale = null;
        }
        this.mLocaleStringForCompatibility = sourceLocale == null ? "" : sourceLocale.toString();
        this.mLanguageTag = sourceLocale == null ? "" : sourceLocale.toLanguageTag();
        this.mNotificationTargetPackageName = context != null ? context.getPackageName() : null;
        this.mNotificationTargetClassName = notificationTargetClass != null ? notificationTargetClass.getCanonicalName() : "";
        this.mHashCode = SuggestionSpan.hashCodeInternal(this.mSuggestions, this.mLanguageTag, this.mLocaleStringForCompatibility, this.mNotificationTargetClassName);
        this.initStyle(context);
    }

    private final void $$robo$$android_text_style_SuggestionSpan$initStyle(Context context) {
        if (context == null) {
            this.mMisspelledUnderlineThickness = 0.0f;
            this.mEasyCorrectUnderlineThickness = 0.0f;
            this.mAutoCorrectionUnderlineThickness = 0.0f;
            this.mMisspelledUnderlineColor = -16777216;
            this.mEasyCorrectUnderlineColor = -16777216;
            this.mAutoCorrectionUnderlineColor = -16777216;
            return;
        }
        int defStyleAttr = 0x11100D0;
        TypedArray typedArray = context.obtainStyledAttributes(null, R.styleable.SuggestionSpan, defStyleAttr, 0);
        this.mMisspelledUnderlineThickness = typedArray.getDimension(1, 0.0f);
        this.mMisspelledUnderlineColor = typedArray.getColor(0, -16777216);
        defStyleAttr = 17891535;
        typedArray = context.obtainStyledAttributes(null, R.styleable.SuggestionSpan, defStyleAttr, 0);
        this.mEasyCorrectUnderlineThickness = typedArray.getDimension(1, 0.0f);
        this.mEasyCorrectUnderlineColor = typedArray.getColor(0, -16777216);
        defStyleAttr = 17891534;
        typedArray = context.obtainStyledAttributes(null, R.styleable.SuggestionSpan, defStyleAttr, 0);
        this.mAutoCorrectionUnderlineThickness = typedArray.getDimension(1, 0.0f);
        this.mAutoCorrectionUnderlineColor = typedArray.getColor(0, -16777216);
    }

    private void $$robo$$android_text_style_SuggestionSpan$__constructor__(Parcel src) {
        this.mSuggestions = src.readStringArray();
        this.mFlags = src.readInt();
        this.mLocaleStringForCompatibility = src.readString();
        this.mLanguageTag = src.readString();
        this.mNotificationTargetClassName = src.readString();
        this.mNotificationTargetPackageName = src.readString();
        this.mHashCode = src.readInt();
        this.mEasyCorrectUnderlineColor = src.readInt();
        this.mEasyCorrectUnderlineThickness = src.readFloat();
        this.mMisspelledUnderlineColor = src.readInt();
        this.mMisspelledUnderlineThickness = src.readFloat();
        this.mAutoCorrectionUnderlineColor = src.readInt();
        this.mAutoCorrectionUnderlineThickness = src.readFloat();
    }

    private final String[] $$robo$$android_text_style_SuggestionSpan$getSuggestions() {
        return this.mSuggestions;
    }

    @Deprecated
    private final String $$robo$$android_text_style_SuggestionSpan$getLocale() {
        return this.mLocaleStringForCompatibility;
    }

    private final Locale $$robo$$android_text_style_SuggestionSpan$getLocaleObject() {
        return this.mLanguageTag.isEmpty() ? null : Locale.forLanguageTag(this.mLanguageTag);
    }

    private final String $$robo$$android_text_style_SuggestionSpan$getNotificationTargetClassName() {
        return this.mNotificationTargetClassName;
    }

    private final int $$robo$$android_text_style_SuggestionSpan$getFlags() {
        return this.mFlags;
    }

    private final void $$robo$$android_text_style_SuggestionSpan$setFlags(int flags) {
        this.mFlags = flags;
    }

    private final int $$robo$$android_text_style_SuggestionSpan$describeContents() {
        return 0;
    }

    private final void $$robo$$android_text_style_SuggestionSpan$writeToParcel(Parcel dest, int flags) {
        this.writeToParcelInternal(dest, flags);
    }

    private final void $$robo$$android_text_style_SuggestionSpan$writeToParcelInternal(Parcel dest, int flags) {
        dest.writeStringArray(this.mSuggestions);
        dest.writeInt(this.mFlags);
        dest.writeString(this.mLocaleStringForCompatibility);
        dest.writeString(this.mLanguageTag);
        dest.writeString(this.mNotificationTargetClassName);
        dest.writeString(this.mNotificationTargetPackageName);
        dest.writeInt(this.mHashCode);
        dest.writeInt(this.mEasyCorrectUnderlineColor);
        dest.writeFloat(this.mEasyCorrectUnderlineThickness);
        dest.writeInt(this.mMisspelledUnderlineColor);
        dest.writeFloat(this.mMisspelledUnderlineThickness);
        dest.writeInt(this.mAutoCorrectionUnderlineColor);
        dest.writeFloat(this.mAutoCorrectionUnderlineThickness);
    }

    private final int $$robo$$android_text_style_SuggestionSpan$getSpanTypeId() {
        return this.getSpanTypeIdInternal();
    }

    private final int $$robo$$android_text_style_SuggestionSpan$getSpanTypeIdInternal() {
        return 19;
    }

    private final boolean $$robo$$android_text_style_SuggestionSpan$equals(Object o) {
        if (o instanceof SuggestionSpan) {
            return ((SuggestionSpan)o).hashCode() == this.mHashCode;
        }
        return false;
    }

    private final int $$robo$$android_text_style_SuggestionSpan$hashCode() {
        return this.mHashCode;
    }

    private static final int $$robo$$android_text_style_SuggestionSpan$hashCodeInternal(String[] suggestions, String languageTag, String localeStringForCompatibility, String notificationTargetClassName) {
        return Arrays.hashCode(new Object[]{SystemClock.uptimeMillis(), suggestions, languageTag, localeStringForCompatibility, notificationTargetClassName});
    }

    private final void $$robo$$android_text_style_SuggestionSpan$updateDrawState(TextPaint tp) {
        boolean autoCorrection;
        boolean misspelled = (this.mFlags & 2) != 0;
        boolean easy = (this.mFlags & 1) != 0;
        boolean bl = autoCorrection = (this.mFlags & 4) != 0;
        if (easy) {
            if (!misspelled) {
                tp.setUnderlineText(this.mEasyCorrectUnderlineColor, this.mEasyCorrectUnderlineThickness);
            } else if (tp.underlineColor == 0) {
                tp.setUnderlineText(this.mMisspelledUnderlineColor, this.mMisspelledUnderlineThickness);
            }
        } else if (autoCorrection) {
            tp.setUnderlineText(this.mAutoCorrectionUnderlineColor, this.mAutoCorrectionUnderlineThickness);
        }
    }

    private final int $$robo$$android_text_style_SuggestionSpan$getUnderlineColor() {
        boolean autoCorrection;
        boolean misspelled = (this.mFlags & 2) != 0;
        boolean easy = (this.mFlags & 1) != 0;
        boolean bl = autoCorrection = (this.mFlags & 4) != 0;
        if (easy) {
            if (!misspelled) {
                return this.mEasyCorrectUnderlineColor;
            }
            return this.mMisspelledUnderlineColor;
        }
        if (autoCorrection) {
            return this.mAutoCorrectionUnderlineColor;
        }
        return 0;
    }

    private final void $$robo$$android_text_style_SuggestionSpan$notifySelection(Context context, String original, int index) {
        Intent intent = new Intent();
        if (context == null || this.mNotificationTargetClassName == null) {
            return;
        }
        if (this.mSuggestions == null || index < 0 || index >= this.mSuggestions.length) {
            Log.w("SuggestionSpan", "Unable to notify the suggestion as the index is out of range index=" + index + " length=" + this.mSuggestions.length);
            return;
        }
        if (this.mNotificationTargetPackageName != null) {
            intent.setClassName(this.mNotificationTargetPackageName, this.mNotificationTargetClassName);
            intent.setAction("android.text.style.SUGGESTION_PICKED");
            intent.putExtra("before", original);
            intent.putExtra("after", this.mSuggestions[index]);
            intent.putExtra("hashcode", this.hashCode());
            context.sendBroadcast(intent);
        } else {
            InputMethodManager imm = InputMethodManager.peekInstance();
            if (imm != null) {
                imm.notifySuggestionPicked(this, original, index);
            }
        }
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<SuggestionSpan>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_text_style_SuggestionSpan_1$__constructor__() {
            }

            private final SuggestionSpan $$robo$$android_text_style_SuggestionSpan_1$createFromParcel(Parcel source) {
                return new SuggestionSpan(source);
            }

            private final SuggestionSpan[] $$robo$$android_text_style_SuggestionSpan_1$newArray(int size) {
                return new SuggestionSpan[size];
            }

            private void __constructor__() {
                this.$$robo$$android_text_style_SuggestionSpan_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_style_SuggestionSpan_1$__constructor__(), 0, this);
            }

            @Override
            public SuggestionSpan createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_text_style_SuggestionSpan_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public SuggestionSpan[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_text_style_SuggestionSpan_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Context context, String[] stringArray, int n) {
        this.$$robo$$android_text_style_SuggestionSpan$__constructor__(context, stringArray, n);
    }

    public SuggestionSpan(Context context, String[] stringArray, int n) {
        this(context, null, stringArray, n, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_style_SuggestionSpan$__constructor__(android.content.Context java.lang.String[] int ), 0, this, context, stringArray, n);
    }

    private void __constructor__(Locale locale, String[] stringArray, int n) {
        this.$$robo$$android_text_style_SuggestionSpan$__constructor__(locale, stringArray, n);
    }

    public SuggestionSpan(Locale locale, String[] stringArray, int n) {
        this(null, locale, stringArray, n, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_style_SuggestionSpan$__constructor__(java.util.Locale java.lang.String[] int ), 0, this, locale, stringArray, n);
    }

    private void __constructor__(Context context, Locale locale, String[] stringArray, int n, Class<?> clazz) {
        this.$$robo$$android_text_style_SuggestionSpan$__constructor__(context, locale, stringArray, n, clazz);
    }

    public SuggestionSpan(Context context, Locale locale, String[] stringArray, int n, Class<?> clazz) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_style_SuggestionSpan$__constructor__(android.content.Context java.util.Locale java.lang.String[] int java.lang.Class<?> ), 0, this, context, locale, stringArray, n, clazz);
    }

    private void initStyle(Context context) {
        InvokeDynamicSupport.bootstrap("initStyle", $$robo$$android_text_style_SuggestionSpan$initStyle(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_text_style_SuggestionSpan$__constructor__(parcel);
    }

    public SuggestionSpan(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_style_SuggestionSpan$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public String[] getSuggestions() {
        return InvokeDynamicSupport.bootstrap("getSuggestions", $$robo$$android_text_style_SuggestionSpan$getSuggestions(), 0, this);
    }

    @Deprecated
    public String getLocale() {
        return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_text_style_SuggestionSpan$getLocale(), 0, this);
    }

    public Locale getLocaleObject() {
        return InvokeDynamicSupport.bootstrap("getLocaleObject", $$robo$$android_text_style_SuggestionSpan$getLocaleObject(), 0, this);
    }

    public String getNotificationTargetClassName() {
        return InvokeDynamicSupport.bootstrap("getNotificationTargetClassName", $$robo$$android_text_style_SuggestionSpan$getNotificationTargetClassName(), 0, this);
    }

    public int getFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_text_style_SuggestionSpan$getFlags(), 0, this);
    }

    public void setFlags(int n) {
        InvokeDynamicSupport.bootstrap("setFlags", $$robo$$android_text_style_SuggestionSpan$setFlags(int ), 0, this, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_text_style_SuggestionSpan$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_text_style_SuggestionSpan$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public void writeToParcelInternal(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcelInternal", $$robo$$android_text_style_SuggestionSpan$writeToParcelInternal(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int getSpanTypeId() {
        return (int)InvokeDynamicSupport.bootstrap("getSpanTypeId", $$robo$$android_text_style_SuggestionSpan$getSpanTypeId(), 0, this);
    }

    @Override
    public int getSpanTypeIdInternal() {
        return (int)InvokeDynamicSupport.bootstrap("getSpanTypeIdInternal", $$robo$$android_text_style_SuggestionSpan$getSpanTypeIdInternal(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_text_style_SuggestionSpan$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_text_style_SuggestionSpan$hashCode(), 0, this);
    }

    private static int hashCodeInternal(String[] stringArray, String string2, String string3, String string4) {
        return (int)InvokeDynamicSupport.bootstrapStatic("hashCodeInternal", $$robo$$android_text_style_SuggestionSpan$hashCodeInternal(java.lang.String[] java.lang.String java.lang.String java.lang.String ), 0, (String[])stringArray, (String)string2, (String)string3, (String)string4);
    }

    @Override
    public void updateDrawState(TextPaint textPaint) {
        InvokeDynamicSupport.bootstrap("updateDrawState", $$robo$$android_text_style_SuggestionSpan$updateDrawState(android.text.TextPaint ), 0, this, textPaint);
    }

    public int getUnderlineColor() {
        return (int)InvokeDynamicSupport.bootstrap("getUnderlineColor", $$robo$$android_text_style_SuggestionSpan$getUnderlineColor(), 0, this);
    }

    public void notifySelection(Context context, String string2, int n) {
        InvokeDynamicSupport.bootstrap("notifySelection", $$robo$$android_text_style_SuggestionSpan$notifySelection(android.content.Context java.lang.String int ), 0, this, context, string2, n);
    }

    static {
        RobolectricInternals.classInitializing(SuggestionSpan.class);
    }

    public /* synthetic */ SuggestionSpan() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SuggestionSpan)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

