/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.LeakyTypefaceStorage;
import android.graphics.Typeface;
import android.os.Parcel;
import android.text.ParcelableSpan;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TextAppearanceSpan
extends MetricAffectingSpan
implements ParcelableSpan,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String mFamilyName;
    private int mStyle;
    private int mTextSize;
    private ColorStateList mTextColor;
    private ColorStateList mTextColorLink;
    private Typeface mTypeface;

    private void $$robo$$android_text_style_TextAppearanceSpan$__constructor__(Context context, int appearance) {
    }

    private void $$robo$$android_text_style_TextAppearanceSpan$__constructor__(Context context, int appearance, int colorList) {
        TypedArray a = context.obtainStyledAttributes(appearance, R.styleable.TextAppearance);
        ColorStateList textColor = a.getColorStateList(3);
        this.mTextColorLink = a.getColorStateList(6);
        this.mTextSize = a.getDimensionPixelSize(0, -1);
        this.mStyle = a.getInt(2, 0);
        this.mTypeface = !context.isRestricted() && context.canLoadUnsafeResources() ? a.getFont(12) : null;
        if (this.mTypeface != null) {
            this.mFamilyName = null;
        } else {
            String family = a.getString(12);
            if (family != null) {
                this.mFamilyName = family;
            } else {
                int tf = a.getInt(1, 0);
                switch (tf) {
                    case 1: {
                        this.mFamilyName = "sans";
                        break;
                    }
                    case 2: {
                        this.mFamilyName = "serif";
                        break;
                    }
                    case 3: {
                        this.mFamilyName = "monospace";
                        break;
                    }
                    default: {
                        this.mFamilyName = null;
                    }
                }
            }
        }
        a.recycle();
        if (colorList >= 0) {
            a = context.obtainStyledAttributes(16973829, R.styleable.Theme);
            textColor = a.getColorStateList(colorList);
            a.recycle();
        }
        this.mTextColor = textColor;
    }

    private void $$robo$$android_text_style_TextAppearanceSpan$__constructor__(String family, int style2, int size, ColorStateList color2, ColorStateList linkColor) {
        this.mFamilyName = family;
        this.mStyle = style2;
        this.mTextSize = size;
        this.mTextColor = color2;
        this.mTextColorLink = linkColor;
        this.mTypeface = null;
    }

    private void $$robo$$android_text_style_TextAppearanceSpan$__constructor__(Parcel src) {
        this.mFamilyName = src.readString();
        this.mStyle = src.readInt();
        this.mTextSize = src.readInt();
        this.mTextColor = src.readInt() != 0 ? ColorStateList.CREATOR.createFromParcel(src) : null;
        this.mTextColorLink = src.readInt() != 0 ? ColorStateList.CREATOR.createFromParcel(src) : null;
        this.mTypeface = LeakyTypefaceStorage.readTypefaceFromParcel(src);
    }

    private final int $$robo$$android_text_style_TextAppearanceSpan$getSpanTypeId() {
        return this.getSpanTypeIdInternal();
    }

    private final int $$robo$$android_text_style_TextAppearanceSpan$getSpanTypeIdInternal() {
        return 17;
    }

    private final int $$robo$$android_text_style_TextAppearanceSpan$describeContents() {
        return 0;
    }

    private final void $$robo$$android_text_style_TextAppearanceSpan$writeToParcel(Parcel dest, int flags) {
        this.writeToParcelInternal(dest, flags);
    }

    private final void $$robo$$android_text_style_TextAppearanceSpan$writeToParcelInternal(Parcel dest, int flags) {
        dest.writeString(this.mFamilyName);
        dest.writeInt(this.mStyle);
        dest.writeInt(this.mTextSize);
        if (this.mTextColor != null) {
            dest.writeInt(1);
            this.mTextColor.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        if (this.mTextColorLink != null) {
            dest.writeInt(1);
            this.mTextColorLink.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        LeakyTypefaceStorage.writeTypefaceToParcel(this.mTypeface, dest);
    }

    private final String $$robo$$android_text_style_TextAppearanceSpan$getFamily() {
        return this.mFamilyName;
    }

    private final ColorStateList $$robo$$android_text_style_TextAppearanceSpan$getTextColor() {
        return this.mTextColor;
    }

    private final ColorStateList $$robo$$android_text_style_TextAppearanceSpan$getLinkTextColor() {
        return this.mTextColorLink;
    }

    private final int $$robo$$android_text_style_TextAppearanceSpan$getTextSize() {
        return this.mTextSize;
    }

    private final int $$robo$$android_text_style_TextAppearanceSpan$getTextStyle() {
        return this.mStyle;
    }

    private final void $$robo$$android_text_style_TextAppearanceSpan$updateDrawState(TextPaint ds) {
        this.updateMeasureState(ds);
        if (this.mTextColor != null) {
            ds.setColor(this.mTextColor.getColorForState(ds.drawableState, 0));
        }
        if (this.mTextColorLink != null) {
            ds.linkColor = this.mTextColorLink.getColorForState(ds.drawableState, 0);
        }
    }

    private final void $$robo$$android_text_style_TextAppearanceSpan$updateMeasureState(TextPaint ds) {
        Typeface styledTypeface;
        int style2 = 0;
        if (this.mTypeface != null) {
            style2 = this.mStyle;
            styledTypeface = Typeface.create(this.mTypeface, style2);
        } else if (this.mFamilyName != null || this.mStyle != 0) {
            Typeface tf = ds.getTypeface();
            if (tf != null) {
                style2 = tf.getStyle();
            }
            styledTypeface = this.mFamilyName != null ? Typeface.create(this.mFamilyName, style2) : (tf == null ? Typeface.defaultFromStyle(style2) : Typeface.create(tf, style2 |= this.mStyle));
        } else {
            styledTypeface = null;
        }
        if (styledTypeface != null) {
            int fake = style2 & ~styledTypeface.getStyle();
            if ((fake & 1) != 0) {
                ds.setFakeBoldText(true);
            }
            if ((fake & 2) != 0) {
                ds.setTextSkewX(-0.25f);
            }
            ds.setTypeface(styledTypeface);
        }
        if (this.mTextSize > 0) {
            ds.setTextSize(this.mTextSize);
        }
    }

    private void __constructor__(Context context, int n) {
        this.$$robo$$android_text_style_TextAppearanceSpan$__constructor__(context, n);
    }

    public TextAppearanceSpan(Context context, int n) {
        this(context, n, -1);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_style_TextAppearanceSpan$__constructor__(android.content.Context int ), 0, this, context, n);
    }

    private void __constructor__(Context context, int n, int n2) {
        this.$$robo$$android_text_style_TextAppearanceSpan$__constructor__(context, n, n2);
    }

    public TextAppearanceSpan(Context context, int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_style_TextAppearanceSpan$__constructor__(android.content.Context int int ), 0, this, context, n, n2);
    }

    private void __constructor__(String string2, int n, int n2, ColorStateList colorStateList, ColorStateList colorStateList2) {
        this.$$robo$$android_text_style_TextAppearanceSpan$__constructor__(string2, n, n2, colorStateList, colorStateList2);
    }

    public TextAppearanceSpan(String string2, int n, int n2, ColorStateList colorStateList, ColorStateList colorStateList2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_style_TextAppearanceSpan$__constructor__(java.lang.String int int android.content.res.ColorStateList android.content.res.ColorStateList ), 0, this, string2, n, n2, colorStateList, colorStateList2);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_text_style_TextAppearanceSpan$__constructor__(parcel);
    }

    public TextAppearanceSpan(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_style_TextAppearanceSpan$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public int getSpanTypeId() {
        return (int)InvokeDynamicSupport.bootstrap("getSpanTypeId", $$robo$$android_text_style_TextAppearanceSpan$getSpanTypeId(), 0, this);
    }

    @Override
    public int getSpanTypeIdInternal() {
        return (int)InvokeDynamicSupport.bootstrap("getSpanTypeIdInternal", $$robo$$android_text_style_TextAppearanceSpan$getSpanTypeIdInternal(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_text_style_TextAppearanceSpan$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_text_style_TextAppearanceSpan$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public void writeToParcelInternal(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcelInternal", $$robo$$android_text_style_TextAppearanceSpan$writeToParcelInternal(android.os.Parcel int ), 0, this, parcel, n);
    }

    public String getFamily() {
        return InvokeDynamicSupport.bootstrap("getFamily", $$robo$$android_text_style_TextAppearanceSpan$getFamily(), 0, this);
    }

    public ColorStateList getTextColor() {
        return InvokeDynamicSupport.bootstrap("getTextColor", $$robo$$android_text_style_TextAppearanceSpan$getTextColor(), 0, this);
    }

    public ColorStateList getLinkTextColor() {
        return InvokeDynamicSupport.bootstrap("getLinkTextColor", $$robo$$android_text_style_TextAppearanceSpan$getLinkTextColor(), 0, this);
    }

    public int getTextSize() {
        return (int)InvokeDynamicSupport.bootstrap("getTextSize", $$robo$$android_text_style_TextAppearanceSpan$getTextSize(), 0, this);
    }

    public int getTextStyle() {
        return (int)InvokeDynamicSupport.bootstrap("getTextStyle", $$robo$$android_text_style_TextAppearanceSpan$getTextStyle(), 0, this);
    }

    @Override
    public void updateDrawState(TextPaint textPaint) {
        InvokeDynamicSupport.bootstrap("updateDrawState", $$robo$$android_text_style_TextAppearanceSpan$updateDrawState(android.text.TextPaint ), 0, this, textPaint);
    }

    @Override
    public void updateMeasureState(TextPaint textPaint) {
        InvokeDynamicSupport.bootstrap("updateMeasureState", $$robo$$android_text_style_TextAppearanceSpan$updateMeasureState(android.text.TextPaint ), 0, this, textPaint);
    }

    public /* synthetic */ TextAppearanceSpan() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextAppearanceSpan)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

