/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.FileUtils;
import android.os.SystemClock;
import android.util.ExceptionUtils;
import android.util.Log;
import com.android.internal.logging.EventLogTags;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.function.Consumer;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AtomicFile
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private File mBaseName;
    private File mBackupName;
    private String mCommitTag;
    private long mStartTime;

    private void $$robo$$android_util_AtomicFile$__constructor__(File baseName) {
    }

    private void $$robo$$android_util_AtomicFile$__constructor__(File baseName, String commitTag) {
        this.mBaseName = baseName;
        this.mBackupName = new File(baseName.getPath() + ".bak");
        this.mCommitTag = commitTag;
    }

    private final File $$robo$$android_util_AtomicFile$getBaseFile() {
        return this.mBaseName;
    }

    private final void $$robo$$android_util_AtomicFile$delete() {
        this.mBaseName.delete();
        this.mBackupName.delete();
    }

    private final FileOutputStream $$robo$$android_util_AtomicFile$startWrite() throws IOException {
        return this.startWrite(this.mCommitTag != null ? SystemClock.uptimeMillis() : 0L);
    }

    private final FileOutputStream $$robo$$android_util_AtomicFile$startWrite(long startTime) throws IOException {
        this.mStartTime = startTime;
        if (this.mBaseName.exists()) {
            if (!this.mBackupName.exists()) {
                if (!this.mBaseName.renameTo(this.mBackupName)) {
                    Log.w("AtomicFile", "Couldn't rename file " + this.mBaseName + " to backup file " + this.mBackupName);
                }
            } else {
                this.mBaseName.delete();
            }
        }
        FileOutputStream str = null;
        try {
            str = new FileOutputStream(this.mBaseName);
        }
        catch (FileNotFoundException e) {
            File parent = this.mBaseName.getParentFile();
            if (!parent.mkdirs()) {
                throw new IOException("Couldn't create directory " + this.mBaseName);
            }
            FileUtils.setPermissions(parent.getPath(), 505, -1, -1);
            try {
                str = new FileOutputStream(this.mBaseName);
            }
            catch (FileNotFoundException e2) {
                throw new IOException("Couldn't create " + this.mBaseName);
            }
        }
        return str;
    }

    private final void $$robo$$android_util_AtomicFile$finishWrite(FileOutputStream str) {
        if (str != null) {
            FileUtils.sync(str);
            try {
                str.close();
                this.mBackupName.delete();
            }
            catch (IOException e) {
                Log.w("AtomicFile", "finishWrite: Got exception:", e);
            }
            if (this.mCommitTag != null) {
                EventLogTags.writeCommitSysConfigFile(this.mCommitTag, SystemClock.uptimeMillis() - this.mStartTime);
            }
        }
    }

    private final void $$robo$$android_util_AtomicFile$failWrite(FileOutputStream str) {
        if (str != null) {
            FileUtils.sync(str);
            try {
                str.close();
                this.mBaseName.delete();
                this.mBackupName.renameTo(this.mBaseName);
            }
            catch (IOException e) {
                Log.w("AtomicFile", "failWrite: Got exception:", e);
            }
        }
    }

    @Deprecated
    private final void $$robo$$android_util_AtomicFile$truncate() throws IOException {
        try {
            FileOutputStream fos = new FileOutputStream(this.mBaseName);
            FileUtils.sync(fos);
            fos.close();
        }
        catch (FileNotFoundException e) {
            throw new IOException("Couldn't append " + this.mBaseName);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Deprecated
    private final FileOutputStream $$robo$$android_util_AtomicFile$openAppend() throws IOException {
        try {
            return new FileOutputStream(this.mBaseName, true);
        }
        catch (FileNotFoundException e) {
            throw new IOException("Couldn't append " + this.mBaseName);
        }
    }

    private final FileInputStream $$robo$$android_util_AtomicFile$openRead() throws FileNotFoundException {
        if (this.mBackupName.exists()) {
            this.mBaseName.delete();
            this.mBackupName.renameTo(this.mBaseName);
        }
        return new FileInputStream(this.mBaseName);
    }

    private final boolean $$robo$$android_util_AtomicFile$exists() {
        return this.mBaseName.exists() || this.mBackupName.exists();
    }

    private final long $$robo$$android_util_AtomicFile$getLastModifiedTime() {
        if (this.mBackupName.exists()) {
            return this.mBackupName.lastModified();
        }
        return this.mBaseName.lastModified();
    }

    private final byte[] $$robo$$android_util_AtomicFile$readFully() throws IOException {
        try (FileInputStream stream = this.openRead();){
            int pos = 0;
            int avail = stream.available();
            byte[] data = new byte[avail];
            while (true) {
                int amt;
                if ((amt = stream.read(data, pos, data.length - pos)) <= 0) {
                    byte[] byArray = data;
                    return byArray;
                }
                avail = stream.available();
                if (avail <= data.length - (pos += amt)) continue;
                byte[] newData = new byte[pos + avail];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])data, (int)0, (byte[])newData, (int)0, (int)pos);
                data = newData;
            }
        }
    }

    private final void $$robo$$android_util_AtomicFile$write(Consumer<FileOutputStream> writeContent) {
        FileOutputStream out = null;
        try {
            out = this.startWrite();
            writeContent.accept(out);
            this.finishWrite(out);
        }
        catch (Throwable t) {
            this.failWrite(out);
            throw ExceptionUtils.propagate(t);
        }
        finally {
            IoUtils.closeQuietly(out);
        }
    }

    private void __constructor__(File file) {
        this.$$robo$$android_util_AtomicFile$__constructor__(file);
    }

    public AtomicFile(File file) {
        this(file, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_AtomicFile$__constructor__(java.io.File ), 0, this, file);
    }

    private void __constructor__(File file, String string2) {
        this.$$robo$$android_util_AtomicFile$__constructor__(file, string2);
    }

    public AtomicFile(File file, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_AtomicFile$__constructor__(java.io.File java.lang.String ), 0, this, file, string2);
    }

    public File getBaseFile() {
        return InvokeDynamicSupport.bootstrap("getBaseFile", $$robo$$android_util_AtomicFile$getBaseFile(), 0, this);
    }

    public void delete() {
        InvokeDynamicSupport.bootstrap("delete", $$robo$$android_util_AtomicFile$delete(), 0, this);
    }

    public FileOutputStream startWrite() throws IOException {
        return InvokeDynamicSupport.bootstrap("startWrite", $$robo$$android_util_AtomicFile$startWrite(), 0, this);
    }

    public FileOutputStream startWrite(long l) throws IOException {
        return InvokeDynamicSupport.bootstrap("startWrite", $$robo$$android_util_AtomicFile$startWrite(long ), 0, this, l);
    }

    public void finishWrite(FileOutputStream fileOutputStream) {
        InvokeDynamicSupport.bootstrap("finishWrite", $$robo$$android_util_AtomicFile$finishWrite(java.io.FileOutputStream ), 0, this, fileOutputStream);
    }

    public void failWrite(FileOutputStream fileOutputStream) {
        InvokeDynamicSupport.bootstrap("failWrite", $$robo$$android_util_AtomicFile$failWrite(java.io.FileOutputStream ), 0, this, fileOutputStream);
    }

    @Deprecated
    public void truncate() throws IOException {
        InvokeDynamicSupport.bootstrap("truncate", $$robo$$android_util_AtomicFile$truncate(), 0, this);
    }

    @Deprecated
    public FileOutputStream openAppend() throws IOException {
        return InvokeDynamicSupport.bootstrap("openAppend", $$robo$$android_util_AtomicFile$openAppend(), 0, this);
    }

    public FileInputStream openRead() throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openRead", $$robo$$android_util_AtomicFile$openRead(), 0, this);
    }

    public boolean exists() {
        return (boolean)InvokeDynamicSupport.bootstrap("exists", $$robo$$android_util_AtomicFile$exists(), 0, this);
    }

    public long getLastModifiedTime() {
        return (long)InvokeDynamicSupport.bootstrap("getLastModifiedTime", $$robo$$android_util_AtomicFile$getLastModifiedTime(), 0, this);
    }

    public byte[] readFully() throws IOException {
        return InvokeDynamicSupport.bootstrap("readFully", $$robo$$android_util_AtomicFile$readFully(), 0, this);
    }

    public void write(Consumer<FileOutputStream> consumer) {
        InvokeDynamicSupport.bootstrap("write", $$robo$$android_util_AtomicFile$write(java.util.function.Consumer<java.io.FileOutputStream> ), 0, this, consumer);
    }

    public /* synthetic */ AtomicFile() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AtomicFile)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

