/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.JsonScope;
import com.google.errorprone.annotations.DoNotMock;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class JsonWriter
implements Closeable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Writer out;
    private List<JsonScope> stack;
    private String indent;
    private String separator;
    private boolean lenient;

    private void $$robo$$android_util_JsonWriter$__constructor__(Writer out) {
        this.stack = new ArrayList<JsonScope>();
        this.stack.add(JsonScope.EMPTY_DOCUMENT);
        this.separator = ":";
        if (out == null) {
            throw new NullPointerException("out == null");
        }
        this.out = out;
    }

    private final void $$robo$$android_util_JsonWriter$setIndent(String indent) {
        if (indent.isEmpty()) {
            this.indent = null;
            this.separator = ":";
        } else {
            this.indent = indent;
            this.separator = ": ";
        }
    }

    private final void $$robo$$android_util_JsonWriter$setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    private final boolean $$robo$$android_util_JsonWriter$isLenient() {
        return this.lenient;
    }

    private final JsonWriter $$robo$$android_util_JsonWriter$beginArray() throws IOException {
        return this.open(JsonScope.EMPTY_ARRAY, "[");
    }

    private final JsonWriter $$robo$$android_util_JsonWriter$endArray() throws IOException {
        return this.close(JsonScope.EMPTY_ARRAY, JsonScope.NONEMPTY_ARRAY, "]");
    }

    private final JsonWriter $$robo$$android_util_JsonWriter$beginObject() throws IOException {
        return this.open(JsonScope.EMPTY_OBJECT, "{");
    }

    private final JsonWriter $$robo$$android_util_JsonWriter$endObject() throws IOException {
        return this.close(JsonScope.EMPTY_OBJECT, JsonScope.NONEMPTY_OBJECT, "}");
    }

    private final JsonWriter $$robo$$android_util_JsonWriter$open(JsonScope empty, String openBracket) throws IOException {
        this.beforeValue(true);
        this.stack.add(empty);
        this.out.write(openBracket);
        return this;
    }

    private final JsonWriter $$robo$$android_util_JsonWriter$close(JsonScope empty, JsonScope nonempty, String closeBracket) throws IOException {
        JsonScope context = this.peek();
        if (context != nonempty && context != empty) {
            throw new IllegalStateException("Nesting problem: " + this.stack);
        }
        this.stack.remove(this.stack.size() - 1);
        if (context == nonempty) {
            this.newline();
        }
        this.out.write(closeBracket);
        return this;
    }

    private final JsonScope $$robo$$android_util_JsonWriter$peek() {
        return this.stack.get(this.stack.size() - 1);
    }

    private final void $$robo$$android_util_JsonWriter$replaceTop(JsonScope topOfStack) {
        this.stack.set(this.stack.size() - 1, topOfStack);
    }

    private final JsonWriter $$robo$$android_util_JsonWriter$name(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        this.beforeName();
        this.string(name);
        return this;
    }

    private final JsonWriter $$robo$$android_util_JsonWriter$value(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.beforeValue(false);
        this.string(value);
        return this;
    }

    private final JsonWriter $$robo$$android_util_JsonWriter$nullValue() throws IOException {
        this.beforeValue(false);
        this.out.write("null");
        return this;
    }

    private final JsonWriter $$robo$$android_util_JsonWriter$value(boolean value) throws IOException {
        this.beforeValue(false);
        this.out.write(value ? "true" : "false");
        return this;
    }

    private final JsonWriter $$robo$$android_util_JsonWriter$value(double value) throws IOException {
        if (!this.lenient && (Double.isNaN(value) || Double.isInfinite(value))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        this.beforeValue(false);
        this.out.append(Double.toString(value));
        return this;
    }

    private final JsonWriter $$robo$$android_util_JsonWriter$value(long value) throws IOException {
        this.beforeValue(false);
        this.out.write(Long.toString(value));
        return this;
    }

    private final JsonWriter $$robo$$android_util_JsonWriter$value(Number value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        String string2 = value.toString();
        if (!this.lenient && (string2.equals("-Infinity") || string2.equals("Infinity") || string2.equals("NaN"))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        this.beforeValue(false);
        this.out.append(string2);
        return this;
    }

    private final void $$robo$$android_util_JsonWriter$flush() throws IOException {
        this.out.flush();
    }

    private final void $$robo$$android_util_JsonWriter$close() throws IOException {
        this.out.close();
        if (this.peek() != JsonScope.NONEMPTY_DOCUMENT) {
            throw new IOException("Incomplete document");
        }
    }

    private final void $$robo$$android_util_JsonWriter$string(String value) throws IOException {
        this.out.write("\"");
        int length = value.length();
        block9: for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    this.out.write(92);
                    this.out.write(c);
                    continue block9;
                }
                case '\t': {
                    this.out.write("\\t");
                    continue block9;
                }
                case '\b': {
                    this.out.write("\\b");
                    continue block9;
                }
                case '\n': {
                    this.out.write("\\n");
                    continue block9;
                }
                case '\r': {
                    this.out.write("\\r");
                    continue block9;
                }
                case '\f': {
                    this.out.write("\\f");
                    continue block9;
                }
                case '\u2028': 
                case '\u2029': {
                    this.out.write(String.format("\\u%04x", c));
                    continue block9;
                }
                default: {
                    if (c <= '\u001f') {
                        this.out.write(String.format("\\u%04x", c));
                        continue block9;
                    }
                    this.out.write(c);
                }
            }
        }
        this.out.write("\"");
    }

    private final void $$robo$$android_util_JsonWriter$newline() throws IOException {
        if (this.indent == null) {
            return;
        }
        this.out.write("\n");
        for (int i = 1; i < this.stack.size(); ++i) {
            this.out.write(this.indent);
        }
    }

    private final void $$robo$$android_util_JsonWriter$beforeName() throws IOException {
        JsonScope context = this.peek();
        if (context == JsonScope.NONEMPTY_OBJECT) {
            this.out.write(44);
        } else if (context != JsonScope.EMPTY_OBJECT) {
            throw new IllegalStateException("Nesting problem: " + this.stack);
        }
        this.newline();
        this.replaceTop(JsonScope.DANGLING_NAME);
    }

    private final void $$robo$$android_util_JsonWriter$beforeValue(boolean root) throws IOException {
        switch (1.$SwitchMap$android$util$JsonScope[this.peek().ordinal()]) {
            case 1: {
                if (!this.lenient && !root) {
                    throw new IllegalStateException("JSON must start with an array or an object.");
                }
                this.replaceTop(JsonScope.NONEMPTY_DOCUMENT);
                break;
            }
            case 2: {
                this.replaceTop(JsonScope.NONEMPTY_ARRAY);
                this.newline();
                break;
            }
            case 3: {
                this.out.append(',');
                this.newline();
                break;
            }
            case 4: {
                this.out.append(this.separator);
                this.replaceTop(JsonScope.NONEMPTY_OBJECT);
                break;
            }
            case 5: {
                throw new IllegalStateException("JSON must have only one top-level value.");
            }
            default: {
                throw new IllegalStateException("Nesting problem: " + this.stack);
            }
        }
    }

    private void __constructor__(Writer writer) {
        this.$$robo$$android_util_JsonWriter$__constructor__(writer);
    }

    public JsonWriter(Writer writer) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_JsonWriter$__constructor__(java.io.Writer ), 0, this, writer);
    }

    public void setIndent(String string2) {
        InvokeDynamicSupport.bootstrap("setIndent", $$robo$$android_util_JsonWriter$setIndent(java.lang.String ), 0, this, string2);
    }

    public void setLenient(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLenient", $$robo$$android_util_JsonWriter$setLenient(boolean ), 0, this, bl);
    }

    public boolean isLenient() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLenient", $$robo$$android_util_JsonWriter$isLenient(), 0, this);
    }

    public JsonWriter beginArray() throws IOException {
        return InvokeDynamicSupport.bootstrap("beginArray", $$robo$$android_util_JsonWriter$beginArray(), 0, this);
    }

    public JsonWriter endArray() throws IOException {
        return InvokeDynamicSupport.bootstrap("endArray", $$robo$$android_util_JsonWriter$endArray(), 0, this);
    }

    public JsonWriter beginObject() throws IOException {
        return InvokeDynamicSupport.bootstrap("beginObject", $$robo$$android_util_JsonWriter$beginObject(), 0, this);
    }

    public JsonWriter endObject() throws IOException {
        return InvokeDynamicSupport.bootstrap("endObject", $$robo$$android_util_JsonWriter$endObject(), 0, this);
    }

    private JsonWriter open(JsonScope jsonScope, String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("open", $$robo$$android_util_JsonWriter$open(android.util.JsonScope java.lang.String ), 0, this, jsonScope, string2);
    }

    private JsonWriter close(JsonScope jsonScope, JsonScope jsonScope2, String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("close", $$robo$$android_util_JsonWriter$close(android.util.JsonScope android.util.JsonScope java.lang.String ), 0, this, jsonScope, jsonScope2, string2);
    }

    private JsonScope peek() {
        return InvokeDynamicSupport.bootstrap("peek", $$robo$$android_util_JsonWriter$peek(), 0, this);
    }

    private void replaceTop(JsonScope jsonScope) {
        InvokeDynamicSupport.bootstrap("replaceTop", $$robo$$android_util_JsonWriter$replaceTop(android.util.JsonScope ), 0, this, jsonScope);
    }

    public JsonWriter name(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("name", $$robo$$android_util_JsonWriter$name(java.lang.String ), 0, this, string2);
    }

    public JsonWriter value(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("value", $$robo$$android_util_JsonWriter$value(java.lang.String ), 0, this, string2);
    }

    public JsonWriter nullValue() throws IOException {
        return InvokeDynamicSupport.bootstrap("nullValue", $$robo$$android_util_JsonWriter$nullValue(), 0, this);
    }

    public JsonWriter value(boolean bl) throws IOException {
        return InvokeDynamicSupport.bootstrap("value", $$robo$$android_util_JsonWriter$value(boolean ), 0, this, bl);
    }

    public JsonWriter value(double d) throws IOException {
        return InvokeDynamicSupport.bootstrap("value", $$robo$$android_util_JsonWriter$value(double ), 0, this, d);
    }

    public JsonWriter value(long l) throws IOException {
        return InvokeDynamicSupport.bootstrap("value", $$robo$$android_util_JsonWriter$value(long ), 0, this, l);
    }

    public JsonWriter value(Number number) throws IOException {
        return InvokeDynamicSupport.bootstrap("value", $$robo$$android_util_JsonWriter$value(java.lang.Number ), 0, this, number);
    }

    public void flush() throws IOException {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$android_util_JsonWriter$flush(), 0, this);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_util_JsonWriter$close(), 0, this);
    }

    private void string(String string2) throws IOException {
        InvokeDynamicSupport.bootstrap("string", $$robo$$android_util_JsonWriter$string(java.lang.String ), 0, this, string2);
    }

    private void newline() throws IOException {
        InvokeDynamicSupport.bootstrap("newline", $$robo$$android_util_JsonWriter$newline(), 0, this);
    }

    private void beforeName() throws IOException {
        InvokeDynamicSupport.bootstrap("beforeName", $$robo$$android_util_JsonWriter$beforeName(), 0, this);
    }

    private void beforeValue(boolean bl) throws IOException {
        InvokeDynamicSupport.bootstrap("beforeValue", $$robo$$android_util_JsonWriter$beforeValue(boolean ), 0, this, bl);
    }

    public /* synthetic */ JsonWriter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (JsonWriter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

