/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.io.IOException;
import java.util.UUID;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MemoryIntArray
implements Parcelable,
Closeable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MemoryIntArray";
    private static int MAX_SIZE = 1024;
    private CloseGuard mCloseGuard;
    private boolean mIsOwner;
    private long mMemoryAddr;
    private int mFd;
    public static Parcelable.Creator<MemoryIntArray> CREATOR;

    private void $$robo$$android_util_MemoryIntArray$__constructor__(int size) throws IOException {
        this.mCloseGuard = CloseGuard.get();
        this.mFd = -1;
        if (size > 1024) {
            throw new IllegalArgumentException("Max size is 1024");
        }
        this.mIsOwner = true;
        String name = UUID.randomUUID().toString();
        this.mFd = this.nativeCreate(name, size);
        this.mMemoryAddr = this.nativeOpen(this.mFd, this.mIsOwner);
        this.mCloseGuard.open("close");
    }

    private void $$robo$$android_util_MemoryIntArray$__constructor__(Parcel parcel) throws IOException {
        this.mCloseGuard = CloseGuard.get();
        this.mFd = -1;
        this.mIsOwner = false;
        ParcelFileDescriptor pfd = (ParcelFileDescriptor)parcel.readParcelable(null);
        if (pfd == null) {
            throw new IOException("No backing file descriptor");
        }
        this.mFd = pfd.detachFd();
        this.mMemoryAddr = this.nativeOpen(this.mFd, this.mIsOwner);
        this.mCloseGuard.open("close");
    }

    private final boolean $$robo$$android_util_MemoryIntArray$isWritable() {
        this.enforceNotClosed();
        return this.mIsOwner;
    }

    private final int $$robo$$android_util_MemoryIntArray$get(int index) throws IOException {
        this.enforceNotClosed();
        this.enforceValidIndex(index);
        return this.nativeGet(this.mFd, this.mMemoryAddr, index);
    }

    private final void $$robo$$android_util_MemoryIntArray$set(int index, int value) throws IOException {
        this.enforceNotClosed();
        this.enforceWritable();
        this.enforceValidIndex(index);
        this.nativeSet(this.mFd, this.mMemoryAddr, index, value);
    }

    private final int $$robo$$android_util_MemoryIntArray$size() throws IOException {
        this.enforceNotClosed();
        return this.nativeSize(this.mFd);
    }

    private final void $$robo$$android_util_MemoryIntArray$close() throws IOException {
        if (!this.isClosed()) {
            this.nativeClose(this.mFd, this.mMemoryAddr, this.mIsOwner);
            this.mFd = -1;
            this.mCloseGuard.close();
        }
    }

    private final boolean $$robo$$android_util_MemoryIntArray$isClosed() {
        return this.mFd == -1;
    }

    private final void $$robo$$android_util_MemoryIntArray$finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            IoUtils.closeQuietly(this);
        }
        finally {
            super.finalize();
        }
    }

    private final int $$robo$$android_util_MemoryIntArray$describeContents() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_util_MemoryIntArray$writeToParcel(Parcel parcel, int flags) {
        ParcelFileDescriptor pfd = ParcelFileDescriptor.adoptFd(this.mFd);
        try {
            parcel.writeParcelable(pfd, flags & 0xFFFFFFFE);
        }
        finally {
            pfd.detachFd();
        }
    }

    private final boolean $$robo$$android_util_MemoryIntArray$equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryIntArray other = (MemoryIntArray)obj;
        return this.mFd == other.mFd;
    }

    private final int $$robo$$android_util_MemoryIntArray$hashCode() {
        return this.mFd;
    }

    private final void $$robo$$android_util_MemoryIntArray$enforceNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("cannot interact with a closed instance");
        }
    }

    private final void $$robo$$android_util_MemoryIntArray$enforceValidIndex(int index) throws IOException {
        int size = this.size();
        if (index < 0 || index > size - 1) {
            throw new IndexOutOfBoundsException(index + " not between 0 and " + (size - 1));
        }
    }

    private final void $$robo$$android_util_MemoryIntArray$enforceWritable() {
        if (!this.isWritable()) {
            throw new UnsupportedOperationException("array is not writable");
        }
    }

    private final int $$robo$$android_util_MemoryIntArray$nativeCreate(String string2, int n) {
        return 0;
    }

    private final long $$robo$$android_util_MemoryIntArray$nativeOpen(int n, boolean bl) {
        return 0L;
    }

    private final void $$robo$$android_util_MemoryIntArray$nativeClose(int n, long l, boolean bl) {
    }

    private final int $$robo$$android_util_MemoryIntArray$nativeGet(int n, long l, int n2) {
        return 0;
    }

    private final void $$robo$$android_util_MemoryIntArray$nativeSet(int n, long l, int n2, int n3) {
    }

    private final int $$robo$$android_util_MemoryIntArray$nativeSize(int n) {
        return 0;
    }

    private static final int $$robo$$android_util_MemoryIntArray$getMaxSize() {
        return 1024;
    }

    private /* synthetic */ void $$robo$$android_util_MemoryIntArray$__constructor__(Parcel x0, 1 x1) throws IOException {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<MemoryIntArray>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_util_MemoryIntArray_1$__constructor__() {
            }

            private final MemoryIntArray $$robo$$android_util_MemoryIntArray_1$createFromParcel(Parcel parcel) {
                try {
                    return new MemoryIntArray(parcel);
                }
                catch (IOException ioe) {
                    throw new IllegalArgumentException("Error unparceling MemoryIntArray");
                }
            }

            private final MemoryIntArray[] $$robo$$android_util_MemoryIntArray_1$newArray(int size) {
                return new MemoryIntArray[size];
            }

            private void __constructor__() {
                this.$$robo$$android_util_MemoryIntArray_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_MemoryIntArray_1$__constructor__(), 0, this);
            }

            @Override
            public MemoryIntArray createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_util_MemoryIntArray_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public MemoryIntArray[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_util_MemoryIntArray_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n) throws IOException {
        this.$$robo$$android_util_MemoryIntArray$__constructor__(n);
    }

    public MemoryIntArray(int n) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_MemoryIntArray$__constructor__(int ), 0, this, n);
    }

    private void __constructor__(Parcel parcel) throws IOException {
        this.$$robo$$android_util_MemoryIntArray$__constructor__(parcel);
    }

    private MemoryIntArray(Parcel parcel) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_MemoryIntArray$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public boolean isWritable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWritable", $$robo$$android_util_MemoryIntArray$isWritable(), 0, this);
    }

    public int get(int n) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("get", $$robo$$android_util_MemoryIntArray$get(int ), 0, this, n);
    }

    public void set(int n, int n2) throws IOException {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_util_MemoryIntArray$set(int int ), 0, this, n, n2);
    }

    public int size() throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_util_MemoryIntArray$size(), 0, this);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_util_MemoryIntArray$close(), 0, this);
    }

    public boolean isClosed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isClosed", $$robo$$android_util_MemoryIntArray$isClosed(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_util_MemoryIntArray$finalize(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_util_MemoryIntArray$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_util_MemoryIntArray$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_util_MemoryIntArray$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_util_MemoryIntArray$hashCode(), 0, this);
    }

    private void enforceNotClosed() {
        InvokeDynamicSupport.bootstrap("enforceNotClosed", $$robo$$android_util_MemoryIntArray$enforceNotClosed(), 0, this);
    }

    private void enforceValidIndex(int n) throws IOException {
        InvokeDynamicSupport.bootstrap("enforceValidIndex", $$robo$$android_util_MemoryIntArray$enforceValidIndex(int ), 0, this, n);
    }

    private void enforceWritable() {
        InvokeDynamicSupport.bootstrap("enforceWritable", $$robo$$android_util_MemoryIntArray$enforceWritable(), 0, this);
    }

    private final native /* synthetic */ int $$robo$$nativeCreate$nativeBinding(String var1, int var2);

    private int nativeCreate(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("nativeCreate", $$robo$$android_util_MemoryIntArray$nativeCreate(java.lang.String int ), 1, this, string2, n);
    }

    private final native /* synthetic */ long $$robo$$nativeOpen$nativeBinding(int var1, boolean var2);

    private long nativeOpen(int n, boolean bl) {
        return (long)InvokeDynamicSupport.bootstrap("nativeOpen", $$robo$$android_util_MemoryIntArray$nativeOpen(int boolean ), 1, this, n, bl);
    }

    private final native /* synthetic */ void $$robo$$nativeClose$nativeBinding(int var1, long var2, boolean var4);

    private void nativeClose(int n, long l, boolean bl) {
        InvokeDynamicSupport.bootstrap("nativeClose", $$robo$$android_util_MemoryIntArray$nativeClose(int long boolean ), 1, this, n, l, bl);
    }

    private final native /* synthetic */ int $$robo$$nativeGet$nativeBinding(int var1, long var2, int var4);

    private int nativeGet(int n, long l, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("nativeGet", $$robo$$android_util_MemoryIntArray$nativeGet(int long int ), 1, this, n, l, n2);
    }

    private final native /* synthetic */ void $$robo$$nativeSet$nativeBinding(int var1, long var2, int var4, int var5);

    private void nativeSet(int n, long l, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("nativeSet", $$robo$$android_util_MemoryIntArray$nativeSet(int long int int ), 1, this, n, l, n2, n3);
    }

    private final native /* synthetic */ int $$robo$$nativeSize$nativeBinding(int var1);

    private int nativeSize(int n) {
        return (int)InvokeDynamicSupport.bootstrap("nativeSize", $$robo$$android_util_MemoryIntArray$nativeSize(int ), 1, this, n);
    }

    public static int getMaxSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaxSize", $$robo$$android_util_MemoryIntArray$getMaxSize(), 0);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) throws IOException {
        this.$$robo$$android_util_MemoryIntArray$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(MemoryIntArray.class);
    }

    public /* synthetic */ MemoryIntArray() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MemoryIntArray)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

