/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.BackupUtils;
import android.util.Log;
import android.util.Range;
import com.android.internal.annotations.VisibleForTesting;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ProtocolException;
import java.time.Clock;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RecurrenceRule
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "RecurrenceRule";
    private static boolean LOGD;
    private static int VERSION_INIT = 0;
    @VisibleForTesting
    public static Clock sClock;
    public ZonedDateTime start;
    public ZonedDateTime end;
    public Period period;
    public static Parcelable.Creator<RecurrenceRule> CREATOR;

    private void $$robo$$android_util_RecurrenceRule$__constructor__(ZonedDateTime start, ZonedDateTime end, Period period) {
        this.start = start;
        this.end = end;
        this.period = period;
    }

    @Deprecated
    private static final RecurrenceRule $$robo$$android_util_RecurrenceRule$buildNever() {
        return new RecurrenceRule(null, null, null);
    }

    @Deprecated
    private static final RecurrenceRule $$robo$$android_util_RecurrenceRule$buildRecurringMonthly(int dayOfMonth, ZoneId zone) {
        ZonedDateTime now = ZonedDateTime.now(sClock).withZoneSameInstant(zone);
        ZonedDateTime start = ZonedDateTime.of(now.toLocalDate().minusYears(1L).withMonth(1).withDayOfMonth(dayOfMonth), LocalTime.MIDNIGHT, zone);
        return new RecurrenceRule(start, null, Period.ofMonths(1));
    }

    private void $$robo$$android_util_RecurrenceRule$__constructor__(Parcel source) {
        this.start = RecurrenceRule.convertZonedDateTime(source.readString());
        this.end = RecurrenceRule.convertZonedDateTime(source.readString());
        this.period = RecurrenceRule.convertPeriod(source.readString());
    }

    private final int $$robo$$android_util_RecurrenceRule$describeContents() {
        return 0;
    }

    private final void $$robo$$android_util_RecurrenceRule$writeToParcel(Parcel dest, int flags) {
        dest.writeString(RecurrenceRule.convertZonedDateTime(this.start));
        dest.writeString(RecurrenceRule.convertZonedDateTime(this.end));
        dest.writeString(RecurrenceRule.convertPeriod(this.period));
    }

    private void $$robo$$android_util_RecurrenceRule$__constructor__(DataInputStream in) throws IOException {
        int version = in.readInt();
        switch (version) {
            case 0: {
                this.start = RecurrenceRule.convertZonedDateTime(BackupUtils.readString(in));
                this.end = RecurrenceRule.convertZonedDateTime(BackupUtils.readString(in));
                this.period = RecurrenceRule.convertPeriod(BackupUtils.readString(in));
                break;
            }
            default: {
                throw new ProtocolException("Unknown version " + version);
            }
        }
    }

    private final void $$robo$$android_util_RecurrenceRule$writeToStream(DataOutputStream out) throws IOException {
        out.writeInt(0);
        BackupUtils.writeString(out, RecurrenceRule.convertZonedDateTime(this.start));
        BackupUtils.writeString(out, RecurrenceRule.convertZonedDateTime(this.end));
        BackupUtils.writeString(out, RecurrenceRule.convertPeriod(this.period));
    }

    private final String $$robo$$android_util_RecurrenceRule$toString() {
        return "RecurrenceRule{" + "start=" + this.start + " end=" + this.end + " period=" + this.period + "}";
    }

    private final int $$robo$$android_util_RecurrenceRule$hashCode() {
        return Objects.hash(this.start, this.end, this.period);
    }

    private final boolean $$robo$$android_util_RecurrenceRule$equals(Object obj) {
        if (obj instanceof RecurrenceRule) {
            RecurrenceRule other = (RecurrenceRule)obj;
            return Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.period, other.period);
        }
        return false;
    }

    private final boolean $$robo$$android_util_RecurrenceRule$isRecurring() {
        return this.period != null;
    }

    @Deprecated
    private final boolean $$robo$$android_util_RecurrenceRule$isMonthly() {
        return this.start != null && this.period != null && this.period.getYears() == 0 && this.period.getMonths() == 1 && this.period.getDays() == 0;
    }

    private final Iterator<Range<ZonedDateTime>> $$robo$$android_util_RecurrenceRule$cycleIterator() {
        if (this.period != null) {
            return new RecurringIterator(this);
        }
        return new NonrecurringIterator(this);
    }

    private static final String $$robo$$android_util_RecurrenceRule$convertZonedDateTime(ZonedDateTime time) {
        return time != null ? time.toString() : null;
    }

    private static final ZonedDateTime $$robo$$android_util_RecurrenceRule$convertZonedDateTime(String time) {
        return time != null ? ZonedDateTime.parse(time) : null;
    }

    private static final String $$robo$$android_util_RecurrenceRule$convertPeriod(Period period) {
        return period != null ? period.toString() : null;
    }

    private static final Period $$robo$$android_util_RecurrenceRule$convertPeriod(String period) {
        return period != null ? Period.parse(period) : null;
    }

    private /* synthetic */ void $$robo$$android_util_RecurrenceRule$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        LOGD = Log.isLoggable("RecurrenceRule", 3);
        sClock = Clock.systemDefaultZone();
        CREATOR = new Parcelable.Creator<RecurrenceRule>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_util_RecurrenceRule_1$__constructor__() {
            }

            private final RecurrenceRule $$robo$$android_util_RecurrenceRule_1$createFromParcel(Parcel source) {
                return new RecurrenceRule(source);
            }

            private final RecurrenceRule[] $$robo$$android_util_RecurrenceRule_1$newArray(int size) {
                return new RecurrenceRule[size];
            }

            private void __constructor__() {
                this.$$robo$$android_util_RecurrenceRule_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_RecurrenceRule_1$__constructor__(), 0, this);
            }

            @Override
            public RecurrenceRule createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_util_RecurrenceRule_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public RecurrenceRule[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_util_RecurrenceRule_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2, Period period) {
        this.$$robo$$android_util_RecurrenceRule$__constructor__(zonedDateTime, zonedDateTime2, period);
    }

    public RecurrenceRule(ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2, Period period) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_RecurrenceRule$__constructor__(java.time.ZonedDateTime java.time.ZonedDateTime java.time.Period ), 0, this, zonedDateTime, zonedDateTime2, period);
    }

    @Deprecated
    public static RecurrenceRule buildNever() {
        return InvokeDynamicSupport.bootstrapStatic("buildNever", $$robo$$android_util_RecurrenceRule$buildNever(), 0);
    }

    @Deprecated
    public static RecurrenceRule buildRecurringMonthly(int n, ZoneId zoneId) {
        return InvokeDynamicSupport.bootstrapStatic("buildRecurringMonthly", $$robo$$android_util_RecurrenceRule$buildRecurringMonthly(int java.time.ZoneId ), 0, (int)n, (ZoneId)zoneId);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_util_RecurrenceRule$__constructor__(parcel);
    }

    private RecurrenceRule(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_RecurrenceRule$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_util_RecurrenceRule$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_util_RecurrenceRule$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private void __constructor__(DataInputStream dataInputStream) throws IOException {
        this.$$robo$$android_util_RecurrenceRule$__constructor__(dataInputStream);
    }

    public RecurrenceRule(DataInputStream dataInputStream) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_RecurrenceRule$__constructor__(java.io.DataInputStream ), 0, this, dataInputStream);
    }

    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("writeToStream", $$robo$$android_util_RecurrenceRule$writeToStream(java.io.DataOutputStream ), 0, this, dataOutputStream);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_util_RecurrenceRule$toString(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_util_RecurrenceRule$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_util_RecurrenceRule$equals(java.lang.Object ), 0, this, object);
    }

    public boolean isRecurring() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRecurring", $$robo$$android_util_RecurrenceRule$isRecurring(), 0, this);
    }

    @Deprecated
    public boolean isMonthly() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMonthly", $$robo$$android_util_RecurrenceRule$isMonthly(), 0, this);
    }

    public Iterator<Range<ZonedDateTime>> cycleIterator() {
        return InvokeDynamicSupport.bootstrap("cycleIterator", $$robo$$android_util_RecurrenceRule$cycleIterator(), 0, this);
    }

    public static String convertZonedDateTime(ZonedDateTime zonedDateTime) {
        return InvokeDynamicSupport.bootstrapStatic("convertZonedDateTime", $$robo$$android_util_RecurrenceRule$convertZonedDateTime(java.time.ZonedDateTime ), 0, (ZonedDateTime)zonedDateTime);
    }

    public static ZonedDateTime convertZonedDateTime(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("convertZonedDateTime", $$robo$$android_util_RecurrenceRule$convertZonedDateTime(java.lang.String ), 0, (String)string2);
    }

    public static String convertPeriod(Period period) {
        return InvokeDynamicSupport.bootstrapStatic("convertPeriod", $$robo$$android_util_RecurrenceRule$convertPeriod(java.time.Period ), 0, (Period)period);
    }

    public static Period convertPeriod(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("convertPeriod", $$robo$$android_util_RecurrenceRule$convertPeriod(java.lang.String ), 0, (String)string2);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_util_RecurrenceRule$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(RecurrenceRule.class);
    }

    public /* synthetic */ RecurrenceRule() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecurrenceRule)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class RecurringIterator
    implements Iterator<Range<ZonedDateTime>> {
        public transient /* synthetic */ Object __robo_data__;
        int i;
        ZonedDateTime cycleStart;
        ZonedDateTime cycleEnd;
        /* synthetic */ RecurrenceRule this$0;

        private void $$robo$$android_util_RecurrenceRule_RecurringIterator$__constructor__(RecurrenceRule recurrenceRule) {
            ZonedDateTime anchor;
            ZonedDateTime zonedDateTime = anchor = recurrenceRule.end != null ? recurrenceRule.end : ZonedDateTime.now(sClock).withZoneSameInstant(recurrenceRule.start.getZone());
            if (LOGD) {
                Log.d("RecurrenceRule", "Resolving using anchor " + anchor);
            }
            this.updateCycle();
            while (anchor.toEpochSecond() > this.cycleEnd.toEpochSecond()) {
                ++this.i;
                this.updateCycle();
            }
            while (anchor.toEpochSecond() <= this.cycleStart.toEpochSecond()) {
                --this.i;
                this.updateCycle();
            }
        }

        private final void $$robo$$android_util_RecurrenceRule_RecurringIterator$updateCycle() {
            this.cycleStart = this.roundBoundaryTime(this.this$0.start.plus(this.this$0.period.multipliedBy(this.i)));
            this.cycleEnd = this.roundBoundaryTime(this.this$0.start.plus(this.this$0.period.multipliedBy(this.i + 1)));
        }

        private final ZonedDateTime $$robo$$android_util_RecurrenceRule_RecurringIterator$roundBoundaryTime(ZonedDateTime boundary) {
            if (this.this$0.isMonthly() && boundary.getDayOfMonth() < this.this$0.start.getDayOfMonth()) {
                return ZonedDateTime.of(boundary.toLocalDate(), LocalTime.MAX, this.this$0.start.getZone());
            }
            return boundary;
        }

        private final boolean $$robo$$android_util_RecurrenceRule_RecurringIterator$hasNext() {
            return this.cycleStart.toEpochSecond() >= this.this$0.start.toEpochSecond();
        }

        private final Range<ZonedDateTime> $$robo$$android_util_RecurrenceRule_RecurringIterator$next() {
            if (LOGD) {
                Log.d("RecurrenceRule", "Cycle " + this.i + " from " + this.cycleStart + " to " + this.cycleEnd);
            }
            Range<ZonedDateTime> r = new Range<ZonedDateTime>(this.cycleStart, this.cycleEnd);
            --this.i;
            this.updateCycle();
            return r;
        }

        private void __constructor__(RecurrenceRule recurrenceRule) {
            this.$$robo$$android_util_RecurrenceRule_RecurringIterator$__constructor__(recurrenceRule);
        }

        public RecurringIterator(RecurrenceRule recurrenceRule) {
            this.this$0 = recurrenceRule;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_RecurrenceRule_RecurringIterator$__constructor__(android.util.RecurrenceRule ), 0, this, recurrenceRule);
        }

        private void updateCycle() {
            InvokeDynamicSupport.bootstrap("updateCycle", $$robo$$android_util_RecurrenceRule_RecurringIterator$updateCycle(), 0, this);
        }

        private ZonedDateTime roundBoundaryTime(ZonedDateTime zonedDateTime) {
            return InvokeDynamicSupport.bootstrap("roundBoundaryTime", $$robo$$android_util_RecurrenceRule_RecurringIterator$roundBoundaryTime(java.time.ZonedDateTime ), 0, this, zonedDateTime);
        }

        @Override
        public boolean hasNext() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasNext", $$robo$$android_util_RecurrenceRule_RecurringIterator$hasNext(), 0, this);
        }

        @Override
        public Range<ZonedDateTime> next() {
            return InvokeDynamicSupport.bootstrap("next", $$robo$$android_util_RecurrenceRule_RecurringIterator$next(), 0, this);
        }

        public /* synthetic */ RecurringIterator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecurringIterator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class NonrecurringIterator
    implements Iterator<Range<ZonedDateTime>> {
        public transient /* synthetic */ Object __robo_data__;
        boolean hasNext;
        /* synthetic */ RecurrenceRule this$0;

        private void $$robo$$android_util_RecurrenceRule_NonrecurringIterator$__constructor__(RecurrenceRule recurrenceRule) {
            this.hasNext = recurrenceRule.start != null && recurrenceRule.end != null;
        }

        private final boolean $$robo$$android_util_RecurrenceRule_NonrecurringIterator$hasNext() {
            return this.hasNext;
        }

        private final Range<ZonedDateTime> $$robo$$android_util_RecurrenceRule_NonrecurringIterator$next() {
            this.hasNext = false;
            return new Range<ZonedDateTime>(this.this$0.start, this.this$0.end);
        }

        private void __constructor__(RecurrenceRule recurrenceRule) {
            this.$$robo$$android_util_RecurrenceRule_NonrecurringIterator$__constructor__(recurrenceRule);
        }

        public NonrecurringIterator(RecurrenceRule recurrenceRule) {
            this.this$0 = recurrenceRule;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_RecurrenceRule_NonrecurringIterator$__constructor__(android.util.RecurrenceRule ), 0, this, recurrenceRule);
        }

        @Override
        public boolean hasNext() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasNext", $$robo$$android_util_RecurrenceRule_NonrecurringIterator$hasNext(), 0, this);
        }

        @Override
        public Range<ZonedDateTime> next() {
            return InvokeDynamicSupport.bootstrap("next", $$robo$$android_util_RecurrenceRule_NonrecurringIterator$next(), 0, this);
        }

        public /* synthetic */ NonrecurringIterator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NonrecurringIterator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

