/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Spline
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$android_util_Spline$__constructor__() {
    }

    public abstract float interpolate(float var1);

    private static final Spline $$robo$$android_util_Spline$createSpline(float[] x, float[] y) {
        if (!Spline.isStrictlyIncreasing(x)) {
            throw new IllegalArgumentException("The control points must all have strictly increasing X values.");
        }
        if (Spline.isMonotonic(y)) {
            return Spline.createMonotoneCubicSpline(x, y);
        }
        return Spline.createLinearSpline(x, y);
    }

    private static final Spline $$robo$$android_util_Spline$createMonotoneCubicSpline(float[] x, float[] y) {
        return new MonotoneCubicSpline(x, y);
    }

    private static final Spline $$robo$$android_util_Spline$createLinearSpline(float[] x, float[] y) {
        return new LinearSpline(x, y);
    }

    private static final boolean $$robo$$android_util_Spline$isStrictlyIncreasing(float[] x) {
        if (x == null || x.length < 2) {
            throw new IllegalArgumentException("There must be at least two control points.");
        }
        float prev = x[0];
        for (int i = 1; i < x.length; ++i) {
            float curr = x[i];
            if (curr <= prev) {
                return false;
            }
            prev = curr;
        }
        return true;
    }

    private static final boolean $$robo$$android_util_Spline$isMonotonic(float[] x) {
        if (x == null || x.length < 2) {
            throw new IllegalArgumentException("There must be at least two control points.");
        }
        float prev = x[0];
        for (int i = 1; i < x.length; ++i) {
            float curr = x[i];
            if (curr < prev) {
                return false;
            }
            prev = curr;
        }
        return true;
    }

    private void __constructor__() {
        this.$$robo$$android_util_Spline$__constructor__();
    }

    public Spline() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_Spline$__constructor__(), 0, this);
    }

    public static Spline createSpline(float[] fArray, float[] fArray2) {
        return InvokeDynamicSupport.bootstrapStatic("createSpline", $$robo$$android_util_Spline$createSpline(float[] float[] ), 0, (float[])fArray, (float[])fArray2);
    }

    public static Spline createMonotoneCubicSpline(float[] fArray, float[] fArray2) {
        return InvokeDynamicSupport.bootstrapStatic("createMonotoneCubicSpline", $$robo$$android_util_Spline$createMonotoneCubicSpline(float[] float[] ), 0, (float[])fArray, (float[])fArray2);
    }

    public static Spline createLinearSpline(float[] fArray, float[] fArray2) {
        return InvokeDynamicSupport.bootstrapStatic("createLinearSpline", $$robo$$android_util_Spline$createLinearSpline(float[] float[] ), 0, (float[])fArray, (float[])fArray2);
    }

    private static boolean isStrictlyIncreasing(float[] fArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isStrictlyIncreasing", $$robo$$android_util_Spline$isStrictlyIncreasing(float[] ), 0, (float[])fArray);
    }

    private static boolean isMonotonic(float[] fArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isMonotonic", $$robo$$android_util_Spline$isMonotonic(float[] ), 0, (float[])fArray);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Spline)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class LinearSpline
    extends Spline
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private float[] mX;
        private float[] mY;
        private float[] mM;

        private void $$robo$$android_util_Spline_LinearSpline$__constructor__(float[] x, float[] y) {
            if (x == null || y == null || x.length != y.length || x.length < 2) {
                throw new IllegalArgumentException("There must be at least two control points and the arrays must be of equal length.");
            }
            int N = x.length;
            this.mM = new float[N - 1];
            for (int i = 0; i < N - 1; ++i) {
                this.mM[i] = (y[i + 1] - y[i]) / (x[i + 1] - x[i]);
            }
            this.mX = x;
            this.mY = y;
        }

        private final float $$robo$$android_util_Spline_LinearSpline$interpolate(float x) {
            int n = this.mX.length;
            if (Float.isNaN(x)) {
                return x;
            }
            if (x <= this.mX[0]) {
                return this.mY[0];
            }
            if (x >= this.mX[n - 1]) {
                return this.mY[n - 1];
            }
            int i = 0;
            while (x >= this.mX[i + 1]) {
                if (x != this.mX[++i]) continue;
                return this.mY[i];
            }
            return this.mY[i] + this.mM[i] * (x - this.mX[i]);
        }

        private final String $$robo$$android_util_Spline_LinearSpline$toString() {
            StringBuilder str = new StringBuilder();
            int n = this.mX.length;
            str.append("LinearSpline{[");
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    str.append(", ");
                }
                str.append("(").append(this.mX[i]);
                str.append(", ").append(this.mY[i]);
                if (i < n - 1) {
                    str.append(": ").append(this.mM[i]);
                }
                str.append(")");
            }
            str.append("]}");
            return str.toString();
        }

        private void __constructor__(float[] fArray, float[] fArray2) {
            this.$$robo$$android_util_Spline_LinearSpline$__constructor__(fArray, fArray2);
        }

        public LinearSpline(float[] fArray, float[] fArray2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_Spline_LinearSpline$__constructor__(float[] float[] ), 0, this, fArray, fArray2);
        }

        @Override
        public float interpolate(float f) {
            return (float)InvokeDynamicSupport.bootstrap("interpolate", $$robo$$android_util_Spline_LinearSpline$interpolate(float ), 0, this, f);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_util_Spline_LinearSpline$toString(), 0, this);
        }

        public /* synthetic */ LinearSpline() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LinearSpline)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MonotoneCubicSpline
    extends Spline
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private float[] mX;
        private float[] mY;
        private float[] mM;

        private void $$robo$$android_util_Spline_MonotoneCubicSpline$__constructor__(float[] x, float[] y) {
            int i;
            if (x == null || y == null || x.length != y.length || x.length < 2) {
                throw new IllegalArgumentException("There must be at least two control points and the arrays must be of equal length.");
            }
            int n = x.length;
            float[] d = new float[n - 1];
            float[] m = new float[n];
            for (i = 0; i < n - 1; ++i) {
                float h = x[i + 1] - x[i];
                if (h <= 0.0f) {
                    throw new IllegalArgumentException("The control points must all have strictly increasing X values.");
                }
                d[i] = (y[i + 1] - y[i]) / h;
            }
            m[0] = d[0];
            for (i = 1; i < n - 1; ++i) {
                m[i] = (d[i - 1] + d[i]) * 0.5f;
            }
            m[n - 1] = d[n - 2];
            for (i = 0; i < n - 1; ++i) {
                if (d[i] == 0.0f) {
                    m[i] = 0.0f;
                    m[i + 1] = 0.0f;
                    continue;
                }
                float a = m[i] / d[i];
                float b = m[i + 1] / d[i];
                if (a < 0.0f || b < 0.0f) {
                    throw new IllegalArgumentException("The control points must have monotonic Y values.");
                }
                float h = (float)Math.hypot(a, b);
                if (!(h > 3.0f)) continue;
                float t = 3.0f / h;
                int n2 = i;
                m[n2] = m[n2] * t;
                int n3 = i + 1;
                m[n3] = m[n3] * t;
            }
            this.mX = x;
            this.mY = y;
            this.mM = m;
        }

        private final float $$robo$$android_util_Spline_MonotoneCubicSpline$interpolate(float x) {
            int n = this.mX.length;
            if (Float.isNaN(x)) {
                return x;
            }
            if (x <= this.mX[0]) {
                return this.mY[0];
            }
            if (x >= this.mX[n - 1]) {
                return this.mY[n - 1];
            }
            int i = 0;
            while (x >= this.mX[i + 1]) {
                if (x != this.mX[++i]) continue;
                return this.mY[i];
            }
            float h = this.mX[i + 1] - this.mX[i];
            float t = (x - this.mX[i]) / h;
            return (this.mY[i] * (1.0f + 2.0f * t) + h * this.mM[i] * t) * (1.0f - t) * (1.0f - t) + (this.mY[i + 1] * (3.0f - 2.0f * t) + h * this.mM[i + 1] * (t - 1.0f)) * t * t;
        }

        private final String $$robo$$android_util_Spline_MonotoneCubicSpline$toString() {
            StringBuilder str = new StringBuilder();
            int n = this.mX.length;
            str.append("MonotoneCubicSpline{[");
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    str.append(", ");
                }
                str.append("(").append(this.mX[i]);
                str.append(", ").append(this.mY[i]);
                str.append(": ").append(this.mM[i]).append(")");
            }
            str.append("]}");
            return str.toString();
        }

        private void __constructor__(float[] fArray, float[] fArray2) {
            this.$$robo$$android_util_Spline_MonotoneCubicSpline$__constructor__(fArray, fArray2);
        }

        public MonotoneCubicSpline(float[] fArray, float[] fArray2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_Spline_MonotoneCubicSpline$__constructor__(float[] float[] ), 0, this, fArray, fArray2);
        }

        @Override
        public float interpolate(float f) {
            return (float)InvokeDynamicSupport.bootstrap("interpolate", $$robo$$android_util_Spline_MonotoneCubicSpline$interpolate(float ), 0, this, f);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_util_Spline_MonotoneCubicSpline$toString(), 0, this);
        }

        public /* synthetic */ MonotoneCubicSpline() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MonotoneCubicSpline)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

