/*
 * Decompiled with CFR 0.152.
 */
package android.util.apk;

import android.content.pm.PackageParser;
import android.content.pm.Signature;
import android.os.Trace;
import android.util.apk.ApkSignatureSchemeV2Verifier;
import android.util.apk.ApkSignatureSchemeV3Verifier;
import android.util.apk.ByteBufferFactory;
import android.util.apk.SignatureNotFoundException;
import android.util.jar.StrictJarFile;
import com.android.internal.util.ArrayUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ApkSignatureVerifier
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static AtomicReference<byte[]> sBuffer;

    private void $$robo$$android_util_apk_ApkSignatureVerifier$__constructor__() {
    }

    private static final PackageParser.SigningDetails $$robo$$android_util_apk_ApkSignatureVerifier$verify(String apkPath, @PackageParser.SigningDetails.SignatureSchemeVersion int minSignatureSchemeVersion) throws PackageParser.PackageParserException {
        if (minSignatureSchemeVersion > 3) {
            throw new PackageParser.PackageParserException(-103, "No signature found in package of version " + minSignatureSchemeVersion + " or newer for package " + apkPath);
        }
        Trace.traceBegin(262144L, "verifyV3");
        try {
            ApkSignatureSchemeV3Verifier.VerifiedSigner vSigner = ApkSignatureSchemeV3Verifier.verify(apkPath);
            Certificate[][] signerCerts = new Certificate[][]{vSigner.certs};
            Signature[] signerSigs = ApkSignatureVerifier.convertToSignatures(signerCerts);
            Signature[] pastSignerSigs = null;
            int[] pastSignerSigsFlags = null;
            if (vSigner.por != null) {
                pastSignerSigs = new Signature[vSigner.por.certs.size()];
                pastSignerSigsFlags = new int[vSigner.por.flagsList.size()];
                for (int i = 0; i < pastSignerSigs.length; ++i) {
                    pastSignerSigs[i] = new Signature(vSigner.por.certs.get(i).getEncoded());
                    pastSignerSigsFlags[i] = vSigner.por.flagsList.get(i);
                }
            }
            PackageParser.SigningDetails signingDetails = new PackageParser.SigningDetails(signerSigs, 3, pastSignerSigs, pastSignerSigsFlags);
            return signingDetails;
        }
        catch (SignatureNotFoundException e) {
            if (minSignatureSchemeVersion >= 3) {
                throw new PackageParser.PackageParserException(-103, "No APK Signature Scheme v3 signature in package " + apkPath, e);
            }
        }
        catch (Exception e) {
            throw new PackageParser.PackageParserException(-103, "Failed to collect certificates from " + apkPath + " using APK Signature Scheme v3", e);
        }
        finally {
            Trace.traceEnd(262144L);
        }
        if (minSignatureSchemeVersion > 2) {
            throw new PackageParser.PackageParserException(-103, "No signature found in package of version " + minSignatureSchemeVersion + " or newer for package " + apkPath);
        }
        Trace.traceBegin(262144L, "verifyV2");
        try {
            Certificate[][] signerCerts = ApkSignatureSchemeV2Verifier.verify(apkPath);
            Signature[] signerSigs = ApkSignatureVerifier.convertToSignatures(signerCerts);
            PackageParser.SigningDetails signingDetails = new PackageParser.SigningDetails(signerSigs, 2);
            return signingDetails;
        }
        catch (SignatureNotFoundException e) {
            if (minSignatureSchemeVersion >= 2) {
                throw new PackageParser.PackageParserException(-103, "No APK Signature Scheme v2 signature in package " + apkPath, e);
            }
        }
        catch (Exception e) {
            throw new PackageParser.PackageParserException(-103, "Failed to collect certificates from " + apkPath + " using APK Signature Scheme v2", e);
        }
        finally {
            Trace.traceEnd(262144L);
        }
        if (minSignatureSchemeVersion > 1) {
            throw new PackageParser.PackageParserException(-103, "No signature found in package of version " + minSignatureSchemeVersion + " or newer for package " + apkPath);
        }
        return ApkSignatureVerifier.verifyV1Signature(apkPath, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final PackageParser.SigningDetails $$robo$$android_util_apk_ApkSignatureVerifier$verifyV1Signature(String apkPath, boolean verifyFull) throws PackageParser.PackageParserException {
        PackageParser.SigningDetails signingDetails;
        StrictJarFile jarFile = null;
        try {
            Trace.traceBegin(262144L, "strictJarFileCtor");
            jarFile = new StrictJarFile(apkPath, true, verifyFull);
            ArrayList<ZipEntry> toVerify = new ArrayList<ZipEntry>();
            ZipEntry manifestEntry = jarFile.findEntry("AndroidManifest.xml");
            if (manifestEntry == null) {
                throw new PackageParser.PackageParserException(-101, "Package " + apkPath + " has no manifest");
            }
            Certificate[][] lastCerts = ApkSignatureVerifier.loadCertificates(jarFile, manifestEntry);
            if (ArrayUtils.isEmpty(lastCerts)) {
                throw new PackageParser.PackageParserException(-103, "Package " + apkPath + " has no certificates at entry " + "AndroidManifest.xml");
            }
            Signature[] lastSigs = ApkSignatureVerifier.convertToSignatures(lastCerts);
            if (verifyFull) {
                Iterator<ZipEntry> i = jarFile.iterator();
                while (i.hasNext()) {
                    String entryName;
                    ZipEntry entry = i.next();
                    if (entry.isDirectory() || (entryName = entry.getName()).startsWith("META-INF/") || entryName.equals("AndroidManifest.xml")) continue;
                    toVerify.add(entry);
                }
                for (ZipEntry entry : toVerify) {
                    Certificate[][] entryCerts = ApkSignatureVerifier.loadCertificates(jarFile, entry);
                    if (ArrayUtils.isEmpty(entryCerts)) {
                        throw new PackageParser.PackageParserException(-103, "Package " + apkPath + " has no certificates at entry " + entry.getName());
                    }
                    Signature[] entrySigs = ApkSignatureVerifier.convertToSignatures(entryCerts);
                    if (Signature.areExactMatch(lastSigs, entrySigs)) continue;
                    throw new PackageParser.PackageParserException(-104, "Package " + apkPath + " has mismatched certificates at entry " + entry.getName());
                }
            }
            signingDetails = new PackageParser.SigningDetails(lastSigs, 1);
        }
        catch (GeneralSecurityException e) {
            try {
                throw new PackageParser.PackageParserException(-105, "Failed to collect certificates from " + apkPath, e);
                catch (IOException | RuntimeException e2) {
                    throw new PackageParser.PackageParserException(-103, "Failed to collect certificates from " + apkPath, e2);
                }
            }
            catch (Throwable throwable) {
                Trace.traceEnd(262144L);
                ApkSignatureVerifier.closeQuietly(jarFile);
                throw throwable;
            }
        }
        Trace.traceEnd(262144L);
        ApkSignatureVerifier.closeQuietly(jarFile);
        return signingDetails;
    }

    private static final Certificate[][] $$robo$$android_util_apk_ApkSignatureVerifier$loadCertificates(StrictJarFile jarFile, ZipEntry entry) throws PackageParser.PackageParserException {
        InputStream is = null;
        try {
            is = jarFile.getInputStream(entry);
            ApkSignatureVerifier.readFullyIgnoringContents(is);
            Certificate[][] certificateArray = jarFile.getCertificateChains(entry);
            return certificateArray;
        }
        catch (IOException | RuntimeException e) {
            throw new PackageParser.PackageParserException(-102, "Failed reading " + entry.getName() + " in " + jarFile, e);
        }
        finally {
            IoUtils.closeQuietly(is);
        }
    }

    private static final void $$robo$$android_util_apk_ApkSignatureVerifier$readFullyIgnoringContents(InputStream in) throws IOException {
        byte[] buffer = sBuffer.getAndSet(null);
        if (buffer == null) {
            buffer = new byte[4096];
        }
        int n = 0;
        int count = 0;
        while ((n = in.read(buffer, 0, buffer.length)) != -1) {
            count += n;
        }
        sBuffer.set(buffer);
    }

    private static final Signature[] $$robo$$android_util_apk_ApkSignatureVerifier$convertToSignatures(Certificate[][] certs) throws CertificateEncodingException {
        Signature[] res = new Signature[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            res[i] = new Signature(certs[i]);
        }
        return res;
    }

    private static final void $$robo$$android_util_apk_ApkSignatureVerifier$closeQuietly(StrictJarFile jarFile) {
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final PackageParser.SigningDetails $$robo$$android_util_apk_ApkSignatureVerifier$plsCertsNoVerifyOnlyCerts(String apkPath, int minSignatureSchemeVersion) throws PackageParser.PackageParserException {
        if (minSignatureSchemeVersion > 3) {
            throw new PackageParser.PackageParserException(-103, "No signature found in package of version " + minSignatureSchemeVersion + " or newer for package " + apkPath);
        }
        Trace.traceBegin(262144L, "certsOnlyV3");
        try {
            ApkSignatureSchemeV3Verifier.VerifiedSigner vSigner = ApkSignatureSchemeV3Verifier.plsCertsNoVerifyOnlyCerts(apkPath);
            Certificate[][] signerCerts = new Certificate[][]{vSigner.certs};
            Signature[] signerSigs = ApkSignatureVerifier.convertToSignatures(signerCerts);
            Signature[] pastSignerSigs = null;
            int[] pastSignerSigsFlags = null;
            if (vSigner.por != null) {
                pastSignerSigs = new Signature[vSigner.por.certs.size()];
                pastSignerSigsFlags = new int[vSigner.por.flagsList.size()];
                for (int i = 0; i < pastSignerSigs.length; ++i) {
                    pastSignerSigs[i] = new Signature(vSigner.por.certs.get(i).getEncoded());
                    pastSignerSigsFlags[i] = vSigner.por.flagsList.get(i);
                }
            }
            PackageParser.SigningDetails signingDetails = new PackageParser.SigningDetails(signerSigs, 3, pastSignerSigs, pastSignerSigsFlags);
            return signingDetails;
        }
        catch (SignatureNotFoundException e) {
            if (minSignatureSchemeVersion >= 3) {
                throw new PackageParser.PackageParserException(-103, "No APK Signature Scheme v3 signature in package " + apkPath, e);
            }
        }
        catch (Exception e) {
            throw new PackageParser.PackageParserException(-103, "Failed to collect certificates from " + apkPath + " using APK Signature Scheme v3", e);
        }
        finally {
            Trace.traceEnd(262144L);
        }
        if (minSignatureSchemeVersion > 2) {
            throw new PackageParser.PackageParserException(-103, "No signature found in package of version " + minSignatureSchemeVersion + " or newer for package " + apkPath);
        }
        Trace.traceBegin(262144L, "certsOnlyV2");
        try {
            Certificate[][] signerCerts = ApkSignatureSchemeV2Verifier.plsCertsNoVerifyOnlyCerts(apkPath);
            Signature[] signerSigs = ApkSignatureVerifier.convertToSignatures(signerCerts);
            PackageParser.SigningDetails signingDetails = new PackageParser.SigningDetails(signerSigs, 2);
            return signingDetails;
        }
        catch (SignatureNotFoundException e) {
            if (minSignatureSchemeVersion >= 2) {
                throw new PackageParser.PackageParserException(-103, "No APK Signature Scheme v2 signature in package " + apkPath, e);
            }
        }
        catch (Exception e) {
            throw new PackageParser.PackageParserException(-103, "Failed to collect certificates from " + apkPath + " using APK Signature Scheme v2", e);
        }
        finally {
            Trace.traceEnd(262144L);
        }
        if (minSignatureSchemeVersion > 1) {
            throw new PackageParser.PackageParserException(-103, "No signature found in package of version " + minSignatureSchemeVersion + " or newer for package " + apkPath);
        }
        return ApkSignatureVerifier.verifyV1Signature(apkPath, false);
    }

    private static final byte[] $$robo$$android_util_apk_ApkSignatureVerifier$getVerityRootHash(String apkPath) throws IOException, SignatureNotFoundException, SecurityException {
        try {
            return ApkSignatureSchemeV3Verifier.getVerityRootHash(apkPath);
        }
        catch (SignatureNotFoundException signatureNotFoundException) {
            return ApkSignatureSchemeV2Verifier.getVerityRootHash(apkPath);
        }
    }

    private static final byte[] $$robo$$android_util_apk_ApkSignatureVerifier$generateApkVerity(String apkPath, ByteBufferFactory bufferFactory) throws IOException, SignatureNotFoundException, SecurityException, DigestException, NoSuchAlgorithmException {
        try {
            return ApkSignatureSchemeV3Verifier.generateApkVerity(apkPath, bufferFactory);
        }
        catch (SignatureNotFoundException signatureNotFoundException) {
            return ApkSignatureSchemeV2Verifier.generateApkVerity(apkPath, bufferFactory);
        }
    }

    private static final byte[] $$robo$$android_util_apk_ApkSignatureVerifier$generateFsverityRootHash(String apkPath) throws NoSuchAlgorithmException, DigestException, IOException {
        try {
            return ApkSignatureSchemeV3Verifier.generateFsverityRootHash(apkPath);
        }
        catch (SignatureNotFoundException signatureNotFoundException) {
            try {
                return ApkSignatureSchemeV2Verifier.generateFsverityRootHash(apkPath);
            }
            catch (SignatureNotFoundException e) {
                return null;
            }
        }
    }

    static void __staticInitializer__() {
        sBuffer = new AtomicReference();
    }

    private void __constructor__() {
        this.$$robo$$android_util_apk_ApkSignatureVerifier$__constructor__();
    }

    public ApkSignatureVerifier() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_apk_ApkSignatureVerifier$__constructor__(), 0, this);
    }

    public static PackageParser.SigningDetails verify(String string2, int n) throws PackageParser.PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("verify", $$robo$$android_util_apk_ApkSignatureVerifier$verify(java.lang.String int ), 0, (String)string2, (int)n);
    }

    private static PackageParser.SigningDetails verifyV1Signature(String string2, boolean bl) throws PackageParser.PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("verifyV1Signature", $$robo$$android_util_apk_ApkSignatureVerifier$verifyV1Signature(java.lang.String boolean ), 0, (String)string2, (boolean)bl);
    }

    private static Certificate[][] loadCertificates(StrictJarFile strictJarFile, ZipEntry zipEntry) throws PackageParser.PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("loadCertificates", $$robo$$android_util_apk_ApkSignatureVerifier$loadCertificates(android.util.jar.StrictJarFile java.util.zip.ZipEntry ), 0, (StrictJarFile)strictJarFile, (ZipEntry)zipEntry);
    }

    private static void readFullyIgnoringContents(InputStream inputStream) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("readFullyIgnoringContents", $$robo$$android_util_apk_ApkSignatureVerifier$readFullyIgnoringContents(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    public static Signature[] convertToSignatures(Certificate[][] certificateArray) throws CertificateEncodingException {
        return InvokeDynamicSupport.bootstrapStatic("convertToSignatures", $$robo$$android_util_apk_ApkSignatureVerifier$convertToSignatures(java.security.cert.Certificate[][] ), 0, (Certificate[][])certificateArray);
    }

    private static void closeQuietly(StrictJarFile strictJarFile) {
        InvokeDynamicSupport.bootstrapStatic("closeQuietly", $$robo$$android_util_apk_ApkSignatureVerifier$closeQuietly(android.util.jar.StrictJarFile ), 0, (StrictJarFile)strictJarFile);
    }

    public static PackageParser.SigningDetails plsCertsNoVerifyOnlyCerts(String string2, int n) throws PackageParser.PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("plsCertsNoVerifyOnlyCerts", $$robo$$android_util_apk_ApkSignatureVerifier$plsCertsNoVerifyOnlyCerts(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public static byte[] getVerityRootHash(String string2) throws IOException, SignatureNotFoundException, SecurityException {
        return InvokeDynamicSupport.bootstrapStatic("getVerityRootHash", $$robo$$android_util_apk_ApkSignatureVerifier$getVerityRootHash(java.lang.String ), 0, (String)string2);
    }

    public static byte[] generateApkVerity(String string2, ByteBufferFactory byteBufferFactory) throws IOException, SignatureNotFoundException, SecurityException, DigestException, NoSuchAlgorithmException {
        return InvokeDynamicSupport.bootstrapStatic("generateApkVerity", $$robo$$android_util_apk_ApkSignatureVerifier$generateApkVerity(java.lang.String android.util.apk.ByteBufferFactory ), 0, (String)string2, (ByteBufferFactory)byteBufferFactory);
    }

    public static byte[] generateFsverityRootHash(String string2) throws NoSuchAlgorithmException, DigestException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("generateFsverityRootHash", $$robo$$android_util_apk_ApkSignatureVerifier$generateFsverityRootHash(java.lang.String ), 0, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(ApkSignatureVerifier.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApkSignatureVerifier)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Result
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Certificate[][] certs;
        public Signature[] sigs;
        public int signatureSchemeVersion;

        private void $$robo$$android_util_apk_ApkSignatureVerifier_Result$__constructor__(Certificate[][] certs, Signature[] sigs, int signingVersion) {
            this.certs = certs;
            this.sigs = sigs;
            this.signatureSchemeVersion = signingVersion;
        }

        private void __constructor__(Certificate[][] certificateArray, Signature[] signatureArray, int n) {
            this.$$robo$$android_util_apk_ApkSignatureVerifier_Result$__constructor__(certificateArray, signatureArray, n);
        }

        public Result(Certificate[][] certificateArray, Signature[] signatureArray, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_apk_ApkSignatureVerifier_Result$__constructor__(java.security.cert.Certificate[][] android.content.pm.Signature[] int ), 0, this, certificateArray, signatureArray, n);
        }

        public /* synthetic */ Result() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Result)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

