/*
 * Decompiled with CFR 0.152.
 */
package android.util.apk;

import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.apk.DataDigester;
import android.util.apk.DataSource;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.DirectByteBuffer;
import java.security.DigestException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MemoryMappedFileDataSource
implements DataSource,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static long MEMORY_PAGE_SIZE_BYTES;
    private FileDescriptor mFd;
    private long mFilePosition;
    private long mSize;

    private void $$robo$$android_util_apk_MemoryMappedFileDataSource$__constructor__(FileDescriptor fd, long position, long size) {
        this.mFd = fd;
        this.mFilePosition = position;
        this.mSize = size;
    }

    private final long $$robo$$android_util_apk_MemoryMappedFileDataSource$size() {
        return this.mSize;
    }

    private final void $$robo$$android_util_apk_MemoryMappedFileDataSource$feedIntoDataDigester(DataDigester md, long offset, int size) throws IOException, DigestException {
        long filePosition = this.mFilePosition + offset;
        long mmapFilePosition = filePosition / MEMORY_PAGE_SIZE_BYTES * MEMORY_PAGE_SIZE_BYTES;
        int dataStartOffsetInMmapRegion = (int)(filePosition - mmapFilePosition);
        long mmapRegionSize = size + dataStartOffsetInMmapRegion;
        long mmapPtr = 0L;
        try {
            mmapPtr = Os.mmap(0L, mmapRegionSize, OsConstants.PROT_READ, OsConstants.MAP_SHARED | OsConstants.MAP_POPULATE, this.mFd, mmapFilePosition);
            DirectByteBuffer buf = new DirectByteBuffer(size, mmapPtr + (long)dataStartOffsetInMmapRegion, this.mFd, null, true);
            md.consume(buf);
        }
        catch (ErrnoException e) {
            throw new IOException("Failed to mmap " + mmapRegionSize + " bytes", e);
        }
        finally {
            if (mmapPtr != 0L) {
                try {
                    Os.munmap(mmapPtr, mmapRegionSize);
                }
                catch (ErrnoException errnoException) {}
            }
        }
    }

    static void __staticInitializer__() {
        MEMORY_PAGE_SIZE_BYTES = Os.sysconf(OsConstants._SC_PAGESIZE);
    }

    private void __constructor__(FileDescriptor fileDescriptor, long l, long l2) {
        this.$$robo$$android_util_apk_MemoryMappedFileDataSource$__constructor__(fileDescriptor, l, l2);
    }

    MemoryMappedFileDataSource(FileDescriptor fileDescriptor, long l, long l2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_apk_MemoryMappedFileDataSource$__constructor__(java.io.FileDescriptor long long ), 0, this, fileDescriptor, l, l2);
    }

    @Override
    public long size() {
        return (long)InvokeDynamicSupport.bootstrap("size", $$robo$$android_util_apk_MemoryMappedFileDataSource$size(), 0, this);
    }

    @Override
    public void feedIntoDataDigester(DataDigester dataDigester, long l, int n) throws IOException, DigestException {
        InvokeDynamicSupport.bootstrap("feedIntoDataDigester", $$robo$$android_util_apk_MemoryMappedFileDataSource$feedIntoDataDigester(android.util.apk.DataDigester long int ), 0, this, dataDigester, l, n);
    }

    static {
        RobolectricInternals.classInitializing(MemoryMappedFileDataSource.class);
    }

    public /* synthetic */ MemoryMappedFileDataSource() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MemoryMappedFileDataSource)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

