/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.Resources;
import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Pair;
import android.util.PathParser;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DisplayCutout
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "DisplayCutout";
    private static String BOTTOM_MARKER = "@bottom";
    private static String DP_MARKER = "@dp";
    private static String RIGHT_MARKER = "@right";
    public static String EMULATION_OVERLAY_CATEGORY = "com.android.internal.display_cutout_emulation";
    private static Rect ZERO_RECT;
    private static Region EMPTY_REGION;
    public static DisplayCutout NO_CUTOUT;
    private static Pair<Path, DisplayCutout> NULL_PAIR;
    private static Object CACHE_LOCK;
    @GuardedBy(value="CACHE_LOCK")
    private static String sCachedSpec;
    @GuardedBy(value="CACHE_LOCK")
    private static int sCachedDisplayWidth;
    @GuardedBy(value="CACHE_LOCK")
    private static int sCachedDisplayHeight;
    @GuardedBy(value="CACHE_LOCK")
    private static float sCachedDensity;
    @GuardedBy(value="CACHE_LOCK")
    private static Pair<Path, DisplayCutout> sCachedCutout;
    private Rect mSafeInsets;
    private Region mBounds;

    private void $$robo$$android_view_DisplayCutout$__constructor__(Rect safeInsets, List<Rect> boundingRects) {
    }

    private void $$robo$$android_view_DisplayCutout$__constructor__(Rect safeInsets, Region bounds, boolean copyArguments) {
        Rect rect = safeInsets == null ? ZERO_RECT : (this.mSafeInsets = copyArguments ? new Rect(safeInsets) : safeInsets);
        this.mBounds = bounds == null ? Region.obtain() : (copyArguments ? Region.obtain(bounds) : bounds);
    }

    private final boolean $$robo$$android_view_DisplayCutout$isEmpty() {
        return this.mSafeInsets.equals(ZERO_RECT);
    }

    private final boolean $$robo$$android_view_DisplayCutout$isBoundsEmpty() {
        return this.mBounds.isEmpty();
    }

    private final int $$robo$$android_view_DisplayCutout$getSafeInsetTop() {
        return this.mSafeInsets.top;
    }

    private final int $$robo$$android_view_DisplayCutout$getSafeInsetBottom() {
        return this.mSafeInsets.bottom;
    }

    private final int $$robo$$android_view_DisplayCutout$getSafeInsetLeft() {
        return this.mSafeInsets.left;
    }

    private final int $$robo$$android_view_DisplayCutout$getSafeInsetRight() {
        return this.mSafeInsets.right;
    }

    private final Rect $$robo$$android_view_DisplayCutout$getSafeInsets() {
        return new Rect(this.mSafeInsets);
    }

    private final Region $$robo$$android_view_DisplayCutout$getBounds() {
        return Region.obtain(this.mBounds);
    }

    private final List<Rect> $$robo$$android_view_DisplayCutout$getBoundingRects() {
        ArrayList<Rect> result = new ArrayList<Rect>();
        Region bounds = Region.obtain();
        bounds.set(this.mBounds);
        bounds.op(0, 0, Integer.MAX_VALUE, this.getSafeInsetTop(), Region.Op.INTERSECT);
        if (!bounds.isEmpty()) {
            result.add(bounds.getBounds());
        }
        bounds.set(this.mBounds);
        bounds.op(0, 0, this.getSafeInsetLeft(), Integer.MAX_VALUE, Region.Op.INTERSECT);
        if (!bounds.isEmpty()) {
            result.add(bounds.getBounds());
        }
        bounds.set(this.mBounds);
        bounds.op(this.getSafeInsetLeft() + 1, this.getSafeInsetTop() + 1, Integer.MAX_VALUE, Integer.MAX_VALUE, Region.Op.INTERSECT);
        if (!bounds.isEmpty()) {
            result.add(bounds.getBounds());
        }
        bounds.recycle();
        return result;
    }

    private final int $$robo$$android_view_DisplayCutout$hashCode() {
        int result = this.mSafeInsets.hashCode();
        result = result * 31 + this.mBounds.getBounds().hashCode();
        return result;
    }

    private final boolean $$robo$$android_view_DisplayCutout$equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DisplayCutout) {
            DisplayCutout c = (DisplayCutout)o;
            return this.mSafeInsets.equals(c.mSafeInsets) && this.mBounds.equals(c.mBounds);
        }
        return false;
    }

    private final String $$robo$$android_view_DisplayCutout$toString() {
        return "DisplayCutout{insets=" + this.mSafeInsets + " boundingRect=" + this.mBounds.getBounds() + "}";
    }

    private final void $$robo$$android_view_DisplayCutout$writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        this.mSafeInsets.writeToProto(proto, 0x10B00000001L);
        this.mBounds.getBounds().writeToProto(proto, 1146756268034L);
        proto.end(token);
    }

    private final DisplayCutout $$robo$$android_view_DisplayCutout$inset(int insetLeft, int insetTop, int insetRight, int insetBottom) {
        if (this.mBounds.isEmpty() || insetLeft == 0 && insetTop == 0 && insetRight == 0 && insetBottom == 0) {
            return this;
        }
        Rect safeInsets = new Rect(this.mSafeInsets);
        Region bounds = Region.obtain(this.mBounds);
        if (insetTop > 0 || safeInsets.top > 0) {
            safeInsets.top = DisplayCutout.atLeastZero(safeInsets.top - insetTop);
        }
        if (insetBottom > 0 || safeInsets.bottom > 0) {
            safeInsets.bottom = DisplayCutout.atLeastZero(safeInsets.bottom - insetBottom);
        }
        if (insetLeft > 0 || safeInsets.left > 0) {
            safeInsets.left = DisplayCutout.atLeastZero(safeInsets.left - insetLeft);
        }
        if (insetRight > 0 || safeInsets.right > 0) {
            safeInsets.right = DisplayCutout.atLeastZero(safeInsets.right - insetRight);
        }
        bounds.translate(-insetLeft, -insetTop);
        return new DisplayCutout(safeInsets, bounds, false);
    }

    private final DisplayCutout $$robo$$android_view_DisplayCutout$replaceSafeInsets(Rect safeInsets) {
        return new DisplayCutout(new Rect(safeInsets), this.mBounds, false);
    }

    private static final int $$robo$$android_view_DisplayCutout$atLeastZero(int value) {
        return value < 0 ? 0 : value;
    }

    private static final DisplayCutout $$robo$$android_view_DisplayCutout$fromBoundingRect(int left, int top, int right, int bottom) {
        Region r = Region.obtain();
        r.set(left, top, right, bottom);
        return DisplayCutout.fromBounds(r);
    }

    private static final DisplayCutout $$robo$$android_view_DisplayCutout$fromBounds(Region region) {
        return new DisplayCutout(ZERO_RECT, region, false);
    }

    private static final DisplayCutout $$robo$$android_view_DisplayCutout$fromResourcesRectApproximation(Resources res, int displayWidth, int displayHeight) {
        return DisplayCutout.fromSpec(res.getString(17039694), displayWidth, displayHeight, (float)DisplayMetrics.DENSITY_DEVICE_STABLE / 160.0f);
    }

    private static final Path $$robo$$android_view_DisplayCutout$pathFromResources(Resources res, int displayWidth, int displayHeight) {
        return (Path)DisplayCutout.pathAndDisplayCutoutFromSpec((String)res.getString((int)17039693), (int)displayWidth, (int)displayHeight, (float)((float)DisplayMetrics.DENSITY_DEVICE_STABLE / 160.0f)).first;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    private static final DisplayCutout $$robo$$android_view_DisplayCutout$fromSpec(String spec, int displayWidth, int displayHeight, float density) {
        return (DisplayCutout)DisplayCutout.pathAndDisplayCutoutFromSpec((String)spec, (int)displayWidth, (int)displayHeight, (float)density).second;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Pair<Path, DisplayCutout> $$robo$$android_view_DisplayCutout$pathAndDisplayCutoutFromSpec(String spec, int displayWidth, int displayHeight, float density) {
        Path p;
        float offsetX;
        if (TextUtils.isEmpty(spec)) {
            return NULL_PAIR;
        }
        Object object = CACHE_LOCK;
        synchronized (object) {
            if (spec.equals(sCachedSpec) && sCachedDisplayWidth == displayWidth && sCachedDisplayHeight == displayHeight && sCachedDensity == density) {
                return sCachedCutout;
            }
        }
        spec = spec.trim();
        if (spec.endsWith("@right")) {
            offsetX = displayWidth;
            spec = spec.substring(0, spec.length() - "@right".length()).trim();
        } else {
            offsetX = (float)displayWidth / 2.0f;
        }
        boolean inDp = spec.endsWith("@dp");
        if (inDp) {
            spec = spec.substring(0, spec.length() - "@dp".length());
        }
        String bottomSpec = null;
        if (spec.contains("@bottom")) {
            String[] splits = spec.split("@bottom", 2);
            spec = splits[0].trim();
            bottomSpec = splits[1].trim();
        }
        Region r = Region.obtain();
        try {
            p = PathParser.createPathFromPathData(spec);
        }
        catch (Throwable e) {
            Log.wtf("DisplayCutout", "Could not inflate cutout: ", e);
            return NULL_PAIR;
        }
        Matrix m = new Matrix();
        if (inDp) {
            m.postScale(density, density);
        }
        m.postTranslate(offsetX, 0.0f);
        p.transform(m);
        DisplayCutout.addToRegion(p, r);
        if (bottomSpec != null) {
            Path bottomPath;
            try {
                bottomPath = PathParser.createPathFromPathData(bottomSpec);
            }
            catch (Throwable e) {
                Log.wtf("DisplayCutout", "Could not inflate bottom cutout: ", e);
                return NULL_PAIR;
            }
            m.postTranslate(0.0f, displayHeight);
            bottomPath.transform(m);
            p.addPath(bottomPath);
            DisplayCutout.addToRegion(bottomPath, r);
        }
        Pair<Path, DisplayCutout> result = new Pair<Path, DisplayCutout>(p, DisplayCutout.fromBounds(r));
        Object object2 = CACHE_LOCK;
        synchronized (object2) {
            sCachedSpec = spec;
            sCachedDisplayWidth = displayWidth;
            sCachedDisplayHeight = displayHeight;
            sCachedDensity = density;
            sCachedCutout = result;
        }
        return result;
    }

    private static final void $$robo$$android_view_DisplayCutout$addToRegion(Path p, Region r) {
        RectF rectF = new RectF();
        Rect rect = new Rect();
        p.computeBounds(rectF, false);
        rectF.round(rect);
        r.op(rect, Region.Op.UNION);
    }

    private static final Region $$robo$$android_view_DisplayCutout$boundingRectsToRegion(List<Rect> rects) {
        Region result = Region.obtain();
        if (rects != null) {
            for (Rect r : rects) {
                result.op(r, Region.Op.UNION);
            }
        }
        return result;
    }

    private /* synthetic */ void $$robo$$android_view_DisplayCutout$__constructor__(Rect x0, Region x1, boolean x2, 1 x3) {
    }

    static void __staticInitializer__() {
        ZERO_RECT = new Rect();
        EMPTY_REGION = new Region();
        NO_CUTOUT = new DisplayCutout(ZERO_RECT, EMPTY_REGION, false);
        NULL_PAIR = new Pair<Object, Object>(null, null);
        CACHE_LOCK = new Object();
        sCachedCutout = NULL_PAIR;
    }

    private void __constructor__(Rect rect, List<Rect> list) {
        this.$$robo$$android_view_DisplayCutout$__constructor__(rect, list);
    }

    public DisplayCutout(Rect rect, List<Rect> list) {
        this(rect != null ? new Rect(rect) : ZERO_RECT, DisplayCutout.boundingRectsToRegion(list), true);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_DisplayCutout$__constructor__(android.graphics.Rect java.util.List<android.graphics.Rect> ), 0, this, rect, list);
    }

    private void __constructor__(Rect rect, Region region, boolean bl) {
        this.$$robo$$android_view_DisplayCutout$__constructor__(rect, region, bl);
    }

    private DisplayCutout(Rect rect, Region region, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_DisplayCutout$__constructor__(android.graphics.Rect android.graphics.Region boolean ), 0, this, rect, region, bl);
    }

    public boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_view_DisplayCutout$isEmpty(), 0, this);
    }

    public boolean isBoundsEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBoundsEmpty", $$robo$$android_view_DisplayCutout$isBoundsEmpty(), 0, this);
    }

    public int getSafeInsetTop() {
        return (int)InvokeDynamicSupport.bootstrap("getSafeInsetTop", $$robo$$android_view_DisplayCutout$getSafeInsetTop(), 0, this);
    }

    public int getSafeInsetBottom() {
        return (int)InvokeDynamicSupport.bootstrap("getSafeInsetBottom", $$robo$$android_view_DisplayCutout$getSafeInsetBottom(), 0, this);
    }

    public int getSafeInsetLeft() {
        return (int)InvokeDynamicSupport.bootstrap("getSafeInsetLeft", $$robo$$android_view_DisplayCutout$getSafeInsetLeft(), 0, this);
    }

    public int getSafeInsetRight() {
        return (int)InvokeDynamicSupport.bootstrap("getSafeInsetRight", $$robo$$android_view_DisplayCutout$getSafeInsetRight(), 0, this);
    }

    public Rect getSafeInsets() {
        return InvokeDynamicSupport.bootstrap("getSafeInsets", $$robo$$android_view_DisplayCutout$getSafeInsets(), 0, this);
    }

    public Region getBounds() {
        return InvokeDynamicSupport.bootstrap("getBounds", $$robo$$android_view_DisplayCutout$getBounds(), 0, this);
    }

    public List<Rect> getBoundingRects() {
        return InvokeDynamicSupport.bootstrap("getBoundingRects", $$robo$$android_view_DisplayCutout$getBoundingRects(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_view_DisplayCutout$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_view_DisplayCutout$equals(java.lang.Object ), 0, this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_DisplayCutout$toString(), 0, this);
    }

    public void writeToProto(ProtoOutputStream protoOutputStream, long l) {
        InvokeDynamicSupport.bootstrap("writeToProto", $$robo$$android_view_DisplayCutout$writeToProto(android.util.proto.ProtoOutputStream long ), 0, this, protoOutputStream, l);
    }

    public DisplayCutout inset(int n, int n2, int n3, int n4) {
        return InvokeDynamicSupport.bootstrap("inset", $$robo$$android_view_DisplayCutout$inset(int int int int ), 0, this, n, n2, n3, n4);
    }

    public DisplayCutout replaceSafeInsets(Rect rect) {
        return InvokeDynamicSupport.bootstrap("replaceSafeInsets", $$robo$$android_view_DisplayCutout$replaceSafeInsets(android.graphics.Rect ), 0, this, rect);
    }

    private static int atLeastZero(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("atLeastZero", $$robo$$android_view_DisplayCutout$atLeastZero(int ), 0, (int)n);
    }

    public static DisplayCutout fromBoundingRect(int n, int n2, int n3, int n4) {
        return InvokeDynamicSupport.bootstrapStatic("fromBoundingRect", $$robo$$android_view_DisplayCutout$fromBoundingRect(int int int int ), 0, (int)n, (int)n2, (int)n3, (int)n4);
    }

    public static DisplayCutout fromBounds(Region region) {
        return InvokeDynamicSupport.bootstrapStatic("fromBounds", $$robo$$android_view_DisplayCutout$fromBounds(android.graphics.Region ), 0, (Region)region);
    }

    public static DisplayCutout fromResourcesRectApproximation(Resources resources, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("fromResourcesRectApproximation", $$robo$$android_view_DisplayCutout$fromResourcesRectApproximation(android.content.res.Resources int int ), 0, (Resources)resources, (int)n, (int)n2);
    }

    public static Path pathFromResources(Resources resources, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("pathFromResources", $$robo$$android_view_DisplayCutout$pathFromResources(android.content.res.Resources int int ), 0, (Resources)resources, (int)n, (int)n2);
    }

    public static DisplayCutout fromSpec(String string2, int n, int n2, float f) {
        return InvokeDynamicSupport.bootstrapStatic("fromSpec", $$robo$$android_view_DisplayCutout$fromSpec(java.lang.String int int float ), 0, (String)string2, (int)n, (int)n2, (float)f);
    }

    private static Pair<Path, DisplayCutout> pathAndDisplayCutoutFromSpec(String string2, int n, int n2, float f) {
        return InvokeDynamicSupport.bootstrapStatic("pathAndDisplayCutoutFromSpec", $$robo$$android_view_DisplayCutout$pathAndDisplayCutoutFromSpec(java.lang.String int int float ), 0, (String)string2, (int)n, (int)n2, (float)f);
    }

    private static void addToRegion(Path path, Region region) {
        InvokeDynamicSupport.bootstrapStatic("addToRegion", $$robo$$android_view_DisplayCutout$addToRegion(android.graphics.Path android.graphics.Region ), 0, (Path)path, (Region)region);
    }

    private static Region boundingRectsToRegion(List<Rect> list) {
        return InvokeDynamicSupport.bootstrapStatic("boundingRectsToRegion", $$robo$$android_view_DisplayCutout$boundingRectsToRegion(java.util.List<android.graphics.Rect> ), 0, list);
    }

    private /* synthetic */ void __constructor__(Rect rect, Region region, boolean bl, 1 var4_4) {
        this.$$robo$$android_view_DisplayCutout$__constructor__(rect, region, bl, var4_4);
    }

    static {
        RobolectricInternals.classInitializing(DisplayCutout.class);
    }

    public /* synthetic */ DisplayCutout() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DisplayCutout)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ParcelableWrapper
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private DisplayCutout mInner;
        public static Parcelable.Creator<ParcelableWrapper> CREATOR;

        private void $$robo$$android_view_DisplayCutout_ParcelableWrapper$__constructor__() {
        }

        private void $$robo$$android_view_DisplayCutout_ParcelableWrapper$__constructor__(DisplayCutout cutout) {
            this.mInner = cutout;
        }

        private final int $$robo$$android_view_DisplayCutout_ParcelableWrapper$describeContents() {
            return 0;
        }

        private final void $$robo$$android_view_DisplayCutout_ParcelableWrapper$writeToParcel(Parcel out, int flags) {
            ParcelableWrapper.writeCutoutToParcel(this.mInner, out, flags);
        }

        private static final void $$robo$$android_view_DisplayCutout_ParcelableWrapper$writeCutoutToParcel(DisplayCutout cutout, Parcel out, int flags) {
            if (cutout == null) {
                out.writeInt(-1);
            } else if (cutout == NO_CUTOUT) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                out.writeTypedObject(cutout.mSafeInsets, flags);
                out.writeTypedObject(cutout.mBounds, flags);
            }
        }

        private final void $$robo$$android_view_DisplayCutout_ParcelableWrapper$readFromParcel(Parcel in) {
            this.mInner = ParcelableWrapper.readCutoutFromParcel(in);
        }

        private static final DisplayCutout $$robo$$android_view_DisplayCutout_ParcelableWrapper$readCutoutFromParcel(Parcel in) {
            int variant = in.readInt();
            if (variant == -1) {
                return null;
            }
            if (variant == 0) {
                return NO_CUTOUT;
            }
            Rect safeInsets = in.readTypedObject(Rect.CREATOR);
            Region bounds = in.readTypedObject(Region.CREATOR);
            return new DisplayCutout(safeInsets, bounds, false);
        }

        private final DisplayCutout $$robo$$android_view_DisplayCutout_ParcelableWrapper$get() {
            return this.mInner;
        }

        private final void $$robo$$android_view_DisplayCutout_ParcelableWrapper$set(ParcelableWrapper cutout) {
            this.mInner = cutout.get();
        }

        private final void $$robo$$android_view_DisplayCutout_ParcelableWrapper$set(DisplayCutout cutout) {
            this.mInner = cutout;
        }

        private final int $$robo$$android_view_DisplayCutout_ParcelableWrapper$hashCode() {
            return this.mInner.hashCode();
        }

        private final boolean $$robo$$android_view_DisplayCutout_ParcelableWrapper$equals(Object o) {
            return o instanceof ParcelableWrapper && this.mInner.equals(((ParcelableWrapper)o).mInner);
        }

        private final String $$robo$$android_view_DisplayCutout_ParcelableWrapper$toString() {
            return String.valueOf(this.mInner);
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ParcelableWrapper>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_view_DisplayCutout_ParcelableWrapper_1$__constructor__() {
                }

                private final ParcelableWrapper $$robo$$android_view_DisplayCutout_ParcelableWrapper_1$createFromParcel(Parcel in) {
                    return new ParcelableWrapper(ParcelableWrapper.readCutoutFromParcel(in));
                }

                private final ParcelableWrapper[] $$robo$$android_view_DisplayCutout_ParcelableWrapper_1$newArray(int size) {
                    return new ParcelableWrapper[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_view_DisplayCutout_ParcelableWrapper_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_DisplayCutout_ParcelableWrapper_1$__constructor__(), 0, this);
                }

                @Override
                public ParcelableWrapper createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_DisplayCutout_ParcelableWrapper_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public ParcelableWrapper[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_DisplayCutout_ParcelableWrapper_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_view_DisplayCutout_ParcelableWrapper$__constructor__();
        }

        public ParcelableWrapper() {
            this(NO_CUTOUT);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_DisplayCutout_ParcelableWrapper$__constructor__(), 0, this);
        }

        private void __constructor__(DisplayCutout displayCutout) {
            this.$$robo$$android_view_DisplayCutout_ParcelableWrapper$__constructor__(displayCutout);
        }

        public ParcelableWrapper(DisplayCutout displayCutout) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_DisplayCutout_ParcelableWrapper$__constructor__(android.view.DisplayCutout ), 0, this, displayCutout);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_DisplayCutout_ParcelableWrapper$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_DisplayCutout_ParcelableWrapper$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public static void writeCutoutToParcel(DisplayCutout displayCutout, Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrapStatic("writeCutoutToParcel", $$robo$$android_view_DisplayCutout_ParcelableWrapper$writeCutoutToParcel(android.view.DisplayCutout android.os.Parcel int ), 0, (DisplayCutout)displayCutout, (Parcel)parcel, (int)n);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_view_DisplayCutout_ParcelableWrapper$readFromParcel(android.os.Parcel ), 0, this, parcel);
        }

        public static DisplayCutout readCutoutFromParcel(Parcel parcel) {
            return InvokeDynamicSupport.bootstrapStatic("readCutoutFromParcel", $$robo$$android_view_DisplayCutout_ParcelableWrapper$readCutoutFromParcel(android.os.Parcel ), 0, (Parcel)parcel);
        }

        public DisplayCutout get() {
            return InvokeDynamicSupport.bootstrap("get", $$robo$$android_view_DisplayCutout_ParcelableWrapper$get(), 0, this);
        }

        public void set(ParcelableWrapper parcelableWrapper) {
            InvokeDynamicSupport.bootstrap("set", $$robo$$android_view_DisplayCutout_ParcelableWrapper$set(android.view.DisplayCutout$ParcelableWrapper ), 0, this, parcelableWrapper);
        }

        public void set(DisplayCutout displayCutout) {
            InvokeDynamicSupport.bootstrap("set", $$robo$$android_view_DisplayCutout_ParcelableWrapper$set(android.view.DisplayCutout ), 0, this, displayCutout);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_view_DisplayCutout_ParcelableWrapper$hashCode(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_view_DisplayCutout_ParcelableWrapper$equals(java.lang.Object ), 0, this, object);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_DisplayCutout_ParcelableWrapper$toString(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(ParcelableWrapper.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParcelableWrapper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

