/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Build;
import android.util.Log;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class InputEventConsistencyVerifier
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean IS_ENG_BUILD;
    private static String EVENT_TYPE_KEY = "KeyEvent";
    private static String EVENT_TYPE_TRACKBALL = "TrackballEvent";
    private static String EVENT_TYPE_TOUCH = "TouchEvent";
    private static String EVENT_TYPE_GENERIC_MOTION = "GenericMotionEvent";
    private static int RECENT_EVENTS_TO_LOG = 5;
    private Object mCaller;
    private int mFlags;
    private String mLogTag;
    private int mLastEventSeq;
    private String mLastEventType;
    private int mLastNestingLevel;
    private InputEvent[] mRecentEvents;
    private boolean[] mRecentEventsUnhandled;
    private int mMostRecentEventIndex;
    private InputEvent mCurrentEvent;
    private String mCurrentEventType;
    private KeyState mKeyStateList;
    private boolean mTrackballDown;
    private boolean mTrackballUnhandled;
    private int mTouchEventStreamPointers;
    private int mTouchEventStreamDeviceId;
    private int mTouchEventStreamSource;
    private boolean mTouchEventStreamIsTainted;
    private boolean mTouchEventStreamUnhandled;
    private boolean mHoverEntered;
    private int mButtonsPressed;
    private StringBuilder mViolationMessage;
    public static int FLAG_RAW_DEVICE_INPUT = 1;

    private void $$robo$$android_view_InputEventConsistencyVerifier$__constructor__(Object caller, int flags) {
    }

    private void $$robo$$android_view_InputEventConsistencyVerifier$__constructor__(Object caller, int flags, String logTag) {
        this.mTouchEventStreamDeviceId = -1;
        this.mCaller = caller;
        this.mFlags = flags;
        this.mLogTag = logTag != null ? logTag : "InputEventConsistencyVerifier";
    }

    private static final boolean $$robo$$android_view_InputEventConsistencyVerifier$isInstrumentationEnabled() {
        return IS_ENG_BUILD;
    }

    private final void $$robo$$android_view_InputEventConsistencyVerifier$reset() {
        this.mLastEventSeq = -1;
        this.mLastNestingLevel = 0;
        this.mTrackballDown = false;
        this.mTrackballUnhandled = false;
        this.mTouchEventStreamPointers = 0;
        this.mTouchEventStreamIsTainted = false;
        this.mTouchEventStreamUnhandled = false;
        this.mHoverEntered = false;
        this.mButtonsPressed = 0;
        while (this.mKeyStateList != null) {
            KeyState state = this.mKeyStateList;
            this.mKeyStateList = state.next;
            state.recycle();
        }
    }

    private final void $$robo$$android_view_InputEventConsistencyVerifier$onInputEvent(InputEvent event, int nestingLevel) {
        if (event instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)event;
            this.onKeyEvent(keyEvent, nestingLevel);
        } else {
            MotionEvent motionEvent = (MotionEvent)event;
            if (motionEvent.isTouchEvent()) {
                this.onTouchEvent(motionEvent, nestingLevel);
            } else if ((motionEvent.getSource() & 4) != 0) {
                this.onTrackballEvent(motionEvent, nestingLevel);
            } else {
                this.onGenericMotionEvent(motionEvent, nestingLevel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void $$robo$$android_view_InputEventConsistencyVerifier$onKeyEvent(KeyEvent event, int nestingLevel) {
        if (!this.startEvent(event, nestingLevel, "KeyEvent")) {
            return;
        }
        try {
            this.ensureMetaStateIsNormalized(event.getMetaState());
            int action = event.getAction();
            int deviceId = event.getDeviceId();
            int source = event.getSource();
            int keyCode = event.getKeyCode();
            switch (action) {
                case 0: {
                    KeyState state = this.findKeyState(deviceId, source, keyCode, false);
                    if (state != null) {
                        if (state.unhandled) {
                            state.unhandled = false;
                            return;
                        } else {
                            if ((this.mFlags & 1) != 0 || event.getRepeatCount() != 0) return;
                            this.problem("ACTION_DOWN but key is already down and this event is not a key repeat.");
                            return;
                        }
                    } else {
                        this.addKeyState(deviceId, source, keyCode);
                        return;
                    }
                }
                case 1: {
                    KeyState state = this.findKeyState(deviceId, source, keyCode, true);
                    if (state == null) {
                        this.problem("ACTION_UP but key was not down.");
                        return;
                    } else {
                        state.recycle();
                        return;
                    }
                }
                case 2: {
                    return;
                }
                default: {
                    this.problem("Invalid action " + KeyEvent.actionToString(action) + " for key event.");
                    return;
                }
            }
        }
        finally {
            this.finishEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_InputEventConsistencyVerifier$onTrackballEvent(MotionEvent event, int nestingLevel) {
        if (!this.startEvent(event, nestingLevel, "TrackballEvent")) {
            return;
        }
        try {
            this.ensureMetaStateIsNormalized(event.getMetaState());
            int action = event.getAction();
            int source = event.getSource();
            if ((source & 4) != 0) {
                switch (action) {
                    case 0: {
                        if (this.mTrackballDown && !this.mTrackballUnhandled) {
                            this.problem("ACTION_DOWN but trackball is already down.");
                        } else {
                            this.mTrackballDown = true;
                            this.mTrackballUnhandled = false;
                        }
                        this.ensureHistorySizeIsZeroForThisAction(event);
                        this.ensurePointerCountIsOneForThisAction(event);
                        break;
                    }
                    case 1: {
                        if (!this.mTrackballDown) {
                            this.problem("ACTION_UP but trackball is not down.");
                        } else {
                            this.mTrackballDown = false;
                            this.mTrackballUnhandled = false;
                        }
                        this.ensureHistorySizeIsZeroForThisAction(event);
                        this.ensurePointerCountIsOneForThisAction(event);
                        break;
                    }
                    case 2: {
                        this.ensurePointerCountIsOneForThisAction(event);
                        break;
                    }
                    default: {
                        this.problem("Invalid action " + MotionEvent.actionToString(action) + " for trackball event.");
                    }
                }
                if (this.mTrackballDown && event.getPressure() <= 0.0f) {
                    this.problem("Trackball is down but pressure is not greater than 0.");
                } else if (!this.mTrackballDown && event.getPressure() != 0.0f) {
                    this.problem("Trackball is up but pressure is not equal to 0.");
                }
            } else {
                this.problem("Source was not SOURCE_CLASS_TRACKBALL.");
            }
        }
        finally {
            this.finishEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_InputEventConsistencyVerifier$onTouchEvent(MotionEvent event, int nestingLevel) {
        block29: {
            boolean newStream;
            if (!this.startEvent(event, nestingLevel, "TouchEvent")) {
                return;
            }
            int action = event.getAction();
            boolean bl = newStream = action == 0 || action == 3 || action == 4;
            if (newStream && (this.mTouchEventStreamIsTainted || this.mTouchEventStreamUnhandled)) {
                this.mTouchEventStreamIsTainted = false;
                this.mTouchEventStreamUnhandled = false;
                this.mTouchEventStreamPointers = 0;
            }
            if (this.mTouchEventStreamIsTainted) {
                event.setTainted(true);
            }
            try {
                this.ensureMetaStateIsNormalized(event.getMetaState());
                int deviceId = event.getDeviceId();
                int source = event.getSource();
                if (!(newStream || this.mTouchEventStreamDeviceId == -1 || this.mTouchEventStreamDeviceId == deviceId && this.mTouchEventStreamSource == source)) {
                    this.problem("Touch event stream contains events from multiple sources: previous device id " + this.mTouchEventStreamDeviceId + ", previous source " + Integer.toHexString(this.mTouchEventStreamSource) + ", new device id " + deviceId + ", new source " + Integer.toHexString(source));
                }
                this.mTouchEventStreamDeviceId = deviceId;
                this.mTouchEventStreamSource = source;
                int pointerCount = event.getPointerCount();
                if ((source & 2) != 0) {
                    switch (action) {
                        case 0: {
                            if (this.mTouchEventStreamPointers != 0) {
                                this.problem("ACTION_DOWN but pointers are already down.  Probably missing ACTION_UP from previous gesture.");
                            }
                            this.ensureHistorySizeIsZeroForThisAction(event);
                            this.ensurePointerCountIsOneForThisAction(event);
                            this.mTouchEventStreamPointers = 1 << event.getPointerId(0);
                            break;
                        }
                        case 1: {
                            this.ensureHistorySizeIsZeroForThisAction(event);
                            this.ensurePointerCountIsOneForThisAction(event);
                            this.mTouchEventStreamPointers = 0;
                            this.mTouchEventStreamIsTainted = false;
                            break;
                        }
                        case 2: {
                            int expectedPointerCount = Integer.bitCount(this.mTouchEventStreamPointers);
                            if (pointerCount != expectedPointerCount) {
                                this.problem("ACTION_MOVE contained " + pointerCount + " pointers but there are currently " + expectedPointerCount + " pointers down.");
                                this.mTouchEventStreamIsTainted = true;
                                break;
                            }
                            break block29;
                        }
                        case 3: {
                            this.mTouchEventStreamPointers = 0;
                            this.mTouchEventStreamIsTainted = false;
                            break;
                        }
                        case 4: {
                            if (this.mTouchEventStreamPointers != 0) {
                                this.problem("ACTION_OUTSIDE but pointers are still down.");
                            }
                            this.ensureHistorySizeIsZeroForThisAction(event);
                            this.ensurePointerCountIsOneForThisAction(event);
                            this.mTouchEventStreamIsTainted = false;
                            break;
                        }
                        default: {
                            int actionMasked = event.getActionMasked();
                            int actionIndex = event.getActionIndex();
                            if (actionMasked == 5) {
                                if (this.mTouchEventStreamPointers == 0) {
                                    this.problem("ACTION_POINTER_DOWN but no other pointers were down.");
                                    this.mTouchEventStreamIsTainted = true;
                                }
                                if (actionIndex < 0 || actionIndex >= pointerCount) {
                                    this.problem("ACTION_POINTER_DOWN index is " + actionIndex + " but the pointer count is " + pointerCount + ".");
                                    this.mTouchEventStreamIsTainted = true;
                                } else {
                                    int id2 = event.getPointerId(actionIndex);
                                    int idBit = 1 << id2;
                                    if ((this.mTouchEventStreamPointers & idBit) != 0) {
                                        this.problem("ACTION_POINTER_DOWN specified pointer id " + id2 + " which is already down.");
                                        this.mTouchEventStreamIsTainted = true;
                                    } else {
                                        this.mTouchEventStreamPointers |= idBit;
                                    }
                                }
                                this.ensureHistorySizeIsZeroForThisAction(event);
                                break;
                            }
                            if (actionMasked == 6) {
                                if (actionIndex < 0 || actionIndex >= pointerCount) {
                                    this.problem("ACTION_POINTER_UP index is " + actionIndex + " but the pointer count is " + pointerCount + ".");
                                    this.mTouchEventStreamIsTainted = true;
                                } else {
                                    int id3 = event.getPointerId(actionIndex);
                                    int idBit = 1 << id3;
                                    if ((this.mTouchEventStreamPointers & idBit) == 0) {
                                        this.problem("ACTION_POINTER_UP specified pointer id " + id3 + " which is not currently down.");
                                        this.mTouchEventStreamIsTainted = true;
                                    } else {
                                        this.mTouchEventStreamPointers &= ~idBit;
                                    }
                                }
                                this.ensureHistorySizeIsZeroForThisAction(event);
                                break;
                            }
                            this.problem("Invalid action " + MotionEvent.actionToString(action) + " for touch event.");
                            break;
                        }
                    }
                    break block29;
                }
                this.problem("Source was not SOURCE_CLASS_POINTER.");
            }
            finally {
                this.finishEvent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void $$robo$$android_view_InputEventConsistencyVerifier$onGenericMotionEvent(MotionEvent event, int nestingLevel) {
        if (!this.startEvent(event, nestingLevel, "GenericMotionEvent")) {
            return;
        }
        try {
            this.ensureMetaStateIsNormalized(event.getMetaState());
            int action = event.getAction();
            int source = event.getSource();
            int buttonState = event.getButtonState();
            int actionButton = event.getActionButton();
            if ((source & 2) != 0) {
                switch (action) {
                    case 9: {
                        this.ensurePointerCountIsOneForThisAction(event);
                        this.mHoverEntered = true;
                        return;
                    }
                    case 7: {
                        this.ensurePointerCountIsOneForThisAction(event);
                        return;
                    }
                    case 10: {
                        this.ensurePointerCountIsOneForThisAction(event);
                        if (!this.mHoverEntered) {
                            this.problem("ACTION_HOVER_EXIT without prior ACTION_HOVER_ENTER");
                        }
                        this.mHoverEntered = false;
                        return;
                    }
                    case 8: {
                        this.ensureHistorySizeIsZeroForThisAction(event);
                        this.ensurePointerCountIsOneForThisAction(event);
                        return;
                    }
                    case 11: {
                        this.ensureActionButtonIsNonZeroForThisAction(event);
                        if ((this.mButtonsPressed & actionButton) != 0) {
                            this.problem("Action button for ACTION_BUTTON_PRESS event is " + actionButton + ", but it has already been pressed and has yet to be released.");
                        }
                        this.mButtonsPressed |= actionButton;
                        if (actionButton == 32 && (buttonState & 2) != 0) {
                            this.mButtonsPressed |= 2;
                        } else if (actionButton == 64 && (buttonState & 4) != 0) {
                            this.mButtonsPressed |= 4;
                        }
                        if (this.mButtonsPressed == buttonState) return;
                        this.problem(String.format("Reported button state differs from expected button state based on press and release events. Is 0x%08x but expected 0x%08x.", buttonState, this.mButtonsPressed));
                        return;
                    }
                    case 12: {
                        this.ensureActionButtonIsNonZeroForThisAction(event);
                        if ((this.mButtonsPressed & actionButton) != actionButton) {
                            this.problem("Action button for ACTION_BUTTON_RELEASE event is " + actionButton + ", but it was either never pressed or has already been released.");
                        }
                        this.mButtonsPressed &= ~actionButton;
                        if (actionButton == 32 && (buttonState & 2) == 0) {
                            this.mButtonsPressed &= 0xFFFFFFFD;
                        } else if (actionButton == 64 && (buttonState & 4) == 0) {
                            this.mButtonsPressed &= 0xFFFFFFFB;
                        }
                        if (this.mButtonsPressed == buttonState) return;
                        this.problem(String.format("Reported button state differs from expected button state based on press and release events. Is 0x%08x but expected 0x%08x.", buttonState, this.mButtonsPressed));
                        return;
                    }
                    default: {
                        this.problem("Invalid action for generic pointer event.");
                        return;
                    }
                }
            }
            if ((source & 0x10) == 0) return;
            switch (action) {
                case 2: {
                    this.ensurePointerCountIsOneForThisAction(event);
                    return;
                }
                default: {
                    this.problem("Invalid action for generic joystick event.");
                    return;
                }
            }
        }
        finally {
            this.finishEvent();
        }
    }

    private final void $$robo$$android_view_InputEventConsistencyVerifier$onUnhandledEvent(InputEvent event, int nestingLevel) {
        if (nestingLevel != this.mLastNestingLevel) {
            return;
        }
        if (this.mRecentEventsUnhandled != null) {
            this.mRecentEventsUnhandled[this.mMostRecentEventIndex] = true;
        }
        if (event instanceof KeyEvent) {
            int keyCode;
            int source;
            KeyEvent keyEvent = (KeyEvent)event;
            int deviceId = keyEvent.getDeviceId();
            KeyState state = this.findKeyState(deviceId, source = keyEvent.getSource(), keyCode = keyEvent.getKeyCode(), false);
            if (state != null) {
                state.unhandled = true;
            }
        } else {
            MotionEvent motionEvent = (MotionEvent)event;
            if (motionEvent.isTouchEvent()) {
                this.mTouchEventStreamUnhandled = true;
            } else if ((motionEvent.getSource() & 4) != 0 && this.mTrackballDown) {
                this.mTrackballUnhandled = true;
            }
        }
    }

    private final void $$robo$$android_view_InputEventConsistencyVerifier$ensureMetaStateIsNormalized(int metaState) {
        int normalizedMetaState = KeyEvent.normalizeMetaState(metaState);
        if (normalizedMetaState != metaState) {
            this.problem(String.format("Metastate not normalized.  Was 0x%08x but expected 0x%08x.", metaState, normalizedMetaState));
        }
    }

    private final void $$robo$$android_view_InputEventConsistencyVerifier$ensurePointerCountIsOneForThisAction(MotionEvent event) {
        int pointerCount = event.getPointerCount();
        if (pointerCount != 1) {
            this.problem("Pointer count is " + pointerCount + " but it should always be 1 for " + MotionEvent.actionToString(event.getAction()));
        }
    }

    private final void $$robo$$android_view_InputEventConsistencyVerifier$ensureActionButtonIsNonZeroForThisAction(MotionEvent event) {
        int actionButton = event.getActionButton();
        if (actionButton == 0) {
            this.problem("No action button set. Action button should always be non-zero for " + MotionEvent.actionToString(event.getAction()));
        }
    }

    private final void $$robo$$android_view_InputEventConsistencyVerifier$ensureHistorySizeIsZeroForThisAction(MotionEvent event) {
        int historySize = event.getHistorySize();
        if (historySize != 0) {
            this.problem("History size is " + historySize + " but it should always be 0 for " + MotionEvent.actionToString(event.getAction()));
        }
    }

    private final boolean $$robo$$android_view_InputEventConsistencyVerifier$startEvent(InputEvent event, int nestingLevel, String eventType) {
        int seq = event.getSequenceNumber();
        if (seq == this.mLastEventSeq && nestingLevel < this.mLastNestingLevel && eventType == this.mLastEventType) {
            return false;
        }
        if (nestingLevel > 0) {
            this.mLastEventSeq = seq;
            this.mLastEventType = eventType;
            this.mLastNestingLevel = nestingLevel;
        } else {
            this.mLastEventSeq = -1;
            this.mLastEventType = null;
            this.mLastNestingLevel = 0;
        }
        this.mCurrentEvent = event;
        this.mCurrentEventType = eventType;
        return true;
    }

    private final void $$robo$$android_view_InputEventConsistencyVerifier$finishEvent() {
        int index;
        if (this.mViolationMessage != null && this.mViolationMessage.length() != 0) {
            if (!this.mCurrentEvent.isTainted()) {
                this.mViolationMessage.append("\n  in ").append(this.mCaller);
                this.mViolationMessage.append("\n  ");
                InputEventConsistencyVerifier.appendEvent(this.mViolationMessage, 0, this.mCurrentEvent, false);
                if (this.mRecentEvents != null) {
                    int index2;
                    InputEvent event;
                    this.mViolationMessage.append("\n  -- recent events --");
                    for (int i = 0; i < 5 && (event = this.mRecentEvents[index2 = (this.mMostRecentEventIndex + 5 - i) % 5]) != null; ++i) {
                        this.mViolationMessage.append("\n  ");
                        InputEventConsistencyVerifier.appendEvent(this.mViolationMessage, i + 1, event, this.mRecentEventsUnhandled[index2]);
                    }
                }
                Log.d(this.mLogTag, this.mViolationMessage.toString());
                this.mCurrentEvent.setTainted(true);
            }
            this.mViolationMessage.setLength(0);
        }
        if (this.mRecentEvents == null) {
            this.mRecentEvents = new InputEvent[5];
            this.mRecentEventsUnhandled = new boolean[5];
        }
        this.mMostRecentEventIndex = index = (this.mMostRecentEventIndex + 1) % 5;
        if (this.mRecentEvents[index] != null) {
            this.mRecentEvents[index].recycle();
        }
        this.mRecentEvents[index] = this.mCurrentEvent.copy();
        this.mRecentEventsUnhandled[index] = false;
        this.mCurrentEvent = null;
        this.mCurrentEventType = null;
    }

    private static final void $$robo$$android_view_InputEventConsistencyVerifier$appendEvent(StringBuilder message, int index, InputEvent event, boolean unhandled) {
        message.append(index).append(": sent at ").append(event.getEventTimeNano());
        message.append(", ");
        if (unhandled) {
            message.append("(unhandled) ");
        }
        message.append(event);
    }

    private final void $$robo$$android_view_InputEventConsistencyVerifier$problem(String message) {
        if (this.mViolationMessage == null) {
            this.mViolationMessage = new StringBuilder();
        }
        if (this.mViolationMessage.length() == 0) {
            this.mViolationMessage.append(this.mCurrentEventType).append(": ");
        } else {
            this.mViolationMessage.append("\n  ");
        }
        this.mViolationMessage.append(message);
    }

    private final KeyState $$robo$$android_view_InputEventConsistencyVerifier$findKeyState(int deviceId, int source, int keyCode, boolean remove) {
        KeyState last = null;
        KeyState state = this.mKeyStateList;
        while (state != null) {
            if (state.deviceId == deviceId && state.source == source && state.keyCode == keyCode) {
                if (remove) {
                    if (last != null) {
                        last.next = state.next;
                    } else {
                        this.mKeyStateList = state.next;
                    }
                    state.next = null;
                }
                return state;
            }
            last = state;
            state = state.next;
        }
        return null;
    }

    private final void $$robo$$android_view_InputEventConsistencyVerifier$addKeyState(int deviceId, int source, int keyCode) {
        KeyState state = KeyState.obtain(deviceId, source, keyCode);
        state.next = this.mKeyStateList;
        this.mKeyStateList = state;
    }

    static void __staticInitializer__() {
        IS_ENG_BUILD = Build.IS_ENG;
    }

    private void __constructor__(Object object, int n) {
        this.$$robo$$android_view_InputEventConsistencyVerifier$__constructor__(object, n);
    }

    public InputEventConsistencyVerifier(Object object, int n) {
        this(object, n, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_InputEventConsistencyVerifier$__constructor__(java.lang.Object int ), 0, this, object, n);
    }

    private void __constructor__(Object object, int n, String string2) {
        this.$$robo$$android_view_InputEventConsistencyVerifier$__constructor__(object, n, string2);
    }

    public InputEventConsistencyVerifier(Object object, int n, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_InputEventConsistencyVerifier$__constructor__(java.lang.Object int java.lang.String ), 0, this, object, n, string2);
    }

    public static boolean isInstrumentationEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isInstrumentationEnabled", $$robo$$android_view_InputEventConsistencyVerifier$isInstrumentationEnabled(), 0);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_view_InputEventConsistencyVerifier$reset(), 0, this);
    }

    public void onInputEvent(InputEvent inputEvent, int n) {
        InvokeDynamicSupport.bootstrap("onInputEvent", $$robo$$android_view_InputEventConsistencyVerifier$onInputEvent(android.view.InputEvent int ), 0, this, inputEvent, n);
    }

    public void onKeyEvent(KeyEvent keyEvent, int n) {
        InvokeDynamicSupport.bootstrap("onKeyEvent", $$robo$$android_view_InputEventConsistencyVerifier$onKeyEvent(android.view.KeyEvent int ), 0, this, keyEvent, n);
    }

    public void onTrackballEvent(MotionEvent motionEvent, int n) {
        InvokeDynamicSupport.bootstrap("onTrackballEvent", $$robo$$android_view_InputEventConsistencyVerifier$onTrackballEvent(android.view.MotionEvent int ), 0, this, motionEvent, n);
    }

    public void onTouchEvent(MotionEvent motionEvent, int n) {
        InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_view_InputEventConsistencyVerifier$onTouchEvent(android.view.MotionEvent int ), 0, this, motionEvent, n);
    }

    public void onGenericMotionEvent(MotionEvent motionEvent, int n) {
        InvokeDynamicSupport.bootstrap("onGenericMotionEvent", $$robo$$android_view_InputEventConsistencyVerifier$onGenericMotionEvent(android.view.MotionEvent int ), 0, this, motionEvent, n);
    }

    public void onUnhandledEvent(InputEvent inputEvent, int n) {
        InvokeDynamicSupport.bootstrap("onUnhandledEvent", $$robo$$android_view_InputEventConsistencyVerifier$onUnhandledEvent(android.view.InputEvent int ), 0, this, inputEvent, n);
    }

    private void ensureMetaStateIsNormalized(int n) {
        InvokeDynamicSupport.bootstrap("ensureMetaStateIsNormalized", $$robo$$android_view_InputEventConsistencyVerifier$ensureMetaStateIsNormalized(int ), 0, this, n);
    }

    private void ensurePointerCountIsOneForThisAction(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("ensurePointerCountIsOneForThisAction", $$robo$$android_view_InputEventConsistencyVerifier$ensurePointerCountIsOneForThisAction(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void ensureActionButtonIsNonZeroForThisAction(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("ensureActionButtonIsNonZeroForThisAction", $$robo$$android_view_InputEventConsistencyVerifier$ensureActionButtonIsNonZeroForThisAction(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void ensureHistorySizeIsZeroForThisAction(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("ensureHistorySizeIsZeroForThisAction", $$robo$$android_view_InputEventConsistencyVerifier$ensureHistorySizeIsZeroForThisAction(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private boolean startEvent(InputEvent inputEvent, int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("startEvent", $$robo$$android_view_InputEventConsistencyVerifier$startEvent(android.view.InputEvent int java.lang.String ), 0, this, inputEvent, n, string2);
    }

    private void finishEvent() {
        InvokeDynamicSupport.bootstrap("finishEvent", $$robo$$android_view_InputEventConsistencyVerifier$finishEvent(), 0, this);
    }

    private static void appendEvent(StringBuilder stringBuilder, int n, InputEvent inputEvent, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("appendEvent", $$robo$$android_view_InputEventConsistencyVerifier$appendEvent(java.lang.StringBuilder int android.view.InputEvent boolean ), 0, (StringBuilder)stringBuilder, (int)n, (InputEvent)inputEvent, (boolean)bl);
    }

    private void problem(String string2) {
        InvokeDynamicSupport.bootstrap("problem", $$robo$$android_view_InputEventConsistencyVerifier$problem(java.lang.String ), 0, this, string2);
    }

    private KeyState findKeyState(int n, int n2, int n3, boolean bl) {
        return InvokeDynamicSupport.bootstrap("findKeyState", $$robo$$android_view_InputEventConsistencyVerifier$findKeyState(int int int boolean ), 0, this, n, n2, n3, bl);
    }

    private void addKeyState(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("addKeyState", $$robo$$android_view_InputEventConsistencyVerifier$addKeyState(int int int ), 0, this, n, n2, n3);
    }

    static {
        RobolectricInternals.classInitializing(InputEventConsistencyVerifier.class);
    }

    public /* synthetic */ InputEventConsistencyVerifier() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputEventConsistencyVerifier)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class KeyState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static Object mRecycledListLock;
        private static KeyState mRecycledList;
        public KeyState next;
        public int deviceId;
        public int source;
        public int keyCode;
        public boolean unhandled;

        private void $$robo$$android_view_InputEventConsistencyVerifier_KeyState$__constructor__() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final KeyState $$robo$$android_view_InputEventConsistencyVerifier_KeyState$obtain(int deviceId, int source, int keyCode) {
            KeyState state;
            Object object = mRecycledListLock;
            synchronized (object) {
                state = mRecycledList;
                if (state != null) {
                    mRecycledList = state.next;
                } else {
                    state = new KeyState();
                }
            }
            state.deviceId = deviceId;
            state.source = source;
            state.keyCode = keyCode;
            state.unhandled = false;
            return state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_view_InputEventConsistencyVerifier_KeyState$recycle() {
            Object object = mRecycledListLock;
            synchronized (object) {
                mRecycledList = this.next = mRecycledList;
            }
        }

        static void __staticInitializer__() {
            mRecycledListLock = new Object();
        }

        private void __constructor__() {
            this.$$robo$$android_view_InputEventConsistencyVerifier_KeyState$__constructor__();
        }

        private KeyState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_InputEventConsistencyVerifier_KeyState$__constructor__(), 0, this);
        }

        public static KeyState obtain(int n, int n2, int n3) {
            return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_InputEventConsistencyVerifier_KeyState$obtain(int int int ), 0, (int)n, (int)n2, (int)n3);
        }

        public void recycle() {
            InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_view_InputEventConsistencyVerifier_KeyState$recycle(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(KeyState.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

