/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.LayoutTransition;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Insets;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pools;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.view.ActionMode;
import android.view.Display;
import android.view.DragEvent;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroupOverlay;
import android.view.ViewHierarchyEncoder;
import android.view.ViewManager;
import android.view.ViewOutlineProvider;
import android.view.ViewParent;
import android.view.ViewRootImpl;
import android.view.ViewStructure;
import android.view.WindowInsets;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.LayoutAnimationController;
import android.view.animation.Transformation;
import android.view.autofill.Helper;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class ViewGroup
extends View
implements ViewParent,
ViewManager,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ViewGroup";
    private static boolean DBG = false;
    protected ArrayList<View> mDisappearingChildren;
    protected OnHierarchyChangeListener mOnHierarchyChangeListener;
    private View mFocused;
    private View mDefaultFocus;
    View mFocusedInCluster;
    private Transformation mChildTransformation;
    RectF mInvalidateRegion;
    Transformation mInvalidationTransformation;
    private View mCurrentDragChild;
    private DragEvent mCurrentDragStartEvent;
    private boolean mIsInterestedInDrag;
    private HashSet<View> mChildrenInterestedInDrag;
    private PointF mLocalPoint;
    private float[] mTempPoint;
    private LayoutAnimationController mLayoutAnimationController;
    private Animation.AnimationListener mAnimationListener;
    private TouchTarget mFirstTouchTarget;
    @ViewDebug.ExportedProperty(category="events")
    private long mLastTouchDownTime;
    @ViewDebug.ExportedProperty(category="events")
    private int mLastTouchDownIndex;
    @ViewDebug.ExportedProperty(category="events")
    private float mLastTouchDownX;
    @ViewDebug.ExportedProperty(category="events")
    private float mLastTouchDownY;
    private HoverTarget mFirstHoverTarget;
    private boolean mHoveredSelf;
    private View mTooltipHoverTarget;
    private boolean mTooltipHoveredSelf;
    @ViewDebug.ExportedProperty(flagMapping={@ViewDebug.FlagToString(mask=1, equals=1, name="CLIP_CHILDREN"), @ViewDebug.FlagToString(mask=2, equals=2, name="CLIP_TO_PADDING"), @ViewDebug.FlagToString(mask=32, equals=32, name="PADDING_NOT_NULL")}, formatToHexString=true)
    protected int mGroupFlags;
    private int mLayoutMode;
    static int FLAG_CLIP_CHILDREN = 1;
    private static int FLAG_CLIP_TO_PADDING = 2;
    static int FLAG_INVALIDATE_REQUIRED = 4;
    private static int FLAG_RUN_ANIMATION = 8;
    static int FLAG_ANIMATION_DONE = 16;
    private static int FLAG_PADDING_NOT_NULL = 32;
    @Deprecated
    private static int FLAG_ANIMATION_CACHE = 64;
    static int FLAG_OPTIMIZE_INVALIDATE = 128;
    static int FLAG_CLEAR_TRANSFORMATION = 256;
    private static int FLAG_NOTIFY_ANIMATION_LISTENER = 512;
    protected static int FLAG_USE_CHILD_DRAWING_ORDER = 1024;
    protected static int FLAG_SUPPORT_STATIC_TRANSFORMATIONS = 2048;
    private static int FLAG_ADD_STATES_FROM_CHILDREN = 8192;
    @Deprecated
    private static int FLAG_ALWAYS_DRAWN_WITH_CACHE = 16384;
    @Deprecated
    private static int FLAG_CHILDREN_DRAWN_WITH_CACHE = 32768;
    private static int FLAG_NOTIFY_CHILDREN_ON_DRAWABLE_STATE_CHANGE = 65536;
    private static int FLAG_MASK_FOCUSABILITY = 393216;
    public static int FOCUS_BEFORE_DESCENDANTS = 131072;
    public static int FOCUS_AFTER_DESCENDANTS = 262144;
    public static int FOCUS_BLOCK_DESCENDANTS = 393216;
    private static int[] DESCENDANT_FOCUSABILITY_FLAGS;
    protected static int FLAG_DISALLOW_INTERCEPT = 524288;
    private static int FLAG_SPLIT_MOTION_EVENTS = 0x200000;
    private static int FLAG_PREVENT_DISPATCH_ATTACHED_TO_WINDOW = 0x400000;
    private static int FLAG_LAYOUT_MODE_WAS_EXPLICITLY_SET = 0x800000;
    static int FLAG_IS_TRANSITION_GROUP = 0x1000000;
    static int FLAG_IS_TRANSITION_GROUP_SET = 0x2000000;
    static int FLAG_TOUCHSCREEN_BLOCKS_FOCUS = 0x4000000;
    private static int FLAG_START_ACTION_MODE_FOR_CHILD_IS_TYPED = 0x8000000;
    private static int FLAG_START_ACTION_MODE_FOR_CHILD_IS_NOT_TYPED = 0x10000000;
    private static int FLAG_SHOW_CONTEXT_MENU_WITH_COORDS = 0x20000000;
    protected int mPersistentDrawingCache;
    @Deprecated
    public static int PERSISTENT_NO_CACHE = 0;
    @Deprecated
    public static int PERSISTENT_ANIMATION_CACHE = 1;
    @Deprecated
    public static int PERSISTENT_SCROLLING_CACHE = 2;
    @Deprecated
    public static int PERSISTENT_ALL_CACHES = 3;
    private static int LAYOUT_MODE_UNDEFINED = -1;
    public static int LAYOUT_MODE_CLIP_BOUNDS = 0;
    public static int LAYOUT_MODE_OPTICAL_BOUNDS = 1;
    public static int LAYOUT_MODE_DEFAULT;
    protected static int CLIP_TO_PADDING_MASK = 34;
    private static int CHILD_LEFT_INDEX = 0;
    private static int CHILD_TOP_INDEX = 1;
    private View[] mChildren;
    private int mChildrenCount;
    boolean mSuppressLayout;
    private boolean mLayoutCalledWhileSuppressed;
    private static int ARRAY_INITIAL_CAPACITY = 12;
    private static int ARRAY_CAPACITY_INCREMENT = 12;
    private static float[] sDebugLines;
    Paint mCachePaint;
    private LayoutTransition mTransition;
    private ArrayList<View> mTransitioningViews;
    private ArrayList<View> mVisibilityChangingChildren;
    private ArrayList<View> mPreSortedChildren;
    @ViewDebug.ExportedProperty(category="layout")
    private int mChildCountWithTransientState;
    private int mNestedScrollAxes;
    private List<Integer> mTransientIndices;
    private List<View> mTransientViews;
    int mChildUnhandledKeyListeners;
    private static ActionMode SENTINEL_ACTION_MODE;
    private LayoutTransition.TransitionListener mLayoutTransitionListener;

    private void $$robo$$android_view_ViewGroup$__constructor__(Context context) {
    }

    private void $$robo$$android_view_ViewGroup$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_view_ViewGroup$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_view_ViewGroup$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mLastTouchDownIndex = -1;
        this.mLayoutMode = -1;
        this.mSuppressLayout = false;
        this.mLayoutCalledWhileSuppressed = false;
        this.mChildCountWithTransientState = 0;
        this.mTransientIndices = null;
        this.mTransientViews = null;
        this.mChildUnhandledKeyListeners = 0;
        this.mLayoutTransitionListener = new LayoutTransition.TransitionListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ViewGroup this$0;

            private void $$robo$$android_view_ViewGroup_4$__constructor__(ViewGroup this$0) {
            }

            private final void $$robo$$android_view_ViewGroup_4$startTransition(LayoutTransition transition2, ViewGroup container, View view, int transitionType) {
                if (transitionType == 3) {
                    this.this$0.startViewTransition(view);
                }
            }

            private final void $$robo$$android_view_ViewGroup_4$endTransition(LayoutTransition transition2, ViewGroup container, View view, int transitionType) {
                if (this.this$0.mLayoutCalledWhileSuppressed && !transition2.isChangingLayout()) {
                    this.this$0.requestLayout();
                    this.this$0.mLayoutCalledWhileSuppressed = false;
                }
                if (transitionType == 3 && this.this$0.mTransitioningViews != null) {
                    this.this$0.endViewTransition(view);
                }
            }

            private void __constructor__(ViewGroup viewGroup) {
                this.$$robo$$android_view_ViewGroup_4$__constructor__(viewGroup);
            }
            {
                this.this$0 = viewGroup;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewGroup_4$__constructor__(android.view.ViewGroup ), 0, this, viewGroup);
            }

            @Override
            public void startTransition(LayoutTransition layoutTransition, ViewGroup viewGroup, View view, int n) {
                InvokeDynamicSupport.bootstrap("startTransition", $$robo$$android_view_ViewGroup_4$startTransition(android.animation.LayoutTransition android.view.ViewGroup android.view.View int ), 0, this, layoutTransition, viewGroup, view, n);
            }

            @Override
            public void endTransition(LayoutTransition layoutTransition, ViewGroup viewGroup, View view, int n) {
                InvokeDynamicSupport.bootstrap("endTransition", $$robo$$android_view_ViewGroup_4$endTransition(android.animation.LayoutTransition android.view.ViewGroup android.view.View int ), 0, this, layoutTransition, viewGroup, view, n);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.initViewGroup();
        this.initFromAttributes(context, attrs, defStyleAttr, defStyleRes);
    }

    private final void $$robo$$android_view_ViewGroup$initViewGroup() {
        if (!this.debugDraw()) {
            this.setFlags(128, 128);
        }
        this.mGroupFlags |= 1;
        this.mGroupFlags |= 2;
        this.mGroupFlags |= 0x10;
        this.mGroupFlags |= 0x40;
        this.mGroupFlags |= 0x4000;
        if (this.mContext.getApplicationInfo().targetSdkVersion >= 11) {
            this.mGroupFlags |= 0x200000;
        }
        this.setDescendantFocusability(131072);
        this.mChildren = new View[12];
        this.mChildrenCount = 0;
        this.mPersistentDrawingCache = 2;
    }

    private final void $$robo$$android_view_ViewGroup$initFromAttributes(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ViewGroup, defStyleAttr, defStyleRes);
        int N = a.getIndexCount();
        block15: for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 0: {
                    this.setClipChildren(a.getBoolean(attr2, true));
                    continue block15;
                }
                case 1: {
                    this.setClipToPadding(a.getBoolean(attr2, true));
                    continue block15;
                }
                case 3: {
                    this.setAnimationCacheEnabled(a.getBoolean(attr2, true));
                    continue block15;
                }
                case 4: {
                    this.setPersistentDrawingCache(a.getInt(attr2, 2));
                    continue block15;
                }
                case 6: {
                    this.setAddStatesFromChildren(a.getBoolean(attr2, false));
                    continue block15;
                }
                case 5: {
                    this.setAlwaysDrawnWithCacheEnabled(a.getBoolean(attr2, true));
                    continue block15;
                }
                case 2: {
                    int id2 = a.getResourceId(attr2, -1);
                    if (id2 <= 0) continue block15;
                    this.setLayoutAnimation(AnimationUtils.loadLayoutAnimation(this.mContext, id2));
                    continue block15;
                }
                case 7: {
                    this.setDescendantFocusability(DESCENDANT_FOCUSABILITY_FLAGS[a.getInt(attr2, 0)]);
                    continue block15;
                }
                case 8: {
                    this.setMotionEventSplittingEnabled(a.getBoolean(attr2, false));
                    continue block15;
                }
                case 9: {
                    boolean animateLayoutChanges = a.getBoolean(attr2, false);
                    if (!animateLayoutChanges) continue block15;
                    this.setLayoutTransition(new LayoutTransition());
                    continue block15;
                }
                case 10: {
                    this.setLayoutMode(a.getInt(attr2, -1));
                    continue block15;
                }
                case 11: {
                    this.setTransitionGroup(a.getBoolean(attr2, false));
                    continue block15;
                }
                case 12: {
                    this.setTouchscreenBlocksFocus(a.getBoolean(attr2, false));
                }
            }
        }
        a.recycle();
    }

    @ViewDebug.ExportedProperty(category="focus", mapping={@ViewDebug.IntToString(from=131072, to="FOCUS_BEFORE_DESCENDANTS"), @ViewDebug.IntToString(from=262144, to="FOCUS_AFTER_DESCENDANTS"), @ViewDebug.IntToString(from=393216, to="FOCUS_BLOCK_DESCENDANTS")})
    private final int $$robo$$android_view_ViewGroup$getDescendantFocusability() {
        return this.mGroupFlags & 0x60000;
    }

    private final void $$robo$$android_view_ViewGroup$setDescendantFocusability(int focusability) {
        switch (focusability) {
            case 131072: 
            case 262144: 
            case 393216: {
                break;
            }
            default: {
                throw new IllegalArgumentException("must be one of FOCUS_BEFORE_DESCENDANTS, FOCUS_AFTER_DESCENDANTS, FOCUS_BLOCK_DESCENDANTS");
            }
        }
        this.mGroupFlags &= 0xFFF9FFFF;
        this.mGroupFlags |= focusability & 0x60000;
    }

    private final void $$robo$$android_view_ViewGroup$handleFocusGainInternal(int direction, Rect previouslyFocusedRect) {
        if (this.mFocused != null) {
            this.mFocused.unFocus(this);
            this.mFocused = null;
            this.mFocusedInCluster = null;
        }
        super.handleFocusGainInternal(direction, previouslyFocusedRect);
    }

    private final void $$robo$$android_view_ViewGroup$requestChildFocus(View child, View focused) {
        if (this.getDescendantFocusability() == 393216) {
            return;
        }
        super.unFocus(focused);
        if (this.mFocused != child) {
            if (this.mFocused != null) {
                this.mFocused.unFocus(focused);
            }
            this.mFocused = child;
        }
        if (this.mParent != null) {
            this.mParent.requestChildFocus(this, focused);
        }
    }

    private final void $$robo$$android_view_ViewGroup$setDefaultFocus(View child) {
        if (this.mDefaultFocus != null && this.mDefaultFocus.isFocusedByDefault()) {
            return;
        }
        this.mDefaultFocus = child;
        if (this.mParent instanceof ViewGroup) {
            ((ViewGroup)this.mParent).setDefaultFocus(this);
        }
    }

    private final void $$robo$$android_view_ViewGroup$clearDefaultFocus(View child) {
        if (this.mDefaultFocus != child && this.mDefaultFocus != null && this.mDefaultFocus.isFocusedByDefault()) {
            return;
        }
        this.mDefaultFocus = null;
        for (int i = 0; i < this.mChildrenCount; ++i) {
            View sibling = this.mChildren[i];
            if (sibling.isFocusedByDefault()) {
                this.mDefaultFocus = sibling;
                return;
            }
            if (this.mDefaultFocus != null || !sibling.hasDefaultFocus()) continue;
            this.mDefaultFocus = sibling;
        }
        if (this.mParent instanceof ViewGroup) {
            ((ViewGroup)this.mParent).clearDefaultFocus(this);
        }
    }

    private final boolean $$robo$$android_view_ViewGroup$hasDefaultFocus() {
        return this.mDefaultFocus != null || super.hasDefaultFocus();
    }

    private final void $$robo$$android_view_ViewGroup$clearFocusedInCluster(View child) {
        if (this.mFocusedInCluster != child) {
            return;
        }
        this.clearFocusedInCluster();
    }

    private final void $$robo$$android_view_ViewGroup$clearFocusedInCluster() {
        View top = this.findKeyboardNavigationCluster();
        ViewParent parent = this;
        do {
            parent.mFocusedInCluster = null;
        } while (parent != top && (parent = parent.getParent()) instanceof ViewGroup);
    }

    private final void $$robo$$android_view_ViewGroup$focusableViewAvailable(View v) {
        if (!(this.mParent == null || this.getDescendantFocusability() == 393216 || (this.mViewFlags & 0xC) != 0 || !this.isFocusableInTouchMode() && this.shouldBlockFocusForTouchscreen() || this.isFocused() && this.getDescendantFocusability() != 262144)) {
            this.mParent.focusableViewAvailable(v);
        }
    }

    private final boolean $$robo$$android_view_ViewGroup$showContextMenuForChild(View originalView) {
        if (this.isShowingContextMenuWithCoords()) {
            return false;
        }
        return this.mParent != null && this.mParent.showContextMenuForChild(originalView);
    }

    private final boolean $$robo$$android_view_ViewGroup$isShowingContextMenuWithCoords() {
        return (this.mGroupFlags & 0x20000000) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_ViewGroup$showContextMenuForChild(View originalView, float x, float y) {
        try {
            this.mGroupFlags |= 0x20000000;
            if (this.showContextMenuForChild(originalView)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.mGroupFlags &= 0xDFFFFFFF;
        }
        return this.mParent != null && this.mParent.showContextMenuForChild(originalView, x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ActionMode $$robo$$android_view_ViewGroup$startActionModeForChild(View originalView, ActionMode.Callback callback) {
        if ((this.mGroupFlags & 0x8000000) == 0) {
            try {
                this.mGroupFlags |= 0x10000000;
                ActionMode actionMode = this.startActionModeForChild(originalView, callback, 0);
                return actionMode;
            }
            finally {
                this.mGroupFlags &= 0xEFFFFFFF;
            }
        }
        return SENTINEL_ACTION_MODE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ActionMode $$robo$$android_view_ViewGroup$startActionModeForChild(View originalView, ActionMode.Callback callback, int type) {
        if ((this.mGroupFlags & 0x10000000) == 0 && type == 0) {
            ActionMode mode;
            try {
                this.mGroupFlags |= 0x8000000;
                mode = this.startActionModeForChild(originalView, callback);
            }
            finally {
                this.mGroupFlags &= 0xF7FFFFFF;
            }
            if (mode != SENTINEL_ACTION_MODE) {
                return mode;
            }
        }
        if (this.mParent != null) {
            try {
                return this.mParent.startActionModeForChild(originalView, callback, type);
            }
            catch (AbstractMethodError ame) {
                return this.mParent.startActionModeForChild(originalView, callback);
            }
        }
        return null;
    }

    private final boolean $$robo$$android_view_ViewGroup$dispatchActivityResult(String who, int requestCode, int resultCode, Intent data) {
        if (super.dispatchActivityResult(who, requestCode, resultCode, data)) {
            return true;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (!child.dispatchActivityResult(who, requestCode, resultCode, data)) continue;
            return true;
        }
        return false;
    }

    private final View $$robo$$android_view_ViewGroup$focusSearch(View focused, int direction) {
        if (this.isRootNamespace()) {
            return FocusFinder.getInstance().findNextFocus(this, focused, direction);
        }
        if (this.mParent != null) {
            return this.mParent.focusSearch(focused, direction);
        }
        return null;
    }

    private final boolean $$robo$$android_view_ViewGroup$requestChildRectangleOnScreen(View child, Rect rectangle, boolean immediate) {
        return false;
    }

    private final boolean $$robo$$android_view_ViewGroup$requestSendAccessibilityEvent(View child, AccessibilityEvent event) {
        ViewParent parent = this.mParent;
        if (parent == null) {
            return false;
        }
        boolean propagate = this.onRequestSendAccessibilityEvent(child, event);
        if (!propagate) {
            return false;
        }
        return parent.requestSendAccessibilityEvent(this, event);
    }

    private final boolean $$robo$$android_view_ViewGroup$onRequestSendAccessibilityEvent(View child, AccessibilityEvent event) {
        if (this.mAccessibilityDelegate != null) {
            return this.mAccessibilityDelegate.onRequestSendAccessibilityEvent(this, child, event);
        }
        return this.onRequestSendAccessibilityEventInternal(child, event);
    }

    private final boolean $$robo$$android_view_ViewGroup$onRequestSendAccessibilityEventInternal(View child, AccessibilityEvent event) {
        return true;
    }

    private final void $$robo$$android_view_ViewGroup$childHasTransientStateChanged(View child, boolean childHasTransientState) {
        boolean oldHasTransientState = this.hasTransientState();
        this.mChildCountWithTransientState = childHasTransientState ? ++this.mChildCountWithTransientState : --this.mChildCountWithTransientState;
        boolean newHasTransientState = this.hasTransientState();
        if (this.mParent != null && oldHasTransientState != newHasTransientState) {
            try {
                this.mParent.childHasTransientStateChanged(this, newHasTransientState);
            }
            catch (AbstractMethodError e) {
                Log.e("ViewGroup", this.mParent.getClass().getSimpleName() + " does not fully implement ViewParent", e);
            }
        }
    }

    private final boolean $$robo$$android_view_ViewGroup$hasTransientState() {
        return this.mChildCountWithTransientState > 0 || super.hasTransientState();
    }

    private final boolean $$robo$$android_view_ViewGroup$dispatchUnhandledMove(View focused, int direction) {
        return this.mFocused != null && this.mFocused.dispatchUnhandledMove(focused, direction);
    }

    private final void $$robo$$android_view_ViewGroup$clearChildFocus(View child) {
        this.mFocused = null;
        if (this.mParent != null) {
            this.mParent.clearChildFocus(this);
        }
    }

    private final void $$robo$$android_view_ViewGroup$clearFocus() {
        if (this.mFocused == null) {
            super.clearFocus();
        } else {
            View focused = this.mFocused;
            this.mFocused = null;
            focused.clearFocus();
        }
    }

    private final void $$robo$$android_view_ViewGroup$unFocus(View focused) {
        if (this.mFocused == null) {
            super.unFocus(focused);
        } else {
            this.mFocused.unFocus(focused);
            this.mFocused = null;
        }
    }

    private final View $$robo$$android_view_ViewGroup$getFocusedChild() {
        return this.mFocused;
    }

    private final View $$robo$$android_view_ViewGroup$getDeepestFocusedChild() {
        ViewGroup v = this;
        while (v != null) {
            if (v.isFocused()) {
                return v;
            }
            v = v instanceof ViewGroup ? v.getFocusedChild() : null;
        }
        return null;
    }

    private final boolean $$robo$$android_view_ViewGroup$hasFocus() {
        return (this.mPrivateFlags & 2) != 0 || this.mFocused != null;
    }

    private final View $$robo$$android_view_ViewGroup$findFocus() {
        if (this.isFocused()) {
            return this;
        }
        if (this.mFocused != null) {
            return this.mFocused.findFocus();
        }
        return null;
    }

    private final boolean $$robo$$android_view_ViewGroup$hasFocusable(boolean allowAutoFocus, boolean dispatchExplicit) {
        if ((this.mViewFlags & 0xC) != 0) {
            return false;
        }
        if ((allowAutoFocus || this.getFocusable() != 16) && this.isFocusable()) {
            return true;
        }
        int descendantFocusability = this.getDescendantFocusability();
        if (descendantFocusability != 393216) {
            return this.hasFocusableChild(dispatchExplicit);
        }
        return false;
    }

    private final boolean $$robo$$android_view_ViewGroup$hasFocusableChild(boolean dispatchExplicit) {
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            if ((!dispatchExplicit || !child.hasExplicitFocusable()) && (dispatchExplicit || !child.hasFocusable())) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$android_view_ViewGroup$addFocusables(ArrayList<View> views, int direction, int focusableMode) {
        int i;
        boolean focusSelf;
        int focusableCount = views.size();
        int descendantFocusability = this.getDescendantFocusability();
        boolean blockFocusForTouchscreen = this.shouldBlockFocusForTouchscreen();
        boolean bl = focusSelf = this.isFocusableInTouchMode() || !blockFocusForTouchscreen;
        if (descendantFocusability == 393216) {
            if (focusSelf) {
                super.addFocusables(views, direction, focusableMode);
            }
            return;
        }
        if (blockFocusForTouchscreen) {
            focusableMode |= 1;
        }
        if (descendantFocusability == 131072 && focusSelf) {
            super.addFocusables(views, direction, focusableMode);
        }
        int count = 0;
        View[] children = new View[this.mChildrenCount];
        for (i = 0; i < this.mChildrenCount; ++i) {
            View child = this.mChildren[i];
            if ((child.mViewFlags & 0xC) != 0) continue;
            children[count++] = child;
        }
        FocusFinder.sort(children, 0, count, this, this.isLayoutRtl());
        for (i = 0; i < count; ++i) {
            children[i].addFocusables(views, direction, focusableMode);
        }
        if (descendantFocusability == 262144 && focusSelf && focusableCount == views.size()) {
            super.addFocusables(views, direction, focusableMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_ViewGroup$addKeyboardNavigationClusters(Collection<View> views, int direction) {
        int i;
        int focusableCount = views.size();
        if (this.isKeyboardNavigationCluster()) {
            boolean blockedFocus = this.getTouchscreenBlocksFocus();
            try {
                this.setTouchscreenBlocksFocusNoRefocus(false);
                super.addKeyboardNavigationClusters(views, direction);
            }
            finally {
                this.setTouchscreenBlocksFocusNoRefocus(blockedFocus);
            }
        } else {
            super.addKeyboardNavigationClusters(views, direction);
        }
        if (focusableCount != views.size()) {
            return;
        }
        if (this.getDescendantFocusability() == 393216) {
            return;
        }
        int count = 0;
        View[] visibleChildren = new View[this.mChildrenCount];
        for (i = 0; i < this.mChildrenCount; ++i) {
            View child = this.mChildren[i];
            if ((child.mViewFlags & 0xC) != 0) continue;
            visibleChildren[count++] = child;
        }
        FocusFinder.sort(visibleChildren, 0, count, this, this.isLayoutRtl());
        for (i = 0; i < count; ++i) {
            visibleChildren[i].addKeyboardNavigationClusters(views, direction);
        }
    }

    private final void $$robo$$android_view_ViewGroup$setTouchscreenBlocksFocus(boolean touchscreenBlocksFocus) {
        if (touchscreenBlocksFocus) {
            View newFocus;
            View focusedChild;
            this.mGroupFlags |= 0x4000000;
            if (this.hasFocus() && !this.isKeyboardNavigationCluster() && !(focusedChild = this.getDeepestFocusedChild()).isFocusableInTouchMode() && (newFocus = this.focusSearch(2)) != null) {
                newFocus.requestFocus();
            }
        } else {
            this.mGroupFlags &= 0xFBFFFFFF;
        }
    }

    private final void $$robo$$android_view_ViewGroup$setTouchscreenBlocksFocusNoRefocus(boolean touchscreenBlocksFocus) {
        this.mGroupFlags = touchscreenBlocksFocus ? (this.mGroupFlags |= 0x4000000) : (this.mGroupFlags &= 0xFBFFFFFF);
    }

    @ViewDebug.ExportedProperty(category="focus")
    private final boolean $$robo$$android_view_ViewGroup$getTouchscreenBlocksFocus() {
        return (this.mGroupFlags & 0x4000000) != 0;
    }

    private final boolean $$robo$$android_view_ViewGroup$shouldBlockFocusForTouchscreen() {
        return this.getTouchscreenBlocksFocus() && this.mContext.getPackageManager().hasSystemFeature("android.hardware.touchscreen") && (!this.isKeyboardNavigationCluster() || !this.hasFocus() && this.findKeyboardNavigationCluster() == this);
    }

    private final void $$robo$$android_view_ViewGroup$findViewsWithText(ArrayList<View> outViews, CharSequence text, int flags) {
        super.findViewsWithText(outViews, text, flags);
        int childrenCount = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < childrenCount; ++i) {
            View child = children[i];
            if ((child.mViewFlags & 0xC) != 0 || (child.mPrivateFlags & 8) != 0) continue;
            child.findViewsWithText(outViews, text, flags);
        }
    }

    private final View $$robo$$android_view_ViewGroup$findViewByAccessibilityIdTraversal(int accessibilityId) {
        Object foundView = super.findViewByAccessibilityIdTraversal(accessibilityId);
        if (foundView != null) {
            return foundView;
        }
        if (this.getAccessibilityNodeProvider() != null) {
            return null;
        }
        int childrenCount = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < childrenCount; ++i) {
            View child = children[i];
            foundView = child.findViewByAccessibilityIdTraversal(accessibilityId);
            if (foundView == null) continue;
            return foundView;
        }
        return null;
    }

    private final View $$robo$$android_view_ViewGroup$findViewByAutofillIdTraversal(int autofillId) {
        Object foundView = super.findViewByAutofillIdTraversal(autofillId);
        if (foundView != null) {
            return foundView;
        }
        int childrenCount = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < childrenCount; ++i) {
            View child = children[i];
            foundView = child.findViewByAutofillIdTraversal(autofillId);
            if (foundView == null) continue;
            return foundView;
        }
        return null;
    }

    private final void $$robo$$android_view_ViewGroup$dispatchWindowFocusChanged(boolean hasFocus) {
        super.dispatchWindowFocusChanged(hasFocus);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchWindowFocusChanged(hasFocus);
        }
    }

    private final void $$robo$$android_view_ViewGroup$addTouchables(ArrayList<View> views) {
        super.addTouchables(views);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            if ((child.mViewFlags & 0xC) != 0) continue;
            child.addTouchables(views);
        }
    }

    private final void $$robo$$android_view_ViewGroup$makeOptionalFitsSystemWindows() {
        super.makeOptionalFitsSystemWindows();
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].makeOptionalFitsSystemWindows();
        }
    }

    private final void $$robo$$android_view_ViewGroup$dispatchDisplayHint(int hint) {
        super.dispatchDisplayHint(hint);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchDisplayHint(hint);
        }
    }

    private final void $$robo$$android_view_ViewGroup$onChildVisibilityChanged(View child, int oldVisibility, int newVisibility) {
        if (this.mTransition != null) {
            if (newVisibility == 0) {
                this.mTransition.showChild(this, child, oldVisibility);
            } else {
                this.mTransition.hideChild(this, child, newVisibility);
                if (this.mTransitioningViews != null && this.mTransitioningViews.contains(child)) {
                    if (this.mVisibilityChangingChildren == null) {
                        this.mVisibilityChangingChildren = new ArrayList();
                    }
                    this.mVisibilityChangingChildren.add(child);
                    this.addDisappearingView(child);
                }
            }
        }
        if (newVisibility == 0 && this.mCurrentDragStartEvent != null && !this.mChildrenInterestedInDrag.contains(child)) {
            this.notifyChildOfDragStart(child);
        }
    }

    private final void $$robo$$android_view_ViewGroup$dispatchVisibilityChanged(View changedView, int visibility) {
        super.dispatchVisibilityChanged(changedView, visibility);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchVisibilityChanged(changedView, visibility);
        }
    }

    private final void $$robo$$android_view_ViewGroup$dispatchWindowVisibilityChanged(int visibility) {
        super.dispatchWindowVisibilityChanged(visibility);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchWindowVisibilityChanged(visibility);
        }
    }

    private final boolean $$robo$$android_view_ViewGroup$dispatchVisibilityAggregated(boolean isVisible) {
        isVisible = super.dispatchVisibilityAggregated(isVisible);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            if (children[i].getVisibility() != 0) continue;
            children[i].dispatchVisibilityAggregated(isVisible);
        }
        return isVisible;
    }

    private final void $$robo$$android_view_ViewGroup$dispatchConfigurationChanged(Configuration newConfig) {
        super.dispatchConfigurationChanged(newConfig);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchConfigurationChanged(newConfig);
        }
    }

    private final void $$robo$$android_view_ViewGroup$recomputeViewAttributes(View child) {
        ViewParent parent;
        if (this.mAttachInfo != null && !this.mAttachInfo.mRecomputeGlobalAttributes && (parent = this.mParent) != null) {
            parent.recomputeViewAttributes(this);
        }
    }

    private final void $$robo$$android_view_ViewGroup$dispatchCollectViewAttributes(View.AttachInfo attachInfo, int visibility) {
        if ((visibility & 0xC) == 0) {
            super.dispatchCollectViewAttributes(attachInfo, visibility);
            int count = this.mChildrenCount;
            View[] children = this.mChildren;
            for (int i = 0; i < count; ++i) {
                View child = children[i];
                child.dispatchCollectViewAttributes(attachInfo, visibility | child.mViewFlags & 0xC);
            }
        }
    }

    private final void $$robo$$android_view_ViewGroup$bringChildToFront(View child) {
        int index = this.indexOfChild(child);
        if (index >= 0) {
            this.removeFromArray(index);
            this.addInArray(child, this.mChildrenCount);
            child.mParent = this;
            this.requestLayout();
            this.invalidate();
        }
    }

    private final PointF $$robo$$android_view_ViewGroup$getLocalPoint() {
        if (this.mLocalPoint == null) {
            this.mLocalPoint = new PointF();
        }
        return this.mLocalPoint;
    }

    private final boolean $$robo$$android_view_ViewGroup$dispatchDragEnterExitInPreN(DragEvent event) {
        if (event.mAction == 6 && this.mCurrentDragChild != null) {
            this.mCurrentDragChild.dispatchDragEnterExitInPreN(event);
            this.mCurrentDragChild = null;
        }
        return this.mIsInterestedInDrag && super.dispatchDragEnterExitInPreN(event);
    }

    private final boolean $$robo$$android_view_ViewGroup$dispatchDragEvent(DragEvent event) {
        boolean retval = false;
        float tx = event.mX;
        float ty = event.mY;
        ClipData td = event.mClipData;
        PointF localPoint = this.getLocalPoint();
        switch (event.mAction) {
            case 1: {
                this.mCurrentDragChild = null;
                this.mCurrentDragStartEvent = DragEvent.obtain(event);
                if (this.mChildrenInterestedInDrag == null) {
                    this.mChildrenInterestedInDrag = new HashSet();
                } else {
                    this.mChildrenInterestedInDrag.clear();
                }
                int count = this.mChildrenCount;
                View[] children = this.mChildren;
                for (int i = 0; i < count; ++i) {
                    View child = children[i];
                    child.mPrivateFlags2 &= 0xFFFFFFFC;
                    if (child.getVisibility() != 0 || !this.notifyChildOfDragStart(children[i])) continue;
                    retval = true;
                }
                this.mIsInterestedInDrag = super.dispatchDragEvent(event);
                if (this.mIsInterestedInDrag) {
                    retval = true;
                }
                if (retval) break;
                this.mCurrentDragStartEvent.recycle();
                this.mCurrentDragStartEvent = null;
                break;
            }
            case 4: {
                HashSet<View> childrenInterestedInDrag = this.mChildrenInterestedInDrag;
                if (childrenInterestedInDrag != null) {
                    for (View child : childrenInterestedInDrag) {
                        if (!child.dispatchDragEvent(event)) continue;
                        retval = true;
                    }
                    childrenInterestedInDrag.clear();
                }
                if (this.mCurrentDragStartEvent != null) {
                    this.mCurrentDragStartEvent.recycle();
                    this.mCurrentDragStartEvent = null;
                }
                if (!this.mIsInterestedInDrag) break;
                if (super.dispatchDragEvent(event)) {
                    retval = true;
                }
                this.mIsInterestedInDrag = false;
                break;
            }
            case 2: 
            case 3: {
                View target = this.findFrontmostDroppableChildAt(event.mX, event.mY, localPoint);
                if (target != this.mCurrentDragChild) {
                    if (sCascadedDragDrop) {
                        int action = event.mAction;
                        event.mX = 0.0f;
                        event.mY = 0.0f;
                        event.mClipData = null;
                        if (this.mCurrentDragChild != null) {
                            event.mAction = 6;
                            this.mCurrentDragChild.dispatchDragEnterExitInPreN(event);
                        }
                        if (target != null) {
                            event.mAction = 5;
                            target.dispatchDragEnterExitInPreN(event);
                        }
                        event.mAction = action;
                        event.mX = tx;
                        event.mY = ty;
                        event.mClipData = td;
                    }
                    this.mCurrentDragChild = target;
                }
                if (target == null && this.mIsInterestedInDrag) {
                    target = this;
                }
                if (target == null) break;
                if (target != this) {
                    boolean eventWasConsumed;
                    event.mX = localPoint.x;
                    event.mY = localPoint.y;
                    retval = target.dispatchDragEvent(event);
                    event.mX = tx;
                    event.mY = ty;
                    if (!this.mIsInterestedInDrag || (eventWasConsumed = sCascadedDragDrop ? retval : event.mEventHandlerWasCalled)) break;
                    retval = super.dispatchDragEvent(event);
                    break;
                }
                retval = super.dispatchDragEvent(event);
            }
        }
        return retval;
    }

    private final View $$robo$$android_view_ViewGroup$findFrontmostDroppableChildAt(float x, float y, PointF outLocalPoint) {
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = count - 1; i >= 0; --i) {
            View child = children[i];
            if (!child.canAcceptDrag() || !this.isTransformedTouchPointInView(x, y, child, outLocalPoint)) continue;
            return child;
        }
        return null;
    }

    private final boolean $$robo$$android_view_ViewGroup$notifyChildOfDragStart(View child) {
        float tx = this.mCurrentDragStartEvent.mX;
        float ty = this.mCurrentDragStartEvent.mY;
        float[] point = this.getTempPoint();
        point[0] = tx;
        point[1] = ty;
        this.transformPointToViewLocal(point, child);
        this.mCurrentDragStartEvent.mX = point[0];
        this.mCurrentDragStartEvent.mY = point[1];
        boolean canAccept = child.dispatchDragEvent(this.mCurrentDragStartEvent);
        this.mCurrentDragStartEvent.mX = tx;
        this.mCurrentDragStartEvent.mY = ty;
        this.mCurrentDragStartEvent.mEventHandlerWasCalled = false;
        if (canAccept) {
            this.mChildrenInterestedInDrag.add(child);
            if (!child.canAcceptDrag()) {
                child.mPrivateFlags2 |= 1;
                child.refreshDrawableState();
            }
        }
        return canAccept;
    }

    private final void $$robo$$android_view_ViewGroup$dispatchWindowSystemUiVisiblityChanged(int visible) {
        super.dispatchWindowSystemUiVisiblityChanged(visible);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            child.dispatchWindowSystemUiVisiblityChanged(visible);
        }
    }

    private final void $$robo$$android_view_ViewGroup$dispatchSystemUiVisibilityChanged(int visible) {
        super.dispatchSystemUiVisibilityChanged(visible);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            child.dispatchSystemUiVisibilityChanged(visible);
        }
    }

    private final boolean $$robo$$android_view_ViewGroup$updateLocalSystemUiVisibility(int localValue, int localChanges) {
        boolean changed = super.updateLocalSystemUiVisibility(localValue, localChanges);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            changed |= child.updateLocalSystemUiVisibility(localValue, localChanges);
        }
        return changed;
    }

    private final boolean $$robo$$android_view_ViewGroup$dispatchKeyEventPreIme(KeyEvent event) {
        if ((this.mPrivateFlags & 0x12) == 18) {
            return super.dispatchKeyEventPreIme(event);
        }
        if (this.mFocused != null && (this.mFocused.mPrivateFlags & 0x10) == 16) {
            return this.mFocused.dispatchKeyEventPreIme(event);
        }
        return false;
    }

    private final boolean $$robo$$android_view_ViewGroup$dispatchKeyEvent(KeyEvent event) {
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onKeyEvent(event, 1);
        }
        if ((this.mPrivateFlags & 0x12) == 18 ? super.dispatchKeyEvent(event) : this.mFocused != null && (this.mFocused.mPrivateFlags & 0x10) == 16 && this.mFocused.dispatchKeyEvent(event)) {
            return true;
        }
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onUnhandledEvent(event, 1);
        }
        return false;
    }

    private final boolean $$robo$$android_view_ViewGroup$dispatchKeyShortcutEvent(KeyEvent event) {
        if ((this.mPrivateFlags & 0x12) == 18) {
            return super.dispatchKeyShortcutEvent(event);
        }
        if (this.mFocused != null && (this.mFocused.mPrivateFlags & 0x10) == 16) {
            return this.mFocused.dispatchKeyShortcutEvent(event);
        }
        return false;
    }

    private final boolean $$robo$$android_view_ViewGroup$dispatchTrackballEvent(MotionEvent event) {
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onTrackballEvent(event, 1);
        }
        if ((this.mPrivateFlags & 0x12) == 18 ? super.dispatchTrackballEvent(event) : this.mFocused != null && (this.mFocused.mPrivateFlags & 0x10) == 16 && this.mFocused.dispatchTrackballEvent(event)) {
            return true;
        }
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onUnhandledEvent(event, 1);
        }
        return false;
    }

    private final boolean $$robo$$android_view_ViewGroup$dispatchCapturedPointerEvent(MotionEvent event) {
        return (this.mPrivateFlags & 0x12) == 18 ? super.dispatchCapturedPointerEvent(event) : this.mFocused != null && (this.mFocused.mPrivateFlags & 0x10) == 16 && this.mFocused.dispatchCapturedPointerEvent(event);
    }

    private final void $$robo$$android_view_ViewGroup$dispatchPointerCaptureChanged(boolean hasCapture) {
        this.exitHoverTargets();
        super.dispatchPointerCaptureChanged(hasCapture);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchPointerCaptureChanged(hasCapture);
        }
    }

    private final PointerIcon $$robo$$android_view_ViewGroup$onResolvePointerIcon(MotionEvent event, int pointerIndex) {
        float y;
        float x = event.getX(pointerIndex);
        if (this.isOnScrollbarThumb(x, y = event.getY(pointerIndex)) || this.isDraggingScrollBar()) {
            return PointerIcon.getSystemIcon(this.mContext, 1000);
        }
        int childrenCount = this.mChildrenCount;
        if (childrenCount != 0) {
            ArrayList<View> preorderedList = this.buildOrderedChildList();
            boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
            View[] children = this.mChildren;
            for (int i = childrenCount - 1; i >= 0; --i) {
                PointerIcon pointerIcon;
                int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
                View child = ViewGroup.getAndVerifyPreorderedView(preorderedList, children, childIndex);
                if (!ViewGroup.canViewReceivePointerEvents(child) || !this.isTransformedTouchPointInView(x, y, child, null) || (pointerIcon = this.dispatchResolvePointerIcon(event, pointerIndex, child)) == null) continue;
                if (preorderedList != null) {
                    preorderedList.clear();
                }
                return pointerIcon;
            }
            if (preorderedList != null) {
                preorderedList.clear();
            }
        }
        return super.onResolvePointerIcon(event, pointerIndex);
    }

    private final PointerIcon $$robo$$android_view_ViewGroup$dispatchResolvePointerIcon(MotionEvent event, int pointerIndex, View child) {
        PointerIcon pointerIcon;
        if (!child.hasIdentityMatrix()) {
            MotionEvent transformedEvent = this.getTransformedMotionEvent(event, child);
            pointerIcon = child.onResolvePointerIcon(transformedEvent, pointerIndex);
            transformedEvent.recycle();
        } else {
            float offsetX = this.mScrollX - child.mLeft;
            float offsetY = this.mScrollY - child.mTop;
            event.offsetLocation(offsetX, offsetY);
            pointerIcon = child.onResolvePointerIcon(event, pointerIndex);
            event.offsetLocation(-offsetX, -offsetY);
        }
        return pointerIcon;
    }

    private final int $$robo$$android_view_ViewGroup$getAndVerifyPreorderedIndex(int childrenCount, int i, boolean customOrder) {
        int childIndex;
        if (customOrder) {
            int childIndex1 = this.getChildDrawingOrder(childrenCount, i);
            if (childIndex1 >= childrenCount) {
                throw new IndexOutOfBoundsException("getChildDrawingOrder() returned invalid index " + childIndex1 + " (child count is " + childrenCount + ")");
            }
            childIndex = childIndex1;
        } else {
            childIndex = i;
        }
        return childIndex;
    }

    private final boolean $$robo$$android_view_ViewGroup$dispatchHoverEvent(MotionEvent event) {
        boolean newHoveredSelf;
        int action = event.getAction();
        boolean interceptHover = this.onInterceptHoverEvent(event);
        event.setAction(action);
        MotionEvent eventNoHistory = event;
        boolean handled = false;
        HoverTarget firstOldHoverTarget = this.mFirstHoverTarget;
        this.mFirstHoverTarget = null;
        if (!interceptHover && action != 10) {
            float x = event.getX();
            float y = event.getY();
            int childrenCount = this.mChildrenCount;
            if (childrenCount != 0) {
                ArrayList<View> preorderedList = this.buildOrderedChildList();
                boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
                View[] children = this.mChildren;
                HoverTarget lastHoverTarget = null;
                for (int i = childrenCount - 1; i >= 0; --i) {
                    boolean wasHovered;
                    int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
                    View child = ViewGroup.getAndVerifyPreorderedView(preorderedList, children, childIndex);
                    if (!ViewGroup.canViewReceivePointerEvents(child) || !this.isTransformedTouchPointInView(x, y, child, null)) continue;
                    HoverTarget hoverTarget = firstOldHoverTarget;
                    HoverTarget predecessor = null;
                    while (true) {
                        if (hoverTarget == null) {
                            hoverTarget = HoverTarget.obtain(child);
                            wasHovered = false;
                            break;
                        }
                        if (hoverTarget.child == child) {
                            if (predecessor != null) {
                                predecessor.next = hoverTarget.next;
                            } else {
                                firstOldHoverTarget = hoverTarget.next;
                            }
                            hoverTarget.next = null;
                            wasHovered = true;
                            break;
                        }
                        predecessor = hoverTarget;
                        hoverTarget = hoverTarget.next;
                    }
                    if (lastHoverTarget != null) {
                        lastHoverTarget.next = hoverTarget;
                    } else {
                        this.mFirstHoverTarget = hoverTarget;
                    }
                    lastHoverTarget = hoverTarget;
                    if (action == 9) {
                        if (!wasHovered) {
                            handled |= this.dispatchTransformedGenericPointerEvent(event, child);
                        }
                    } else if (action == 7) {
                        if (!wasHovered) {
                            eventNoHistory = ViewGroup.obtainMotionEventNoHistoryOrSelf(eventNoHistory);
                            eventNoHistory.setAction(9);
                            handled |= this.dispatchTransformedGenericPointerEvent(eventNoHistory, child);
                            eventNoHistory.setAction(action);
                            handled |= this.dispatchTransformedGenericPointerEvent(eventNoHistory, child);
                        } else {
                            handled |= this.dispatchTransformedGenericPointerEvent(event, child);
                        }
                    }
                    if (handled) break;
                }
                if (preorderedList != null) {
                    preorderedList.clear();
                }
            }
        }
        while (firstOldHoverTarget != null) {
            View child = firstOldHoverTarget.child;
            if (action == 10) {
                handled |= this.dispatchTransformedGenericPointerEvent(event, child);
            } else {
                if (action == 7) {
                    boolean hoverExitPending = event.isHoverExitPending();
                    event.setHoverExitPending(true);
                    this.dispatchTransformedGenericPointerEvent(event, child);
                    event.setHoverExitPending(hoverExitPending);
                }
                eventNoHistory = ViewGroup.obtainMotionEventNoHistoryOrSelf(eventNoHistory);
                eventNoHistory.setAction(10);
                this.dispatchTransformedGenericPointerEvent(eventNoHistory, child);
                eventNoHistory.setAction(action);
            }
            HoverTarget nextOldHoverTarget = firstOldHoverTarget.next;
            firstOldHoverTarget.recycle();
            firstOldHoverTarget = nextOldHoverTarget;
        }
        boolean bl = newHoveredSelf = !handled && action != 10 && !event.isHoverExitPending();
        if (newHoveredSelf == this.mHoveredSelf) {
            if (newHoveredSelf) {
                handled |= super.dispatchHoverEvent(event);
            }
        } else {
            if (this.mHoveredSelf) {
                if (action == 10) {
                    handled |= super.dispatchHoverEvent(event);
                } else {
                    if (action == 7) {
                        super.dispatchHoverEvent(event);
                    }
                    eventNoHistory = ViewGroup.obtainMotionEventNoHistoryOrSelf(eventNoHistory);
                    eventNoHistory.setAction(10);
                    super.dispatchHoverEvent(eventNoHistory);
                    eventNoHistory.setAction(action);
                }
                this.mHoveredSelf = false;
            }
            if (newHoveredSelf) {
                if (action == 9) {
                    handled |= super.dispatchHoverEvent(event);
                    this.mHoveredSelf = true;
                } else if (action == 7) {
                    eventNoHistory = ViewGroup.obtainMotionEventNoHistoryOrSelf(eventNoHistory);
                    eventNoHistory.setAction(9);
                    handled |= super.dispatchHoverEvent(eventNoHistory);
                    eventNoHistory.setAction(action);
                    handled |= super.dispatchHoverEvent(eventNoHistory);
                    this.mHoveredSelf = true;
                }
            }
        }
        if (eventNoHistory != event) {
            eventNoHistory.recycle();
        }
        return handled;
    }

    private final void $$robo$$android_view_ViewGroup$exitHoverTargets() {
        if (this.mHoveredSelf || this.mFirstHoverTarget != null) {
            long now = SystemClock.uptimeMillis();
            MotionEvent event = MotionEvent.obtain(now, now, 10, 0.0f, 0.0f, 0);
            event.setSource(4098);
            this.dispatchHoverEvent(event);
            event.recycle();
        }
    }

    private final void $$robo$$android_view_ViewGroup$cancelHoverTarget(View view) {
        HoverTarget predecessor = null;
        HoverTarget target = this.mFirstHoverTarget;
        while (target != null) {
            HoverTarget next = target.next;
            if (target.child == view) {
                if (predecessor == null) {
                    this.mFirstHoverTarget = next;
                } else {
                    predecessor.next = next;
                }
                target.recycle();
                long now = SystemClock.uptimeMillis();
                MotionEvent event = MotionEvent.obtain(now, now, 10, 0.0f, 0.0f, 0);
                event.setSource(4098);
                view.dispatchHoverEvent(event);
                event.recycle();
                return;
            }
            predecessor = target;
            target = next;
        }
    }

    private final boolean $$robo$$android_view_ViewGroup$dispatchTooltipHoverEvent(MotionEvent event) {
        int action = event.getAction();
        switch (action) {
            case 9: {
                break;
            }
            case 7: {
                View newTarget = null;
                int childrenCount = this.mChildrenCount;
                if (childrenCount != 0) {
                    float x = event.getX();
                    float y = event.getY();
                    ArrayList<View> preorderedList = this.buildOrderedChildList();
                    boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
                    View[] children = this.mChildren;
                    for (int i = childrenCount - 1; i >= 0; --i) {
                        int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
                        View child = ViewGroup.getAndVerifyPreorderedView(preorderedList, children, childIndex);
                        if (!ViewGroup.canViewReceivePointerEvents(child) || !this.isTransformedTouchPointInView(x, y, child, null) || !this.dispatchTooltipHoverEvent(event, child)) continue;
                        newTarget = child;
                        break;
                    }
                    if (preorderedList != null) {
                        preorderedList.clear();
                    }
                }
                if (this.mTooltipHoverTarget != newTarget) {
                    if (this.mTooltipHoverTarget != null) {
                        event.setAction(10);
                        this.mTooltipHoverTarget.dispatchTooltipHoverEvent(event);
                        event.setAction(action);
                    }
                    this.mTooltipHoverTarget = newTarget;
                }
                if (this.mTooltipHoverTarget != null) {
                    if (this.mTooltipHoveredSelf) {
                        this.mTooltipHoveredSelf = false;
                        event.setAction(10);
                        super.dispatchTooltipHoverEvent(event);
                        event.setAction(action);
                    }
                    return true;
                }
                this.mTooltipHoveredSelf = super.dispatchTooltipHoverEvent(event);
                return this.mTooltipHoveredSelf;
            }
            case 10: {
                if (this.mTooltipHoverTarget != null) {
                    this.mTooltipHoverTarget.dispatchTooltipHoverEvent(event);
                    this.mTooltipHoverTarget = null;
                    break;
                }
                if (!this.mTooltipHoveredSelf) break;
                super.dispatchTooltipHoverEvent(event);
                this.mTooltipHoveredSelf = false;
            }
        }
        return false;
    }

    private final boolean $$robo$$android_view_ViewGroup$dispatchTooltipHoverEvent(MotionEvent event, View child) {
        boolean result;
        if (!child.hasIdentityMatrix()) {
            MotionEvent transformedEvent = this.getTransformedMotionEvent(event, child);
            result = child.dispatchTooltipHoverEvent(transformedEvent);
            transformedEvent.recycle();
        } else {
            float offsetX = this.mScrollX - child.mLeft;
            float offsetY = this.mScrollY - child.mTop;
            event.offsetLocation(offsetX, offsetY);
            result = child.dispatchTooltipHoverEvent(event);
            event.offsetLocation(-offsetX, -offsetY);
        }
        return result;
    }

    private final void $$robo$$android_view_ViewGroup$exitTooltipHoverTargets() {
        if (this.mTooltipHoveredSelf || this.mTooltipHoverTarget != null) {
            long now = SystemClock.uptimeMillis();
            MotionEvent event = MotionEvent.obtain(now, now, 10, 0.0f, 0.0f, 0);
            event.setSource(4098);
            this.dispatchTooltipHoverEvent(event);
            event.recycle();
        }
    }

    private final boolean $$robo$$android_view_ViewGroup$hasHoveredChild() {
        return this.mFirstHoverTarget != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_ViewGroup$addChildrenForAccessibility(ArrayList<View> outChildren) {
        if (this.getAccessibilityNodeProvider() != null) {
            return;
        }
        ChildListForAccessibility children = ChildListForAccessibility.obtain(this, true);
        try {
            int childrenCount = children.getChildCount();
            for (int i = 0; i < childrenCount; ++i) {
                View child = children.getChildAt(i);
                if ((child.mViewFlags & 0xC) != 0) continue;
                if (child.includeForAccessibility()) {
                    outChildren.add(child);
                    continue;
                }
                child.addChildrenForAccessibility(outChildren);
            }
        }
        finally {
            children.recycle();
        }
    }

    private final boolean $$robo$$android_view_ViewGroup$onInterceptHoverEvent(MotionEvent event) {
        if (event.isFromSource(8194)) {
            int action = event.getAction();
            float x = event.getX();
            float y = event.getY();
            if ((action == 7 || action == 9) && this.isOnScrollbar(x, y)) {
                return true;
            }
        }
        return false;
    }

    private static final MotionEvent $$robo$$android_view_ViewGroup$obtainMotionEventNoHistoryOrSelf(MotionEvent event) {
        if (event.getHistorySize() == 0) {
            return event;
        }
        return MotionEvent.obtainNoHistory(event);
    }

    private final boolean $$robo$$android_view_ViewGroup$dispatchGenericPointerEvent(MotionEvent event) {
        int childrenCount = this.mChildrenCount;
        if (childrenCount != 0) {
            float x = event.getX();
            float y = event.getY();
            ArrayList<View> preorderedList = this.buildOrderedChildList();
            boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
            View[] children = this.mChildren;
            for (int i = childrenCount - 1; i >= 0; --i) {
                int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
                View child = ViewGroup.getAndVerifyPreorderedView(preorderedList, children, childIndex);
                if (!ViewGroup.canViewReceivePointerEvents(child) || !this.isTransformedTouchPointInView(x, y, child, null) || !this.dispatchTransformedGenericPointerEvent(event, child)) continue;
                if (preorderedList != null) {
                    preorderedList.clear();
                }
                return true;
            }
            if (preorderedList != null) {
                preorderedList.clear();
            }
        }
        return super.dispatchGenericPointerEvent(event);
    }

    private final boolean $$robo$$android_view_ViewGroup$dispatchGenericFocusedEvent(MotionEvent event) {
        if ((this.mPrivateFlags & 0x12) == 18) {
            return super.dispatchGenericFocusedEvent(event);
        }
        if (this.mFocused != null && (this.mFocused.mPrivateFlags & 0x10) == 16) {
            return this.mFocused.dispatchGenericMotionEvent(event);
        }
        return false;
    }

    private final boolean $$robo$$android_view_ViewGroup$dispatchTransformedGenericPointerEvent(MotionEvent event, View child) {
        boolean handled;
        if (!child.hasIdentityMatrix()) {
            MotionEvent transformedEvent = this.getTransformedMotionEvent(event, child);
            handled = child.dispatchGenericMotionEvent(transformedEvent);
            transformedEvent.recycle();
        } else {
            float offsetX = this.mScrollX - child.mLeft;
            float offsetY = this.mScrollY - child.mTop;
            event.offsetLocation(offsetX, offsetY);
            handled = child.dispatchGenericMotionEvent(event);
            event.offsetLocation(-offsetX, -offsetY);
        }
        return handled;
    }

    private final MotionEvent $$robo$$android_view_ViewGroup$getTransformedMotionEvent(MotionEvent event, View child) {
        float offsetX = this.mScrollX - child.mLeft;
        float offsetY = this.mScrollY - child.mTop;
        MotionEvent transformedEvent = MotionEvent.obtain(event);
        transformedEvent.offsetLocation(offsetX, offsetY);
        if (!child.hasIdentityMatrix()) {
            transformedEvent.transform(child.getInverseMatrix());
        }
        return transformedEvent;
    }

    private final boolean $$robo$$android_view_ViewGroup$dispatchTouchEvent(MotionEvent ev) {
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onTouchEvent(ev, 1);
        }
        if (ev.isTargetAccessibilityFocus() && this.isAccessibilityFocusedViewOrHost()) {
            ev.setTargetAccessibilityFocus(false);
        }
        boolean handled = false;
        if (this.onFilterTouchEventForSecurity(ev)) {
            boolean intercepted;
            int action = ev.getAction();
            int actionMasked = action & 0xFF;
            if (actionMasked == 0) {
                this.cancelAndClearTouchTargets(ev);
                this.resetTouchState();
            }
            if (actionMasked == 0 || this.mFirstTouchTarget != null) {
                boolean disallowIntercept;
                boolean bl = disallowIntercept = (this.mGroupFlags & 0x80000) != 0;
                if (!disallowIntercept) {
                    intercepted = this.onInterceptTouchEvent(ev);
                    ev.setAction(action);
                } else {
                    intercepted = false;
                }
            } else {
                intercepted = true;
            }
            if (intercepted || this.mFirstTouchTarget != null) {
                ev.setTargetAccessibilityFocus(false);
            }
            boolean canceled = ViewGroup.resetCancelNextUpFlag(this) || actionMasked == 3;
            boolean split = (this.mGroupFlags & 0x200000) != 0;
            TouchTarget newTouchTarget = null;
            boolean alreadyDispatchedToNewTouchTarget = false;
            if (!canceled && !intercepted) {
                View childWithAccessibilityFocus;
                View view = childWithAccessibilityFocus = ev.isTargetAccessibilityFocus() ? this.findChildWithAccessibilityFocus() : null;
                if (actionMasked == 0 || split && actionMasked == 5 || actionMasked == 7) {
                    int actionIndex = ev.getActionIndex();
                    int idBitsToAssign = split ? 1 << ev.getPointerId(actionIndex) : -1;
                    this.removePointersFromTouchTargets(idBitsToAssign);
                    int childrenCount = this.mChildrenCount;
                    if (newTouchTarget == null && childrenCount != 0) {
                        float x = ev.getX(actionIndex);
                        float y = ev.getY(actionIndex);
                        ArrayList<View> preorderedList = this.buildTouchDispatchChildList();
                        boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
                        View[] children = this.mChildren;
                        for (int i = childrenCount - 1; i >= 0; --i) {
                            int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
                            View child = ViewGroup.getAndVerifyPreorderedView(preorderedList, children, childIndex);
                            if (childWithAccessibilityFocus != null) {
                                if (childWithAccessibilityFocus != child) continue;
                                childWithAccessibilityFocus = null;
                                i = childrenCount - 1;
                            }
                            if (!ViewGroup.canViewReceivePointerEvents(child) || !this.isTransformedTouchPointInView(x, y, child, null)) {
                                ev.setTargetAccessibilityFocus(false);
                                continue;
                            }
                            newTouchTarget = this.getTouchTarget(child);
                            if (newTouchTarget != null) {
                                newTouchTarget.pointerIdBits |= idBitsToAssign;
                                break;
                            }
                            ViewGroup.resetCancelNextUpFlag(child);
                            if (this.dispatchTransformedTouchEvent(ev, false, child, idBitsToAssign)) {
                                this.mLastTouchDownTime = ev.getDownTime();
                                if (preorderedList != null) {
                                    for (int j = 0; j < childrenCount; ++j) {
                                        if (children[childIndex] != this.mChildren[j]) continue;
                                        this.mLastTouchDownIndex = j;
                                        break;
                                    }
                                } else {
                                    this.mLastTouchDownIndex = childIndex;
                                }
                                this.mLastTouchDownX = ev.getX();
                                this.mLastTouchDownY = ev.getY();
                                newTouchTarget = this.addTouchTarget(child, idBitsToAssign);
                                alreadyDispatchedToNewTouchTarget = true;
                                break;
                            }
                            ev.setTargetAccessibilityFocus(false);
                        }
                        if (preorderedList != null) {
                            preorderedList.clear();
                        }
                    }
                    if (newTouchTarget == null && this.mFirstTouchTarget != null) {
                        newTouchTarget = this.mFirstTouchTarget;
                        while (newTouchTarget.next != null) {
                            newTouchTarget = newTouchTarget.next;
                        }
                        newTouchTarget.pointerIdBits |= idBitsToAssign;
                    }
                }
            }
            if (this.mFirstTouchTarget == null) {
                handled = this.dispatchTransformedTouchEvent(ev, canceled, null, -1);
            } else {
                TouchTarget predecessor = null;
                TouchTarget target = this.mFirstTouchTarget;
                while (target != null) {
                    TouchTarget next = target.next;
                    if (alreadyDispatchedToNewTouchTarget && target == newTouchTarget) {
                        handled = true;
                    } else {
                        boolean cancelChild;
                        boolean bl = cancelChild = ViewGroup.resetCancelNextUpFlag(target.child) || intercepted;
                        if (this.dispatchTransformedTouchEvent(ev, cancelChild, target.child, target.pointerIdBits)) {
                            handled = true;
                        }
                        if (cancelChild) {
                            if (predecessor == null) {
                                this.mFirstTouchTarget = next;
                            } else {
                                predecessor.next = next;
                            }
                            target.recycle();
                            target = next;
                            continue;
                        }
                    }
                    predecessor = target;
                    target = next;
                }
            }
            if (canceled || actionMasked == 1 || actionMasked == 7) {
                this.resetTouchState();
            } else if (split && actionMasked == 6) {
                int actionIndex = ev.getActionIndex();
                int idBitsToRemove = 1 << ev.getPointerId(actionIndex);
                this.removePointersFromTouchTargets(idBitsToRemove);
            }
        }
        if (!handled && this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onUnhandledEvent(ev, 1);
        }
        return handled;
    }

    private final ArrayList<View> $$robo$$android_view_ViewGroup$buildTouchDispatchChildList() {
        return this.buildOrderedChildList();
    }

    private final View $$robo$$android_view_ViewGroup$findChildWithAccessibilityFocus() {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot == null) {
            return null;
        }
        View current = viewRoot.getAccessibilityFocusedHost();
        if (current == null) {
            return null;
        }
        ViewParent parent = current.getParent();
        while (parent instanceof View) {
            if (parent == this) {
                return current;
            }
            current = (View)((Object)parent);
            parent = current.getParent();
        }
        return null;
    }

    private final void $$robo$$android_view_ViewGroup$resetTouchState() {
        this.clearTouchTargets();
        ViewGroup.resetCancelNextUpFlag(this);
        this.mGroupFlags &= 0xFFF7FFFF;
        this.mNestedScrollAxes = 0;
    }

    private static final boolean $$robo$$android_view_ViewGroup$resetCancelNextUpFlag(View view) {
        if ((view.mPrivateFlags & 0x4000000) != 0) {
            view.mPrivateFlags &= 0xFBFFFFFF;
            return true;
        }
        return false;
    }

    private final void $$robo$$android_view_ViewGroup$clearTouchTargets() {
        TouchTarget target = this.mFirstTouchTarget;
        if (target != null) {
            TouchTarget next;
            do {
                next = target.next;
                target.recycle();
            } while ((target = next) != null);
            this.mFirstTouchTarget = null;
        }
    }

    private final void $$robo$$android_view_ViewGroup$cancelAndClearTouchTargets(MotionEvent event) {
        if (this.mFirstTouchTarget != null) {
            boolean syntheticEvent = false;
            if (event == null) {
                long now = SystemClock.uptimeMillis();
                event = MotionEvent.obtain(now, now, 3, 0.0f, 0.0f, 0);
                event.setSource(4098);
                syntheticEvent = true;
            }
            TouchTarget target = this.mFirstTouchTarget;
            while (target != null) {
                ViewGroup.resetCancelNextUpFlag(target.child);
                this.dispatchTransformedTouchEvent(event, true, target.child, target.pointerIdBits);
                target = target.next;
            }
            this.clearTouchTargets();
            if (syntheticEvent) {
                event.recycle();
            }
        }
    }

    private final TouchTarget $$robo$$android_view_ViewGroup$getTouchTarget(View child) {
        TouchTarget target = this.mFirstTouchTarget;
        while (target != null) {
            if (target.child == child) {
                return target;
            }
            target = target.next;
        }
        return null;
    }

    private final TouchTarget $$robo$$android_view_ViewGroup$addTouchTarget(View child, int pointerIdBits) {
        TouchTarget target = TouchTarget.obtain(child, pointerIdBits);
        target.next = this.mFirstTouchTarget;
        this.mFirstTouchTarget = target;
        return target;
    }

    private final void $$robo$$android_view_ViewGroup$removePointersFromTouchTargets(int pointerIdBits) {
        TouchTarget predecessor = null;
        TouchTarget target = this.mFirstTouchTarget;
        while (target != null) {
            TouchTarget next = target.next;
            if ((target.pointerIdBits & pointerIdBits) != 0) {
                target.pointerIdBits &= ~pointerIdBits;
                if (target.pointerIdBits == 0) {
                    if (predecessor == null) {
                        this.mFirstTouchTarget = next;
                    } else {
                        predecessor.next = next;
                    }
                    target.recycle();
                    target = next;
                    continue;
                }
            }
            predecessor = target;
            target = next;
        }
    }

    private final void $$robo$$android_view_ViewGroup$cancelTouchTarget(View view) {
        TouchTarget predecessor = null;
        TouchTarget target = this.mFirstTouchTarget;
        while (target != null) {
            TouchTarget next = target.next;
            if (target.child == view) {
                if (predecessor == null) {
                    this.mFirstTouchTarget = next;
                } else {
                    predecessor.next = next;
                }
                target.recycle();
                long now = SystemClock.uptimeMillis();
                MotionEvent event = MotionEvent.obtain(now, now, 3, 0.0f, 0.0f, 0);
                event.setSource(4098);
                view.dispatchTouchEvent(event);
                event.recycle();
                return;
            }
            predecessor = target;
            target = next;
        }
    }

    private static final boolean $$robo$$android_view_ViewGroup$canViewReceivePointerEvents(View child) {
        return (child.mViewFlags & 0xC) == 0 || child.getAnimation() != null;
    }

    private final float[] $$robo$$android_view_ViewGroup$getTempPoint() {
        if (this.mTempPoint == null) {
            this.mTempPoint = new float[2];
        }
        return this.mTempPoint;
    }

    private final boolean $$robo$$android_view_ViewGroup$isTransformedTouchPointInView(float x, float y, View child, PointF outLocalPoint) {
        float[] point = this.getTempPoint();
        point[0] = x;
        point[1] = y;
        this.transformPointToViewLocal(point, child);
        boolean isInView = child.pointInView(point[0], point[1]);
        if (isInView && outLocalPoint != null) {
            outLocalPoint.set(point[0], point[1]);
        }
        return isInView;
    }

    private final void $$robo$$android_view_ViewGroup$transformPointToViewLocal(float[] point, View child) {
        point[0] = point[0] + (float)(this.mScrollX - child.mLeft);
        point[1] = point[1] + (float)(this.mScrollY - child.mTop);
        if (!child.hasIdentityMatrix()) {
            child.getInverseMatrix().mapPoints(point);
        }
    }

    private final boolean $$robo$$android_view_ViewGroup$dispatchTransformedTouchEvent(MotionEvent event, boolean cancel, View child, int desiredPointerIdBits) {
        boolean handled;
        MotionEvent transformedEvent;
        int oldAction = event.getAction();
        if (cancel || oldAction == 3) {
            event.setAction(3);
            boolean handled2 = child == null ? super.dispatchTouchEvent(event) : child.dispatchTouchEvent(event);
            event.setAction(oldAction);
            return handled2;
        }
        int oldPointerIdBits = event.getPointerIdBits();
        int newPointerIdBits = oldPointerIdBits & desiredPointerIdBits;
        if (newPointerIdBits == 0) {
            return false;
        }
        if (newPointerIdBits == oldPointerIdBits) {
            if (child == null || child.hasIdentityMatrix()) {
                boolean handled3;
                if (child == null) {
                    handled3 = super.dispatchTouchEvent(event);
                } else {
                    float offsetX = this.mScrollX - child.mLeft;
                    float offsetY = this.mScrollY - child.mTop;
                    event.offsetLocation(offsetX, offsetY);
                    handled3 = child.dispatchTouchEvent(event);
                    event.offsetLocation(-offsetX, -offsetY);
                }
                return handled3;
            }
            transformedEvent = MotionEvent.obtain(event);
        } else {
            transformedEvent = event.split(newPointerIdBits);
        }
        if (child == null) {
            handled = super.dispatchTouchEvent(transformedEvent);
        } else {
            float offsetX = this.mScrollX - child.mLeft;
            float offsetY = this.mScrollY - child.mTop;
            transformedEvent.offsetLocation(offsetX, offsetY);
            if (!child.hasIdentityMatrix()) {
                transformedEvent.transform(child.getInverseMatrix());
            }
            handled = child.dispatchTouchEvent(transformedEvent);
        }
        transformedEvent.recycle();
        return handled;
    }

    private final void $$robo$$android_view_ViewGroup$setMotionEventSplittingEnabled(boolean split) {
        this.mGroupFlags = split ? (this.mGroupFlags |= 0x200000) : (this.mGroupFlags &= 0xFFDFFFFF);
    }

    private final boolean $$robo$$android_view_ViewGroup$isMotionEventSplittingEnabled() {
        return (this.mGroupFlags & 0x200000) == 0x200000;
    }

    private final boolean $$robo$$android_view_ViewGroup$isTransitionGroup() {
        if ((this.mGroupFlags & 0x2000000) != 0) {
            return (this.mGroupFlags & 0x1000000) != 0;
        }
        ViewOutlineProvider outlineProvider = this.getOutlineProvider();
        return this.getBackground() != null || this.getTransitionName() != null || outlineProvider != null && outlineProvider != ViewOutlineProvider.BACKGROUND;
    }

    private final void $$robo$$android_view_ViewGroup$setTransitionGroup(boolean isTransitionGroup) {
        this.mGroupFlags |= 0x2000000;
        this.mGroupFlags = isTransitionGroup ? (this.mGroupFlags |= 0x1000000) : (this.mGroupFlags &= 0xFEFFFFFF);
    }

    private final void $$robo$$android_view_ViewGroup$requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (disallowIntercept == ((this.mGroupFlags & 0x80000) != 0)) {
            return;
        }
        this.mGroupFlags = disallowIntercept ? (this.mGroupFlags |= 0x80000) : (this.mGroupFlags &= 0xFFF7FFFF);
        if (this.mParent != null) {
            this.mParent.requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    private final boolean $$robo$$android_view_ViewGroup$onInterceptTouchEvent(MotionEvent ev) {
        return ev.isFromSource(8194) && ev.getAction() == 0 && ev.isButtonPressed(1) && this.isOnScrollbarThumb(ev.getX(), ev.getY());
    }

    private final boolean $$robo$$android_view_ViewGroup$requestFocus(int direction, Rect previouslyFocusedRect) {
        boolean result;
        int descendantFocusability = this.getDescendantFocusability();
        switch (descendantFocusability) {
            case 393216: {
                result = super.requestFocus(direction, previouslyFocusedRect);
                break;
            }
            case 131072: {
                boolean took = super.requestFocus(direction, previouslyFocusedRect);
                result = took ? took : this.onRequestFocusInDescendants(direction, previouslyFocusedRect);
                break;
            }
            case 262144: {
                boolean took = this.onRequestFocusInDescendants(direction, previouslyFocusedRect);
                result = took ? took : super.requestFocus(direction, previouslyFocusedRect);
                break;
            }
            default: {
                throw new IllegalStateException("descendant focusability must be one of FOCUS_BEFORE_DESCENDANTS, FOCUS_AFTER_DESCENDANTS, FOCUS_BLOCK_DESCENDANTS but is " + descendantFocusability);
            }
        }
        if (result && !this.isLayoutValid() && (this.mPrivateFlags & 1) == 0) {
            this.mPrivateFlags |= 1;
        }
        return result;
    }

    private final boolean $$robo$$android_view_ViewGroup$onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        int end;
        int increment;
        int index;
        int count = this.mChildrenCount;
        if ((direction & 2) != 0) {
            index = 0;
            increment = 1;
            end = count;
        } else {
            index = count - 1;
            increment = -1;
            end = -1;
        }
        View[] children = this.mChildren;
        for (int i = index; i != end; i += increment) {
            View child = children[i];
            if ((child.mViewFlags & 0xC) != 0 || !child.requestFocus(direction, previouslyFocusedRect)) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_view_ViewGroup$restoreDefaultFocus() {
        if (this.mDefaultFocus != null && this.getDescendantFocusability() != 393216 && (this.mDefaultFocus.mViewFlags & 0xC) == 0 && this.mDefaultFocus.restoreDefaultFocus()) {
            return true;
        }
        return super.restoreDefaultFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_ViewGroup$restoreFocusInCluster(int direction) {
        if (this.isKeyboardNavigationCluster()) {
            boolean blockedFocus = this.getTouchscreenBlocksFocus();
            try {
                this.setTouchscreenBlocksFocusNoRefocus(false);
                boolean bl = this.restoreFocusInClusterInternal(direction);
                return bl;
            }
            finally {
                this.setTouchscreenBlocksFocusNoRefocus(blockedFocus);
            }
        }
        return this.restoreFocusInClusterInternal(direction);
    }

    private final boolean $$robo$$android_view_ViewGroup$restoreFocusInClusterInternal(int direction) {
        if (this.mFocusedInCluster != null && this.getDescendantFocusability() != 393216 && (this.mFocusedInCluster.mViewFlags & 0xC) == 0 && this.mFocusedInCluster.restoreFocusInCluster(direction)) {
            return true;
        }
        return super.restoreFocusInCluster(direction);
    }

    private final boolean $$robo$$android_view_ViewGroup$restoreFocusNotInCluster() {
        if (this.mFocusedInCluster != null) {
            return this.restoreFocusInCluster(130);
        }
        if (this.isKeyboardNavigationCluster() || (this.mViewFlags & 0xC) != 0) {
            return false;
        }
        int descendentFocusability = this.getDescendantFocusability();
        if (descendentFocusability == 393216) {
            return super.requestFocus(130, null);
        }
        if (descendentFocusability == 131072 && super.requestFocus(130, null)) {
            return true;
        }
        for (int i = 0; i < this.mChildrenCount; ++i) {
            View child = this.mChildren[i];
            if (child.isKeyboardNavigationCluster() || !child.restoreFocusNotInCluster()) continue;
            return true;
        }
        if (descendentFocusability == 262144 && !this.hasFocusableChild(false)) {
            return super.requestFocus(130, null);
        }
        return false;
    }

    private final void $$robo$$android_view_ViewGroup$dispatchStartTemporaryDetach() {
        super.dispatchStartTemporaryDetach();
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchStartTemporaryDetach();
        }
    }

    private final void $$robo$$android_view_ViewGroup$dispatchFinishTemporaryDetach() {
        super.dispatchFinishTemporaryDetach();
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchFinishTemporaryDetach();
        }
    }

    private final void $$robo$$android_view_ViewGroup$dispatchAttachedToWindow(View.AttachInfo info, int visibility) {
        this.mGroupFlags |= 0x400000;
        super.dispatchAttachedToWindow(info, visibility);
        this.mGroupFlags &= 0xFFBFFFFF;
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            child.dispatchAttachedToWindow(info, this.combineVisibility(visibility, child.getVisibility()));
        }
        int transientCount = this.mTransientIndices == null ? 0 : this.mTransientIndices.size();
        for (int i = 0; i < transientCount; ++i) {
            View view = this.mTransientViews.get(i);
            view.dispatchAttachedToWindow(info, this.combineVisibility(visibility, view.getVisibility()));
        }
    }

    private final void $$robo$$android_view_ViewGroup$dispatchScreenStateChanged(int screenState) {
        super.dispatchScreenStateChanged(screenState);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchScreenStateChanged(screenState);
        }
    }

    private final void $$robo$$android_view_ViewGroup$dispatchMovedToDisplay(Display display, Configuration config) {
        super.dispatchMovedToDisplay(display, config);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchMovedToDisplay(display, config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_ViewGroup$dispatchPopulateAccessibilityEventInternal(AccessibilityEvent event) {
        boolean handled = false;
        if (this.includeForAccessibility() && (handled = super.dispatchPopulateAccessibilityEventInternal(event))) {
            return handled;
        }
        ChildListForAccessibility children = ChildListForAccessibility.obtain(this, true);
        try {
            int childCount = children.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = children.getChildAt(i);
                if ((child.mViewFlags & 0xC) != 0 || !(handled = child.dispatchPopulateAccessibilityEvent(event))) continue;
                boolean bl = handled;
                return bl;
            }
        }
        finally {
            children.recycle();
        }
        return false;
    }

    private final void $$robo$$android_view_ViewGroup$dispatchProvideStructure(ViewStructure structure) {
        super.dispatchProvideStructure(structure);
        if (this.isAssistBlocked() || structure.getChildCount() != 0) {
            return;
        }
        int childrenCount = this.mChildrenCount;
        if (childrenCount <= 0) {
            return;
        }
        if (!this.isLaidOut()) {
            if (Helper.sVerbose) {
                Log.v("View", "dispatchProvideStructure(): not laid out, ignoring " + childrenCount + " children of " + this.getAccessibilityViewId());
            }
            return;
        }
        structure.setChildCount(childrenCount);
        ArrayList<View> preorderedList = this.buildOrderedChildList();
        boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
        for (int i = 0; i < childrenCount; ++i) {
            int childIndex;
            try {
                childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
            }
            catch (IndexOutOfBoundsException e) {
                childIndex = i;
                if (this.mContext.getApplicationInfo().targetSdkVersion < 23) {
                    Log.w("ViewGroup", "Bad getChildDrawingOrder while collecting assist @ " + i + " of " + childrenCount, e);
                    customOrder = false;
                    if (i > 0) {
                        int j;
                        int[] permutation = new int[childrenCount];
                        SparseBooleanArray usedIndices = new SparseBooleanArray();
                        for (int j2 = 0; j2 < i; ++j2) {
                            permutation[j2] = this.getChildDrawingOrder(childrenCount, j2);
                            usedIndices.put(permutation[j2], true);
                        }
                        int nextIndex = 0;
                        for (j = i; j < childrenCount; ++j) {
                            while (usedIndices.get(nextIndex, false)) {
                                ++nextIndex;
                            }
                            permutation[j] = nextIndex++;
                        }
                        preorderedList = new ArrayList(childrenCount);
                        for (j = 0; j < childrenCount; ++j) {
                            int index = permutation[j];
                            View child = this.mChildren[index];
                            preorderedList.add(child);
                        }
                    }
                }
                throw e;
            }
            View child = ViewGroup.getAndVerifyPreorderedView(preorderedList, this.mChildren, childIndex);
            ViewStructure cstructure = structure.newChild(i);
            child.dispatchProvideStructure(cstructure);
        }
        if (preorderedList != null) {
            preorderedList.clear();
        }
    }

    private final void $$robo$$android_view_ViewGroup$dispatchProvideAutofillStructure(ViewStructure structure, int flags) {
        super.dispatchProvideAutofillStructure(structure, flags);
        if (structure.getChildCount() != 0) {
            return;
        }
        if (!this.isLaidOut()) {
            if (Helper.sVerbose) {
                Log.v("View", "dispatchProvideAutofillStructure(): not laid out, ignoring " + this.mChildrenCount + " children of " + this.getAutofillId());
            }
            return;
        }
        ChildListForAutoFill children = this.getChildrenForAutofill(flags);
        int childrenCount = children.size();
        structure.setChildCount(childrenCount);
        for (int i = 0; i < childrenCount; ++i) {
            View child = (View)children.get(i);
            ViewStructure cstructure = structure.newChild(i);
            child.dispatchProvideAutofillStructure(cstructure, flags);
        }
        children.recycle();
    }

    private final ChildListForAutoFill $$robo$$android_view_ViewGroup$getChildrenForAutofill(int flags) {
        ChildListForAutoFill children = ChildListForAutoFill.obtain();
        this.populateChildrenForAutofill(children, flags);
        return children;
    }

    private final void $$robo$$android_view_ViewGroup$populateChildrenForAutofill(ArrayList<View> list, int flags) {
        int childrenCount = this.mChildrenCount;
        if (childrenCount <= 0) {
            return;
        }
        ArrayList<View> preorderedList = this.buildOrderedChildList();
        boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
        for (int i = 0; i < childrenCount; ++i) {
            View child;
            int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
            View view = child = preorderedList == null ? this.mChildren[childIndex] : preorderedList.get(childIndex);
            if ((flags & 1) != 0 || child.isImportantForAutofill()) {
                list.add(child);
                continue;
            }
            if (!(child instanceof ViewGroup)) continue;
            ((ViewGroup)child).populateChildrenForAutofill(list, flags);
        }
    }

    private static final View $$robo$$android_view_ViewGroup$getAndVerifyPreorderedView(ArrayList<View> preorderedList, View[] children, int childIndex) {
        View child;
        if (preorderedList != null) {
            child = preorderedList.get(childIndex);
            if (child == null) {
                throw new RuntimeException("Invalid preorderedList contained null child at index " + childIndex);
            }
        } else {
            child = children[childIndex];
        }
        return child;
    }

    private final void $$robo$$android_view_ViewGroup$onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        if (this.getAccessibilityNodeProvider() != null) {
            return;
        }
        if (this.mAttachInfo != null) {
            ArrayList<View> childrenForAccessibility = this.mAttachInfo.mTempArrayList;
            childrenForAccessibility.clear();
            this.addChildrenForAccessibility(childrenForAccessibility);
            int childrenForAccessibilityCount = childrenForAccessibility.size();
            for (int i = 0; i < childrenForAccessibilityCount; ++i) {
                View child = childrenForAccessibility.get(i);
                info.addChildUnchecked(child);
            }
            childrenForAccessibility.clear();
        }
    }

    private final CharSequence $$robo$$android_view_ViewGroup$getAccessibilityClassName() {
        return ViewGroup.class.getName();
    }

    private final void $$robo$$android_view_ViewGroup$notifySubtreeAccessibilityStateChanged(View child, View source, int changeType) {
        if (this.getAccessibilityLiveRegion() != 0) {
            this.notifyViewAccessibilityStateChangedIfNeeded(1);
        } else if (this.mParent != null) {
            try {
                this.mParent.notifySubtreeAccessibilityStateChanged(this, source, changeType);
            }
            catch (AbstractMethodError e) {
                Log.e("View", this.mParent.getClass().getSimpleName() + " does not fully implement ViewParent", e);
            }
        }
    }

    private final void $$robo$$android_view_ViewGroup$notifySubtreeAccessibilityStateChangedIfNeeded() {
        ViewParent a11yParent;
        if (!AccessibilityManager.getInstance(this.mContext).isEnabled() || this.mAttachInfo == null) {
            return;
        }
        if (this.getImportantForAccessibility() != 4 && !this.isImportantForAccessibility() && this.getChildCount() > 0 && (a11yParent = this.getParentForAccessibility()) instanceof View) {
            ((View)((Object)a11yParent)).notifySubtreeAccessibilityStateChangedIfNeeded();
            return;
        }
        super.notifySubtreeAccessibilityStateChangedIfNeeded();
    }

    private final void $$robo$$android_view_ViewGroup$resetSubtreeAccessibilityStateChanged() {
        super.resetSubtreeAccessibilityStateChanged();
        View[] children = this.mChildren;
        int childCount = this.mChildrenCount;
        for (int i = 0; i < childCount; ++i) {
            children[i].resetSubtreeAccessibilityStateChanged();
        }
    }

    private final int $$robo$$android_view_ViewGroup$getNumChildrenForAccessibility() {
        int numChildrenForAccessibility = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.includeForAccessibility()) {
                ++numChildrenForAccessibility;
                continue;
            }
            if (!(child instanceof ViewGroup)) continue;
            numChildrenForAccessibility += ((ViewGroup)child).getNumChildrenForAccessibility();
        }
        return numChildrenForAccessibility;
    }

    private final boolean $$robo$$android_view_ViewGroup$onNestedPrePerformAccessibilityAction(View target, int action, Bundle args) {
        return false;
    }

    private final void $$robo$$android_view_ViewGroup$dispatchDetachedFromWindow() {
        this.cancelAndClearTouchTargets(null);
        this.exitHoverTargets();
        this.exitTooltipHoverTargets();
        this.mLayoutCalledWhileSuppressed = false;
        this.mChildrenInterestedInDrag = null;
        this.mIsInterestedInDrag = false;
        if (this.mCurrentDragStartEvent != null) {
            this.mCurrentDragStartEvent.recycle();
            this.mCurrentDragStartEvent = null;
        }
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchDetachedFromWindow();
        }
        this.clearDisappearingChildren();
        int transientCount = this.mTransientViews == null ? 0 : this.mTransientIndices.size();
        for (int i = 0; i < transientCount; ++i) {
            View view = this.mTransientViews.get(i);
            view.dispatchDetachedFromWindow();
        }
        super.dispatchDetachedFromWindow();
    }

    private final void $$robo$$android_view_ViewGroup$internalSetPadding(int left, int top, int right, int bottom) {
        super.internalSetPadding(left, top, right, bottom);
        this.mGroupFlags = (this.mPaddingLeft | this.mPaddingTop | this.mPaddingRight | this.mPaddingBottom) != 0 ? (this.mGroupFlags |= 0x20) : (this.mGroupFlags &= 0xFFFFFFDF);
    }

    private final void $$robo$$android_view_ViewGroup$dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        super.dispatchSaveInstanceState(container);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View c = children[i];
            if ((c.mViewFlags & 0x20000000) == 0x20000000) continue;
            c.dispatchSaveInstanceState(container);
        }
    }

    private final void $$robo$$android_view_ViewGroup$dispatchFreezeSelfOnly(SparseArray<Parcelable> container) {
        super.dispatchSaveInstanceState(container);
    }

    private final void $$robo$$android_view_ViewGroup$dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        super.dispatchRestoreInstanceState(container);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View c = children[i];
            if ((c.mViewFlags & 0x20000000) == 0x20000000) continue;
            c.dispatchRestoreInstanceState(container);
        }
    }

    private final void $$robo$$android_view_ViewGroup$dispatchThawSelfOnly(SparseArray<Parcelable> container) {
        super.dispatchRestoreInstanceState(container);
    }

    @Deprecated
    private final void $$robo$$android_view_ViewGroup$setChildrenDrawingCacheEnabled(boolean enabled) {
        if (enabled || (this.mPersistentDrawingCache & 3) != 3) {
            View[] children = this.mChildren;
            int count = this.mChildrenCount;
            for (int i = 0; i < count; ++i) {
                children[i].setDrawingCacheEnabled(enabled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bitmap $$robo$$android_view_ViewGroup$createSnapshot(ViewDebug.CanvasProvider canvasProvider, boolean skipChildren) {
        Bitmap bitmap;
        block7: {
            int count = this.mChildrenCount;
            int[] visibilities = null;
            if (skipChildren) {
                visibilities = new int[count];
                for (int i = 0; i < count; ++i) {
                    View child = this.getChildAt(i);
                    visibilities[i] = child.getVisibility();
                    if (visibilities[i] != 0) continue;
                    child.mViewFlags = child.mViewFlags & 0xFFFFFFF3 | 4;
                }
            }
            try {
                bitmap = super.createSnapshot(canvasProvider, skipChildren);
                if (!skipChildren) break block7;
            }
            catch (Throwable throwable) {
                if (skipChildren) {
                    for (int i = 0; i < count; ++i) {
                        View child = this.getChildAt(i);
                        child.mViewFlags = child.mViewFlags & 0xFFFFFFF3 | visibilities[i] & 0xC;
                    }
                }
                throw throwable;
            }
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                child.mViewFlags = child.mViewFlags & 0xFFFFFFF3 | visibilities[i] & 0xC;
            }
        }
        return bitmap;
    }

    private final boolean $$robo$$android_view_ViewGroup$isLayoutModeOptical() {
        return this.mLayoutMode == 1;
    }

    private final Insets $$robo$$android_view_ViewGroup$computeOpticalInsets() {
        if (this.isLayoutModeOptical()) {
            int left = 0;
            int top = 0;
            int right = 0;
            int bottom = 0;
            for (int i = 0; i < this.mChildrenCount; ++i) {
                View child = this.getChildAt(i);
                if (child.getVisibility() != 0) continue;
                Insets insets = child.getOpticalInsets();
                left = Math.max(left, insets.left);
                top = Math.max(top, insets.top);
                right = Math.max(right, insets.right);
                bottom = Math.max(bottom, insets.bottom);
            }
            return Insets.of(left, top, right, bottom);
        }
        return Insets.NONE;
    }

    private static final void $$robo$$android_view_ViewGroup$fillRect(Canvas canvas, Paint paint, int x1, int y1, int x2, int y2) {
        if (x1 != x2 && y1 != y2) {
            int tmp;
            if (x1 > x2) {
                tmp = x1;
                x1 = x2;
                x2 = tmp;
            }
            if (y1 > y2) {
                tmp = y1;
                y1 = y2;
                y2 = tmp;
            }
            canvas.drawRect(x1, y1, x2, y2, paint);
        }
    }

    private static final int $$robo$$android_view_ViewGroup$sign(int x) {
        return x >= 0 ? 1 : -1;
    }

    private static final void $$robo$$android_view_ViewGroup$drawCorner(Canvas c, Paint paint, int x1, int y1, int dx, int dy, int lw) {
        ViewGroup.fillRect(c, paint, x1, y1, x1 + dx, y1 + lw * ViewGroup.sign(dy));
        ViewGroup.fillRect(c, paint, x1, y1, x1 + lw * ViewGroup.sign(dx), y1 + dy);
    }

    private static final void $$robo$$android_view_ViewGroup$drawRectCorners(Canvas canvas, int x1, int y1, int x2, int y2, Paint paint, int lineLength, int lineWidth) {
        ViewGroup.drawCorner(canvas, paint, x1, y1, lineLength, lineLength, lineWidth);
        ViewGroup.drawCorner(canvas, paint, x1, y2, lineLength, -lineLength, lineWidth);
        ViewGroup.drawCorner(canvas, paint, x2, y1, -lineLength, lineLength, lineWidth);
        ViewGroup.drawCorner(canvas, paint, x2, y2, -lineLength, -lineLength, lineWidth);
    }

    private static final void $$robo$$android_view_ViewGroup$fillDifference(Canvas canvas, int x2, int y2, int x3, int y3, int dx1, int dy1, int dx2, int dy2, Paint paint) {
        int x1 = x2 - dx1;
        int y1 = y2 - dy1;
        int x4 = x3 + dx2;
        int y4 = y3 + dy2;
        ViewGroup.fillRect(canvas, paint, x1, y1, x4, y2);
        ViewGroup.fillRect(canvas, paint, x1, y2, x2, y3);
        ViewGroup.fillRect(canvas, paint, x3, y2, x4, y3);
        ViewGroup.fillRect(canvas, paint, x1, y3, x4, y4);
    }

    private final void $$robo$$android_view_ViewGroup$onDebugDrawMargins(Canvas canvas, Paint paint) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View c = this.getChildAt(i);
            c.getLayoutParams().onDebugDraw(c, canvas, paint);
        }
    }

    private final void $$robo$$android_view_ViewGroup$onDebugDraw(Canvas canvas) {
        Paint paint = ViewGroup.getDebugPaint();
        paint.setColor(-65536);
        paint.setStyle(Paint.Style.STROKE);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View c = this.getChildAt(i);
            if (c.getVisibility() == 8) continue;
            Insets insets = c.getOpticalInsets();
            ViewGroup.drawRect(canvas, paint, c.getLeft() + insets.left, c.getTop() + insets.top, c.getRight() - insets.right - 1, c.getBottom() - insets.bottom - 1);
        }
        paint.setColor(Color.argb(63, 255, 0, 255));
        paint.setStyle(Paint.Style.FILL);
        this.onDebugDrawMargins(canvas, paint);
        paint.setColor(DEBUG_CORNERS_COLOR);
        paint.setStyle(Paint.Style.FILL);
        int lineLength = this.dipsToPixels(8);
        int lineWidth = this.dipsToPixels(1);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View c = this.getChildAt(i);
            if (c.getVisibility() == 8) continue;
            ViewGroup.drawRectCorners(canvas, c.getLeft(), c.getTop(), c.getRight(), c.getBottom(), paint, lineLength, lineWidth);
        }
    }

    private final void $$robo$$android_view_ViewGroup$dispatchDraw(Canvas canvas) {
        boolean clipToPadding;
        boolean usingRenderNodeProperties = canvas.isRecordingFor(this.mRenderNode);
        int childrenCount = this.mChildrenCount;
        View[] children = this.mChildren;
        int flags = this.mGroupFlags;
        if ((flags & 8) != 0 && this.canAnimate()) {
            boolean buildCache = !this.isHardwareAccelerated();
            for (int i = 0; i < childrenCount; ++i) {
                View child = children[i];
                if ((child.mViewFlags & 0xC) != 0) continue;
                LayoutParams params = child.getLayoutParams();
                this.attachLayoutAnimationParameters(child, params, i, childrenCount);
                this.bindLayoutAnimation(child);
            }
            LayoutAnimationController controller = this.mLayoutAnimationController;
            if (controller.willOverlap()) {
                this.mGroupFlags |= 0x80;
            }
            controller.start();
            this.mGroupFlags &= 0xFFFFFFF7;
            this.mGroupFlags &= 0xFFFFFFEF;
            if (this.mAnimationListener != null) {
                this.mAnimationListener.onAnimationStart(controller.getAnimation());
            }
        }
        int clipSaveCount = 0;
        boolean bl = clipToPadding = (flags & 0x22) == 34;
        if (clipToPadding) {
            clipSaveCount = canvas.save(2);
            canvas.clipRect(this.mScrollX + this.mPaddingLeft, this.mScrollY + this.mPaddingTop, this.mScrollX + this.mRight - this.mLeft - this.mPaddingRight, this.mScrollY + this.mBottom - this.mTop - this.mPaddingBottom);
        }
        this.mPrivateFlags &= 0xFFFFFFBF;
        this.mGroupFlags &= 0xFFFFFFFB;
        boolean more = false;
        long drawingTime = this.getDrawingTime();
        if (usingRenderNodeProperties) {
            canvas.insertReorderBarrier();
        }
        int transientCount = this.mTransientIndices == null ? 0 : this.mTransientIndices.size();
        int transientIndex = transientCount != 0 ? 0 : -1;
        ArrayList<View> preorderedList = usingRenderNodeProperties ? null : this.buildOrderedChildList();
        boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
        for (int i = 0; i < childrenCount; ++i) {
            while (transientIndex >= 0 && this.mTransientIndices.get(transientIndex) == i) {
                View transientChild = this.mTransientViews.get(transientIndex);
                if ((transientChild.mViewFlags & 0xC) == 0 || transientChild.getAnimation() != null) {
                    more |= this.drawChild(canvas, transientChild, drawingTime);
                }
                if (++transientIndex < transientCount) continue;
                transientIndex = -1;
            }
            int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
            View child = ViewGroup.getAndVerifyPreorderedView(preorderedList, children, childIndex);
            if ((child.mViewFlags & 0xC) != 0 && child.getAnimation() == null) continue;
            more |= this.drawChild(canvas, child, drawingTime);
        }
        while (transientIndex >= 0) {
            View transientChild = this.mTransientViews.get(transientIndex);
            if ((transientChild.mViewFlags & 0xC) == 0 || transientChild.getAnimation() != null) {
                more |= this.drawChild(canvas, transientChild, drawingTime);
            }
            if (++transientIndex < transientCount) continue;
            break;
        }
        if (preorderedList != null) {
            preorderedList.clear();
        }
        if (this.mDisappearingChildren != null) {
            int disappearingCount;
            ArrayList<View> disappearingChildren = this.mDisappearingChildren;
            for (int i = disappearingCount = disappearingChildren.size() - 1; i >= 0; --i) {
                View child = disappearingChildren.get(i);
                more |= this.drawChild(canvas, child, drawingTime);
            }
        }
        if (usingRenderNodeProperties) {
            canvas.insertInorderBarrier();
        }
        if (this.debugDraw()) {
            this.onDebugDraw(canvas);
        }
        if (clipToPadding) {
            canvas.restoreToCount(clipSaveCount);
        }
        if (((flags = this.mGroupFlags) & 4) == 4) {
            this.invalidate(true);
        }
        if ((flags & 0x10) == 0 && (flags & 0x200) == 0 && this.mLayoutAnimationController.isDone() && !more) {
            this.mGroupFlags |= 0x200;
            Runnable end = new Runnable(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ViewGroup this$0;

                private void $$robo$$android_view_ViewGroup_2$__constructor__(ViewGroup this$0) {
                }

                private final void $$robo$$android_view_ViewGroup_2$run() {
                    this.this$0.notifyAnimationListener();
                }

                private void __constructor__(ViewGroup viewGroup) {
                    this.$$robo$$android_view_ViewGroup_2$__constructor__(viewGroup);
                }
                {
                    this.this$0 = viewGroup;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewGroup_2$__constructor__(android.view.ViewGroup ), 0, this, viewGroup);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_view_ViewGroup_2$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.post(end);
        }
    }

    private final ViewGroupOverlay $$robo$$android_view_ViewGroup$getOverlay() {
        if (this.mOverlay == null) {
            this.mOverlay = new ViewGroupOverlay(this.mContext, this);
        }
        return (ViewGroupOverlay)this.mOverlay;
    }

    private final int $$robo$$android_view_ViewGroup$getChildDrawingOrder(int childCount, int i) {
        return i;
    }

    private final boolean $$robo$$android_view_ViewGroup$hasChildWithZ() {
        for (int i = 0; i < this.mChildrenCount; ++i) {
            if (this.mChildren[i].getZ() == 0.0f) continue;
            return true;
        }
        return false;
    }

    private final ArrayList<View> $$robo$$android_view_ViewGroup$buildOrderedChildList() {
        int childrenCount = this.mChildrenCount;
        if (childrenCount <= 1 || !this.hasChildWithZ()) {
            return null;
        }
        if (this.mPreSortedChildren == null) {
            this.mPreSortedChildren = new ArrayList(childrenCount);
        } else {
            this.mPreSortedChildren.clear();
            this.mPreSortedChildren.ensureCapacity(childrenCount);
        }
        boolean customOrder = this.isChildrenDrawingOrderEnabled();
        for (int i = 0; i < childrenCount; ++i) {
            int insertIndex;
            int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
            View nextChild = this.mChildren[childIndex];
            float currentZ = nextChild.getZ();
            for (insertIndex = i; insertIndex > 0 && this.mPreSortedChildren.get(insertIndex - 1).getZ() > currentZ; --insertIndex) {
            }
            this.mPreSortedChildren.add(insertIndex, nextChild);
        }
        return this.mPreSortedChildren;
    }

    private final void $$robo$$android_view_ViewGroup$notifyAnimationListener() {
        this.mGroupFlags &= 0xFFFFFDFF;
        this.mGroupFlags |= 0x10;
        if (this.mAnimationListener != null) {
            Runnable end = new Runnable(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ViewGroup this$0;

                private void $$robo$$android_view_ViewGroup_3$__constructor__(ViewGroup this$0) {
                }

                private final void $$robo$$android_view_ViewGroup_3$run() {
                    this.this$0.mAnimationListener.onAnimationEnd(this.this$0.mLayoutAnimationController.getAnimation());
                }

                private void __constructor__(ViewGroup viewGroup) {
                    this.$$robo$$android_view_ViewGroup_3$__constructor__(viewGroup);
                }
                {
                    this.this$0 = viewGroup;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewGroup_3$__constructor__(android.view.ViewGroup ), 0, this, viewGroup);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_view_ViewGroup_3$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.post(end);
        }
        this.invalidate(true);
    }

    private final void $$robo$$android_view_ViewGroup$dispatchGetDisplayList() {
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            if ((child.mViewFlags & 0xC) != 0 && child.getAnimation() == null) continue;
            this.recreateChildDisplayList(child);
        }
        int transientCount = this.mTransientViews == null ? 0 : this.mTransientIndices.size();
        for (int i = 0; i < transientCount; ++i) {
            View child = this.mTransientViews.get(i);
            if ((child.mViewFlags & 0xC) != 0 && child.getAnimation() == null) continue;
            this.recreateChildDisplayList(child);
        }
        if (this.mOverlay != null) {
            ViewGroup overlayView = this.mOverlay.getOverlayView();
            this.recreateChildDisplayList(overlayView);
        }
        if (this.mDisappearingChildren != null) {
            ArrayList<View> disappearingChildren = this.mDisappearingChildren;
            int disappearingCount = disappearingChildren.size();
            for (int i = 0; i < disappearingCount; ++i) {
                View child = disappearingChildren.get(i);
                this.recreateChildDisplayList(child);
            }
        }
    }

    private final void $$robo$$android_view_ViewGroup$recreateChildDisplayList(View child) {
        child.mRecreateDisplayList = (child.mPrivateFlags & Integer.MIN_VALUE) != 0;
        child.mPrivateFlags &= Integer.MAX_VALUE;
        child.updateDisplayListIfDirty();
        child.mRecreateDisplayList = false;
    }

    private final boolean $$robo$$android_view_ViewGroup$drawChild(Canvas canvas, View child, long drawingTime) {
        return child.draw(canvas, this, drawingTime);
    }

    private final void $$robo$$android_view_ViewGroup$getScrollIndicatorBounds(Rect out) {
        boolean clipToPadding;
        super.getScrollIndicatorBounds(out);
        boolean bl = clipToPadding = (this.mGroupFlags & 0x22) == 34;
        if (clipToPadding) {
            out.left += this.mPaddingLeft;
            out.right -= this.mPaddingRight;
            out.top += this.mPaddingTop;
            out.bottom -= this.mPaddingBottom;
        }
    }

    @ViewDebug.ExportedProperty(category="drawing")
    private final boolean $$robo$$android_view_ViewGroup$getClipChildren() {
        return (this.mGroupFlags & 1) != 0;
    }

    private final void $$robo$$android_view_ViewGroup$setClipChildren(boolean clipChildren) {
        boolean previousValue;
        boolean bl = previousValue = (this.mGroupFlags & 1) == 1;
        if (clipChildren != previousValue) {
            this.setBooleanFlag(1, clipChildren);
            for (int i = 0; i < this.mChildrenCount; ++i) {
                View child = this.getChildAt(i);
                if (child.mRenderNode == null) continue;
                child.mRenderNode.setClipToBounds(clipChildren);
            }
            this.invalidate(true);
        }
    }

    private final void $$robo$$android_view_ViewGroup$setClipToPadding(boolean clipToPadding) {
        if (this.hasBooleanFlag(2) != clipToPadding) {
            this.setBooleanFlag(2, clipToPadding);
            this.invalidate(true);
        }
    }

    @ViewDebug.ExportedProperty(category="drawing")
    private final boolean $$robo$$android_view_ViewGroup$getClipToPadding() {
        return this.hasBooleanFlag(2);
    }

    private final void $$robo$$android_view_ViewGroup$dispatchSetSelected(boolean selected) {
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            children[i].setSelected(selected);
        }
    }

    private final void $$robo$$android_view_ViewGroup$dispatchSetActivated(boolean activated) {
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            children[i].setActivated(activated);
        }
    }

    private final void $$robo$$android_view_ViewGroup$dispatchSetPressed(boolean pressed) {
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            if (pressed && (child.isClickable() || child.isLongClickable())) continue;
            child.setPressed(pressed);
        }
    }

    private final void $$robo$$android_view_ViewGroup$dispatchDrawableHotspotChanged(float x, float y) {
        int count = this.mChildrenCount;
        if (count == 0) {
            return;
        }
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            boolean duplicatesState;
            View child = children[i];
            boolean nonActionable = !child.isClickable() && !child.isLongClickable();
            boolean bl = duplicatesState = (child.mViewFlags & 0x400000) != 0;
            if (!nonActionable && !duplicatesState) continue;
            float[] point = this.getTempPoint();
            point[0] = x;
            point[1] = y;
            this.transformPointToViewLocal(point, child);
            child.drawableHotspotChanged(point[0], point[1]);
        }
    }

    private final void $$robo$$android_view_ViewGroup$dispatchCancelPendingInputEvents() {
        super.dispatchCancelPendingInputEvents();
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchCancelPendingInputEvents();
        }
    }

    private final void $$robo$$android_view_ViewGroup$setStaticTransformationsEnabled(boolean enabled) {
        this.setBooleanFlag(2048, enabled);
    }

    private final boolean $$robo$$android_view_ViewGroup$getChildStaticTransformation(View child, Transformation t) {
        return false;
    }

    private final Transformation $$robo$$android_view_ViewGroup$getChildTransformation() {
        if (this.mChildTransformation == null) {
            this.mChildTransformation = new Transformation();
        }
        return this.mChildTransformation;
    }

    private final <T extends View> T $$robo$$android_view_ViewGroup$findViewTraversal(int id2) {
        if (id2 == this.mID) {
            return (T)this;
        }
        View[] where = this.mChildren;
        int len = this.mChildrenCount;
        for (int i = 0; i < len; ++i) {
            View v = where[i];
            if ((v.mPrivateFlags & 8) != 0 || (v = v.findViewById(id2)) == null) continue;
            return (T)v;
        }
        return null;
    }

    private final <T extends View> T $$robo$$android_view_ViewGroup$findViewWithTagTraversal(Object tag) {
        if (tag != null && tag.equals(this.mTag)) {
            return (T)this;
        }
        View[] where = this.mChildren;
        int len = this.mChildrenCount;
        for (int i = 0; i < len; ++i) {
            View v = where[i];
            if ((v.mPrivateFlags & 8) != 0 || (v = v.findViewWithTag(tag)) == null) continue;
            return (T)v;
        }
        return null;
    }

    private final <T extends View> T $$robo$$android_view_ViewGroup$findViewByPredicateTraversal(Predicate<View> predicate, View childToSkip) {
        if (predicate.test(this)) {
            return (T)this;
        }
        View[] where = this.mChildren;
        int len = this.mChildrenCount;
        for (int i = 0; i < len; ++i) {
            View v = where[i];
            if (v == childToSkip || (v.mPrivateFlags & 8) != 0 || (v = v.findViewByPredicate(predicate)) == null) continue;
            return (T)v;
        }
        return null;
    }

    private final void $$robo$$android_view_ViewGroup$addTransientView(View view, int index) {
        int oldSize;
        if (index < 0) {
            return;
        }
        if (this.mTransientIndices == null) {
            this.mTransientIndices = new ArrayList<Integer>();
            this.mTransientViews = new ArrayList<View>();
        }
        if ((oldSize = this.mTransientIndices.size()) > 0) {
            int insertionIndex;
            for (insertionIndex = 0; insertionIndex < oldSize && index >= this.mTransientIndices.get(insertionIndex); ++insertionIndex) {
            }
            this.mTransientIndices.add(insertionIndex, index);
            this.mTransientViews.add(insertionIndex, view);
        } else {
            this.mTransientIndices.add(index);
            this.mTransientViews.add(view);
        }
        view.mParent = this;
        view.dispatchAttachedToWindow(this.mAttachInfo, this.mViewFlags & 0xC);
        this.invalidate(true);
    }

    private final void $$robo$$android_view_ViewGroup$removeTransientView(View view) {
        if (this.mTransientViews == null) {
            return;
        }
        int size = this.mTransientViews.size();
        for (int i = 0; i < size; ++i) {
            if (view != this.mTransientViews.get(i)) continue;
            this.mTransientViews.remove(i);
            this.mTransientIndices.remove(i);
            view.mParent = null;
            view.dispatchDetachedFromWindow();
            this.invalidate(true);
            return;
        }
    }

    private final int $$robo$$android_view_ViewGroup$getTransientViewCount() {
        return this.mTransientIndices == null ? 0 : this.mTransientIndices.size();
    }

    private final int $$robo$$android_view_ViewGroup$getTransientViewIndex(int position) {
        if (position < 0 || this.mTransientIndices == null || position >= this.mTransientIndices.size()) {
            return -1;
        }
        return this.mTransientIndices.get(position);
    }

    private final View $$robo$$android_view_ViewGroup$getTransientView(int position) {
        if (this.mTransientViews == null || position >= this.mTransientViews.size()) {
            return null;
        }
        return this.mTransientViews.get(position);
    }

    private final void $$robo$$android_view_ViewGroup$addView(View child) {
        this.addView(child, -1);
    }

    private final void $$robo$$android_view_ViewGroup$addView(View child, int index) {
        if (child == null) {
            throw new IllegalArgumentException("Cannot add a null child view to a ViewGroup");
        }
        LayoutParams params = child.getLayoutParams();
        if (params == null && (params = this.generateDefaultLayoutParams()) == null) {
            throw new IllegalArgumentException("generateDefaultLayoutParams() cannot return null");
        }
        this.addView(child, index, params);
    }

    private final void $$robo$$android_view_ViewGroup$addView(View child, int width, int height) {
        LayoutParams params = this.generateDefaultLayoutParams();
        params.width = width;
        params.height = height;
        this.addView(child, -1, params);
    }

    private final void $$robo$$android_view_ViewGroup$addView(View child, LayoutParams params) {
        this.addView(child, -1, params);
    }

    private final void $$robo$$android_view_ViewGroup$addView(View child, int index, LayoutParams params) {
        if (child == null) {
            throw new IllegalArgumentException("Cannot add a null child view to a ViewGroup");
        }
        this.requestLayout();
        this.invalidate(true);
        this.addViewInner(child, index, params, false);
    }

    private final void $$robo$$android_view_ViewGroup$updateViewLayout(View view, LayoutParams params) {
        if (!this.checkLayoutParams(params)) {
            throw new IllegalArgumentException("Invalid LayoutParams supplied to " + this);
        }
        if (view.mParent != this) {
            throw new IllegalArgumentException("Given view not a child of " + this);
        }
        view.setLayoutParams(params);
    }

    private final boolean $$robo$$android_view_ViewGroup$checkLayoutParams(LayoutParams p) {
        return p != null;
    }

    private final void $$robo$$android_view_ViewGroup$setOnHierarchyChangeListener(OnHierarchyChangeListener listener) {
        this.mOnHierarchyChangeListener = listener;
    }

    private final void $$robo$$android_view_ViewGroup$dispatchViewAdded(View child) {
        this.onViewAdded(child);
        if (this.mOnHierarchyChangeListener != null) {
            this.mOnHierarchyChangeListener.onChildViewAdded(this, child);
        }
    }

    private final void $$robo$$android_view_ViewGroup$onViewAdded(View child) {
    }

    private final void $$robo$$android_view_ViewGroup$dispatchViewRemoved(View child) {
        this.onViewRemoved(child);
        if (this.mOnHierarchyChangeListener != null) {
            this.mOnHierarchyChangeListener.onChildViewRemoved(this, child);
        }
    }

    private final void $$robo$$android_view_ViewGroup$onViewRemoved(View child) {
    }

    private final void $$robo$$android_view_ViewGroup$clearCachedLayoutMode() {
        if (!this.hasBooleanFlag(0x800000)) {
            this.mLayoutMode = -1;
        }
    }

    private final void $$robo$$android_view_ViewGroup$onAttachedToWindow() {
        super.onAttachedToWindow();
        this.clearCachedLayoutMode();
    }

    private final void $$robo$$android_view_ViewGroup$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.clearCachedLayoutMode();
    }

    private final void $$robo$$android_view_ViewGroup$destroyHardwareResources() {
        super.destroyHardwareResources();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.getChildAt(i).destroyHardwareResources();
        }
    }

    private final boolean $$robo$$android_view_ViewGroup$addViewInLayout(View child, int index, LayoutParams params) {
        return this.addViewInLayout(child, index, params, false);
    }

    private final boolean $$robo$$android_view_ViewGroup$addViewInLayout(View child, int index, LayoutParams params, boolean preventRequestLayout) {
        if (child == null) {
            throw new IllegalArgumentException("Cannot add a null child view to a ViewGroup");
        }
        child.mParent = null;
        this.addViewInner(child, index, params, preventRequestLayout);
        child.mPrivateFlags = child.mPrivateFlags & 0xFF9FFFFF | 0x20;
        return true;
    }

    private final void $$robo$$android_view_ViewGroup$cleanupLayoutState(View child) {
        child.mPrivateFlags &= 0xFFFFEFFF;
    }

    private final void $$robo$$android_view_ViewGroup$addViewInner(View child, int index, LayoutParams params, boolean preventRequestLayout) {
        View.AttachInfo ai;
        boolean childHasFocus;
        if (this.mTransition != null) {
            this.mTransition.cancel(3);
        }
        if (child.getParent() != null) {
            throw new IllegalStateException("The specified child already has a parent. You must call removeView() on the child's parent first.");
        }
        if (this.mTransition != null) {
            this.mTransition.addChild(this, child);
        }
        if (!this.checkLayoutParams(params)) {
            params = this.generateLayoutParams(params);
        }
        if (preventRequestLayout) {
            child.mLayoutParams = params;
        } else {
            child.setLayoutParams(params);
        }
        if (index < 0) {
            index = this.mChildrenCount;
        }
        this.addInArray(child, index);
        if (preventRequestLayout) {
            child.assignParent(this);
        } else {
            child.mParent = this;
        }
        if (child.hasUnhandledKeyListener()) {
            this.incrementChildUnhandledKeyListeners();
        }
        if (childHasFocus = child.hasFocus()) {
            this.requestChildFocus(child, child.findFocus());
        }
        if ((ai = this.mAttachInfo) != null && (this.mGroupFlags & 0x400000) == 0) {
            boolean lastKeepOn = ai.mKeepScreenOn;
            ai.mKeepScreenOn = false;
            child.dispatchAttachedToWindow(this.mAttachInfo, this.mViewFlags & 0xC);
            if (ai.mKeepScreenOn) {
                this.needGlobalAttributesUpdate(true);
            }
            ai.mKeepScreenOn = lastKeepOn;
        }
        if (child.isLayoutDirectionInherited()) {
            child.resetRtlProperties();
        }
        this.dispatchViewAdded(child);
        if ((child.mViewFlags & 0x400000) == 0x400000) {
            this.mGroupFlags |= 0x10000;
        }
        if (child.hasTransientState()) {
            this.childHasTransientStateChanged(child, true);
        }
        if (child.getVisibility() != 8) {
            this.notifySubtreeAccessibilityStateChangedIfNeeded();
        }
        if (this.mTransientIndices != null) {
            int transientCount = this.mTransientIndices.size();
            for (int i = 0; i < transientCount; ++i) {
                int oldIndex = this.mTransientIndices.get(i);
                if (index > oldIndex) continue;
                this.mTransientIndices.set(i, oldIndex + 1);
            }
        }
        if (this.mCurrentDragStartEvent != null && child.getVisibility() == 0) {
            this.notifyChildOfDragStart(child);
        }
        if (child.hasDefaultFocus()) {
            this.setDefaultFocus(child);
        }
        this.touchAccessibilityNodeProviderIfNeeded(child);
    }

    private final void $$robo$$android_view_ViewGroup$touchAccessibilityNodeProviderIfNeeded(View child) {
        if (this.mContext.isAutofillCompatibilityEnabled()) {
            child.getAccessibilityNodeProvider();
        }
    }

    private final void $$robo$$android_view_ViewGroup$addInArray(View child, int index) {
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        int size = children.length;
        if (index == count) {
            if (size == count) {
                this.mChildren = new View[size + 12];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)children, (int)0, (Object)this.mChildren, (int)0, (int)size);
                children = this.mChildren;
            }
            children[this.mChildrenCount++] = child;
        } else if (index < count) {
            if (size == count) {
                this.mChildren = new View[size + 12];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)children, (int)0, (Object)this.mChildren, (int)0, (int)index);
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)children, (int)index, (Object)this.mChildren, (int)(index + 1), (int)(count - index));
                children = this.mChildren;
            } else {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)children, (int)index, (Object)children, (int)(index + 1), (int)(count - index));
            }
            children[index] = child;
            ++this.mChildrenCount;
            if (this.mLastTouchDownIndex >= index) {
                ++this.mLastTouchDownIndex;
            }
        } else {
            throw new IndexOutOfBoundsException("index=" + index + " count=" + count);
        }
    }

    private final void $$robo$$android_view_ViewGroup$removeFromArray(int index) {
        int count;
        View[] children = this.mChildren;
        if (this.mTransitioningViews == null || !this.mTransitioningViews.contains(children[index])) {
            children[index].mParent = null;
        }
        if (index == (count = this.mChildrenCount--) - 1) {
            children[this.mChildrenCount] = null;
        } else if (index >= 0 && index < count) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)children, (int)(index + 1), (Object)children, (int)index, (int)(count - index - 1));
            children[--this.mChildrenCount] = null;
        } else {
            throw new IndexOutOfBoundsException();
        }
        if (this.mLastTouchDownIndex == index) {
            this.mLastTouchDownTime = 0L;
            this.mLastTouchDownIndex = -1;
        } else if (this.mLastTouchDownIndex > index) {
            --this.mLastTouchDownIndex;
        }
    }

    private final void $$robo$$android_view_ViewGroup$removeFromArray(int start, int count) {
        int end;
        View[] children = this.mChildren;
        int childrenCount = this.mChildrenCount;
        if ((start = Math.max(0, start)) == (end = Math.min(childrenCount, start + count))) {
            return;
        }
        if (end == childrenCount) {
            for (int i = start; i < end; ++i) {
                children[i].mParent = null;
                children[i] = null;
            }
        } else {
            int i;
            for (i = start; i < end; ++i) {
                children[i].mParent = null;
            }
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)children, (int)end, (Object)children, (int)start, (int)(childrenCount - end));
            for (i = childrenCount - (end - start); i < childrenCount; ++i) {
                children[i] = null;
            }
        }
        this.mChildrenCount -= end - start;
    }

    private final void $$robo$$android_view_ViewGroup$bindLayoutAnimation(View child) {
        Animation a = this.mLayoutAnimationController.getAnimationForView(child);
        child.setAnimation(a);
    }

    private final void $$robo$$android_view_ViewGroup$attachLayoutAnimationParameters(View child, LayoutParams params, int index, int count) {
        LayoutAnimationController.AnimationParameters animationParams = params.layoutAnimationParameters;
        if (animationParams == null) {
            params.layoutAnimationParameters = animationParams = new LayoutAnimationController.AnimationParameters();
        }
        animationParams.count = count;
        animationParams.index = index;
    }

    private final void $$robo$$android_view_ViewGroup$removeView(View view) {
        if (this.removeViewInternal(view)) {
            this.requestLayout();
            this.invalidate(true);
        }
    }

    private final void $$robo$$android_view_ViewGroup$removeViewInLayout(View view) {
        this.removeViewInternal(view);
    }

    private final void $$robo$$android_view_ViewGroup$removeViewsInLayout(int start, int count) {
        this.removeViewsInternal(start, count);
    }

    private final void $$robo$$android_view_ViewGroup$removeViewAt(int index) {
        this.removeViewInternal(index, this.getChildAt(index));
        this.requestLayout();
        this.invalidate(true);
    }

    private final void $$robo$$android_view_ViewGroup$removeViews(int start, int count) {
        this.removeViewsInternal(start, count);
        this.requestLayout();
        this.invalidate(true);
    }

    private final boolean $$robo$$android_view_ViewGroup$removeViewInternal(View view) {
        int index = this.indexOfChild(view);
        if (index >= 0) {
            this.removeViewInternal(index, view);
            return true;
        }
        return false;
    }

    private final void $$robo$$android_view_ViewGroup$removeViewInternal(int index, View view) {
        if (this.mTransition != null) {
            this.mTransition.removeChild(this, view);
        }
        boolean clearChildFocus = false;
        if (view == this.mFocused) {
            view.unFocus(null);
            clearChildFocus = true;
        }
        if (view == this.mFocusedInCluster) {
            this.clearFocusedInCluster(view);
        }
        view.clearAccessibilityFocus();
        this.cancelTouchTarget(view);
        this.cancelHoverTarget(view);
        if (view.getAnimation() != null || this.mTransitioningViews != null && this.mTransitioningViews.contains(view)) {
            this.addDisappearingView(view);
        } else if (view.mAttachInfo != null) {
            view.dispatchDetachedFromWindow();
        }
        if (view.hasTransientState()) {
            this.childHasTransientStateChanged(view, false);
        }
        this.needGlobalAttributesUpdate(false);
        this.removeFromArray(index);
        if (view.hasUnhandledKeyListener()) {
            this.decrementChildUnhandledKeyListeners();
        }
        if (view == this.mDefaultFocus) {
            this.clearDefaultFocus(view);
        }
        if (clearChildFocus) {
            this.clearChildFocus(view);
            if (!this.rootViewRequestFocus()) {
                this.notifyGlobalFocusCleared(this);
            }
        }
        this.dispatchViewRemoved(view);
        if (view.getVisibility() != 8) {
            this.notifySubtreeAccessibilityStateChangedIfNeeded();
        }
        int transientCount = this.mTransientIndices == null ? 0 : this.mTransientIndices.size();
        for (int i = 0; i < transientCount; ++i) {
            int oldIndex = this.mTransientIndices.get(i);
            if (index >= oldIndex) continue;
            this.mTransientIndices.set(i, oldIndex - 1);
        }
        if (this.mCurrentDragStartEvent != null) {
            this.mChildrenInterestedInDrag.remove(view);
        }
    }

    private final void $$robo$$android_view_ViewGroup$setLayoutTransition(LayoutTransition transition2) {
        if (this.mTransition != null) {
            LayoutTransition previousTransition = this.mTransition;
            previousTransition.cancel();
            previousTransition.removeTransitionListener(this.mLayoutTransitionListener);
        }
        this.mTransition = transition2;
        if (this.mTransition != null) {
            this.mTransition.addTransitionListener(this.mLayoutTransitionListener);
        }
    }

    private final LayoutTransition $$robo$$android_view_ViewGroup$getLayoutTransition() {
        return this.mTransition;
    }

    private final void $$robo$$android_view_ViewGroup$removeViewsInternal(int start, int count) {
        int end = start + count;
        if (start < 0 || count < 0 || end > this.mChildrenCount) {
            throw new IndexOutOfBoundsException();
        }
        View focused = this.mFocused;
        boolean detach = this.mAttachInfo != null;
        boolean clearChildFocus = false;
        View clearDefaultFocus = null;
        View[] children = this.mChildren;
        for (int i = start; i < end; ++i) {
            View view = children[i];
            if (this.mTransition != null) {
                this.mTransition.removeChild(this, view);
            }
            if (view == focused) {
                view.unFocus(null);
                clearChildFocus = true;
            }
            if (view == this.mDefaultFocus) {
                clearDefaultFocus = view;
            }
            if (view == this.mFocusedInCluster) {
                this.clearFocusedInCluster(view);
            }
            view.clearAccessibilityFocus();
            this.cancelTouchTarget(view);
            this.cancelHoverTarget(view);
            if (view.getAnimation() != null || this.mTransitioningViews != null && this.mTransitioningViews.contains(view)) {
                this.addDisappearingView(view);
            } else if (detach) {
                view.dispatchDetachedFromWindow();
            }
            if (view.hasTransientState()) {
                this.childHasTransientStateChanged(view, false);
            }
            this.needGlobalAttributesUpdate(false);
            this.dispatchViewRemoved(view);
        }
        this.removeFromArray(start, count);
        if (clearDefaultFocus != null) {
            this.clearDefaultFocus(clearDefaultFocus);
        }
        if (clearChildFocus) {
            this.clearChildFocus(focused);
            if (!this.rootViewRequestFocus()) {
                this.notifyGlobalFocusCleared(focused);
            }
        }
    }

    private final void $$robo$$android_view_ViewGroup$removeAllViews() {
        this.removeAllViewsInLayout();
        this.requestLayout();
        this.invalidate(true);
    }

    private final void $$robo$$android_view_ViewGroup$removeAllViewsInLayout() {
        int count = this.mChildrenCount;
        if (count <= 0) {
            return;
        }
        View[] children = this.mChildren;
        this.mChildrenCount = 0;
        View focused = this.mFocused;
        boolean detach = this.mAttachInfo != null;
        boolean clearChildFocus = false;
        this.needGlobalAttributesUpdate(false);
        for (int i = count - 1; i >= 0; --i) {
            View view = children[i];
            if (this.mTransition != null) {
                this.mTransition.removeChild(this, view);
            }
            if (view == focused) {
                view.unFocus(null);
                clearChildFocus = true;
            }
            view.clearAccessibilityFocus();
            this.cancelTouchTarget(view);
            this.cancelHoverTarget(view);
            if (view.getAnimation() != null || this.mTransitioningViews != null && this.mTransitioningViews.contains(view)) {
                this.addDisappearingView(view);
            } else if (detach) {
                view.dispatchDetachedFromWindow();
            }
            if (view.hasTransientState()) {
                this.childHasTransientStateChanged(view, false);
            }
            this.dispatchViewRemoved(view);
            view.mParent = null;
            children[i] = null;
        }
        if (this.mDefaultFocus != null) {
            this.clearDefaultFocus(this.mDefaultFocus);
        }
        if (this.mFocusedInCluster != null) {
            this.clearFocusedInCluster(this.mFocusedInCluster);
        }
        if (clearChildFocus) {
            this.clearChildFocus(focused);
            if (!this.rootViewRequestFocus()) {
                this.notifyGlobalFocusCleared(focused);
            }
        }
    }

    private final void $$robo$$android_view_ViewGroup$removeDetachedView(View child, boolean animate) {
        if (this.mTransition != null) {
            this.mTransition.removeChild(this, child);
        }
        if (child == this.mFocused) {
            child.clearFocus();
        }
        if (child == this.mDefaultFocus) {
            this.clearDefaultFocus(child);
        }
        if (child == this.mFocusedInCluster) {
            this.clearFocusedInCluster(child);
        }
        child.clearAccessibilityFocus();
        this.cancelTouchTarget(child);
        this.cancelHoverTarget(child);
        if (animate && child.getAnimation() != null || this.mTransitioningViews != null && this.mTransitioningViews.contains(child)) {
            this.addDisappearingView(child);
        } else if (child.mAttachInfo != null) {
            child.dispatchDetachedFromWindow();
        }
        if (child.hasTransientState()) {
            this.childHasTransientStateChanged(child, false);
        }
        this.dispatchViewRemoved(child);
    }

    private final void $$robo$$android_view_ViewGroup$attachViewToParent(View child, int index, LayoutParams params) {
        child.mLayoutParams = params;
        if (index < 0) {
            index = this.mChildrenCount;
        }
        this.addInArray(child, index);
        child.mParent = this;
        child.mPrivateFlags = child.mPrivateFlags & 0xFF9FFFFF & 0xFFFF7FFF | 0x20 | Integer.MIN_VALUE;
        this.mPrivateFlags |= Integer.MIN_VALUE;
        if (child.hasFocus()) {
            this.requestChildFocus(child, child.findFocus());
        }
        this.dispatchVisibilityAggregated(this.isAttachedToWindow() && this.getWindowVisibility() == 0 && this.isShown());
        this.notifySubtreeAccessibilityStateChangedIfNeeded();
    }

    private final void $$robo$$android_view_ViewGroup$detachViewFromParent(View child) {
        this.removeFromArray(this.indexOfChild(child));
    }

    private final void $$robo$$android_view_ViewGroup$detachViewFromParent(int index) {
        this.removeFromArray(index);
    }

    private final void $$robo$$android_view_ViewGroup$detachViewsFromParent(int start, int count) {
        this.removeFromArray(start, count);
    }

    private final void $$robo$$android_view_ViewGroup$detachAllViewsFromParent() {
        int count = this.mChildrenCount;
        if (count <= 0) {
            return;
        }
        View[] children = this.mChildren;
        this.mChildrenCount = 0;
        for (int i = count - 1; i >= 0; --i) {
            children[i].mParent = null;
            children[i] = null;
        }
    }

    private final void $$robo$$android_view_ViewGroup$onDescendantInvalidated(View child, View target) {
        this.mPrivateFlags |= target.mPrivateFlags & 0x40;
        if ((target.mPrivateFlags & 0xFF9FFFFF) != 0) {
            this.mPrivateFlags = this.mPrivateFlags & 0xFF9FFFFF | 0x200000;
            this.mPrivateFlags &= 0xFFFF7FFF;
        }
        if (this.mLayerType == 1) {
            this.mPrivateFlags |= 0x80200000;
            target = this;
        }
        if (this.mParent != null) {
            this.mParent.onDescendantInvalidated(this, target);
        }
    }

    @Deprecated
    private final void $$robo$$android_view_ViewGroup$invalidateChild(View child, Rect dirty) {
        View.AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo != null && attachInfo.mHardwareAccelerated) {
            this.onDescendantInvalidated(child, child);
            return;
        }
        ViewParent parent = this;
        if (attachInfo != null) {
            int opaqueFlag;
            boolean drawAnimation = (child.mPrivateFlags & 0x40) != 0;
            Matrix childMatrix = child.getMatrix();
            boolean isOpaque = child.isOpaque() && !drawAnimation && child.getAnimation() == null && childMatrix.isIdentity();
            int n = opaqueFlag = isOpaque ? 0x400000 : 0x200000;
            if (child.mLayerType != 0) {
                this.mPrivateFlags |= Integer.MIN_VALUE;
                this.mPrivateFlags &= 0xFFFF7FFF;
            }
            int[] location = attachInfo.mInvalidateChildLocation;
            location[0] = child.mLeft;
            location[1] = child.mTop;
            if (!childMatrix.isIdentity() || (this.mGroupFlags & 0x800) != 0) {
                Matrix transformMatrix;
                RectF boundingRect = attachInfo.mTmpTransformRect;
                boundingRect.set(dirty);
                if ((this.mGroupFlags & 0x800) != 0) {
                    Transformation t = attachInfo.mTmpTransformation;
                    boolean transformed = this.getChildStaticTransformation(child, t);
                    if (transformed) {
                        transformMatrix = attachInfo.mTmpMatrix;
                        transformMatrix.set(t.getMatrix());
                        if (!childMatrix.isIdentity()) {
                            transformMatrix.preConcat(childMatrix);
                        }
                    } else {
                        transformMatrix = childMatrix;
                    }
                } else {
                    transformMatrix = childMatrix;
                }
                transformMatrix.mapRect(boundingRect);
                dirty.set((int)Math.floor(boundingRect.left), (int)Math.floor(boundingRect.top), (int)Math.ceil(boundingRect.right), (int)Math.ceil(boundingRect.bottom));
            }
            do {
                Matrix m;
                View view = null;
                if (parent instanceof View) {
                    view = parent;
                }
                if (drawAnimation) {
                    if (view != null) {
                        view.mPrivateFlags |= 0x40;
                    } else if (parent instanceof ViewRootImpl) {
                        ((ViewRootImpl)parent).mIsAnimating = true;
                    }
                }
                if (view != null) {
                    if ((view.mViewFlags & 0x3000) != 0 && view.getSolidColor() == 0) {
                        opaqueFlag = 0x200000;
                    }
                    if ((view.mPrivateFlags & 0x600000) != 0x200000) {
                        view.mPrivateFlags = view.mPrivateFlags & 0xFF9FFFFF | opaqueFlag;
                    }
                }
                parent = parent.invalidateChildInParent(location, dirty);
                if (view == null || (m = view.getMatrix()).isIdentity()) continue;
                RectF boundingRect = attachInfo.mTmpTransformRect;
                boundingRect.set(dirty);
                m.mapRect(boundingRect);
                dirty.set((int)Math.floor(boundingRect.left), (int)Math.floor(boundingRect.top), (int)Math.ceil(boundingRect.right), (int)Math.ceil(boundingRect.bottom));
            } while (parent != null);
        }
    }

    @Deprecated
    private final ViewParent $$robo$$android_view_ViewGroup$invalidateChildInParent(int[] location, Rect dirty) {
        if ((this.mPrivateFlags & 0x8020) != 0) {
            if ((this.mGroupFlags & 0x90) != 128) {
                dirty.offset(location[0] - this.mScrollX, location[1] - this.mScrollY);
                if ((this.mGroupFlags & 1) == 0) {
                    dirty.union(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
                }
                int left = this.mLeft;
                int top = this.mTop;
                if ((this.mGroupFlags & 1) == 1 && !dirty.intersect(0, 0, this.mRight - left, this.mBottom - top)) {
                    dirty.setEmpty();
                }
                location[0] = left;
                location[1] = top;
            } else {
                if ((this.mGroupFlags & 1) == 1) {
                    dirty.set(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
                } else {
                    dirty.union(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
                }
                location[0] = this.mLeft;
                location[1] = this.mTop;
                this.mPrivateFlags &= 0xFFFFFFDF;
            }
            this.mPrivateFlags &= 0xFFFF7FFF;
            if (this.mLayerType != 0) {
                this.mPrivateFlags |= Integer.MIN_VALUE;
            }
            return this.mParent;
        }
        return null;
    }

    private final void $$robo$$android_view_ViewGroup$offsetDescendantRectToMyCoords(View descendant, Rect rect) {
        this.offsetRectBetweenParentAndChild(descendant, rect, true, false);
    }

    private final void $$robo$$android_view_ViewGroup$offsetRectIntoDescendantCoords(View descendant, Rect rect) {
        this.offsetRectBetweenParentAndChild(descendant, rect, false, false);
    }

    private final void $$robo$$android_view_ViewGroup$offsetRectBetweenParentAndChild(View descendant, Rect rect, boolean offsetFromChildToParent, boolean clipToBounds) {
        if (descendant == this) {
            return;
        }
        ViewParent theParent = descendant.mParent;
        while (theParent != null && theParent instanceof View && theParent != this) {
            boolean intersected;
            View p;
            if (offsetFromChildToParent) {
                rect.offset(descendant.mLeft - descendant.mScrollX, descendant.mTop - descendant.mScrollY);
                if (clipToBounds) {
                    p = (View)((Object)theParent);
                    intersected = rect.intersect(0, 0, p.mRight - p.mLeft, p.mBottom - p.mTop);
                    if (!intersected) {
                        rect.setEmpty();
                    }
                }
            } else {
                if (clipToBounds) {
                    p = (View)((Object)theParent);
                    intersected = rect.intersect(0, 0, p.mRight - p.mLeft, p.mBottom - p.mTop);
                    if (!intersected) {
                        rect.setEmpty();
                    }
                }
                rect.offset(descendant.mScrollX - descendant.mLeft, descendant.mScrollY - descendant.mTop);
            }
            descendant = (View)((Object)theParent);
            theParent = descendant.mParent;
        }
        if (theParent == this) {
            if (offsetFromChildToParent) {
                rect.offset(descendant.mLeft - descendant.mScrollX, descendant.mTop - descendant.mScrollY);
            } else {
                rect.offset(descendant.mScrollX - descendant.mLeft, descendant.mScrollY - descendant.mTop);
            }
        } else {
            throw new IllegalArgumentException("parameter must be a descendant of this view");
        }
    }

    private final void $$robo$$android_view_ViewGroup$offsetChildrenTopAndBottom(int offset) {
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        boolean invalidate = false;
        for (int i = 0; i < count; ++i) {
            View v = children[i];
            v.mTop += offset;
            v.mBottom += offset;
            if (v.mRenderNode == null) continue;
            invalidate = true;
            v.mRenderNode.offsetTopAndBottom(offset);
        }
        if (invalidate) {
            this.invalidateViewProperty(false, false);
        }
        this.notifySubtreeAccessibilityStateChangedIfNeeded();
    }

    private final boolean $$robo$$android_view_ViewGroup$getChildVisibleRect(View child, Rect r, Point offset) {
        return this.getChildVisibleRect(child, r, offset, false);
    }

    private final boolean $$robo$$android_view_ViewGroup$getChildVisibleRect(View child, Rect r, Point offset, boolean forceParentCheck) {
        RectF rect = this.mAttachInfo != null ? this.mAttachInfo.mTmpTransformRect : new RectF();
        rect.set(r);
        if (!child.hasIdentityMatrix()) {
            child.getMatrix().mapRect(rect);
        }
        int dx = child.mLeft - this.mScrollX;
        int dy = child.mTop - this.mScrollY;
        rect.offset(dx, dy);
        if (offset != null) {
            if (!child.hasIdentityMatrix()) {
                float[] position = this.mAttachInfo != null ? this.mAttachInfo.mTmpTransformLocation : new float[2];
                position[0] = offset.x;
                position[1] = offset.y;
                child.getMatrix().mapPoints(position);
                offset.x = Math.round(position[0]);
                offset.y = Math.round(position[1]);
            }
            offset.x += dx;
            offset.y += dy;
        }
        int width = this.mRight - this.mLeft;
        int height = this.mBottom - this.mTop;
        boolean rectIsVisible = true;
        if (this.mParent == null || this.mParent instanceof ViewGroup && ((ViewGroup)this.mParent).getClipChildren()) {
            rectIsVisible = rect.intersect(0.0f, 0.0f, width, height);
        }
        if ((forceParentCheck || rectIsVisible) && (this.mGroupFlags & 0x22) == 34) {
            rectIsVisible = rect.intersect(this.mPaddingLeft, this.mPaddingTop, width - this.mPaddingRight, height - this.mPaddingBottom);
        }
        if ((forceParentCheck || rectIsVisible) && this.mClipBounds != null) {
            rectIsVisible = rect.intersect(this.mClipBounds.left, this.mClipBounds.top, this.mClipBounds.right, this.mClipBounds.bottom);
        }
        r.set((int)Math.floor(rect.left), (int)Math.floor(rect.top), (int)Math.ceil(rect.right), (int)Math.ceil(rect.bottom));
        if ((forceParentCheck || rectIsVisible) && this.mParent != null) {
            rectIsVisible = this.mParent instanceof ViewGroup ? ((ViewGroup)this.mParent).getChildVisibleRect(this, r, offset, forceParentCheck) : this.mParent.getChildVisibleRect(this, r, offset);
        }
        return rectIsVisible;
    }

    private final void $$robo$$android_view_ViewGroup$layout(int l, int t, int r, int b) {
        if (!(this.mSuppressLayout || this.mTransition != null && this.mTransition.isChangingLayout())) {
            if (this.mTransition != null) {
                this.mTransition.layoutChange(this);
            }
            super.layout(l, t, r, b);
        } else {
            this.mLayoutCalledWhileSuppressed = true;
        }
    }

    @Override
    protected abstract void onLayout(boolean var1, int var2, int var3, int var4, int var5);

    private final boolean $$robo$$android_view_ViewGroup$canAnimate() {
        return this.mLayoutAnimationController != null;
    }

    private final void $$robo$$android_view_ViewGroup$startLayoutAnimation() {
        if (this.mLayoutAnimationController != null) {
            this.mGroupFlags |= 8;
            this.requestLayout();
        }
    }

    private final void $$robo$$android_view_ViewGroup$scheduleLayoutAnimation() {
        this.mGroupFlags |= 8;
    }

    private final void $$robo$$android_view_ViewGroup$setLayoutAnimation(LayoutAnimationController controller) {
        this.mLayoutAnimationController = controller;
        if (this.mLayoutAnimationController != null) {
            this.mGroupFlags |= 8;
        }
    }

    private final LayoutAnimationController $$robo$$android_view_ViewGroup$getLayoutAnimation() {
        return this.mLayoutAnimationController;
    }

    @Deprecated
    private final boolean $$robo$$android_view_ViewGroup$isAnimationCacheEnabled() {
        return (this.mGroupFlags & 0x40) == 64;
    }

    @Deprecated
    private final void $$robo$$android_view_ViewGroup$setAnimationCacheEnabled(boolean enabled) {
        this.setBooleanFlag(64, enabled);
    }

    @Deprecated
    private final boolean $$robo$$android_view_ViewGroup$isAlwaysDrawnWithCacheEnabled() {
        return (this.mGroupFlags & 0x4000) == 16384;
    }

    @Deprecated
    private final void $$robo$$android_view_ViewGroup$setAlwaysDrawnWithCacheEnabled(boolean always) {
        this.setBooleanFlag(16384, always);
    }

    @Deprecated
    private final boolean $$robo$$android_view_ViewGroup$isChildrenDrawnWithCacheEnabled() {
        return (this.mGroupFlags & 0x8000) == 32768;
    }

    @Deprecated
    private final void $$robo$$android_view_ViewGroup$setChildrenDrawnWithCacheEnabled(boolean enabled) {
        this.setBooleanFlag(32768, enabled);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    private final boolean $$robo$$android_view_ViewGroup$isChildrenDrawingOrderEnabled() {
        return (this.mGroupFlags & 0x400) == 1024;
    }

    private final void $$robo$$android_view_ViewGroup$setChildrenDrawingOrderEnabled(boolean enabled) {
        this.setBooleanFlag(1024, enabled);
    }

    private final boolean $$robo$$android_view_ViewGroup$hasBooleanFlag(int flag) {
        return (this.mGroupFlags & flag) == flag;
    }

    private final void $$robo$$android_view_ViewGroup$setBooleanFlag(int flag, boolean value) {
        this.mGroupFlags = value ? (this.mGroupFlags |= flag) : (this.mGroupFlags &= ~flag);
    }

    @Deprecated
    @ViewDebug.ExportedProperty(category="drawing", mapping={@ViewDebug.IntToString(from=0, to="NONE"), @ViewDebug.IntToString(from=1, to="ANIMATION"), @ViewDebug.IntToString(from=2, to="SCROLLING"), @ViewDebug.IntToString(from=3, to="ALL")})
    private final int $$robo$$android_view_ViewGroup$getPersistentDrawingCache() {
        return this.mPersistentDrawingCache;
    }

    @Deprecated
    private final void $$robo$$android_view_ViewGroup$setPersistentDrawingCache(int drawingCacheToKeep) {
        this.mPersistentDrawingCache = drawingCacheToKeep & 3;
    }

    private final void $$robo$$android_view_ViewGroup$setLayoutMode(int layoutMode, boolean explicitly) {
        this.mLayoutMode = layoutMode;
        this.setBooleanFlag(0x800000, explicitly);
    }

    private final void $$robo$$android_view_ViewGroup$invalidateInheritedLayoutMode(int layoutModeOfRoot) {
        if (this.mLayoutMode == -1 || this.mLayoutMode == layoutModeOfRoot || this.hasBooleanFlag(0x800000)) {
            return;
        }
        this.setLayoutMode(-1, false);
        int N = this.getChildCount();
        for (int i = 0; i < N; ++i) {
            this.getChildAt(i).invalidateInheritedLayoutMode(layoutModeOfRoot);
        }
    }

    private final int $$robo$$android_view_ViewGroup$getLayoutMode() {
        if (this.mLayoutMode == -1) {
            int inheritedLayoutMode = this.mParent instanceof ViewGroup ? ((ViewGroup)this.mParent).getLayoutMode() : LAYOUT_MODE_DEFAULT;
            this.setLayoutMode(inheritedLayoutMode, false);
        }
        return this.mLayoutMode;
    }

    private final void $$robo$$android_view_ViewGroup$setLayoutMode(int layoutMode) {
        if (this.mLayoutMode != layoutMode) {
            this.invalidateInheritedLayoutMode(layoutMode);
            this.setLayoutMode(layoutMode, layoutMode != -1);
            this.requestLayout();
        }
    }

    private final LayoutParams $$robo$$android_view_ViewGroup$generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    private final LayoutParams $$robo$$android_view_ViewGroup$generateLayoutParams(LayoutParams p) {
        return p;
    }

    private final LayoutParams $$robo$$android_view_ViewGroup$generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    private final void $$robo$$android_view_ViewGroup$debug(int depth) {
        String output;
        super.debug(depth);
        if (this.mFocused != null) {
            output = ViewGroup.debugIndent(depth);
            output = output + "mFocused";
            Log.d("View", output);
            this.mFocused.debug(depth + 1);
        }
        if (this.mDefaultFocus != null) {
            output = ViewGroup.debugIndent(depth);
            output = output + "mDefaultFocus";
            Log.d("View", output);
            this.mDefaultFocus.debug(depth + 1);
        }
        if (this.mFocusedInCluster != null) {
            output = ViewGroup.debugIndent(depth);
            output = output + "mFocusedInCluster";
            Log.d("View", output);
            this.mFocusedInCluster.debug(depth + 1);
        }
        if (this.mChildrenCount != 0) {
            output = ViewGroup.debugIndent(depth);
            output = output + "{";
            Log.d("View", output);
        }
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            View child = this.mChildren[i];
            child.debug(depth + 1);
        }
        if (this.mChildrenCount != 0) {
            output = ViewGroup.debugIndent(depth);
            output = output + "}";
            Log.d("View", output);
        }
    }

    private final int $$robo$$android_view_ViewGroup$indexOfChild(View child) {
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            if (children[i] != child) continue;
            return i;
        }
        return -1;
    }

    private final int $$robo$$android_view_ViewGroup$getChildCount() {
        return this.mChildrenCount;
    }

    private final View $$robo$$android_view_ViewGroup$getChildAt(int index) {
        if (index < 0 || index >= this.mChildrenCount) {
            return null;
        }
        return this.mChildren[index];
    }

    private final void $$robo$$android_view_ViewGroup$measureChildren(int widthMeasureSpec, int heightMeasureSpec) {
        int size = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < size; ++i) {
            View child = children[i];
            if ((child.mViewFlags & 0xC) == 8) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
        }
    }

    private final void $$robo$$android_view_ViewGroup$measureChild(View child, int parentWidthMeasureSpec, int parentHeightMeasureSpec) {
        LayoutParams lp = child.getLayoutParams();
        int childWidthMeasureSpec = ViewGroup.getChildMeasureSpec(parentWidthMeasureSpec, this.mPaddingLeft + this.mPaddingRight, lp.width);
        int childHeightMeasureSpec = ViewGroup.getChildMeasureSpec(parentHeightMeasureSpec, this.mPaddingTop + this.mPaddingBottom, lp.height);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    private final void $$robo$$android_view_ViewGroup$measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        MarginLayoutParams lp = (MarginLayoutParams)child.getLayoutParams();
        int childWidthMeasureSpec = ViewGroup.getChildMeasureSpec(parentWidthMeasureSpec, this.mPaddingLeft + this.mPaddingRight + lp.leftMargin + lp.rightMargin + widthUsed, lp.width);
        int childHeightMeasureSpec = ViewGroup.getChildMeasureSpec(parentHeightMeasureSpec, this.mPaddingTop + this.mPaddingBottom + lp.topMargin + lp.bottomMargin + heightUsed, lp.height);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    private static final int $$robo$$android_view_ViewGroup$getChildMeasureSpec(int spec, int padding, int childDimension) {
        int specMode = View.MeasureSpec.getMode(spec);
        int specSize = View.MeasureSpec.getSize(spec);
        int size = Math.max(0, specSize - padding);
        int resultSize = 0;
        int resultMode = 0;
        switch (specMode) {
            case 0x40000000: {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension == -1) {
                    resultSize = size;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension != -2) break;
                resultSize = size;
                resultMode = Integer.MIN_VALUE;
                break;
            }
            case -2147483648: {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension == -1) {
                    resultSize = size;
                    resultMode = Integer.MIN_VALUE;
                    break;
                }
                if (childDimension != -2) break;
                resultSize = size;
                resultMode = Integer.MIN_VALUE;
                break;
            }
            case 0: {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension == -1) {
                    resultSize = View.sUseZeroUnspecifiedMeasureSpec ? 0 : size;
                    resultMode = 0;
                    break;
                }
                if (childDimension != -2) break;
                resultSize = View.sUseZeroUnspecifiedMeasureSpec ? 0 : size;
                resultMode = 0;
            }
        }
        return View.MeasureSpec.makeMeasureSpec(resultSize, resultMode);
    }

    private final void $$robo$$android_view_ViewGroup$clearDisappearingChildren() {
        ArrayList<View> disappearingChildren = this.mDisappearingChildren;
        if (disappearingChildren != null) {
            int count = disappearingChildren.size();
            for (int i = 0; i < count; ++i) {
                View view = disappearingChildren.get(i);
                if (view.mAttachInfo != null) {
                    view.dispatchDetachedFromWindow();
                }
                view.clearAnimation();
            }
            disappearingChildren.clear();
            this.invalidate();
        }
    }

    private final void $$robo$$android_view_ViewGroup$addDisappearingView(View v) {
        ArrayList<View> disappearingChildren = this.mDisappearingChildren;
        if (disappearingChildren == null) {
            disappearingChildren = this.mDisappearingChildren = new ArrayList();
        }
        disappearingChildren.add(v);
    }

    private final void $$robo$$android_view_ViewGroup$finishAnimatingView(View view, Animation animation) {
        ArrayList<View> disappearingChildren = this.mDisappearingChildren;
        if (disappearingChildren != null && disappearingChildren.contains(view)) {
            disappearingChildren.remove(view);
            if (view.mAttachInfo != null) {
                view.dispatchDetachedFromWindow();
            }
            view.clearAnimation();
            this.mGroupFlags |= 4;
        }
        if (animation != null && !animation.getFillAfter()) {
            view.clearAnimation();
        }
        if ((view.mPrivateFlags & 0x10000) == 65536) {
            view.onAnimationEnd();
            view.mPrivateFlags &= 0xFFFEFFFF;
            this.mGroupFlags |= 4;
        }
    }

    private final boolean $$robo$$android_view_ViewGroup$isViewTransitioning(View view) {
        return this.mTransitioningViews != null && this.mTransitioningViews.contains(view);
    }

    private final void $$robo$$android_view_ViewGroup$startViewTransition(View view) {
        if (view.mParent == this) {
            if (this.mTransitioningViews == null) {
                this.mTransitioningViews = new ArrayList();
            }
            this.mTransitioningViews.add(view);
        }
    }

    private final void $$robo$$android_view_ViewGroup$endViewTransition(View view) {
        if (this.mTransitioningViews != null) {
            this.mTransitioningViews.remove(view);
            ArrayList<View> disappearingChildren = this.mDisappearingChildren;
            if (disappearingChildren != null && disappearingChildren.contains(view)) {
                disappearingChildren.remove(view);
                if (this.mVisibilityChangingChildren != null && this.mVisibilityChangingChildren.contains(view)) {
                    this.mVisibilityChangingChildren.remove(view);
                } else {
                    if (view.mAttachInfo != null) {
                        view.dispatchDetachedFromWindow();
                    }
                    if (view.mParent != null) {
                        view.mParent = null;
                    }
                }
                this.invalidate();
            }
        }
    }

    private final void $$robo$$android_view_ViewGroup$suppressLayout(boolean suppress) {
        this.mSuppressLayout = suppress;
        if (!suppress && this.mLayoutCalledWhileSuppressed) {
            this.requestLayout();
            this.mLayoutCalledWhileSuppressed = false;
        }
    }

    private final boolean $$robo$$android_view_ViewGroup$isLayoutSuppressed() {
        return this.mSuppressLayout;
    }

    private final boolean $$robo$$android_view_ViewGroup$gatherTransparentRegion(Region region) {
        boolean meOpaque;
        boolean bl = meOpaque = (this.mPrivateFlags & 0x200) == 0;
        if (meOpaque && region == null) {
            return true;
        }
        super.gatherTransparentRegion(region);
        int childrenCount = this.mChildrenCount;
        boolean noneOfTheChildrenAreTransparent = true;
        if (childrenCount > 0) {
            ArrayList<View> preorderedList = this.buildOrderedChildList();
            boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
            View[] children = this.mChildren;
            for (int i = 0; i < childrenCount; ++i) {
                int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
                View child = ViewGroup.getAndVerifyPreorderedView(preorderedList, children, childIndex);
                if ((child.mViewFlags & 0xC) != 0 && child.getAnimation() == null || child.gatherTransparentRegion(region)) continue;
                noneOfTheChildrenAreTransparent = false;
            }
            if (preorderedList != null) {
                preorderedList.clear();
            }
        }
        return meOpaque || noneOfTheChildrenAreTransparent;
    }

    private final void $$robo$$android_view_ViewGroup$requestTransparentRegion(View child) {
        if (child != null) {
            child.mPrivateFlags |= 0x200;
            if (this.mParent != null) {
                this.mParent.requestTransparentRegion(this);
            }
        }
    }

    private final WindowInsets $$robo$$android_view_ViewGroup$dispatchApplyWindowInsets(WindowInsets insets) {
        if (!(insets = super.dispatchApplyWindowInsets(insets)).isConsumed()) {
            int count = this.getChildCount();
            for (int i = 0; i < count && !(insets = this.getChildAt(i).dispatchApplyWindowInsets(insets)).isConsumed(); ++i) {
            }
        }
        return insets;
    }

    private final Animation.AnimationListener $$robo$$android_view_ViewGroup$getLayoutAnimationListener() {
        return this.mAnimationListener;
    }

    private final void $$robo$$android_view_ViewGroup$drawableStateChanged() {
        super.drawableStateChanged();
        if ((this.mGroupFlags & 0x10000) != 0) {
            if ((this.mGroupFlags & 0x2000) != 0) {
                throw new IllegalStateException("addStateFromChildren cannot be enabled if a child has duplicateParentState set to true");
            }
            View[] children = this.mChildren;
            int count = this.mChildrenCount;
            for (int i = 0; i < count; ++i) {
                View child = children[i];
                if ((child.mViewFlags & 0x400000) == 0) continue;
                child.refreshDrawableState();
            }
        }
    }

    private final void $$robo$$android_view_ViewGroup$jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            children[i].jumpDrawablesToCurrentState();
        }
    }

    private final int[] $$robo$$android_view_ViewGroup$onCreateDrawableState(int extraSpace) {
        if ((this.mGroupFlags & 0x2000) == 0) {
            return super.onCreateDrawableState(extraSpace);
        }
        int need = 0;
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            int[] childState = this.getChildAt(i).getDrawableState();
            if (childState == null) continue;
            need += childState.length;
        }
        int[] state = super.onCreateDrawableState(extraSpace + need);
        for (int i = 0; i < n; ++i) {
            int[] childState = this.getChildAt(i).getDrawableState();
            if (childState == null) continue;
            state = ViewGroup.mergeDrawableStates(state, childState);
        }
        return state;
    }

    private final void $$robo$$android_view_ViewGroup$setAddStatesFromChildren(boolean addsStates) {
        this.mGroupFlags = addsStates ? (this.mGroupFlags |= 0x2000) : (this.mGroupFlags &= 0xFFFFDFFF);
        this.refreshDrawableState();
    }

    private final boolean $$robo$$android_view_ViewGroup$addStatesFromChildren() {
        return (this.mGroupFlags & 0x2000) != 0;
    }

    private final void $$robo$$android_view_ViewGroup$childDrawableStateChanged(View child) {
        if ((this.mGroupFlags & 0x2000) != 0) {
            this.refreshDrawableState();
        }
    }

    private final void $$robo$$android_view_ViewGroup$setLayoutAnimationListener(Animation.AnimationListener animationListener) {
        this.mAnimationListener = animationListener;
    }

    private final void $$robo$$android_view_ViewGroup$requestTransitionStart(LayoutTransition transition2) {
        ViewRootImpl viewAncestor = this.getViewRootImpl();
        if (viewAncestor != null) {
            viewAncestor.requestTransitionStart(transition2);
        }
    }

    private final boolean $$robo$$android_view_ViewGroup$resolveRtlPropertiesIfNeeded() {
        boolean result = super.resolveRtlPropertiesIfNeeded();
        if (result) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                if (!child.isLayoutDirectionInherited()) continue;
                child.resolveRtlPropertiesIfNeeded();
            }
        }
        return result;
    }

    private final boolean $$robo$$android_view_ViewGroup$resolveLayoutDirection() {
        boolean result = super.resolveLayoutDirection();
        if (result) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                if (!child.isLayoutDirectionInherited()) continue;
                child.resolveLayoutDirection();
            }
        }
        return result;
    }

    private final boolean $$robo$$android_view_ViewGroup$resolveTextDirection() {
        boolean result = super.resolveTextDirection();
        if (result) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                if (!child.isTextDirectionInherited()) continue;
                child.resolveTextDirection();
            }
        }
        return result;
    }

    private final boolean $$robo$$android_view_ViewGroup$resolveTextAlignment() {
        boolean result = super.resolveTextAlignment();
        if (result) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                if (!child.isTextAlignmentInherited()) continue;
                child.resolveTextAlignment();
            }
        }
        return result;
    }

    private final void $$robo$$android_view_ViewGroup$resolvePadding() {
        super.resolvePadding();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isLayoutDirectionInherited() || child.isPaddingResolved()) continue;
            child.resolvePadding();
        }
    }

    private final void $$robo$$android_view_ViewGroup$resolveDrawables() {
        super.resolveDrawables();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isLayoutDirectionInherited() || child.areDrawablesResolved()) continue;
            child.resolveDrawables();
        }
    }

    private final void $$robo$$android_view_ViewGroup$resolveLayoutParams() {
        super.resolveLayoutParams();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            child.resolveLayoutParams();
        }
    }

    private final void $$robo$$android_view_ViewGroup$resetResolvedLayoutDirection() {
        super.resetResolvedLayoutDirection();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isLayoutDirectionInherited()) continue;
            child.resetResolvedLayoutDirection();
        }
    }

    private final void $$robo$$android_view_ViewGroup$resetResolvedTextDirection() {
        super.resetResolvedTextDirection();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isTextDirectionInherited()) continue;
            child.resetResolvedTextDirection();
        }
    }

    private final void $$robo$$android_view_ViewGroup$resetResolvedTextAlignment() {
        super.resetResolvedTextAlignment();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isTextAlignmentInherited()) continue;
            child.resetResolvedTextAlignment();
        }
    }

    private final void $$robo$$android_view_ViewGroup$resetResolvedPadding() {
        super.resetResolvedPadding();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isLayoutDirectionInherited()) continue;
            child.resetResolvedPadding();
        }
    }

    private final void $$robo$$android_view_ViewGroup$resetResolvedDrawables() {
        super.resetResolvedDrawables();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isLayoutDirectionInherited()) continue;
            child.resetResolvedDrawables();
        }
    }

    private final boolean $$robo$$android_view_ViewGroup$shouldDelayChildPressedState() {
        return true;
    }

    private final boolean $$robo$$android_view_ViewGroup$onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return false;
    }

    private final void $$robo$$android_view_ViewGroup$onNestedScrollAccepted(View child, View target, int axes) {
        this.mNestedScrollAxes = axes;
    }

    private final void $$robo$$android_view_ViewGroup$onStopNestedScroll(View child) {
        this.stopNestedScroll();
        this.mNestedScrollAxes = 0;
    }

    private final void $$robo$$android_view_ViewGroup$onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, null);
    }

    private final void $$robo$$android_view_ViewGroup$onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        this.dispatchNestedPreScroll(dx, dy, consumed, null);
    }

    private final boolean $$robo$$android_view_ViewGroup$onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return this.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    private final boolean $$robo$$android_view_ViewGroup$onNestedPreFling(View target, float velocityX, float velocityY) {
        return this.dispatchNestedPreFling(velocityX, velocityY);
    }

    private final int $$robo$$android_view_ViewGroup$getNestedScrollAxes() {
        return this.mNestedScrollAxes;
    }

    private final void $$robo$$android_view_ViewGroup$onSetLayoutParams(View child, LayoutParams layoutParams) {
        this.requestLayout();
    }

    private final void $$robo$$android_view_ViewGroup$captureTransitioningViews(List<View> transitioningViews) {
        if (this.getVisibility() != 0) {
            return;
        }
        if (this.isTransitionGroup()) {
            transitioningViews.add(this);
        } else {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                child.captureTransitioningViews(transitioningViews);
            }
        }
    }

    private final void $$robo$$android_view_ViewGroup$findNamedViews(Map<String, View> namedElements) {
        if (this.getVisibility() != 0 && this.mGhostView == null) {
            return;
        }
        super.findNamedViews(namedElements);
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            child.findNamedViews(namedElements);
        }
    }

    private final boolean $$robo$$android_view_ViewGroup$hasUnhandledKeyListener() {
        return this.mChildUnhandledKeyListeners > 0 || super.hasUnhandledKeyListener();
    }

    private final void $$robo$$android_view_ViewGroup$incrementChildUnhandledKeyListeners() {
        ++this.mChildUnhandledKeyListeners;
        if (this.mChildUnhandledKeyListeners == 1 && this.mParent instanceof ViewGroup) {
            ((ViewGroup)this.mParent).incrementChildUnhandledKeyListeners();
        }
    }

    private final void $$robo$$android_view_ViewGroup$decrementChildUnhandledKeyListeners() {
        --this.mChildUnhandledKeyListeners;
        if (this.mChildUnhandledKeyListeners == 0 && this.mParent instanceof ViewGroup) {
            ((ViewGroup)this.mParent).decrementChildUnhandledKeyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final View $$robo$$android_view_ViewGroup$dispatchUnhandledKeyEvent(KeyEvent evt) {
        if (!this.hasUnhandledKeyListener()) {
            return null;
        }
        ArrayList<View> orderedViews = this.buildOrderedChildList();
        if (orderedViews != null) {
            try {
                for (int i = orderedViews.size() - 1; i >= 0; --i) {
                    View v = orderedViews.get(i);
                    View consumer = v.dispatchUnhandledKeyEvent(evt);
                    if (consumer == null) continue;
                    View view = consumer;
                    return view;
                }
            }
            finally {
                orderedViews.clear();
            }
        } else {
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                View v = this.getChildAt(i);
                View consumer = v.dispatchUnhandledKeyEvent(evt);
                if (consumer == null) continue;
                return consumer;
            }
        }
        if (this.onUnhandledKeyEvent(evt)) {
            return this;
        }
        return null;
    }

    private static final void $$robo$$android_view_ViewGroup$drawRect(Canvas canvas, Paint paint, int x1, int y1, int x2, int y2) {
        if (sDebugLines == null) {
            sDebugLines = new float[16];
        }
        ViewGroup.sDebugLines[0] = x1;
        ViewGroup.sDebugLines[1] = y1;
        ViewGroup.sDebugLines[2] = x2;
        ViewGroup.sDebugLines[3] = y1;
        ViewGroup.sDebugLines[4] = x2;
        ViewGroup.sDebugLines[5] = y1;
        ViewGroup.sDebugLines[6] = x2;
        ViewGroup.sDebugLines[7] = y2;
        ViewGroup.sDebugLines[8] = x2;
        ViewGroup.sDebugLines[9] = y2;
        ViewGroup.sDebugLines[10] = x1;
        ViewGroup.sDebugLines[11] = y2;
        ViewGroup.sDebugLines[12] = x1;
        ViewGroup.sDebugLines[13] = y2;
        ViewGroup.sDebugLines[14] = x1;
        ViewGroup.sDebugLines[15] = y1;
        canvas.drawLines(sDebugLines, paint);
    }

    private final void $$robo$$android_view_ViewGroup$encodeProperties(ViewHierarchyEncoder encoder) {
        super.encodeProperties(encoder);
        encoder.addProperty("focus:descendantFocusability", this.getDescendantFocusability());
        encoder.addProperty("drawing:clipChildren", this.getClipChildren());
        encoder.addProperty("drawing:clipToPadding", this.getClipToPadding());
        encoder.addProperty("drawing:childrenDrawingOrderEnabled", this.isChildrenDrawingOrderEnabled());
        encoder.addProperty("drawing:persistentDrawingCache", this.getPersistentDrawingCache());
        int n = this.getChildCount();
        encoder.addProperty("meta:__childCount__", (short)n);
        for (int i = 0; i < n; ++i) {
            encoder.addPropertyKey("meta:__child__" + i);
            this.getChildAt(i).encode(encoder);
        }
    }

    static void __staticInitializer__() {
        DESCENDANT_FOCUSABILITY_FLAGS = new int[]{131072, 262144, 393216};
        LAYOUT_MODE_DEFAULT = 0;
        SENTINEL_ACTION_MODE = new ShadowedObject(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_ViewGroup_1$__constructor__() {
            }

            private final void $$robo$$android_view_ViewGroup_1$setTitle(CharSequence title) {
            }

            private final void $$robo$$android_view_ViewGroup_1$setTitle(int resId) {
            }

            private final void $$robo$$android_view_ViewGroup_1$setSubtitle(CharSequence subtitle) {
            }

            private final void $$robo$$android_view_ViewGroup_1$setSubtitle(int resId) {
            }

            private final void $$robo$$android_view_ViewGroup_1$setCustomView(View view) {
            }

            private final void $$robo$$android_view_ViewGroup_1$invalidate() {
            }

            private final void $$robo$$android_view_ViewGroup_1$finish() {
            }

            private final Menu $$robo$$android_view_ViewGroup_1$getMenu() {
                return null;
            }

            private final CharSequence $$robo$$android_view_ViewGroup_1$getTitle() {
                return null;
            }

            private final CharSequence $$robo$$android_view_ViewGroup_1$getSubtitle() {
                return null;
            }

            private final View $$robo$$android_view_ViewGroup_1$getCustomView() {
                return null;
            }

            private final MenuInflater $$robo$$android_view_ViewGroup_1$getMenuInflater() {
                return null;
            }

            private void __constructor__() {
                this.$$robo$$android_view_ViewGroup_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewGroup_1$__constructor__(), 0, this);
            }

            @Override
            public void setTitle(CharSequence charSequence) {
                InvokeDynamicSupport.bootstrap("setTitle", $$robo$$android_view_ViewGroup_1$setTitle(java.lang.CharSequence ), 0, this, charSequence);
            }

            @Override
            public void setTitle(int n) {
                InvokeDynamicSupport.bootstrap("setTitle", $$robo$$android_view_ViewGroup_1$setTitle(int ), 0, this, n);
            }

            @Override
            public void setSubtitle(CharSequence charSequence) {
                InvokeDynamicSupport.bootstrap("setSubtitle", $$robo$$android_view_ViewGroup_1$setSubtitle(java.lang.CharSequence ), 0, this, charSequence);
            }

            @Override
            public void setSubtitle(int n) {
                InvokeDynamicSupport.bootstrap("setSubtitle", $$robo$$android_view_ViewGroup_1$setSubtitle(int ), 0, this, n);
            }

            @Override
            public void setCustomView(View view) {
                InvokeDynamicSupport.bootstrap("setCustomView", $$robo$$android_view_ViewGroup_1$setCustomView(android.view.View ), 0, this, view);
            }

            @Override
            public void invalidate() {
                InvokeDynamicSupport.bootstrap("invalidate", $$robo$$android_view_ViewGroup_1$invalidate(), 0, this);
            }

            @Override
            public void finish() {
                InvokeDynamicSupport.bootstrap("finish", $$robo$$android_view_ViewGroup_1$finish(), 0, this);
            }

            @Override
            public Menu getMenu() {
                return InvokeDynamicSupport.bootstrap("getMenu", $$robo$$android_view_ViewGroup_1$getMenu(), 0, this);
            }

            @Override
            public CharSequence getTitle() {
                return InvokeDynamicSupport.bootstrap("getTitle", $$robo$$android_view_ViewGroup_1$getTitle(), 0, this);
            }

            @Override
            public CharSequence getSubtitle() {
                return InvokeDynamicSupport.bootstrap("getSubtitle", $$robo$$android_view_ViewGroup_1$getSubtitle(), 0, this);
            }

            @Override
            public View getCustomView() {
                return InvokeDynamicSupport.bootstrap("getCustomView", $$robo$$android_view_ViewGroup_1$getCustomView(), 0, this);
            }

            @Override
            public MenuInflater getMenuInflater() {
                return InvokeDynamicSupport.bootstrap("getMenuInflater", $$robo$$android_view_ViewGroup_1$getMenuInflater(), 0, this);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_view_ViewGroup$__constructor__(context);
    }

    public ViewGroup(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewGroup$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_view_ViewGroup$__constructor__(context, attributeSet);
    }

    public ViewGroup(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewGroup$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_view_ViewGroup$__constructor__(context, attributeSet, n);
    }

    public ViewGroup(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewGroup$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_view_ViewGroup$__constructor__(context, attributeSet, n, n2);
    }

    public ViewGroup(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewGroup$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private void initViewGroup() {
        InvokeDynamicSupport.bootstrap("initViewGroup", $$robo$$android_view_ViewGroup$initViewGroup(), 0, this);
    }

    private void initFromAttributes(Context context, AttributeSet attributeSet, int n, int n2) {
        InvokeDynamicSupport.bootstrap("initFromAttributes", $$robo$$android_view_ViewGroup$initFromAttributes(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    @ViewDebug.ExportedProperty(category="focus", mapping={@ViewDebug.IntToString(from=131072, to="FOCUS_BEFORE_DESCENDANTS"), @ViewDebug.IntToString(from=262144, to="FOCUS_AFTER_DESCENDANTS"), @ViewDebug.IntToString(from=393216, to="FOCUS_BLOCK_DESCENDANTS")})
    public int getDescendantFocusability() {
        return (int)InvokeDynamicSupport.bootstrap("getDescendantFocusability", $$robo$$android_view_ViewGroup$getDescendantFocusability(), 0, this);
    }

    public void setDescendantFocusability(int n) {
        InvokeDynamicSupport.bootstrap("setDescendantFocusability", $$robo$$android_view_ViewGroup$setDescendantFocusability(int ), 0, this, n);
    }

    @Override
    void handleFocusGainInternal(int n, Rect rect) {
        InvokeDynamicSupport.bootstrap("handleFocusGainInternal", $$robo$$android_view_ViewGroup$handleFocusGainInternal(int android.graphics.Rect ), 0, this, n, rect);
    }

    @Override
    public void requestChildFocus(View view, View view2) {
        InvokeDynamicSupport.bootstrap("requestChildFocus", $$robo$$android_view_ViewGroup$requestChildFocus(android.view.View android.view.View ), 0, this, view, view2);
    }

    void setDefaultFocus(View view) {
        InvokeDynamicSupport.bootstrap("setDefaultFocus", $$robo$$android_view_ViewGroup$setDefaultFocus(android.view.View ), 0, this, view);
    }

    void clearDefaultFocus(View view) {
        InvokeDynamicSupport.bootstrap("clearDefaultFocus", $$robo$$android_view_ViewGroup$clearDefaultFocus(android.view.View ), 0, this, view);
    }

    @Override
    boolean hasDefaultFocus() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasDefaultFocus", $$robo$$android_view_ViewGroup$hasDefaultFocus(), 0, this);
    }

    void clearFocusedInCluster(View view) {
        InvokeDynamicSupport.bootstrap("clearFocusedInCluster", $$robo$$android_view_ViewGroup$clearFocusedInCluster(android.view.View ), 0, this, view);
    }

    void clearFocusedInCluster() {
        InvokeDynamicSupport.bootstrap("clearFocusedInCluster", $$robo$$android_view_ViewGroup$clearFocusedInCluster(), 0, this);
    }

    @Override
    public void focusableViewAvailable(View view) {
        InvokeDynamicSupport.bootstrap("focusableViewAvailable", $$robo$$android_view_ViewGroup$focusableViewAvailable(android.view.View ), 0, this, view);
    }

    @Override
    public boolean showContextMenuForChild(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("showContextMenuForChild", $$robo$$android_view_ViewGroup$showContextMenuForChild(android.view.View ), 0, this, view);
    }

    public boolean isShowingContextMenuWithCoords() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShowingContextMenuWithCoords", $$robo$$android_view_ViewGroup$isShowingContextMenuWithCoords(), 0, this);
    }

    @Override
    public boolean showContextMenuForChild(View view, float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrap("showContextMenuForChild", $$robo$$android_view_ViewGroup$showContextMenuForChild(android.view.View float float ), 0, this, view, f, f2);
    }

    @Override
    public ActionMode startActionModeForChild(View view, ActionMode.Callback callback) {
        return InvokeDynamicSupport.bootstrap("startActionModeForChild", $$robo$$android_view_ViewGroup$startActionModeForChild(android.view.View android.view.ActionMode$Callback ), 0, this, view, callback);
    }

    @Override
    public ActionMode startActionModeForChild(View view, ActionMode.Callback callback, int n) {
        return InvokeDynamicSupport.bootstrap("startActionModeForChild", $$robo$$android_view_ViewGroup$startActionModeForChild(android.view.View android.view.ActionMode$Callback int ), 0, this, view, callback, n);
    }

    @Override
    public boolean dispatchActivityResult(String string2, int n, int n2, Intent intent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchActivityResult", $$robo$$android_view_ViewGroup$dispatchActivityResult(java.lang.String int int android.content.Intent ), 0, this, string2, n, n2, intent);
    }

    @Override
    public View focusSearch(View view, int n) {
        return InvokeDynamicSupport.bootstrap("focusSearch", $$robo$$android_view_ViewGroup$focusSearch(android.view.View int ), 0, this, view, n);
    }

    @Override
    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestChildRectangleOnScreen", $$robo$$android_view_ViewGroup$requestChildRectangleOnScreen(android.view.View android.graphics.Rect boolean ), 0, this, view, rect, bl);
    }

    @Override
    public boolean requestSendAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestSendAccessibilityEvent", $$robo$$android_view_ViewGroup$requestSendAccessibilityEvent(android.view.View android.view.accessibility.AccessibilityEvent ), 0, this, view, accessibilityEvent);
    }

    public boolean onRequestSendAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onRequestSendAccessibilityEvent", $$robo$$android_view_ViewGroup$onRequestSendAccessibilityEvent(android.view.View android.view.accessibility.AccessibilityEvent ), 0, this, view, accessibilityEvent);
    }

    public boolean onRequestSendAccessibilityEventInternal(View view, AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onRequestSendAccessibilityEventInternal", $$robo$$android_view_ViewGroup$onRequestSendAccessibilityEventInternal(android.view.View android.view.accessibility.AccessibilityEvent ), 0, this, view, accessibilityEvent);
    }

    @Override
    public void childHasTransientStateChanged(View view, boolean bl) {
        InvokeDynamicSupport.bootstrap("childHasTransientStateChanged", $$robo$$android_view_ViewGroup$childHasTransientStateChanged(android.view.View boolean ), 0, this, view, bl);
    }

    @Override
    public boolean hasTransientState() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasTransientState", $$robo$$android_view_ViewGroup$hasTransientState(), 0, this);
    }

    @Override
    public boolean dispatchUnhandledMove(View view, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchUnhandledMove", $$robo$$android_view_ViewGroup$dispatchUnhandledMove(android.view.View int ), 0, this, view, n);
    }

    @Override
    public void clearChildFocus(View view) {
        InvokeDynamicSupport.bootstrap("clearChildFocus", $$robo$$android_view_ViewGroup$clearChildFocus(android.view.View ), 0, this, view);
    }

    @Override
    public void clearFocus() {
        InvokeDynamicSupport.bootstrap("clearFocus", $$robo$$android_view_ViewGroup$clearFocus(), 0, this);
    }

    @Override
    void unFocus(View view) {
        InvokeDynamicSupport.bootstrap("unFocus", $$robo$$android_view_ViewGroup$unFocus(android.view.View ), 0, this, view);
    }

    public View getFocusedChild() {
        return InvokeDynamicSupport.bootstrap("getFocusedChild", $$robo$$android_view_ViewGroup$getFocusedChild(), 0, this);
    }

    View getDeepestFocusedChild() {
        return InvokeDynamicSupport.bootstrap("getDeepestFocusedChild", $$robo$$android_view_ViewGroup$getDeepestFocusedChild(), 0, this);
    }

    @Override
    public boolean hasFocus() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFocus", $$robo$$android_view_ViewGroup$hasFocus(), 0, this);
    }

    @Override
    public View findFocus() {
        return InvokeDynamicSupport.bootstrap("findFocus", $$robo$$android_view_ViewGroup$findFocus(), 0, this);
    }

    @Override
    boolean hasFocusable(boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFocusable", $$robo$$android_view_ViewGroup$hasFocusable(boolean boolean ), 0, this, bl, bl2);
    }

    boolean hasFocusableChild(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFocusableChild", $$robo$$android_view_ViewGroup$hasFocusableChild(boolean ), 0, this, bl);
    }

    @Override
    public void addFocusables(ArrayList<View> arrayList, int n, int n2) {
        InvokeDynamicSupport.bootstrap("addFocusables", $$robo$$android_view_ViewGroup$addFocusables(java.util.ArrayList<android.view.View> int int ), 0, this, arrayList, n, n2);
    }

    @Override
    public void addKeyboardNavigationClusters(Collection<View> collection, int n) {
        InvokeDynamicSupport.bootstrap("addKeyboardNavigationClusters", $$robo$$android_view_ViewGroup$addKeyboardNavigationClusters(java.util.Collection<android.view.View> int ), 0, this, collection, n);
    }

    public void setTouchscreenBlocksFocus(boolean bl) {
        InvokeDynamicSupport.bootstrap("setTouchscreenBlocksFocus", $$robo$$android_view_ViewGroup$setTouchscreenBlocksFocus(boolean ), 0, this, bl);
    }

    private void setTouchscreenBlocksFocusNoRefocus(boolean bl) {
        InvokeDynamicSupport.bootstrap("setTouchscreenBlocksFocusNoRefocus", $$robo$$android_view_ViewGroup$setTouchscreenBlocksFocusNoRefocus(boolean ), 0, this, bl);
    }

    @ViewDebug.ExportedProperty(category="focus")
    public boolean getTouchscreenBlocksFocus() {
        return (boolean)InvokeDynamicSupport.bootstrap("getTouchscreenBlocksFocus", $$robo$$android_view_ViewGroup$getTouchscreenBlocksFocus(), 0, this);
    }

    boolean shouldBlockFocusForTouchscreen() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldBlockFocusForTouchscreen", $$robo$$android_view_ViewGroup$shouldBlockFocusForTouchscreen(), 0, this);
    }

    @Override
    public void findViewsWithText(ArrayList<View> arrayList, CharSequence charSequence, int n) {
        InvokeDynamicSupport.bootstrap("findViewsWithText", $$robo$$android_view_ViewGroup$findViewsWithText(java.util.ArrayList<android.view.View> java.lang.CharSequence int ), 0, this, arrayList, charSequence, n);
    }

    public View findViewByAccessibilityIdTraversal(int n) {
        return InvokeDynamicSupport.bootstrap("findViewByAccessibilityIdTraversal", $$robo$$android_view_ViewGroup$findViewByAccessibilityIdTraversal(int ), 0, this, n);
    }

    public View findViewByAutofillIdTraversal(int n) {
        return InvokeDynamicSupport.bootstrap("findViewByAutofillIdTraversal", $$robo$$android_view_ViewGroup$findViewByAutofillIdTraversal(int ), 0, this, n);
    }

    @Override
    public void dispatchWindowFocusChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("dispatchWindowFocusChanged", $$robo$$android_view_ViewGroup$dispatchWindowFocusChanged(boolean ), 0, this, bl);
    }

    @Override
    public void addTouchables(ArrayList<View> arrayList) {
        InvokeDynamicSupport.bootstrap("addTouchables", $$robo$$android_view_ViewGroup$addTouchables(java.util.ArrayList<android.view.View> ), 0, this, arrayList);
    }

    @Override
    public void makeOptionalFitsSystemWindows() {
        InvokeDynamicSupport.bootstrap("makeOptionalFitsSystemWindows", $$robo$$android_view_ViewGroup$makeOptionalFitsSystemWindows(), 0, this);
    }

    @Override
    public void dispatchDisplayHint(int n) {
        InvokeDynamicSupport.bootstrap("dispatchDisplayHint", $$robo$$android_view_ViewGroup$dispatchDisplayHint(int ), 0, this, n);
    }

    protected void onChildVisibilityChanged(View view, int n, int n2) {
        InvokeDynamicSupport.bootstrap("onChildVisibilityChanged", $$robo$$android_view_ViewGroup$onChildVisibilityChanged(android.view.View int int ), 0, this, view, n, n2);
    }

    @Override
    protected void dispatchVisibilityChanged(View view, int n) {
        InvokeDynamicSupport.bootstrap("dispatchVisibilityChanged", $$robo$$android_view_ViewGroup$dispatchVisibilityChanged(android.view.View int ), 0, this, view, n);
    }

    @Override
    public void dispatchWindowVisibilityChanged(int n) {
        InvokeDynamicSupport.bootstrap("dispatchWindowVisibilityChanged", $$robo$$android_view_ViewGroup$dispatchWindowVisibilityChanged(int ), 0, this, n);
    }

    @Override
    boolean dispatchVisibilityAggregated(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchVisibilityAggregated", $$robo$$android_view_ViewGroup$dispatchVisibilityAggregated(boolean ), 0, this, bl);
    }

    @Override
    public void dispatchConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("dispatchConfigurationChanged", $$robo$$android_view_ViewGroup$dispatchConfigurationChanged(android.content.res.Configuration ), 0, this, configuration);
    }

    @Override
    public void recomputeViewAttributes(View view) {
        InvokeDynamicSupport.bootstrap("recomputeViewAttributes", $$robo$$android_view_ViewGroup$recomputeViewAttributes(android.view.View ), 0, this, view);
    }

    @Override
    void dispatchCollectViewAttributes(View.AttachInfo attachInfo, int n) {
        InvokeDynamicSupport.bootstrap("dispatchCollectViewAttributes", $$robo$$android_view_ViewGroup$dispatchCollectViewAttributes(android.view.View$AttachInfo int ), 0, this, attachInfo, n);
    }

    @Override
    public void bringChildToFront(View view) {
        InvokeDynamicSupport.bootstrap("bringChildToFront", $$robo$$android_view_ViewGroup$bringChildToFront(android.view.View ), 0, this, view);
    }

    private PointF getLocalPoint() {
        return InvokeDynamicSupport.bootstrap("getLocalPoint", $$robo$$android_view_ViewGroup$getLocalPoint(), 0, this);
    }

    @Override
    boolean dispatchDragEnterExitInPreN(DragEvent dragEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchDragEnterExitInPreN", $$robo$$android_view_ViewGroup$dispatchDragEnterExitInPreN(android.view.DragEvent ), 0, this, dragEvent);
    }

    @Override
    public boolean dispatchDragEvent(DragEvent dragEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchDragEvent", $$robo$$android_view_ViewGroup$dispatchDragEvent(android.view.DragEvent ), 0, this, dragEvent);
    }

    View findFrontmostDroppableChildAt(float f, float f2, PointF pointF) {
        return InvokeDynamicSupport.bootstrap("findFrontmostDroppableChildAt", $$robo$$android_view_ViewGroup$findFrontmostDroppableChildAt(float float android.graphics.PointF ), 0, this, f, f2, pointF);
    }

    boolean notifyChildOfDragStart(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("notifyChildOfDragStart", $$robo$$android_view_ViewGroup$notifyChildOfDragStart(android.view.View ), 0, this, view);
    }

    @Override
    public void dispatchWindowSystemUiVisiblityChanged(int n) {
        InvokeDynamicSupport.bootstrap("dispatchWindowSystemUiVisiblityChanged", $$robo$$android_view_ViewGroup$dispatchWindowSystemUiVisiblityChanged(int ), 0, this, n);
    }

    @Override
    public void dispatchSystemUiVisibilityChanged(int n) {
        InvokeDynamicSupport.bootstrap("dispatchSystemUiVisibilityChanged", $$robo$$android_view_ViewGroup$dispatchSystemUiVisibilityChanged(int ), 0, this, n);
    }

    @Override
    boolean updateLocalSystemUiVisibility(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateLocalSystemUiVisibility", $$robo$$android_view_ViewGroup$updateLocalSystemUiVisibility(int int ), 0, this, n, n2);
    }

    @Override
    public boolean dispatchKeyEventPreIme(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchKeyEventPreIme", $$robo$$android_view_ViewGroup$dispatchKeyEventPreIme(android.view.KeyEvent ), 0, this, keyEvent);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchKeyEvent", $$robo$$android_view_ViewGroup$dispatchKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    @Override
    public boolean dispatchKeyShortcutEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchKeyShortcutEvent", $$robo$$android_view_ViewGroup$dispatchKeyShortcutEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    @Override
    public boolean dispatchTrackballEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchTrackballEvent", $$robo$$android_view_ViewGroup$dispatchTrackballEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean dispatchCapturedPointerEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchCapturedPointerEvent", $$robo$$android_view_ViewGroup$dispatchCapturedPointerEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public void dispatchPointerCaptureChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("dispatchPointerCaptureChanged", $$robo$$android_view_ViewGroup$dispatchPointerCaptureChanged(boolean ), 0, this, bl);
    }

    @Override
    public PointerIcon onResolvePointerIcon(MotionEvent motionEvent, int n) {
        return InvokeDynamicSupport.bootstrap("onResolvePointerIcon", $$robo$$android_view_ViewGroup$onResolvePointerIcon(android.view.MotionEvent int ), 0, this, motionEvent, n);
    }

    private PointerIcon dispatchResolvePointerIcon(MotionEvent motionEvent, int n, View view) {
        return InvokeDynamicSupport.bootstrap("dispatchResolvePointerIcon", $$robo$$android_view_ViewGroup$dispatchResolvePointerIcon(android.view.MotionEvent int android.view.View ), 0, this, motionEvent, n, view);
    }

    private int getAndVerifyPreorderedIndex(int n, int n2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getAndVerifyPreorderedIndex", $$robo$$android_view_ViewGroup$getAndVerifyPreorderedIndex(int int boolean ), 0, this, n, n2, bl);
    }

    @Override
    protected boolean dispatchHoverEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchHoverEvent", $$robo$$android_view_ViewGroup$dispatchHoverEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void exitHoverTargets() {
        InvokeDynamicSupport.bootstrap("exitHoverTargets", $$robo$$android_view_ViewGroup$exitHoverTargets(), 0, this);
    }

    private void cancelHoverTarget(View view) {
        InvokeDynamicSupport.bootstrap("cancelHoverTarget", $$robo$$android_view_ViewGroup$cancelHoverTarget(android.view.View ), 0, this, view);
    }

    @Override
    boolean dispatchTooltipHoverEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchTooltipHoverEvent", $$robo$$android_view_ViewGroup$dispatchTooltipHoverEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private boolean dispatchTooltipHoverEvent(MotionEvent motionEvent, View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchTooltipHoverEvent", $$robo$$android_view_ViewGroup$dispatchTooltipHoverEvent(android.view.MotionEvent android.view.View ), 0, this, motionEvent, view);
    }

    private void exitTooltipHoverTargets() {
        InvokeDynamicSupport.bootstrap("exitTooltipHoverTargets", $$robo$$android_view_ViewGroup$exitTooltipHoverTargets(), 0, this);
    }

    @Override
    protected boolean hasHoveredChild() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasHoveredChild", $$robo$$android_view_ViewGroup$hasHoveredChild(), 0, this);
    }

    @Override
    public void addChildrenForAccessibility(ArrayList<View> arrayList) {
        InvokeDynamicSupport.bootstrap("addChildrenForAccessibility", $$robo$$android_view_ViewGroup$addChildrenForAccessibility(java.util.ArrayList<android.view.View> ), 0, this, arrayList);
    }

    public boolean onInterceptHoverEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onInterceptHoverEvent", $$robo$$android_view_ViewGroup$onInterceptHoverEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private static MotionEvent obtainMotionEventNoHistoryOrSelf(MotionEvent motionEvent) {
        return InvokeDynamicSupport.bootstrapStatic("obtainMotionEventNoHistoryOrSelf", $$robo$$android_view_ViewGroup$obtainMotionEventNoHistoryOrSelf(android.view.MotionEvent ), 0, (MotionEvent)motionEvent);
    }

    @Override
    protected boolean dispatchGenericPointerEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchGenericPointerEvent", $$robo$$android_view_ViewGroup$dispatchGenericPointerEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    protected boolean dispatchGenericFocusedEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchGenericFocusedEvent", $$robo$$android_view_ViewGroup$dispatchGenericFocusedEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private boolean dispatchTransformedGenericPointerEvent(MotionEvent motionEvent, View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchTransformedGenericPointerEvent", $$robo$$android_view_ViewGroup$dispatchTransformedGenericPointerEvent(android.view.MotionEvent android.view.View ), 0, this, motionEvent, view);
    }

    private MotionEvent getTransformedMotionEvent(MotionEvent motionEvent, View view) {
        return InvokeDynamicSupport.bootstrap("getTransformedMotionEvent", $$robo$$android_view_ViewGroup$getTransformedMotionEvent(android.view.MotionEvent android.view.View ), 0, this, motionEvent, view);
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchTouchEvent", $$robo$$android_view_ViewGroup$dispatchTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    public ArrayList<View> buildTouchDispatchChildList() {
        return InvokeDynamicSupport.bootstrap("buildTouchDispatchChildList", $$robo$$android_view_ViewGroup$buildTouchDispatchChildList(), 0, this);
    }

    private View findChildWithAccessibilityFocus() {
        return InvokeDynamicSupport.bootstrap("findChildWithAccessibilityFocus", $$robo$$android_view_ViewGroup$findChildWithAccessibilityFocus(), 0, this);
    }

    private void resetTouchState() {
        InvokeDynamicSupport.bootstrap("resetTouchState", $$robo$$android_view_ViewGroup$resetTouchState(), 0, this);
    }

    private static boolean resetCancelNextUpFlag(View view) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("resetCancelNextUpFlag", $$robo$$android_view_ViewGroup$resetCancelNextUpFlag(android.view.View ), 0, (View)view);
    }

    private void clearTouchTargets() {
        InvokeDynamicSupport.bootstrap("clearTouchTargets", $$robo$$android_view_ViewGroup$clearTouchTargets(), 0, this);
    }

    private void cancelAndClearTouchTargets(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("cancelAndClearTouchTargets", $$robo$$android_view_ViewGroup$cancelAndClearTouchTargets(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private TouchTarget getTouchTarget(View view) {
        return InvokeDynamicSupport.bootstrap("getTouchTarget", $$robo$$android_view_ViewGroup$getTouchTarget(android.view.View ), 0, this, view);
    }

    private TouchTarget addTouchTarget(View view, int n) {
        return InvokeDynamicSupport.bootstrap("addTouchTarget", $$robo$$android_view_ViewGroup$addTouchTarget(android.view.View int ), 0, this, view, n);
    }

    private void removePointersFromTouchTargets(int n) {
        InvokeDynamicSupport.bootstrap("removePointersFromTouchTargets", $$robo$$android_view_ViewGroup$removePointersFromTouchTargets(int ), 0, this, n);
    }

    private void cancelTouchTarget(View view) {
        InvokeDynamicSupport.bootstrap("cancelTouchTarget", $$robo$$android_view_ViewGroup$cancelTouchTarget(android.view.View ), 0, this, view);
    }

    private static boolean canViewReceivePointerEvents(View view) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("canViewReceivePointerEvents", $$robo$$android_view_ViewGroup$canViewReceivePointerEvents(android.view.View ), 0, (View)view);
    }

    private float[] getTempPoint() {
        return InvokeDynamicSupport.bootstrap("getTempPoint", $$robo$$android_view_ViewGroup$getTempPoint(), 0, this);
    }

    protected boolean isTransformedTouchPointInView(float f, float f2, View view, PointF pointF) {
        return (boolean)InvokeDynamicSupport.bootstrap("isTransformedTouchPointInView", $$robo$$android_view_ViewGroup$isTransformedTouchPointInView(float float android.view.View android.graphics.PointF ), 0, this, f, f2, view, pointF);
    }

    public void transformPointToViewLocal(float[] fArray, View view) {
        InvokeDynamicSupport.bootstrap("transformPointToViewLocal", $$robo$$android_view_ViewGroup$transformPointToViewLocal(float[] android.view.View ), 0, this, fArray, view);
    }

    private boolean dispatchTransformedTouchEvent(MotionEvent motionEvent, boolean bl, View view, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchTransformedTouchEvent", $$robo$$android_view_ViewGroup$dispatchTransformedTouchEvent(android.view.MotionEvent boolean android.view.View int ), 0, this, motionEvent, bl, view, n);
    }

    public void setMotionEventSplittingEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMotionEventSplittingEnabled", $$robo$$android_view_ViewGroup$setMotionEventSplittingEnabled(boolean ), 0, this, bl);
    }

    public boolean isMotionEventSplittingEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMotionEventSplittingEnabled", $$robo$$android_view_ViewGroup$isMotionEventSplittingEnabled(), 0, this);
    }

    public boolean isTransitionGroup() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTransitionGroup", $$robo$$android_view_ViewGroup$isTransitionGroup(), 0, this);
    }

    public void setTransitionGroup(boolean bl) {
        InvokeDynamicSupport.bootstrap("setTransitionGroup", $$robo$$android_view_ViewGroup$setTransitionGroup(boolean ), 0, this, bl);
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean bl) {
        InvokeDynamicSupport.bootstrap("requestDisallowInterceptTouchEvent", $$robo$$android_view_ViewGroup$requestDisallowInterceptTouchEvent(boolean ), 0, this, bl);
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onInterceptTouchEvent", $$robo$$android_view_ViewGroup$onInterceptTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean requestFocus(int n, Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestFocus", $$robo$$android_view_ViewGroup$requestFocus(int android.graphics.Rect ), 0, this, n, rect);
    }

    protected boolean onRequestFocusInDescendants(int n, Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("onRequestFocusInDescendants", $$robo$$android_view_ViewGroup$onRequestFocusInDescendants(int android.graphics.Rect ), 0, this, n, rect);
    }

    @Override
    public boolean restoreDefaultFocus() {
        return (boolean)InvokeDynamicSupport.bootstrap("restoreDefaultFocus", $$robo$$android_view_ViewGroup$restoreDefaultFocus(), 0, this);
    }

    @Override
    public boolean restoreFocusInCluster(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("restoreFocusInCluster", $$robo$$android_view_ViewGroup$restoreFocusInCluster(int ), 0, this, n);
    }

    private boolean restoreFocusInClusterInternal(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("restoreFocusInClusterInternal", $$robo$$android_view_ViewGroup$restoreFocusInClusterInternal(int ), 0, this, n);
    }

    @Override
    public boolean restoreFocusNotInCluster() {
        return (boolean)InvokeDynamicSupport.bootstrap("restoreFocusNotInCluster", $$robo$$android_view_ViewGroup$restoreFocusNotInCluster(), 0, this);
    }

    @Override
    public void dispatchStartTemporaryDetach() {
        InvokeDynamicSupport.bootstrap("dispatchStartTemporaryDetach", $$robo$$android_view_ViewGroup$dispatchStartTemporaryDetach(), 0, this);
    }

    @Override
    public void dispatchFinishTemporaryDetach() {
        InvokeDynamicSupport.bootstrap("dispatchFinishTemporaryDetach", $$robo$$android_view_ViewGroup$dispatchFinishTemporaryDetach(), 0, this);
    }

    @Override
    void dispatchAttachedToWindow(View.AttachInfo attachInfo, int n) {
        InvokeDynamicSupport.bootstrap("dispatchAttachedToWindow", $$robo$$android_view_ViewGroup$dispatchAttachedToWindow(android.view.View$AttachInfo int ), 0, this, attachInfo, n);
    }

    @Override
    void dispatchScreenStateChanged(int n) {
        InvokeDynamicSupport.bootstrap("dispatchScreenStateChanged", $$robo$$android_view_ViewGroup$dispatchScreenStateChanged(int ), 0, this, n);
    }

    @Override
    void dispatchMovedToDisplay(Display display, Configuration configuration) {
        InvokeDynamicSupport.bootstrap("dispatchMovedToDisplay", $$robo$$android_view_ViewGroup$dispatchMovedToDisplay(android.view.Display android.content.res.Configuration ), 0, this, display, configuration);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchPopulateAccessibilityEventInternal", $$robo$$android_view_ViewGroup$dispatchPopulateAccessibilityEventInternal(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void dispatchProvideStructure(ViewStructure viewStructure) {
        InvokeDynamicSupport.bootstrap("dispatchProvideStructure", $$robo$$android_view_ViewGroup$dispatchProvideStructure(android.view.ViewStructure ), 0, this, viewStructure);
    }

    @Override
    public void dispatchProvideAutofillStructure(ViewStructure viewStructure, int n) {
        InvokeDynamicSupport.bootstrap("dispatchProvideAutofillStructure", $$robo$$android_view_ViewGroup$dispatchProvideAutofillStructure(android.view.ViewStructure int ), 0, this, viewStructure, n);
    }

    private ChildListForAutoFill getChildrenForAutofill(int n) {
        return InvokeDynamicSupport.bootstrap("getChildrenForAutofill", $$robo$$android_view_ViewGroup$getChildrenForAutofill(int ), 0, this, n);
    }

    private void populateChildrenForAutofill(ArrayList<View> arrayList, int n) {
        InvokeDynamicSupport.bootstrap("populateChildrenForAutofill", $$robo$$android_view_ViewGroup$populateChildrenForAutofill(java.util.ArrayList<android.view.View> int ), 0, this, arrayList, n);
    }

    private static View getAndVerifyPreorderedView(ArrayList<View> arrayList, View[] viewArray, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getAndVerifyPreorderedView", $$robo$$android_view_ViewGroup$getAndVerifyPreorderedView(java.util.ArrayList<android.view.View> android.view.View[] int ), 0, arrayList, (View[])viewArray, (int)n);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoInternal", $$robo$$android_view_ViewGroup$onInitializeAccessibilityNodeInfoInternal(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_view_ViewGroup$getAccessibilityClassName(), 0, this);
    }

    @Override
    public void notifySubtreeAccessibilityStateChanged(View view, View view2, int n) {
        InvokeDynamicSupport.bootstrap("notifySubtreeAccessibilityStateChanged", $$robo$$android_view_ViewGroup$notifySubtreeAccessibilityStateChanged(android.view.View android.view.View int ), 0, this, view, view2, n);
    }

    @Override
    public void notifySubtreeAccessibilityStateChangedIfNeeded() {
        InvokeDynamicSupport.bootstrap("notifySubtreeAccessibilityStateChangedIfNeeded", $$robo$$android_view_ViewGroup$notifySubtreeAccessibilityStateChangedIfNeeded(), 0, this);
    }

    @Override
    void resetSubtreeAccessibilityStateChanged() {
        InvokeDynamicSupport.bootstrap("resetSubtreeAccessibilityStateChanged", $$robo$$android_view_ViewGroup$resetSubtreeAccessibilityStateChanged(), 0, this);
    }

    int getNumChildrenForAccessibility() {
        return (int)InvokeDynamicSupport.bootstrap("getNumChildrenForAccessibility", $$robo$$android_view_ViewGroup$getNumChildrenForAccessibility(), 0, this);
    }

    @Override
    public boolean onNestedPrePerformAccessibilityAction(View view, int n, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("onNestedPrePerformAccessibilityAction", $$robo$$android_view_ViewGroup$onNestedPrePerformAccessibilityAction(android.view.View int android.os.Bundle ), 0, this, view, n, bundle);
    }

    @Override
    void dispatchDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("dispatchDetachedFromWindow", $$robo$$android_view_ViewGroup$dispatchDetachedFromWindow(), 0, this);
    }

    @Override
    protected void internalSetPadding(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("internalSetPadding", $$robo$$android_view_ViewGroup$internalSetPadding(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    protected void dispatchSaveInstanceState(SparseArray<Parcelable> sparseArray) {
        InvokeDynamicSupport.bootstrap("dispatchSaveInstanceState", $$robo$$android_view_ViewGroup$dispatchSaveInstanceState(android.util.SparseArray<android.os.Parcelable> ), 0, this, sparseArray);
    }

    protected void dispatchFreezeSelfOnly(SparseArray<Parcelable> sparseArray) {
        InvokeDynamicSupport.bootstrap("dispatchFreezeSelfOnly", $$robo$$android_view_ViewGroup$dispatchFreezeSelfOnly(android.util.SparseArray<android.os.Parcelable> ), 0, this, sparseArray);
    }

    @Override
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> sparseArray) {
        InvokeDynamicSupport.bootstrap("dispatchRestoreInstanceState", $$robo$$android_view_ViewGroup$dispatchRestoreInstanceState(android.util.SparseArray<android.os.Parcelable> ), 0, this, sparseArray);
    }

    protected void dispatchThawSelfOnly(SparseArray<Parcelable> sparseArray) {
        InvokeDynamicSupport.bootstrap("dispatchThawSelfOnly", $$robo$$android_view_ViewGroup$dispatchThawSelfOnly(android.util.SparseArray<android.os.Parcelable> ), 0, this, sparseArray);
    }

    @Deprecated
    protected void setChildrenDrawingCacheEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setChildrenDrawingCacheEnabled", $$robo$$android_view_ViewGroup$setChildrenDrawingCacheEnabled(boolean ), 0, this, bl);
    }

    @Override
    public Bitmap createSnapshot(ViewDebug.CanvasProvider canvasProvider, boolean bl) {
        return InvokeDynamicSupport.bootstrap("createSnapshot", $$robo$$android_view_ViewGroup$createSnapshot(android.view.ViewDebug$CanvasProvider boolean ), 0, this, canvasProvider, bl);
    }

    boolean isLayoutModeOptical() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLayoutModeOptical", $$robo$$android_view_ViewGroup$isLayoutModeOptical(), 0, this);
    }

    @Override
    Insets computeOpticalInsets() {
        return InvokeDynamicSupport.bootstrap("computeOpticalInsets", $$robo$$android_view_ViewGroup$computeOpticalInsets(), 0, this);
    }

    private static void fillRect(Canvas canvas, Paint paint, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrapStatic("fillRect", $$robo$$android_view_ViewGroup$fillRect(android.graphics.Canvas android.graphics.Paint int int int int ), 0, (Canvas)canvas, (Paint)paint, (int)n, (int)n2, (int)n3, (int)n4);
    }

    private static int sign(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("sign", $$robo$$android_view_ViewGroup$sign(int ), 0, (int)n);
    }

    private static void drawCorner(Canvas canvas, Paint paint, int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrapStatic("drawCorner", $$robo$$android_view_ViewGroup$drawCorner(android.graphics.Canvas android.graphics.Paint int int int int int ), 0, (Canvas)canvas, (Paint)paint, (int)n, (int)n2, (int)n3, (int)n4, (int)n5);
    }

    private static void drawRectCorners(Canvas canvas, int n, int n2, int n3, int n4, Paint paint, int n5, int n6) {
        InvokeDynamicSupport.bootstrapStatic("drawRectCorners", $$robo$$android_view_ViewGroup$drawRectCorners(android.graphics.Canvas int int int int android.graphics.Paint int int ), 0, (Canvas)canvas, (int)n, (int)n2, (int)n3, (int)n4, (Paint)paint, (int)n5, (int)n6);
    }

    private static void fillDifference(Canvas canvas, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Paint paint) {
        InvokeDynamicSupport.bootstrapStatic("fillDifference", $$robo$$android_view_ViewGroup$fillDifference(android.graphics.Canvas int int int int int int int int android.graphics.Paint ), 0, (Canvas)canvas, (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (Paint)paint);
    }

    protected void onDebugDrawMargins(Canvas canvas, Paint paint) {
        InvokeDynamicSupport.bootstrap("onDebugDrawMargins", $$robo$$android_view_ViewGroup$onDebugDrawMargins(android.graphics.Canvas android.graphics.Paint ), 0, this, canvas, paint);
    }

    protected void onDebugDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDebugDraw", $$robo$$android_view_ViewGroup$onDebugDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("dispatchDraw", $$robo$$android_view_ViewGroup$dispatchDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    public ViewGroupOverlay getOverlay() {
        return InvokeDynamicSupport.bootstrap("getOverlay", $$robo$$android_view_ViewGroup$getOverlay(), 0, this);
    }

    protected int getChildDrawingOrder(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getChildDrawingOrder", $$robo$$android_view_ViewGroup$getChildDrawingOrder(int int ), 0, this, n, n2);
    }

    private boolean hasChildWithZ() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasChildWithZ", $$robo$$android_view_ViewGroup$hasChildWithZ(), 0, this);
    }

    ArrayList<View> buildOrderedChildList() {
        return InvokeDynamicSupport.bootstrap("buildOrderedChildList", $$robo$$android_view_ViewGroup$buildOrderedChildList(), 0, this);
    }

    private void notifyAnimationListener() {
        InvokeDynamicSupport.bootstrap("notifyAnimationListener", $$robo$$android_view_ViewGroup$notifyAnimationListener(), 0, this);
    }

    @Override
    protected void dispatchGetDisplayList() {
        InvokeDynamicSupport.bootstrap("dispatchGetDisplayList", $$robo$$android_view_ViewGroup$dispatchGetDisplayList(), 0, this);
    }

    private void recreateChildDisplayList(View view) {
        InvokeDynamicSupport.bootstrap("recreateChildDisplayList", $$robo$$android_view_ViewGroup$recreateChildDisplayList(android.view.View ), 0, this, view);
    }

    protected boolean drawChild(Canvas canvas, View view, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("drawChild", $$robo$$android_view_ViewGroup$drawChild(android.graphics.Canvas android.view.View long ), 0, this, canvas, view, l);
    }

    @Override
    void getScrollIndicatorBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("getScrollIndicatorBounds", $$robo$$android_view_ViewGroup$getScrollIndicatorBounds(android.graphics.Rect ), 0, this, rect);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public boolean getClipChildren() {
        return (boolean)InvokeDynamicSupport.bootstrap("getClipChildren", $$robo$$android_view_ViewGroup$getClipChildren(), 0, this);
    }

    public void setClipChildren(boolean bl) {
        InvokeDynamicSupport.bootstrap("setClipChildren", $$robo$$android_view_ViewGroup$setClipChildren(boolean ), 0, this, bl);
    }

    public void setClipToPadding(boolean bl) {
        InvokeDynamicSupport.bootstrap("setClipToPadding", $$robo$$android_view_ViewGroup$setClipToPadding(boolean ), 0, this, bl);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public boolean getClipToPadding() {
        return (boolean)InvokeDynamicSupport.bootstrap("getClipToPadding", $$robo$$android_view_ViewGroup$getClipToPadding(), 0, this);
    }

    @Override
    public void dispatchSetSelected(boolean bl) {
        InvokeDynamicSupport.bootstrap("dispatchSetSelected", $$robo$$android_view_ViewGroup$dispatchSetSelected(boolean ), 0, this, bl);
    }

    @Override
    public void dispatchSetActivated(boolean bl) {
        InvokeDynamicSupport.bootstrap("dispatchSetActivated", $$robo$$android_view_ViewGroup$dispatchSetActivated(boolean ), 0, this, bl);
    }

    @Override
    protected void dispatchSetPressed(boolean bl) {
        InvokeDynamicSupport.bootstrap("dispatchSetPressed", $$robo$$android_view_ViewGroup$dispatchSetPressed(boolean ), 0, this, bl);
    }

    @Override
    public void dispatchDrawableHotspotChanged(float f, float f2) {
        InvokeDynamicSupport.bootstrap("dispatchDrawableHotspotChanged", $$robo$$android_view_ViewGroup$dispatchDrawableHotspotChanged(float float ), 0, this, f, f2);
    }

    @Override
    void dispatchCancelPendingInputEvents() {
        InvokeDynamicSupport.bootstrap("dispatchCancelPendingInputEvents", $$robo$$android_view_ViewGroup$dispatchCancelPendingInputEvents(), 0, this);
    }

    protected void setStaticTransformationsEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setStaticTransformationsEnabled", $$robo$$android_view_ViewGroup$setStaticTransformationsEnabled(boolean ), 0, this, bl);
    }

    protected boolean getChildStaticTransformation(View view, Transformation transformation) {
        return (boolean)InvokeDynamicSupport.bootstrap("getChildStaticTransformation", $$robo$$android_view_ViewGroup$getChildStaticTransformation(android.view.View android.view.animation.Transformation ), 0, this, view, transformation);
    }

    Transformation getChildTransformation() {
        return InvokeDynamicSupport.bootstrap("getChildTransformation", $$robo$$android_view_ViewGroup$getChildTransformation(), 0, this);
    }

    @Override
    protected <T extends View> T findViewTraversal(int n) {
        return (T)InvokeDynamicSupport.bootstrap("findViewTraversal", $$robo$$android_view_ViewGroup$findViewTraversal(int ), 0, this, n);
    }

    @Override
    protected <T extends View> T findViewWithTagTraversal(Object object) {
        return (T)InvokeDynamicSupport.bootstrap("findViewWithTagTraversal", $$robo$$android_view_ViewGroup$findViewWithTagTraversal(java.lang.Object ), 0, this, object);
    }

    @Override
    protected <T extends View> T findViewByPredicateTraversal(Predicate<View> predicate, View view) {
        return (T)InvokeDynamicSupport.bootstrap("findViewByPredicateTraversal", $$robo$$android_view_ViewGroup$findViewByPredicateTraversal(java.util.function.Predicate<android.view.View> android.view.View ), 0, this, predicate, view);
    }

    public void addTransientView(View view, int n) {
        InvokeDynamicSupport.bootstrap("addTransientView", $$robo$$android_view_ViewGroup$addTransientView(android.view.View int ), 0, this, view, n);
    }

    public void removeTransientView(View view) {
        InvokeDynamicSupport.bootstrap("removeTransientView", $$robo$$android_view_ViewGroup$removeTransientView(android.view.View ), 0, this, view);
    }

    public int getTransientViewCount() {
        return (int)InvokeDynamicSupport.bootstrap("getTransientViewCount", $$robo$$android_view_ViewGroup$getTransientViewCount(), 0, this);
    }

    public int getTransientViewIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getTransientViewIndex", $$robo$$android_view_ViewGroup$getTransientViewIndex(int ), 0, this, n);
    }

    public View getTransientView(int n) {
        return InvokeDynamicSupport.bootstrap("getTransientView", $$robo$$android_view_ViewGroup$getTransientView(int ), 0, this, n);
    }

    public void addView(View view) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_view_ViewGroup$addView(android.view.View ), 0, this, view);
    }

    public void addView(View view, int n) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_view_ViewGroup$addView(android.view.View int ), 0, this, view, n);
    }

    public void addView(View view, int n, int n2) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_view_ViewGroup$addView(android.view.View int int ), 0, this, view, n, n2);
    }

    @Override
    public void addView(View view, LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_view_ViewGroup$addView(android.view.View android.view.ViewGroup$LayoutParams ), 0, this, view, layoutParams);
    }

    public void addView(View view, int n, LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_view_ViewGroup$addView(android.view.View int android.view.ViewGroup$LayoutParams ), 0, this, view, n, layoutParams);
    }

    @Override
    public void updateViewLayout(View view, LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("updateViewLayout", $$robo$$android_view_ViewGroup$updateViewLayout(android.view.View android.view.ViewGroup$LayoutParams ), 0, this, view, layoutParams);
    }

    protected boolean checkLayoutParams(LayoutParams layoutParams) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkLayoutParams", $$robo$$android_view_ViewGroup$checkLayoutParams(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
    }

    public void setOnHierarchyChangeListener(OnHierarchyChangeListener onHierarchyChangeListener) {
        InvokeDynamicSupport.bootstrap("setOnHierarchyChangeListener", $$robo$$android_view_ViewGroup$setOnHierarchyChangeListener(android.view.ViewGroup$OnHierarchyChangeListener ), 0, this, onHierarchyChangeListener);
    }

    void dispatchViewAdded(View view) {
        InvokeDynamicSupport.bootstrap("dispatchViewAdded", $$robo$$android_view_ViewGroup$dispatchViewAdded(android.view.View ), 0, this, view);
    }

    public void onViewAdded(View view) {
        InvokeDynamicSupport.bootstrap("onViewAdded", $$robo$$android_view_ViewGroup$onViewAdded(android.view.View ), 0, this, view);
    }

    void dispatchViewRemoved(View view) {
        InvokeDynamicSupport.bootstrap("dispatchViewRemoved", $$robo$$android_view_ViewGroup$dispatchViewRemoved(android.view.View ), 0, this, view);
    }

    public void onViewRemoved(View view) {
        InvokeDynamicSupport.bootstrap("onViewRemoved", $$robo$$android_view_ViewGroup$onViewRemoved(android.view.View ), 0, this, view);
    }

    private void clearCachedLayoutMode() {
        InvokeDynamicSupport.bootstrap("clearCachedLayoutMode", $$robo$$android_view_ViewGroup$clearCachedLayoutMode(), 0, this);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_view_ViewGroup$onAttachedToWindow(), 0, this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_view_ViewGroup$onDetachedFromWindow(), 0, this);
    }

    @Override
    protected void destroyHardwareResources() {
        InvokeDynamicSupport.bootstrap("destroyHardwareResources", $$robo$$android_view_ViewGroup$destroyHardwareResources(), 0, this);
    }

    protected boolean addViewInLayout(View view, int n, LayoutParams layoutParams) {
        return (boolean)InvokeDynamicSupport.bootstrap("addViewInLayout", $$robo$$android_view_ViewGroup$addViewInLayout(android.view.View int android.view.ViewGroup$LayoutParams ), 0, this, view, n, layoutParams);
    }

    protected boolean addViewInLayout(View view, int n, LayoutParams layoutParams, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("addViewInLayout", $$robo$$android_view_ViewGroup$addViewInLayout(android.view.View int android.view.ViewGroup$LayoutParams boolean ), 0, this, view, n, layoutParams, bl);
    }

    protected void cleanupLayoutState(View view) {
        InvokeDynamicSupport.bootstrap("cleanupLayoutState", $$robo$$android_view_ViewGroup$cleanupLayoutState(android.view.View ), 0, this, view);
    }

    private void addViewInner(View view, int n, LayoutParams layoutParams, boolean bl) {
        InvokeDynamicSupport.bootstrap("addViewInner", $$robo$$android_view_ViewGroup$addViewInner(android.view.View int android.view.ViewGroup$LayoutParams boolean ), 0, this, view, n, layoutParams, bl);
    }

    private void touchAccessibilityNodeProviderIfNeeded(View view) {
        InvokeDynamicSupport.bootstrap("touchAccessibilityNodeProviderIfNeeded", $$robo$$android_view_ViewGroup$touchAccessibilityNodeProviderIfNeeded(android.view.View ), 0, this, view);
    }

    private void addInArray(View view, int n) {
        InvokeDynamicSupport.bootstrap("addInArray", $$robo$$android_view_ViewGroup$addInArray(android.view.View int ), 0, this, view, n);
    }

    private void removeFromArray(int n) {
        InvokeDynamicSupport.bootstrap("removeFromArray", $$robo$$android_view_ViewGroup$removeFromArray(int ), 0, this, n);
    }

    private void removeFromArray(int n, int n2) {
        InvokeDynamicSupport.bootstrap("removeFromArray", $$robo$$android_view_ViewGroup$removeFromArray(int int ), 0, this, n, n2);
    }

    private void bindLayoutAnimation(View view) {
        InvokeDynamicSupport.bootstrap("bindLayoutAnimation", $$robo$$android_view_ViewGroup$bindLayoutAnimation(android.view.View ), 0, this, view);
    }

    protected void attachLayoutAnimationParameters(View view, LayoutParams layoutParams, int n, int n2) {
        InvokeDynamicSupport.bootstrap("attachLayoutAnimationParameters", $$robo$$android_view_ViewGroup$attachLayoutAnimationParameters(android.view.View android.view.ViewGroup$LayoutParams int int ), 0, this, view, layoutParams, n, n2);
    }

    @Override
    public void removeView(View view) {
        InvokeDynamicSupport.bootstrap("removeView", $$robo$$android_view_ViewGroup$removeView(android.view.View ), 0, this, view);
    }

    public void removeViewInLayout(View view) {
        InvokeDynamicSupport.bootstrap("removeViewInLayout", $$robo$$android_view_ViewGroup$removeViewInLayout(android.view.View ), 0, this, view);
    }

    public void removeViewsInLayout(int n, int n2) {
        InvokeDynamicSupport.bootstrap("removeViewsInLayout", $$robo$$android_view_ViewGroup$removeViewsInLayout(int int ), 0, this, n, n2);
    }

    public void removeViewAt(int n) {
        InvokeDynamicSupport.bootstrap("removeViewAt", $$robo$$android_view_ViewGroup$removeViewAt(int ), 0, this, n);
    }

    public void removeViews(int n, int n2) {
        InvokeDynamicSupport.bootstrap("removeViews", $$robo$$android_view_ViewGroup$removeViews(int int ), 0, this, n, n2);
    }

    private boolean removeViewInternal(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeViewInternal", $$robo$$android_view_ViewGroup$removeViewInternal(android.view.View ), 0, this, view);
    }

    private void removeViewInternal(int n, View view) {
        InvokeDynamicSupport.bootstrap("removeViewInternal", $$robo$$android_view_ViewGroup$removeViewInternal(int android.view.View ), 0, this, n, view);
    }

    public void setLayoutTransition(LayoutTransition layoutTransition) {
        InvokeDynamicSupport.bootstrap("setLayoutTransition", $$robo$$android_view_ViewGroup$setLayoutTransition(android.animation.LayoutTransition ), 0, this, layoutTransition);
    }

    public LayoutTransition getLayoutTransition() {
        return InvokeDynamicSupport.bootstrap("getLayoutTransition", $$robo$$android_view_ViewGroup$getLayoutTransition(), 0, this);
    }

    private void removeViewsInternal(int n, int n2) {
        InvokeDynamicSupport.bootstrap("removeViewsInternal", $$robo$$android_view_ViewGroup$removeViewsInternal(int int ), 0, this, n, n2);
    }

    public void removeAllViews() {
        InvokeDynamicSupport.bootstrap("removeAllViews", $$robo$$android_view_ViewGroup$removeAllViews(), 0, this);
    }

    public void removeAllViewsInLayout() {
        InvokeDynamicSupport.bootstrap("removeAllViewsInLayout", $$robo$$android_view_ViewGroup$removeAllViewsInLayout(), 0, this);
    }

    protected void removeDetachedView(View view, boolean bl) {
        InvokeDynamicSupport.bootstrap("removeDetachedView", $$robo$$android_view_ViewGroup$removeDetachedView(android.view.View boolean ), 0, this, view, bl);
    }

    protected void attachViewToParent(View view, int n, LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("attachViewToParent", $$robo$$android_view_ViewGroup$attachViewToParent(android.view.View int android.view.ViewGroup$LayoutParams ), 0, this, view, n, layoutParams);
    }

    protected void detachViewFromParent(View view) {
        InvokeDynamicSupport.bootstrap("detachViewFromParent", $$robo$$android_view_ViewGroup$detachViewFromParent(android.view.View ), 0, this, view);
    }

    protected void detachViewFromParent(int n) {
        InvokeDynamicSupport.bootstrap("detachViewFromParent", $$robo$$android_view_ViewGroup$detachViewFromParent(int ), 0, this, n);
    }

    protected void detachViewsFromParent(int n, int n2) {
        InvokeDynamicSupport.bootstrap("detachViewsFromParent", $$robo$$android_view_ViewGroup$detachViewsFromParent(int int ), 0, this, n, n2);
    }

    protected void detachAllViewsFromParent() {
        InvokeDynamicSupport.bootstrap("detachAllViewsFromParent", $$robo$$android_view_ViewGroup$detachAllViewsFromParent(), 0, this);
    }

    @Override
    public void onDescendantInvalidated(View view, View view2) {
        InvokeDynamicSupport.bootstrap("onDescendantInvalidated", $$robo$$android_view_ViewGroup$onDescendantInvalidated(android.view.View android.view.View ), 0, this, view, view2);
    }

    @Override
    @Deprecated
    public void invalidateChild(View view, Rect rect) {
        InvokeDynamicSupport.bootstrap("invalidateChild", $$robo$$android_view_ViewGroup$invalidateChild(android.view.View android.graphics.Rect ), 0, this, view, rect);
    }

    @Override
    @Deprecated
    public ViewParent invalidateChildInParent(int[] nArray, Rect rect) {
        return InvokeDynamicSupport.bootstrap("invalidateChildInParent", $$robo$$android_view_ViewGroup$invalidateChildInParent(int[] android.graphics.Rect ), 0, this, nArray, rect);
    }

    public void offsetDescendantRectToMyCoords(View view, Rect rect) {
        InvokeDynamicSupport.bootstrap("offsetDescendantRectToMyCoords", $$robo$$android_view_ViewGroup$offsetDescendantRectToMyCoords(android.view.View android.graphics.Rect ), 0, this, view, rect);
    }

    public void offsetRectIntoDescendantCoords(View view, Rect rect) {
        InvokeDynamicSupport.bootstrap("offsetRectIntoDescendantCoords", $$robo$$android_view_ViewGroup$offsetRectIntoDescendantCoords(android.view.View android.graphics.Rect ), 0, this, view, rect);
    }

    void offsetRectBetweenParentAndChild(View view, Rect rect, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("offsetRectBetweenParentAndChild", $$robo$$android_view_ViewGroup$offsetRectBetweenParentAndChild(android.view.View android.graphics.Rect boolean boolean ), 0, this, view, rect, bl, bl2);
    }

    public void offsetChildrenTopAndBottom(int n) {
        InvokeDynamicSupport.bootstrap("offsetChildrenTopAndBottom", $$robo$$android_view_ViewGroup$offsetChildrenTopAndBottom(int ), 0, this, n);
    }

    @Override
    public boolean getChildVisibleRect(View view, Rect rect, Point point) {
        return (boolean)InvokeDynamicSupport.bootstrap("getChildVisibleRect", $$robo$$android_view_ViewGroup$getChildVisibleRect(android.view.View android.graphics.Rect android.graphics.Point ), 0, this, view, rect, point);
    }

    public boolean getChildVisibleRect(View view, Rect rect, Point point, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("getChildVisibleRect", $$robo$$android_view_ViewGroup$getChildVisibleRect(android.view.View android.graphics.Rect android.graphics.Point boolean ), 0, this, view, rect, point, bl);
    }

    @Override
    public void layout(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("layout", $$robo$$android_view_ViewGroup$layout(int int int int ), 0, this, n, n2, n3, n4);
    }

    protected boolean canAnimate() {
        return (boolean)InvokeDynamicSupport.bootstrap("canAnimate", $$robo$$android_view_ViewGroup$canAnimate(), 0, this);
    }

    public void startLayoutAnimation() {
        InvokeDynamicSupport.bootstrap("startLayoutAnimation", $$robo$$android_view_ViewGroup$startLayoutAnimation(), 0, this);
    }

    public void scheduleLayoutAnimation() {
        InvokeDynamicSupport.bootstrap("scheduleLayoutAnimation", $$robo$$android_view_ViewGroup$scheduleLayoutAnimation(), 0, this);
    }

    public void setLayoutAnimation(LayoutAnimationController layoutAnimationController) {
        InvokeDynamicSupport.bootstrap("setLayoutAnimation", $$robo$$android_view_ViewGroup$setLayoutAnimation(android.view.animation.LayoutAnimationController ), 0, this, layoutAnimationController);
    }

    public LayoutAnimationController getLayoutAnimation() {
        return InvokeDynamicSupport.bootstrap("getLayoutAnimation", $$robo$$android_view_ViewGroup$getLayoutAnimation(), 0, this);
    }

    @Deprecated
    public boolean isAnimationCacheEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAnimationCacheEnabled", $$robo$$android_view_ViewGroup$isAnimationCacheEnabled(), 0, this);
    }

    @Deprecated
    public void setAnimationCacheEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAnimationCacheEnabled", $$robo$$android_view_ViewGroup$setAnimationCacheEnabled(boolean ), 0, this, bl);
    }

    @Deprecated
    public boolean isAlwaysDrawnWithCacheEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAlwaysDrawnWithCacheEnabled", $$robo$$android_view_ViewGroup$isAlwaysDrawnWithCacheEnabled(), 0, this);
    }

    @Deprecated
    public void setAlwaysDrawnWithCacheEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAlwaysDrawnWithCacheEnabled", $$robo$$android_view_ViewGroup$setAlwaysDrawnWithCacheEnabled(boolean ), 0, this, bl);
    }

    @Deprecated
    protected boolean isChildrenDrawnWithCacheEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isChildrenDrawnWithCacheEnabled", $$robo$$android_view_ViewGroup$isChildrenDrawnWithCacheEnabled(), 0, this);
    }

    @Deprecated
    protected void setChildrenDrawnWithCacheEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setChildrenDrawnWithCacheEnabled", $$robo$$android_view_ViewGroup$setChildrenDrawnWithCacheEnabled(boolean ), 0, this, bl);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    protected boolean isChildrenDrawingOrderEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isChildrenDrawingOrderEnabled", $$robo$$android_view_ViewGroup$isChildrenDrawingOrderEnabled(), 0, this);
    }

    protected void setChildrenDrawingOrderEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setChildrenDrawingOrderEnabled", $$robo$$android_view_ViewGroup$setChildrenDrawingOrderEnabled(boolean ), 0, this, bl);
    }

    private boolean hasBooleanFlag(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasBooleanFlag", $$robo$$android_view_ViewGroup$hasBooleanFlag(int ), 0, this, n);
    }

    private void setBooleanFlag(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setBooleanFlag", $$robo$$android_view_ViewGroup$setBooleanFlag(int boolean ), 0, this, n, bl);
    }

    @Deprecated
    @ViewDebug.ExportedProperty(category="drawing", mapping={@ViewDebug.IntToString(from=0, to="NONE"), @ViewDebug.IntToString(from=1, to="ANIMATION"), @ViewDebug.IntToString(from=2, to="SCROLLING"), @ViewDebug.IntToString(from=3, to="ALL")})
    public int getPersistentDrawingCache() {
        return (int)InvokeDynamicSupport.bootstrap("getPersistentDrawingCache", $$robo$$android_view_ViewGroup$getPersistentDrawingCache(), 0, this);
    }

    @Deprecated
    public void setPersistentDrawingCache(int n) {
        InvokeDynamicSupport.bootstrap("setPersistentDrawingCache", $$robo$$android_view_ViewGroup$setPersistentDrawingCache(int ), 0, this, n);
    }

    private void setLayoutMode(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setLayoutMode", $$robo$$android_view_ViewGroup$setLayoutMode(int boolean ), 0, this, n, bl);
    }

    @Override
    void invalidateInheritedLayoutMode(int n) {
        InvokeDynamicSupport.bootstrap("invalidateInheritedLayoutMode", $$robo$$android_view_ViewGroup$invalidateInheritedLayoutMode(int ), 0, this, n);
    }

    public int getLayoutMode() {
        return (int)InvokeDynamicSupport.bootstrap("getLayoutMode", $$robo$$android_view_ViewGroup$getLayoutMode(), 0, this);
    }

    public void setLayoutMode(int n) {
        InvokeDynamicSupport.bootstrap("setLayoutMode", $$robo$$android_view_ViewGroup$setLayoutMode(int ), 0, this, n);
    }

    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$android_view_ViewGroup$generateLayoutParams(android.util.AttributeSet ), 0, this, attributeSet);
    }

    protected LayoutParams generateLayoutParams(LayoutParams layoutParams) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$android_view_ViewGroup$generateLayoutParams(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return InvokeDynamicSupport.bootstrap("generateDefaultLayoutParams", $$robo$$android_view_ViewGroup$generateDefaultLayoutParams(), 0, this);
    }

    @Override
    protected void debug(int n) {
        InvokeDynamicSupport.bootstrap("debug", $$robo$$android_view_ViewGroup$debug(int ), 0, this, n);
    }

    public int indexOfChild(View view) {
        return (int)InvokeDynamicSupport.bootstrap("indexOfChild", $$robo$$android_view_ViewGroup$indexOfChild(android.view.View ), 0, this, view);
    }

    public int getChildCount() {
        return (int)InvokeDynamicSupport.bootstrap("getChildCount", $$robo$$android_view_ViewGroup$getChildCount(), 0, this);
    }

    public View getChildAt(int n) {
        return InvokeDynamicSupport.bootstrap("getChildAt", $$robo$$android_view_ViewGroup$getChildAt(int ), 0, this, n);
    }

    protected void measureChildren(int n, int n2) {
        InvokeDynamicSupport.bootstrap("measureChildren", $$robo$$android_view_ViewGroup$measureChildren(int int ), 0, this, n, n2);
    }

    protected void measureChild(View view, int n, int n2) {
        InvokeDynamicSupport.bootstrap("measureChild", $$robo$$android_view_ViewGroup$measureChild(android.view.View int int ), 0, this, view, n, n2);
    }

    protected void measureChildWithMargins(View view, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("measureChildWithMargins", $$robo$$android_view_ViewGroup$measureChildWithMargins(android.view.View int int int int ), 0, this, view, n, n2, n3, n4);
    }

    public static int getChildMeasureSpec(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getChildMeasureSpec", $$robo$$android_view_ViewGroup$getChildMeasureSpec(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    public void clearDisappearingChildren() {
        InvokeDynamicSupport.bootstrap("clearDisappearingChildren", $$robo$$android_view_ViewGroup$clearDisappearingChildren(), 0, this);
    }

    private void addDisappearingView(View view) {
        InvokeDynamicSupport.bootstrap("addDisappearingView", $$robo$$android_view_ViewGroup$addDisappearingView(android.view.View ), 0, this, view);
    }

    void finishAnimatingView(View view, Animation animation) {
        InvokeDynamicSupport.bootstrap("finishAnimatingView", $$robo$$android_view_ViewGroup$finishAnimatingView(android.view.View android.view.animation.Animation ), 0, this, view, animation);
    }

    boolean isViewTransitioning(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("isViewTransitioning", $$robo$$android_view_ViewGroup$isViewTransitioning(android.view.View ), 0, this, view);
    }

    public void startViewTransition(View view) {
        InvokeDynamicSupport.bootstrap("startViewTransition", $$robo$$android_view_ViewGroup$startViewTransition(android.view.View ), 0, this, view);
    }

    public void endViewTransition(View view) {
        InvokeDynamicSupport.bootstrap("endViewTransition", $$robo$$android_view_ViewGroup$endViewTransition(android.view.View ), 0, this, view);
    }

    public void suppressLayout(boolean bl) {
        InvokeDynamicSupport.bootstrap("suppressLayout", $$robo$$android_view_ViewGroup$suppressLayout(boolean ), 0, this, bl);
    }

    public boolean isLayoutSuppressed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLayoutSuppressed", $$robo$$android_view_ViewGroup$isLayoutSuppressed(), 0, this);
    }

    @Override
    public boolean gatherTransparentRegion(Region region) {
        return (boolean)InvokeDynamicSupport.bootstrap("gatherTransparentRegion", $$robo$$android_view_ViewGroup$gatherTransparentRegion(android.graphics.Region ), 0, this, region);
    }

    @Override
    public void requestTransparentRegion(View view) {
        InvokeDynamicSupport.bootstrap("requestTransparentRegion", $$robo$$android_view_ViewGroup$requestTransparentRegion(android.view.View ), 0, this, view);
    }

    @Override
    public WindowInsets dispatchApplyWindowInsets(WindowInsets windowInsets) {
        return InvokeDynamicSupport.bootstrap("dispatchApplyWindowInsets", $$robo$$android_view_ViewGroup$dispatchApplyWindowInsets(android.view.WindowInsets ), 0, this, windowInsets);
    }

    public Animation.AnimationListener getLayoutAnimationListener() {
        return InvokeDynamicSupport.bootstrap("getLayoutAnimationListener", $$robo$$android_view_ViewGroup$getLayoutAnimationListener(), 0, this);
    }

    @Override
    protected void drawableStateChanged() {
        InvokeDynamicSupport.bootstrap("drawableStateChanged", $$robo$$android_view_ViewGroup$drawableStateChanged(), 0, this);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpDrawablesToCurrentState", $$robo$$android_view_ViewGroup$jumpDrawablesToCurrentState(), 0, this);
    }

    @Override
    protected int[] onCreateDrawableState(int n) {
        return InvokeDynamicSupport.bootstrap("onCreateDrawableState", $$robo$$android_view_ViewGroup$onCreateDrawableState(int ), 0, this, n);
    }

    public void setAddStatesFromChildren(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAddStatesFromChildren", $$robo$$android_view_ViewGroup$setAddStatesFromChildren(boolean ), 0, this, bl);
    }

    public boolean addStatesFromChildren() {
        return (boolean)InvokeDynamicSupport.bootstrap("addStatesFromChildren", $$robo$$android_view_ViewGroup$addStatesFromChildren(), 0, this);
    }

    @Override
    public void childDrawableStateChanged(View view) {
        InvokeDynamicSupport.bootstrap("childDrawableStateChanged", $$robo$$android_view_ViewGroup$childDrawableStateChanged(android.view.View ), 0, this, view);
    }

    public void setLayoutAnimationListener(Animation.AnimationListener animationListener) {
        InvokeDynamicSupport.bootstrap("setLayoutAnimationListener", $$robo$$android_view_ViewGroup$setLayoutAnimationListener(android.view.animation.Animation$AnimationListener ), 0, this, animationListener);
    }

    public void requestTransitionStart(LayoutTransition layoutTransition) {
        InvokeDynamicSupport.bootstrap("requestTransitionStart", $$robo$$android_view_ViewGroup$requestTransitionStart(android.animation.LayoutTransition ), 0, this, layoutTransition);
    }

    @Override
    public boolean resolveRtlPropertiesIfNeeded() {
        return (boolean)InvokeDynamicSupport.bootstrap("resolveRtlPropertiesIfNeeded", $$robo$$android_view_ViewGroup$resolveRtlPropertiesIfNeeded(), 0, this);
    }

    @Override
    public boolean resolveLayoutDirection() {
        return (boolean)InvokeDynamicSupport.bootstrap("resolveLayoutDirection", $$robo$$android_view_ViewGroup$resolveLayoutDirection(), 0, this);
    }

    @Override
    public boolean resolveTextDirection() {
        return (boolean)InvokeDynamicSupport.bootstrap("resolveTextDirection", $$robo$$android_view_ViewGroup$resolveTextDirection(), 0, this);
    }

    @Override
    public boolean resolveTextAlignment() {
        return (boolean)InvokeDynamicSupport.bootstrap("resolveTextAlignment", $$robo$$android_view_ViewGroup$resolveTextAlignment(), 0, this);
    }

    @Override
    public void resolvePadding() {
        InvokeDynamicSupport.bootstrap("resolvePadding", $$robo$$android_view_ViewGroup$resolvePadding(), 0, this);
    }

    @Override
    protected void resolveDrawables() {
        InvokeDynamicSupport.bootstrap("resolveDrawables", $$robo$$android_view_ViewGroup$resolveDrawables(), 0, this);
    }

    @Override
    public void resolveLayoutParams() {
        InvokeDynamicSupport.bootstrap("resolveLayoutParams", $$robo$$android_view_ViewGroup$resolveLayoutParams(), 0, this);
    }

    @Override
    public void resetResolvedLayoutDirection() {
        InvokeDynamicSupport.bootstrap("resetResolvedLayoutDirection", $$robo$$android_view_ViewGroup$resetResolvedLayoutDirection(), 0, this);
    }

    @Override
    public void resetResolvedTextDirection() {
        InvokeDynamicSupport.bootstrap("resetResolvedTextDirection", $$robo$$android_view_ViewGroup$resetResolvedTextDirection(), 0, this);
    }

    @Override
    public void resetResolvedTextAlignment() {
        InvokeDynamicSupport.bootstrap("resetResolvedTextAlignment", $$robo$$android_view_ViewGroup$resetResolvedTextAlignment(), 0, this);
    }

    @Override
    public void resetResolvedPadding() {
        InvokeDynamicSupport.bootstrap("resetResolvedPadding", $$robo$$android_view_ViewGroup$resetResolvedPadding(), 0, this);
    }

    @Override
    protected void resetResolvedDrawables() {
        InvokeDynamicSupport.bootstrap("resetResolvedDrawables", $$robo$$android_view_ViewGroup$resetResolvedDrawables(), 0, this);
    }

    public boolean shouldDelayChildPressedState() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldDelayChildPressedState", $$robo$$android_view_ViewGroup$shouldDelayChildPressedState(), 0, this);
    }

    @Override
    public boolean onStartNestedScroll(View view, View view2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStartNestedScroll", $$robo$$android_view_ViewGroup$onStartNestedScroll(android.view.View android.view.View int ), 0, this, view, view2, n);
    }

    @Override
    public void onNestedScrollAccepted(View view, View view2, int n) {
        InvokeDynamicSupport.bootstrap("onNestedScrollAccepted", $$robo$$android_view_ViewGroup$onNestedScrollAccepted(android.view.View android.view.View int ), 0, this, view, view2, n);
    }

    @Override
    public void onStopNestedScroll(View view) {
        InvokeDynamicSupport.bootstrap("onStopNestedScroll", $$robo$$android_view_ViewGroup$onStopNestedScroll(android.view.View ), 0, this, view);
    }

    @Override
    public void onNestedScroll(View view, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onNestedScroll", $$robo$$android_view_ViewGroup$onNestedScroll(android.view.View int int int int ), 0, this, view, n, n2, n3, n4);
    }

    @Override
    public void onNestedPreScroll(View view, int n, int n2, int[] nArray) {
        InvokeDynamicSupport.bootstrap("onNestedPreScroll", $$robo$$android_view_ViewGroup$onNestedPreScroll(android.view.View int int int[] ), 0, this, view, n, n2, nArray);
    }

    @Override
    public boolean onNestedFling(View view, float f, float f2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("onNestedFling", $$robo$$android_view_ViewGroup$onNestedFling(android.view.View float float boolean ), 0, this, view, f, f2, bl);
    }

    @Override
    public boolean onNestedPreFling(View view, float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onNestedPreFling", $$robo$$android_view_ViewGroup$onNestedPreFling(android.view.View float float ), 0, this, view, f, f2);
    }

    public int getNestedScrollAxes() {
        return (int)InvokeDynamicSupport.bootstrap("getNestedScrollAxes", $$robo$$android_view_ViewGroup$getNestedScrollAxes(), 0, this);
    }

    protected void onSetLayoutParams(View view, LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("onSetLayoutParams", $$robo$$android_view_ViewGroup$onSetLayoutParams(android.view.View android.view.ViewGroup$LayoutParams ), 0, this, view, layoutParams);
    }

    @Override
    public void captureTransitioningViews(List<View> list) {
        InvokeDynamicSupport.bootstrap("captureTransitioningViews", $$robo$$android_view_ViewGroup$captureTransitioningViews(java.util.List<android.view.View> ), 0, this, list);
    }

    @Override
    public void findNamedViews(Map<String, View> map) {
        InvokeDynamicSupport.bootstrap("findNamedViews", $$robo$$android_view_ViewGroup$findNamedViews(java.util.Map<java.lang.String, android.view.View> ), 0, this, map);
    }

    @Override
    boolean hasUnhandledKeyListener() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasUnhandledKeyListener", $$robo$$android_view_ViewGroup$hasUnhandledKeyListener(), 0, this);
    }

    void incrementChildUnhandledKeyListeners() {
        InvokeDynamicSupport.bootstrap("incrementChildUnhandledKeyListeners", $$robo$$android_view_ViewGroup$incrementChildUnhandledKeyListeners(), 0, this);
    }

    void decrementChildUnhandledKeyListeners() {
        InvokeDynamicSupport.bootstrap("decrementChildUnhandledKeyListeners", $$robo$$android_view_ViewGroup$decrementChildUnhandledKeyListeners(), 0, this);
    }

    @Override
    View dispatchUnhandledKeyEvent(KeyEvent keyEvent) {
        return InvokeDynamicSupport.bootstrap("dispatchUnhandledKeyEvent", $$robo$$android_view_ViewGroup$dispatchUnhandledKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    private static void drawRect(Canvas canvas, Paint paint, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrapStatic("drawRect", $$robo$$android_view_ViewGroup$drawRect(android.graphics.Canvas android.graphics.Paint int int int int ), 0, (Canvas)canvas, (Paint)paint, (int)n, (int)n2, (int)n3, (int)n4);
    }

    @Override
    protected void encodeProperties(ViewHierarchyEncoder viewHierarchyEncoder) {
        InvokeDynamicSupport.bootstrap("encodeProperties", $$robo$$android_view_ViewGroup$encodeProperties(android.view.ViewHierarchyEncoder ), 0, this, viewHierarchyEncoder);
    }

    static {
        RobolectricInternals.classInitializing(ViewGroup.class);
    }

    public /* synthetic */ ViewGroup() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewGroup)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ViewLocationHolder
    implements Comparable<ViewLocationHolder> {
        public transient /* synthetic */ Object __robo_data__;
        private static int MAX_POOL_SIZE = 32;
        private static Pools.SynchronizedPool<ViewLocationHolder> sPool;
        public static int COMPARISON_STRATEGY_STRIPE = 1;
        public static int COMPARISON_STRATEGY_LOCATION = 2;
        private static int sComparisonStrategy;
        private Rect mLocation;
        private ViewGroup mRoot;
        public View mView;
        private int mLayoutDirection;

        private void $$robo$$android_view_ViewGroup_ViewLocationHolder$__constructor__() {
            this.mLocation = new Rect();
        }

        private static final ViewLocationHolder $$robo$$android_view_ViewGroup_ViewLocationHolder$obtain(ViewGroup root, View view) {
            ViewLocationHolder holder = sPool.acquire();
            if (holder == null) {
                holder = new ViewLocationHolder();
            }
            holder.init(root, view);
            return holder;
        }

        private static final void $$robo$$android_view_ViewGroup_ViewLocationHolder$setComparisonStrategy(int strategy) {
            sComparisonStrategy = strategy;
        }

        private final void $$robo$$android_view_ViewGroup_ViewLocationHolder$recycle() {
            this.clear();
            sPool.release(this);
        }

        private final int $$robo$$android_view_ViewGroup_ViewLocationHolder$compareTo(ViewLocationHolder another) {
            if (another == null) {
                return 1;
            }
            int boundsResult = ViewLocationHolder.compareBoundsOfTree(this, another);
            if (boundsResult != 0) {
                return boundsResult;
            }
            return this.mView.getAccessibilityViewId() - another.mView.getAccessibilityViewId();
        }

        private static final int $$robo$$android_view_ViewGroup_ViewLocationHolder$compareBoundsOfTree(ViewLocationHolder holder1, ViewLocationHolder holder2) {
            int topDifference;
            if (sComparisonStrategy == 1) {
                if (holder1.mLocation.bottom - holder2.mLocation.top <= 0) {
                    return -1;
                }
                if (holder1.mLocation.top - holder2.mLocation.bottom >= 0) {
                    return 1;
                }
            }
            if (holder1.mLayoutDirection == 0) {
                int leftDifference = holder1.mLocation.left - holder2.mLocation.left;
                if (leftDifference != 0) {
                    return leftDifference;
                }
            } else {
                int rightDifference = holder1.mLocation.right - holder2.mLocation.right;
                if (rightDifference != 0) {
                    return -rightDifference;
                }
            }
            if ((topDifference = holder1.mLocation.top - holder2.mLocation.top) != 0) {
                return topDifference;
            }
            int heightDiference = holder1.mLocation.height() - holder2.mLocation.height();
            if (heightDiference != 0) {
                return -heightDiference;
            }
            int widthDifference = holder1.mLocation.width() - holder2.mLocation.width();
            if (widthDifference != 0) {
                return -widthDifference;
            }
            Rect view1Bounds = new Rect();
            Rect view2Bounds = new Rect();
            Rect tempRect = new Rect();
            holder1.mView.getBoundsOnScreen(view1Bounds, true);
            holder2.mView.getBoundsOnScreen(view2Bounds, true);
            Object child1 = holder1.mView.findViewByPredicateTraversal(view -> {
                view.getBoundsOnScreen(tempRect, true);
                return !tempRect.equals(view1Bounds);
            }, null);
            Object child2 = holder2.mView.findViewByPredicateTraversal(view -> {
                view.getBoundsOnScreen(tempRect, true);
                return !tempRect.equals(view2Bounds);
            }, null);
            if (child1 != null && child2 != null) {
                ViewLocationHolder childHolder1 = ViewLocationHolder.obtain(holder1.mRoot, child1);
                ViewLocationHolder childHolder2 = ViewLocationHolder.obtain(holder1.mRoot, child2);
                return ViewLocationHolder.compareBoundsOfTree(childHolder1, childHolder2);
            }
            if (child1 != null) {
                return 1;
            }
            if (child2 != null) {
                return -1;
            }
            return 0;
        }

        private final void $$robo$$android_view_ViewGroup_ViewLocationHolder$init(ViewGroup root, View view) {
            Rect viewLocation = this.mLocation;
            view.getDrawingRect(viewLocation);
            root.offsetDescendantRectToMyCoords(view, viewLocation);
            this.mView = view;
            this.mRoot = root;
            this.mLayoutDirection = root.getLayoutDirection();
        }

        private final void $$robo$$android_view_ViewGroup_ViewLocationHolder$clear() {
            this.mView = null;
            this.mLocation.set(0, 0, 0, 0);
        }

        static void __staticInitializer__() {
            sPool = new Pools.SynchronizedPool(32);
            sComparisonStrategy = 1;
        }

        private void __constructor__() {
            this.$$robo$$android_view_ViewGroup_ViewLocationHolder$__constructor__();
        }

        ViewLocationHolder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewGroup_ViewLocationHolder$__constructor__(), 0, this);
        }

        public static ViewLocationHolder obtain(ViewGroup viewGroup, View view) {
            return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_ViewGroup_ViewLocationHolder$obtain(android.view.ViewGroup android.view.View ), 0, (ViewGroup)viewGroup, (View)view);
        }

        public static void setComparisonStrategy(int n) {
            InvokeDynamicSupport.bootstrapStatic("setComparisonStrategy", $$robo$$android_view_ViewGroup_ViewLocationHolder$setComparisonStrategy(int ), 0, (int)n);
        }

        public void recycle() {
            InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_view_ViewGroup_ViewLocationHolder$recycle(), 0, this);
        }

        @Override
        public int compareTo(ViewLocationHolder viewLocationHolder) {
            return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_view_ViewGroup_ViewLocationHolder$compareTo(android.view.ViewGroup$ViewLocationHolder ), 0, this, viewLocationHolder);
        }

        private static int compareBoundsOfTree(ViewLocationHolder viewLocationHolder, ViewLocationHolder viewLocationHolder2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("compareBoundsOfTree", $$robo$$android_view_ViewGroup_ViewLocationHolder$compareBoundsOfTree(android.view.ViewGroup$ViewLocationHolder android.view.ViewGroup$ViewLocationHolder ), 0, (ViewLocationHolder)viewLocationHolder, (ViewLocationHolder)viewLocationHolder2);
        }

        private void init(ViewGroup viewGroup, View view) {
            InvokeDynamicSupport.bootstrap("init", $$robo$$android_view_ViewGroup_ViewLocationHolder$init(android.view.ViewGroup android.view.View ), 0, this, viewGroup, view);
        }

        private void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$android_view_ViewGroup_ViewLocationHolder$clear(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(ViewLocationHolder.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewLocationHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ChildListForAccessibility
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MAX_POOL_SIZE = 32;
        private static Pools.SynchronizedPool<ChildListForAccessibility> sPool;
        private ArrayList<View> mChildren;
        private ArrayList<ViewLocationHolder> mHolders;

        private void $$robo$$android_view_ViewGroup_ChildListForAccessibility$__constructor__() {
            this.mChildren = new ArrayList();
            this.mHolders = new ArrayList();
        }

        private static final ChildListForAccessibility $$robo$$android_view_ViewGroup_ChildListForAccessibility$obtain(ViewGroup parent, boolean sort) {
            ChildListForAccessibility list = sPool.acquire();
            if (list == null) {
                list = new ChildListForAccessibility();
            }
            list.init(parent, sort);
            return list;
        }

        private final void $$robo$$android_view_ViewGroup_ChildListForAccessibility$recycle() {
            this.clear();
            sPool.release(this);
        }

        private final int $$robo$$android_view_ViewGroup_ChildListForAccessibility$getChildCount() {
            return this.mChildren.size();
        }

        private final View $$robo$$android_view_ViewGroup_ChildListForAccessibility$getChildAt(int index) {
            return this.mChildren.get(index);
        }

        private final void $$robo$$android_view_ViewGroup_ChildListForAccessibility$init(ViewGroup parent, boolean sort) {
            ArrayList<View> children = this.mChildren;
            int childCount = parent.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = parent.getChildAt(i);
                children.add(child);
            }
            if (sort) {
                int i;
                ArrayList<ViewLocationHolder> holders = this.mHolders;
                for (i = 0; i < childCount; ++i) {
                    View child = children.get(i);
                    ViewLocationHolder holder = ViewLocationHolder.obtain(parent, child);
                    holders.add(holder);
                }
                this.sort(holders);
                for (i = 0; i < childCount; ++i) {
                    ViewLocationHolder holder = holders.get(i);
                    children.set(i, holder.mView);
                    holder.recycle();
                }
                holders.clear();
            }
        }

        private final void $$robo$$android_view_ViewGroup_ChildListForAccessibility$sort(ArrayList<ViewLocationHolder> holders) {
            try {
                ViewLocationHolder.setComparisonStrategy(1);
                Collections.sort(holders);
            }
            catch (IllegalArgumentException iae) {
                ViewLocationHolder.setComparisonStrategy(2);
                Collections.sort(holders);
            }
        }

        private final void $$robo$$android_view_ViewGroup_ChildListForAccessibility$clear() {
            this.mChildren.clear();
        }

        static void __staticInitializer__() {
            sPool = new Pools.SynchronizedPool(32);
        }

        private void __constructor__() {
            this.$$robo$$android_view_ViewGroup_ChildListForAccessibility$__constructor__();
        }

        ChildListForAccessibility() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewGroup_ChildListForAccessibility$__constructor__(), 0, this);
        }

        public static ChildListForAccessibility obtain(ViewGroup viewGroup, boolean bl) {
            return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_ViewGroup_ChildListForAccessibility$obtain(android.view.ViewGroup boolean ), 0, (ViewGroup)viewGroup, (boolean)bl);
        }

        public void recycle() {
            InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_view_ViewGroup_ChildListForAccessibility$recycle(), 0, this);
        }

        public int getChildCount() {
            return (int)InvokeDynamicSupport.bootstrap("getChildCount", $$robo$$android_view_ViewGroup_ChildListForAccessibility$getChildCount(), 0, this);
        }

        public View getChildAt(int n) {
            return InvokeDynamicSupport.bootstrap("getChildAt", $$robo$$android_view_ViewGroup_ChildListForAccessibility$getChildAt(int ), 0, this, n);
        }

        private void init(ViewGroup viewGroup, boolean bl) {
            InvokeDynamicSupport.bootstrap("init", $$robo$$android_view_ViewGroup_ChildListForAccessibility$init(android.view.ViewGroup boolean ), 0, this, viewGroup, bl);
        }

        private void sort(ArrayList<ViewLocationHolder> arrayList) {
            InvokeDynamicSupport.bootstrap("sort", $$robo$$android_view_ViewGroup_ChildListForAccessibility$sort(java.util.ArrayList<android.view.ViewGroup$ViewLocationHolder> ), 0, this, arrayList);
        }

        private void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$android_view_ViewGroup_ChildListForAccessibility$clear(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(ChildListForAccessibility.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChildListForAccessibility)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ChildListForAutoFill
    extends ArrayList<View> {
        public transient /* synthetic */ Object __robo_data__;
        private static int MAX_POOL_SIZE = 32;
        private static Pools.SimplePool<ChildListForAutoFill> sPool;

        private void $$robo$$android_view_ViewGroup_ChildListForAutoFill$__constructor__() {
        }

        private static final ChildListForAutoFill $$robo$$android_view_ViewGroup_ChildListForAutoFill$obtain() {
            ChildListForAutoFill list = sPool.acquire();
            if (list == null) {
                list = new ChildListForAutoFill();
            }
            return list;
        }

        private final void $$robo$$android_view_ViewGroup_ChildListForAutoFill$recycle() {
            this.clear();
            sPool.release(this);
        }

        static void __staticInitializer__() {
            sPool = new Pools.SimplePool(32);
        }

        private void __constructor__() {
            this.$$robo$$android_view_ViewGroup_ChildListForAutoFill$__constructor__();
        }

        ChildListForAutoFill() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewGroup_ChildListForAutoFill$__constructor__(), 0, this);
        }

        public static ChildListForAutoFill obtain() {
            return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_ViewGroup_ChildListForAutoFill$obtain(), 0);
        }

        public void recycle() {
            InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_view_ViewGroup_ChildListForAutoFill$recycle(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(ChildListForAutoFill.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChildListForAutoFill)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class HoverTarget
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MAX_RECYCLED = 32;
        private static Object sRecycleLock;
        private static HoverTarget sRecycleBin;
        private static int sRecycledCount;
        public View child;
        public HoverTarget next;

        private void $$robo$$android_view_ViewGroup_HoverTarget$__constructor__() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final HoverTarget $$robo$$android_view_ViewGroup_HoverTarget$obtain(View child) {
            HoverTarget target;
            if (child == null) {
                throw new IllegalArgumentException("child must be non-null");
            }
            Object object = sRecycleLock;
            synchronized (object) {
                if (sRecycleBin == null) {
                    target = new HoverTarget();
                } else {
                    target = sRecycleBin;
                    sRecycleBin = target.next;
                    --sRecycledCount;
                    target.next = null;
                }
            }
            target.child = child;
            return target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_view_ViewGroup_HoverTarget$recycle() {
            if (this.child == null) {
                throw new IllegalStateException("already recycled once");
            }
            Object object = sRecycleLock;
            synchronized (object) {
                if (sRecycledCount < 32) {
                    this.next = sRecycleBin;
                    sRecycleBin = this;
                    ++sRecycledCount;
                } else {
                    this.next = null;
                }
                this.child = null;
            }
        }

        static void __staticInitializer__() {
            sRecycleLock = new Object[0];
        }

        private void __constructor__() {
            this.$$robo$$android_view_ViewGroup_HoverTarget$__constructor__();
        }

        private HoverTarget() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewGroup_HoverTarget$__constructor__(), 0, this);
        }

        public static HoverTarget obtain(View view) {
            return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_ViewGroup_HoverTarget$obtain(android.view.View ), 0, (View)view);
        }

        public void recycle() {
            InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_view_ViewGroup_HoverTarget$recycle(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(HoverTarget.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HoverTarget)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class TouchTarget
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MAX_RECYCLED = 32;
        private static Object sRecycleLock;
        private static TouchTarget sRecycleBin;
        private static int sRecycledCount;
        public static int ALL_POINTER_IDS = -1;
        public View child;
        public int pointerIdBits;
        public TouchTarget next;

        private void $$robo$$android_view_ViewGroup_TouchTarget$__constructor__() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final TouchTarget $$robo$$android_view_ViewGroup_TouchTarget$obtain(View child, int pointerIdBits) {
            TouchTarget target;
            if (child == null) {
                throw new IllegalArgumentException("child must be non-null");
            }
            Object object = sRecycleLock;
            synchronized (object) {
                if (sRecycleBin == null) {
                    target = new TouchTarget();
                } else {
                    target = sRecycleBin;
                    sRecycleBin = target.next;
                    --sRecycledCount;
                    target.next = null;
                }
            }
            target.child = child;
            target.pointerIdBits = pointerIdBits;
            return target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_view_ViewGroup_TouchTarget$recycle() {
            if (this.child == null) {
                throw new IllegalStateException("already recycled once");
            }
            Object object = sRecycleLock;
            synchronized (object) {
                if (sRecycledCount < 32) {
                    this.next = sRecycleBin;
                    sRecycleBin = this;
                    ++sRecycledCount;
                } else {
                    this.next = null;
                }
                this.child = null;
            }
        }

        static void __staticInitializer__() {
            sRecycleLock = new Object[0];
        }

        private void __constructor__() {
            this.$$robo$$android_view_ViewGroup_TouchTarget$__constructor__();
        }

        private TouchTarget() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewGroup_TouchTarget$__constructor__(), 0, this);
        }

        public static TouchTarget obtain(View view, int n) {
            return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_ViewGroup_TouchTarget$obtain(android.view.View int ), 0, (View)view, (int)n);
        }

        public void recycle() {
            InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_view_ViewGroup_TouchTarget$recycle(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(TouchTarget.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TouchTarget)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MarginLayoutParams
    extends LayoutParams
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        @ViewDebug.ExportedProperty(category="layout")
        public int leftMargin;
        @ViewDebug.ExportedProperty(category="layout")
        public int topMargin;
        @ViewDebug.ExportedProperty(category="layout")
        public int rightMargin;
        @ViewDebug.ExportedProperty(category="layout")
        public int bottomMargin;
        @ViewDebug.ExportedProperty(category="layout")
        private int startMargin;
        @ViewDebug.ExportedProperty(category="layout")
        private int endMargin;
        public static int DEFAULT_MARGIN_RELATIVE = Integer.MIN_VALUE;
        @ViewDebug.ExportedProperty(category="layout", flagMapping={@ViewDebug.FlagToString(mask=3, equals=3, name="LAYOUT_DIRECTION"), @ViewDebug.FlagToString(mask=4, equals=4, name="LEFT_MARGIN_UNDEFINED_MASK"), @ViewDebug.FlagToString(mask=8, equals=8, name="RIGHT_MARGIN_UNDEFINED_MASK"), @ViewDebug.FlagToString(mask=16, equals=16, name="RTL_COMPATIBILITY_MODE_MASK"), @ViewDebug.FlagToString(mask=32, equals=32, name="NEED_RESOLUTION_MASK")}, formatToHexString=true)
        byte mMarginFlags;
        private static int LAYOUT_DIRECTION_MASK = 3;
        private static int LEFT_MARGIN_UNDEFINED_MASK = 4;
        private static int RIGHT_MARGIN_UNDEFINED_MASK = 8;
        private static int RTL_COMPATIBILITY_MODE_MASK = 16;
        private static int NEED_RESOLUTION_MASK = 32;
        private static int DEFAULT_MARGIN_RESOLVED = 0;
        private static int UNDEFINED_MARGIN = Integer.MIN_VALUE;

        private void $$robo$$android_view_ViewGroup_MarginLayoutParams$__constructor__(Context c, AttributeSet attrs) {
            this.startMargin = Integer.MIN_VALUE;
            this.endMargin = Integer.MIN_VALUE;
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.ViewGroup_MarginLayout);
            this.setBaseAttributes(a, 0, 1);
            int margin = a.getDimensionPixelSize(2, -1);
            if (margin >= 0) {
                this.leftMargin = margin;
                this.topMargin = margin;
                this.rightMargin = margin;
                this.bottomMargin = margin;
            } else {
                int horizontalMargin = a.getDimensionPixelSize(9, -1);
                int verticalMargin = a.getDimensionPixelSize(10, -1);
                if (horizontalMargin >= 0) {
                    this.leftMargin = horizontalMargin;
                    this.rightMargin = horizontalMargin;
                } else {
                    this.leftMargin = a.getDimensionPixelSize(3, Integer.MIN_VALUE);
                    if (this.leftMargin == Integer.MIN_VALUE) {
                        this.mMarginFlags = (byte)(this.mMarginFlags | 4);
                        this.leftMargin = 0;
                    }
                    this.rightMargin = a.getDimensionPixelSize(5, Integer.MIN_VALUE);
                    if (this.rightMargin == Integer.MIN_VALUE) {
                        this.mMarginFlags = (byte)(this.mMarginFlags | 8);
                        this.rightMargin = 0;
                    }
                }
                this.startMargin = a.getDimensionPixelSize(7, Integer.MIN_VALUE);
                this.endMargin = a.getDimensionPixelSize(8, Integer.MIN_VALUE);
                if (verticalMargin >= 0) {
                    this.topMargin = verticalMargin;
                    this.bottomMargin = verticalMargin;
                } else {
                    this.topMargin = a.getDimensionPixelSize(4, 0);
                    this.bottomMargin = a.getDimensionPixelSize(6, 0);
                }
                if (this.isMarginRelative()) {
                    this.mMarginFlags = (byte)(this.mMarginFlags | 0x20);
                }
            }
            boolean hasRtlSupport = c.getApplicationInfo().hasRtlSupport();
            int targetSdkVersion = c.getApplicationInfo().targetSdkVersion;
            if (targetSdkVersion < 17 || !hasRtlSupport) {
                this.mMarginFlags = (byte)(this.mMarginFlags | 0x10);
            }
            this.mMarginFlags = (byte)(this.mMarginFlags | 0);
            a.recycle();
        }

        private void $$robo$$android_view_ViewGroup_MarginLayoutParams$__constructor__(int width, int height) {
            this.startMargin = Integer.MIN_VALUE;
            this.endMargin = Integer.MIN_VALUE;
            this.mMarginFlags = (byte)(this.mMarginFlags | 4);
            this.mMarginFlags = (byte)(this.mMarginFlags | 8);
            this.mMarginFlags = (byte)(this.mMarginFlags & 0xFFFFFFDF);
            this.mMarginFlags = (byte)(this.mMarginFlags & 0xFFFFFFEF);
        }

        private void $$robo$$android_view_ViewGroup_MarginLayoutParams$__constructor__(MarginLayoutParams source) {
            this.startMargin = Integer.MIN_VALUE;
            this.endMargin = Integer.MIN_VALUE;
            this.width = source.width;
            this.height = source.height;
            this.leftMargin = source.leftMargin;
            this.topMargin = source.topMargin;
            this.rightMargin = source.rightMargin;
            this.bottomMargin = source.bottomMargin;
            this.startMargin = source.startMargin;
            this.endMargin = source.endMargin;
            this.mMarginFlags = source.mMarginFlags;
        }

        private void $$robo$$android_view_ViewGroup_MarginLayoutParams$__constructor__(LayoutParams source) {
            this.startMargin = Integer.MIN_VALUE;
            this.endMargin = Integer.MIN_VALUE;
            this.mMarginFlags = (byte)(this.mMarginFlags | 4);
            this.mMarginFlags = (byte)(this.mMarginFlags | 8);
            this.mMarginFlags = (byte)(this.mMarginFlags & 0xFFFFFFDF);
            this.mMarginFlags = (byte)(this.mMarginFlags & 0xFFFFFFEF);
        }

        private final void $$robo$$android_view_ViewGroup_MarginLayoutParams$copyMarginsFrom(MarginLayoutParams source) {
            this.leftMargin = source.leftMargin;
            this.topMargin = source.topMargin;
            this.rightMargin = source.rightMargin;
            this.bottomMargin = source.bottomMargin;
            this.startMargin = source.startMargin;
            this.endMargin = source.endMargin;
            this.mMarginFlags = source.mMarginFlags;
        }

        private final void $$robo$$android_view_ViewGroup_MarginLayoutParams$setMargins(int left, int top, int right, int bottom) {
            this.leftMargin = left;
            this.topMargin = top;
            this.rightMargin = right;
            this.bottomMargin = bottom;
            this.mMarginFlags = (byte)(this.mMarginFlags & 0xFFFFFFFB);
            this.mMarginFlags = (byte)(this.mMarginFlags & 0xFFFFFFF7);
            this.mMarginFlags = this.isMarginRelative() ? (byte)(this.mMarginFlags | 0x20) : (byte)(this.mMarginFlags & 0xFFFFFFDF);
        }

        private final void $$robo$$android_view_ViewGroup_MarginLayoutParams$setMarginsRelative(int start, int top, int end, int bottom) {
            this.startMargin = start;
            this.topMargin = top;
            this.endMargin = end;
            this.bottomMargin = bottom;
            this.mMarginFlags = (byte)(this.mMarginFlags | 0x20);
        }

        private final void $$robo$$android_view_ViewGroup_MarginLayoutParams$setMarginStart(int start) {
            this.startMargin = start;
            this.mMarginFlags = (byte)(this.mMarginFlags | 0x20);
        }

        private final int $$robo$$android_view_ViewGroup_MarginLayoutParams$getMarginStart() {
            if (this.startMargin != Integer.MIN_VALUE) {
                return this.startMargin;
            }
            if ((this.mMarginFlags & 0x20) == 32) {
                this.doResolveMargins();
            }
            switch (this.mMarginFlags & 3) {
                case 1: {
                    return this.rightMargin;
                }
            }
            return this.leftMargin;
        }

        private final void $$robo$$android_view_ViewGroup_MarginLayoutParams$setMarginEnd(int end) {
            this.endMargin = end;
            this.mMarginFlags = (byte)(this.mMarginFlags | 0x20);
        }

        private final int $$robo$$android_view_ViewGroup_MarginLayoutParams$getMarginEnd() {
            if (this.endMargin != Integer.MIN_VALUE) {
                return this.endMargin;
            }
            if ((this.mMarginFlags & 0x20) == 32) {
                this.doResolveMargins();
            }
            switch (this.mMarginFlags & 3) {
                case 1: {
                    return this.leftMargin;
                }
            }
            return this.rightMargin;
        }

        private final boolean $$robo$$android_view_ViewGroup_MarginLayoutParams$isMarginRelative() {
            return this.startMargin != Integer.MIN_VALUE || this.endMargin != Integer.MIN_VALUE;
        }

        private final void $$robo$$android_view_ViewGroup_MarginLayoutParams$setLayoutDirection(int layoutDirection) {
            if (layoutDirection != 0 && layoutDirection != 1) {
                return;
            }
            if (layoutDirection != (this.mMarginFlags & 3)) {
                this.mMarginFlags = (byte)(this.mMarginFlags & 0xFFFFFFFC);
                this.mMarginFlags = (byte)(this.mMarginFlags | layoutDirection & 3);
                this.mMarginFlags = this.isMarginRelative() ? (byte)(this.mMarginFlags | 0x20) : (byte)(this.mMarginFlags & 0xFFFFFFDF);
            }
        }

        private final int $$robo$$android_view_ViewGroup_MarginLayoutParams$getLayoutDirection() {
            return this.mMarginFlags & 3;
        }

        private final void $$robo$$android_view_ViewGroup_MarginLayoutParams$resolveLayoutDirection(int layoutDirection) {
            this.setLayoutDirection(layoutDirection);
            if (!this.isMarginRelative() || (this.mMarginFlags & 0x20) != 32) {
                return;
            }
            this.doResolveMargins();
        }

        private final void $$robo$$android_view_ViewGroup_MarginLayoutParams$doResolveMargins() {
            if ((this.mMarginFlags & 0x10) == 16) {
                if ((this.mMarginFlags & 4) == 4 && this.startMargin > Integer.MIN_VALUE) {
                    this.leftMargin = this.startMargin;
                }
                if ((this.mMarginFlags & 8) == 8 && this.endMargin > Integer.MIN_VALUE) {
                    this.rightMargin = this.endMargin;
                }
            } else {
                switch (this.mMarginFlags & 3) {
                    case 1: {
                        this.leftMargin = this.endMargin > Integer.MIN_VALUE ? this.endMargin : 0;
                        this.rightMargin = this.startMargin > Integer.MIN_VALUE ? this.startMargin : 0;
                        break;
                    }
                    default: {
                        this.leftMargin = this.startMargin > Integer.MIN_VALUE ? this.startMargin : 0;
                        this.rightMargin = this.endMargin > Integer.MIN_VALUE ? this.endMargin : 0;
                    }
                }
            }
            this.mMarginFlags = (byte)(this.mMarginFlags & 0xFFFFFFDF);
        }

        private final boolean $$robo$$android_view_ViewGroup_MarginLayoutParams$isLayoutRtl() {
            return (this.mMarginFlags & 3) == 1;
        }

        private final void $$robo$$android_view_ViewGroup_MarginLayoutParams$onDebugDraw(View view, Canvas canvas, Paint paint) {
            Insets oi = View.isLayoutModeOptical(view.mParent) ? view.getOpticalInsets() : Insets.NONE;
            ViewGroup.fillDifference(canvas, view.getLeft() + oi.left, view.getTop() + oi.top, view.getRight() - oi.right, view.getBottom() - oi.bottom, this.leftMargin, this.topMargin, this.rightMargin, this.bottomMargin, paint);
        }

        private final void $$robo$$android_view_ViewGroup_MarginLayoutParams$encodeProperties(ViewHierarchyEncoder encoder) {
            super.encodeProperties(encoder);
            encoder.addProperty("leftMargin", this.leftMargin);
            encoder.addProperty("topMargin", this.topMargin);
            encoder.addProperty("rightMargin", this.rightMargin);
            encoder.addProperty("bottomMargin", this.bottomMargin);
            encoder.addProperty("startMargin", this.startMargin);
            encoder.addProperty("endMargin", this.endMargin);
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$android_view_ViewGroup_MarginLayoutParams$__constructor__(context, attributeSet);
        }

        public MarginLayoutParams(Context context, AttributeSet attributeSet) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewGroup_MarginLayoutParams$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_view_ViewGroup_MarginLayoutParams$__constructor__(n, n2);
        }

        public MarginLayoutParams(int n, int n2) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewGroup_MarginLayoutParams$__constructor__(int int ), 0, this, n, n2);
        }

        private void __constructor__(MarginLayoutParams marginLayoutParams) {
            this.$$robo$$android_view_ViewGroup_MarginLayoutParams$__constructor__(marginLayoutParams);
        }

        public MarginLayoutParams(MarginLayoutParams marginLayoutParams) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewGroup_MarginLayoutParams$__constructor__(android.view.ViewGroup$MarginLayoutParams ), 0, this, marginLayoutParams);
        }

        private void __constructor__(LayoutParams layoutParams) {
            this.$$robo$$android_view_ViewGroup_MarginLayoutParams$__constructor__(layoutParams);
        }

        public MarginLayoutParams(LayoutParams layoutParams) {
            super(layoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewGroup_MarginLayoutParams$__constructor__(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
        }

        public void copyMarginsFrom(MarginLayoutParams marginLayoutParams) {
            InvokeDynamicSupport.bootstrap("copyMarginsFrom", $$robo$$android_view_ViewGroup_MarginLayoutParams$copyMarginsFrom(android.view.ViewGroup$MarginLayoutParams ), 0, this, marginLayoutParams);
        }

        public void setMargins(int n, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("setMargins", $$robo$$android_view_ViewGroup_MarginLayoutParams$setMargins(int int int int ), 0, this, n, n2, n3, n4);
        }

        public void setMarginsRelative(int n, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("setMarginsRelative", $$robo$$android_view_ViewGroup_MarginLayoutParams$setMarginsRelative(int int int int ), 0, this, n, n2, n3, n4);
        }

        public void setMarginStart(int n) {
            InvokeDynamicSupport.bootstrap("setMarginStart", $$robo$$android_view_ViewGroup_MarginLayoutParams$setMarginStart(int ), 0, this, n);
        }

        public int getMarginStart() {
            return (int)InvokeDynamicSupport.bootstrap("getMarginStart", $$robo$$android_view_ViewGroup_MarginLayoutParams$getMarginStart(), 0, this);
        }

        public void setMarginEnd(int n) {
            InvokeDynamicSupport.bootstrap("setMarginEnd", $$robo$$android_view_ViewGroup_MarginLayoutParams$setMarginEnd(int ), 0, this, n);
        }

        public int getMarginEnd() {
            return (int)InvokeDynamicSupport.bootstrap("getMarginEnd", $$robo$$android_view_ViewGroup_MarginLayoutParams$getMarginEnd(), 0, this);
        }

        public boolean isMarginRelative() {
            return (boolean)InvokeDynamicSupport.bootstrap("isMarginRelative", $$robo$$android_view_ViewGroup_MarginLayoutParams$isMarginRelative(), 0, this);
        }

        public void setLayoutDirection(int n) {
            InvokeDynamicSupport.bootstrap("setLayoutDirection", $$robo$$android_view_ViewGroup_MarginLayoutParams$setLayoutDirection(int ), 0, this, n);
        }

        public int getLayoutDirection() {
            return (int)InvokeDynamicSupport.bootstrap("getLayoutDirection", $$robo$$android_view_ViewGroup_MarginLayoutParams$getLayoutDirection(), 0, this);
        }

        @Override
        public void resolveLayoutDirection(int n) {
            InvokeDynamicSupport.bootstrap("resolveLayoutDirection", $$robo$$android_view_ViewGroup_MarginLayoutParams$resolveLayoutDirection(int ), 0, this, n);
        }

        private void doResolveMargins() {
            InvokeDynamicSupport.bootstrap("doResolveMargins", $$robo$$android_view_ViewGroup_MarginLayoutParams$doResolveMargins(), 0, this);
        }

        public boolean isLayoutRtl() {
            return (boolean)InvokeDynamicSupport.bootstrap("isLayoutRtl", $$robo$$android_view_ViewGroup_MarginLayoutParams$isLayoutRtl(), 0, this);
        }

        @Override
        public void onDebugDraw(View view, Canvas canvas, Paint paint) {
            InvokeDynamicSupport.bootstrap("onDebugDraw", $$robo$$android_view_ViewGroup_MarginLayoutParams$onDebugDraw(android.view.View android.graphics.Canvas android.graphics.Paint ), 0, this, view, canvas, paint);
        }

        @Override
        protected void encodeProperties(ViewHierarchyEncoder viewHierarchyEncoder) {
            InvokeDynamicSupport.bootstrap("encodeProperties", $$robo$$android_view_ViewGroup_MarginLayoutParams$encodeProperties(android.view.ViewHierarchyEncoder ), 0, this, viewHierarchyEncoder);
        }

        public /* synthetic */ MarginLayoutParams() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MarginLayoutParams)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class LayoutParams
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        @Deprecated
        public static int FILL_PARENT = -1;
        public static int MATCH_PARENT = -1;
        public static int WRAP_CONTENT = -2;
        @ViewDebug.ExportedProperty(category="layout", mapping={@ViewDebug.IntToString(from=-1, to="MATCH_PARENT"), @ViewDebug.IntToString(from=-2, to="WRAP_CONTENT")})
        public int width;
        @ViewDebug.ExportedProperty(category="layout", mapping={@ViewDebug.IntToString(from=-1, to="MATCH_PARENT"), @ViewDebug.IntToString(from=-2, to="WRAP_CONTENT")})
        public int height;
        public LayoutAnimationController.AnimationParameters layoutAnimationParameters;

        private void $$robo$$android_view_ViewGroup_LayoutParams$__constructor__(Context c, AttributeSet attrs) {
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.ViewGroup_Layout);
            this.setBaseAttributes(a, 0, 1);
            a.recycle();
        }

        private void $$robo$$android_view_ViewGroup_LayoutParams$__constructor__(int width, int height) {
            this.width = width;
            this.height = height;
        }

        private void $$robo$$android_view_ViewGroup_LayoutParams$__constructor__(LayoutParams source) {
            this.width = source.width;
            this.height = source.height;
        }

        private void $$robo$$android_view_ViewGroup_LayoutParams$__constructor__() {
        }

        private final void $$robo$$android_view_ViewGroup_LayoutParams$setBaseAttributes(TypedArray a, int widthAttr, int heightAttr) {
            this.width = a.getLayoutDimension(widthAttr, "layout_width");
            this.height = a.getLayoutDimension(heightAttr, "layout_height");
        }

        private final void $$robo$$android_view_ViewGroup_LayoutParams$resolveLayoutDirection(int layoutDirection) {
        }

        private final String $$robo$$android_view_ViewGroup_LayoutParams$debug(String output) {
            return output + "ViewGroup.LayoutParams={ width=" + LayoutParams.sizeToString(this.width) + ", height=" + LayoutParams.sizeToString(this.height) + " }";
        }

        private final void $$robo$$android_view_ViewGroup_LayoutParams$onDebugDraw(View view, Canvas canvas, Paint paint) {
        }

        private static final String $$robo$$android_view_ViewGroup_LayoutParams$sizeToString(int size) {
            if (size == -2) {
                return "wrap-content";
            }
            if (size == -1) {
                return "match-parent";
            }
            return String.valueOf(size);
        }

        private final void $$robo$$android_view_ViewGroup_LayoutParams$encode(ViewHierarchyEncoder encoder) {
            encoder.beginObject(this);
            this.encodeProperties(encoder);
            encoder.endObject();
        }

        private final void $$robo$$android_view_ViewGroup_LayoutParams$encodeProperties(ViewHierarchyEncoder encoder) {
            encoder.addProperty("width", this.width);
            encoder.addProperty("height", this.height);
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$android_view_ViewGroup_LayoutParams$__constructor__(context, attributeSet);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewGroup_LayoutParams$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_view_ViewGroup_LayoutParams$__constructor__(n, n2);
        }

        public LayoutParams(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewGroup_LayoutParams$__constructor__(int int ), 0, this, n, n2);
        }

        private void __constructor__(LayoutParams layoutParams) {
            this.$$robo$$android_view_ViewGroup_LayoutParams$__constructor__(layoutParams);
        }

        public LayoutParams(LayoutParams layoutParams) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewGroup_LayoutParams$__constructor__(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
        }

        private void __constructor__() {
            this.$$robo$$android_view_ViewGroup_LayoutParams$__constructor__();
        }

        LayoutParams() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewGroup_LayoutParams$__constructor__(), 0, this);
        }

        protected void setBaseAttributes(TypedArray typedArray, int n, int n2) {
            InvokeDynamicSupport.bootstrap("setBaseAttributes", $$robo$$android_view_ViewGroup_LayoutParams$setBaseAttributes(android.content.res.TypedArray int int ), 0, this, typedArray, n, n2);
        }

        public void resolveLayoutDirection(int n) {
            InvokeDynamicSupport.bootstrap("resolveLayoutDirection", $$robo$$android_view_ViewGroup_LayoutParams$resolveLayoutDirection(int ), 0, this, n);
        }

        public String debug(String string2) {
            return InvokeDynamicSupport.bootstrap("debug", $$robo$$android_view_ViewGroup_LayoutParams$debug(java.lang.String ), 0, this, string2);
        }

        public void onDebugDraw(View view, Canvas canvas, Paint paint) {
            InvokeDynamicSupport.bootstrap("onDebugDraw", $$robo$$android_view_ViewGroup_LayoutParams$onDebugDraw(android.view.View android.graphics.Canvas android.graphics.Paint ), 0, this, view, canvas, paint);
        }

        protected static String sizeToString(int n) {
            return InvokeDynamicSupport.bootstrapStatic("sizeToString", $$robo$$android_view_ViewGroup_LayoutParams$sizeToString(int ), 0, (int)n);
        }

        void encode(ViewHierarchyEncoder viewHierarchyEncoder) {
            InvokeDynamicSupport.bootstrap("encode", $$robo$$android_view_ViewGroup_LayoutParams$encode(android.view.ViewHierarchyEncoder ), 0, this, viewHierarchyEncoder);
        }

        protected void encodeProperties(ViewHierarchyEncoder viewHierarchyEncoder) {
            InvokeDynamicSupport.bootstrap("encodeProperties", $$robo$$android_view_ViewGroup_LayoutParams$encodeProperties(android.view.ViewHierarchyEncoder ), 0, this, viewHierarchyEncoder);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutParams)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnHierarchyChangeListener
    extends InstrumentedInterface {
        public void onChildViewAdded(View var1, View var2);

        public void onChildViewRemoved(View var1, View var2);
    }
}

