/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.os.Parcelable;
import android.view.View;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AccessibilityRecord
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected static boolean DEBUG_CONCISE_TOSTRING = false;
    private static int UNDEFINED = -1;
    private static int PROPERTY_CHECKED = 1;
    private static int PROPERTY_ENABLED = 2;
    private static int PROPERTY_PASSWORD = 4;
    private static int PROPERTY_FULL_SCREEN = 128;
    private static int PROPERTY_SCROLLABLE = 256;
    private static int PROPERTY_IMPORTANT_FOR_ACCESSIBILITY = 512;
    private static int GET_SOURCE_PREFETCH_FLAGS = 7;
    private static int MAX_POOL_SIZE = 10;
    private static Object sPoolLock;
    private static AccessibilityRecord sPool;
    private static int sPoolSize;
    private AccessibilityRecord mNext;
    private boolean mIsInPool;
    boolean mSealed;
    int mBooleanProperties;
    int mCurrentItemIndex;
    int mItemCount;
    int mFromIndex;
    int mToIndex;
    int mScrollX;
    int mScrollY;
    int mScrollDeltaX;
    int mScrollDeltaY;
    int mMaxScrollX;
    int mMaxScrollY;
    int mAddedCount;
    int mRemovedCount;
    long mSourceNodeId;
    int mSourceWindowId;
    CharSequence mClassName;
    CharSequence mContentDescription;
    CharSequence mBeforeText;
    Parcelable mParcelableData;
    List<CharSequence> mText;
    int mConnectionId;

    private void $$robo$$android_view_accessibility_AccessibilityRecord$__constructor__() {
        this.mBooleanProperties = 0;
        this.mCurrentItemIndex = -1;
        this.mItemCount = -1;
        this.mFromIndex = -1;
        this.mToIndex = -1;
        this.mScrollX = -1;
        this.mScrollY = -1;
        this.mScrollDeltaX = -1;
        this.mScrollDeltaY = -1;
        this.mMaxScrollX = -1;
        this.mMaxScrollY = -1;
        this.mAddedCount = -1;
        this.mRemovedCount = -1;
        this.mSourceNodeId = AccessibilityNodeInfo.UNDEFINED_NODE_ID;
        this.mSourceWindowId = -1;
        this.mText = new ArrayList<CharSequence>();
        this.mConnectionId = -1;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setSource(View source) {
        this.setSource(source, -1);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setSource(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        boolean important = true;
        int rootViewId = Integer.MAX_VALUE;
        this.mSourceWindowId = -1;
        if (root != null) {
            important = root.isImportantForAccessibility();
            rootViewId = root.getAccessibilityViewId();
            this.mSourceWindowId = root.getAccessibilityWindowId();
        }
        this.setBooleanProperty(512, important);
        this.mSourceNodeId = AccessibilityNodeInfo.makeNodeId(rootViewId, virtualDescendantId);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setSourceNodeId(long sourceNodeId) {
        this.mSourceNodeId = sourceNodeId;
    }

    private final AccessibilityNodeInfo $$robo$$android_view_accessibility_AccessibilityRecord$getSource() {
        this.enforceSealed();
        if (this.mConnectionId == -1 || this.mSourceWindowId == -1 || AccessibilityNodeInfo.getAccessibilityViewId(this.mSourceNodeId) == Integer.MAX_VALUE) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mSourceWindowId, this.mSourceNodeId, false, 7, null);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setWindowId(int windowId) {
        this.mSourceWindowId = windowId;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityRecord$getWindowId() {
        return this.mSourceWindowId;
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityRecord$isChecked() {
        return this.getBooleanProperty(1);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setChecked(boolean isChecked) {
        this.enforceNotSealed();
        this.setBooleanProperty(1, isChecked);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityRecord$isEnabled() {
        return this.getBooleanProperty(2);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setEnabled(boolean isEnabled) {
        this.enforceNotSealed();
        this.setBooleanProperty(2, isEnabled);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityRecord$isPassword() {
        return this.getBooleanProperty(4);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setPassword(boolean isPassword) {
        this.enforceNotSealed();
        this.setBooleanProperty(4, isPassword);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityRecord$isFullScreen() {
        return this.getBooleanProperty(128);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setFullScreen(boolean isFullScreen) {
        this.enforceNotSealed();
        this.setBooleanProperty(128, isFullScreen);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityRecord$isScrollable() {
        return this.getBooleanProperty(256);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setScrollable(boolean scrollable) {
        this.enforceNotSealed();
        this.setBooleanProperty(256, scrollable);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityRecord$isImportantForAccessibility() {
        return this.getBooleanProperty(512);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setImportantForAccessibility(boolean importantForAccessibility) {
        this.enforceNotSealed();
        this.setBooleanProperty(512, importantForAccessibility);
    }

    private final int $$robo$$android_view_accessibility_AccessibilityRecord$getItemCount() {
        return this.mItemCount;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setItemCount(int itemCount) {
        this.enforceNotSealed();
        this.mItemCount = itemCount;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityRecord$getCurrentItemIndex() {
        return this.mCurrentItemIndex;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setCurrentItemIndex(int currentItemIndex) {
        this.enforceNotSealed();
        this.mCurrentItemIndex = currentItemIndex;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityRecord$getFromIndex() {
        return this.mFromIndex;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setFromIndex(int fromIndex) {
        this.enforceNotSealed();
        this.mFromIndex = fromIndex;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityRecord$getToIndex() {
        return this.mToIndex;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setToIndex(int toIndex) {
        this.enforceNotSealed();
        this.mToIndex = toIndex;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityRecord$getScrollX() {
        return this.mScrollX;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setScrollX(int scrollX) {
        this.enforceNotSealed();
        this.mScrollX = scrollX;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityRecord$getScrollY() {
        return this.mScrollY;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setScrollY(int scrollY) {
        this.enforceNotSealed();
        this.mScrollY = scrollY;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityRecord$getScrollDeltaX() {
        return this.mScrollDeltaX;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setScrollDeltaX(int scrollDeltaX) {
        this.enforceNotSealed();
        this.mScrollDeltaX = scrollDeltaX;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityRecord$getScrollDeltaY() {
        return this.mScrollDeltaY;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setScrollDeltaY(int scrollDeltaY) {
        this.enforceNotSealed();
        this.mScrollDeltaY = scrollDeltaY;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityRecord$getMaxScrollX() {
        return this.mMaxScrollX;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setMaxScrollX(int maxScrollX) {
        this.enforceNotSealed();
        this.mMaxScrollX = maxScrollX;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityRecord$getMaxScrollY() {
        return this.mMaxScrollY;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setMaxScrollY(int maxScrollY) {
        this.enforceNotSealed();
        this.mMaxScrollY = maxScrollY;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityRecord$getAddedCount() {
        return this.mAddedCount;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setAddedCount(int addedCount) {
        this.enforceNotSealed();
        this.mAddedCount = addedCount;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityRecord$getRemovedCount() {
        return this.mRemovedCount;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setRemovedCount(int removedCount) {
        this.enforceNotSealed();
        this.mRemovedCount = removedCount;
    }

    private final CharSequence $$robo$$android_view_accessibility_AccessibilityRecord$getClassName() {
        return this.mClassName;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setClassName(CharSequence className) {
        this.enforceNotSealed();
        this.mClassName = className;
    }

    private final List<CharSequence> $$robo$$android_view_accessibility_AccessibilityRecord$getText() {
        return this.mText;
    }

    private final CharSequence $$robo$$android_view_accessibility_AccessibilityRecord$getBeforeText() {
        return this.mBeforeText;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setBeforeText(CharSequence beforeText) {
        this.enforceNotSealed();
        this.mBeforeText = beforeText == null ? null : beforeText.subSequence(0, beforeText.length());
    }

    private final CharSequence $$robo$$android_view_accessibility_AccessibilityRecord$getContentDescription() {
        return this.mContentDescription;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setContentDescription(CharSequence contentDescription) {
        this.enforceNotSealed();
        this.mContentDescription = contentDescription == null ? null : contentDescription.subSequence(0, contentDescription.length());
    }

    private final Parcelable $$robo$$android_view_accessibility_AccessibilityRecord$getParcelableData() {
        return this.mParcelableData;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setParcelableData(Parcelable parcelableData) {
        this.enforceNotSealed();
        this.mParcelableData = parcelableData;
    }

    private final long $$robo$$android_view_accessibility_AccessibilityRecord$getSourceNodeId() {
        return this.mSourceNodeId;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setConnectionId(int connectionId) {
        this.enforceNotSealed();
        this.mConnectionId = connectionId;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setSealed(boolean sealed) {
        this.mSealed = sealed;
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityRecord$isSealed() {
        return this.mSealed;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$enforceSealed() {
        if (!this.isSealed()) {
            throw new IllegalStateException("Cannot perform this action on a not sealed instance.");
        }
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$enforceNotSealed() {
        if (this.isSealed()) {
            throw new IllegalStateException("Cannot perform this action on a sealed instance.");
        }
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityRecord$getBooleanProperty(int property) {
        return (this.mBooleanProperties & property) == property;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$setBooleanProperty(int property, boolean value) {
        this.mBooleanProperties = value ? (this.mBooleanProperties |= property) : (this.mBooleanProperties &= ~property);
    }

    private static final AccessibilityRecord $$robo$$android_view_accessibility_AccessibilityRecord$obtain(AccessibilityRecord record) {
        AccessibilityRecord clone = AccessibilityRecord.obtain();
        clone.init(record);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final AccessibilityRecord $$robo$$android_view_accessibility_AccessibilityRecord$obtain() {
        Object object = sPoolLock;
        synchronized (object) {
            if (sPool != null) {
                AccessibilityRecord record = sPool;
                sPool = AccessibilityRecord.sPool.mNext;
                --sPoolSize;
                record.mNext = null;
                record.mIsInPool = false;
                return record;
            }
            return new AccessibilityRecord();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityRecord$recycle() {
        if (this.mIsInPool) {
            throw new IllegalStateException("Record already recycled!");
        }
        this.clear();
        Object object = sPoolLock;
        synchronized (object) {
            if (sPoolSize <= 10) {
                this.mNext = sPool;
                sPool = this;
                this.mIsInPool = true;
                ++sPoolSize;
            }
        }
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$init(AccessibilityRecord record) {
        this.mSealed = record.mSealed;
        this.mBooleanProperties = record.mBooleanProperties;
        this.mCurrentItemIndex = record.mCurrentItemIndex;
        this.mItemCount = record.mItemCount;
        this.mFromIndex = record.mFromIndex;
        this.mToIndex = record.mToIndex;
        this.mScrollX = record.mScrollX;
        this.mScrollY = record.mScrollY;
        this.mMaxScrollX = record.mMaxScrollX;
        this.mMaxScrollY = record.mMaxScrollY;
        this.mAddedCount = record.mAddedCount;
        this.mRemovedCount = record.mRemovedCount;
        this.mClassName = record.mClassName;
        this.mContentDescription = record.mContentDescription;
        this.mBeforeText = record.mBeforeText;
        this.mParcelableData = record.mParcelableData;
        this.mText.addAll(record.mText);
        this.mSourceWindowId = record.mSourceWindowId;
        this.mSourceNodeId = record.mSourceNodeId;
        this.mConnectionId = record.mConnectionId;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$clear() {
        this.mSealed = false;
        this.mBooleanProperties = 0;
        this.mCurrentItemIndex = -1;
        this.mItemCount = -1;
        this.mFromIndex = -1;
        this.mToIndex = -1;
        this.mScrollX = -1;
        this.mScrollY = -1;
        this.mMaxScrollX = -1;
        this.mMaxScrollY = -1;
        this.mAddedCount = -1;
        this.mRemovedCount = -1;
        this.mClassName = null;
        this.mContentDescription = null;
        this.mBeforeText = null;
        this.mParcelableData = null;
        this.mText.clear();
        this.mSourceNodeId = Integer.MAX_VALUE;
        this.mSourceWindowId = -1;
        this.mConnectionId = -1;
    }

    private final String $$robo$$android_view_accessibility_AccessibilityRecord$toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    private final StringBuilder $$robo$$android_view_accessibility_AccessibilityRecord$appendTo(StringBuilder builder) {
        builder.append(" [ ClassName: ").append(this.mClassName);
        this.appendPropName(builder, "Text").append(this.mText);
        this.append(builder, "ContentDescription", this.mContentDescription);
        this.append(builder, "ItemCount", this.mItemCount);
        this.append(builder, "CurrentItemIndex", this.mCurrentItemIndex);
        this.appendUnless(true, 2, builder);
        this.appendUnless(false, 4, builder);
        this.appendUnless(false, 1, builder);
        this.appendUnless(false, 128, builder);
        this.appendUnless(false, 256, builder);
        this.append(builder, "BeforeText", this.mBeforeText);
        this.append(builder, "FromIndex", this.mFromIndex);
        this.append(builder, "ToIndex", this.mToIndex);
        this.append(builder, "ScrollX", this.mScrollX);
        this.append(builder, "ScrollY", this.mScrollY);
        this.append(builder, "MaxScrollX", this.mMaxScrollX);
        this.append(builder, "MaxScrollY", this.mMaxScrollY);
        this.append(builder, "AddedCount", this.mAddedCount);
        this.append(builder, "RemovedCount", this.mRemovedCount);
        this.append(builder, "ParcelableData", this.mParcelableData);
        builder.append(" ]");
        return builder;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$appendUnless(boolean defValue, int prop, StringBuilder builder) {
        boolean value = this.getBooleanProperty(prop);
        this.appendPropName(builder, AccessibilityRecord.singleBooleanPropertyToString(prop)).append(value);
    }

    private static final String $$robo$$android_view_accessibility_AccessibilityRecord$singleBooleanPropertyToString(int prop) {
        switch (prop) {
            case 1: {
                return "Checked";
            }
            case 2: {
                return "Enabled";
            }
            case 4: {
                return "Password";
            }
            case 128: {
                return "FullScreen";
            }
            case 256: {
                return "Scrollable";
            }
            case 512: {
                return "ImportantForAccessibility";
            }
        }
        return Integer.toHexString(prop);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$append(StringBuilder builder, String propName, int propValue) {
        this.appendPropName(builder, propName).append(propValue);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityRecord$append(StringBuilder builder, String propName, Object propValue) {
        this.appendPropName(builder, propName).append(propValue);
    }

    private final StringBuilder $$robo$$android_view_accessibility_AccessibilityRecord$appendPropName(StringBuilder builder, String propName) {
        return builder.append("; ").append(propName).append(": ");
    }

    static void __staticInitializer__() {
        sPoolLock = new Object();
    }

    private void __constructor__() {
        this.$$robo$$android_view_accessibility_AccessibilityRecord$__constructor__();
    }

    AccessibilityRecord() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_AccessibilityRecord$__constructor__(), 0, this);
    }

    public void setSource(View view) {
        InvokeDynamicSupport.bootstrap("setSource", $$robo$$android_view_accessibility_AccessibilityRecord$setSource(android.view.View ), 0, this, view);
    }

    public void setSource(View view, int n) {
        InvokeDynamicSupport.bootstrap("setSource", $$robo$$android_view_accessibility_AccessibilityRecord$setSource(android.view.View int ), 0, this, view, n);
    }

    public void setSourceNodeId(long l) {
        InvokeDynamicSupport.bootstrap("setSourceNodeId", $$robo$$android_view_accessibility_AccessibilityRecord$setSourceNodeId(long ), 0, this, l);
    }

    public AccessibilityNodeInfo getSource() {
        return InvokeDynamicSupport.bootstrap("getSource", $$robo$$android_view_accessibility_AccessibilityRecord$getSource(), 0, this);
    }

    public void setWindowId(int n) {
        InvokeDynamicSupport.bootstrap("setWindowId", $$robo$$android_view_accessibility_AccessibilityRecord$setWindowId(int ), 0, this, n);
    }

    public int getWindowId() {
        return (int)InvokeDynamicSupport.bootstrap("getWindowId", $$robo$$android_view_accessibility_AccessibilityRecord$getWindowId(), 0, this);
    }

    public boolean isChecked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isChecked", $$robo$$android_view_accessibility_AccessibilityRecord$isChecked(), 0, this);
    }

    public void setChecked(boolean bl) {
        InvokeDynamicSupport.bootstrap("setChecked", $$robo$$android_view_accessibility_AccessibilityRecord$setChecked(boolean ), 0, this, bl);
    }

    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_view_accessibility_AccessibilityRecord$isEnabled(), 0, this);
    }

    public void setEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_view_accessibility_AccessibilityRecord$setEnabled(boolean ), 0, this, bl);
    }

    public boolean isPassword() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPassword", $$robo$$android_view_accessibility_AccessibilityRecord$isPassword(), 0, this);
    }

    public void setPassword(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPassword", $$robo$$android_view_accessibility_AccessibilityRecord$setPassword(boolean ), 0, this, bl);
    }

    public boolean isFullScreen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFullScreen", $$robo$$android_view_accessibility_AccessibilityRecord$isFullScreen(), 0, this);
    }

    public void setFullScreen(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFullScreen", $$robo$$android_view_accessibility_AccessibilityRecord$setFullScreen(boolean ), 0, this, bl);
    }

    public boolean isScrollable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isScrollable", $$robo$$android_view_accessibility_AccessibilityRecord$isScrollable(), 0, this);
    }

    public void setScrollable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setScrollable", $$robo$$android_view_accessibility_AccessibilityRecord$setScrollable(boolean ), 0, this, bl);
    }

    public boolean isImportantForAccessibility() {
        return (boolean)InvokeDynamicSupport.bootstrap("isImportantForAccessibility", $$robo$$android_view_accessibility_AccessibilityRecord$isImportantForAccessibility(), 0, this);
    }

    public void setImportantForAccessibility(boolean bl) {
        InvokeDynamicSupport.bootstrap("setImportantForAccessibility", $$robo$$android_view_accessibility_AccessibilityRecord$setImportantForAccessibility(boolean ), 0, this, bl);
    }

    public int getItemCount() {
        return (int)InvokeDynamicSupport.bootstrap("getItemCount", $$robo$$android_view_accessibility_AccessibilityRecord$getItemCount(), 0, this);
    }

    public void setItemCount(int n) {
        InvokeDynamicSupport.bootstrap("setItemCount", $$robo$$android_view_accessibility_AccessibilityRecord$setItemCount(int ), 0, this, n);
    }

    public int getCurrentItemIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentItemIndex", $$robo$$android_view_accessibility_AccessibilityRecord$getCurrentItemIndex(), 0, this);
    }

    public void setCurrentItemIndex(int n) {
        InvokeDynamicSupport.bootstrap("setCurrentItemIndex", $$robo$$android_view_accessibility_AccessibilityRecord$setCurrentItemIndex(int ), 0, this, n);
    }

    public int getFromIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getFromIndex", $$robo$$android_view_accessibility_AccessibilityRecord$getFromIndex(), 0, this);
    }

    public void setFromIndex(int n) {
        InvokeDynamicSupport.bootstrap("setFromIndex", $$robo$$android_view_accessibility_AccessibilityRecord$setFromIndex(int ), 0, this, n);
    }

    public int getToIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getToIndex", $$robo$$android_view_accessibility_AccessibilityRecord$getToIndex(), 0, this);
    }

    public void setToIndex(int n) {
        InvokeDynamicSupport.bootstrap("setToIndex", $$robo$$android_view_accessibility_AccessibilityRecord$setToIndex(int ), 0, this, n);
    }

    public int getScrollX() {
        return (int)InvokeDynamicSupport.bootstrap("getScrollX", $$robo$$android_view_accessibility_AccessibilityRecord$getScrollX(), 0, this);
    }

    public void setScrollX(int n) {
        InvokeDynamicSupport.bootstrap("setScrollX", $$robo$$android_view_accessibility_AccessibilityRecord$setScrollX(int ), 0, this, n);
    }

    public int getScrollY() {
        return (int)InvokeDynamicSupport.bootstrap("getScrollY", $$robo$$android_view_accessibility_AccessibilityRecord$getScrollY(), 0, this);
    }

    public void setScrollY(int n) {
        InvokeDynamicSupport.bootstrap("setScrollY", $$robo$$android_view_accessibility_AccessibilityRecord$setScrollY(int ), 0, this, n);
    }

    public int getScrollDeltaX() {
        return (int)InvokeDynamicSupport.bootstrap("getScrollDeltaX", $$robo$$android_view_accessibility_AccessibilityRecord$getScrollDeltaX(), 0, this);
    }

    public void setScrollDeltaX(int n) {
        InvokeDynamicSupport.bootstrap("setScrollDeltaX", $$robo$$android_view_accessibility_AccessibilityRecord$setScrollDeltaX(int ), 0, this, n);
    }

    public int getScrollDeltaY() {
        return (int)InvokeDynamicSupport.bootstrap("getScrollDeltaY", $$robo$$android_view_accessibility_AccessibilityRecord$getScrollDeltaY(), 0, this);
    }

    public void setScrollDeltaY(int n) {
        InvokeDynamicSupport.bootstrap("setScrollDeltaY", $$robo$$android_view_accessibility_AccessibilityRecord$setScrollDeltaY(int ), 0, this, n);
    }

    public int getMaxScrollX() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxScrollX", $$robo$$android_view_accessibility_AccessibilityRecord$getMaxScrollX(), 0, this);
    }

    public void setMaxScrollX(int n) {
        InvokeDynamicSupport.bootstrap("setMaxScrollX", $$robo$$android_view_accessibility_AccessibilityRecord$setMaxScrollX(int ), 0, this, n);
    }

    public int getMaxScrollY() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxScrollY", $$robo$$android_view_accessibility_AccessibilityRecord$getMaxScrollY(), 0, this);
    }

    public void setMaxScrollY(int n) {
        InvokeDynamicSupport.bootstrap("setMaxScrollY", $$robo$$android_view_accessibility_AccessibilityRecord$setMaxScrollY(int ), 0, this, n);
    }

    public int getAddedCount() {
        return (int)InvokeDynamicSupport.bootstrap("getAddedCount", $$robo$$android_view_accessibility_AccessibilityRecord$getAddedCount(), 0, this);
    }

    public void setAddedCount(int n) {
        InvokeDynamicSupport.bootstrap("setAddedCount", $$robo$$android_view_accessibility_AccessibilityRecord$setAddedCount(int ), 0, this, n);
    }

    public int getRemovedCount() {
        return (int)InvokeDynamicSupport.bootstrap("getRemovedCount", $$robo$$android_view_accessibility_AccessibilityRecord$getRemovedCount(), 0, this);
    }

    public void setRemovedCount(int n) {
        InvokeDynamicSupport.bootstrap("setRemovedCount", $$robo$$android_view_accessibility_AccessibilityRecord$setRemovedCount(int ), 0, this, n);
    }

    public CharSequence getClassName() {
        return InvokeDynamicSupport.bootstrap("getClassName", $$robo$$android_view_accessibility_AccessibilityRecord$getClassName(), 0, this);
    }

    public void setClassName(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setClassName", $$robo$$android_view_accessibility_AccessibilityRecord$setClassName(java.lang.CharSequence ), 0, this, charSequence);
    }

    public List<CharSequence> getText() {
        return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_view_accessibility_AccessibilityRecord$getText(), 0, this);
    }

    public CharSequence getBeforeText() {
        return InvokeDynamicSupport.bootstrap("getBeforeText", $$robo$$android_view_accessibility_AccessibilityRecord$getBeforeText(), 0, this);
    }

    public void setBeforeText(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setBeforeText", $$robo$$android_view_accessibility_AccessibilityRecord$setBeforeText(java.lang.CharSequence ), 0, this, charSequence);
    }

    public CharSequence getContentDescription() {
        return InvokeDynamicSupport.bootstrap("getContentDescription", $$robo$$android_view_accessibility_AccessibilityRecord$getContentDescription(), 0, this);
    }

    public void setContentDescription(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setContentDescription", $$robo$$android_view_accessibility_AccessibilityRecord$setContentDescription(java.lang.CharSequence ), 0, this, charSequence);
    }

    public Parcelable getParcelableData() {
        return InvokeDynamicSupport.bootstrap("getParcelableData", $$robo$$android_view_accessibility_AccessibilityRecord$getParcelableData(), 0, this);
    }

    public void setParcelableData(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("setParcelableData", $$robo$$android_view_accessibility_AccessibilityRecord$setParcelableData(android.os.Parcelable ), 0, this, parcelable);
    }

    public long getSourceNodeId() {
        return (long)InvokeDynamicSupport.bootstrap("getSourceNodeId", $$robo$$android_view_accessibility_AccessibilityRecord$getSourceNodeId(), 0, this);
    }

    public void setConnectionId(int n) {
        InvokeDynamicSupport.bootstrap("setConnectionId", $$robo$$android_view_accessibility_AccessibilityRecord$setConnectionId(int ), 0, this, n);
    }

    public void setSealed(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSealed", $$robo$$android_view_accessibility_AccessibilityRecord$setSealed(boolean ), 0, this, bl);
    }

    boolean isSealed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSealed", $$robo$$android_view_accessibility_AccessibilityRecord$isSealed(), 0, this);
    }

    void enforceSealed() {
        InvokeDynamicSupport.bootstrap("enforceSealed", $$robo$$android_view_accessibility_AccessibilityRecord$enforceSealed(), 0, this);
    }

    void enforceNotSealed() {
        InvokeDynamicSupport.bootstrap("enforceNotSealed", $$robo$$android_view_accessibility_AccessibilityRecord$enforceNotSealed(), 0, this);
    }

    private boolean getBooleanProperty(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getBooleanProperty", $$robo$$android_view_accessibility_AccessibilityRecord$getBooleanProperty(int ), 0, this, n);
    }

    private void setBooleanProperty(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setBooleanProperty", $$robo$$android_view_accessibility_AccessibilityRecord$setBooleanProperty(int boolean ), 0, this, n, bl);
    }

    public static AccessibilityRecord obtain(AccessibilityRecord accessibilityRecord) {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_accessibility_AccessibilityRecord$obtain(android.view.accessibility.AccessibilityRecord ), 0, (AccessibilityRecord)accessibilityRecord);
    }

    public static AccessibilityRecord obtain() {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_accessibility_AccessibilityRecord$obtain(), 0);
    }

    public void recycle() {
        InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_view_accessibility_AccessibilityRecord$recycle(), 0, this);
    }

    void init(AccessibilityRecord accessibilityRecord) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_view_accessibility_AccessibilityRecord$init(android.view.accessibility.AccessibilityRecord ), 0, this, accessibilityRecord);
    }

    void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_view_accessibility_AccessibilityRecord$clear(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_accessibility_AccessibilityRecord$toString(), 0, this);
    }

    StringBuilder appendTo(StringBuilder stringBuilder) {
        return InvokeDynamicSupport.bootstrap("appendTo", $$robo$$android_view_accessibility_AccessibilityRecord$appendTo(java.lang.StringBuilder ), 0, this, stringBuilder);
    }

    private void appendUnless(boolean bl, int n, StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrap("appendUnless", $$robo$$android_view_accessibility_AccessibilityRecord$appendUnless(boolean int java.lang.StringBuilder ), 0, this, bl, n, stringBuilder);
    }

    private static String singleBooleanPropertyToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("singleBooleanPropertyToString", $$robo$$android_view_accessibility_AccessibilityRecord$singleBooleanPropertyToString(int ), 0, (int)n);
    }

    private void append(StringBuilder stringBuilder, String string2, int n) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$android_view_accessibility_AccessibilityRecord$append(java.lang.StringBuilder java.lang.String int ), 0, this, stringBuilder, string2, n);
    }

    private void append(StringBuilder stringBuilder, String string2, Object object) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$android_view_accessibility_AccessibilityRecord$append(java.lang.StringBuilder java.lang.String java.lang.Object ), 0, this, stringBuilder, string2, object);
    }

    private StringBuilder appendPropName(StringBuilder stringBuilder, String string2) {
        return InvokeDynamicSupport.bootstrap("appendPropName", $$robo$$android_view_accessibility_AccessibilityRecord$appendPropName(java.lang.StringBuilder java.lang.String ), 0, this, stringBuilder, string2);
    }

    static {
        RobolectricInternals.classInitializing(AccessibilityRecord.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityRecord)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

