/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ScaleAnimation
extends Animation
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Resources mResources;
    private float mFromX;
    private float mToX;
    private float mFromY;
    private float mToY;
    private int mFromXType;
    private int mToXType;
    private int mFromYType;
    private int mToYType;
    private int mFromXData;
    private int mToXData;
    private int mFromYData;
    private int mToYData;
    private int mPivotXType;
    private int mPivotYType;
    private float mPivotXValue;
    private float mPivotYValue;
    private float mPivotX;
    private float mPivotY;

    private void $$robo$$android_view_animation_ScaleAnimation$__constructor__(Context context, AttributeSet attrs) {
        this.mFromXType = 0;
        this.mToXType = 0;
        this.mFromYType = 0;
        this.mToYType = 0;
        this.mFromXData = 0;
        this.mToXData = 0;
        this.mFromYData = 0;
        this.mToYData = 0;
        this.mPivotXType = 0;
        this.mPivotYType = 0;
        this.mPivotXValue = 0.0f;
        this.mPivotYValue = 0.0f;
        this.mResources = context.getResources();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ScaleAnimation);
        TypedValue tv = a.peekValue(2);
        this.mFromX = 0.0f;
        if (tv != null) {
            if (tv.type == 4) {
                this.mFromX = tv.getFloat();
            } else {
                this.mFromXType = tv.type;
                this.mFromXData = tv.data;
            }
        }
        tv = a.peekValue(3);
        this.mToX = 0.0f;
        if (tv != null) {
            if (tv.type == 4) {
                this.mToX = tv.getFloat();
            } else {
                this.mToXType = tv.type;
                this.mToXData = tv.data;
            }
        }
        tv = a.peekValue(4);
        this.mFromY = 0.0f;
        if (tv != null) {
            if (tv.type == 4) {
                this.mFromY = tv.getFloat();
            } else {
                this.mFromYType = tv.type;
                this.mFromYData = tv.data;
            }
        }
        tv = a.peekValue(5);
        this.mToY = 0.0f;
        if (tv != null) {
            if (tv.type == 4) {
                this.mToY = tv.getFloat();
            } else {
                this.mToYType = tv.type;
                this.mToYData = tv.data;
            }
        }
        Animation.Description d = Animation.Description.parseValue(a.peekValue(0));
        this.mPivotXType = d.type;
        this.mPivotXValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(1));
        this.mPivotYType = d.type;
        this.mPivotYValue = d.value;
        a.recycle();
        this.initializePivotPoint();
    }

    private void $$robo$$android_view_animation_ScaleAnimation$__constructor__(float fromX, float toX, float fromY, float toY) {
        this.mFromXType = 0;
        this.mToXType = 0;
        this.mFromYType = 0;
        this.mToYType = 0;
        this.mFromXData = 0;
        this.mToXData = 0;
        this.mFromYData = 0;
        this.mToYData = 0;
        this.mPivotXType = 0;
        this.mPivotYType = 0;
        this.mPivotXValue = 0.0f;
        this.mPivotYValue = 0.0f;
        this.mResources = null;
        this.mFromX = fromX;
        this.mToX = toX;
        this.mFromY = fromY;
        this.mToY = toY;
        this.mPivotX = 0.0f;
        this.mPivotY = 0.0f;
    }

    private void $$robo$$android_view_animation_ScaleAnimation$__constructor__(float fromX, float toX, float fromY, float toY, float pivotX, float pivotY) {
        this.mFromXType = 0;
        this.mToXType = 0;
        this.mFromYType = 0;
        this.mToYType = 0;
        this.mFromXData = 0;
        this.mToXData = 0;
        this.mFromYData = 0;
        this.mToYData = 0;
        this.mPivotXType = 0;
        this.mPivotYType = 0;
        this.mPivotXValue = 0.0f;
        this.mPivotYValue = 0.0f;
        this.mResources = null;
        this.mFromX = fromX;
        this.mToX = toX;
        this.mFromY = fromY;
        this.mToY = toY;
        this.mPivotXType = 0;
        this.mPivotYType = 0;
        this.mPivotXValue = pivotX;
        this.mPivotYValue = pivotY;
        this.initializePivotPoint();
    }

    private void $$robo$$android_view_animation_ScaleAnimation$__constructor__(float fromX, float toX, float fromY, float toY, int pivotXType, float pivotXValue, int pivotYType, float pivotYValue) {
        this.mFromXType = 0;
        this.mToXType = 0;
        this.mFromYType = 0;
        this.mToYType = 0;
        this.mFromXData = 0;
        this.mToXData = 0;
        this.mFromYData = 0;
        this.mToYData = 0;
        this.mPivotXType = 0;
        this.mPivotYType = 0;
        this.mPivotXValue = 0.0f;
        this.mPivotYValue = 0.0f;
        this.mResources = null;
        this.mFromX = fromX;
        this.mToX = toX;
        this.mFromY = fromY;
        this.mToY = toY;
        this.mPivotXValue = pivotXValue;
        this.mPivotXType = pivotXType;
        this.mPivotYValue = pivotYValue;
        this.mPivotYType = pivotYType;
        this.initializePivotPoint();
    }

    private final void $$robo$$android_view_animation_ScaleAnimation$initializePivotPoint() {
        if (this.mPivotXType == 0) {
            this.mPivotX = this.mPivotXValue;
        }
        if (this.mPivotYType == 0) {
            this.mPivotY = this.mPivotYValue;
        }
    }

    private final void $$robo$$android_view_animation_ScaleAnimation$applyTransformation(float interpolatedTime, Transformation t) {
        float sx = 1.0f;
        float sy = 1.0f;
        float scale = this.getScaleFactor();
        if (this.mFromX != 1.0f || this.mToX != 1.0f) {
            sx = this.mFromX + (this.mToX - this.mFromX) * interpolatedTime;
        }
        if (this.mFromY != 1.0f || this.mToY != 1.0f) {
            sy = this.mFromY + (this.mToY - this.mFromY) * interpolatedTime;
        }
        if (this.mPivotX == 0.0f && this.mPivotY == 0.0f) {
            t.getMatrix().setScale(sx, sy);
        } else {
            t.getMatrix().setScale(sx, sy, scale * this.mPivotX, scale * this.mPivotY);
        }
    }

    private final float $$robo$$android_view_animation_ScaleAnimation$resolveScale(float scale, int type, int data, int size, int psize) {
        float targetSize;
        if (type == 6) {
            targetSize = TypedValue.complexToFraction(data, size, psize);
        } else if (type == 5) {
            targetSize = TypedValue.complexToDimension(data, this.mResources.getDisplayMetrics());
        } else {
            return scale;
        }
        if (size == 0) {
            return 1.0f;
        }
        return targetSize / (float)size;
    }

    private final void $$robo$$android_view_animation_ScaleAnimation$initialize(int width, int height, int parentWidth, int parentHeight) {
        super.initialize(width, height, parentWidth, parentHeight);
        this.mFromX = this.resolveScale(this.mFromX, this.mFromXType, this.mFromXData, width, parentWidth);
        this.mToX = this.resolveScale(this.mToX, this.mToXType, this.mToXData, width, parentWidth);
        this.mFromY = this.resolveScale(this.mFromY, this.mFromYType, this.mFromYData, height, parentHeight);
        this.mToY = this.resolveScale(this.mToY, this.mToYType, this.mToYData, height, parentHeight);
        this.mPivotX = this.resolveSize(this.mPivotXType, this.mPivotXValue, width, parentWidth);
        this.mPivotY = this.resolveSize(this.mPivotYType, this.mPivotYValue, height, parentHeight);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_view_animation_ScaleAnimation$__constructor__(context, attributeSet);
    }

    public ScaleAnimation(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_ScaleAnimation$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(float f, float f2, float f3, float f4) {
        this.$$robo$$android_view_animation_ScaleAnimation$__constructor__(f, f2, f3, f4);
    }

    public ScaleAnimation(float f, float f2, float f3, float f4) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_ScaleAnimation$__constructor__(float float float float ), 0, this, f, f2, f3, f4);
    }

    private void __constructor__(float f, float f2, float f3, float f4, float f5, float f6) {
        this.$$robo$$android_view_animation_ScaleAnimation$__constructor__(f, f2, f3, f4, f5, f6);
    }

    public ScaleAnimation(float f, float f2, float f3, float f4, float f5, float f6) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_ScaleAnimation$__constructor__(float float float float float float ), 0, this, f, f2, f3, f4, f5, f6);
    }

    private void __constructor__(float f, float f2, float f3, float f4, int n, float f5, int n2, float f6) {
        this.$$robo$$android_view_animation_ScaleAnimation$__constructor__(f, f2, f3, f4, n, f5, n2, f6);
    }

    public ScaleAnimation(float f, float f2, float f3, float f4, int n, float f5, int n2, float f6) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_ScaleAnimation$__constructor__(float float float float int float int float ), 0, this, f, f2, f3, f4, n, f5, n2, f6);
    }

    private void initializePivotPoint() {
        InvokeDynamicSupport.bootstrap("initializePivotPoint", $$robo$$android_view_animation_ScaleAnimation$initializePivotPoint(), 0, this);
    }

    @Override
    protected void applyTransformation(float f, Transformation transformation) {
        InvokeDynamicSupport.bootstrap("applyTransformation", $$robo$$android_view_animation_ScaleAnimation$applyTransformation(float android.view.animation.Transformation ), 0, this, f, transformation);
    }

    float resolveScale(float f, int n, int n2, int n3, int n4) {
        return (float)InvokeDynamicSupport.bootstrap("resolveScale", $$robo$$android_view_animation_ScaleAnimation$resolveScale(float int int int int ), 0, this, f, n, n2, n3, n4);
    }

    @Override
    public void initialize(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_view_animation_ScaleAnimation$initialize(int int int int ), 0, this, n, n2, n3, n4);
    }

    public /* synthetic */ ScaleAnimation() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScaleAnimation)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

