/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.graphics.Rect;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.Trace;
import android.text.style.SuggestionSpan;
import android.util.Log;
import android.util.Pools;
import android.util.PrintWriterPrinter;
import android.util.SparseArray;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventSender;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.autofill.AutofillManager;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionInspector;
import android.view.inputmethod.InputContentInfo;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;
import com.android.internal.inputmethod.IInputContentUriToken;
import com.android.internal.os.SomeArgs;
import com.android.internal.view.IInputConnectionWrapper;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodClient;
import com.android.internal.view.IInputMethodManager;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.InputBindResult;
import com.android.internal.view.InputMethodClient;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class InputMethodManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static boolean DEBUG = false;
    static String TAG = "InputMethodManager";
    static String PENDING_EVENT_COUNTER = "aq:imm";
    static InputMethodManager sInstance;
    public static int CONTROL_WINDOW_VIEW_HAS_FOCUS = 1;
    public static int CONTROL_WINDOW_IS_TEXT_EDITOR = 2;
    public static int CONTROL_WINDOW_FIRST = 4;
    public static int CONTROL_START_INITIAL = 256;
    static long INPUT_METHOD_NOT_RESPONDING_TIMEOUT = 2500L;
    public static int DISPATCH_IN_PROGRESS = -1;
    public static int DISPATCH_NOT_HANDLED = 0;
    public static int DISPATCH_HANDLED = 1;
    public static int SHOW_IM_PICKER_MODE_AUTO = 0;
    public static int SHOW_IM_PICKER_MODE_INCLUDE_AUXILIARY_SUBTYPES = 1;
    public static int SHOW_IM_PICKER_MODE_EXCLUDE_AUXILIARY_SUBTYPES = 2;
    IInputMethodManager mService;
    Looper mMainLooper;
    H mH;
    IInputContext mIInputContext;
    boolean mActive;
    boolean mRestartOnNextWindowFocus;
    boolean mFullscreenMode;
    View mCurRootView;
    View mServedView;
    View mNextServedView;
    boolean mServedConnecting;
    EditorInfo mCurrentTextBoxAttribute;
    ControlledInputConnectionWrapper mServedInputConnectionWrapper;
    CompletionInfo[] mCompletions;
    Rect mTmpCursorRect;
    Rect mCursorRect;
    int mCursorSelStart;
    int mCursorSelEnd;
    int mCursorCandStart;
    int mCursorCandEnd;
    private static int NOT_AN_ACTION_NOTIFICATION_SEQUENCE_NUMBER = -1;
    private int mNextUserActionNotificationSequenceNumber;
    private int mLastSentUserActionNotificationSequenceNumber;
    private CursorAnchorInfo mCursorAnchorInfo;
    int mBindSequence;
    String mCurId;
    IInputMethodSession mCurMethod;
    InputChannel mCurChannel;
    ImeInputEventSender mCurSender;
    private static int REQUEST_UPDATE_CURSOR_ANCHOR_INFO_NONE = 0;
    private int mRequestUpdateCursorAnchorInfoMonitorMode;
    Pools.Pool<PendingEvent> mPendingEventPool;
    SparseArray<PendingEvent> mPendingEvents;
    static int MSG_DUMP = 1;
    static int MSG_BIND = 2;
    static int MSG_UNBIND = 3;
    static int MSG_SET_ACTIVE = 4;
    static int MSG_SEND_INPUT_EVENT = 5;
    static int MSG_TIMEOUT_INPUT_EVENT = 6;
    static int MSG_FLUSH_INPUT_EVENT = 7;
    static int MSG_SET_USER_ACTION_NOTIFICATION_SEQUENCE_NUMBER = 9;
    static int MSG_REPORT_FULLSCREEN_MODE = 10;
    IInputMethodClient.Stub mClient;
    InputConnection mDummyInputConnection;
    public static int SHOW_IMPLICIT = 1;
    public static int SHOW_FORCED = 2;
    public static int RESULT_UNCHANGED_SHOWN = 0;
    public static int RESULT_UNCHANGED_HIDDEN = 1;
    public static int RESULT_SHOWN = 2;
    public static int RESULT_HIDDEN = 3;
    public static int HIDE_IMPLICIT_ONLY = 1;
    public static int HIDE_NOT_ALWAYS = 2;

    private static final boolean $$robo$$android_view_inputmethod_InputMethodManager$isAutofillUIShowing(View servedView) {
        AutofillManager afm = servedView.getContext().getSystemService(AutofillManager.class);
        return afm != null && afm.isAutofillUiShowing();
    }

    private static final boolean $$robo$$android_view_inputmethod_InputMethodManager$canStartInput(View servedView) {
        return servedView.hasWindowFocus() || InputMethodManager.isAutofillUIShowing(servedView);
    }

    private void $$robo$$android_view_inputmethod_InputMethodManager$__constructor__(Looper looper) throws ServiceManager.ServiceNotFoundException {
    }

    private void $$robo$$android_view_inputmethod_InputMethodManager$__constructor__(IInputMethodManager service, Looper looper) {
        this.mActive = false;
        this.mRestartOnNextWindowFocus = true;
        this.mTmpCursorRect = new Rect();
        this.mCursorRect = new Rect();
        this.mNextUserActionNotificationSequenceNumber = -1;
        this.mLastSentUserActionNotificationSequenceNumber = -1;
        this.mCursorAnchorInfo = null;
        this.mBindSequence = -1;
        this.mRequestUpdateCursorAnchorInfoMonitorMode = 0;
        this.mPendingEventPool = new Pools.SimplePool<PendingEvent>(20);
        this.mPendingEvents = new SparseArray(20);
        this.mClient = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ InputMethodManager this$0;

            private void $$robo$$android_view_inputmethod_InputMethodManager_1$__constructor__(InputMethodManager this$0) {
            }

            private final void $$robo$$android_view_inputmethod_InputMethodManager_1$dump(FileDescriptor fd, PrintWriter fout, String[] args) {
                CountDownLatch latch = new CountDownLatch(1);
                SomeArgs sargs = SomeArgs.obtain();
                sargs.arg1 = fd;
                sargs.arg2 = fout;
                sargs.arg3 = args;
                sargs.arg4 = latch;
                this.this$0.mH.sendMessage(this.this$0.mH.obtainMessage(1, sargs));
                try {
                    if (!latch.await(5L, TimeUnit.SECONDS)) {
                        fout.println("Timeout waiting for dump");
                    }
                }
                catch (InterruptedException e) {
                    fout.println("Interrupted waiting for dump");
                }
            }

            private final void $$robo$$android_view_inputmethod_InputMethodManager_1$setUsingInputMethod(boolean state) {
            }

            private final void $$robo$$android_view_inputmethod_InputMethodManager_1$onBindMethod(InputBindResult res) {
                this.this$0.mH.obtainMessage(2, res).sendToTarget();
            }

            private final void $$robo$$android_view_inputmethod_InputMethodManager_1$onUnbindMethod(int sequence, int unbindReason) {
                this.this$0.mH.obtainMessage(3, sequence, unbindReason).sendToTarget();
            }

            private final void $$robo$$android_view_inputmethod_InputMethodManager_1$setActive(boolean active, boolean fullscreen) {
                this.this$0.mH.obtainMessage(4, active ? 1 : 0, fullscreen ? 1 : 0).sendToTarget();
            }

            private final void $$robo$$android_view_inputmethod_InputMethodManager_1$setUserActionNotificationSequenceNumber(int sequenceNumber) {
                this.this$0.mH.obtainMessage(9, sequenceNumber, 0).sendToTarget();
            }

            private final void $$robo$$android_view_inputmethod_InputMethodManager_1$reportFullscreenMode(boolean fullscreen) {
                this.this$0.mH.obtainMessage(10, fullscreen ? 1 : 0, 0).sendToTarget();
            }

            private void __constructor__(InputMethodManager inputMethodManager) {
                this.$$robo$$android_view_inputmethod_InputMethodManager_1$__constructor__(inputMethodManager);
            }
            {
                this.this$0 = inputMethodManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_InputMethodManager_1$__constructor__(android.view.inputmethod.InputMethodManager ), 0, this, inputMethodManager);
            }

            @Override
            protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
                InvokeDynamicSupport.bootstrap("dump", $$robo$$android_view_inputmethod_InputMethodManager_1$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
            }

            @Override
            public void setUsingInputMethod(boolean bl) {
                InvokeDynamicSupport.bootstrap("setUsingInputMethod", $$robo$$android_view_inputmethod_InputMethodManager_1$setUsingInputMethod(boolean ), 0, this, bl);
            }

            @Override
            public void onBindMethod(InputBindResult inputBindResult) {
                InvokeDynamicSupport.bootstrap("onBindMethod", $$robo$$android_view_inputmethod_InputMethodManager_1$onBindMethod(com.android.internal.view.InputBindResult ), 0, this, inputBindResult);
            }

            @Override
            public void onUnbindMethod(int n, int n2) {
                InvokeDynamicSupport.bootstrap("onUnbindMethod", $$robo$$android_view_inputmethod_InputMethodManager_1$onUnbindMethod(int int ), 0, this, n, n2);
            }

            @Override
            public void setActive(boolean bl, boolean bl2) {
                InvokeDynamicSupport.bootstrap("setActive", $$robo$$android_view_inputmethod_InputMethodManager_1$setActive(boolean boolean ), 0, this, bl, bl2);
            }

            @Override
            public void setUserActionNotificationSequenceNumber(int n) {
                InvokeDynamicSupport.bootstrap("setUserActionNotificationSequenceNumber", $$robo$$android_view_inputmethod_InputMethodManager_1$setUserActionNotificationSequenceNumber(int ), 0, this, n);
            }

            @Override
            public void reportFullscreenMode(boolean bl) {
                InvokeDynamicSupport.bootstrap("reportFullscreenMode", $$robo$$android_view_inputmethod_InputMethodManager_1$reportFullscreenMode(boolean ), 0, this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mDummyInputConnection = new BaseInputConnection(this, false);
        this.mService = service;
        this.mMainLooper = looper;
        this.mH = new H(this, looper);
        this.mIInputContext = new ControlledInputConnectionWrapper(looper, this.mDummyInputConnection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final InputMethodManager $$robo$$android_view_inputmethod_InputMethodManager$getInstance() {
        Class<InputMethodManager> clazz = InputMethodManager.class;
        synchronized (InputMethodManager.class) {
            if (sInstance == null) {
                try {
                    sInstance = new InputMethodManager(Looper.getMainLooper());
                }
                catch (ServiceManager.ServiceNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private static final InputMethodManager $$robo$$android_view_inputmethod_InputMethodManager$peekInstance() {
        return sInstance;
    }

    private final IInputMethodClient $$robo$$android_view_inputmethod_InputMethodManager$getClient() {
        return this.mClient;
    }

    private final IInputContext $$robo$$android_view_inputmethod_InputMethodManager$getInputContext() {
        return this.mIInputContext;
    }

    private final List<InputMethodInfo> $$robo$$android_view_inputmethod_InputMethodManager$getInputMethodList() {
        try {
            return this.mService.getInputMethodList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<InputMethodInfo> $$robo$$android_view_inputmethod_InputMethodManager$getVrInputMethodList() {
        try {
            return this.mService.getVrInputMethodList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<InputMethodInfo> $$robo$$android_view_inputmethod_InputMethodManager$getEnabledInputMethodList() {
        try {
            return this.mService.getEnabledInputMethodList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<InputMethodSubtype> $$robo$$android_view_inputmethod_InputMethodManager$getEnabledInputMethodSubtypeList(InputMethodInfo imi, boolean allowsImplicitlySelectedSubtypes) {
        try {
            return this.mService.getEnabledInputMethodSubtypeList(imi == null ? null : imi.getId(), allowsImplicitlySelectedSubtypes);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_view_inputmethod_InputMethodManager$showStatusIcon(IBinder imeToken, String packageName, int iconId) {
        this.showStatusIconInternal(imeToken, packageName, iconId);
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$showStatusIconInternal(IBinder imeToken, String packageName, int iconId) {
        try {
            this.mService.updateStatusIcon(imeToken, packageName, iconId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_view_inputmethod_InputMethodManager$hideStatusIcon(IBinder imeToken) {
        this.hideStatusIconInternal(imeToken);
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$hideStatusIconInternal(IBinder imeToken) {
        try {
            this.mService.updateStatusIcon(imeToken, null, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$setImeWindowStatus(IBinder imeToken, IBinder startInputToken, int vis, int backDisposition) {
        try {
            this.mService.setImeWindowStatus(imeToken, startInputToken, vis, backDisposition);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$registerSuggestionSpansForNotification(SuggestionSpan[] spans) {
        try {
            this.mService.registerSuggestionSpansForNotification(spans);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$notifySuggestionPicked(SuggestionSpan span, String originalString, int index) {
        try {
            this.mService.notifySuggestionPicked(span, originalString, index);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_inputmethod_InputMethodManager$isFullscreenMode() {
        H h = this.mH;
        synchronized (h) {
            return this.mFullscreenMode;
        }
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$reportFullscreenMode(IBinder token, boolean fullscreen) {
        try {
            this.mService.reportFullscreenMode(token, fullscreen);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_inputmethod_InputMethodManager$isActive(View view) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            return (this.mServedView == view || this.mServedView != null && this.mServedView.checkInputConnectionProxy(view)) && this.mCurrentTextBoxAttribute != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_inputmethod_InputMethodManager$isActive() {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            return this.mServedView != null && this.mCurrentTextBoxAttribute != null;
        }
    }

    private final boolean $$robo$$android_view_inputmethod_InputMethodManager$isAcceptingText() {
        this.checkFocus();
        return this.mServedInputConnectionWrapper != null && this.mServedInputConnectionWrapper.getInputConnection() != null;
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$clearBindingLocked() {
        this.clearConnectionLocked();
        this.setInputChannelLocked(null);
        this.mBindSequence = -1;
        this.mCurId = null;
        this.mCurMethod = null;
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$setInputChannelLocked(InputChannel channel) {
        if (this.mCurChannel != channel) {
            if (this.mCurSender != null) {
                this.flushPendingEventsLocked();
                this.mCurSender.dispose();
                this.mCurSender = null;
            }
            if (this.mCurChannel != null) {
                this.mCurChannel.dispose();
            }
            this.mCurChannel = channel;
        }
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$clearConnectionLocked() {
        this.mCurrentTextBoxAttribute = null;
        if (this.mServedInputConnectionWrapper != null) {
            this.mServedInputConnectionWrapper.deactivate();
            this.mServedInputConnectionWrapper = null;
        }
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$finishInputLocked() {
        this.mNextServedView = null;
        if (this.mServedView != null) {
            if (this.mCurrentTextBoxAttribute != null) {
                try {
                    this.mService.finishInput(this.mClient);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            this.mServedView = null;
            this.mCompletions = null;
            this.mServedConnecting = false;
            this.clearConnectionLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$displayCompletions(View view, CompletionInfo[] completions) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!(this.mServedView == view || this.mServedView != null && this.mServedView.checkInputConnectionProxy(view))) {
                return;
            }
            this.mCompletions = completions;
            if (this.mCurMethod != null) {
                try {
                    this.mCurMethod.displayCompletions(this.mCompletions);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$updateExtractedText(View view, int token, ExtractedText text) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!(this.mServedView == view || this.mServedView != null && this.mServedView.checkInputConnectionProxy(view))) {
                return;
            }
            if (this.mCurMethod != null) {
                try {
                    this.mCurMethod.updateExtractedText(token, text);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    private final boolean $$robo$$android_view_inputmethod_InputMethodManager$showSoftInput(View view, int flags) {
        return this.showSoftInput(view, flags, null);
    }

    private final boolean $$robo$$android_view_inputmethod_InputMethodManager$showSoftInput(View view, int flags, ResultReceiver resultReceiver) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!(this.mServedView == view || this.mServedView != null && this.mServedView.checkInputConnectionProxy(view))) {
                return false;
            }
            try {
                return this.mService.showSoftInput(this.mClient, flags, resultReceiver);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    private final void $$robo$$android_view_inputmethod_InputMethodManager$showSoftInputUnchecked(int flags, ResultReceiver resultReceiver) {
        try {
            Log.w("InputMethodManager", "showSoftInputUnchecked() is a hidden method, which will be removed soon. If you are using android.support.v7.widget.SearchView, please update to version 26.0 or newer version.");
            this.mService.showSoftInput(this.mClient, flags, resultReceiver);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_view_inputmethod_InputMethodManager$hideSoftInputFromWindow(IBinder windowToken, int flags) {
        return this.hideSoftInputFromWindow(windowToken, flags, null);
    }

    private final boolean $$robo$$android_view_inputmethod_InputMethodManager$hideSoftInputFromWindow(IBinder windowToken, int flags, ResultReceiver resultReceiver) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView == null || this.mServedView.getWindowToken() != windowToken) {
                return false;
            }
            try {
                return this.mService.hideSoftInput(this.mClient, flags, resultReceiver);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$toggleSoftInputFromWindow(IBinder windowToken, int showFlags, int hideFlags) {
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView == null || this.mServedView.getWindowToken() != windowToken) {
                return;
            }
            if (this.mCurMethod != null) {
                try {
                    this.mCurMethod.toggleSoftInput(showFlags, hideFlags);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$toggleSoftInput(int showFlags, int hideFlags) {
        if (this.mCurMethod != null) {
            try {
                this.mCurMethod.toggleSoftInput(showFlags, hideFlags);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$restartInput(View view) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!(this.mServedView == view || this.mServedView != null && this.mServedView.checkInputConnectionProxy(view))) {
                return;
            }
            this.mServedConnecting = true;
        }
        this.startInputInner(3, null, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_inputmethod_InputMethodManager$startInputInner(int startInputReason, IBinder windowGainingFocus, int controlFlags, int softInputMode, int windowFlags) {
        View view;
        H h = this.mH;
        synchronized (h) {
            view = this.mServedView;
            if (view == null) {
                return false;
            }
        }
        Handler vh = view.getHandler();
        if (vh == null) {
            this.closeCurrentInput();
            return false;
        }
        if (vh.getLooper() != Looper.myLooper()) {
            vh.post(() -> this.startInputInner(startInputReason, null, 0, 0, 0));
            return false;
        }
        EditorInfo tba = new EditorInfo();
        tba.packageName = view.getContext().getOpPackageName();
        tba.fieldId = view.getId();
        InputConnection ic = view.onCreateInputConnection(tba);
        H h2 = this.mH;
        synchronized (h2) {
            ControlledInputConnectionWrapper servedContext;
            int missingMethodFlags;
            if (this.mServedView != view || !this.mServedConnecting) {
                return false;
            }
            if (this.mCurrentTextBoxAttribute == null) {
                controlFlags |= 0x100;
            }
            this.mCurrentTextBoxAttribute = tba;
            this.mServedConnecting = false;
            if (this.mServedInputConnectionWrapper != null) {
                this.mServedInputConnectionWrapper.deactivate();
                this.mServedInputConnectionWrapper = null;
            }
            if (ic != null) {
                this.mCursorSelStart = tba.initialSelStart;
                this.mCursorSelEnd = tba.initialSelEnd;
                this.mCursorCandStart = -1;
                this.mCursorCandEnd = -1;
                this.mCursorRect.setEmpty();
                this.mCursorAnchorInfo = null;
                missingMethodFlags = InputConnectionInspector.getMissingMethodFlags(ic);
                Handler icHandler = (missingMethodFlags & 0x20) != 0 ? null : ic.getHandler();
                servedContext = new ControlledInputConnectionWrapper(icHandler != null ? icHandler.getLooper() : vh.getLooper(), ic, this);
            } else {
                servedContext = null;
                missingMethodFlags = 0;
            }
            this.mServedInputConnectionWrapper = servedContext;
            try {
                InputBindResult res = this.mService.startInputOrWindowGainedFocus(startInputReason, this.mClient, windowGainingFocus, controlFlags, softInputMode, windowFlags, tba, servedContext, missingMethodFlags, view.getContext().getApplicationInfo().targetSdkVersion);
                if (res == null) {
                    Log.wtf("InputMethodManager", "startInputOrWindowGainedFocus must not return null. startInputReason=" + InputMethodClient.getStartInputReason(startInputReason) + " editorInfo=" + tba + " controlFlags=#" + Integer.toHexString(controlFlags));
                    return false;
                }
                if (res.id != null) {
                    this.setInputChannelLocked(res.channel);
                    this.mBindSequence = res.sequence;
                    this.mCurMethod = res.method;
                    this.mCurId = res.id;
                    this.mNextUserActionNotificationSequenceNumber = res.userActionNotificationSequenceNumber;
                } else if (res.channel != null && res.channel != this.mCurChannel) {
                    res.channel.dispose();
                }
                switch (res.result) {
                    case 11: {
                        this.mRestartOnNextWindowFocus = true;
                    }
                }
                if (this.mCurMethod != null && this.mCompletions != null) {
                    try {
                        this.mCurMethod.displayCompletions(this.mCompletions);
                    }
                    catch (RemoteException remoteException) {}
                }
            }
            catch (RemoteException e) {
                Log.w("InputMethodManager", "IME died: " + this.mCurId, e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$windowDismissed(IBinder appWindowToken) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != null && this.mServedView.getWindowToken() == appWindowToken) {
                this.finishInputLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$focusIn(View view) {
        H h = this.mH;
        synchronized (h) {
            this.focusInLocked(view);
        }
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$focusInLocked(View view) {
        if (view != null && view.isTemporarilyDetached()) {
            return;
        }
        if (this.mCurRootView != view.getRootView()) {
            return;
        }
        this.mNextServedView = view;
        InputMethodManager.scheduleCheckFocusLocked(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$focusOut(View view) {
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != view) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$onViewDetachedFromWindow(View view) {
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView == view) {
                this.mNextServedView = null;
                InputMethodManager.scheduleCheckFocusLocked(view);
            }
        }
    }

    private static final void $$robo$$android_view_inputmethod_InputMethodManager$scheduleCheckFocusLocked(View view) {
        ViewRootImpl viewRootImpl = view.getViewRootImpl();
        if (viewRootImpl != null) {
            viewRootImpl.dispatchCheckFocus();
        }
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$checkFocus() {
        if (this.checkFocusNoStartInput(false)) {
            this.startInputInner(4, null, 0, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_inputmethod_InputMethodManager$checkFocusNoStartInput(boolean forceNewFocus) {
        ControlledInputConnectionWrapper ic;
        if (this.mServedView == this.mNextServedView && !forceNewFocus) {
            return false;
        }
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView == this.mNextServedView && !forceNewFocus) {
                return false;
            }
            if (this.mNextServedView == null) {
                this.finishInputLocked();
                this.closeCurrentInput();
                return false;
            }
            ic = this.mServedInputConnectionWrapper;
            this.mServedView = this.mNextServedView;
            this.mCurrentTextBoxAttribute = null;
            this.mCompletions = null;
            this.mServedConnecting = true;
        }
        if (ic != null) {
            ic.finishComposingText();
        }
        return true;
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$closeCurrentInput() {
        try {
            this.mService.hideSoftInput(this.mClient, 2, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$onPostWindowFocus(View rootView, View focusedView, int softInputMode, boolean first, int windowFlags) {
        boolean forceNewFocus = false;
        H h = this.mH;
        synchronized (h) {
            if (this.mRestartOnNextWindowFocus) {
                this.mRestartOnNextWindowFocus = false;
                forceNewFocus = true;
            }
            this.focusInLocked(focusedView != null ? focusedView : rootView);
        }
        int controlFlags = 0;
        if (focusedView != null) {
            controlFlags |= 1;
            if (focusedView.onCheckIsTextEditor()) {
                controlFlags |= 2;
            }
        }
        if (first) {
            controlFlags |= 4;
        }
        if (this.checkFocusNoStartInput(forceNewFocus) && this.startInputInner(1, rootView.getWindowToken(), controlFlags, softInputMode, windowFlags)) {
            return;
        }
        H h2 = this.mH;
        synchronized (h2) {
            try {
                this.mService.startInputOrWindowGainedFocus(2, this.mClient, rootView.getWindowToken(), controlFlags, softInputMode, windowFlags, null, null, 0, rootView.getContext().getApplicationInfo().targetSdkVersion);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$onPreWindowFocus(View rootView, boolean hasWindowFocus) {
        H h = this.mH;
        synchronized (h) {
            if (rootView == null) {
                this.mCurRootView = null;
            }
            if (hasWindowFocus) {
                this.mCurRootView = rootView;
            } else if (rootView == this.mCurRootView) {
                this.mCurRootView = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$updateSelection(View view, int selStart, int selEnd, int candidatesStart, int candidatesEnd) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != view && (this.mServedView == null || !this.mServedView.checkInputConnectionProxy(view)) || this.mCurrentTextBoxAttribute == null || this.mCurMethod == null) {
                return;
            }
            if (this.mCursorSelStart != selStart || this.mCursorSelEnd != selEnd || this.mCursorCandStart != candidatesStart || this.mCursorCandEnd != candidatesEnd) {
                try {
                    int oldSelStart = this.mCursorSelStart;
                    int oldSelEnd = this.mCursorSelEnd;
                    this.mCursorSelStart = selStart;
                    this.mCursorSelEnd = selEnd;
                    this.mCursorCandStart = candidatesStart;
                    this.mCursorCandEnd = candidatesEnd;
                    this.mCurMethod.updateSelection(oldSelStart, oldSelEnd, selStart, selEnd, candidatesStart, candidatesEnd);
                }
                catch (RemoteException e) {
                    Log.w("InputMethodManager", "IME died: " + this.mCurId, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$viewClicked(View view) {
        boolean focusChanged = this.mServedView != this.mNextServedView;
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != view && (this.mServedView == null || !this.mServedView.checkInputConnectionProxy(view)) || this.mCurrentTextBoxAttribute == null || this.mCurMethod == null) {
                return;
            }
            try {
                this.mCurMethod.viewClicked(focusChanged);
            }
            catch (RemoteException e) {
                Log.w("InputMethodManager", "IME died: " + this.mCurId, e);
            }
        }
    }

    @Deprecated
    private final boolean $$robo$$android_view_inputmethod_InputMethodManager$isWatchingCursor(View view) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_inputmethod_InputMethodManager$isCursorAnchorInfoEnabled() {
        H h = this.mH;
        synchronized (h) {
            boolean isImmediate = (this.mRequestUpdateCursorAnchorInfoMonitorMode & 1) != 0;
            boolean isMonitoring = (this.mRequestUpdateCursorAnchorInfoMonitorMode & 2) != 0;
            return isImmediate || isMonitoring;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$setUpdateCursorAnchorInfoMode(int flags) {
        H h = this.mH;
        synchronized (h) {
            this.mRequestUpdateCursorAnchorInfoMonitorMode = flags;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final void $$robo$$android_view_inputmethod_InputMethodManager$updateCursor(View view, int left, int top, int right, int bottom) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != view && (this.mServedView == null || !this.mServedView.checkInputConnectionProxy(view)) || this.mCurrentTextBoxAttribute == null || this.mCurMethod == null) {
                return;
            }
            this.mTmpCursorRect.set(left, top, right, bottom);
            if (!this.mCursorRect.equals(this.mTmpCursorRect)) {
                try {
                    this.mCurMethod.updateCursor(this.mTmpCursorRect);
                    this.mCursorRect.set(this.mTmpCursorRect);
                }
                catch (RemoteException e) {
                    Log.w("InputMethodManager", "IME died: " + this.mCurId, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$updateCursorAnchorInfo(View view, CursorAnchorInfo cursorAnchorInfo) {
        if (view == null || cursorAnchorInfo == null) {
            return;
        }
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            boolean isImmediate;
            if (this.mServedView != view && (this.mServedView == null || !this.mServedView.checkInputConnectionProxy(view)) || this.mCurrentTextBoxAttribute == null || this.mCurMethod == null) {
                return;
            }
            boolean bl = isImmediate = (this.mRequestUpdateCursorAnchorInfoMonitorMode & 1) != 0;
            if (!isImmediate && Objects.equals(this.mCursorAnchorInfo, cursorAnchorInfo)) {
                return;
            }
            try {
                this.mCurMethod.updateCursorAnchorInfo(cursorAnchorInfo);
                this.mCursorAnchorInfo = cursorAnchorInfo;
                this.mRequestUpdateCursorAnchorInfoMonitorMode &= 0xFFFFFFFE;
            }
            catch (RemoteException e) {
                Log.w("InputMethodManager", "IME died: " + this.mCurId, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$sendAppPrivateCommand(View view, String action, Bundle data) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != view && (this.mServedView == null || !this.mServedView.checkInputConnectionProxy(view)) || this.mCurrentTextBoxAttribute == null || this.mCurMethod == null) {
                return;
            }
            try {
                this.mCurMethod.appPrivateCommand(action, data);
            }
            catch (RemoteException e) {
                Log.w("InputMethodManager", "IME died: " + this.mCurId, e);
            }
        }
    }

    @Deprecated
    private final void $$robo$$android_view_inputmethod_InputMethodManager$setInputMethod(IBinder token, String id2) {
        this.setInputMethodInternal(token, id2);
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$setInputMethodInternal(IBinder token, String id2) {
        try {
            this.mService.setInputMethod(token, id2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_view_inputmethod_InputMethodManager$setInputMethodAndSubtype(IBinder token, String id2, InputMethodSubtype subtype) {
        this.setInputMethodAndSubtypeInternal(token, id2, subtype);
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$setInputMethodAndSubtypeInternal(IBinder token, String id2, InputMethodSubtype subtype) {
        try {
            this.mService.setInputMethodAndSubtype(token, id2, subtype);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_view_inputmethod_InputMethodManager$hideSoftInputFromInputMethod(IBinder token, int flags) {
        this.hideSoftInputFromInputMethodInternal(token, flags);
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$hideSoftInputFromInputMethodInternal(IBinder token, int flags) {
        try {
            this.mService.hideMySoftInput(token, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_view_inputmethod_InputMethodManager$showSoftInputFromInputMethod(IBinder token, int flags) {
        this.showSoftInputFromInputMethodInternal(token, flags);
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$showSoftInputFromInputMethodInternal(IBinder token, int flags) {
        try {
            this.mService.showMySoftInput(token, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_view_inputmethod_InputMethodManager$dispatchInputEvent(InputEvent event, Object token, FinishedInputEventCallback callback, Handler handler) {
        H h = this.mH;
        synchronized (h) {
            if (this.mCurMethod != null) {
                KeyEvent keyEvent;
                if (event instanceof KeyEvent && (keyEvent = (KeyEvent)event).getAction() == 0 && keyEvent.getKeyCode() == 63 && keyEvent.getRepeatCount() == 0) {
                    this.showInputMethodPickerLocked();
                    return 1;
                }
                PendingEvent p = this.obtainPendingEventLocked(event, token, this.mCurId, callback, handler);
                if (this.mMainLooper.isCurrentThread()) {
                    return this.sendInputEventOnMainLooperLocked(p);
                }
                Message msg = this.mH.obtainMessage(5, p);
                msg.setAsynchronous(true);
                this.mH.sendMessage(msg);
                return -1;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$dispatchKeyEventFromInputMethod(View targetView, KeyEvent event) {
        H h = this.mH;
        synchronized (h) {
            ViewRootImpl viewRootImpl;
            ViewRootImpl viewRootImpl2 = viewRootImpl = targetView != null ? targetView.getViewRootImpl() : null;
            if (viewRootImpl == null && this.mServedView != null) {
                viewRootImpl = this.mServedView.getViewRootImpl();
            }
            if (viewRootImpl != null) {
                viewRootImpl.dispatchKeyFromIme(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$sendInputEventAndReportResultOnMainLooper(PendingEvent p) {
        boolean handled;
        H h = this.mH;
        synchronized (h) {
            int result = this.sendInputEventOnMainLooperLocked(p);
            if (result == -1) {
                return;
            }
            handled = result == 1;
        }
        this.invokeFinishedInputEventCallback(p, handled);
    }

    private final int $$robo$$android_view_inputmethod_InputMethodManager$sendInputEventOnMainLooperLocked(PendingEvent p) {
        if (this.mCurChannel != null) {
            InputEvent event;
            int seq;
            if (this.mCurSender == null) {
                this.mCurSender = new ImeInputEventSender(this, this.mCurChannel, this.mH.getLooper());
            }
            if (this.mCurSender.sendInputEvent(seq = (event = p.mEvent).getSequenceNumber(), event)) {
                this.mPendingEvents.put(seq, p);
                Trace.traceCounter(4L, "aq:imm", this.mPendingEvents.size());
                Message msg = this.mH.obtainMessage(6, seq, 0, p);
                msg.setAsynchronous(true);
                this.mH.sendMessageDelayed(msg, 2500L);
                return -1;
            }
            Log.w("InputMethodManager", "Unable to send input event to IME: " + this.mCurId + " dropping: " + event);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$finishedInputEvent(int seq, boolean handled, boolean timeout) {
        PendingEvent p;
        H h = this.mH;
        synchronized (h) {
            int index = this.mPendingEvents.indexOfKey(seq);
            if (index < 0) {
                return;
            }
            p = this.mPendingEvents.valueAt(index);
            this.mPendingEvents.removeAt(index);
            Trace.traceCounter(4L, "aq:imm", this.mPendingEvents.size());
            if (timeout) {
                Log.w("InputMethodManager", "Timeout waiting for IME to handle input event after 2500 ms: " + p.mInputMethodId);
            } else {
                this.mH.removeMessages(6, p);
            }
        }
        this.invokeFinishedInputEventCallback(p, handled);
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$invokeFinishedInputEventCallback(PendingEvent p, boolean handled) {
        p.mHandled = handled;
        if (p.mHandler.getLooper().isCurrentThread()) {
            p.run();
        } else {
            Message msg = Message.obtain(p.mHandler, p);
            msg.setAsynchronous(true);
            msg.sendToTarget();
        }
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$flushPendingEventsLocked() {
        this.mH.removeMessages(7);
        int count = this.mPendingEvents.size();
        for (int i = 0; i < count; ++i) {
            int seq = this.mPendingEvents.keyAt(i);
            Message msg = this.mH.obtainMessage(7, seq, 0);
            msg.setAsynchronous(true);
            msg.sendToTarget();
        }
    }

    private final PendingEvent $$robo$$android_view_inputmethod_InputMethodManager$obtainPendingEventLocked(InputEvent event, Object token, String inputMethodId, FinishedInputEventCallback callback, Handler handler) {
        PendingEvent p = this.mPendingEventPool.acquire();
        if (p == null) {
            p = new PendingEvent(this);
        }
        p.mEvent = event;
        p.mToken = token;
        p.mInputMethodId = inputMethodId;
        p.mCallback = callback;
        p.mHandler = handler;
        return p;
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$recyclePendingEventLocked(PendingEvent p) {
        p.recycle();
        this.mPendingEventPool.release(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$showInputMethodPicker() {
        H h = this.mH;
        synchronized (h) {
            this.showInputMethodPickerLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$showInputMethodPicker(boolean showAuxiliarySubtypes) {
        H h = this.mH;
        synchronized (h) {
            try {
                int mode = showAuxiliarySubtypes ? 1 : 2;
                this.mService.showInputMethodPickerFromClient(this.mClient, mode);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$showInputMethodPickerLocked() {
        try {
            this.mService.showInputMethodPickerFromClient(this.mClient, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_view_inputmethod_InputMethodManager$isInputMethodPickerShown() {
        try {
            return this.mService.isInputMethodPickerShownForTest();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$showInputMethodAndSubtypeEnabler(String imiId) {
        H h = this.mH;
        synchronized (h) {
            try {
                this.mService.showInputMethodAndSubtypeEnablerFromClient(this.mClient, imiId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final InputMethodSubtype $$robo$$android_view_inputmethod_InputMethodManager$getCurrentInputMethodSubtype() {
        try {
            return this.mService.getCurrentInputMethodSubtype();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_view_inputmethod_InputMethodManager$setCurrentInputMethodSubtype(InputMethodSubtype subtype) {
        H h = this.mH;
        synchronized (h) {
            try {
                return this.mService.setCurrentInputMethodSubtype(subtype);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$notifyUserAction() {
        H h = this.mH;
        synchronized (h) {
            if (this.mLastSentUserActionNotificationSequenceNumber == this.mNextUserActionNotificationSequenceNumber) {
                return;
            }
            try {
                this.mService.notifyUserAction(this.mNextUserActionNotificationSequenceNumber);
                this.mLastSentUserActionNotificationSequenceNumber = this.mNextUserActionNotificationSequenceNumber;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<InputMethodInfo, List<InputMethodSubtype>> $$robo$$android_view_inputmethod_InputMethodManager$getShortcutInputMethodsAndSubtypes() {
        H h = this.mH;
        synchronized (h) {
            HashMap<InputMethodInfo, List<InputMethodSubtype>> ret;
            block8: {
                ret = new HashMap<InputMethodInfo, List<InputMethodSubtype>>();
                try {
                    List info = this.mService.getShortcutInputMethodsAndSubtypes();
                    ArrayList<InputMethodSubtype> subtypes = null;
                    if (info == null || info.isEmpty()) break block8;
                    int N = info.size();
                    for (int i = 0; i < N; ++i) {
                        Object o = info.get(i);
                        if (o instanceof InputMethodInfo) {
                            if (ret.containsKey(o)) {
                                Log.e("InputMethodManager", "IMI list already contains the same InputMethod.");
                                break;
                            }
                            subtypes = new ArrayList<InputMethodSubtype>();
                            ret.put((InputMethodInfo)o, subtypes);
                            continue;
                        }
                        if (subtypes == null || !(o instanceof InputMethodSubtype)) continue;
                        subtypes.add((InputMethodSubtype)o);
                    }
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            return ret;
        }
    }

    private final int $$robo$$android_view_inputmethod_InputMethodManager$getInputMethodWindowVisibleHeight() {
        H h = this.mH;
        synchronized (h) {
            try {
                return this.mService.getInputMethodWindowVisibleHeight();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$clearLastInputMethodWindowForTransition(IBinder token) {
        H h = this.mH;
        synchronized (h) {
            try {
                this.mService.clearLastInputMethodWindowForTransition(token);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    private final boolean $$robo$$android_view_inputmethod_InputMethodManager$switchToLastInputMethod(IBinder imeToken) {
        return this.switchToPreviousInputMethodInternal(imeToken);
    }

    private final boolean $$robo$$android_view_inputmethod_InputMethodManager$switchToPreviousInputMethodInternal(IBinder imeToken) {
        H h = this.mH;
        synchronized (h) {
            try {
                return this.mService.switchToPreviousInputMethod(imeToken);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    private final boolean $$robo$$android_view_inputmethod_InputMethodManager$switchToNextInputMethod(IBinder imeToken, boolean onlyCurrentIme) {
        return this.switchToNextInputMethodInternal(imeToken, onlyCurrentIme);
    }

    private final boolean $$robo$$android_view_inputmethod_InputMethodManager$switchToNextInputMethodInternal(IBinder imeToken, boolean onlyCurrentIme) {
        H h = this.mH;
        synchronized (h) {
            try {
                return this.mService.switchToNextInputMethod(imeToken, onlyCurrentIme);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    private final boolean $$robo$$android_view_inputmethod_InputMethodManager$shouldOfferSwitchingToNextInputMethod(IBinder imeToken) {
        return this.shouldOfferSwitchingToNextInputMethodInternal(imeToken);
    }

    private final boolean $$robo$$android_view_inputmethod_InputMethodManager$shouldOfferSwitchingToNextInputMethodInternal(IBinder imeToken) {
        H h = this.mH;
        synchronized (h) {
            try {
                return this.mService.shouldOfferSwitchingToNextInputMethod(imeToken);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodManager$setAdditionalInputMethodSubtypes(String imiId, InputMethodSubtype[] subtypes) {
        H h = this.mH;
        synchronized (h) {
            try {
                this.mService.setAdditionalInputMethodSubtypes(imiId, subtypes);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final InputMethodSubtype $$robo$$android_view_inputmethod_InputMethodManager$getLastInputMethodSubtype() {
        H h = this.mH;
        synchronized (h) {
            try {
                return this.mService.getLastInputMethodSubtype();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$exposeContent(IBinder token, InputContentInfo inputContentInfo, EditorInfo editorInfo) {
        IInputContentUriToken uriToken;
        Uri contentUri = inputContentInfo.getContentUri();
        try {
            uriToken = this.mService.createInputContentUriToken(token, contentUri, editorInfo.packageName);
            if (uriToken == null) {
                return;
            }
        }
        catch (RemoteException e) {
            Log.e("InputMethodManager", "createInputContentAccessToken failed. contentUri=" + contentUri.toString() + " packageName=" + editorInfo.packageName, e);
            return;
        }
        inputContentInfo.setUriToken(uriToken);
    }

    private final void $$robo$$android_view_inputmethod_InputMethodManager$doDump(FileDescriptor fd, PrintWriter fout, String[] args) {
        PrintWriterPrinter p = new PrintWriterPrinter(fout);
        p.println("Input method client state for " + this + ":");
        p.println("  mService=" + this.mService);
        p.println("  mMainLooper=" + this.mMainLooper);
        p.println("  mIInputContext=" + this.mIInputContext);
        p.println("  mActive=" + this.mActive + " mRestartOnNextWindowFocus=" + this.mRestartOnNextWindowFocus + " mBindSequence=" + this.mBindSequence + " mCurId=" + this.mCurId);
        p.println("  mFullscreenMode=" + this.mFullscreenMode);
        p.println("  mCurMethod=" + this.mCurMethod);
        p.println("  mCurRootView=" + this.mCurRootView);
        p.println("  mServedView=" + this.mServedView);
        p.println("  mNextServedView=" + this.mNextServedView);
        p.println("  mServedConnecting=" + this.mServedConnecting);
        if (this.mCurrentTextBoxAttribute != null) {
            p.println("  mCurrentTextBoxAttribute:");
            this.mCurrentTextBoxAttribute.dump(p, "    ");
        } else {
            p.println("  mCurrentTextBoxAttribute: null");
        }
        p.println("  mServedInputConnectionWrapper=" + this.mServedInputConnectionWrapper);
        p.println("  mCompletions=" + Arrays.toString(this.mCompletions));
        p.println("  mCursorRect=" + this.mCursorRect);
        p.println("  mCursorSelStart=" + this.mCursorSelStart + " mCursorSelEnd=" + this.mCursorSelEnd + " mCursorCandStart=" + this.mCursorCandStart + " mCursorCandEnd=" + this.mCursorCandEnd);
        p.println("  mNextUserActionNotificationSequenceNumber=" + this.mNextUserActionNotificationSequenceNumber + " mLastSentUserActionNotificationSequenceNumber=" + this.mLastSentUserActionNotificationSequenceNumber);
    }

    private static final String $$robo$$android_view_inputmethod_InputMethodManager$dumpViewInfo(View view) {
        if (view == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(view);
        sb.append(",focus=" + view.hasFocus());
        sb.append(",windowFocus=" + view.hasWindowFocus());
        sb.append(",autofillUiShowing=" + InputMethodManager.isAutofillUIShowing(view));
        sb.append(",window=" + view.getWindowToken());
        sb.append(",temporaryDetach=" + view.isTemporarilyDetached());
        return sb.toString();
    }

    private static boolean isAutofillUIShowing(View view) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAutofillUIShowing", $$robo$$android_view_inputmethod_InputMethodManager$isAutofillUIShowing(android.view.View ), 0, (View)view);
    }

    private static boolean canStartInput(View view) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("canStartInput", $$robo$$android_view_inputmethod_InputMethodManager$canStartInput(android.view.View ), 0, (View)view);
    }

    private void __constructor__(Looper looper) throws ServiceManager.ServiceNotFoundException {
        this.$$robo$$android_view_inputmethod_InputMethodManager$__constructor__(looper);
    }

    InputMethodManager(Looper looper) throws ServiceManager.ServiceNotFoundException {
        this(IInputMethodManager.Stub.asInterface(ServiceManager.getServiceOrThrow("input_method")), looper);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_InputMethodManager$__constructor__(android.os.Looper ), 0, this, looper);
    }

    private void __constructor__(IInputMethodManager iInputMethodManager, Looper looper) {
        this.$$robo$$android_view_inputmethod_InputMethodManager$__constructor__(iInputMethodManager, looper);
    }

    InputMethodManager(IInputMethodManager iInputMethodManager, Looper looper) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_InputMethodManager$__constructor__(com.android.internal.view.IInputMethodManager android.os.Looper ), 0, this, iInputMethodManager, looper);
    }

    public static InputMethodManager getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_view_inputmethod_InputMethodManager$getInstance(), 0);
    }

    public static InputMethodManager peekInstance() {
        return InvokeDynamicSupport.bootstrapStatic("peekInstance", $$robo$$android_view_inputmethod_InputMethodManager$peekInstance(), 0);
    }

    public IInputMethodClient getClient() {
        return InvokeDynamicSupport.bootstrap("getClient", $$robo$$android_view_inputmethod_InputMethodManager$getClient(), 0, this);
    }

    public IInputContext getInputContext() {
        return InvokeDynamicSupport.bootstrap("getInputContext", $$robo$$android_view_inputmethod_InputMethodManager$getInputContext(), 0, this);
    }

    public List<InputMethodInfo> getInputMethodList() {
        return InvokeDynamicSupport.bootstrap("getInputMethodList", $$robo$$android_view_inputmethod_InputMethodManager$getInputMethodList(), 0, this);
    }

    public List<InputMethodInfo> getVrInputMethodList() {
        return InvokeDynamicSupport.bootstrap("getVrInputMethodList", $$robo$$android_view_inputmethod_InputMethodManager$getVrInputMethodList(), 0, this);
    }

    public List<InputMethodInfo> getEnabledInputMethodList() {
        return InvokeDynamicSupport.bootstrap("getEnabledInputMethodList", $$robo$$android_view_inputmethod_InputMethodManager$getEnabledInputMethodList(), 0, this);
    }

    public List<InputMethodSubtype> getEnabledInputMethodSubtypeList(InputMethodInfo inputMethodInfo, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getEnabledInputMethodSubtypeList", $$robo$$android_view_inputmethod_InputMethodManager$getEnabledInputMethodSubtypeList(android.view.inputmethod.InputMethodInfo boolean ), 0, this, inputMethodInfo, bl);
    }

    @Deprecated
    public void showStatusIcon(IBinder iBinder, String string2, int n) {
        InvokeDynamicSupport.bootstrap("showStatusIcon", $$robo$$android_view_inputmethod_InputMethodManager$showStatusIcon(android.os.IBinder java.lang.String int ), 0, this, iBinder, string2, n);
    }

    public void showStatusIconInternal(IBinder iBinder, String string2, int n) {
        InvokeDynamicSupport.bootstrap("showStatusIconInternal", $$robo$$android_view_inputmethod_InputMethodManager$showStatusIconInternal(android.os.IBinder java.lang.String int ), 0, this, iBinder, string2, n);
    }

    @Deprecated
    public void hideStatusIcon(IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("hideStatusIcon", $$robo$$android_view_inputmethod_InputMethodManager$hideStatusIcon(android.os.IBinder ), 0, this, iBinder);
    }

    public void hideStatusIconInternal(IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("hideStatusIconInternal", $$robo$$android_view_inputmethod_InputMethodManager$hideStatusIconInternal(android.os.IBinder ), 0, this, iBinder);
    }

    public void setImeWindowStatus(IBinder iBinder, IBinder iBinder2, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setImeWindowStatus", $$robo$$android_view_inputmethod_InputMethodManager$setImeWindowStatus(android.os.IBinder android.os.IBinder int int ), 0, this, iBinder, iBinder2, n, n2);
    }

    public void registerSuggestionSpansForNotification(SuggestionSpan[] suggestionSpanArray) {
        InvokeDynamicSupport.bootstrap("registerSuggestionSpansForNotification", $$robo$$android_view_inputmethod_InputMethodManager$registerSuggestionSpansForNotification(android.text.style.SuggestionSpan[] ), 0, this, suggestionSpanArray);
    }

    public void notifySuggestionPicked(SuggestionSpan suggestionSpan, String string2, int n) {
        InvokeDynamicSupport.bootstrap("notifySuggestionPicked", $$robo$$android_view_inputmethod_InputMethodManager$notifySuggestionPicked(android.text.style.SuggestionSpan java.lang.String int ), 0, this, suggestionSpan, string2, n);
    }

    public boolean isFullscreenMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFullscreenMode", $$robo$$android_view_inputmethod_InputMethodManager$isFullscreenMode(), 0, this);
    }

    public void reportFullscreenMode(IBinder iBinder, boolean bl) {
        InvokeDynamicSupport.bootstrap("reportFullscreenMode", $$robo$$android_view_inputmethod_InputMethodManager$reportFullscreenMode(android.os.IBinder boolean ), 0, this, iBinder, bl);
    }

    public boolean isActive(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("isActive", $$robo$$android_view_inputmethod_InputMethodManager$isActive(android.view.View ), 0, this, view);
    }

    public boolean isActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActive", $$robo$$android_view_inputmethod_InputMethodManager$isActive(), 0, this);
    }

    public boolean isAcceptingText() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAcceptingText", $$robo$$android_view_inputmethod_InputMethodManager$isAcceptingText(), 0, this);
    }

    void clearBindingLocked() {
        InvokeDynamicSupport.bootstrap("clearBindingLocked", $$robo$$android_view_inputmethod_InputMethodManager$clearBindingLocked(), 0, this);
    }

    void setInputChannelLocked(InputChannel inputChannel) {
        InvokeDynamicSupport.bootstrap("setInputChannelLocked", $$robo$$android_view_inputmethod_InputMethodManager$setInputChannelLocked(android.view.InputChannel ), 0, this, inputChannel);
    }

    void clearConnectionLocked() {
        InvokeDynamicSupport.bootstrap("clearConnectionLocked", $$robo$$android_view_inputmethod_InputMethodManager$clearConnectionLocked(), 0, this);
    }

    void finishInputLocked() {
        InvokeDynamicSupport.bootstrap("finishInputLocked", $$robo$$android_view_inputmethod_InputMethodManager$finishInputLocked(), 0, this);
    }

    public void displayCompletions(View view, CompletionInfo[] completionInfoArray) {
        InvokeDynamicSupport.bootstrap("displayCompletions", $$robo$$android_view_inputmethod_InputMethodManager$displayCompletions(android.view.View android.view.inputmethod.CompletionInfo[] ), 0, this, view, completionInfoArray);
    }

    public void updateExtractedText(View view, int n, ExtractedText extractedText) {
        InvokeDynamicSupport.bootstrap("updateExtractedText", $$robo$$android_view_inputmethod_InputMethodManager$updateExtractedText(android.view.View int android.view.inputmethod.ExtractedText ), 0, this, view, n, extractedText);
    }

    public boolean showSoftInput(View view, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("showSoftInput", $$robo$$android_view_inputmethod_InputMethodManager$showSoftInput(android.view.View int ), 0, this, view, n);
    }

    public boolean showSoftInput(View view, int n, ResultReceiver resultReceiver) {
        return (boolean)InvokeDynamicSupport.bootstrap("showSoftInput", $$robo$$android_view_inputmethod_InputMethodManager$showSoftInput(android.view.View int android.os.ResultReceiver ), 0, this, view, n, resultReceiver);
    }

    @Deprecated
    public void showSoftInputUnchecked(int n, ResultReceiver resultReceiver) {
        InvokeDynamicSupport.bootstrap("showSoftInputUnchecked", $$robo$$android_view_inputmethod_InputMethodManager$showSoftInputUnchecked(int android.os.ResultReceiver ), 0, this, n, resultReceiver);
    }

    public boolean hideSoftInputFromWindow(IBinder iBinder, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hideSoftInputFromWindow", $$robo$$android_view_inputmethod_InputMethodManager$hideSoftInputFromWindow(android.os.IBinder int ), 0, this, iBinder, n);
    }

    public boolean hideSoftInputFromWindow(IBinder iBinder, int n, ResultReceiver resultReceiver) {
        return (boolean)InvokeDynamicSupport.bootstrap("hideSoftInputFromWindow", $$robo$$android_view_inputmethod_InputMethodManager$hideSoftInputFromWindow(android.os.IBinder int android.os.ResultReceiver ), 0, this, iBinder, n, resultReceiver);
    }

    public void toggleSoftInputFromWindow(IBinder iBinder, int n, int n2) {
        InvokeDynamicSupport.bootstrap("toggleSoftInputFromWindow", $$robo$$android_view_inputmethod_InputMethodManager$toggleSoftInputFromWindow(android.os.IBinder int int ), 0, this, iBinder, n, n2);
    }

    public void toggleSoftInput(int n, int n2) {
        InvokeDynamicSupport.bootstrap("toggleSoftInput", $$robo$$android_view_inputmethod_InputMethodManager$toggleSoftInput(int int ), 0, this, n, n2);
    }

    public void restartInput(View view) {
        InvokeDynamicSupport.bootstrap("restartInput", $$robo$$android_view_inputmethod_InputMethodManager$restartInput(android.view.View ), 0, this, view);
    }

    boolean startInputInner(int n, IBinder iBinder, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("startInputInner", $$robo$$android_view_inputmethod_InputMethodManager$startInputInner(int android.os.IBinder int int int ), 0, this, n, iBinder, n2, n3, n4);
    }

    public void windowDismissed(IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("windowDismissed", $$robo$$android_view_inputmethod_InputMethodManager$windowDismissed(android.os.IBinder ), 0, this, iBinder);
    }

    public void focusIn(View view) {
        InvokeDynamicSupport.bootstrap("focusIn", $$robo$$android_view_inputmethod_InputMethodManager$focusIn(android.view.View ), 0, this, view);
    }

    void focusInLocked(View view) {
        InvokeDynamicSupport.bootstrap("focusInLocked", $$robo$$android_view_inputmethod_InputMethodManager$focusInLocked(android.view.View ), 0, this, view);
    }

    public void focusOut(View view) {
        InvokeDynamicSupport.bootstrap("focusOut", $$robo$$android_view_inputmethod_InputMethodManager$focusOut(android.view.View ), 0, this, view);
    }

    public void onViewDetachedFromWindow(View view) {
        InvokeDynamicSupport.bootstrap("onViewDetachedFromWindow", $$robo$$android_view_inputmethod_InputMethodManager$onViewDetachedFromWindow(android.view.View ), 0, this, view);
    }

    static void scheduleCheckFocusLocked(View view) {
        InvokeDynamicSupport.bootstrapStatic("scheduleCheckFocusLocked", $$robo$$android_view_inputmethod_InputMethodManager$scheduleCheckFocusLocked(android.view.View ), 0, (View)view);
    }

    public void checkFocus() {
        InvokeDynamicSupport.bootstrap("checkFocus", $$robo$$android_view_inputmethod_InputMethodManager$checkFocus(), 0, this);
    }

    private boolean checkFocusNoStartInput(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkFocusNoStartInput", $$robo$$android_view_inputmethod_InputMethodManager$checkFocusNoStartInput(boolean ), 0, this, bl);
    }

    void closeCurrentInput() {
        InvokeDynamicSupport.bootstrap("closeCurrentInput", $$robo$$android_view_inputmethod_InputMethodManager$closeCurrentInput(), 0, this);
    }

    public void onPostWindowFocus(View view, View view2, int n, boolean bl, int n2) {
        InvokeDynamicSupport.bootstrap("onPostWindowFocus", $$robo$$android_view_inputmethod_InputMethodManager$onPostWindowFocus(android.view.View android.view.View int boolean int ), 0, this, view, view2, n, bl, n2);
    }

    public void onPreWindowFocus(View view, boolean bl) {
        InvokeDynamicSupport.bootstrap("onPreWindowFocus", $$robo$$android_view_inputmethod_InputMethodManager$onPreWindowFocus(android.view.View boolean ), 0, this, view, bl);
    }

    public void updateSelection(View view, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("updateSelection", $$robo$$android_view_inputmethod_InputMethodManager$updateSelection(android.view.View int int int int ), 0, this, view, n, n2, n3, n4);
    }

    public void viewClicked(View view) {
        InvokeDynamicSupport.bootstrap("viewClicked", $$robo$$android_view_inputmethod_InputMethodManager$viewClicked(android.view.View ), 0, this, view);
    }

    @Deprecated
    public boolean isWatchingCursor(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("isWatchingCursor", $$robo$$android_view_inputmethod_InputMethodManager$isWatchingCursor(android.view.View ), 0, this, view);
    }

    public boolean isCursorAnchorInfoEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCursorAnchorInfoEnabled", $$robo$$android_view_inputmethod_InputMethodManager$isCursorAnchorInfoEnabled(), 0, this);
    }

    public void setUpdateCursorAnchorInfoMode(int n) {
        InvokeDynamicSupport.bootstrap("setUpdateCursorAnchorInfoMode", $$robo$$android_view_inputmethod_InputMethodManager$setUpdateCursorAnchorInfoMode(int ), 0, this, n);
    }

    @Deprecated
    public void updateCursor(View view, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("updateCursor", $$robo$$android_view_inputmethod_InputMethodManager$updateCursor(android.view.View int int int int ), 0, this, view, n, n2, n3, n4);
    }

    public void updateCursorAnchorInfo(View view, CursorAnchorInfo cursorAnchorInfo) {
        InvokeDynamicSupport.bootstrap("updateCursorAnchorInfo", $$robo$$android_view_inputmethod_InputMethodManager$updateCursorAnchorInfo(android.view.View android.view.inputmethod.CursorAnchorInfo ), 0, this, view, cursorAnchorInfo);
    }

    public void sendAppPrivateCommand(View view, String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("sendAppPrivateCommand", $$robo$$android_view_inputmethod_InputMethodManager$sendAppPrivateCommand(android.view.View java.lang.String android.os.Bundle ), 0, this, view, string2, bundle);
    }

    @Deprecated
    public void setInputMethod(IBinder iBinder, String string2) {
        InvokeDynamicSupport.bootstrap("setInputMethod", $$robo$$android_view_inputmethod_InputMethodManager$setInputMethod(android.os.IBinder java.lang.String ), 0, this, iBinder, string2);
    }

    public void setInputMethodInternal(IBinder iBinder, String string2) {
        InvokeDynamicSupport.bootstrap("setInputMethodInternal", $$robo$$android_view_inputmethod_InputMethodManager$setInputMethodInternal(android.os.IBinder java.lang.String ), 0, this, iBinder, string2);
    }

    @Deprecated
    public void setInputMethodAndSubtype(IBinder iBinder, String string2, InputMethodSubtype inputMethodSubtype) {
        InvokeDynamicSupport.bootstrap("setInputMethodAndSubtype", $$robo$$android_view_inputmethod_InputMethodManager$setInputMethodAndSubtype(android.os.IBinder java.lang.String android.view.inputmethod.InputMethodSubtype ), 0, this, iBinder, string2, inputMethodSubtype);
    }

    public void setInputMethodAndSubtypeInternal(IBinder iBinder, String string2, InputMethodSubtype inputMethodSubtype) {
        InvokeDynamicSupport.bootstrap("setInputMethodAndSubtypeInternal", $$robo$$android_view_inputmethod_InputMethodManager$setInputMethodAndSubtypeInternal(android.os.IBinder java.lang.String android.view.inputmethod.InputMethodSubtype ), 0, this, iBinder, string2, inputMethodSubtype);
    }

    @Deprecated
    public void hideSoftInputFromInputMethod(IBinder iBinder, int n) {
        InvokeDynamicSupport.bootstrap("hideSoftInputFromInputMethod", $$robo$$android_view_inputmethod_InputMethodManager$hideSoftInputFromInputMethod(android.os.IBinder int ), 0, this, iBinder, n);
    }

    public void hideSoftInputFromInputMethodInternal(IBinder iBinder, int n) {
        InvokeDynamicSupport.bootstrap("hideSoftInputFromInputMethodInternal", $$robo$$android_view_inputmethod_InputMethodManager$hideSoftInputFromInputMethodInternal(android.os.IBinder int ), 0, this, iBinder, n);
    }

    @Deprecated
    public void showSoftInputFromInputMethod(IBinder iBinder, int n) {
        InvokeDynamicSupport.bootstrap("showSoftInputFromInputMethod", $$robo$$android_view_inputmethod_InputMethodManager$showSoftInputFromInputMethod(android.os.IBinder int ), 0, this, iBinder, n);
    }

    public void showSoftInputFromInputMethodInternal(IBinder iBinder, int n) {
        InvokeDynamicSupport.bootstrap("showSoftInputFromInputMethodInternal", $$robo$$android_view_inputmethod_InputMethodManager$showSoftInputFromInputMethodInternal(android.os.IBinder int ), 0, this, iBinder, n);
    }

    public int dispatchInputEvent(InputEvent inputEvent, Object object, FinishedInputEventCallback finishedInputEventCallback, Handler handler) {
        return (int)InvokeDynamicSupport.bootstrap("dispatchInputEvent", $$robo$$android_view_inputmethod_InputMethodManager$dispatchInputEvent(android.view.InputEvent java.lang.Object android.view.inputmethod.InputMethodManager$FinishedInputEventCallback android.os.Handler ), 0, this, inputEvent, object, finishedInputEventCallback, handler);
    }

    public void dispatchKeyEventFromInputMethod(View view, KeyEvent keyEvent) {
        InvokeDynamicSupport.bootstrap("dispatchKeyEventFromInputMethod", $$robo$$android_view_inputmethod_InputMethodManager$dispatchKeyEventFromInputMethod(android.view.View android.view.KeyEvent ), 0, this, view, keyEvent);
    }

    void sendInputEventAndReportResultOnMainLooper(PendingEvent pendingEvent) {
        InvokeDynamicSupport.bootstrap("sendInputEventAndReportResultOnMainLooper", $$robo$$android_view_inputmethod_InputMethodManager$sendInputEventAndReportResultOnMainLooper(android.view.inputmethod.InputMethodManager$PendingEvent ), 0, this, pendingEvent);
    }

    int sendInputEventOnMainLooperLocked(PendingEvent pendingEvent) {
        return (int)InvokeDynamicSupport.bootstrap("sendInputEventOnMainLooperLocked", $$robo$$android_view_inputmethod_InputMethodManager$sendInputEventOnMainLooperLocked(android.view.inputmethod.InputMethodManager$PendingEvent ), 0, this, pendingEvent);
    }

    void finishedInputEvent(int n, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("finishedInputEvent", $$robo$$android_view_inputmethod_InputMethodManager$finishedInputEvent(int boolean boolean ), 0, this, n, bl, bl2);
    }

    void invokeFinishedInputEventCallback(PendingEvent pendingEvent, boolean bl) {
        InvokeDynamicSupport.bootstrap("invokeFinishedInputEventCallback", $$robo$$android_view_inputmethod_InputMethodManager$invokeFinishedInputEventCallback(android.view.inputmethod.InputMethodManager$PendingEvent boolean ), 0, this, pendingEvent, bl);
    }

    private void flushPendingEventsLocked() {
        InvokeDynamicSupport.bootstrap("flushPendingEventsLocked", $$robo$$android_view_inputmethod_InputMethodManager$flushPendingEventsLocked(), 0, this);
    }

    private PendingEvent obtainPendingEventLocked(InputEvent inputEvent, Object object, String string2, FinishedInputEventCallback finishedInputEventCallback, Handler handler) {
        return InvokeDynamicSupport.bootstrap("obtainPendingEventLocked", $$robo$$android_view_inputmethod_InputMethodManager$obtainPendingEventLocked(android.view.InputEvent java.lang.Object java.lang.String android.view.inputmethod.InputMethodManager$FinishedInputEventCallback android.os.Handler ), 0, this, inputEvent, object, string2, finishedInputEventCallback, handler);
    }

    private void recyclePendingEventLocked(PendingEvent pendingEvent) {
        InvokeDynamicSupport.bootstrap("recyclePendingEventLocked", $$robo$$android_view_inputmethod_InputMethodManager$recyclePendingEventLocked(android.view.inputmethod.InputMethodManager$PendingEvent ), 0, this, pendingEvent);
    }

    public void showInputMethodPicker() {
        InvokeDynamicSupport.bootstrap("showInputMethodPicker", $$robo$$android_view_inputmethod_InputMethodManager$showInputMethodPicker(), 0, this);
    }

    public void showInputMethodPicker(boolean bl) {
        InvokeDynamicSupport.bootstrap("showInputMethodPicker", $$robo$$android_view_inputmethod_InputMethodManager$showInputMethodPicker(boolean ), 0, this, bl);
    }

    private void showInputMethodPickerLocked() {
        InvokeDynamicSupport.bootstrap("showInputMethodPickerLocked", $$robo$$android_view_inputmethod_InputMethodManager$showInputMethodPickerLocked(), 0, this);
    }

    public boolean isInputMethodPickerShown() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInputMethodPickerShown", $$robo$$android_view_inputmethod_InputMethodManager$isInputMethodPickerShown(), 0, this);
    }

    public void showInputMethodAndSubtypeEnabler(String string2) {
        InvokeDynamicSupport.bootstrap("showInputMethodAndSubtypeEnabler", $$robo$$android_view_inputmethod_InputMethodManager$showInputMethodAndSubtypeEnabler(java.lang.String ), 0, this, string2);
    }

    public InputMethodSubtype getCurrentInputMethodSubtype() {
        return InvokeDynamicSupport.bootstrap("getCurrentInputMethodSubtype", $$robo$$android_view_inputmethod_InputMethodManager$getCurrentInputMethodSubtype(), 0, this);
    }

    public boolean setCurrentInputMethodSubtype(InputMethodSubtype inputMethodSubtype) {
        return (boolean)InvokeDynamicSupport.bootstrap("setCurrentInputMethodSubtype", $$robo$$android_view_inputmethod_InputMethodManager$setCurrentInputMethodSubtype(android.view.inputmethod.InputMethodSubtype ), 0, this, inputMethodSubtype);
    }

    public void notifyUserAction() {
        InvokeDynamicSupport.bootstrap("notifyUserAction", $$robo$$android_view_inputmethod_InputMethodManager$notifyUserAction(), 0, this);
    }

    public Map<InputMethodInfo, List<InputMethodSubtype>> getShortcutInputMethodsAndSubtypes() {
        return InvokeDynamicSupport.bootstrap("getShortcutInputMethodsAndSubtypes", $$robo$$android_view_inputmethod_InputMethodManager$getShortcutInputMethodsAndSubtypes(), 0, this);
    }

    public int getInputMethodWindowVisibleHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getInputMethodWindowVisibleHeight", $$robo$$android_view_inputmethod_InputMethodManager$getInputMethodWindowVisibleHeight(), 0, this);
    }

    public void clearLastInputMethodWindowForTransition(IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("clearLastInputMethodWindowForTransition", $$robo$$android_view_inputmethod_InputMethodManager$clearLastInputMethodWindowForTransition(android.os.IBinder ), 0, this, iBinder);
    }

    @Deprecated
    public boolean switchToLastInputMethod(IBinder iBinder) {
        return (boolean)InvokeDynamicSupport.bootstrap("switchToLastInputMethod", $$robo$$android_view_inputmethod_InputMethodManager$switchToLastInputMethod(android.os.IBinder ), 0, this, iBinder);
    }

    public boolean switchToPreviousInputMethodInternal(IBinder iBinder) {
        return (boolean)InvokeDynamicSupport.bootstrap("switchToPreviousInputMethodInternal", $$robo$$android_view_inputmethod_InputMethodManager$switchToPreviousInputMethodInternal(android.os.IBinder ), 0, this, iBinder);
    }

    @Deprecated
    public boolean switchToNextInputMethod(IBinder iBinder, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("switchToNextInputMethod", $$robo$$android_view_inputmethod_InputMethodManager$switchToNextInputMethod(android.os.IBinder boolean ), 0, this, iBinder, bl);
    }

    public boolean switchToNextInputMethodInternal(IBinder iBinder, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("switchToNextInputMethodInternal", $$robo$$android_view_inputmethod_InputMethodManager$switchToNextInputMethodInternal(android.os.IBinder boolean ), 0, this, iBinder, bl);
    }

    @Deprecated
    public boolean shouldOfferSwitchingToNextInputMethod(IBinder iBinder) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldOfferSwitchingToNextInputMethod", $$robo$$android_view_inputmethod_InputMethodManager$shouldOfferSwitchingToNextInputMethod(android.os.IBinder ), 0, this, iBinder);
    }

    public boolean shouldOfferSwitchingToNextInputMethodInternal(IBinder iBinder) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldOfferSwitchingToNextInputMethodInternal", $$robo$$android_view_inputmethod_InputMethodManager$shouldOfferSwitchingToNextInputMethodInternal(android.os.IBinder ), 0, this, iBinder);
    }

    public void setAdditionalInputMethodSubtypes(String string2, InputMethodSubtype[] inputMethodSubtypeArray) {
        InvokeDynamicSupport.bootstrap("setAdditionalInputMethodSubtypes", $$robo$$android_view_inputmethod_InputMethodManager$setAdditionalInputMethodSubtypes(java.lang.String android.view.inputmethod.InputMethodSubtype[] ), 0, this, string2, inputMethodSubtypeArray);
    }

    public InputMethodSubtype getLastInputMethodSubtype() {
        return InvokeDynamicSupport.bootstrap("getLastInputMethodSubtype", $$robo$$android_view_inputmethod_InputMethodManager$getLastInputMethodSubtype(), 0, this);
    }

    public void exposeContent(IBinder iBinder, InputContentInfo inputContentInfo, EditorInfo editorInfo) {
        InvokeDynamicSupport.bootstrap("exposeContent", $$robo$$android_view_inputmethod_InputMethodManager$exposeContent(android.os.IBinder android.view.inputmethod.InputContentInfo android.view.inputmethod.EditorInfo ), 0, this, iBinder, inputContentInfo, editorInfo);
    }

    void doDump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("doDump", $$robo$$android_view_inputmethod_InputMethodManager$doDump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    private static String dumpViewInfo(View view) {
        return InvokeDynamicSupport.bootstrapStatic("dumpViewInfo", $$robo$$android_view_inputmethod_InputMethodManager$dumpViewInfo(android.view.View ), 0, (View)view);
    }

    public /* synthetic */ InputMethodManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputMethodManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class PendingEvent
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public InputEvent mEvent;
        public Object mToken;
        public String mInputMethodId;
        public FinishedInputEventCallback mCallback;
        public Handler mHandler;
        public boolean mHandled;
        /* synthetic */ InputMethodManager this$0;

        private void $$robo$$android_view_inputmethod_InputMethodManager_PendingEvent$__constructor__(InputMethodManager inputMethodManager) {
        }

        private final void $$robo$$android_view_inputmethod_InputMethodManager_PendingEvent$recycle() {
            this.mEvent = null;
            this.mToken = null;
            this.mInputMethodId = null;
            this.mCallback = null;
            this.mHandler = null;
            this.mHandled = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_view_inputmethod_InputMethodManager_PendingEvent$run() {
            this.mCallback.onFinishedInputEvent(this.mToken, this.mHandled);
            H h = this.this$0.mH;
            synchronized (h) {
                this.this$0.recyclePendingEventLocked(this);
            }
        }

        private /* synthetic */ void $$robo$$android_view_inputmethod_InputMethodManager_PendingEvent$__constructor__(InputMethodManager x0, 1 x1) {
        }

        private void __constructor__(InputMethodManager inputMethodManager) {
            this.$$robo$$android_view_inputmethod_InputMethodManager_PendingEvent$__constructor__(inputMethodManager);
        }

        private PendingEvent(InputMethodManager inputMethodManager) {
            this.this$0 = inputMethodManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_InputMethodManager_PendingEvent$__constructor__(android.view.inputmethod.InputMethodManager ), 0, this, inputMethodManager);
        }

        public void recycle() {
            InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_view_inputmethod_InputMethodManager_PendingEvent$recycle(), 0, this);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_view_inputmethod_InputMethodManager_PendingEvent$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(InputMethodManager inputMethodManager, 1 var2_2) {
            this.$$robo$$android_view_inputmethod_InputMethodManager_PendingEvent$__constructor__(inputMethodManager, var2_2);
        }

        public /* synthetic */ PendingEvent() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PendingEvent)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class ImeInputEventSender
    extends InputEventSender
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ InputMethodManager this$0;

        private void $$robo$$android_view_inputmethod_InputMethodManager_ImeInputEventSender$__constructor__(InputMethodManager inputMethodManager, InputChannel inputChannel, Looper looper) {
        }

        private final void $$robo$$android_view_inputmethod_InputMethodManager_ImeInputEventSender$onInputEventFinished(int seq, boolean handled) {
            this.this$0.finishedInputEvent(seq, handled, false);
        }

        private void __constructor__(InputMethodManager inputMethodManager, InputChannel inputChannel, Looper looper) {
            this.$$robo$$android_view_inputmethod_InputMethodManager_ImeInputEventSender$__constructor__(inputMethodManager, inputChannel, looper);
        }

        public ImeInputEventSender(InputMethodManager inputMethodManager, InputChannel inputChannel, Looper looper) {
            this.this$0 = inputMethodManager;
            super(inputChannel, looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_InputMethodManager_ImeInputEventSender$__constructor__(android.view.inputmethod.InputMethodManager android.view.InputChannel android.os.Looper ), 0, this, inputMethodManager, inputChannel, looper);
        }

        @Override
        public void onInputEventFinished(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("onInputEventFinished", $$robo$$android_view_inputmethod_InputMethodManager_ImeInputEventSender$onInputEventFinished(int boolean ), 0, this, n, bl);
        }

        public /* synthetic */ ImeInputEventSender() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImeInputEventSender)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface FinishedInputEventCallback
    extends InstrumentedInterface {
        public void onFinishedInputEvent(Object var1, boolean var2);
    }

    private static class ControlledInputConnectionWrapper
    extends IInputConnectionWrapper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private InputMethodManager mParentInputMethodManager;

        private void $$robo$$android_view_inputmethod_InputMethodManager_ControlledInputConnectionWrapper$__constructor__(Looper mainLooper, InputConnection conn, InputMethodManager inputMethodManager) {
            this.mParentInputMethodManager = inputMethodManager;
        }

        private final boolean $$robo$$android_view_inputmethod_InputMethodManager_ControlledInputConnectionWrapper$isActive() {
            return this.mParentInputMethodManager.mActive && !this.isFinished();
        }

        private final void $$robo$$android_view_inputmethod_InputMethodManager_ControlledInputConnectionWrapper$deactivate() {
            if (this.isFinished()) {
                return;
            }
            this.closeConnection();
        }

        private final void $$robo$$android_view_inputmethod_InputMethodManager_ControlledInputConnectionWrapper$onUserAction() {
            this.mParentInputMethodManager.notifyUserAction();
        }

        private final String $$robo$$android_view_inputmethod_InputMethodManager_ControlledInputConnectionWrapper$toString() {
            return "ControlledInputConnectionWrapper{connection=" + this.getInputConnection() + " finished=" + this.isFinished() + " mParentInputMethodManager.mActive=" + this.mParentInputMethodManager.mActive + "}";
        }

        private void __constructor__(Looper looper, InputConnection inputConnection, InputMethodManager inputMethodManager) {
            this.$$robo$$android_view_inputmethod_InputMethodManager_ControlledInputConnectionWrapper$__constructor__(looper, inputConnection, inputMethodManager);
        }

        public ControlledInputConnectionWrapper(Looper looper, InputConnection inputConnection, InputMethodManager inputMethodManager) {
            super(looper, inputConnection);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_InputMethodManager_ControlledInputConnectionWrapper$__constructor__(android.os.Looper android.view.inputmethod.InputConnection android.view.inputmethod.InputMethodManager ), 0, this, looper, inputConnection, inputMethodManager);
        }

        @Override
        public boolean isActive() {
            return (boolean)InvokeDynamicSupport.bootstrap("isActive", $$robo$$android_view_inputmethod_InputMethodManager_ControlledInputConnectionWrapper$isActive(), 0, this);
        }

        void deactivate() {
            InvokeDynamicSupport.bootstrap("deactivate", $$robo$$android_view_inputmethod_InputMethodManager_ControlledInputConnectionWrapper$deactivate(), 0, this);
        }

        @Override
        protected void onUserAction() {
            InvokeDynamicSupport.bootstrap("onUserAction", $$robo$$android_view_inputmethod_InputMethodManager_ControlledInputConnectionWrapper$onUserAction(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_inputmethod_InputMethodManager_ControlledInputConnectionWrapper$toString(), 0, this);
        }

        public /* synthetic */ ControlledInputConnectionWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ControlledInputConnectionWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class H
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ InputMethodManager this$0;

        private void $$robo$$android_view_inputmethod_InputMethodManager_H$__constructor__(InputMethodManager this$0, Looper looper) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_view_inputmethod_InputMethodManager_H$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        this.this$0.doDump((FileDescriptor)args.arg1, (PrintWriter)args.arg2, (String[])args.arg3);
                    }
                    catch (RuntimeException e) {
                        ((PrintWriter)args.arg2).println("Exception: " + e);
                    }
                    Object e = args.arg4;
                    synchronized (e) {
                        ((CountDownLatch)args.arg4).countDown();
                    }
                    args.recycle();
                    return;
                }
                case 2: {
                    InputBindResult res = (InputBindResult)msg.obj;
                    H e = this.this$0.mH;
                    synchronized (e) {
                        if (this.this$0.mBindSequence < 0 || this.this$0.mBindSequence != res.sequence) {
                            Log.w("InputMethodManager", "Ignoring onBind: cur seq=" + this.this$0.mBindSequence + ", given seq=" + res.sequence);
                            if (res.channel != null && res.channel != this.this$0.mCurChannel) {
                                res.channel.dispose();
                            }
                            return;
                        }
                        this.this$0.mRequestUpdateCursorAnchorInfoMonitorMode = 0;
                        this.this$0.setInputChannelLocked(res.channel);
                        this.this$0.mCurMethod = res.method;
                        this.this$0.mCurId = res.id;
                        this.this$0.mBindSequence = res.sequence;
                    }
                    this.this$0.startInputInner(5, null, 0, 0, 0);
                    return;
                }
                case 3: {
                    boolean startInput;
                    int sequence = msg.arg1;
                    int reason = msg.arg2;
                    H h = this.this$0.mH;
                    synchronized (h) {
                        if (this.this$0.mBindSequence != sequence) {
                            return;
                        }
                        this.this$0.clearBindingLocked();
                        if (this.this$0.mServedView != null && this.this$0.mServedView.isFocused()) {
                            this.this$0.mServedConnecting = true;
                        }
                        startInput = this.this$0.mActive;
                    }
                    if (startInput) {
                        this.this$0.startInputInner(6, null, 0, 0, 0);
                    }
                    return;
                }
                case 4: {
                    boolean active = msg.arg1 != 0;
                    boolean fullscreen = msg.arg2 != 0;
                    H h = this.this$0.mH;
                    synchronized (h) {
                        this.this$0.mActive = active;
                        this.this$0.mFullscreenMode = fullscreen;
                        if (!active) {
                            this.this$0.mRestartOnNextWindowFocus = true;
                            try {
                                this.this$0.mIInputContext.finishComposingText();
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                        }
                        if (this.this$0.mServedView != null && InputMethodManager.canStartInput(this.this$0.mServedView) && this.this$0.checkFocusNoStartInput(this.this$0.mRestartOnNextWindowFocus)) {
                            int reason = active ? 7 : 8;
                            this.this$0.startInputInner(reason, null, 0, 0, 0);
                        }
                    }
                    return;
                }
                case 5: {
                    this.this$0.sendInputEventAndReportResultOnMainLooper((PendingEvent)msg.obj);
                    return;
                }
                case 6: {
                    this.this$0.finishedInputEvent(msg.arg1, false, true);
                    return;
                }
                case 7: {
                    this.this$0.finishedInputEvent(msg.arg1, false, false);
                    return;
                }
                case 9: {
                    H active = this.this$0.mH;
                    synchronized (active) {
                        this.this$0.mNextUserActionNotificationSequenceNumber = msg.arg1;
                    }
                    return;
                }
                case 10: {
                    boolean fullscreen = msg.arg1 != 0;
                    InputConnection ic = null;
                    H h = this.this$0.mH;
                    synchronized (h) {
                        this.this$0.mFullscreenMode = fullscreen;
                        if (this.this$0.mServedInputConnectionWrapper != null) {
                            ic = this.this$0.mServedInputConnectionWrapper.getInputConnection();
                        }
                    }
                    if (ic != null) {
                        ic.reportFullscreenMode(fullscreen);
                    }
                    return;
                }
            }
        }

        private void __constructor__(InputMethodManager inputMethodManager, Looper looper) {
            this.$$robo$$android_view_inputmethod_InputMethodManager_H$__constructor__(inputMethodManager, looper);
        }

        H(InputMethodManager inputMethodManager, Looper looper) {
            this.this$0 = inputMethodManager;
            super(looper, null, true);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_InputMethodManager_H$__constructor__(android.view.inputmethod.InputMethodManager android.os.Looper ), 0, this, inputMethodManager, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_view_inputmethod_InputMethodManager_H$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ H() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (H)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

