/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.metrics.LogMaker;
import android.util.ArrayMap;
import android.view.textclassifier.TextLinks;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class GenerateLinksLogger
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "GenerateLinksLogger";
    private static boolean DEBUG_LOG_ENABLED = false;
    private static String ZERO = "0";
    private MetricsLogger mMetricsLogger;
    private Random mRng;
    private int mSampleRate;

    private void $$robo$$android_view_textclassifier_GenerateLinksLogger$__constructor__(int sampleRate) {
        this.mSampleRate = sampleRate;
        this.mRng = new Random((long)InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System"));
        this.mMetricsLogger = new MetricsLogger();
    }

    @VisibleForTesting
    private void $$robo$$android_view_textclassifier_GenerateLinksLogger$__constructor__(int sampleRate, MetricsLogger metricsLogger) {
        this.mSampleRate = sampleRate;
        this.mRng = new Random((long)InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System"));
        this.mMetricsLogger = metricsLogger;
    }

    private final void $$robo$$android_view_textclassifier_GenerateLinksLogger$logGenerateLinks(CharSequence text, TextLinks links, String callingPackageName, long latencyMs) {
        Preconditions.checkNotNull(text);
        Preconditions.checkNotNull(links);
        Preconditions.checkNotNull(callingPackageName);
        if (!this.shouldLog()) {
            return;
        }
        LinkifyStats totalStats = new LinkifyStats();
        ArrayMap<String, LinkifyStats> perEntityTypeStats = new ArrayMap<String, LinkifyStats>();
        for (TextLinks.TextLink link : links.getLinks()) {
            String entityType;
            if (link.getEntityCount() == 0 || (entityType = link.getEntity(0)) == null || "other".equals(entityType) || "".equals(entityType)) continue;
            totalStats.countLink(link);
            perEntityTypeStats.computeIfAbsent(entityType, k -> new LinkifyStats()).countLink(link);
        }
        String callId = UUID.randomUUID().toString();
        this.writeStats(callId, callingPackageName, null, totalStats, text, latencyMs);
        for (Map.Entry entry : perEntityTypeStats.entrySet()) {
            this.writeStats(callId, callingPackageName, (String)entry.getKey(), (LinkifyStats)entry.getValue(), text, latencyMs);
        }
    }

    private final boolean $$robo$$android_view_textclassifier_GenerateLinksLogger$shouldLog() {
        if (this.mSampleRate <= 1) {
            return true;
        }
        return this.mRng.nextInt(this.mSampleRate) == 0;
    }

    private final void $$robo$$android_view_textclassifier_GenerateLinksLogger$writeStats(String callId, String callingPackageName, String entityType, LinkifyStats stats, CharSequence text, long latencyMs) {
        LogMaker log = new LogMaker(1313).setPackageName(callingPackageName).addTaggedData(1319, callId).addTaggedData(1316, stats.mNumLinks).addTaggedData(1317, stats.mNumLinksTextLength).addTaggedData(1315, text.length()).addTaggedData(1314, latencyMs);
        if (entityType != null) {
            log.addTaggedData(1318, entityType);
        }
        this.mMetricsLogger.write(log);
        GenerateLinksLogger.debugLog(log);
    }

    private static final void $$robo$$android_view_textclassifier_GenerateLinksLogger$debugLog(LogMaker log) {
    }

    private void __constructor__(int n) {
        this.$$robo$$android_view_textclassifier_GenerateLinksLogger$__constructor__(n);
    }

    public GenerateLinksLogger(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_GenerateLinksLogger$__constructor__(int ), 0, this, n);
    }

    private void __constructor__(int n, MetricsLogger metricsLogger) {
        this.$$robo$$android_view_textclassifier_GenerateLinksLogger$__constructor__(n, metricsLogger);
    }

    public GenerateLinksLogger(int n, MetricsLogger metricsLogger) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_GenerateLinksLogger$__constructor__(int com.android.internal.logging.MetricsLogger ), 0, this, n, metricsLogger);
    }

    public void logGenerateLinks(CharSequence charSequence, TextLinks textLinks, String string2, long l) {
        InvokeDynamicSupport.bootstrap("logGenerateLinks", $$robo$$android_view_textclassifier_GenerateLinksLogger$logGenerateLinks(java.lang.CharSequence android.view.textclassifier.TextLinks java.lang.String long ), 0, this, charSequence, textLinks, string2, l);
    }

    private boolean shouldLog() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldLog", $$robo$$android_view_textclassifier_GenerateLinksLogger$shouldLog(), 0, this);
    }

    private void writeStats(String string2, String string3, String string4, LinkifyStats linkifyStats, CharSequence charSequence, long l) {
        InvokeDynamicSupport.bootstrap("writeStats", $$robo$$android_view_textclassifier_GenerateLinksLogger$writeStats(java.lang.String java.lang.String java.lang.String android.view.textclassifier.GenerateLinksLogger$LinkifyStats java.lang.CharSequence long ), 0, this, string2, string3, string4, linkifyStats, charSequence, l);
    }

    private static void debugLog(LogMaker logMaker) {
        InvokeDynamicSupport.bootstrapStatic("debugLog", $$robo$$android_view_textclassifier_GenerateLinksLogger$debugLog(android.metrics.LogMaker ), 0, (LogMaker)logMaker);
    }

    public /* synthetic */ GenerateLinksLogger() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GenerateLinksLogger)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class LinkifyStats
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int mNumLinks;
        int mNumLinksTextLength;

        private void $$robo$$android_view_textclassifier_GenerateLinksLogger_LinkifyStats$__constructor__() {
        }

        private final void $$robo$$android_view_textclassifier_GenerateLinksLogger_LinkifyStats$countLink(TextLinks.TextLink link) {
            ++this.mNumLinks;
            this.mNumLinksTextLength += link.getEnd() - link.getStart();
        }

        private /* synthetic */ void $$robo$$android_view_textclassifier_GenerateLinksLogger_LinkifyStats$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_view_textclassifier_GenerateLinksLogger_LinkifyStats$__constructor__();
        }

        private LinkifyStats() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_GenerateLinksLogger_LinkifyStats$__constructor__(), 0, this);
        }

        void countLink(TextLinks.TextLink textLink) {
            InvokeDynamicSupport.bootstrap("countLink", $$robo$$android_view_textclassifier_GenerateLinksLogger_LinkifyStats$countLink(android.view.textclassifier.TextLinks$TextLink ), 0, this, textLink);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_view_textclassifier_GenerateLinksLogger_LinkifyStats$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LinkifyStats)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

