/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.os.Parcel;
import android.os.Parcelable;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassificationContext;
import android.view.textclassifier.TextClassificationSessionId;
import android.view.textclassifier.TextSelection;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class SelectionEvent
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int ACTION_OVERTYPE = 100;
    public static int ACTION_COPY = 101;
    public static int ACTION_PASTE = 102;
    public static int ACTION_CUT = 103;
    public static int ACTION_SHARE = 104;
    public static int ACTION_SMART_SHARE = 105;
    public static int ACTION_DRAG = 106;
    public static int ACTION_ABANDON = 107;
    public static int ACTION_OTHER = 108;
    public static int ACTION_SELECT_ALL = 200;
    public static int ACTION_RESET = 201;
    public static int EVENT_SELECTION_STARTED = 1;
    public static int EVENT_SELECTION_MODIFIED = 2;
    public static int EVENT_SMART_SELECTION_SINGLE = 3;
    public static int EVENT_SMART_SELECTION_MULTI = 4;
    public static int EVENT_AUTO_SELECTION = 5;
    public static int INVOCATION_MANUAL = 1;
    public static int INVOCATION_LINK = 2;
    public static int INVOCATION_UNKNOWN = 0;
    private static String NO_SIGNATURE = "";
    private int mAbsoluteStart;
    private int mAbsoluteEnd;
    private String mEntityType;
    private int mEventType;
    private String mPackageName;
    private String mWidgetType;
    private int mInvocationMethod;
    private String mWidgetVersion;
    private String mResultId;
    private long mEventTime;
    private long mDurationSinceSessionStart;
    private long mDurationSincePreviousEvent;
    private int mEventIndex;
    private TextClassificationSessionId mSessionId;
    private int mStart;
    private int mEnd;
    private int mSmartStart;
    private int mSmartEnd;
    public static Parcelable.Creator<SelectionEvent> CREATOR;

    private void $$robo$$android_view_textclassifier_SelectionEvent$__constructor__(int start, int end, int eventType, String entityType, int invocationMethod, String resultId) {
        this.mPackageName = "";
        this.mWidgetType = "unknown";
        Preconditions.checkArgument(end >= start, "end cannot be less than start");
        this.mAbsoluteStart = start;
        this.mAbsoluteEnd = end;
        this.mEventType = eventType;
        this.mEntityType = Preconditions.checkNotNull(entityType);
        this.mResultId = resultId;
        this.mInvocationMethod = invocationMethod;
    }

    private void $$robo$$android_view_textclassifier_SelectionEvent$__constructor__(Parcel in) {
        this.mPackageName = "";
        this.mWidgetType = "unknown";
        this.mAbsoluteStart = in.readInt();
        this.mAbsoluteEnd = in.readInt();
        this.mEventType = in.readInt();
        this.mEntityType = in.readString();
        this.mWidgetVersion = in.readInt() > 0 ? in.readString() : null;
        this.mPackageName = in.readString();
        this.mWidgetType = in.readString();
        this.mInvocationMethod = in.readInt();
        this.mResultId = in.readString();
        this.mEventTime = in.readLong();
        this.mDurationSinceSessionStart = in.readLong();
        this.mDurationSincePreviousEvent = in.readLong();
        this.mEventIndex = in.readInt();
        this.mSessionId = in.readInt() > 0 ? TextClassificationSessionId.CREATOR.createFromParcel(in) : null;
        this.mStart = in.readInt();
        this.mEnd = in.readInt();
        this.mSmartStart = in.readInt();
        this.mSmartEnd = in.readInt();
    }

    private final void $$robo$$android_view_textclassifier_SelectionEvent$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mAbsoluteStart);
        dest.writeInt(this.mAbsoluteEnd);
        dest.writeInt(this.mEventType);
        dest.writeString(this.mEntityType);
        dest.writeInt(this.mWidgetVersion != null ? 1 : 0);
        if (this.mWidgetVersion != null) {
            dest.writeString(this.mWidgetVersion);
        }
        dest.writeString(this.mPackageName);
        dest.writeString(this.mWidgetType);
        dest.writeInt(this.mInvocationMethod);
        dest.writeString(this.mResultId);
        dest.writeLong(this.mEventTime);
        dest.writeLong(this.mDurationSinceSessionStart);
        dest.writeLong(this.mDurationSincePreviousEvent);
        dest.writeInt(this.mEventIndex);
        dest.writeInt(this.mSessionId != null ? 1 : 0);
        if (this.mSessionId != null) {
            this.mSessionId.writeToParcel(dest, flags);
        }
        dest.writeInt(this.mStart);
        dest.writeInt(this.mEnd);
        dest.writeInt(this.mSmartStart);
        dest.writeInt(this.mSmartEnd);
    }

    private final int $$robo$$android_view_textclassifier_SelectionEvent$describeContents() {
        return 0;
    }

    private static final SelectionEvent $$robo$$android_view_textclassifier_SelectionEvent$createSelectionStartedEvent(int invocationMethod, int start) {
        return new SelectionEvent(start, start + 1, 1, "", invocationMethod, "");
    }

    private static final SelectionEvent $$robo$$android_view_textclassifier_SelectionEvent$createSelectionModifiedEvent(int start, int end) {
        Preconditions.checkArgument(end >= start, "end cannot be less than start");
        return new SelectionEvent(start, end, 2, "", 0, "");
    }

    private static final SelectionEvent $$robo$$android_view_textclassifier_SelectionEvent$createSelectionModifiedEvent(int start, int end, TextClassification classification) {
        Preconditions.checkArgument(end >= start, "end cannot be less than start");
        Preconditions.checkNotNull(classification);
        String entityType = classification.getEntityCount() > 0 ? classification.getEntity(0) : "";
        return new SelectionEvent(start, end, 2, entityType, 0, classification.getId());
    }

    private static final SelectionEvent $$robo$$android_view_textclassifier_SelectionEvent$createSelectionModifiedEvent(int start, int end, TextSelection selection) {
        Preconditions.checkArgument(end >= start, "end cannot be less than start");
        Preconditions.checkNotNull(selection);
        String entityType = selection.getEntityCount() > 0 ? selection.getEntity(0) : "";
        return new SelectionEvent(start, end, 5, entityType, 0, selection.getId());
    }

    private static final SelectionEvent $$robo$$android_view_textclassifier_SelectionEvent$createSelectionActionEvent(int start, int end, int actionType) {
        Preconditions.checkArgument(end >= start, "end cannot be less than start");
        SelectionEvent.checkActionType(actionType);
        return new SelectionEvent(start, end, actionType, "", 0, "");
    }

    private static final SelectionEvent $$robo$$android_view_textclassifier_SelectionEvent$createSelectionActionEvent(int start, int end, int actionType, TextClassification classification) {
        Preconditions.checkArgument(end >= start, "end cannot be less than start");
        Preconditions.checkNotNull(classification);
        SelectionEvent.checkActionType(actionType);
        String entityType = classification.getEntityCount() > 0 ? classification.getEntity(0) : "";
        return new SelectionEvent(start, end, actionType, entityType, 0, classification.getId());
    }

    private static final void $$robo$$android_view_textclassifier_SelectionEvent$checkActionType(int eventType) throws IllegalArgumentException {
        switch (eventType) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 200: 
            case 201: {
                return;
            }
        }
        throw new IllegalArgumentException(String.format(Locale.US, "%d is not an eventType", eventType));
    }

    private final int $$robo$$android_view_textclassifier_SelectionEvent$getAbsoluteStart() {
        return this.mAbsoluteStart;
    }

    private final int $$robo$$android_view_textclassifier_SelectionEvent$getAbsoluteEnd() {
        return this.mAbsoluteEnd;
    }

    private final int $$robo$$android_view_textclassifier_SelectionEvent$getEventType() {
        return this.mEventType;
    }

    private final void $$robo$$android_view_textclassifier_SelectionEvent$setEventType(int eventType) {
        this.mEventType = eventType;
    }

    private final String $$robo$$android_view_textclassifier_SelectionEvent$getEntityType() {
        return this.mEntityType;
    }

    private final String $$robo$$android_view_textclassifier_SelectionEvent$getPackageName() {
        return this.mPackageName;
    }

    private final String $$robo$$android_view_textclassifier_SelectionEvent$getWidgetType() {
        return this.mWidgetType;
    }

    private final String $$robo$$android_view_textclassifier_SelectionEvent$getWidgetVersion() {
        return this.mWidgetVersion;
    }

    private final void $$robo$$android_view_textclassifier_SelectionEvent$setTextClassificationSessionContext(TextClassificationContext context) {
        this.mPackageName = context.getPackageName();
        this.mWidgetType = context.getWidgetType();
        this.mWidgetVersion = context.getWidgetVersion();
    }

    private final int $$robo$$android_view_textclassifier_SelectionEvent$getInvocationMethod() {
        return this.mInvocationMethod;
    }

    private final void $$robo$$android_view_textclassifier_SelectionEvent$setInvocationMethod(int invocationMethod) {
        this.mInvocationMethod = invocationMethod;
    }

    private final String $$robo$$android_view_textclassifier_SelectionEvent$getResultId() {
        return this.mResultId;
    }

    private final SelectionEvent $$robo$$android_view_textclassifier_SelectionEvent$setResultId(String resultId) {
        this.mResultId = resultId;
        return this;
    }

    private final long $$robo$$android_view_textclassifier_SelectionEvent$getEventTime() {
        return this.mEventTime;
    }

    private final SelectionEvent $$robo$$android_view_textclassifier_SelectionEvent$setEventTime(long timeMs) {
        this.mEventTime = timeMs;
        return this;
    }

    private final long $$robo$$android_view_textclassifier_SelectionEvent$getDurationSinceSessionStart() {
        return this.mDurationSinceSessionStart;
    }

    private final SelectionEvent $$robo$$android_view_textclassifier_SelectionEvent$setDurationSinceSessionStart(long durationMs) {
        this.mDurationSinceSessionStart = durationMs;
        return this;
    }

    private final long $$robo$$android_view_textclassifier_SelectionEvent$getDurationSincePreviousEvent() {
        return this.mDurationSincePreviousEvent;
    }

    private final SelectionEvent $$robo$$android_view_textclassifier_SelectionEvent$setDurationSincePreviousEvent(long durationMs) {
        this.mDurationSincePreviousEvent = durationMs;
        return this;
    }

    private final int $$robo$$android_view_textclassifier_SelectionEvent$getEventIndex() {
        return this.mEventIndex;
    }

    private final SelectionEvent $$robo$$android_view_textclassifier_SelectionEvent$setEventIndex(int index) {
        this.mEventIndex = index;
        return this;
    }

    private final TextClassificationSessionId $$robo$$android_view_textclassifier_SelectionEvent$getSessionId() {
        return this.mSessionId;
    }

    private final SelectionEvent $$robo$$android_view_textclassifier_SelectionEvent$setSessionId(TextClassificationSessionId id2) {
        this.mSessionId = id2;
        return this;
    }

    private final int $$robo$$android_view_textclassifier_SelectionEvent$getStart() {
        return this.mStart;
    }

    private final SelectionEvent $$robo$$android_view_textclassifier_SelectionEvent$setStart(int start) {
        this.mStart = start;
        return this;
    }

    private final int $$robo$$android_view_textclassifier_SelectionEvent$getEnd() {
        return this.mEnd;
    }

    private final SelectionEvent $$robo$$android_view_textclassifier_SelectionEvent$setEnd(int end) {
        this.mEnd = end;
        return this;
    }

    private final int $$robo$$android_view_textclassifier_SelectionEvent$getSmartStart() {
        return this.mSmartStart;
    }

    private final SelectionEvent $$robo$$android_view_textclassifier_SelectionEvent$setSmartStart(int start) {
        this.mSmartStart = start;
        return this;
    }

    private final int $$robo$$android_view_textclassifier_SelectionEvent$getSmartEnd() {
        return this.mSmartEnd;
    }

    private final SelectionEvent $$robo$$android_view_textclassifier_SelectionEvent$setSmartEnd(int end) {
        this.mSmartEnd = end;
        return this;
    }

    private final boolean $$robo$$android_view_textclassifier_SelectionEvent$isTerminal() {
        return SelectionEvent.isTerminal(this.mEventType);
    }

    private static final boolean $$robo$$android_view_textclassifier_SelectionEvent$isTerminal(int eventType) {
        switch (eventType) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                return true;
            }
        }
        return false;
    }

    private final int $$robo$$android_view_textclassifier_SelectionEvent$hashCode() {
        return Objects.hash(this.mAbsoluteStart, this.mAbsoluteEnd, this.mEventType, this.mEntityType, this.mWidgetVersion, this.mPackageName, this.mWidgetType, this.mInvocationMethod, this.mResultId, this.mEventTime, this.mDurationSinceSessionStart, this.mDurationSincePreviousEvent, this.mEventIndex, this.mSessionId, this.mStart, this.mEnd, this.mSmartStart, this.mSmartEnd);
    }

    private final boolean $$robo$$android_view_textclassifier_SelectionEvent$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SelectionEvent)) {
            return false;
        }
        SelectionEvent other = (SelectionEvent)obj;
        return this.mAbsoluteStart == other.mAbsoluteStart && this.mAbsoluteEnd == other.mAbsoluteEnd && this.mEventType == other.mEventType && Objects.equals(this.mEntityType, other.mEntityType) && Objects.equals(this.mWidgetVersion, other.mWidgetVersion) && Objects.equals(this.mPackageName, other.mPackageName) && Objects.equals(this.mWidgetType, other.mWidgetType) && this.mInvocationMethod == other.mInvocationMethod && Objects.equals(this.mResultId, other.mResultId) && this.mEventTime == other.mEventTime && this.mDurationSinceSessionStart == other.mDurationSinceSessionStart && this.mDurationSincePreviousEvent == other.mDurationSincePreviousEvent && this.mEventIndex == other.mEventIndex && Objects.equals(this.mSessionId, other.mSessionId) && this.mStart == other.mStart && this.mEnd == other.mEnd && this.mSmartStart == other.mSmartStart && this.mSmartEnd == other.mSmartEnd;
    }

    private final String $$robo$$android_view_textclassifier_SelectionEvent$toString() {
        return String.format(Locale.US, "SelectionEvent {absoluteStart=%d, absoluteEnd=%d, eventType=%d, entityType=%s, widgetVersion=%s, packageName=%s, widgetType=%s, invocationMethod=%s, resultId=%s, eventTime=%d, durationSinceSessionStart=%d, durationSincePreviousEvent=%d, eventIndex=%d,sessionId=%s, start=%d, end=%d, smartStart=%d, smartEnd=%d}", this.mAbsoluteStart, this.mAbsoluteEnd, this.mEventType, this.mEntityType, this.mWidgetVersion, this.mPackageName, this.mWidgetType, this.mInvocationMethod, this.mResultId, this.mEventTime, this.mDurationSinceSessionStart, this.mDurationSincePreviousEvent, this.mEventIndex, this.mSessionId, this.mStart, this.mEnd, this.mSmartStart, this.mSmartEnd);
    }

    private /* synthetic */ void $$robo$$android_view_textclassifier_SelectionEvent$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<SelectionEvent>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_textclassifier_SelectionEvent_1$__constructor__() {
            }

            private final SelectionEvent $$robo$$android_view_textclassifier_SelectionEvent_1$createFromParcel(Parcel in) {
                return new SelectionEvent(in);
            }

            private final SelectionEvent[] $$robo$$android_view_textclassifier_SelectionEvent_1$newArray(int size) {
                return new SelectionEvent[size];
            }

            private void __constructor__() {
                this.$$robo$$android_view_textclassifier_SelectionEvent_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_SelectionEvent_1$__constructor__(), 0, this);
            }

            @Override
            public SelectionEvent createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_textclassifier_SelectionEvent_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public SelectionEvent[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_textclassifier_SelectionEvent_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n, int n2, int n3, String string2, int n4, String string3) {
        this.$$robo$$android_view_textclassifier_SelectionEvent$__constructor__(n, n2, n3, string2, n4, string3);
    }

    SelectionEvent(int n, int n2, int n3, String string2, int n4, String string3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_SelectionEvent$__constructor__(int int int java.lang.String int java.lang.String ), 0, this, n, n2, n3, string2, n4, string3);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_view_textclassifier_SelectionEvent$__constructor__(parcel);
    }

    private SelectionEvent(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_SelectionEvent$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_textclassifier_SelectionEvent$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_textclassifier_SelectionEvent$describeContents(), 0, this);
    }

    public static SelectionEvent createSelectionStartedEvent(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("createSelectionStartedEvent", $$robo$$android_view_textclassifier_SelectionEvent$createSelectionStartedEvent(int int ), 0, (int)n, (int)n2);
    }

    public static SelectionEvent createSelectionModifiedEvent(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("createSelectionModifiedEvent", $$robo$$android_view_textclassifier_SelectionEvent$createSelectionModifiedEvent(int int ), 0, (int)n, (int)n2);
    }

    public static SelectionEvent createSelectionModifiedEvent(int n, int n2, TextClassification textClassification) {
        return InvokeDynamicSupport.bootstrapStatic("createSelectionModifiedEvent", $$robo$$android_view_textclassifier_SelectionEvent$createSelectionModifiedEvent(int int android.view.textclassifier.TextClassification ), 0, (int)n, (int)n2, (TextClassification)textClassification);
    }

    public static SelectionEvent createSelectionModifiedEvent(int n, int n2, TextSelection textSelection) {
        return InvokeDynamicSupport.bootstrapStatic("createSelectionModifiedEvent", $$robo$$android_view_textclassifier_SelectionEvent$createSelectionModifiedEvent(int int android.view.textclassifier.TextSelection ), 0, (int)n, (int)n2, (TextSelection)textSelection);
    }

    public static SelectionEvent createSelectionActionEvent(int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrapStatic("createSelectionActionEvent", $$robo$$android_view_textclassifier_SelectionEvent$createSelectionActionEvent(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    public static SelectionEvent createSelectionActionEvent(int n, int n2, int n3, TextClassification textClassification) {
        return InvokeDynamicSupport.bootstrapStatic("createSelectionActionEvent", $$robo$$android_view_textclassifier_SelectionEvent$createSelectionActionEvent(int int int android.view.textclassifier.TextClassification ), 0, (int)n, (int)n2, (int)n3, (TextClassification)textClassification);
    }

    private static void checkActionType(int n) throws IllegalArgumentException {
        InvokeDynamicSupport.bootstrapStatic("checkActionType", $$robo$$android_view_textclassifier_SelectionEvent$checkActionType(int ), 0, (int)n);
    }

    int getAbsoluteStart() {
        return (int)InvokeDynamicSupport.bootstrap("getAbsoluteStart", $$robo$$android_view_textclassifier_SelectionEvent$getAbsoluteStart(), 0, this);
    }

    int getAbsoluteEnd() {
        return (int)InvokeDynamicSupport.bootstrap("getAbsoluteEnd", $$robo$$android_view_textclassifier_SelectionEvent$getAbsoluteEnd(), 0, this);
    }

    public int getEventType() {
        return (int)InvokeDynamicSupport.bootstrap("getEventType", $$robo$$android_view_textclassifier_SelectionEvent$getEventType(), 0, this);
    }

    void setEventType(int n) {
        InvokeDynamicSupport.bootstrap("setEventType", $$robo$$android_view_textclassifier_SelectionEvent$setEventType(int ), 0, this, n);
    }

    public String getEntityType() {
        return InvokeDynamicSupport.bootstrap("getEntityType", $$robo$$android_view_textclassifier_SelectionEvent$getEntityType(), 0, this);
    }

    public String getPackageName() {
        return InvokeDynamicSupport.bootstrap("getPackageName", $$robo$$android_view_textclassifier_SelectionEvent$getPackageName(), 0, this);
    }

    public String getWidgetType() {
        return InvokeDynamicSupport.bootstrap("getWidgetType", $$robo$$android_view_textclassifier_SelectionEvent$getWidgetType(), 0, this);
    }

    public String getWidgetVersion() {
        return InvokeDynamicSupport.bootstrap("getWidgetVersion", $$robo$$android_view_textclassifier_SelectionEvent$getWidgetVersion(), 0, this);
    }

    void setTextClassificationSessionContext(TextClassificationContext textClassificationContext) {
        InvokeDynamicSupport.bootstrap("setTextClassificationSessionContext", $$robo$$android_view_textclassifier_SelectionEvent$setTextClassificationSessionContext(android.view.textclassifier.TextClassificationContext ), 0, this, textClassificationContext);
    }

    public int getInvocationMethod() {
        return (int)InvokeDynamicSupport.bootstrap("getInvocationMethod", $$robo$$android_view_textclassifier_SelectionEvent$getInvocationMethod(), 0, this);
    }

    void setInvocationMethod(int n) {
        InvokeDynamicSupport.bootstrap("setInvocationMethod", $$robo$$android_view_textclassifier_SelectionEvent$setInvocationMethod(int ), 0, this, n);
    }

    public String getResultId() {
        return InvokeDynamicSupport.bootstrap("getResultId", $$robo$$android_view_textclassifier_SelectionEvent$getResultId(), 0, this);
    }

    SelectionEvent setResultId(String string2) {
        return InvokeDynamicSupport.bootstrap("setResultId", $$robo$$android_view_textclassifier_SelectionEvent$setResultId(java.lang.String ), 0, this, string2);
    }

    public long getEventTime() {
        return (long)InvokeDynamicSupport.bootstrap("getEventTime", $$robo$$android_view_textclassifier_SelectionEvent$getEventTime(), 0, this);
    }

    SelectionEvent setEventTime(long l) {
        return InvokeDynamicSupport.bootstrap("setEventTime", $$robo$$android_view_textclassifier_SelectionEvent$setEventTime(long ), 0, this, l);
    }

    public long getDurationSinceSessionStart() {
        return (long)InvokeDynamicSupport.bootstrap("getDurationSinceSessionStart", $$robo$$android_view_textclassifier_SelectionEvent$getDurationSinceSessionStart(), 0, this);
    }

    SelectionEvent setDurationSinceSessionStart(long l) {
        return InvokeDynamicSupport.bootstrap("setDurationSinceSessionStart", $$robo$$android_view_textclassifier_SelectionEvent$setDurationSinceSessionStart(long ), 0, this, l);
    }

    public long getDurationSincePreviousEvent() {
        return (long)InvokeDynamicSupport.bootstrap("getDurationSincePreviousEvent", $$robo$$android_view_textclassifier_SelectionEvent$getDurationSincePreviousEvent(), 0, this);
    }

    SelectionEvent setDurationSincePreviousEvent(long l) {
        return InvokeDynamicSupport.bootstrap("setDurationSincePreviousEvent", $$robo$$android_view_textclassifier_SelectionEvent$setDurationSincePreviousEvent(long ), 0, this, l);
    }

    public int getEventIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getEventIndex", $$robo$$android_view_textclassifier_SelectionEvent$getEventIndex(), 0, this);
    }

    SelectionEvent setEventIndex(int n) {
        return InvokeDynamicSupport.bootstrap("setEventIndex", $$robo$$android_view_textclassifier_SelectionEvent$setEventIndex(int ), 0, this, n);
    }

    public TextClassificationSessionId getSessionId() {
        return InvokeDynamicSupport.bootstrap("getSessionId", $$robo$$android_view_textclassifier_SelectionEvent$getSessionId(), 0, this);
    }

    SelectionEvent setSessionId(TextClassificationSessionId textClassificationSessionId) {
        return InvokeDynamicSupport.bootstrap("setSessionId", $$robo$$android_view_textclassifier_SelectionEvent$setSessionId(android.view.textclassifier.TextClassificationSessionId ), 0, this, textClassificationSessionId);
    }

    public int getStart() {
        return (int)InvokeDynamicSupport.bootstrap("getStart", $$robo$$android_view_textclassifier_SelectionEvent$getStart(), 0, this);
    }

    SelectionEvent setStart(int n) {
        return InvokeDynamicSupport.bootstrap("setStart", $$robo$$android_view_textclassifier_SelectionEvent$setStart(int ), 0, this, n);
    }

    public int getEnd() {
        return (int)InvokeDynamicSupport.bootstrap("getEnd", $$robo$$android_view_textclassifier_SelectionEvent$getEnd(), 0, this);
    }

    SelectionEvent setEnd(int n) {
        return InvokeDynamicSupport.bootstrap("setEnd", $$robo$$android_view_textclassifier_SelectionEvent$setEnd(int ), 0, this, n);
    }

    public int getSmartStart() {
        return (int)InvokeDynamicSupport.bootstrap("getSmartStart", $$robo$$android_view_textclassifier_SelectionEvent$getSmartStart(), 0, this);
    }

    SelectionEvent setSmartStart(int n) {
        return InvokeDynamicSupport.bootstrap("setSmartStart", $$robo$$android_view_textclassifier_SelectionEvent$setSmartStart(int ), 0, this, n);
    }

    public int getSmartEnd() {
        return (int)InvokeDynamicSupport.bootstrap("getSmartEnd", $$robo$$android_view_textclassifier_SelectionEvent$getSmartEnd(), 0, this);
    }

    SelectionEvent setSmartEnd(int n) {
        return InvokeDynamicSupport.bootstrap("setSmartEnd", $$robo$$android_view_textclassifier_SelectionEvent$setSmartEnd(int ), 0, this, n);
    }

    boolean isTerminal() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTerminal", $$robo$$android_view_textclassifier_SelectionEvent$isTerminal(), 0, this);
    }

    public static boolean isTerminal(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isTerminal", $$robo$$android_view_textclassifier_SelectionEvent$isTerminal(int ), 0, (int)n);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_view_textclassifier_SelectionEvent$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_view_textclassifier_SelectionEvent$equals(java.lang.Object ), 0, this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_textclassifier_SelectionEvent$toString(), 0, this);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_view_textclassifier_SelectionEvent$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(SelectionEvent.class);
    }

    public /* synthetic */ SelectionEvent() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SelectionEvent)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InvocationMethod {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EventType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ActionType {
    }
}

