/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.Context;
import android.metrics.LogMaker;
import android.view.textclassifier.SelectionEvent;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.text.BreakIterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class SelectionSessionLogger
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "SelectionSessionLogger";
    private static boolean DEBUG_LOG_ENABLED = false;
    static String CLASSIFIER_ID = "androidtc";
    private static int START_EVENT_DELTA = 1117;
    private static int PREV_EVENT_DELTA = 1118;
    private static int INDEX = 1120;
    private static int WIDGET_TYPE = 1255;
    private static int WIDGET_VERSION = 1262;
    private static int MODEL_NAME = 1256;
    private static int ENTITY_TYPE = 1254;
    private static int SMART_START = 1252;
    private static int SMART_END = 1253;
    private static int EVENT_START = 1250;
    private static int EVENT_END = 1251;
    private static int SESSION_ID = 1119;
    private static String ZERO = "0";
    private static String UNKNOWN = "unknown";
    private MetricsLogger mMetricsLogger;

    private void $$robo$$android_view_textclassifier_SelectionSessionLogger$__constructor__() {
        this.mMetricsLogger = new MetricsLogger();
    }

    @VisibleForTesting
    private void $$robo$$android_view_textclassifier_SelectionSessionLogger$__constructor__(MetricsLogger metricsLogger) {
        this.mMetricsLogger = Preconditions.checkNotNull(metricsLogger);
    }

    private final void $$robo$$android_view_textclassifier_SelectionSessionLogger$writeEvent(SelectionEvent event) {
        Preconditions.checkNotNull(event);
        LogMaker log = new LogMaker(1100).setType(SelectionSessionLogger.getLogType(event)).setSubtype(SelectionSessionLogger.getLogSubType(event)).setPackageName(event.getPackageName()).addTaggedData(1117, event.getDurationSinceSessionStart()).addTaggedData(1118, event.getDurationSincePreviousEvent()).addTaggedData(1120, event.getEventIndex()).addTaggedData(1255, event.getWidgetType()).addTaggedData(1262, event.getWidgetVersion()).addTaggedData(1256, SignatureParser.getModelName(event.getResultId())).addTaggedData(1254, event.getEntityType()).addTaggedData(1252, event.getSmartStart()).addTaggedData(1253, event.getSmartEnd()).addTaggedData(1250, event.getStart()).addTaggedData(1251, event.getEnd());
        if (event.getSessionId() != null) {
            log.addTaggedData(1119, event.getSessionId().flattenToString());
        }
        this.mMetricsLogger.write(log);
        SelectionSessionLogger.debugLog(log);
    }

    private static final int $$robo$$android_view_textclassifier_SelectionSessionLogger$getLogType(SelectionEvent event) {
        switch (event.getEventType()) {
            case 100: {
                return 1108;
            }
            case 101: {
                return 1109;
            }
            case 102: {
                return 1110;
            }
            case 103: {
                return 1111;
            }
            case 104: {
                return 1112;
            }
            case 105: {
                return 1113;
            }
            case 106: {
                return 1114;
            }
            case 107: {
                return 1115;
            }
            case 108: {
                return 1116;
            }
            case 200: {
                return 1103;
            }
            case 201: {
                return 1104;
            }
            case 1: {
                return 1101;
            }
            case 2: {
                return 1102;
            }
            case 3: {
                return 1105;
            }
            case 4: {
                return 1106;
            }
            case 5: {
                return 1107;
            }
        }
        return 0;
    }

    private static final int $$robo$$android_view_textclassifier_SelectionSessionLogger$getLogSubType(SelectionEvent event) {
        switch (event.getInvocationMethod()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    private static final String $$robo$$android_view_textclassifier_SelectionSessionLogger$getLogTypeString(int logType) {
        switch (logType) {
            case 1108: {
                return "OVERTYPE";
            }
            case 1109: {
                return "COPY";
            }
            case 1110: {
                return "PASTE";
            }
            case 1111: {
                return "CUT";
            }
            case 1112: {
                return "SHARE";
            }
            case 1113: {
                return "SMART_SHARE";
            }
            case 1114: {
                return "DRAG";
            }
            case 1115: {
                return "ABANDON";
            }
            case 1116: {
                return "OTHER";
            }
            case 1103: {
                return "SELECT_ALL";
            }
            case 1104: {
                return "RESET";
            }
            case 1101: {
                return "SELECTION_STARTED";
            }
            case 1102: {
                return "SELECTION_MODIFIED";
            }
            case 1105: {
                return "SMART_SELECTION_SINGLE";
            }
            case 1106: {
                return "SMART_SELECTION_MULTI";
            }
            case 1107: {
                return "AUTO_SELECTION";
            }
        }
        return "unknown";
    }

    private static final String $$robo$$android_view_textclassifier_SelectionSessionLogger$getLogSubTypeString(int logSubType) {
        switch (logSubType) {
            case 1: {
                return "MANUAL";
            }
            case 2: {
                return "LINK";
            }
        }
        return "unknown";
    }

    private static final void $$robo$$android_view_textclassifier_SelectionSessionLogger$debugLog(LogMaker log) {
    }

    private static final BreakIterator $$robo$$android_view_textclassifier_SelectionSessionLogger$getTokenIterator(Locale locale) {
        return BreakIterator.getWordInstance(Preconditions.checkNotNull(locale));
    }

    private static final String $$robo$$android_view_textclassifier_SelectionSessionLogger$createId(String text, int start, int end, Context context, int modelVersion, List<Locale> locales) {
        Preconditions.checkNotNull(text);
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(locales);
        StringJoiner localesJoiner = new StringJoiner(",");
        for (Locale locale : locales) {
            localesJoiner.add(locale.toLanguageTag());
        }
        String modelName = String.format(Locale.US, "%s_v%d", localesJoiner.toString(), modelVersion);
        int hash = Objects.hash(text, start, end, context.getPackageName());
        return SignatureParser.createSignature("androidtc", modelName, hash);
    }

    private void __constructor__() {
        this.$$robo$$android_view_textclassifier_SelectionSessionLogger$__constructor__();
    }

    public SelectionSessionLogger() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_SelectionSessionLogger$__constructor__(), 0, this);
    }

    private void __constructor__(MetricsLogger metricsLogger) {
        this.$$robo$$android_view_textclassifier_SelectionSessionLogger$__constructor__(metricsLogger);
    }

    public SelectionSessionLogger(MetricsLogger metricsLogger) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_SelectionSessionLogger$__constructor__(com.android.internal.logging.MetricsLogger ), 0, this, metricsLogger);
    }

    public void writeEvent(SelectionEvent selectionEvent) {
        InvokeDynamicSupport.bootstrap("writeEvent", $$robo$$android_view_textclassifier_SelectionSessionLogger$writeEvent(android.view.textclassifier.SelectionEvent ), 0, this, selectionEvent);
    }

    private static int getLogType(SelectionEvent selectionEvent) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getLogType", $$robo$$android_view_textclassifier_SelectionSessionLogger$getLogType(android.view.textclassifier.SelectionEvent ), 0, (SelectionEvent)selectionEvent);
    }

    private static int getLogSubType(SelectionEvent selectionEvent) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getLogSubType", $$robo$$android_view_textclassifier_SelectionSessionLogger$getLogSubType(android.view.textclassifier.SelectionEvent ), 0, (SelectionEvent)selectionEvent);
    }

    private static String getLogTypeString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getLogTypeString", $$robo$$android_view_textclassifier_SelectionSessionLogger$getLogTypeString(int ), 0, (int)n);
    }

    private static String getLogSubTypeString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getLogSubTypeString", $$robo$$android_view_textclassifier_SelectionSessionLogger$getLogSubTypeString(int ), 0, (int)n);
    }

    private static void debugLog(LogMaker logMaker) {
        InvokeDynamicSupport.bootstrapStatic("debugLog", $$robo$$android_view_textclassifier_SelectionSessionLogger$debugLog(android.metrics.LogMaker ), 0, (LogMaker)logMaker);
    }

    public static BreakIterator getTokenIterator(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getTokenIterator", $$robo$$android_view_textclassifier_SelectionSessionLogger$getTokenIterator(java.util.Locale ), 0, (Locale)locale);
    }

    public static String createId(String string2, int n, int n2, Context context, int n3, List<Locale> list) {
        return InvokeDynamicSupport.bootstrapStatic("createId", $$robo$$android_view_textclassifier_SelectionSessionLogger$createId(java.lang.String int int android.content.Context int java.util.List<java.util.Locale> ), 0, (String)string2, (int)n, (int)n2, (Context)context, (int)n3, list);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SelectionSessionLogger)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    @VisibleForTesting
    public static final class SignatureParser
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_view_textclassifier_SelectionSessionLogger_SignatureParser$__constructor__() {
        }

        private static final String $$robo$$android_view_textclassifier_SelectionSessionLogger_SignatureParser$createSignature(String classifierId, String modelName, int hash) {
            return String.format(Locale.US, "%s|%s|%d", classifierId, modelName, hash);
        }

        private static final String $$robo$$android_view_textclassifier_SelectionSessionLogger_SignatureParser$getClassifierId(String signature) {
            if (signature == null) {
                return "";
            }
            int end = signature.indexOf("|");
            if (end >= 0) {
                return signature.substring(0, end);
            }
            return "";
        }

        private static final String $$robo$$android_view_textclassifier_SelectionSessionLogger_SignatureParser$getModelName(String signature) {
            if (signature == null) {
                return "";
            }
            int start = signature.indexOf("|") + 1;
            int end = signature.indexOf("|", start);
            if (start >= 1 && end >= start) {
                return signature.substring(start, end);
            }
            return "";
        }

        private static final int $$robo$$android_view_textclassifier_SelectionSessionLogger_SignatureParser$getHash(String signature) {
            if (signature == null) {
                return 0;
            }
            int index1 = signature.indexOf("|");
            int index2 = signature.indexOf("|", index1);
            if (index2 > 0) {
                return Integer.parseInt(signature.substring(index2));
            }
            return 0;
        }

        private void __constructor__() {
            this.$$robo$$android_view_textclassifier_SelectionSessionLogger_SignatureParser$__constructor__();
        }

        public SignatureParser() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_SelectionSessionLogger_SignatureParser$__constructor__(), 0, this);
        }

        static String createSignature(String string2, String string3, int n) {
            return InvokeDynamicSupport.bootstrapStatic("createSignature", $$robo$$android_view_textclassifier_SelectionSessionLogger_SignatureParser$createSignature(java.lang.String java.lang.String int ), 0, (String)string2, (String)string3, (int)n);
        }

        static String getClassifierId(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("getClassifierId", $$robo$$android_view_textclassifier_SelectionSessionLogger_SignatureParser$getClassifierId(java.lang.String ), 0, (String)string2);
        }

        static String getModelName(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("getModelName", $$robo$$android_view_textclassifier_SelectionSessionLogger_SignatureParser$getModelName(java.lang.String ), 0, (String)string2);
        }

        static int getHash(String string2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("getHash", $$robo$$android_view_textclassifier_SelectionSessionLogger_SignatureParser$getHash(java.lang.String ), 0, (String)string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SignatureParser)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

