/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.service.textclassifier.ITextClassificationCallback;
import android.service.textclassifier.ITextClassifierService;
import android.service.textclassifier.ITextLinksCallback;
import android.service.textclassifier.ITextSelectionCallback;
import android.view.textclassifier.Log;
import android.view.textclassifier.SelectionEvent;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassificationConstants;
import android.view.textclassifier.TextClassificationContext;
import android.view.textclassifier.TextClassificationManager;
import android.view.textclassifier.TextClassificationSessionId;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextLinks;
import android.view.textclassifier.TextSelection;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class SystemTextClassifier
implements TextClassifier,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "SystemTextClassifier";
    private ITextClassifierService mManagerService;
    private TextClassificationConstants mSettings;
    private TextClassifier mFallback;
    private String mPackageName;
    private TextClassificationSessionId mSessionId;

    private void $$robo$$android_view_textclassifier_SystemTextClassifier$__constructor__(Context context, TextClassificationConstants settings) throws ServiceManager.ServiceNotFoundException {
        this.mManagerService = ITextClassifierService.Stub.asInterface(ServiceManager.getServiceOrThrow("textclassification"));
        this.mSettings = Preconditions.checkNotNull(settings);
        this.mFallback = context.getSystemService(TextClassificationManager.class).getTextClassifier(0);
        this.mPackageName = Preconditions.checkNotNull(context.getPackageName());
    }

    private final TextSelection $$robo$$android_view_textclassifier_SystemTextClassifier$suggestSelection(TextSelection.Request request) {
        Preconditions.checkNotNull(request);
        TextClassifier.Utils.checkMainThread();
        try {
            TextSelectionCallback callback = new TextSelectionCallback();
            this.mManagerService.onSuggestSelection(this.mSessionId, request, callback);
            TextSelection selection = callback.mReceiver.get();
            if (selection != null) {
                return selection;
            }
        }
        catch (RemoteException | InterruptedException e) {
            Log.e("SystemTextClassifier", "Error suggesting selection for text. Using fallback.", e);
        }
        return this.mFallback.suggestSelection(request);
    }

    private final TextClassification $$robo$$android_view_textclassifier_SystemTextClassifier$classifyText(TextClassification.Request request) {
        Preconditions.checkNotNull(request);
        TextClassifier.Utils.checkMainThread();
        try {
            TextClassificationCallback callback = new TextClassificationCallback();
            this.mManagerService.onClassifyText(this.mSessionId, request, callback);
            TextClassification classification = callback.mReceiver.get();
            if (classification != null) {
                return classification;
            }
        }
        catch (RemoteException | InterruptedException e) {
            Log.e("SystemTextClassifier", "Error classifying text. Using fallback.", e);
        }
        return this.mFallback.classifyText(request);
    }

    private final TextLinks $$robo$$android_view_textclassifier_SystemTextClassifier$generateLinks(TextLinks.Request request) {
        Preconditions.checkNotNull(request);
        TextClassifier.Utils.checkMainThread();
        if (!this.mSettings.isSmartLinkifyEnabled() && request.isLegacyFallback()) {
            return TextClassifier.Utils.generateLegacyLinks(request);
        }
        try {
            request.setCallingPackageName(this.mPackageName);
            TextLinksCallback callback = new TextLinksCallback();
            this.mManagerService.onGenerateLinks(this.mSessionId, request, callback);
            TextLinks links = callback.mReceiver.get();
            if (links != null) {
                return links;
            }
        }
        catch (RemoteException | InterruptedException e) {
            Log.e("SystemTextClassifier", "Error generating links. Using fallback.", e);
        }
        return this.mFallback.generateLinks(request);
    }

    private final void $$robo$$android_view_textclassifier_SystemTextClassifier$onSelectionEvent(SelectionEvent event) {
        Preconditions.checkNotNull(event);
        TextClassifier.Utils.checkMainThread();
        try {
            this.mManagerService.onSelectionEvent(this.mSessionId, event);
        }
        catch (RemoteException e) {
            Log.e("SystemTextClassifier", "Error reporting selection event.", e);
        }
    }

    private final int $$robo$$android_view_textclassifier_SystemTextClassifier$getMaxGenerateLinksTextLength() {
        return this.mFallback.getMaxGenerateLinksTextLength();
    }

    private final void $$robo$$android_view_textclassifier_SystemTextClassifier$destroy() {
        try {
            if (this.mSessionId != null) {
                this.mManagerService.onDestroyTextClassificationSession(this.mSessionId);
            }
        }
        catch (RemoteException e) {
            Log.e("SystemTextClassifier", "Error destroying classification session.", e);
        }
    }

    private final void $$robo$$android_view_textclassifier_SystemTextClassifier$initializeRemoteSession(TextClassificationContext classificationContext, TextClassificationSessionId sessionId) {
        this.mSessionId = Preconditions.checkNotNull(sessionId);
        try {
            this.mManagerService.onCreateTextClassificationSession(classificationContext, this.mSessionId);
        }
        catch (RemoteException e) {
            Log.e("SystemTextClassifier", "Error starting a new classification session.", e);
        }
    }

    private void __constructor__(Context context, TextClassificationConstants textClassificationConstants) throws ServiceManager.ServiceNotFoundException {
        this.$$robo$$android_view_textclassifier_SystemTextClassifier$__constructor__(context, textClassificationConstants);
    }

    public SystemTextClassifier(Context context, TextClassificationConstants textClassificationConstants) throws ServiceManager.ServiceNotFoundException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_SystemTextClassifier$__constructor__(android.content.Context android.view.textclassifier.TextClassificationConstants ), 0, this, context, textClassificationConstants);
    }

    @Override
    public TextSelection suggestSelection(TextSelection.Request request) {
        return InvokeDynamicSupport.bootstrap("suggestSelection", $$robo$$android_view_textclassifier_SystemTextClassifier$suggestSelection(android.view.textclassifier.TextSelection$Request ), 0, this, request);
    }

    @Override
    public TextClassification classifyText(TextClassification.Request request) {
        return InvokeDynamicSupport.bootstrap("classifyText", $$robo$$android_view_textclassifier_SystemTextClassifier$classifyText(android.view.textclassifier.TextClassification$Request ), 0, this, request);
    }

    @Override
    public TextLinks generateLinks(TextLinks.Request request) {
        return InvokeDynamicSupport.bootstrap("generateLinks", $$robo$$android_view_textclassifier_SystemTextClassifier$generateLinks(android.view.textclassifier.TextLinks$Request ), 0, this, request);
    }

    @Override
    public void onSelectionEvent(SelectionEvent selectionEvent) {
        InvokeDynamicSupport.bootstrap("onSelectionEvent", $$robo$$android_view_textclassifier_SystemTextClassifier$onSelectionEvent(android.view.textclassifier.SelectionEvent ), 0, this, selectionEvent);
    }

    @Override
    public int getMaxGenerateLinksTextLength() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxGenerateLinksTextLength", $$robo$$android_view_textclassifier_SystemTextClassifier$getMaxGenerateLinksTextLength(), 0, this);
    }

    @Override
    public void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_view_textclassifier_SystemTextClassifier$destroy(), 0, this);
    }

    void initializeRemoteSession(TextClassificationContext textClassificationContext, TextClassificationSessionId textClassificationSessionId) {
        InvokeDynamicSupport.bootstrap("initializeRemoteSession", $$robo$$android_view_textclassifier_SystemTextClassifier$initializeRemoteSession(android.view.textclassifier.TextClassificationContext android.view.textclassifier.TextClassificationSessionId ), 0, this, textClassificationContext, textClassificationSessionId);
    }

    public /* synthetic */ SystemTextClassifier() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SystemTextClassifier)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class ResponseReceiver<T> {
        public transient /* synthetic */ Object __robo_data__;
        private CountDownLatch mLatch;
        private T mResponse;

        private void $$robo$$android_view_textclassifier_SystemTextClassifier_ResponseReceiver$__constructor__() {
            this.mLatch = new CountDownLatch(1);
        }

        private final void $$robo$$android_view_textclassifier_SystemTextClassifier_ResponseReceiver$onSuccess(T response) {
            this.mResponse = response;
            this.mLatch.countDown();
        }

        private final void $$robo$$android_view_textclassifier_SystemTextClassifier_ResponseReceiver$onFailure() {
            Log.e("SystemTextClassifier", "Request failed.", null);
            this.mLatch.countDown();
        }

        private final T $$robo$$android_view_textclassifier_SystemTextClassifier_ResponseReceiver$get() throws InterruptedException {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                this.mLatch.await(2L, TimeUnit.SECONDS);
            }
            return this.mResponse;
        }

        private /* synthetic */ void $$robo$$android_view_textclassifier_SystemTextClassifier_ResponseReceiver$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_view_textclassifier_SystemTextClassifier_ResponseReceiver$__constructor__();
        }

        private ResponseReceiver() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_SystemTextClassifier_ResponseReceiver$__constructor__(), 0, this);
        }

        public void onSuccess(T t) {
            InvokeDynamicSupport.bootstrap("onSuccess", $$robo$$android_view_textclassifier_SystemTextClassifier_ResponseReceiver$onSuccess(T ), 0, this, t);
        }

        public void onFailure() {
            InvokeDynamicSupport.bootstrap("onFailure", $$robo$$android_view_textclassifier_SystemTextClassifier_ResponseReceiver$onFailure(), 0, this);
        }

        public T get() throws InterruptedException {
            return (T)InvokeDynamicSupport.bootstrap("get", $$robo$$android_view_textclassifier_SystemTextClassifier_ResponseReceiver$get(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_view_textclassifier_SystemTextClassifier_ResponseReceiver$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResponseReceiver)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class TextLinksCallback
    extends ITextLinksCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        ResponseReceiver<TextLinks> mReceiver;

        private void $$robo$$android_view_textclassifier_SystemTextClassifier_TextLinksCallback$__constructor__() {
            this.mReceiver = new ResponseReceiver();
        }

        private final void $$robo$$android_view_textclassifier_SystemTextClassifier_TextLinksCallback$onSuccess(TextLinks links) {
            this.mReceiver.onSuccess(links);
        }

        private final void $$robo$$android_view_textclassifier_SystemTextClassifier_TextLinksCallback$onFailure() {
            this.mReceiver.onFailure();
        }

        private /* synthetic */ void $$robo$$android_view_textclassifier_SystemTextClassifier_TextLinksCallback$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_view_textclassifier_SystemTextClassifier_TextLinksCallback$__constructor__();
        }

        private TextLinksCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_SystemTextClassifier_TextLinksCallback$__constructor__(), 0, this);
        }

        @Override
        public void onSuccess(TextLinks textLinks) {
            InvokeDynamicSupport.bootstrap("onSuccess", $$robo$$android_view_textclassifier_SystemTextClassifier_TextLinksCallback$onSuccess(android.view.textclassifier.TextLinks ), 0, this, textLinks);
        }

        @Override
        public void onFailure() {
            InvokeDynamicSupport.bootstrap("onFailure", $$robo$$android_view_textclassifier_SystemTextClassifier_TextLinksCallback$onFailure(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_view_textclassifier_SystemTextClassifier_TextLinksCallback$__constructor__(var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextLinksCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class TextClassificationCallback
    extends ITextClassificationCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        ResponseReceiver<TextClassification> mReceiver;

        private void $$robo$$android_view_textclassifier_SystemTextClassifier_TextClassificationCallback$__constructor__() {
            this.mReceiver = new ResponseReceiver();
        }

        private final void $$robo$$android_view_textclassifier_SystemTextClassifier_TextClassificationCallback$onSuccess(TextClassification classification) {
            this.mReceiver.onSuccess(classification);
        }

        private final void $$robo$$android_view_textclassifier_SystemTextClassifier_TextClassificationCallback$onFailure() {
            this.mReceiver.onFailure();
        }

        private /* synthetic */ void $$robo$$android_view_textclassifier_SystemTextClassifier_TextClassificationCallback$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_view_textclassifier_SystemTextClassifier_TextClassificationCallback$__constructor__();
        }

        private TextClassificationCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_SystemTextClassifier_TextClassificationCallback$__constructor__(), 0, this);
        }

        @Override
        public void onSuccess(TextClassification textClassification) {
            InvokeDynamicSupport.bootstrap("onSuccess", $$robo$$android_view_textclassifier_SystemTextClassifier_TextClassificationCallback$onSuccess(android.view.textclassifier.TextClassification ), 0, this, textClassification);
        }

        @Override
        public void onFailure() {
            InvokeDynamicSupport.bootstrap("onFailure", $$robo$$android_view_textclassifier_SystemTextClassifier_TextClassificationCallback$onFailure(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_view_textclassifier_SystemTextClassifier_TextClassificationCallback$__constructor__(var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextClassificationCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class TextSelectionCallback
    extends ITextSelectionCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        ResponseReceiver<TextSelection> mReceiver;

        private void $$robo$$android_view_textclassifier_SystemTextClassifier_TextSelectionCallback$__constructor__() {
            this.mReceiver = new ResponseReceiver();
        }

        private final void $$robo$$android_view_textclassifier_SystemTextClassifier_TextSelectionCallback$onSuccess(TextSelection selection) {
            this.mReceiver.onSuccess(selection);
        }

        private final void $$robo$$android_view_textclassifier_SystemTextClassifier_TextSelectionCallback$onFailure() {
            this.mReceiver.onFailure();
        }

        private /* synthetic */ void $$robo$$android_view_textclassifier_SystemTextClassifier_TextSelectionCallback$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_view_textclassifier_SystemTextClassifier_TextSelectionCallback$__constructor__();
        }

        private TextSelectionCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_SystemTextClassifier_TextSelectionCallback$__constructor__(), 0, this);
        }

        @Override
        public void onSuccess(TextSelection textSelection) {
            InvokeDynamicSupport.bootstrap("onSuccess", $$robo$$android_view_textclassifier_SystemTextClassifier_TextSelectionCallback$onSuccess(android.view.textclassifier.TextSelection ), 0, this, textSelection);
        }

        @Override
        public void onFailure() {
            InvokeDynamicSupport.bootstrap("onFailure", $$robo$$android_view_textclassifier_SystemTextClassifier_TextSelectionCallback$onFailure(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_view_textclassifier_SystemTextClassifier_TextSelectionCallback$__constructor__(var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextSelectionCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

