/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.view.textclassifier.Log;
import android.view.textclassifier.SelectionEvent;
import android.view.textclassifier.SelectionSessionLogger;
import android.view.textclassifier.SystemTextClassifier;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassificationContext;
import android.view.textclassifier.TextClassificationSessionId;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextLinks;
import android.view.textclassifier.TextSelection;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.invoke.CallSite;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class TextClassificationSession
implements TextClassifier,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static boolean DEBUG_LOG_ENABLED = true;
    private static String LOG_TAG = "TextClassificationSession";
    private TextClassifier mDelegate;
    private SelectionEventHelper mEventHelper;
    private TextClassificationSessionId mSessionId;
    private TextClassificationContext mClassificationContext;
    private boolean mDestroyed;

    private void $$robo$$android_view_textclassifier_TextClassificationSession$__constructor__(TextClassificationContext context, TextClassifier delegate) {
        this.mClassificationContext = Preconditions.checkNotNull(context);
        this.mDelegate = Preconditions.checkNotNull(delegate);
        this.mSessionId = new TextClassificationSessionId();
        this.mEventHelper = new SelectionEventHelper(this.mSessionId, this.mClassificationContext);
        this.initializeRemoteSession();
    }

    private final TextSelection $$robo$$android_view_textclassifier_TextClassificationSession$suggestSelection(TextSelection.Request request) {
        this.checkDestroyed();
        return this.mDelegate.suggestSelection(request);
    }

    private final void $$robo$$android_view_textclassifier_TextClassificationSession$initializeRemoteSession() {
        if (this.mDelegate instanceof SystemTextClassifier) {
            ((SystemTextClassifier)this.mDelegate).initializeRemoteSession(this.mClassificationContext, this.mSessionId);
        }
    }

    private final TextClassification $$robo$$android_view_textclassifier_TextClassificationSession$classifyText(TextClassification.Request request) {
        this.checkDestroyed();
        return this.mDelegate.classifyText(request);
    }

    private final TextLinks $$robo$$android_view_textclassifier_TextClassificationSession$generateLinks(TextLinks.Request request) {
        this.checkDestroyed();
        return this.mDelegate.generateLinks(request);
    }

    private final void $$robo$$android_view_textclassifier_TextClassificationSession$onSelectionEvent(SelectionEvent event) {
        this.checkDestroyed();
        Preconditions.checkNotNull(event);
        if (this.mEventHelper.sanitizeEvent(event)) {
            this.mDelegate.onSelectionEvent(event);
        }
    }

    private final void $$robo$$android_view_textclassifier_TextClassificationSession$destroy() {
        this.mEventHelper.endSession();
        this.mDelegate.destroy();
        this.mDestroyed = true;
    }

    private final boolean $$robo$$android_view_textclassifier_TextClassificationSession$isDestroyed() {
        return this.mDestroyed;
    }

    private final void $$robo$$android_view_textclassifier_TextClassificationSession$checkDestroyed() {
        if (this.mDestroyed) {
            throw new IllegalStateException("This TextClassification session has been destroyed");
        }
    }

    private void __constructor__(TextClassificationContext textClassificationContext, TextClassifier textClassifier) {
        this.$$robo$$android_view_textclassifier_TextClassificationSession$__constructor__(textClassificationContext, textClassifier);
    }

    TextClassificationSession(TextClassificationContext textClassificationContext, TextClassifier textClassifier) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassificationSession$__constructor__(android.view.textclassifier.TextClassificationContext android.view.textclassifier.TextClassifier ), 0, this, textClassificationContext, textClassifier);
    }

    @Override
    public TextSelection suggestSelection(TextSelection.Request request) {
        return InvokeDynamicSupport.bootstrap("suggestSelection", $$robo$$android_view_textclassifier_TextClassificationSession$suggestSelection(android.view.textclassifier.TextSelection$Request ), 0, this, request);
    }

    private void initializeRemoteSession() {
        InvokeDynamicSupport.bootstrap("initializeRemoteSession", $$robo$$android_view_textclassifier_TextClassificationSession$initializeRemoteSession(), 0, this);
    }

    @Override
    public TextClassification classifyText(TextClassification.Request request) {
        return InvokeDynamicSupport.bootstrap("classifyText", $$robo$$android_view_textclassifier_TextClassificationSession$classifyText(android.view.textclassifier.TextClassification$Request ), 0, this, request);
    }

    @Override
    public TextLinks generateLinks(TextLinks.Request request) {
        return InvokeDynamicSupport.bootstrap("generateLinks", $$robo$$android_view_textclassifier_TextClassificationSession$generateLinks(android.view.textclassifier.TextLinks$Request ), 0, this, request);
    }

    @Override
    public void onSelectionEvent(SelectionEvent selectionEvent) {
        InvokeDynamicSupport.bootstrap("onSelectionEvent", $$robo$$android_view_textclassifier_TextClassificationSession$onSelectionEvent(android.view.textclassifier.SelectionEvent ), 0, this, selectionEvent);
    }

    @Override
    public void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_view_textclassifier_TextClassificationSession$destroy(), 0, this);
    }

    @Override
    public boolean isDestroyed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDestroyed", $$robo$$android_view_textclassifier_TextClassificationSession$isDestroyed(), 0, this);
    }

    private void checkDestroyed() {
        InvokeDynamicSupport.bootstrap("checkDestroyed", $$robo$$android_view_textclassifier_TextClassificationSession$checkDestroyed(), 0, this);
    }

    public /* synthetic */ TextClassificationSession() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextClassificationSession)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class SelectionEventHelper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private TextClassificationSessionId mSessionId;
        private TextClassificationContext mContext;
        private int mInvocationMethod;
        private SelectionEvent mPrevEvent;
        private SelectionEvent mSmartEvent;
        private SelectionEvent mStartEvent;

        private void $$robo$$android_view_textclassifier_TextClassificationSession_SelectionEventHelper$__constructor__(TextClassificationSessionId sessionId, TextClassificationContext context) {
            this.mInvocationMethod = 0;
            this.mSessionId = Preconditions.checkNotNull(sessionId);
            this.mContext = Preconditions.checkNotNull(context);
        }

        private final boolean $$robo$$android_view_textclassifier_TextClassificationSession_SelectionEventHelper$sanitizeEvent(SelectionEvent event) {
            this.updateInvocationMethod(event);
            this.modifyAutoSelectionEventType(event);
            if (event.getEventType() != 1 && this.mStartEvent == null) {
                Log.d("TextClassificationSession", "Selection session not yet started. Ignoring event");
                return false;
            }
            CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            switch (event.getEventType()) {
                case 1: {
                    Preconditions.checkArgument(event.getAbsoluteEnd() == event.getAbsoluteStart() + 1);
                    event.setSessionId(this.mSessionId);
                    this.mStartEvent = event;
                    break;
                }
                case 3: 
                case 4: {
                    this.mSmartEvent = event;
                    break;
                }
                case 2: 
                case 5: {
                    if (this.mPrevEvent == null || this.mPrevEvent.getAbsoluteStart() != event.getAbsoluteStart() || this.mPrevEvent.getAbsoluteEnd() != event.getAbsoluteEnd()) break;
                    return false;
                }
            }
            event.setEventTime((long)now);
            if (this.mStartEvent != null) {
                event.setSessionId(this.mStartEvent.getSessionId()).setDurationSinceSessionStart((long)(now - this.mStartEvent.getEventTime())).setStart(event.getAbsoluteStart() - this.mStartEvent.getAbsoluteStart()).setEnd(event.getAbsoluteEnd() - this.mStartEvent.getAbsoluteStart());
            }
            if (this.mSmartEvent != null) {
                event.setResultId(this.mSmartEvent.getResultId()).setSmartStart(this.mSmartEvent.getAbsoluteStart() - this.mStartEvent.getAbsoluteStart()).setSmartEnd(this.mSmartEvent.getAbsoluteEnd() - this.mStartEvent.getAbsoluteStart());
            }
            if (this.mPrevEvent != null) {
                event.setDurationSincePreviousEvent((long)(now - this.mPrevEvent.getEventTime())).setEventIndex(this.mPrevEvent.getEventIndex() + 1);
            }
            this.mPrevEvent = event;
            return true;
        }

        private final void $$robo$$android_view_textclassifier_TextClassificationSession_SelectionEventHelper$endSession() {
            this.mPrevEvent = null;
            this.mSmartEvent = null;
            this.mStartEvent = null;
        }

        private final void $$robo$$android_view_textclassifier_TextClassificationSession_SelectionEventHelper$updateInvocationMethod(SelectionEvent event) {
            event.setTextClassificationSessionContext(this.mContext);
            if (event.getInvocationMethod() == 0) {
                event.setInvocationMethod(this.mInvocationMethod);
            } else {
                this.mInvocationMethod = event.getInvocationMethod();
            }
        }

        private final void $$robo$$android_view_textclassifier_TextClassificationSession_SelectionEventHelper$modifyAutoSelectionEventType(SelectionEvent event) {
            switch (event.getEventType()) {
                case 3: 
                case 4: 
                case 5: {
                    if (SelectionEventHelper.isPlatformLocalTextClassifierSmartSelection(event.getResultId())) {
                        if (event.getAbsoluteEnd() - event.getAbsoluteStart() > 1) {
                            event.setEventType(4);
                        } else {
                            event.setEventType(3);
                        }
                    } else {
                        event.setEventType(5);
                    }
                    return;
                }
            }
        }

        private static final boolean $$robo$$android_view_textclassifier_TextClassificationSession_SelectionEventHelper$isPlatformLocalTextClassifierSmartSelection(String signature) {
            return "androidtc".equals(SelectionSessionLogger.SignatureParser.getClassifierId(signature));
        }

        private void __constructor__(TextClassificationSessionId textClassificationSessionId, TextClassificationContext textClassificationContext) {
            this.$$robo$$android_view_textclassifier_TextClassificationSession_SelectionEventHelper$__constructor__(textClassificationSessionId, textClassificationContext);
        }

        SelectionEventHelper(TextClassificationSessionId textClassificationSessionId, TextClassificationContext textClassificationContext) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassificationSession_SelectionEventHelper$__constructor__(android.view.textclassifier.TextClassificationSessionId android.view.textclassifier.TextClassificationContext ), 0, this, textClassificationSessionId, textClassificationContext);
        }

        boolean sanitizeEvent(SelectionEvent selectionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("sanitizeEvent", $$robo$$android_view_textclassifier_TextClassificationSession_SelectionEventHelper$sanitizeEvent(android.view.textclassifier.SelectionEvent ), 0, this, selectionEvent);
        }

        void endSession() {
            InvokeDynamicSupport.bootstrap("endSession", $$robo$$android_view_textclassifier_TextClassificationSession_SelectionEventHelper$endSession(), 0, this);
        }

        private void updateInvocationMethod(SelectionEvent selectionEvent) {
            InvokeDynamicSupport.bootstrap("updateInvocationMethod", $$robo$$android_view_textclassifier_TextClassificationSession_SelectionEventHelper$updateInvocationMethod(android.view.textclassifier.SelectionEvent ), 0, this, selectionEvent);
        }

        private void modifyAutoSelectionEventType(SelectionEvent selectionEvent) {
            InvokeDynamicSupport.bootstrap("modifyAutoSelectionEventType", $$robo$$android_view_textclassifier_TextClassificationSession_SelectionEventHelper$modifyAutoSelectionEventType(android.view.textclassifier.SelectionEvent ), 0, this, selectionEvent);
        }

        private static boolean isPlatformLocalTextClassifierSmartSelection(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isPlatformLocalTextClassifierSmartSelection", $$robo$$android_view_textclassifier_TextClassificationSession_SelectionEventHelper$isPlatformLocalTextClassifierSmartSelection(java.lang.String ), 0, (String)string2);
        }

        public /* synthetic */ SelectionEventHelper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SelectionEventHelper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

