/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.os.LocaleList;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.SpannableString;
import android.text.style.URLSpan;
import android.text.util.Linkify;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.view.textclassifier.Log;
import android.view.textclassifier.SelectionEvent;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextLinks;
import android.view.textclassifier.TextSelection;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public interface TextClassifier
extends InstrumentedInterface {
    public static final String DEFAULT_LOG_TAG = "androidtc";
    public static final int LOCAL = 0;
    public static final int SYSTEM = 1;
    public static final String TYPE_UNKNOWN = "";
    public static final String TYPE_OTHER = "other";
    public static final String TYPE_EMAIL = "email";
    public static final String TYPE_PHONE = "phone";
    public static final String TYPE_ADDRESS = "address";
    public static final String TYPE_URL = "url";
    public static final String TYPE_DATE = "date";
    public static final String TYPE_DATE_TIME = "datetime";
    public static final String TYPE_FLIGHT_NUMBER = "flight";
    public static final String HINT_TEXT_IS_EDITABLE = "android.text_is_editable";
    public static final String HINT_TEXT_IS_NOT_EDITABLE = "android.text_is_not_editable";
    public static final String WIDGET_TYPE_TEXTVIEW = "textview";
    public static final String WIDGET_TYPE_EDITTEXT = "edittext";
    public static final String WIDGET_TYPE_UNSELECTABLE_TEXTVIEW = "nosel-textview";
    public static final String WIDGET_TYPE_WEBVIEW = "webview";
    public static final String WIDGET_TYPE_EDIT_WEBVIEW = "edit-webview";
    public static final String WIDGET_TYPE_CUSTOM_TEXTVIEW = "customview";
    public static final String WIDGET_TYPE_CUSTOM_EDITTEXT = "customedit";
    public static final String WIDGET_TYPE_CUSTOM_UNSELECTABLE_TEXTVIEW = "nosel-customview";
    public static final String WIDGET_TYPE_UNKNOWN = "unknown";
    public static final TextClassifier NO_OP = new TextClassifier(){
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_view_textclassifier_TextClassifier_1$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_view_textclassifier_TextClassifier_1$__constructor__();
        }
        {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassifier_1$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    };

    default public TextSelection suggestSelection(TextSelection.Request request) {
        Preconditions.checkNotNull(request);
        Utils.checkMainThread();
        return new TextSelection.Builder(request.getStartIndex(), request.getEndIndex()).build();
    }

    default public TextSelection suggestSelection(CharSequence text, int selectionStartIndex, int selectionEndIndex, LocaleList defaultLocales) {
        TextSelection.Request request = new TextSelection.Request.Builder(text, selectionStartIndex, selectionEndIndex).setDefaultLocales(defaultLocales).build();
        return this.suggestSelection(request);
    }

    default public TextSelection suggestSelection(CharSequence text, int selectionStartIndex, int selectionEndIndex, TextSelection.Options options) {
        if (options == null) {
            return this.suggestSelection(new TextSelection.Request.Builder(text, selectionStartIndex, selectionEndIndex).build());
        }
        if (options.getRequest() != null) {
            return this.suggestSelection(options.getRequest());
        }
        return this.suggestSelection(new TextSelection.Request.Builder(text, selectionStartIndex, selectionEndIndex).setDefaultLocales(options.getDefaultLocales()).build());
    }

    default public TextClassification classifyText(TextClassification.Request request) {
        Preconditions.checkNotNull(request);
        Utils.checkMainThread();
        return TextClassification.EMPTY;
    }

    default public TextClassification classifyText(CharSequence text, int startIndex, int endIndex, LocaleList defaultLocales) {
        TextClassification.Request request = new TextClassification.Request.Builder(text, startIndex, endIndex).setDefaultLocales(defaultLocales).build();
        return this.classifyText(request);
    }

    default public TextClassification classifyText(CharSequence text, int startIndex, int endIndex, TextClassification.Options options) {
        if (options == null) {
            return this.classifyText(new TextClassification.Request.Builder(text, startIndex, endIndex).build());
        }
        if (options.getRequest() != null) {
            return this.classifyText(options.getRequest());
        }
        return this.classifyText(new TextClassification.Request.Builder(text, startIndex, endIndex).setDefaultLocales(options.getDefaultLocales()).setReferenceTime(options.getReferenceTime()).build());
    }

    default public TextLinks generateLinks(TextLinks.Request request) {
        Preconditions.checkNotNull(request);
        Utils.checkMainThread();
        return new TextLinks.Builder(request.getText().toString()).build();
    }

    default public TextLinks generateLinks(CharSequence text, TextLinks.Options options) {
        if (options == null) {
            return this.generateLinks(new TextLinks.Request.Builder(text).build());
        }
        if (options.getRequest() != null) {
            return this.generateLinks(options.getRequest());
        }
        return this.generateLinks(new TextLinks.Request.Builder(text).setDefaultLocales(options.getDefaultLocales()).setEntityConfig(options.getEntityConfig()).build());
    }

    default public int getMaxGenerateLinksTextLength() {
        return Integer.MAX_VALUE;
    }

    default public void onSelectionEvent(SelectionEvent event) {
    }

    default public void destroy() {
    }

    default public boolean isDestroyed() {
        return false;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Utils
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_view_textclassifier_TextClassifier_Utils$__constructor__() {
        }

        private static final void $$robo$$android_view_textclassifier_TextClassifier_Utils$checkArgument(CharSequence text, int startIndex, int endIndex) {
            Preconditions.checkArgument(text != null);
            Preconditions.checkArgument(startIndex >= 0);
            Preconditions.checkArgument(endIndex <= text.length());
            Preconditions.checkArgument(endIndex > startIndex);
        }

        private static final void $$robo$$android_view_textclassifier_TextClassifier_Utils$checkTextLength(CharSequence text, int maxLength) {
            Preconditions.checkArgumentInRange(text.length(), 0, maxLength, "text.length()");
        }

        private static final TextLinks $$robo$$android_view_textclassifier_TextClassifier_Utils$generateLegacyLinks(TextLinks.Request request) {
            String string2 = request.getText().toString();
            TextLinks.Builder links = new TextLinks.Builder(string2);
            Collection<String> entities = request.getEntityConfig().resolveEntityListModifications(Collections.emptyList());
            if (entities.contains(TextClassifier.TYPE_URL)) {
                Utils.addLinks(links, string2, TextClassifier.TYPE_URL);
            }
            if (entities.contains(TextClassifier.TYPE_PHONE)) {
                Utils.addLinks(links, string2, TextClassifier.TYPE_PHONE);
            }
            if (entities.contains(TextClassifier.TYPE_EMAIL)) {
                Utils.addLinks(links, string2, TextClassifier.TYPE_EMAIL);
            }
            return links.build();
        }

        private static final void $$robo$$android_view_textclassifier_TextClassifier_Utils$addLinks(TextLinks.Builder links, String string2, String entityType) {
            SpannableString spannable = new SpannableString(string2);
            if (Linkify.addLinks(spannable, Utils.linkMask(entityType))) {
                URLSpan[] spans;
                for (URLSpan urlSpan : spans = spannable.getSpans(0, spannable.length(), URLSpan.class)) {
                    links.addLink(spannable.getSpanStart(urlSpan), spannable.getSpanEnd(urlSpan), Utils.entityScores(entityType), urlSpan);
                }
            }
        }

        private static final int $$robo$$android_view_textclassifier_TextClassifier_Utils$linkMask(String entityType) {
            switch (entityType) {
                case "url": {
                    return 1;
                }
                case "phone": {
                    return 4;
                }
                case "email": {
                    return 2;
                }
            }
            return 0;
        }

        private static final Map<String, Float> $$robo$$android_view_textclassifier_TextClassifier_Utils$entityScores(String entityType) {
            ArrayMap<String, Float> scores = new ArrayMap<String, Float>();
            scores.put(entityType, Float.valueOf(1.0f));
            return scores;
        }

        private static final void $$robo$$android_view_textclassifier_TextClassifier_Utils$checkMainThread() {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                Log.w(TextClassifier.DEFAULT_LOG_TAG, "TextClassifier called on main thread");
            }
        }

        private void __constructor__() {
            this.$$robo$$android_view_textclassifier_TextClassifier_Utils$__constructor__();
        }

        public Utils() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassifier_Utils$__constructor__(), 0, this);
        }

        static void checkArgument(CharSequence charSequence, int n, int n2) {
            InvokeDynamicSupport.bootstrapStatic("checkArgument", $$robo$$android_view_textclassifier_TextClassifier_Utils$checkArgument(java.lang.CharSequence int int ), 0, (CharSequence)charSequence, (int)n, (int)n2);
        }

        static void checkTextLength(CharSequence charSequence, int n) {
            InvokeDynamicSupport.bootstrapStatic("checkTextLength", $$robo$$android_view_textclassifier_TextClassifier_Utils$checkTextLength(java.lang.CharSequence int ), 0, (CharSequence)charSequence, (int)n);
        }

        public static TextLinks generateLegacyLinks(TextLinks.Request request) {
            return InvokeDynamicSupport.bootstrapStatic("generateLegacyLinks", $$robo$$android_view_textclassifier_TextClassifier_Utils$generateLegacyLinks(android.view.textclassifier.TextLinks$Request ), 0, (TextLinks.Request)request);
        }

        private static void addLinks(TextLinks.Builder builder, String string2, String string3) {
            InvokeDynamicSupport.bootstrapStatic("addLinks", $$robo$$android_view_textclassifier_TextClassifier_Utils$addLinks(android.view.textclassifier.TextLinks$Builder java.lang.String java.lang.String ), 0, (TextLinks.Builder)builder, (String)string2, (String)string3);
        }

        private static int linkMask(String string2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("linkMask", $$robo$$android_view_textclassifier_TextClassifier_Utils$linkMask(java.lang.String ), 0, (String)string2);
        }

        private static Map<String, Float> entityScores(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("entityScores", $$robo$$android_view_textclassifier_TextClassifier_Utils$entityScores(java.lang.String ), 0, (String)string2);
        }

        static void checkMainThread() {
            InvokeDynamicSupport.bootstrapStatic("checkMainThread", $$robo$$android_view_textclassifier_TextClassifier_Utils$checkMainThread(), 0);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Utils)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class EntityConfig
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Collection<String> mHints;
        private Collection<String> mExcludedEntityTypes;
        private Collection<String> mIncludedEntityTypes;
        private boolean mUseHints;
        public static Parcelable.Creator<EntityConfig> CREATOR;

        private void $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$__constructor__(boolean useHints, Collection<String> hints, Collection<String> includedEntityTypes, Collection<String> excludedEntityTypes) {
            this.mHints = hints == null ? Collections.EMPTY_LIST : Collections.unmodifiableCollection(new ArraySet<String>(hints));
            this.mExcludedEntityTypes = excludedEntityTypes == null ? Collections.EMPTY_LIST : new ArraySet<String>(excludedEntityTypes);
            this.mIncludedEntityTypes = includedEntityTypes == null ? Collections.EMPTY_LIST : new ArraySet<String>(includedEntityTypes);
            this.mUseHints = useHints;
        }

        private static final EntityConfig $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$createWithHints(Collection<String> hints) {
            return new EntityConfig(true, hints, null, null);
        }

        private static final EntityConfig $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$create(Collection<String> hints) {
            return EntityConfig.createWithHints(hints);
        }

        private static final EntityConfig $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$create(Collection<String> hints, Collection<String> includedEntityTypes, Collection<String> excludedEntityTypes) {
            return new EntityConfig(true, hints, includedEntityTypes, excludedEntityTypes);
        }

        private static final EntityConfig $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$createWithExplicitEntityList(Collection<String> entityTypes) {
            return new EntityConfig(false, null, entityTypes, null);
        }

        private static final EntityConfig $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$createWithEntityList(Collection<String> entityTypes) {
            return EntityConfig.createWithExplicitEntityList(entityTypes);
        }

        private final Collection<String> $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$resolveEntityListModifications(Collection<String> entities) {
            HashSet<String> finalSet = new HashSet<String>();
            if (this.mUseHints) {
                finalSet.addAll(entities);
            }
            finalSet.addAll(this.mIncludedEntityTypes);
            finalSet.removeAll(this.mExcludedEntityTypes);
            return finalSet;
        }

        private final Collection<String> $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$getHints() {
            return this.mHints;
        }

        private final int $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$describeContents() {
            return 0;
        }

        private final void $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$writeToParcel(Parcel dest, int flags) {
            dest.writeStringList(new ArrayList<String>(this.mHints));
            dest.writeStringList(new ArrayList<String>(this.mExcludedEntityTypes));
            dest.writeStringList(new ArrayList<String>(this.mIncludedEntityTypes));
            dest.writeInt(this.mUseHints ? 1 : 0);
        }

        private void $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$__constructor__(Parcel in) {
            this.mHints = new ArraySet<String>(in.createStringArrayList());
            this.mExcludedEntityTypes = new ArraySet<String>(in.createStringArrayList());
            this.mIncludedEntityTypes = new ArraySet<String>(in.createStringArrayList());
            this.mUseHints = in.readInt() == 1;
        }

        private /* synthetic */ void $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<EntityConfig>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_view_textclassifier_TextClassifier_EntityConfig_1$__constructor__() {
                }

                private final EntityConfig $$robo$$android_view_textclassifier_TextClassifier_EntityConfig_1$createFromParcel(Parcel in) {
                    return new EntityConfig(in);
                }

                private final EntityConfig[] $$robo$$android_view_textclassifier_TextClassifier_EntityConfig_1$newArray(int size) {
                    return new EntityConfig[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_view_textclassifier_TextClassifier_EntityConfig_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassifier_EntityConfig_1$__constructor__(), 0, this);
                }

                @Override
                public EntityConfig createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_textclassifier_TextClassifier_EntityConfig_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public EntityConfig[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_textclassifier_TextClassifier_EntityConfig_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(boolean bl, Collection<String> collection, Collection<String> collection2, Collection<String> collection3) {
            this.$$robo$$android_view_textclassifier_TextClassifier_EntityConfig$__constructor__(bl, collection, collection2, collection3);
        }

        private EntityConfig(boolean bl, Collection<String> collection, Collection<String> collection2, Collection<String> collection3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$__constructor__(boolean java.util.Collection<java.lang.String> java.util.Collection<java.lang.String> java.util.Collection<java.lang.String> ), 0, this, bl, collection, collection2, collection3);
        }

        public static EntityConfig createWithHints(Collection<String> collection) {
            return InvokeDynamicSupport.bootstrapStatic("createWithHints", $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$createWithHints(java.util.Collection<java.lang.String> ), 0, collection);
        }

        public static EntityConfig create(Collection<String> collection) {
            return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$create(java.util.Collection<java.lang.String> ), 0, collection);
        }

        public static EntityConfig create(Collection<String> collection, Collection<String> collection2, Collection<String> collection3) {
            return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$create(java.util.Collection<java.lang.String> java.util.Collection<java.lang.String> java.util.Collection<java.lang.String> ), 0, collection, collection2, collection3);
        }

        public static EntityConfig createWithExplicitEntityList(Collection<String> collection) {
            return InvokeDynamicSupport.bootstrapStatic("createWithExplicitEntityList", $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$createWithExplicitEntityList(java.util.Collection<java.lang.String> ), 0, collection);
        }

        public static EntityConfig createWithEntityList(Collection<String> collection) {
            return InvokeDynamicSupport.bootstrapStatic("createWithEntityList", $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$createWithEntityList(java.util.Collection<java.lang.String> ), 0, collection);
        }

        public Collection<String> resolveEntityListModifications(Collection<String> collection) {
            return InvokeDynamicSupport.bootstrap("resolveEntityListModifications", $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$resolveEntityListModifications(java.util.Collection<java.lang.String> ), 0, this, collection);
        }

        public Collection<String> getHints() {
            return InvokeDynamicSupport.bootstrap("getHints", $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$getHints(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_view_textclassifier_TextClassifier_EntityConfig$__constructor__(parcel);
        }

        private EntityConfig(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassifier_EntityConfig$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_view_textclassifier_TextClassifier_EntityConfig$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(EntityConfig.class);
        }

        public /* synthetic */ EntityConfig() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EntityConfig)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WidgetType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Hints {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EntityType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TextClassifierType {
    }
}

