/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.Context;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Spannable;
import android.text.style.ClickableSpan;
import android.text.style.URLSpan;
import android.view.View;
import android.view.textclassifier.EntityConfidence;
import android.view.textclassifier.TextClassificationManager;
import android.view.textclassifier.TextClassificationSessionId;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextLinksParams;
import android.widget.TextView;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class TextLinks
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int STATUS_LINKS_APPLIED = 0;
    public static int STATUS_NO_LINKS_FOUND = 1;
    public static int STATUS_NO_LINKS_APPLIED = 2;
    public static int STATUS_DIFFERENT_TEXT = 3;
    public static int APPLY_STRATEGY_IGNORE = 0;
    public static int APPLY_STRATEGY_REPLACE = 1;
    private String mFullText;
    private List<TextLink> mLinks;
    public static Parcelable.Creator<TextLinks> CREATOR;

    private void $$robo$$android_view_textclassifier_TextLinks$__constructor__(String fullText, ArrayList<TextLink> links) {
        this.mFullText = fullText;
        this.mLinks = Collections.unmodifiableList(links);
    }

    private final String $$robo$$android_view_textclassifier_TextLinks$getText() {
        return this.mFullText;
    }

    private final Collection<TextLink> $$robo$$android_view_textclassifier_TextLinks$getLinks() {
        return this.mLinks;
    }

    private final int $$robo$$android_view_textclassifier_TextLinks$apply(Spannable text, int applyStrategy, Function<TextLink, TextLinkSpan> spanFactory) {
        Preconditions.checkNotNull(text);
        return new TextLinksParams.Builder().setApplyStrategy(applyStrategy).setSpanFactory(spanFactory).build().apply(text, this);
    }

    private final String $$robo$$android_view_textclassifier_TextLinks$toString() {
        return String.format(Locale.US, "TextLinks{fullText=%s, links=%s}", this.mFullText, this.mLinks);
    }

    private final int $$robo$$android_view_textclassifier_TextLinks$describeContents() {
        return 0;
    }

    private final void $$robo$$android_view_textclassifier_TextLinks$writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mFullText);
        dest.writeTypedList(this.mLinks);
    }

    private void $$robo$$android_view_textclassifier_TextLinks$__constructor__(Parcel in) {
        this.mFullText = in.readString();
        this.mLinks = in.createTypedArrayList(TextLink.CREATOR);
    }

    private /* synthetic */ void $$robo$$android_view_textclassifier_TextLinks$__constructor__(Parcel x0, 1 x1) {
    }

    private /* synthetic */ void $$robo$$android_view_textclassifier_TextLinks$__constructor__(String x0, ArrayList x1, 1 x2) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<TextLinks>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_textclassifier_TextLinks_1$__constructor__() {
            }

            private final TextLinks $$robo$$android_view_textclassifier_TextLinks_1$createFromParcel(Parcel in) {
                return new TextLinks(in);
            }

            private final TextLinks[] $$robo$$android_view_textclassifier_TextLinks_1$newArray(int size) {
                return new TextLinks[size];
            }

            private void __constructor__() {
                this.$$robo$$android_view_textclassifier_TextLinks_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextLinks_1$__constructor__(), 0, this);
            }

            @Override
            public TextLinks createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_textclassifier_TextLinks_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public TextLinks[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_textclassifier_TextLinks_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(String string2, ArrayList<TextLink> arrayList) {
        this.$$robo$$android_view_textclassifier_TextLinks$__constructor__(string2, arrayList);
    }

    private TextLinks(String string2, ArrayList<TextLink> arrayList) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextLinks$__constructor__(java.lang.String java.util.ArrayList<android.view.textclassifier.TextLinks$TextLink> ), 0, this, string2, arrayList);
    }

    public String getText() {
        return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_view_textclassifier_TextLinks$getText(), 0, this);
    }

    public Collection<TextLink> getLinks() {
        return InvokeDynamicSupport.bootstrap("getLinks", $$robo$$android_view_textclassifier_TextLinks$getLinks(), 0, this);
    }

    public int apply(Spannable spannable, int n, Function<TextLink, TextLinkSpan> function) {
        return (int)InvokeDynamicSupport.bootstrap("apply", $$robo$$android_view_textclassifier_TextLinks$apply(android.text.Spannable int java.util.function.Function<android.view.textclassifier.TextLinks$TextLink, android.view.textclassifier.TextLinks$TextLinkSpan> ), 0, this, spannable, n, function);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_textclassifier_TextLinks$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_textclassifier_TextLinks$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_textclassifier_TextLinks$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_view_textclassifier_TextLinks$__constructor__(parcel);
    }

    private TextLinks(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextLinks$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_view_textclassifier_TextLinks$__constructor__(parcel, var2_2);
    }

    private /* synthetic */ void __constructor__(String string2, ArrayList arrayList, 1 var3_3) {
        this.$$robo$$android_view_textclassifier_TextLinks$__constructor__(string2, arrayList, var3_3);
    }

    static {
        RobolectricInternals.classInitializing(TextLinks.class);
    }

    public /* synthetic */ TextLinks() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextLinks)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Options
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private TextClassificationSessionId mSessionId;
        private Request mRequest;
        private LocaleList mDefaultLocales;
        private TextClassifier.EntityConfig mEntityConfig;
        private boolean mLegacyFallback;
        private int mApplyStrategy;
        private Function<TextLink, TextLinkSpan> mSpanFactory;
        private String mCallingPackageName;

        private void $$robo$$android_view_textclassifier_TextLinks_Options$__constructor__() {
        }

        private void $$robo$$android_view_textclassifier_TextLinks_Options$__constructor__(TextClassificationSessionId sessionId, Request request) {
            this.mSessionId = sessionId;
            this.mRequest = request;
        }

        private static final Options $$robo$$android_view_textclassifier_TextLinks_Options$from(TextClassificationSessionId sessionId, Request request) {
            Options options = new Options(sessionId, request);
            options.setDefaultLocales(request.getDefaultLocales());
            options.setEntityConfig(request.getEntityConfig());
            return options;
        }

        private static final Options $$robo$$android_view_textclassifier_TextLinks_Options$fromLinkMask(int mask) {
            ArrayList<String> entitiesToFind = new ArrayList<String>();
            if ((mask & 1) != 0) {
                entitiesToFind.add("url");
            }
            if ((mask & 2) != 0) {
                entitiesToFind.add("email");
            }
            if ((mask & 4) != 0) {
                entitiesToFind.add("phone");
            }
            if ((mask & 8) != 0) {
                entitiesToFind.add("address");
            }
            return new Options().setEntityConfig(TextClassifier.EntityConfig.createWithEntityList(entitiesToFind));
        }

        private final Options $$robo$$android_view_textclassifier_TextLinks_Options$setDefaultLocales(LocaleList defaultLocales) {
            this.mDefaultLocales = defaultLocales;
            return this;
        }

        private final Options $$robo$$android_view_textclassifier_TextLinks_Options$setEntityConfig(TextClassifier.EntityConfig entityConfig) {
            this.mEntityConfig = entityConfig;
            return this;
        }

        private final Options $$robo$$android_view_textclassifier_TextLinks_Options$setApplyStrategy(int applyStrategy) {
            Options.checkValidApplyStrategy(applyStrategy);
            this.mApplyStrategy = applyStrategy;
            return this;
        }

        private final Options $$robo$$android_view_textclassifier_TextLinks_Options$setSpanFactory(Function<TextLink, TextLinkSpan> spanFactory) {
            this.mSpanFactory = spanFactory;
            return this;
        }

        private final LocaleList $$robo$$android_view_textclassifier_TextLinks_Options$getDefaultLocales() {
            return this.mDefaultLocales;
        }

        private final TextClassifier.EntityConfig $$robo$$android_view_textclassifier_TextLinks_Options$getEntityConfig() {
            return this.mEntityConfig;
        }

        private final int $$robo$$android_view_textclassifier_TextLinks_Options$getApplyStrategy() {
            return this.mApplyStrategy;
        }

        private final Function<TextLink, TextLinkSpan> $$robo$$android_view_textclassifier_TextLinks_Options$getSpanFactory() {
            return this.mSpanFactory;
        }

        private final Request $$robo$$android_view_textclassifier_TextLinks_Options$getRequest() {
            return this.mRequest;
        }

        private final TextClassificationSessionId $$robo$$android_view_textclassifier_TextLinks_Options$getSessionId() {
            return this.mSessionId;
        }

        private static final void $$robo$$android_view_textclassifier_TextLinks_Options$checkValidApplyStrategy(int applyStrategy) {
            if (applyStrategy != 0 && applyStrategy != 1) {
                throw new IllegalArgumentException("Invalid apply strategy. See TextLinks.ApplyStrategy for options.");
            }
        }

        private void __constructor__() {
            this.$$robo$$android_view_textclassifier_TextLinks_Options$__constructor__();
        }

        public Options() {
            this(null, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextLinks_Options$__constructor__(), 0, this);
        }

        private void __constructor__(TextClassificationSessionId textClassificationSessionId, Request request) {
            this.$$robo$$android_view_textclassifier_TextLinks_Options$__constructor__(textClassificationSessionId, request);
        }

        private Options(TextClassificationSessionId textClassificationSessionId, Request request) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextLinks_Options$__constructor__(android.view.textclassifier.TextClassificationSessionId android.view.textclassifier.TextLinks$Request ), 0, this, textClassificationSessionId, request);
        }

        public static Options from(TextClassificationSessionId textClassificationSessionId, Request request) {
            return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$android_view_textclassifier_TextLinks_Options$from(android.view.textclassifier.TextClassificationSessionId android.view.textclassifier.TextLinks$Request ), 0, (TextClassificationSessionId)textClassificationSessionId, (Request)request);
        }

        public static Options fromLinkMask(int n) {
            return InvokeDynamicSupport.bootstrapStatic("fromLinkMask", $$robo$$android_view_textclassifier_TextLinks_Options$fromLinkMask(int ), 0, (int)n);
        }

        public Options setDefaultLocales(LocaleList localeList) {
            return InvokeDynamicSupport.bootstrap("setDefaultLocales", $$robo$$android_view_textclassifier_TextLinks_Options$setDefaultLocales(android.os.LocaleList ), 0, this, localeList);
        }

        public Options setEntityConfig(TextClassifier.EntityConfig entityConfig) {
            return InvokeDynamicSupport.bootstrap("setEntityConfig", $$robo$$android_view_textclassifier_TextLinks_Options$setEntityConfig(android.view.textclassifier.TextClassifier$EntityConfig ), 0, this, entityConfig);
        }

        public Options setApplyStrategy(int n) {
            return InvokeDynamicSupport.bootstrap("setApplyStrategy", $$robo$$android_view_textclassifier_TextLinks_Options$setApplyStrategy(int ), 0, this, n);
        }

        public Options setSpanFactory(Function<TextLink, TextLinkSpan> function) {
            return InvokeDynamicSupport.bootstrap("setSpanFactory", $$robo$$android_view_textclassifier_TextLinks_Options$setSpanFactory(java.util.function.Function<android.view.textclassifier.TextLinks$TextLink, android.view.textclassifier.TextLinks$TextLinkSpan> ), 0, this, function);
        }

        public LocaleList getDefaultLocales() {
            return InvokeDynamicSupport.bootstrap("getDefaultLocales", $$robo$$android_view_textclassifier_TextLinks_Options$getDefaultLocales(), 0, this);
        }

        public TextClassifier.EntityConfig getEntityConfig() {
            return InvokeDynamicSupport.bootstrap("getEntityConfig", $$robo$$android_view_textclassifier_TextLinks_Options$getEntityConfig(), 0, this);
        }

        public int getApplyStrategy() {
            return (int)InvokeDynamicSupport.bootstrap("getApplyStrategy", $$robo$$android_view_textclassifier_TextLinks_Options$getApplyStrategy(), 0, this);
        }

        public Function<TextLink, TextLinkSpan> getSpanFactory() {
            return InvokeDynamicSupport.bootstrap("getSpanFactory", $$robo$$android_view_textclassifier_TextLinks_Options$getSpanFactory(), 0, this);
        }

        public Request getRequest() {
            return InvokeDynamicSupport.bootstrap("getRequest", $$robo$$android_view_textclassifier_TextLinks_Options$getRequest(), 0, this);
        }

        public TextClassificationSessionId getSessionId() {
            return InvokeDynamicSupport.bootstrap("getSessionId", $$robo$$android_view_textclassifier_TextLinks_Options$getSessionId(), 0, this);
        }

        private static void checkValidApplyStrategy(int n) {
            InvokeDynamicSupport.bootstrapStatic("checkValidApplyStrategy", $$robo$$android_view_textclassifier_TextLinks_Options$checkValidApplyStrategy(int ), 0, (int)n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Options)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mFullText;
        private ArrayList<TextLink> mLinks;

        private void $$robo$$android_view_textclassifier_TextLinks_Builder$__constructor__(String fullText) {
            this.mFullText = Preconditions.checkNotNull(fullText);
            this.mLinks = new ArrayList();
        }

        private final Builder $$robo$$android_view_textclassifier_TextLinks_Builder$addLink(int start, int end, Map<String, Float> entityScores) {
            this.mLinks.add(new TextLink(start, end, entityScores, null));
            return this;
        }

        private final Builder $$robo$$android_view_textclassifier_TextLinks_Builder$addLink(int start, int end, Map<String, Float> entityScores, URLSpan urlSpan) {
            this.mLinks.add(new TextLink(start, end, entityScores, urlSpan));
            return this;
        }

        private final Builder $$robo$$android_view_textclassifier_TextLinks_Builder$clearTextLinks() {
            this.mLinks.clear();
            return this;
        }

        private final TextLinks $$robo$$android_view_textclassifier_TextLinks_Builder$build() {
            return new TextLinks(this.mFullText, this.mLinks);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_view_textclassifier_TextLinks_Builder$__constructor__(string2);
        }

        public Builder(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextLinks_Builder$__constructor__(java.lang.String ), 0, this, string2);
        }

        public Builder addLink(int n, int n2, Map<String, Float> map) {
            return InvokeDynamicSupport.bootstrap("addLink", $$robo$$android_view_textclassifier_TextLinks_Builder$addLink(int int java.util.Map<java.lang.String, java.lang.Float> ), 0, this, n, n2, map);
        }

        Builder addLink(int n, int n2, Map<String, Float> map, URLSpan uRLSpan) {
            return InvokeDynamicSupport.bootstrap("addLink", $$robo$$android_view_textclassifier_TextLinks_Builder$addLink(int int java.util.Map<java.lang.String, java.lang.Float> android.text.style.URLSpan ), 0, this, n, n2, map, uRLSpan);
        }

        public Builder clearTextLinks() {
            return InvokeDynamicSupport.bootstrap("clearTextLinks", $$robo$$android_view_textclassifier_TextLinks_Builder$clearTextLinks(), 0, this);
        }

        public TextLinks build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_view_textclassifier_TextLinks_Builder$build(), 0, this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class TextLinkSpan
    extends ClickableSpan
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int INVOCATION_METHOD_UNSPECIFIED = -1;
        public static int INVOCATION_METHOD_TOUCH = 0;
        public static int INVOCATION_METHOD_KEYBOARD = 1;
        private TextLink mTextLink;

        private void $$robo$$android_view_textclassifier_TextLinks_TextLinkSpan$__constructor__(TextLink textLink) {
            this.mTextLink = textLink;
        }

        private final void $$robo$$android_view_textclassifier_TextLinks_TextLinkSpan$onClick(View widget) {
            this.onClick(widget, -1);
        }

        private final void $$robo$$android_view_textclassifier_TextLinks_TextLinkSpan$onClick(View widget, int invocationMethod) {
            if (widget instanceof TextView) {
                TextView textView = (TextView)widget;
                Context context = textView.getContext();
                if (TextClassificationManager.getSettings(context).isSmartLinkifyEnabled()) {
                    switch (invocationMethod) {
                        case 0: {
                            textView.requestActionMode(this);
                            break;
                        }
                        default: {
                            textView.handleClick(this);
                            break;
                        }
                    }
                } else if (this.mTextLink.mUrlSpan != null) {
                    this.mTextLink.mUrlSpan.onClick(textView);
                } else {
                    textView.handleClick(this);
                }
            }
        }

        private final TextLink $$robo$$android_view_textclassifier_TextLinks_TextLinkSpan$getTextLink() {
            return this.mTextLink;
        }

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
        private final String $$robo$$android_view_textclassifier_TextLinks_TextLinkSpan$getUrl() {
            if (this.mTextLink.mUrlSpan != null) {
                return this.mTextLink.mUrlSpan.getURL();
            }
            return null;
        }

        private void __constructor__(TextLink textLink) {
            this.$$robo$$android_view_textclassifier_TextLinks_TextLinkSpan$__constructor__(textLink);
        }

        public TextLinkSpan(TextLink textLink) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextLinks_TextLinkSpan$__constructor__(android.view.textclassifier.TextLinks$TextLink ), 0, this, textLink);
        }

        @Override
        public void onClick(View view) {
            InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_view_textclassifier_TextLinks_TextLinkSpan$onClick(android.view.View ), 0, this, view);
        }

        public void onClick(View view, int n) {
            InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_view_textclassifier_TextLinks_TextLinkSpan$onClick(android.view.View int ), 0, this, view, n);
        }

        public TextLink getTextLink() {
            return InvokeDynamicSupport.bootstrap("getTextLink", $$robo$$android_view_textclassifier_TextLinks_TextLinkSpan$getTextLink(), 0, this);
        }

        public String getUrl() {
            return InvokeDynamicSupport.bootstrap("getUrl", $$robo$$android_view_textclassifier_TextLinks_TextLinkSpan$getUrl(), 0, this);
        }

        public /* synthetic */ TextLinkSpan() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextLinkSpan)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface InvocationMethod {
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Request
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private CharSequence mText;
        private LocaleList mDefaultLocales;
        private TextClassifier.EntityConfig mEntityConfig;
        private boolean mLegacyFallback;
        private String mCallingPackageName;
        public static Parcelable.Creator<Request> CREATOR;

        private void $$robo$$android_view_textclassifier_TextLinks_Request$__constructor__(CharSequence text, LocaleList defaultLocales, TextClassifier.EntityConfig entityConfig, boolean legacyFallback, String callingPackageName) {
            this.mText = text;
            this.mDefaultLocales = defaultLocales;
            this.mEntityConfig = entityConfig;
            this.mLegacyFallback = legacyFallback;
            this.mCallingPackageName = callingPackageName;
        }

        private final CharSequence $$robo$$android_view_textclassifier_TextLinks_Request$getText() {
            return this.mText;
        }

        private final LocaleList $$robo$$android_view_textclassifier_TextLinks_Request$getDefaultLocales() {
            return this.mDefaultLocales;
        }

        private final TextClassifier.EntityConfig $$robo$$android_view_textclassifier_TextLinks_Request$getEntityConfig() {
            return this.mEntityConfig;
        }

        private final boolean $$robo$$android_view_textclassifier_TextLinks_Request$isLegacyFallback() {
            return this.mLegacyFallback;
        }

        private final void $$robo$$android_view_textclassifier_TextLinks_Request$setCallingPackageName(String callingPackageName) {
            this.mCallingPackageName = callingPackageName;
        }

        private final String $$robo$$android_view_textclassifier_TextLinks_Request$getCallingPackageName() {
            return this.mCallingPackageName;
        }

        private final int $$robo$$android_view_textclassifier_TextLinks_Request$describeContents() {
            return 0;
        }

        private final void $$robo$$android_view_textclassifier_TextLinks_Request$writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mText.toString());
            dest.writeInt(this.mDefaultLocales != null ? 1 : 0);
            if (this.mDefaultLocales != null) {
                this.mDefaultLocales.writeToParcel(dest, flags);
            }
            dest.writeInt(this.mEntityConfig != null ? 1 : 0);
            if (this.mEntityConfig != null) {
                this.mEntityConfig.writeToParcel(dest, flags);
            }
            dest.writeString(this.mCallingPackageName);
        }

        private void $$robo$$android_view_textclassifier_TextLinks_Request$__constructor__(Parcel in) {
            this.mText = in.readString();
            this.mDefaultLocales = in.readInt() == 0 ? null : LocaleList.CREATOR.createFromParcel(in);
            this.mEntityConfig = in.readInt() == 0 ? null : TextClassifier.EntityConfig.CREATOR.createFromParcel(in);
            this.mLegacyFallback = true;
            this.mCallingPackageName = in.readString();
        }

        private /* synthetic */ void $$robo$$android_view_textclassifier_TextLinks_Request$__constructor__(CharSequence x0, LocaleList x1, TextClassifier.EntityConfig x2, boolean x3, String x4, 1 x5) {
        }

        private /* synthetic */ void $$robo$$android_view_textclassifier_TextLinks_Request$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<Request>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_view_textclassifier_TextLinks_Request_1$__constructor__() {
                }

                private final Request $$robo$$android_view_textclassifier_TextLinks_Request_1$createFromParcel(Parcel in) {
                    return new Request(in);
                }

                private final Request[] $$robo$$android_view_textclassifier_TextLinks_Request_1$newArray(int size) {
                    return new Request[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_view_textclassifier_TextLinks_Request_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextLinks_Request_1$__constructor__(), 0, this);
                }

                @Override
                public Request createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_textclassifier_TextLinks_Request_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public Request[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_textclassifier_TextLinks_Request_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(CharSequence charSequence, LocaleList localeList, TextClassifier.EntityConfig entityConfig, boolean bl, String string2) {
            this.$$robo$$android_view_textclassifier_TextLinks_Request$__constructor__(charSequence, localeList, entityConfig, bl, string2);
        }

        private Request(CharSequence charSequence, LocaleList localeList, TextClassifier.EntityConfig entityConfig, boolean bl, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextLinks_Request$__constructor__(java.lang.CharSequence android.os.LocaleList android.view.textclassifier.TextClassifier$EntityConfig boolean java.lang.String ), 0, this, charSequence, localeList, entityConfig, bl, string2);
        }

        public CharSequence getText() {
            return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_view_textclassifier_TextLinks_Request$getText(), 0, this);
        }

        public LocaleList getDefaultLocales() {
            return InvokeDynamicSupport.bootstrap("getDefaultLocales", $$robo$$android_view_textclassifier_TextLinks_Request$getDefaultLocales(), 0, this);
        }

        public TextClassifier.EntityConfig getEntityConfig() {
            return InvokeDynamicSupport.bootstrap("getEntityConfig", $$robo$$android_view_textclassifier_TextLinks_Request$getEntityConfig(), 0, this);
        }

        public boolean isLegacyFallback() {
            return (boolean)InvokeDynamicSupport.bootstrap("isLegacyFallback", $$robo$$android_view_textclassifier_TextLinks_Request$isLegacyFallback(), 0, this);
        }

        void setCallingPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setCallingPackageName", $$robo$$android_view_textclassifier_TextLinks_Request$setCallingPackageName(java.lang.String ), 0, this, string2);
        }

        public String getCallingPackageName() {
            return InvokeDynamicSupport.bootstrap("getCallingPackageName", $$robo$$android_view_textclassifier_TextLinks_Request$getCallingPackageName(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_textclassifier_TextLinks_Request$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_textclassifier_TextLinks_Request$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_view_textclassifier_TextLinks_Request$__constructor__(parcel);
        }

        private Request(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextLinks_Request$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private /* synthetic */ void __constructor__(CharSequence charSequence, LocaleList localeList, TextClassifier.EntityConfig entityConfig, boolean bl, String string2, 1 var6_6) {
            this.$$robo$$android_view_textclassifier_TextLinks_Request$__constructor__(charSequence, localeList, entityConfig, bl, string2, var6_6);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_view_textclassifier_TextLinks_Request$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(Request.class);
        }

        public /* synthetic */ Request() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Request)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public static final class Builder
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private CharSequence mText;
            private LocaleList mDefaultLocales;
            private TextClassifier.EntityConfig mEntityConfig;
            private boolean mLegacyFallback;
            private String mCallingPackageName;

            private void $$robo$$android_view_textclassifier_TextLinks_Request_Builder$__constructor__(CharSequence text) {
                this.mLegacyFallback = true;
                this.mText = Preconditions.checkNotNull(text);
            }

            private final Builder $$robo$$android_view_textclassifier_TextLinks_Request_Builder$setDefaultLocales(LocaleList defaultLocales) {
                this.mDefaultLocales = defaultLocales;
                return this;
            }

            private final Builder $$robo$$android_view_textclassifier_TextLinks_Request_Builder$setEntityConfig(TextClassifier.EntityConfig entityConfig) {
                this.mEntityConfig = entityConfig;
                return this;
            }

            private final Builder $$robo$$android_view_textclassifier_TextLinks_Request_Builder$setLegacyFallback(boolean legacyFallback) {
                this.mLegacyFallback = legacyFallback;
                return this;
            }

            private final Builder $$robo$$android_view_textclassifier_TextLinks_Request_Builder$setCallingPackageName(String callingPackageName) {
                this.mCallingPackageName = callingPackageName;
                return this;
            }

            private final Request $$robo$$android_view_textclassifier_TextLinks_Request_Builder$build() {
                return new Request(this.mText, this.mDefaultLocales, this.mEntityConfig, this.mLegacyFallback, this.mCallingPackageName);
            }

            private void __constructor__(CharSequence charSequence) {
                this.$$robo$$android_view_textclassifier_TextLinks_Request_Builder$__constructor__(charSequence);
            }

            public Builder(CharSequence charSequence) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextLinks_Request_Builder$__constructor__(java.lang.CharSequence ), 0, this, charSequence);
            }

            public Builder setDefaultLocales(LocaleList localeList) {
                return InvokeDynamicSupport.bootstrap("setDefaultLocales", $$robo$$android_view_textclassifier_TextLinks_Request_Builder$setDefaultLocales(android.os.LocaleList ), 0, this, localeList);
            }

            public Builder setEntityConfig(TextClassifier.EntityConfig entityConfig) {
                return InvokeDynamicSupport.bootstrap("setEntityConfig", $$robo$$android_view_textclassifier_TextLinks_Request_Builder$setEntityConfig(android.view.textclassifier.TextClassifier$EntityConfig ), 0, this, entityConfig);
            }

            public Builder setLegacyFallback(boolean bl) {
                return InvokeDynamicSupport.bootstrap("setLegacyFallback", $$robo$$android_view_textclassifier_TextLinks_Request_Builder$setLegacyFallback(boolean ), 0, this, bl);
            }

            public Builder setCallingPackageName(String string2) {
                return InvokeDynamicSupport.bootstrap("setCallingPackageName", $$robo$$android_view_textclassifier_TextLinks_Request_Builder$setCallingPackageName(java.lang.String ), 0, this, string2);
            }

            public Request build() {
                return InvokeDynamicSupport.bootstrap("build", $$robo$$android_view_textclassifier_TextLinks_Request_Builder$build(), 0, this);
            }

            public /* synthetic */ Builder() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class TextLink
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private EntityConfidence mEntityScores;
        private int mStart;
        private int mEnd;
        URLSpan mUrlSpan;
        public static Parcelable.Creator<TextLink> CREATOR;

        private void $$robo$$android_view_textclassifier_TextLinks_TextLink$__constructor__(int start, int end, Map<String, Float> entityScores, URLSpan urlSpan) {
            Preconditions.checkNotNull(entityScores);
            Preconditions.checkArgument(!entityScores.isEmpty());
            Preconditions.checkArgument(start <= end);
            this.mStart = start;
            this.mEnd = end;
            this.mEntityScores = new EntityConfidence(entityScores);
            this.mUrlSpan = urlSpan;
        }

        private final int $$robo$$android_view_textclassifier_TextLinks_TextLink$getStart() {
            return this.mStart;
        }

        private final int $$robo$$android_view_textclassifier_TextLinks_TextLink$getEnd() {
            return this.mEnd;
        }

        private final int $$robo$$android_view_textclassifier_TextLinks_TextLink$getEntityCount() {
            return this.mEntityScores.getEntities().size();
        }

        private final String $$robo$$android_view_textclassifier_TextLinks_TextLink$getEntity(int index) {
            return this.mEntityScores.getEntities().get(index);
        }

        private final float $$robo$$android_view_textclassifier_TextLinks_TextLink$getConfidenceScore(String entityType) {
            return this.mEntityScores.getConfidenceScore(entityType);
        }

        private final String $$robo$$android_view_textclassifier_TextLinks_TextLink$toString() {
            return String.format(Locale.US, "TextLink{start=%s, end=%s, entityScores=%s, urlSpan=%s}", this.mStart, this.mEnd, this.mEntityScores, this.mUrlSpan);
        }

        private final int $$robo$$android_view_textclassifier_TextLinks_TextLink$describeContents() {
            return 0;
        }

        private final void $$robo$$android_view_textclassifier_TextLinks_TextLink$writeToParcel(Parcel dest, int flags) {
            this.mEntityScores.writeToParcel(dest, flags);
            dest.writeInt(this.mStart);
            dest.writeInt(this.mEnd);
        }

        private void $$robo$$android_view_textclassifier_TextLinks_TextLink$__constructor__(Parcel in) {
            this.mEntityScores = EntityConfidence.CREATOR.createFromParcel(in);
            this.mStart = in.readInt();
            this.mEnd = in.readInt();
            this.mUrlSpan = null;
        }

        private /* synthetic */ void $$robo$$android_view_textclassifier_TextLinks_TextLink$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<TextLink>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_view_textclassifier_TextLinks_TextLink_1$__constructor__() {
                }

                private final TextLink $$robo$$android_view_textclassifier_TextLinks_TextLink_1$createFromParcel(Parcel in) {
                    return new TextLink(in);
                }

                private final TextLink[] $$robo$$android_view_textclassifier_TextLinks_TextLink_1$newArray(int size) {
                    return new TextLink[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_view_textclassifier_TextLinks_TextLink_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextLinks_TextLink_1$__constructor__(), 0, this);
                }

                @Override
                public TextLink createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_textclassifier_TextLinks_TextLink_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public TextLink[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_textclassifier_TextLinks_TextLink_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(int n, int n2, Map<String, Float> map, URLSpan uRLSpan) {
            this.$$robo$$android_view_textclassifier_TextLinks_TextLink$__constructor__(n, n2, map, uRLSpan);
        }

        TextLink(int n, int n2, Map<String, Float> map, URLSpan uRLSpan) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextLinks_TextLink$__constructor__(int int java.util.Map<java.lang.String, java.lang.Float> android.text.style.URLSpan ), 0, this, n, n2, map, uRLSpan);
        }

        public int getStart() {
            return (int)InvokeDynamicSupport.bootstrap("getStart", $$robo$$android_view_textclassifier_TextLinks_TextLink$getStart(), 0, this);
        }

        public int getEnd() {
            return (int)InvokeDynamicSupport.bootstrap("getEnd", $$robo$$android_view_textclassifier_TextLinks_TextLink$getEnd(), 0, this);
        }

        public int getEntityCount() {
            return (int)InvokeDynamicSupport.bootstrap("getEntityCount", $$robo$$android_view_textclassifier_TextLinks_TextLink$getEntityCount(), 0, this);
        }

        public String getEntity(int n) {
            return InvokeDynamicSupport.bootstrap("getEntity", $$robo$$android_view_textclassifier_TextLinks_TextLink$getEntity(int ), 0, this, n);
        }

        public float getConfidenceScore(String string2) {
            return (float)InvokeDynamicSupport.bootstrap("getConfidenceScore", $$robo$$android_view_textclassifier_TextLinks_TextLink$getConfidenceScore(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_textclassifier_TextLinks_TextLink$toString(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_textclassifier_TextLinks_TextLink$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_textclassifier_TextLinks_TextLink$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_view_textclassifier_TextLinks_TextLink$__constructor__(parcel);
        }

        private TextLink(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextLinks_TextLink$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_view_textclassifier_TextLinks_TextLink$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(TextLink.class);
        }

        public /* synthetic */ TextLink() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextLink)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ApplyStrategy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
    }
}

