/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.text.Spannable;
import android.text.style.ClickableSpan;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextLinks;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.function.Function;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class TextLinksParams
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static Function<TextLinks.TextLink, TextLinks.TextLinkSpan> DEFAULT_SPAN_FACTORY;
    private int mApplyStrategy;
    private Function<TextLinks.TextLink, TextLinks.TextLinkSpan> mSpanFactory;
    private TextClassifier.EntityConfig mEntityConfig;

    private void $$robo$$android_view_textclassifier_TextLinksParams$__constructor__(int applyStrategy, Function<TextLinks.TextLink, TextLinks.TextLinkSpan> spanFactory) {
        this.mApplyStrategy = applyStrategy;
        this.mSpanFactory = spanFactory;
        this.mEntityConfig = TextClassifier.EntityConfig.createWithHints(null);
    }

    private static final TextLinksParams $$robo$$android_view_textclassifier_TextLinksParams$fromLinkMask(int mask) {
        ArrayList<String> entitiesToFind = new ArrayList<String>();
        if ((mask & 1) != 0) {
            entitiesToFind.add("url");
        }
        if ((mask & 2) != 0) {
            entitiesToFind.add("email");
        }
        if ((mask & 4) != 0) {
            entitiesToFind.add("phone");
        }
        if ((mask & 8) != 0) {
            entitiesToFind.add("address");
        }
        return new Builder().setEntityConfig(TextClassifier.EntityConfig.createWithExplicitEntityList(entitiesToFind)).build();
    }

    private final TextClassifier.EntityConfig $$robo$$android_view_textclassifier_TextLinksParams$getEntityConfig() {
        return this.mEntityConfig;
    }

    private final int $$robo$$android_view_textclassifier_TextLinksParams$apply(Spannable text, TextLinks textLinks) {
        Preconditions.checkNotNull(text);
        Preconditions.checkNotNull(textLinks);
        String textString = text.toString();
        if (!textString.startsWith(textLinks.getText())) {
            return 3;
        }
        if (textLinks.getLinks().isEmpty()) {
            return 1;
        }
        int applyCount = 0;
        for (TextLinks.TextLink link : textLinks.getLinks()) {
            TextLinks.TextLinkSpan span = this.mSpanFactory.apply(link);
            if (span == null) continue;
            ClickableSpan[] existingSpans = text.getSpans(link.getStart(), link.getEnd(), ClickableSpan.class);
            if (existingSpans.length > 0) {
                if (this.mApplyStrategy != 1) continue;
                for (ClickableSpan existingSpan : existingSpans) {
                    text.removeSpan(existingSpan);
                }
                text.setSpan(span, link.getStart(), link.getEnd(), 33);
                ++applyCount;
                continue;
            }
            text.setSpan(span, link.getStart(), link.getEnd(), 33);
            ++applyCount;
        }
        if (applyCount == 0) {
            return 2;
        }
        return 0;
    }

    private static final int $$robo$$android_view_textclassifier_TextLinksParams$checkApplyStrategy(int applyStrategy) {
        if (applyStrategy != 0 && applyStrategy != 1) {
            throw new IllegalArgumentException("Invalid apply strategy. See TextLinksParams.ApplyStrategy for options.");
        }
        return applyStrategy;
    }

    private /* synthetic */ void $$robo$$android_view_textclassifier_TextLinksParams$__constructor__(int x0, Function x1, 1 x2) {
    }

    static void __staticInitializer__() {
        DEFAULT_SPAN_FACTORY = textLink -> new TextLinks.TextLinkSpan((TextLinks.TextLink)textLink);
    }

    private void __constructor__(int n, Function<TextLinks.TextLink, TextLinks.TextLinkSpan> function) {
        this.$$robo$$android_view_textclassifier_TextLinksParams$__constructor__(n, function);
    }

    private TextLinksParams(int n, Function<TextLinks.TextLink, TextLinks.TextLinkSpan> function) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextLinksParams$__constructor__(int java.util.function.Function<android.view.textclassifier.TextLinks$TextLink, android.view.textclassifier.TextLinks$TextLinkSpan> ), 0, this, n, function);
    }

    public static TextLinksParams fromLinkMask(int n) {
        return InvokeDynamicSupport.bootstrapStatic("fromLinkMask", $$robo$$android_view_textclassifier_TextLinksParams$fromLinkMask(int ), 0, (int)n);
    }

    public TextClassifier.EntityConfig getEntityConfig() {
        return InvokeDynamicSupport.bootstrap("getEntityConfig", $$robo$$android_view_textclassifier_TextLinksParams$getEntityConfig(), 0, this);
    }

    public int apply(Spannable spannable, TextLinks textLinks) {
        return (int)InvokeDynamicSupport.bootstrap("apply", $$robo$$android_view_textclassifier_TextLinksParams$apply(android.text.Spannable android.view.textclassifier.TextLinks ), 0, this, spannable, textLinks);
    }

    private static int checkApplyStrategy(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkApplyStrategy", $$robo$$android_view_textclassifier_TextLinksParams$checkApplyStrategy(int ), 0, (int)n);
    }

    private /* synthetic */ void __constructor__(int n, Function function, 1 var3_3) {
        this.$$robo$$android_view_textclassifier_TextLinksParams$__constructor__(n, function, var3_3);
    }

    static {
        RobolectricInternals.classInitializing(TextLinksParams.class);
    }

    public /* synthetic */ TextLinksParams() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextLinksParams)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mApplyStrategy;
        private Function<TextLinks.TextLink, TextLinks.TextLinkSpan> mSpanFactory;

        private void $$robo$$android_view_textclassifier_TextLinksParams_Builder$__constructor__() {
            this.mApplyStrategy = 0;
            this.mSpanFactory = DEFAULT_SPAN_FACTORY;
        }

        private final Builder $$robo$$android_view_textclassifier_TextLinksParams_Builder$setApplyStrategy(int applyStrategy) {
            this.mApplyStrategy = TextLinksParams.checkApplyStrategy(applyStrategy);
            return this;
        }

        private final Builder $$robo$$android_view_textclassifier_TextLinksParams_Builder$setSpanFactory(Function<TextLinks.TextLink, TextLinks.TextLinkSpan> spanFactory) {
            this.mSpanFactory = spanFactory == null ? DEFAULT_SPAN_FACTORY : spanFactory;
            return this;
        }

        private final Builder $$robo$$android_view_textclassifier_TextLinksParams_Builder$setEntityConfig(TextClassifier.EntityConfig entityConfig) {
            return this;
        }

        private final TextLinksParams $$robo$$android_view_textclassifier_TextLinksParams_Builder$build() {
            return new TextLinksParams(this.mApplyStrategy, this.mSpanFactory);
        }

        private void __constructor__() {
            this.$$robo$$android_view_textclassifier_TextLinksParams_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextLinksParams_Builder$__constructor__(), 0, this);
        }

        public Builder setApplyStrategy(int n) {
            return InvokeDynamicSupport.bootstrap("setApplyStrategy", $$robo$$android_view_textclassifier_TextLinksParams_Builder$setApplyStrategy(int ), 0, this, n);
        }

        public Builder setSpanFactory(Function<TextLinks.TextLink, TextLinks.TextLinkSpan> function) {
            return InvokeDynamicSupport.bootstrap("setSpanFactory", $$robo$$android_view_textclassifier_TextLinksParams_Builder$setSpanFactory(java.util.function.Function<android.view.textclassifier.TextLinks$TextLink, android.view.textclassifier.TextLinks$TextLinkSpan> ), 0, this, function);
        }

        public Builder setEntityConfig(TextClassifier.EntityConfig entityConfig) {
            return InvokeDynamicSupport.bootstrap("setEntityConfig", $$robo$$android_view_textclassifier_TextLinksParams_Builder$setEntityConfig(android.view.textclassifier.TextClassifier$EntityConfig ), 0, this, entityConfig);
        }

        public TextLinksParams build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_view_textclassifier_TextLinksParams_Builder$build(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

