/*
 * Decompiled with CFR 0.152.
 */
package android.view.textservice;

import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.view.textservice.SentenceSuggestionsInfo;
import android.view.textservice.SpellCheckerInfo;
import android.view.textservice.SuggestionsInfo;
import android.view.textservice.TextInfo;
import com.android.internal.textservice.ISpellCheckerSession;
import com.android.internal.textservice.ISpellCheckerSessionListener;
import com.android.internal.textservice.ITextServicesManager;
import com.android.internal.textservice.ITextServicesSessionListener;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.util.LinkedList;
import java.util.Queue;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SpellCheckerSession
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean DBG = false;
    public static String SERVICE_META_DATA = "android.view.textservice.scs";
    private static int MSG_ON_GET_SUGGESTION_MULTIPLE = 1;
    private static int MSG_ON_GET_SUGGESTION_MULTIPLE_FOR_SENTENCE = 2;
    private InternalListener mInternalListener;
    private ITextServicesManager mTextServicesManager;
    private SpellCheckerInfo mSpellCheckerInfo;
    private SpellCheckerSessionListener mSpellCheckerSessionListener;
    private SpellCheckerSessionListenerImpl mSpellCheckerSessionListenerImpl;
    private CloseGuard mGuard;
    private Handler mHandler;

    private void $$robo$$android_view_textservice_SpellCheckerSession$__constructor__(SpellCheckerInfo info, ITextServicesManager tsm, SpellCheckerSessionListener listener) {
        this.mGuard = CloseGuard.get();
        this.mHandler = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SpellCheckerSession this$0;

            private void $$robo$$android_view_textservice_SpellCheckerSession_1$__constructor__(SpellCheckerSession this$0) {
            }

            private final void $$robo$$android_view_textservice_SpellCheckerSession_1$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        this.this$0.handleOnGetSuggestionsMultiple((SuggestionsInfo[])msg.obj);
                        break;
                    }
                    case 2: {
                        this.this$0.handleOnGetSentenceSuggestionsMultiple((SentenceSuggestionsInfo[])msg.obj);
                    }
                }
            }

            private void __constructor__(SpellCheckerSession spellCheckerSession) {
                this.$$robo$$android_view_textservice_SpellCheckerSession_1$__constructor__(spellCheckerSession);
            }
            {
                this.this$0 = spellCheckerSession;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textservice_SpellCheckerSession_1$__constructor__(android.view.textservice.SpellCheckerSession ), 0, this, spellCheckerSession);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_view_textservice_SpellCheckerSession_1$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        if (info == null || listener == null || tsm == null) {
            throw new NullPointerException();
        }
        this.mSpellCheckerInfo = info;
        this.mSpellCheckerSessionListenerImpl = new SpellCheckerSessionListenerImpl(this.mHandler);
        this.mInternalListener = new InternalListener(this.mSpellCheckerSessionListenerImpl);
        this.mTextServicesManager = tsm;
        this.mSpellCheckerSessionListener = listener;
        this.mGuard.open("finishSession");
    }

    private final boolean $$robo$$android_view_textservice_SpellCheckerSession$isSessionDisconnected() {
        return this.mSpellCheckerSessionListenerImpl.isDisconnected();
    }

    private final SpellCheckerInfo $$robo$$android_view_textservice_SpellCheckerSession$getSpellChecker() {
        return this.mSpellCheckerInfo;
    }

    private final void $$robo$$android_view_textservice_SpellCheckerSession$cancel() {
        this.mSpellCheckerSessionListenerImpl.cancel();
    }

    private final void $$robo$$android_view_textservice_SpellCheckerSession$close() {
        this.mGuard.close();
        try {
            this.mSpellCheckerSessionListenerImpl.close();
            this.mTextServicesManager.finishSpellCheckerService(this.mSpellCheckerSessionListenerImpl);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_view_textservice_SpellCheckerSession$getSentenceSuggestions(TextInfo[] textInfos, int suggestionsLimit) {
        this.mSpellCheckerSessionListenerImpl.getSentenceSuggestionsMultiple(textInfos, suggestionsLimit);
    }

    @Deprecated
    private final void $$robo$$android_view_textservice_SpellCheckerSession$getSuggestions(TextInfo textInfo, int suggestionsLimit) {
        this.getSuggestions(new TextInfo[]{textInfo}, suggestionsLimit, false);
    }

    @Deprecated
    private final void $$robo$$android_view_textservice_SpellCheckerSession$getSuggestions(TextInfo[] textInfos, int suggestionsLimit, boolean sequentialWords) {
        this.mSpellCheckerSessionListenerImpl.getSuggestionsMultiple(textInfos, suggestionsLimit, sequentialWords);
    }

    private final void $$robo$$android_view_textservice_SpellCheckerSession$handleOnGetSuggestionsMultiple(SuggestionsInfo[] suggestionInfos) {
        this.mSpellCheckerSessionListener.onGetSuggestions(suggestionInfos);
    }

    private final void $$robo$$android_view_textservice_SpellCheckerSession$handleOnGetSentenceSuggestionsMultiple(SentenceSuggestionsInfo[] suggestionInfos) {
        this.mSpellCheckerSessionListener.onGetSentenceSuggestions(suggestionInfos);
    }

    private final void $$robo$$android_view_textservice_SpellCheckerSession$finalize() throws Throwable {
        try {
            if (this.mGuard != null) {
                this.mGuard.warnIfOpen();
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    private final ITextServicesSessionListener $$robo$$android_view_textservice_SpellCheckerSession$getTextServicesSessionListener() {
        return this.mInternalListener;
    }

    private final ISpellCheckerSessionListener $$robo$$android_view_textservice_SpellCheckerSession$getSpellCheckerSessionListener() {
        return this.mSpellCheckerSessionListenerImpl;
    }

    static void __staticInitializer__() {
        TAG = SpellCheckerSession.class.getSimpleName();
    }

    private void __constructor__(SpellCheckerInfo spellCheckerInfo, ITextServicesManager iTextServicesManager, SpellCheckerSessionListener spellCheckerSessionListener) {
        this.$$robo$$android_view_textservice_SpellCheckerSession$__constructor__(spellCheckerInfo, iTextServicesManager, spellCheckerSessionListener);
    }

    public SpellCheckerSession(SpellCheckerInfo spellCheckerInfo, ITextServicesManager iTextServicesManager, SpellCheckerSessionListener spellCheckerSessionListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textservice_SpellCheckerSession$__constructor__(android.view.textservice.SpellCheckerInfo com.android.internal.textservice.ITextServicesManager android.view.textservice.SpellCheckerSession$SpellCheckerSessionListener ), 0, this, spellCheckerInfo, iTextServicesManager, spellCheckerSessionListener);
    }

    public boolean isSessionDisconnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSessionDisconnected", $$robo$$android_view_textservice_SpellCheckerSession$isSessionDisconnected(), 0, this);
    }

    public SpellCheckerInfo getSpellChecker() {
        return InvokeDynamicSupport.bootstrap("getSpellChecker", $$robo$$android_view_textservice_SpellCheckerSession$getSpellChecker(), 0, this);
    }

    public void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_view_textservice_SpellCheckerSession$cancel(), 0, this);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_view_textservice_SpellCheckerSession$close(), 0, this);
    }

    public void getSentenceSuggestions(TextInfo[] textInfoArray, int n) {
        InvokeDynamicSupport.bootstrap("getSentenceSuggestions", $$robo$$android_view_textservice_SpellCheckerSession$getSentenceSuggestions(android.view.textservice.TextInfo[] int ), 0, this, textInfoArray, n);
    }

    @Deprecated
    public void getSuggestions(TextInfo textInfo, int n) {
        InvokeDynamicSupport.bootstrap("getSuggestions", $$robo$$android_view_textservice_SpellCheckerSession$getSuggestions(android.view.textservice.TextInfo int ), 0, this, textInfo, n);
    }

    @Deprecated
    public void getSuggestions(TextInfo[] textInfoArray, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("getSuggestions", $$robo$$android_view_textservice_SpellCheckerSession$getSuggestions(android.view.textservice.TextInfo[] int boolean ), 0, this, textInfoArray, n, bl);
    }

    private void handleOnGetSuggestionsMultiple(SuggestionsInfo[] suggestionsInfoArray) {
        InvokeDynamicSupport.bootstrap("handleOnGetSuggestionsMultiple", $$robo$$android_view_textservice_SpellCheckerSession$handleOnGetSuggestionsMultiple(android.view.textservice.SuggestionsInfo[] ), 0, this, suggestionsInfoArray);
    }

    private void handleOnGetSentenceSuggestionsMultiple(SentenceSuggestionsInfo[] sentenceSuggestionsInfoArray) {
        InvokeDynamicSupport.bootstrap("handleOnGetSentenceSuggestionsMultiple", $$robo$$android_view_textservice_SpellCheckerSession$handleOnGetSentenceSuggestionsMultiple(android.view.textservice.SentenceSuggestionsInfo[] ), 0, this, sentenceSuggestionsInfoArray);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_view_textservice_SpellCheckerSession$finalize(), 0, this);
    }

    public ITextServicesSessionListener getTextServicesSessionListener() {
        return InvokeDynamicSupport.bootstrap("getTextServicesSessionListener", $$robo$$android_view_textservice_SpellCheckerSession$getTextServicesSessionListener(), 0, this);
    }

    public ISpellCheckerSessionListener getSpellCheckerSessionListener() {
        return InvokeDynamicSupport.bootstrap("getSpellCheckerSessionListener", $$robo$$android_view_textservice_SpellCheckerSession$getSpellCheckerSessionListener(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(SpellCheckerSession.class);
    }

    public /* synthetic */ SpellCheckerSession() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpellCheckerSession)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class InternalListener
    extends ITextServicesSessionListener.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private SpellCheckerSessionListenerImpl mParentSpellCheckerSessionListenerImpl;

        private void $$robo$$android_view_textservice_SpellCheckerSession_InternalListener$__constructor__(SpellCheckerSessionListenerImpl spellCheckerSessionListenerImpl) {
            this.mParentSpellCheckerSessionListenerImpl = spellCheckerSessionListenerImpl;
        }

        private final void $$robo$$android_view_textservice_SpellCheckerSession_InternalListener$onServiceConnected(ISpellCheckerSession session) {
            this.mParentSpellCheckerSessionListenerImpl.onServiceConnected(session);
        }

        private void __constructor__(SpellCheckerSessionListenerImpl spellCheckerSessionListenerImpl) {
            this.$$robo$$android_view_textservice_SpellCheckerSession_InternalListener$__constructor__(spellCheckerSessionListenerImpl);
        }

        public InternalListener(SpellCheckerSessionListenerImpl spellCheckerSessionListenerImpl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textservice_SpellCheckerSession_InternalListener$__constructor__(android.view.textservice.SpellCheckerSession$SpellCheckerSessionListenerImpl ), 0, this, spellCheckerSessionListenerImpl);
        }

        @Override
        public void onServiceConnected(ISpellCheckerSession iSpellCheckerSession) {
            InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_view_textservice_SpellCheckerSession_InternalListener$onServiceConnected(com.android.internal.textservice.ISpellCheckerSession ), 0, this, iSpellCheckerSession);
        }

        public /* synthetic */ InternalListener() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InternalListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface SpellCheckerSessionListener
    extends InstrumentedInterface {
        public void onGetSuggestions(SuggestionsInfo[] var1);

        public void onGetSentenceSuggestions(SentenceSuggestionsInfo[] var1);
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class SpellCheckerSessionListenerImpl
    extends ISpellCheckerSessionListener.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int TASK_CANCEL = 1;
        private static int TASK_GET_SUGGESTIONS_MULTIPLE = 2;
        private static int TASK_CLOSE = 3;
        private static int TASK_GET_SUGGESTIONS_MULTIPLE_FOR_SENTENCE = 4;
        private Queue<SpellCheckerParams> mPendingTasks;
        private Handler mHandler;
        private static int STATE_WAIT_CONNECTION = 0;
        private static int STATE_CONNECTED = 1;
        private static int STATE_CLOSED_AFTER_CONNECTION = 2;
        private static int STATE_CLOSED_BEFORE_CONNECTION = 3;
        private int mState;
        private ISpellCheckerSession mISpellCheckerSession;
        private HandlerThread mThread;
        private Handler mAsyncHandler;

        private static final String $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$taskToString(int task) {
            switch (task) {
                case 1: {
                    return "TASK_CANCEL";
                }
                case 2: {
                    return "TASK_GET_SUGGESTIONS_MULTIPLE";
                }
                case 3: {
                    return "TASK_CLOSE";
                }
                case 4: {
                    return "TASK_GET_SUGGESTIONS_MULTIPLE_FOR_SENTENCE";
                }
            }
            return "Unexpected task=" + task;
        }

        private static final String $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$stateToString(int state) {
            switch (state) {
                case 0: {
                    return "STATE_WAIT_CONNECTION";
                }
                case 1: {
                    return "STATE_CONNECTED";
                }
                case 2: {
                    return "STATE_CLOSED_AFTER_CONNECTION";
                }
                case 3: {
                    return "STATE_CLOSED_BEFORE_CONNECTION";
                }
            }
            return "Unexpected state=" + state;
        }

        private void $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$__constructor__(Handler handler) {
            this.mPendingTasks = new LinkedList<SpellCheckerParams>();
            this.mState = 0;
            this.mHandler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$processTask(ISpellCheckerSession session, SpellCheckerParams scp, boolean async) {
            if (async || this.mAsyncHandler == null) {
                switch (scp.mWhat) {
                    case 1: {
                        try {
                            session.onCancel();
                        }
                        catch (RemoteException e) {
                            Log.e(TAG, "Failed to cancel " + e);
                        }
                        break;
                    }
                    case 2: {
                        try {
                            session.onGetSuggestionsMultiple(scp.mTextInfos, scp.mSuggestionsLimit, scp.mSequentialWords);
                        }
                        catch (RemoteException e) {
                            Log.e(TAG, "Failed to get suggestions " + e);
                        }
                        break;
                    }
                    case 4: {
                        try {
                            session.onGetSentenceSuggestionsMultiple(scp.mTextInfos, scp.mSuggestionsLimit);
                        }
                        catch (RemoteException e) {
                            Log.e(TAG, "Failed to get suggestions " + e);
                        }
                        break;
                    }
                    case 3: {
                        try {
                            session.onClose();
                            break;
                        }
                        catch (RemoteException e) {
                            Log.e(TAG, "Failed to close " + e);
                        }
                    }
                }
            } else {
                scp.mSession = session;
                this.mAsyncHandler.sendMessage(Message.obtain(this.mAsyncHandler, 1, scp));
            }
            if (scp.mWhat == 3) {
                SpellCheckerSessionListenerImpl spellCheckerSessionListenerImpl = this;
                synchronized (spellCheckerSessionListenerImpl) {
                    this.processCloseLocked();
                }
            }
        }

        private final void $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$processCloseLocked() {
            this.mISpellCheckerSession = null;
            if (this.mThread != null) {
                this.mThread.quit();
            }
            this.mHandler = null;
            this.mPendingTasks.clear();
            this.mThread = null;
            this.mAsyncHandler = null;
            switch (this.mState) {
                case 0: {
                    this.mState = 3;
                    break;
                }
                case 1: {
                    this.mState = 2;
                    break;
                }
                default: {
                    Log.e(TAG, "processCloseLocked is called unexpectedly. mState=" + SpellCheckerSessionListenerImpl.stateToString(this.mState));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$onServiceConnected(ISpellCheckerSession session) {
            SpellCheckerSessionListenerImpl spellCheckerSessionListenerImpl = this;
            synchronized (spellCheckerSessionListenerImpl) {
                switch (this.mState) {
                    case 0: {
                        break;
                    }
                    case 3: {
                        return;
                    }
                    default: {
                        Log.e(TAG, "ignoring onServiceConnected due to unexpected mState=" + SpellCheckerSessionListenerImpl.stateToString(this.mState));
                        return;
                    }
                }
                if (session == null) {
                    Log.e(TAG, "ignoring onServiceConnected due to session=null");
                    return;
                }
                this.mISpellCheckerSession = session;
                if (session.asBinder() instanceof Binder && this.mThread == null) {
                    this.mThread = new HandlerThread("SpellCheckerSession", 10);
                    this.mThread.start();
                    this.mAsyncHandler = new ShadowedObject(this, this.mThread.getLooper()){
                        public transient /* synthetic */ Object __robo_data__;
                        /* synthetic */ SpellCheckerSessionListenerImpl this$0;

                        private void $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl_1$__constructor__(SpellCheckerSessionListenerImpl this$0, Looper x0) {
                        }

                        private final void $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl_1$handleMessage(Message msg) {
                            SpellCheckerParams scp = (SpellCheckerParams)msg.obj;
                            this.this$0.processTask(scp.mSession, scp, true);
                        }

                        private void __constructor__(SpellCheckerSessionListenerImpl spellCheckerSessionListenerImpl, Looper looper) {
                            this.$$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl_1$__constructor__(spellCheckerSessionListenerImpl, looper);
                        }
                        {
                            this.this$0 = spellCheckerSessionListenerImpl;
                            super(looper);
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl_1$__constructor__(android.view.textservice.SpellCheckerSession$SpellCheckerSessionListenerImpl android.os.Looper ), 0, this, spellCheckerSessionListenerImpl, looper);
                        }

                        @Override
                        public void handleMessage(Message message) {
                            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl_1$handleMessage(android.os.Message ), 0, this, message);
                        }
                        {
                            this.$$robo$init();
                        }

                        @Override
                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        @Override
                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    };
                }
                this.mState = 1;
                while (!this.mPendingTasks.isEmpty()) {
                    this.processTask(session, this.mPendingTasks.poll(), false);
                }
            }
        }

        private final void $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$cancel() {
            this.processOrEnqueueTask(new SpellCheckerParams(1, null, 0, false));
        }

        private final void $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$getSuggestionsMultiple(TextInfo[] textInfos, int suggestionsLimit, boolean sequentialWords) {
            this.processOrEnqueueTask(new SpellCheckerParams(2, textInfos, suggestionsLimit, sequentialWords));
        }

        private final void $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$getSentenceSuggestionsMultiple(TextInfo[] textInfos, int suggestionsLimit) {
            this.processOrEnqueueTask(new SpellCheckerParams(4, textInfos, suggestionsLimit, false));
        }

        private final void $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$close() {
            this.processOrEnqueueTask(new SpellCheckerParams(3, null, 0, false));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$isDisconnected() {
            SpellCheckerSessionListenerImpl spellCheckerSessionListenerImpl = this;
            synchronized (spellCheckerSessionListenerImpl) {
                return this.mState != 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$processOrEnqueueTask(SpellCheckerParams scp) {
            ISpellCheckerSession session;
            SpellCheckerSessionListenerImpl spellCheckerSessionListenerImpl = this;
            synchronized (spellCheckerSessionListenerImpl) {
                if (scp.mWhat == 3 && (this.mState == 2 || this.mState == 3)) {
                    return;
                }
                if (this.mState != 0 && this.mState != 1) {
                    Log.e(TAG, "ignoring processOrEnqueueTask due to unexpected mState=" + SpellCheckerSessionListenerImpl.stateToString(this.mState) + " scp.mWhat=" + SpellCheckerSessionListenerImpl.taskToString(scp.mWhat));
                    return;
                }
                if (this.mState == 0) {
                    if (scp.mWhat == 3) {
                        this.processCloseLocked();
                        return;
                    }
                    SpellCheckerParams closeTask = null;
                    if (scp.mWhat == 1) {
                        while (!this.mPendingTasks.isEmpty()) {
                            SpellCheckerParams tmp = this.mPendingTasks.poll();
                            if (tmp.mWhat != 3) continue;
                            closeTask = tmp;
                        }
                    }
                    this.mPendingTasks.offer(scp);
                    if (closeTask != null) {
                        this.mPendingTasks.offer(closeTask);
                    }
                    return;
                }
                session = this.mISpellCheckerSession;
            }
            this.processTask(session, scp, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$onGetSuggestions(SuggestionsInfo[] results) {
            SpellCheckerSessionListenerImpl spellCheckerSessionListenerImpl = this;
            synchronized (spellCheckerSessionListenerImpl) {
                if (this.mHandler != null) {
                    this.mHandler.sendMessage(Message.obtain(this.mHandler, 1, results));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$onGetSentenceSuggestions(SentenceSuggestionsInfo[] results) {
            SpellCheckerSessionListenerImpl spellCheckerSessionListenerImpl = this;
            synchronized (spellCheckerSessionListenerImpl) {
                if (this.mHandler != null) {
                    this.mHandler.sendMessage(Message.obtain(this.mHandler, 2, results));
                }
            }
        }

        private static String taskToString(int n) {
            return InvokeDynamicSupport.bootstrapStatic("taskToString", $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$taskToString(int ), 0, (int)n);
        }

        private static String stateToString(int n) {
            return InvokeDynamicSupport.bootstrapStatic("stateToString", $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$stateToString(int ), 0, (int)n);
        }

        private void __constructor__(Handler handler) {
            this.$$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$__constructor__(handler);
        }

        public SpellCheckerSessionListenerImpl(Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$__constructor__(android.os.Handler ), 0, this, handler);
        }

        private void processTask(ISpellCheckerSession iSpellCheckerSession, SpellCheckerParams spellCheckerParams, boolean bl) {
            InvokeDynamicSupport.bootstrap("processTask", $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$processTask(com.android.internal.textservice.ISpellCheckerSession android.view.textservice.SpellCheckerSession$SpellCheckerSessionListenerImpl$SpellCheckerParams boolean ), 0, this, iSpellCheckerSession, spellCheckerParams, bl);
        }

        private void processCloseLocked() {
            InvokeDynamicSupport.bootstrap("processCloseLocked", $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$processCloseLocked(), 0, this);
        }

        public void onServiceConnected(ISpellCheckerSession iSpellCheckerSession) {
            InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$onServiceConnected(com.android.internal.textservice.ISpellCheckerSession ), 0, this, iSpellCheckerSession);
        }

        public void cancel() {
            InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$cancel(), 0, this);
        }

        public void getSuggestionsMultiple(TextInfo[] textInfoArray, int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("getSuggestionsMultiple", $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$getSuggestionsMultiple(android.view.textservice.TextInfo[] int boolean ), 0, this, textInfoArray, n, bl);
        }

        public void getSentenceSuggestionsMultiple(TextInfo[] textInfoArray, int n) {
            InvokeDynamicSupport.bootstrap("getSentenceSuggestionsMultiple", $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$getSentenceSuggestionsMultiple(android.view.textservice.TextInfo[] int ), 0, this, textInfoArray, n);
        }

        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$close(), 0, this);
        }

        public boolean isDisconnected() {
            return (boolean)InvokeDynamicSupport.bootstrap("isDisconnected", $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$isDisconnected(), 0, this);
        }

        private void processOrEnqueueTask(SpellCheckerParams spellCheckerParams) {
            InvokeDynamicSupport.bootstrap("processOrEnqueueTask", $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$processOrEnqueueTask(android.view.textservice.SpellCheckerSession$SpellCheckerSessionListenerImpl$SpellCheckerParams ), 0, this, spellCheckerParams);
        }

        @Override
        public void onGetSuggestions(SuggestionsInfo[] suggestionsInfoArray) {
            InvokeDynamicSupport.bootstrap("onGetSuggestions", $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$onGetSuggestions(android.view.textservice.SuggestionsInfo[] ), 0, this, suggestionsInfoArray);
        }

        @Override
        public void onGetSentenceSuggestions(SentenceSuggestionsInfo[] sentenceSuggestionsInfoArray) {
            InvokeDynamicSupport.bootstrap("onGetSentenceSuggestions", $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl$onGetSentenceSuggestions(android.view.textservice.SentenceSuggestionsInfo[] ), 0, this, sentenceSuggestionsInfoArray);
        }

        public /* synthetic */ SpellCheckerSessionListenerImpl() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpellCheckerSessionListenerImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class SpellCheckerParams
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            public int mWhat;
            public TextInfo[] mTextInfos;
            public int mSuggestionsLimit;
            public boolean mSequentialWords;
            public ISpellCheckerSession mSession;

            private void $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl_SpellCheckerParams$__constructor__(int what, TextInfo[] textInfos, int suggestionsLimit, boolean sequentialWords) {
                this.mWhat = what;
                this.mTextInfos = textInfos;
                this.mSuggestionsLimit = suggestionsLimit;
                this.mSequentialWords = sequentialWords;
            }

            private void __constructor__(int n, TextInfo[] textInfoArray, int n2, boolean bl) {
                this.$$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl_SpellCheckerParams$__constructor__(n, textInfoArray, n2, bl);
            }

            public SpellCheckerParams(int n, TextInfo[] textInfoArray, int n2, boolean bl) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textservice_SpellCheckerSession_SpellCheckerSessionListenerImpl_SpellCheckerParams$__constructor__(int android.view.textservice.TextInfo[] int boolean ), 0, this, n, textInfoArray, n2, bl);
            }

            public /* synthetic */ SpellCheckerParams() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpellCheckerParams)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

