/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.annotation.SystemApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import android.view.ActionMode;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
public class FindActionModeCallback
implements ActionMode.Callback,
TextWatcher,
View.OnClickListener,
WebView.FindListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private View mCustomView;
    private EditText mEditText;
    private TextView mMatches;
    private WebView mWebView;
    private InputMethodManager mInput;
    private Resources mResources;
    private boolean mMatchesFound;
    private int mNumberOfMatches;
    private int mActiveMatchIndex;
    private ActionMode mActionMode;
    private Rect mGlobalVisibleRect;
    private Point mGlobalVisibleOffset;

    private void $$robo$$android_webkit_FindActionModeCallback$__constructor__(Context context) {
        this.mGlobalVisibleRect = new Rect();
        this.mGlobalVisibleOffset = new Point();
        this.mCustomView = LayoutInflater.from(context).inflate(17367326, null);
        this.mEditText = (EditText)this.mCustomView.findViewById(16908291);
        this.mEditText.setCustomSelectionActionModeCallback(new NoAction());
        this.mEditText.setOnClickListener(this);
        this.setText("");
        this.mMatches = (TextView)this.mCustomView.findViewById(16909046);
        this.mInput = context.getSystemService(InputMethodManager.class);
        this.mResources = context.getResources();
    }

    private final void $$robo$$android_webkit_FindActionModeCallback$finish() {
        this.mActionMode.finish();
    }

    private final void $$robo$$android_webkit_FindActionModeCallback$setText(String text) {
        this.mEditText.setText(text);
        CharSequence span = this.mEditText.getText();
        int length = span.length();
        Selection.setSelection((Spannable)span, length, length);
        span.setSpan(this, 0, length, 18);
        this.mMatchesFound = false;
    }

    private final void $$robo$$android_webkit_FindActionModeCallback$setWebView(WebView webView) {
        if (null == webView) {
            throw new AssertionError((Object)"WebView supplied to FindActionModeCallback cannot be null");
        }
        this.mWebView = webView;
        this.mWebView.setFindDialogFindListener(this);
    }

    private final void $$robo$$android_webkit_FindActionModeCallback$onFindResultReceived(int activeMatchOrdinal, int numberOfMatches, boolean isDoneCounting) {
        if (isDoneCounting) {
            this.updateMatchCount(activeMatchOrdinal, numberOfMatches, numberOfMatches == 0);
        }
    }

    private final void $$robo$$android_webkit_FindActionModeCallback$findNext(boolean next) {
        if (this.mWebView == null) {
            throw new AssertionError((Object)"No WebView for FindActionModeCallback::findNext");
        }
        if (!this.mMatchesFound) {
            this.findAll();
            return;
        }
        if (0 == this.mNumberOfMatches) {
            return;
        }
        this.mWebView.findNext(next);
        this.updateMatchesString();
    }

    private final void $$robo$$android_webkit_FindActionModeCallback$findAll() {
        if (this.mWebView == null) {
            throw new AssertionError((Object)"No WebView for FindActionModeCallback::findAll");
        }
        CharSequence find = this.mEditText.getText();
        if (0 == find.length()) {
            this.mWebView.clearMatches();
            this.mMatches.setVisibility(8);
            this.mMatchesFound = false;
            this.mWebView.findAll(null);
        } else {
            this.mMatchesFound = true;
            this.mMatches.setVisibility(4);
            this.mNumberOfMatches = 0;
            this.mWebView.findAllAsync(find.toString());
        }
    }

    private final void $$robo$$android_webkit_FindActionModeCallback$showSoftInput() {
        if (this.mEditText.requestFocus()) {
            this.mInput.showSoftInput(this.mEditText, 0);
        }
    }

    private final void $$robo$$android_webkit_FindActionModeCallback$updateMatchCount(int matchIndex, int matchCount, boolean isEmptyFind) {
        if (!isEmptyFind) {
            this.mNumberOfMatches = matchCount;
            this.mActiveMatchIndex = matchIndex;
            this.updateMatchesString();
        } else {
            this.mMatches.setVisibility(8);
            this.mNumberOfMatches = 0;
        }
    }

    private final void $$robo$$android_webkit_FindActionModeCallback$updateMatchesString() {
        if (this.mNumberOfMatches == 0) {
            this.mMatches.setText(17040347);
        } else {
            this.mMatches.setText(this.mResources.getQuantityString(18153492, this.mNumberOfMatches, this.mActiveMatchIndex + 1, this.mNumberOfMatches));
        }
        this.mMatches.setVisibility(0);
    }

    private final void $$robo$$android_webkit_FindActionModeCallback$onClick(View v) {
        this.findNext(true);
    }

    private final boolean $$robo$$android_webkit_FindActionModeCallback$onCreateActionMode(ActionMode mode, Menu menu2) {
        if (!mode.isUiFocusable()) {
            return false;
        }
        mode.setCustomView(this.mCustomView);
        mode.getMenuInflater().inflate(18087938, menu2);
        this.mActionMode = mode;
        CharSequence edit = this.mEditText.getText();
        Selection.setSelection((Spannable)edit, edit.length());
        this.mMatches.setVisibility(8);
        this.mMatchesFound = false;
        this.mMatches.setText("0");
        this.mEditText.requestFocus();
        return true;
    }

    private final void $$robo$$android_webkit_FindActionModeCallback$onDestroyActionMode(ActionMode mode) {
        this.mActionMode = null;
        this.mWebView.notifyFindDialogDismissed();
        this.mWebView.setFindDialogFindListener(null);
        this.mInput.hideSoftInputFromWindow(this.mWebView.getWindowToken(), 0);
    }

    private final boolean $$robo$$android_webkit_FindActionModeCallback$onPrepareActionMode(ActionMode mode, Menu menu2) {
        return false;
    }

    private final boolean $$robo$$android_webkit_FindActionModeCallback$onActionItemClicked(ActionMode mode, MenuItem item) {
        if (this.mWebView == null) {
            throw new AssertionError((Object)"No WebView for FindActionModeCallback::onActionItemClicked");
        }
        this.mInput.hideSoftInputFromWindow(this.mWebView.getWindowToken(), 0);
        switch (item.getItemId()) {
            case 16908883: {
                this.findNext(false);
                break;
            }
            case 16908882: {
                this.findNext(true);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private final void $$robo$$android_webkit_FindActionModeCallback$beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    private final void $$robo$$android_webkit_FindActionModeCallback$onTextChanged(CharSequence s, int start, int before, int count) {
        this.findAll();
    }

    private final void $$robo$$android_webkit_FindActionModeCallback$afterTextChanged(Editable s) {
    }

    private final int $$robo$$android_webkit_FindActionModeCallback$getActionModeGlobalBottom() {
        if (this.mActionMode == null) {
            return 0;
        }
        View view = (View)((Object)this.mCustomView.getParent());
        if (view == null) {
            view = this.mCustomView;
        }
        view.getGlobalVisibleRect(this.mGlobalVisibleRect, this.mGlobalVisibleOffset);
        return this.mGlobalVisibleRect.bottom;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_webkit_FindActionModeCallback$__constructor__(context);
    }

    public FindActionModeCallback(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_FindActionModeCallback$__constructor__(android.content.Context ), 0, this, context);
    }

    public void finish() {
        InvokeDynamicSupport.bootstrap("finish", $$robo$$android_webkit_FindActionModeCallback$finish(), 0, this);
    }

    public void setText(String string2) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_webkit_FindActionModeCallback$setText(java.lang.String ), 0, this, string2);
    }

    public void setWebView(WebView webView) {
        InvokeDynamicSupport.bootstrap("setWebView", $$robo$$android_webkit_FindActionModeCallback$setWebView(android.webkit.WebView ), 0, this, webView);
    }

    @Override
    public void onFindResultReceived(int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("onFindResultReceived", $$robo$$android_webkit_FindActionModeCallback$onFindResultReceived(int int boolean ), 0, this, n, n2, bl);
    }

    private void findNext(boolean bl) {
        InvokeDynamicSupport.bootstrap("findNext", $$robo$$android_webkit_FindActionModeCallback$findNext(boolean ), 0, this, bl);
    }

    public void findAll() {
        InvokeDynamicSupport.bootstrap("findAll", $$robo$$android_webkit_FindActionModeCallback$findAll(), 0, this);
    }

    public void showSoftInput() {
        InvokeDynamicSupport.bootstrap("showSoftInput", $$robo$$android_webkit_FindActionModeCallback$showSoftInput(), 0, this);
    }

    public void updateMatchCount(int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("updateMatchCount", $$robo$$android_webkit_FindActionModeCallback$updateMatchCount(int int boolean ), 0, this, n, n2, bl);
    }

    private void updateMatchesString() {
        InvokeDynamicSupport.bootstrap("updateMatchesString", $$robo$$android_webkit_FindActionModeCallback$updateMatchesString(), 0, this);
    }

    @Override
    public void onClick(View view) {
        InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_webkit_FindActionModeCallback$onClick(android.view.View ), 0, this, view);
    }

    @Override
    public boolean onCreateActionMode(ActionMode actionMode, Menu menu2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onCreateActionMode", $$robo$$android_webkit_FindActionModeCallback$onCreateActionMode(android.view.ActionMode android.view.Menu ), 0, this, actionMode, menu2);
    }

    @Override
    public void onDestroyActionMode(ActionMode actionMode) {
        InvokeDynamicSupport.bootstrap("onDestroyActionMode", $$robo$$android_webkit_FindActionModeCallback$onDestroyActionMode(android.view.ActionMode ), 0, this, actionMode);
    }

    @Override
    public boolean onPrepareActionMode(ActionMode actionMode, Menu menu2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onPrepareActionMode", $$robo$$android_webkit_FindActionModeCallback$onPrepareActionMode(android.view.ActionMode android.view.Menu ), 0, this, actionMode, menu2);
    }

    @Override
    public boolean onActionItemClicked(ActionMode actionMode, MenuItem menuItem) {
        return (boolean)InvokeDynamicSupport.bootstrap("onActionItemClicked", $$robo$$android_webkit_FindActionModeCallback$onActionItemClicked(android.view.ActionMode android.view.MenuItem ), 0, this, actionMode, menuItem);
    }

    @Override
    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("beforeTextChanged", $$robo$$android_webkit_FindActionModeCallback$beforeTextChanged(java.lang.CharSequence int int int ), 0, this, charSequence, n, n2, n3);
    }

    @Override
    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("onTextChanged", $$robo$$android_webkit_FindActionModeCallback$onTextChanged(java.lang.CharSequence int int int ), 0, this, charSequence, n, n2, n3);
    }

    @Override
    public void afterTextChanged(Editable editable) {
        InvokeDynamicSupport.bootstrap("afterTextChanged", $$robo$$android_webkit_FindActionModeCallback$afterTextChanged(android.text.Editable ), 0, this, editable);
    }

    public int getActionModeGlobalBottom() {
        return (int)InvokeDynamicSupport.bootstrap("getActionModeGlobalBottom", $$robo$$android_webkit_FindActionModeCallback$getActionModeGlobalBottom(), 0, this);
    }

    public /* synthetic */ FindActionModeCallback() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FindActionModeCallback)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class NoAction
    implements ActionMode.Callback,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_webkit_FindActionModeCallback_NoAction$__constructor__() {
        }

        private final boolean $$robo$$android_webkit_FindActionModeCallback_NoAction$onCreateActionMode(ActionMode mode, Menu menu2) {
            return false;
        }

        private final boolean $$robo$$android_webkit_FindActionModeCallback_NoAction$onPrepareActionMode(ActionMode mode, Menu menu2) {
            return false;
        }

        private final boolean $$robo$$android_webkit_FindActionModeCallback_NoAction$onActionItemClicked(ActionMode mode, MenuItem item) {
            return false;
        }

        private final void $$robo$$android_webkit_FindActionModeCallback_NoAction$onDestroyActionMode(ActionMode mode) {
        }

        private void __constructor__() {
            this.$$robo$$android_webkit_FindActionModeCallback_NoAction$__constructor__();
        }

        public NoAction() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_FindActionModeCallback_NoAction$__constructor__(), 0, this);
        }

        @Override
        public boolean onCreateActionMode(ActionMode actionMode, Menu menu2) {
            return (boolean)InvokeDynamicSupport.bootstrap("onCreateActionMode", $$robo$$android_webkit_FindActionModeCallback_NoAction$onCreateActionMode(android.view.ActionMode android.view.Menu ), 0, this, actionMode, menu2);
        }

        @Override
        public boolean onPrepareActionMode(ActionMode actionMode, Menu menu2) {
            return (boolean)InvokeDynamicSupport.bootstrap("onPrepareActionMode", $$robo$$android_webkit_FindActionModeCallback_NoAction$onPrepareActionMode(android.view.ActionMode android.view.Menu ), 0, this, actionMode, menu2);
        }

        @Override
        public boolean onActionItemClicked(ActionMode actionMode, MenuItem menuItem) {
            return (boolean)InvokeDynamicSupport.bootstrap("onActionItemClicked", $$robo$$android_webkit_FindActionModeCallback_NoAction$onActionItemClicked(android.view.ActionMode android.view.MenuItem ), 0, this, actionMode, menuItem);
        }

        @Override
        public void onDestroyActionMode(ActionMode actionMode) {
            InvokeDynamicSupport.bootstrap("onDestroyActionMode", $$robo$$android_webkit_FindActionModeCallback_NoAction$onDestroyActionMode(android.view.ActionMode ), 0, this, actionMode);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NoAction)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

