/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.os.Trace;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.StateSet;
import android.view.ActionMode;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewHierarchyEncoder;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputContentInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.Checkable;
import android.widget.EdgeEffect;
import android.widget.EditText;
import android.widget.FastScroller;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ListAdapter;
import android.widget.OverScroller;
import android.widget.PopupWindow;
import android.widget.RemoteViews;
import android.widget.RemoteViewsAdapter;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AbsListView
extends AdapterView<ListAdapter>
implements TextWatcher,
ViewTreeObserver.OnGlobalLayoutListener,
Filter.FilterListener,
ViewTreeObserver.OnTouchModeChangeListener,
RemoteViewsAdapter.RemoteAdapterConnectionCallback {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AbsListView";
    public static int TRANSCRIPT_MODE_DISABLED = 0;
    public static int TRANSCRIPT_MODE_NORMAL = 1;
    public static int TRANSCRIPT_MODE_ALWAYS_SCROLL = 2;
    static int TOUCH_MODE_REST = -1;
    static int TOUCH_MODE_DOWN = 0;
    static int TOUCH_MODE_TAP = 1;
    static int TOUCH_MODE_DONE_WAITING = 2;
    static int TOUCH_MODE_SCROLL = 3;
    static int TOUCH_MODE_FLING = 4;
    static int TOUCH_MODE_OVERSCROLL = 5;
    static int TOUCH_MODE_OVERFLING = 6;
    static int LAYOUT_NORMAL = 0;
    static int LAYOUT_FORCE_TOP = 1;
    static int LAYOUT_SET_SELECTION = 2;
    static int LAYOUT_FORCE_BOTTOM = 3;
    static int LAYOUT_SPECIFIC = 4;
    static int LAYOUT_SYNC = 5;
    static int LAYOUT_MOVE_SELECTION = 6;
    public static int CHOICE_MODE_NONE = 0;
    public static int CHOICE_MODE_SINGLE = 1;
    public static int CHOICE_MODE_MULTIPLE = 2;
    public static int CHOICE_MODE_MULTIPLE_MODAL = 3;
    private Thread mOwnerThread;
    int mChoiceMode;
    ActionMode mChoiceActionMode;
    MultiChoiceModeWrapper mMultiChoiceModeCallback;
    int mCheckedItemCount;
    SparseBooleanArray mCheckStates;
    LongSparseArray<Integer> mCheckedIdStates;
    int mLayoutMode;
    AdapterDataSetObserver mDataSetObserver;
    ListAdapter mAdapter;
    private RemoteViewsAdapter mRemoteAdapter;
    boolean mAdapterHasStableIds;
    private boolean mDeferNotifyDataSetChanged;
    boolean mDrawSelectorOnTop;
    Drawable mSelector;
    int mSelectorPosition;
    Rect mSelectorRect;
    RecycleBin mRecycler;
    int mSelectionLeftPadding;
    int mSelectionTopPadding;
    int mSelectionRightPadding;
    int mSelectionBottomPadding;
    Rect mListPadding;
    int mWidthMeasureSpec;
    View mScrollUp;
    View mScrollDown;
    boolean mCachingStarted;
    boolean mCachingActive;
    int mMotionPosition;
    int mMotionViewOriginalTop;
    int mMotionViewNewTop;
    int mMotionX;
    int mMotionY;
    int mTouchMode;
    int mLastY;
    int mMotionCorrection;
    private VelocityTracker mVelocityTracker;
    private FlingRunnable mFlingRunnable;
    AbsPositionScroller mPositionScroller;
    int mSelectedTop;
    boolean mStackFromBottom;
    boolean mScrollingCacheEnabled;
    boolean mFastScrollEnabled;
    boolean mFastScrollAlwaysVisible;
    private OnScrollListener mOnScrollListener;
    PopupWindow mPopup;
    EditText mTextFilter;
    private boolean mSmoothScrollbarEnabled;
    private boolean mTextFilterEnabled;
    private boolean mFiltered;
    private Rect mTouchFrame;
    int mResurrectToPosition;
    private ContextMenu.ContextMenuInfo mContextMenuInfo;
    int mOverscrollMax;
    static int OVERSCROLL_LIMIT_DIVISOR = 3;
    private static int CHECK_POSITION_SEARCH_DISTANCE = 20;
    private static int TOUCH_MODE_UNKNOWN = -1;
    private static int TOUCH_MODE_ON = 0;
    private static int TOUCH_MODE_OFF = 1;
    private int mLastTouchMode;
    private static boolean PROFILE_SCROLLING = false;
    private boolean mScrollProfilingStarted;
    private static boolean PROFILE_FLINGING = false;
    private boolean mFlingProfilingStarted;
    private StrictMode.Span mScrollStrictSpan;
    private StrictMode.Span mFlingStrictSpan;
    private CheckForLongPress mPendingCheckForLongPress;
    private CheckForTap mPendingCheckForTap;
    private CheckForKeyLongPress mPendingCheckForKeyLongPress;
    private PerformClick mPerformClick;
    private Runnable mTouchModeReset;
    private boolean mHasPerformedLongPress;
    private int mTranscriptMode;
    private int mCacheColorHint;
    private boolean mIsChildViewEnabled;
    private int[] mSelectorState;
    private int mLastScrollState;
    private FastScroller mFastScroll;
    private int mFastScrollStyle;
    private boolean mGlobalLayoutListenerAddedFilter;
    private int mTouchSlop;
    private float mDensityScale;
    private float mVerticalScrollFactor;
    private InputConnection mDefInputConnection;
    private InputConnectionWrapper mPublicInputConnection;
    private Runnable mClearScrollingCache;
    Runnable mPositionScrollAfterLayout;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private float mVelocityScale;
    boolean[] mIsScrap;
    private int[] mScrollOffset;
    private int[] mScrollConsumed;
    private float[] mTmpPoint;
    private int mNestedYOffset;
    private boolean mPopupHidden;
    private int mActivePointerId;
    private static int INVALID_POINTER = -1;
    int mOverscrollDistance;
    int mOverflingDistance;
    private EdgeEffect mEdgeGlowTop;
    private EdgeEffect mEdgeGlowBottom;
    private int mFirstPositionDistanceGuess;
    private int mLastPositionDistanceGuess;
    private int mDirection;
    private boolean mForceTranscriptScroll;
    private ListItemAccessibilityDelegate mAccessibilityDelegate;
    private int mLastAccessibilityScrollEventFromIndex;
    private int mLastAccessibilityScrollEventToIndex;
    private int mLastHandledItemCount;
    static Interpolator sLinearInterpolator;
    private SavedState mPendingSync;
    private boolean mIsDetaching;

    private void $$robo$$android_widget_AbsListView$__constructor__(Context context) {
        this.mChoiceMode = 0;
        this.mLayoutMode = 0;
        this.mDeferNotifyDataSetChanged = false;
        this.mDrawSelectorOnTop = false;
        this.mSelectorPosition = -1;
        this.mSelectorRect = new Rect();
        this.mRecycler = new RecycleBin(this);
        this.mSelectionLeftPadding = 0;
        this.mSelectionTopPadding = 0;
        this.mSelectionRightPadding = 0;
        this.mSelectionBottomPadding = 0;
        this.mListPadding = new Rect();
        this.mWidthMeasureSpec = 0;
        this.mTouchMode = -1;
        this.mSelectedTop = 0;
        this.mSmoothScrollbarEnabled = true;
        this.mResurrectToPosition = -1;
        this.mContextMenuInfo = null;
        this.mLastTouchMode = -1;
        this.mScrollProfilingStarted = false;
        this.mFlingProfilingStarted = false;
        this.mScrollStrictSpan = null;
        this.mFlingStrictSpan = null;
        this.mLastScrollState = 0;
        this.mVelocityScale = 1.0f;
        this.mIsScrap = new boolean[1];
        this.mScrollOffset = new int[2];
        this.mScrollConsumed = new int[2];
        this.mTmpPoint = new float[2];
        this.mNestedYOffset = 0;
        this.mActivePointerId = -1;
        this.mDirection = 0;
        this.initAbsListView();
        this.mOwnerThread = Thread.currentThread();
        this.setVerticalScrollBarEnabled(true);
        TypedArray a = context.obtainStyledAttributes(R.styleable.View);
        this.initializeScrollbarsInternal(a);
        a.recycle();
    }

    private void $$robo$$android_widget_AbsListView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_AbsListView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_AbsListView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mChoiceMode = 0;
        this.mLayoutMode = 0;
        this.mDeferNotifyDataSetChanged = false;
        this.mDrawSelectorOnTop = false;
        this.mSelectorPosition = -1;
        this.mSelectorRect = new Rect();
        this.mRecycler = new RecycleBin(this);
        this.mSelectionLeftPadding = 0;
        this.mSelectionTopPadding = 0;
        this.mSelectionRightPadding = 0;
        this.mSelectionBottomPadding = 0;
        this.mListPadding = new Rect();
        this.mWidthMeasureSpec = 0;
        this.mTouchMode = -1;
        this.mSelectedTop = 0;
        this.mSmoothScrollbarEnabled = true;
        this.mResurrectToPosition = -1;
        this.mContextMenuInfo = null;
        this.mLastTouchMode = -1;
        this.mScrollProfilingStarted = false;
        this.mFlingProfilingStarted = false;
        this.mScrollStrictSpan = null;
        this.mFlingStrictSpan = null;
        this.mLastScrollState = 0;
        this.mVelocityScale = 1.0f;
        this.mIsScrap = new boolean[1];
        this.mScrollOffset = new int[2];
        this.mScrollConsumed = new int[2];
        this.mTmpPoint = new float[2];
        this.mNestedYOffset = 0;
        this.mActivePointerId = -1;
        this.mDirection = 0;
        this.initAbsListView();
        this.mOwnerThread = Thread.currentThread();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AbsListView, defStyleAttr, defStyleRes);
        Drawable selector = a.getDrawable(0);
        if (selector != null) {
            this.setSelector(selector);
        }
        this.mDrawSelectorOnTop = a.getBoolean(1, false);
        this.setStackFromBottom(a.getBoolean(2, false));
        this.setScrollingCacheEnabled(a.getBoolean(3, true));
        this.setTextFilterEnabled(a.getBoolean(4, false));
        this.setTranscriptMode(a.getInt(5, 0));
        this.setCacheColorHint(a.getColor(6, 0));
        this.setSmoothScrollbarEnabled(a.getBoolean(9, true));
        this.setChoiceMode(a.getInt(7, 0));
        this.setFastScrollEnabled(a.getBoolean(8, false));
        this.setFastScrollStyle(a.getResourceId(11, 0));
        this.setFastScrollAlwaysVisible(a.getBoolean(10, false));
        a.recycle();
        if (context.getResources().getConfiguration().uiMode == 6) {
            this.setRevealOnFocusHint(false);
        }
    }

    private final void $$robo$$android_widget_AbsListView$initAbsListView() {
        this.setClickable(true);
        this.setFocusableInTouchMode(true);
        this.setWillNotDraw(false);
        this.setAlwaysDrawnWithCacheEnabled(false);
        this.setScrollingCacheEnabled(true);
        ViewConfiguration configuration = ViewConfiguration.get(this.mContext);
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mVerticalScrollFactor = configuration.getScaledVerticalScrollFactor();
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mOverscrollDistance = configuration.getScaledOverscrollDistance();
        this.mOverflingDistance = configuration.getScaledOverflingDistance();
        this.mDensityScale = this.getContext().getResources().getDisplayMetrics().density;
    }

    private final void $$robo$$android_widget_AbsListView$setOverScrollMode(int mode) {
        if (mode != 2) {
            if (this.mEdgeGlowTop == null) {
                Context context = this.getContext();
                this.mEdgeGlowTop = new EdgeEffect(context);
                this.mEdgeGlowBottom = new EdgeEffect(context);
            }
        } else {
            this.mEdgeGlowTop = null;
            this.mEdgeGlowBottom = null;
        }
        super.setOverScrollMode(mode);
    }

    private final void $$robo$$android_widget_AbsListView$setAdapter(ListAdapter adapter) {
        if (adapter != null) {
            this.mAdapterHasStableIds = this.mAdapter.hasStableIds();
            if (this.mChoiceMode != 0 && this.mAdapterHasStableIds && this.mCheckedIdStates == null) {
                this.mCheckedIdStates = new LongSparseArray();
            }
        }
        this.clearChoices();
    }

    private final int $$robo$$android_widget_AbsListView$getCheckedItemCount() {
        return this.mCheckedItemCount;
    }

    private final boolean $$robo$$android_widget_AbsListView$isItemChecked(int position) {
        if (this.mChoiceMode != 0 && this.mCheckStates != null) {
            return this.mCheckStates.get(position);
        }
        return false;
    }

    private final int $$robo$$android_widget_AbsListView$getCheckedItemPosition() {
        if (this.mChoiceMode == 1 && this.mCheckStates != null && this.mCheckStates.size() == 1) {
            return this.mCheckStates.keyAt(0);
        }
        return -1;
    }

    private final SparseBooleanArray $$robo$$android_widget_AbsListView$getCheckedItemPositions() {
        if (this.mChoiceMode != 0) {
            return this.mCheckStates;
        }
        return null;
    }

    private final long[] $$robo$$android_widget_AbsListView$getCheckedItemIds() {
        if (this.mChoiceMode == 0 || this.mCheckedIdStates == null || this.mAdapter == null) {
            return new long[0];
        }
        LongSparseArray<Integer> idStates = this.mCheckedIdStates;
        int count = idStates.size();
        long[] ids = new long[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = idStates.keyAt(i);
        }
        return ids;
    }

    private final void $$robo$$android_widget_AbsListView$clearChoices() {
        if (this.mCheckStates != null) {
            this.mCheckStates.clear();
        }
        if (this.mCheckedIdStates != null) {
            this.mCheckedIdStates.clear();
        }
        this.mCheckedItemCount = 0;
    }

    private final void $$robo$$android_widget_AbsListView$setItemChecked(int position, boolean value) {
        boolean itemCheckChanged;
        if (this.mChoiceMode == 0) {
            return;
        }
        if (value && this.mChoiceMode == 3 && this.mChoiceActionMode == null) {
            if (this.mMultiChoiceModeCallback == null || !this.mMultiChoiceModeCallback.hasWrappedCallback()) {
                throw new IllegalStateException("AbsListView: attempted to start selection mode for CHOICE_MODE_MULTIPLE_MODAL but no choice mode callback was supplied. Call setMultiChoiceModeListener to set a callback.");
            }
            this.mChoiceActionMode = this.startActionMode(this.mMultiChoiceModeCallback);
        }
        if (this.mChoiceMode == 2 || this.mChoiceMode == 3) {
            boolean oldValue = this.mCheckStates.get(position);
            this.mCheckStates.put(position, value);
            if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                if (value) {
                    this.mCheckedIdStates.put(this.mAdapter.getItemId(position), position);
                } else {
                    this.mCheckedIdStates.delete(this.mAdapter.getItemId(position));
                }
            }
            boolean bl = itemCheckChanged = oldValue != value;
            if (itemCheckChanged) {
                this.mCheckedItemCount = value ? ++this.mCheckedItemCount : --this.mCheckedItemCount;
            }
            if (this.mChoiceActionMode != null) {
                long id2 = this.mAdapter.getItemId(position);
                this.mMultiChoiceModeCallback.onItemCheckedStateChanged(this.mChoiceActionMode, position, id2, value);
            }
        } else {
            boolean updateIds = this.mCheckedIdStates != null && this.mAdapter.hasStableIds();
            boolean bl = itemCheckChanged = this.isItemChecked(position) != value;
            if (value || this.isItemChecked(position)) {
                this.mCheckStates.clear();
                if (updateIds) {
                    this.mCheckedIdStates.clear();
                }
            }
            if (value) {
                this.mCheckStates.put(position, true);
                if (updateIds) {
                    this.mCheckedIdStates.put(this.mAdapter.getItemId(position), position);
                }
                this.mCheckedItemCount = 1;
            } else if (this.mCheckStates.size() == 0 || !this.mCheckStates.valueAt(0)) {
                this.mCheckedItemCount = 0;
            }
        }
        if (!this.mInLayout && !this.mBlockLayoutRequests && itemCheckChanged) {
            this.mDataChanged = true;
            this.rememberSyncState();
            this.requestLayout();
        }
    }

    private final boolean $$robo$$android_widget_AbsListView$performItemClick(View view, int position, long id2) {
        boolean handled = false;
        boolean dispatchItemClick = true;
        if (this.mChoiceMode != 0) {
            handled = true;
            boolean checkedStateChanged = false;
            if (this.mChoiceMode == 2 || this.mChoiceMode == 3 && this.mChoiceActionMode != null) {
                boolean checked = !this.mCheckStates.get(position, false);
                this.mCheckStates.put(position, checked);
                if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                    if (checked) {
                        this.mCheckedIdStates.put(this.mAdapter.getItemId(position), position);
                    } else {
                        this.mCheckedIdStates.delete(this.mAdapter.getItemId(position));
                    }
                }
                this.mCheckedItemCount = checked ? ++this.mCheckedItemCount : --this.mCheckedItemCount;
                if (this.mChoiceActionMode != null) {
                    this.mMultiChoiceModeCallback.onItemCheckedStateChanged(this.mChoiceActionMode, position, id2, checked);
                    dispatchItemClick = false;
                }
                checkedStateChanged = true;
            } else if (this.mChoiceMode == 1) {
                boolean checked;
                boolean bl = checked = !this.mCheckStates.get(position, false);
                if (checked) {
                    this.mCheckStates.clear();
                    this.mCheckStates.put(position, true);
                    if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                        this.mCheckedIdStates.clear();
                        this.mCheckedIdStates.put(this.mAdapter.getItemId(position), position);
                    }
                    this.mCheckedItemCount = 1;
                } else if (this.mCheckStates.size() == 0 || !this.mCheckStates.valueAt(0)) {
                    this.mCheckedItemCount = 0;
                }
                checkedStateChanged = true;
            }
            if (checkedStateChanged) {
                this.updateOnScreenCheckedViews();
            }
        }
        if (dispatchItemClick) {
            handled |= super.performItemClick(view, position, id2);
        }
        return handled;
    }

    private final void $$robo$$android_widget_AbsListView$updateOnScreenCheckedViews() {
        int firstPos = this.mFirstPosition;
        int count = this.getChildCount();
        boolean useActivated = this.getContext().getApplicationInfo().targetSdkVersion >= 11;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            int position = firstPos + i;
            if (child instanceof Checkable) {
                ((Checkable)((Object)child)).setChecked(this.mCheckStates.get(position));
                continue;
            }
            if (!useActivated) continue;
            child.setActivated(this.mCheckStates.get(position));
        }
    }

    private final int $$robo$$android_widget_AbsListView$getChoiceMode() {
        return this.mChoiceMode;
    }

    private final void $$robo$$android_widget_AbsListView$setChoiceMode(int choiceMode) {
        this.mChoiceMode = choiceMode;
        if (this.mChoiceActionMode != null) {
            this.mChoiceActionMode.finish();
            this.mChoiceActionMode = null;
        }
        if (this.mChoiceMode != 0) {
            if (this.mCheckStates == null) {
                this.mCheckStates = new SparseBooleanArray(0);
            }
            if (this.mCheckedIdStates == null && this.mAdapter != null && this.mAdapter.hasStableIds()) {
                this.mCheckedIdStates = new LongSparseArray(0);
            }
            if (this.mChoiceMode == 3) {
                this.clearChoices();
                this.setLongClickable(true);
            }
        }
    }

    private final void $$robo$$android_widget_AbsListView$setMultiChoiceModeListener(MultiChoiceModeListener listener) {
        if (this.mMultiChoiceModeCallback == null) {
            this.mMultiChoiceModeCallback = new MultiChoiceModeWrapper(this);
        }
        this.mMultiChoiceModeCallback.setWrapped(listener);
    }

    private final boolean $$robo$$android_widget_AbsListView$contentFits() {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return true;
        }
        if (childCount != this.mItemCount) {
            return false;
        }
        return this.getChildAt(0).getTop() >= this.mListPadding.top && this.getChildAt(childCount - 1).getBottom() <= this.getHeight() - this.mListPadding.bottom;
    }

    private final void $$robo$$android_widget_AbsListView$setFastScrollEnabled(boolean enabled) {
        if (this.mFastScrollEnabled != enabled) {
            this.mFastScrollEnabled = enabled;
            if (this.isOwnerThread()) {
                this.setFastScrollerEnabledUiThread(enabled);
            } else {
                this.post(new Runnable(this, enabled){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ boolean val$enabled;
                    /* synthetic */ AbsListView this$0;

                    private void $$robo$$android_widget_AbsListView_1$__constructor__(AbsListView this$0, boolean bl) {
                    }

                    private final void $$robo$$android_widget_AbsListView_1$run() {
                        this.this$0.setFastScrollerEnabledUiThread(this.val$enabled);
                    }

                    private void __constructor__(AbsListView absListView, boolean bl) {
                        this.$$robo$$android_widget_AbsListView_1$__constructor__(absListView, bl);
                    }
                    {
                        this.this$0 = absListView;
                        this.val$enabled = bl;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_1$__constructor__(android.widget.AbsListView boolean ), 0, this, absListView, bl);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_AbsListView_1$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }
    }

    private final void $$robo$$android_widget_AbsListView$setFastScrollerEnabledUiThread(boolean enabled) {
        if (this.mFastScroll != null) {
            this.mFastScroll.setEnabled(enabled);
        } else if (enabled) {
            this.mFastScroll = new FastScroller(this, this.mFastScrollStyle);
            this.mFastScroll.setEnabled(true);
        }
        this.resolvePadding();
        if (this.mFastScroll != null) {
            this.mFastScroll.updateLayout();
        }
    }

    private final void $$robo$$android_widget_AbsListView$setFastScrollStyle(int styleResId) {
        if (this.mFastScroll == null) {
            this.mFastScrollStyle = styleResId;
        } else {
            this.mFastScroll.setStyle(styleResId);
        }
    }

    private final void $$robo$$android_widget_AbsListView$setFastScrollAlwaysVisible(boolean alwaysShow) {
        if (this.mFastScrollAlwaysVisible != alwaysShow) {
            if (alwaysShow && !this.mFastScrollEnabled) {
                this.setFastScrollEnabled(true);
            }
            this.mFastScrollAlwaysVisible = alwaysShow;
            if (this.isOwnerThread()) {
                this.setFastScrollerAlwaysVisibleUiThread(alwaysShow);
            } else {
                this.post(new Runnable(this, alwaysShow){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ boolean val$alwaysShow;
                    /* synthetic */ AbsListView this$0;

                    private void $$robo$$android_widget_AbsListView_2$__constructor__(AbsListView this$0, boolean bl) {
                    }

                    private final void $$robo$$android_widget_AbsListView_2$run() {
                        this.this$0.setFastScrollerAlwaysVisibleUiThread(this.val$alwaysShow);
                    }

                    private void __constructor__(AbsListView absListView, boolean bl) {
                        this.$$robo$$android_widget_AbsListView_2$__constructor__(absListView, bl);
                    }
                    {
                        this.this$0 = absListView;
                        this.val$alwaysShow = bl;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_2$__constructor__(android.widget.AbsListView boolean ), 0, this, absListView, bl);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_AbsListView_2$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }
    }

    private final void $$robo$$android_widget_AbsListView$setFastScrollerAlwaysVisibleUiThread(boolean alwaysShow) {
        if (this.mFastScroll != null) {
            this.mFastScroll.setAlwaysShow(alwaysShow);
        }
    }

    private final boolean $$robo$$android_widget_AbsListView$isOwnerThread() {
        return this.mOwnerThread == Thread.currentThread();
    }

    private final boolean $$robo$$android_widget_AbsListView$isFastScrollAlwaysVisible() {
        if (this.mFastScroll == null) {
            return this.mFastScrollEnabled && this.mFastScrollAlwaysVisible;
        }
        return this.mFastScroll.isEnabled() && this.mFastScroll.isAlwaysShowEnabled();
    }

    private final int $$robo$$android_widget_AbsListView$getVerticalScrollbarWidth() {
        if (this.mFastScroll != null && this.mFastScroll.isEnabled()) {
            return Math.max(super.getVerticalScrollbarWidth(), this.mFastScroll.getWidth());
        }
        return super.getVerticalScrollbarWidth();
    }

    @ViewDebug.ExportedProperty
    private final boolean $$robo$$android_widget_AbsListView$isFastScrollEnabled() {
        if (this.mFastScroll == null) {
            return this.mFastScrollEnabled;
        }
        return this.mFastScroll.isEnabled();
    }

    private final void $$robo$$android_widget_AbsListView$setVerticalScrollbarPosition(int position) {
        super.setVerticalScrollbarPosition(position);
        if (this.mFastScroll != null) {
            this.mFastScroll.setScrollbarPosition(position);
        }
    }

    private final void $$robo$$android_widget_AbsListView$setScrollBarStyle(int style2) {
        super.setScrollBarStyle(style2);
        if (this.mFastScroll != null) {
            this.mFastScroll.setScrollBarStyle(style2);
        }
    }

    private final boolean $$robo$$android_widget_AbsListView$isVerticalScrollBarHidden() {
        return this.isFastScrollEnabled();
    }

    private final void $$robo$$android_widget_AbsListView$setSmoothScrollbarEnabled(boolean enabled) {
        this.mSmoothScrollbarEnabled = enabled;
    }

    @ViewDebug.ExportedProperty
    private final boolean $$robo$$android_widget_AbsListView$isSmoothScrollbarEnabled() {
        return this.mSmoothScrollbarEnabled;
    }

    private final void $$robo$$android_widget_AbsListView$setOnScrollListener(OnScrollListener l) {
        this.mOnScrollListener = l;
        this.invokeOnItemScrollListener();
    }

    private final void $$robo$$android_widget_AbsListView$invokeOnItemScrollListener() {
        if (this.mFastScroll != null) {
            this.mFastScroll.onScroll(this.mFirstPosition, this.getChildCount(), this.mItemCount);
        }
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScroll(this, this.mFirstPosition, this.getChildCount(), this.mItemCount);
        }
        this.onScrollChanged(0, 0, 0, 0);
    }

    private final void $$robo$$android_widget_AbsListView$sendAccessibilityEventUnchecked(AccessibilityEvent event) {
        if (event.getEventType() == 4096) {
            int firstVisiblePosition = this.getFirstVisiblePosition();
            int lastVisiblePosition = this.getLastVisiblePosition();
            if (this.mLastAccessibilityScrollEventFromIndex == firstVisiblePosition && this.mLastAccessibilityScrollEventToIndex == lastVisiblePosition) {
                return;
            }
            this.mLastAccessibilityScrollEventFromIndex = firstVisiblePosition;
            this.mLastAccessibilityScrollEventToIndex = lastVisiblePosition;
        }
        super.sendAccessibilityEventUnchecked(event);
    }

    private final CharSequence $$robo$$android_widget_AbsListView$getAccessibilityClassName() {
        return AbsListView.class.getName();
    }

    private final void $$robo$$android_widget_AbsListView$onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        if (this.isEnabled()) {
            if (this.canScrollUp()) {
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_UP);
                info.setScrollable(true);
            }
            if (this.canScrollDown()) {
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_DOWN);
                info.setScrollable(true);
            }
        }
        info.removeAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_CLICK);
        info.setClickable(false);
    }

    private final int $$robo$$android_widget_AbsListView$getSelectionModeForAccessibility() {
        int choiceMode = this.getChoiceMode();
        switch (choiceMode) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
        }
        return 0;
    }

    private final boolean $$robo$$android_widget_AbsListView$performAccessibilityActionInternal(int action, Bundle arguments) {
        if (super.performAccessibilityActionInternal(action, arguments)) {
            return true;
        }
        switch (action) {
            case 4096: 
            case 16908346: {
                if (this.isEnabled() && this.canScrollDown()) {
                    int viewportHeight = this.getHeight() - this.mListPadding.top - this.mListPadding.bottom;
                    this.smoothScrollBy(viewportHeight, 200);
                    return true;
                }
                return false;
            }
            case 8192: 
            case 16908344: {
                if (this.isEnabled() && this.canScrollUp()) {
                    int viewportHeight = this.getHeight() - this.mListPadding.top - this.mListPadding.bottom;
                    this.smoothScrollBy(-viewportHeight, 200);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private final View $$robo$$android_widget_AbsListView$findViewByAccessibilityIdTraversal(int accessibilityId) {
        if (accessibilityId == this.getAccessibilityViewId()) {
            return this;
        }
        return super.findViewByAccessibilityIdTraversal(accessibilityId);
    }

    @ViewDebug.ExportedProperty
    private final boolean $$robo$$android_widget_AbsListView$isScrollingCacheEnabled() {
        return this.mScrollingCacheEnabled;
    }

    private final void $$robo$$android_widget_AbsListView$setScrollingCacheEnabled(boolean enabled) {
        if (this.mScrollingCacheEnabled && !enabled) {
            this.clearScrollingCache();
        }
        this.mScrollingCacheEnabled = enabled;
    }

    private final void $$robo$$android_widget_AbsListView$setTextFilterEnabled(boolean textFilterEnabled) {
        this.mTextFilterEnabled = textFilterEnabled;
    }

    @ViewDebug.ExportedProperty
    private final boolean $$robo$$android_widget_AbsListView$isTextFilterEnabled() {
        return this.mTextFilterEnabled;
    }

    private final void $$robo$$android_widget_AbsListView$getFocusedRect(Rect r) {
        View view = this.getSelectedView();
        if (view != null && view.getParent() == this) {
            view.getFocusedRect(r);
            this.offsetDescendantRectToMyCoords(view, r);
        } else {
            super.getFocusedRect(r);
        }
    }

    private final void $$robo$$android_widget_AbsListView$useDefaultSelector() {
        this.setSelector(this.getContext().getDrawable(17301602));
    }

    @ViewDebug.ExportedProperty
    private final boolean $$robo$$android_widget_AbsListView$isStackFromBottom() {
        return this.mStackFromBottom;
    }

    private final void $$robo$$android_widget_AbsListView$setStackFromBottom(boolean stackFromBottom) {
        if (this.mStackFromBottom != stackFromBottom) {
            this.mStackFromBottom = stackFromBottom;
            this.requestLayoutIfNecessary();
        }
    }

    private final void $$robo$$android_widget_AbsListView$requestLayoutIfNecessary() {
        if (this.getChildCount() > 0) {
            this.resetList();
            this.requestLayout();
            this.invalidate();
        }
    }

    private final Parcelable $$robo$$android_widget_AbsListView$onSaveInstanceState() {
        CharSequence filterText;
        EditText textFilter;
        long selectedId;
        this.dismissPopup();
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        if (this.mPendingSync != null) {
            ss.selectedId = this.mPendingSync.selectedId;
            ss.firstId = this.mPendingSync.firstId;
            ss.viewTop = this.mPendingSync.viewTop;
            ss.position = this.mPendingSync.position;
            ss.height = this.mPendingSync.height;
            ss.filter = this.mPendingSync.filter;
            ss.inActionMode = this.mPendingSync.inActionMode;
            ss.checkedItemCount = this.mPendingSync.checkedItemCount;
            ss.checkState = this.mPendingSync.checkState;
            ss.checkIdState = this.mPendingSync.checkIdState;
            return ss;
        }
        boolean haveChildren = this.getChildCount() > 0 && this.mItemCount > 0;
        ss.selectedId = selectedId = this.getSelectedItemId();
        ss.height = this.getHeight();
        if (selectedId >= 0L) {
            ss.viewTop = this.mSelectedTop;
            ss.position = this.getSelectedItemPosition();
            ss.firstId = -1L;
        } else if (haveChildren && this.mFirstPosition > 0) {
            View v = this.getChildAt(0);
            ss.viewTop = v.getTop();
            int firstPos = this.mFirstPosition;
            if (firstPos >= this.mItemCount) {
                firstPos = this.mItemCount - 1;
            }
            ss.position = firstPos;
            ss.firstId = this.mAdapter.getItemId(firstPos);
        } else {
            ss.viewTop = 0;
            ss.firstId = -1L;
            ss.position = 0;
        }
        ss.filter = null;
        if (this.mFiltered && (textFilter = this.mTextFilter) != null && (filterText = textFilter.getText()) != null) {
            ss.filter = ((Object)filterText).toString();
        }
        boolean bl = ss.inActionMode = this.mChoiceMode == 3 && this.mChoiceActionMode != null;
        if (this.mCheckStates != null) {
            ss.checkState = this.mCheckStates.clone();
        }
        if (this.mCheckedIdStates != null) {
            LongSparseArray<Integer> idState = new LongSparseArray<Integer>();
            int count = this.mCheckedIdStates.size();
            for (int i = 0; i < count; ++i) {
                idState.put(this.mCheckedIdStates.keyAt(i), this.mCheckedIdStates.valueAt(i));
            }
            ss.checkIdState = idState;
        }
        ss.checkedItemCount = this.mCheckedItemCount;
        if (this.mRemoteAdapter != null) {
            this.mRemoteAdapter.saveRemoteViewsCache();
        }
        return ss;
    }

    private final void $$robo$$android_widget_AbsListView$onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mDataChanged = true;
        this.mSyncHeight = ss.height;
        if (ss.selectedId >= 0L) {
            this.mNeedSync = true;
            this.mPendingSync = ss;
            this.mSyncRowId = ss.selectedId;
            this.mSyncPosition = ss.position;
            this.mSpecificTop = ss.viewTop;
            this.mSyncMode = 0;
        } else if (ss.firstId >= 0L) {
            this.setSelectedPositionInt(-1);
            this.setNextSelectedPositionInt(-1);
            this.mSelectorPosition = -1;
            this.mNeedSync = true;
            this.mPendingSync = ss;
            this.mSyncRowId = ss.firstId;
            this.mSyncPosition = ss.position;
            this.mSpecificTop = ss.viewTop;
            this.mSyncMode = 1;
        }
        this.setFilterText(ss.filter);
        if (ss.checkState != null) {
            this.mCheckStates = ss.checkState;
        }
        if (ss.checkIdState != null) {
            this.mCheckedIdStates = ss.checkIdState;
        }
        this.mCheckedItemCount = ss.checkedItemCount;
        if (ss.inActionMode && this.mChoiceMode == 3 && this.mMultiChoiceModeCallback != null) {
            this.mChoiceActionMode = this.startActionMode(this.mMultiChoiceModeCallback);
        }
        this.requestLayout();
    }

    private final boolean $$robo$$android_widget_AbsListView$acceptFilter() {
        return this.mTextFilterEnabled && this.getAdapter() instanceof Filterable && ((Filterable)this.getAdapter()).getFilter() != null;
    }

    private final void $$robo$$android_widget_AbsListView$setFilterText(String filterText) {
        if (this.mTextFilterEnabled && !TextUtils.isEmpty(filterText)) {
            this.createTextFilter(false);
            this.mTextFilter.setText(filterText);
            this.mTextFilter.setSelection(filterText.length());
            if (this.mAdapter instanceof Filterable) {
                if (this.mPopup == null) {
                    Filter f = ((Filterable)((Object)this.mAdapter)).getFilter();
                    f.filter(filterText);
                }
                this.mFiltered = true;
                this.mDataSetObserver.clearSavedState();
            }
        }
    }

    private final CharSequence $$robo$$android_widget_AbsListView$getTextFilter() {
        if (this.mTextFilterEnabled && this.mTextFilter != null) {
            return this.mTextFilter.getText();
        }
        return null;
    }

    private final void $$robo$$android_widget_AbsListView$onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        if (gainFocus && this.mSelectedPosition < 0 && !this.isInTouchMode()) {
            if (!this.isAttachedToWindow() && this.mAdapter != null) {
                this.mDataChanged = true;
                this.mOldItemCount = this.mItemCount;
                this.mItemCount = this.mAdapter.getCount();
            }
            this.resurrectSelection();
        }
    }

    private final void $$robo$$android_widget_AbsListView$requestLayout() {
        if (!this.mBlockLayoutRequests && !this.mInLayout) {
            super.requestLayout();
        }
    }

    private final void $$robo$$android_widget_AbsListView$resetList() {
        this.removeAllViewsInLayout();
        this.mFirstPosition = 0;
        this.mDataChanged = false;
        this.mPositionScrollAfterLayout = null;
        this.mNeedSync = false;
        this.mPendingSync = null;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        this.setSelectedPositionInt(-1);
        this.setNextSelectedPositionInt(-1);
        this.mSelectedTop = 0;
        this.mSelectorPosition = -1;
        this.mSelectorRect.setEmpty();
        this.invalidate();
    }

    private final int $$robo$$android_widget_AbsListView$computeVerticalScrollExtent() {
        int count = this.getChildCount();
        if (count > 0) {
            if (this.mSmoothScrollbarEnabled) {
                int extent = count * 100;
                View view = this.getChildAt(0);
                int top = view.getTop();
                int height = view.getHeight();
                if (height > 0) {
                    extent += top * 100 / height;
                }
                view = this.getChildAt(count - 1);
                int bottom = view.getBottom();
                height = view.getHeight();
                if (height > 0) {
                    extent -= (bottom - this.getHeight()) * 100 / height;
                }
                return extent;
            }
            return 1;
        }
        return 0;
    }

    private final int $$robo$$android_widget_AbsListView$computeVerticalScrollOffset() {
        int firstPosition = this.mFirstPosition;
        int childCount = this.getChildCount();
        if (firstPosition >= 0 && childCount > 0) {
            if (this.mSmoothScrollbarEnabled) {
                View view = this.getChildAt(0);
                int top = view.getTop();
                int height = view.getHeight();
                if (height > 0) {
                    return Math.max(firstPosition * 100 - top * 100 / height + (int)((float)this.mScrollY / (float)this.getHeight() * (float)this.mItemCount * 100.0f), 0);
                }
            } else {
                int count = this.mItemCount;
                int index = firstPosition == 0 ? 0 : (firstPosition + childCount == count ? count : firstPosition + childCount / 2);
                return (int)((float)firstPosition + (float)childCount * ((float)index / (float)count));
            }
        }
        return 0;
    }

    private final int $$robo$$android_widget_AbsListView$computeVerticalScrollRange() {
        int result;
        if (this.mSmoothScrollbarEnabled) {
            result = Math.max(this.mItemCount * 100, 0);
            if (this.mScrollY != 0) {
                result += Math.abs((int)((float)this.mScrollY / (float)this.getHeight() * (float)this.mItemCount * 100.0f));
            }
        } else {
            result = this.mItemCount;
        }
        return result;
    }

    private final float $$robo$$android_widget_AbsListView$getTopFadingEdgeStrength() {
        int count = this.getChildCount();
        float fadeEdge = super.getTopFadingEdgeStrength();
        if (count == 0) {
            return fadeEdge;
        }
        if (this.mFirstPosition > 0) {
            return 1.0f;
        }
        int top = this.getChildAt(0).getTop();
        float fadeLength = this.getVerticalFadingEdgeLength();
        return top < this.mPaddingTop ? (float)(-(top - this.mPaddingTop)) / fadeLength : fadeEdge;
    }

    private final float $$robo$$android_widget_AbsListView$getBottomFadingEdgeStrength() {
        int count = this.getChildCount();
        float fadeEdge = super.getBottomFadingEdgeStrength();
        if (count == 0) {
            return fadeEdge;
        }
        if (this.mFirstPosition + count - 1 < this.mItemCount - 1) {
            return 1.0f;
        }
        int bottom = this.getChildAt(count - 1).getBottom();
        int height = this.getHeight();
        float fadeLength = this.getVerticalFadingEdgeLength();
        return bottom > height - this.mPaddingBottom ? (float)(bottom - height + this.mPaddingBottom) / fadeLength : fadeEdge;
    }

    private final void $$robo$$android_widget_AbsListView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mSelector == null) {
            this.useDefaultSelector();
        }
        Rect listPadding = this.mListPadding;
        listPadding.left = this.mSelectionLeftPadding + this.mPaddingLeft;
        listPadding.top = this.mSelectionTopPadding + this.mPaddingTop;
        listPadding.right = this.mSelectionRightPadding + this.mPaddingRight;
        listPadding.bottom = this.mSelectionBottomPadding + this.mPaddingBottom;
        if (this.mTranscriptMode == 1) {
            int childCount = this.getChildCount();
            int listBottom = this.getHeight() - this.getPaddingBottom();
            View lastChild = this.getChildAt(childCount - 1);
            int lastBottom = lastChild != null ? lastChild.getBottom() : listBottom;
            this.mForceTranscriptScroll = this.mFirstPosition + childCount >= this.mLastHandledItemCount && lastBottom <= listBottom;
        }
    }

    private final void $$robo$$android_widget_AbsListView$onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mInLayout = true;
        int childCount = this.getChildCount();
        if (changed) {
            for (int i = 0; i < childCount; ++i) {
                this.getChildAt(i).forceLayout();
            }
            this.mRecycler.markChildrenDirty();
        }
        this.layoutChildren();
        this.mOverscrollMax = (b - t) / 3;
        if (this.mFastScroll != null) {
            this.mFastScroll.onItemCountChanged(this.getChildCount(), this.mItemCount);
        }
        this.mInLayout = false;
    }

    private final boolean $$robo$$android_widget_AbsListView$setFrame(int left, int top, int right, int bottom) {
        boolean changed = super.setFrame(left, top, right, bottom);
        if (changed) {
            boolean visible;
            boolean bl = visible = this.getWindowVisibility() == 0;
            if (this.mFiltered && visible && this.mPopup != null && this.mPopup.isShowing()) {
                this.positionPopup();
            }
        }
        return changed;
    }

    private final void $$robo$$android_widget_AbsListView$layoutChildren() {
    }

    private final View $$robo$$android_widget_AbsListView$getAccessibilityFocusedChild(View focusedView) {
        ViewParent viewParent;
        for (viewParent = focusedView.getParent(); viewParent instanceof View && viewParent != this; viewParent = viewParent.getParent()) {
            focusedView = (View)((Object)viewParent);
        }
        if (!(viewParent instanceof View)) {
            return null;
        }
        return focusedView;
    }

    private final void $$robo$$android_widget_AbsListView$updateScrollIndicators() {
        if (this.mScrollUp != null) {
            this.mScrollUp.setVisibility(this.canScrollUp() ? 0 : 4);
        }
        if (this.mScrollDown != null) {
            this.mScrollDown.setVisibility(this.canScrollDown() ? 0 : 4);
        }
    }

    private final boolean $$robo$$android_widget_AbsListView$canScrollUp() {
        boolean canScrollUp;
        boolean bl = canScrollUp = this.mFirstPosition > 0;
        if (!canScrollUp && this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            canScrollUp = child.getTop() < this.mListPadding.top;
        }
        return canScrollUp;
    }

    private final boolean $$robo$$android_widget_AbsListView$canScrollDown() {
        boolean canScrollDown;
        int count = this.getChildCount();
        boolean bl = canScrollDown = this.mFirstPosition + count < this.mItemCount;
        if (!canScrollDown && count > 0) {
            View child = this.getChildAt(count - 1);
            canScrollDown = child.getBottom() > this.mBottom - this.mListPadding.bottom;
        }
        return canScrollDown;
    }

    @ViewDebug.ExportedProperty
    private final View $$robo$$android_widget_AbsListView$getSelectedView() {
        if (this.mItemCount > 0 && this.mSelectedPosition >= 0) {
            return this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
        }
        return null;
    }

    private final int $$robo$$android_widget_AbsListView$getListPaddingTop() {
        return this.mListPadding.top;
    }

    private final int $$robo$$android_widget_AbsListView$getListPaddingBottom() {
        return this.mListPadding.bottom;
    }

    private final int $$robo$$android_widget_AbsListView$getListPaddingLeft() {
        return this.mListPadding.left;
    }

    private final int $$robo$$android_widget_AbsListView$getListPaddingRight() {
        return this.mListPadding.right;
    }

    private final View $$robo$$android_widget_AbsListView$obtainView(int position, boolean[] outMetadata) {
        Trace.traceBegin(8L, "obtainView");
        outMetadata[0] = false;
        View transientView = this.mRecycler.getTransientStateView(position);
        if (transientView != null) {
            View updatedView;
            LayoutParams params = (LayoutParams)transientView.getLayoutParams();
            if (params.viewType == this.mAdapter.getItemViewType(position) && (updatedView = this.mAdapter.getView(position, transientView, this)) != transientView) {
                this.setItemViewLayoutParams(updatedView, position);
                this.mRecycler.addScrapView(updatedView, position);
            }
            outMetadata[0] = true;
            transientView.dispatchFinishTemporaryDetach();
            return transientView;
        }
        View scrapView = this.mRecycler.getScrapView(position);
        View child = this.mAdapter.getView(position, scrapView, this);
        if (scrapView != null) {
            if (child != scrapView) {
                this.mRecycler.addScrapView(scrapView, position);
            } else if (child.isTemporarilyDetached()) {
                outMetadata[0] = true;
                child.dispatchFinishTemporaryDetach();
            }
        }
        if (this.mCacheColorHint != 0) {
            child.setDrawingCacheBackgroundColor(this.mCacheColorHint);
        }
        if (child.getImportantForAccessibility() == 0) {
            child.setImportantForAccessibility(1);
        }
        this.setItemViewLayoutParams(child, position);
        if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            if (this.mAccessibilityDelegate == null) {
                this.mAccessibilityDelegate = new ListItemAccessibilityDelegate(this);
            }
            if (child.getAccessibilityDelegate() == null) {
                child.setAccessibilityDelegate(this.mAccessibilityDelegate);
            }
        }
        Trace.traceEnd(8L);
        return child;
    }

    private final void $$robo$$android_widget_AbsListView$setItemViewLayoutParams(View child, int position) {
        ViewGroup.LayoutParams vlp = child.getLayoutParams();
        LayoutParams lp = vlp == null ? (LayoutParams)this.generateDefaultLayoutParams() : (!this.checkLayoutParams(vlp) ? (LayoutParams)this.generateLayoutParams(vlp) : (LayoutParams)vlp);
        if (this.mAdapterHasStableIds) {
            lp.itemId = this.mAdapter.getItemId(position);
        }
        lp.viewType = this.mAdapter.getItemViewType(position);
        lp.isEnabled = this.mAdapter.isEnabled(position);
        if (lp != vlp) {
            child.setLayoutParams(lp);
        }
    }

    private final void $$robo$$android_widget_AbsListView$onInitializeAccessibilityNodeInfoForItem(View view, int position, AccessibilityNodeInfo info) {
        if (position == -1) {
            return;
        }
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        boolean isItemEnabled = lp instanceof LayoutParams ? ((LayoutParams)lp).isEnabled : false;
        if (!this.isEnabled() || !isItemEnabled) {
            info.setEnabled(false);
            return;
        }
        if (position == this.getSelectedItemPosition()) {
            info.setSelected(true);
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_CLEAR_SELECTION);
        } else {
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SELECT);
        }
        if (this.isItemClickable(view)) {
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_CLICK);
            info.setClickable(true);
        }
        if (this.isLongClickable()) {
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_LONG_CLICK);
            info.setLongClickable(true);
        }
    }

    private final boolean $$robo$$android_widget_AbsListView$isItemClickable(View view) {
        return !view.hasExplicitFocusable();
    }

    private final void $$robo$$android_widget_AbsListView$positionSelectorLikeTouch(int position, View sel, float x, float y) {
        this.positionSelector(position, sel, true, x, y);
    }

    private final void $$robo$$android_widget_AbsListView$positionSelectorLikeFocus(int position, View sel) {
        if (this.mSelector != null && this.mSelectorPosition != position && position != -1) {
            Rect bounds = this.mSelectorRect;
            float x = bounds.exactCenterX();
            float y = bounds.exactCenterY();
            this.positionSelector(position, sel, true, x, y);
        } else {
            this.positionSelector(position, sel);
        }
    }

    private final void $$robo$$android_widget_AbsListView$positionSelector(int position, View sel) {
        this.positionSelector(position, sel, false, -1.0f, -1.0f);
    }

    private final void $$robo$$android_widget_AbsListView$positionSelector(int position, View sel, boolean manageHotspot, float x, float y) {
        Drawable selector;
        boolean positionChanged;
        boolean bl = positionChanged = position != this.mSelectorPosition;
        if (position != -1) {
            this.mSelectorPosition = position;
        }
        Rect selectorRect = this.mSelectorRect;
        selectorRect.set(sel.getLeft(), sel.getTop(), sel.getRight(), sel.getBottom());
        if (sel instanceof SelectionBoundsAdjuster) {
            ((SelectionBoundsAdjuster)((Object)sel)).adjustListItemSelectionBounds(selectorRect);
        }
        selectorRect.left -= this.mSelectionLeftPadding;
        selectorRect.top -= this.mSelectionTopPadding;
        selectorRect.right += this.mSelectionRightPadding;
        selectorRect.bottom += this.mSelectionBottomPadding;
        boolean isChildViewEnabled = sel.isEnabled();
        if (this.mIsChildViewEnabled != isChildViewEnabled) {
            this.mIsChildViewEnabled = isChildViewEnabled;
        }
        if ((selector = this.mSelector) != null) {
            if (positionChanged) {
                selector.setVisible(false, false);
                selector.setState(StateSet.NOTHING);
            }
            selector.setBounds(selectorRect);
            if (positionChanged) {
                if (this.getVisibility() == 0) {
                    selector.setVisible(true, false);
                }
                this.updateSelectorState();
            }
            if (manageHotspot) {
                selector.setHotspot(x, y);
            }
        }
    }

    private final void $$robo$$android_widget_AbsListView$dispatchDraw(Canvas canvas) {
        boolean drawSelectorOnTop;
        boolean clipToPadding;
        int saveCount = 0;
        boolean bl = clipToPadding = (this.mGroupFlags & 0x22) == 34;
        if (clipToPadding) {
            saveCount = canvas.save();
            int scrollX = this.mScrollX;
            int scrollY = this.mScrollY;
            canvas.clipRect(scrollX + this.mPaddingLeft, scrollY + this.mPaddingTop, scrollX + this.mRight - this.mLeft - this.mPaddingRight, scrollY + this.mBottom - this.mTop - this.mPaddingBottom);
            this.mGroupFlags &= 0xFFFFFFDD;
        }
        if (!(drawSelectorOnTop = this.mDrawSelectorOnTop)) {
            this.drawSelector(canvas);
        }
        super.dispatchDraw(canvas);
        if (drawSelectorOnTop) {
            this.drawSelector(canvas);
        }
        if (clipToPadding) {
            canvas.restoreToCount(saveCount);
            this.mGroupFlags |= 0x22;
        }
    }

    private final boolean $$robo$$android_widget_AbsListView$isPaddingOffsetRequired() {
        return (this.mGroupFlags & 0x22) != 34;
    }

    private final int $$robo$$android_widget_AbsListView$getLeftPaddingOffset() {
        return (this.mGroupFlags & 0x22) == 34 ? 0 : -this.mPaddingLeft;
    }

    private final int $$robo$$android_widget_AbsListView$getTopPaddingOffset() {
        return (this.mGroupFlags & 0x22) == 34 ? 0 : -this.mPaddingTop;
    }

    private final int $$robo$$android_widget_AbsListView$getRightPaddingOffset() {
        return (this.mGroupFlags & 0x22) == 34 ? 0 : this.mPaddingRight;
    }

    private final int $$robo$$android_widget_AbsListView$getBottomPaddingOffset() {
        return (this.mGroupFlags & 0x22) == 34 ? 0 : this.mPaddingBottom;
    }

    private final void $$robo$$android_widget_AbsListView$internalSetPadding(int left, int top, int right, int bottom) {
        super.internalSetPadding(left, top, right, bottom);
        if (this.isLayoutRequested()) {
            this.handleBoundsChange();
        }
    }

    private final void $$robo$$android_widget_AbsListView$onSizeChanged(int w, int h, int oldw, int oldh) {
        this.handleBoundsChange();
        if (this.mFastScroll != null) {
            this.mFastScroll.onSizeChanged(w, h, oldw, oldh);
        }
    }

    private final void $$robo$$android_widget_AbsListView$handleBoundsChange() {
        if (this.mInLayout) {
            return;
        }
        int childCount = this.getChildCount();
        if (childCount > 0) {
            this.mDataChanged = true;
            this.rememberSyncState();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                ViewGroup.LayoutParams lp = child.getLayoutParams();
                if (lp != null && lp.width >= 1 && lp.height >= 1) continue;
                child.forceLayout();
            }
        }
    }

    private final boolean $$robo$$android_widget_AbsListView$touchModeDrawsInPressedState() {
        switch (this.mTouchMode) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$android_widget_AbsListView$shouldShowSelector() {
        return this.isFocused() && !this.isInTouchMode() || this.touchModeDrawsInPressedState() && this.isPressed();
    }

    private final void $$robo$$android_widget_AbsListView$drawSelector(Canvas canvas) {
        if (this.shouldDrawSelector()) {
            Drawable selector = this.mSelector;
            selector.setBounds(this.mSelectorRect);
            selector.draw(canvas);
        }
    }

    private final boolean $$robo$$android_widget_AbsListView$shouldDrawSelector() {
        return !this.mSelectorRect.isEmpty();
    }

    private final void $$robo$$android_widget_AbsListView$setDrawSelectorOnTop(boolean onTop) {
        this.mDrawSelectorOnTop = onTop;
    }

    private final void $$robo$$android_widget_AbsListView$setSelector(int resID) {
        this.setSelector(this.getContext().getDrawable(resID));
    }

    private final void $$robo$$android_widget_AbsListView$setSelector(Drawable sel) {
        if (this.mSelector != null) {
            this.mSelector.setCallback(null);
            this.unscheduleDrawable(this.mSelector);
        }
        this.mSelector = sel;
        Rect padding = new Rect();
        sel.getPadding(padding);
        this.mSelectionLeftPadding = padding.left;
        this.mSelectionTopPadding = padding.top;
        this.mSelectionRightPadding = padding.right;
        this.mSelectionBottomPadding = padding.bottom;
        sel.setCallback(this);
        this.updateSelectorState();
    }

    private final Drawable $$robo$$android_widget_AbsListView$getSelector() {
        return this.mSelector;
    }

    private final void $$robo$$android_widget_AbsListView$keyPressed() {
        if (!this.isEnabled() || !this.isClickable()) {
            return;
        }
        Drawable selector = this.mSelector;
        Rect selectorRect = this.mSelectorRect;
        if (selector != null && (this.isFocused() || this.touchModeDrawsInPressedState()) && !selectorRect.isEmpty()) {
            View v = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
            if (v != null) {
                if (v.hasExplicitFocusable()) {
                    return;
                }
                v.setPressed(true);
            }
            this.setPressed(true);
            boolean longClickable = this.isLongClickable();
            Drawable d = selector.getCurrent();
            if (d != null && d instanceof TransitionDrawable) {
                if (longClickable) {
                    ((TransitionDrawable)d).startTransition(ViewConfiguration.getLongPressTimeout());
                } else {
                    ((TransitionDrawable)d).resetTransition();
                }
            }
            if (longClickable && !this.mDataChanged) {
                if (this.mPendingCheckForKeyLongPress == null) {
                    this.mPendingCheckForKeyLongPress = new CheckForKeyLongPress(this);
                }
                this.mPendingCheckForKeyLongPress.rememberWindowAttachCount();
                this.postDelayed(this.mPendingCheckForKeyLongPress, ViewConfiguration.getLongPressTimeout());
            }
        }
    }

    private final void $$robo$$android_widget_AbsListView$setScrollIndicators(View up, View down) {
        this.mScrollUp = up;
        this.mScrollDown = down;
    }

    private final void $$robo$$android_widget_AbsListView$updateSelectorState() {
        Drawable selector = this.mSelector;
        if (selector != null && selector.isStateful()) {
            if (this.shouldShowSelector()) {
                if (selector.setState(this.getDrawableStateForSelector())) {
                    this.invalidateDrawable(selector);
                }
            } else {
                selector.setState(StateSet.NOTHING);
            }
        }
    }

    private final void $$robo$$android_widget_AbsListView$drawableStateChanged() {
        super.drawableStateChanged();
        this.updateSelectorState();
    }

    private final int[] $$robo$$android_widget_AbsListView$getDrawableStateForSelector() {
        if (this.mIsChildViewEnabled) {
            return super.getDrawableState();
        }
        int enabledState = ENABLED_STATE_SET[0];
        int[] state = this.onCreateDrawableState(1);
        int enabledPos = -1;
        for (int i = state.length - 1; i >= 0; --i) {
            if (state[i] != enabledState) continue;
            enabledPos = i;
            break;
        }
        if (enabledPos >= 0) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)state, (int)(enabledPos + 1), (Object)state, (int)enabledPos, (int)(state.length - enabledPos - 1));
        }
        return state;
    }

    private final boolean $$robo$$android_widget_AbsListView$verifyDrawable(Drawable dr) {
        return this.mSelector == dr || super.verifyDrawable(dr);
    }

    private final void $$robo$$android_widget_AbsListView$jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mSelector != null) {
            this.mSelector.jumpToCurrentState();
        }
    }

    private final void $$robo$$android_widget_AbsListView$onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewTreeObserver treeObserver = this.getViewTreeObserver();
        treeObserver.addOnTouchModeChangeListener(this);
        if (this.mTextFilterEnabled && this.mPopup != null && !this.mGlobalLayoutListenerAddedFilter) {
            treeObserver.addOnGlobalLayoutListener(this);
        }
        if (this.mAdapter != null && this.mDataSetObserver == null) {
            this.mDataSetObserver = new AdapterDataSetObserver(this);
            this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
            this.mDataChanged = true;
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
        }
    }

    private final void $$robo$$android_widget_AbsListView$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mIsDetaching = true;
        this.dismissPopup();
        this.mRecycler.clear();
        ViewTreeObserver treeObserver = this.getViewTreeObserver();
        treeObserver.removeOnTouchModeChangeListener(this);
        if (this.mTextFilterEnabled && this.mPopup != null) {
            treeObserver.removeOnGlobalLayoutListener(this);
            this.mGlobalLayoutListenerAddedFilter = false;
        }
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
            this.mDataSetObserver = null;
        }
        if (this.mScrollStrictSpan != null) {
            this.mScrollStrictSpan.finish();
            this.mScrollStrictSpan = null;
        }
        if (this.mFlingStrictSpan != null) {
            this.mFlingStrictSpan.finish();
            this.mFlingStrictSpan = null;
        }
        if (this.mFlingRunnable != null) {
            this.removeCallbacks(this.mFlingRunnable);
        }
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        if (this.mClearScrollingCache != null) {
            this.removeCallbacks(this.mClearScrollingCache);
        }
        if (this.mPerformClick != null) {
            this.removeCallbacks(this.mPerformClick);
        }
        if (this.mTouchModeReset != null) {
            this.removeCallbacks(this.mTouchModeReset);
            this.mTouchModeReset.run();
        }
        this.mIsDetaching = false;
    }

    private final void $$robo$$android_widget_AbsListView$onWindowFocusChanged(boolean hasWindowFocus) {
        int touchMode;
        super.onWindowFocusChanged(hasWindowFocus);
        int n = touchMode = this.isInTouchMode() ? 0 : 1;
        if (!hasWindowFocus) {
            this.setChildrenDrawingCacheEnabled(false);
            if (this.mFlingRunnable != null) {
                this.removeCallbacks(this.mFlingRunnable);
                this.mFlingRunnable.mSuppressIdleStateChangeCall = false;
                this.mFlingRunnable.endFling();
                if (this.mPositionScroller != null) {
                    this.mPositionScroller.stop();
                }
                if (this.mScrollY != 0) {
                    this.mScrollY = 0;
                    this.invalidateParentCaches();
                    this.finishGlows();
                    this.invalidate();
                }
            }
            this.dismissPopup();
            if (touchMode == 1) {
                this.mResurrectToPosition = this.mSelectedPosition;
            }
        } else {
            if (this.mFiltered && !this.mPopupHidden) {
                this.showPopup();
            }
            if (touchMode != this.mLastTouchMode && this.mLastTouchMode != -1) {
                if (touchMode == 1) {
                    this.resurrectSelection();
                } else {
                    this.hideSelector();
                    this.mLayoutMode = 0;
                    this.layoutChildren();
                }
            }
        }
        this.mLastTouchMode = touchMode;
    }

    private final void $$robo$$android_widget_AbsListView$onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        if (this.mFastScroll != null) {
            this.mFastScroll.setScrollbarPosition(this.getVerticalScrollbarPosition());
        }
    }

    private final ContextMenu.ContextMenuInfo $$robo$$android_widget_AbsListView$createContextMenuInfo(View view, int position, long id2) {
        return new AdapterView.AdapterContextMenuInfo(view, position, id2);
    }

    private final void $$robo$$android_widget_AbsListView$onCancelPendingInputEvents() {
        super.onCancelPendingInputEvents();
        if (this.mPerformClick != null) {
            this.removeCallbacks(this.mPerformClick);
        }
        if (this.mPendingCheckForTap != null) {
            this.removeCallbacks(this.mPendingCheckForTap);
        }
        if (this.mPendingCheckForLongPress != null) {
            this.removeCallbacks(this.mPendingCheckForLongPress);
        }
        if (this.mPendingCheckForKeyLongPress != null) {
            this.removeCallbacks(this.mPendingCheckForKeyLongPress);
        }
    }

    private final boolean $$robo$$android_widget_AbsListView$performStylusButtonPressAction(MotionEvent ev) {
        long longPressId;
        int longPressPosition;
        View child;
        if (this.mChoiceMode == 3 && this.mChoiceActionMode == null && (child = this.getChildAt(this.mMotionPosition - this.mFirstPosition)) != null && this.performLongPress(child, longPressPosition = this.mMotionPosition, longPressId = this.mAdapter.getItemId(this.mMotionPosition))) {
            this.mTouchMode = -1;
            this.setPressed(false);
            child.setPressed(false);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_widget_AbsListView$performLongPress(View child, int longPressPosition, long longPressId) {
        return this.performLongPress(child, longPressPosition, longPressId, -1.0f, -1.0f);
    }

    private final boolean $$robo$$android_widget_AbsListView$performLongPress(View child, int longPressPosition, long longPressId, float x, float y) {
        if (this.mChoiceMode == 3) {
            if (this.mChoiceActionMode == null && (this.mChoiceActionMode = this.startActionMode(this.mMultiChoiceModeCallback)) != null) {
                this.setItemChecked(longPressPosition, true);
                this.performHapticFeedback(0);
            }
            return true;
        }
        boolean handled = false;
        if (this.mOnItemLongClickListener != null) {
            handled = this.mOnItemLongClickListener.onItemLongClick(this, child, longPressPosition, longPressId);
        }
        if (!handled) {
            this.mContextMenuInfo = this.createContextMenuInfo(child, longPressPosition, longPressId);
            handled = x != -1.0f && y != -1.0f ? super.showContextMenuForChild(this, x, y) : super.showContextMenuForChild(this);
        }
        if (handled) {
            this.performHapticFeedback(0);
        }
        return handled;
    }

    private final ContextMenu.ContextMenuInfo $$robo$$android_widget_AbsListView$getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    private final boolean $$robo$$android_widget_AbsListView$showContextMenu() {
        return this.showContextMenuInternal(0.0f, 0.0f, false);
    }

    private final boolean $$robo$$android_widget_AbsListView$showContextMenu(float x, float y) {
        return this.showContextMenuInternal(x, y, true);
    }

    private final boolean $$robo$$android_widget_AbsListView$showContextMenuInternal(float x, float y, boolean useOffsets) {
        int position = this.pointToPosition((int)x, (int)y);
        if (position != -1) {
            long id2 = this.mAdapter.getItemId(position);
            View child = this.getChildAt(position - this.mFirstPosition);
            if (child != null) {
                this.mContextMenuInfo = this.createContextMenuInfo(child, position, id2);
                if (useOffsets) {
                    return super.showContextMenuForChild(this, x, y);
                }
                return super.showContextMenuForChild(this);
            }
        }
        if (useOffsets) {
            return super.showContextMenu(x, y);
        }
        return super.showContextMenu();
    }

    private final boolean $$robo$$android_widget_AbsListView$showContextMenuForChild(View originalView) {
        if (this.isShowingContextMenuWithCoords()) {
            return false;
        }
        return this.showContextMenuForChildInternal(originalView, 0.0f, 0.0f, false);
    }

    private final boolean $$robo$$android_widget_AbsListView$showContextMenuForChild(View originalView, float x, float y) {
        return this.showContextMenuForChildInternal(originalView, x, y, true);
    }

    private final boolean $$robo$$android_widget_AbsListView$showContextMenuForChildInternal(View originalView, float x, float y, boolean useOffsets) {
        int longPressPosition = this.getPositionForView(originalView);
        if (longPressPosition < 0) {
            return false;
        }
        long longPressId = this.mAdapter.getItemId(longPressPosition);
        boolean handled = false;
        if (this.mOnItemLongClickListener != null) {
            handled = this.mOnItemLongClickListener.onItemLongClick(this, originalView, longPressPosition, longPressId);
        }
        if (!handled) {
            View child = this.getChildAt(longPressPosition - this.mFirstPosition);
            this.mContextMenuInfo = this.createContextMenuInfo(child, longPressPosition, longPressId);
            handled = useOffsets ? super.showContextMenuForChild(originalView, x, y) : super.showContextMenuForChild(originalView);
        }
        return handled;
    }

    private final boolean $$robo$$android_widget_AbsListView$onKeyDown(int keyCode, KeyEvent event) {
        return false;
    }

    private final boolean $$robo$$android_widget_AbsListView$onKeyUp(int keyCode, KeyEvent event) {
        if (KeyEvent.isConfirmKey(keyCode)) {
            if (!this.isEnabled()) {
                return true;
            }
            if (this.isClickable() && this.isPressed() && this.mSelectedPosition >= 0 && this.mAdapter != null && this.mSelectedPosition < this.mAdapter.getCount()) {
                View view = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
                if (view != null) {
                    this.performItemClick(view, this.mSelectedPosition, this.mSelectedRowId);
                    view.setPressed(false);
                }
                this.setPressed(false);
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    private final void $$robo$$android_widget_AbsListView$dispatchSetPressed(boolean pressed) {
    }

    private final void $$robo$$android_widget_AbsListView$dispatchDrawableHotspotChanged(float x, float y) {
    }

    private final int $$robo$$android_widget_AbsListView$pointToPosition(int x, int y) {
        Rect frame = this.mTouchFrame;
        if (frame == null) {
            frame = this.mTouchFrame = new Rect();
        }
        int count = this.getChildCount();
        for (int i = count - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0) continue;
            child.getHitRect(frame);
            if (!frame.contains(x, y)) continue;
            return this.mFirstPosition + i;
        }
        return -1;
    }

    private final long $$robo$$android_widget_AbsListView$pointToRowId(int x, int y) {
        int position = this.pointToPosition(x, y);
        if (position >= 0) {
            return this.mAdapter.getItemId(position);
        }
        return Long.MIN_VALUE;
    }

    private final boolean $$robo$$android_widget_AbsListView$startScrollIfNeeded(int x, int y, MotionEvent vtev) {
        boolean overscroll;
        int deltaY = y - this.mMotionY;
        int distance = Math.abs(deltaY);
        boolean bl = overscroll = this.mScrollY != 0;
        if ((overscroll || distance > this.mTouchSlop) && (this.getNestedScrollAxes() & 2) == 0) {
            this.createScrollingCache();
            if (overscroll) {
                this.mTouchMode = 5;
                this.mMotionCorrection = 0;
            } else {
                this.mTouchMode = 3;
                this.mMotionCorrection = deltaY > 0 ? this.mTouchSlop : -this.mTouchSlop;
            }
            this.removeCallbacks(this.mPendingCheckForLongPress);
            this.setPressed(false);
            View motionView = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
            if (motionView != null) {
                motionView.setPressed(false);
            }
            this.reportScrollStateChange(1);
            ViewParent parent = this.getParent();
            if (parent != null) {
                parent.requestDisallowInterceptTouchEvent(true);
            }
            this.scrollIfNeeded(x, y, vtev);
            return true;
        }
        return false;
    }

    private final void $$robo$$android_widget_AbsListView$scrollIfNeeded(int x, int y, MotionEvent vtev) {
        int rawDeltaY = y - this.mMotionY;
        int scrollOffsetCorrection = 0;
        int scrollConsumedCorrection = 0;
        if (this.mLastY == Integer.MIN_VALUE) {
            rawDeltaY -= this.mMotionCorrection;
        }
        if (this.dispatchNestedPreScroll(0, this.mLastY != Integer.MIN_VALUE ? this.mLastY - y : -rawDeltaY, this.mScrollConsumed, this.mScrollOffset)) {
            rawDeltaY += this.mScrollConsumed[1];
            scrollOffsetCorrection = -this.mScrollOffset[1];
            scrollConsumedCorrection = this.mScrollConsumed[1];
            if (vtev != null) {
                vtev.offsetLocation(0.0f, this.mScrollOffset[1]);
                this.mNestedYOffset += this.mScrollOffset[1];
            }
        }
        int deltaY = rawDeltaY;
        int incrementalDeltaY = this.mLastY != Integer.MIN_VALUE ? y - this.mLastY + scrollConsumedCorrection : deltaY;
        int lastYCorrection = 0;
        if (this.mTouchMode == 3) {
            if (this.mScrollStrictSpan == null) {
                this.mScrollStrictSpan = StrictMode.enterCriticalSpan("AbsListView-scroll");
            }
            if (y != this.mLastY) {
                ViewParent parent;
                if ((this.mGroupFlags & 0x80000) == 0 && Math.abs(rawDeltaY) > this.mTouchSlop && (parent = this.getParent()) != null) {
                    parent.requestDisallowInterceptTouchEvent(true);
                }
                int motionIndex = this.mMotionPosition >= 0 ? this.mMotionPosition - this.mFirstPosition : this.getChildCount() / 2;
                int motionViewPrevTop = 0;
                View motionView = this.getChildAt(motionIndex);
                if (motionView != null) {
                    motionViewPrevTop = motionView.getTop();
                }
                boolean atEdge = false;
                if (incrementalDeltaY != 0) {
                    atEdge = this.trackMotionScroll(deltaY, incrementalDeltaY);
                }
                if ((motionView = this.getChildAt(motionIndex)) != null) {
                    int motionViewRealTop = motionView.getTop();
                    if (atEdge) {
                        int overscroll = -incrementalDeltaY - (motionViewRealTop - motionViewPrevTop);
                        if (this.dispatchNestedScroll(0, overscroll - incrementalDeltaY, 0, overscroll, this.mScrollOffset)) {
                            lastYCorrection -= this.mScrollOffset[1];
                            if (vtev != null) {
                                vtev.offsetLocation(0.0f, this.mScrollOffset[1]);
                                this.mNestedYOffset += this.mScrollOffset[1];
                            }
                        } else {
                            int overscrollMode;
                            boolean atOverscrollEdge = this.overScrollBy(0, overscroll, 0, this.mScrollY, 0, 0, 0, this.mOverscrollDistance, true);
                            if (atOverscrollEdge && this.mVelocityTracker != null) {
                                this.mVelocityTracker.clear();
                            }
                            if ((overscrollMode = this.getOverScrollMode()) == 0 || overscrollMode == 1 && !this.contentFits()) {
                                if (!atOverscrollEdge) {
                                    this.mDirection = 0;
                                    this.mTouchMode = 5;
                                }
                                if (incrementalDeltaY > 0) {
                                    this.mEdgeGlowTop.onPull((float)(-overscroll) / (float)this.getHeight(), (float)x / (float)this.getWidth());
                                    if (!this.mEdgeGlowBottom.isFinished()) {
                                        this.mEdgeGlowBottom.onRelease();
                                    }
                                    this.invalidateTopGlow();
                                } else if (incrementalDeltaY < 0) {
                                    this.mEdgeGlowBottom.onPull((float)overscroll / (float)this.getHeight(), 1.0f - (float)x / (float)this.getWidth());
                                    if (!this.mEdgeGlowTop.isFinished()) {
                                        this.mEdgeGlowTop.onRelease();
                                    }
                                    this.invalidateBottomGlow();
                                }
                            }
                        }
                    }
                    this.mMotionY = y + lastYCorrection + scrollOffsetCorrection;
                }
                this.mLastY = y + lastYCorrection + scrollOffsetCorrection;
            }
        } else if (this.mTouchMode == 5 && y != this.mLastY) {
            int newDirection;
            int oldScroll = this.mScrollY;
            int newScroll = oldScroll - incrementalDeltaY;
            int n = newDirection = y > this.mLastY ? 1 : -1;
            if (this.mDirection == 0) {
                this.mDirection = newDirection;
            }
            int overScrollDistance = -incrementalDeltaY;
            if (newScroll < 0 && oldScroll >= 0 || newScroll > 0 && oldScroll <= 0) {
                overScrollDistance = -oldScroll;
                incrementalDeltaY += overScrollDistance;
            } else {
                incrementalDeltaY = 0;
            }
            if (overScrollDistance != 0) {
                this.overScrollBy(0, overScrollDistance, 0, this.mScrollY, 0, 0, 0, this.mOverscrollDistance, true);
                int overscrollMode = this.getOverScrollMode();
                if (overscrollMode == 0 || overscrollMode == 1 && !this.contentFits()) {
                    if (rawDeltaY > 0) {
                        this.mEdgeGlowTop.onPull((float)overScrollDistance / (float)this.getHeight(), (float)x / (float)this.getWidth());
                        if (!this.mEdgeGlowBottom.isFinished()) {
                            this.mEdgeGlowBottom.onRelease();
                        }
                        this.invalidateTopGlow();
                    } else if (rawDeltaY < 0) {
                        this.mEdgeGlowBottom.onPull((float)overScrollDistance / (float)this.getHeight(), 1.0f - (float)x / (float)this.getWidth());
                        if (!this.mEdgeGlowTop.isFinished()) {
                            this.mEdgeGlowTop.onRelease();
                        }
                        this.invalidateBottomGlow();
                    }
                }
            }
            if (incrementalDeltaY != 0) {
                if (this.mScrollY != 0) {
                    this.mScrollY = 0;
                    this.invalidateParentIfNeeded();
                }
                this.trackMotionScroll(incrementalDeltaY, incrementalDeltaY);
                this.mTouchMode = 3;
                int motionPosition = this.findClosestMotionRow(y);
                this.mMotionCorrection = 0;
                View motionView = this.getChildAt(motionPosition - this.mFirstPosition);
                this.mMotionViewOriginalTop = motionView != null ? motionView.getTop() : 0;
                this.mMotionY = y + scrollOffsetCorrection;
                this.mMotionPosition = motionPosition;
            }
            this.mLastY = y + lastYCorrection + scrollOffsetCorrection;
            this.mDirection = newDirection;
        }
    }

    private final void $$robo$$android_widget_AbsListView$invalidateTopGlow() {
        if (this.mEdgeGlowTop == null) {
            return;
        }
        boolean clipToPadding = this.getClipToPadding();
        int top = clipToPadding ? this.mPaddingTop : 0;
        int left = clipToPadding ? this.mPaddingLeft : 0;
        int right = clipToPadding ? this.getWidth() - this.mPaddingRight : this.getWidth();
        this.invalidate(left, top, right, top + this.mEdgeGlowTop.getMaxHeight());
    }

    private final void $$robo$$android_widget_AbsListView$invalidateBottomGlow() {
        if (this.mEdgeGlowBottom == null) {
            return;
        }
        boolean clipToPadding = this.getClipToPadding();
        int bottom = clipToPadding ? this.getHeight() - this.mPaddingBottom : this.getHeight();
        int left = clipToPadding ? this.mPaddingLeft : 0;
        int right = clipToPadding ? this.getWidth() - this.mPaddingRight : this.getWidth();
        this.invalidate(left, bottom - this.mEdgeGlowBottom.getMaxHeight(), right, bottom);
    }

    private final void $$robo$$android_widget_AbsListView$onTouchModeChanged(boolean isInTouchMode) {
        if (isInTouchMode) {
            this.hideSelector();
            if (this.getHeight() > 0 && this.getChildCount() > 0) {
                this.layoutChildren();
            }
            this.updateSelectorState();
        } else {
            int touchMode = this.mTouchMode;
            if (touchMode == 5 || touchMode == 6) {
                if (this.mFlingRunnable != null) {
                    this.mFlingRunnable.endFling();
                }
                if (this.mPositionScroller != null) {
                    this.mPositionScroller.stop();
                }
                if (this.mScrollY != 0) {
                    this.mScrollY = 0;
                    this.invalidateParentCaches();
                    this.finishGlows();
                    this.invalidate();
                }
            }
        }
    }

    private final boolean $$robo$$android_widget_AbsListView$handleScrollBarDragging(MotionEvent event) {
        return false;
    }

    private final boolean $$robo$$android_widget_AbsListView$onTouchEvent(MotionEvent ev) {
        if (!this.isEnabled()) {
            return this.isClickable() || this.isLongClickable();
        }
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        if (this.mIsDetaching || !this.isAttachedToWindow()) {
            return false;
        }
        this.startNestedScroll(2);
        if (this.mFastScroll != null && this.mFastScroll.onTouchEvent(ev)) {
            return true;
        }
        this.initVelocityTrackerIfNotExists();
        MotionEvent vtev = MotionEvent.obtain(ev);
        int actionMasked = ev.getActionMasked();
        if (actionMasked == 0) {
            this.mNestedYOffset = 0;
        }
        vtev.offsetLocation(0.0f, this.mNestedYOffset);
        switch (actionMasked) {
            case 0: {
                this.onTouchDown(ev);
                break;
            }
            case 2: {
                this.onTouchMove(ev, vtev);
                break;
            }
            case 1: {
                this.onTouchUp(ev);
                break;
            }
            case 3: {
                this.onTouchCancel();
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                int x = this.mMotionX;
                int y = this.mMotionY;
                int motionPosition = this.pointToPosition(x, y);
                if (motionPosition >= 0) {
                    View child = this.getChildAt(motionPosition - this.mFirstPosition);
                    this.mMotionViewOriginalTop = child.getTop();
                    this.mMotionPosition = motionPosition;
                }
                this.mLastY = y;
                break;
            }
            case 5: {
                int index = ev.getActionIndex();
                int id2 = ev.getPointerId(index);
                int x = (int)ev.getX(index);
                int y = (int)ev.getY(index);
                this.mMotionCorrection = 0;
                this.mActivePointerId = id2;
                this.mMotionX = x;
                this.mMotionY = y;
                int motionPosition = this.pointToPosition(x, y);
                if (motionPosition >= 0) {
                    View child = this.getChildAt(motionPosition - this.mFirstPosition);
                    this.mMotionViewOriginalTop = child.getTop();
                    this.mMotionPosition = motionPosition;
                }
                this.mLastY = y;
                break;
            }
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.addMovement(vtev);
        }
        vtev.recycle();
        return true;
    }

    private final void $$robo$$android_widget_AbsListView$onTouchDown(MotionEvent ev) {
        this.mHasPerformedLongPress = false;
        this.mActivePointerId = ev.getPointerId(0);
        this.hideSelector();
        if (this.mTouchMode == 6) {
            this.mFlingRunnable.endFling();
            if (this.mPositionScroller != null) {
                this.mPositionScroller.stop();
            }
            this.mTouchMode = 5;
            this.mMotionX = (int)ev.getX();
            this.mLastY = this.mMotionY = (int)ev.getY();
            this.mMotionCorrection = 0;
            this.mDirection = 0;
        } else {
            int x = (int)ev.getX();
            int y = (int)ev.getY();
            int motionPosition = this.pointToPosition(x, y);
            if (!this.mDataChanged) {
                if (this.mTouchMode == 4) {
                    this.createScrollingCache();
                    this.mTouchMode = 3;
                    this.mMotionCorrection = 0;
                    motionPosition = this.findMotionRow(y);
                    this.mFlingRunnable.flywheelTouch();
                } else if (motionPosition >= 0 && ((ListAdapter)this.getAdapter()).isEnabled(motionPosition)) {
                    this.mTouchMode = 0;
                    if (this.mPendingCheckForTap == null) {
                        this.mPendingCheckForTap = new CheckForTap(this);
                    }
                    this.mPendingCheckForTap.x = ev.getX();
                    this.mPendingCheckForTap.y = ev.getY();
                    this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
                }
            }
            if (motionPosition >= 0) {
                View v = this.getChildAt(motionPosition - this.mFirstPosition);
                this.mMotionViewOriginalTop = v.getTop();
            }
            this.mMotionX = x;
            this.mMotionY = y;
            this.mMotionPosition = motionPosition;
            this.mLastY = Integer.MIN_VALUE;
        }
        if (this.mTouchMode == 0 && this.mMotionPosition != -1 && this.performButtonActionOnTouchDown(ev)) {
            this.removeCallbacks(this.mPendingCheckForTap);
        }
    }

    private final void $$robo$$android_widget_AbsListView$onTouchMove(MotionEvent ev, MotionEvent vtev) {
        if (this.mHasPerformedLongPress) {
            return;
        }
        int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
        if (pointerIndex == -1) {
            pointerIndex = 0;
            this.mActivePointerId = ev.getPointerId(pointerIndex);
        }
        if (this.mDataChanged) {
            this.layoutChildren();
        }
        int y = (int)ev.getY(pointerIndex);
        switch (this.mTouchMode) {
            case 0: 
            case 1: 
            case 2: {
                if (this.startScrollIfNeeded((int)ev.getX(pointerIndex), y, vtev)) break;
                View motionView = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
                float x = ev.getX(pointerIndex);
                if (!this.pointInView(x, y, this.mTouchSlop)) {
                    this.setPressed(false);
                    if (motionView != null) {
                        motionView.setPressed(false);
                    }
                    this.removeCallbacks((Runnable)(this.mTouchMode == 0 ? this.mPendingCheckForTap : this.mPendingCheckForLongPress));
                    this.mTouchMode = 2;
                    this.updateSelectorState();
                    break;
                }
                if (motionView == null) break;
                float[] point = this.mTmpPoint;
                point[0] = x;
                point[1] = y;
                this.transformPointToViewLocal(point, motionView);
                motionView.drawableHotspotChanged(point[0], point[1]);
                break;
            }
            case 3: 
            case 5: {
                this.scrollIfNeeded((int)ev.getX(pointerIndex), y, vtev);
            }
        }
    }

    private final void $$robo$$android_widget_AbsListView$onTouchUp(MotionEvent ev) {
        switch (this.mTouchMode) {
            case 0: 
            case 1: 
            case 2: {
                int motionPosition = this.mMotionPosition;
                View child = this.getChildAt(motionPosition - this.mFirstPosition);
                if (child != null) {
                    float x;
                    boolean inList;
                    if (this.mTouchMode != 0) {
                        child.setPressed(false);
                    }
                    boolean bl = inList = (x = ev.getX()) > (float)this.mListPadding.left && x < (float)(this.getWidth() - this.mListPadding.right);
                    if (inList && !child.hasExplicitFocusable()) {
                        if (this.mPerformClick == null) {
                            this.mPerformClick = new PerformClick(this);
                        }
                        PerformClick performClick = this.mPerformClick;
                        performClick.mClickMotionPosition = motionPosition;
                        performClick.rememberWindowAttachCount();
                        this.mResurrectToPosition = motionPosition;
                        if (this.mTouchMode == 0 || this.mTouchMode == 1) {
                            this.removeCallbacks((Runnable)(this.mTouchMode == 0 ? this.mPendingCheckForTap : this.mPendingCheckForLongPress));
                            this.mLayoutMode = 0;
                            if (!this.mDataChanged && this.mAdapter.isEnabled(motionPosition)) {
                                this.mTouchMode = 1;
                                this.setSelectedPositionInt(this.mMotionPosition);
                                this.layoutChildren();
                                child.setPressed(true);
                                this.positionSelector(this.mMotionPosition, child);
                                this.setPressed(true);
                                if (this.mSelector != null) {
                                    Drawable d = this.mSelector.getCurrent();
                                    if (d != null && d instanceof TransitionDrawable) {
                                        ((TransitionDrawable)d).resetTransition();
                                    }
                                    this.mSelector.setHotspot(x, ev.getY());
                                }
                                if (this.mTouchModeReset != null) {
                                    this.removeCallbacks(this.mTouchModeReset);
                                }
                                this.mTouchModeReset = new Runnable(this, child, performClick){
                                    public transient /* synthetic */ Object __robo_data__;
                                    /* synthetic */ View val$child;
                                    /* synthetic */ PerformClick val$performClick;
                                    /* synthetic */ AbsListView this$0;

                                    private void $$robo$$android_widget_AbsListView_3$__constructor__(AbsListView this$0, View view, PerformClick performClick) {
                                    }

                                    private final void $$robo$$android_widget_AbsListView_3$run() {
                                        this.this$0.mTouchModeReset = null;
                                        this.this$0.mTouchMode = -1;
                                        this.val$child.setPressed(false);
                                        this.this$0.setPressed(false);
                                        if (!this.this$0.mDataChanged && !this.this$0.mIsDetaching && this.this$0.isAttachedToWindow()) {
                                            this.val$performClick.run();
                                        }
                                    }

                                    private void __constructor__(AbsListView absListView, View view, PerformClick performClick) {
                                        this.$$robo$$android_widget_AbsListView_3$__constructor__(absListView, view, performClick);
                                    }
                                    {
                                        this.this$0 = absListView;
                                        this.val$child = view;
                                        this.val$performClick = performClick;
                                        this.$$robo$init();
                                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_3$__constructor__(android.widget.AbsListView android.view.View android.widget.AbsListView$PerformClick ), 0, this, absListView, view, performClick);
                                    }

                                    @Override
                                    public void run() {
                                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_AbsListView_3$run(), 0, this);
                                    }
                                    {
                                        this.$$robo$init();
                                    }

                                    protected /* synthetic */ void $$robo$init() {
                                        if (this.__robo_data__ == null) {
                                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                        }
                                    }

                                    public /* synthetic */ Object $$robo$getData() {
                                        return this.__robo_data__;
                                    }
                                };
                                this.postDelayed(this.mTouchModeReset, ViewConfiguration.getPressedStateDuration());
                            } else {
                                this.mTouchMode = -1;
                                this.updateSelectorState();
                            }
                            return;
                        }
                        if (!this.mDataChanged && this.mAdapter.isEnabled(motionPosition)) {
                            performClick.run();
                        }
                    }
                }
                this.mTouchMode = -1;
                this.updateSelectorState();
                break;
            }
            case 3: {
                int childCount = this.getChildCount();
                if (childCount > 0) {
                    boolean flingVelocity;
                    int firstChildTop = this.getChildAt(0).getTop();
                    int lastChildBottom = this.getChildAt(childCount - 1).getBottom();
                    int contentTop = this.mListPadding.top;
                    int contentBottom = this.getHeight() - this.mListPadding.bottom;
                    if (this.mFirstPosition == 0 && firstChildTop >= contentTop && this.mFirstPosition + childCount < this.mItemCount && lastChildBottom <= this.getHeight() - contentBottom) {
                        this.mTouchMode = -1;
                        this.reportScrollStateChange(0);
                        break;
                    }
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                    int initialVelocity = (int)(velocityTracker.getYVelocity(this.mActivePointerId) * this.mVelocityScale);
                    boolean bl = flingVelocity = Math.abs(initialVelocity) > this.mMinimumVelocity;
                    if (!(!flingVelocity || this.mFirstPosition == 0 && firstChildTop == contentTop - this.mOverscrollDistance || this.mFirstPosition + childCount == this.mItemCount && lastChildBottom == contentBottom + this.mOverscrollDistance)) {
                        if (!this.dispatchNestedPreFling(0.0f, -initialVelocity)) {
                            if (this.mFlingRunnable == null) {
                                this.mFlingRunnable = new FlingRunnable(this);
                            }
                            this.reportScrollStateChange(2);
                            this.mFlingRunnable.start(-initialVelocity);
                            this.dispatchNestedFling(0.0f, -initialVelocity, true);
                            break;
                        }
                        this.mTouchMode = -1;
                        this.reportScrollStateChange(0);
                        break;
                    }
                    this.mTouchMode = -1;
                    this.reportScrollStateChange(0);
                    if (this.mFlingRunnable != null) {
                        this.mFlingRunnable.endFling();
                    }
                    if (this.mPositionScroller != null) {
                        this.mPositionScroller.stop();
                    }
                    if (!flingVelocity || this.dispatchNestedPreFling(0.0f, -initialVelocity)) break;
                    this.dispatchNestedFling(0.0f, -initialVelocity, false);
                    break;
                }
                this.mTouchMode = -1;
                this.reportScrollStateChange(0);
                break;
            }
            case 5: {
                if (this.mFlingRunnable == null) {
                    this.mFlingRunnable = new FlingRunnable(this);
                }
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                int initialVelocity = (int)velocityTracker.getYVelocity(this.mActivePointerId);
                this.reportScrollStateChange(2);
                if (Math.abs(initialVelocity) > this.mMinimumVelocity) {
                    this.mFlingRunnable.startOverfling(-initialVelocity);
                    break;
                }
                this.mFlingRunnable.startSpringback();
            }
        }
        this.setPressed(false);
        if (this.mEdgeGlowTop != null) {
            this.mEdgeGlowTop.onRelease();
            this.mEdgeGlowBottom.onRelease();
        }
        this.invalidate();
        this.removeCallbacks(this.mPendingCheckForLongPress);
        this.recycleVelocityTracker();
        this.mActivePointerId = -1;
        if (this.mScrollStrictSpan != null) {
            this.mScrollStrictSpan.finish();
            this.mScrollStrictSpan = null;
        }
    }

    private final void $$robo$$android_widget_AbsListView$onTouchCancel() {
        switch (this.mTouchMode) {
            case 5: {
                if (this.mFlingRunnable == null) {
                    this.mFlingRunnable = new FlingRunnable(this);
                }
                this.mFlingRunnable.startSpringback();
                break;
            }
            case 6: {
                break;
            }
            default: {
                this.mTouchMode = -1;
                this.setPressed(false);
                View motionView = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
                if (motionView != null) {
                    motionView.setPressed(false);
                }
                this.clearScrollingCache();
                this.removeCallbacks(this.mPendingCheckForLongPress);
                this.recycleVelocityTracker();
            }
        }
        if (this.mEdgeGlowTop != null) {
            this.mEdgeGlowTop.onRelease();
            this.mEdgeGlowBottom.onRelease();
        }
        this.mActivePointerId = -1;
    }

    private final void $$robo$$android_widget_AbsListView$onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        if (this.mScrollY != scrollY) {
            this.onScrollChanged(this.mScrollX, scrollY, this.mScrollX, this.mScrollY);
            this.mScrollY = scrollY;
            this.invalidateParentIfNeeded();
            this.awakenScrollBars();
        }
    }

    private final boolean $$robo$$android_widget_AbsListView$onGenericMotionEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 8: {
                float axisValue = event.isFromSource(2) ? event.getAxisValue(9) : (event.isFromSource(0x400000) ? event.getAxisValue(26) : 0.0f);
                int delta = Math.round(axisValue * this.mVerticalScrollFactor);
                if (delta == 0 || this.trackMotionScroll(delta, delta)) break;
                return true;
            }
            case 11: {
                int actionButton;
                if (!event.isFromSource(2) || (actionButton = event.getActionButton()) != 32 && actionButton != 2 || this.mTouchMode != 0 && this.mTouchMode != 1 || !this.performStylusButtonPressAction(event)) break;
                this.removeCallbacks(this.mPendingCheckForLongPress);
                this.removeCallbacks(this.mPendingCheckForTap);
            }
        }
        return super.onGenericMotionEvent(event);
    }

    private final void $$robo$$android_widget_AbsListView$fling(int velocityY) {
        if (this.mFlingRunnable == null) {
            this.mFlingRunnable = new FlingRunnable(this);
        }
        this.reportScrollStateChange(2);
        this.mFlingRunnable.start(velocityY);
    }

    private final boolean $$robo$$android_widget_AbsListView$onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return (nestedScrollAxes & 2) != 0;
    }

    private final void $$robo$$android_widget_AbsListView$onNestedScrollAccepted(View child, View target, int axes) {
        super.onNestedScrollAccepted(child, target, axes);
        this.startNestedScroll(2);
    }

    private final void $$robo$$android_widget_AbsListView$onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        int oldTop;
        int motionIndex = this.getChildCount() / 2;
        View motionView = this.getChildAt(motionIndex);
        int n = oldTop = motionView != null ? motionView.getTop() : 0;
        if (motionView == null || this.trackMotionScroll(-dyUnconsumed, -dyUnconsumed)) {
            int myUnconsumed = dyUnconsumed;
            int myConsumed = 0;
            if (motionView != null) {
                myConsumed = motionView.getTop() - oldTop;
                myUnconsumed -= myConsumed;
            }
            this.dispatchNestedScroll(0, myConsumed, 0, myUnconsumed, null);
        }
    }

    private final boolean $$robo$$android_widget_AbsListView$onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        int childCount = this.getChildCount();
        if (!consumed && childCount > 0 && this.canScrollList((int)velocityY) && Math.abs(velocityY) > (float)this.mMinimumVelocity) {
            this.reportScrollStateChange(2);
            if (this.mFlingRunnable == null) {
                this.mFlingRunnable = new FlingRunnable(this);
            }
            if (!this.dispatchNestedPreFling(0.0f, velocityY)) {
                this.mFlingRunnable.start((int)velocityY);
            }
            return true;
        }
        return this.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    private final void $$robo$$android_widget_AbsListView$draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mEdgeGlowTop != null) {
            int restoreCount;
            int translateY;
            int translateX;
            int height;
            int width;
            int scrollY = this.mScrollY;
            boolean clipToPadding = this.getClipToPadding();
            if (clipToPadding) {
                width = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
                height = this.getHeight() - this.mPaddingTop - this.mPaddingBottom;
                translateX = this.mPaddingLeft;
                translateY = this.mPaddingTop;
            } else {
                width = this.getWidth();
                height = this.getHeight();
                translateX = 0;
                translateY = 0;
            }
            if (!this.mEdgeGlowTop.isFinished()) {
                restoreCount = canvas.save();
                canvas.clipRect(translateX, translateY, translateX + width, translateY + this.mEdgeGlowTop.getMaxHeight());
                int edgeY = Math.min(0, scrollY + this.mFirstPositionDistanceGuess) + translateY;
                canvas.translate(translateX, edgeY);
                this.mEdgeGlowTop.setSize(width, height);
                if (this.mEdgeGlowTop.draw(canvas)) {
                    this.invalidateTopGlow();
                }
                canvas.restoreToCount(restoreCount);
            }
            if (!this.mEdgeGlowBottom.isFinished()) {
                restoreCount = canvas.save();
                canvas.clipRect(translateX, translateY + height - this.mEdgeGlowBottom.getMaxHeight(), translateX + width, translateY + height);
                int edgeX = -width + translateX;
                int edgeY = Math.max(this.getHeight(), scrollY + this.mLastPositionDistanceGuess) - (clipToPadding ? this.mPaddingBottom : 0);
                canvas.translate(edgeX, edgeY);
                canvas.rotate(180.0f, width, 0.0f);
                this.mEdgeGlowBottom.setSize(width, height);
                if (this.mEdgeGlowBottom.draw(canvas)) {
                    this.invalidateBottomGlow();
                }
                canvas.restoreToCount(restoreCount);
            }
        }
    }

    private final void $$robo$$android_widget_AbsListView$initOrResetVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
    }

    private final void $$robo$$android_widget_AbsListView$initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private final void $$robo$$android_widget_AbsListView$recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private final void $$robo$$android_widget_AbsListView$requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (disallowIntercept) {
            this.recycleVelocityTracker();
        }
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
    }

    private final boolean $$robo$$android_widget_AbsListView$onInterceptHoverEvent(MotionEvent event) {
        if (this.mFastScroll != null && this.mFastScroll.onInterceptHoverEvent(event)) {
            return true;
        }
        return super.onInterceptHoverEvent(event);
    }

    private final PointerIcon $$robo$$android_widget_AbsListView$onResolvePointerIcon(MotionEvent event, int pointerIndex) {
        PointerIcon pointerIcon;
        if (this.mFastScroll != null && (pointerIcon = this.mFastScroll.onResolvePointerIcon(event, pointerIndex)) != null) {
            return pointerIcon;
        }
        return super.onResolvePointerIcon(event, pointerIndex);
    }

    private final boolean $$robo$$android_widget_AbsListView$onInterceptTouchEvent(MotionEvent ev) {
        int actionMasked = ev.getActionMasked();
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        if (this.mIsDetaching || !this.isAttachedToWindow()) {
            return false;
        }
        if (this.mFastScroll != null && this.mFastScroll.onInterceptTouchEvent(ev)) {
            return true;
        }
        switch (actionMasked) {
            case 0: {
                int touchMode = this.mTouchMode;
                if (touchMode == 6 || touchMode == 5) {
                    this.mMotionCorrection = 0;
                    return true;
                }
                int x = (int)ev.getX();
                int y = (int)ev.getY();
                this.mActivePointerId = ev.getPointerId(0);
                int motionPosition = this.findMotionRow(y);
                if (touchMode != 4 && motionPosition >= 0) {
                    View v = this.getChildAt(motionPosition - this.mFirstPosition);
                    this.mMotionViewOriginalTop = v.getTop();
                    this.mMotionX = x;
                    this.mMotionY = y;
                    this.mMotionPosition = motionPosition;
                    this.mTouchMode = 0;
                    this.clearScrollingCache();
                }
                this.mLastY = Integer.MIN_VALUE;
                this.initOrResetVelocityTracker();
                this.mVelocityTracker.addMovement(ev);
                this.mNestedYOffset = 0;
                this.startNestedScroll(2);
                if (touchMode != 4) break;
                return true;
            }
            case 2: {
                switch (this.mTouchMode) {
                    case 0: {
                        int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                        if (pointerIndex == -1) {
                            pointerIndex = 0;
                            this.mActivePointerId = ev.getPointerId(pointerIndex);
                        }
                        int y = (int)ev.getY(pointerIndex);
                        this.initVelocityTrackerIfNotExists();
                        this.mVelocityTracker.addMovement(ev);
                        if (!this.startScrollIfNeeded((int)ev.getX(pointerIndex), y, null)) break;
                        return true;
                    }
                }
                break;
            }
            case 1: 
            case 3: {
                this.mTouchMode = -1;
                this.mActivePointerId = -1;
                this.recycleVelocityTracker();
                this.reportScrollStateChange(0);
                this.stopNestedScroll();
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        return false;
    }

    private final void $$robo$$android_widget_AbsListView$onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = (ev.getAction() & 0xFF00) >> 8;
        int pointerId = ev.getPointerId(pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mMotionX = (int)ev.getX(newPointerIndex);
            this.mMotionY = (int)ev.getY(newPointerIndex);
            this.mMotionCorrection = 0;
            this.mActivePointerId = ev.getPointerId(newPointerIndex);
        }
    }

    private final void $$robo$$android_widget_AbsListView$addTouchables(ArrayList<View> views) {
        int count = this.getChildCount();
        int firstPosition = this.mFirstPosition;
        ListAdapter adapter = this.mAdapter;
        if (adapter == null) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (adapter.isEnabled(firstPosition + i)) {
                views.add(child);
            }
            child.addTouchables(views);
        }
    }

    private final void $$robo$$android_widget_AbsListView$reportScrollStateChange(int newState) {
        if (newState != this.mLastScrollState && this.mOnScrollListener != null) {
            this.mLastScrollState = newState;
            this.mOnScrollListener.onScrollStateChanged(this, newState);
        }
    }

    private final void $$robo$$android_widget_AbsListView$setFriction(float friction) {
        if (this.mFlingRunnable == null) {
            this.mFlingRunnable = new FlingRunnable(this);
        }
        this.mFlingRunnable.mScroller.setFriction(friction);
    }

    private final void $$robo$$android_widget_AbsListView$setVelocityScale(float scale) {
        this.mVelocityScale = scale;
    }

    private final AbsPositionScroller $$robo$$android_widget_AbsListView$createPositionScroller() {
        return new PositionScroller(this);
    }

    private final void $$robo$$android_widget_AbsListView$smoothScrollToPosition(int position) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = this.createPositionScroller();
        }
        this.mPositionScroller.start(position);
    }

    private final void $$robo$$android_widget_AbsListView$smoothScrollToPositionFromTop(int position, int offset, int duration) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = this.createPositionScroller();
        }
        this.mPositionScroller.startWithOffset(position, offset, duration);
    }

    private final void $$robo$$android_widget_AbsListView$smoothScrollToPositionFromTop(int position, int offset) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = this.createPositionScroller();
        }
        this.mPositionScroller.startWithOffset(position, offset);
    }

    private final void $$robo$$android_widget_AbsListView$smoothScrollToPosition(int position, int boundPosition) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = this.createPositionScroller();
        }
        this.mPositionScroller.start(position, boundPosition);
    }

    private final void $$robo$$android_widget_AbsListView$smoothScrollBy(int distance, int duration) {
        this.smoothScrollBy(distance, duration, false, false);
    }

    private final void $$robo$$android_widget_AbsListView$smoothScrollBy(int distance, int duration, boolean linear, boolean suppressEndFlingStateChangeCall) {
        if (this.mFlingRunnable == null) {
            this.mFlingRunnable = new FlingRunnable(this);
        }
        int firstPos = this.mFirstPosition;
        int childCount = this.getChildCount();
        int lastPos = firstPos + childCount;
        int topLimit = this.getPaddingTop();
        int bottomLimit = this.getHeight() - this.getPaddingBottom();
        if (distance == 0 || this.mItemCount == 0 || childCount == 0 || firstPos == 0 && this.getChildAt(0).getTop() == topLimit && distance < 0 || lastPos == this.mItemCount && this.getChildAt(childCount - 1).getBottom() == bottomLimit && distance > 0) {
            this.mFlingRunnable.endFling();
            if (this.mPositionScroller != null) {
                this.mPositionScroller.stop();
            }
        } else {
            this.reportScrollStateChange(2);
            this.mFlingRunnable.startScroll(distance, duration, linear, suppressEndFlingStateChangeCall);
        }
    }

    private final void $$robo$$android_widget_AbsListView$smoothScrollByOffset(int position) {
        View child;
        int index = -1;
        if (position < 0) {
            index = this.getFirstVisiblePosition();
        } else if (position > 0) {
            index = this.getLastVisiblePosition();
        }
        if (index > -1 && (child = this.getChildAt(index - this.getFirstVisiblePosition())) != null) {
            Rect visibleRect = new Rect();
            if (child.getGlobalVisibleRect(visibleRect)) {
                int childRectArea = child.getWidth() * child.getHeight();
                int visibleRectArea = visibleRect.width() * visibleRect.height();
                float visibleArea = (float)visibleRectArea / (float)childRectArea;
                float visibleThreshold = 0.75f;
                if (position < 0 && visibleArea < 0.75f) {
                    ++index;
                } else if (position > 0 && visibleArea < 0.75f) {
                    --index;
                }
            }
            this.smoothScrollToPosition(Math.max(0, Math.min(this.getCount(), index + position)));
        }
    }

    private final void $$robo$$android_widget_AbsListView$createScrollingCache() {
        if (this.mScrollingCacheEnabled && !this.mCachingStarted && !this.isHardwareAccelerated()) {
            this.setChildrenDrawnWithCacheEnabled(true);
            this.setChildrenDrawingCacheEnabled(true);
            this.mCachingActive = true;
            this.mCachingStarted = true;
        }
    }

    private final void $$robo$$android_widget_AbsListView$clearScrollingCache() {
        if (!this.isHardwareAccelerated()) {
            if (this.mClearScrollingCache == null) {
                this.mClearScrollingCache = new Runnable(this){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ AbsListView this$0;

                    private void $$robo$$android_widget_AbsListView_4$__constructor__(AbsListView this$0) {
                    }

                    private final void $$robo$$android_widget_AbsListView_4$run() {
                        if (this.this$0.mCachingStarted) {
                            this.this$0.mCachingActive = false;
                            this.this$0.mCachingStarted = false;
                            this.this$0.setChildrenDrawnWithCacheEnabled(false);
                            if ((this.this$0.mPersistentDrawingCache & 2) == 0) {
                                this.this$0.setChildrenDrawingCacheEnabled(false);
                            }
                            if (!this.this$0.isAlwaysDrawnWithCacheEnabled()) {
                                this.this$0.invalidate();
                            }
                        }
                    }

                    private void __constructor__(AbsListView absListView) {
                        this.$$robo$$android_widget_AbsListView_4$__constructor__(absListView);
                    }
                    {
                        this.this$0 = absListView;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_4$__constructor__(android.widget.AbsListView ), 0, this, absListView);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_AbsListView_4$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
            }
            this.post(this.mClearScrollingCache);
        }
    }

    private final void $$robo$$android_widget_AbsListView$scrollListBy(int y) {
        this.trackMotionScroll(-y, -y);
    }

    private final boolean $$robo$$android_widget_AbsListView$canScrollList(int direction) {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return false;
        }
        int firstPosition = this.mFirstPosition;
        Rect listPadding = this.mListPadding;
        if (direction > 0) {
            int lastBottom = this.getChildAt(childCount - 1).getBottom();
            int lastPosition = firstPosition + childCount;
            return lastPosition < this.mItemCount || lastBottom > this.getHeight() - listPadding.bottom;
        }
        int firstTop = this.getChildAt(0).getTop();
        return firstPosition > 0 || firstTop < listPadding.top;
    }

    private final boolean $$robo$$android_widget_AbsListView$trackMotionScroll(int deltaY, int incrementalDeltaY) {
        int childIndex;
        int absIncrementalDeltaY;
        View child;
        int i;
        boolean cannotScrollUp;
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return true;
        }
        int firstTop = this.getChildAt(0).getTop();
        int lastBottom = this.getChildAt(childCount - 1).getBottom();
        Rect listPadding = this.mListPadding;
        int effectivePaddingTop = 0;
        int effectivePaddingBottom = 0;
        if ((this.mGroupFlags & 0x22) == 34) {
            effectivePaddingTop = listPadding.top;
            effectivePaddingBottom = listPadding.bottom;
        }
        int spaceAbove = effectivePaddingTop - firstTop;
        int end = this.getHeight() - effectivePaddingBottom;
        int spaceBelow = lastBottom - end;
        int height = this.getHeight() - this.mPaddingBottom - this.mPaddingTop;
        deltaY = deltaY < 0 ? Math.max(-(height - 1), deltaY) : Math.min(height - 1, deltaY);
        incrementalDeltaY = incrementalDeltaY < 0 ? Math.max(-(height - 1), incrementalDeltaY) : Math.min(height - 1, incrementalDeltaY);
        int firstPosition = this.mFirstPosition;
        this.mFirstPositionDistanceGuess = firstPosition == 0 ? firstTop - listPadding.top : (this.mFirstPositionDistanceGuess += incrementalDeltaY);
        this.mLastPositionDistanceGuess = firstPosition + childCount == this.mItemCount ? lastBottom + listPadding.bottom : (this.mLastPositionDistanceGuess += incrementalDeltaY);
        boolean cannotScrollDown = firstPosition == 0 && firstTop >= listPadding.top && incrementalDeltaY >= 0;
        boolean bl = cannotScrollUp = firstPosition + childCount == this.mItemCount && lastBottom <= this.getHeight() - listPadding.bottom && incrementalDeltaY <= 0;
        if (cannotScrollDown || cannotScrollUp) {
            return incrementalDeltaY != 0;
        }
        boolean down = incrementalDeltaY < 0;
        boolean inTouchMode = this.isInTouchMode();
        if (inTouchMode) {
            this.hideSelector();
        }
        int headerViewsCount = this.getHeaderViewsCount();
        int footerViewsStart = this.mItemCount - this.getFooterViewsCount();
        int start = 0;
        int count = 0;
        if (down) {
            int top = -incrementalDeltaY;
            if ((this.mGroupFlags & 0x22) == 34) {
                top += listPadding.top;
            }
            for (i = 0; i < childCount && (child = this.getChildAt(i)).getBottom() < top; ++i) {
                ++count;
                int position = firstPosition + i;
                if (position < headerViewsCount || position >= footerViewsStart) continue;
                child.clearAccessibilityFocus();
                this.mRecycler.addScrapView(child, position);
            }
        } else {
            int bottom = this.getHeight() - incrementalDeltaY;
            if ((this.mGroupFlags & 0x22) == 34) {
                bottom -= listPadding.bottom;
            }
            for (i = childCount - 1; i >= 0 && (child = this.getChildAt(i)).getTop() > bottom; --i) {
                start = i;
                ++count;
                int position = firstPosition + i;
                if (position < headerViewsCount || position >= footerViewsStart) continue;
                child.clearAccessibilityFocus();
                this.mRecycler.addScrapView(child, position);
            }
        }
        this.mMotionViewNewTop = this.mMotionViewOriginalTop + deltaY;
        this.mBlockLayoutRequests = true;
        if (count > 0) {
            this.detachViewsFromParent(start, count);
            this.mRecycler.removeSkippedScrap();
        }
        if (!this.awakenScrollBars()) {
            this.invalidate();
        }
        this.offsetChildrenTopAndBottom(incrementalDeltaY);
        if (down) {
            this.mFirstPosition += count;
        }
        if (spaceAbove < (absIncrementalDeltaY = Math.abs(incrementalDeltaY)) || spaceBelow < absIncrementalDeltaY) {
            this.fillGap(down);
        }
        this.mRecycler.fullyDetachScrapViews();
        boolean selectorOnScreen = false;
        if (!inTouchMode && this.mSelectedPosition != -1) {
            int childIndex2 = this.mSelectedPosition - this.mFirstPosition;
            if (childIndex2 >= 0 && childIndex2 < this.getChildCount()) {
                this.positionSelector(this.mSelectedPosition, this.getChildAt(childIndex2));
                selectorOnScreen = true;
            }
        } else if (this.mSelectorPosition != -1 && (childIndex = this.mSelectorPosition - this.mFirstPosition) >= 0 && childIndex < this.getChildCount()) {
            this.positionSelector(this.mSelectorPosition, this.getChildAt(childIndex));
            selectorOnScreen = true;
        }
        if (!selectorOnScreen) {
            this.mSelectorRect.setEmpty();
        }
        this.mBlockLayoutRequests = false;
        this.invokeOnItemScrollListener();
        return false;
    }

    private final int $$robo$$android_widget_AbsListView$getHeaderViewsCount() {
        return 0;
    }

    private final int $$robo$$android_widget_AbsListView$getFooterViewsCount() {
        return 0;
    }

    abstract void fillGap(boolean var1);

    private final void $$robo$$android_widget_AbsListView$hideSelector() {
        if (this.mSelectedPosition != -1) {
            if (this.mLayoutMode != 4) {
                this.mResurrectToPosition = this.mSelectedPosition;
            }
            if (this.mNextSelectedPosition >= 0 && this.mNextSelectedPosition != this.mSelectedPosition) {
                this.mResurrectToPosition = this.mNextSelectedPosition;
            }
            this.setSelectedPositionInt(-1);
            this.setNextSelectedPositionInt(-1);
            this.mSelectedTop = 0;
        }
    }

    private final int $$robo$$android_widget_AbsListView$reconcileSelectedPosition() {
        int position = this.mSelectedPosition;
        if (position < 0) {
            position = this.mResurrectToPosition;
        }
        position = Math.max(0, position);
        position = Math.min(position, this.mItemCount - 1);
        return position;
    }

    abstract int findMotionRow(int var1);

    private final int $$robo$$android_widget_AbsListView$findClosestMotionRow(int y) {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return -1;
        }
        int motionRow = this.findMotionRow(y);
        return motionRow != -1 ? motionRow : this.mFirstPosition + childCount - 1;
    }

    private final void $$robo$$android_widget_AbsListView$invalidateViews() {
        this.mDataChanged = true;
        this.rememberSyncState();
        this.requestLayout();
        this.invalidate();
    }

    private final boolean $$robo$$android_widget_AbsListView$resurrectSelectionIfNeeded() {
        if (this.mSelectedPosition < 0 && this.resurrectSelection()) {
            this.updateSelectorState();
            return true;
        }
        return false;
    }

    abstract void setSelectionInt(int var1);

    private final boolean $$robo$$android_widget_AbsListView$resurrectSelection() {
        int selectedPos;
        int childCount = this.getChildCount();
        if (childCount <= 0) {
            return false;
        }
        int selectedTop = 0;
        int childrenTop = this.mListPadding.top;
        int childrenBottom = this.mBottom - this.mTop - this.mListPadding.bottom;
        int firstPosition = this.mFirstPosition;
        int toPosition = this.mResurrectToPosition;
        boolean down = true;
        if (toPosition >= firstPosition && toPosition < firstPosition + childCount) {
            selectedPos = toPosition;
            View selected = this.getChildAt(selectedPos - this.mFirstPosition);
            selectedTop = selected.getTop();
            int selectedBottom = selected.getBottom();
            if (selectedTop < childrenTop) {
                selectedTop = childrenTop + this.getVerticalFadingEdgeLength();
            } else if (selectedBottom > childrenBottom) {
                selectedTop = childrenBottom - selected.getMeasuredHeight() - this.getVerticalFadingEdgeLength();
            }
        } else if (toPosition < firstPosition) {
            selectedPos = firstPosition;
            for (int i = 0; i < childCount; ++i) {
                View v = this.getChildAt(i);
                int top = v.getTop();
                if (i == 0) {
                    selectedTop = top;
                    if (firstPosition > 0 || top < childrenTop) {
                        childrenTop += this.getVerticalFadingEdgeLength();
                    }
                }
                if (top < childrenTop) continue;
                selectedPos = firstPosition + i;
                selectedTop = top;
                break;
            }
        } else {
            int itemCount = this.mItemCount;
            down = false;
            selectedPos = firstPosition + childCount - 1;
            for (int i = childCount - 1; i >= 0; --i) {
                View v = this.getChildAt(i);
                int top = v.getTop();
                int bottom = v.getBottom();
                if (i == childCount - 1) {
                    selectedTop = top;
                    if (firstPosition + childCount < itemCount || bottom > childrenBottom) {
                        childrenBottom -= this.getVerticalFadingEdgeLength();
                    }
                }
                if (bottom > childrenBottom) continue;
                selectedPos = firstPosition + i;
                selectedTop = top;
                break;
            }
        }
        this.mResurrectToPosition = -1;
        this.removeCallbacks(this.mFlingRunnable);
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        this.mTouchMode = -1;
        this.clearScrollingCache();
        this.mSpecificTop = selectedTop;
        selectedPos = this.lookForSelectablePosition(selectedPos, down);
        if (selectedPos >= firstPosition && selectedPos <= this.getLastVisiblePosition()) {
            this.mLayoutMode = 4;
            this.updateSelectorState();
            this.setSelectionInt(selectedPos);
            this.invokeOnItemScrollListener();
        } else {
            selectedPos = -1;
        }
        this.reportScrollStateChange(0);
        return selectedPos >= 0;
    }

    private final void $$robo$$android_widget_AbsListView$confirmCheckedPositionsById() {
        this.mCheckStates.clear();
        boolean checkedCountChanged = false;
        for (int checkedIndex = 0; checkedIndex < this.mCheckedIdStates.size(); ++checkedIndex) {
            int lastPos;
            long lastPosId;
            long id2 = this.mCheckedIdStates.keyAt(checkedIndex);
            if (id2 != (lastPosId = this.mAdapter.getItemId(lastPos = this.mCheckedIdStates.valueAt(checkedIndex).intValue()))) {
                int start = Math.max(0, lastPos - 20);
                int end = Math.min(lastPos + 20, this.mItemCount);
                boolean found = false;
                for (int searchPos = start; searchPos < end; ++searchPos) {
                    long searchId = this.mAdapter.getItemId(searchPos);
                    if (id2 != searchId) continue;
                    found = true;
                    this.mCheckStates.put(searchPos, true);
                    this.mCheckedIdStates.setValueAt(checkedIndex, searchPos);
                    break;
                }
                if (found) continue;
                this.mCheckedIdStates.delete(id2);
                --checkedIndex;
                --this.mCheckedItemCount;
                checkedCountChanged = true;
                if (this.mChoiceActionMode == null || this.mMultiChoiceModeCallback == null) continue;
                this.mMultiChoiceModeCallback.onItemCheckedStateChanged(this.mChoiceActionMode, lastPos, id2, false);
                continue;
            }
            this.mCheckStates.put(lastPos, true);
        }
        if (checkedCountChanged && this.mChoiceActionMode != null) {
            this.mChoiceActionMode.invalidate();
        }
    }

    private final void $$robo$$android_widget_AbsListView$handleDataChanged() {
        int count = this.mItemCount;
        int lastHandledItemCount = this.mLastHandledItemCount;
        this.mLastHandledItemCount = this.mItemCount;
        if (this.mChoiceMode != 0 && this.mAdapter != null && this.mAdapter.hasStableIds()) {
            this.confirmCheckedPositionsById();
        }
        this.mRecycler.clearTransientStateViews();
        if (count > 0) {
            int selectablePos;
            int newPos;
            if (this.mNeedSync) {
                this.mNeedSync = false;
                this.mPendingSync = null;
                if (this.mTranscriptMode == 2) {
                    this.mLayoutMode = 3;
                    return;
                }
                if (this.mTranscriptMode == 1) {
                    int lastBottom;
                    if (this.mForceTranscriptScroll) {
                        this.mForceTranscriptScroll = false;
                        this.mLayoutMode = 3;
                        return;
                    }
                    int childCount = this.getChildCount();
                    int listBottom = this.getHeight() - this.getPaddingBottom();
                    View lastChild = this.getChildAt(childCount - 1);
                    int n = lastBottom = lastChild != null ? lastChild.getBottom() : listBottom;
                    if (this.mFirstPosition + childCount >= lastHandledItemCount && lastBottom <= listBottom) {
                        this.mLayoutMode = 3;
                        return;
                    }
                    this.awakenScrollBars();
                }
                switch (this.mSyncMode) {
                    case 0: {
                        if (this.isInTouchMode()) {
                            this.mLayoutMode = 5;
                            this.mSyncPosition = Math.min(Math.max(0, this.mSyncPosition), count - 1);
                            return;
                        }
                        newPos = this.findSyncPosition();
                        if (newPos < 0 || (selectablePos = this.lookForSelectablePosition(newPos, true)) != newPos) break;
                        this.mSyncPosition = newPos;
                        this.mLayoutMode = this.mSyncHeight == (long)this.getHeight() ? 5 : 2;
                        this.setNextSelectedPositionInt(newPos);
                        return;
                    }
                    case 1: {
                        this.mLayoutMode = 5;
                        this.mSyncPosition = Math.min(Math.max(0, this.mSyncPosition), count - 1);
                        return;
                    }
                }
            }
            if (!this.isInTouchMode()) {
                newPos = this.getSelectedItemPosition();
                if (newPos >= count) {
                    newPos = count - 1;
                }
                if (newPos < 0) {
                    newPos = 0;
                }
                if ((selectablePos = this.lookForSelectablePosition(newPos, true)) >= 0) {
                    this.setNextSelectedPositionInt(selectablePos);
                    return;
                }
                selectablePos = this.lookForSelectablePosition(newPos, false);
                if (selectablePos >= 0) {
                    this.setNextSelectedPositionInt(selectablePos);
                    return;
                }
            } else if (this.mResurrectToPosition >= 0) {
                return;
            }
        }
        this.mLayoutMode = this.mStackFromBottom ? 3 : 1;
        this.mSelectedPosition = -1;
        this.mSelectedRowId = Long.MIN_VALUE;
        this.mNextSelectedPosition = -1;
        this.mNextSelectedRowId = Long.MIN_VALUE;
        this.mNeedSync = false;
        this.mPendingSync = null;
        this.mSelectorPosition = -1;
        this.checkSelectionChanged();
    }

    private final void $$robo$$android_widget_AbsListView$onDisplayHint(int hint) {
        super.onDisplayHint(hint);
        switch (hint) {
            case 4: {
                if (this.mPopup == null || !this.mPopup.isShowing()) break;
                this.dismissPopup();
                break;
            }
            case 0: {
                if (!this.mFiltered || this.mPopup == null || this.mPopup.isShowing()) break;
                this.showPopup();
            }
        }
        this.mPopupHidden = hint == 4;
    }

    private final void $$robo$$android_widget_AbsListView$dismissPopup() {
        if (this.mPopup != null) {
            this.mPopup.dismiss();
        }
    }

    private final void $$robo$$android_widget_AbsListView$showPopup() {
        if (this.getWindowVisibility() == 0) {
            this.createTextFilter(true);
            this.positionPopup();
            this.checkFocus();
        }
    }

    private final void $$robo$$android_widget_AbsListView$positionPopup() {
        int screenHeight = this.getResources().getDisplayMetrics().heightPixels;
        int[] xy = new int[2];
        this.getLocationOnScreen(xy);
        int bottomGap = screenHeight - xy[1] - this.getHeight() + (int)(this.mDensityScale * 20.0f);
        if (!this.mPopup.isShowing()) {
            this.mPopup.showAtLocation(this, 81, xy[0], bottomGap);
        } else {
            this.mPopup.update(xy[0], bottomGap, -1, -1);
        }
    }

    private static final int $$robo$$android_widget_AbsListView$getDistance(Rect source, Rect dest, int direction) {
        int dY;
        int dX;
        int sY;
        int sX;
        switch (direction) {
            case 66: {
                sX = source.right;
                sY = source.top + source.height() / 2;
                dX = dest.left;
                dY = dest.top + dest.height() / 2;
                break;
            }
            case 130: {
                sX = source.left + source.width() / 2;
                sY = source.bottom;
                dX = dest.left + dest.width() / 2;
                dY = dest.top;
                break;
            }
            case 17: {
                sX = source.left;
                sY = source.top + source.height() / 2;
                dX = dest.right;
                dY = dest.top + dest.height() / 2;
                break;
            }
            case 33: {
                sX = source.left + source.width() / 2;
                sY = source.top;
                dX = dest.left + dest.width() / 2;
                dY = dest.bottom;
                break;
            }
            case 1: 
            case 2: {
                sX = source.right + source.width() / 2;
                sY = source.top + source.height() / 2;
                dX = dest.left + dest.width() / 2;
                dY = dest.top + dest.height() / 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT, FOCUS_FORWARD, FOCUS_BACKWARD}.");
            }
        }
        int deltaX = dX - sX;
        int deltaY = dY - sY;
        return deltaY * deltaY + deltaX * deltaX;
    }

    private final boolean $$robo$$android_widget_AbsListView$isInFilterMode() {
        return this.mFiltered;
    }

    private final boolean $$robo$$android_widget_AbsListView$sendToTextFilter(int keyCode, int count, KeyEvent event) {
        if (!this.acceptFilter()) {
            return false;
        }
        boolean handled = false;
        boolean okToSend = true;
        switch (keyCode) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 66: {
                okToSend = false;
                break;
            }
            case 4: {
                if (this.mFiltered && this.mPopup != null && this.mPopup.isShowing()) {
                    if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                        KeyEvent.DispatcherState state = this.getKeyDispatcherState();
                        if (state != null) {
                            state.startTracking(event, this);
                        }
                        handled = true;
                    } else if (event.getAction() == 1 && event.isTracking() && !event.isCanceled()) {
                        handled = true;
                        this.mTextFilter.setText("");
                    }
                }
                okToSend = false;
                break;
            }
            case 62: {
                okToSend = this.mFiltered;
            }
        }
        if (okToSend) {
            this.createTextFilter(true);
            KeyEvent forwardEvent = event;
            if (forwardEvent.getRepeatCount() > 0) {
                forwardEvent = KeyEvent.changeTimeRepeat(event, event.getEventTime(), 0);
            }
            int action = event.getAction();
            switch (action) {
                case 0: {
                    handled = this.mTextFilter.onKeyDown(keyCode, forwardEvent);
                    break;
                }
                case 1: {
                    handled = this.mTextFilter.onKeyUp(keyCode, forwardEvent);
                    break;
                }
                case 2: {
                    handled = this.mTextFilter.onKeyMultiple(keyCode, count, event);
                }
            }
        }
        return handled;
    }

    private final InputConnection $$robo$$android_widget_AbsListView$onCreateInputConnection(EditorInfo outAttrs) {
        if (this.isTextFilterEnabled()) {
            if (this.mPublicInputConnection == null) {
                this.mDefInputConnection = new BaseInputConnection(this, false);
                this.mPublicInputConnection = new InputConnectionWrapper(this, outAttrs);
            }
            outAttrs.inputType = 177;
            outAttrs.imeOptions = 6;
            return this.mPublicInputConnection;
        }
        return null;
    }

    private final boolean $$robo$$android_widget_AbsListView$checkInputConnectionProxy(View view) {
        return view == this.mTextFilter;
    }

    private final void $$robo$$android_widget_AbsListView$createTextFilter(boolean animateEntrance) {
        if (this.mPopup == null) {
            PopupWindow p = new PopupWindow(this.getContext());
            p.setFocusable(false);
            p.setTouchable(false);
            p.setInputMethodMode(2);
            p.setContentView(this.getTextFilterInput());
            p.setWidth(-2);
            p.setHeight(-2);
            p.setBackgroundDrawable(null);
            this.mPopup = p;
            this.getViewTreeObserver().addOnGlobalLayoutListener(this);
            this.mGlobalLayoutListenerAddedFilter = true;
        }
        if (animateEntrance) {
            this.mPopup.setAnimationStyle(0x1030303);
        } else {
            this.mPopup.setAnimationStyle(16974596);
        }
    }

    private final EditText $$robo$$android_widget_AbsListView$getTextFilterInput() {
        if (this.mTextFilter == null) {
            LayoutInflater layoutInflater = LayoutInflater.from(this.getContext());
            this.mTextFilter = (EditText)layoutInflater.inflate(17367319, null);
            this.mTextFilter.setRawInputType(177);
            this.mTextFilter.setImeOptions(0x10000000);
            this.mTextFilter.addTextChangedListener(this);
        }
        return this.mTextFilter;
    }

    private final void $$robo$$android_widget_AbsListView$clearTextFilter() {
        if (this.mFiltered) {
            this.getTextFilterInput().setText("");
            this.mFiltered = false;
            if (this.mPopup != null && this.mPopup.isShowing()) {
                this.dismissPopup();
            }
        }
    }

    private final boolean $$robo$$android_widget_AbsListView$hasTextFilter() {
        return this.mFiltered;
    }

    private final void $$robo$$android_widget_AbsListView$onGlobalLayout() {
        if (this.isShown()) {
            if (this.mFiltered && this.mPopup != null && !this.mPopup.isShowing() && !this.mPopupHidden) {
                this.showPopup();
            }
        } else if (this.mPopup != null && this.mPopup.isShowing()) {
            this.dismissPopup();
        }
    }

    private final void $$robo$$android_widget_AbsListView$beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    private final void $$robo$$android_widget_AbsListView$onTextChanged(CharSequence s, int start, int before, int count) {
        if (this.isTextFilterEnabled()) {
            this.createTextFilter(true);
            int length = s.length();
            boolean showing = this.mPopup.isShowing();
            if (!showing && length > 0) {
                this.showPopup();
                this.mFiltered = true;
            } else if (showing && length == 0) {
                this.dismissPopup();
                this.mFiltered = false;
            }
            if (this.mAdapter instanceof Filterable) {
                Filter f = ((Filterable)((Object)this.mAdapter)).getFilter();
                if (f != null) {
                    f.filter(s, this);
                } else {
                    throw new IllegalStateException("You cannot call onTextChanged with a non filterable adapter");
                }
            }
        }
    }

    private final void $$robo$$android_widget_AbsListView$afterTextChanged(Editable s) {
    }

    private final void $$robo$$android_widget_AbsListView$onFilterComplete(int count) {
        if (this.mSelectedPosition < 0 && count > 0) {
            this.mResurrectToPosition = -1;
            this.resurrectSelection();
        }
    }

    private final ViewGroup.LayoutParams $$robo$$android_widget_AbsListView$generateDefaultLayoutParams() {
        return new LayoutParams(-1, -2, 0);
    }

    private final ViewGroup.LayoutParams $$robo$$android_widget_AbsListView$generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    private final LayoutParams $$robo$$android_widget_AbsListView$generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    private final boolean $$robo$$android_widget_AbsListView$checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    private final void $$robo$$android_widget_AbsListView$setTranscriptMode(int mode) {
        this.mTranscriptMode = mode;
    }

    private final int $$robo$$android_widget_AbsListView$getTranscriptMode() {
        return this.mTranscriptMode;
    }

    private final int $$robo$$android_widget_AbsListView$getSolidColor() {
        return this.mCacheColorHint;
    }

    private final void $$robo$$android_widget_AbsListView$setCacheColorHint(int color2) {
        if (color2 != this.mCacheColorHint) {
            this.mCacheColorHint = color2;
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.getChildAt(i).setDrawingCacheBackgroundColor(color2);
            }
            this.mRecycler.setCacheColorHint(color2);
        }
    }

    @ViewDebug.ExportedProperty(category="drawing")
    private final int $$robo$$android_widget_AbsListView$getCacheColorHint() {
        return this.mCacheColorHint;
    }

    private final void $$robo$$android_widget_AbsListView$reclaimViews(List<View> views) {
        int childCount = this.getChildCount();
        RecyclerListener listener = this.mRecycler.mRecyclerListener;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp == null || !this.mRecycler.shouldRecycleViewType(lp.viewType)) continue;
            views.add(child);
            child.setAccessibilityDelegate(null);
            if (listener == null) continue;
            listener.onMovedToScrapHeap(child);
        }
        this.mRecycler.reclaimScrapViews(views);
        this.removeAllViewsInLayout();
    }

    private final void $$robo$$android_widget_AbsListView$finishGlows() {
        if (this.mEdgeGlowTop != null) {
            this.mEdgeGlowTop.finish();
            this.mEdgeGlowBottom.finish();
        }
    }

    private final void $$robo$$android_widget_AbsListView$setRemoteViewsAdapter(Intent intent) {
        this.setRemoteViewsAdapter(intent, false);
    }

    private final Runnable $$robo$$android_widget_AbsListView$setRemoteViewsAdapterAsync(Intent intent) {
        return new RemoteViewsAdapter.AsyncRemoteAdapterAction(this, intent);
    }

    private final void $$robo$$android_widget_AbsListView$setRemoteViewsAdapter(Intent intent, boolean isAsync) {
        Intent.FilterComparison fcOld;
        Intent.FilterComparison fcNew;
        if (this.mRemoteAdapter != null && (fcNew = new Intent.FilterComparison(intent)).equals(fcOld = new Intent.FilterComparison(this.mRemoteAdapter.getRemoteViewsServiceIntent()))) {
            return;
        }
        this.mDeferNotifyDataSetChanged = false;
        this.mRemoteAdapter = new RemoteViewsAdapter(this.getContext(), intent, this, isAsync);
        if (this.mRemoteAdapter.isDataReady()) {
            this.setAdapter(this.mRemoteAdapter);
        }
    }

    private final void $$robo$$android_widget_AbsListView$setRemoteViewsOnClickHandler(RemoteViews.OnClickHandler handler) {
        if (this.mRemoteAdapter != null) {
            this.mRemoteAdapter.setRemoteViewsOnClickHandler(handler);
        }
    }

    private final void $$robo$$android_widget_AbsListView$deferNotifyDataSetChanged() {
        this.mDeferNotifyDataSetChanged = true;
    }

    private final boolean $$robo$$android_widget_AbsListView$onRemoteAdapterConnected() {
        if (this.mRemoteAdapter != this.mAdapter) {
            this.setAdapter(this.mRemoteAdapter);
            if (this.mDeferNotifyDataSetChanged) {
                this.mRemoteAdapter.notifyDataSetChanged();
                this.mDeferNotifyDataSetChanged = false;
            }
            return false;
        }
        if (this.mRemoteAdapter != null) {
            this.mRemoteAdapter.superNotifyDataSetChanged();
            return true;
        }
        return false;
    }

    private final void $$robo$$android_widget_AbsListView$onRemoteAdapterDisconnected() {
    }

    private final void $$robo$$android_widget_AbsListView$setVisibleRangeHint(int start, int end) {
        if (this.mRemoteAdapter != null) {
            this.mRemoteAdapter.setVisibleRangeHint(start, end);
        }
    }

    private final void $$robo$$android_widget_AbsListView$setRecyclerListener(RecyclerListener listener) {
        this.mRecycler.mRecyclerListener = listener;
    }

    private final int $$robo$$android_widget_AbsListView$getHeightForPosition(int position) {
        int firstVisiblePosition = this.getFirstVisiblePosition();
        int childCount = this.getChildCount();
        int index = position - firstVisiblePosition;
        if (index >= 0 && index < childCount) {
            View view = this.getChildAt(index);
            return view.getHeight();
        }
        View view = this.obtainView(position, this.mIsScrap);
        view.measure(this.mWidthMeasureSpec, 0);
        int height = view.getMeasuredHeight();
        this.mRecycler.addScrapView(view, position);
        return height;
    }

    private final void $$robo$$android_widget_AbsListView$setSelectionFromTop(int position, int y) {
        if (this.mAdapter == null) {
            return;
        }
        if (!this.isInTouchMode()) {
            if ((position = this.lookForSelectablePosition(position, true)) >= 0) {
                this.setNextSelectedPositionInt(position);
            }
        } else {
            this.mResurrectToPosition = position;
        }
        if (position >= 0) {
            this.mLayoutMode = 4;
            this.mSpecificTop = this.mListPadding.top + y;
            if (this.mNeedSync) {
                this.mSyncPosition = position;
                this.mSyncRowId = this.mAdapter.getItemId(position);
            }
            if (this.mPositionScroller != null) {
                this.mPositionScroller.stop();
            }
            this.requestLayout();
        }
    }

    private final void $$robo$$android_widget_AbsListView$encodeProperties(ViewHierarchyEncoder encoder) {
        super.encodeProperties(encoder);
        encoder.addProperty("drawing:cacheColorHint", this.getCacheColorHint());
        encoder.addProperty("list:fastScrollEnabled", this.isFastScrollEnabled());
        encoder.addProperty("list:scrollingCacheEnabled", this.isScrollingCacheEnabled());
        encoder.addProperty("list:smoothScrollbarEnabled", this.isSmoothScrollbarEnabled());
        encoder.addProperty("list:stackFromBottom", this.isStackFromBottom());
        encoder.addProperty("list:textFilterEnabled", this.isTextFilterEnabled());
        View selectedView = this.getSelectedView();
        if (selectedView != null) {
            encoder.addPropertyKey("selectedView");
            selectedView.encode(encoder);
        }
    }

    static void __staticInitializer__() {
        sLinearInterpolator = new LinearInterpolator();
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_AbsListView$__constructor__(context);
    }

    public AbsListView(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_AbsListView$__constructor__(context, attributeSet);
    }

    public AbsListView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842858);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_AbsListView$__constructor__(context, attributeSet, n);
    }

    public AbsListView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_AbsListView$__constructor__(context, attributeSet, n, n2);
    }

    public AbsListView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private void initAbsListView() {
        InvokeDynamicSupport.bootstrap("initAbsListView", $$robo$$android_widget_AbsListView$initAbsListView(), 0, this);
    }

    @Override
    public void setOverScrollMode(int n) {
        InvokeDynamicSupport.bootstrap("setOverScrollMode", $$robo$$android_widget_AbsListView$setOverScrollMode(int ), 0, this, n);
    }

    @Override
    public void setAdapter(ListAdapter listAdapter) {
        InvokeDynamicSupport.bootstrap("setAdapter", $$robo$$android_widget_AbsListView$setAdapter(android.widget.ListAdapter ), 0, this, listAdapter);
    }

    public int getCheckedItemCount() {
        return (int)InvokeDynamicSupport.bootstrap("getCheckedItemCount", $$robo$$android_widget_AbsListView$getCheckedItemCount(), 0, this);
    }

    public boolean isItemChecked(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isItemChecked", $$robo$$android_widget_AbsListView$isItemChecked(int ), 0, this, n);
    }

    public int getCheckedItemPosition() {
        return (int)InvokeDynamicSupport.bootstrap("getCheckedItemPosition", $$robo$$android_widget_AbsListView$getCheckedItemPosition(), 0, this);
    }

    public SparseBooleanArray getCheckedItemPositions() {
        return InvokeDynamicSupport.bootstrap("getCheckedItemPositions", $$robo$$android_widget_AbsListView$getCheckedItemPositions(), 0, this);
    }

    public long[] getCheckedItemIds() {
        return InvokeDynamicSupport.bootstrap("getCheckedItemIds", $$robo$$android_widget_AbsListView$getCheckedItemIds(), 0, this);
    }

    public void clearChoices() {
        InvokeDynamicSupport.bootstrap("clearChoices", $$robo$$android_widget_AbsListView$clearChoices(), 0, this);
    }

    public void setItemChecked(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setItemChecked", $$robo$$android_widget_AbsListView$setItemChecked(int boolean ), 0, this, n, bl);
    }

    @Override
    public boolean performItemClick(View view, int n, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("performItemClick", $$robo$$android_widget_AbsListView$performItemClick(android.view.View int long ), 0, this, view, n, l);
    }

    private void updateOnScreenCheckedViews() {
        InvokeDynamicSupport.bootstrap("updateOnScreenCheckedViews", $$robo$$android_widget_AbsListView$updateOnScreenCheckedViews(), 0, this);
    }

    public int getChoiceMode() {
        return (int)InvokeDynamicSupport.bootstrap("getChoiceMode", $$robo$$android_widget_AbsListView$getChoiceMode(), 0, this);
    }

    public void setChoiceMode(int n) {
        InvokeDynamicSupport.bootstrap("setChoiceMode", $$robo$$android_widget_AbsListView$setChoiceMode(int ), 0, this, n);
    }

    public void setMultiChoiceModeListener(MultiChoiceModeListener multiChoiceModeListener) {
        InvokeDynamicSupport.bootstrap("setMultiChoiceModeListener", $$robo$$android_widget_AbsListView$setMultiChoiceModeListener(android.widget.AbsListView$MultiChoiceModeListener ), 0, this, multiChoiceModeListener);
    }

    private boolean contentFits() {
        return (boolean)InvokeDynamicSupport.bootstrap("contentFits", $$robo$$android_widget_AbsListView$contentFits(), 0, this);
    }

    public void setFastScrollEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFastScrollEnabled", $$robo$$android_widget_AbsListView$setFastScrollEnabled(boolean ), 0, this, bl);
    }

    private void setFastScrollerEnabledUiThread(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFastScrollerEnabledUiThread", $$robo$$android_widget_AbsListView$setFastScrollerEnabledUiThread(boolean ), 0, this, bl);
    }

    public void setFastScrollStyle(int n) {
        InvokeDynamicSupport.bootstrap("setFastScrollStyle", $$robo$$android_widget_AbsListView$setFastScrollStyle(int ), 0, this, n);
    }

    public void setFastScrollAlwaysVisible(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFastScrollAlwaysVisible", $$robo$$android_widget_AbsListView$setFastScrollAlwaysVisible(boolean ), 0, this, bl);
    }

    private void setFastScrollerAlwaysVisibleUiThread(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFastScrollerAlwaysVisibleUiThread", $$robo$$android_widget_AbsListView$setFastScrollerAlwaysVisibleUiThread(boolean ), 0, this, bl);
    }

    private boolean isOwnerThread() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOwnerThread", $$robo$$android_widget_AbsListView$isOwnerThread(), 0, this);
    }

    public boolean isFastScrollAlwaysVisible() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFastScrollAlwaysVisible", $$robo$$android_widget_AbsListView$isFastScrollAlwaysVisible(), 0, this);
    }

    @Override
    public int getVerticalScrollbarWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getVerticalScrollbarWidth", $$robo$$android_widget_AbsListView$getVerticalScrollbarWidth(), 0, this);
    }

    @ViewDebug.ExportedProperty
    public boolean isFastScrollEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFastScrollEnabled", $$robo$$android_widget_AbsListView$isFastScrollEnabled(), 0, this);
    }

    @Override
    public void setVerticalScrollbarPosition(int n) {
        InvokeDynamicSupport.bootstrap("setVerticalScrollbarPosition", $$robo$$android_widget_AbsListView$setVerticalScrollbarPosition(int ), 0, this, n);
    }

    @Override
    public void setScrollBarStyle(int n) {
        InvokeDynamicSupport.bootstrap("setScrollBarStyle", $$robo$$android_widget_AbsListView$setScrollBarStyle(int ), 0, this, n);
    }

    @Override
    protected boolean isVerticalScrollBarHidden() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVerticalScrollBarHidden", $$robo$$android_widget_AbsListView$isVerticalScrollBarHidden(), 0, this);
    }

    public void setSmoothScrollbarEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSmoothScrollbarEnabled", $$robo$$android_widget_AbsListView$setSmoothScrollbarEnabled(boolean ), 0, this, bl);
    }

    @ViewDebug.ExportedProperty
    public boolean isSmoothScrollbarEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSmoothScrollbarEnabled", $$robo$$android_widget_AbsListView$isSmoothScrollbarEnabled(), 0, this);
    }

    public void setOnScrollListener(OnScrollListener onScrollListener) {
        InvokeDynamicSupport.bootstrap("setOnScrollListener", $$robo$$android_widget_AbsListView$setOnScrollListener(android.widget.AbsListView$OnScrollListener ), 0, this, onScrollListener);
    }

    void invokeOnItemScrollListener() {
        InvokeDynamicSupport.bootstrap("invokeOnItemScrollListener", $$robo$$android_widget_AbsListView$invokeOnItemScrollListener(), 0, this);
    }

    @Override
    public void sendAccessibilityEventUnchecked(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("sendAccessibilityEventUnchecked", $$robo$$android_widget_AbsListView$sendAccessibilityEventUnchecked(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_AbsListView$getAccessibilityClassName(), 0, this);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoInternal", $$robo$$android_widget_AbsListView$onInitializeAccessibilityNodeInfoInternal(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    int getSelectionModeForAccessibility() {
        return (int)InvokeDynamicSupport.bootstrap("getSelectionModeForAccessibility", $$robo$$android_widget_AbsListView$getSelectionModeForAccessibility(), 0, this);
    }

    @Override
    public boolean performAccessibilityActionInternal(int n, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("performAccessibilityActionInternal", $$robo$$android_widget_AbsListView$performAccessibilityActionInternal(int android.os.Bundle ), 0, this, n, bundle);
    }

    @Override
    public View findViewByAccessibilityIdTraversal(int n) {
        return InvokeDynamicSupport.bootstrap("findViewByAccessibilityIdTraversal", $$robo$$android_widget_AbsListView$findViewByAccessibilityIdTraversal(int ), 0, this, n);
    }

    @ViewDebug.ExportedProperty
    public boolean isScrollingCacheEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isScrollingCacheEnabled", $$robo$$android_widget_AbsListView$isScrollingCacheEnabled(), 0, this);
    }

    public void setScrollingCacheEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setScrollingCacheEnabled", $$robo$$android_widget_AbsListView$setScrollingCacheEnabled(boolean ), 0, this, bl);
    }

    public void setTextFilterEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setTextFilterEnabled", $$robo$$android_widget_AbsListView$setTextFilterEnabled(boolean ), 0, this, bl);
    }

    @ViewDebug.ExportedProperty
    public boolean isTextFilterEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTextFilterEnabled", $$robo$$android_widget_AbsListView$isTextFilterEnabled(), 0, this);
    }

    @Override
    public void getFocusedRect(Rect rect) {
        InvokeDynamicSupport.bootstrap("getFocusedRect", $$robo$$android_widget_AbsListView$getFocusedRect(android.graphics.Rect ), 0, this, rect);
    }

    private void useDefaultSelector() {
        InvokeDynamicSupport.bootstrap("useDefaultSelector", $$robo$$android_widget_AbsListView$useDefaultSelector(), 0, this);
    }

    @ViewDebug.ExportedProperty
    public boolean isStackFromBottom() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStackFromBottom", $$robo$$android_widget_AbsListView$isStackFromBottom(), 0, this);
    }

    public void setStackFromBottom(boolean bl) {
        InvokeDynamicSupport.bootstrap("setStackFromBottom", $$robo$$android_widget_AbsListView$setStackFromBottom(boolean ), 0, this, bl);
    }

    void requestLayoutIfNecessary() {
        InvokeDynamicSupport.bootstrap("requestLayoutIfNecessary", $$robo$$android_widget_AbsListView$requestLayoutIfNecessary(), 0, this);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_widget_AbsListView$onSaveInstanceState(), 0, this);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_widget_AbsListView$onRestoreInstanceState(android.os.Parcelable ), 0, this, parcelable);
    }

    private boolean acceptFilter() {
        return (boolean)InvokeDynamicSupport.bootstrap("acceptFilter", $$robo$$android_widget_AbsListView$acceptFilter(), 0, this);
    }

    public void setFilterText(String string2) {
        InvokeDynamicSupport.bootstrap("setFilterText", $$robo$$android_widget_AbsListView$setFilterText(java.lang.String ), 0, this, string2);
    }

    public CharSequence getTextFilter() {
        return InvokeDynamicSupport.bootstrap("getTextFilter", $$robo$$android_widget_AbsListView$getTextFilter(), 0, this);
    }

    @Override
    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        InvokeDynamicSupport.bootstrap("onFocusChanged", $$robo$$android_widget_AbsListView$onFocusChanged(boolean int android.graphics.Rect ), 0, this, bl, n, rect);
    }

    @Override
    public void requestLayout() {
        InvokeDynamicSupport.bootstrap("requestLayout", $$robo$$android_widget_AbsListView$requestLayout(), 0, this);
    }

    void resetList() {
        InvokeDynamicSupport.bootstrap("resetList", $$robo$$android_widget_AbsListView$resetList(), 0, this);
    }

    @Override
    protected int computeVerticalScrollExtent() {
        return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollExtent", $$robo$$android_widget_AbsListView$computeVerticalScrollExtent(), 0, this);
    }

    @Override
    protected int computeVerticalScrollOffset() {
        return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollOffset", $$robo$$android_widget_AbsListView$computeVerticalScrollOffset(), 0, this);
    }

    @Override
    protected int computeVerticalScrollRange() {
        return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollRange", $$robo$$android_widget_AbsListView$computeVerticalScrollRange(), 0, this);
    }

    @Override
    protected float getTopFadingEdgeStrength() {
        return (float)InvokeDynamicSupport.bootstrap("getTopFadingEdgeStrength", $$robo$$android_widget_AbsListView$getTopFadingEdgeStrength(), 0, this);
    }

    @Override
    protected float getBottomFadingEdgeStrength() {
        return (float)InvokeDynamicSupport.bootstrap("getBottomFadingEdgeStrength", $$robo$$android_widget_AbsListView$getBottomFadingEdgeStrength(), 0, this);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_AbsListView$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_AbsListView$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    @Override
    protected boolean setFrame(int n, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("setFrame", $$robo$$android_widget_AbsListView$setFrame(int int int int ), 0, this, n, n2, n3, n4);
    }

    protected void layoutChildren() {
        InvokeDynamicSupport.bootstrap("layoutChildren", $$robo$$android_widget_AbsListView$layoutChildren(), 0, this);
    }

    View getAccessibilityFocusedChild(View view) {
        return InvokeDynamicSupport.bootstrap("getAccessibilityFocusedChild", $$robo$$android_widget_AbsListView$getAccessibilityFocusedChild(android.view.View ), 0, this, view);
    }

    void updateScrollIndicators() {
        InvokeDynamicSupport.bootstrap("updateScrollIndicators", $$robo$$android_widget_AbsListView$updateScrollIndicators(), 0, this);
    }

    private boolean canScrollUp() {
        return (boolean)InvokeDynamicSupport.bootstrap("canScrollUp", $$robo$$android_widget_AbsListView$canScrollUp(), 0, this);
    }

    private boolean canScrollDown() {
        return (boolean)InvokeDynamicSupport.bootstrap("canScrollDown", $$robo$$android_widget_AbsListView$canScrollDown(), 0, this);
    }

    @Override
    @ViewDebug.ExportedProperty
    public View getSelectedView() {
        return InvokeDynamicSupport.bootstrap("getSelectedView", $$robo$$android_widget_AbsListView$getSelectedView(), 0, this);
    }

    public int getListPaddingTop() {
        return (int)InvokeDynamicSupport.bootstrap("getListPaddingTop", $$robo$$android_widget_AbsListView$getListPaddingTop(), 0, this);
    }

    public int getListPaddingBottom() {
        return (int)InvokeDynamicSupport.bootstrap("getListPaddingBottom", $$robo$$android_widget_AbsListView$getListPaddingBottom(), 0, this);
    }

    public int getListPaddingLeft() {
        return (int)InvokeDynamicSupport.bootstrap("getListPaddingLeft", $$robo$$android_widget_AbsListView$getListPaddingLeft(), 0, this);
    }

    public int getListPaddingRight() {
        return (int)InvokeDynamicSupport.bootstrap("getListPaddingRight", $$robo$$android_widget_AbsListView$getListPaddingRight(), 0, this);
    }

    View obtainView(int n, boolean[] blArray) {
        return InvokeDynamicSupport.bootstrap("obtainView", $$robo$$android_widget_AbsListView$obtainView(int boolean[] ), 0, this, n, blArray);
    }

    private void setItemViewLayoutParams(View view, int n) {
        InvokeDynamicSupport.bootstrap("setItemViewLayoutParams", $$robo$$android_widget_AbsListView$setItemViewLayoutParams(android.view.View int ), 0, this, view, n);
    }

    public void onInitializeAccessibilityNodeInfoForItem(View view, int n, AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoForItem", $$robo$$android_widget_AbsListView$onInitializeAccessibilityNodeInfoForItem(android.view.View int android.view.accessibility.AccessibilityNodeInfo ), 0, this, view, n, accessibilityNodeInfo);
    }

    private boolean isItemClickable(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("isItemClickable", $$robo$$android_widget_AbsListView$isItemClickable(android.view.View ), 0, this, view);
    }

    void positionSelectorLikeTouch(int n, View view, float f, float f2) {
        InvokeDynamicSupport.bootstrap("positionSelectorLikeTouch", $$robo$$android_widget_AbsListView$positionSelectorLikeTouch(int android.view.View float float ), 0, this, n, view, f, f2);
    }

    void positionSelectorLikeFocus(int n, View view) {
        InvokeDynamicSupport.bootstrap("positionSelectorLikeFocus", $$robo$$android_widget_AbsListView$positionSelectorLikeFocus(int android.view.View ), 0, this, n, view);
    }

    void positionSelector(int n, View view) {
        InvokeDynamicSupport.bootstrap("positionSelector", $$robo$$android_widget_AbsListView$positionSelector(int android.view.View ), 0, this, n, view);
    }

    private void positionSelector(int n, View view, boolean bl, float f, float f2) {
        InvokeDynamicSupport.bootstrap("positionSelector", $$robo$$android_widget_AbsListView$positionSelector(int android.view.View boolean float float ), 0, this, n, view, bl, f, f2);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("dispatchDraw", $$robo$$android_widget_AbsListView$dispatchDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    protected boolean isPaddingOffsetRequired() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPaddingOffsetRequired", $$robo$$android_widget_AbsListView$isPaddingOffsetRequired(), 0, this);
    }

    @Override
    protected int getLeftPaddingOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getLeftPaddingOffset", $$robo$$android_widget_AbsListView$getLeftPaddingOffset(), 0, this);
    }

    @Override
    protected int getTopPaddingOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getTopPaddingOffset", $$robo$$android_widget_AbsListView$getTopPaddingOffset(), 0, this);
    }

    @Override
    protected int getRightPaddingOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getRightPaddingOffset", $$robo$$android_widget_AbsListView$getRightPaddingOffset(), 0, this);
    }

    @Override
    protected int getBottomPaddingOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getBottomPaddingOffset", $$robo$$android_widget_AbsListView$getBottomPaddingOffset(), 0, this);
    }

    @Override
    protected void internalSetPadding(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("internalSetPadding", $$robo$$android_widget_AbsListView$internalSetPadding(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onSizeChanged", $$robo$$android_widget_AbsListView$onSizeChanged(int int int int ), 0, this, n, n2, n3, n4);
    }

    void handleBoundsChange() {
        InvokeDynamicSupport.bootstrap("handleBoundsChange", $$robo$$android_widget_AbsListView$handleBoundsChange(), 0, this);
    }

    boolean touchModeDrawsInPressedState() {
        return (boolean)InvokeDynamicSupport.bootstrap("touchModeDrawsInPressedState", $$robo$$android_widget_AbsListView$touchModeDrawsInPressedState(), 0, this);
    }

    boolean shouldShowSelector() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldShowSelector", $$robo$$android_widget_AbsListView$shouldShowSelector(), 0, this);
    }

    private void drawSelector(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("drawSelector", $$robo$$android_widget_AbsListView$drawSelector(android.graphics.Canvas ), 0, this, canvas);
    }

    public boolean shouldDrawSelector() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldDrawSelector", $$robo$$android_widget_AbsListView$shouldDrawSelector(), 0, this);
    }

    public void setDrawSelectorOnTop(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDrawSelectorOnTop", $$robo$$android_widget_AbsListView$setDrawSelectorOnTop(boolean ), 0, this, bl);
    }

    public void setSelector(int n) {
        InvokeDynamicSupport.bootstrap("setSelector", $$robo$$android_widget_AbsListView$setSelector(int ), 0, this, n);
    }

    public void setSelector(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setSelector", $$robo$$android_widget_AbsListView$setSelector(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public Drawable getSelector() {
        return InvokeDynamicSupport.bootstrap("getSelector", $$robo$$android_widget_AbsListView$getSelector(), 0, this);
    }

    void keyPressed() {
        InvokeDynamicSupport.bootstrap("keyPressed", $$robo$$android_widget_AbsListView$keyPressed(), 0, this);
    }

    public void setScrollIndicators(View view, View view2) {
        InvokeDynamicSupport.bootstrap("setScrollIndicators", $$robo$$android_widget_AbsListView$setScrollIndicators(android.view.View android.view.View ), 0, this, view, view2);
    }

    void updateSelectorState() {
        InvokeDynamicSupport.bootstrap("updateSelectorState", $$robo$$android_widget_AbsListView$updateSelectorState(), 0, this);
    }

    @Override
    protected void drawableStateChanged() {
        InvokeDynamicSupport.bootstrap("drawableStateChanged", $$robo$$android_widget_AbsListView$drawableStateChanged(), 0, this);
    }

    private int[] getDrawableStateForSelector() {
        return InvokeDynamicSupport.bootstrap("getDrawableStateForSelector", $$robo$$android_widget_AbsListView$getDrawableStateForSelector(), 0, this);
    }

    @Override
    public boolean verifyDrawable(Drawable drawable2) {
        return (boolean)InvokeDynamicSupport.bootstrap("verifyDrawable", $$robo$$android_widget_AbsListView$verifyDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpDrawablesToCurrentState", $$robo$$android_widget_AbsListView$jumpDrawablesToCurrentState(), 0, this);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_widget_AbsListView$onAttachedToWindow(), 0, this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_widget_AbsListView$onDetachedFromWindow(), 0, this);
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onWindowFocusChanged", $$robo$$android_widget_AbsListView$onWindowFocusChanged(boolean ), 0, this, bl);
    }

    @Override
    public void onRtlPropertiesChanged(int n) {
        InvokeDynamicSupport.bootstrap("onRtlPropertiesChanged", $$robo$$android_widget_AbsListView$onRtlPropertiesChanged(int ), 0, this, n);
    }

    ContextMenu.ContextMenuInfo createContextMenuInfo(View view, int n, long l) {
        return InvokeDynamicSupport.bootstrap("createContextMenuInfo", $$robo$$android_widget_AbsListView$createContextMenuInfo(android.view.View int long ), 0, this, view, n, l);
    }

    @Override
    public void onCancelPendingInputEvents() {
        InvokeDynamicSupport.bootstrap("onCancelPendingInputEvents", $$robo$$android_widget_AbsListView$onCancelPendingInputEvents(), 0, this);
    }

    private boolean performStylusButtonPressAction(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("performStylusButtonPressAction", $$robo$$android_widget_AbsListView$performStylusButtonPressAction(android.view.MotionEvent ), 0, this, motionEvent);
    }

    boolean performLongPress(View view, int n, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("performLongPress", $$robo$$android_widget_AbsListView$performLongPress(android.view.View int long ), 0, this, view, n, l);
    }

    boolean performLongPress(View view, int n, long l, float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrap("performLongPress", $$robo$$android_widget_AbsListView$performLongPress(android.view.View int long float float ), 0, this, view, n, l, f, f2);
    }

    @Override
    protected ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return InvokeDynamicSupport.bootstrap("getContextMenuInfo", $$robo$$android_widget_AbsListView$getContextMenuInfo(), 0, this);
    }

    @Override
    public boolean showContextMenu() {
        return (boolean)InvokeDynamicSupport.bootstrap("showContextMenu", $$robo$$android_widget_AbsListView$showContextMenu(), 0, this);
    }

    @Override
    public boolean showContextMenu(float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrap("showContextMenu", $$robo$$android_widget_AbsListView$showContextMenu(float float ), 0, this, f, f2);
    }

    private boolean showContextMenuInternal(float f, float f2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("showContextMenuInternal", $$robo$$android_widget_AbsListView$showContextMenuInternal(float float boolean ), 0, this, f, f2, bl);
    }

    @Override
    public boolean showContextMenuForChild(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("showContextMenuForChild", $$robo$$android_widget_AbsListView$showContextMenuForChild(android.view.View ), 0, this, view);
    }

    @Override
    public boolean showContextMenuForChild(View view, float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrap("showContextMenuForChild", $$robo$$android_widget_AbsListView$showContextMenuForChild(android.view.View float float ), 0, this, view, f, f2);
    }

    private boolean showContextMenuForChildInternal(View view, float f, float f2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("showContextMenuForChildInternal", $$robo$$android_widget_AbsListView$showContextMenuForChildInternal(android.view.View float float boolean ), 0, this, view, f, f2, bl);
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$android_widget_AbsListView$onKeyDown(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyUp", $$robo$$android_widget_AbsListView$onKeyUp(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    @Override
    protected void dispatchSetPressed(boolean bl) {
        InvokeDynamicSupport.bootstrap("dispatchSetPressed", $$robo$$android_widget_AbsListView$dispatchSetPressed(boolean ), 0, this, bl);
    }

    @Override
    public void dispatchDrawableHotspotChanged(float f, float f2) {
        InvokeDynamicSupport.bootstrap("dispatchDrawableHotspotChanged", $$robo$$android_widget_AbsListView$dispatchDrawableHotspotChanged(float float ), 0, this, f, f2);
    }

    public int pointToPosition(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("pointToPosition", $$robo$$android_widget_AbsListView$pointToPosition(int int ), 0, this, n, n2);
    }

    public long pointToRowId(int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("pointToRowId", $$robo$$android_widget_AbsListView$pointToRowId(int int ), 0, this, n, n2);
    }

    private boolean startScrollIfNeeded(int n, int n2, MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("startScrollIfNeeded", $$robo$$android_widget_AbsListView$startScrollIfNeeded(int int android.view.MotionEvent ), 0, this, n, n2, motionEvent);
    }

    private void scrollIfNeeded(int n, int n2, MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("scrollIfNeeded", $$robo$$android_widget_AbsListView$scrollIfNeeded(int int android.view.MotionEvent ), 0, this, n, n2, motionEvent);
    }

    private void invalidateTopGlow() {
        InvokeDynamicSupport.bootstrap("invalidateTopGlow", $$robo$$android_widget_AbsListView$invalidateTopGlow(), 0, this);
    }

    private void invalidateBottomGlow() {
        InvokeDynamicSupport.bootstrap("invalidateBottomGlow", $$robo$$android_widget_AbsListView$invalidateBottomGlow(), 0, this);
    }

    @Override
    public void onTouchModeChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onTouchModeChanged", $$robo$$android_widget_AbsListView$onTouchModeChanged(boolean ), 0, this, bl);
    }

    @Override
    protected boolean handleScrollBarDragging(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleScrollBarDragging", $$robo$$android_widget_AbsListView$handleScrollBarDragging(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_AbsListView$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void onTouchDown(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("onTouchDown", $$robo$$android_widget_AbsListView$onTouchDown(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void onTouchMove(MotionEvent motionEvent, MotionEvent motionEvent2) {
        InvokeDynamicSupport.bootstrap("onTouchMove", $$robo$$android_widget_AbsListView$onTouchMove(android.view.MotionEvent android.view.MotionEvent ), 0, this, motionEvent, motionEvent2);
    }

    private void onTouchUp(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("onTouchUp", $$robo$$android_widget_AbsListView$onTouchUp(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void onTouchCancel() {
        InvokeDynamicSupport.bootstrap("onTouchCancel", $$robo$$android_widget_AbsListView$onTouchCancel(), 0, this);
    }

    @Override
    protected void onOverScrolled(int n, int n2, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("onOverScrolled", $$robo$$android_widget_AbsListView$onOverScrolled(int int boolean boolean ), 0, this, n, n2, bl, bl2);
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onGenericMotionEvent", $$robo$$android_widget_AbsListView$onGenericMotionEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    public void fling(int n) {
        InvokeDynamicSupport.bootstrap("fling", $$robo$$android_widget_AbsListView$fling(int ), 0, this, n);
    }

    @Override
    public boolean onStartNestedScroll(View view, View view2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStartNestedScroll", $$robo$$android_widget_AbsListView$onStartNestedScroll(android.view.View android.view.View int ), 0, this, view, view2, n);
    }

    @Override
    public void onNestedScrollAccepted(View view, View view2, int n) {
        InvokeDynamicSupport.bootstrap("onNestedScrollAccepted", $$robo$$android_widget_AbsListView$onNestedScrollAccepted(android.view.View android.view.View int ), 0, this, view, view2, n);
    }

    @Override
    public void onNestedScroll(View view, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onNestedScroll", $$robo$$android_widget_AbsListView$onNestedScroll(android.view.View int int int int ), 0, this, view, n, n2, n3, n4);
    }

    @Override
    public boolean onNestedFling(View view, float f, float f2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("onNestedFling", $$robo$$android_widget_AbsListView$onNestedFling(android.view.View float float boolean ), 0, this, view, f, f2, bl);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_widget_AbsListView$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    private void initOrResetVelocityTracker() {
        InvokeDynamicSupport.bootstrap("initOrResetVelocityTracker", $$robo$$android_widget_AbsListView$initOrResetVelocityTracker(), 0, this);
    }

    private void initVelocityTrackerIfNotExists() {
        InvokeDynamicSupport.bootstrap("initVelocityTrackerIfNotExists", $$robo$$android_widget_AbsListView$initVelocityTrackerIfNotExists(), 0, this);
    }

    private void recycleVelocityTracker() {
        InvokeDynamicSupport.bootstrap("recycleVelocityTracker", $$robo$$android_widget_AbsListView$recycleVelocityTracker(), 0, this);
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean bl) {
        InvokeDynamicSupport.bootstrap("requestDisallowInterceptTouchEvent", $$robo$$android_widget_AbsListView$requestDisallowInterceptTouchEvent(boolean ), 0, this, bl);
    }

    @Override
    public boolean onInterceptHoverEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onInterceptHoverEvent", $$robo$$android_widget_AbsListView$onInterceptHoverEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public PointerIcon onResolvePointerIcon(MotionEvent motionEvent, int n) {
        return InvokeDynamicSupport.bootstrap("onResolvePointerIcon", $$robo$$android_widget_AbsListView$onResolvePointerIcon(android.view.MotionEvent int ), 0, this, motionEvent, n);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onInterceptTouchEvent", $$robo$$android_widget_AbsListView$onInterceptTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("onSecondaryPointerUp", $$robo$$android_widget_AbsListView$onSecondaryPointerUp(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public void addTouchables(ArrayList<View> arrayList) {
        InvokeDynamicSupport.bootstrap("addTouchables", $$robo$$android_widget_AbsListView$addTouchables(java.util.ArrayList<android.view.View> ), 0, this, arrayList);
    }

    void reportScrollStateChange(int n) {
        InvokeDynamicSupport.bootstrap("reportScrollStateChange", $$robo$$android_widget_AbsListView$reportScrollStateChange(int ), 0, this, n);
    }

    public void setFriction(float f) {
        InvokeDynamicSupport.bootstrap("setFriction", $$robo$$android_widget_AbsListView$setFriction(float ), 0, this, f);
    }

    public void setVelocityScale(float f) {
        InvokeDynamicSupport.bootstrap("setVelocityScale", $$robo$$android_widget_AbsListView$setVelocityScale(float ), 0, this, f);
    }

    AbsPositionScroller createPositionScroller() {
        return InvokeDynamicSupport.bootstrap("createPositionScroller", $$robo$$android_widget_AbsListView$createPositionScroller(), 0, this);
    }

    public void smoothScrollToPosition(int n) {
        InvokeDynamicSupport.bootstrap("smoothScrollToPosition", $$robo$$android_widget_AbsListView$smoothScrollToPosition(int ), 0, this, n);
    }

    public void smoothScrollToPositionFromTop(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("smoothScrollToPositionFromTop", $$robo$$android_widget_AbsListView$smoothScrollToPositionFromTop(int int int ), 0, this, n, n2, n3);
    }

    public void smoothScrollToPositionFromTop(int n, int n2) {
        InvokeDynamicSupport.bootstrap("smoothScrollToPositionFromTop", $$robo$$android_widget_AbsListView$smoothScrollToPositionFromTop(int int ), 0, this, n, n2);
    }

    public void smoothScrollToPosition(int n, int n2) {
        InvokeDynamicSupport.bootstrap("smoothScrollToPosition", $$robo$$android_widget_AbsListView$smoothScrollToPosition(int int ), 0, this, n, n2);
    }

    public void smoothScrollBy(int n, int n2) {
        InvokeDynamicSupport.bootstrap("smoothScrollBy", $$robo$$android_widget_AbsListView$smoothScrollBy(int int ), 0, this, n, n2);
    }

    void smoothScrollBy(int n, int n2, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("smoothScrollBy", $$robo$$android_widget_AbsListView$smoothScrollBy(int int boolean boolean ), 0, this, n, n2, bl, bl2);
    }

    void smoothScrollByOffset(int n) {
        InvokeDynamicSupport.bootstrap("smoothScrollByOffset", $$robo$$android_widget_AbsListView$smoothScrollByOffset(int ), 0, this, n);
    }

    private void createScrollingCache() {
        InvokeDynamicSupport.bootstrap("createScrollingCache", $$robo$$android_widget_AbsListView$createScrollingCache(), 0, this);
    }

    private void clearScrollingCache() {
        InvokeDynamicSupport.bootstrap("clearScrollingCache", $$robo$$android_widget_AbsListView$clearScrollingCache(), 0, this);
    }

    public void scrollListBy(int n) {
        InvokeDynamicSupport.bootstrap("scrollListBy", $$robo$$android_widget_AbsListView$scrollListBy(int ), 0, this, n);
    }

    public boolean canScrollList(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("canScrollList", $$robo$$android_widget_AbsListView$canScrollList(int ), 0, this, n);
    }

    boolean trackMotionScroll(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("trackMotionScroll", $$robo$$android_widget_AbsListView$trackMotionScroll(int int ), 0, this, n, n2);
    }

    int getHeaderViewsCount() {
        return (int)InvokeDynamicSupport.bootstrap("getHeaderViewsCount", $$robo$$android_widget_AbsListView$getHeaderViewsCount(), 0, this);
    }

    int getFooterViewsCount() {
        return (int)InvokeDynamicSupport.bootstrap("getFooterViewsCount", $$robo$$android_widget_AbsListView$getFooterViewsCount(), 0, this);
    }

    void hideSelector() {
        InvokeDynamicSupport.bootstrap("hideSelector", $$robo$$android_widget_AbsListView$hideSelector(), 0, this);
    }

    int reconcileSelectedPosition() {
        return (int)InvokeDynamicSupport.bootstrap("reconcileSelectedPosition", $$robo$$android_widget_AbsListView$reconcileSelectedPosition(), 0, this);
    }

    int findClosestMotionRow(int n) {
        return (int)InvokeDynamicSupport.bootstrap("findClosestMotionRow", $$robo$$android_widget_AbsListView$findClosestMotionRow(int ), 0, this, n);
    }

    public void invalidateViews() {
        InvokeDynamicSupport.bootstrap("invalidateViews", $$robo$$android_widget_AbsListView$invalidateViews(), 0, this);
    }

    boolean resurrectSelectionIfNeeded() {
        return (boolean)InvokeDynamicSupport.bootstrap("resurrectSelectionIfNeeded", $$robo$$android_widget_AbsListView$resurrectSelectionIfNeeded(), 0, this);
    }

    boolean resurrectSelection() {
        return (boolean)InvokeDynamicSupport.bootstrap("resurrectSelection", $$robo$$android_widget_AbsListView$resurrectSelection(), 0, this);
    }

    void confirmCheckedPositionsById() {
        InvokeDynamicSupport.bootstrap("confirmCheckedPositionsById", $$robo$$android_widget_AbsListView$confirmCheckedPositionsById(), 0, this);
    }

    @Override
    protected void handleDataChanged() {
        InvokeDynamicSupport.bootstrap("handleDataChanged", $$robo$$android_widget_AbsListView$handleDataChanged(), 0, this);
    }

    @Override
    protected void onDisplayHint(int n) {
        InvokeDynamicSupport.bootstrap("onDisplayHint", $$robo$$android_widget_AbsListView$onDisplayHint(int ), 0, this, n);
    }

    private void dismissPopup() {
        InvokeDynamicSupport.bootstrap("dismissPopup", $$robo$$android_widget_AbsListView$dismissPopup(), 0, this);
    }

    private void showPopup() {
        InvokeDynamicSupport.bootstrap("showPopup", $$robo$$android_widget_AbsListView$showPopup(), 0, this);
    }

    private void positionPopup() {
        InvokeDynamicSupport.bootstrap("positionPopup", $$robo$$android_widget_AbsListView$positionPopup(), 0, this);
    }

    static int getDistance(Rect rect, Rect rect2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDistance", $$robo$$android_widget_AbsListView$getDistance(android.graphics.Rect android.graphics.Rect int ), 0, (Rect)rect, (Rect)rect2, (int)n);
    }

    @Override
    protected boolean isInFilterMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInFilterMode", $$robo$$android_widget_AbsListView$isInFilterMode(), 0, this);
    }

    boolean sendToTextFilter(int n, int n2, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendToTextFilter", $$robo$$android_widget_AbsListView$sendToTextFilter(int int android.view.KeyEvent ), 0, this, n, n2, keyEvent);
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        return InvokeDynamicSupport.bootstrap("onCreateInputConnection", $$robo$$android_widget_AbsListView$onCreateInputConnection(android.view.inputmethod.EditorInfo ), 0, this, editorInfo);
    }

    @Override
    public boolean checkInputConnectionProxy(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkInputConnectionProxy", $$robo$$android_widget_AbsListView$checkInputConnectionProxy(android.view.View ), 0, this, view);
    }

    private void createTextFilter(boolean bl) {
        InvokeDynamicSupport.bootstrap("createTextFilter", $$robo$$android_widget_AbsListView$createTextFilter(boolean ), 0, this, bl);
    }

    private EditText getTextFilterInput() {
        return InvokeDynamicSupport.bootstrap("getTextFilterInput", $$robo$$android_widget_AbsListView$getTextFilterInput(), 0, this);
    }

    public void clearTextFilter() {
        InvokeDynamicSupport.bootstrap("clearTextFilter", $$robo$$android_widget_AbsListView$clearTextFilter(), 0, this);
    }

    public boolean hasTextFilter() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasTextFilter", $$robo$$android_widget_AbsListView$hasTextFilter(), 0, this);
    }

    @Override
    public void onGlobalLayout() {
        InvokeDynamicSupport.bootstrap("onGlobalLayout", $$robo$$android_widget_AbsListView$onGlobalLayout(), 0, this);
    }

    @Override
    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("beforeTextChanged", $$robo$$android_widget_AbsListView$beforeTextChanged(java.lang.CharSequence int int int ), 0, this, charSequence, n, n2, n3);
    }

    @Override
    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("onTextChanged", $$robo$$android_widget_AbsListView$onTextChanged(java.lang.CharSequence int int int ), 0, this, charSequence, n, n2, n3);
    }

    @Override
    public void afterTextChanged(Editable editable) {
        InvokeDynamicSupport.bootstrap("afterTextChanged", $$robo$$android_widget_AbsListView$afterTextChanged(android.text.Editable ), 0, this, editable);
    }

    @Override
    public void onFilterComplete(int n) {
        InvokeDynamicSupport.bootstrap("onFilterComplete", $$robo$$android_widget_AbsListView$onFilterComplete(int ), 0, this, n);
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return InvokeDynamicSupport.bootstrap("generateDefaultLayoutParams", $$robo$$android_widget_AbsListView$generateDefaultLayoutParams(), 0, this);
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$android_widget_AbsListView$generateLayoutParams(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$android_widget_AbsListView$generateLayoutParams(android.util.AttributeSet ), 0, this, attributeSet);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkLayoutParams", $$robo$$android_widget_AbsListView$checkLayoutParams(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
    }

    public void setTranscriptMode(int n) {
        InvokeDynamicSupport.bootstrap("setTranscriptMode", $$robo$$android_widget_AbsListView$setTranscriptMode(int ), 0, this, n);
    }

    public int getTranscriptMode() {
        return (int)InvokeDynamicSupport.bootstrap("getTranscriptMode", $$robo$$android_widget_AbsListView$getTranscriptMode(), 0, this);
    }

    @Override
    public int getSolidColor() {
        return (int)InvokeDynamicSupport.bootstrap("getSolidColor", $$robo$$android_widget_AbsListView$getSolidColor(), 0, this);
    }

    public void setCacheColorHint(int n) {
        InvokeDynamicSupport.bootstrap("setCacheColorHint", $$robo$$android_widget_AbsListView$setCacheColorHint(int ), 0, this, n);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public int getCacheColorHint() {
        return (int)InvokeDynamicSupport.bootstrap("getCacheColorHint", $$robo$$android_widget_AbsListView$getCacheColorHint(), 0, this);
    }

    public void reclaimViews(List<View> list) {
        InvokeDynamicSupport.bootstrap("reclaimViews", $$robo$$android_widget_AbsListView$reclaimViews(java.util.List<android.view.View> ), 0, this, list);
    }

    private void finishGlows() {
        InvokeDynamicSupport.bootstrap("finishGlows", $$robo$$android_widget_AbsListView$finishGlows(), 0, this);
    }

    public void setRemoteViewsAdapter(Intent intent) {
        InvokeDynamicSupport.bootstrap("setRemoteViewsAdapter", $$robo$$android_widget_AbsListView$setRemoteViewsAdapter(android.content.Intent ), 0, this, intent);
    }

    public Runnable setRemoteViewsAdapterAsync(Intent intent) {
        return InvokeDynamicSupport.bootstrap("setRemoteViewsAdapterAsync", $$robo$$android_widget_AbsListView$setRemoteViewsAdapterAsync(android.content.Intent ), 0, this, intent);
    }

    @Override
    public void setRemoteViewsAdapter(Intent intent, boolean bl) {
        InvokeDynamicSupport.bootstrap("setRemoteViewsAdapter", $$robo$$android_widget_AbsListView$setRemoteViewsAdapter(android.content.Intent boolean ), 0, this, intent, bl);
    }

    public void setRemoteViewsOnClickHandler(RemoteViews.OnClickHandler onClickHandler) {
        InvokeDynamicSupport.bootstrap("setRemoteViewsOnClickHandler", $$robo$$android_widget_AbsListView$setRemoteViewsOnClickHandler(android.widget.RemoteViews$OnClickHandler ), 0, this, onClickHandler);
    }

    @Override
    public void deferNotifyDataSetChanged() {
        InvokeDynamicSupport.bootstrap("deferNotifyDataSetChanged", $$robo$$android_widget_AbsListView$deferNotifyDataSetChanged(), 0, this);
    }

    @Override
    public boolean onRemoteAdapterConnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("onRemoteAdapterConnected", $$robo$$android_widget_AbsListView$onRemoteAdapterConnected(), 0, this);
    }

    @Override
    public void onRemoteAdapterDisconnected() {
        InvokeDynamicSupport.bootstrap("onRemoteAdapterDisconnected", $$robo$$android_widget_AbsListView$onRemoteAdapterDisconnected(), 0, this);
    }

    void setVisibleRangeHint(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setVisibleRangeHint", $$robo$$android_widget_AbsListView$setVisibleRangeHint(int int ), 0, this, n, n2);
    }

    public void setRecyclerListener(RecyclerListener recyclerListener) {
        InvokeDynamicSupport.bootstrap("setRecyclerListener", $$robo$$android_widget_AbsListView$setRecyclerListener(android.widget.AbsListView$RecyclerListener ), 0, this, recyclerListener);
    }

    int getHeightForPosition(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getHeightForPosition", $$robo$$android_widget_AbsListView$getHeightForPosition(int ), 0, this, n);
    }

    public void setSelectionFromTop(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setSelectionFromTop", $$robo$$android_widget_AbsListView$setSelectionFromTop(int int ), 0, this, n, n2);
    }

    @Override
    protected void encodeProperties(ViewHierarchyEncoder viewHierarchyEncoder) {
        InvokeDynamicSupport.bootstrap("encodeProperties", $$robo$$android_widget_AbsListView$encodeProperties(android.view.ViewHierarchyEncoder ), 0, this, viewHierarchyEncoder);
    }

    static {
        RobolectricInternals.classInitializing(AbsListView.class);
    }

    public /* synthetic */ AbsListView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbsListView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class PositionScroller
    extends AbsPositionScroller
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int SCROLL_DURATION = 200;
        private static int MOVE_DOWN_POS = 1;
        private static int MOVE_UP_POS = 2;
        private static int MOVE_DOWN_BOUND = 3;
        private static int MOVE_UP_BOUND = 4;
        private static int MOVE_OFFSET = 5;
        private int mMode;
        private int mTargetPos;
        private int mBoundPos;
        private int mLastSeenPos;
        private int mScrollDuration;
        private int mExtraScroll;
        private int mOffsetFromTop;
        /* synthetic */ AbsListView this$0;

        private void $$robo$$android_widget_AbsListView_PositionScroller$__constructor__(AbsListView this$0) {
            this.mExtraScroll = ViewConfiguration.get(this$0.mContext).getScaledFadingEdgeLength();
        }

        private final void $$robo$$android_widget_AbsListView_PositionScroller$start(int position) {
            int viewTravelCount;
            this.stop();
            if (this.this$0.mDataChanged) {
                this.this$0.mPositionScrollAfterLayout = new Runnable(this, position){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$position;
                    /* synthetic */ PositionScroller this$1;

                    private void $$robo$$android_widget_AbsListView_PositionScroller_1$__constructor__(PositionScroller this$1, int n) {
                    }

                    private final void $$robo$$android_widget_AbsListView_PositionScroller_1$run() {
                        this.this$1.start(this.val$position);
                    }

                    private void __constructor__(PositionScroller positionScroller, int n) {
                        this.$$robo$$android_widget_AbsListView_PositionScroller_1$__constructor__(positionScroller, n);
                    }
                    {
                        this.this$1 = positionScroller;
                        this.val$position = n;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_PositionScroller_1$__constructor__(android.widget.AbsListView$PositionScroller int ), 0, this, positionScroller, n);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_AbsListView_PositionScroller_1$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
                return;
            }
            int childCount = this.this$0.getChildCount();
            if (childCount == 0) {
                return;
            }
            int firstPos = this.this$0.mFirstPosition;
            int lastPos = firstPos + childCount - 1;
            int clampedPosition = Math.max(0, Math.min(this.this$0.getCount() - 1, position));
            if (clampedPosition < firstPos) {
                viewTravelCount = firstPos - clampedPosition + 1;
                this.mMode = 2;
            } else if (clampedPosition > lastPos) {
                viewTravelCount = clampedPosition - lastPos + 1;
                this.mMode = 1;
            } else {
                this.scrollToVisible(clampedPosition, -1, 200);
                return;
            }
            this.mScrollDuration = viewTravelCount > 0 ? 200 / viewTravelCount : 200;
            this.mTargetPos = clampedPosition;
            this.mBoundPos = -1;
            this.mLastSeenPos = -1;
            this.this$0.postOnAnimation(this);
        }

        private final void $$robo$$android_widget_AbsListView_PositionScroller$start(int position, int boundPosition) {
            int viewTravelCount;
            this.stop();
            if (boundPosition == -1) {
                this.start(position);
                return;
            }
            if (this.this$0.mDataChanged) {
                this.this$0.mPositionScrollAfterLayout = new Runnable(this, position, boundPosition){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$position;
                    /* synthetic */ int val$boundPosition;
                    /* synthetic */ PositionScroller this$1;

                    private void $$robo$$android_widget_AbsListView_PositionScroller_2$__constructor__(PositionScroller this$1, int n, int n2) {
                    }

                    private final void $$robo$$android_widget_AbsListView_PositionScroller_2$run() {
                        this.this$1.start(this.val$position, this.val$boundPosition);
                    }

                    private void __constructor__(PositionScroller positionScroller, int n, int n2) {
                        this.$$robo$$android_widget_AbsListView_PositionScroller_2$__constructor__(positionScroller, n, n2);
                    }
                    {
                        this.this$1 = positionScroller;
                        this.val$position = n;
                        this.val$boundPosition = n2;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_PositionScroller_2$__constructor__(android.widget.AbsListView$PositionScroller int int ), 0, this, positionScroller, n, n2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_AbsListView_PositionScroller_2$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
                return;
            }
            int childCount = this.this$0.getChildCount();
            if (childCount == 0) {
                return;
            }
            int firstPos = this.this$0.mFirstPosition;
            int lastPos = firstPos + childCount - 1;
            int clampedPosition = Math.max(0, Math.min(this.this$0.getCount() - 1, position));
            if (clampedPosition < firstPos) {
                int boundPosFromLast = lastPos - boundPosition;
                if (boundPosFromLast < 1) {
                    return;
                }
                int boundTravel = boundPosFromLast - 1;
                int posTravel = firstPos - clampedPosition + 1;
                if (boundTravel < posTravel) {
                    viewTravelCount = boundTravel;
                    this.mMode = 4;
                } else {
                    viewTravelCount = posTravel;
                    this.mMode = 2;
                }
            } else if (clampedPosition > lastPos) {
                int boundPosFromFirst = boundPosition - firstPos;
                if (boundPosFromFirst < 1) {
                    return;
                }
                int boundTravel = boundPosFromFirst - 1;
                int posTravel = clampedPosition - lastPos + 1;
                if (boundTravel < posTravel) {
                    viewTravelCount = boundTravel;
                    this.mMode = 3;
                } else {
                    viewTravelCount = posTravel;
                    this.mMode = 1;
                }
            } else {
                this.scrollToVisible(clampedPosition, boundPosition, 200);
                return;
            }
            this.mScrollDuration = viewTravelCount > 0 ? 200 / viewTravelCount : 200;
            this.mTargetPos = clampedPosition;
            this.mBoundPos = boundPosition;
            this.mLastSeenPos = -1;
            this.this$0.postOnAnimation(this);
        }

        private final void $$robo$$android_widget_AbsListView_PositionScroller$startWithOffset(int position, int offset) {
            this.startWithOffset(position, offset, 200);
        }

        private final void $$robo$$android_widget_AbsListView_PositionScroller$startWithOffset(int position, int offset, int duration) {
            int viewTravelCount;
            this.stop();
            if (this.this$0.mDataChanged) {
                int postOffset = offset;
                this.this$0.mPositionScrollAfterLayout = new Runnable(this, position, postOffset, duration){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$position;
                    /* synthetic */ int val$postOffset;
                    /* synthetic */ int val$duration;
                    /* synthetic */ PositionScroller this$1;

                    private void $$robo$$android_widget_AbsListView_PositionScroller_3$__constructor__(PositionScroller this$1, int n, int n2, int n3) {
                    }

                    private final void $$robo$$android_widget_AbsListView_PositionScroller_3$run() {
                        this.this$1.startWithOffset(this.val$position, this.val$postOffset, this.val$duration);
                    }

                    private void __constructor__(PositionScroller positionScroller, int n, int n2, int n3) {
                        this.$$robo$$android_widget_AbsListView_PositionScroller_3$__constructor__(positionScroller, n, n2, n3);
                    }
                    {
                        this.this$1 = positionScroller;
                        this.val$position = n;
                        this.val$postOffset = n2;
                        this.val$duration = n3;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_PositionScroller_3$__constructor__(android.widget.AbsListView$PositionScroller int int int ), 0, this, positionScroller, n, n2, n3);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_AbsListView_PositionScroller_3$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
                return;
            }
            int childCount = this.this$0.getChildCount();
            if (childCount == 0) {
                return;
            }
            this.mTargetPos = Math.max(0, Math.min(this.this$0.getCount() - 1, position));
            this.mOffsetFromTop = offset += this.this$0.getPaddingTop();
            this.mBoundPos = -1;
            this.mLastSeenPos = -1;
            this.mMode = 5;
            int firstPos = this.this$0.mFirstPosition;
            int lastPos = firstPos + childCount - 1;
            if (this.mTargetPos < firstPos) {
                viewTravelCount = firstPos - this.mTargetPos;
            } else if (this.mTargetPos > lastPos) {
                viewTravelCount = this.mTargetPos - lastPos;
            } else {
                int targetTop = this.this$0.getChildAt(this.mTargetPos - firstPos).getTop();
                this.this$0.smoothScrollBy(targetTop - offset, duration, true, false);
                return;
            }
            float screenTravelCount = (float)viewTravelCount / (float)childCount;
            this.mScrollDuration = screenTravelCount < 1.0f ? duration : (int)((float)duration / screenTravelCount);
            this.mLastSeenPos = -1;
            this.this$0.postOnAnimation(this);
        }

        private final void $$robo$$android_widget_AbsListView_PositionScroller$scrollToVisible(int targetPos, int boundPos, int duration) {
            int firstPos = this.this$0.mFirstPosition;
            int childCount = this.this$0.getChildCount();
            int lastPos = firstPos + childCount - 1;
            int paddedTop = this.this$0.mListPadding.top;
            int paddedBottom = this.this$0.getHeight() - this.this$0.mListPadding.bottom;
            if (targetPos < firstPos || targetPos > lastPos) {
                Log.w("AbsListView", "scrollToVisible called with targetPos " + targetPos + " not visible [" + firstPos + ", " + lastPos + "]");
            }
            if (boundPos < firstPos || boundPos > lastPos) {
                boundPos = -1;
            }
            View targetChild = this.this$0.getChildAt(targetPos - firstPos);
            int targetTop = targetChild.getTop();
            int targetBottom = targetChild.getBottom();
            int scrollBy = 0;
            if (targetBottom > paddedBottom) {
                scrollBy = targetBottom - paddedBottom;
            }
            if (targetTop < paddedTop) {
                scrollBy = targetTop - paddedTop;
            }
            if (scrollBy == 0) {
                return;
            }
            if (boundPos >= 0) {
                View boundChild = this.this$0.getChildAt(boundPos - firstPos);
                int boundTop = boundChild.getTop();
                int boundBottom = boundChild.getBottom();
                int absScroll = Math.abs(scrollBy);
                if (scrollBy < 0 && boundBottom + absScroll > paddedBottom) {
                    scrollBy = Math.max(0, boundBottom - paddedBottom);
                } else if (scrollBy > 0 && boundTop - absScroll < paddedTop) {
                    scrollBy = Math.min(0, boundTop - paddedTop);
                }
            }
            this.this$0.smoothScrollBy(scrollBy, duration);
        }

        private final void $$robo$$android_widget_AbsListView_PositionScroller$stop() {
            this.this$0.removeCallbacks(this);
        }

        private final void $$robo$$android_widget_AbsListView_PositionScroller$run() {
            int listHeight = this.this$0.getHeight();
            int firstPos = this.this$0.mFirstPosition;
            switch (this.mMode) {
                case 1: {
                    int lastViewIndex = this.this$0.getChildCount() - 1;
                    int lastPos = firstPos + lastViewIndex;
                    if (lastViewIndex < 0) {
                        return;
                    }
                    if (lastPos == this.mLastSeenPos) {
                        this.this$0.postOnAnimation(this);
                        return;
                    }
                    View lastView = this.this$0.getChildAt(lastViewIndex);
                    int lastViewHeight = lastView.getHeight();
                    int lastViewTop = lastView.getTop();
                    int lastViewPixelsShowing = listHeight - lastViewTop;
                    int extraScroll = lastPos < this.this$0.mItemCount - 1 ? Math.max(this.this$0.mListPadding.bottom, this.mExtraScroll) : this.this$0.mListPadding.bottom;
                    int scrollBy = lastViewHeight - lastViewPixelsShowing + extraScroll;
                    this.this$0.smoothScrollBy(scrollBy, this.mScrollDuration, true, lastPos < this.mTargetPos);
                    this.mLastSeenPos = lastPos;
                    if (lastPos >= this.mTargetPos) break;
                    this.this$0.postOnAnimation(this);
                    break;
                }
                case 3: {
                    boolean nextViewIndex = true;
                    int childCount = this.this$0.getChildCount();
                    if (firstPos == this.mBoundPos || childCount <= 1 || firstPos + childCount >= this.this$0.mItemCount) {
                        this.this$0.reportScrollStateChange(0);
                        return;
                    }
                    int nextPos = firstPos + 1;
                    if (nextPos == this.mLastSeenPos) {
                        this.this$0.postOnAnimation(this);
                        return;
                    }
                    View nextView = this.this$0.getChildAt(1);
                    int nextViewHeight = nextView.getHeight();
                    int nextViewTop = nextView.getTop();
                    int extraScroll = Math.max(this.this$0.mListPadding.bottom, this.mExtraScroll);
                    if (nextPos < this.mBoundPos) {
                        this.this$0.smoothScrollBy(Math.max(0, nextViewHeight + nextViewTop - extraScroll), this.mScrollDuration, true, true);
                        this.mLastSeenPos = nextPos;
                        this.this$0.postOnAnimation(this);
                        break;
                    }
                    if (nextViewTop > extraScroll) {
                        this.this$0.smoothScrollBy(nextViewTop - extraScroll, this.mScrollDuration, true, false);
                        break;
                    }
                    this.this$0.reportScrollStateChange(0);
                    break;
                }
                case 2: {
                    if (firstPos == this.mLastSeenPos) {
                        this.this$0.postOnAnimation(this);
                        return;
                    }
                    View firstView = this.this$0.getChildAt(0);
                    if (firstView == null) {
                        return;
                    }
                    int firstViewTop = firstView.getTop();
                    int extraScroll = firstPos > 0 ? Math.max(this.mExtraScroll, this.this$0.mListPadding.top) : this.this$0.mListPadding.top;
                    this.this$0.smoothScrollBy(firstViewTop - extraScroll, this.mScrollDuration, true, firstPos > this.mTargetPos);
                    this.mLastSeenPos = firstPos;
                    if (firstPos <= this.mTargetPos) break;
                    this.this$0.postOnAnimation(this);
                    break;
                }
                case 4: {
                    int lastViewIndex = this.this$0.getChildCount() - 2;
                    if (lastViewIndex < 0) {
                        return;
                    }
                    int lastPos = firstPos + lastViewIndex;
                    if (lastPos == this.mLastSeenPos) {
                        this.this$0.postOnAnimation(this);
                        return;
                    }
                    View lastView = this.this$0.getChildAt(lastViewIndex);
                    int lastViewHeight = lastView.getHeight();
                    int lastViewTop = lastView.getTop();
                    int lastViewPixelsShowing = listHeight - lastViewTop;
                    int extraScroll = Math.max(this.this$0.mListPadding.top, this.mExtraScroll);
                    this.mLastSeenPos = lastPos;
                    if (lastPos > this.mBoundPos) {
                        this.this$0.smoothScrollBy(-(lastViewPixelsShowing - extraScroll), this.mScrollDuration, true, true);
                        this.this$0.postOnAnimation(this);
                        break;
                    }
                    int bottom = listHeight - extraScroll;
                    int lastViewBottom = lastViewTop + lastViewHeight;
                    if (bottom > lastViewBottom) {
                        this.this$0.smoothScrollBy(-(bottom - lastViewBottom), this.mScrollDuration, true, false);
                        break;
                    }
                    this.this$0.reportScrollStateChange(0);
                    break;
                }
                case 5: {
                    if (this.mLastSeenPos == firstPos) {
                        this.this$0.postOnAnimation(this);
                        return;
                    }
                    this.mLastSeenPos = firstPos;
                    int childCount = this.this$0.getChildCount();
                    int position = this.mTargetPos;
                    int lastPos = firstPos + childCount - 1;
                    View firstChild = this.this$0.getChildAt(0);
                    int firstChildHeight = firstChild.getHeight();
                    View lastChild = this.this$0.getChildAt(childCount - 1);
                    int lastChildHeight = lastChild.getHeight();
                    float firstPositionVisiblePart = (float)firstChildHeight == 0.0f ? 1.0f : (float)(firstChildHeight + firstChild.getTop()) / (float)firstChildHeight;
                    float lastPositionVisiblePart = (float)lastChildHeight == 0.0f ? 1.0f : (float)(lastChildHeight + this.this$0.getHeight() - lastChild.getBottom()) / (float)lastChildHeight;
                    float viewTravelCount = 0.0f;
                    if (position < firstPos) {
                        viewTravelCount = (float)(firstPos - position) + (1.0f - firstPositionVisiblePart) + 1.0f;
                    } else if (position > lastPos) {
                        viewTravelCount = (float)(position - lastPos) + (1.0f - lastPositionVisiblePart);
                    }
                    float screenTravelCount = viewTravelCount / (float)childCount;
                    float modifier = Math.min(Math.abs(screenTravelCount), 1.0f);
                    if (position < firstPos) {
                        int distance = (int)((float)(-this.this$0.getHeight()) * modifier);
                        int duration = (int)((float)this.mScrollDuration * modifier);
                        this.this$0.smoothScrollBy(distance, duration, true, true);
                        this.this$0.postOnAnimation(this);
                        break;
                    }
                    if (position > lastPos) {
                        int distance = (int)((float)this.this$0.getHeight() * modifier);
                        int duration = (int)((float)this.mScrollDuration * modifier);
                        this.this$0.smoothScrollBy(distance, duration, true, true);
                        this.this$0.postOnAnimation(this);
                        break;
                    }
                    int targetTop = this.this$0.getChildAt(position - firstPos).getTop();
                    int distance = targetTop - this.mOffsetFromTop;
                    int duration = (int)((float)this.mScrollDuration * ((float)Math.abs(distance) / (float)this.this$0.getHeight()));
                    this.this$0.smoothScrollBy(distance, duration, true, false);
                    break;
                }
            }
        }

        private void __constructor__(AbsListView absListView) {
            this.$$robo$$android_widget_AbsListView_PositionScroller$__constructor__(absListView);
        }

        PositionScroller(AbsListView absListView) {
            this.this$0 = absListView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_PositionScroller$__constructor__(android.widget.AbsListView ), 0, this, absListView);
        }

        @Override
        public void start(int n) {
            InvokeDynamicSupport.bootstrap("start", $$robo$$android_widget_AbsListView_PositionScroller$start(int ), 0, this, n);
        }

        @Override
        public void start(int n, int n2) {
            InvokeDynamicSupport.bootstrap("start", $$robo$$android_widget_AbsListView_PositionScroller$start(int int ), 0, this, n, n2);
        }

        @Override
        public void startWithOffset(int n, int n2) {
            InvokeDynamicSupport.bootstrap("startWithOffset", $$robo$$android_widget_AbsListView_PositionScroller$startWithOffset(int int ), 0, this, n, n2);
        }

        @Override
        public void startWithOffset(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("startWithOffset", $$robo$$android_widget_AbsListView_PositionScroller$startWithOffset(int int int ), 0, this, n, n2, n3);
        }

        private void scrollToVisible(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("scrollToVisible", $$robo$$android_widget_AbsListView_PositionScroller$scrollToVisible(int int int ), 0, this, n, n2, n3);
        }

        @Override
        public void stop() {
            InvokeDynamicSupport.bootstrap("stop", $$robo$$android_widget_AbsListView_PositionScroller$stop(), 0, this);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_AbsListView_PositionScroller$run(), 0, this);
        }

        public /* synthetic */ PositionScroller() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PositionScroller)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class AbsPositionScroller
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_widget_AbsListView_AbsPositionScroller$__constructor__() {
        }

        public abstract void start(int var1);

        public abstract void start(int var1, int var2);

        public abstract void startWithOffset(int var1, int var2);

        public abstract void startWithOffset(int var1, int var2, int var3);

        public abstract void stop();

        private void __constructor__() {
            this.$$robo$$android_widget_AbsListView_AbsPositionScroller$__constructor__();
        }

        AbsPositionScroller() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_AbsPositionScroller$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbsPositionScroller)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class RecycleBin
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private RecyclerListener mRecyclerListener;
        private int mFirstActivePosition;
        private View[] mActiveViews;
        private ArrayList<View>[] mScrapViews;
        private int mViewTypeCount;
        private ArrayList<View> mCurrentScrap;
        private ArrayList<View> mSkippedScrap;
        private SparseArray<View> mTransientStateViews;
        private LongSparseArray<View> mTransientStateViewsById;
        /* synthetic */ AbsListView this$0;

        private void $$robo$$android_widget_AbsListView_RecycleBin$__constructor__(AbsListView this$0) {
            this.mActiveViews = new View[0];
        }

        private final void $$robo$$android_widget_AbsListView_RecycleBin$setViewTypeCount(int viewTypeCount) {
            if (viewTypeCount < 1) {
                throw new IllegalArgumentException("Can't have a viewTypeCount < 1");
            }
            ArrayList[] scrapViews = new ArrayList[viewTypeCount];
            for (int i = 0; i < viewTypeCount; ++i) {
                scrapViews[i] = new ArrayList();
            }
            this.mViewTypeCount = viewTypeCount;
            this.mCurrentScrap = scrapViews[0];
            this.mScrapViews = scrapViews;
        }

        private final void $$robo$$android_widget_AbsListView_RecycleBin$markChildrenDirty() {
            int i;
            if (this.mViewTypeCount == 1) {
                ArrayList<View> scrap = this.mCurrentScrap;
                int scrapCount = scrap.size();
                for (int i2 = 0; i2 < scrapCount; ++i2) {
                    scrap.get(i2).forceLayout();
                }
            } else {
                int typeCount = this.mViewTypeCount;
                for (i = 0; i < typeCount; ++i) {
                    ArrayList<View> scrap = this.mScrapViews[i];
                    int scrapCount = scrap.size();
                    for (int j = 0; j < scrapCount; ++j) {
                        scrap.get(j).forceLayout();
                    }
                }
            }
            if (this.mTransientStateViews != null) {
                int count = this.mTransientStateViews.size();
                for (i = 0; i < count; ++i) {
                    this.mTransientStateViews.valueAt(i).forceLayout();
                }
            }
            if (this.mTransientStateViewsById != null) {
                int count = this.mTransientStateViewsById.size();
                for (i = 0; i < count; ++i) {
                    this.mTransientStateViewsById.valueAt(i).forceLayout();
                }
            }
        }

        private final boolean $$robo$$android_widget_AbsListView_RecycleBin$shouldRecycleViewType(int viewType) {
            return viewType >= 0;
        }

        private final void $$robo$$android_widget_AbsListView_RecycleBin$clear() {
            if (this.mViewTypeCount == 1) {
                ArrayList<View> scrap = this.mCurrentScrap;
                this.clearScrap(scrap);
            } else {
                int typeCount = this.mViewTypeCount;
                for (int i = 0; i < typeCount; ++i) {
                    ArrayList<View> scrap = this.mScrapViews[i];
                    this.clearScrap(scrap);
                }
            }
            this.clearTransientStateViews();
        }

        private final void $$robo$$android_widget_AbsListView_RecycleBin$fillActiveViews(int childCount, int firstActivePosition) {
            if (this.mActiveViews.length < childCount) {
                this.mActiveViews = new View[childCount];
            }
            this.mFirstActivePosition = firstActivePosition;
            View[] activeViews = this.mActiveViews;
            for (int i = 0; i < childCount; ++i) {
                View child = this.this$0.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp == null || lp.viewType == -2) continue;
                activeViews[i] = child;
                lp.scrappedFromPosition = firstActivePosition + i;
            }
        }

        private final View $$robo$$android_widget_AbsListView_RecycleBin$getActiveView(int position) {
            int index = position - this.mFirstActivePosition;
            View[] activeViews = this.mActiveViews;
            if (index >= 0 && index < activeViews.length) {
                View match = activeViews[index];
                activeViews[index] = null;
                return match;
            }
            return null;
        }

        private final View $$robo$$android_widget_AbsListView_RecycleBin$getTransientStateView(int position) {
            int index;
            if (this.this$0.mAdapter != null && this.this$0.mAdapterHasStableIds && this.mTransientStateViewsById != null) {
                long id2 = this.this$0.mAdapter.getItemId(position);
                View result = this.mTransientStateViewsById.get(id2);
                this.mTransientStateViewsById.remove(id2);
                return result;
            }
            if (this.mTransientStateViews != null && (index = this.mTransientStateViews.indexOfKey(position)) >= 0) {
                View result = this.mTransientStateViews.valueAt(index);
                this.mTransientStateViews.removeAt(index);
                return result;
            }
            return null;
        }

        private final void $$robo$$android_widget_AbsListView_RecycleBin$clearTransientStateViews() {
            LongSparseArray<View> viewsById;
            SparseArray<View> viewsByPos = this.mTransientStateViews;
            if (viewsByPos != null) {
                int N = viewsByPos.size();
                for (int i = 0; i < N; ++i) {
                    this.removeDetachedView(viewsByPos.valueAt(i), false);
                }
                viewsByPos.clear();
            }
            if ((viewsById = this.mTransientStateViewsById) != null) {
                int N = viewsById.size();
                for (int i = 0; i < N; ++i) {
                    this.removeDetachedView(viewsById.valueAt(i), false);
                }
                viewsById.clear();
            }
        }

        private final View $$robo$$android_widget_AbsListView_RecycleBin$getScrapView(int position) {
            int whichScrap = this.this$0.mAdapter.getItemViewType(position);
            if (whichScrap < 0) {
                return null;
            }
            if (this.mViewTypeCount == 1) {
                return this.retrieveFromScrap(this.mCurrentScrap, position);
            }
            if (whichScrap < this.mScrapViews.length) {
                return this.retrieveFromScrap(this.mScrapViews[whichScrap], position);
            }
            return null;
        }

        private final void $$robo$$android_widget_AbsListView_RecycleBin$addScrapView(View scrap, int position) {
            LayoutParams lp = (LayoutParams)scrap.getLayoutParams();
            if (lp == null) {
                return;
            }
            lp.scrappedFromPosition = position;
            int viewType = lp.viewType;
            if (!this.shouldRecycleViewType(viewType)) {
                if (viewType != -2) {
                    this.getSkippedScrap().add(scrap);
                }
                return;
            }
            scrap.dispatchStartTemporaryDetach();
            this.this$0.notifyViewAccessibilityStateChangedIfNeeded(1);
            boolean scrapHasTransientState = scrap.hasTransientState();
            if (scrapHasTransientState) {
                if (this.this$0.mAdapter != null && this.this$0.mAdapterHasStableIds) {
                    if (this.mTransientStateViewsById == null) {
                        this.mTransientStateViewsById = new LongSparseArray();
                    }
                    this.mTransientStateViewsById.put(lp.itemId, scrap);
                } else if (!this.this$0.mDataChanged) {
                    if (this.mTransientStateViews == null) {
                        this.mTransientStateViews = new SparseArray();
                    }
                    this.mTransientStateViews.put(position, scrap);
                } else {
                    this.clearScrapForRebind(scrap);
                    this.getSkippedScrap().add(scrap);
                }
            } else {
                this.clearScrapForRebind(scrap);
                if (this.mViewTypeCount == 1) {
                    this.mCurrentScrap.add(scrap);
                } else {
                    this.mScrapViews[viewType].add(scrap);
                }
                if (this.mRecyclerListener != null) {
                    this.mRecyclerListener.onMovedToScrapHeap(scrap);
                }
            }
        }

        private final ArrayList<View> $$robo$$android_widget_AbsListView_RecycleBin$getSkippedScrap() {
            if (this.mSkippedScrap == null) {
                this.mSkippedScrap = new ArrayList();
            }
            return this.mSkippedScrap;
        }

        private final void $$robo$$android_widget_AbsListView_RecycleBin$removeSkippedScrap() {
            if (this.mSkippedScrap == null) {
                return;
            }
            int count = this.mSkippedScrap.size();
            for (int i = 0; i < count; ++i) {
                this.removeDetachedView(this.mSkippedScrap.get(i), false);
            }
            this.mSkippedScrap.clear();
        }

        private final void $$robo$$android_widget_AbsListView_RecycleBin$scrapActiveViews() {
            View[] activeViews = this.mActiveViews;
            boolean hasListener = this.mRecyclerListener != null;
            boolean multipleScraps = this.mViewTypeCount > 1;
            ArrayList<View> scrapViews = this.mCurrentScrap;
            int count = activeViews.length;
            for (int i = count - 1; i >= 0; --i) {
                View victim = activeViews[i];
                if (victim == null) continue;
                LayoutParams lp = (LayoutParams)victim.getLayoutParams();
                int whichScrap = lp.viewType;
                activeViews[i] = null;
                if (victim.hasTransientState()) {
                    victim.dispatchStartTemporaryDetach();
                    if (this.this$0.mAdapter != null && this.this$0.mAdapterHasStableIds) {
                        if (this.mTransientStateViewsById == null) {
                            this.mTransientStateViewsById = new LongSparseArray();
                        }
                        long id2 = this.this$0.mAdapter.getItemId(this.mFirstActivePosition + i);
                        this.mTransientStateViewsById.put(id2, victim);
                        continue;
                    }
                    if (!this.this$0.mDataChanged) {
                        if (this.mTransientStateViews == null) {
                            this.mTransientStateViews = new SparseArray();
                        }
                        this.mTransientStateViews.put(this.mFirstActivePosition + i, victim);
                        continue;
                    }
                    if (whichScrap == -2) continue;
                    this.removeDetachedView(victim, false);
                    continue;
                }
                if (!this.shouldRecycleViewType(whichScrap)) {
                    if (whichScrap == -2) continue;
                    this.removeDetachedView(victim, false);
                    continue;
                }
                if (multipleScraps) {
                    scrapViews = this.mScrapViews[whichScrap];
                }
                lp.scrappedFromPosition = this.mFirstActivePosition + i;
                this.removeDetachedView(victim, false);
                scrapViews.add(victim);
                if (!hasListener) continue;
                this.mRecyclerListener.onMovedToScrapHeap(victim);
            }
            this.pruneScrapViews();
        }

        private final void $$robo$$android_widget_AbsListView_RecycleBin$fullyDetachScrapViews() {
            int viewTypeCount = this.mViewTypeCount;
            ArrayList<View>[] scrapViews = this.mScrapViews;
            for (int i = 0; i < viewTypeCount; ++i) {
                ArrayList<View> scrapPile = scrapViews[i];
                for (int j = scrapPile.size() - 1; j >= 0; --j) {
                    View view = scrapPile.get(j);
                    if (!view.isTemporarilyDetached()) continue;
                    this.removeDetachedView(view, false);
                }
            }
        }

        private final void $$robo$$android_widget_AbsListView_RecycleBin$pruneScrapViews() {
            LongSparseArray<View> transViewsById;
            int maxViews = this.mActiveViews.length;
            int viewTypeCount = this.mViewTypeCount;
            ArrayList<View>[] scrapViews = this.mScrapViews;
            for (int i = 0; i < viewTypeCount; ++i) {
                ArrayList<View> scrapPile = scrapViews[i];
                int size = scrapPile.size();
                while (size > maxViews) {
                    scrapPile.remove(--size);
                }
            }
            SparseArray<View> transViewsByPos = this.mTransientStateViews;
            if (transViewsByPos != null) {
                for (int i = 0; i < transViewsByPos.size(); ++i) {
                    View v = transViewsByPos.valueAt(i);
                    if (v.hasTransientState()) continue;
                    this.removeDetachedView(v, false);
                    transViewsByPos.removeAt(i);
                    --i;
                }
            }
            if ((transViewsById = this.mTransientStateViewsById) != null) {
                for (int i = 0; i < transViewsById.size(); ++i) {
                    View v = transViewsById.valueAt(i);
                    if (v.hasTransientState()) continue;
                    this.removeDetachedView(v, false);
                    transViewsById.removeAt(i);
                    --i;
                }
            }
        }

        private final void $$robo$$android_widget_AbsListView_RecycleBin$reclaimScrapViews(List<View> views) {
            if (this.mViewTypeCount == 1) {
                views.addAll(this.mCurrentScrap);
            } else {
                int viewTypeCount = this.mViewTypeCount;
                ArrayList<View>[] scrapViews = this.mScrapViews;
                for (int i = 0; i < viewTypeCount; ++i) {
                    ArrayList<View> scrapPile = scrapViews[i];
                    views.addAll(scrapPile);
                }
            }
        }

        private final void $$robo$$android_widget_AbsListView_RecycleBin$setCacheColorHint(int color2) {
            if (this.mViewTypeCount == 1) {
                ArrayList<View> scrap = this.mCurrentScrap;
                int scrapCount = scrap.size();
                for (int i = 0; i < scrapCount; ++i) {
                    scrap.get(i).setDrawingCacheBackgroundColor(color2);
                }
            } else {
                int typeCount = this.mViewTypeCount;
                for (int i = 0; i < typeCount; ++i) {
                    ArrayList<View> scrap = this.mScrapViews[i];
                    int scrapCount = scrap.size();
                    for (int j = 0; j < scrapCount; ++j) {
                        scrap.get(j).setDrawingCacheBackgroundColor(color2);
                    }
                }
            }
            for (View victim : this.mActiveViews) {
                if (victim == null) continue;
                victim.setDrawingCacheBackgroundColor(color2);
            }
        }

        private final View $$robo$$android_widget_AbsListView_RecycleBin$retrieveFromScrap(ArrayList<View> scrapViews, int position) {
            int size = scrapViews.size();
            if (size > 0) {
                for (int i = size - 1; i >= 0; --i) {
                    View view = scrapViews.get(i);
                    LayoutParams params = (LayoutParams)view.getLayoutParams();
                    if (this.this$0.mAdapterHasStableIds) {
                        long id2 = this.this$0.mAdapter.getItemId(position);
                        if (id2 != params.itemId) continue;
                        return scrapViews.remove(i);
                    }
                    if (params.scrappedFromPosition != position) continue;
                    View scrap = scrapViews.remove(i);
                    this.clearScrapForRebind(scrap);
                    return scrap;
                }
                View scrap = scrapViews.remove(size - 1);
                this.clearScrapForRebind(scrap);
                return scrap;
            }
            return null;
        }

        private final void $$robo$$android_widget_AbsListView_RecycleBin$clearScrap(ArrayList<View> scrap) {
            int scrapCount = scrap.size();
            for (int j = 0; j < scrapCount; ++j) {
                this.removeDetachedView(scrap.remove(scrapCount - 1 - j), false);
            }
        }

        private final void $$robo$$android_widget_AbsListView_RecycleBin$clearScrapForRebind(View view) {
            view.clearAccessibilityFocus();
            view.setAccessibilityDelegate(null);
        }

        private final void $$robo$$android_widget_AbsListView_RecycleBin$removeDetachedView(View child, boolean animate) {
            child.setAccessibilityDelegate(null);
            this.this$0.removeDetachedView(child, animate);
        }

        private void __constructor__(AbsListView absListView) {
            this.$$robo$$android_widget_AbsListView_RecycleBin$__constructor__(absListView);
        }

        RecycleBin(AbsListView absListView) {
            this.this$0 = absListView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_RecycleBin$__constructor__(android.widget.AbsListView ), 0, this, absListView);
        }

        public void setViewTypeCount(int n) {
            InvokeDynamicSupport.bootstrap("setViewTypeCount", $$robo$$android_widget_AbsListView_RecycleBin$setViewTypeCount(int ), 0, this, n);
        }

        public void markChildrenDirty() {
            InvokeDynamicSupport.bootstrap("markChildrenDirty", $$robo$$android_widget_AbsListView_RecycleBin$markChildrenDirty(), 0, this);
        }

        public boolean shouldRecycleViewType(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("shouldRecycleViewType", $$robo$$android_widget_AbsListView_RecycleBin$shouldRecycleViewType(int ), 0, this, n);
        }

        void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$android_widget_AbsListView_RecycleBin$clear(), 0, this);
        }

        void fillActiveViews(int n, int n2) {
            InvokeDynamicSupport.bootstrap("fillActiveViews", $$robo$$android_widget_AbsListView_RecycleBin$fillActiveViews(int int ), 0, this, n, n2);
        }

        View getActiveView(int n) {
            return InvokeDynamicSupport.bootstrap("getActiveView", $$robo$$android_widget_AbsListView_RecycleBin$getActiveView(int ), 0, this, n);
        }

        View getTransientStateView(int n) {
            return InvokeDynamicSupport.bootstrap("getTransientStateView", $$robo$$android_widget_AbsListView_RecycleBin$getTransientStateView(int ), 0, this, n);
        }

        void clearTransientStateViews() {
            InvokeDynamicSupport.bootstrap("clearTransientStateViews", $$robo$$android_widget_AbsListView_RecycleBin$clearTransientStateViews(), 0, this);
        }

        View getScrapView(int n) {
            return InvokeDynamicSupport.bootstrap("getScrapView", $$robo$$android_widget_AbsListView_RecycleBin$getScrapView(int ), 0, this, n);
        }

        void addScrapView(View view, int n) {
            InvokeDynamicSupport.bootstrap("addScrapView", $$robo$$android_widget_AbsListView_RecycleBin$addScrapView(android.view.View int ), 0, this, view, n);
        }

        private ArrayList<View> getSkippedScrap() {
            return InvokeDynamicSupport.bootstrap("getSkippedScrap", $$robo$$android_widget_AbsListView_RecycleBin$getSkippedScrap(), 0, this);
        }

        void removeSkippedScrap() {
            InvokeDynamicSupport.bootstrap("removeSkippedScrap", $$robo$$android_widget_AbsListView_RecycleBin$removeSkippedScrap(), 0, this);
        }

        void scrapActiveViews() {
            InvokeDynamicSupport.bootstrap("scrapActiveViews", $$robo$$android_widget_AbsListView_RecycleBin$scrapActiveViews(), 0, this);
        }

        void fullyDetachScrapViews() {
            InvokeDynamicSupport.bootstrap("fullyDetachScrapViews", $$robo$$android_widget_AbsListView_RecycleBin$fullyDetachScrapViews(), 0, this);
        }

        private void pruneScrapViews() {
            InvokeDynamicSupport.bootstrap("pruneScrapViews", $$robo$$android_widget_AbsListView_RecycleBin$pruneScrapViews(), 0, this);
        }

        void reclaimScrapViews(List<View> list) {
            InvokeDynamicSupport.bootstrap("reclaimScrapViews", $$robo$$android_widget_AbsListView_RecycleBin$reclaimScrapViews(java.util.List<android.view.View> ), 0, this, list);
        }

        void setCacheColorHint(int n) {
            InvokeDynamicSupport.bootstrap("setCacheColorHint", $$robo$$android_widget_AbsListView_RecycleBin$setCacheColorHint(int ), 0, this, n);
        }

        private View retrieveFromScrap(ArrayList<View> arrayList, int n) {
            return InvokeDynamicSupport.bootstrap("retrieveFromScrap", $$robo$$android_widget_AbsListView_RecycleBin$retrieveFromScrap(java.util.ArrayList<android.view.View> int ), 0, this, arrayList, n);
        }

        private void clearScrap(ArrayList<View> arrayList) {
            InvokeDynamicSupport.bootstrap("clearScrap", $$robo$$android_widget_AbsListView_RecycleBin$clearScrap(java.util.ArrayList<android.view.View> ), 0, this, arrayList);
        }

        private void clearScrapForRebind(View view) {
            InvokeDynamicSupport.bootstrap("clearScrapForRebind", $$robo$$android_widget_AbsListView_RecycleBin$clearScrapForRebind(android.view.View ), 0, this, view);
        }

        private void removeDetachedView(View view, boolean bl) {
            InvokeDynamicSupport.bootstrap("removeDetachedView", $$robo$$android_widget_AbsListView_RecycleBin$removeDetachedView(android.view.View boolean ), 0, this, view, bl);
        }

        public /* synthetic */ RecycleBin() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecycleBin)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface RecyclerListener
    extends InstrumentedInterface {
        public void onMovedToScrapHeap(View var1);
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        @ViewDebug.ExportedProperty(category="list", mapping={@ViewDebug.IntToString(from=-1, to="ITEM_VIEW_TYPE_IGNORE"), @ViewDebug.IntToString(from=-2, to="ITEM_VIEW_TYPE_HEADER_OR_FOOTER")})
        int viewType;
        @ViewDebug.ExportedProperty(category="list")
        boolean recycledHeaderFooter;
        @ViewDebug.ExportedProperty(category="list")
        boolean forceAdd;
        int scrappedFromPosition;
        long itemId;
        boolean isEnabled;

        private void $$robo$$android_widget_AbsListView_LayoutParams$__constructor__(Context c, AttributeSet attrs) {
            this.itemId = -1L;
        }

        private void $$robo$$android_widget_AbsListView_LayoutParams$__constructor__(int w, int h) {
            this.itemId = -1L;
        }

        private void $$robo$$android_widget_AbsListView_LayoutParams$__constructor__(int w, int h, int viewType) {
            this.itemId = -1L;
            this.viewType = viewType;
        }

        private void $$robo$$android_widget_AbsListView_LayoutParams$__constructor__(ViewGroup.LayoutParams source) {
            this.itemId = -1L;
        }

        private final void $$robo$$android_widget_AbsListView_LayoutParams$encodeProperties(ViewHierarchyEncoder encoder) {
            super.encodeProperties(encoder);
            encoder.addProperty("list:viewType", this.viewType);
            encoder.addProperty("list:recycledHeaderFooter", this.recycledHeaderFooter);
            encoder.addProperty("list:forceAdd", this.forceAdd);
            encoder.addProperty("list:isEnabled", this.isEnabled);
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$android_widget_AbsListView_LayoutParams$__constructor__(context, attributeSet);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_LayoutParams$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_widget_AbsListView_LayoutParams$__constructor__(n, n2);
        }

        public LayoutParams(int n, int n2) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_LayoutParams$__constructor__(int int ), 0, this, n, n2);
        }

        private void __constructor__(int n, int n2, int n3) {
            this.$$robo$$android_widget_AbsListView_LayoutParams$__constructor__(n, n2, n3);
        }

        public LayoutParams(int n, int n2, int n3) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_LayoutParams$__constructor__(int int int ), 0, this, n, n2, n3);
        }

        private void __constructor__(ViewGroup.LayoutParams layoutParams) {
            this.$$robo$$android_widget_AbsListView_LayoutParams$__constructor__(layoutParams);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_LayoutParams$__constructor__(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
        }

        @Override
        protected void encodeProperties(ViewHierarchyEncoder viewHierarchyEncoder) {
            InvokeDynamicSupport.bootstrap("encodeProperties", $$robo$$android_widget_AbsListView_LayoutParams$encodeProperties(android.view.ViewHierarchyEncoder ), 0, this, viewHierarchyEncoder);
        }

        public /* synthetic */ LayoutParams() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutParams)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class MultiChoiceModeWrapper
    implements MultiChoiceModeListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private MultiChoiceModeListener mWrapped;
        /* synthetic */ AbsListView this$0;

        private void $$robo$$android_widget_AbsListView_MultiChoiceModeWrapper$__constructor__(AbsListView this$0) {
        }

        private final void $$robo$$android_widget_AbsListView_MultiChoiceModeWrapper$setWrapped(MultiChoiceModeListener wrapped) {
            this.mWrapped = wrapped;
        }

        private final boolean $$robo$$android_widget_AbsListView_MultiChoiceModeWrapper$hasWrappedCallback() {
            return this.mWrapped != null;
        }

        private final boolean $$robo$$android_widget_AbsListView_MultiChoiceModeWrapper$onCreateActionMode(ActionMode mode, Menu menu2) {
            if (this.mWrapped.onCreateActionMode(mode, menu2)) {
                this.this$0.setLongClickable(false);
                return true;
            }
            return false;
        }

        private final boolean $$robo$$android_widget_AbsListView_MultiChoiceModeWrapper$onPrepareActionMode(ActionMode mode, Menu menu2) {
            return this.mWrapped.onPrepareActionMode(mode, menu2);
        }

        private final boolean $$robo$$android_widget_AbsListView_MultiChoiceModeWrapper$onActionItemClicked(ActionMode mode, MenuItem item) {
            return this.mWrapped.onActionItemClicked(mode, item);
        }

        private final void $$robo$$android_widget_AbsListView_MultiChoiceModeWrapper$onDestroyActionMode(ActionMode mode) {
            this.mWrapped.onDestroyActionMode(mode);
            this.this$0.mChoiceActionMode = null;
            this.this$0.clearChoices();
            this.this$0.mDataChanged = true;
            this.this$0.rememberSyncState();
            this.this$0.requestLayout();
            this.this$0.setLongClickable(true);
        }

        private final void $$robo$$android_widget_AbsListView_MultiChoiceModeWrapper$onItemCheckedStateChanged(ActionMode mode, int position, long id2, boolean checked) {
            this.mWrapped.onItemCheckedStateChanged(mode, position, id2, checked);
            if (this.this$0.getCheckedItemCount() == 0) {
                mode.finish();
            }
        }

        private void __constructor__(AbsListView absListView) {
            this.$$robo$$android_widget_AbsListView_MultiChoiceModeWrapper$__constructor__(absListView);
        }

        MultiChoiceModeWrapper(AbsListView absListView) {
            this.this$0 = absListView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_MultiChoiceModeWrapper$__constructor__(android.widget.AbsListView ), 0, this, absListView);
        }

        public void setWrapped(MultiChoiceModeListener multiChoiceModeListener) {
            InvokeDynamicSupport.bootstrap("setWrapped", $$robo$$android_widget_AbsListView_MultiChoiceModeWrapper$setWrapped(android.widget.AbsListView$MultiChoiceModeListener ), 0, this, multiChoiceModeListener);
        }

        public boolean hasWrappedCallback() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasWrappedCallback", $$robo$$android_widget_AbsListView_MultiChoiceModeWrapper$hasWrappedCallback(), 0, this);
        }

        @Override
        public boolean onCreateActionMode(ActionMode actionMode, Menu menu2) {
            return (boolean)InvokeDynamicSupport.bootstrap("onCreateActionMode", $$robo$$android_widget_AbsListView_MultiChoiceModeWrapper$onCreateActionMode(android.view.ActionMode android.view.Menu ), 0, this, actionMode, menu2);
        }

        @Override
        public boolean onPrepareActionMode(ActionMode actionMode, Menu menu2) {
            return (boolean)InvokeDynamicSupport.bootstrap("onPrepareActionMode", $$robo$$android_widget_AbsListView_MultiChoiceModeWrapper$onPrepareActionMode(android.view.ActionMode android.view.Menu ), 0, this, actionMode, menu2);
        }

        @Override
        public boolean onActionItemClicked(ActionMode actionMode, MenuItem menuItem) {
            return (boolean)InvokeDynamicSupport.bootstrap("onActionItemClicked", $$robo$$android_widget_AbsListView_MultiChoiceModeWrapper$onActionItemClicked(android.view.ActionMode android.view.MenuItem ), 0, this, actionMode, menuItem);
        }

        @Override
        public void onDestroyActionMode(ActionMode actionMode) {
            InvokeDynamicSupport.bootstrap("onDestroyActionMode", $$robo$$android_widget_AbsListView_MultiChoiceModeWrapper$onDestroyActionMode(android.view.ActionMode ), 0, this, actionMode);
        }

        @Override
        public void onItemCheckedStateChanged(ActionMode actionMode, int n, long l, boolean bl) {
            InvokeDynamicSupport.bootstrap("onItemCheckedStateChanged", $$robo$$android_widget_AbsListView_MultiChoiceModeWrapper$onItemCheckedStateChanged(android.view.ActionMode int long boolean ), 0, this, actionMode, n, l, bl);
        }

        public /* synthetic */ MultiChoiceModeWrapper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MultiChoiceModeWrapper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface MultiChoiceModeListener
    extends ActionMode.Callback,
    InstrumentedInterface {
        public void onItemCheckedStateChanged(ActionMode var1, int var2, long var3, boolean var5);
    }

    public class AdapterDataSetObserver
    extends AdapterView.AdapterDataSetObserver {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AbsListView this$0;

        private void $$robo$$android_widget_AbsListView_AdapterDataSetObserver$__constructor__(AbsListView this$0) {
        }

        private final void $$robo$$android_widget_AbsListView_AdapterDataSetObserver$onChanged() {
            super.onChanged();
            if (this.this$0.mFastScroll != null) {
                this.this$0.mFastScroll.onSectionsChanged();
            }
        }

        private final void $$robo$$android_widget_AbsListView_AdapterDataSetObserver$onInvalidated() {
            super.onInvalidated();
            if (this.this$0.mFastScroll != null) {
                this.this$0.mFastScroll.onSectionsChanged();
            }
        }

        private void __constructor__(AbsListView absListView) {
            this.$$robo$$android_widget_AbsListView_AdapterDataSetObserver$__constructor__(absListView);
        }

        AdapterDataSetObserver(AbsListView absListView) {
            this.this$0 = absListView;
            super(absListView);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_AdapterDataSetObserver$__constructor__(android.widget.AbsListView ), 0, this, absListView);
        }

        @Override
        public void onChanged() {
            InvokeDynamicSupport.bootstrap("onChanged", $$robo$$android_widget_AbsListView_AdapterDataSetObserver$onChanged(), 0, this);
        }

        @Override
        public void onInvalidated() {
            InvokeDynamicSupport.bootstrap("onInvalidated", $$robo$$android_widget_AbsListView_AdapterDataSetObserver$onInvalidated(), 0, this);
        }

        public /* synthetic */ AdapterDataSetObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AdapterDataSetObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class InputConnectionWrapper
    implements InputConnection,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private EditorInfo mOutAttrs;
        private InputConnection mTarget;
        /* synthetic */ AbsListView this$0;

        private void $$robo$$android_widget_AbsListView_InputConnectionWrapper$__constructor__(AbsListView absListView, EditorInfo outAttrs) {
            this.mOutAttrs = outAttrs;
        }

        private final InputConnection $$robo$$android_widget_AbsListView_InputConnectionWrapper$getTarget() {
            if (this.mTarget == null) {
                this.mTarget = this.this$0.getTextFilterInput().onCreateInputConnection(this.mOutAttrs);
            }
            return this.mTarget;
        }

        private final boolean $$robo$$android_widget_AbsListView_InputConnectionWrapper$reportFullscreenMode(boolean enabled) {
            return this.this$0.mDefInputConnection.reportFullscreenMode(enabled);
        }

        private final boolean $$robo$$android_widget_AbsListView_InputConnectionWrapper$performEditorAction(int editorAction) {
            if (editorAction == 6) {
                InputMethodManager imm = this.this$0.getContext().getSystemService(InputMethodManager.class);
                if (imm != null) {
                    imm.hideSoftInputFromWindow(this.this$0.getWindowToken(), 0);
                }
                return true;
            }
            return false;
        }

        private final boolean $$robo$$android_widget_AbsListView_InputConnectionWrapper$sendKeyEvent(KeyEvent event) {
            return this.this$0.mDefInputConnection.sendKeyEvent(event);
        }

        private final CharSequence $$robo$$android_widget_AbsListView_InputConnectionWrapper$getTextBeforeCursor(int n, int flags) {
            if (this.mTarget == null) {
                return "";
            }
            return this.mTarget.getTextBeforeCursor(n, flags);
        }

        private final CharSequence $$robo$$android_widget_AbsListView_InputConnectionWrapper$getTextAfterCursor(int n, int flags) {
            if (this.mTarget == null) {
                return "";
            }
            return this.mTarget.getTextAfterCursor(n, flags);
        }

        private final CharSequence $$robo$$android_widget_AbsListView_InputConnectionWrapper$getSelectedText(int flags) {
            if (this.mTarget == null) {
                return "";
            }
            return this.mTarget.getSelectedText(flags);
        }

        private final int $$robo$$android_widget_AbsListView_InputConnectionWrapper$getCursorCapsMode(int reqModes) {
            if (this.mTarget == null) {
                return 16384;
            }
            return this.mTarget.getCursorCapsMode(reqModes);
        }

        private final ExtractedText $$robo$$android_widget_AbsListView_InputConnectionWrapper$getExtractedText(ExtractedTextRequest request, int flags) {
            return this.getTarget().getExtractedText(request, flags);
        }

        private final boolean $$robo$$android_widget_AbsListView_InputConnectionWrapper$deleteSurroundingText(int beforeLength, int afterLength) {
            return this.getTarget().deleteSurroundingText(beforeLength, afterLength);
        }

        private final boolean $$robo$$android_widget_AbsListView_InputConnectionWrapper$deleteSurroundingTextInCodePoints(int beforeLength, int afterLength) {
            return this.getTarget().deleteSurroundingTextInCodePoints(beforeLength, afterLength);
        }

        private final boolean $$robo$$android_widget_AbsListView_InputConnectionWrapper$setComposingText(CharSequence text, int newCursorPosition) {
            return this.getTarget().setComposingText(text, newCursorPosition);
        }

        private final boolean $$robo$$android_widget_AbsListView_InputConnectionWrapper$setComposingRegion(int start, int end) {
            return this.getTarget().setComposingRegion(start, end);
        }

        private final boolean $$robo$$android_widget_AbsListView_InputConnectionWrapper$finishComposingText() {
            return this.mTarget == null || this.mTarget.finishComposingText();
        }

        private final boolean $$robo$$android_widget_AbsListView_InputConnectionWrapper$commitText(CharSequence text, int newCursorPosition) {
            return this.getTarget().commitText(text, newCursorPosition);
        }

        private final boolean $$robo$$android_widget_AbsListView_InputConnectionWrapper$commitCompletion(CompletionInfo text) {
            return this.getTarget().commitCompletion(text);
        }

        private final boolean $$robo$$android_widget_AbsListView_InputConnectionWrapper$commitCorrection(CorrectionInfo correctionInfo) {
            return this.getTarget().commitCorrection(correctionInfo);
        }

        private final boolean $$robo$$android_widget_AbsListView_InputConnectionWrapper$setSelection(int start, int end) {
            return this.getTarget().setSelection(start, end);
        }

        private final boolean $$robo$$android_widget_AbsListView_InputConnectionWrapper$performContextMenuAction(int id2) {
            return this.getTarget().performContextMenuAction(id2);
        }

        private final boolean $$robo$$android_widget_AbsListView_InputConnectionWrapper$beginBatchEdit() {
            return this.getTarget().beginBatchEdit();
        }

        private final boolean $$robo$$android_widget_AbsListView_InputConnectionWrapper$endBatchEdit() {
            return this.getTarget().endBatchEdit();
        }

        private final boolean $$robo$$android_widget_AbsListView_InputConnectionWrapper$clearMetaKeyStates(int states) {
            return this.getTarget().clearMetaKeyStates(states);
        }

        private final boolean $$robo$$android_widget_AbsListView_InputConnectionWrapper$performPrivateCommand(String action, Bundle data) {
            return this.getTarget().performPrivateCommand(action, data);
        }

        private final boolean $$robo$$android_widget_AbsListView_InputConnectionWrapper$requestCursorUpdates(int cursorUpdateMode) {
            return this.getTarget().requestCursorUpdates(cursorUpdateMode);
        }

        private final Handler $$robo$$android_widget_AbsListView_InputConnectionWrapper$getHandler() {
            return this.getTarget().getHandler();
        }

        private final void $$robo$$android_widget_AbsListView_InputConnectionWrapper$closeConnection() {
            this.getTarget().closeConnection();
        }

        private final boolean $$robo$$android_widget_AbsListView_InputConnectionWrapper$commitContent(InputContentInfo inputContentInfo, int flags, Bundle opts) {
            return this.getTarget().commitContent(inputContentInfo, flags, opts);
        }

        private void __constructor__(AbsListView absListView, EditorInfo editorInfo) {
            this.$$robo$$android_widget_AbsListView_InputConnectionWrapper$__constructor__(absListView, editorInfo);
        }

        public InputConnectionWrapper(AbsListView absListView, EditorInfo editorInfo) {
            this.this$0 = absListView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_InputConnectionWrapper$__constructor__(android.widget.AbsListView android.view.inputmethod.EditorInfo ), 0, this, absListView, editorInfo);
        }

        private InputConnection getTarget() {
            return InvokeDynamicSupport.bootstrap("getTarget", $$robo$$android_widget_AbsListView_InputConnectionWrapper$getTarget(), 0, this);
        }

        @Override
        public boolean reportFullscreenMode(boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("reportFullscreenMode", $$robo$$android_widget_AbsListView_InputConnectionWrapper$reportFullscreenMode(boolean ), 0, this, bl);
        }

        @Override
        public boolean performEditorAction(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("performEditorAction", $$robo$$android_widget_AbsListView_InputConnectionWrapper$performEditorAction(int ), 0, this, n);
        }

        @Override
        public boolean sendKeyEvent(KeyEvent keyEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("sendKeyEvent", $$robo$$android_widget_AbsListView_InputConnectionWrapper$sendKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
        }

        @Override
        public CharSequence getTextBeforeCursor(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("getTextBeforeCursor", $$robo$$android_widget_AbsListView_InputConnectionWrapper$getTextBeforeCursor(int int ), 0, this, n, n2);
        }

        @Override
        public CharSequence getTextAfterCursor(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("getTextAfterCursor", $$robo$$android_widget_AbsListView_InputConnectionWrapper$getTextAfterCursor(int int ), 0, this, n, n2);
        }

        @Override
        public CharSequence getSelectedText(int n) {
            return InvokeDynamicSupport.bootstrap("getSelectedText", $$robo$$android_widget_AbsListView_InputConnectionWrapper$getSelectedText(int ), 0, this, n);
        }

        @Override
        public int getCursorCapsMode(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getCursorCapsMode", $$robo$$android_widget_AbsListView_InputConnectionWrapper$getCursorCapsMode(int ), 0, this, n);
        }

        @Override
        public ExtractedText getExtractedText(ExtractedTextRequest extractedTextRequest, int n) {
            return InvokeDynamicSupport.bootstrap("getExtractedText", $$robo$$android_widget_AbsListView_InputConnectionWrapper$getExtractedText(android.view.inputmethod.ExtractedTextRequest int ), 0, this, extractedTextRequest, n);
        }

        @Override
        public boolean deleteSurroundingText(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("deleteSurroundingText", $$robo$$android_widget_AbsListView_InputConnectionWrapper$deleteSurroundingText(int int ), 0, this, n, n2);
        }

        @Override
        public boolean deleteSurroundingTextInCodePoints(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("deleteSurroundingTextInCodePoints", $$robo$$android_widget_AbsListView_InputConnectionWrapper$deleteSurroundingTextInCodePoints(int int ), 0, this, n, n2);
        }

        @Override
        public boolean setComposingText(CharSequence charSequence, int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("setComposingText", $$robo$$android_widget_AbsListView_InputConnectionWrapper$setComposingText(java.lang.CharSequence int ), 0, this, charSequence, n);
        }

        @Override
        public boolean setComposingRegion(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("setComposingRegion", $$robo$$android_widget_AbsListView_InputConnectionWrapper$setComposingRegion(int int ), 0, this, n, n2);
        }

        @Override
        public boolean finishComposingText() {
            return (boolean)InvokeDynamicSupport.bootstrap("finishComposingText", $$robo$$android_widget_AbsListView_InputConnectionWrapper$finishComposingText(), 0, this);
        }

        @Override
        public boolean commitText(CharSequence charSequence, int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("commitText", $$robo$$android_widget_AbsListView_InputConnectionWrapper$commitText(java.lang.CharSequence int ), 0, this, charSequence, n);
        }

        @Override
        public boolean commitCompletion(CompletionInfo completionInfo) {
            return (boolean)InvokeDynamicSupport.bootstrap("commitCompletion", $$robo$$android_widget_AbsListView_InputConnectionWrapper$commitCompletion(android.view.inputmethod.CompletionInfo ), 0, this, completionInfo);
        }

        @Override
        public boolean commitCorrection(CorrectionInfo correctionInfo) {
            return (boolean)InvokeDynamicSupport.bootstrap("commitCorrection", $$robo$$android_widget_AbsListView_InputConnectionWrapper$commitCorrection(android.view.inputmethod.CorrectionInfo ), 0, this, correctionInfo);
        }

        @Override
        public boolean setSelection(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("setSelection", $$robo$$android_widget_AbsListView_InputConnectionWrapper$setSelection(int int ), 0, this, n, n2);
        }

        @Override
        public boolean performContextMenuAction(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("performContextMenuAction", $$robo$$android_widget_AbsListView_InputConnectionWrapper$performContextMenuAction(int ), 0, this, n);
        }

        @Override
        public boolean beginBatchEdit() {
            return (boolean)InvokeDynamicSupport.bootstrap("beginBatchEdit", $$robo$$android_widget_AbsListView_InputConnectionWrapper$beginBatchEdit(), 0, this);
        }

        @Override
        public boolean endBatchEdit() {
            return (boolean)InvokeDynamicSupport.bootstrap("endBatchEdit", $$robo$$android_widget_AbsListView_InputConnectionWrapper$endBatchEdit(), 0, this);
        }

        @Override
        public boolean clearMetaKeyStates(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("clearMetaKeyStates", $$robo$$android_widget_AbsListView_InputConnectionWrapper$clearMetaKeyStates(int ), 0, this, n);
        }

        @Override
        public boolean performPrivateCommand(String string2, Bundle bundle) {
            return (boolean)InvokeDynamicSupport.bootstrap("performPrivateCommand", $$robo$$android_widget_AbsListView_InputConnectionWrapper$performPrivateCommand(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
        }

        @Override
        public boolean requestCursorUpdates(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("requestCursorUpdates", $$robo$$android_widget_AbsListView_InputConnectionWrapper$requestCursorUpdates(int ), 0, this, n);
        }

        @Override
        public Handler getHandler() {
            return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$android_widget_AbsListView_InputConnectionWrapper$getHandler(), 0, this);
        }

        @Override
        public void closeConnection() {
            InvokeDynamicSupport.bootstrap("closeConnection", $$robo$$android_widget_AbsListView_InputConnectionWrapper$closeConnection(), 0, this);
        }

        @Override
        public boolean commitContent(InputContentInfo inputContentInfo, int n, Bundle bundle) {
            return (boolean)InvokeDynamicSupport.bootstrap("commitContent", $$robo$$android_widget_AbsListView_InputConnectionWrapper$commitContent(android.view.inputmethod.InputContentInfo int android.os.Bundle ), 0, this, inputContentInfo, n, bundle);
        }

        public /* synthetic */ InputConnectionWrapper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputConnectionWrapper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class FlingRunnable
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private OverScroller mScroller;
        private int mLastFlingY;
        private boolean mSuppressIdleStateChangeCall;
        private Runnable mCheckFlywheel;
        private static int FLYWHEEL_TIMEOUT = 40;
        /* synthetic */ AbsListView this$0;

        private void $$robo$$android_widget_AbsListView_FlingRunnable$__constructor__(AbsListView absListView) {
            this.mCheckFlywheel = new Runnable(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ FlingRunnable this$1;

                private void $$robo$$android_widget_AbsListView_FlingRunnable_1$__constructor__(FlingRunnable this$1) {
                }

                private final void $$robo$$android_widget_AbsListView_FlingRunnable_1$run() {
                    int activeId = this.this$1.this$0.mActivePointerId;
                    VelocityTracker vt = this.this$1.this$0.mVelocityTracker;
                    OverScroller scroller = this.this$1.mScroller;
                    if (vt == null || activeId == -1) {
                        return;
                    }
                    vt.computeCurrentVelocity(1000, this.this$1.this$0.mMaximumVelocity);
                    float yvel = -vt.getYVelocity(activeId);
                    if (Math.abs(yvel) >= (float)this.this$1.this$0.mMinimumVelocity && scroller.isScrollingInDirection(0.0f, yvel)) {
                        this.this$1.this$0.postDelayed(this, 40L);
                    } else {
                        this.this$1.endFling();
                        this.this$1.this$0.mTouchMode = 3;
                        this.this$1.this$0.reportScrollStateChange(1);
                    }
                }

                private void __constructor__(FlingRunnable flingRunnable) {
                    this.$$robo$$android_widget_AbsListView_FlingRunnable_1$__constructor__(flingRunnable);
                }
                {
                    this.this$1 = flingRunnable;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_FlingRunnable_1$__constructor__(android.widget.AbsListView$FlingRunnable ), 0, this, flingRunnable);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_AbsListView_FlingRunnable_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mScroller = new OverScroller(absListView.getContext());
        }

        private final void $$robo$$android_widget_AbsListView_FlingRunnable$start(int initialVelocity) {
            int initialY;
            this.mLastFlingY = initialY = initialVelocity < 0 ? Integer.MAX_VALUE : 0;
            this.mScroller.setInterpolator(null);
            this.mScroller.fling(0, initialY, 0, initialVelocity, 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
            this.this$0.mTouchMode = 4;
            this.mSuppressIdleStateChangeCall = false;
            this.this$0.postOnAnimation(this);
            if (this.this$0.mFlingStrictSpan == null) {
                this.this$0.mFlingStrictSpan = StrictMode.enterCriticalSpan("AbsListView-fling");
            }
        }

        private final void $$robo$$android_widget_AbsListView_FlingRunnable$startSpringback() {
            this.mSuppressIdleStateChangeCall = false;
            if (this.mScroller.springBack(0, this.this$0.mScrollY, 0, 0, 0, 0)) {
                this.this$0.mTouchMode = 6;
                this.this$0.invalidate();
                this.this$0.postOnAnimation(this);
            } else {
                this.this$0.mTouchMode = -1;
                this.this$0.reportScrollStateChange(0);
            }
        }

        private final void $$robo$$android_widget_AbsListView_FlingRunnable$startOverfling(int initialVelocity) {
            this.mScroller.setInterpolator(null);
            this.mScroller.fling(0, this.this$0.mScrollY, 0, initialVelocity, 0, 0, Integer.MIN_VALUE, Integer.MAX_VALUE, 0, this.this$0.getHeight());
            this.this$0.mTouchMode = 6;
            this.mSuppressIdleStateChangeCall = false;
            this.this$0.invalidate();
            this.this$0.postOnAnimation(this);
        }

        private final void $$robo$$android_widget_AbsListView_FlingRunnable$edgeReached(int delta) {
            this.mScroller.notifyVerticalEdgeReached(this.this$0.mScrollY, 0, this.this$0.mOverflingDistance);
            int overscrollMode = this.this$0.getOverScrollMode();
            if (overscrollMode == 0 || overscrollMode == 1 && !this.this$0.contentFits()) {
                this.this$0.mTouchMode = 6;
                int vel = (int)this.mScroller.getCurrVelocity();
                if (delta > 0) {
                    this.this$0.mEdgeGlowTop.onAbsorb(vel);
                } else {
                    this.this$0.mEdgeGlowBottom.onAbsorb(vel);
                }
            } else {
                this.this$0.mTouchMode = -1;
                if (this.this$0.mPositionScroller != null) {
                    this.this$0.mPositionScroller.stop();
                }
            }
            this.this$0.invalidate();
            this.this$0.postOnAnimation(this);
        }

        private final void $$robo$$android_widget_AbsListView_FlingRunnable$startScroll(int distance, int duration, boolean linear, boolean suppressEndFlingStateChangeCall) {
            int initialY;
            this.mLastFlingY = initialY = distance < 0 ? Integer.MAX_VALUE : 0;
            this.mScroller.setInterpolator(linear ? sLinearInterpolator : null);
            this.mScroller.startScroll(0, initialY, 0, distance, duration);
            this.this$0.mTouchMode = 4;
            this.mSuppressIdleStateChangeCall = suppressEndFlingStateChangeCall;
            this.this$0.postOnAnimation(this);
        }

        private final void $$robo$$android_widget_AbsListView_FlingRunnable$endFling() {
            this.this$0.mTouchMode = -1;
            this.this$0.removeCallbacks(this);
            this.this$0.removeCallbacks(this.mCheckFlywheel);
            if (!this.mSuppressIdleStateChangeCall) {
                this.this$0.reportScrollStateChange(0);
            }
            this.this$0.clearScrollingCache();
            this.mScroller.abortAnimation();
            if (this.this$0.mFlingStrictSpan != null) {
                this.this$0.mFlingStrictSpan.finish();
                this.this$0.mFlingStrictSpan = null;
            }
        }

        private final void $$robo$$android_widget_AbsListView_FlingRunnable$flywheelTouch() {
            this.this$0.postDelayed(this.mCheckFlywheel, 40L);
        }

        private final void $$robo$$android_widget_AbsListView_FlingRunnable$run() {
            switch (this.this$0.mTouchMode) {
                default: {
                    this.endFling();
                    return;
                }
                case 3: {
                    if (this.mScroller.isFinished()) {
                        return;
                    }
                }
                case 4: {
                    boolean atEdge;
                    boolean atEnd;
                    if (this.this$0.mDataChanged) {
                        this.this$0.layoutChildren();
                    }
                    if (this.this$0.mItemCount == 0 || this.this$0.getChildCount() == 0) {
                        this.endFling();
                        return;
                    }
                    OverScroller scroller = this.mScroller;
                    boolean more = scroller.computeScrollOffset();
                    int y = scroller.getCurrY();
                    int delta = this.mLastFlingY - y;
                    if (delta > 0) {
                        this.this$0.mMotionPosition = this.this$0.mFirstPosition;
                        View firstView = this.this$0.getChildAt(0);
                        this.this$0.mMotionViewOriginalTop = firstView.getTop();
                        delta = Math.min(this.this$0.getHeight() - this.this$0.mPaddingBottom - this.this$0.mPaddingTop - 1, delta);
                    } else {
                        int offsetToLast = this.this$0.getChildCount() - 1;
                        this.this$0.mMotionPosition = this.this$0.mFirstPosition + offsetToLast;
                        View lastView = this.this$0.getChildAt(offsetToLast);
                        this.this$0.mMotionViewOriginalTop = lastView.getTop();
                        delta = Math.max(-(this.this$0.getHeight() - this.this$0.mPaddingBottom - this.this$0.mPaddingTop - 1), delta);
                    }
                    View motionView = this.this$0.getChildAt(this.this$0.mMotionPosition - this.this$0.mFirstPosition);
                    int oldTop = 0;
                    if (motionView != null) {
                        oldTop = motionView.getTop();
                    }
                    boolean bl = atEnd = (atEdge = this.this$0.trackMotionScroll(delta, delta)) && delta != 0;
                    if (atEnd) {
                        if (motionView != null) {
                            int overshoot = -(delta - (motionView.getTop() - oldTop));
                            this.this$0.overScrollBy(0, overshoot, 0, this.this$0.mScrollY, 0, 0, 0, this.this$0.mOverflingDistance, false);
                        }
                        if (!more) break;
                        this.edgeReached(delta);
                        break;
                    }
                    if (more && !atEnd) {
                        if (atEdge) {
                            this.this$0.invalidate();
                        }
                        this.mLastFlingY = y;
                        this.this$0.postOnAnimation(this);
                        break;
                    }
                    this.endFling();
                    break;
                }
                case 6: {
                    OverScroller scroller = this.mScroller;
                    if (scroller.computeScrollOffset()) {
                        int scrollY = this.this$0.mScrollY;
                        int currY = scroller.getCurrY();
                        int deltaY = currY - scrollY;
                        if (this.this$0.overScrollBy(0, deltaY, 0, scrollY, 0, 0, 0, this.this$0.mOverflingDistance, false)) {
                            boolean crossUp;
                            boolean crossDown = scrollY <= 0 && currY > 0;
                            boolean bl = crossUp = scrollY >= 0 && currY < 0;
                            if (crossDown || crossUp) {
                                int velocity = (int)scroller.getCurrVelocity();
                                if (crossUp) {
                                    velocity = -velocity;
                                }
                                scroller.abortAnimation();
                                this.start(velocity);
                                break;
                            }
                            this.startSpringback();
                            break;
                        }
                        this.this$0.invalidate();
                        this.this$0.postOnAnimation(this);
                        break;
                    }
                    this.endFling();
                    break;
                }
            }
        }

        private void __constructor__(AbsListView absListView) {
            this.$$robo$$android_widget_AbsListView_FlingRunnable$__constructor__(absListView);
        }

        FlingRunnable(AbsListView absListView) {
            this.this$0 = absListView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_FlingRunnable$__constructor__(android.widget.AbsListView ), 0, this, absListView);
        }

        void start(int n) {
            InvokeDynamicSupport.bootstrap("start", $$robo$$android_widget_AbsListView_FlingRunnable$start(int ), 0, this, n);
        }

        void startSpringback() {
            InvokeDynamicSupport.bootstrap("startSpringback", $$robo$$android_widget_AbsListView_FlingRunnable$startSpringback(), 0, this);
        }

        void startOverfling(int n) {
            InvokeDynamicSupport.bootstrap("startOverfling", $$robo$$android_widget_AbsListView_FlingRunnable$startOverfling(int ), 0, this, n);
        }

        void edgeReached(int n) {
            InvokeDynamicSupport.bootstrap("edgeReached", $$robo$$android_widget_AbsListView_FlingRunnable$edgeReached(int ), 0, this, n);
        }

        void startScroll(int n, int n2, boolean bl, boolean bl2) {
            InvokeDynamicSupport.bootstrap("startScroll", $$robo$$android_widget_AbsListView_FlingRunnable$startScroll(int int boolean boolean ), 0, this, n, n2, bl, bl2);
        }

        void endFling() {
            InvokeDynamicSupport.bootstrap("endFling", $$robo$$android_widget_AbsListView_FlingRunnable$endFling(), 0, this);
        }

        void flywheelTouch() {
            InvokeDynamicSupport.bootstrap("flywheelTouch", $$robo$$android_widget_AbsListView_FlingRunnable$flywheelTouch(), 0, this);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_AbsListView_FlingRunnable$run(), 0, this);
        }

        public /* synthetic */ FlingRunnable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FlingRunnable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class CheckForTap
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        float x;
        float y;
        /* synthetic */ AbsListView this$0;

        private void $$robo$$android_widget_AbsListView_CheckForTap$__constructor__(AbsListView absListView) {
        }

        private final void $$robo$$android_widget_AbsListView_CheckForTap$run() {
            if (this.this$0.mTouchMode == 0) {
                this.this$0.mTouchMode = 1;
                View child = this.this$0.getChildAt(this.this$0.mMotionPosition - this.this$0.mFirstPosition);
                if (child != null && !child.hasExplicitFocusable()) {
                    this.this$0.mLayoutMode = 0;
                    if (!this.this$0.mDataChanged) {
                        float[] point = this.this$0.mTmpPoint;
                        point[0] = this.x;
                        point[1] = this.y;
                        this.this$0.transformPointToViewLocal(point, child);
                        child.drawableHotspotChanged(point[0], point[1]);
                        child.setPressed(true);
                        this.this$0.setPressed(true);
                        this.this$0.layoutChildren();
                        this.this$0.positionSelector(this.this$0.mMotionPosition, child);
                        this.this$0.refreshDrawableState();
                        int longPressTimeout = ViewConfiguration.getLongPressTimeout();
                        boolean longClickable = this.this$0.isLongClickable();
                        if (this.this$0.mSelector != null) {
                            Drawable d = this.this$0.mSelector.getCurrent();
                            if (d != null && d instanceof TransitionDrawable) {
                                if (longClickable) {
                                    ((TransitionDrawable)d).startTransition(longPressTimeout);
                                } else {
                                    ((TransitionDrawable)d).resetTransition();
                                }
                            }
                            this.this$0.mSelector.setHotspot(this.x, this.y);
                        }
                        if (longClickable) {
                            if (this.this$0.mPendingCheckForLongPress == null) {
                                this.this$0.mPendingCheckForLongPress = new CheckForLongPress(this.this$0);
                            }
                            this.this$0.mPendingCheckForLongPress.setCoords(this.x, this.y);
                            this.this$0.mPendingCheckForLongPress.rememberWindowAttachCount();
                            this.this$0.postDelayed(this.this$0.mPendingCheckForLongPress, longPressTimeout);
                        } else {
                            this.this$0.mTouchMode = 2;
                        }
                    } else {
                        this.this$0.mTouchMode = 2;
                    }
                }
            }
        }

        private /* synthetic */ void $$robo$$android_widget_AbsListView_CheckForTap$__constructor__(AbsListView x0, 1 x1) {
        }

        private void __constructor__(AbsListView absListView) {
            this.$$robo$$android_widget_AbsListView_CheckForTap$__constructor__(absListView);
        }

        private CheckForTap(AbsListView absListView) {
            this.this$0 = absListView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_CheckForTap$__constructor__(android.widget.AbsListView ), 0, this, absListView);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_AbsListView_CheckForTap$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(AbsListView absListView, 1 var2_2) {
            this.$$robo$$android_widget_AbsListView_CheckForTap$__constructor__(absListView, var2_2);
        }

        public /* synthetic */ CheckForTap() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CheckForTap)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class CheckForKeyLongPress
    extends WindowRunnnable
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AbsListView this$0;

        private void $$robo$$android_widget_AbsListView_CheckForKeyLongPress$__constructor__(AbsListView absListView) {
        }

        private final void $$robo$$android_widget_AbsListView_CheckForKeyLongPress$run() {
            if (this.this$0.isPressed() && this.this$0.mSelectedPosition >= 0) {
                int index = this.this$0.mSelectedPosition - this.this$0.mFirstPosition;
                View v = this.this$0.getChildAt(index);
                if (!this.this$0.mDataChanged) {
                    boolean handled = false;
                    if (this.sameWindow()) {
                        handled = this.this$0.performLongPress(v, this.this$0.mSelectedPosition, this.this$0.mSelectedRowId);
                    }
                    if (handled) {
                        this.this$0.setPressed(false);
                        v.setPressed(false);
                    }
                } else {
                    this.this$0.setPressed(false);
                    if (v != null) {
                        v.setPressed(false);
                    }
                }
            }
        }

        private /* synthetic */ void $$robo$$android_widget_AbsListView_CheckForKeyLongPress$__constructor__(AbsListView x0, 1 x1) {
        }

        private void __constructor__(AbsListView absListView) {
            this.$$robo$$android_widget_AbsListView_CheckForKeyLongPress$__constructor__(absListView);
        }

        private CheckForKeyLongPress(AbsListView absListView) {
            this.this$0 = absListView;
            super(absListView);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_CheckForKeyLongPress$__constructor__(android.widget.AbsListView ), 0, this, absListView);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_AbsListView_CheckForKeyLongPress$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(AbsListView absListView, 1 var2_2) {
            this.$$robo$$android_widget_AbsListView_CheckForKeyLongPress$__constructor__(absListView, var2_2);
        }

        public /* synthetic */ CheckForKeyLongPress() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CheckForKeyLongPress)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class CheckForLongPress
    extends WindowRunnnable
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int INVALID_COORD = -1;
        private float mX;
        private float mY;
        /* synthetic */ AbsListView this$0;

        private void $$robo$$android_widget_AbsListView_CheckForLongPress$__constructor__(AbsListView absListView) {
            this.mX = -1.0f;
            this.mY = -1.0f;
        }

        private final void $$robo$$android_widget_AbsListView_CheckForLongPress$setCoords(float x, float y) {
            this.mX = x;
            this.mY = y;
        }

        private final void $$robo$$android_widget_AbsListView_CheckForLongPress$run() {
            int motionPosition = this.this$0.mMotionPosition;
            View child = this.this$0.getChildAt(motionPosition - this.this$0.mFirstPosition);
            if (child != null) {
                int longPressPosition = this.this$0.mMotionPosition;
                long longPressId = this.this$0.mAdapter.getItemId(this.this$0.mMotionPosition);
                boolean handled = false;
                if (this.sameWindow() && !this.this$0.mDataChanged) {
                    handled = this.mX != -1.0f && this.mY != -1.0f ? this.this$0.performLongPress(child, longPressPosition, longPressId, this.mX, this.mY) : this.this$0.performLongPress(child, longPressPosition, longPressId);
                }
                if (handled) {
                    this.this$0.mHasPerformedLongPress = true;
                    this.this$0.mTouchMode = -1;
                    this.this$0.setPressed(false);
                    child.setPressed(false);
                } else {
                    this.this$0.mTouchMode = 2;
                }
            }
        }

        private /* synthetic */ void $$robo$$android_widget_AbsListView_CheckForLongPress$__constructor__(AbsListView x0, 1 x1) {
        }

        private void __constructor__(AbsListView absListView) {
            this.$$robo$$android_widget_AbsListView_CheckForLongPress$__constructor__(absListView);
        }

        private CheckForLongPress(AbsListView absListView) {
            this.this$0 = absListView;
            super(absListView);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_CheckForLongPress$__constructor__(android.widget.AbsListView ), 0, this, absListView);
        }

        private void setCoords(float f, float f2) {
            InvokeDynamicSupport.bootstrap("setCoords", $$robo$$android_widget_AbsListView_CheckForLongPress$setCoords(float float ), 0, this, f, f2);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_AbsListView_CheckForLongPress$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(AbsListView absListView, 1 var2_2) {
            this.$$robo$$android_widget_AbsListView_CheckForLongPress$__constructor__(absListView, var2_2);
        }

        public /* synthetic */ CheckForLongPress() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CheckForLongPress)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class PerformClick
    extends WindowRunnnable
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int mClickMotionPosition;
        /* synthetic */ AbsListView this$0;

        private void $$robo$$android_widget_AbsListView_PerformClick$__constructor__(AbsListView absListView) {
        }

        private final void $$robo$$android_widget_AbsListView_PerformClick$run() {
            View view;
            if (this.this$0.mDataChanged) {
                return;
            }
            ListAdapter adapter = this.this$0.mAdapter;
            int motionPosition = this.mClickMotionPosition;
            if (adapter != null && this.this$0.mItemCount > 0 && motionPosition != -1 && motionPosition < adapter.getCount() && this.sameWindow() && adapter.isEnabled(motionPosition) && (view = this.this$0.getChildAt(motionPosition - this.this$0.mFirstPosition)) != null) {
                this.this$0.performItemClick(view, motionPosition, adapter.getItemId(motionPosition));
            }
        }

        private /* synthetic */ void $$robo$$android_widget_AbsListView_PerformClick$__constructor__(AbsListView x0, 1 x1) {
        }

        private void __constructor__(AbsListView absListView) {
            this.$$robo$$android_widget_AbsListView_PerformClick$__constructor__(absListView);
        }

        private PerformClick(AbsListView absListView) {
            this.this$0 = absListView;
            super(absListView);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_PerformClick$__constructor__(android.widget.AbsListView ), 0, this, absListView);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_AbsListView_PerformClick$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(AbsListView absListView, 1 var2_2) {
            this.$$robo$$android_widget_AbsListView_PerformClick$__constructor__(absListView, var2_2);
        }

        public /* synthetic */ PerformClick() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PerformClick)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class WindowRunnnable
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mOriginalAttachCount;
        /* synthetic */ AbsListView this$0;

        private void $$robo$$android_widget_AbsListView_WindowRunnnable$__constructor__(AbsListView absListView) {
        }

        private final void $$robo$$android_widget_AbsListView_WindowRunnnable$rememberWindowAttachCount() {
            this.mOriginalAttachCount = this.this$0.getWindowAttachCount();
        }

        private final boolean $$robo$$android_widget_AbsListView_WindowRunnnable$sameWindow() {
            return this.this$0.getWindowAttachCount() == this.mOriginalAttachCount;
        }

        private /* synthetic */ void $$robo$$android_widget_AbsListView_WindowRunnnable$__constructor__(AbsListView x0, 1 x1) {
        }

        private void __constructor__(AbsListView absListView) {
            this.$$robo$$android_widget_AbsListView_WindowRunnnable$__constructor__(absListView);
        }

        private WindowRunnnable(AbsListView absListView) {
            this.this$0 = absListView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_WindowRunnnable$__constructor__(android.widget.AbsListView ), 0, this, absListView);
        }

        public void rememberWindowAttachCount() {
            InvokeDynamicSupport.bootstrap("rememberWindowAttachCount", $$robo$$android_widget_AbsListView_WindowRunnnable$rememberWindowAttachCount(), 0, this);
        }

        public boolean sameWindow() {
            return (boolean)InvokeDynamicSupport.bootstrap("sameWindow", $$robo$$android_widget_AbsListView_WindowRunnnable$sameWindow(), 0, this);
        }

        private /* synthetic */ void __constructor__(AbsListView absListView, 1 var2_2) {
            this.$$robo$$android_widget_AbsListView_WindowRunnnable$__constructor__(absListView, var2_2);
        }

        public /* synthetic */ WindowRunnnable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WindowRunnnable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class ListItemAccessibilityDelegate
    extends View.AccessibilityDelegate
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AbsListView this$0;

        private void $$robo$$android_widget_AbsListView_ListItemAccessibilityDelegate$__constructor__(AbsListView this$0) {
        }

        private final void $$robo$$android_widget_AbsListView_ListItemAccessibilityDelegate$onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfo info) {
            super.onInitializeAccessibilityNodeInfo(host, info);
            int position = this.this$0.getPositionForView(host);
            this.this$0.onInitializeAccessibilityNodeInfoForItem(host, position, info);
        }

        private final boolean $$robo$$android_widget_AbsListView_ListItemAccessibilityDelegate$performAccessibilityAction(View host, int action, Bundle arguments) {
            if (super.performAccessibilityAction(host, action, arguments)) {
                return true;
            }
            int position = this.this$0.getPositionForView(host);
            if (position == -1 || this.this$0.mAdapter == null) {
                return false;
            }
            if (position >= this.this$0.mAdapter.getCount()) {
                return false;
            }
            ViewGroup.LayoutParams lp = host.getLayoutParams();
            boolean isItemEnabled = lp instanceof LayoutParams ? ((LayoutParams)lp).isEnabled : false;
            if (!this.this$0.isEnabled() || !isItemEnabled) {
                return false;
            }
            switch (action) {
                case 8: {
                    if (this.this$0.getSelectedItemPosition() == position) {
                        this.this$0.setSelection(-1);
                        return true;
                    }
                    return false;
                }
                case 4: {
                    if (this.this$0.getSelectedItemPosition() != position) {
                        this.this$0.setSelection(position);
                        return true;
                    }
                    return false;
                }
                case 16: {
                    if (this.this$0.isItemClickable(host)) {
                        long id2 = this.this$0.getItemIdAtPosition(position);
                        return this.this$0.performItemClick(host, position, id2);
                    }
                    return false;
                }
                case 32: {
                    if (this.this$0.isLongClickable()) {
                        long id3 = this.this$0.getItemIdAtPosition(position);
                        return this.this$0.performLongPress(host, position, id3);
                    }
                    return false;
                }
            }
            return false;
        }

        private void __constructor__(AbsListView absListView) {
            this.$$robo$$android_widget_AbsListView_ListItemAccessibilityDelegate$__constructor__(absListView);
        }

        ListItemAccessibilityDelegate(AbsListView absListView) {
            this.this$0 = absListView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_ListItemAccessibilityDelegate$__constructor__(android.widget.AbsListView ), 0, this, absListView);
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfo accessibilityNodeInfo) {
            InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$android_widget_AbsListView_ListItemAccessibilityDelegate$onInitializeAccessibilityNodeInfo(android.view.View android.view.accessibility.AccessibilityNodeInfo ), 0, this, view, accessibilityNodeInfo);
        }

        @Override
        public boolean performAccessibilityAction(View view, int n, Bundle bundle) {
            return (boolean)InvokeDynamicSupport.bootstrap("performAccessibilityAction", $$robo$$android_widget_AbsListView_ListItemAccessibilityDelegate$performAccessibilityAction(android.view.View int android.os.Bundle ), 0, this, view, n, bundle);
        }

        public /* synthetic */ ListItemAccessibilityDelegate() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ListItemAccessibilityDelegate)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SavedState
    extends View.BaseSavedState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        long selectedId;
        long firstId;
        int viewTop;
        int position;
        int height;
        String filter;
        boolean inActionMode;
        int checkedItemCount;
        SparseBooleanArray checkState;
        LongSparseArray<Integer> checkIdState;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$android_widget_AbsListView_SavedState$__constructor__(Parcelable superState) {
        }

        private void $$robo$$android_widget_AbsListView_SavedState$__constructor__(Parcel in) {
            this.selectedId = in.readLong();
            this.firstId = in.readLong();
            this.viewTop = in.readInt();
            this.position = in.readInt();
            this.height = in.readInt();
            this.filter = in.readString();
            this.inActionMode = in.readByte() != 0;
            this.checkedItemCount = in.readInt();
            this.checkState = in.readSparseBooleanArray();
            int N = in.readInt();
            if (N > 0) {
                this.checkIdState = new LongSparseArray();
                for (int i = 0; i < N; ++i) {
                    long key = in.readLong();
                    int value = in.readInt();
                    this.checkIdState.put(key, value);
                }
            }
        }

        private final void $$robo$$android_widget_AbsListView_SavedState$writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeLong(this.selectedId);
            out.writeLong(this.firstId);
            out.writeInt(this.viewTop);
            out.writeInt(this.position);
            out.writeInt(this.height);
            out.writeString(this.filter);
            out.writeByte((byte)(this.inActionMode ? 1 : 0));
            out.writeInt(this.checkedItemCount);
            out.writeSparseBooleanArray(this.checkState);
            int N = this.checkIdState != null ? this.checkIdState.size() : 0;
            out.writeInt(N);
            for (int i = 0; i < N; ++i) {
                out.writeLong(this.checkIdState.keyAt(i));
                out.writeInt(this.checkIdState.valueAt(i));
            }
        }

        private final String $$robo$$android_widget_AbsListView_SavedState$toString() {
            return "AbsListView.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " selectedId=" + this.selectedId + " firstId=" + this.firstId + " viewTop=" + this.viewTop + " position=" + this.position + " height=" + this.height + " filter=" + this.filter + " checkState=" + this.checkState + "}";
        }

        private /* synthetic */ void $$robo$$android_widget_AbsListView_SavedState$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_widget_AbsListView_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$android_widget_AbsListView_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in);
                }

                private final SavedState[] $$robo$$android_widget_AbsListView_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_widget_AbsListView_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_SavedState_1$__constructor__(), 0, this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_AbsListView_SavedState_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_widget_AbsListView_SavedState_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcelable parcelable) {
            this.$$robo$$android_widget_AbsListView_SavedState$__constructor__(parcelable);
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_SavedState$__constructor__(android.os.Parcelable ), 0, this, parcelable);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_widget_AbsListView_SavedState$__constructor__(parcel);
        }

        private SavedState(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsListView_SavedState$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_AbsListView_SavedState$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_widget_AbsListView_SavedState$toString(), 0, this);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_widget_AbsListView_SavedState$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        public /* synthetic */ SavedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface SelectionBoundsAdjuster
    extends InstrumentedInterface {
        public void adjustListItemSelectionBounds(Rect var1);
    }

    public static interface OnScrollListener
    extends InstrumentedInterface {
        public static final int SCROLL_STATE_IDLE = 0;
        public static final int SCROLL_STATE_TOUCH_SCROLL = 1;
        public static final int SCROLL_STATE_FLING = 2;

        public void onScrollStateChanged(AbsListView var1, int var2);

        public void onScroll(AbsListView var1, int var2, int var3, int var4);
    }
}

