/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.IntProperty;
import android.util.MathUtils;
import android.util.Property;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewGroupOverlay;
import android.view.ViewOverlay;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListConnector;
import android.widget.ExpandableListView;
import android.widget.HeaderViewListAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.SectionIndexer;
import android.widget.TextView;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FastScroller
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int DURATION_FADE_OUT = 300;
    private static int DURATION_FADE_IN = 150;
    private static int DURATION_CROSS_FADE = 50;
    private static int DURATION_RESIZE = 100;
    private static long FADE_TIMEOUT = 1500L;
    private static int MIN_PAGES = 4;
    private static int STATE_NONE = 0;
    private static int STATE_VISIBLE = 1;
    private static int STATE_DRAGGING = 2;
    private static int OVERLAY_FLOATING = 0;
    private static int OVERLAY_AT_THUMB = 1;
    private static int OVERLAY_ABOVE_THUMB = 2;
    private static int THUMB_POSITION_MIDPOINT = 0;
    private static int THUMB_POSITION_INSIDE = 1;
    private static int PREVIEW_LEFT = 0;
    private static int PREVIEW_RIGHT = 1;
    private static long TAP_TIMEOUT;
    private Rect mTempBounds;
    private Rect mTempMargins;
    private Rect mContainerRect;
    private AbsListView mList;
    private ViewGroupOverlay mOverlay;
    private TextView mPrimaryText;
    private TextView mSecondaryText;
    private ImageView mThumbImage;
    private ImageView mTrackImage;
    private View mPreviewImage;
    private int[] mPreviewResId;
    private int mMinimumTouchTarget;
    private int mPreviewPadding;
    private int mPreviewMinWidth;
    private int mPreviewMinHeight;
    private int mThumbMinWidth;
    private int mThumbMinHeight;
    private float mTextSize;
    private ColorStateList mTextColor;
    private Drawable mThumbDrawable;
    private Drawable mTrackDrawable;
    private int mTextAppearance;
    private int mThumbPosition;
    private float mThumbOffset;
    private float mThumbRange;
    private int mWidth;
    private AnimatorSet mDecorAnimation;
    private AnimatorSet mPreviewAnimation;
    private boolean mShowingPrimary;
    private boolean mScrollCompleted;
    private int mFirstVisibleItem;
    private int mHeaderCount;
    private int mCurrentSection;
    private int mScrollbarPosition;
    private boolean mLongList;
    private Object[] mSections;
    private boolean mUpdatingLayout;
    private int mState;
    private boolean mShowingPreview;
    private Adapter mListAdapter;
    private SectionIndexer mSectionIndexer;
    private boolean mLayoutFromRight;
    private boolean mEnabled;
    private boolean mAlwaysShow;
    private int mOverlayPosition;
    private int mScrollBarStyle;
    private boolean mMatchDragPosition;
    private float mInitialTouchY;
    private long mPendingDrag;
    private int mScaledTouchSlop;
    private int mOldItemCount;
    private int mOldChildCount;
    private Runnable mDeferHide;
    private Animator.AnimatorListener mSwitchPrimaryListener;
    private static Property<View, Integer> LEFT;
    private static Property<View, Integer> TOP;
    private static Property<View, Integer> RIGHT;
    private static Property<View, Integer> BOTTOM;

    private void $$robo$$android_widget_FastScroller$__constructor__(AbsListView listView, int styleResId) {
        this.mTempBounds = new Rect();
        this.mTempMargins = new Rect();
        this.mContainerRect = new Rect();
        this.mPreviewResId = new int[2];
        this.mCurrentSection = -1;
        this.mScrollbarPosition = -1;
        this.mPendingDrag = -1L;
        this.mDeferHide = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ FastScroller this$0;

            private void $$robo$$android_widget_FastScroller_1$__constructor__(FastScroller this$0) {
            }

            private final void $$robo$$android_widget_FastScroller_1$run() {
                this.this$0.setState(0);
            }

            private void __constructor__(FastScroller fastScroller) {
                this.$$robo$$android_widget_FastScroller_1$__constructor__(fastScroller);
            }
            {
                this.this$0 = fastScroller;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FastScroller_1$__constructor__(android.widget.FastScroller ), 0, this, fastScroller);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_FastScroller_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mSwitchPrimaryListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ FastScroller this$0;

            private void $$robo$$android_widget_FastScroller_2$__constructor__(FastScroller this$0) {
            }

            private final void $$robo$$android_widget_FastScroller_2$onAnimationEnd(Animator animation) {
                this.this$0.mShowingPrimary = !this.this$0.mShowingPrimary;
            }

            private void __constructor__(FastScroller fastScroller) {
                this.$$robo$$android_widget_FastScroller_2$__constructor__(fastScroller);
            }
            {
                this.this$0 = fastScroller;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FastScroller_2$__constructor__(android.widget.FastScroller ), 0, this, fastScroller);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_widget_FastScroller_2$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mList = listView;
        this.mOldItemCount = listView.getCount();
        this.mOldChildCount = listView.getChildCount();
        Context context = listView.getContext();
        this.mScaledTouchSlop = ViewConfiguration.get(context).getScaledTouchSlop();
        this.mScrollBarStyle = listView.getScrollBarStyle();
        this.mScrollCompleted = true;
        this.mState = 1;
        this.mMatchDragPosition = context.getApplicationInfo().targetSdkVersion >= 11;
        this.mTrackImage = new ImageView(context);
        this.mTrackImage.setScaleType(ImageView.ScaleType.FIT_XY);
        this.mThumbImage = new ImageView(context);
        this.mThumbImage.setScaleType(ImageView.ScaleType.FIT_XY);
        this.mPreviewImage = new View(context);
        this.mPreviewImage.setAlpha(0.0f);
        this.mPrimaryText = this.createPreviewTextView(context);
        this.mSecondaryText = this.createPreviewTextView(context);
        this.mMinimumTouchTarget = listView.getResources().getDimensionPixelSize(17105044);
        this.setStyle(styleResId);
        ViewOverlay overlay = listView.getOverlay();
        this.mOverlay = overlay;
        ((ViewGroupOverlay)overlay).add(this.mTrackImage);
        ((ViewGroupOverlay)overlay).add(this.mThumbImage);
        ((ViewGroupOverlay)overlay).add(this.mPreviewImage);
        ((ViewGroupOverlay)overlay).add(this.mPrimaryText);
        ((ViewGroupOverlay)overlay).add(this.mSecondaryText);
        this.getSectionsFromIndexer();
        this.updateLongList(this.mOldChildCount, this.mOldItemCount);
        this.setScrollbarPosition(listView.getVerticalScrollbarPosition());
        this.postAutoHide();
    }

    private final void $$robo$$android_widget_FastScroller$updateAppearance() {
        int width = 0;
        this.mTrackImage.setImageDrawable(this.mTrackDrawable);
        if (this.mTrackDrawable != null) {
            width = Math.max(width, this.mTrackDrawable.getIntrinsicWidth());
        }
        this.mThumbImage.setImageDrawable(this.mThumbDrawable);
        this.mThumbImage.setMinimumWidth(this.mThumbMinWidth);
        this.mThumbImage.setMinimumHeight(this.mThumbMinHeight);
        if (this.mThumbDrawable != null) {
            width = Math.max(width, this.mThumbDrawable.getIntrinsicWidth());
        }
        this.mWidth = Math.max(width, this.mThumbMinWidth);
        if (this.mTextAppearance != 0) {
            this.mPrimaryText.setTextAppearance(this.mTextAppearance);
            this.mSecondaryText.setTextAppearance(this.mTextAppearance);
        }
        if (this.mTextColor != null) {
            this.mPrimaryText.setTextColor(this.mTextColor);
            this.mSecondaryText.setTextColor(this.mTextColor);
        }
        if (this.mTextSize > 0.0f) {
            this.mPrimaryText.setTextSize(0, this.mTextSize);
            this.mSecondaryText.setTextSize(0, this.mTextSize);
        }
        int padding = this.mPreviewPadding;
        this.mPrimaryText.setIncludeFontPadding(false);
        this.mPrimaryText.setPadding(padding, padding, padding, padding);
        this.mSecondaryText.setIncludeFontPadding(false);
        this.mSecondaryText.setPadding(padding, padding, padding, padding);
        this.refreshDrawablePressedState();
    }

    private final void $$robo$$android_widget_FastScroller$setStyle(int resId) {
        Context context = this.mList.getContext();
        TypedArray ta = context.obtainStyledAttributes(null, R.styleable.FastScroll, 16843767, resId);
        int N = ta.getIndexCount();
        block16: for (int i = 0; i < N; ++i) {
            int index = ta.getIndex(i);
            switch (index) {
                case 9: {
                    this.mOverlayPosition = ta.getInt(index, 0);
                    continue block16;
                }
                case 7: {
                    this.mPreviewResId[0] = ta.getResourceId(index, 0);
                    continue block16;
                }
                case 8: {
                    this.mPreviewResId[1] = ta.getResourceId(index, 0);
                    continue block16;
                }
                case 10: {
                    this.mThumbDrawable = ta.getDrawable(index);
                    continue block16;
                }
                case 13: {
                    this.mTrackDrawable = ta.getDrawable(index);
                    continue block16;
                }
                case 0: {
                    this.mTextAppearance = ta.getResourceId(index, 0);
                    continue block16;
                }
                case 2: {
                    this.mTextColor = ta.getColorStateList(index);
                    continue block16;
                }
                case 1: {
                    this.mTextSize = ta.getDimensionPixelSize(index, 0);
                    continue block16;
                }
                case 4: {
                    this.mPreviewMinWidth = ta.getDimensionPixelSize(index, 0);
                    continue block16;
                }
                case 5: {
                    this.mPreviewMinHeight = ta.getDimensionPixelSize(index, 0);
                    continue block16;
                }
                case 12: {
                    this.mThumbMinWidth = ta.getDimensionPixelSize(index, 0);
                    continue block16;
                }
                case 11: {
                    this.mThumbMinHeight = ta.getDimensionPixelSize(index, 0);
                    continue block16;
                }
                case 3: {
                    this.mPreviewPadding = ta.getDimensionPixelSize(index, 0);
                    continue block16;
                }
                case 6: {
                    this.mThumbPosition = ta.getInt(index, 0);
                }
            }
        }
        ta.recycle();
        this.updateAppearance();
    }

    private final void $$robo$$android_widget_FastScroller$remove() {
        this.mOverlay.remove(this.mTrackImage);
        this.mOverlay.remove(this.mThumbImage);
        this.mOverlay.remove(this.mPreviewImage);
        this.mOverlay.remove(this.mPrimaryText);
        this.mOverlay.remove(this.mSecondaryText);
    }

    private final void $$robo$$android_widget_FastScroller$setEnabled(boolean enabled) {
        if (this.mEnabled != enabled) {
            this.mEnabled = enabled;
            this.onStateDependencyChanged(true);
        }
    }

    private final boolean $$robo$$android_widget_FastScroller$isEnabled() {
        return this.mEnabled && (this.mLongList || this.mAlwaysShow);
    }

    private final void $$robo$$android_widget_FastScroller$setAlwaysShow(boolean alwaysShow) {
        if (this.mAlwaysShow != alwaysShow) {
            this.mAlwaysShow = alwaysShow;
            this.onStateDependencyChanged(false);
        }
    }

    private final boolean $$robo$$android_widget_FastScroller$isAlwaysShowEnabled() {
        return this.mAlwaysShow;
    }

    private final void $$robo$$android_widget_FastScroller$onStateDependencyChanged(boolean peekIfEnabled) {
        if (this.isEnabled()) {
            if (this.isAlwaysShowEnabled()) {
                this.setState(1);
            } else if (this.mState == 1) {
                this.postAutoHide();
            } else if (peekIfEnabled) {
                this.setState(1);
                this.postAutoHide();
            }
        } else {
            this.stop();
        }
        this.mList.resolvePadding();
    }

    private final void $$robo$$android_widget_FastScroller$setScrollBarStyle(int style2) {
        if (this.mScrollBarStyle != style2) {
            this.mScrollBarStyle = style2;
            this.updateLayout();
        }
    }

    private final void $$robo$$android_widget_FastScroller$stop() {
        this.setState(0);
    }

    private final void $$robo$$android_widget_FastScroller$setScrollbarPosition(int position) {
        if (position == 0) {
            int n = position = this.mList.isLayoutRtl() ? 1 : 2;
        }
        if (this.mScrollbarPosition != position) {
            this.mScrollbarPosition = position;
            this.mLayoutFromRight = position != 1;
            int previewResId = this.mPreviewResId[this.mLayoutFromRight ? 1 : 0];
            this.mPreviewImage.setBackgroundResource(previewResId);
            int textMinWidth = Math.max(0, this.mPreviewMinWidth - this.mPreviewImage.getPaddingLeft() - this.mPreviewImage.getPaddingRight());
            this.mPrimaryText.setMinimumWidth(textMinWidth);
            this.mSecondaryText.setMinimumWidth(textMinWidth);
            int textMinHeight = Math.max(0, this.mPreviewMinHeight - this.mPreviewImage.getPaddingTop() - this.mPreviewImage.getPaddingBottom());
            this.mPrimaryText.setMinimumHeight(textMinHeight);
            this.mSecondaryText.setMinimumHeight(textMinHeight);
            this.updateLayout();
        }
    }

    private final int $$robo$$android_widget_FastScroller$getWidth() {
        return this.mWidth;
    }

    private final void $$robo$$android_widget_FastScroller$onSizeChanged(int w, int h, int oldw, int oldh) {
        this.updateLayout();
    }

    private final void $$robo$$android_widget_FastScroller$onItemCountChanged(int childCount, int itemCount) {
        if (this.mOldItemCount != itemCount || this.mOldChildCount != childCount) {
            boolean hasMoreItems;
            this.mOldItemCount = itemCount;
            this.mOldChildCount = childCount;
            boolean bl = hasMoreItems = itemCount - childCount > 0;
            if (hasMoreItems && this.mState != 2) {
                int firstVisibleItem = this.mList.getFirstVisiblePosition();
                this.setThumbPos(this.getPosFromItemCount(firstVisibleItem, childCount, itemCount));
            }
            this.updateLongList(childCount, itemCount);
        }
    }

    private final void $$robo$$android_widget_FastScroller$updateLongList(int childCount, int itemCount) {
        boolean longList;
        boolean bl = longList = childCount > 0 && itemCount / childCount >= 4;
        if (this.mLongList != longList) {
            this.mLongList = longList;
            this.onStateDependencyChanged(false);
        }
    }

    private final TextView $$robo$$android_widget_FastScroller$createPreviewTextView(Context context) {
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-2, -2);
        TextView textView = new TextView(context);
        textView.setLayoutParams(params);
        textView.setSingleLine(true);
        textView.setEllipsize(TextUtils.TruncateAt.MIDDLE);
        textView.setGravity(17);
        textView.setAlpha(0.0f);
        textView.setLayoutDirection(this.mList.getLayoutDirection());
        return textView;
    }

    private final void $$robo$$android_widget_FastScroller$updateLayout() {
        if (this.mUpdatingLayout) {
            return;
        }
        this.mUpdatingLayout = true;
        this.updateContainerRect();
        this.layoutThumb();
        this.layoutTrack();
        this.updateOffsetAndRange();
        Rect bounds = this.mTempBounds;
        this.measurePreview(this.mPrimaryText, bounds);
        this.applyLayout(this.mPrimaryText, bounds);
        this.measurePreview(this.mSecondaryText, bounds);
        this.applyLayout(this.mSecondaryText, bounds);
        if (this.mPreviewImage != null) {
            bounds.left -= this.mPreviewImage.getPaddingLeft();
            bounds.top -= this.mPreviewImage.getPaddingTop();
            bounds.right += this.mPreviewImage.getPaddingRight();
            bounds.bottom += this.mPreviewImage.getPaddingBottom();
            this.applyLayout(this.mPreviewImage, bounds);
        }
        this.mUpdatingLayout = false;
    }

    private final void $$robo$$android_widget_FastScroller$applyLayout(View view, Rect bounds) {
        view.layout(bounds.left, bounds.top, bounds.right, bounds.bottom);
        view.setPivotX(this.mLayoutFromRight ? (float)(bounds.right - bounds.left) : 0.0f);
    }

    private final void $$robo$$android_widget_FastScroller$measurePreview(View v, Rect out) {
        Rect margins = this.mTempMargins;
        margins.left = this.mPreviewImage.getPaddingLeft();
        margins.top = this.mPreviewImage.getPaddingTop();
        margins.right = this.mPreviewImage.getPaddingRight();
        margins.bottom = this.mPreviewImage.getPaddingBottom();
        if (this.mOverlayPosition == 0) {
            this.measureFloating(v, margins, out);
        } else {
            this.measureViewToSide(v, this.mThumbImage, margins, out);
        }
    }

    private final void $$robo$$android_widget_FastScroller$measureViewToSide(View view, View adjacent, Rect margins, Rect out) {
        int left;
        int right;
        int marginRight;
        int marginTop;
        int marginLeft;
        if (margins == null) {
            marginLeft = 0;
            marginTop = 0;
            marginRight = 0;
        } else {
            marginLeft = margins.left;
            marginTop = margins.top;
            marginRight = margins.right;
        }
        Rect container = this.mContainerRect;
        int containerWidth = container.width();
        int maxWidth = adjacent == null ? containerWidth : (this.mLayoutFromRight ? adjacent.getLeft() : containerWidth - adjacent.getRight());
        int adjMaxHeight = Math.max(0, container.height());
        int adjMaxWidth = Math.max(0, maxWidth - marginLeft - marginRight);
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(adjMaxWidth, Integer.MIN_VALUE);
        int heightMeasureSpec = View.MeasureSpec.makeSafeMeasureSpec(adjMaxHeight, 0);
        view.measure(widthMeasureSpec, heightMeasureSpec);
        int width = Math.min(adjMaxWidth, view.getMeasuredWidth());
        if (this.mLayoutFromRight) {
            right = (adjacent == null ? container.right : adjacent.getLeft()) - marginRight;
            left = right - width;
        } else {
            left = (adjacent == null ? container.left : adjacent.getRight()) + marginLeft;
            right = left + width;
        }
        int top = marginTop;
        int bottom = top + view.getMeasuredHeight();
        out.set(left, top, right, bottom);
    }

    private final void $$robo$$android_widget_FastScroller$measureFloating(View preview, Rect margins, Rect out) {
        int marginRight;
        int marginTop;
        int marginLeft;
        if (margins == null) {
            marginLeft = 0;
            marginTop = 0;
            marginRight = 0;
        } else {
            marginLeft = margins.left;
            marginTop = margins.top;
            marginRight = margins.right;
        }
        Rect container = this.mContainerRect;
        int containerWidth = container.width();
        int adjMaxHeight = Math.max(0, container.height());
        int adjMaxWidth = Math.max(0, containerWidth - marginLeft - marginRight);
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(adjMaxWidth, Integer.MIN_VALUE);
        int heightMeasureSpec = View.MeasureSpec.makeSafeMeasureSpec(adjMaxHeight, 0);
        preview.measure(widthMeasureSpec, heightMeasureSpec);
        int containerHeight = container.height();
        int width = preview.getMeasuredWidth();
        int top = containerHeight / 10 + marginTop + container.top;
        int bottom = top + preview.getMeasuredHeight();
        int left = (containerWidth - width) / 2 + container.left;
        int right = left + width;
        out.set(left, top, right, bottom);
    }

    private final void $$robo$$android_widget_FastScroller$updateContainerRect() {
        AbsListView list = this.mList;
        list.resolvePadding();
        Rect container = this.mContainerRect;
        container.left = 0;
        container.top = 0;
        container.right = list.getWidth();
        container.bottom = list.getHeight();
        int scrollbarStyle = this.mScrollBarStyle;
        if (scrollbarStyle == 0x1000000 || scrollbarStyle == 0) {
            container.left += list.getPaddingLeft();
            container.top += list.getPaddingTop();
            container.right -= list.getPaddingRight();
            container.bottom -= list.getPaddingBottom();
            if (scrollbarStyle == 0x1000000) {
                int width = this.getWidth();
                if (this.mScrollbarPosition == 2) {
                    container.right += width;
                } else {
                    container.left -= width;
                }
            }
        }
    }

    private final void $$robo$$android_widget_FastScroller$layoutThumb() {
        Rect bounds = this.mTempBounds;
        this.measureViewToSide(this.mThumbImage, null, null, bounds);
        this.applyLayout(this.mThumbImage, bounds);
    }

    private final void $$robo$$android_widget_FastScroller$layoutTrack() {
        int bottom;
        int top;
        ImageView track = this.mTrackImage;
        ImageView thumb = this.mThumbImage;
        Rect container = this.mContainerRect;
        int maxWidth = Math.max(0, container.width());
        int maxHeight = Math.max(0, container.height());
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(maxWidth, Integer.MIN_VALUE);
        int heightMeasureSpec = View.MeasureSpec.makeSafeMeasureSpec(maxHeight, 0);
        track.measure(widthMeasureSpec, heightMeasureSpec);
        if (this.mThumbPosition == 1) {
            top = container.top;
            bottom = container.bottom;
        } else {
            int thumbHalfHeight = thumb.getHeight() / 2;
            top = container.top + thumbHalfHeight;
            bottom = container.bottom - thumbHalfHeight;
        }
        int trackWidth = track.getMeasuredWidth();
        int left = thumb.getLeft() + (thumb.getWidth() - trackWidth) / 2;
        int right = left + trackWidth;
        track.layout(left, top, right, bottom);
    }

    private final void $$robo$$android_widget_FastScroller$updateOffsetAndRange() {
        float max;
        float min;
        ImageView trackImage = this.mTrackImage;
        ImageView thumbImage = this.mThumbImage;
        if (this.mThumbPosition == 1) {
            float halfThumbHeight = (float)thumbImage.getHeight() / 2.0f;
            min = (float)trackImage.getTop() + halfThumbHeight;
            max = (float)trackImage.getBottom() - halfThumbHeight;
        } else {
            min = trackImage.getTop();
            max = trackImage.getBottom();
        }
        this.mThumbOffset = min;
        this.mThumbRange = max - min;
    }

    private final void $$robo$$android_widget_FastScroller$setState(int state) {
        this.mList.removeCallbacks(this.mDeferHide);
        if (this.mAlwaysShow && state == 0) {
            state = 1;
        }
        if (state == this.mState) {
            return;
        }
        switch (state) {
            case 0: {
                this.transitionToHidden();
                break;
            }
            case 1: {
                this.transitionToVisible();
                break;
            }
            case 2: {
                if (this.transitionPreviewLayout(this.mCurrentSection)) {
                    this.transitionToDragging();
                    break;
                }
                this.transitionToVisible();
            }
        }
        this.mState = state;
        this.refreshDrawablePressedState();
    }

    private final void $$robo$$android_widget_FastScroller$refreshDrawablePressedState() {
        boolean isPressed = this.mState == 2;
        this.mThumbImage.setPressed(isPressed);
        this.mTrackImage.setPressed(isPressed);
    }

    private final void $$robo$$android_widget_FastScroller$transitionToHidden() {
        if (this.mDecorAnimation != null) {
            this.mDecorAnimation.cancel();
        }
        Animator fadeOut = FastScroller.groupAnimatorOfFloat(View.ALPHA, 0.0f, this.mThumbImage, this.mTrackImage, this.mPreviewImage, this.mPrimaryText, this.mSecondaryText).setDuration(300L);
        float offset = this.mLayoutFromRight ? (float)this.mThumbImage.getWidth() : (float)(-this.mThumbImage.getWidth());
        Animator slideOut = FastScroller.groupAnimatorOfFloat(View.TRANSLATION_X, offset, this.mThumbImage, this.mTrackImage).setDuration(300L);
        this.mDecorAnimation = new AnimatorSet();
        this.mDecorAnimation.playTogether(fadeOut, slideOut);
        this.mDecorAnimation.start();
        this.mShowingPreview = false;
    }

    private final void $$robo$$android_widget_FastScroller$transitionToVisible() {
        if (this.mDecorAnimation != null) {
            this.mDecorAnimation.cancel();
        }
        Animator fadeIn = FastScroller.groupAnimatorOfFloat(View.ALPHA, 1.0f, this.mThumbImage, this.mTrackImage).setDuration(150L);
        Animator fadeOut = FastScroller.groupAnimatorOfFloat(View.ALPHA, 0.0f, this.mPreviewImage, this.mPrimaryText, this.mSecondaryText).setDuration(300L);
        Animator slideIn = FastScroller.groupAnimatorOfFloat(View.TRANSLATION_X, 0.0f, this.mThumbImage, this.mTrackImage).setDuration(150L);
        this.mDecorAnimation = new AnimatorSet();
        this.mDecorAnimation.playTogether(fadeIn, fadeOut, slideIn);
        this.mDecorAnimation.start();
        this.mShowingPreview = false;
    }

    private final void $$robo$$android_widget_FastScroller$transitionToDragging() {
        if (this.mDecorAnimation != null) {
            this.mDecorAnimation.cancel();
        }
        Animator fadeIn = FastScroller.groupAnimatorOfFloat(View.ALPHA, 1.0f, this.mThumbImage, this.mTrackImage, this.mPreviewImage).setDuration(150L);
        Animator slideIn = FastScroller.groupAnimatorOfFloat(View.TRANSLATION_X, 0.0f, this.mThumbImage, this.mTrackImage).setDuration(150L);
        this.mDecorAnimation = new AnimatorSet();
        this.mDecorAnimation.playTogether(fadeIn, slideIn);
        this.mDecorAnimation.start();
        this.mShowingPreview = true;
    }

    private final void $$robo$$android_widget_FastScroller$postAutoHide() {
        this.mList.removeCallbacks(this.mDeferHide);
        this.mList.postDelayed(this.mDeferHide, 1500L);
    }

    private final void $$robo$$android_widget_FastScroller$onScroll(int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        boolean hasMoreItems;
        if (!this.isEnabled()) {
            this.setState(0);
            return;
        }
        boolean bl = hasMoreItems = totalItemCount - visibleItemCount > 0;
        if (hasMoreItems && this.mState != 2) {
            this.setThumbPos(this.getPosFromItemCount(firstVisibleItem, visibleItemCount, totalItemCount));
        }
        this.mScrollCompleted = true;
        if (this.mFirstVisibleItem != firstVisibleItem) {
            this.mFirstVisibleItem = firstVisibleItem;
            if (this.mState != 2) {
                this.setState(1);
                this.postAutoHide();
            }
        }
    }

    private final void $$robo$$android_widget_FastScroller$getSectionsFromIndexer() {
        this.mSectionIndexer = null;
        Object adapter = this.mList.getAdapter();
        if (adapter instanceof HeaderViewListAdapter) {
            this.mHeaderCount = ((HeaderViewListAdapter)adapter).getHeadersCount();
            adapter = ((HeaderViewListAdapter)adapter).getWrappedAdapter();
        }
        if (adapter instanceof ExpandableListConnector) {
            ExpandableListAdapter expAdapter = ((ExpandableListConnector)adapter).getAdapter();
            if (expAdapter instanceof SectionIndexer) {
                this.mSectionIndexer = (SectionIndexer)((Object)expAdapter);
                this.mListAdapter = adapter;
                this.mSections = this.mSectionIndexer.getSections();
            }
        } else if (adapter instanceof SectionIndexer) {
            this.mListAdapter = adapter;
            this.mSectionIndexer = (SectionIndexer)adapter;
            this.mSections = this.mSectionIndexer.getSections();
        } else {
            this.mListAdapter = adapter;
            this.mSections = null;
        }
    }

    private final void $$robo$$android_widget_FastScroller$onSectionsChanged() {
        this.mListAdapter = null;
    }

    private final void $$robo$$android_widget_FastScroller$scrollTo(float position) {
        int sectionIndex;
        int sectionCount;
        this.mScrollCompleted = false;
        int count = this.mList.getCount();
        Object[] sections = this.mSections;
        int n = sectionCount = sections == null ? 0 : sections.length;
        if (sections != null && sectionCount > 1) {
            int exactSection;
            int targetSection = exactSection = MathUtils.constrain((int)(position * (float)sectionCount), 0, sectionCount - 1);
            int targetIndex = this.mSectionIndexer.getPositionForSection(targetSection);
            sectionIndex = targetSection;
            int nextIndex = count;
            int prevIndex = targetIndex;
            int prevSection = targetSection;
            int nextSection = targetSection + 1;
            if (targetSection < sectionCount - 1) {
                nextIndex = this.mSectionIndexer.getPositionForSection(targetSection + 1);
            }
            if (nextIndex == targetIndex) {
                while (targetSection > 0) {
                    if ((prevIndex = this.mSectionIndexer.getPositionForSection(--targetSection)) != targetIndex) {
                        prevSection = targetSection;
                        sectionIndex = targetSection;
                        break;
                    }
                    if (targetSection != 0) continue;
                    sectionIndex = 0;
                    break;
                }
            }
            int nextNextSection = nextSection + 1;
            while (nextNextSection < sectionCount && this.mSectionIndexer.getPositionForSection(nextNextSection) == nextIndex) {
                ++nextNextSection;
                ++nextSection;
            }
            float prevPosition = (float)prevSection / (float)sectionCount;
            float nextPosition = (float)nextSection / (float)sectionCount;
            float snapThreshold = count == 0 ? Float.MAX_VALUE : 0.125f / (float)count;
            targetIndex = prevSection == exactSection && position - prevPosition < snapThreshold ? prevIndex : prevIndex + (int)((float)(nextIndex - prevIndex) * (position - prevPosition) / (nextPosition - prevPosition));
            targetIndex = MathUtils.constrain(targetIndex, 0, count - 1);
            if (this.mList instanceof ExpandableListView) {
                ExpandableListView expList = (ExpandableListView)this.mList;
                expList.setSelectionFromTop(expList.getFlatListPosition(ExpandableListView.getPackedPositionForGroup(targetIndex + this.mHeaderCount)), 0);
            } else if (this.mList instanceof ListView) {
                ((ListView)this.mList).setSelectionFromTop(targetIndex + this.mHeaderCount, 0);
            } else {
                this.mList.setSelection(targetIndex + this.mHeaderCount);
            }
        } else {
            int index = MathUtils.constrain((int)(position * (float)count), 0, count - 1);
            if (this.mList instanceof ExpandableListView) {
                ExpandableListView expList = (ExpandableListView)this.mList;
                expList.setSelectionFromTop(expList.getFlatListPosition(ExpandableListView.getPackedPositionForGroup(index + this.mHeaderCount)), 0);
            } else if (this.mList instanceof ListView) {
                ((ListView)this.mList).setSelectionFromTop(index + this.mHeaderCount, 0);
            } else {
                this.mList.setSelection(index + this.mHeaderCount);
            }
            sectionIndex = -1;
        }
        if (this.mCurrentSection != sectionIndex) {
            this.mCurrentSection = sectionIndex;
            boolean hasPreview = this.transitionPreviewLayout(sectionIndex);
            if (!this.mShowingPreview && hasPreview) {
                this.transitionToDragging();
            } else if (this.mShowingPreview && !hasPreview) {
                this.transitionToVisible();
            }
        }
    }

    private final boolean $$robo$$android_widget_FastScroller$transitionPreviewLayout(int sectionIndex) {
        TextView target;
        TextView showing;
        Object section;
        Object[] sections = this.mSections;
        String text = null;
        if (sections != null && sectionIndex >= 0 && sectionIndex < sections.length && (section = sections[sectionIndex]) != null) {
            text = section.toString();
        }
        Rect bounds = this.mTempBounds;
        View preview = this.mPreviewImage;
        if (this.mShowingPrimary) {
            showing = this.mPrimaryText;
            target = this.mSecondaryText;
        } else {
            showing = this.mSecondaryText;
            target = this.mPrimaryText;
        }
        target.setText(text);
        this.measurePreview(target, bounds);
        this.applyLayout(target, bounds);
        if (this.mPreviewAnimation != null) {
            this.mPreviewAnimation.cancel();
        }
        Animator showTarget = FastScroller.animateAlpha(target, 1.0f).setDuration(50L);
        Animator hideShowing = FastScroller.animateAlpha(showing, 0.0f).setDuration(50L);
        hideShowing.addListener(this.mSwitchPrimaryListener);
        bounds.left -= preview.getPaddingLeft();
        bounds.top -= preview.getPaddingTop();
        bounds.right += preview.getPaddingRight();
        bounds.bottom += preview.getPaddingBottom();
        Animator resizePreview = FastScroller.animateBounds(preview, bounds);
        resizePreview.setDuration(100L);
        this.mPreviewAnimation = new AnimatorSet();
        AnimatorSet.Builder builder = this.mPreviewAnimation.play(hideShowing).with(showTarget);
        builder.with(resizePreview);
        int previewWidth = preview.getWidth() - preview.getPaddingLeft() - preview.getPaddingRight();
        int targetWidth = target.getWidth();
        if (targetWidth > previewWidth) {
            target.setScaleX((float)previewWidth / (float)targetWidth);
            Animator scaleAnim = FastScroller.animateScaleX(target, 1.0f).setDuration(100L);
            builder.with(scaleAnim);
        } else {
            target.setScaleX(1.0f);
        }
        int showingWidth = showing.getWidth();
        if (showingWidth > targetWidth) {
            float scale = (float)targetWidth / (float)showingWidth;
            Animator scaleAnim = FastScroller.animateScaleX(showing, scale).setDuration(100L);
            builder.with(scaleAnim);
        }
        this.mPreviewAnimation.start();
        return !TextUtils.isEmpty(text);
    }

    private final void $$robo$$android_widget_FastScroller$setThumbPos(float position) {
        float previewPos;
        float thumbMiddle = position * this.mThumbRange + this.mThumbOffset;
        this.mThumbImage.setTranslationY(thumbMiddle - (float)this.mThumbImage.getHeight() / 2.0f);
        View previewImage = this.mPreviewImage;
        float previewHalfHeight = (float)previewImage.getHeight() / 2.0f;
        switch (this.mOverlayPosition) {
            case 1: {
                previewPos = thumbMiddle;
                break;
            }
            case 2: {
                previewPos = thumbMiddle - previewHalfHeight;
                break;
            }
            default: {
                previewPos = 0.0f;
            }
        }
        Rect container = this.mContainerRect;
        int top = container.top;
        int bottom = container.bottom;
        float minP = (float)top + previewHalfHeight;
        float maxP = (float)bottom - previewHalfHeight;
        float previewMiddle = MathUtils.constrain(previewPos, minP, maxP);
        float previewTop = previewMiddle - previewHalfHeight;
        previewImage.setTranslationY(previewTop);
        this.mPrimaryText.setTranslationY(previewTop);
        this.mSecondaryText.setTranslationY(previewTop);
    }

    private final float $$robo$$android_widget_FastScroller$getPosFromMotionEvent(float y) {
        if (this.mThumbRange <= 0.0f) {
            return 0.0f;
        }
        return MathUtils.constrain((y - this.mThumbOffset) / this.mThumbRange, 0.0f, 1.0f);
    }

    private final float $$robo$$android_widget_FastScroller$getPosFromItemCount(int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        int positionsInSection;
        boolean hasSections;
        SectionIndexer sectionIndexer = this.mSectionIndexer;
        if (sectionIndexer == null || this.mListAdapter == null) {
            this.getSectionsFromIndexer();
        }
        if (visibleItemCount == 0 || totalItemCount == 0) {
            return 0.0f;
        }
        boolean bl = hasSections = sectionIndexer != null && this.mSections != null && this.mSections.length > 0;
        if (!hasSections || !this.mMatchDragPosition) {
            if (visibleItemCount == totalItemCount) {
                return 0.0f;
            }
            return (float)firstVisibleItem / (float)(totalItemCount - visibleItemCount);
        }
        if ((firstVisibleItem -= this.mHeaderCount) < 0) {
            return 0.0f;
        }
        totalItemCount -= this.mHeaderCount;
        View child = this.mList.getChildAt(0);
        float incrementalPos = child == null || child.getHeight() == 0 ? 0.0f : (float)(this.mList.getPaddingTop() - child.getTop()) / (float)child.getHeight();
        int section = sectionIndexer.getSectionForPosition(firstVisibleItem);
        int sectionPos = sectionIndexer.getPositionForSection(section);
        int sectionCount = this.mSections.length;
        if (section < sectionCount - 1) {
            int nextSectionPos = section + 1 < sectionCount ? sectionIndexer.getPositionForSection(section + 1) : totalItemCount - 1;
            positionsInSection = nextSectionPos - sectionPos;
        } else {
            positionsInSection = totalItemCount - sectionPos;
        }
        float posWithinSection = positionsInSection == 0 ? 0.0f : ((float)firstVisibleItem + incrementalPos - (float)sectionPos) / (float)positionsInSection;
        float result = ((float)section + posWithinSection) / (float)sectionCount;
        if (firstVisibleItem > 0 && firstVisibleItem + visibleItemCount == totalItemCount) {
            int currentVisibleSize;
            int maxSize;
            View lastChild = this.mList.getChildAt(visibleItemCount - 1);
            int bottomPadding = this.mList.getPaddingBottom();
            if (this.mList.getClipToPadding()) {
                maxSize = lastChild.getHeight();
                currentVisibleSize = this.mList.getHeight() - bottomPadding - lastChild.getTop();
            } else {
                maxSize = lastChild.getHeight() + bottomPadding;
                currentVisibleSize = this.mList.getHeight() - lastChild.getTop();
            }
            if (currentVisibleSize > 0 && maxSize > 0) {
                result += (1.0f - result) * ((float)currentVisibleSize / (float)maxSize);
            }
        }
        return result;
    }

    private final void $$robo$$android_widget_FastScroller$cancelFling() {
        MotionEvent cancelFling = MotionEvent.obtain(0L, 0L, 3, 0.0f, 0.0f, 0);
        this.mList.onTouchEvent(cancelFling);
        cancelFling.recycle();
    }

    private final void $$robo$$android_widget_FastScroller$cancelPendingDrag() {
        this.mPendingDrag = -1L;
    }

    private final void $$robo$$android_widget_FastScroller$startPendingDrag() {
        this.mPendingDrag = SystemClock.uptimeMillis() + TAP_TIMEOUT;
    }

    private final void $$robo$$android_widget_FastScroller$beginDrag() {
        this.mPendingDrag = -1L;
        this.setState(2);
        if (this.mListAdapter == null && this.mList != null) {
            this.getSectionsFromIndexer();
        }
        if (this.mList != null) {
            this.mList.requestDisallowInterceptTouchEvent(true);
            this.mList.reportScrollStateChange(1);
        }
        this.cancelFling();
    }

    private final boolean $$robo$$android_widget_FastScroller$onInterceptTouchEvent(MotionEvent ev) {
        if (!this.isEnabled()) {
            return false;
        }
        switch (ev.getActionMasked()) {
            case 0: {
                if (!this.isPointInside(ev.getX(), ev.getY())) break;
                if (!this.mList.isInScrollingContainer()) {
                    return true;
                }
                this.mInitialTouchY = ev.getY();
                this.startPendingDrag();
                break;
            }
            case 2: {
                if (!this.isPointInside(ev.getX(), ev.getY())) {
                    this.cancelPendingDrag();
                    break;
                }
                if (this.mPendingDrag < 0L || this.mPendingDrag > SystemClock.uptimeMillis()) break;
                this.beginDrag();
                float pos = this.getPosFromMotionEvent(this.mInitialTouchY);
                this.scrollTo(pos);
                return this.onTouchEvent(ev);
            }
            case 1: 
            case 3: {
                this.cancelPendingDrag();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_widget_FastScroller$onInterceptHoverEvent(MotionEvent ev) {
        if (!this.isEnabled()) {
            return false;
        }
        int actionMasked = ev.getActionMasked();
        if ((actionMasked == 9 || actionMasked == 7) && this.mState == 0 && this.isPointInside(ev.getX(), ev.getY())) {
            this.setState(1);
            this.postAutoHide();
        }
        return false;
    }

    private final PointerIcon $$robo$$android_widget_FastScroller$onResolvePointerIcon(MotionEvent event, int pointerIndex) {
        if (this.mState == 2 || this.isPointInside(event.getX(), event.getY())) {
            return PointerIcon.getSystemIcon(this.mList.getContext(), 1000);
        }
        return null;
    }

    private final boolean $$robo$$android_widget_FastScroller$onTouchEvent(MotionEvent me) {
        if (!this.isEnabled()) {
            return false;
        }
        switch (me.getActionMasked()) {
            case 0: {
                if (!this.isPointInside(me.getX(), me.getY()) || this.mList.isInScrollingContainer()) break;
                this.beginDrag();
                return true;
            }
            case 1: {
                if (this.mPendingDrag >= 0L) {
                    this.beginDrag();
                    float pos = this.getPosFromMotionEvent(me.getY());
                    this.setThumbPos(pos);
                    this.scrollTo(pos);
                }
                if (this.mState != 2) break;
                if (this.mList != null) {
                    this.mList.requestDisallowInterceptTouchEvent(false);
                    this.mList.reportScrollStateChange(0);
                }
                this.setState(1);
                this.postAutoHide();
                return true;
            }
            case 2: {
                if (this.mPendingDrag >= 0L && Math.abs(me.getY() - this.mInitialTouchY) > (float)this.mScaledTouchSlop) {
                    this.beginDrag();
                }
                if (this.mState != 2) break;
                float pos = this.getPosFromMotionEvent(me.getY());
                this.setThumbPos(pos);
                if (this.mScrollCompleted) {
                    this.scrollTo(pos);
                }
                return true;
            }
            case 3: {
                this.cancelPendingDrag();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_widget_FastScroller$isPointInside(float x, float y) {
        return this.isPointInsideX(x) && (this.mTrackDrawable != null || this.isPointInsideY(y));
    }

    private final boolean $$robo$$android_widget_FastScroller$isPointInsideX(float x) {
        float adjust;
        float offset = this.mThumbImage.getTranslationX();
        float left = (float)this.mThumbImage.getLeft() + offset;
        float right = (float)this.mThumbImage.getRight() + offset;
        float targetSizeDiff = (float)this.mMinimumTouchTarget - (right - left);
        float f = adjust = targetSizeDiff > 0.0f ? targetSizeDiff : 0.0f;
        if (this.mLayoutFromRight) {
            return x >= (float)this.mThumbImage.getLeft() - adjust;
        }
        return x <= (float)this.mThumbImage.getRight() + adjust;
    }

    private final boolean $$robo$$android_widget_FastScroller$isPointInsideY(float y) {
        float offset = this.mThumbImage.getTranslationY();
        float top = (float)this.mThumbImage.getTop() + offset;
        float bottom = (float)this.mThumbImage.getBottom() + offset;
        float targetSizeDiff = (float)this.mMinimumTouchTarget - (bottom - top);
        float adjust = targetSizeDiff > 0.0f ? targetSizeDiff / 2.0f : 0.0f;
        return y >= top - adjust && y <= bottom + adjust;
    }

    private static final Animator $$robo$$android_widget_FastScroller$groupAnimatorOfFloat(Property<View, Float> property, float value, View ... views) {
        AnimatorSet animSet = new AnimatorSet();
        AnimatorSet.Builder builder = null;
        for (int i = views.length - 1; i >= 0; --i) {
            ObjectAnimator anim2 = ObjectAnimator.ofFloat(views[i], property, value);
            if (builder == null) {
                builder = animSet.play(anim2);
                continue;
            }
            builder.with(anim2);
        }
        return animSet;
    }

    private static final Animator $$robo$$android_widget_FastScroller$animateScaleX(View v, float target) {
        return ObjectAnimator.ofFloat(v, View.SCALE_X, target);
    }

    private static final Animator $$robo$$android_widget_FastScroller$animateAlpha(View v, float alpha) {
        return ObjectAnimator.ofFloat(v, View.ALPHA, alpha);
    }

    private static final Animator $$robo$$android_widget_FastScroller$animateBounds(View v, Rect bounds) {
        PropertyValuesHolder left = PropertyValuesHolder.ofInt(LEFT, bounds.left);
        PropertyValuesHolder top = PropertyValuesHolder.ofInt(TOP, bounds.top);
        PropertyValuesHolder right = PropertyValuesHolder.ofInt(RIGHT, bounds.right);
        PropertyValuesHolder bottom = PropertyValuesHolder.ofInt(BOTTOM, bounds.bottom);
        return ObjectAnimator.ofPropertyValuesHolder(v, left, top, right, bottom);
    }

    static void __staticInitializer__() {
        TAP_TIMEOUT = ViewConfiguration.getTapTimeout();
        LEFT = new IntProperty<View>("left"){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_widget_FastScroller_3$__constructor__(String x0) {
            }

            private final void $$robo$$android_widget_FastScroller_3$setValue(View object, int value) {
                object.setLeft(value);
            }

            private final Integer $$robo$$android_widget_FastScroller_3$get(View object) {
                return object.getLeft();
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_widget_FastScroller_3$__constructor__(string2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FastScroller_3$__constructor__(java.lang.String ), 0, this, string2);
            }

            @Override
            public void setValue(View view, int n) {
                InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_widget_FastScroller_3$setValue(android.view.View int ), 0, this, view, n);
            }

            @Override
            public Integer get(View view) {
                return InvokeDynamicSupport.bootstrap("get", $$robo$$android_widget_FastScroller_3$get(android.view.View ), 0, this, view);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        TOP = new IntProperty<View>("top"){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_widget_FastScroller_4$__constructor__(String x0) {
            }

            private final void $$robo$$android_widget_FastScroller_4$setValue(View object, int value) {
                object.setTop(value);
            }

            private final Integer $$robo$$android_widget_FastScroller_4$get(View object) {
                return object.getTop();
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_widget_FastScroller_4$__constructor__(string2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FastScroller_4$__constructor__(java.lang.String ), 0, this, string2);
            }

            @Override
            public void setValue(View view, int n) {
                InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_widget_FastScroller_4$setValue(android.view.View int ), 0, this, view, n);
            }

            @Override
            public Integer get(View view) {
                return InvokeDynamicSupport.bootstrap("get", $$robo$$android_widget_FastScroller_4$get(android.view.View ), 0, this, view);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        RIGHT = new IntProperty<View>("right"){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_widget_FastScroller_5$__constructor__(String x0) {
            }

            private final void $$robo$$android_widget_FastScroller_5$setValue(View object, int value) {
                object.setRight(value);
            }

            private final Integer $$robo$$android_widget_FastScroller_5$get(View object) {
                return object.getRight();
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_widget_FastScroller_5$__constructor__(string2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FastScroller_5$__constructor__(java.lang.String ), 0, this, string2);
            }

            @Override
            public void setValue(View view, int n) {
                InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_widget_FastScroller_5$setValue(android.view.View int ), 0, this, view, n);
            }

            @Override
            public Integer get(View view) {
                return InvokeDynamicSupport.bootstrap("get", $$robo$$android_widget_FastScroller_5$get(android.view.View ), 0, this, view);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        BOTTOM = new IntProperty<View>("bottom"){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_widget_FastScroller_6$__constructor__(String x0) {
            }

            private final void $$robo$$android_widget_FastScroller_6$setValue(View object, int value) {
                object.setBottom(value);
            }

            private final Integer $$robo$$android_widget_FastScroller_6$get(View object) {
                return object.getBottom();
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_widget_FastScroller_6$__constructor__(string2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FastScroller_6$__constructor__(java.lang.String ), 0, this, string2);
            }

            @Override
            public void setValue(View view, int n) {
                InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_widget_FastScroller_6$setValue(android.view.View int ), 0, this, view, n);
            }

            @Override
            public Integer get(View view) {
                return InvokeDynamicSupport.bootstrap("get", $$robo$$android_widget_FastScroller_6$get(android.view.View ), 0, this, view);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(AbsListView absListView, int n) {
        this.$$robo$$android_widget_FastScroller$__constructor__(absListView, n);
    }

    public FastScroller(AbsListView absListView, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FastScroller$__constructor__(android.widget.AbsListView int ), 0, this, absListView, n);
    }

    private void updateAppearance() {
        InvokeDynamicSupport.bootstrap("updateAppearance", $$robo$$android_widget_FastScroller$updateAppearance(), 0, this);
    }

    public void setStyle(int n) {
        InvokeDynamicSupport.bootstrap("setStyle", $$robo$$android_widget_FastScroller$setStyle(int ), 0, this, n);
    }

    public void remove() {
        InvokeDynamicSupport.bootstrap("remove", $$robo$$android_widget_FastScroller$remove(), 0, this);
    }

    public void setEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_widget_FastScroller$setEnabled(boolean ), 0, this, bl);
    }

    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_widget_FastScroller$isEnabled(), 0, this);
    }

    public void setAlwaysShow(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAlwaysShow", $$robo$$android_widget_FastScroller$setAlwaysShow(boolean ), 0, this, bl);
    }

    public boolean isAlwaysShowEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAlwaysShowEnabled", $$robo$$android_widget_FastScroller$isAlwaysShowEnabled(), 0, this);
    }

    private void onStateDependencyChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onStateDependencyChanged", $$robo$$android_widget_FastScroller$onStateDependencyChanged(boolean ), 0, this, bl);
    }

    public void setScrollBarStyle(int n) {
        InvokeDynamicSupport.bootstrap("setScrollBarStyle", $$robo$$android_widget_FastScroller$setScrollBarStyle(int ), 0, this, n);
    }

    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_widget_FastScroller$stop(), 0, this);
    }

    public void setScrollbarPosition(int n) {
        InvokeDynamicSupport.bootstrap("setScrollbarPosition", $$robo$$android_widget_FastScroller$setScrollbarPosition(int ), 0, this, n);
    }

    public int getWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_widget_FastScroller$getWidth(), 0, this);
    }

    public void onSizeChanged(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onSizeChanged", $$robo$$android_widget_FastScroller$onSizeChanged(int int int int ), 0, this, n, n2, n3, n4);
    }

    public void onItemCountChanged(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onItemCountChanged", $$robo$$android_widget_FastScroller$onItemCountChanged(int int ), 0, this, n, n2);
    }

    private void updateLongList(int n, int n2) {
        InvokeDynamicSupport.bootstrap("updateLongList", $$robo$$android_widget_FastScroller$updateLongList(int int ), 0, this, n, n2);
    }

    private TextView createPreviewTextView(Context context) {
        return InvokeDynamicSupport.bootstrap("createPreviewTextView", $$robo$$android_widget_FastScroller$createPreviewTextView(android.content.Context ), 0, this, context);
    }

    public void updateLayout() {
        InvokeDynamicSupport.bootstrap("updateLayout", $$robo$$android_widget_FastScroller$updateLayout(), 0, this);
    }

    private void applyLayout(View view, Rect rect) {
        InvokeDynamicSupport.bootstrap("applyLayout", $$robo$$android_widget_FastScroller$applyLayout(android.view.View android.graphics.Rect ), 0, this, view, rect);
    }

    private void measurePreview(View view, Rect rect) {
        InvokeDynamicSupport.bootstrap("measurePreview", $$robo$$android_widget_FastScroller$measurePreview(android.view.View android.graphics.Rect ), 0, this, view, rect);
    }

    private void measureViewToSide(View view, View view2, Rect rect, Rect rect2) {
        InvokeDynamicSupport.bootstrap("measureViewToSide", $$robo$$android_widget_FastScroller$measureViewToSide(android.view.View android.view.View android.graphics.Rect android.graphics.Rect ), 0, this, view, view2, rect, rect2);
    }

    private void measureFloating(View view, Rect rect, Rect rect2) {
        InvokeDynamicSupport.bootstrap("measureFloating", $$robo$$android_widget_FastScroller$measureFloating(android.view.View android.graphics.Rect android.graphics.Rect ), 0, this, view, rect, rect2);
    }

    private void updateContainerRect() {
        InvokeDynamicSupport.bootstrap("updateContainerRect", $$robo$$android_widget_FastScroller$updateContainerRect(), 0, this);
    }

    private void layoutThumb() {
        InvokeDynamicSupport.bootstrap("layoutThumb", $$robo$$android_widget_FastScroller$layoutThumb(), 0, this);
    }

    private void layoutTrack() {
        InvokeDynamicSupport.bootstrap("layoutTrack", $$robo$$android_widget_FastScroller$layoutTrack(), 0, this);
    }

    private void updateOffsetAndRange() {
        InvokeDynamicSupport.bootstrap("updateOffsetAndRange", $$robo$$android_widget_FastScroller$updateOffsetAndRange(), 0, this);
    }

    private void setState(int n) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$android_widget_FastScroller$setState(int ), 0, this, n);
    }

    private void refreshDrawablePressedState() {
        InvokeDynamicSupport.bootstrap("refreshDrawablePressedState", $$robo$$android_widget_FastScroller$refreshDrawablePressedState(), 0, this);
    }

    private void transitionToHidden() {
        InvokeDynamicSupport.bootstrap("transitionToHidden", $$robo$$android_widget_FastScroller$transitionToHidden(), 0, this);
    }

    private void transitionToVisible() {
        InvokeDynamicSupport.bootstrap("transitionToVisible", $$robo$$android_widget_FastScroller$transitionToVisible(), 0, this);
    }

    private void transitionToDragging() {
        InvokeDynamicSupport.bootstrap("transitionToDragging", $$robo$$android_widget_FastScroller$transitionToDragging(), 0, this);
    }

    private void postAutoHide() {
        InvokeDynamicSupport.bootstrap("postAutoHide", $$robo$$android_widget_FastScroller$postAutoHide(), 0, this);
    }

    public void onScroll(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("onScroll", $$robo$$android_widget_FastScroller$onScroll(int int int ), 0, this, n, n2, n3);
    }

    private void getSectionsFromIndexer() {
        InvokeDynamicSupport.bootstrap("getSectionsFromIndexer", $$robo$$android_widget_FastScroller$getSectionsFromIndexer(), 0, this);
    }

    public void onSectionsChanged() {
        InvokeDynamicSupport.bootstrap("onSectionsChanged", $$robo$$android_widget_FastScroller$onSectionsChanged(), 0, this);
    }

    private void scrollTo(float f) {
        InvokeDynamicSupport.bootstrap("scrollTo", $$robo$$android_widget_FastScroller$scrollTo(float ), 0, this, f);
    }

    private boolean transitionPreviewLayout(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("transitionPreviewLayout", $$robo$$android_widget_FastScroller$transitionPreviewLayout(int ), 0, this, n);
    }

    private void setThumbPos(float f) {
        InvokeDynamicSupport.bootstrap("setThumbPos", $$robo$$android_widget_FastScroller$setThumbPos(float ), 0, this, f);
    }

    private float getPosFromMotionEvent(float f) {
        return (float)InvokeDynamicSupport.bootstrap("getPosFromMotionEvent", $$robo$$android_widget_FastScroller$getPosFromMotionEvent(float ), 0, this, f);
    }

    private float getPosFromItemCount(int n, int n2, int n3) {
        return (float)InvokeDynamicSupport.bootstrap("getPosFromItemCount", $$robo$$android_widget_FastScroller$getPosFromItemCount(int int int ), 0, this, n, n2, n3);
    }

    private void cancelFling() {
        InvokeDynamicSupport.bootstrap("cancelFling", $$robo$$android_widget_FastScroller$cancelFling(), 0, this);
    }

    private void cancelPendingDrag() {
        InvokeDynamicSupport.bootstrap("cancelPendingDrag", $$robo$$android_widget_FastScroller$cancelPendingDrag(), 0, this);
    }

    private void startPendingDrag() {
        InvokeDynamicSupport.bootstrap("startPendingDrag", $$robo$$android_widget_FastScroller$startPendingDrag(), 0, this);
    }

    private void beginDrag() {
        InvokeDynamicSupport.bootstrap("beginDrag", $$robo$$android_widget_FastScroller$beginDrag(), 0, this);
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onInterceptTouchEvent", $$robo$$android_widget_FastScroller$onInterceptTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    public boolean onInterceptHoverEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onInterceptHoverEvent", $$robo$$android_widget_FastScroller$onInterceptHoverEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    public PointerIcon onResolvePointerIcon(MotionEvent motionEvent, int n) {
        return InvokeDynamicSupport.bootstrap("onResolvePointerIcon", $$robo$$android_widget_FastScroller$onResolvePointerIcon(android.view.MotionEvent int ), 0, this, motionEvent, n);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_FastScroller$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private boolean isPointInside(float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPointInside", $$robo$$android_widget_FastScroller$isPointInside(float float ), 0, this, f, f2);
    }

    private boolean isPointInsideX(float f) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPointInsideX", $$robo$$android_widget_FastScroller$isPointInsideX(float ), 0, this, f);
    }

    private boolean isPointInsideY(float f) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPointInsideY", $$robo$$android_widget_FastScroller$isPointInsideY(float ), 0, this, f);
    }

    private static Animator groupAnimatorOfFloat(Property<View, Float> property, float f, View ... viewArray) {
        return InvokeDynamicSupport.bootstrapStatic("groupAnimatorOfFloat", $$robo$$android_widget_FastScroller$groupAnimatorOfFloat(android.util.Property<android.view.View, java.lang.Float> float android.view.View[] ), 0, property, (float)f, (View[])viewArray);
    }

    private static Animator animateScaleX(View view, float f) {
        return InvokeDynamicSupport.bootstrapStatic("animateScaleX", $$robo$$android_widget_FastScroller$animateScaleX(android.view.View float ), 0, (View)view, (float)f);
    }

    private static Animator animateAlpha(View view, float f) {
        return InvokeDynamicSupport.bootstrapStatic("animateAlpha", $$robo$$android_widget_FastScroller$animateAlpha(android.view.View float ), 0, (View)view, (float)f);
    }

    private static Animator animateBounds(View view, Rect rect) {
        return InvokeDynamicSupport.bootstrapStatic("animateBounds", $$robo$$android_widget_FastScroller$animateBounds(android.view.View android.graphics.Rect ), 0, (View)view, (Rect)rect);
    }

    static {
        RobolectricInternals.classInitializing(FastScroller.class);
    }

    public /* synthetic */ FastScroller() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FastScroller)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

