/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Insets;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.LogPrinter;
import android.util.Pair;
import android.util.Printer;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RemoteViews;
import android.widget.Space;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@RemoteViews.RemoteView
public class GridLayout
extends ViewGroup
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int HORIZONTAL = 0;
    public static int VERTICAL = 1;
    public static int UNDEFINED = Integer.MIN_VALUE;
    public static int ALIGN_BOUNDS = 0;
    public static int ALIGN_MARGINS = 1;
    static int MAX_SIZE = 100000;
    static int DEFAULT_CONTAINER_MARGIN = 0;
    static int UNINITIALIZED_HASH = 0;
    static Printer LOG_PRINTER;
    static Printer NO_PRINTER;
    private static int DEFAULT_ORIENTATION = 0;
    private static int DEFAULT_COUNT = Integer.MIN_VALUE;
    private static boolean DEFAULT_USE_DEFAULT_MARGINS = false;
    private static boolean DEFAULT_ORDER_PRESERVED = true;
    private static int DEFAULT_ALIGNMENT_MODE = 1;
    private static int ORIENTATION = 0;
    private static int ROW_COUNT = 1;
    private static int COLUMN_COUNT = 3;
    private static int USE_DEFAULT_MARGINS = 5;
    private static int ALIGNMENT_MODE = 6;
    private static int ROW_ORDER_PRESERVED = 2;
    private static int COLUMN_ORDER_PRESERVED = 4;
    Axis mHorizontalAxis;
    Axis mVerticalAxis;
    int mOrientation;
    boolean mUseDefaultMargins;
    int mAlignmentMode;
    int mDefaultGap;
    int mLastLayoutParamsHashCode;
    Printer mPrinter;
    static Alignment UNDEFINED_ALIGNMENT;
    private static Alignment LEADING;
    private static Alignment TRAILING;
    public static Alignment TOP;
    public static Alignment BOTTOM;
    public static Alignment START;
    public static Alignment END;
    public static Alignment LEFT;
    public static Alignment RIGHT;
    public static Alignment CENTER;
    public static Alignment BASELINE;
    public static Alignment FILL;
    private static int INFLEXIBLE = 0;
    private static int CAN_STRETCH = 2;

    private void $$robo$$android_widget_GridLayout$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_GridLayout$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_GridLayout$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_widget_GridLayout$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mHorizontalAxis = new Axis(this, true);
        this.mVerticalAxis = new Axis(this, false);
        this.mOrientation = 0;
        this.mUseDefaultMargins = false;
        this.mAlignmentMode = 1;
        this.mLastLayoutParamsHashCode = 0;
        this.mPrinter = LOG_PRINTER;
        this.mDefaultGap = context.getResources().getDimensionPixelOffset(17105015);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.GridLayout, defStyleAttr, defStyleRes);
        try {
            this.setRowCount(a.getInt(1, Integer.MIN_VALUE));
            this.setColumnCount(a.getInt(3, Integer.MIN_VALUE));
            this.setOrientation(a.getInt(0, 0));
            this.setUseDefaultMargins(a.getBoolean(5, false));
            this.setAlignmentMode(a.getInt(6, 1));
            this.setRowOrderPreserved(a.getBoolean(2, true));
            this.setColumnOrderPreserved(a.getBoolean(4, true));
        }
        finally {
            a.recycle();
        }
    }

    private final int $$robo$$android_widget_GridLayout$getOrientation() {
        return this.mOrientation;
    }

    private final void $$robo$$android_widget_GridLayout$setOrientation(int orientation) {
        if (this.mOrientation != orientation) {
            this.mOrientation = orientation;
            this.invalidateStructure();
            this.requestLayout();
        }
    }

    private final int $$robo$$android_widget_GridLayout$getRowCount() {
        return this.mVerticalAxis.getCount();
    }

    private final void $$robo$$android_widget_GridLayout$setRowCount(int rowCount) {
        this.mVerticalAxis.setCount(rowCount);
        this.invalidateStructure();
        this.requestLayout();
    }

    private final int $$robo$$android_widget_GridLayout$getColumnCount() {
        return this.mHorizontalAxis.getCount();
    }

    private final void $$robo$$android_widget_GridLayout$setColumnCount(int columnCount) {
        this.mHorizontalAxis.setCount(columnCount);
        this.invalidateStructure();
        this.requestLayout();
    }

    private final boolean $$robo$$android_widget_GridLayout$getUseDefaultMargins() {
        return this.mUseDefaultMargins;
    }

    private final void $$robo$$android_widget_GridLayout$setUseDefaultMargins(boolean useDefaultMargins) {
        this.mUseDefaultMargins = useDefaultMargins;
        this.requestLayout();
    }

    private final int $$robo$$android_widget_GridLayout$getAlignmentMode() {
        return this.mAlignmentMode;
    }

    private final void $$robo$$android_widget_GridLayout$setAlignmentMode(int alignmentMode) {
        this.mAlignmentMode = alignmentMode;
        this.requestLayout();
    }

    private final boolean $$robo$$android_widget_GridLayout$isRowOrderPreserved() {
        return this.mVerticalAxis.isOrderPreserved();
    }

    private final void $$robo$$android_widget_GridLayout$setRowOrderPreserved(boolean rowOrderPreserved) {
        this.mVerticalAxis.setOrderPreserved(rowOrderPreserved);
        this.invalidateStructure();
        this.requestLayout();
    }

    private final boolean $$robo$$android_widget_GridLayout$isColumnOrderPreserved() {
        return this.mHorizontalAxis.isOrderPreserved();
    }

    private final void $$robo$$android_widget_GridLayout$setColumnOrderPreserved(boolean columnOrderPreserved) {
        this.mHorizontalAxis.setOrderPreserved(columnOrderPreserved);
        this.invalidateStructure();
        this.requestLayout();
    }

    private final Printer $$robo$$android_widget_GridLayout$getPrinter() {
        return this.mPrinter;
    }

    private final void $$robo$$android_widget_GridLayout$setPrinter(Printer printer) {
        this.mPrinter = printer == null ? NO_PRINTER : printer;
    }

    private static final int $$robo$$android_widget_GridLayout$max2(int[] a, int valueIfEmpty) {
        int result = valueIfEmpty;
        int N = a.length;
        for (int i = 0; i < N; ++i) {
            result = Math.max(result, a[i]);
        }
        return result;
    }

    private static final <T> T[] $$robo$$android_widget_GridLayout$append(T[] a, T[] b) {
        Object[] result = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length + b.length);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", a, (int)0, (Object)result, (int)0, (int)a.length);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", b, (int)0, (Object)result, (int)a.length, (int)b.length);
        return result;
    }

    private static final Alignment $$robo$$android_widget_GridLayout$getAlignment(int gravity, boolean horizontal) {
        int mask = horizontal ? 7 : 112;
        int shift = horizontal ? 0 : 4;
        int flags = (gravity & mask) >> shift;
        switch (flags) {
            case 3: {
                return horizontal ? LEFT : TOP;
            }
            case 5: {
                return horizontal ? RIGHT : BOTTOM;
            }
            case 7: {
                return FILL;
            }
            case 1: {
                return CENTER;
            }
            case 0x800003: {
                return START;
            }
            case 0x800005: {
                return END;
            }
        }
        return UNDEFINED_ALIGNMENT;
    }

    private final int $$robo$$android_widget_GridLayout$getDefaultMargin(View c, boolean horizontal, boolean leading) {
        if (c.getClass() == Space.class) {
            return 0;
        }
        return this.mDefaultGap / 2;
    }

    private final int $$robo$$android_widget_GridLayout$getDefaultMargin(View c, boolean isAtEdge, boolean horizontal, boolean leading) {
        return this.getDefaultMargin(c, horizontal, leading);
    }

    private final int $$robo$$android_widget_GridLayout$getDefaultMargin(View c, LayoutParams p, boolean horizontal, boolean leading) {
        boolean leading1;
        if (!this.mUseDefaultMargins) {
            return 0;
        }
        Spec spec = horizontal ? p.columnSpec : p.rowSpec;
        Axis axis = horizontal ? this.mHorizontalAxis : this.mVerticalAxis;
        Interval span = spec.span;
        boolean bl = horizontal && this.isLayoutRtl() ? !leading : (leading1 = leading);
        boolean isAtEdge = leading1 ? span.min == 0 : span.max == axis.getCount();
        return this.getDefaultMargin(c, isAtEdge, horizontal, leading);
    }

    private final int $$robo$$android_widget_GridLayout$getMargin1(View view, boolean horizontal, boolean leading) {
        LayoutParams lp = this.getLayoutParams(view);
        int margin = horizontal ? (leading ? lp.leftMargin : lp.rightMargin) : (leading ? lp.topMargin : lp.bottomMargin);
        return margin == Integer.MIN_VALUE ? this.getDefaultMargin(view, lp, horizontal, leading) : margin;
    }

    private final int $$robo$$android_widget_GridLayout$getMargin(View view, boolean horizontal, boolean leading) {
        if (this.mAlignmentMode == 1) {
            return this.getMargin1(view, horizontal, leading);
        }
        Axis axis = horizontal ? this.mHorizontalAxis : this.mVerticalAxis;
        int[] margins = leading ? axis.getLeadingMargins() : axis.getTrailingMargins();
        LayoutParams lp = this.getLayoutParams(view);
        Spec spec = horizontal ? lp.columnSpec : lp.rowSpec;
        int index = leading ? spec.span.min : spec.span.max;
        return margins[index];
    }

    private final int $$robo$$android_widget_GridLayout$getTotalMargin(View child, boolean horizontal) {
        return this.getMargin(child, horizontal, true) + this.getMargin(child, horizontal, false);
    }

    private static final boolean $$robo$$android_widget_GridLayout$fits(int[] a, int value, int start, int end) {
        if (end > a.length) {
            return false;
        }
        for (int i = start; i < end; ++i) {
            if (a[i] <= value) continue;
            return false;
        }
        return true;
    }

    private static final void $$robo$$android_widget_GridLayout$procrusteanFill(int[] a, int start, int end, int value) {
        int length = a.length;
        Arrays.fill(a, Math.min(start, length), Math.min(end, length), value);
    }

    private static final void $$robo$$android_widget_GridLayout$setCellGroup(LayoutParams lp, int row, int rowSpan, int col, int colSpan) {
        lp.setRowSpecSpan(new Interval(row, row + rowSpan));
        lp.setColumnSpecSpan(new Interval(col, col + colSpan));
    }

    private static final int $$robo$$android_widget_GridLayout$clip(Interval minorRange, boolean minorWasDefined, int count) {
        int size = minorRange.size();
        if (count == 0) {
            return size;
        }
        int min = minorWasDefined ? Math.min(minorRange.min, count) : 0;
        return Math.min(size, count - min);
    }

    private final void $$robo$$android_widget_GridLayout$validateLayoutParams() {
        boolean horizontal = this.mOrientation == 0;
        Axis axis = horizontal ? this.mHorizontalAxis : this.mVerticalAxis;
        int count = axis.definedCount != Integer.MIN_VALUE ? axis.definedCount : 0;
        int major = 0;
        int minor = 0;
        int[] maxSizes = new int[count];
        int N = this.getChildCount();
        for (int i = 0; i < N; ++i) {
            LayoutParams lp = (LayoutParams)this.getChildAt(i).getLayoutParams();
            Spec majorSpec = horizontal ? lp.rowSpec : lp.columnSpec;
            Interval majorRange = majorSpec.span;
            boolean majorWasDefined = majorSpec.startDefined;
            int majorSpan = majorRange.size();
            if (majorWasDefined) {
                major = majorRange.min;
            }
            Spec minorSpec = horizontal ? lp.columnSpec : lp.rowSpec;
            Interval minorRange = minorSpec.span;
            boolean minorWasDefined = minorSpec.startDefined;
            int minorSpan = GridLayout.clip(minorRange, minorWasDefined, count);
            if (minorWasDefined) {
                minor = minorRange.min;
            }
            if (count != 0) {
                if (!majorWasDefined || !minorWasDefined) {
                    while (!GridLayout.fits(maxSizes, major, minor, minor + minorSpan)) {
                        if (minorWasDefined) {
                            ++major;
                            continue;
                        }
                        if (minor + minorSpan <= count) {
                            ++minor;
                            continue;
                        }
                        minor = 0;
                        ++major;
                    }
                }
                GridLayout.procrusteanFill(maxSizes, minor, minor + minorSpan, major + majorSpan);
            }
            if (horizontal) {
                GridLayout.setCellGroup(lp, major, majorSpan, minor, minorSpan);
            } else {
                GridLayout.setCellGroup(lp, minor, minorSpan, major, majorSpan);
            }
            minor += minorSpan;
        }
    }

    private final void $$robo$$android_widget_GridLayout$invalidateStructure() {
        this.mLastLayoutParamsHashCode = 0;
        this.mHorizontalAxis.invalidateStructure();
        this.mVerticalAxis.invalidateStructure();
        this.invalidateValues();
    }

    private final void $$robo$$android_widget_GridLayout$invalidateValues() {
        if (this.mHorizontalAxis != null && this.mVerticalAxis != null) {
            this.mHorizontalAxis.invalidateValues();
            this.mVerticalAxis.invalidateValues();
        }
    }

    private final void $$robo$$android_widget_GridLayout$onSetLayoutParams(View child, ViewGroup.LayoutParams layoutParams) {
        super.onSetLayoutParams(child, layoutParams);
        if (!this.checkLayoutParams(layoutParams)) {
            GridLayout.handleInvalidParams("supplied LayoutParams are of the wrong type");
        }
        this.invalidateStructure();
    }

    private final LayoutParams $$robo$$android_widget_GridLayout$getLayoutParams(View c) {
        return (LayoutParams)c.getLayoutParams();
    }

    private static final void $$robo$$android_widget_GridLayout$handleInvalidParams(String msg) {
        throw new IllegalArgumentException(msg + ". ");
    }

    private final void $$robo$$android_widget_GridLayout$checkLayoutParams(LayoutParams lp, boolean horizontal) {
        String groupName = horizontal ? "column" : "row";
        Spec spec = horizontal ? lp.columnSpec : lp.rowSpec;
        Interval span = spec.span;
        if (span.min != Integer.MIN_VALUE && span.min < 0) {
            GridLayout.handleInvalidParams(groupName + " indices must be positive");
        }
        Axis axis = horizontal ? this.mHorizontalAxis : this.mVerticalAxis;
        int count = axis.definedCount;
        if (count != Integer.MIN_VALUE) {
            if (span.max > count) {
                GridLayout.handleInvalidParams(groupName + " indices (start + span) mustn't exceed the " + groupName + " count");
            }
            if (span.size() > count) {
                GridLayout.handleInvalidParams(groupName + " span mustn't exceed the " + groupName + " count");
            }
        }
    }

    private final boolean $$robo$$android_widget_GridLayout$checkLayoutParams(ViewGroup.LayoutParams p) {
        if (!(p instanceof LayoutParams)) {
            return false;
        }
        LayoutParams lp = (LayoutParams)p;
        this.checkLayoutParams(lp, true);
        this.checkLayoutParams(lp, false);
        return true;
    }

    private final LayoutParams $$robo$$android_widget_GridLayout$generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    private final LayoutParams $$robo$$android_widget_GridLayout$generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    private final LayoutParams $$robo$$android_widget_GridLayout$generateLayoutParams(ViewGroup.LayoutParams lp) {
        if (sPreserveMarginParamsInLayoutParamConversion) {
            if (lp instanceof LayoutParams) {
                return new LayoutParams((LayoutParams)lp);
            }
            if (lp instanceof ViewGroup.MarginLayoutParams) {
                return new LayoutParams((ViewGroup.MarginLayoutParams)lp);
            }
        }
        return new LayoutParams(lp);
    }

    private final void $$robo$$android_widget_GridLayout$drawLine(Canvas graphics, int x1, int y1, int x2, int y2, Paint paint) {
        if (this.isLayoutRtl()) {
            int width = this.getWidth();
            graphics.drawLine(width - x1, y1, width - x2, y2, paint);
        } else {
            graphics.drawLine(x1, y1, x2, y2, paint);
        }
    }

    private final void $$robo$$android_widget_GridLayout$onDebugDrawMargins(Canvas canvas, Paint paint) {
        LayoutParams lp = new LayoutParams();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View c = this.getChildAt(i);
            lp.setMargins(this.getMargin1(c, true, true), this.getMargin1(c, false, true), this.getMargin1(c, true, false), this.getMargin1(c, false, false));
            lp.onDebugDraw(c, canvas, paint);
        }
    }

    private final void $$robo$$android_widget_GridLayout$onDebugDraw(Canvas canvas) {
        int[] ys;
        Paint paint = new Paint();
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(Color.argb(50, 255, 255, 255));
        Insets insets = this.getOpticalInsets();
        int top = this.getPaddingTop() + insets.top;
        int left = this.getPaddingLeft() + insets.left;
        int right = this.getWidth() - this.getPaddingRight() - insets.right;
        int bottom = this.getHeight() - this.getPaddingBottom() - insets.bottom;
        int[] xs = this.mHorizontalAxis.locations;
        if (xs != null) {
            int length = xs.length;
            for (int i = 0; i < length; ++i) {
                int x = left + xs[i];
                this.drawLine(canvas, x, top, x, bottom, paint);
            }
        }
        if ((ys = this.mVerticalAxis.locations) != null) {
            int length = ys.length;
            for (int i = 0; i < length; ++i) {
                int y = top + ys[i];
                this.drawLine(canvas, left, y, right, y, paint);
            }
        }
        super.onDebugDraw(canvas);
    }

    private final void $$robo$$android_widget_GridLayout$onViewAdded(View child) {
        super.onViewAdded(child);
        this.invalidateStructure();
    }

    private final void $$robo$$android_widget_GridLayout$onViewRemoved(View child) {
        super.onViewRemoved(child);
        this.invalidateStructure();
    }

    private final void $$robo$$android_widget_GridLayout$onChildVisibilityChanged(View child, int oldVisibility, int newVisibility) {
        super.onChildVisibilityChanged(child, oldVisibility, newVisibility);
        if (oldVisibility == 8 || newVisibility == 8) {
            this.invalidateStructure();
        }
    }

    private final int $$robo$$android_widget_GridLayout$computeLayoutParamsHashCode() {
        int result = 1;
        int N = this.getChildCount();
        for (int i = 0; i < N; ++i) {
            View c = this.getChildAt(i);
            if (c.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)c.getLayoutParams();
            result = 31 * result + lp.hashCode();
        }
        return result;
    }

    private final void $$robo$$android_widget_GridLayout$consistencyCheck() {
        if (this.mLastLayoutParamsHashCode == 0) {
            this.validateLayoutParams();
            this.mLastLayoutParamsHashCode = this.computeLayoutParamsHashCode();
        } else if (this.mLastLayoutParamsHashCode != this.computeLayoutParamsHashCode()) {
            this.mPrinter.println("The fields of some layout parameters were modified in between layout operations. Check the javadoc for GridLayout.LayoutParams#rowSpec.");
            this.invalidateStructure();
            this.consistencyCheck();
        }
    }

    private final void $$robo$$android_widget_GridLayout$measureChildWithMargins2(View child, int parentWidthSpec, int parentHeightSpec, int childWidth, int childHeight) {
        int childWidthSpec = GridLayout.getChildMeasureSpec(parentWidthSpec, this.getTotalMargin(child, true), childWidth);
        int childHeightSpec = GridLayout.getChildMeasureSpec(parentHeightSpec, this.getTotalMargin(child, false), childHeight);
        child.measure(childWidthSpec, childHeightSpec);
    }

    private final void $$robo$$android_widget_GridLayout$measureChildrenWithMargins(int widthSpec, int heightSpec, boolean firstPass) {
        int N = this.getChildCount();
        for (int i = 0; i < N; ++i) {
            Spec spec;
            View c = this.getChildAt(i);
            if (c.getVisibility() == 8) continue;
            LayoutParams lp = this.getLayoutParams(c);
            if (firstPass) {
                this.measureChildWithMargins2(c, widthSpec, heightSpec, lp.width, lp.height);
                continue;
            }
            boolean horizontal = this.mOrientation == 0;
            Spec spec2 = spec = horizontal ? lp.columnSpec : lp.rowSpec;
            if (spec.getAbsoluteAlignment(horizontal) != FILL) continue;
            Interval span = spec.span;
            Axis axis = horizontal ? this.mHorizontalAxis : this.mVerticalAxis;
            int[] locations = axis.getLocations();
            int cellSize = locations[span.max] - locations[span.min];
            int viewSize = cellSize - this.getTotalMargin(c, horizontal);
            if (horizontal) {
                this.measureChildWithMargins2(c, widthSpec, heightSpec, viewSize, lp.height);
                continue;
            }
            this.measureChildWithMargins2(c, widthSpec, heightSpec, lp.width, viewSize);
        }
    }

    private static final int $$robo$$android_widget_GridLayout$adjust(int measureSpec, int delta) {
        return View.MeasureSpec.makeMeasureSpec(View.MeasureSpec.getSize(measureSpec + delta), View.MeasureSpec.getMode(measureSpec));
    }

    private final void $$robo$$android_widget_GridLayout$onMeasure(int widthSpec, int heightSpec) {
        int heightSansPadding;
        int widthSansPadding;
        this.consistencyCheck();
        this.invalidateValues();
        int hPadding = this.getPaddingLeft() + this.getPaddingRight();
        int vPadding = this.getPaddingTop() + this.getPaddingBottom();
        int widthSpecSansPadding = GridLayout.adjust(widthSpec, -hPadding);
        int heightSpecSansPadding = GridLayout.adjust(heightSpec, -vPadding);
        this.measureChildrenWithMargins(widthSpecSansPadding, heightSpecSansPadding, true);
        if (this.mOrientation == 0) {
            widthSansPadding = this.mHorizontalAxis.getMeasure(widthSpecSansPadding);
            this.measureChildrenWithMargins(widthSpecSansPadding, heightSpecSansPadding, false);
            heightSansPadding = this.mVerticalAxis.getMeasure(heightSpecSansPadding);
        } else {
            heightSansPadding = this.mVerticalAxis.getMeasure(heightSpecSansPadding);
            this.measureChildrenWithMargins(widthSpecSansPadding, heightSpecSansPadding, false);
            widthSansPadding = this.mHorizontalAxis.getMeasure(widthSpecSansPadding);
        }
        int measuredWidth = Math.max(widthSansPadding + hPadding, this.getSuggestedMinimumWidth());
        int measuredHeight = Math.max(heightSansPadding + vPadding, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(GridLayout.resolveSizeAndState(measuredWidth, widthSpec, 0), GridLayout.resolveSizeAndState(measuredHeight, heightSpec, 0));
    }

    private final int $$robo$$android_widget_GridLayout$getMeasurement(View c, boolean horizontal) {
        return horizontal ? c.getMeasuredWidth() : c.getMeasuredHeight();
    }

    private final int $$robo$$android_widget_GridLayout$getMeasurementIncludingMargin(View c, boolean horizontal) {
        if (c.getVisibility() == 8) {
            return 0;
        }
        return this.getMeasurement(c, horizontal) + this.getTotalMargin(c, horizontal);
    }

    private final void $$robo$$android_widget_GridLayout$requestLayout() {
        super.requestLayout();
        this.invalidateValues();
    }

    private final void $$robo$$android_widget_GridLayout$onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.consistencyCheck();
        int targetWidth = right - left;
        int targetHeight = bottom - top;
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        this.mHorizontalAxis.layout(targetWidth - paddingLeft - paddingRight);
        this.mVerticalAxis.layout(targetHeight - paddingTop - paddingBottom);
        int[] hLocations = this.mHorizontalAxis.getLocations();
        int[] vLocations = this.mVerticalAxis.getLocations();
        int N = this.getChildCount();
        for (int i = 0; i < N; ++i) {
            View c = this.getChildAt(i);
            if (c.getVisibility() == 8) continue;
            LayoutParams lp = this.getLayoutParams(c);
            Spec columnSpec = lp.columnSpec;
            Spec rowSpec = lp.rowSpec;
            Interval colSpan = columnSpec.span;
            Interval rowSpan = rowSpec.span;
            int x1 = hLocations[colSpan.min];
            int y1 = vLocations[rowSpan.min];
            int x2 = hLocations[colSpan.max];
            int y2 = vLocations[rowSpan.max];
            int cellWidth = x2 - x1;
            int cellHeight = y2 - y1;
            int pWidth = this.getMeasurement(c, true);
            int pHeight = this.getMeasurement(c, false);
            Alignment hAlign = columnSpec.getAbsoluteAlignment(true);
            Alignment vAlign = rowSpec.getAbsoluteAlignment(false);
            Bounds boundsX = this.mHorizontalAxis.getGroupBounds().getValue(i);
            Bounds boundsY = this.mVerticalAxis.getGroupBounds().getValue(i);
            int gravityOffsetX = hAlign.getGravityOffset(c, cellWidth - boundsX.size(true));
            int gravityOffsetY = vAlign.getGravityOffset(c, cellHeight - boundsY.size(true));
            int leftMargin = this.getMargin(c, true, true);
            int topMargin = this.getMargin(c, false, true);
            int rightMargin = this.getMargin(c, true, false);
            int bottomMargin = this.getMargin(c, false, false);
            int sumMarginsX = leftMargin + rightMargin;
            int sumMarginsY = topMargin + bottomMargin;
            int alignmentOffsetX = boundsX.getOffset(this, c, hAlign, pWidth + sumMarginsX, true);
            int alignmentOffsetY = boundsY.getOffset(this, c, vAlign, pHeight + sumMarginsY, false);
            int width = hAlign.getSizeInCell(c, pWidth, cellWidth - sumMarginsX);
            int height = vAlign.getSizeInCell(c, pHeight, cellHeight - sumMarginsY);
            int dx = x1 + gravityOffsetX + alignmentOffsetX;
            int cx = !this.isLayoutRtl() ? paddingLeft + leftMargin + dx : targetWidth - width - paddingRight - rightMargin - dx;
            int cy = paddingTop + y1 + gravityOffsetY + alignmentOffsetY + topMargin;
            if (width != c.getMeasuredWidth() || height != c.getMeasuredHeight()) {
                c.measure(View.MeasureSpec.makeMeasureSpec(width, 0x40000000), View.MeasureSpec.makeMeasureSpec(height, 0x40000000));
            }
            c.layout(cx, cy, cx + width, cy + height);
        }
    }

    private final CharSequence $$robo$$android_widget_GridLayout$getAccessibilityClassName() {
        return GridLayout.class.getName();
    }

    private static final Spec $$robo$$android_widget_GridLayout$spec(int start, int size, Alignment alignment, float weight) {
        return new Spec(start != Integer.MIN_VALUE, start, size, alignment, weight);
    }

    private static final Spec $$robo$$android_widget_GridLayout$spec(int start, Alignment alignment, float weight) {
        return GridLayout.spec(start, 1, alignment, weight);
    }

    private static final Spec $$robo$$android_widget_GridLayout$spec(int start, int size, float weight) {
        return GridLayout.spec(start, size, UNDEFINED_ALIGNMENT, weight);
    }

    private static final Spec $$robo$$android_widget_GridLayout$spec(int start, float weight) {
        return GridLayout.spec(start, 1, weight);
    }

    private static final Spec $$robo$$android_widget_GridLayout$spec(int start, int size, Alignment alignment) {
        return GridLayout.spec(start, size, alignment, 0.0f);
    }

    private static final Spec $$robo$$android_widget_GridLayout$spec(int start, Alignment alignment) {
        return GridLayout.spec(start, 1, alignment);
    }

    private static final Spec $$robo$$android_widget_GridLayout$spec(int start, int size) {
        return GridLayout.spec(start, size, UNDEFINED_ALIGNMENT);
    }

    private static final Spec $$robo$$android_widget_GridLayout$spec(int start) {
        return GridLayout.spec(start, 1);
    }

    private static final Alignment $$robo$$android_widget_GridLayout$createSwitchingAlignment(Alignment ltr, Alignment rtl) {
        return new ShadowedObject(ltr, rtl){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Alignment val$ltr;
            /* synthetic */ Alignment val$rtl;

            private void $$robo$$android_widget_GridLayout_5$__constructor__(Alignment alignment, Alignment alignment2) {
            }

            private final int $$robo$$android_widget_GridLayout_5$getGravityOffset(View view, int cellDelta) {
                return (!view.isLayoutRtl() ? this.val$ltr : this.val$rtl).getGravityOffset(view, cellDelta);
            }

            private final int $$robo$$android_widget_GridLayout_5$getAlignmentValue(View view, int viewSize, int mode) {
                return (!view.isLayoutRtl() ? this.val$ltr : this.val$rtl).getAlignmentValue(view, viewSize, mode);
            }

            private void __constructor__(Alignment alignment, Alignment alignment2) {
                this.$$robo$$android_widget_GridLayout_5$__constructor__(alignment, alignment2);
            }
            {
                this.val$ltr = alignment;
                this.val$rtl = alignment2;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_5$__constructor__(android.widget.GridLayout$Alignment android.widget.GridLayout$Alignment ), 0, this, alignment, alignment2);
            }

            @Override
            int getGravityOffset(View view, int n) {
                return (int)InvokeDynamicSupport.bootstrap("getGravityOffset", $$robo$$android_widget_GridLayout_5$getGravityOffset(android.view.View int ), 0, this, view, n);
            }

            @Override
            public int getAlignmentValue(View view, int n, int n2) {
                return (int)InvokeDynamicSupport.bootstrap("getAlignmentValue", $$robo$$android_widget_GridLayout_5$getAlignmentValue(android.view.View int int ), 0, this, view, n, n2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private static final boolean $$robo$$android_widget_GridLayout$canStretch(int flexibility) {
        return (flexibility & 2) != 0;
    }

    static void __staticInitializer__() {
        LOG_PRINTER = new LogPrinter(3, GridLayout.class.getName());
        NO_PRINTER = new Printer(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_widget_GridLayout_1$__constructor__() {
            }

            private final void $$robo$$android_widget_GridLayout_1$println(String x) {
            }

            private void __constructor__() {
                this.$$robo$$android_widget_GridLayout_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_1$__constructor__(), 0, this);
            }

            @Override
            public void println(String string2) {
                InvokeDynamicSupport.bootstrap("println", $$robo$$android_widget_GridLayout_1$println(java.lang.String ), 0, this, string2);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        UNDEFINED_ALIGNMENT = new ShadowedObject(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_widget_GridLayout_2$__constructor__() {
            }

            private final int $$robo$$android_widget_GridLayout_2$getGravityOffset(View view, int cellDelta) {
                return Integer.MIN_VALUE;
            }

            private final int $$robo$$android_widget_GridLayout_2$getAlignmentValue(View view, int viewSize, int mode) {
                return Integer.MIN_VALUE;
            }

            private void __constructor__() {
                this.$$robo$$android_widget_GridLayout_2$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_2$__constructor__(), 0, this);
            }

            @Override
            int getGravityOffset(View view, int n) {
                return (int)InvokeDynamicSupport.bootstrap("getGravityOffset", $$robo$$android_widget_GridLayout_2$getGravityOffset(android.view.View int ), 0, this, view, n);
            }

            @Override
            public int getAlignmentValue(View view, int n, int n2) {
                return (int)InvokeDynamicSupport.bootstrap("getAlignmentValue", $$robo$$android_widget_GridLayout_2$getAlignmentValue(android.view.View int int ), 0, this, view, n, n2);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        LEADING = new ShadowedObject(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_widget_GridLayout_3$__constructor__() {
            }

            private final int $$robo$$android_widget_GridLayout_3$getGravityOffset(View view, int cellDelta) {
                return 0;
            }

            private final int $$robo$$android_widget_GridLayout_3$getAlignmentValue(View view, int viewSize, int mode) {
                return 0;
            }

            private void __constructor__() {
                this.$$robo$$android_widget_GridLayout_3$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_3$__constructor__(), 0, this);
            }

            @Override
            int getGravityOffset(View view, int n) {
                return (int)InvokeDynamicSupport.bootstrap("getGravityOffset", $$robo$$android_widget_GridLayout_3$getGravityOffset(android.view.View int ), 0, this, view, n);
            }

            @Override
            public int getAlignmentValue(View view, int n, int n2) {
                return (int)InvokeDynamicSupport.bootstrap("getAlignmentValue", $$robo$$android_widget_GridLayout_3$getAlignmentValue(android.view.View int int ), 0, this, view, n, n2);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        TRAILING = new ShadowedObject(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_widget_GridLayout_4$__constructor__() {
            }

            private final int $$robo$$android_widget_GridLayout_4$getGravityOffset(View view, int cellDelta) {
                return cellDelta;
            }

            private final int $$robo$$android_widget_GridLayout_4$getAlignmentValue(View view, int viewSize, int mode) {
                return viewSize;
            }

            private void __constructor__() {
                this.$$robo$$android_widget_GridLayout_4$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_4$__constructor__(), 0, this);
            }

            @Override
            int getGravityOffset(View view, int n) {
                return (int)InvokeDynamicSupport.bootstrap("getGravityOffset", $$robo$$android_widget_GridLayout_4$getGravityOffset(android.view.View int ), 0, this, view, n);
            }

            @Override
            public int getAlignmentValue(View view, int n, int n2) {
                return (int)InvokeDynamicSupport.bootstrap("getAlignmentValue", $$robo$$android_widget_GridLayout_4$getAlignmentValue(android.view.View int int ), 0, this, view, n, n2);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        TOP = LEADING;
        BOTTOM = TRAILING;
        START = LEADING;
        END = TRAILING;
        LEFT = GridLayout.createSwitchingAlignment(START, END);
        RIGHT = GridLayout.createSwitchingAlignment(END, START);
        CENTER = new ShadowedObject(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_widget_GridLayout_6$__constructor__() {
            }

            private final int $$robo$$android_widget_GridLayout_6$getGravityOffset(View view, int cellDelta) {
                return cellDelta >> 1;
            }

            private final int $$robo$$android_widget_GridLayout_6$getAlignmentValue(View view, int viewSize, int mode) {
                return viewSize >> 1;
            }

            private void __constructor__() {
                this.$$robo$$android_widget_GridLayout_6$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_6$__constructor__(), 0, this);
            }

            @Override
            int getGravityOffset(View view, int n) {
                return (int)InvokeDynamicSupport.bootstrap("getGravityOffset", $$robo$$android_widget_GridLayout_6$getGravityOffset(android.view.View int ), 0, this, view, n);
            }

            @Override
            public int getAlignmentValue(View view, int n, int n2) {
                return (int)InvokeDynamicSupport.bootstrap("getAlignmentValue", $$robo$$android_widget_GridLayout_6$getAlignmentValue(android.view.View int int ), 0, this, view, n, n2);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        BASELINE = new ShadowedObject(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_widget_GridLayout_7$__constructor__() {
            }

            private final int $$robo$$android_widget_GridLayout_7$getGravityOffset(View view, int cellDelta) {
                return 0;
            }

            private final int $$robo$$android_widget_GridLayout_7$getAlignmentValue(View view, int viewSize, int mode) {
                if (view.getVisibility() == 8) {
                    return 0;
                }
                int baseline = view.getBaseline();
                return baseline == -1 ? Integer.MIN_VALUE : baseline;
            }

            private final Bounds $$robo$$android_widget_GridLayout_7$getBounds() {
                return new ShadowedObject(this){
                    public transient /* synthetic */ Object __robo_data__;
                    private int size;
                    /* synthetic */ 7 this$0;

                    private void $$robo$$android_widget_GridLayout_7_1$__constructor__(7 this$0) {
                    }

                    private final void $$robo$$android_widget_GridLayout_7_1$reset() {
                        super.reset();
                        this.size = Integer.MIN_VALUE;
                    }

                    private final void $$robo$$android_widget_GridLayout_7_1$include(int before, int after) {
                        super.include(before, after);
                        this.size = Math.max(this.size, before + after);
                    }

                    private final int $$robo$$android_widget_GridLayout_7_1$size(boolean min) {
                        return Math.max(super.size(min), this.size);
                    }

                    private final int $$robo$$android_widget_GridLayout_7_1$getOffset(GridLayout gl, View c, Alignment a, int size, boolean hrz) {
                        return Math.max(0, super.getOffset(gl, c, a, size, hrz));
                    }

                    private void __constructor__(7 var1_1) {
                        this.$$robo$$android_widget_GridLayout_7_1$__constructor__(var1_1);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_7_1$__constructor__(android.widget.GridLayout$7 ), 0, this, var1_1);
                    }

                    @Override
                    protected void reset() {
                        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_widget_GridLayout_7_1$reset(), 0, this);
                    }

                    @Override
                    protected void include(int n, int n2) {
                        InvokeDynamicSupport.bootstrap("include", $$robo$$android_widget_GridLayout_7_1$include(int int ), 0, this, n, n2);
                    }

                    @Override
                    protected int size(boolean bl) {
                        return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_widget_GridLayout_7_1$size(boolean ), 0, this, bl);
                    }

                    @Override
                    protected int getOffset(GridLayout gridLayout, View view, Alignment alignment, int n, boolean bl) {
                        return (int)InvokeDynamicSupport.bootstrap("getOffset", $$robo$$android_widget_GridLayout_7_1$getOffset(android.widget.GridLayout android.view.View android.widget.GridLayout$Alignment int boolean ), 0, this, gridLayout, view, alignment, n, bl);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
            }

            private void __constructor__() {
                this.$$robo$$android_widget_GridLayout_7$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_7$__constructor__(), 0, this);
            }

            @Override
            int getGravityOffset(View view, int n) {
                return (int)InvokeDynamicSupport.bootstrap("getGravityOffset", $$robo$$android_widget_GridLayout_7$getGravityOffset(android.view.View int ), 0, this, view, n);
            }

            @Override
            public int getAlignmentValue(View view, int n, int n2) {
                return (int)InvokeDynamicSupport.bootstrap("getAlignmentValue", $$robo$$android_widget_GridLayout_7$getAlignmentValue(android.view.View int int ), 0, this, view, n, n2);
            }

            @Override
            public Bounds getBounds() {
                return InvokeDynamicSupport.bootstrap("getBounds", $$robo$$android_widget_GridLayout_7$getBounds(), 0, this);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        FILL = new ShadowedObject(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_widget_GridLayout_8$__constructor__() {
            }

            private final int $$robo$$android_widget_GridLayout_8$getGravityOffset(View view, int cellDelta) {
                return 0;
            }

            private final int $$robo$$android_widget_GridLayout_8$getAlignmentValue(View view, int viewSize, int mode) {
                return Integer.MIN_VALUE;
            }

            private final int $$robo$$android_widget_GridLayout_8$getSizeInCell(View view, int viewSize, int cellSize) {
                return cellSize;
            }

            private void __constructor__() {
                this.$$robo$$android_widget_GridLayout_8$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_8$__constructor__(), 0, this);
            }

            @Override
            int getGravityOffset(View view, int n) {
                return (int)InvokeDynamicSupport.bootstrap("getGravityOffset", $$robo$$android_widget_GridLayout_8$getGravityOffset(android.view.View int ), 0, this, view, n);
            }

            @Override
            public int getAlignmentValue(View view, int n, int n2) {
                return (int)InvokeDynamicSupport.bootstrap("getAlignmentValue", $$robo$$android_widget_GridLayout_8$getAlignmentValue(android.view.View int int ), 0, this, view, n, n2);
            }

            @Override
            public int getSizeInCell(View view, int n, int n2) {
                return (int)InvokeDynamicSupport.bootstrap("getSizeInCell", $$robo$$android_widget_GridLayout_8$getSizeInCell(android.view.View int int ), 0, this, view, n, n2);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_GridLayout$__constructor__(context);
    }

    public GridLayout(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_GridLayout$__constructor__(context, attributeSet);
    }

    public GridLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_GridLayout$__constructor__(context, attributeSet, n);
    }

    public GridLayout(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_GridLayout$__constructor__(context, attributeSet, n, n2);
    }

    public GridLayout(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    public int getOrientation() {
        return (int)InvokeDynamicSupport.bootstrap("getOrientation", $$robo$$android_widget_GridLayout$getOrientation(), 0, this);
    }

    public void setOrientation(int n) {
        InvokeDynamicSupport.bootstrap("setOrientation", $$robo$$android_widget_GridLayout$setOrientation(int ), 0, this, n);
    }

    public int getRowCount() {
        return (int)InvokeDynamicSupport.bootstrap("getRowCount", $$robo$$android_widget_GridLayout$getRowCount(), 0, this);
    }

    public void setRowCount(int n) {
        InvokeDynamicSupport.bootstrap("setRowCount", $$robo$$android_widget_GridLayout$setRowCount(int ), 0, this, n);
    }

    public int getColumnCount() {
        return (int)InvokeDynamicSupport.bootstrap("getColumnCount", $$robo$$android_widget_GridLayout$getColumnCount(), 0, this);
    }

    public void setColumnCount(int n) {
        InvokeDynamicSupport.bootstrap("setColumnCount", $$robo$$android_widget_GridLayout$setColumnCount(int ), 0, this, n);
    }

    public boolean getUseDefaultMargins() {
        return (boolean)InvokeDynamicSupport.bootstrap("getUseDefaultMargins", $$robo$$android_widget_GridLayout$getUseDefaultMargins(), 0, this);
    }

    public void setUseDefaultMargins(boolean bl) {
        InvokeDynamicSupport.bootstrap("setUseDefaultMargins", $$robo$$android_widget_GridLayout$setUseDefaultMargins(boolean ), 0, this, bl);
    }

    public int getAlignmentMode() {
        return (int)InvokeDynamicSupport.bootstrap("getAlignmentMode", $$robo$$android_widget_GridLayout$getAlignmentMode(), 0, this);
    }

    public void setAlignmentMode(int n) {
        InvokeDynamicSupport.bootstrap("setAlignmentMode", $$robo$$android_widget_GridLayout$setAlignmentMode(int ), 0, this, n);
    }

    public boolean isRowOrderPreserved() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRowOrderPreserved", $$robo$$android_widget_GridLayout$isRowOrderPreserved(), 0, this);
    }

    public void setRowOrderPreserved(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRowOrderPreserved", $$robo$$android_widget_GridLayout$setRowOrderPreserved(boolean ), 0, this, bl);
    }

    public boolean isColumnOrderPreserved() {
        return (boolean)InvokeDynamicSupport.bootstrap("isColumnOrderPreserved", $$robo$$android_widget_GridLayout$isColumnOrderPreserved(), 0, this);
    }

    public void setColumnOrderPreserved(boolean bl) {
        InvokeDynamicSupport.bootstrap("setColumnOrderPreserved", $$robo$$android_widget_GridLayout$setColumnOrderPreserved(boolean ), 0, this, bl);
    }

    public Printer getPrinter() {
        return InvokeDynamicSupport.bootstrap("getPrinter", $$robo$$android_widget_GridLayout$getPrinter(), 0, this);
    }

    public void setPrinter(Printer printer) {
        InvokeDynamicSupport.bootstrap("setPrinter", $$robo$$android_widget_GridLayout$setPrinter(android.util.Printer ), 0, this, printer);
    }

    static int max2(int[] nArray, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("max2", $$robo$$android_widget_GridLayout$max2(int[] int ), 0, (int[])nArray, (int)n);
    }

    static <T> T[] append(T[] TArray, T[] TArray2) {
        return InvokeDynamicSupport.bootstrapStatic("append", $$robo$$android_widget_GridLayout$append(T[] T[] ), 0, (Object[])TArray, (Object[])TArray2);
    }

    static Alignment getAlignment(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getAlignment", $$robo$$android_widget_GridLayout$getAlignment(int boolean ), 0, (int)n, (boolean)bl);
    }

    private int getDefaultMargin(View view, boolean bl, boolean bl2) {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultMargin", $$robo$$android_widget_GridLayout$getDefaultMargin(android.view.View boolean boolean ), 0, this, view, bl, bl2);
    }

    private int getDefaultMargin(View view, boolean bl, boolean bl2, boolean bl3) {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultMargin", $$robo$$android_widget_GridLayout$getDefaultMargin(android.view.View boolean boolean boolean ), 0, this, view, bl, bl2, bl3);
    }

    private int getDefaultMargin(View view, LayoutParams layoutParams, boolean bl, boolean bl2) {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultMargin", $$robo$$android_widget_GridLayout$getDefaultMargin(android.view.View android.widget.GridLayout$LayoutParams boolean boolean ), 0, this, view, layoutParams, bl, bl2);
    }

    int getMargin1(View view, boolean bl, boolean bl2) {
        return (int)InvokeDynamicSupport.bootstrap("getMargin1", $$robo$$android_widget_GridLayout$getMargin1(android.view.View boolean boolean ), 0, this, view, bl, bl2);
    }

    private int getMargin(View view, boolean bl, boolean bl2) {
        return (int)InvokeDynamicSupport.bootstrap("getMargin", $$robo$$android_widget_GridLayout$getMargin(android.view.View boolean boolean ), 0, this, view, bl, bl2);
    }

    private int getTotalMargin(View view, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getTotalMargin", $$robo$$android_widget_GridLayout$getTotalMargin(android.view.View boolean ), 0, this, view, bl);
    }

    private static boolean fits(int[] nArray, int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("fits", $$robo$$android_widget_GridLayout$fits(int[] int int int ), 0, (int[])nArray, (int)n, (int)n2, (int)n3);
    }

    private static void procrusteanFill(int[] nArray, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrapStatic("procrusteanFill", $$robo$$android_widget_GridLayout$procrusteanFill(int[] int int int ), 0, (int[])nArray, (int)n, (int)n2, (int)n3);
    }

    private static void setCellGroup(LayoutParams layoutParams, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrapStatic("setCellGroup", $$robo$$android_widget_GridLayout$setCellGroup(android.widget.GridLayout$LayoutParams int int int int ), 0, (LayoutParams)layoutParams, (int)n, (int)n2, (int)n3, (int)n4);
    }

    private static int clip(Interval interval, boolean bl, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("clip", $$robo$$android_widget_GridLayout$clip(android.widget.GridLayout$Interval boolean int ), 0, (Interval)interval, (boolean)bl, (int)n);
    }

    private void validateLayoutParams() {
        InvokeDynamicSupport.bootstrap("validateLayoutParams", $$robo$$android_widget_GridLayout$validateLayoutParams(), 0, this);
    }

    private void invalidateStructure() {
        InvokeDynamicSupport.bootstrap("invalidateStructure", $$robo$$android_widget_GridLayout$invalidateStructure(), 0, this);
    }

    private void invalidateValues() {
        InvokeDynamicSupport.bootstrap("invalidateValues", $$robo$$android_widget_GridLayout$invalidateValues(), 0, this);
    }

    @Override
    protected void onSetLayoutParams(View view, ViewGroup.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("onSetLayoutParams", $$robo$$android_widget_GridLayout$onSetLayoutParams(android.view.View android.view.ViewGroup$LayoutParams ), 0, this, view, layoutParams);
    }

    LayoutParams getLayoutParams(View view) {
        return InvokeDynamicSupport.bootstrap("getLayoutParams", $$robo$$android_widget_GridLayout$getLayoutParams(android.view.View ), 0, this, view);
    }

    private static void handleInvalidParams(String string2) {
        InvokeDynamicSupport.bootstrapStatic("handleInvalidParams", $$robo$$android_widget_GridLayout$handleInvalidParams(java.lang.String ), 0, (String)string2);
    }

    private void checkLayoutParams(LayoutParams layoutParams, boolean bl) {
        InvokeDynamicSupport.bootstrap("checkLayoutParams", $$robo$$android_widget_GridLayout$checkLayoutParams(android.widget.GridLayout$LayoutParams boolean ), 0, this, layoutParams, bl);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkLayoutParams", $$robo$$android_widget_GridLayout$checkLayoutParams(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        return InvokeDynamicSupport.bootstrap("generateDefaultLayoutParams", $$robo$$android_widget_GridLayout$generateDefaultLayoutParams(), 0, this);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$android_widget_GridLayout$generateLayoutParams(android.util.AttributeSet ), 0, this, attributeSet);
    }

    @Override
    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$android_widget_GridLayout$generateLayoutParams(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
    }

    private void drawLine(Canvas canvas, int n, int n2, int n3, int n4, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawLine", $$robo$$android_widget_GridLayout$drawLine(android.graphics.Canvas int int int int android.graphics.Paint ), 0, this, canvas, n, n2, n3, n4, paint);
    }

    @Override
    protected void onDebugDrawMargins(Canvas canvas, Paint paint) {
        InvokeDynamicSupport.bootstrap("onDebugDrawMargins", $$robo$$android_widget_GridLayout$onDebugDrawMargins(android.graphics.Canvas android.graphics.Paint ), 0, this, canvas, paint);
    }

    @Override
    protected void onDebugDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDebugDraw", $$robo$$android_widget_GridLayout$onDebugDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    public void onViewAdded(View view) {
        InvokeDynamicSupport.bootstrap("onViewAdded", $$robo$$android_widget_GridLayout$onViewAdded(android.view.View ), 0, this, view);
    }

    @Override
    public void onViewRemoved(View view) {
        InvokeDynamicSupport.bootstrap("onViewRemoved", $$robo$$android_widget_GridLayout$onViewRemoved(android.view.View ), 0, this, view);
    }

    @Override
    protected void onChildVisibilityChanged(View view, int n, int n2) {
        InvokeDynamicSupport.bootstrap("onChildVisibilityChanged", $$robo$$android_widget_GridLayout$onChildVisibilityChanged(android.view.View int int ), 0, this, view, n, n2);
    }

    private int computeLayoutParamsHashCode() {
        return (int)InvokeDynamicSupport.bootstrap("computeLayoutParamsHashCode", $$robo$$android_widget_GridLayout$computeLayoutParamsHashCode(), 0, this);
    }

    private void consistencyCheck() {
        InvokeDynamicSupport.bootstrap("consistencyCheck", $$robo$$android_widget_GridLayout$consistencyCheck(), 0, this);
    }

    private void measureChildWithMargins2(View view, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("measureChildWithMargins2", $$robo$$android_widget_GridLayout$measureChildWithMargins2(android.view.View int int int int ), 0, this, view, n, n2, n3, n4);
    }

    private void measureChildrenWithMargins(int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("measureChildrenWithMargins", $$robo$$android_widget_GridLayout$measureChildrenWithMargins(int int boolean ), 0, this, n, n2, bl);
    }

    static int adjust(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("adjust", $$robo$$android_widget_GridLayout$adjust(int int ), 0, (int)n, (int)n2);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_GridLayout$onMeasure(int int ), 0, this, n, n2);
    }

    private int getMeasurement(View view, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getMeasurement", $$robo$$android_widget_GridLayout$getMeasurement(android.view.View boolean ), 0, this, view, bl);
    }

    int getMeasurementIncludingMargin(View view, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getMeasurementIncludingMargin", $$robo$$android_widget_GridLayout$getMeasurementIncludingMargin(android.view.View boolean ), 0, this, view, bl);
    }

    @Override
    public void requestLayout() {
        InvokeDynamicSupport.bootstrap("requestLayout", $$robo$$android_widget_GridLayout$requestLayout(), 0, this);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_GridLayout$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_GridLayout$getAccessibilityClassName(), 0, this);
    }

    public static Spec spec(int n, int n2, Alignment alignment, float f) {
        return InvokeDynamicSupport.bootstrapStatic("spec", $$robo$$android_widget_GridLayout$spec(int int android.widget.GridLayout$Alignment float ), 0, (int)n, (int)n2, (Alignment)alignment, (float)f);
    }

    public static Spec spec(int n, Alignment alignment, float f) {
        return InvokeDynamicSupport.bootstrapStatic("spec", $$robo$$android_widget_GridLayout$spec(int android.widget.GridLayout$Alignment float ), 0, (int)n, (Alignment)alignment, (float)f);
    }

    public static Spec spec(int n, int n2, float f) {
        return InvokeDynamicSupport.bootstrapStatic("spec", $$robo$$android_widget_GridLayout$spec(int int float ), 0, (int)n, (int)n2, (float)f);
    }

    public static Spec spec(int n, float f) {
        return InvokeDynamicSupport.bootstrapStatic("spec", $$robo$$android_widget_GridLayout$spec(int float ), 0, (int)n, (float)f);
    }

    public static Spec spec(int n, int n2, Alignment alignment) {
        return InvokeDynamicSupport.bootstrapStatic("spec", $$robo$$android_widget_GridLayout$spec(int int android.widget.GridLayout$Alignment ), 0, (int)n, (int)n2, (Alignment)alignment);
    }

    public static Spec spec(int n, Alignment alignment) {
        return InvokeDynamicSupport.bootstrapStatic("spec", $$robo$$android_widget_GridLayout$spec(int android.widget.GridLayout$Alignment ), 0, (int)n, (Alignment)alignment);
    }

    public static Spec spec(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("spec", $$robo$$android_widget_GridLayout$spec(int int ), 0, (int)n, (int)n2);
    }

    public static Spec spec(int n) {
        return InvokeDynamicSupport.bootstrapStatic("spec", $$robo$$android_widget_GridLayout$spec(int ), 0, (int)n);
    }

    private static Alignment createSwitchingAlignment(Alignment alignment, Alignment alignment2) {
        return InvokeDynamicSupport.bootstrapStatic("createSwitchingAlignment", $$robo$$android_widget_GridLayout$createSwitchingAlignment(android.widget.GridLayout$Alignment android.widget.GridLayout$Alignment ), 0, (Alignment)alignment, (Alignment)alignment2);
    }

    static boolean canStretch(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("canStretch", $$robo$$android_widget_GridLayout$canStretch(int ), 0, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(GridLayout.class);
    }

    public /* synthetic */ GridLayout() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GridLayout)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class Alignment
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_widget_GridLayout_Alignment$__constructor__() {
        }

        abstract int getGravityOffset(View var1, int var2);

        abstract int getAlignmentValue(View var1, int var2, int var3);

        private final int $$robo$$android_widget_GridLayout_Alignment$getSizeInCell(View view, int viewSize, int cellSize) {
            return viewSize;
        }

        private final Bounds $$robo$$android_widget_GridLayout_Alignment$getBounds() {
            return new Bounds();
        }

        private void __constructor__() {
            this.$$robo$$android_widget_GridLayout_Alignment$__constructor__();
        }

        Alignment() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_Alignment$__constructor__(), 0, this);
        }

        int getSizeInCell(View view, int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("getSizeInCell", $$robo$$android_widget_GridLayout_Alignment$getSizeInCell(android.view.View int int ), 0, this, view, n, n2);
        }

        Bounds getBounds() {
            return InvokeDynamicSupport.bootstrap("getBounds", $$robo$$android_widget_GridLayout_Alignment$getBounds(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Alignment)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Spec
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static Spec UNDEFINED;
        static float DEFAULT_WEIGHT = 0.0f;
        boolean startDefined;
        Interval span;
        Alignment alignment;
        float weight;

        private void $$robo$$android_widget_GridLayout_Spec$__constructor__(boolean startDefined, Interval span, Alignment alignment, float weight) {
            this.startDefined = startDefined;
            this.span = span;
            this.alignment = alignment;
            this.weight = weight;
        }

        private void $$robo$$android_widget_GridLayout_Spec$__constructor__(boolean startDefined, int start, int size, Alignment alignment, float weight) {
        }

        private final Alignment $$robo$$android_widget_GridLayout_Spec$getAbsoluteAlignment(boolean horizontal) {
            if (this.alignment != UNDEFINED_ALIGNMENT) {
                return this.alignment;
            }
            if (this.weight == 0.0f) {
                return horizontal ? START : BASELINE;
            }
            return FILL;
        }

        private final Spec $$robo$$android_widget_GridLayout_Spec$copyWriteSpan(Interval span) {
            return new Spec(this.startDefined, span, this.alignment, this.weight);
        }

        private final Spec $$robo$$android_widget_GridLayout_Spec$copyWriteAlignment(Alignment alignment) {
            return new Spec(this.startDefined, this.span, alignment, this.weight);
        }

        private final int $$robo$$android_widget_GridLayout_Spec$getFlexibility() {
            return this.alignment == UNDEFINED_ALIGNMENT && this.weight == 0.0f ? 0 : 2;
        }

        private final boolean $$robo$$android_widget_GridLayout_Spec$equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            Spec spec = (Spec)that;
            if (!this.alignment.equals(spec.alignment)) {
                return false;
            }
            return this.span.equals(spec.span);
        }

        private final int $$robo$$android_widget_GridLayout_Spec$hashCode() {
            int result = this.span.hashCode();
            result = 31 * result + this.alignment.hashCode();
            return result;
        }

        private /* synthetic */ void $$robo$$android_widget_GridLayout_Spec$__constructor__(boolean x0, int x1, int x2, Alignment x3, float x4, 1 x5) {
        }

        static void __staticInitializer__() {
            UNDEFINED = GridLayout.spec(Integer.MIN_VALUE);
        }

        private void __constructor__(boolean bl, Interval interval, Alignment alignment, float f) {
            this.$$robo$$android_widget_GridLayout_Spec$__constructor__(bl, interval, alignment, f);
        }

        private Spec(boolean bl, Interval interval, Alignment alignment, float f) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_Spec$__constructor__(boolean android.widget.GridLayout$Interval android.widget.GridLayout$Alignment float ), 0, this, bl, interval, alignment, f);
        }

        private void __constructor__(boolean bl, int n, int n2, Alignment alignment, float f) {
            this.$$robo$$android_widget_GridLayout_Spec$__constructor__(bl, n, n2, alignment, f);
        }

        private Spec(boolean bl, int n, int n2, Alignment alignment, float f) {
            this(bl, new Interval(n, n + n2), alignment, f);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_Spec$__constructor__(boolean int int android.widget.GridLayout$Alignment float ), 0, this, bl, n, n2, alignment, f);
        }

        private Alignment getAbsoluteAlignment(boolean bl) {
            return InvokeDynamicSupport.bootstrap("getAbsoluteAlignment", $$robo$$android_widget_GridLayout_Spec$getAbsoluteAlignment(boolean ), 0, this, bl);
        }

        Spec copyWriteSpan(Interval interval) {
            return InvokeDynamicSupport.bootstrap("copyWriteSpan", $$robo$$android_widget_GridLayout_Spec$copyWriteSpan(android.widget.GridLayout$Interval ), 0, this, interval);
        }

        Spec copyWriteAlignment(Alignment alignment) {
            return InvokeDynamicSupport.bootstrap("copyWriteAlignment", $$robo$$android_widget_GridLayout_Spec$copyWriteAlignment(android.widget.GridLayout$Alignment ), 0, this, alignment);
        }

        int getFlexibility() {
            return (int)InvokeDynamicSupport.bootstrap("getFlexibility", $$robo$$android_widget_GridLayout_Spec$getFlexibility(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_widget_GridLayout_Spec$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_widget_GridLayout_Spec$hashCode(), 0, this);
        }

        private /* synthetic */ void __constructor__(boolean bl, int n, int n2, Alignment alignment, float f, 1 var6_6) {
            this.$$robo$$android_widget_GridLayout_Spec$__constructor__(bl, n, n2, alignment, f, var6_6);
        }

        static {
            RobolectricInternals.classInitializing(Spec.class);
        }

        public /* synthetic */ Spec() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Spec)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Interval
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int min;
        public int max;

        private void $$robo$$android_widget_GridLayout_Interval$__constructor__(int min, int max) {
            this.min = min;
            this.max = max;
        }

        private final int $$robo$$android_widget_GridLayout_Interval$size() {
            return this.max - this.min;
        }

        private final Interval $$robo$$android_widget_GridLayout_Interval$inverse() {
            return new Interval(this.max, this.min);
        }

        private final boolean $$robo$$android_widget_GridLayout_Interval$equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            Interval interval = (Interval)that;
            if (this.max != interval.max) {
                return false;
            }
            return this.min == interval.min;
        }

        private final int $$robo$$android_widget_GridLayout_Interval$hashCode() {
            int result = this.min;
            result = 31 * result + this.max;
            return result;
        }

        private final String $$robo$$android_widget_GridLayout_Interval$toString() {
            return "[" + this.min + ", " + this.max + "]";
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_widget_GridLayout_Interval$__constructor__(n, n2);
        }

        public Interval(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_Interval$__constructor__(int int ), 0, this, n, n2);
        }

        int size() {
            return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_widget_GridLayout_Interval$size(), 0, this);
        }

        Interval inverse() {
            return InvokeDynamicSupport.bootstrap("inverse", $$robo$$android_widget_GridLayout_Interval$inverse(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_widget_GridLayout_Interval$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_widget_GridLayout_Interval$hashCode(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_widget_GridLayout_Interval$toString(), 0, this);
        }

        public /* synthetic */ Interval() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Interval)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Bounds
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int before;
        public int after;
        public int flexibility;

        private void $$robo$$android_widget_GridLayout_Bounds$__constructor__() {
            this.reset();
        }

        private final void $$robo$$android_widget_GridLayout_Bounds$reset() {
            this.before = Integer.MIN_VALUE;
            this.after = Integer.MIN_VALUE;
            this.flexibility = 2;
        }

        private final void $$robo$$android_widget_GridLayout_Bounds$include(int before, int after) {
            this.before = Math.max(this.before, before);
            this.after = Math.max(this.after, after);
        }

        private final int $$robo$$android_widget_GridLayout_Bounds$size(boolean min) {
            if (!min && GridLayout.canStretch(this.flexibility)) {
                return 100000;
            }
            return this.before + this.after;
        }

        private final int $$robo$$android_widget_GridLayout_Bounds$getOffset(GridLayout gl, View c, Alignment a, int size, boolean horizontal) {
            return this.before - a.getAlignmentValue(c, size, gl.getLayoutMode());
        }

        private final void $$robo$$android_widget_GridLayout_Bounds$include(GridLayout gl, View c, Spec spec, Axis axis, int size) {
            this.flexibility &= spec.getFlexibility();
            boolean horizontal = axis.horizontal;
            Alignment alignment = spec.getAbsoluteAlignment(axis.horizontal);
            int before = alignment.getAlignmentValue(c, size, gl.getLayoutMode());
            this.include(before, size - before);
        }

        private final String $$robo$$android_widget_GridLayout_Bounds$toString() {
            return "Bounds{before=" + this.before + ", after=" + this.after + '}';
        }

        private /* synthetic */ void $$robo$$android_widget_GridLayout_Bounds$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_widget_GridLayout_Bounds$__constructor__();
        }

        private Bounds() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_Bounds$__constructor__(), 0, this);
        }

        protected void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_widget_GridLayout_Bounds$reset(), 0, this);
        }

        protected void include(int n, int n2) {
            InvokeDynamicSupport.bootstrap("include", $$robo$$android_widget_GridLayout_Bounds$include(int int ), 0, this, n, n2);
        }

        protected int size(boolean bl) {
            return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_widget_GridLayout_Bounds$size(boolean ), 0, this, bl);
        }

        protected int getOffset(GridLayout gridLayout, View view, Alignment alignment, int n, boolean bl) {
            return (int)InvokeDynamicSupport.bootstrap("getOffset", $$robo$$android_widget_GridLayout_Bounds$getOffset(android.widget.GridLayout android.view.View android.widget.GridLayout$Alignment int boolean ), 0, this, gridLayout, view, alignment, n, bl);
        }

        protected void include(GridLayout gridLayout, View view, Spec spec, Axis axis, int n) {
            InvokeDynamicSupport.bootstrap("include", $$robo$$android_widget_GridLayout_Bounds$include(android.widget.GridLayout android.view.View android.widget.GridLayout$Spec android.widget.GridLayout$Axis int ), 0, this, gridLayout, view, spec, axis, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_widget_GridLayout_Bounds$toString(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_widget_GridLayout_Bounds$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Bounds)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class PackedMap<K, V> {
        public transient /* synthetic */ Object __robo_data__;
        public int[] index;
        public K[] keys;
        public V[] values;

        private void $$robo$$android_widget_GridLayout_PackedMap$__constructor__(K[] keys, V[] values) {
            this.index = PackedMap.createIndex(keys);
            this.keys = PackedMap.compact(keys, this.index);
            this.values = PackedMap.compact(values, this.index);
        }

        private final V $$robo$$android_widget_GridLayout_PackedMap$getValue(int i) {
            return this.values[this.index[i]];
        }

        private static final <K> int[] $$robo$$android_widget_GridLayout_PackedMap$createIndex(K[] keys) {
            int size = keys.length;
            int[] result = new int[size];
            HashMap<K, Integer> keyToIndex = new HashMap<K, Integer>();
            for (int i = 0; i < size; ++i) {
                K key = keys[i];
                Integer index = (Integer)keyToIndex.get(key);
                if (index == null) {
                    index = keyToIndex.size();
                    keyToIndex.put(key, index);
                }
                result[i] = index;
            }
            return result;
        }

        private static final <K> K[] $$robo$$android_widget_GridLayout_PackedMap$compact(K[] a, int[] index) {
            int size = a.length;
            Class<?> componentType = a.getClass().getComponentType();
            Object[] result = (Object[])Array.newInstance(componentType, GridLayout.max2(index, -1) + 1);
            for (int i = 0; i < size; ++i) {
                result[index[i]] = a[i];
            }
            return result;
        }

        private /* synthetic */ void $$robo$$android_widget_GridLayout_PackedMap$__constructor__(Object[] x0, Object[] x1, 1 x2) {
        }

        private void __constructor__(K[] KArray, V[] VArray) {
            this.$$robo$$android_widget_GridLayout_PackedMap$__constructor__(KArray, VArray);
        }

        private PackedMap(K[] KArray, V[] VArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_PackedMap$__constructor__(K[] V[] ), 0, this, KArray, VArray);
        }

        public V getValue(int n) {
            return (V)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_widget_GridLayout_PackedMap$getValue(int ), 0, this, n);
        }

        private static <K> int[] createIndex(K[] KArray) {
            return InvokeDynamicSupport.bootstrapStatic("createIndex", $$robo$$android_widget_GridLayout_PackedMap$createIndex(K[] ), 0, (Object[])KArray);
        }

        private static <K> K[] compact(K[] KArray, int[] nArray) {
            return InvokeDynamicSupport.bootstrapStatic("compact", $$robo$$android_widget_GridLayout_PackedMap$compact(K[] int[] ), 0, (Object[])KArray, (int[])nArray);
        }

        private /* synthetic */ void __constructor__(Object[] objectArray, Object[] objectArray2, 1 var3_3) {
            this.$$robo$$android_widget_GridLayout_PackedMap$__constructor__(objectArray, objectArray2, var3_3);
        }

        public /* synthetic */ PackedMap() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PackedMap)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Assoc<K, V>
    extends ArrayList<Pair<K, V>> {
        public transient /* synthetic */ Object __robo_data__;
        private Class<K> keyType;
        private Class<V> valueType;

        private void $$robo$$android_widget_GridLayout_Assoc$__constructor__(Class<K> keyType, Class<V> valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        private static final <K, V> Assoc<K, V> $$robo$$android_widget_GridLayout_Assoc$of(Class<K> keyType, Class<V> valueType) {
            return new Assoc<K, V>(keyType, valueType);
        }

        private final void $$robo$$android_widget_GridLayout_Assoc$put(K key, V value) {
            this.add(Pair.create(key, value));
        }

        private final PackedMap<K, V> $$robo$$android_widget_GridLayout_Assoc$pack() {
            int N = this.size();
            Object[] keys = (Object[])Array.newInstance(this.keyType, N);
            Object[] values = (Object[])Array.newInstance(this.valueType, N);
            for (int i = 0; i < N; ++i) {
                keys[i] = ((Pair)this.get((int)i)).first;
                values[i] = ((Pair)this.get((int)i)).second;
            }
            return new PackedMap(keys, values);
        }

        private void __constructor__(Class<K> clazz, Class<V> clazz2) {
            this.$$robo$$android_widget_GridLayout_Assoc$__constructor__(clazz, clazz2);
        }

        private Assoc(Class<K> clazz, Class<V> clazz2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_Assoc$__constructor__(java.lang.Class<K> java.lang.Class<V> ), 0, this, clazz, clazz2);
        }

        public static <K, V> Assoc<K, V> of(Class<K> clazz, Class<V> clazz2) {
            return InvokeDynamicSupport.bootstrapStatic("of", $$robo$$android_widget_GridLayout_Assoc$of(java.lang.Class<K> java.lang.Class<V> ), 0, clazz, clazz2);
        }

        public void put(K k, V v) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_widget_GridLayout_Assoc$put(K V ), 0, this, k, v);
        }

        public PackedMap<K, V> pack() {
            return InvokeDynamicSupport.bootstrap("pack", $$robo$$android_widget_GridLayout_Assoc$pack(), 0, this);
        }

        public /* synthetic */ Assoc() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Assoc)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class MutableInt
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int value;

        private void $$robo$$android_widget_GridLayout_MutableInt$__constructor__() {
            this.reset();
        }

        private void $$robo$$android_widget_GridLayout_MutableInt$__constructor__(int value) {
            this.value = value;
        }

        private final void $$robo$$android_widget_GridLayout_MutableInt$reset() {
            this.value = Integer.MIN_VALUE;
        }

        private final String $$robo$$android_widget_GridLayout_MutableInt$toString() {
            return Integer.toString(this.value);
        }

        private void __constructor__() {
            this.$$robo$$android_widget_GridLayout_MutableInt$__constructor__();
        }

        public MutableInt() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_MutableInt$__constructor__(), 0, this);
        }

        private void __constructor__(int n) {
            this.$$robo$$android_widget_GridLayout_MutableInt$__constructor__(n);
        }

        public MutableInt(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_MutableInt$__constructor__(int ), 0, this, n);
        }

        public void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_widget_GridLayout_MutableInt$reset(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_widget_GridLayout_MutableInt$toString(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MutableInt)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Arc
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Interval span;
        public MutableInt value;
        public boolean valid;

        private void $$robo$$android_widget_GridLayout_Arc$__constructor__(Interval span, MutableInt value) {
            this.valid = true;
            this.span = span;
            this.value = value;
        }

        private final String $$robo$$android_widget_GridLayout_Arc$toString() {
            return this.span + " " + (!this.valid ? "+>" : "->") + " " + this.value;
        }

        private void __constructor__(Interval interval, MutableInt mutableInt) {
            this.$$robo$$android_widget_GridLayout_Arc$__constructor__(interval, mutableInt);
        }

        public Arc(Interval interval, MutableInt mutableInt) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_Arc$__constructor__(android.widget.GridLayout$Interval android.widget.GridLayout$MutableInt ), 0, this, interval, mutableInt);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_widget_GridLayout_Arc$toString(), 0, this);
        }

        public /* synthetic */ Arc() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Arc)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int DEFAULT_WIDTH = -2;
        private static int DEFAULT_HEIGHT = -2;
        private static int DEFAULT_MARGIN = Integer.MIN_VALUE;
        private static int DEFAULT_ROW = Integer.MIN_VALUE;
        private static int DEFAULT_COLUMN = Integer.MIN_VALUE;
        private static Interval DEFAULT_SPAN;
        private static int DEFAULT_SPAN_SIZE;
        private static int MARGIN = 2;
        private static int LEFT_MARGIN = 3;
        private static int TOP_MARGIN = 4;
        private static int RIGHT_MARGIN = 5;
        private static int BOTTOM_MARGIN = 6;
        private static int COLUMN = 1;
        private static int COLUMN_SPAN = 4;
        private static int COLUMN_WEIGHT = 6;
        private static int ROW = 2;
        private static int ROW_SPAN = 3;
        private static int ROW_WEIGHT = 5;
        private static int GRAVITY = 0;
        public Spec rowSpec;
        public Spec columnSpec;

        private void $$robo$$android_widget_GridLayout_LayoutParams$__constructor__(int width, int height, int left, int top, int right, int bottom, Spec rowSpec, Spec columnSpec) {
            this.rowSpec = Spec.UNDEFINED;
            this.columnSpec = Spec.UNDEFINED;
            this.setMargins(left, top, right, bottom);
            this.rowSpec = rowSpec;
            this.columnSpec = columnSpec;
        }

        private void $$robo$$android_widget_GridLayout_LayoutParams$__constructor__(Spec rowSpec, Spec columnSpec) {
        }

        private void $$robo$$android_widget_GridLayout_LayoutParams$__constructor__() {
        }

        private void $$robo$$android_widget_GridLayout_LayoutParams$__constructor__(ViewGroup.LayoutParams params) {
            this.rowSpec = Spec.UNDEFINED;
            this.columnSpec = Spec.UNDEFINED;
        }

        private void $$robo$$android_widget_GridLayout_LayoutParams$__constructor__(ViewGroup.MarginLayoutParams params) {
            this.rowSpec = Spec.UNDEFINED;
            this.columnSpec = Spec.UNDEFINED;
        }

        private void $$robo$$android_widget_GridLayout_LayoutParams$__constructor__(LayoutParams source) {
            this.rowSpec = Spec.UNDEFINED;
            this.columnSpec = Spec.UNDEFINED;
            this.rowSpec = source.rowSpec;
            this.columnSpec = source.columnSpec;
        }

        private void $$robo$$android_widget_GridLayout_LayoutParams$__constructor__(Context context, AttributeSet attrs) {
            this.rowSpec = Spec.UNDEFINED;
            this.columnSpec = Spec.UNDEFINED;
            this.reInitSuper(context, attrs);
            this.init(context, attrs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_widget_GridLayout_LayoutParams$reInitSuper(Context context, AttributeSet attrs) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ViewGroup_MarginLayout);
            try {
                int margin = a.getDimensionPixelSize(2, Integer.MIN_VALUE);
                this.leftMargin = a.getDimensionPixelSize(3, margin);
                this.topMargin = a.getDimensionPixelSize(4, margin);
                this.rightMargin = a.getDimensionPixelSize(5, margin);
                this.bottomMargin = a.getDimensionPixelSize(6, margin);
            }
            finally {
                a.recycle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_widget_GridLayout_LayoutParams$init(Context context, AttributeSet attrs) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.GridLayout_Layout);
            try {
                int gravity = a.getInt(0, 0);
                int column = a.getInt(1, Integer.MIN_VALUE);
                int colSpan = a.getInt(4, DEFAULT_SPAN_SIZE);
                float colWeight = a.getFloat(6, 0.0f);
                this.columnSpec = GridLayout.spec(column, colSpan, GridLayout.getAlignment(gravity, true), colWeight);
                int row = a.getInt(2, Integer.MIN_VALUE);
                int rowSpan = a.getInt(3, DEFAULT_SPAN_SIZE);
                float rowWeight = a.getFloat(5, 0.0f);
                this.rowSpec = GridLayout.spec(row, rowSpan, GridLayout.getAlignment(gravity, false), rowWeight);
            }
            finally {
                a.recycle();
            }
        }

        private final void $$robo$$android_widget_GridLayout_LayoutParams$setGravity(int gravity) {
            this.rowSpec = this.rowSpec.copyWriteAlignment(GridLayout.getAlignment(gravity, false));
            this.columnSpec = this.columnSpec.copyWriteAlignment(GridLayout.getAlignment(gravity, true));
        }

        private final void $$robo$$android_widget_GridLayout_LayoutParams$setBaseAttributes(TypedArray attributes, int widthAttr, int heightAttr) {
            this.width = attributes.getLayoutDimension(widthAttr, -2);
            this.height = attributes.getLayoutDimension(heightAttr, -2);
        }

        private final void $$robo$$android_widget_GridLayout_LayoutParams$setRowSpecSpan(Interval span) {
            this.rowSpec = this.rowSpec.copyWriteSpan(span);
        }

        private final void $$robo$$android_widget_GridLayout_LayoutParams$setColumnSpecSpan(Interval span) {
            this.columnSpec = this.columnSpec.copyWriteSpan(span);
        }

        private final boolean $$robo$$android_widget_GridLayout_LayoutParams$equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LayoutParams that = (LayoutParams)o;
            if (!this.columnSpec.equals(that.columnSpec)) {
                return false;
            }
            return this.rowSpec.equals(that.rowSpec);
        }

        private final int $$robo$$android_widget_GridLayout_LayoutParams$hashCode() {
            int result = this.rowSpec.hashCode();
            result = 31 * result + this.columnSpec.hashCode();
            return result;
        }

        static void __staticInitializer__() {
            DEFAULT_SPAN = new Interval(Integer.MIN_VALUE, -2147483647);
            DEFAULT_SPAN_SIZE = DEFAULT_SPAN.size();
        }

        private void __constructor__(int n, int n2, int n3, int n4, int n5, int n6, Spec spec, Spec spec2) {
            this.$$robo$$android_widget_GridLayout_LayoutParams$__constructor__(n, n2, n3, n4, n5, n6, spec, spec2);
        }

        private LayoutParams(int n, int n2, int n3, int n4, int n5, int n6, Spec spec, Spec spec2) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_LayoutParams$__constructor__(int int int int int int android.widget.GridLayout$Spec android.widget.GridLayout$Spec ), 0, this, n, n2, n3, n4, n5, n6, spec, spec2);
        }

        private void __constructor__(Spec spec, Spec spec2) {
            this.$$robo$$android_widget_GridLayout_LayoutParams$__constructor__(spec, spec2);
        }

        public LayoutParams(Spec spec, Spec spec2) {
            this(-2, -2, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, spec, spec2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_LayoutParams$__constructor__(android.widget.GridLayout$Spec android.widget.GridLayout$Spec ), 0, this, spec, spec2);
        }

        private void __constructor__() {
            this.$$robo$$android_widget_GridLayout_LayoutParams$__constructor__();
        }

        public LayoutParams() {
            this(Spec.UNDEFINED, Spec.UNDEFINED);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_LayoutParams$__constructor__(), 0, this);
        }

        private void __constructor__(ViewGroup.LayoutParams layoutParams) {
            this.$$robo$$android_widget_GridLayout_LayoutParams$__constructor__(layoutParams);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_LayoutParams$__constructor__(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
        }

        private void __constructor__(ViewGroup.MarginLayoutParams marginLayoutParams) {
            this.$$robo$$android_widget_GridLayout_LayoutParams$__constructor__(marginLayoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_LayoutParams$__constructor__(android.view.ViewGroup$MarginLayoutParams ), 0, this, marginLayoutParams);
        }

        private void __constructor__(LayoutParams layoutParams) {
            this.$$robo$$android_widget_GridLayout_LayoutParams$__constructor__(layoutParams);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super(layoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_LayoutParams$__constructor__(android.widget.GridLayout$LayoutParams ), 0, this, layoutParams);
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$android_widget_GridLayout_LayoutParams$__constructor__(context, attributeSet);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_LayoutParams$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
        }

        private void reInitSuper(Context context, AttributeSet attributeSet) {
            InvokeDynamicSupport.bootstrap("reInitSuper", $$robo$$android_widget_GridLayout_LayoutParams$reInitSuper(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
        }

        private void init(Context context, AttributeSet attributeSet) {
            InvokeDynamicSupport.bootstrap("init", $$robo$$android_widget_GridLayout_LayoutParams$init(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
        }

        public void setGravity(int n) {
            InvokeDynamicSupport.bootstrap("setGravity", $$robo$$android_widget_GridLayout_LayoutParams$setGravity(int ), 0, this, n);
        }

        @Override
        protected void setBaseAttributes(TypedArray typedArray, int n, int n2) {
            InvokeDynamicSupport.bootstrap("setBaseAttributes", $$robo$$android_widget_GridLayout_LayoutParams$setBaseAttributes(android.content.res.TypedArray int int ), 0, this, typedArray, n, n2);
        }

        void setRowSpecSpan(Interval interval) {
            InvokeDynamicSupport.bootstrap("setRowSpecSpan", $$robo$$android_widget_GridLayout_LayoutParams$setRowSpecSpan(android.widget.GridLayout$Interval ), 0, this, interval);
        }

        void setColumnSpecSpan(Interval interval) {
            InvokeDynamicSupport.bootstrap("setColumnSpecSpan", $$robo$$android_widget_GridLayout_LayoutParams$setColumnSpecSpan(android.widget.GridLayout$Interval ), 0, this, interval);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_widget_GridLayout_LayoutParams$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_widget_GridLayout_LayoutParams$hashCode(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(LayoutParams.class);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutParams)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class Axis
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int NEW = 0;
        private static int PENDING = 1;
        private static int COMPLETE = 2;
        public boolean horizontal;
        public int definedCount;
        private int maxIndex;
        PackedMap<Spec, Bounds> groupBounds;
        public boolean groupBoundsValid;
        PackedMap<Interval, MutableInt> forwardLinks;
        public boolean forwardLinksValid;
        PackedMap<Interval, MutableInt> backwardLinks;
        public boolean backwardLinksValid;
        public int[] leadingMargins;
        public boolean leadingMarginsValid;
        public int[] trailingMargins;
        public boolean trailingMarginsValid;
        public Arc[] arcs;
        public boolean arcsValid;
        public int[] locations;
        public boolean locationsValid;
        public boolean hasWeights;
        public boolean hasWeightsValid;
        public int[] deltas;
        boolean orderPreserved;
        private MutableInt parentMin;
        private MutableInt parentMax;
        static /* synthetic */ boolean $assertionsDisabled;
        /* synthetic */ GridLayout this$0;

        private void $$robo$$android_widget_GridLayout_Axis$__constructor__(GridLayout this$0, boolean horizontal) {
            this.definedCount = Integer.MIN_VALUE;
            this.maxIndex = Integer.MIN_VALUE;
            this.groupBoundsValid = false;
            this.forwardLinksValid = false;
            this.backwardLinksValid = false;
            this.leadingMarginsValid = false;
            this.trailingMarginsValid = false;
            this.arcsValid = false;
            this.locationsValid = false;
            this.hasWeightsValid = false;
            this.orderPreserved = true;
            this.parentMin = new MutableInt(0);
            this.parentMax = new MutableInt(-100000);
            this.horizontal = horizontal;
        }

        private final int $$robo$$android_widget_GridLayout_Axis$calculateMaxIndex() {
            int result = -1;
            int N = this.this$0.getChildCount();
            for (int i = 0; i < N; ++i) {
                View c = this.this$0.getChildAt(i);
                LayoutParams params = this.this$0.getLayoutParams(c);
                Spec spec = this.horizontal ? params.columnSpec : params.rowSpec;
                Interval span = spec.span;
                result = Math.max(result, span.min);
                result = Math.max(result, span.max);
                result = Math.max(result, span.size());
            }
            return result == -1 ? Integer.MIN_VALUE : result;
        }

        private final int $$robo$$android_widget_GridLayout_Axis$getMaxIndex() {
            if (this.maxIndex == Integer.MIN_VALUE) {
                this.maxIndex = Math.max(0, this.calculateMaxIndex());
            }
            return this.maxIndex;
        }

        private final int $$robo$$android_widget_GridLayout_Axis$getCount() {
            return Math.max(this.definedCount, this.getMaxIndex());
        }

        private final void $$robo$$android_widget_GridLayout_Axis$setCount(int count) {
            if (count != Integer.MIN_VALUE && count < this.getMaxIndex()) {
                GridLayout.handleInvalidParams((this.horizontal ? "column" : "row") + "Count must be greater than or equal to the maximum of all grid indices (and spans) defined in the LayoutParams of each child");
            }
            this.definedCount = count;
        }

        private final boolean $$robo$$android_widget_GridLayout_Axis$isOrderPreserved() {
            return this.orderPreserved;
        }

        private final void $$robo$$android_widget_GridLayout_Axis$setOrderPreserved(boolean orderPreserved) {
            this.orderPreserved = orderPreserved;
            this.invalidateStructure();
        }

        private final PackedMap<Spec, Bounds> $$robo$$android_widget_GridLayout_Axis$createGroupBounds() {
            Assoc<Spec, Bounds> assoc = Assoc.of(Spec.class, Bounds.class);
            int N = this.this$0.getChildCount();
            for (int i = 0; i < N; ++i) {
                View c = this.this$0.getChildAt(i);
                LayoutParams lp = this.this$0.getLayoutParams(c);
                Spec spec = this.horizontal ? lp.columnSpec : lp.rowSpec;
                Bounds bounds = spec.getAbsoluteAlignment(this.horizontal).getBounds();
                assoc.put(spec, bounds);
            }
            return assoc.pack();
        }

        private final void $$robo$$android_widget_GridLayout_Axis$computeGroupBounds() {
            int i;
            Bounds[] values = (Bounds[])this.groupBounds.values;
            for (i = 0; i < values.length; ++i) {
                values[i].reset();
            }
            int N = this.this$0.getChildCount();
            for (i = 0; i < N; ++i) {
                View c = this.this$0.getChildAt(i);
                LayoutParams lp = this.this$0.getLayoutParams(c);
                Spec spec = this.horizontal ? lp.columnSpec : lp.rowSpec;
                int size = this.this$0.getMeasurementIncludingMargin(c, this.horizontal) + (spec.weight == 0.0f ? 0 : this.getDeltas()[i]);
                this.groupBounds.getValue(i).include(this.this$0, c, spec, this, size);
            }
        }

        private final PackedMap<Spec, Bounds> $$robo$$android_widget_GridLayout_Axis$getGroupBounds() {
            if (this.groupBounds == null) {
                this.groupBounds = this.createGroupBounds();
            }
            if (!this.groupBoundsValid) {
                this.computeGroupBounds();
                this.groupBoundsValid = true;
            }
            return this.groupBounds;
        }

        private final PackedMap<Interval, MutableInt> $$robo$$android_widget_GridLayout_Axis$createLinks(boolean min) {
            Assoc<Interval, MutableInt> result = Assoc.of(Interval.class, MutableInt.class);
            Spec[] keys = (Spec[])this.getGroupBounds().keys;
            int N = keys.length;
            for (int i = 0; i < N; ++i) {
                Interval span = min ? keys[i].span : keys[i].span.inverse();
                result.put(span, new MutableInt());
            }
            return result.pack();
        }

        private final void $$robo$$android_widget_GridLayout_Axis$computeLinks(PackedMap<Interval, MutableInt> links, boolean min) {
            MutableInt[] spans = (MutableInt[])links.values;
            for (int i = 0; i < spans.length; ++i) {
                spans[i].reset();
            }
            Bounds[] bounds = (Bounds[])this.getGroupBounds().values;
            for (int i = 0; i < bounds.length; ++i) {
                int size = bounds[i].size(min);
                MutableInt valueHolder = links.getValue(i);
                valueHolder.value = Math.max(valueHolder.value, min ? size : -size);
            }
        }

        private final PackedMap<Interval, MutableInt> $$robo$$android_widget_GridLayout_Axis$getForwardLinks() {
            if (this.forwardLinks == null) {
                this.forwardLinks = this.createLinks(true);
            }
            if (!this.forwardLinksValid) {
                this.computeLinks(this.forwardLinks, true);
                this.forwardLinksValid = true;
            }
            return this.forwardLinks;
        }

        private final PackedMap<Interval, MutableInt> $$robo$$android_widget_GridLayout_Axis$getBackwardLinks() {
            if (this.backwardLinks == null) {
                this.backwardLinks = this.createLinks(false);
            }
            if (!this.backwardLinksValid) {
                this.computeLinks(this.backwardLinks, false);
                this.backwardLinksValid = true;
            }
            return this.backwardLinks;
        }

        private final void $$robo$$android_widget_GridLayout_Axis$include(List<Arc> arcs, Interval key, MutableInt size, boolean ignoreIfAlreadyPresent) {
            if (key.size() == 0) {
                return;
            }
            if (ignoreIfAlreadyPresent) {
                for (Arc arc : arcs) {
                    Interval span = arc.span;
                    if (!span.equals(key)) continue;
                    return;
                }
            }
            arcs.add(new Arc(key, size));
        }

        private final void $$robo$$android_widget_GridLayout_Axis$include(List<Arc> arcs, Interval key, MutableInt size) {
            this.include(arcs, key, size, true);
        }

        private final Arc[][] $$robo$$android_widget_GridLayout_Axis$groupArcsByFirstVertex(Arc[] arcs) {
            int N = this.getCount() + 1;
            Arc[][] result = new Arc[N][];
            int[] sizes = new int[N];
            for (Arc arc : arcs) {
                int n = arc.span.min;
                sizes[n] = sizes[n] + 1;
            }
            for (int i = 0; i < sizes.length; ++i) {
                result[i] = new Arc[sizes[i]];
            }
            Arrays.fill(sizes, 0);
            for (Arc arc : arcs) {
                int i;
                int n = i = arc.span.min;
                int n2 = sizes[n];
                sizes[n] = n2 + 1;
                result[i][n2] = arc;
            }
            return result;
        }

        private final Arc[] $$robo$$android_widget_GridLayout_Axis$topologicalSort(Arc[] arcs) {
            return new ShadowedObject(this, arcs){
                public transient /* synthetic */ Object __robo_data__;
                Arc[] result;
                int cursor;
                Arc[][] arcsByVertex;
                int[] visited;
                static /* synthetic */ boolean $assertionsDisabled;
                /* synthetic */ Arc[] val$arcs;
                /* synthetic */ Axis this$1;

                private void $$robo$$android_widget_GridLayout_Axis_1$__constructor__(Axis this$1, Arc[] arcArray) {
                    this.result = new Arc[this.val$arcs.length];
                    this.cursor = this.result.length - 1;
                    this.arcsByVertex = this.this$1.groupArcsByFirstVertex(this.val$arcs);
                    this.visited = new int[this.this$1.getCount() + 1];
                }

                private final void $$robo$$android_widget_GridLayout_Axis_1$walk(int loc) {
                    switch (this.visited[loc]) {
                        case 0: {
                            this.visited[loc] = 1;
                            for (Arc arc : this.arcsByVertex[loc]) {
                                this.walk(arc.span.max);
                                this.result[this.cursor--] = arc;
                            }
                            this.visited[loc] = 2;
                            break;
                        }
                        case 1: {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            break;
                        }
                    }
                }

                private final Arc[] $$robo$$android_widget_GridLayout_Axis_1$sort() {
                    int N = this.arcsByVertex.length;
                    for (int loc = 0; loc < N; ++loc) {
                        this.walk(loc);
                    }
                    if (!$assertionsDisabled && this.cursor != -1) {
                        throw new AssertionError();
                    }
                    return this.result;
                }

                static void __staticInitializer__() {
                    $assertionsDisabled = !GridLayout.class.desiredAssertionStatus();
                }

                private void __constructor__(Axis axis, Arc[] arcArray) {
                    this.$$robo$$android_widget_GridLayout_Axis_1$__constructor__(axis, arcArray);
                }
                {
                    this.this$1 = axis;
                    this.val$arcs = arcArray;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_Axis_1$__constructor__(android.widget.GridLayout$Axis android.widget.GridLayout$Arc[] ), 0, this, axis, arcArray);
                }

                void walk(int n) {
                    InvokeDynamicSupport.bootstrap("walk", $$robo$$android_widget_GridLayout_Axis_1$walk(int ), 0, this, n);
                }

                Arc[] sort() {
                    return InvokeDynamicSupport.bootstrap("sort", $$robo$$android_widget_GridLayout_Axis_1$sort(), 0, this);
                }

                static {
                    RobolectricInternals.classInitializing(1.class);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            }.sort();
        }

        private final Arc[] $$robo$$android_widget_GridLayout_Axis$topologicalSort(List<Arc> arcs) {
            return this.topologicalSort(arcs.toArray(new Arc[arcs.size()]));
        }

        private final void $$robo$$android_widget_GridLayout_Axis$addComponentSizes(List<Arc> result, PackedMap<Interval, MutableInt> links) {
            for (int i = 0; i < ((Interval[])links.keys).length; ++i) {
                Interval key = ((Interval[])links.keys)[i];
                this.include(result, key, ((MutableInt[])links.values)[i], false);
            }
        }

        private final Arc[] $$robo$$android_widget_GridLayout_Axis$createArcs() {
            ArrayList<Arc> mins = new ArrayList<Arc>();
            ArrayList<Arc> maxs = new ArrayList<Arc>();
            this.addComponentSizes(mins, this.getForwardLinks());
            this.addComponentSizes(maxs, this.getBackwardLinks());
            if (this.orderPreserved) {
                for (int i = 0; i < this.getCount(); ++i) {
                    this.include(mins, new Interval(i, i + 1), new MutableInt(0));
                }
            }
            int N = this.getCount();
            this.include(mins, new Interval(0, N), this.parentMin, false);
            this.include(maxs, new Interval(N, 0), this.parentMax, false);
            Arc[] sMins = this.topologicalSort(mins);
            Arc[] sMaxs = this.topologicalSort(maxs);
            return GridLayout.append(sMins, sMaxs);
        }

        private final void $$robo$$android_widget_GridLayout_Axis$computeArcs() {
            this.getForwardLinks();
            this.getBackwardLinks();
        }

        private final Arc[] $$robo$$android_widget_GridLayout_Axis$getArcs() {
            if (this.arcs == null) {
                this.arcs = this.createArcs();
            }
            if (!this.arcsValid) {
                this.computeArcs();
                this.arcsValid = true;
            }
            return this.arcs;
        }

        private final boolean $$robo$$android_widget_GridLayout_Axis$relax(int[] locations, Arc entry) {
            if (!entry.valid) {
                return false;
            }
            Interval span = entry.span;
            int u = span.min;
            int value = entry.value.value;
            int candidate = locations[u] + value;
            int v = span.max;
            if (candidate > locations[v]) {
                locations[v] = candidate;
                return true;
            }
            return false;
        }

        private final void $$robo$$android_widget_GridLayout_Axis$init(int[] locations) {
            Arrays.fill(locations, 0);
        }

        private final String $$robo$$android_widget_GridLayout_Axis$arcsToString(List<Arc> arcs) {
            String var = this.horizontal ? "x" : "y";
            StringBuilder result = new StringBuilder();
            boolean first = true;
            for (Arc arc : arcs) {
                if (first) {
                    first = false;
                } else {
                    result = result.append(", ");
                }
                int src = arc.span.min;
                int dst = arc.span.max;
                int value = arc.value.value;
                result.append(src < dst ? var + dst + "-" + var + src + ">=" + value : var + src + "-" + var + dst + "<=" + -value);
            }
            return result.toString();
        }

        private final void $$robo$$android_widget_GridLayout_Axis$logError(String axisName, Arc[] arcs, boolean[] culprits0) {
            ArrayList<Arc> culprits = new ArrayList<Arc>();
            ArrayList<Arc> removed = new ArrayList<Arc>();
            for (int c = 0; c < arcs.length; ++c) {
                Arc arc = arcs[c];
                if (culprits0[c]) {
                    culprits.add(arc);
                }
                if (arc.valid) continue;
                removed.add(arc);
            }
            this.this$0.mPrinter.println(axisName + " constraints: " + this.arcsToString(culprits) + " are inconsistent; permanently removing: " + this.arcsToString(removed) + ". ");
        }

        private final boolean $$robo$$android_widget_GridLayout_Axis$solve(Arc[] arcs, int[] locations) {
            return this.solve(arcs, locations, true);
        }

        private final boolean $$robo$$android_widget_GridLayout_Axis$solve(Arc[] arcs, int[] locations, boolean modifyOnError) {
            String axisName = this.horizontal ? "horizontal" : "vertical";
            int N = this.getCount() + 1;
            boolean[] originalCulprits = null;
            block0: for (int p = 0; p < arcs.length; ++p) {
                int i;
                int j;
                int length;
                this.init(locations);
                for (int i2 = 0; i2 < N; ++i2) {
                    boolean changed = false;
                    length = arcs.length;
                    for (j = 0; j < length; ++j) {
                        changed |= this.relax(locations, arcs[j]);
                    }
                    if (changed) continue;
                    if (originalCulprits != null) {
                        this.logError(axisName, arcs, originalCulprits);
                    }
                    return true;
                }
                if (!modifyOnError) {
                    return false;
                }
                boolean[] culprits = new boolean[arcs.length];
                for (i = 0; i < N; ++i) {
                    length = arcs.length;
                    for (j = 0; j < length; ++j) {
                        int n = j;
                        culprits[n] = culprits[n] | this.relax(locations, arcs[j]);
                    }
                }
                if (p == 0) {
                    originalCulprits = culprits;
                }
                for (i = 0; i < arcs.length; ++i) {
                    if (!culprits[i]) continue;
                    Arc arc = arcs[i];
                    if (arc.span.min < arc.span.max) continue;
                    arc.valid = false;
                    continue block0;
                }
            }
            return true;
        }

        private final void $$robo$$android_widget_GridLayout_Axis$computeMargins(boolean leading) {
            int[] margins = leading ? this.leadingMargins : this.trailingMargins;
            int N = this.this$0.getChildCount();
            for (int i = 0; i < N; ++i) {
                View c = this.this$0.getChildAt(i);
                if (c.getVisibility() == 8) continue;
                LayoutParams lp = this.this$0.getLayoutParams(c);
                Spec spec = this.horizontal ? lp.columnSpec : lp.rowSpec;
                Interval span = spec.span;
                int index = leading ? span.min : span.max;
                margins[index] = Math.max(margins[index], this.this$0.getMargin1(c, this.horizontal, leading));
            }
        }

        private final int[] $$robo$$android_widget_GridLayout_Axis$getLeadingMargins() {
            if (this.leadingMargins == null) {
                this.leadingMargins = new int[this.getCount() + 1];
            }
            if (!this.leadingMarginsValid) {
                this.computeMargins(true);
                this.leadingMarginsValid = true;
            }
            return this.leadingMargins;
        }

        private final int[] $$robo$$android_widget_GridLayout_Axis$getTrailingMargins() {
            if (this.trailingMargins == null) {
                this.trailingMargins = new int[this.getCount() + 1];
            }
            if (!this.trailingMarginsValid) {
                this.computeMargins(false);
                this.trailingMarginsValid = true;
            }
            return this.trailingMargins;
        }

        private final boolean $$robo$$android_widget_GridLayout_Axis$solve(int[] a) {
            return this.solve(this.getArcs(), a);
        }

        private final boolean $$robo$$android_widget_GridLayout_Axis$computeHasWeights() {
            int N = this.this$0.getChildCount();
            for (int i = 0; i < N; ++i) {
                Spec spec;
                View child = this.this$0.getChildAt(i);
                if (child.getVisibility() == 8) continue;
                LayoutParams lp = this.this$0.getLayoutParams(child);
                Spec spec2 = spec = this.horizontal ? lp.columnSpec : lp.rowSpec;
                if (spec.weight == 0.0f) continue;
                return true;
            }
            return false;
        }

        private final boolean $$robo$$android_widget_GridLayout_Axis$hasWeights() {
            if (!this.hasWeightsValid) {
                this.hasWeights = this.computeHasWeights();
                this.hasWeightsValid = true;
            }
            return this.hasWeights;
        }

        private final int[] $$robo$$android_widget_GridLayout_Axis$getDeltas() {
            if (this.deltas == null) {
                this.deltas = new int[this.this$0.getChildCount()];
            }
            return this.deltas;
        }

        private final void $$robo$$android_widget_GridLayout_Axis$shareOutDelta(int totalDelta, float totalWeight) {
            Arrays.fill(this.deltas, 0);
            int N = this.this$0.getChildCount();
            for (int i = 0; i < N; ++i) {
                int delta;
                View c = this.this$0.getChildAt(i);
                if (c.getVisibility() == 8) continue;
                LayoutParams lp = this.this$0.getLayoutParams(c);
                Spec spec = this.horizontal ? lp.columnSpec : lp.rowSpec;
                float weight = spec.weight;
                if (weight == 0.0f) continue;
                this.deltas[i] = delta = Math.round(weight * (float)totalDelta / totalWeight);
                totalDelta -= delta;
                totalWeight -= weight;
            }
        }

        private final void $$robo$$android_widget_GridLayout_Axis$solveAndDistributeSpace(int[] a) {
            Arrays.fill(this.getDeltas(), 0);
            this.solve(a);
            int deltaMax = this.parentMin.value * this.this$0.getChildCount() + 1;
            if (deltaMax < 2) {
                return;
            }
            int deltaMin = 0;
            float totalWeight = this.calculateTotalWeight();
            int validDelta = -1;
            boolean validSolution = true;
            while (deltaMin < deltaMax) {
                int delta = (int)(((long)deltaMin + (long)deltaMax) / 2L);
                this.invalidateValues();
                this.shareOutDelta(delta, totalWeight);
                validSolution = this.solve(this.getArcs(), a, false);
                if (validSolution) {
                    validDelta = delta;
                    deltaMin = delta + 1;
                    continue;
                }
                deltaMax = delta;
            }
            if (validDelta > 0 && !validSolution) {
                this.invalidateValues();
                this.shareOutDelta(validDelta, totalWeight);
                this.solve(a);
            }
        }

        private final float $$robo$$android_widget_GridLayout_Axis$calculateTotalWeight() {
            float totalWeight = 0.0f;
            int N = this.this$0.getChildCount();
            for (int i = 0; i < N; ++i) {
                View c = this.this$0.getChildAt(i);
                if (c.getVisibility() == 8) continue;
                LayoutParams lp = this.this$0.getLayoutParams(c);
                Spec spec = this.horizontal ? lp.columnSpec : lp.rowSpec;
                totalWeight += spec.weight;
            }
            return totalWeight;
        }

        private final void $$robo$$android_widget_GridLayout_Axis$computeLocations(int[] a) {
            if (!this.hasWeights()) {
                this.solve(a);
            } else {
                this.solveAndDistributeSpace(a);
            }
            if (!this.orderPreserved) {
                int a0 = a[0];
                int N = a.length;
                for (int i = 0; i < N; ++i) {
                    a[i] = a[i] - a0;
                }
            }
        }

        private final int[] $$robo$$android_widget_GridLayout_Axis$getLocations() {
            if (this.locations == null) {
                int N = this.getCount() + 1;
                this.locations = new int[N];
            }
            if (!this.locationsValid) {
                this.computeLocations(this.locations);
                this.locationsValid = true;
            }
            return this.locations;
        }

        private final int $$robo$$android_widget_GridLayout_Axis$size(int[] locations) {
            return locations[this.getCount()];
        }

        private final void $$robo$$android_widget_GridLayout_Axis$setParentConstraints(int min, int max) {
            this.parentMin.value = min;
            this.parentMax.value = -max;
            this.locationsValid = false;
        }

        private final int $$robo$$android_widget_GridLayout_Axis$getMeasure(int min, int max) {
            this.setParentConstraints(min, max);
            return this.size(this.getLocations());
        }

        private final int $$robo$$android_widget_GridLayout_Axis$getMeasure(int measureSpec) {
            int mode = View.MeasureSpec.getMode(measureSpec);
            int size = View.MeasureSpec.getSize(measureSpec);
            switch (mode) {
                case 0: {
                    return this.getMeasure(0, 100000);
                }
                case 0x40000000: {
                    return this.getMeasure(size, size);
                }
                case -2147483648: {
                    return this.getMeasure(0, size);
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return 0;
        }

        private final void $$robo$$android_widget_GridLayout_Axis$layout(int size) {
            this.setParentConstraints(size, size);
            this.getLocations();
        }

        private final void $$robo$$android_widget_GridLayout_Axis$invalidateStructure() {
            this.maxIndex = Integer.MIN_VALUE;
            this.groupBounds = null;
            this.forwardLinks = null;
            this.backwardLinks = null;
            this.leadingMargins = null;
            this.trailingMargins = null;
            this.arcs = null;
            this.locations = null;
            this.deltas = null;
            this.hasWeightsValid = false;
            this.invalidateValues();
        }

        private final void $$robo$$android_widget_GridLayout_Axis$invalidateValues() {
            this.groupBoundsValid = false;
            this.forwardLinksValid = false;
            this.backwardLinksValid = false;
            this.leadingMarginsValid = false;
            this.trailingMarginsValid = false;
            this.arcsValid = false;
            this.locationsValid = false;
        }

        private /* synthetic */ void $$robo$$android_widget_GridLayout_Axis$__constructor__(GridLayout x0, boolean x1, android.widget.GridLayout$1 x2) {
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !GridLayout.class.desiredAssertionStatus();
        }

        private void __constructor__(GridLayout gridLayout, boolean bl) {
            this.$$robo$$android_widget_GridLayout_Axis$__constructor__(gridLayout, bl);
        }

        private Axis(GridLayout gridLayout, boolean bl) {
            this.this$0 = gridLayout;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridLayout_Axis$__constructor__(android.widget.GridLayout boolean ), 0, this, gridLayout, bl);
        }

        private int calculateMaxIndex() {
            return (int)InvokeDynamicSupport.bootstrap("calculateMaxIndex", $$robo$$android_widget_GridLayout_Axis$calculateMaxIndex(), 0, this);
        }

        private int getMaxIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getMaxIndex", $$robo$$android_widget_GridLayout_Axis$getMaxIndex(), 0, this);
        }

        public int getCount() {
            return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$android_widget_GridLayout_Axis$getCount(), 0, this);
        }

        public void setCount(int n) {
            InvokeDynamicSupport.bootstrap("setCount", $$robo$$android_widget_GridLayout_Axis$setCount(int ), 0, this, n);
        }

        public boolean isOrderPreserved() {
            return (boolean)InvokeDynamicSupport.bootstrap("isOrderPreserved", $$robo$$android_widget_GridLayout_Axis$isOrderPreserved(), 0, this);
        }

        public void setOrderPreserved(boolean bl) {
            InvokeDynamicSupport.bootstrap("setOrderPreserved", $$robo$$android_widget_GridLayout_Axis$setOrderPreserved(boolean ), 0, this, bl);
        }

        private PackedMap<Spec, Bounds> createGroupBounds() {
            return InvokeDynamicSupport.bootstrap("createGroupBounds", $$robo$$android_widget_GridLayout_Axis$createGroupBounds(), 0, this);
        }

        private void computeGroupBounds() {
            InvokeDynamicSupport.bootstrap("computeGroupBounds", $$robo$$android_widget_GridLayout_Axis$computeGroupBounds(), 0, this);
        }

        public PackedMap<Spec, Bounds> getGroupBounds() {
            return InvokeDynamicSupport.bootstrap("getGroupBounds", $$robo$$android_widget_GridLayout_Axis$getGroupBounds(), 0, this);
        }

        private PackedMap<Interval, MutableInt> createLinks(boolean bl) {
            return InvokeDynamicSupport.bootstrap("createLinks", $$robo$$android_widget_GridLayout_Axis$createLinks(boolean ), 0, this, bl);
        }

        private void computeLinks(PackedMap<Interval, MutableInt> packedMap, boolean bl) {
            InvokeDynamicSupport.bootstrap("computeLinks", $$robo$$android_widget_GridLayout_Axis$computeLinks(android.widget.GridLayout$PackedMap<android.widget.GridLayout$Interval, android.widget.GridLayout$MutableInt> boolean ), 0, this, packedMap, bl);
        }

        private PackedMap<Interval, MutableInt> getForwardLinks() {
            return InvokeDynamicSupport.bootstrap("getForwardLinks", $$robo$$android_widget_GridLayout_Axis$getForwardLinks(), 0, this);
        }

        private PackedMap<Interval, MutableInt> getBackwardLinks() {
            return InvokeDynamicSupport.bootstrap("getBackwardLinks", $$robo$$android_widget_GridLayout_Axis$getBackwardLinks(), 0, this);
        }

        private void include(List<Arc> list, Interval interval, MutableInt mutableInt, boolean bl) {
            InvokeDynamicSupport.bootstrap("include", $$robo$$android_widget_GridLayout_Axis$include(java.util.List<android.widget.GridLayout$Arc> android.widget.GridLayout$Interval android.widget.GridLayout$MutableInt boolean ), 0, this, list, interval, mutableInt, bl);
        }

        private void include(List<Arc> list, Interval interval, MutableInt mutableInt) {
            InvokeDynamicSupport.bootstrap("include", $$robo$$android_widget_GridLayout_Axis$include(java.util.List<android.widget.GridLayout$Arc> android.widget.GridLayout$Interval android.widget.GridLayout$MutableInt ), 0, this, list, interval, mutableInt);
        }

        Arc[][] groupArcsByFirstVertex(Arc[] arcArray) {
            return InvokeDynamicSupport.bootstrap("groupArcsByFirstVertex", $$robo$$android_widget_GridLayout_Axis$groupArcsByFirstVertex(android.widget.GridLayout$Arc[] ), 0, this, arcArray);
        }

        private Arc[] topologicalSort(Arc[] arcArray) {
            return InvokeDynamicSupport.bootstrap("topologicalSort", $$robo$$android_widget_GridLayout_Axis$topologicalSort(android.widget.GridLayout$Arc[] ), 0, this, arcArray);
        }

        private Arc[] topologicalSort(List<Arc> list) {
            return InvokeDynamicSupport.bootstrap("topologicalSort", $$robo$$android_widget_GridLayout_Axis$topologicalSort(java.util.List<android.widget.GridLayout$Arc> ), 0, this, list);
        }

        private void addComponentSizes(List<Arc> list, PackedMap<Interval, MutableInt> packedMap) {
            InvokeDynamicSupport.bootstrap("addComponentSizes", $$robo$$android_widget_GridLayout_Axis$addComponentSizes(java.util.List<android.widget.GridLayout$Arc> android.widget.GridLayout$PackedMap<android.widget.GridLayout$Interval, android.widget.GridLayout$MutableInt> ), 0, this, list, packedMap);
        }

        private Arc[] createArcs() {
            return InvokeDynamicSupport.bootstrap("createArcs", $$robo$$android_widget_GridLayout_Axis$createArcs(), 0, this);
        }

        private void computeArcs() {
            InvokeDynamicSupport.bootstrap("computeArcs", $$robo$$android_widget_GridLayout_Axis$computeArcs(), 0, this);
        }

        public Arc[] getArcs() {
            return InvokeDynamicSupport.bootstrap("getArcs", $$robo$$android_widget_GridLayout_Axis$getArcs(), 0, this);
        }

        private boolean relax(int[] nArray, Arc arc) {
            return (boolean)InvokeDynamicSupport.bootstrap("relax", $$robo$$android_widget_GridLayout_Axis$relax(int[] android.widget.GridLayout$Arc ), 0, this, nArray, arc);
        }

        private void init(int[] nArray) {
            InvokeDynamicSupport.bootstrap("init", $$robo$$android_widget_GridLayout_Axis$init(int[] ), 0, this, nArray);
        }

        private String arcsToString(List<Arc> list) {
            return InvokeDynamicSupport.bootstrap("arcsToString", $$robo$$android_widget_GridLayout_Axis$arcsToString(java.util.List<android.widget.GridLayout$Arc> ), 0, this, list);
        }

        private void logError(String string2, Arc[] arcArray, boolean[] blArray) {
            InvokeDynamicSupport.bootstrap("logError", $$robo$$android_widget_GridLayout_Axis$logError(java.lang.String android.widget.GridLayout$Arc[] boolean[] ), 0, this, string2, arcArray, blArray);
        }

        private boolean solve(Arc[] arcArray, int[] nArray) {
            return (boolean)InvokeDynamicSupport.bootstrap("solve", $$robo$$android_widget_GridLayout_Axis$solve(android.widget.GridLayout$Arc[] int[] ), 0, this, arcArray, nArray);
        }

        private boolean solve(Arc[] arcArray, int[] nArray, boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("solve", $$robo$$android_widget_GridLayout_Axis$solve(android.widget.GridLayout$Arc[] int[] boolean ), 0, this, arcArray, nArray, bl);
        }

        private void computeMargins(boolean bl) {
            InvokeDynamicSupport.bootstrap("computeMargins", $$robo$$android_widget_GridLayout_Axis$computeMargins(boolean ), 0, this, bl);
        }

        public int[] getLeadingMargins() {
            return InvokeDynamicSupport.bootstrap("getLeadingMargins", $$robo$$android_widget_GridLayout_Axis$getLeadingMargins(), 0, this);
        }

        public int[] getTrailingMargins() {
            return InvokeDynamicSupport.bootstrap("getTrailingMargins", $$robo$$android_widget_GridLayout_Axis$getTrailingMargins(), 0, this);
        }

        private boolean solve(int[] nArray) {
            return (boolean)InvokeDynamicSupport.bootstrap("solve", $$robo$$android_widget_GridLayout_Axis$solve(int[] ), 0, this, nArray);
        }

        private boolean computeHasWeights() {
            return (boolean)InvokeDynamicSupport.bootstrap("computeHasWeights", $$robo$$android_widget_GridLayout_Axis$computeHasWeights(), 0, this);
        }

        private boolean hasWeights() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasWeights", $$robo$$android_widget_GridLayout_Axis$hasWeights(), 0, this);
        }

        public int[] getDeltas() {
            return InvokeDynamicSupport.bootstrap("getDeltas", $$robo$$android_widget_GridLayout_Axis$getDeltas(), 0, this);
        }

        private void shareOutDelta(int n, float f) {
            InvokeDynamicSupport.bootstrap("shareOutDelta", $$robo$$android_widget_GridLayout_Axis$shareOutDelta(int float ), 0, this, n, f);
        }

        private void solveAndDistributeSpace(int[] nArray) {
            InvokeDynamicSupport.bootstrap("solveAndDistributeSpace", $$robo$$android_widget_GridLayout_Axis$solveAndDistributeSpace(int[] ), 0, this, nArray);
        }

        private float calculateTotalWeight() {
            return (float)InvokeDynamicSupport.bootstrap("calculateTotalWeight", $$robo$$android_widget_GridLayout_Axis$calculateTotalWeight(), 0, this);
        }

        private void computeLocations(int[] nArray) {
            InvokeDynamicSupport.bootstrap("computeLocations", $$robo$$android_widget_GridLayout_Axis$computeLocations(int[] ), 0, this, nArray);
        }

        public int[] getLocations() {
            return InvokeDynamicSupport.bootstrap("getLocations", $$robo$$android_widget_GridLayout_Axis$getLocations(), 0, this);
        }

        private int size(int[] nArray) {
            return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_widget_GridLayout_Axis$size(int[] ), 0, this, nArray);
        }

        private void setParentConstraints(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setParentConstraints", $$robo$$android_widget_GridLayout_Axis$setParentConstraints(int int ), 0, this, n, n2);
        }

        private int getMeasure(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("getMeasure", $$robo$$android_widget_GridLayout_Axis$getMeasure(int int ), 0, this, n, n2);
        }

        public int getMeasure(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getMeasure", $$robo$$android_widget_GridLayout_Axis$getMeasure(int ), 0, this, n);
        }

        public void layout(int n) {
            InvokeDynamicSupport.bootstrap("layout", $$robo$$android_widget_GridLayout_Axis$layout(int ), 0, this, n);
        }

        public void invalidateStructure() {
            InvokeDynamicSupport.bootstrap("invalidateStructure", $$robo$$android_widget_GridLayout_Axis$invalidateStructure(), 0, this);
        }

        public void invalidateValues() {
            InvokeDynamicSupport.bootstrap("invalidateValues", $$robo$$android_widget_GridLayout_Axis$invalidateValues(), 0, this);
        }

        private /* synthetic */ void __constructor__(GridLayout gridLayout, boolean bl, android.widget.GridLayout$1 var3_3) {
            this.$$robo$$android_widget_GridLayout_Axis$__constructor__(gridLayout, bl, var3_3);
        }

        static {
            RobolectricInternals.classInitializing(Axis.class);
        }

        public /* synthetic */ Axis() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Axis)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AlignmentMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Orientation {
    }
}

