/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.FloatProperty;
import android.util.MathUtils;
import android.util.Pools;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewHierarchyEncoder;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.AlphaAnimation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.Transformation;
import android.widget.RemoteViews;
import com.android.internal.R;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@RemoteViews.RemoteView
public class ProgressBar
extends View
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int MAX_LEVEL = 10000;
    private static int TIMEOUT_SEND_ACCESSIBILITY_EVENT = 200;
    private static DecelerateInterpolator PROGRESS_ANIM_INTERPOLATOR;
    private static int PROGRESS_ANIM_DURATION = 80;
    int mMinWidth;
    int mMaxWidth;
    int mMinHeight;
    int mMaxHeight;
    private int mProgress;
    private int mSecondaryProgress;
    private int mMin;
    private boolean mMinInitialized;
    private int mMax;
    private boolean mMaxInitialized;
    private int mBehavior;
    private int mDuration;
    private boolean mIndeterminate;
    private boolean mOnlyIndeterminate;
    private Transformation mTransformation;
    private AlphaAnimation mAnimation;
    private boolean mHasAnimation;
    private Drawable mIndeterminateDrawable;
    private Drawable mProgressDrawable;
    private Drawable mCurrentDrawable;
    private ProgressTintInfo mProgressTintInfo;
    int mSampleWidth;
    private boolean mNoInvalidate;
    private Interpolator mInterpolator;
    private RefreshProgressRunnable mRefreshProgressRunnable;
    private long mUiThreadId;
    private boolean mShouldStartAnimationDrawable;
    private boolean mInDrawing;
    private boolean mAttached;
    private boolean mRefreshIsPosted;
    private float mVisualProgress;
    boolean mMirrorForRtl;
    private boolean mAggregatedIsVisible;
    private ArrayList<RefreshData> mRefreshData;
    private AccessibilityEventSender mAccessibilityEventSender;
    private FloatProperty<ProgressBar> VISUAL_PROGRESS;

    private void $$robo$$android_widget_ProgressBar$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_ProgressBar$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_ProgressBar$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_ProgressBar$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mSampleWidth = 0;
        this.mMirrorForRtl = false;
        this.mRefreshData = new ArrayList();
        this.VISUAL_PROGRESS = new FloatProperty<ProgressBar>(this, "visual_progress"){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ProgressBar this$0;

            private void $$robo$$android_widget_ProgressBar_1$__constructor__(ProgressBar this$0, String x0) {
            }

            private final void $$robo$$android_widget_ProgressBar_1$setValue(ProgressBar object, float value) {
                object.setVisualProgress(16908301, value);
                object.mVisualProgress = value;
            }

            private final Float $$robo$$android_widget_ProgressBar_1$get(ProgressBar object) {
                return Float.valueOf(object.mVisualProgress);
            }

            private void __constructor__(ProgressBar progressBar, String string2) {
                this.$$robo$$android_widget_ProgressBar_1$__constructor__(progressBar, string2);
            }
            {
                this.this$0 = progressBar;
                super(string2);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ProgressBar_1$__constructor__(android.widget.ProgressBar java.lang.String ), 0, this, progressBar, string2);
            }

            @Override
            public void setValue(ProgressBar progressBar, float f) {
                InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_widget_ProgressBar_1$setValue(android.widget.ProgressBar float ), 0, this, progressBar, f);
            }

            @Override
            public Float get(ProgressBar progressBar) {
                return InvokeDynamicSupport.bootstrap("get", $$robo$$android_widget_ProgressBar_1$get(android.widget.ProgressBar ), 0, this, progressBar);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mUiThreadId = Thread.currentThread().getId();
        this.initProgressBar();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ProgressBar, defStyleAttr, defStyleRes);
        this.mNoInvalidate = true;
        Drawable progressDrawable = a.getDrawable(8);
        if (progressDrawable != null) {
            if (ProgressBar.needsTileify(progressDrawable)) {
                this.setProgressDrawableTiled(progressDrawable);
            } else {
                this.setProgressDrawable(progressDrawable);
            }
        }
        this.mDuration = a.getInt(9, this.mDuration);
        this.mMinWidth = a.getDimensionPixelSize(11, this.mMinWidth);
        this.mMaxWidth = a.getDimensionPixelSize(0, this.mMaxWidth);
        this.mMinHeight = a.getDimensionPixelSize(12, this.mMinHeight);
        this.mMaxHeight = a.getDimensionPixelSize(1, this.mMaxHeight);
        this.mBehavior = a.getInt(10, this.mBehavior);
        int resID = a.getResourceId(13, 17432587);
        if (resID > 0) {
            this.setInterpolator(context, resID);
        }
        this.setMin(a.getInt(26, this.mMin));
        this.setMax(a.getInt(2, this.mMax));
        this.setProgress(a.getInt(3, this.mProgress));
        this.setSecondaryProgress(a.getInt(4, this.mSecondaryProgress));
        Drawable indeterminateDrawable = a.getDrawable(7);
        if (indeterminateDrawable != null) {
            if (ProgressBar.needsTileify(indeterminateDrawable)) {
                this.setIndeterminateDrawableTiled(indeterminateDrawable);
            } else {
                this.setIndeterminateDrawable(indeterminateDrawable);
            }
        }
        this.mOnlyIndeterminate = a.getBoolean(6, this.mOnlyIndeterminate);
        this.mNoInvalidate = false;
        this.setIndeterminate(this.mOnlyIndeterminate || a.getBoolean(5, this.mIndeterminate));
        this.mMirrorForRtl = a.getBoolean(15, this.mMirrorForRtl);
        if (a.hasValue(17)) {
            if (this.mProgressTintInfo == null) {
                this.mProgressTintInfo = new ProgressTintInfo();
            }
            this.mProgressTintInfo.mProgressTintMode = Drawable.parseTintMode(a.getInt(17, -1), null);
            this.mProgressTintInfo.mHasProgressTintMode = true;
        }
        if (a.hasValue(16)) {
            if (this.mProgressTintInfo == null) {
                this.mProgressTintInfo = new ProgressTintInfo();
            }
            this.mProgressTintInfo.mProgressTintList = a.getColorStateList(16);
            this.mProgressTintInfo.mHasProgressTint = true;
        }
        if (a.hasValue(19)) {
            if (this.mProgressTintInfo == null) {
                this.mProgressTintInfo = new ProgressTintInfo();
            }
            this.mProgressTintInfo.mProgressBackgroundTintMode = Drawable.parseTintMode(a.getInt(19, -1), null);
            this.mProgressTintInfo.mHasProgressBackgroundTintMode = true;
        }
        if (a.hasValue(18)) {
            if (this.mProgressTintInfo == null) {
                this.mProgressTintInfo = new ProgressTintInfo();
            }
            this.mProgressTintInfo.mProgressBackgroundTintList = a.getColorStateList(18);
            this.mProgressTintInfo.mHasProgressBackgroundTint = true;
        }
        if (a.hasValue(21)) {
            if (this.mProgressTintInfo == null) {
                this.mProgressTintInfo = new ProgressTintInfo();
            }
            this.mProgressTintInfo.mSecondaryProgressTintMode = Drawable.parseTintMode(a.getInt(21, -1), null);
            this.mProgressTintInfo.mHasSecondaryProgressTintMode = true;
        }
        if (a.hasValue(20)) {
            if (this.mProgressTintInfo == null) {
                this.mProgressTintInfo = new ProgressTintInfo();
            }
            this.mProgressTintInfo.mSecondaryProgressTintList = a.getColorStateList(20);
            this.mProgressTintInfo.mHasSecondaryProgressTint = true;
        }
        if (a.hasValue(23)) {
            if (this.mProgressTintInfo == null) {
                this.mProgressTintInfo = new ProgressTintInfo();
            }
            this.mProgressTintInfo.mIndeterminateTintMode = Drawable.parseTintMode(a.getInt(23, -1), null);
            this.mProgressTintInfo.mHasIndeterminateTintMode = true;
        }
        if (a.hasValue(22)) {
            if (this.mProgressTintInfo == null) {
                this.mProgressTintInfo = new ProgressTintInfo();
            }
            this.mProgressTintInfo.mIndeterminateTintList = a.getColorStateList(22);
            this.mProgressTintInfo.mHasIndeterminateTint = true;
        }
        a.recycle();
        this.applyProgressTints();
        this.applyIndeterminateTint();
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
    }

    private static final boolean $$robo$$android_widget_ProgressBar$needsTileify(Drawable dr) {
        if (dr instanceof LayerDrawable) {
            LayerDrawable orig = (LayerDrawable)dr;
            int N = orig.getNumberOfLayers();
            for (int i = 0; i < N; ++i) {
                if (!ProgressBar.needsTileify(orig.getDrawable(i))) continue;
                return true;
            }
            return false;
        }
        if (dr instanceof StateListDrawable) {
            StateListDrawable in = (StateListDrawable)dr;
            int N = in.getStateCount();
            for (int i = 0; i < N; ++i) {
                if (!ProgressBar.needsTileify(in.getStateDrawable(i))) continue;
                return true;
            }
            return false;
        }
        return dr instanceof BitmapDrawable;
    }

    private final Drawable $$robo$$android_widget_ProgressBar$tileify(Drawable drawable2, boolean clip) {
        if (drawable2 instanceof LayerDrawable) {
            LayerDrawable orig = (LayerDrawable)drawable2;
            int N = orig.getNumberOfLayers();
            Drawable[] outDrawables = new Drawable[N];
            for (int i = 0; i < N; ++i) {
                int id2 = orig.getId(i);
                outDrawables[i] = this.tileify(orig.getDrawable(i), id2 == 16908301 || id2 == 16908303);
            }
            LayerDrawable clone = new LayerDrawable(outDrawables);
            for (int i = 0; i < N; ++i) {
                clone.setId(i, orig.getId(i));
                clone.setLayerGravity(i, orig.getLayerGravity(i));
                clone.setLayerWidth(i, orig.getLayerWidth(i));
                clone.setLayerHeight(i, orig.getLayerHeight(i));
                clone.setLayerInsetLeft(i, orig.getLayerInsetLeft(i));
                clone.setLayerInsetRight(i, orig.getLayerInsetRight(i));
                clone.setLayerInsetTop(i, orig.getLayerInsetTop(i));
                clone.setLayerInsetBottom(i, orig.getLayerInsetBottom(i));
                clone.setLayerInsetStart(i, orig.getLayerInsetStart(i));
                clone.setLayerInsetEnd(i, orig.getLayerInsetEnd(i));
            }
            return clone;
        }
        if (drawable2 instanceof StateListDrawable) {
            StateListDrawable in = (StateListDrawable)drawable2;
            StateListDrawable out = new StateListDrawable();
            int N = in.getStateCount();
            for (int i = 0; i < N; ++i) {
                out.addState(in.getStateSet(i), this.tileify(in.getStateDrawable(i), clip));
            }
            return out;
        }
        if (drawable2 instanceof BitmapDrawable) {
            Drawable.ConstantState cs = drawable2.getConstantState();
            BitmapDrawable clone = (BitmapDrawable)cs.newDrawable(this.getResources());
            clone.setTileModeXY(Shader.TileMode.REPEAT, Shader.TileMode.CLAMP);
            if (this.mSampleWidth <= 0) {
                this.mSampleWidth = clone.getIntrinsicWidth();
            }
            if (clip) {
                return new ClipDrawable(clone, 3, 1);
            }
            return clone;
        }
        return drawable2;
    }

    private final Shape $$robo$$android_widget_ProgressBar$getDrawableShape() {
        float[] roundedCorners = new float[]{5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f};
        return new RoundRectShape(roundedCorners, null, null);
    }

    private final Drawable $$robo$$android_widget_ProgressBar$tileifyIndeterminate(Drawable drawable2) {
        if (drawable2 instanceof AnimationDrawable) {
            AnimationDrawable background = (AnimationDrawable)drawable2;
            int N = background.getNumberOfFrames();
            AnimationDrawable newBg = new AnimationDrawable();
            newBg.setOneShot(background.isOneShot());
            for (int i = 0; i < N; ++i) {
                Drawable frame = this.tileify(background.getFrame(i), true);
                frame.setLevel(10000);
                newBg.addFrame(frame, background.getDuration(i));
            }
            newBg.setLevel(10000);
            drawable2 = newBg;
        }
        return drawable2;
    }

    private final void $$robo$$android_widget_ProgressBar$initProgressBar() {
        this.mMin = 0;
        this.mMax = 100;
        this.mProgress = 0;
        this.mSecondaryProgress = 0;
        this.mIndeterminate = false;
        this.mOnlyIndeterminate = false;
        this.mDuration = 4000;
        this.mBehavior = 1;
        this.mMinWidth = 24;
        this.mMaxWidth = 48;
        this.mMinHeight = 24;
        this.mMaxHeight = 48;
    }

    @ViewDebug.ExportedProperty(category="progress")
    private final synchronized boolean $$robo$$android_widget_ProgressBar$isIndeterminate() {
        return this.mIndeterminate;
    }

    @RemotableViewMethod
    private final synchronized void $$robo$$android_widget_ProgressBar$setIndeterminate(boolean indeterminate) {
        if (!(this.mOnlyIndeterminate && this.mIndeterminate || indeterminate == this.mIndeterminate)) {
            this.mIndeterminate = indeterminate;
            if (indeterminate) {
                this.swapCurrentDrawable(this.mIndeterminateDrawable);
                this.startAnimation();
            } else {
                this.swapCurrentDrawable(this.mProgressDrawable);
                this.stopAnimation();
            }
        }
    }

    private final void $$robo$$android_widget_ProgressBar$swapCurrentDrawable(Drawable newDrawable) {
        Drawable oldDrawable = this.mCurrentDrawable;
        this.mCurrentDrawable = newDrawable;
        if (oldDrawable != this.mCurrentDrawable) {
            if (oldDrawable != null) {
                oldDrawable.setVisible(false, false);
            }
            if (this.mCurrentDrawable != null) {
                this.mCurrentDrawable.setVisible(this.getWindowVisibility() == 0 && this.isShown(), false);
            }
        }
    }

    private final Drawable $$robo$$android_widget_ProgressBar$getIndeterminateDrawable() {
        return this.mIndeterminateDrawable;
    }

    private final void $$robo$$android_widget_ProgressBar$setIndeterminateDrawable(Drawable d) {
        if (this.mIndeterminateDrawable != d) {
            if (this.mIndeterminateDrawable != null) {
                this.mIndeterminateDrawable.setCallback(null);
                this.unscheduleDrawable(this.mIndeterminateDrawable);
            }
            this.mIndeterminateDrawable = d;
            if (d != null) {
                d.setCallback(this);
                d.setLayoutDirection(this.getLayoutDirection());
                if (d.isStateful()) {
                    d.setState(this.getDrawableState());
                }
                this.applyIndeterminateTint();
            }
            if (this.mIndeterminate) {
                this.swapCurrentDrawable(d);
                this.postInvalidate();
            }
        }
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_ProgressBar$setIndeterminateTintList(ColorStateList tint) {
        if (this.mProgressTintInfo == null) {
            this.mProgressTintInfo = new ProgressTintInfo();
        }
        this.mProgressTintInfo.mIndeterminateTintList = tint;
        this.mProgressTintInfo.mHasIndeterminateTint = true;
        this.applyIndeterminateTint();
    }

    private final ColorStateList $$robo$$android_widget_ProgressBar$getIndeterminateTintList() {
        return this.mProgressTintInfo != null ? this.mProgressTintInfo.mIndeterminateTintList : null;
    }

    private final void $$robo$$android_widget_ProgressBar$setIndeterminateTintMode(PorterDuff.Mode tintMode) {
        if (this.mProgressTintInfo == null) {
            this.mProgressTintInfo = new ProgressTintInfo();
        }
        this.mProgressTintInfo.mIndeterminateTintMode = tintMode;
        this.mProgressTintInfo.mHasIndeterminateTintMode = true;
        this.applyIndeterminateTint();
    }

    private final PorterDuff.Mode $$robo$$android_widget_ProgressBar$getIndeterminateTintMode() {
        return this.mProgressTintInfo != null ? this.mProgressTintInfo.mIndeterminateTintMode : null;
    }

    private final void $$robo$$android_widget_ProgressBar$applyIndeterminateTint() {
        if (this.mIndeterminateDrawable != null && this.mProgressTintInfo != null) {
            ProgressTintInfo tintInfo = this.mProgressTintInfo;
            if (tintInfo.mHasIndeterminateTint || tintInfo.mHasIndeterminateTintMode) {
                this.mIndeterminateDrawable = this.mIndeterminateDrawable.mutate();
                if (tintInfo.mHasIndeterminateTint) {
                    this.mIndeterminateDrawable.setTintList(tintInfo.mIndeterminateTintList);
                }
                if (tintInfo.mHasIndeterminateTintMode) {
                    this.mIndeterminateDrawable.setTintMode(tintInfo.mIndeterminateTintMode);
                }
                if (this.mIndeterminateDrawable.isStateful()) {
                    this.mIndeterminateDrawable.setState(this.getDrawableState());
                }
            }
        }
    }

    private final void $$robo$$android_widget_ProgressBar$setIndeterminateDrawableTiled(Drawable d) {
        if (d != null) {
            d = this.tileifyIndeterminate(d);
        }
        this.setIndeterminateDrawable(d);
    }

    private final Drawable $$robo$$android_widget_ProgressBar$getProgressDrawable() {
        return this.mProgressDrawable;
    }

    private final void $$robo$$android_widget_ProgressBar$setProgressDrawable(Drawable d) {
        if (this.mProgressDrawable != d) {
            if (this.mProgressDrawable != null) {
                this.mProgressDrawable.setCallback(null);
                this.unscheduleDrawable(this.mProgressDrawable);
            }
            this.mProgressDrawable = d;
            if (d != null) {
                int drawableHeight;
                d.setCallback(this);
                d.setLayoutDirection(this.getLayoutDirection());
                if (d.isStateful()) {
                    d.setState(this.getDrawableState());
                }
                if (this.mMaxHeight < (drawableHeight = d.getMinimumHeight())) {
                    this.mMaxHeight = drawableHeight;
                    this.requestLayout();
                }
                this.applyProgressTints();
            }
            if (!this.mIndeterminate) {
                this.swapCurrentDrawable(d);
                this.postInvalidate();
            }
            this.updateDrawableBounds(this.getWidth(), this.getHeight());
            this.updateDrawableState();
            this.doRefreshProgress(16908301, this.mProgress, false, false, false);
            this.doRefreshProgress(16908303, this.mSecondaryProgress, false, false, false);
        }
    }

    private final boolean $$robo$$android_widget_ProgressBar$getMirrorForRtl() {
        return this.mMirrorForRtl;
    }

    private final void $$robo$$android_widget_ProgressBar$applyProgressTints() {
        if (this.mProgressDrawable != null && this.mProgressTintInfo != null) {
            this.applyPrimaryProgressTint();
            this.applyProgressBackgroundTint();
            this.applySecondaryProgressTint();
        }
    }

    private final void $$robo$$android_widget_ProgressBar$applyPrimaryProgressTint() {
        Drawable target;
        if ((this.mProgressTintInfo.mHasProgressTint || this.mProgressTintInfo.mHasProgressTintMode) && (target = this.getTintTarget(16908301, true)) != null) {
            if (this.mProgressTintInfo.mHasProgressTint) {
                target.setTintList(this.mProgressTintInfo.mProgressTintList);
            }
            if (this.mProgressTintInfo.mHasProgressTintMode) {
                target.setTintMode(this.mProgressTintInfo.mProgressTintMode);
            }
            if (target.isStateful()) {
                target.setState(this.getDrawableState());
            }
        }
    }

    private final void $$robo$$android_widget_ProgressBar$applyProgressBackgroundTint() {
        Drawable target;
        if ((this.mProgressTintInfo.mHasProgressBackgroundTint || this.mProgressTintInfo.mHasProgressBackgroundTintMode) && (target = this.getTintTarget(0x1020000, false)) != null) {
            if (this.mProgressTintInfo.mHasProgressBackgroundTint) {
                target.setTintList(this.mProgressTintInfo.mProgressBackgroundTintList);
            }
            if (this.mProgressTintInfo.mHasProgressBackgroundTintMode) {
                target.setTintMode(this.mProgressTintInfo.mProgressBackgroundTintMode);
            }
            if (target.isStateful()) {
                target.setState(this.getDrawableState());
            }
        }
    }

    private final void $$robo$$android_widget_ProgressBar$applySecondaryProgressTint() {
        Drawable target;
        if ((this.mProgressTintInfo.mHasSecondaryProgressTint || this.mProgressTintInfo.mHasSecondaryProgressTintMode) && (target = this.getTintTarget(16908303, false)) != null) {
            if (this.mProgressTintInfo.mHasSecondaryProgressTint) {
                target.setTintList(this.mProgressTintInfo.mSecondaryProgressTintList);
            }
            if (this.mProgressTintInfo.mHasSecondaryProgressTintMode) {
                target.setTintMode(this.mProgressTintInfo.mSecondaryProgressTintMode);
            }
            if (target.isStateful()) {
                target.setState(this.getDrawableState());
            }
        }
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_ProgressBar$setProgressTintList(ColorStateList tint) {
        if (this.mProgressTintInfo == null) {
            this.mProgressTintInfo = new ProgressTintInfo();
        }
        this.mProgressTintInfo.mProgressTintList = tint;
        this.mProgressTintInfo.mHasProgressTint = true;
        if (this.mProgressDrawable != null) {
            this.applyPrimaryProgressTint();
        }
    }

    private final ColorStateList $$robo$$android_widget_ProgressBar$getProgressTintList() {
        return this.mProgressTintInfo != null ? this.mProgressTintInfo.mProgressTintList : null;
    }

    private final void $$robo$$android_widget_ProgressBar$setProgressTintMode(PorterDuff.Mode tintMode) {
        if (this.mProgressTintInfo == null) {
            this.mProgressTintInfo = new ProgressTintInfo();
        }
        this.mProgressTintInfo.mProgressTintMode = tintMode;
        this.mProgressTintInfo.mHasProgressTintMode = true;
        if (this.mProgressDrawable != null) {
            this.applyPrimaryProgressTint();
        }
    }

    private final PorterDuff.Mode $$robo$$android_widget_ProgressBar$getProgressTintMode() {
        return this.mProgressTintInfo != null ? this.mProgressTintInfo.mProgressTintMode : null;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_ProgressBar$setProgressBackgroundTintList(ColorStateList tint) {
        if (this.mProgressTintInfo == null) {
            this.mProgressTintInfo = new ProgressTintInfo();
        }
        this.mProgressTintInfo.mProgressBackgroundTintList = tint;
        this.mProgressTintInfo.mHasProgressBackgroundTint = true;
        if (this.mProgressDrawable != null) {
            this.applyProgressBackgroundTint();
        }
    }

    private final ColorStateList $$robo$$android_widget_ProgressBar$getProgressBackgroundTintList() {
        return this.mProgressTintInfo != null ? this.mProgressTintInfo.mProgressBackgroundTintList : null;
    }

    private final void $$robo$$android_widget_ProgressBar$setProgressBackgroundTintMode(PorterDuff.Mode tintMode) {
        if (this.mProgressTintInfo == null) {
            this.mProgressTintInfo = new ProgressTintInfo();
        }
        this.mProgressTintInfo.mProgressBackgroundTintMode = tintMode;
        this.mProgressTintInfo.mHasProgressBackgroundTintMode = true;
        if (this.mProgressDrawable != null) {
            this.applyProgressBackgroundTint();
        }
    }

    private final PorterDuff.Mode $$robo$$android_widget_ProgressBar$getProgressBackgroundTintMode() {
        return this.mProgressTintInfo != null ? this.mProgressTintInfo.mProgressBackgroundTintMode : null;
    }

    private final void $$robo$$android_widget_ProgressBar$setSecondaryProgressTintList(ColorStateList tint) {
        if (this.mProgressTintInfo == null) {
            this.mProgressTintInfo = new ProgressTintInfo();
        }
        this.mProgressTintInfo.mSecondaryProgressTintList = tint;
        this.mProgressTintInfo.mHasSecondaryProgressTint = true;
        if (this.mProgressDrawable != null) {
            this.applySecondaryProgressTint();
        }
    }

    private final ColorStateList $$robo$$android_widget_ProgressBar$getSecondaryProgressTintList() {
        return this.mProgressTintInfo != null ? this.mProgressTintInfo.mSecondaryProgressTintList : null;
    }

    private final void $$robo$$android_widget_ProgressBar$setSecondaryProgressTintMode(PorterDuff.Mode tintMode) {
        if (this.mProgressTintInfo == null) {
            this.mProgressTintInfo = new ProgressTintInfo();
        }
        this.mProgressTintInfo.mSecondaryProgressTintMode = tintMode;
        this.mProgressTintInfo.mHasSecondaryProgressTintMode = true;
        if (this.mProgressDrawable != null) {
            this.applySecondaryProgressTint();
        }
    }

    private final PorterDuff.Mode $$robo$$android_widget_ProgressBar$getSecondaryProgressTintMode() {
        return this.mProgressTintInfo != null ? this.mProgressTintInfo.mSecondaryProgressTintMode : null;
    }

    private final Drawable $$robo$$android_widget_ProgressBar$getTintTarget(int layerId, boolean shouldFallback) {
        Drawable layer = null;
        Drawable d = this.mProgressDrawable;
        if (d != null) {
            this.mProgressDrawable = d.mutate();
            if (d instanceof LayerDrawable) {
                layer = ((LayerDrawable)d).findDrawableByLayerId(layerId);
            }
            if (shouldFallback && layer == null) {
                layer = d;
            }
        }
        return layer;
    }

    private final void $$robo$$android_widget_ProgressBar$setProgressDrawableTiled(Drawable d) {
        if (d != null) {
            d = this.tileify(d, false);
        }
        this.setProgressDrawable(d);
    }

    private final Drawable $$robo$$android_widget_ProgressBar$getCurrentDrawable() {
        return this.mCurrentDrawable;
    }

    private final boolean $$robo$$android_widget_ProgressBar$verifyDrawable(Drawable who) {
        return who == this.mProgressDrawable || who == this.mIndeterminateDrawable || super.verifyDrawable(who);
    }

    private final void $$robo$$android_widget_ProgressBar$jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.jumpToCurrentState();
        }
        if (this.mIndeterminateDrawable != null) {
            this.mIndeterminateDrawable.jumpToCurrentState();
        }
    }

    private final void $$robo$$android_widget_ProgressBar$onResolveDrawables(int layoutDirection) {
        Drawable d = this.mCurrentDrawable;
        if (d != null) {
            d.setLayoutDirection(layoutDirection);
        }
        if (this.mIndeterminateDrawable != null) {
            this.mIndeterminateDrawable.setLayoutDirection(layoutDirection);
        }
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.setLayoutDirection(layoutDirection);
        }
    }

    private final void $$robo$$android_widget_ProgressBar$postInvalidate() {
        if (!this.mNoInvalidate) {
            super.postInvalidate();
        }
    }

    private final synchronized void $$robo$$android_widget_ProgressBar$doRefreshProgress(int id2, int progress, boolean fromUser, boolean callBackToApp, boolean animate) {
        boolean isPrimary;
        int range = this.mMax - this.mMin;
        float scale = range > 0 ? (float)(progress - this.mMin) / (float)range : 0.0f;
        boolean bl = isPrimary = id2 == 16908301;
        if (isPrimary && animate) {
            ObjectAnimator animator2 = ObjectAnimator.ofFloat(this, this.VISUAL_PROGRESS, scale);
            animator2.setAutoCancel(true);
            animator2.setDuration(80L);
            animator2.setInterpolator(PROGRESS_ANIM_INTERPOLATOR);
            animator2.start();
        } else {
            this.setVisualProgress(id2, scale);
        }
        if (isPrimary && callBackToApp) {
            this.onProgressRefresh(scale, fromUser, progress);
        }
    }

    private final void $$robo$$android_widget_ProgressBar$onProgressRefresh(float scale, boolean fromUser, int progress) {
        if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            this.scheduleAccessibilityEventSender();
        }
    }

    private final void $$robo$$android_widget_ProgressBar$setVisualProgress(int id2, float progress) {
        this.mVisualProgress = progress;
        Drawable d = this.mCurrentDrawable;
        if (d instanceof LayerDrawable && (d = ((LayerDrawable)d).findDrawableByLayerId(id2)) == null) {
            d = this.mCurrentDrawable;
        }
        if (d != null) {
            int level = (int)(progress * 10000.0f);
            d.setLevel(level);
        } else {
            this.invalidate();
        }
        this.onVisualProgressChanged(id2, progress);
    }

    private final void $$robo$$android_widget_ProgressBar$onVisualProgressChanged(int id2, float progress) {
    }

    private final synchronized void $$robo$$android_widget_ProgressBar$refreshProgress(int id2, int progress, boolean fromUser, boolean animate) {
        if (this.mUiThreadId == Thread.currentThread().getId()) {
            this.doRefreshProgress(id2, progress, fromUser, true, animate);
        } else {
            if (this.mRefreshProgressRunnable == null) {
                this.mRefreshProgressRunnable = new RefreshProgressRunnable(this);
            }
            RefreshData rd = RefreshData.obtain(id2, progress, fromUser, animate);
            this.mRefreshData.add(rd);
            if (this.mAttached && !this.mRefreshIsPosted) {
                this.post(this.mRefreshProgressRunnable);
                this.mRefreshIsPosted = true;
            }
        }
    }

    @RemotableViewMethod
    private final synchronized void $$robo$$android_widget_ProgressBar$setProgress(int progress) {
        this.setProgressInternal(progress, false, false);
    }

    private final void $$robo$$android_widget_ProgressBar$setProgress(int progress, boolean animate) {
        this.setProgressInternal(progress, false, animate);
    }

    @RemotableViewMethod
    private final synchronized boolean $$robo$$android_widget_ProgressBar$setProgressInternal(int progress, boolean fromUser, boolean animate) {
        if (this.mIndeterminate) {
            return false;
        }
        if ((progress = MathUtils.constrain(progress, this.mMin, this.mMax)) == this.mProgress) {
            return false;
        }
        this.mProgress = progress;
        this.refreshProgress(16908301, this.mProgress, fromUser, animate);
        return true;
    }

    @RemotableViewMethod
    private final synchronized void $$robo$$android_widget_ProgressBar$setSecondaryProgress(int secondaryProgress) {
        if (this.mIndeterminate) {
            return;
        }
        if (secondaryProgress < this.mMin) {
            secondaryProgress = this.mMin;
        }
        if (secondaryProgress > this.mMax) {
            secondaryProgress = this.mMax;
        }
        if (secondaryProgress != this.mSecondaryProgress) {
            this.mSecondaryProgress = secondaryProgress;
            this.refreshProgress(16908303, this.mSecondaryProgress, false, false);
        }
    }

    @ViewDebug.ExportedProperty(category="progress")
    private final synchronized int $$robo$$android_widget_ProgressBar$getProgress() {
        return this.mIndeterminate ? 0 : this.mProgress;
    }

    @ViewDebug.ExportedProperty(category="progress")
    private final synchronized int $$robo$$android_widget_ProgressBar$getSecondaryProgress() {
        return this.mIndeterminate ? 0 : this.mSecondaryProgress;
    }

    @ViewDebug.ExportedProperty(category="progress")
    private final synchronized int $$robo$$android_widget_ProgressBar$getMin() {
        return this.mMin;
    }

    @ViewDebug.ExportedProperty(category="progress")
    private final synchronized int $$robo$$android_widget_ProgressBar$getMax() {
        return this.mMax;
    }

    @RemotableViewMethod
    private final synchronized void $$robo$$android_widget_ProgressBar$setMin(int min) {
        if (this.mMaxInitialized && min > this.mMax) {
            min = this.mMax;
        }
        this.mMinInitialized = true;
        if (this.mMaxInitialized && min != this.mMin) {
            this.mMin = min;
            this.postInvalidate();
            if (this.mProgress < min) {
                this.mProgress = min;
            }
            this.refreshProgress(16908301, this.mProgress, false, false);
        } else {
            this.mMin = min;
        }
    }

    @RemotableViewMethod
    private final synchronized void $$robo$$android_widget_ProgressBar$setMax(int max) {
        if (this.mMinInitialized && max < this.mMin) {
            max = this.mMin;
        }
        this.mMaxInitialized = true;
        if (this.mMinInitialized && max != this.mMax) {
            this.mMax = max;
            this.postInvalidate();
            if (this.mProgress > max) {
                this.mProgress = max;
            }
            this.refreshProgress(16908301, this.mProgress, false, false);
        } else {
            this.mMax = max;
        }
    }

    private final synchronized void $$robo$$android_widget_ProgressBar$incrementProgressBy(int diff) {
        this.setProgress(this.mProgress + diff);
    }

    private final synchronized void $$robo$$android_widget_ProgressBar$incrementSecondaryProgressBy(int diff) {
        this.setSecondaryProgress(this.mSecondaryProgress + diff);
    }

    private final void $$robo$$android_widget_ProgressBar$startAnimation() {
        if (this.getVisibility() != 0 || this.getWindowVisibility() != 0) {
            return;
        }
        if (this.mIndeterminateDrawable instanceof Animatable) {
            this.mShouldStartAnimationDrawable = true;
            this.mHasAnimation = false;
        } else {
            this.mHasAnimation = true;
            if (this.mInterpolator == null) {
                this.mInterpolator = new LinearInterpolator();
            }
            if (this.mTransformation == null) {
                this.mTransformation = new Transformation();
            } else {
                this.mTransformation.clear();
            }
            if (this.mAnimation == null) {
                this.mAnimation = new AlphaAnimation(0.0f, 1.0f);
            } else {
                this.mAnimation.reset();
            }
            this.mAnimation.setRepeatMode(this.mBehavior);
            this.mAnimation.setRepeatCount(-1);
            this.mAnimation.setDuration(this.mDuration);
            this.mAnimation.setInterpolator(this.mInterpolator);
            this.mAnimation.setStartTime(-1L);
        }
        this.postInvalidate();
    }

    private final void $$robo$$android_widget_ProgressBar$stopAnimation() {
        this.mHasAnimation = false;
        if (this.mIndeterminateDrawable instanceof Animatable) {
            ((Animatable)((Object)this.mIndeterminateDrawable)).stop();
            this.mShouldStartAnimationDrawable = false;
        }
        this.postInvalidate();
    }

    private final void $$robo$$android_widget_ProgressBar$setInterpolator(Context context, int resID) {
        this.setInterpolator(AnimationUtils.loadInterpolator(context, resID));
    }

    private final void $$robo$$android_widget_ProgressBar$setInterpolator(Interpolator interpolator2) {
        this.mInterpolator = interpolator2;
    }

    private final Interpolator $$robo$$android_widget_ProgressBar$getInterpolator() {
        return this.mInterpolator;
    }

    private final void $$robo$$android_widget_ProgressBar$onVisibilityAggregated(boolean isVisible) {
        super.onVisibilityAggregated(isVisible);
        if (isVisible != this.mAggregatedIsVisible) {
            this.mAggregatedIsVisible = isVisible;
            if (this.mIndeterminate) {
                if (isVisible) {
                    this.startAnimation();
                } else {
                    this.stopAnimation();
                }
            }
            if (this.mCurrentDrawable != null) {
                this.mCurrentDrawable.setVisible(isVisible, false);
            }
        }
    }

    private final void $$robo$$android_widget_ProgressBar$invalidateDrawable(Drawable dr) {
        if (!this.mInDrawing) {
            if (this.verifyDrawable(dr)) {
                Rect dirty = dr.getBounds();
                int scrollX = this.mScrollX + this.mPaddingLeft;
                int scrollY = this.mScrollY + this.mPaddingTop;
                this.invalidate(dirty.left + scrollX, dirty.top + scrollY, dirty.right + scrollX, dirty.bottom + scrollY);
            } else {
                super.invalidateDrawable(dr);
            }
        }
    }

    private final void $$robo$$android_widget_ProgressBar$onSizeChanged(int w, int h, int oldw, int oldh) {
        this.updateDrawableBounds(w, h);
    }

    private final void $$robo$$android_widget_ProgressBar$updateDrawableBounds(int w, int h) {
        int right = w -= this.mPaddingRight + this.mPaddingLeft;
        int bottom = h -= this.mPaddingTop + this.mPaddingBottom;
        int top = 0;
        int left = 0;
        if (this.mIndeterminateDrawable != null) {
            float boundAspect;
            int intrinsicHeight;
            int intrinsicWidth;
            float intrinsicAspect;
            if (this.mOnlyIndeterminate && !(this.mIndeterminateDrawable instanceof AnimationDrawable) && (intrinsicAspect = (float)(intrinsicWidth = this.mIndeterminateDrawable.getIntrinsicWidth()) / (float)(intrinsicHeight = this.mIndeterminateDrawable.getIntrinsicHeight())) != (boundAspect = (float)w / (float)h)) {
                if (boundAspect > intrinsicAspect) {
                    int width = (int)((float)h * intrinsicAspect);
                    left = (w - width) / 2;
                    right = left + width;
                } else {
                    int height = (int)((float)w * (1.0f / intrinsicAspect));
                    top = (h - height) / 2;
                    bottom = top + height;
                }
            }
            if (this.isLayoutRtl() && this.mMirrorForRtl) {
                int tempLeft = left;
                left = w - right;
                right = w - tempLeft;
            }
            this.mIndeterminateDrawable.setBounds(left, top, right, bottom);
        }
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.setBounds(0, 0, right, bottom);
        }
    }

    private final synchronized void $$robo$$android_widget_ProgressBar$onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawTrack(canvas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_widget_ProgressBar$drawTrack(Canvas canvas) {
        Drawable d = this.mCurrentDrawable;
        if (d != null) {
            int saveCount = canvas.save();
            if (this.isLayoutRtl() && this.mMirrorForRtl) {
                canvas.translate(this.getWidth() - this.mPaddingRight, this.mPaddingTop);
                canvas.scale(-1.0f, 1.0f);
            } else {
                canvas.translate(this.mPaddingLeft, this.mPaddingTop);
            }
            long time = this.getDrawingTime();
            if (this.mHasAnimation) {
                this.mAnimation.getTransformation(time, this.mTransformation);
                float scale = this.mTransformation.getAlpha();
                try {
                    this.mInDrawing = true;
                    d.setLevel((int)(scale * 10000.0f));
                }
                finally {
                    this.mInDrawing = false;
                }
                this.postInvalidateOnAnimation();
            }
            d.draw(canvas);
            canvas.restoreToCount(saveCount);
            if (this.mShouldStartAnimationDrawable && d instanceof Animatable) {
                ((Animatable)((Object)d)).start();
                this.mShouldStartAnimationDrawable = false;
            }
        }
    }

    private final synchronized void $$robo$$android_widget_ProgressBar$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int dw = 0;
        int dh = 0;
        Drawable d = this.mCurrentDrawable;
        if (d != null) {
            dw = Math.max(this.mMinWidth, Math.min(this.mMaxWidth, d.getIntrinsicWidth()));
            dh = Math.max(this.mMinHeight, Math.min(this.mMaxHeight, d.getIntrinsicHeight()));
        }
        this.updateDrawableState();
        int measuredWidth = ProgressBar.resolveSizeAndState(dw += this.mPaddingLeft + this.mPaddingRight, widthMeasureSpec, 0);
        int measuredHeight = ProgressBar.resolveSizeAndState(dh += this.mPaddingTop + this.mPaddingBottom, heightMeasureSpec, 0);
        this.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    private final void $$robo$$android_widget_ProgressBar$drawableStateChanged() {
        super.drawableStateChanged();
        this.updateDrawableState();
    }

    private final void $$robo$$android_widget_ProgressBar$updateDrawableState() {
        Drawable indeterminateDrawable;
        int[] state = this.getDrawableState();
        boolean changed = false;
        Drawable progressDrawable = this.mProgressDrawable;
        if (progressDrawable != null && progressDrawable.isStateful()) {
            changed |= progressDrawable.setState(state);
        }
        if ((indeterminateDrawable = this.mIndeterminateDrawable) != null && indeterminateDrawable.isStateful()) {
            changed |= indeterminateDrawable.setState(state);
        }
        if (changed) {
            this.invalidate();
        }
    }

    private final void $$robo$$android_widget_ProgressBar$drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.setHotspot(x, y);
        }
        if (this.mIndeterminateDrawable != null) {
            this.mIndeterminateDrawable.setHotspot(x, y);
        }
    }

    private final Parcelable $$robo$$android_widget_ProgressBar$onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.progress = this.mProgress;
        ss.secondaryProgress = this.mSecondaryProgress;
        return ss;
    }

    private final void $$robo$$android_widget_ProgressBar$onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setProgress(ss.progress);
        this.setSecondaryProgress(ss.secondaryProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_widget_ProgressBar$onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mIndeterminate) {
            this.startAnimation();
        }
        if (this.mRefreshData != null) {
            ProgressBar progressBar = this;
            synchronized (progressBar) {
                int count = this.mRefreshData.size();
                for (int i = 0; i < count; ++i) {
                    RefreshData rd = this.mRefreshData.get(i);
                    this.doRefreshProgress(rd.id, rd.progress, rd.fromUser, true, rd.animate);
                    rd.recycle();
                }
                this.mRefreshData.clear();
            }
        }
        this.mAttached = true;
    }

    private final void $$robo$$android_widget_ProgressBar$onDetachedFromWindow() {
        if (this.mIndeterminate) {
            this.stopAnimation();
        }
        if (this.mRefreshProgressRunnable != null) {
            this.removeCallbacks(this.mRefreshProgressRunnable);
            this.mRefreshIsPosted = false;
        }
        if (this.mAccessibilityEventSender != null) {
            this.removeCallbacks(this.mAccessibilityEventSender);
        }
        super.onDetachedFromWindow();
        this.mAttached = false;
    }

    private final CharSequence $$robo$$android_widget_ProgressBar$getAccessibilityClassName() {
        return ProgressBar.class.getName();
    }

    private final void $$robo$$android_widget_ProgressBar$onInitializeAccessibilityEventInternal(AccessibilityEvent event) {
        super.onInitializeAccessibilityEventInternal(event);
        event.setItemCount(this.mMax - this.mMin);
        event.setCurrentItemIndex(this.mProgress);
    }

    private final void $$robo$$android_widget_ProgressBar$onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        if (!this.isIndeterminate()) {
            AccessibilityNodeInfo.RangeInfo rangeInfo = AccessibilityNodeInfo.RangeInfo.obtain(0, this.getMin(), this.getMax(), this.getProgress());
            info.setRangeInfo(rangeInfo);
        }
    }

    private final void $$robo$$android_widget_ProgressBar$scheduleAccessibilityEventSender() {
        if (this.mAccessibilityEventSender == null) {
            this.mAccessibilityEventSender = new AccessibilityEventSender(this);
        } else {
            this.removeCallbacks(this.mAccessibilityEventSender);
        }
        this.postDelayed(this.mAccessibilityEventSender, 200L);
    }

    private final void $$robo$$android_widget_ProgressBar$encodeProperties(ViewHierarchyEncoder stream) {
        super.encodeProperties(stream);
        stream.addProperty("progress:max", this.getMax());
        stream.addProperty("progress:progress", this.getProgress());
        stream.addProperty("progress:secondaryProgress", this.getSecondaryProgress());
        stream.addProperty("progress:indeterminate", this.isIndeterminate());
    }

    private final boolean $$robo$$android_widget_ProgressBar$isAnimating() {
        return this.isIndeterminate() && this.getWindowVisibility() == 0 && this.isShown();
    }

    static void __staticInitializer__() {
        PROGRESS_ANIM_INTERPOLATOR = new DecelerateInterpolator();
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_ProgressBar$__constructor__(context);
    }

    public ProgressBar(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ProgressBar$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_ProgressBar$__constructor__(context, attributeSet);
    }

    public ProgressBar(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0x1010077);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ProgressBar$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_ProgressBar$__constructor__(context, attributeSet, n);
    }

    public ProgressBar(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ProgressBar$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_ProgressBar$__constructor__(context, attributeSet, n, n2);
    }

    public ProgressBar(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ProgressBar$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private static boolean needsTileify(Drawable drawable2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("needsTileify", $$robo$$android_widget_ProgressBar$needsTileify(android.graphics.drawable.Drawable ), 0, (Drawable)drawable2);
    }

    private Drawable tileify(Drawable drawable2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("tileify", $$robo$$android_widget_ProgressBar$tileify(android.graphics.drawable.Drawable boolean ), 0, this, drawable2, bl);
    }

    Shape getDrawableShape() {
        return InvokeDynamicSupport.bootstrap("getDrawableShape", $$robo$$android_widget_ProgressBar$getDrawableShape(), 0, this);
    }

    private Drawable tileifyIndeterminate(Drawable drawable2) {
        return InvokeDynamicSupport.bootstrap("tileifyIndeterminate", $$robo$$android_widget_ProgressBar$tileifyIndeterminate(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    private void initProgressBar() {
        InvokeDynamicSupport.bootstrap("initProgressBar", $$robo$$android_widget_ProgressBar$initProgressBar(), 0, this);
    }

    @ViewDebug.ExportedProperty(category="progress")
    public synchronized boolean isIndeterminate() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIndeterminate", $$robo$$android_widget_ProgressBar$isIndeterminate(), 0, this);
    }

    @RemotableViewMethod
    public synchronized void setIndeterminate(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIndeterminate", $$robo$$android_widget_ProgressBar$setIndeterminate(boolean ), 0, this, bl);
    }

    private void swapCurrentDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("swapCurrentDrawable", $$robo$$android_widget_ProgressBar$swapCurrentDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public Drawable getIndeterminateDrawable() {
        return InvokeDynamicSupport.bootstrap("getIndeterminateDrawable", $$robo$$android_widget_ProgressBar$getIndeterminateDrawable(), 0, this);
    }

    public void setIndeterminateDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setIndeterminateDrawable", $$robo$$android_widget_ProgressBar$setIndeterminateDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @RemotableViewMethod
    public void setIndeterminateTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setIndeterminateTintList", $$robo$$android_widget_ProgressBar$setIndeterminateTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    public ColorStateList getIndeterminateTintList() {
        return InvokeDynamicSupport.bootstrap("getIndeterminateTintList", $$robo$$android_widget_ProgressBar$getIndeterminateTintList(), 0, this);
    }

    public void setIndeterminateTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setIndeterminateTintMode", $$robo$$android_widget_ProgressBar$setIndeterminateTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    public PorterDuff.Mode getIndeterminateTintMode() {
        return InvokeDynamicSupport.bootstrap("getIndeterminateTintMode", $$robo$$android_widget_ProgressBar$getIndeterminateTintMode(), 0, this);
    }

    private void applyIndeterminateTint() {
        InvokeDynamicSupport.bootstrap("applyIndeterminateTint", $$robo$$android_widget_ProgressBar$applyIndeterminateTint(), 0, this);
    }

    public void setIndeterminateDrawableTiled(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setIndeterminateDrawableTiled", $$robo$$android_widget_ProgressBar$setIndeterminateDrawableTiled(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public Drawable getProgressDrawable() {
        return InvokeDynamicSupport.bootstrap("getProgressDrawable", $$robo$$android_widget_ProgressBar$getProgressDrawable(), 0, this);
    }

    public void setProgressDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setProgressDrawable", $$robo$$android_widget_ProgressBar$setProgressDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public boolean getMirrorForRtl() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMirrorForRtl", $$robo$$android_widget_ProgressBar$getMirrorForRtl(), 0, this);
    }

    private void applyProgressTints() {
        InvokeDynamicSupport.bootstrap("applyProgressTints", $$robo$$android_widget_ProgressBar$applyProgressTints(), 0, this);
    }

    private void applyPrimaryProgressTint() {
        InvokeDynamicSupport.bootstrap("applyPrimaryProgressTint", $$robo$$android_widget_ProgressBar$applyPrimaryProgressTint(), 0, this);
    }

    private void applyProgressBackgroundTint() {
        InvokeDynamicSupport.bootstrap("applyProgressBackgroundTint", $$robo$$android_widget_ProgressBar$applyProgressBackgroundTint(), 0, this);
    }

    private void applySecondaryProgressTint() {
        InvokeDynamicSupport.bootstrap("applySecondaryProgressTint", $$robo$$android_widget_ProgressBar$applySecondaryProgressTint(), 0, this);
    }

    @RemotableViewMethod
    public void setProgressTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setProgressTintList", $$robo$$android_widget_ProgressBar$setProgressTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    public ColorStateList getProgressTintList() {
        return InvokeDynamicSupport.bootstrap("getProgressTintList", $$robo$$android_widget_ProgressBar$getProgressTintList(), 0, this);
    }

    public void setProgressTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setProgressTintMode", $$robo$$android_widget_ProgressBar$setProgressTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    public PorterDuff.Mode getProgressTintMode() {
        return InvokeDynamicSupport.bootstrap("getProgressTintMode", $$robo$$android_widget_ProgressBar$getProgressTintMode(), 0, this);
    }

    @RemotableViewMethod
    public void setProgressBackgroundTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setProgressBackgroundTintList", $$robo$$android_widget_ProgressBar$setProgressBackgroundTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    public ColorStateList getProgressBackgroundTintList() {
        return InvokeDynamicSupport.bootstrap("getProgressBackgroundTintList", $$robo$$android_widget_ProgressBar$getProgressBackgroundTintList(), 0, this);
    }

    public void setProgressBackgroundTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setProgressBackgroundTintMode", $$robo$$android_widget_ProgressBar$setProgressBackgroundTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    public PorterDuff.Mode getProgressBackgroundTintMode() {
        return InvokeDynamicSupport.bootstrap("getProgressBackgroundTintMode", $$robo$$android_widget_ProgressBar$getProgressBackgroundTintMode(), 0, this);
    }

    public void setSecondaryProgressTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setSecondaryProgressTintList", $$robo$$android_widget_ProgressBar$setSecondaryProgressTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    public ColorStateList getSecondaryProgressTintList() {
        return InvokeDynamicSupport.bootstrap("getSecondaryProgressTintList", $$robo$$android_widget_ProgressBar$getSecondaryProgressTintList(), 0, this);
    }

    public void setSecondaryProgressTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setSecondaryProgressTintMode", $$robo$$android_widget_ProgressBar$setSecondaryProgressTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    public PorterDuff.Mode getSecondaryProgressTintMode() {
        return InvokeDynamicSupport.bootstrap("getSecondaryProgressTintMode", $$robo$$android_widget_ProgressBar$getSecondaryProgressTintMode(), 0, this);
    }

    private Drawable getTintTarget(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getTintTarget", $$robo$$android_widget_ProgressBar$getTintTarget(int boolean ), 0, this, n, bl);
    }

    public void setProgressDrawableTiled(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setProgressDrawableTiled", $$robo$$android_widget_ProgressBar$setProgressDrawableTiled(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    Drawable getCurrentDrawable() {
        return InvokeDynamicSupport.bootstrap("getCurrentDrawable", $$robo$$android_widget_ProgressBar$getCurrentDrawable(), 0, this);
    }

    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        return (boolean)InvokeDynamicSupport.bootstrap("verifyDrawable", $$robo$$android_widget_ProgressBar$verifyDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpDrawablesToCurrentState", $$robo$$android_widget_ProgressBar$jumpDrawablesToCurrentState(), 0, this);
    }

    @Override
    public void onResolveDrawables(int n) {
        InvokeDynamicSupport.bootstrap("onResolveDrawables", $$robo$$android_widget_ProgressBar$onResolveDrawables(int ), 0, this, n);
    }

    @Override
    public void postInvalidate() {
        InvokeDynamicSupport.bootstrap("postInvalidate", $$robo$$android_widget_ProgressBar$postInvalidate(), 0, this);
    }

    private synchronized void doRefreshProgress(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        InvokeDynamicSupport.bootstrap("doRefreshProgress", $$robo$$android_widget_ProgressBar$doRefreshProgress(int int boolean boolean boolean ), 0, this, n, n2, bl, bl2, bl3);
    }

    void onProgressRefresh(float f, boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("onProgressRefresh", $$robo$$android_widget_ProgressBar$onProgressRefresh(float boolean int ), 0, this, f, bl, n);
    }

    private void setVisualProgress(int n, float f) {
        InvokeDynamicSupport.bootstrap("setVisualProgress", $$robo$$android_widget_ProgressBar$setVisualProgress(int float ), 0, this, n, f);
    }

    void onVisualProgressChanged(int n, float f) {
        InvokeDynamicSupport.bootstrap("onVisualProgressChanged", $$robo$$android_widget_ProgressBar$onVisualProgressChanged(int float ), 0, this, n, f);
    }

    private synchronized void refreshProgress(int n, int n2, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("refreshProgress", $$robo$$android_widget_ProgressBar$refreshProgress(int int boolean boolean ), 0, this, n, n2, bl, bl2);
    }

    @RemotableViewMethod
    public synchronized void setProgress(int n) {
        InvokeDynamicSupport.bootstrap("setProgress", $$robo$$android_widget_ProgressBar$setProgress(int ), 0, this, n);
    }

    public void setProgress(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setProgress", $$robo$$android_widget_ProgressBar$setProgress(int boolean ), 0, this, n, bl);
    }

    @RemotableViewMethod
    synchronized boolean setProgressInternal(int n, boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setProgressInternal", $$robo$$android_widget_ProgressBar$setProgressInternal(int boolean boolean ), 0, this, n, bl, bl2);
    }

    @RemotableViewMethod
    public synchronized void setSecondaryProgress(int n) {
        InvokeDynamicSupport.bootstrap("setSecondaryProgress", $$robo$$android_widget_ProgressBar$setSecondaryProgress(int ), 0, this, n);
    }

    @ViewDebug.ExportedProperty(category="progress")
    public synchronized int getProgress() {
        return (int)InvokeDynamicSupport.bootstrap("getProgress", $$robo$$android_widget_ProgressBar$getProgress(), 0, this);
    }

    @ViewDebug.ExportedProperty(category="progress")
    public synchronized int getSecondaryProgress() {
        return (int)InvokeDynamicSupport.bootstrap("getSecondaryProgress", $$robo$$android_widget_ProgressBar$getSecondaryProgress(), 0, this);
    }

    @ViewDebug.ExportedProperty(category="progress")
    public synchronized int getMin() {
        return (int)InvokeDynamicSupport.bootstrap("getMin", $$robo$$android_widget_ProgressBar$getMin(), 0, this);
    }

    @ViewDebug.ExportedProperty(category="progress")
    public synchronized int getMax() {
        return (int)InvokeDynamicSupport.bootstrap("getMax", $$robo$$android_widget_ProgressBar$getMax(), 0, this);
    }

    @RemotableViewMethod
    public synchronized void setMin(int n) {
        InvokeDynamicSupport.bootstrap("setMin", $$robo$$android_widget_ProgressBar$setMin(int ), 0, this, n);
    }

    @RemotableViewMethod
    public synchronized void setMax(int n) {
        InvokeDynamicSupport.bootstrap("setMax", $$robo$$android_widget_ProgressBar$setMax(int ), 0, this, n);
    }

    public synchronized void incrementProgressBy(int n) {
        InvokeDynamicSupport.bootstrap("incrementProgressBy", $$robo$$android_widget_ProgressBar$incrementProgressBy(int ), 0, this, n);
    }

    public synchronized void incrementSecondaryProgressBy(int n) {
        InvokeDynamicSupport.bootstrap("incrementSecondaryProgressBy", $$robo$$android_widget_ProgressBar$incrementSecondaryProgressBy(int ), 0, this, n);
    }

    void startAnimation() {
        InvokeDynamicSupport.bootstrap("startAnimation", $$robo$$android_widget_ProgressBar$startAnimation(), 0, this);
    }

    void stopAnimation() {
        InvokeDynamicSupport.bootstrap("stopAnimation", $$robo$$android_widget_ProgressBar$stopAnimation(), 0, this);
    }

    public void setInterpolator(Context context, int n) {
        InvokeDynamicSupport.bootstrap("setInterpolator", $$robo$$android_widget_ProgressBar$setInterpolator(android.content.Context int ), 0, this, context, n);
    }

    public void setInterpolator(Interpolator interpolator2) {
        InvokeDynamicSupport.bootstrap("setInterpolator", $$robo$$android_widget_ProgressBar$setInterpolator(android.view.animation.Interpolator ), 0, this, interpolator2);
    }

    public Interpolator getInterpolator() {
        return InvokeDynamicSupport.bootstrap("getInterpolator", $$robo$$android_widget_ProgressBar$getInterpolator(), 0, this);
    }

    @Override
    public void onVisibilityAggregated(boolean bl) {
        InvokeDynamicSupport.bootstrap("onVisibilityAggregated", $$robo$$android_widget_ProgressBar$onVisibilityAggregated(boolean ), 0, this, bl);
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("invalidateDrawable", $$robo$$android_widget_ProgressBar$invalidateDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onSizeChanged", $$robo$$android_widget_ProgressBar$onSizeChanged(int int int int ), 0, this, n, n2, n3, n4);
    }

    private void updateDrawableBounds(int n, int n2) {
        InvokeDynamicSupport.bootstrap("updateDrawableBounds", $$robo$$android_widget_ProgressBar$updateDrawableBounds(int int ), 0, this, n, n2);
    }

    @Override
    protected synchronized void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_widget_ProgressBar$onDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    void drawTrack(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("drawTrack", $$robo$$android_widget_ProgressBar$drawTrack(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    protected synchronized void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_ProgressBar$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    protected void drawableStateChanged() {
        InvokeDynamicSupport.bootstrap("drawableStateChanged", $$robo$$android_widget_ProgressBar$drawableStateChanged(), 0, this);
    }

    private void updateDrawableState() {
        InvokeDynamicSupport.bootstrap("updateDrawableState", $$robo$$android_widget_ProgressBar$updateDrawableState(), 0, this);
    }

    @Override
    public void drawableHotspotChanged(float f, float f2) {
        InvokeDynamicSupport.bootstrap("drawableHotspotChanged", $$robo$$android_widget_ProgressBar$drawableHotspotChanged(float float ), 0, this, f, f2);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_widget_ProgressBar$onSaveInstanceState(), 0, this);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_widget_ProgressBar$onRestoreInstanceState(android.os.Parcelable ), 0, this, parcelable);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_widget_ProgressBar$onAttachedToWindow(), 0, this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_widget_ProgressBar$onDetachedFromWindow(), 0, this);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_ProgressBar$getAccessibilityClassName(), 0, this);
    }

    @Override
    public void onInitializeAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEventInternal", $$robo$$android_widget_ProgressBar$onInitializeAccessibilityEventInternal(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoInternal", $$robo$$android_widget_ProgressBar$onInitializeAccessibilityNodeInfoInternal(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    private void scheduleAccessibilityEventSender() {
        InvokeDynamicSupport.bootstrap("scheduleAccessibilityEventSender", $$robo$$android_widget_ProgressBar$scheduleAccessibilityEventSender(), 0, this);
    }

    @Override
    protected void encodeProperties(ViewHierarchyEncoder viewHierarchyEncoder) {
        InvokeDynamicSupport.bootstrap("encodeProperties", $$robo$$android_widget_ProgressBar$encodeProperties(android.view.ViewHierarchyEncoder ), 0, this, viewHierarchyEncoder);
    }

    public boolean isAnimating() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAnimating", $$robo$$android_widget_ProgressBar$isAnimating(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(ProgressBar.class);
    }

    public /* synthetic */ ProgressBar() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProgressBar)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ProgressTintInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        ColorStateList mIndeterminateTintList;
        PorterDuff.Mode mIndeterminateTintMode;
        boolean mHasIndeterminateTint;
        boolean mHasIndeterminateTintMode;
        ColorStateList mProgressTintList;
        PorterDuff.Mode mProgressTintMode;
        boolean mHasProgressTint;
        boolean mHasProgressTintMode;
        ColorStateList mProgressBackgroundTintList;
        PorterDuff.Mode mProgressBackgroundTintMode;
        boolean mHasProgressBackgroundTint;
        boolean mHasProgressBackgroundTintMode;
        ColorStateList mSecondaryProgressTintList;
        PorterDuff.Mode mSecondaryProgressTintMode;
        boolean mHasSecondaryProgressTint;
        boolean mHasSecondaryProgressTintMode;

        private void $$robo$$android_widget_ProgressBar_ProgressTintInfo$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_widget_ProgressBar_ProgressTintInfo$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_widget_ProgressBar_ProgressTintInfo$__constructor__();
        }

        private ProgressTintInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ProgressBar_ProgressTintInfo$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_widget_ProgressBar_ProgressTintInfo$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProgressTintInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class AccessibilityEventSender
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ProgressBar this$0;

        private void $$robo$$android_widget_ProgressBar_AccessibilityEventSender$__constructor__(ProgressBar progressBar) {
        }

        private final void $$robo$$android_widget_ProgressBar_AccessibilityEventSender$run() {
            this.this$0.sendAccessibilityEvent(4);
        }

        private /* synthetic */ void $$robo$$android_widget_ProgressBar_AccessibilityEventSender$__constructor__(ProgressBar x0, 1 x1) {
        }

        private void __constructor__(ProgressBar progressBar) {
            this.$$robo$$android_widget_ProgressBar_AccessibilityEventSender$__constructor__(progressBar);
        }

        private AccessibilityEventSender(ProgressBar progressBar) {
            this.this$0 = progressBar;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ProgressBar_AccessibilityEventSender$__constructor__(android.widget.ProgressBar ), 0, this, progressBar);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_ProgressBar_AccessibilityEventSender$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(ProgressBar progressBar, 1 var2_2) {
            this.$$robo$$android_widget_ProgressBar_AccessibilityEventSender$__constructor__(progressBar, var2_2);
        }

        public /* synthetic */ AccessibilityEventSender() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityEventSender)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SavedState
    extends View.BaseSavedState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int progress;
        int secondaryProgress;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$android_widget_ProgressBar_SavedState$__constructor__(Parcelable superState) {
        }

        private void $$robo$$android_widget_ProgressBar_SavedState$__constructor__(Parcel in) {
            this.progress = in.readInt();
            this.secondaryProgress = in.readInt();
        }

        private final void $$robo$$android_widget_ProgressBar_SavedState$writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.progress);
            out.writeInt(this.secondaryProgress);
        }

        private /* synthetic */ void $$robo$$android_widget_ProgressBar_SavedState$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_widget_ProgressBar_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$android_widget_ProgressBar_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in);
                }

                private final SavedState[] $$robo$$android_widget_ProgressBar_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_widget_ProgressBar_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ProgressBar_SavedState_1$__constructor__(), 0, this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_ProgressBar_SavedState_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_widget_ProgressBar_SavedState_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcelable parcelable) {
            this.$$robo$$android_widget_ProgressBar_SavedState$__constructor__(parcelable);
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ProgressBar_SavedState$__constructor__(android.os.Parcelable ), 0, this, parcelable);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_widget_ProgressBar_SavedState$__constructor__(parcel);
        }

        private SavedState(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ProgressBar_SavedState$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_ProgressBar_SavedState$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_widget_ProgressBar_SavedState$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        public /* synthetic */ SavedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class RefreshData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int POOL_MAX = 24;
        private static Pools.SynchronizedPool<RefreshData> sPool;
        public int id;
        public int progress;
        public boolean fromUser;
        public boolean animate;

        private void $$robo$$android_widget_ProgressBar_RefreshData$__constructor__() {
        }

        private static final RefreshData $$robo$$android_widget_ProgressBar_RefreshData$obtain(int id2, int progress, boolean fromUser, boolean animate) {
            RefreshData rd = sPool.acquire();
            if (rd == null) {
                rd = new RefreshData();
            }
            rd.id = id2;
            rd.progress = progress;
            rd.fromUser = fromUser;
            rd.animate = animate;
            return rd;
        }

        private final void $$robo$$android_widget_ProgressBar_RefreshData$recycle() {
            sPool.release(this);
        }

        static void __staticInitializer__() {
            sPool = new Pools.SynchronizedPool(24);
        }

        private void __constructor__() {
            this.$$robo$$android_widget_ProgressBar_RefreshData$__constructor__();
        }

        private RefreshData() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ProgressBar_RefreshData$__constructor__(), 0, this);
        }

        public static RefreshData obtain(int n, int n2, boolean bl, boolean bl2) {
            return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_widget_ProgressBar_RefreshData$obtain(int int boolean boolean ), 0, (int)n, (int)n2, (boolean)bl, (boolean)bl2);
        }

        public void recycle() {
            InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_widget_ProgressBar_RefreshData$recycle(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(RefreshData.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RefreshData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class RefreshProgressRunnable
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ProgressBar this$0;

        private void $$robo$$android_widget_ProgressBar_RefreshProgressRunnable$__constructor__(ProgressBar progressBar) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_widget_ProgressBar_RefreshProgressRunnable$run() {
            ProgressBar progressBar = this.this$0;
            synchronized (progressBar) {
                int count = this.this$0.mRefreshData.size();
                for (int i = 0; i < count; ++i) {
                    RefreshData rd = (RefreshData)this.this$0.mRefreshData.get(i);
                    this.this$0.doRefreshProgress(rd.id, rd.progress, rd.fromUser, true, rd.animate);
                    rd.recycle();
                }
                this.this$0.mRefreshData.clear();
                this.this$0.mRefreshIsPosted = false;
            }
        }

        private /* synthetic */ void $$robo$$android_widget_ProgressBar_RefreshProgressRunnable$__constructor__(ProgressBar x0, 1 x1) {
        }

        private void __constructor__(ProgressBar progressBar) {
            this.$$robo$$android_widget_ProgressBar_RefreshProgressRunnable$__constructor__(progressBar);
        }

        private RefreshProgressRunnable(ProgressBar progressBar) {
            this.this$0 = progressBar;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ProgressBar_RefreshProgressRunnable$__constructor__(android.widget.ProgressBar ), 0, this, progressBar);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_ProgressBar_RefreshProgressRunnable$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(ProgressBar progressBar, 1 var2_2) {
            this.$$robo$$android_widget_ProgressBar_RefreshProgressRunnable$__constructor__(progressBar, var2_2);
        }

        public /* synthetic */ RefreshProgressRunnable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RefreshProgressRunnable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

