/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.ActivityOptions;
import android.app.ActivityThread;
import android.app.Application;
import android.app.PendingIntent;
import android.app.RemoteInput;
import android.appwidget.AppWidgetHostView;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.AdapterViewAnimator;
import android.widget.ImageView;
import android.widget.RemoteViewsAdapter;
import android.widget.RemoteViewsListAdapter;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.util.NotificationColorUtil;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RemoteViews
implements Parcelable,
LayoutInflater.Filter,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "RemoteViews";
    static String EXTRA_REMOTEADAPTER_APPWIDGET_ID = "remoteAdapterAppWidgetId";
    private static int MAX_NESTED_VIEWS = 10;
    private static int SET_ON_CLICK_PENDING_INTENT_TAG = 1;
    private static int REFLECTION_ACTION_TAG = 2;
    private static int SET_DRAWABLE_TINT_TAG = 3;
    private static int VIEW_GROUP_ACTION_ADD_TAG = 4;
    private static int VIEW_CONTENT_NAVIGATION_TAG = 5;
    private static int SET_EMPTY_VIEW_ACTION_TAG = 6;
    private static int VIEW_GROUP_ACTION_REMOVE_TAG = 7;
    private static int SET_PENDING_INTENT_TEMPLATE_TAG = 8;
    private static int SET_ON_CLICK_FILL_IN_INTENT_TAG = 9;
    private static int SET_REMOTE_VIEW_ADAPTER_INTENT_TAG = 10;
    private static int TEXT_VIEW_DRAWABLE_ACTION_TAG = 11;
    private static int BITMAP_REFLECTION_ACTION_TAG = 12;
    private static int TEXT_VIEW_SIZE_ACTION_TAG = 13;
    private static int VIEW_PADDING_ACTION_TAG = 14;
    private static int SET_REMOTE_VIEW_ADAPTER_LIST_TAG = 15;
    private static int SET_REMOTE_INPUTS_ACTION_TAG = 18;
    private static int LAYOUT_PARAM_ACTION_TAG = 19;
    private static int OVERRIDE_TEXT_COLORS_TAG = 20;
    public ApplicationInfo mApplication;
    private int mLayoutId;
    private ArrayList<Action> mActions;
    private BitmapCache mBitmapCache;
    private boolean mIsRoot;
    private int mApplyThemeResId;
    private boolean mReapplyDisallowed;
    private static int MODE_NORMAL = 0;
    private static int MODE_HAS_LANDSCAPE_AND_PORTRAIT = 1;
    private RemoteViews mLandscape;
    private RemoteViews mPortrait;
    private boolean mIsWidgetCollectionChild;
    private Map<Class, Object> mClassCookies;
    private static OnClickHandler DEFAULT_ON_CLICK_HANDLER;
    private static ArrayMap<MethodKey, MethodArgs> sMethods;
    private static MethodKey sLookupKey;
    private static Action ACTION_NOOP;
    public static Parcelable.Creator<RemoteViews> CREATOR;

    private final void $$robo$$android_widget_RemoteViews$setRemoteInputs(int viewId, RemoteInput[] remoteInputs) {
        this.mActions.add(new SetRemoteInputsAction(this, viewId, remoteInputs));
    }

    private final void $$robo$$android_widget_RemoteViews$reduceImageSizes(int maxWidth, int maxHeight) {
        ArrayList<Bitmap> cache = this.mBitmapCache.mBitmaps;
        for (int i = 0; i < cache.size(); ++i) {
            Bitmap bitmap = cache.get(i);
            cache.set(i, Icon.scaleDownIfNecessary(bitmap, maxWidth, maxHeight));
        }
    }

    private final void $$robo$$android_widget_RemoteViews$overrideTextColors(int textColor) {
        this.addAction(new OverrideTextColorsAction(this, textColor));
    }

    private final void $$robo$$android_widget_RemoteViews$setReapplyDisallowed() {
        this.mReapplyDisallowed = true;
    }

    private final boolean $$robo$$android_widget_RemoteViews$isReapplyDisallowed() {
        return this.mReapplyDisallowed;
    }

    private final void $$robo$$android_widget_RemoteViews$mergeRemoteViews(RemoteViews newRv) {
        if (newRv == null) {
            return;
        }
        RemoteViews copy = new RemoteViews(newRv);
        HashMap<String, Action> map = new HashMap<String, Action>();
        if (this.mActions == null) {
            this.mActions = new ArrayList();
        }
        int count = this.mActions.size();
        for (int i = 0; i < count; ++i) {
            Action a = this.mActions.get(i);
            map.put(a.getUniqueKey(), a);
        }
        ArrayList<Action> newActions = copy.mActions;
        if (newActions == null) {
            return;
        }
        count = newActions.size();
        for (int i = 0; i < count; ++i) {
            Action a = newActions.get(i);
            String key = newActions.get(i).getUniqueKey();
            int mergeBehavior = newActions.get(i).mergeBehavior();
            if (map.containsKey(key) && mergeBehavior == 0) {
                this.mActions.remove(map.get(key));
                map.remove(key);
            }
            if (mergeBehavior != 0 && mergeBehavior != 1) continue;
            this.mActions.add(a);
        }
        this.mBitmapCache = new BitmapCache();
        this.setBitmapCache(this.mBitmapCache);
    }

    private final void $$robo$$android_widget_RemoteViews$visitUris(Consumer<Uri> visitor) {
        if (this.mActions != null) {
            for (int i = 0; i < this.mActions.size(); ++i) {
                this.mActions.get(i).visitUris(visitor);
            }
        }
    }

    private static final void $$robo$$android_widget_RemoteViews$visitIconUri(Icon icon, Consumer<Uri> visitor) {
        if (icon != null && icon.getType() == 4) {
            visitor.accept(icon.getUri());
        }
    }

    private static final Rect $$robo$$android_widget_RemoteViews$getSourceBounds(View v) {
        float appScale = v.getContext().getResources().getCompatibilityInfo().applicationScale;
        int[] pos = new int[2];
        v.getLocationOnScreen(pos);
        Rect rect = new Rect();
        rect.left = (int)((float)pos[0] * appScale + 0.5f);
        rect.top = (int)((float)pos[1] * appScale + 0.5f);
        rect.right = (int)((float)(pos[0] + v.getWidth()) * appScale + 0.5f);
        rect.bottom = (int)((float)(pos[1] + v.getHeight()) * appScale + 0.5f);
        return rect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MethodHandle $$robo$$android_widget_RemoteViews$getMethod(View view, String methodName, Class<?> paramType, boolean async) {
        Class<?> klass = view.getClass();
        ArrayMap<MethodKey, MethodArgs> arrayMap = sMethods;
        synchronized (arrayMap) {
            sLookupKey.set(klass, paramType, methodName);
            MethodArgs result = sMethods.get(sLookupKey);
            if (result == null) {
                try {
                    Method method = paramType == null ? klass.getMethod(methodName, new Class[0]) : klass.getMethod(methodName, paramType);
                    if (!method.isAnnotationPresent(RemotableViewMethod.class)) {
                        throw new ActionException("view: " + klass.getName() + " can't use method with RemoteViews: " + methodName + RemoteViews.getParameters(paramType));
                    }
                    result = new MethodArgs();
                    result.syncMethod = MethodHandles.publicLookup().unreflect(method);
                    result.asyncMethodName = method.getAnnotation(RemotableViewMethod.class).asyncImpl();
                }
                catch (IllegalAccessException | NoSuchMethodException ex) {
                    throw new ActionException("view: " + klass.getName() + " doesn't have method: " + methodName + RemoteViews.getParameters(paramType));
                }
                MethodKey key = new MethodKey();
                key.set(klass, paramType, methodName);
                sMethods.put(key, result);
            }
            if (!async) {
                return result.syncMethod;
            }
            if (result.asyncMethodName.isEmpty()) {
                return null;
            }
            if (result.asyncMethod == null) {
                MethodType asyncType = result.syncMethod.type().dropParameterTypes(0, 1).changeReturnType(Runnable.class);
                try {
                    result.asyncMethod = MethodHandles.publicLookup().findVirtual(klass, result.asyncMethodName, asyncType);
                }
                catch (IllegalAccessException | NoSuchMethodException ex) {
                    throw new ActionException("Async implementation declared as " + result.asyncMethodName + " but not defined for " + methodName + ": public Runnable " + result.asyncMethodName + " (" + TextUtils.join((CharSequence)",", asyncType.parameterArray()) + ")");
                }
            }
            return result.asyncMethod;
        }
    }

    private static final String $$robo$$android_widget_RemoteViews$getParameters(Class<?> paramType) {
        if (paramType == null) {
            return "()";
        }
        return "(" + paramType + ")";
    }

    private final void $$robo$$android_widget_RemoteViews$configureRemoteViewsAsChild(RemoteViews rv) {
        rv.setBitmapCache(this.mBitmapCache);
        rv.setNotRoot();
    }

    private final void $$robo$$android_widget_RemoteViews$setNotRoot() {
        this.mIsRoot = false;
    }

    private void $$robo$$android_widget_RemoteViews$__constructor__(String packageName, int layoutId) {
    }

    private void $$robo$$android_widget_RemoteViews$__constructor__(String packageName, int userId, int layoutId) {
    }

    private void $$robo$$android_widget_RemoteViews$__constructor__(ApplicationInfo application, int layoutId) {
        this.mIsRoot = true;
        this.mLandscape = null;
        this.mPortrait = null;
        this.mIsWidgetCollectionChild = false;
        this.mApplication = application;
        this.mLayoutId = layoutId;
        this.mBitmapCache = new BitmapCache();
        this.mClassCookies = null;
    }

    private final boolean $$robo$$android_widget_RemoteViews$hasLandscapeAndPortraitLayouts() {
        return this.mLandscape != null && this.mPortrait != null;
    }

    private void $$robo$$android_widget_RemoteViews$__constructor__(RemoteViews landscape, RemoteViews portrait) {
        this.mIsRoot = true;
        this.mLandscape = null;
        this.mPortrait = null;
        this.mIsWidgetCollectionChild = false;
        if (landscape == null || portrait == null) {
            throw new RuntimeException("Both RemoteViews must be non-null");
        }
        if (!landscape.hasSameAppInfo(portrait.mApplication)) {
            throw new RuntimeException("Both RemoteViews must share the same package and user");
        }
        this.mApplication = portrait.mApplication;
        this.mLayoutId = portrait.getLayoutId();
        this.mLandscape = landscape;
        this.mPortrait = portrait;
        this.mBitmapCache = new BitmapCache();
        this.configureRemoteViewsAsChild(landscape);
        this.configureRemoteViewsAsChild(portrait);
        this.mClassCookies = portrait.mClassCookies != null ? portrait.mClassCookies : landscape.mClassCookies;
    }

    private void $$robo$$android_widget_RemoteViews$__constructor__(RemoteViews src) {
        this.mIsRoot = true;
        this.mLandscape = null;
        this.mPortrait = null;
        this.mIsWidgetCollectionChild = false;
        this.mBitmapCache = src.mBitmapCache;
        this.mApplication = src.mApplication;
        this.mIsRoot = src.mIsRoot;
        this.mLayoutId = src.mLayoutId;
        this.mIsWidgetCollectionChild = src.mIsWidgetCollectionChild;
        this.mReapplyDisallowed = src.mReapplyDisallowed;
        this.mClassCookies = src.mClassCookies;
        if (src.hasLandscapeAndPortraitLayouts()) {
            this.mLandscape = new RemoteViews(src.mLandscape);
            this.mPortrait = new RemoteViews(src.mPortrait);
        }
        if (src.mActions != null) {
            Parcel p = Parcel.obtain();
            p.putClassCookies(this.mClassCookies);
            src.writeActionsToParcel(p);
            p.setDataPosition(0);
            this.readActionsFromParcel(p, 0);
            p.recycle();
        }
        this.setBitmapCache(new BitmapCache());
    }

    private void $$robo$$android_widget_RemoteViews$__constructor__(Parcel parcel) {
    }

    private void $$robo$$android_widget_RemoteViews$__constructor__(Parcel parcel, BitmapCache bitmapCache, ApplicationInfo info, int depth, Map<Class, Object> classCookies) {
        this.mIsRoot = true;
        this.mLandscape = null;
        this.mPortrait = null;
        this.mIsWidgetCollectionChild = false;
        if (depth > 10 && UserHandle.getAppId(Binder.getCallingUid()) != 1000) {
            throw new IllegalArgumentException("Too many nested views.");
        }
        ++depth;
        int mode = parcel.readInt();
        if (bitmapCache == null) {
            this.mBitmapCache = new BitmapCache(parcel);
            this.mClassCookies = parcel.copyClassCookies();
        } else {
            this.setBitmapCache(bitmapCache);
            this.mClassCookies = classCookies;
            this.setNotRoot();
        }
        if (mode == 0) {
            this.mApplication = parcel.readInt() == 0 ? info : ApplicationInfo.CREATOR.createFromParcel(parcel);
            this.mLayoutId = parcel.readInt();
            this.mIsWidgetCollectionChild = parcel.readInt() == 1;
            this.readActionsFromParcel(parcel, depth);
        } else {
            this.mLandscape = new RemoteViews(parcel, this.mBitmapCache, info, depth, this.mClassCookies);
            this.mPortrait = new RemoteViews(parcel, this.mBitmapCache, this.mLandscape.mApplication, depth, this.mClassCookies);
            this.mApplication = this.mPortrait.mApplication;
            this.mLayoutId = this.mPortrait.getLayoutId();
        }
        this.mReapplyDisallowed = parcel.readInt() == 0;
    }

    private final void $$robo$$android_widget_RemoteViews$readActionsFromParcel(Parcel parcel, int depth) {
        int count = parcel.readInt();
        if (count > 0) {
            this.mActions = new ArrayList(count);
            for (int i = 0; i < count; ++i) {
                this.mActions.add(this.getActionFromParcel(parcel, depth));
            }
        }
    }

    private final Action $$robo$$android_widget_RemoteViews$getActionFromParcel(Parcel parcel, int depth) {
        int tag = parcel.readInt();
        switch (tag) {
            case 1: {
                return new SetOnClickPendingIntent(this, parcel);
            }
            case 3: {
                return new SetDrawableTint(this, parcel);
            }
            case 2: {
                return new ReflectionAction(this, parcel);
            }
            case 4: {
                return new ViewGroupActionAdd(this, parcel, this.mBitmapCache, this.mApplication, depth, this.mClassCookies);
            }
            case 7: {
                return new ViewGroupActionRemove(this, parcel);
            }
            case 5: {
                return new ViewContentNavigation(this, parcel);
            }
            case 6: {
                return new SetEmptyView(this, parcel);
            }
            case 8: {
                return new SetPendingIntentTemplate(this, parcel);
            }
            case 9: {
                return new SetOnClickFillInIntent(this, parcel);
            }
            case 10: {
                return new SetRemoteViewsAdapterIntent(this, parcel);
            }
            case 11: {
                return new TextViewDrawableAction(this, parcel);
            }
            case 13: {
                return new TextViewSizeAction(this, parcel);
            }
            case 14: {
                return new ViewPaddingAction(this, parcel);
            }
            case 12: {
                return new BitmapReflectionAction(this, parcel);
            }
            case 15: {
                return new SetRemoteViewsAdapterList(this, parcel);
            }
            case 18: {
                return new SetRemoteInputsAction(this, parcel);
            }
            case 19: {
                return new LayoutParamAction(parcel);
            }
            case 20: {
                return new OverrideTextColorsAction(this, parcel);
            }
        }
        throw new ActionException("Tag " + tag + " not found");
    }

    @Deprecated
    private final RemoteViews $$robo$$android_widget_RemoteViews$clone() {
        Preconditions.checkState(this.mIsRoot, "RemoteView has been attached to another RemoteView. May only clone the root of a RemoteView hierarchy.");
        return new RemoteViews(this);
    }

    private final String $$robo$$android_widget_RemoteViews$getPackage() {
        return this.mApplication != null ? this.mApplication.packageName : null;
    }

    private final int $$robo$$android_widget_RemoteViews$getLayoutId() {
        return this.mLayoutId;
    }

    private final void $$robo$$android_widget_RemoteViews$setIsWidgetCollectionChild(boolean isWidgetCollectionChild) {
        this.mIsWidgetCollectionChild = isWidgetCollectionChild;
    }

    private final void $$robo$$android_widget_RemoteViews$setBitmapCache(BitmapCache bitmapCache) {
        this.mBitmapCache = bitmapCache;
        if (!this.hasLandscapeAndPortraitLayouts()) {
            if (this.mActions != null) {
                int count = this.mActions.size();
                for (int i = 0; i < count; ++i) {
                    this.mActions.get(i).setBitmapCache(bitmapCache);
                }
            }
        } else {
            this.mLandscape.setBitmapCache(bitmapCache);
            this.mPortrait.setBitmapCache(bitmapCache);
        }
    }

    private final int $$robo$$android_widget_RemoteViews$estimateMemoryUsage() {
        return this.mBitmapCache.getBitmapMemory();
    }

    private final void $$robo$$android_widget_RemoteViews$addAction(Action a) {
        if (this.hasLandscapeAndPortraitLayouts()) {
            throw new RuntimeException("RemoteViews specifying separate landscape and portrait layouts cannot be modified. Instead, fully configure the landscape and portrait layouts individually before constructing the combined layout.");
        }
        if (this.mActions == null) {
            this.mActions = new ArrayList();
        }
        this.mActions.add(a);
    }

    private final void $$robo$$android_widget_RemoteViews$addView(int viewId, RemoteViews nestedView) {
        this.addAction(nestedView == null ? new ViewGroupActionRemove(this, viewId) : new ViewGroupActionAdd(this, viewId, nestedView));
    }

    private final void $$robo$$android_widget_RemoteViews$addView(int viewId, RemoteViews nestedView, int index) {
        this.addAction(new ViewGroupActionAdd(this, viewId, nestedView, index));
    }

    private final void $$robo$$android_widget_RemoteViews$removeAllViews(int viewId) {
        this.addAction(new ViewGroupActionRemove(this, viewId));
    }

    private final void $$robo$$android_widget_RemoteViews$removeAllViewsExceptId(int viewId, int viewIdToKeep) {
        this.addAction(new ViewGroupActionRemove(this, viewId, viewIdToKeep));
    }

    private final void $$robo$$android_widget_RemoteViews$showNext(int viewId) {
        this.addAction(new ViewContentNavigation(this, viewId, true));
    }

    private final void $$robo$$android_widget_RemoteViews$showPrevious(int viewId) {
        this.addAction(new ViewContentNavigation(this, viewId, false));
    }

    private final void $$robo$$android_widget_RemoteViews$setDisplayedChild(int viewId, int childIndex) {
        this.setInt(viewId, "setDisplayedChild", childIndex);
    }

    private final void $$robo$$android_widget_RemoteViews$setViewVisibility(int viewId, int visibility) {
        this.setInt(viewId, "setVisibility", visibility);
    }

    private final void $$robo$$android_widget_RemoteViews$setTextViewText(int viewId, CharSequence text) {
        this.setCharSequence(viewId, "setText", text);
    }

    private final void $$robo$$android_widget_RemoteViews$setTextViewTextSize(int viewId, int units, float size) {
        this.addAction(new TextViewSizeAction(this, viewId, units, size));
    }

    private final void $$robo$$android_widget_RemoteViews$setTextViewCompoundDrawables(int viewId, int left, int top, int right, int bottom) {
        this.addAction(new TextViewDrawableAction(this, viewId, false, left, top, right, bottom));
    }

    private final void $$robo$$android_widget_RemoteViews$setTextViewCompoundDrawablesRelative(int viewId, int start, int top, int end, int bottom) {
        this.addAction(new TextViewDrawableAction(this, viewId, true, start, top, end, bottom));
    }

    private final void $$robo$$android_widget_RemoteViews$setTextViewCompoundDrawables(int viewId, Icon left, Icon top, Icon right, Icon bottom) {
        this.addAction(new TextViewDrawableAction(this, viewId, false, left, top, right, bottom));
    }

    private final void $$robo$$android_widget_RemoteViews$setTextViewCompoundDrawablesRelative(int viewId, Icon start, Icon top, Icon end, Icon bottom) {
        this.addAction(new TextViewDrawableAction(this, viewId, true, start, top, end, bottom));
    }

    private final void $$robo$$android_widget_RemoteViews$setImageViewResource(int viewId, int srcId) {
        this.setInt(viewId, "setImageResource", srcId);
    }

    private final void $$robo$$android_widget_RemoteViews$setImageViewUri(int viewId, Uri uri) {
        this.setUri(viewId, "setImageURI", uri);
    }

    private final void $$robo$$android_widget_RemoteViews$setImageViewBitmap(int viewId, Bitmap bitmap) {
        this.setBitmap(viewId, "setImageBitmap", bitmap);
    }

    private final void $$robo$$android_widget_RemoteViews$setImageViewIcon(int viewId, Icon icon) {
        this.setIcon(viewId, "setImageIcon", icon);
    }

    private final void $$robo$$android_widget_RemoteViews$setEmptyView(int viewId, int emptyViewId) {
        this.addAction(new SetEmptyView(this, viewId, emptyViewId));
    }

    private final void $$robo$$android_widget_RemoteViews$setChronometer(int viewId, long base, String format, boolean started) {
        this.setLong(viewId, "setBase", base);
        this.setString(viewId, "setFormat", format);
        this.setBoolean(viewId, "setStarted", started);
    }

    private final void $$robo$$android_widget_RemoteViews$setChronometerCountDown(int viewId, boolean isCountDown) {
        this.setBoolean(viewId, "setCountDown", isCountDown);
    }

    private final void $$robo$$android_widget_RemoteViews$setProgressBar(int viewId, int max, int progress, boolean indeterminate) {
        this.setBoolean(viewId, "setIndeterminate", indeterminate);
        if (!indeterminate) {
            this.setInt(viewId, "setMax", max);
            this.setInt(viewId, "setProgress", progress);
        }
    }

    private final void $$robo$$android_widget_RemoteViews$setOnClickPendingIntent(int viewId, PendingIntent pendingIntent) {
        this.addAction(new SetOnClickPendingIntent(this, viewId, pendingIntent));
    }

    private final void $$robo$$android_widget_RemoteViews$setPendingIntentTemplate(int viewId, PendingIntent pendingIntentTemplate) {
        this.addAction(new SetPendingIntentTemplate(this, viewId, pendingIntentTemplate));
    }

    private final void $$robo$$android_widget_RemoteViews$setOnClickFillInIntent(int viewId, Intent fillInIntent) {
        this.addAction(new SetOnClickFillInIntent(this, viewId, fillInIntent));
    }

    private final void $$robo$$android_widget_RemoteViews$setDrawableTint(int viewId, boolean targetBackground, int colorFilter, PorterDuff.Mode mode) {
        this.addAction(new SetDrawableTint(this, viewId, targetBackground, colorFilter, mode));
    }

    private final void $$robo$$android_widget_RemoteViews$setProgressTintList(int viewId, ColorStateList tint) {
        this.addAction(new ReflectionAction(this, viewId, "setProgressTintList", 15, tint));
    }

    private final void $$robo$$android_widget_RemoteViews$setProgressBackgroundTintList(int viewId, ColorStateList tint) {
        this.addAction(new ReflectionAction(this, viewId, "setProgressBackgroundTintList", 15, tint));
    }

    private final void $$robo$$android_widget_RemoteViews$setProgressIndeterminateTintList(int viewId, ColorStateList tint) {
        this.addAction(new ReflectionAction(this, viewId, "setIndeterminateTintList", 15, tint));
    }

    private final void $$robo$$android_widget_RemoteViews$setTextColor(int viewId, int color2) {
        this.setInt(viewId, "setTextColor", color2);
    }

    private final void $$robo$$android_widget_RemoteViews$setTextColor(int viewId, ColorStateList colors) {
        this.addAction(new ReflectionAction(this, viewId, "setTextColor", 15, colors));
    }

    @Deprecated
    private final void $$robo$$android_widget_RemoteViews$setRemoteAdapter(int appWidgetId, int viewId, Intent intent) {
        this.setRemoteAdapter(viewId, intent);
    }

    private final void $$robo$$android_widget_RemoteViews$setRemoteAdapter(int viewId, Intent intent) {
        this.addAction(new SetRemoteViewsAdapterIntent(this, viewId, intent));
    }

    private final void $$robo$$android_widget_RemoteViews$setRemoteAdapter(int viewId, ArrayList<RemoteViews> list, int viewTypeCount) {
        this.addAction(new SetRemoteViewsAdapterList(this, viewId, list, viewTypeCount));
    }

    private final void $$robo$$android_widget_RemoteViews$setScrollPosition(int viewId, int position) {
        this.setInt(viewId, "smoothScrollToPosition", position);
    }

    private final void $$robo$$android_widget_RemoteViews$setRelativeScrollPosition(int viewId, int offset) {
        this.setInt(viewId, "smoothScrollByOffset", offset);
    }

    private final void $$robo$$android_widget_RemoteViews$setViewPadding(int viewId, int left, int top, int right, int bottom) {
        this.addAction(new ViewPaddingAction(this, viewId, left, top, right, bottom));
    }

    private final void $$robo$$android_widget_RemoteViews$setViewLayoutMarginEndDimen(int viewId, int endMarginDimen) {
        this.addAction(new LayoutParamAction(viewId, 1, endMarginDimen));
    }

    private final void $$robo$$android_widget_RemoteViews$setViewLayoutMarginEnd(int viewId, int endMargin) {
        this.addAction(new LayoutParamAction(viewId, 4, endMargin));
    }

    private final void $$robo$$android_widget_RemoteViews$setViewLayoutMarginBottomDimen(int viewId, int bottomMarginDimen) {
        this.addAction(new LayoutParamAction(viewId, 3, bottomMarginDimen));
    }

    private final void $$robo$$android_widget_RemoteViews$setViewLayoutWidth(int viewId, int layoutWidth) {
        if (layoutWidth != 0 && layoutWidth != -1 && layoutWidth != -2) {
            throw new IllegalArgumentException("Only supports 0, WRAP_CONTENT and MATCH_PARENT");
        }
        this.mActions.add(new LayoutParamAction(viewId, 2, layoutWidth));
    }

    private final void $$robo$$android_widget_RemoteViews$setBoolean(int viewId, String methodName, boolean value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 1, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setByte(int viewId, String methodName, byte value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 2, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setShort(int viewId, String methodName, short value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 3, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setInt(int viewId, String methodName, int value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 4, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setColorStateList(int viewId, String methodName, ColorStateList value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 15, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setLong(int viewId, String methodName, long value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 5, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setFloat(int viewId, String methodName, float value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 6, Float.valueOf(value)));
    }

    private final void $$robo$$android_widget_RemoteViews$setDouble(int viewId, String methodName, double value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 7, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setChar(int viewId, String methodName, char value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 8, Character.valueOf(value)));
    }

    private final void $$robo$$android_widget_RemoteViews$setString(int viewId, String methodName, String value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 9, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setCharSequence(int viewId, String methodName, CharSequence value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 10, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setUri(int viewId, String methodName, Uri value) {
        if (value != null) {
            value = value.getCanonicalUri();
            if (StrictMode.vmFileUriExposureEnabled()) {
                value.checkFileUriExposed("RemoteViews.setUri()");
            }
        }
        this.addAction(new ReflectionAction(this, viewId, methodName, 11, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setBitmap(int viewId, String methodName, Bitmap value) {
        this.addAction(new BitmapReflectionAction(this, viewId, methodName, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setBundle(int viewId, String methodName, Bundle value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 13, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setIntent(int viewId, String methodName, Intent value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 14, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setIcon(int viewId, String methodName, Icon value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 16, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setContentDescription(int viewId, CharSequence contentDescription) {
        this.setCharSequence(viewId, "setContentDescription", contentDescription);
    }

    private final void $$robo$$android_widget_RemoteViews$setAccessibilityTraversalBefore(int viewId, int nextId) {
        this.setInt(viewId, "setAccessibilityTraversalBefore", nextId);
    }

    private final void $$robo$$android_widget_RemoteViews$setAccessibilityTraversalAfter(int viewId, int nextId) {
        this.setInt(viewId, "setAccessibilityTraversalAfter", nextId);
    }

    private final void $$robo$$android_widget_RemoteViews$setLabelFor(int viewId, int labeledId) {
        this.setInt(viewId, "setLabelFor", labeledId);
    }

    private final RemoteViews $$robo$$android_widget_RemoteViews$getRemoteViewsToApply(Context context) {
        if (this.hasLandscapeAndPortraitLayouts()) {
            int orientation = context.getResources().getConfiguration().orientation;
            if (orientation == 2) {
                return this.mLandscape;
            }
            return this.mPortrait;
        }
        return this;
    }

    private final void $$robo$$android_widget_RemoteViews$setApplyTheme(int themeResId) {
        this.mApplyThemeResId = themeResId;
    }

    private final View $$robo$$android_widget_RemoteViews$apply(Context context, ViewGroup parent) {
        return this.apply(context, parent, null);
    }

    private final View $$robo$$android_widget_RemoteViews$apply(Context context, ViewGroup parent, OnClickHandler handler) {
        RemoteViews rvToApply = this.getRemoteViewsToApply(context);
        View result = this.inflateView(context, rvToApply, parent);
        RemoteViews.loadTransitionOverride(context, handler);
        rvToApply.performApply(result, parent, handler);
        return result;
    }

    private final View $$robo$$android_widget_RemoteViews$inflateView(Context context, RemoteViews rv, ViewGroup parent) {
        Context contextForResources = this.getContextForResources(context);
        ContextWrapper inflationContext = new RemoteViewsContextWrapper(context, contextForResources);
        if (this.mApplyThemeResId != 0) {
            inflationContext = new ContextThemeWrapper((Context)inflationContext, this.mApplyThemeResId);
        }
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        inflater = inflater.cloneInContext(inflationContext);
        inflater.setFilter(this);
        View v = inflater.inflate(rv.getLayoutId(), parent, false);
        v.setTagInternal(16908312, rv.getLayoutId());
        return v;
    }

    private static final void $$robo$$android_widget_RemoteViews$loadTransitionOverride(Context context, OnClickHandler handler) {
        if (handler != null && context.getResources().getBoolean(17957001)) {
            TypedArray windowStyle = context.getTheme().obtainStyledAttributes(R.styleable.Window);
            int windowAnimations = windowStyle.getResourceId(8, 0);
            TypedArray windowAnimationStyle = context.obtainStyledAttributes(windowAnimations, R.styleable.WindowAnimation);
            handler.setEnterAnimationId(windowAnimationStyle.getResourceId(26, 0));
            windowStyle.recycle();
            windowAnimationStyle.recycle();
        }
    }

    private final CancellationSignal $$robo$$android_widget_RemoteViews$applyAsync(Context context, ViewGroup parent, Executor executor, OnViewAppliedListener listener) {
        return this.applyAsync(context, parent, executor, listener, null);
    }

    private final CancellationSignal $$robo$$android_widget_RemoteViews$startTaskOnExecutor(AsyncApplyTask task, Executor executor) {
        CancellationSignal cancelSignal = new CancellationSignal();
        cancelSignal.setOnCancelListener(task);
        task.executeOnExecutor(executor == null ? AsyncTask.THREAD_POOL_EXECUTOR : executor, new Void[0]);
        return cancelSignal;
    }

    private final CancellationSignal $$robo$$android_widget_RemoteViews$applyAsync(Context context, ViewGroup parent, Executor executor, OnViewAppliedListener listener, OnClickHandler handler) {
        return this.startTaskOnExecutor(this.getAsyncApplyTask(context, parent, listener, handler), executor);
    }

    private final AsyncApplyTask $$robo$$android_widget_RemoteViews$getAsyncApplyTask(Context context, ViewGroup parent, OnViewAppliedListener listener, OnClickHandler handler) {
        return new AsyncApplyTask(this, this.getRemoteViewsToApply(context), parent, context, listener, handler, null);
    }

    private final void $$robo$$android_widget_RemoteViews$reapply(Context context, View v) {
        this.reapply(context, v, null);
    }

    private final void $$robo$$android_widget_RemoteViews$reapply(Context context, View v, OnClickHandler handler) {
        RemoteViews rvToApply = this.getRemoteViewsToApply(context);
        if (this.hasLandscapeAndPortraitLayouts() && ((Integer)v.getTag(16908312)).intValue() != rvToApply.getLayoutId()) {
            throw new RuntimeException("Attempting to re-apply RemoteViews to a view that that does not share the same root layout id.");
        }
        rvToApply.performApply(v, (ViewGroup)v.getParent(), handler);
    }

    private final CancellationSignal $$robo$$android_widget_RemoteViews$reapplyAsync(Context context, View v, Executor executor, OnViewAppliedListener listener) {
        return this.reapplyAsync(context, v, executor, listener, null);
    }

    private final CancellationSignal $$robo$$android_widget_RemoteViews$reapplyAsync(Context context, View v, Executor executor, OnViewAppliedListener listener, OnClickHandler handler) {
        RemoteViews rvToApply = this.getRemoteViewsToApply(context);
        if (this.hasLandscapeAndPortraitLayouts() && ((Integer)v.getTag(16908312)).intValue() != rvToApply.getLayoutId()) {
            throw new RuntimeException("Attempting to re-apply RemoteViews to a view that that does not share the same root layout id.");
        }
        return this.startTaskOnExecutor(new AsyncApplyTask(this, rvToApply, (ViewGroup)v.getParent(), context, listener, handler, v), executor);
    }

    private final void $$robo$$android_widget_RemoteViews$performApply(View v, ViewGroup parent, OnClickHandler handler) {
        if (this.mActions != null) {
            handler = handler == null ? DEFAULT_ON_CLICK_HANDLER : handler;
            int count = this.mActions.size();
            for (int i = 0; i < count; ++i) {
                Action a = this.mActions.get(i);
                a.apply(v, parent, handler);
            }
        }
    }

    private final boolean $$robo$$android_widget_RemoteViews$prefersAsyncApply() {
        if (this.mActions != null) {
            int count = this.mActions.size();
            for (int i = 0; i < count; ++i) {
                if (!this.mActions.get(i).prefersAsyncApply()) continue;
                return true;
            }
        }
        return false;
    }

    private final Context $$robo$$android_widget_RemoteViews$getContextForResources(Context context) {
        if (this.mApplication != null) {
            if (context.getUserId() == UserHandle.getUserId(this.mApplication.uid) && context.getPackageName().equals(this.mApplication.packageName)) {
                return context;
            }
            try {
                return context.createApplicationContext(this.mApplication, 4);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e("RemoteViews", "Package name " + this.mApplication.packageName + " not found");
            }
        }
        return context;
    }

    private final int $$robo$$android_widget_RemoteViews$getSequenceNumber() {
        return this.mActions == null ? 0 : this.mActions.size();
    }

    private final boolean $$robo$$android_widget_RemoteViews$onLoadClass(Class clazz) {
        return clazz.isAnnotationPresent(RemoteView.class);
    }

    private final int $$robo$$android_widget_RemoteViews$describeContents() {
        return 0;
    }

    private final void $$robo$$android_widget_RemoteViews$writeToParcel(Parcel dest, int flags) {
        if (!this.hasLandscapeAndPortraitLayouts()) {
            dest.writeInt(0);
            if (this.mIsRoot) {
                this.mBitmapCache.writeBitmapsToParcel(dest, flags);
            }
            if (!this.mIsRoot && (flags & 2) != 0) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                this.mApplication.writeToParcel(dest, flags);
            }
            dest.writeInt(this.mLayoutId);
            dest.writeInt(this.mIsWidgetCollectionChild ? 1 : 0);
            this.writeActionsToParcel(dest);
        } else {
            dest.writeInt(1);
            if (this.mIsRoot) {
                this.mBitmapCache.writeBitmapsToParcel(dest, flags);
            }
            this.mLandscape.writeToParcel(dest, flags);
            this.mPortrait.writeToParcel(dest, flags | 2);
        }
        dest.writeInt(this.mReapplyDisallowed ? 1 : 0);
    }

    private final void $$robo$$android_widget_RemoteViews$writeActionsToParcel(Parcel parcel) {
        int count = this.mActions != null ? this.mActions.size() : 0;
        parcel.writeInt(count);
        for (int i = 0; i < count; ++i) {
            Action a = this.mActions.get(i);
            parcel.writeInt(a.getActionTag());
            a.writeToParcel(parcel, a.hasSameAppInfo(this.mApplication) ? 2 : 0);
        }
    }

    private static final ApplicationInfo $$robo$$android_widget_RemoteViews$getApplicationInfo(String packageName, int userId) {
        if (packageName == null) {
            return null;
        }
        Application application = ActivityThread.currentApplication();
        if (application == null) {
            throw new IllegalStateException("Cannot create remote views out of an aplication.");
        }
        ApplicationInfo applicationInfo = application.getApplicationInfo();
        if (UserHandle.getUserId(applicationInfo.uid) != userId || !applicationInfo.packageName.equals(packageName)) {
            try {
                Context context = application.getBaseContext().createPackageContextAsUser(packageName, 0, new UserHandle(userId));
                applicationInfo = context.getApplicationInfo();
            }
            catch (PackageManager.NameNotFoundException nnfe) {
                throw new IllegalArgumentException("No such package " + packageName);
            }
        }
        return applicationInfo;
    }

    private final boolean $$robo$$android_widget_RemoteViews$hasSameAppInfo(ApplicationInfo info) {
        return this.mApplication.packageName.equals(info.packageName) && this.mApplication.uid == info.uid;
    }

    private /* synthetic */ void $$robo$$android_widget_RemoteViews$__constructor__(Parcel x0, BitmapCache x1, ApplicationInfo x2, int x3, Map x4, 1 x5) {
    }

    static void __staticInitializer__() {
        DEFAULT_ON_CLICK_HANDLER = new OnClickHandler();
        sMethods = new ArrayMap();
        sLookupKey = new MethodKey();
        ACTION_NOOP = new ShadowedObject(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_widget_RemoteViews_1$__constructor__() {
            }

            private final void $$robo$$android_widget_RemoteViews_1$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            }

            private void __constructor__() {
                this.$$robo$$android_widget_RemoteViews_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_1$__constructor__(), 0, this);
            }

            @Override
            public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
                InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_1$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        CREATOR = new Parcelable.Creator<RemoteViews>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_widget_RemoteViews_2$__constructor__() {
            }

            private final RemoteViews $$robo$$android_widget_RemoteViews_2$createFromParcel(Parcel parcel) {
                return new RemoteViews(parcel);
            }

            private final RemoteViews[] $$robo$$android_widget_RemoteViews_2$newArray(int size) {
                return new RemoteViews[size];
            }

            private void __constructor__() {
                this.$$robo$$android_widget_RemoteViews_2$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_2$__constructor__(), 0, this);
            }

            @Override
            public RemoteViews createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_RemoteViews_2$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public RemoteViews[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_widget_RemoteViews_2$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public void setRemoteInputs(int n, RemoteInput[] remoteInputArray) {
        InvokeDynamicSupport.bootstrap("setRemoteInputs", $$robo$$android_widget_RemoteViews$setRemoteInputs(int android.app.RemoteInput[] ), 0, this, n, remoteInputArray);
    }

    public void reduceImageSizes(int n, int n2) {
        InvokeDynamicSupport.bootstrap("reduceImageSizes", $$robo$$android_widget_RemoteViews$reduceImageSizes(int int ), 0, this, n, n2);
    }

    public void overrideTextColors(int n) {
        InvokeDynamicSupport.bootstrap("overrideTextColors", $$robo$$android_widget_RemoteViews$overrideTextColors(int ), 0, this, n);
    }

    public void setReapplyDisallowed() {
        InvokeDynamicSupport.bootstrap("setReapplyDisallowed", $$robo$$android_widget_RemoteViews$setReapplyDisallowed(), 0, this);
    }

    public boolean isReapplyDisallowed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isReapplyDisallowed", $$robo$$android_widget_RemoteViews$isReapplyDisallowed(), 0, this);
    }

    public void mergeRemoteViews(RemoteViews remoteViews) {
        InvokeDynamicSupport.bootstrap("mergeRemoteViews", $$robo$$android_widget_RemoteViews$mergeRemoteViews(android.widget.RemoteViews ), 0, this, remoteViews);
    }

    public void visitUris(Consumer<Uri> consumer) {
        InvokeDynamicSupport.bootstrap("visitUris", $$robo$$android_widget_RemoteViews$visitUris(java.util.function.Consumer<android.net.Uri> ), 0, this, consumer);
    }

    private static void visitIconUri(Icon icon, Consumer<Uri> consumer) {
        InvokeDynamicSupport.bootstrapStatic("visitIconUri", $$robo$$android_widget_RemoteViews$visitIconUri(android.graphics.drawable.Icon java.util.function.Consumer<android.net.Uri> ), 0, (Icon)icon, consumer);
    }

    private static Rect getSourceBounds(View view) {
        return InvokeDynamicSupport.bootstrapStatic("getSourceBounds", $$robo$$android_widget_RemoteViews$getSourceBounds(android.view.View ), 0, (View)view);
    }

    private MethodHandle getMethod(View view, String string2, Class<?> clazz, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getMethod", $$robo$$android_widget_RemoteViews$getMethod(android.view.View java.lang.String java.lang.Class<?> boolean ), 0, this, view, string2, clazz, bl);
    }

    private static String getParameters(Class<?> clazz) {
        return InvokeDynamicSupport.bootstrapStatic("getParameters", $$robo$$android_widget_RemoteViews$getParameters(java.lang.Class<?> ), 0, clazz);
    }

    private void configureRemoteViewsAsChild(RemoteViews remoteViews) {
        InvokeDynamicSupport.bootstrap("configureRemoteViewsAsChild", $$robo$$android_widget_RemoteViews$configureRemoteViewsAsChild(android.widget.RemoteViews ), 0, this, remoteViews);
    }

    void setNotRoot() {
        InvokeDynamicSupport.bootstrap("setNotRoot", $$robo$$android_widget_RemoteViews$setNotRoot(), 0, this);
    }

    private void __constructor__(String string2, int n) {
        this.$$robo$$android_widget_RemoteViews$__constructor__(string2, n);
    }

    public RemoteViews(String string2, int n) {
        this(RemoteViews.getApplicationInfo(string2, UserHandle.myUserId()), n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews$__constructor__(java.lang.String int ), 0, this, string2, n);
    }

    private void __constructor__(String string2, int n, int n2) {
        this.$$robo$$android_widget_RemoteViews$__constructor__(string2, n, n2);
    }

    public RemoteViews(String string2, int n, int n2) {
        this(RemoteViews.getApplicationInfo(string2, n), n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
    }

    private void __constructor__(ApplicationInfo applicationInfo, int n) {
        this.$$robo$$android_widget_RemoteViews$__constructor__(applicationInfo, n);
    }

    protected RemoteViews(ApplicationInfo applicationInfo, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews$__constructor__(android.content.pm.ApplicationInfo int ), 0, this, applicationInfo, n);
    }

    private boolean hasLandscapeAndPortraitLayouts() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasLandscapeAndPortraitLayouts", $$robo$$android_widget_RemoteViews$hasLandscapeAndPortraitLayouts(), 0, this);
    }

    private void __constructor__(RemoteViews remoteViews, RemoteViews remoteViews2) {
        this.$$robo$$android_widget_RemoteViews$__constructor__(remoteViews, remoteViews2);
    }

    public RemoteViews(RemoteViews remoteViews, RemoteViews remoteViews2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews$__constructor__(android.widget.RemoteViews android.widget.RemoteViews ), 0, this, remoteViews, remoteViews2);
    }

    private void __constructor__(RemoteViews remoteViews) {
        this.$$robo$$android_widget_RemoteViews$__constructor__(remoteViews);
    }

    public RemoteViews(RemoteViews remoteViews) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews$__constructor__(android.widget.RemoteViews ), 0, this, remoteViews);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_widget_RemoteViews$__constructor__(parcel);
    }

    public RemoteViews(Parcel parcel) {
        this(parcel, null, null, 0, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    private void __constructor__(Parcel parcel, BitmapCache bitmapCache, ApplicationInfo applicationInfo, int n, Map<Class, Object> map) {
        this.$$robo$$android_widget_RemoteViews$__constructor__(parcel, bitmapCache, applicationInfo, n, map);
    }

    private RemoteViews(Parcel parcel, BitmapCache bitmapCache, ApplicationInfo applicationInfo, int n, Map<Class, Object> map) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews$__constructor__(android.os.Parcel android.widget.RemoteViews$BitmapCache android.content.pm.ApplicationInfo int java.util.Map<java.lang.Class, java.lang.Object> ), 0, this, parcel, bitmapCache, applicationInfo, n, map);
    }

    private void readActionsFromParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("readActionsFromParcel", $$robo$$android_widget_RemoteViews$readActionsFromParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private Action getActionFromParcel(Parcel parcel, int n) {
        return InvokeDynamicSupport.bootstrap("getActionFromParcel", $$robo$$android_widget_RemoteViews$getActionFromParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Deprecated
    public RemoteViews clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_widget_RemoteViews$clone(), 0, this);
    }

    public String getPackage() {
        return InvokeDynamicSupport.bootstrap("getPackage", $$robo$$android_widget_RemoteViews$getPackage(), 0, this);
    }

    public int getLayoutId() {
        return (int)InvokeDynamicSupport.bootstrap("getLayoutId", $$robo$$android_widget_RemoteViews$getLayoutId(), 0, this);
    }

    void setIsWidgetCollectionChild(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsWidgetCollectionChild", $$robo$$android_widget_RemoteViews$setIsWidgetCollectionChild(boolean ), 0, this, bl);
    }

    private void setBitmapCache(BitmapCache bitmapCache) {
        InvokeDynamicSupport.bootstrap("setBitmapCache", $$robo$$android_widget_RemoteViews$setBitmapCache(android.widget.RemoteViews$BitmapCache ), 0, this, bitmapCache);
    }

    public int estimateMemoryUsage() {
        return (int)InvokeDynamicSupport.bootstrap("estimateMemoryUsage", $$robo$$android_widget_RemoteViews$estimateMemoryUsage(), 0, this);
    }

    private void addAction(Action action) {
        InvokeDynamicSupport.bootstrap("addAction", $$robo$$android_widget_RemoteViews$addAction(android.widget.RemoteViews$Action ), 0, this, action);
    }

    public void addView(int n, RemoteViews remoteViews) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_RemoteViews$addView(int android.widget.RemoteViews ), 0, this, n, remoteViews);
    }

    public void addView(int n, RemoteViews remoteViews, int n2) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_RemoteViews$addView(int android.widget.RemoteViews int ), 0, this, n, remoteViews, n2);
    }

    public void removeAllViews(int n) {
        InvokeDynamicSupport.bootstrap("removeAllViews", $$robo$$android_widget_RemoteViews$removeAllViews(int ), 0, this, n);
    }

    public void removeAllViewsExceptId(int n, int n2) {
        InvokeDynamicSupport.bootstrap("removeAllViewsExceptId", $$robo$$android_widget_RemoteViews$removeAllViewsExceptId(int int ), 0, this, n, n2);
    }

    public void showNext(int n) {
        InvokeDynamicSupport.bootstrap("showNext", $$robo$$android_widget_RemoteViews$showNext(int ), 0, this, n);
    }

    public void showPrevious(int n) {
        InvokeDynamicSupport.bootstrap("showPrevious", $$robo$$android_widget_RemoteViews$showPrevious(int ), 0, this, n);
    }

    public void setDisplayedChild(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setDisplayedChild", $$robo$$android_widget_RemoteViews$setDisplayedChild(int int ), 0, this, n, n2);
    }

    public void setViewVisibility(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setViewVisibility", $$robo$$android_widget_RemoteViews$setViewVisibility(int int ), 0, this, n, n2);
    }

    public void setTextViewText(int n, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setTextViewText", $$robo$$android_widget_RemoteViews$setTextViewText(int java.lang.CharSequence ), 0, this, n, charSequence);
    }

    public void setTextViewTextSize(int n, int n2, float f) {
        InvokeDynamicSupport.bootstrap("setTextViewTextSize", $$robo$$android_widget_RemoteViews$setTextViewTextSize(int int float ), 0, this, n, n2, f);
    }

    public void setTextViewCompoundDrawables(int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("setTextViewCompoundDrawables", $$robo$$android_widget_RemoteViews$setTextViewCompoundDrawables(int int int int int ), 0, this, n, n2, n3, n4, n5);
    }

    public void setTextViewCompoundDrawablesRelative(int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("setTextViewCompoundDrawablesRelative", $$robo$$android_widget_RemoteViews$setTextViewCompoundDrawablesRelative(int int int int int ), 0, this, n, n2, n3, n4, n5);
    }

    public void setTextViewCompoundDrawables(int n, Icon icon, Icon icon2, Icon icon3, Icon icon4) {
        InvokeDynamicSupport.bootstrap("setTextViewCompoundDrawables", $$robo$$android_widget_RemoteViews$setTextViewCompoundDrawables(int android.graphics.drawable.Icon android.graphics.drawable.Icon android.graphics.drawable.Icon android.graphics.drawable.Icon ), 0, this, n, icon, icon2, icon3, icon4);
    }

    public void setTextViewCompoundDrawablesRelative(int n, Icon icon, Icon icon2, Icon icon3, Icon icon4) {
        InvokeDynamicSupport.bootstrap("setTextViewCompoundDrawablesRelative", $$robo$$android_widget_RemoteViews$setTextViewCompoundDrawablesRelative(int android.graphics.drawable.Icon android.graphics.drawable.Icon android.graphics.drawable.Icon android.graphics.drawable.Icon ), 0, this, n, icon, icon2, icon3, icon4);
    }

    public void setImageViewResource(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setImageViewResource", $$robo$$android_widget_RemoteViews$setImageViewResource(int int ), 0, this, n, n2);
    }

    public void setImageViewUri(int n, Uri uri) {
        InvokeDynamicSupport.bootstrap("setImageViewUri", $$robo$$android_widget_RemoteViews$setImageViewUri(int android.net.Uri ), 0, this, n, uri);
    }

    public void setImageViewBitmap(int n, Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("setImageViewBitmap", $$robo$$android_widget_RemoteViews$setImageViewBitmap(int android.graphics.Bitmap ), 0, this, n, bitmap);
    }

    public void setImageViewIcon(int n, Icon icon) {
        InvokeDynamicSupport.bootstrap("setImageViewIcon", $$robo$$android_widget_RemoteViews$setImageViewIcon(int android.graphics.drawable.Icon ), 0, this, n, icon);
    }

    public void setEmptyView(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setEmptyView", $$robo$$android_widget_RemoteViews$setEmptyView(int int ), 0, this, n, n2);
    }

    public void setChronometer(int n, long l, String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setChronometer", $$robo$$android_widget_RemoteViews$setChronometer(int long java.lang.String boolean ), 0, this, n, l, string2, bl);
    }

    public void setChronometerCountDown(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setChronometerCountDown", $$robo$$android_widget_RemoteViews$setChronometerCountDown(int boolean ), 0, this, n, bl);
    }

    public void setProgressBar(int n, int n2, int n3, boolean bl) {
        InvokeDynamicSupport.bootstrap("setProgressBar", $$robo$$android_widget_RemoteViews$setProgressBar(int int int boolean ), 0, this, n, n2, n3, bl);
    }

    public void setOnClickPendingIntent(int n, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("setOnClickPendingIntent", $$robo$$android_widget_RemoteViews$setOnClickPendingIntent(int android.app.PendingIntent ), 0, this, n, pendingIntent);
    }

    public void setPendingIntentTemplate(int n, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("setPendingIntentTemplate", $$robo$$android_widget_RemoteViews$setPendingIntentTemplate(int android.app.PendingIntent ), 0, this, n, pendingIntent);
    }

    public void setOnClickFillInIntent(int n, Intent intent) {
        InvokeDynamicSupport.bootstrap("setOnClickFillInIntent", $$robo$$android_widget_RemoteViews$setOnClickFillInIntent(int android.content.Intent ), 0, this, n, intent);
    }

    public void setDrawableTint(int n, boolean bl, int n2, PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setDrawableTint", $$robo$$android_widget_RemoteViews$setDrawableTint(int boolean int android.graphics.PorterDuff$Mode ), 0, this, n, bl, n2, mode);
    }

    public void setProgressTintList(int n, ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setProgressTintList", $$robo$$android_widget_RemoteViews$setProgressTintList(int android.content.res.ColorStateList ), 0, this, n, colorStateList);
    }

    public void setProgressBackgroundTintList(int n, ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setProgressBackgroundTintList", $$robo$$android_widget_RemoteViews$setProgressBackgroundTintList(int android.content.res.ColorStateList ), 0, this, n, colorStateList);
    }

    public void setProgressIndeterminateTintList(int n, ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setProgressIndeterminateTintList", $$robo$$android_widget_RemoteViews$setProgressIndeterminateTintList(int android.content.res.ColorStateList ), 0, this, n, colorStateList);
    }

    public void setTextColor(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setTextColor", $$robo$$android_widget_RemoteViews$setTextColor(int int ), 0, this, n, n2);
    }

    public void setTextColor(int n, ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTextColor", $$robo$$android_widget_RemoteViews$setTextColor(int android.content.res.ColorStateList ), 0, this, n, colorStateList);
    }

    @Deprecated
    public void setRemoteAdapter(int n, int n2, Intent intent) {
        InvokeDynamicSupport.bootstrap("setRemoteAdapter", $$robo$$android_widget_RemoteViews$setRemoteAdapter(int int android.content.Intent ), 0, this, n, n2, intent);
    }

    public void setRemoteAdapter(int n, Intent intent) {
        InvokeDynamicSupport.bootstrap("setRemoteAdapter", $$robo$$android_widget_RemoteViews$setRemoteAdapter(int android.content.Intent ), 0, this, n, intent);
    }

    public void setRemoteAdapter(int n, ArrayList<RemoteViews> arrayList, int n2) {
        InvokeDynamicSupport.bootstrap("setRemoteAdapter", $$robo$$android_widget_RemoteViews$setRemoteAdapter(int java.util.ArrayList<android.widget.RemoteViews> int ), 0, this, n, arrayList, n2);
    }

    public void setScrollPosition(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setScrollPosition", $$robo$$android_widget_RemoteViews$setScrollPosition(int int ), 0, this, n, n2);
    }

    public void setRelativeScrollPosition(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setRelativeScrollPosition", $$robo$$android_widget_RemoteViews$setRelativeScrollPosition(int int ), 0, this, n, n2);
    }

    public void setViewPadding(int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("setViewPadding", $$robo$$android_widget_RemoteViews$setViewPadding(int int int int int ), 0, this, n, n2, n3, n4, n5);
    }

    public void setViewLayoutMarginEndDimen(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setViewLayoutMarginEndDimen", $$robo$$android_widget_RemoteViews$setViewLayoutMarginEndDimen(int int ), 0, this, n, n2);
    }

    public void setViewLayoutMarginEnd(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setViewLayoutMarginEnd", $$robo$$android_widget_RemoteViews$setViewLayoutMarginEnd(int int ), 0, this, n, n2);
    }

    public void setViewLayoutMarginBottomDimen(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setViewLayoutMarginBottomDimen", $$robo$$android_widget_RemoteViews$setViewLayoutMarginBottomDimen(int int ), 0, this, n, n2);
    }

    public void setViewLayoutWidth(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setViewLayoutWidth", $$robo$$android_widget_RemoteViews$setViewLayoutWidth(int int ), 0, this, n, n2);
    }

    public void setBoolean(int n, String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setBoolean", $$robo$$android_widget_RemoteViews$setBoolean(int java.lang.String boolean ), 0, this, n, string2, bl);
    }

    public void setByte(int n, String string2, byte by) {
        InvokeDynamicSupport.bootstrap("setByte", $$robo$$android_widget_RemoteViews$setByte(int java.lang.String byte ), 0, this, n, string2, by);
    }

    public void setShort(int n, String string2, short s) {
        InvokeDynamicSupport.bootstrap("setShort", $$robo$$android_widget_RemoteViews$setShort(int java.lang.String short ), 0, this, n, string2, s);
    }

    public void setInt(int n, String string2, int n2) {
        InvokeDynamicSupport.bootstrap("setInt", $$robo$$android_widget_RemoteViews$setInt(int java.lang.String int ), 0, this, n, string2, n2);
    }

    public void setColorStateList(int n, String string2, ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setColorStateList", $$robo$$android_widget_RemoteViews$setColorStateList(int java.lang.String android.content.res.ColorStateList ), 0, this, n, string2, colorStateList);
    }

    public void setLong(int n, String string2, long l) {
        InvokeDynamicSupport.bootstrap("setLong", $$robo$$android_widget_RemoteViews$setLong(int java.lang.String long ), 0, this, n, string2, l);
    }

    public void setFloat(int n, String string2, float f) {
        InvokeDynamicSupport.bootstrap("setFloat", $$robo$$android_widget_RemoteViews$setFloat(int java.lang.String float ), 0, this, n, string2, f);
    }

    public void setDouble(int n, String string2, double d) {
        InvokeDynamicSupport.bootstrap("setDouble", $$robo$$android_widget_RemoteViews$setDouble(int java.lang.String double ), 0, this, n, string2, d);
    }

    public void setChar(int n, String string2, char c) {
        InvokeDynamicSupport.bootstrap("setChar", $$robo$$android_widget_RemoteViews$setChar(int java.lang.String char ), 0, this, n, string2, c);
    }

    public void setString(int n, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setString", $$robo$$android_widget_RemoteViews$setString(int java.lang.String java.lang.String ), 0, this, n, string2, string3);
    }

    public void setCharSequence(int n, String string2, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setCharSequence", $$robo$$android_widget_RemoteViews$setCharSequence(int java.lang.String java.lang.CharSequence ), 0, this, n, string2, charSequence);
    }

    public void setUri(int n, String string2, Uri uri) {
        InvokeDynamicSupport.bootstrap("setUri", $$robo$$android_widget_RemoteViews$setUri(int java.lang.String android.net.Uri ), 0, this, n, string2, uri);
    }

    public void setBitmap(int n, String string2, Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("setBitmap", $$robo$$android_widget_RemoteViews$setBitmap(int java.lang.String android.graphics.Bitmap ), 0, this, n, string2, bitmap);
    }

    public void setBundle(int n, String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setBundle", $$robo$$android_widget_RemoteViews$setBundle(int java.lang.String android.os.Bundle ), 0, this, n, string2, bundle);
    }

    public void setIntent(int n, String string2, Intent intent) {
        InvokeDynamicSupport.bootstrap("setIntent", $$robo$$android_widget_RemoteViews$setIntent(int java.lang.String android.content.Intent ), 0, this, n, string2, intent);
    }

    public void setIcon(int n, String string2, Icon icon) {
        InvokeDynamicSupport.bootstrap("setIcon", $$robo$$android_widget_RemoteViews$setIcon(int java.lang.String android.graphics.drawable.Icon ), 0, this, n, string2, icon);
    }

    public void setContentDescription(int n, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setContentDescription", $$robo$$android_widget_RemoteViews$setContentDescription(int java.lang.CharSequence ), 0, this, n, charSequence);
    }

    public void setAccessibilityTraversalBefore(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setAccessibilityTraversalBefore", $$robo$$android_widget_RemoteViews$setAccessibilityTraversalBefore(int int ), 0, this, n, n2);
    }

    public void setAccessibilityTraversalAfter(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setAccessibilityTraversalAfter", $$robo$$android_widget_RemoteViews$setAccessibilityTraversalAfter(int int ), 0, this, n, n2);
    }

    public void setLabelFor(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setLabelFor", $$robo$$android_widget_RemoteViews$setLabelFor(int int ), 0, this, n, n2);
    }

    private RemoteViews getRemoteViewsToApply(Context context) {
        return InvokeDynamicSupport.bootstrap("getRemoteViewsToApply", $$robo$$android_widget_RemoteViews$getRemoteViewsToApply(android.content.Context ), 0, this, context);
    }

    public void setApplyTheme(int n) {
        InvokeDynamicSupport.bootstrap("setApplyTheme", $$robo$$android_widget_RemoteViews$setApplyTheme(int ), 0, this, n);
    }

    public View apply(Context context, ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews$apply(android.content.Context android.view.ViewGroup ), 0, this, context, viewGroup);
    }

    public View apply(Context context, ViewGroup viewGroup, OnClickHandler onClickHandler) {
        return InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews$apply(android.content.Context android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, context, viewGroup, onClickHandler);
    }

    private View inflateView(Context context, RemoteViews remoteViews, ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("inflateView", $$robo$$android_widget_RemoteViews$inflateView(android.content.Context android.widget.RemoteViews android.view.ViewGroup ), 0, this, context, remoteViews, viewGroup);
    }

    private static void loadTransitionOverride(Context context, OnClickHandler onClickHandler) {
        InvokeDynamicSupport.bootstrapStatic("loadTransitionOverride", $$robo$$android_widget_RemoteViews$loadTransitionOverride(android.content.Context android.widget.RemoteViews$OnClickHandler ), 0, (Context)context, (OnClickHandler)onClickHandler);
    }

    public CancellationSignal applyAsync(Context context, ViewGroup viewGroup, Executor executor, OnViewAppliedListener onViewAppliedListener) {
        return InvokeDynamicSupport.bootstrap("applyAsync", $$robo$$android_widget_RemoteViews$applyAsync(android.content.Context android.view.ViewGroup java.util.concurrent.Executor android.widget.RemoteViews$OnViewAppliedListener ), 0, this, context, viewGroup, executor, onViewAppliedListener);
    }

    private CancellationSignal startTaskOnExecutor(AsyncApplyTask asyncApplyTask, Executor executor) {
        return InvokeDynamicSupport.bootstrap("startTaskOnExecutor", $$robo$$android_widget_RemoteViews$startTaskOnExecutor(android.widget.RemoteViews$AsyncApplyTask java.util.concurrent.Executor ), 0, this, asyncApplyTask, executor);
    }

    public CancellationSignal applyAsync(Context context, ViewGroup viewGroup, Executor executor, OnViewAppliedListener onViewAppliedListener, OnClickHandler onClickHandler) {
        return InvokeDynamicSupport.bootstrap("applyAsync", $$robo$$android_widget_RemoteViews$applyAsync(android.content.Context android.view.ViewGroup java.util.concurrent.Executor android.widget.RemoteViews$OnViewAppliedListener android.widget.RemoteViews$OnClickHandler ), 0, this, context, viewGroup, executor, onViewAppliedListener, onClickHandler);
    }

    private AsyncApplyTask getAsyncApplyTask(Context context, ViewGroup viewGroup, OnViewAppliedListener onViewAppliedListener, OnClickHandler onClickHandler) {
        return InvokeDynamicSupport.bootstrap("getAsyncApplyTask", $$robo$$android_widget_RemoteViews$getAsyncApplyTask(android.content.Context android.view.ViewGroup android.widget.RemoteViews$OnViewAppliedListener android.widget.RemoteViews$OnClickHandler ), 0, this, context, viewGroup, onViewAppliedListener, onClickHandler);
    }

    public void reapply(Context context, View view) {
        InvokeDynamicSupport.bootstrap("reapply", $$robo$$android_widget_RemoteViews$reapply(android.content.Context android.view.View ), 0, this, context, view);
    }

    public void reapply(Context context, View view, OnClickHandler onClickHandler) {
        InvokeDynamicSupport.bootstrap("reapply", $$robo$$android_widget_RemoteViews$reapply(android.content.Context android.view.View android.widget.RemoteViews$OnClickHandler ), 0, this, context, view, onClickHandler);
    }

    public CancellationSignal reapplyAsync(Context context, View view, Executor executor, OnViewAppliedListener onViewAppliedListener) {
        return InvokeDynamicSupport.bootstrap("reapplyAsync", $$robo$$android_widget_RemoteViews$reapplyAsync(android.content.Context android.view.View java.util.concurrent.Executor android.widget.RemoteViews$OnViewAppliedListener ), 0, this, context, view, executor, onViewAppliedListener);
    }

    public CancellationSignal reapplyAsync(Context context, View view, Executor executor, OnViewAppliedListener onViewAppliedListener, OnClickHandler onClickHandler) {
        return InvokeDynamicSupport.bootstrap("reapplyAsync", $$robo$$android_widget_RemoteViews$reapplyAsync(android.content.Context android.view.View java.util.concurrent.Executor android.widget.RemoteViews$OnViewAppliedListener android.widget.RemoteViews$OnClickHandler ), 0, this, context, view, executor, onViewAppliedListener, onClickHandler);
    }

    private void performApply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
        InvokeDynamicSupport.bootstrap("performApply", $$robo$$android_widget_RemoteViews$performApply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
    }

    public boolean prefersAsyncApply() {
        return (boolean)InvokeDynamicSupport.bootstrap("prefersAsyncApply", $$robo$$android_widget_RemoteViews$prefersAsyncApply(), 0, this);
    }

    private Context getContextForResources(Context context) {
        return InvokeDynamicSupport.bootstrap("getContextForResources", $$robo$$android_widget_RemoteViews$getContextForResources(android.content.Context ), 0, this, context);
    }

    public int getSequenceNumber() {
        return (int)InvokeDynamicSupport.bootstrap("getSequenceNumber", $$robo$$android_widget_RemoteViews$getSequenceNumber(), 0, this);
    }

    @Override
    public boolean onLoadClass(Class clazz) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLoadClass", $$robo$$android_widget_RemoteViews$onLoadClass(java.lang.Class ), 0, this, clazz);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_widget_RemoteViews$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private void writeActionsToParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("writeActionsToParcel", $$robo$$android_widget_RemoteViews$writeActionsToParcel(android.os.Parcel ), 0, this, parcel);
    }

    private static ApplicationInfo getApplicationInfo(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getApplicationInfo", $$robo$$android_widget_RemoteViews$getApplicationInfo(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public boolean hasSameAppInfo(ApplicationInfo applicationInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSameAppInfo", $$robo$$android_widget_RemoteViews$hasSameAppInfo(android.content.pm.ApplicationInfo ), 0, this, applicationInfo);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, BitmapCache bitmapCache, ApplicationInfo applicationInfo, int n, Map map, 1 var6_6) {
        this.$$robo$$android_widget_RemoteViews$__constructor__(parcel, bitmapCache, applicationInfo, n, map, var6_6);
    }

    static {
        RobolectricInternals.classInitializing(RemoteViews.class);
    }

    public /* synthetic */ RemoteViews() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RemoteViews)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ViewTree
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int INSERT_AT_END_INDEX = -1;
        private View mRoot;
        private ArrayList<ViewTree> mChildren;

        private void $$robo$$android_widget_RemoteViews_ViewTree$__constructor__(View root) {
            this.mRoot = root;
        }

        private final void $$robo$$android_widget_RemoteViews_ViewTree$createTree() {
            if (this.mChildren != null) {
                return;
            }
            this.mChildren = new ArrayList();
            if (this.mRoot instanceof ViewGroup) {
                ViewGroup vg = (ViewGroup)this.mRoot;
                int count = vg.getChildCount();
                for (int i = 0; i < count; ++i) {
                    this.addViewChild(vg.getChildAt(i));
                }
            }
        }

        private final ViewTree $$robo$$android_widget_RemoteViews_ViewTree$findViewTreeById(int id2) {
            if (this.mRoot.getId() == id2) {
                return this;
            }
            if (this.mChildren == null) {
                return null;
            }
            for (ViewTree tree : this.mChildren) {
                ViewTree result = tree.findViewTreeById(id2);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        private final void $$robo$$android_widget_RemoteViews_ViewTree$replaceView(View v) {
            this.mRoot = v;
            this.mChildren = null;
            this.createTree();
        }

        private final <T extends View> T $$robo$$android_widget_RemoteViews_ViewTree$findViewById(int id2) {
            if (this.mChildren == null) {
                return this.mRoot.findViewById(id2);
            }
            ViewTree tree = this.findViewTreeById(id2);
            return (T)(tree == null ? null : tree.mRoot);
        }

        private final void $$robo$$android_widget_RemoteViews_ViewTree$addChild(ViewTree child) {
            this.addChild(child, -1);
        }

        private final void $$robo$$android_widget_RemoteViews_ViewTree$addChild(ViewTree child, int index) {
            if (this.mChildren == null) {
                this.mChildren = new ArrayList();
            }
            child.createTree();
            if (index == -1) {
                this.mChildren.add(child);
                return;
            }
            this.mChildren.add(index, child);
        }

        private final void $$robo$$android_widget_RemoteViews_ViewTree$addViewChild(View v) {
            ViewTree target;
            if (v.isRootNamespace()) {
                return;
            }
            if (v.getId() != 0) {
                ViewTree tree = new ViewTree(v);
                this.mChildren.add(tree);
                target = tree;
            } else {
                target = this;
            }
            if (v instanceof ViewGroup && target.mChildren == null) {
                target.mChildren = new ArrayList();
                ViewGroup vg = (ViewGroup)v;
                int count = vg.getChildCount();
                for (int i = 0; i < count; ++i) {
                    target.addViewChild(vg.getChildAt(i));
                }
            }
        }

        private /* synthetic */ void $$robo$$android_widget_RemoteViews_ViewTree$__constructor__(View x0, 1 x1) {
        }

        private void __constructor__(View view) {
            this.$$robo$$android_widget_RemoteViews_ViewTree$__constructor__(view);
        }

        private ViewTree(View view) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ViewTree$__constructor__(android.view.View ), 0, this, view);
        }

        public void createTree() {
            InvokeDynamicSupport.bootstrap("createTree", $$robo$$android_widget_RemoteViews_ViewTree$createTree(), 0, this);
        }

        public ViewTree findViewTreeById(int n) {
            return InvokeDynamicSupport.bootstrap("findViewTreeById", $$robo$$android_widget_RemoteViews_ViewTree$findViewTreeById(int ), 0, this, n);
        }

        public void replaceView(View view) {
            InvokeDynamicSupport.bootstrap("replaceView", $$robo$$android_widget_RemoteViews_ViewTree$replaceView(android.view.View ), 0, this, view);
        }

        public <T extends View> T findViewById(int n) {
            return (T)InvokeDynamicSupport.bootstrap("findViewById", $$robo$$android_widget_RemoteViews_ViewTree$findViewById(int ), 0, this, n);
        }

        public void addChild(ViewTree viewTree) {
            InvokeDynamicSupport.bootstrap("addChild", $$robo$$android_widget_RemoteViews_ViewTree$addChild(android.widget.RemoteViews$ViewTree ), 0, this, viewTree);
        }

        public void addChild(ViewTree viewTree, int n) {
            InvokeDynamicSupport.bootstrap("addChild", $$robo$$android_widget_RemoteViews_ViewTree$addChild(android.widget.RemoteViews$ViewTree int ), 0, this, viewTree, n);
        }

        private void addViewChild(View view) {
            InvokeDynamicSupport.bootstrap("addViewChild", $$robo$$android_widget_RemoteViews_ViewTree$addViewChild(android.view.View ), 0, this, view);
        }

        private /* synthetic */ void __constructor__(View view, 1 var2_2) {
            this.$$robo$$android_widget_RemoteViews_ViewTree$__constructor__(view, var2_2);
        }

        public /* synthetic */ ViewTree() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewTree)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class AsyncApplyTask
    extends AsyncTask<Void, Void, ViewTree>
    implements CancellationSignal.OnCancelListener {
        public transient /* synthetic */ Object __robo_data__;
        RemoteViews mRV;
        ViewGroup mParent;
        Context mContext;
        OnViewAppliedListener mListener;
        OnClickHandler mHandler;
        private View mResult;
        private ViewTree mTree;
        private Action[] mActions;
        private Exception mError;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_AsyncApplyTask$__constructor__(RemoteViews remoteViews, RemoteViews rv, ViewGroup parent, Context context, OnViewAppliedListener listener, OnClickHandler handler, View result) {
            this.mRV = rv;
            this.mParent = parent;
            this.mContext = context;
            this.mListener = listener;
            this.mHandler = handler;
            this.mResult = result;
            RemoteViews.loadTransitionOverride(context, handler);
        }

        private final ViewTree $$robo$$android_widget_RemoteViews_AsyncApplyTask$doInBackground(Void ... params) {
            try {
                if (this.mResult == null) {
                    this.mResult = this.this$0.inflateView(this.mContext, this.mRV, this.mParent);
                }
                this.mTree = new ViewTree(this.mResult);
                if (this.mRV.mActions != null) {
                    int count = this.mRV.mActions.size();
                    this.mActions = new Action[count];
                    for (int i = 0; i < count && !this.isCancelled(); ++i) {
                        this.mActions[i] = ((Action)this.mRV.mActions.get(i)).initActionAsync(this.mTree, this.mParent, this.mHandler);
                    }
                } else {
                    this.mActions = null;
                }
                return this.mTree;
            }
            catch (Exception e) {
                this.mError = e;
                return null;
            }
        }

        private final void $$robo$$android_widget_RemoteViews_AsyncApplyTask$onPostExecute(ViewTree viewTree) {
            if (this.mError == null) {
                try {
                    if (this.mActions != null) {
                        OnClickHandler handler = this.mHandler == null ? DEFAULT_ON_CLICK_HANDLER : this.mHandler;
                        for (Action a : this.mActions) {
                            a.apply(viewTree.mRoot, this.mParent, handler);
                        }
                    }
                }
                catch (Exception e) {
                    this.mError = e;
                }
            }
            if (this.mListener != null) {
                if (this.mError != null) {
                    this.mListener.onError(this.mError);
                } else {
                    this.mListener.onViewApplied(viewTree.mRoot);
                }
            } else if (this.mError != null) {
                if (this.mError instanceof ActionException) {
                    throw (ActionException)this.mError;
                }
                throw new ActionException(this.mError);
            }
        }

        private final void $$robo$$android_widget_RemoteViews_AsyncApplyTask$onCancel() {
            this.cancel(true);
        }

        private /* synthetic */ void $$robo$$android_widget_RemoteViews_AsyncApplyTask$__constructor__(RemoteViews x0, RemoteViews x1, ViewGroup x2, Context x3, OnViewAppliedListener x4, OnClickHandler x5, View x6, 1 x7) {
        }

        private void __constructor__(RemoteViews remoteViews, RemoteViews remoteViews2, ViewGroup viewGroup, Context context, OnViewAppliedListener onViewAppliedListener, OnClickHandler onClickHandler, View view) {
            this.$$robo$$android_widget_RemoteViews_AsyncApplyTask$__constructor__(remoteViews, remoteViews2, viewGroup, context, onViewAppliedListener, onClickHandler, view);
        }

        private AsyncApplyTask(RemoteViews remoteViews, RemoteViews remoteViews2, ViewGroup viewGroup, Context context, OnViewAppliedListener onViewAppliedListener, OnClickHandler onClickHandler, View view) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_AsyncApplyTask$__constructor__(android.widget.RemoteViews android.widget.RemoteViews android.view.ViewGroup android.content.Context android.widget.RemoteViews$OnViewAppliedListener android.widget.RemoteViews$OnClickHandler android.view.View ), 0, this, remoteViews, remoteViews2, viewGroup, context, onViewAppliedListener, onClickHandler, view);
        }

        protected ViewTree doInBackground(Void ... voidArray) {
            return InvokeDynamicSupport.bootstrap("doInBackground", $$robo$$android_widget_RemoteViews_AsyncApplyTask$doInBackground(java.lang.Void[] ), 0, this, voidArray);
        }

        @Override
        protected void onPostExecute(ViewTree viewTree) {
            InvokeDynamicSupport.bootstrap("onPostExecute", $$robo$$android_widget_RemoteViews_AsyncApplyTask$onPostExecute(android.widget.RemoteViews$ViewTree ), 0, this, viewTree);
        }

        @Override
        public void onCancel() {
            InvokeDynamicSupport.bootstrap("onCancel", $$robo$$android_widget_RemoteViews_AsyncApplyTask$onCancel(), 0, this);
        }

        private /* synthetic */ void __constructor__(RemoteViews remoteViews, RemoteViews remoteViews2, ViewGroup viewGroup, Context context, OnViewAppliedListener onViewAppliedListener, OnClickHandler onClickHandler, View view, 1 var8_8) {
            this.$$robo$$android_widget_RemoteViews_AsyncApplyTask$__constructor__(remoteViews, remoteViews2, viewGroup, context, onViewAppliedListener, onClickHandler, view, var8_8);
        }

        public /* synthetic */ AsyncApplyTask() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AsyncApplyTask)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnViewAppliedListener
    extends InstrumentedInterface {
        public void onViewApplied(View var1);

        public void onError(Exception var1);
    }

    private class OverrideTextColorsAction
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int textColor;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_OverrideTextColorsAction$__constructor__(RemoteViews remoteViews, int textColor) {
            this.textColor = textColor;
        }

        private void $$robo$$android_widget_RemoteViews_OverrideTextColorsAction$__constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.textColor = parcel.readInt();
        }

        private final void $$robo$$android_widget_RemoteViews_OverrideTextColorsAction$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.textColor);
        }

        private final void $$robo$$android_widget_RemoteViews_OverrideTextColorsAction$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Stack<View> viewsToProcess = new Stack<View>();
            viewsToProcess.add(root);
            while (!viewsToProcess.isEmpty()) {
                View v = (View)viewsToProcess.pop();
                if (v instanceof TextView) {
                    TextView textView = (TextView)v;
                    textView.setText(NotificationColorUtil.clearColorSpans(textView.getText()));
                    textView.setTextColor(this.textColor);
                }
                if (!(v instanceof ViewGroup)) continue;
                ViewGroup viewGroup = (ViewGroup)v;
                for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                    viewsToProcess.push(viewGroup.getChildAt(i));
                }
            }
        }

        private final int $$robo$$android_widget_RemoteViews_OverrideTextColorsAction$getActionTag() {
            return 20;
        }

        private void __constructor__(RemoteViews remoteViews, int n) {
            this.$$robo$$android_widget_RemoteViews_OverrideTextColorsAction$__constructor__(remoteViews, n);
        }

        public OverrideTextColorsAction(RemoteViews remoteViews, int n) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_OverrideTextColorsAction$__constructor__(android.widget.RemoteViews int ), 0, this, remoteViews, n);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_OverrideTextColorsAction$__constructor__(remoteViews, parcel);
        }

        public OverrideTextColorsAction(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_OverrideTextColorsAction$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_OverrideTextColorsAction$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_OverrideTextColorsAction$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public int getActionTag() {
            return (int)InvokeDynamicSupport.bootstrap("getActionTag", $$robo$$android_widget_RemoteViews_OverrideTextColorsAction$getActionTag(), 0, this);
        }

        public /* synthetic */ OverrideTextColorsAction() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OverrideTextColorsAction)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SetRemoteInputsAction
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Parcelable[] remoteInputs;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_SetRemoteInputsAction$__constructor__(RemoteViews remoteViews, int viewId, RemoteInput[] remoteInputs) {
            this.viewId = viewId;
            this.remoteInputs = remoteInputs;
        }

        private void $$robo$$android_widget_RemoteViews_SetRemoteInputsAction$__constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.viewId = parcel.readInt();
            this.remoteInputs = parcel.createTypedArray(RemoteInput.CREATOR);
        }

        private final void $$robo$$android_widget_RemoteViews_SetRemoteInputsAction$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeTypedArray(this.remoteInputs, flags);
        }

        private final void $$robo$$android_widget_RemoteViews_SetRemoteInputsAction$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            ((View)target).setTagInternal(16909223, this.remoteInputs);
        }

        private final int $$robo$$android_widget_RemoteViews_SetRemoteInputsAction$getActionTag() {
            return 18;
        }

        private void __constructor__(RemoteViews remoteViews, int n, RemoteInput[] remoteInputArray) {
            this.$$robo$$android_widget_RemoteViews_SetRemoteInputsAction$__constructor__(remoteViews, n, remoteInputArray);
        }

        public SetRemoteInputsAction(RemoteViews remoteViews, int n, RemoteInput[] remoteInputArray) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetRemoteInputsAction$__constructor__(android.widget.RemoteViews int android.app.RemoteInput[] ), 0, this, remoteViews, n, remoteInputArray);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_SetRemoteInputsAction$__constructor__(remoteViews, parcel);
        }

        public SetRemoteInputsAction(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetRemoteInputsAction$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_SetRemoteInputsAction$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_SetRemoteInputsAction$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public int getActionTag() {
            return (int)InvokeDynamicSupport.bootstrap("getActionTag", $$robo$$android_widget_RemoteViews_SetRemoteInputsAction$getActionTag(), 0, this);
        }

        public /* synthetic */ SetRemoteInputsAction() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SetRemoteInputsAction)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class LayoutParamAction
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int LAYOUT_MARGIN_END_DIMEN = 1;
        public static int LAYOUT_WIDTH = 2;
        public static int LAYOUT_MARGIN_BOTTOM_DIMEN = 3;
        public static int LAYOUT_MARGIN_END = 4;
        int mProperty;
        int mValue;

        private void $$robo$$android_widget_RemoteViews_LayoutParamAction$__constructor__(int viewId, int property, int value) {
            this.viewId = viewId;
            this.mProperty = property;
            this.mValue = value;
        }

        private void $$robo$$android_widget_RemoteViews_LayoutParamAction$__constructor__(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.mProperty = parcel.readInt();
            this.mValue = parcel.readInt();
        }

        private final void $$robo$$android_widget_RemoteViews_LayoutParamAction$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeInt(this.mProperty);
            dest.writeInt(this.mValue);
        }

        private final void $$robo$$android_widget_RemoteViews_LayoutParamAction$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            ViewGroup.LayoutParams layoutParams = ((View)target).getLayoutParams();
            if (layoutParams == null) {
                return;
            }
            int value = this.mValue;
            switch (this.mProperty) {
                case 1: {
                    value = LayoutParamAction.resolveDimenPixelOffset(target, this.mValue);
                }
                case 4: {
                    if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) break;
                    ((ViewGroup.MarginLayoutParams)layoutParams).setMarginEnd(value);
                    ((View)target).setLayoutParams(layoutParams);
                    break;
                }
                case 3: {
                    int resolved;
                    if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) break;
                    ((ViewGroup.MarginLayoutParams)layoutParams).bottomMargin = resolved = LayoutParamAction.resolveDimenPixelOffset(target, this.mValue);
                    ((View)target).setLayoutParams(layoutParams);
                    break;
                }
                case 2: {
                    layoutParams.width = this.mValue;
                    ((View)target).setLayoutParams(layoutParams);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown property " + this.mProperty);
                }
            }
        }

        private static final int $$robo$$android_widget_RemoteViews_LayoutParamAction$resolveDimenPixelOffset(View target, int value) {
            if (value == 0) {
                return 0;
            }
            return target.getContext().getResources().getDimensionPixelOffset(value);
        }

        private final int $$robo$$android_widget_RemoteViews_LayoutParamAction$getActionTag() {
            return 19;
        }

        private final String $$robo$$android_widget_RemoteViews_LayoutParamAction$getUniqueKey() {
            return super.getUniqueKey() + this.mProperty;
        }

        private void __constructor__(int n, int n2, int n3) {
            this.$$robo$$android_widget_RemoteViews_LayoutParamAction$__constructor__(n, n2, n3);
        }

        public LayoutParamAction(int n, int n2, int n3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_LayoutParamAction$__constructor__(int int int ), 0, this, n, n2, n3);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_LayoutParamAction$__constructor__(parcel);
        }

        public LayoutParamAction(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_LayoutParamAction$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_LayoutParamAction$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_LayoutParamAction$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        private static int resolveDimenPixelOffset(View view, int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("resolveDimenPixelOffset", $$robo$$android_widget_RemoteViews_LayoutParamAction$resolveDimenPixelOffset(android.view.View int ), 0, (View)view, (int)n);
        }

        @Override
        public int getActionTag() {
            return (int)InvokeDynamicSupport.bootstrap("getActionTag", $$robo$$android_widget_RemoteViews_LayoutParamAction$getActionTag(), 0, this);
        }

        @Override
        public String getUniqueKey() {
            return InvokeDynamicSupport.bootstrap("getUniqueKey", $$robo$$android_widget_RemoteViews_LayoutParamAction$getUniqueKey(), 0, this);
        }

        public /* synthetic */ LayoutParamAction() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutParamAction)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ViewPaddingAction
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int left;
        int top;
        int right;
        int bottom;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_ViewPaddingAction$__constructor__(RemoteViews remoteViews, int viewId, int left, int top, int right, int bottom) {
            this.viewId = viewId;
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
        }

        private void $$robo$$android_widget_RemoteViews_ViewPaddingAction$__constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.viewId = parcel.readInt();
            this.left = parcel.readInt();
            this.top = parcel.readInt();
            this.right = parcel.readInt();
            this.bottom = parcel.readInt();
        }

        private final void $$robo$$android_widget_RemoteViews_ViewPaddingAction$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeInt(this.left);
            dest.writeInt(this.top);
            dest.writeInt(this.right);
            dest.writeInt(this.bottom);
        }

        private final void $$robo$$android_widget_RemoteViews_ViewPaddingAction$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            ((View)target).setPadding(this.left, this.top, this.right, this.bottom);
        }

        private final int $$robo$$android_widget_RemoteViews_ViewPaddingAction$getActionTag() {
            return 14;
        }

        private void __constructor__(RemoteViews remoteViews, int n, int n2, int n3, int n4, int n5) {
            this.$$robo$$android_widget_RemoteViews_ViewPaddingAction$__constructor__(remoteViews, n, n2, n3, n4, n5);
        }

        public ViewPaddingAction(RemoteViews remoteViews, int n, int n2, int n3, int n4, int n5) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ViewPaddingAction$__constructor__(android.widget.RemoteViews int int int int int ), 0, this, remoteViews, n, n2, n3, n4, n5);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_ViewPaddingAction$__constructor__(remoteViews, parcel);
        }

        public ViewPaddingAction(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ViewPaddingAction$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_ViewPaddingAction$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_ViewPaddingAction$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public int getActionTag() {
            return (int)InvokeDynamicSupport.bootstrap("getActionTag", $$robo$$android_widget_RemoteViews_ViewPaddingAction$getActionTag(), 0, this);
        }

        public /* synthetic */ ViewPaddingAction() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewPaddingAction)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class TextViewSizeAction
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int units;
        float size;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_TextViewSizeAction$__constructor__(RemoteViews remoteViews, int viewId, int units, float size) {
            this.viewId = viewId;
            this.units = units;
            this.size = size;
        }

        private void $$robo$$android_widget_RemoteViews_TextViewSizeAction$__constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.viewId = parcel.readInt();
            this.units = parcel.readInt();
            this.size = parcel.readFloat();
        }

        private final void $$robo$$android_widget_RemoteViews_TextViewSizeAction$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeInt(this.units);
            dest.writeFloat(this.size);
        }

        private final void $$robo$$android_widget_RemoteViews_TextViewSizeAction$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            TextView target = (TextView)root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            target.setTextSize(this.units, this.size);
        }

        private final int $$robo$$android_widget_RemoteViews_TextViewSizeAction$getActionTag() {
            return 13;
        }

        private void __constructor__(RemoteViews remoteViews, int n, int n2, float f) {
            this.$$robo$$android_widget_RemoteViews_TextViewSizeAction$__constructor__(remoteViews, n, n2, f);
        }

        public TextViewSizeAction(RemoteViews remoteViews, int n, int n2, float f) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_TextViewSizeAction$__constructor__(android.widget.RemoteViews int int float ), 0, this, remoteViews, n, n2, f);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_TextViewSizeAction$__constructor__(remoteViews, parcel);
        }

        public TextViewSizeAction(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_TextViewSizeAction$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_TextViewSizeAction$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_TextViewSizeAction$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public int getActionTag() {
            return (int)InvokeDynamicSupport.bootstrap("getActionTag", $$robo$$android_widget_RemoteViews_TextViewSizeAction$getActionTag(), 0, this);
        }

        public /* synthetic */ TextViewSizeAction() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextViewSizeAction)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class TextViewDrawableAction
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        boolean isRelative;
        boolean useIcons;
        int d1;
        int d2;
        int d3;
        int d4;
        Icon i1;
        Icon i2;
        Icon i3;
        Icon i4;
        boolean drawablesLoaded;
        Drawable id1;
        Drawable id2;
        Drawable id3;
        Drawable id4;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_TextViewDrawableAction$__constructor__(RemoteViews remoteViews, int viewId, boolean isRelative, int d1, int d2, int d3, int d4) {
            this.isRelative = false;
            this.useIcons = false;
            this.drawablesLoaded = false;
            this.viewId = viewId;
            this.isRelative = isRelative;
            this.useIcons = false;
            this.d1 = d1;
            this.d2 = d2;
            this.d3 = d3;
            this.d4 = d4;
        }

        private void $$robo$$android_widget_RemoteViews_TextViewDrawableAction$__constructor__(RemoteViews remoteViews, int viewId, boolean isRelative, Icon i1, Icon i2, Icon i3, Icon i4) {
            this.isRelative = false;
            this.useIcons = false;
            this.drawablesLoaded = false;
            this.viewId = viewId;
            this.isRelative = isRelative;
            this.useIcons = true;
            this.i1 = i1;
            this.i2 = i2;
            this.i3 = i3;
            this.i4 = i4;
        }

        private void $$robo$$android_widget_RemoteViews_TextViewDrawableAction$__constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.isRelative = false;
            this.useIcons = false;
            this.drawablesLoaded = false;
            this.viewId = parcel.readInt();
            this.isRelative = parcel.readInt() != 0;
            boolean bl = this.useIcons = parcel.readInt() != 0;
            if (this.useIcons) {
                this.i1 = parcel.readTypedObject(Icon.CREATOR);
                this.i2 = parcel.readTypedObject(Icon.CREATOR);
                this.i3 = parcel.readTypedObject(Icon.CREATOR);
                this.i4 = parcel.readTypedObject(Icon.CREATOR);
            } else {
                this.d1 = parcel.readInt();
                this.d2 = parcel.readInt();
                this.d3 = parcel.readInt();
                this.d4 = parcel.readInt();
            }
        }

        private final void $$robo$$android_widget_RemoteViews_TextViewDrawableAction$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeInt(this.isRelative ? 1 : 0);
            dest.writeInt(this.useIcons ? 1 : 0);
            if (this.useIcons) {
                dest.writeTypedObject(this.i1, 0);
                dest.writeTypedObject(this.i2, 0);
                dest.writeTypedObject(this.i3, 0);
                dest.writeTypedObject(this.i4, 0);
            } else {
                dest.writeInt(this.d1);
                dest.writeInt(this.d2);
                dest.writeInt(this.d3);
                dest.writeInt(this.d4);
            }
        }

        private final void $$robo$$android_widget_RemoteViews_TextViewDrawableAction$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            TextView target = (TextView)root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (this.drawablesLoaded) {
                if (this.isRelative) {
                    target.setCompoundDrawablesRelativeWithIntrinsicBounds(this.id1, this.id2, this.id3, this.id4);
                } else {
                    target.setCompoundDrawablesWithIntrinsicBounds(this.id1, this.id2, this.id3, this.id4);
                }
            } else if (this.useIcons) {
                Drawable id4;
                Context ctx = target.getContext();
                Drawable id1 = this.i1 == null ? null : this.i1.loadDrawable(ctx);
                Drawable id2 = this.i2 == null ? null : this.i2.loadDrawable(ctx);
                Drawable id3 = this.i3 == null ? null : this.i3.loadDrawable(ctx);
                Drawable drawable2 = id4 = this.i4 == null ? null : this.i4.loadDrawable(ctx);
                if (this.isRelative) {
                    target.setCompoundDrawablesRelativeWithIntrinsicBounds(id1, id2, id3, id4);
                } else {
                    target.setCompoundDrawablesWithIntrinsicBounds(id1, id2, id3, id4);
                }
            } else if (this.isRelative) {
                target.setCompoundDrawablesRelativeWithIntrinsicBounds(this.d1, this.d2, this.d3, this.d4);
            } else {
                target.setCompoundDrawablesWithIntrinsicBounds(this.d1, this.d2, this.d3, this.d4);
            }
        }

        private final Action $$robo$$android_widget_RemoteViews_TextViewDrawableAction$initActionAsync(ViewTree root, ViewGroup rootParent, OnClickHandler handler) {
            TextView target = (TextView)root.findViewById(this.viewId);
            if (target == null) {
                return ACTION_NOOP;
            }
            TextViewDrawableAction copy = this.useIcons ? new TextViewDrawableAction(this.this$0, this.viewId, this.isRelative, this.i1, this.i2, this.i3, this.i4) : new TextViewDrawableAction(this.this$0, this.viewId, this.isRelative, this.d1, this.d2, this.d3, this.d4);
            copy.drawablesLoaded = true;
            Context ctx = target.getContext();
            if (this.useIcons) {
                copy.id1 = this.i1 == null ? null : this.i1.loadDrawable(ctx);
                copy.id2 = this.i2 == null ? null : this.i2.loadDrawable(ctx);
                copy.id3 = this.i3 == null ? null : this.i3.loadDrawable(ctx);
                copy.id4 = this.i4 == null ? null : this.i4.loadDrawable(ctx);
            } else {
                copy.id1 = this.d1 == 0 ? null : ctx.getDrawable(this.d1);
                copy.id2 = this.d2 == 0 ? null : ctx.getDrawable(this.d2);
                copy.id3 = this.d3 == 0 ? null : ctx.getDrawable(this.d3);
                copy.id4 = this.d4 == 0 ? null : ctx.getDrawable(this.d4);
            }
            return copy;
        }

        private final boolean $$robo$$android_widget_RemoteViews_TextViewDrawableAction$prefersAsyncApply() {
            return this.useIcons;
        }

        private final int $$robo$$android_widget_RemoteViews_TextViewDrawableAction$getActionTag() {
            return 11;
        }

        private final void $$robo$$android_widget_RemoteViews_TextViewDrawableAction$visitUris(Consumer<Uri> visitor) {
            if (this.useIcons) {
                RemoteViews.visitIconUri(this.i1, visitor);
                RemoteViews.visitIconUri(this.i2, visitor);
                RemoteViews.visitIconUri(this.i3, visitor);
                RemoteViews.visitIconUri(this.i4, visitor);
            }
        }

        private void __constructor__(RemoteViews remoteViews, int n, boolean bl, int n2, int n3, int n4, int n5) {
            this.$$robo$$android_widget_RemoteViews_TextViewDrawableAction$__constructor__(remoteViews, n, bl, n2, n3, n4, n5);
        }

        public TextViewDrawableAction(RemoteViews remoteViews, int n, boolean bl, int n2, int n3, int n4, int n5) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_TextViewDrawableAction$__constructor__(android.widget.RemoteViews int boolean int int int int ), 0, this, remoteViews, n, bl, n2, n3, n4, n5);
        }

        private void __constructor__(RemoteViews remoteViews, int n, boolean bl, Icon icon, Icon icon2, Icon icon3, Icon icon4) {
            this.$$robo$$android_widget_RemoteViews_TextViewDrawableAction$__constructor__(remoteViews, n, bl, icon, icon2, icon3, icon4);
        }

        public TextViewDrawableAction(RemoteViews remoteViews, int n, boolean bl, Icon icon, Icon icon2, Icon icon3, Icon icon4) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_TextViewDrawableAction$__constructor__(android.widget.RemoteViews int boolean android.graphics.drawable.Icon android.graphics.drawable.Icon android.graphics.drawable.Icon android.graphics.drawable.Icon ), 0, this, remoteViews, n, bl, icon, icon2, icon3, icon4);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_TextViewDrawableAction$__constructor__(remoteViews, parcel);
        }

        public TextViewDrawableAction(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_TextViewDrawableAction$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_TextViewDrawableAction$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_TextViewDrawableAction$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public Action initActionAsync(ViewTree viewTree, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            return InvokeDynamicSupport.bootstrap("initActionAsync", $$robo$$android_widget_RemoteViews_TextViewDrawableAction$initActionAsync(android.widget.RemoteViews$ViewTree android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, viewTree, viewGroup, onClickHandler);
        }

        @Override
        public boolean prefersAsyncApply() {
            return (boolean)InvokeDynamicSupport.bootstrap("prefersAsyncApply", $$robo$$android_widget_RemoteViews_TextViewDrawableAction$prefersAsyncApply(), 0, this);
        }

        @Override
        public int getActionTag() {
            return (int)InvokeDynamicSupport.bootstrap("getActionTag", $$robo$$android_widget_RemoteViews_TextViewDrawableAction$getActionTag(), 0, this);
        }

        @Override
        public void visitUris(Consumer<Uri> consumer) {
            InvokeDynamicSupport.bootstrap("visitUris", $$robo$$android_widget_RemoteViews_TextViewDrawableAction$visitUris(java.util.function.Consumer<android.net.Uri> ), 0, this, consumer);
        }

        public /* synthetic */ TextViewDrawableAction() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextViewDrawableAction)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ViewGroupActionRemove
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int REMOVE_ALL_VIEWS_ID = -2;
        private int mViewIdToKeep;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_ViewGroupActionRemove$__constructor__(RemoteViews remoteViews, int viewId) {
        }

        private void $$robo$$android_widget_RemoteViews_ViewGroupActionRemove$__constructor__(RemoteViews remoteViews, int viewId, int viewIdToKeep) {
            this.viewId = viewId;
            this.mViewIdToKeep = viewIdToKeep;
        }

        private void $$robo$$android_widget_RemoteViews_ViewGroupActionRemove$__constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.viewId = parcel.readInt();
            this.mViewIdToKeep = parcel.readInt();
        }

        private final void $$robo$$android_widget_RemoteViews_ViewGroupActionRemove$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeInt(this.mViewIdToKeep);
        }

        private final void $$robo$$android_widget_RemoteViews_ViewGroupActionRemove$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            ViewGroup target = (ViewGroup)root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (this.mViewIdToKeep == -2) {
                target.removeAllViews();
                return;
            }
            this.removeAllViewsExceptIdToKeep(target);
        }

        private final Action $$robo$$android_widget_RemoteViews_ViewGroupActionRemove$initActionAsync(ViewTree root, ViewGroup rootParent, OnClickHandler handler) {
            root.createTree();
            ViewTree target = root.findViewTreeById(this.viewId);
            if (target == null || !(target.mRoot instanceof ViewGroup)) {
                return ACTION_NOOP;
            }
            ViewGroup targetVg = (ViewGroup)target.mRoot;
            target.mChildren = null;
            return new ShadowedObject(this, targetVg){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ViewGroup val$targetVg;
                /* synthetic */ ViewGroupActionRemove this$1;

                private void $$robo$$android_widget_RemoteViews_ViewGroupActionRemove_1$__constructor__(ViewGroupActionRemove this$1, ViewGroup viewGroup) {
                }

                private final void $$robo$$android_widget_RemoteViews_ViewGroupActionRemove_1$apply(View root, ViewGroup rootParent, OnClickHandler handler) throws ActionException {
                    if (this.this$1.mViewIdToKeep == -2) {
                        this.val$targetVg.removeAllViews();
                        return;
                    }
                    this.this$1.removeAllViewsExceptIdToKeep(this.val$targetVg);
                }

                private void __constructor__(ViewGroupActionRemove viewGroupActionRemove, ViewGroup viewGroup) {
                    this.$$robo$$android_widget_RemoteViews_ViewGroupActionRemove_1$__constructor__(viewGroupActionRemove, viewGroup);
                }
                {
                    this.this$1 = viewGroupActionRemove;
                    this.val$targetVg = viewGroup;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ViewGroupActionRemove_1$__constructor__(android.widget.RemoteViews$ViewGroupActionRemove android.view.ViewGroup ), 0, this, viewGroupActionRemove, viewGroup);
                }

                @Override
                public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) throws ActionException {
                    InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_ViewGroupActionRemove_1$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private final void $$robo$$android_widget_RemoteViews_ViewGroupActionRemove$removeAllViewsExceptIdToKeep(ViewGroup viewGroup) {
            for (int index = viewGroup.getChildCount() - 1; index >= 0; --index) {
                if (viewGroup.getChildAt(index).getId() == this.mViewIdToKeep) continue;
                viewGroup.removeViewAt(index);
            }
        }

        private final int $$robo$$android_widget_RemoteViews_ViewGroupActionRemove$getActionTag() {
            return 7;
        }

        private final int $$robo$$android_widget_RemoteViews_ViewGroupActionRemove$mergeBehavior() {
            return 1;
        }

        private void __constructor__(RemoteViews remoteViews, int n) {
            this.$$robo$$android_widget_RemoteViews_ViewGroupActionRemove$__constructor__(remoteViews, n);
        }

        ViewGroupActionRemove(RemoteViews remoteViews, int n) {
            this(remoteViews, n, -2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ViewGroupActionRemove$__constructor__(android.widget.RemoteViews int ), 0, this, remoteViews, n);
        }

        private void __constructor__(RemoteViews remoteViews, int n, int n2) {
            this.$$robo$$android_widget_RemoteViews_ViewGroupActionRemove$__constructor__(remoteViews, n, n2);
        }

        ViewGroupActionRemove(RemoteViews remoteViews, int n, int n2) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ViewGroupActionRemove$__constructor__(android.widget.RemoteViews int int ), 0, this, remoteViews, n, n2);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_ViewGroupActionRemove$__constructor__(remoteViews, parcel);
        }

        ViewGroupActionRemove(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ViewGroupActionRemove$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_ViewGroupActionRemove$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_ViewGroupActionRemove$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public Action initActionAsync(ViewTree viewTree, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            return InvokeDynamicSupport.bootstrap("initActionAsync", $$robo$$android_widget_RemoteViews_ViewGroupActionRemove$initActionAsync(android.widget.RemoteViews$ViewTree android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, viewTree, viewGroup, onClickHandler);
        }

        private void removeAllViewsExceptIdToKeep(ViewGroup viewGroup) {
            InvokeDynamicSupport.bootstrap("removeAllViewsExceptIdToKeep", $$robo$$android_widget_RemoteViews_ViewGroupActionRemove$removeAllViewsExceptIdToKeep(android.view.ViewGroup ), 0, this, viewGroup);
        }

        @Override
        public int getActionTag() {
            return (int)InvokeDynamicSupport.bootstrap("getActionTag", $$robo$$android_widget_RemoteViews_ViewGroupActionRemove$getActionTag(), 0, this);
        }

        @Override
        public int mergeBehavior() {
            return (int)InvokeDynamicSupport.bootstrap("mergeBehavior", $$robo$$android_widget_RemoteViews_ViewGroupActionRemove$mergeBehavior(), 0, this);
        }

        public /* synthetic */ ViewGroupActionRemove() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewGroupActionRemove)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ViewGroupActionAdd
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private RemoteViews mNestedViews;
        private int mIndex;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_ViewGroupActionAdd$__constructor__(RemoteViews remoteViews, int viewId, RemoteViews nestedViews) {
        }

        private void $$robo$$android_widget_RemoteViews_ViewGroupActionAdd$__constructor__(RemoteViews remoteViews, int viewId, RemoteViews nestedViews, int index) {
            this.viewId = viewId;
            this.mNestedViews = nestedViews;
            this.mIndex = index;
            if (nestedViews != null) {
                remoteViews.configureRemoteViewsAsChild(nestedViews);
            }
        }

        private void $$robo$$android_widget_RemoteViews_ViewGroupActionAdd$__constructor__(RemoteViews remoteViews, Parcel parcel, BitmapCache bitmapCache, ApplicationInfo info, int depth, Map<Class, Object> classCookies) {
            this.viewId = parcel.readInt();
            this.mIndex = parcel.readInt();
            this.mNestedViews = new RemoteViews(parcel, bitmapCache, info, depth, classCookies);
        }

        private final void $$robo$$android_widget_RemoteViews_ViewGroupActionAdd$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeInt(this.mIndex);
            this.mNestedViews.writeToParcel(dest, flags);
        }

        private final boolean $$robo$$android_widget_RemoteViews_ViewGroupActionAdd$hasSameAppInfo(ApplicationInfo parentInfo) {
            return this.mNestedViews.hasSameAppInfo(parentInfo);
        }

        private final void $$robo$$android_widget_RemoteViews_ViewGroupActionAdd$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Context context = root.getContext();
            ViewGroup target = (ViewGroup)root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            target.addView(this.mNestedViews.apply(context, target, handler), this.mIndex);
        }

        private final Action $$robo$$android_widget_RemoteViews_ViewGroupActionAdd$initActionAsync(ViewTree root, ViewGroup rootParent, OnClickHandler handler) {
            root.createTree();
            ViewTree target = root.findViewTreeById(this.viewId);
            if (target == null || !(target.mRoot instanceof ViewGroup)) {
                return ACTION_NOOP;
            }
            ViewGroup targetVg = (ViewGroup)target.mRoot;
            Context context = root.mRoot.getContext();
            AsyncApplyTask task = this.mNestedViews.getAsyncApplyTask(context, targetVg, null, handler);
            ViewTree tree = task.doInBackground(new Void[0]);
            if (tree == null) {
                throw new ActionException(task.mError);
            }
            target.addChild(tree, this.mIndex);
            return new ShadowedObject(this, task, tree, targetVg){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ AsyncApplyTask val$task;
                /* synthetic */ ViewTree val$tree;
                /* synthetic */ ViewGroup val$targetVg;
                /* synthetic */ ViewGroupActionAdd this$1;

                private void $$robo$$android_widget_RemoteViews_ViewGroupActionAdd_1$__constructor__(ViewGroupActionAdd this$1, AsyncApplyTask asyncApplyTask, ViewTree viewTree, ViewGroup viewGroup) {
                }

                private final void $$robo$$android_widget_RemoteViews_ViewGroupActionAdd_1$apply(View root, ViewGroup rootParent, OnClickHandler handler) throws ActionException {
                    this.val$task.onPostExecute(this.val$tree);
                    this.val$targetVg.addView(this.val$task.mResult, this.this$1.mIndex);
                }

                private void __constructor__(ViewGroupActionAdd viewGroupActionAdd, AsyncApplyTask asyncApplyTask, ViewTree viewTree, ViewGroup viewGroup) {
                    this.$$robo$$android_widget_RemoteViews_ViewGroupActionAdd_1$__constructor__(viewGroupActionAdd, asyncApplyTask, viewTree, viewGroup);
                }
                {
                    this.this$1 = viewGroupActionAdd;
                    this.val$task = asyncApplyTask;
                    this.val$tree = viewTree;
                    this.val$targetVg = viewGroup;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ViewGroupActionAdd_1$__constructor__(android.widget.RemoteViews$ViewGroupActionAdd android.widget.RemoteViews$AsyncApplyTask android.widget.RemoteViews$ViewTree android.view.ViewGroup ), 0, this, viewGroupActionAdd, asyncApplyTask, viewTree, viewGroup);
                }

                @Override
                public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) throws ActionException {
                    InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_ViewGroupActionAdd_1$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private final void $$robo$$android_widget_RemoteViews_ViewGroupActionAdd$setBitmapCache(BitmapCache bitmapCache) {
            this.mNestedViews.setBitmapCache(bitmapCache);
        }

        private final int $$robo$$android_widget_RemoteViews_ViewGroupActionAdd$mergeBehavior() {
            return 1;
        }

        private final boolean $$robo$$android_widget_RemoteViews_ViewGroupActionAdd$prefersAsyncApply() {
            return this.mNestedViews.prefersAsyncApply();
        }

        private final int $$robo$$android_widget_RemoteViews_ViewGroupActionAdd$getActionTag() {
            return 4;
        }

        private void __constructor__(RemoteViews remoteViews, int n, RemoteViews remoteViews2) {
            this.$$robo$$android_widget_RemoteViews_ViewGroupActionAdd$__constructor__(remoteViews, n, remoteViews2);
        }

        ViewGroupActionAdd(RemoteViews remoteViews, int n, RemoteViews remoteViews2) {
            this(remoteViews, n, remoteViews2, -1);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ViewGroupActionAdd$__constructor__(android.widget.RemoteViews int android.widget.RemoteViews ), 0, this, remoteViews, n, remoteViews2);
        }

        private void __constructor__(RemoteViews remoteViews, int n, RemoteViews remoteViews2, int n2) {
            this.$$robo$$android_widget_RemoteViews_ViewGroupActionAdd$__constructor__(remoteViews, n, remoteViews2, n2);
        }

        ViewGroupActionAdd(RemoteViews remoteViews, int n, RemoteViews remoteViews2, int n2) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ViewGroupActionAdd$__constructor__(android.widget.RemoteViews int android.widget.RemoteViews int ), 0, this, remoteViews, n, remoteViews2, n2);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel, BitmapCache bitmapCache, ApplicationInfo applicationInfo, int n, Map<Class, Object> map) {
            this.$$robo$$android_widget_RemoteViews_ViewGroupActionAdd$__constructor__(remoteViews, parcel, bitmapCache, applicationInfo, n, map);
        }

        ViewGroupActionAdd(RemoteViews remoteViews, Parcel parcel, BitmapCache bitmapCache, ApplicationInfo applicationInfo, int n, Map<Class, Object> map) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ViewGroupActionAdd$__constructor__(android.widget.RemoteViews android.os.Parcel android.widget.RemoteViews$BitmapCache android.content.pm.ApplicationInfo int java.util.Map<java.lang.Class, java.lang.Object> ), 0, this, remoteViews, parcel, bitmapCache, applicationInfo, n, map);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_ViewGroupActionAdd$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public boolean hasSameAppInfo(ApplicationInfo applicationInfo) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasSameAppInfo", $$robo$$android_widget_RemoteViews_ViewGroupActionAdd$hasSameAppInfo(android.content.pm.ApplicationInfo ), 0, this, applicationInfo);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_ViewGroupActionAdd$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public Action initActionAsync(ViewTree viewTree, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            return InvokeDynamicSupport.bootstrap("initActionAsync", $$robo$$android_widget_RemoteViews_ViewGroupActionAdd$initActionAsync(android.widget.RemoteViews$ViewTree android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, viewTree, viewGroup, onClickHandler);
        }

        @Override
        public void setBitmapCache(BitmapCache bitmapCache) {
            InvokeDynamicSupport.bootstrap("setBitmapCache", $$robo$$android_widget_RemoteViews_ViewGroupActionAdd$setBitmapCache(android.widget.RemoteViews$BitmapCache ), 0, this, bitmapCache);
        }

        @Override
        public int mergeBehavior() {
            return (int)InvokeDynamicSupport.bootstrap("mergeBehavior", $$robo$$android_widget_RemoteViews_ViewGroupActionAdd$mergeBehavior(), 0, this);
        }

        @Override
        public boolean prefersAsyncApply() {
            return (boolean)InvokeDynamicSupport.bootstrap("prefersAsyncApply", $$robo$$android_widget_RemoteViews_ViewGroupActionAdd$prefersAsyncApply(), 0, this);
        }

        @Override
        public int getActionTag() {
            return (int)InvokeDynamicSupport.bootstrap("getActionTag", $$robo$$android_widget_RemoteViews_ViewGroupActionAdd$getActionTag(), 0, this);
        }

        public /* synthetic */ ViewGroupActionAdd() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewGroupActionAdd)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class RunnableAction
    extends RuntimeAction
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Runnable mRunnable;

        private void $$robo$$android_widget_RemoteViews_RunnableAction$__constructor__(Runnable r) {
            this.mRunnable = r;
        }

        private final void $$robo$$android_widget_RemoteViews_RunnableAction$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            this.mRunnable.run();
        }

        private void __constructor__(Runnable runnable) {
            this.$$robo$$android_widget_RemoteViews_RunnableAction$__constructor__(runnable);
        }

        RunnableAction(Runnable runnable) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_RunnableAction$__constructor__(java.lang.Runnable ), 0, this, runnable);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_RunnableAction$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        public /* synthetic */ RunnableAction() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RunnableAction)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class ReflectionAction
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static int BOOLEAN = 1;
        static int BYTE = 2;
        static int SHORT = 3;
        static int INT = 4;
        static int LONG = 5;
        static int FLOAT = 6;
        static int DOUBLE = 7;
        static int CHAR = 8;
        static int STRING = 9;
        static int CHAR_SEQUENCE = 10;
        static int URI = 11;
        static int BITMAP = 12;
        static int BUNDLE = 13;
        static int INTENT = 14;
        static int COLOR_STATE_LIST = 15;
        static int ICON = 16;
        String methodName;
        int type;
        Object value;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_ReflectionAction$__constructor__(RemoteViews remoteViews, int viewId, String methodName, int type, Object value) {
            this.viewId = viewId;
            this.methodName = methodName;
            this.type = type;
            this.value = value;
        }

        private void $$robo$$android_widget_RemoteViews_ReflectionAction$__constructor__(RemoteViews remoteViews, Parcel in) {
            this.viewId = in.readInt();
            this.methodName = in.readString();
            this.type = in.readInt();
            switch (this.type) {
                case 1: {
                    this.value = in.readBoolean();
                    break;
                }
                case 2: {
                    this.value = in.readByte();
                    break;
                }
                case 3: {
                    this.value = (short)in.readInt();
                    break;
                }
                case 4: {
                    this.value = in.readInt();
                    break;
                }
                case 5: {
                    this.value = in.readLong();
                    break;
                }
                case 6: {
                    this.value = Float.valueOf(in.readFloat());
                    break;
                }
                case 7: {
                    this.value = in.readDouble();
                    break;
                }
                case 8: {
                    this.value = Character.valueOf((char)in.readInt());
                    break;
                }
                case 9: {
                    this.value = in.readString();
                    break;
                }
                case 10: {
                    this.value = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
                    break;
                }
                case 11: {
                    this.value = in.readTypedObject(Uri.CREATOR);
                    break;
                }
                case 12: {
                    this.value = in.readTypedObject(Bitmap.CREATOR);
                    break;
                }
                case 13: {
                    this.value = in.readBundle();
                    break;
                }
                case 14: {
                    this.value = in.readTypedObject(Intent.CREATOR);
                    break;
                }
                case 15: {
                    this.value = in.readTypedObject(ColorStateList.CREATOR);
                    break;
                }
                case 16: {
                    this.value = in.readTypedObject(Icon.CREATOR);
                }
            }
        }

        private final void $$robo$$android_widget_RemoteViews_ReflectionAction$writeToParcel(Parcel out, int flags) {
            out.writeInt(this.viewId);
            out.writeString(this.methodName);
            out.writeInt(this.type);
            switch (this.type) {
                case 1: {
                    out.writeBoolean((Boolean)this.value);
                    break;
                }
                case 2: {
                    out.writeByte((Byte)this.value);
                    break;
                }
                case 3: {
                    out.writeInt(((Short)this.value).shortValue());
                    break;
                }
                case 4: {
                    out.writeInt((Integer)this.value);
                    break;
                }
                case 5: {
                    out.writeLong((Long)this.value);
                    break;
                }
                case 6: {
                    out.writeFloat(((Float)this.value).floatValue());
                    break;
                }
                case 7: {
                    out.writeDouble((Double)this.value);
                    break;
                }
                case 8: {
                    out.writeInt(((Character)this.value).charValue());
                    break;
                }
                case 9: {
                    out.writeString((String)this.value);
                    break;
                }
                case 10: {
                    TextUtils.writeToParcel((CharSequence)this.value, out, flags);
                    break;
                }
                case 13: {
                    out.writeBundle((Bundle)this.value);
                    break;
                }
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: {
                    out.writeTypedObject((Parcelable)this.value, flags);
                    break;
                }
            }
        }

        private final Class<?> $$robo$$android_widget_RemoteViews_ReflectionAction$getParameterType() {
            switch (this.type) {
                case 1: {
                    return Boolean.TYPE;
                }
                case 2: {
                    return Byte.TYPE;
                }
                case 3: {
                    return Short.TYPE;
                }
                case 4: {
                    return Integer.TYPE;
                }
                case 5: {
                    return Long.TYPE;
                }
                case 6: {
                    return Float.TYPE;
                }
                case 7: {
                    return Double.TYPE;
                }
                case 8: {
                    return Character.TYPE;
                }
                case 9: {
                    return String.class;
                }
                case 10: {
                    return CharSequence.class;
                }
                case 11: {
                    return Uri.class;
                }
                case 12: {
                    return Bitmap.class;
                }
                case 13: {
                    return Bundle.class;
                }
                case 14: {
                    return Intent.class;
                }
                case 15: {
                    return ColorStateList.class;
                }
                case 16: {
                    return Icon.class;
                }
            }
            return null;
        }

        private final void $$robo$$android_widget_RemoteViews_ReflectionAction$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Object view = root.findViewById(this.viewId);
            if (view == null) {
                return;
            }
            Class<?> param = this.getParameterType();
            if (param == null) {
                throw new ActionException("bad type: " + this.type);
            }
            try {
                this.this$0.getMethod(view, this.methodName, param, false).invoke((View)view, this.value);
            }
            catch (Throwable ex) {
                throw new ActionException(ex);
            }
        }

        private final Action $$robo$$android_widget_RemoteViews_ReflectionAction$initActionAsync(ViewTree root, ViewGroup rootParent, OnClickHandler handler) {
            Object view = root.findViewById(this.viewId);
            if (view == null) {
                return ACTION_NOOP;
            }
            Class<?> param = this.getParameterType();
            if (param == null) {
                throw new ActionException("bad type: " + this.type);
            }
            try {
                MethodHandle method = this.this$0.getMethod(view, this.methodName, param, true);
                if (method != null) {
                    Runnable endAction = method.invoke((View)view, this.value);
                    if (endAction == null) {
                        return ACTION_NOOP;
                    }
                    if (endAction instanceof ViewStub.ViewReplaceRunnable) {
                        root.createTree();
                        root.findViewTreeById(this.viewId).replaceView(((ViewStub.ViewReplaceRunnable)endAction).view);
                    }
                    return new RunnableAction(endAction);
                }
            }
            catch (Throwable ex) {
                throw new ActionException(ex);
            }
            return this;
        }

        private final int $$robo$$android_widget_RemoteViews_ReflectionAction$mergeBehavior() {
            if (this.methodName.equals("smoothScrollBy")) {
                return 1;
            }
            return 0;
        }

        private final int $$robo$$android_widget_RemoteViews_ReflectionAction$getActionTag() {
            return 2;
        }

        private final String $$robo$$android_widget_RemoteViews_ReflectionAction$getUniqueKey() {
            return super.getUniqueKey() + this.methodName + this.type;
        }

        private final boolean $$robo$$android_widget_RemoteViews_ReflectionAction$prefersAsyncApply() {
            return this.type == 11 || this.type == 16;
        }

        private final void $$robo$$android_widget_RemoteViews_ReflectionAction$visitUris(Consumer<Uri> visitor) {
            switch (this.type) {
                case 11: {
                    Uri uri = (Uri)this.value;
                    visitor.accept(uri);
                    break;
                }
                case 16: {
                    Icon icon = (Icon)this.value;
                    RemoteViews.visitIconUri(icon, visitor);
                }
            }
        }

        private void __constructor__(RemoteViews remoteViews, int n, String string2, int n2, Object object) {
            this.$$robo$$android_widget_RemoteViews_ReflectionAction$__constructor__(remoteViews, n, string2, n2, object);
        }

        ReflectionAction(RemoteViews remoteViews, int n, String string2, int n2, Object object) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ReflectionAction$__constructor__(android.widget.RemoteViews int java.lang.String int java.lang.Object ), 0, this, remoteViews, n, string2, n2, object);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_ReflectionAction$__constructor__(remoteViews, parcel);
        }

        ReflectionAction(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ReflectionAction$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_ReflectionAction$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private Class<?> getParameterType() {
            return InvokeDynamicSupport.bootstrap("getParameterType", $$robo$$android_widget_RemoteViews_ReflectionAction$getParameterType(), 0, this);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_ReflectionAction$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public Action initActionAsync(ViewTree viewTree, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            return InvokeDynamicSupport.bootstrap("initActionAsync", $$robo$$android_widget_RemoteViews_ReflectionAction$initActionAsync(android.widget.RemoteViews$ViewTree android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, viewTree, viewGroup, onClickHandler);
        }

        @Override
        public int mergeBehavior() {
            return (int)InvokeDynamicSupport.bootstrap("mergeBehavior", $$robo$$android_widget_RemoteViews_ReflectionAction$mergeBehavior(), 0, this);
        }

        @Override
        public int getActionTag() {
            return (int)InvokeDynamicSupport.bootstrap("getActionTag", $$robo$$android_widget_RemoteViews_ReflectionAction$getActionTag(), 0, this);
        }

        @Override
        public String getUniqueKey() {
            return InvokeDynamicSupport.bootstrap("getUniqueKey", $$robo$$android_widget_RemoteViews_ReflectionAction$getUniqueKey(), 0, this);
        }

        @Override
        public boolean prefersAsyncApply() {
            return (boolean)InvokeDynamicSupport.bootstrap("prefersAsyncApply", $$robo$$android_widget_RemoteViews_ReflectionAction$prefersAsyncApply(), 0, this);
        }

        @Override
        public void visitUris(Consumer<Uri> consumer) {
            InvokeDynamicSupport.bootstrap("visitUris", $$robo$$android_widget_RemoteViews_ReflectionAction$visitUris(java.util.function.Consumer<android.net.Uri> ), 0, this, consumer);
        }

        public /* synthetic */ ReflectionAction() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ReflectionAction)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class BitmapReflectionAction
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int bitmapId;
        Bitmap bitmap;
        String methodName;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_BitmapReflectionAction$__constructor__(RemoteViews remoteViews, int viewId, String methodName, Bitmap bitmap) {
            this.bitmap = bitmap;
            this.viewId = viewId;
            this.methodName = methodName;
            this.bitmapId = remoteViews.mBitmapCache.getBitmapId(bitmap);
        }

        private void $$robo$$android_widget_RemoteViews_BitmapReflectionAction$__constructor__(RemoteViews remoteViews, Parcel in) {
            this.viewId = in.readInt();
            this.methodName = in.readString();
            this.bitmapId = in.readInt();
            this.bitmap = remoteViews.mBitmapCache.getBitmapForId(this.bitmapId);
        }

        private final void $$robo$$android_widget_RemoteViews_BitmapReflectionAction$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeString(this.methodName);
            dest.writeInt(this.bitmapId);
        }

        private final void $$robo$$android_widget_RemoteViews_BitmapReflectionAction$apply(View root, ViewGroup rootParent, OnClickHandler handler) throws ActionException {
            ReflectionAction ra = new ReflectionAction(this.this$0, this.viewId, this.methodName, 12, this.bitmap);
            ra.apply(root, rootParent, handler);
        }

        private final void $$robo$$android_widget_RemoteViews_BitmapReflectionAction$setBitmapCache(BitmapCache bitmapCache) {
            this.bitmapId = bitmapCache.getBitmapId(this.bitmap);
        }

        private final int $$robo$$android_widget_RemoteViews_BitmapReflectionAction$getActionTag() {
            return 12;
        }

        private void __constructor__(RemoteViews remoteViews, int n, String string2, Bitmap bitmap) {
            this.$$robo$$android_widget_RemoteViews_BitmapReflectionAction$__constructor__(remoteViews, n, string2, bitmap);
        }

        BitmapReflectionAction(RemoteViews remoteViews, int n, String string2, Bitmap bitmap) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_BitmapReflectionAction$__constructor__(android.widget.RemoteViews int java.lang.String android.graphics.Bitmap ), 0, this, remoteViews, n, string2, bitmap);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_BitmapReflectionAction$__constructor__(remoteViews, parcel);
        }

        BitmapReflectionAction(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_BitmapReflectionAction$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_BitmapReflectionAction$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) throws ActionException {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_BitmapReflectionAction$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public void setBitmapCache(BitmapCache bitmapCache) {
            InvokeDynamicSupport.bootstrap("setBitmapCache", $$robo$$android_widget_RemoteViews_BitmapReflectionAction$setBitmapCache(android.widget.RemoteViews$BitmapCache ), 0, this, bitmapCache);
        }

        @Override
        public int getActionTag() {
            return (int)InvokeDynamicSupport.bootstrap("getActionTag", $$robo$$android_widget_RemoteViews_BitmapReflectionAction$getActionTag(), 0, this);
        }

        public /* synthetic */ BitmapReflectionAction() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BitmapReflectionAction)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class BitmapCache
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        ArrayList<Bitmap> mBitmaps;
        int mBitmapMemory;

        private void $$robo$$android_widget_RemoteViews_BitmapCache$__constructor__() {
            this.mBitmapMemory = -1;
            this.mBitmaps = new ArrayList();
        }

        private void $$robo$$android_widget_RemoteViews_BitmapCache$__constructor__(Parcel source) {
            this.mBitmapMemory = -1;
            this.mBitmaps = source.createTypedArrayList(Bitmap.CREATOR);
        }

        private final int $$robo$$android_widget_RemoteViews_BitmapCache$getBitmapId(Bitmap b) {
            if (b == null) {
                return -1;
            }
            if (this.mBitmaps.contains(b)) {
                return this.mBitmaps.indexOf(b);
            }
            this.mBitmaps.add(b);
            this.mBitmapMemory = -1;
            return this.mBitmaps.size() - 1;
        }

        private final Bitmap $$robo$$android_widget_RemoteViews_BitmapCache$getBitmapForId(int id2) {
            if (id2 == -1 || id2 >= this.mBitmaps.size()) {
                return null;
            }
            return this.mBitmaps.get(id2);
        }

        private final void $$robo$$android_widget_RemoteViews_BitmapCache$writeBitmapsToParcel(Parcel dest, int flags) {
            dest.writeTypedList(this.mBitmaps, flags);
        }

        private final int $$robo$$android_widget_RemoteViews_BitmapCache$getBitmapMemory() {
            if (this.mBitmapMemory < 0) {
                this.mBitmapMemory = 0;
                int count = this.mBitmaps.size();
                for (int i = 0; i < count; ++i) {
                    this.mBitmapMemory += this.mBitmaps.get(i).getAllocationByteCount();
                }
            }
            return this.mBitmapMemory;
        }

        private void __constructor__() {
            this.$$robo$$android_widget_RemoteViews_BitmapCache$__constructor__();
        }

        public BitmapCache() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_BitmapCache$__constructor__(), 0, this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_BitmapCache$__constructor__(parcel);
        }

        public BitmapCache(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_BitmapCache$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        public int getBitmapId(Bitmap bitmap) {
            return (int)InvokeDynamicSupport.bootstrap("getBitmapId", $$robo$$android_widget_RemoteViews_BitmapCache$getBitmapId(android.graphics.Bitmap ), 0, this, bitmap);
        }

        public Bitmap getBitmapForId(int n) {
            return InvokeDynamicSupport.bootstrap("getBitmapForId", $$robo$$android_widget_RemoteViews_BitmapCache$getBitmapForId(int ), 0, this, n);
        }

        public void writeBitmapsToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeBitmapsToParcel", $$robo$$android_widget_RemoteViews_BitmapCache$writeBitmapsToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public int getBitmapMemory() {
            return (int)InvokeDynamicSupport.bootstrap("getBitmapMemory", $$robo$$android_widget_RemoteViews_BitmapCache$getBitmapMemory(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BitmapCache)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class ViewContentNavigation
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        boolean mNext;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_ViewContentNavigation$__constructor__(RemoteViews remoteViews, int viewId, boolean next) {
            this.viewId = viewId;
            this.mNext = next;
        }

        private void $$robo$$android_widget_RemoteViews_ViewContentNavigation$__constructor__(RemoteViews remoteViews, Parcel in) {
            this.viewId = in.readInt();
            this.mNext = in.readBoolean();
        }

        private final void $$robo$$android_widget_RemoteViews_ViewContentNavigation$writeToParcel(Parcel out, int flags) {
            out.writeInt(this.viewId);
            out.writeBoolean(this.mNext);
        }

        private final void $$robo$$android_widget_RemoteViews_ViewContentNavigation$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Object view = root.findViewById(this.viewId);
            if (view == null) {
                return;
            }
            try {
                this.this$0.getMethod(view, this.mNext ? "showNext" : "showPrevious", null, false).invoke((View)view);
            }
            catch (Throwable ex) {
                throw new ActionException(ex);
            }
        }

        private final int $$robo$$android_widget_RemoteViews_ViewContentNavigation$mergeBehavior() {
            return 2;
        }

        private final int $$robo$$android_widget_RemoteViews_ViewContentNavigation$getActionTag() {
            return 5;
        }

        private void __constructor__(RemoteViews remoteViews, int n, boolean bl) {
            this.$$robo$$android_widget_RemoteViews_ViewContentNavigation$__constructor__(remoteViews, n, bl);
        }

        ViewContentNavigation(RemoteViews remoteViews, int n, boolean bl) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ViewContentNavigation$__constructor__(android.widget.RemoteViews int boolean ), 0, this, remoteViews, n, bl);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_ViewContentNavigation$__constructor__(remoteViews, parcel);
        }

        ViewContentNavigation(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ViewContentNavigation$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_ViewContentNavigation$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_ViewContentNavigation$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public int mergeBehavior() {
            return (int)InvokeDynamicSupport.bootstrap("mergeBehavior", $$robo$$android_widget_RemoteViews_ViewContentNavigation$mergeBehavior(), 0, this);
        }

        @Override
        public int getActionTag() {
            return (int)InvokeDynamicSupport.bootstrap("getActionTag", $$robo$$android_widget_RemoteViews_ViewContentNavigation$getActionTag(), 0, this);
        }

        public /* synthetic */ ViewContentNavigation() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewContentNavigation)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SetDrawableTint
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        boolean targetBackground;
        int colorFilter;
        PorterDuff.Mode filterMode;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_SetDrawableTint$__constructor__(RemoteViews remoteViews, int id2, boolean targetBackground, int colorFilter, PorterDuff.Mode mode) {
            this.viewId = id2;
            this.targetBackground = targetBackground;
            this.colorFilter = colorFilter;
            this.filterMode = mode;
        }

        private void $$robo$$android_widget_RemoteViews_SetDrawableTint$__constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.viewId = parcel.readInt();
            this.targetBackground = parcel.readInt() != 0;
            this.colorFilter = parcel.readInt();
            this.filterMode = PorterDuff.intToMode(parcel.readInt());
        }

        private final void $$robo$$android_widget_RemoteViews_SetDrawableTint$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeInt(this.targetBackground ? 1 : 0);
            dest.writeInt(this.colorFilter);
            dest.writeInt(PorterDuff.modeToInt(this.filterMode));
        }

        private final void $$robo$$android_widget_RemoteViews_SetDrawableTint$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            Drawable targetDrawable = null;
            if (this.targetBackground) {
                targetDrawable = ((View)target).getBackground();
            } else if (target instanceof ImageView) {
                ImageView imageView = (ImageView)target;
                targetDrawable = imageView.getDrawable();
            }
            if (targetDrawable != null) {
                targetDrawable.mutate().setColorFilter(this.colorFilter, this.filterMode);
            }
        }

        private final int $$robo$$android_widget_RemoteViews_SetDrawableTint$getActionTag() {
            return 3;
        }

        private void __constructor__(RemoteViews remoteViews, int n, boolean bl, int n2, PorterDuff.Mode mode) {
            this.$$robo$$android_widget_RemoteViews_SetDrawableTint$__constructor__(remoteViews, n, bl, n2, mode);
        }

        SetDrawableTint(RemoteViews remoteViews, int n, boolean bl, int n2, PorterDuff.Mode mode) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetDrawableTint$__constructor__(android.widget.RemoteViews int boolean int android.graphics.PorterDuff$Mode ), 0, this, remoteViews, n, bl, n2, mode);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_SetDrawableTint$__constructor__(remoteViews, parcel);
        }

        SetDrawableTint(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetDrawableTint$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_SetDrawableTint$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_SetDrawableTint$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public int getActionTag() {
            return (int)InvokeDynamicSupport.bootstrap("getActionTag", $$robo$$android_widget_RemoteViews_SetDrawableTint$getActionTag(), 0, this);
        }

        public /* synthetic */ SetDrawableTint() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SetDrawableTint)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SetOnClickPendingIntent
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        PendingIntent pendingIntent;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$__constructor__(RemoteViews remoteViews, int id2, PendingIntent pendingIntent) {
            this.viewId = id2;
            this.pendingIntent = pendingIntent;
        }

        private void $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$__constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.viewId = parcel.readInt();
            this.pendingIntent = PendingIntent.readPendingIntentOrNullFromParcel(parcel);
        }

        private final void $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            PendingIntent.writePendingIntentOrNullToParcel(this.pendingIntent, dest);
        }

        private final void $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (this.this$0.mIsWidgetCollectionChild) {
                Log.w("RemoteViews", "Cannot setOnClickPendingIntent for collection item (id: " + this.viewId + ")");
                ApplicationInfo appInfo = root.getContext().getApplicationInfo();
                if (appInfo != null && appInfo.targetSdkVersion >= 16) {
                    return;
                }
            }
            View.OnClickListener listener = null;
            if (this.pendingIntent != null) {
                listener = new View.OnClickListener(this, handler){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ OnClickHandler val$handler;
                    /* synthetic */ SetOnClickPendingIntent this$1;

                    private void $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent_1$__constructor__(SetOnClickPendingIntent this$1, OnClickHandler onClickHandler) {
                    }

                    private final void $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent_1$onClick(View v) {
                        Rect rect = RemoteViews.getSourceBounds(v);
                        Intent intent = new Intent();
                        intent.setSourceBounds(rect);
                        this.val$handler.onClickHandler(v, this.this$1.pendingIntent, intent);
                    }

                    private void __constructor__(SetOnClickPendingIntent setOnClickPendingIntent, OnClickHandler onClickHandler) {
                        this.$$robo$$android_widget_RemoteViews_SetOnClickPendingIntent_1$__constructor__(setOnClickPendingIntent, onClickHandler);
                    }
                    {
                        this.this$1 = setOnClickPendingIntent;
                        this.val$handler = onClickHandler;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent_1$__constructor__(android.widget.RemoteViews$SetOnClickPendingIntent android.widget.RemoteViews$OnClickHandler ), 0, this, setOnClickPendingIntent, onClickHandler);
                    }

                    @Override
                    public void onClick(View view) {
                        InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent_1$onClick(android.view.View ), 0, this, view);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
            }
            ((View)target).setTagInternal(16909165, this.pendingIntent);
            ((View)target).setOnClickListener(listener);
        }

        private final int $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$getActionTag() {
            return 1;
        }

        private void __constructor__(RemoteViews remoteViews, int n, PendingIntent pendingIntent) {
            this.$$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$__constructor__(remoteViews, n, pendingIntent);
        }

        public SetOnClickPendingIntent(RemoteViews remoteViews, int n, PendingIntent pendingIntent) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$__constructor__(android.widget.RemoteViews int android.app.PendingIntent ), 0, this, remoteViews, n, pendingIntent);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$__constructor__(remoteViews, parcel);
        }

        public SetOnClickPendingIntent(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public int getActionTag() {
            return (int)InvokeDynamicSupport.bootstrap("getActionTag", $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$getActionTag(), 0, this);
        }

        public /* synthetic */ SetOnClickPendingIntent() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SetOnClickPendingIntent)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SetRemoteViewsAdapterIntent
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Intent intent;
        boolean isAsync;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$__constructor__(RemoteViews remoteViews, int id2, Intent intent) {
            this.isAsync = false;
            this.viewId = id2;
            this.intent = intent;
        }

        private void $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$__constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.isAsync = false;
            this.viewId = parcel.readInt();
            this.intent = parcel.readTypedObject(Intent.CREATOR);
        }

        private final void $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeTypedObject(this.intent, flags);
        }

        private final void $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (!(rootParent instanceof AppWidgetHostView)) {
                Log.e("RemoteViews", "SetRemoteViewsAdapterIntent action can only be used for AppWidgets (root id: " + this.viewId + ")");
                return;
            }
            if (!(target instanceof AbsListView) && !(target instanceof AdapterViewAnimator)) {
                Log.e("RemoteViews", "Cannot setRemoteViewsAdapter on a view which is not an AbsListView or AdapterViewAnimator (id: " + this.viewId + ")");
                return;
            }
            AppWidgetHostView host = (AppWidgetHostView)rootParent;
            this.intent.putExtra("remoteAdapterAppWidgetId", host.getAppWidgetId());
            if (target instanceof AbsListView) {
                AbsListView v = (AbsListView)target;
                v.setRemoteViewsAdapter(this.intent, this.isAsync);
                v.setRemoteViewsOnClickHandler(handler);
            } else if (target instanceof AdapterViewAnimator) {
                AdapterViewAnimator v = (AdapterViewAnimator)target;
                v.setRemoteViewsAdapter(this.intent, this.isAsync);
                v.setRemoteViewsOnClickHandler(handler);
            }
        }

        private final Action $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$initActionAsync(ViewTree root, ViewGroup rootParent, OnClickHandler handler) {
            SetRemoteViewsAdapterIntent copy = new SetRemoteViewsAdapterIntent(this.this$0, this.viewId, this.intent);
            copy.isAsync = true;
            return copy;
        }

        private final int $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$getActionTag() {
            return 10;
        }

        private void __constructor__(RemoteViews remoteViews, int n, Intent intent) {
            this.$$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$__constructor__(remoteViews, n, intent);
        }

        public SetRemoteViewsAdapterIntent(RemoteViews remoteViews, int n, Intent intent) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$__constructor__(android.widget.RemoteViews int android.content.Intent ), 0, this, remoteViews, n, intent);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$__constructor__(remoteViews, parcel);
        }

        public SetRemoteViewsAdapterIntent(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public Action initActionAsync(ViewTree viewTree, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            return InvokeDynamicSupport.bootstrap("initActionAsync", $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$initActionAsync(android.widget.RemoteViews$ViewTree android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, viewTree, viewGroup, onClickHandler);
        }

        @Override
        public int getActionTag() {
            return (int)InvokeDynamicSupport.bootstrap("getActionTag", $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$getActionTag(), 0, this);
        }

        public /* synthetic */ SetRemoteViewsAdapterIntent() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SetRemoteViewsAdapterIntent)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SetRemoteViewsAdapterList
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int viewTypeCount;
        ArrayList<RemoteViews> list;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$__constructor__(RemoteViews remoteViews, int id2, ArrayList<RemoteViews> list, int viewTypeCount) {
            this.viewId = id2;
            this.list = list;
            this.viewTypeCount = viewTypeCount;
        }

        private void $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$__constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.viewId = parcel.readInt();
            this.viewTypeCount = parcel.readInt();
            this.list = parcel.createTypedArrayList(CREATOR);
        }

        private final void $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeInt(this.viewTypeCount);
            dest.writeTypedList(this.list, flags);
        }

        private final void $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (!(rootParent instanceof AppWidgetHostView)) {
                Log.e("RemoteViews", "SetRemoteViewsAdapterIntent action can only be used for AppWidgets (root id: " + this.viewId + ")");
                return;
            }
            if (!(target instanceof AbsListView) && !(target instanceof AdapterViewAnimator)) {
                Log.e("RemoteViews", "Cannot setRemoteViewsAdapter on a view which is not an AbsListView or AdapterViewAnimator (id: " + this.viewId + ")");
                return;
            }
            if (target instanceof AbsListView) {
                AbsListView v = (AbsListView)target;
                Object a = v.getAdapter();
                if (a instanceof RemoteViewsListAdapter && this.viewTypeCount <= a.getViewTypeCount()) {
                    ((RemoteViewsListAdapter)a).setViewsList(this.list);
                } else {
                    v.setAdapter(new RemoteViewsListAdapter(v.getContext(), this.list, this.viewTypeCount));
                }
            } else if (target instanceof AdapterViewAnimator) {
                AdapterViewAnimator v = (AdapterViewAnimator)target;
                Adapter a = v.getAdapter();
                if (a instanceof RemoteViewsListAdapter && this.viewTypeCount <= a.getViewTypeCount()) {
                    ((RemoteViewsListAdapter)a).setViewsList(this.list);
                } else {
                    v.setAdapter(new RemoteViewsListAdapter(v.getContext(), this.list, this.viewTypeCount));
                }
            }
        }

        private final int $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$getActionTag() {
            return 15;
        }

        private void __constructor__(RemoteViews remoteViews, int n, ArrayList<RemoteViews> arrayList, int n2) {
            this.$$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$__constructor__(remoteViews, n, arrayList, n2);
        }

        public SetRemoteViewsAdapterList(RemoteViews remoteViews, int n, ArrayList<RemoteViews> arrayList, int n2) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$__constructor__(android.widget.RemoteViews int java.util.ArrayList<android.widget.RemoteViews> int ), 0, this, remoteViews, n, arrayList, n2);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$__constructor__(remoteViews, parcel);
        }

        public SetRemoteViewsAdapterList(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public int getActionTag() {
            return (int)InvokeDynamicSupport.bootstrap("getActionTag", $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$getActionTag(), 0, this);
        }

        public /* synthetic */ SetRemoteViewsAdapterList() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SetRemoteViewsAdapterList)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SetPendingIntentTemplate
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        PendingIntent pendingIntentTemplate;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$__constructor__(RemoteViews remoteViews, int id2, PendingIntent pendingIntentTemplate) {
            this.viewId = id2;
            this.pendingIntentTemplate = pendingIntentTemplate;
        }

        private void $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$__constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.viewId = parcel.readInt();
            this.pendingIntentTemplate = PendingIntent.readPendingIntentOrNullFromParcel(parcel);
        }

        private final void $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            PendingIntent.writePendingIntentOrNullToParcel(this.pendingIntentTemplate, dest);
        }

        private final void $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (!(target instanceof AdapterView)) {
                Log.e("RemoteViews", "Cannot setPendingIntentTemplate on a view which is notan AdapterView (id: " + this.viewId + ")");
                return;
            }
            AdapterView av = (AdapterView)target;
            AdapterView.OnItemClickListener listener = new AdapterView.OnItemClickListener(this, handler){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ OnClickHandler val$handler;
                /* synthetic */ SetPendingIntentTemplate this$1;

                private void $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate_1$__constructor__(SetPendingIntentTemplate this$1, OnClickHandler onClickHandler) {
                }

                private final void $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate_1$onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    if (view instanceof ViewGroup) {
                        ViewGroup vg = (ViewGroup)view;
                        if (parent instanceof AdapterViewAnimator) {
                            vg = (ViewGroup)vg.getChildAt(0);
                        }
                        if (vg == null) {
                            return;
                        }
                        Intent fillInIntent = null;
                        int childCount = vg.getChildCount();
                        for (int i = 0; i < childCount; ++i) {
                            Object tag = vg.getChildAt(i).getTag(16908877);
                            if (!(tag instanceof Intent)) continue;
                            fillInIntent = (Intent)tag;
                            break;
                        }
                        if (fillInIntent == null) {
                            return;
                        }
                        Rect rect = RemoteViews.getSourceBounds(view);
                        Intent intent = new Intent();
                        intent.setSourceBounds(rect);
                        this.val$handler.onClickHandler(view, this.this$1.pendingIntentTemplate, fillInIntent);
                    }
                }

                private void __constructor__(SetPendingIntentTemplate setPendingIntentTemplate, OnClickHandler onClickHandler) {
                    this.$$robo$$android_widget_RemoteViews_SetPendingIntentTemplate_1$__constructor__(setPendingIntentTemplate, onClickHandler);
                }
                {
                    this.this$1 = setPendingIntentTemplate;
                    this.val$handler = onClickHandler;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate_1$__constructor__(android.widget.RemoteViews$SetPendingIntentTemplate android.widget.RemoteViews$OnClickHandler ), 0, this, setPendingIntentTemplate, onClickHandler);
                }

                @Override
                public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                    InvokeDynamicSupport.bootstrap("onItemClick", $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate_1$onItemClick(android.widget.AdapterView<?> android.view.View int long ), 0, this, adapterView, view, n, l);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            av.setOnItemClickListener(listener);
            av.setTag(this.pendingIntentTemplate);
        }

        private final int $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$getActionTag() {
            return 8;
        }

        private void __constructor__(RemoteViews remoteViews, int n, PendingIntent pendingIntent) {
            this.$$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$__constructor__(remoteViews, n, pendingIntent);
        }

        public SetPendingIntentTemplate(RemoteViews remoteViews, int n, PendingIntent pendingIntent) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$__constructor__(android.widget.RemoteViews int android.app.PendingIntent ), 0, this, remoteViews, n, pendingIntent);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$__constructor__(remoteViews, parcel);
        }

        public SetPendingIntentTemplate(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public int getActionTag() {
            return (int)InvokeDynamicSupport.bootstrap("getActionTag", $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$getActionTag(), 0, this);
        }

        public /* synthetic */ SetPendingIntentTemplate() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SetPendingIntentTemplate)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SetOnClickFillInIntent
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Intent fillInIntent;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$__constructor__(RemoteViews remoteViews, int id2, Intent fillInIntent) {
            this.viewId = id2;
            this.fillInIntent = fillInIntent;
        }

        private void $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$__constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.viewId = parcel.readInt();
            this.fillInIntent = parcel.readTypedObject(Intent.CREATOR);
        }

        private final void $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.viewId);
            dest.writeTypedObject(this.fillInIntent, 0);
        }

        private final void $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (!this.this$0.mIsWidgetCollectionChild) {
                Log.e("RemoteViews", "The method setOnClickFillInIntent is available only from RemoteViewsFactory (ie. on collection items).");
                return;
            }
            if (target == root) {
                ((View)target).setTagInternal(16908877, this.fillInIntent);
            } else if (this.fillInIntent != null) {
                View.OnClickListener listener = new View.OnClickListener(this, handler){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ OnClickHandler val$handler;
                    /* synthetic */ SetOnClickFillInIntent this$1;

                    private void $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent_1$__constructor__(SetOnClickFillInIntent this$1, OnClickHandler onClickHandler) {
                    }

                    private final void $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent_1$onClick(View v) {
                        View parent;
                        for (parent = (View)((Object)v.getParent()); !(parent == null || parent instanceof AdapterView || parent instanceof AppWidgetHostView && !(parent instanceof RemoteViewsAdapter.RemoteViewsFrameLayout)); parent = (View)((Object)parent.getParent())) {
                        }
                        if (!(parent instanceof AdapterView)) {
                            Log.e("RemoteViews", "Collection item doesn't have AdapterView parent");
                            return;
                        }
                        if (!(parent.getTag() instanceof PendingIntent)) {
                            Log.e("RemoteViews", "Attempting setOnClickFillInIntent without calling setPendingIntentTemplate on parent.");
                            return;
                        }
                        PendingIntent pendingIntent = (PendingIntent)parent.getTag();
                        Rect rect = RemoteViews.getSourceBounds(v);
                        this.this$1.fillInIntent.setSourceBounds(rect);
                        this.val$handler.onClickHandler(v, pendingIntent, this.this$1.fillInIntent);
                    }

                    private void __constructor__(SetOnClickFillInIntent setOnClickFillInIntent, OnClickHandler onClickHandler) {
                        this.$$robo$$android_widget_RemoteViews_SetOnClickFillInIntent_1$__constructor__(setOnClickFillInIntent, onClickHandler);
                    }
                    {
                        this.this$1 = setOnClickFillInIntent;
                        this.val$handler = onClickHandler;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent_1$__constructor__(android.widget.RemoteViews$SetOnClickFillInIntent android.widget.RemoteViews$OnClickHandler ), 0, this, setOnClickFillInIntent, onClickHandler);
                    }

                    @Override
                    public void onClick(View view) {
                        InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent_1$onClick(android.view.View ), 0, this, view);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
                ((View)target).setOnClickListener(listener);
            }
        }

        private final int $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$getActionTag() {
            return 9;
        }

        private void __constructor__(RemoteViews remoteViews, int n, Intent intent) {
            this.$$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$__constructor__(remoteViews, n, intent);
        }

        public SetOnClickFillInIntent(RemoteViews remoteViews, int n, Intent intent) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$__constructor__(android.widget.RemoteViews int android.content.Intent ), 0, this, remoteViews, n, intent);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$__constructor__(remoteViews, parcel);
        }

        public SetOnClickFillInIntent(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public int getActionTag() {
            return (int)InvokeDynamicSupport.bootstrap("getActionTag", $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$getActionTag(), 0, this);
        }

        public /* synthetic */ SetOnClickFillInIntent() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SetOnClickFillInIntent)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SetEmptyView
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int emptyViewId;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_SetEmptyView$__constructor__(RemoteViews remoteViews, int viewId, int emptyViewId) {
            this.viewId = viewId;
            this.emptyViewId = emptyViewId;
        }

        private void $$robo$$android_widget_RemoteViews_SetEmptyView$__constructor__(RemoteViews remoteViews, Parcel in) {
            this.viewId = in.readInt();
            this.emptyViewId = in.readInt();
        }

        private final void $$robo$$android_widget_RemoteViews_SetEmptyView$writeToParcel(Parcel out, int flags) {
            out.writeInt(this.viewId);
            out.writeInt(this.emptyViewId);
        }

        private final void $$robo$$android_widget_RemoteViews_SetEmptyView$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Object view = root.findViewById(this.viewId);
            if (!(view instanceof AdapterView)) {
                return;
            }
            AdapterView adapterView = (AdapterView)view;
            Object emptyView = root.findViewById(this.emptyViewId);
            if (emptyView == null) {
                return;
            }
            adapterView.setEmptyView((View)emptyView);
        }

        private final int $$robo$$android_widget_RemoteViews_SetEmptyView$getActionTag() {
            return 6;
        }

        private void __constructor__(RemoteViews remoteViews, int n, int n2) {
            this.$$robo$$android_widget_RemoteViews_SetEmptyView$__constructor__(remoteViews, n, n2);
        }

        SetEmptyView(RemoteViews remoteViews, int n, int n2) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetEmptyView$__constructor__(android.widget.RemoteViews int int ), 0, this, remoteViews, n, n2);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_SetEmptyView$__constructor__(remoteViews, parcel);
        }

        SetEmptyView(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetEmptyView$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_SetEmptyView$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_SetEmptyView$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public int getActionTag() {
            return (int)InvokeDynamicSupport.bootstrap("getActionTag", $$robo$$android_widget_RemoteViews_SetEmptyView$getActionTag(), 0, this);
        }

        public /* synthetic */ SetEmptyView() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SetEmptyView)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class RemoteViewsContextWrapper
    extends ContextWrapper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Context mContextForResources;

        private void $$robo$$android_widget_RemoteViews_RemoteViewsContextWrapper$__constructor__(Context context, Context contextForResources) {
            this.mContextForResources = contextForResources;
        }

        private final Resources $$robo$$android_widget_RemoteViews_RemoteViewsContextWrapper$getResources() {
            return this.mContextForResources.getResources();
        }

        private final Resources.Theme $$robo$$android_widget_RemoteViews_RemoteViewsContextWrapper$getTheme() {
            return this.mContextForResources.getTheme();
        }

        private final String $$robo$$android_widget_RemoteViews_RemoteViewsContextWrapper$getPackageName() {
            return this.mContextForResources.getPackageName();
        }

        private void __constructor__(Context context, Context context2) {
            this.$$robo$$android_widget_RemoteViews_RemoteViewsContextWrapper$__constructor__(context, context2);
        }

        RemoteViewsContextWrapper(Context context, Context context2) {
            super(context);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_RemoteViewsContextWrapper$__constructor__(android.content.Context android.content.Context ), 0, this, context, context2);
        }

        @Override
        public Resources getResources() {
            return InvokeDynamicSupport.bootstrap("getResources", $$robo$$android_widget_RemoteViews_RemoteViewsContextWrapper$getResources(), 0, this);
        }

        @Override
        public Resources.Theme getTheme() {
            return InvokeDynamicSupport.bootstrap("getTheme", $$robo$$android_widget_RemoteViews_RemoteViewsContextWrapper$getTheme(), 0, this);
        }

        @Override
        public String getPackageName() {
            return InvokeDynamicSupport.bootstrap("getPackageName", $$robo$$android_widget_RemoteViews_RemoteViewsContextWrapper$getPackageName(), 0, this);
        }

        public /* synthetic */ RemoteViewsContextWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RemoteViewsContextWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static abstract class RuntimeAction
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_widget_RemoteViews_RuntimeAction$__constructor__() {
        }

        private final int $$robo$$android_widget_RemoteViews_RuntimeAction$getActionTag() {
            return 0;
        }

        private final void $$robo$$android_widget_RemoteViews_RuntimeAction$writeToParcel(Parcel dest, int flags) {
            throw new UnsupportedOperationException();
        }

        private /* synthetic */ void $$robo$$android_widget_RemoteViews_RuntimeAction$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_widget_RemoteViews_RuntimeAction$__constructor__();
        }

        private RuntimeAction() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_RuntimeAction$__constructor__(), 0, this);
        }

        @Override
        public int getActionTag() {
            return (int)InvokeDynamicSupport.bootstrap("getActionTag", $$robo$$android_widget_RemoteViews_RuntimeAction$getActionTag(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_RuntimeAction$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_widget_RemoteViews_RuntimeAction$__constructor__(var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RuntimeAction)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static abstract class Action
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int MERGE_REPLACE = 0;
        public static int MERGE_APPEND = 1;
        public static int MERGE_IGNORE = 2;
        int viewId;

        private void $$robo$$android_widget_RemoteViews_Action$__constructor__() {
        }

        public abstract void apply(View var1, ViewGroup var2, OnClickHandler var3) throws ActionException;

        private final int $$robo$$android_widget_RemoteViews_Action$describeContents() {
            return 0;
        }

        private final void $$robo$$android_widget_RemoteViews_Action$setBitmapCache(BitmapCache bitmapCache) {
        }

        private final int $$robo$$android_widget_RemoteViews_Action$mergeBehavior() {
            return 0;
        }

        public abstract int getActionTag();

        private final String $$robo$$android_widget_RemoteViews_Action$getUniqueKey() {
            return this.getActionTag() + "_" + this.viewId;
        }

        private final Action $$robo$$android_widget_RemoteViews_Action$initActionAsync(ViewTree root, ViewGroup rootParent, OnClickHandler handler) {
            return this;
        }

        private final boolean $$robo$$android_widget_RemoteViews_Action$prefersAsyncApply() {
            return false;
        }

        private final boolean $$robo$$android_widget_RemoteViews_Action$hasSameAppInfo(ApplicationInfo parentInfo) {
            return true;
        }

        private final void $$robo$$android_widget_RemoteViews_Action$visitUris(Consumer<Uri> visitor) {
        }

        private /* synthetic */ void $$robo$$android_widget_RemoteViews_Action$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_widget_RemoteViews_Action$__constructor__();
        }

        private Action() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_Action$__constructor__(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_widget_RemoteViews_Action$describeContents(), 0, this);
        }

        public void setBitmapCache(BitmapCache bitmapCache) {
            InvokeDynamicSupport.bootstrap("setBitmapCache", $$robo$$android_widget_RemoteViews_Action$setBitmapCache(android.widget.RemoteViews$BitmapCache ), 0, this, bitmapCache);
        }

        public int mergeBehavior() {
            return (int)InvokeDynamicSupport.bootstrap("mergeBehavior", $$robo$$android_widget_RemoteViews_Action$mergeBehavior(), 0, this);
        }

        public String getUniqueKey() {
            return InvokeDynamicSupport.bootstrap("getUniqueKey", $$robo$$android_widget_RemoteViews_Action$getUniqueKey(), 0, this);
        }

        public Action initActionAsync(ViewTree viewTree, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            return InvokeDynamicSupport.bootstrap("initActionAsync", $$robo$$android_widget_RemoteViews_Action$initActionAsync(android.widget.RemoteViews$ViewTree android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, viewTree, viewGroup, onClickHandler);
        }

        public boolean prefersAsyncApply() {
            return (boolean)InvokeDynamicSupport.bootstrap("prefersAsyncApply", $$robo$$android_widget_RemoteViews_Action$prefersAsyncApply(), 0, this);
        }

        public boolean hasSameAppInfo(ApplicationInfo applicationInfo) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasSameAppInfo", $$robo$$android_widget_RemoteViews_Action$hasSameAppInfo(android.content.pm.ApplicationInfo ), 0, this, applicationInfo);
        }

        public void visitUris(Consumer<Uri> consumer) {
            InvokeDynamicSupport.bootstrap("visitUris", $$robo$$android_widget_RemoteViews_Action$visitUris(java.util.function.Consumer<android.net.Uri> ), 0, this, consumer);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_widget_RemoteViews_Action$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Action)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class OnClickHandler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mEnterAnimationId;

        private void $$robo$$android_widget_RemoteViews_OnClickHandler$__constructor__() {
        }

        private final boolean $$robo$$android_widget_RemoteViews_OnClickHandler$onClickHandler(View view, PendingIntent pendingIntent, Intent fillInIntent) {
            return this.onClickHandler(view, pendingIntent, fillInIntent, 0);
        }

        private final boolean $$robo$$android_widget_RemoteViews_OnClickHandler$onClickHandler(View view, PendingIntent pendingIntent, Intent fillInIntent, int windowingMode) {
            try {
                Context context = view.getContext();
                ActivityOptions opts = this.mEnterAnimationId != 0 ? ActivityOptions.makeCustomAnimation(context, this.mEnterAnimationId, 0) : ActivityOptions.makeBasic();
                if (windowingMode != 0) {
                    opts.setLaunchWindowingMode(windowingMode);
                }
                context.startIntentSender(pendingIntent.getIntentSender(), fillInIntent, 0x10000000, 0x10000000, 0, opts.toBundle());
            }
            catch (IntentSender.SendIntentException e) {
                Log.e("RemoteViews", "Cannot send pending intent: ", e);
                return false;
            }
            catch (Exception e) {
                Log.e("RemoteViews", "Cannot send pending intent due to unknown exception: ", e);
                return false;
            }
            return true;
        }

        private final void $$robo$$android_widget_RemoteViews_OnClickHandler$setEnterAnimationId(int enterAnimationId) {
            this.mEnterAnimationId = enterAnimationId;
        }

        private void __constructor__() {
            this.$$robo$$android_widget_RemoteViews_OnClickHandler$__constructor__();
        }

        public OnClickHandler() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_OnClickHandler$__constructor__(), 0, this);
        }

        public boolean onClickHandler(View view, PendingIntent pendingIntent, Intent intent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onClickHandler", $$robo$$android_widget_RemoteViews_OnClickHandler$onClickHandler(android.view.View android.app.PendingIntent android.content.Intent ), 0, this, view, pendingIntent, intent);
        }

        public boolean onClickHandler(View view, PendingIntent pendingIntent, Intent intent, int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("onClickHandler", $$robo$$android_widget_RemoteViews_OnClickHandler$onClickHandler(android.view.View android.app.PendingIntent android.content.Intent int ), 0, this, view, pendingIntent, intent, n);
        }

        public void setEnterAnimationId(int n) {
            InvokeDynamicSupport.bootstrap("setEnterAnimationId", $$robo$$android_widget_RemoteViews_OnClickHandler$setEnterAnimationId(int ), 0, this, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OnClickHandler)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ActionException
    extends RuntimeException
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_widget_RemoteViews_ActionException$__constructor__(Exception ex) {
        }

        private void $$robo$$android_widget_RemoteViews_ActionException$__constructor__(String message) {
        }

        private void $$robo$$android_widget_RemoteViews_ActionException$__constructor__(Throwable t) {
        }

        private void __constructor__(Exception exception) {
            this.$$robo$$android_widget_RemoteViews_ActionException$__constructor__(exception);
        }

        public ActionException(Exception exception) {
            super(exception);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ActionException$__constructor__(java.lang.Exception ), 0, this, exception);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_widget_RemoteViews_ActionException$__constructor__(string2);
        }

        public ActionException(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ActionException$__constructor__(java.lang.String ), 0, this, string2);
        }

        private void __constructor__(Throwable throwable) {
            this.$$robo$$android_widget_RemoteViews_ActionException$__constructor__(throwable);
        }

        public ActionException(Throwable throwable) {
            super(throwable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ActionException$__constructor__(java.lang.Throwable ), 0, this, throwable);
        }

        public /* synthetic */ ActionException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActionException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RemoteView {
    }

    public static class MethodArgs
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public MethodHandle syncMethod;
        public MethodHandle asyncMethod;
        public String asyncMethodName;

        private void $$robo$$android_widget_RemoteViews_MethodArgs$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_widget_RemoteViews_MethodArgs$__constructor__();
        }

        MethodArgs() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_MethodArgs$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MethodArgs)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MethodKey
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Class targetClass;
        public Class paramClass;
        public String methodName;

        private void $$robo$$android_widget_RemoteViews_MethodKey$__constructor__() {
        }

        private final boolean $$robo$$android_widget_RemoteViews_MethodKey$equals(Object o) {
            if (!(o instanceof MethodKey)) {
                return false;
            }
            MethodKey p = (MethodKey)o;
            return Objects.equals(p.targetClass, this.targetClass) && Objects.equals(p.paramClass, this.paramClass) && Objects.equals(p.methodName, this.methodName);
        }

        private final int $$robo$$android_widget_RemoteViews_MethodKey$hashCode() {
            return Objects.hashCode(this.targetClass) ^ Objects.hashCode(this.paramClass) ^ Objects.hashCode(this.methodName);
        }

        private final void $$robo$$android_widget_RemoteViews_MethodKey$set(Class targetClass, Class paramClass, String methodName) {
            this.targetClass = targetClass;
            this.paramClass = paramClass;
            this.methodName = methodName;
        }

        private void __constructor__() {
            this.$$robo$$android_widget_RemoteViews_MethodKey$__constructor__();
        }

        MethodKey() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_MethodKey$__constructor__(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_widget_RemoteViews_MethodKey$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_widget_RemoteViews_MethodKey$hashCode(), 0, this);
        }

        public void set(Class clazz, Class clazz2, String string2) {
            InvokeDynamicSupport.bootstrap("set", $$robo$$android_widget_RemoteViews_MethodKey$set(java.lang.Class java.lang.Class java.lang.String ), 0, this, clazz, clazz2, string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MethodKey)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

