/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.IServiceConnection;
import android.appwidget.AppWidgetHostView;
import android.appwidget.AppWidgetManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.widget.IRemoteViewsFactory;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RemoteViewsAdapter
extends BaseAdapter
implements Handler.Callback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "RemoteViewsAdapter";
    private static int DEFAULT_CACHE_SIZE = 40;
    private static int UNBIND_SERVICE_DELAY = 5000;
    private static int DEFAULT_LOADING_VIEW_HEIGHT = 50;
    private static HashMap<RemoteViewsCacheKey, FixedSizeRemoteViewsCache> sCachedRemoteViewsCaches;
    private static HashMap<RemoteViewsCacheKey, Runnable> sRemoteViewsCacheRemoveRunnables;
    private static HandlerThread sCacheRemovalThread;
    private static Handler sCacheRemovalQueue;
    private static int REMOTE_VIEWS_CACHE_DURATION = 5000;
    private Context mContext;
    private Intent mIntent;
    private int mAppWidgetId;
    private Executor mAsyncViewLoadExecutor;
    private RemoteViews.OnClickHandler mRemoteViewsOnClickHandler;
    private FixedSizeRemoteViewsCache mCache;
    private int mVisibleWindowLowerBound;
    private int mVisibleWindowUpperBound;
    private RemoteViewsFrameLayoutRefSet mRequestedViews;
    private HandlerThread mWorkerThread;
    private Handler mMainHandler;
    private RemoteServiceHandler mServiceHandler;
    private RemoteAdapterConnectionCallback mCallback;
    private boolean mDataReady;
    private ApplicationInfo mLastRemoteViewAppInfo;
    static int MSG_REQUEST_BIND = 1;
    static int MSG_NOTIFY_DATA_SET_CHANGED = 2;
    static int MSG_LOAD_NEXT_ITEM = 3;
    static int MSG_UNBIND_SERVICE = 4;
    private static int MSG_MAIN_HANDLER_COMMIT_METADATA = 1;
    private static int MSG_MAIN_HANDLER_SUPER_NOTIFY_DATA_SET_CHANGED = 2;
    private static int MSG_MAIN_HANDLER_REMOTE_ADAPTER_CONNECTED = 3;
    private static int MSG_MAIN_HANDLER_REMOTE_ADAPTER_DISCONNECTED = 4;
    private static int MSG_MAIN_HANDLER_REMOTE_VIEWS_LOADED = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_widget_RemoteViewsAdapter$__constructor__(Context context, Intent intent, RemoteAdapterConnectionCallback callback, boolean useAsyncLoader) {
        this.mDataReady = false;
        this.mContext = context;
        this.mIntent = intent;
        if (this.mIntent == null) {
            throw new IllegalArgumentException("Non-null Intent must be specified.");
        }
        this.mAppWidgetId = intent.getIntExtra("remoteAdapterAppWidgetId", -1);
        this.mRequestedViews = new RemoteViewsFrameLayoutRefSet(this);
        if (intent.hasExtra("remoteAdapterAppWidgetId")) {
            intent.removeExtra("remoteAdapterAppWidgetId");
        }
        this.mWorkerThread = new HandlerThread("RemoteViewsCache-loader");
        this.mWorkerThread.start();
        this.mMainHandler = new Handler(Looper.myLooper(), this);
        this.mServiceHandler = new RemoteServiceHandler(this.mWorkerThread.getLooper(), this, context.getApplicationContext());
        this.mAsyncViewLoadExecutor = useAsyncLoader ? new HandlerThreadExecutor(this.mWorkerThread) : null;
        this.mCallback = callback;
        if (sCacheRemovalThread == null) {
            sCacheRemovalThread = new HandlerThread("RemoteViewsAdapter-cachePruner");
            sCacheRemovalThread.start();
            sCacheRemovalQueue = new Handler(sCacheRemovalThread.getLooper());
        }
        RemoteViewsCacheKey key = new RemoteViewsCacheKey(new Intent.FilterComparison(this.mIntent), this.mAppWidgetId);
        HashMap<RemoteViewsCacheKey, FixedSizeRemoteViewsCache> hashMap = sCachedRemoteViewsCaches;
        synchronized (hashMap) {
            if (sCachedRemoteViewsCaches.containsKey(key)) {
                this.mCache = sCachedRemoteViewsCaches.get(key);
                RemoteViewsMetaData remoteViewsMetaData = this.mCache.mMetaData;
                synchronized (remoteViewsMetaData) {
                    if (((FixedSizeRemoteViewsCache)this.mCache).mMetaData.count > 0) {
                        this.mDataReady = true;
                    }
                }
            } else {
                this.mCache = new FixedSizeRemoteViewsCache(40);
            }
            if (!this.mDataReady) {
                this.requestBindService();
            }
        }
    }

    private final void $$robo$$android_widget_RemoteViewsAdapter$finalize() throws Throwable {
        try {
            this.mServiceHandler.unbindNow();
            this.mWorkerThread.quit();
        }
        finally {
            super.finalize();
        }
    }

    private final boolean $$robo$$android_widget_RemoteViewsAdapter$isDataReady() {
        return this.mDataReady;
    }

    private final void $$robo$$android_widget_RemoteViewsAdapter$setRemoteViewsOnClickHandler(RemoteViews.OnClickHandler handler) {
        this.mRemoteViewsOnClickHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_widget_RemoteViewsAdapter$saveRemoteViewsCache() {
        RemoteViewsCacheKey key = new RemoteViewsCacheKey(new Intent.FilterComparison(this.mIntent), this.mAppWidgetId);
        HashMap<RemoteViewsCacheKey, FixedSizeRemoteViewsCache> hashMap = sCachedRemoteViewsCaches;
        synchronized (hashMap) {
            if (sRemoteViewsCacheRemoveRunnables.containsKey(key)) {
                sCacheRemovalQueue.removeCallbacks(sRemoteViewsCacheRemoveRunnables.get(key));
                sRemoteViewsCacheRemoveRunnables.remove(key);
            }
            int metaDataCount = 0;
            int numRemoteViewsCached = 0;
            Object object = this.mCache.mMetaData;
            synchronized (object) {
                metaDataCount = ((FixedSizeRemoteViewsCache)this.mCache).mMetaData.count;
            }
            object = this.mCache;
            synchronized (object) {
                numRemoteViewsCached = this.mCache.mIndexRemoteViews.size();
            }
            if (metaDataCount > 0 && numRemoteViewsCached > 0) {
                sCachedRemoteViewsCaches.put(key, this.mCache);
            }
            Runnable r = () -> {
                HashMap<RemoteViewsCacheKey, FixedSizeRemoteViewsCache> hashMap = sCachedRemoteViewsCaches;
                synchronized (hashMap) {
                    if (sCachedRemoteViewsCaches.containsKey(key)) {
                        sCachedRemoteViewsCaches.remove(key);
                    }
                    if (sRemoteViewsCacheRemoveRunnables.containsKey(key)) {
                        sRemoteViewsCacheRemoveRunnables.remove(key);
                    }
                }
            };
            sRemoteViewsCacheRemoveRunnables.put(key, r);
            sCacheRemovalQueue.postDelayed(r, 5000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_widget_RemoteViewsAdapter$updateTemporaryMetaData(IRemoteViewsFactory factory) {
        try {
            RemoteViewsMetaData tmpMetaData;
            RemoteViews firstView;
            boolean hasStableIds = factory.hasStableIds();
            int viewTypeCount = factory.getViewTypeCount();
            int count = factory.getCount();
            LoadingViewTemplate loadingTemplate = new LoadingViewTemplate(factory.getLoadingView(), this.mContext);
            if (count > 0 && loadingTemplate.remoteViews == null && (firstView = factory.getViewAt(0)) != null) {
                loadingTemplate.loadFirstViewHeight(firstView, this.mContext, new HandlerThreadExecutor(this.mWorkerThread));
            }
            RemoteViewsMetaData remoteViewsMetaData = tmpMetaData = this.mCache.getTemporaryMetaData();
            synchronized (remoteViewsMetaData) {
                tmpMetaData.hasStableIds = hasStableIds;
                tmpMetaData.viewTypeCount = viewTypeCount + 1;
                tmpMetaData.count = count;
                tmpMetaData.loadingTemplate = loadingTemplate;
            }
        }
        catch (RemoteException | RuntimeException e) {
            Log.e("RemoteViewsAdapter", "Error in updateMetaData: " + e.getMessage());
            Object object = this.mCache.getMetaData();
            synchronized (object) {
                this.mCache.getMetaData().reset();
            }
            object = this.mCache;
            synchronized (object) {
                this.mCache.reset();
            }
            this.mMainHandler.sendEmptyMessage(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_widget_RemoteViewsAdapter$updateRemoteViews(IRemoteViewsFactory factory, int position, boolean notifyWhenLoaded) {
        int cacheCount;
        boolean viewTypeInRange;
        RemoteViewsMetaData metaData;
        long itemId;
        RemoteViews remoteViews;
        try {
            remoteViews = factory.getViewAt(position);
            itemId = factory.getItemId(position);
            if (remoteViews == null) {
                throw new RuntimeException("Null remoteViews");
            }
        }
        catch (RemoteException | RuntimeException e) {
            Log.e("RemoteViewsAdapter", "Error in updateRemoteViews(" + position + "): " + e.getMessage());
            return;
        }
        if (remoteViews.mApplication != null) {
            if (this.mLastRemoteViewAppInfo != null && remoteViews.hasSameAppInfo(this.mLastRemoteViewAppInfo)) {
                remoteViews.mApplication = this.mLastRemoteViewAppInfo;
            } else {
                this.mLastRemoteViewAppInfo = remoteViews.mApplication;
            }
        }
        int layoutId = remoteViews.getLayoutId();
        Object object = metaData = this.mCache.getMetaData();
        synchronized (object) {
            viewTypeInRange = metaData.isViewTypeInRange(layoutId);
            cacheCount = ((FixedSizeRemoteViewsCache)this.mCache).mMetaData.count;
        }
        object = this.mCache;
        synchronized (object) {
            if (viewTypeInRange) {
                int[] visibleWindow = this.getVisibleWindow(cacheCount);
                this.mCache.insert(position, remoteViews, itemId, visibleWindow);
                if (notifyWhenLoaded) {
                    Message.obtain(this.mMainHandler, 5, position, 0, remoteViews).sendToTarget();
                }
            } else {
                Log.e("RemoteViewsAdapter", "Error: widget's RemoteViewsFactory returns more view types than  indicated by getViewTypeCount() ");
            }
        }
    }

    private final Intent $$robo$$android_widget_RemoteViewsAdapter$getRemoteViewsServiceIntent() {
        return this.mIntent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_widget_RemoteViewsAdapter$getCount() {
        RemoteViewsMetaData metaData;
        RemoteViewsMetaData remoteViewsMetaData = metaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return metaData.count;
        }
    }

    private final Object $$robo$$android_widget_RemoteViewsAdapter$getItem(int position) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_widget_RemoteViewsAdapter$getItemId(int position) {
        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = this.mCache;
        synchronized (fixedSizeRemoteViewsCache) {
            if (this.mCache.containsMetaDataAt(position)) {
                return this.mCache.getMetaDataAt((int)position).itemId;
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_widget_RemoteViewsAdapter$getItemViewType(int position) {
        RemoteViewsMetaData metaData;
        int typeId;
        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = this.mCache;
        synchronized (fixedSizeRemoteViewsCache) {
            if (!this.mCache.containsMetaDataAt(position)) {
                return 0;
            }
            typeId = this.mCache.getMetaDataAt((int)position).typeId;
        }
        RemoteViewsMetaData remoteViewsMetaData = metaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return metaData.getMappedViewType(typeId);
        }
    }

    private final void $$robo$$android_widget_RemoteViewsAdapter$setVisibleRangeHint(int lowerBound, int upperBound) {
        this.mVisibleWindowLowerBound = lowerBound;
        this.mVisibleWindowUpperBound = upperBound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final View $$robo$$android_widget_RemoteViewsAdapter$getView(int position, View convertView, ViewGroup parent) {
        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = this.mCache;
        synchronized (fixedSizeRemoteViewsCache) {
            RemoteViewsFrameLayout layout2;
            RemoteViews rv = this.mCache.getRemoteViewsAt(position);
            boolean isInCache = rv != null;
            boolean hasNewItems = false;
            if (convertView != null && convertView instanceof RemoteViewsFrameLayout) {
                this.mRequestedViews.removeView((RemoteViewsFrameLayout)convertView);
            }
            if (!isInCache) {
                this.requestBindService();
            } else {
                hasNewItems = this.mCache.queuePositionsToBePreloadedFromRequestedPosition(position);
            }
            if (convertView instanceof RemoteViewsFrameLayout) {
                layout2 = (RemoteViewsFrameLayout)convertView;
            } else {
                layout2 = new RemoteViewsFrameLayout(parent.getContext(), this.mCache);
                layout2.setExecutor(this.mAsyncViewLoadExecutor);
            }
            if (isInCache) {
                layout2.onRemoteViewsLoaded(rv, this.mRemoteViewsOnClickHandler, false);
                if (hasNewItems) {
                    this.mServiceHandler.sendEmptyMessage(3);
                }
            } else {
                layout2.onRemoteViewsLoaded(this.mCache.getMetaData().getLoadingTemplate((Context)this.mContext).remoteViews, this.mRemoteViewsOnClickHandler, false);
                this.mRequestedViews.add(position, layout2);
                this.mCache.queueRequestedPositionToLoad(position);
                this.mServiceHandler.sendEmptyMessage(3);
            }
            return layout2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_widget_RemoteViewsAdapter$getViewTypeCount() {
        RemoteViewsMetaData metaData;
        RemoteViewsMetaData remoteViewsMetaData = metaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return metaData.viewTypeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_widget_RemoteViewsAdapter$hasStableIds() {
        RemoteViewsMetaData metaData;
        RemoteViewsMetaData remoteViewsMetaData = metaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return metaData.hasStableIds;
        }
    }

    private final boolean $$robo$$android_widget_RemoteViewsAdapter$isEmpty() {
        return this.getCount() <= 0;
    }

    private final int[] $$robo$$android_widget_RemoteViewsAdapter$getVisibleWindow(int count) {
        int[] window;
        int lower = this.mVisibleWindowLowerBound;
        int upper = this.mVisibleWindowUpperBound;
        if (lower == 0 && upper == 0 || lower < 0 || upper < 0) {
            return new int[0];
        }
        if (lower <= upper) {
            window = new int[upper + 1 - lower];
            int i = lower;
            int j = 0;
            while (i <= upper) {
                window[j] = i++;
                ++j;
            }
        } else {
            count = Math.max(count, lower);
            window = new int[count - lower + upper + 1];
            int j = 0;
            int i = 0;
            while (i <= upper) {
                window[j] = i++;
                ++j;
            }
            i = lower;
            while (i < count) {
                window[j] = i++;
                ++j;
            }
        }
        return window;
    }

    private final void $$robo$$android_widget_RemoteViewsAdapter$notifyDataSetChanged() {
        this.mServiceHandler.removeMessages(4);
        this.mServiceHandler.sendEmptyMessage(2);
    }

    private final void $$robo$$android_widget_RemoteViewsAdapter$superNotifyDataSetChanged() {
        super.notifyDataSetChanged();
    }

    private final boolean $$robo$$android_widget_RemoteViewsAdapter$handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.mCache.commitTemporaryMetaData();
                return true;
            }
            case 2: {
                this.superNotifyDataSetChanged();
                return true;
            }
            case 3: {
                if (this.mCallback != null) {
                    this.mCallback.onRemoteAdapterConnected();
                }
                return true;
            }
            case 4: {
                if (this.mCallback != null) {
                    this.mCallback.onRemoteAdapterDisconnected();
                }
                return true;
            }
            case 5: {
                this.mRequestedViews.notifyOnRemoteViewsLoaded(msg.arg1, (RemoteViews)msg.obj);
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$android_widget_RemoteViewsAdapter$requestBindService() {
        this.mServiceHandler.removeMessages(4);
        Message.obtain(this.mServiceHandler, 1, this.mAppWidgetId, 0, this.mIntent).sendToTarget();
    }

    static void __staticInitializer__() {
        sCachedRemoteViewsCaches = new HashMap();
        sRemoteViewsCacheRemoveRunnables = new HashMap();
    }

    private void __constructor__(Context context, Intent intent, RemoteAdapterConnectionCallback remoteAdapterConnectionCallback, boolean bl) {
        this.$$robo$$android_widget_RemoteViewsAdapter$__constructor__(context, intent, remoteAdapterConnectionCallback, bl);
    }

    public RemoteViewsAdapter(Context context, Intent intent, RemoteAdapterConnectionCallback remoteAdapterConnectionCallback, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViewsAdapter$__constructor__(android.content.Context android.content.Intent android.widget.RemoteViewsAdapter$RemoteAdapterConnectionCallback boolean ), 0, this, context, intent, remoteAdapterConnectionCallback, bl);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_widget_RemoteViewsAdapter$finalize(), 0, this);
    }

    public boolean isDataReady() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDataReady", $$robo$$android_widget_RemoteViewsAdapter$isDataReady(), 0, this);
    }

    public void setRemoteViewsOnClickHandler(RemoteViews.OnClickHandler onClickHandler) {
        InvokeDynamicSupport.bootstrap("setRemoteViewsOnClickHandler", $$robo$$android_widget_RemoteViewsAdapter$setRemoteViewsOnClickHandler(android.widget.RemoteViews$OnClickHandler ), 0, this, onClickHandler);
    }

    public void saveRemoteViewsCache() {
        InvokeDynamicSupport.bootstrap("saveRemoteViewsCache", $$robo$$android_widget_RemoteViewsAdapter$saveRemoteViewsCache(), 0, this);
    }

    private void updateTemporaryMetaData(IRemoteViewsFactory iRemoteViewsFactory) {
        InvokeDynamicSupport.bootstrap("updateTemporaryMetaData", $$robo$$android_widget_RemoteViewsAdapter$updateTemporaryMetaData(com.android.internal.widget.IRemoteViewsFactory ), 0, this, iRemoteViewsFactory);
    }

    private void updateRemoteViews(IRemoteViewsFactory iRemoteViewsFactory, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("updateRemoteViews", $$robo$$android_widget_RemoteViewsAdapter$updateRemoteViews(com.android.internal.widget.IRemoteViewsFactory int boolean ), 0, this, iRemoteViewsFactory, n, bl);
    }

    public Intent getRemoteViewsServiceIntent() {
        return InvokeDynamicSupport.bootstrap("getRemoteViewsServiceIntent", $$robo$$android_widget_RemoteViewsAdapter$getRemoteViewsServiceIntent(), 0, this);
    }

    @Override
    public int getCount() {
        return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$android_widget_RemoteViewsAdapter$getCount(), 0, this);
    }

    @Override
    public Object getItem(int n) {
        return InvokeDynamicSupport.bootstrap("getItem", $$robo$$android_widget_RemoteViewsAdapter$getItem(int ), 0, this, n);
    }

    @Override
    public long getItemId(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getItemId", $$robo$$android_widget_RemoteViewsAdapter$getItemId(int ), 0, this, n);
    }

    @Override
    public int getItemViewType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getItemViewType", $$robo$$android_widget_RemoteViewsAdapter$getItemViewType(int ), 0, this, n);
    }

    public void setVisibleRangeHint(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setVisibleRangeHint", $$robo$$android_widget_RemoteViewsAdapter$setVisibleRangeHint(int int ), 0, this, n, n2);
    }

    @Override
    public View getView(int n, View view, ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("getView", $$robo$$android_widget_RemoteViewsAdapter$getView(int android.view.View android.view.ViewGroup ), 0, this, n, view, viewGroup);
    }

    @Override
    public int getViewTypeCount() {
        return (int)InvokeDynamicSupport.bootstrap("getViewTypeCount", $$robo$$android_widget_RemoteViewsAdapter$getViewTypeCount(), 0, this);
    }

    @Override
    public boolean hasStableIds() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasStableIds", $$robo$$android_widget_RemoteViewsAdapter$hasStableIds(), 0, this);
    }

    @Override
    public boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_widget_RemoteViewsAdapter$isEmpty(), 0, this);
    }

    private int[] getVisibleWindow(int n) {
        return InvokeDynamicSupport.bootstrap("getVisibleWindow", $$robo$$android_widget_RemoteViewsAdapter$getVisibleWindow(int ), 0, this, n);
    }

    @Override
    public void notifyDataSetChanged() {
        InvokeDynamicSupport.bootstrap("notifyDataSetChanged", $$robo$$android_widget_RemoteViewsAdapter$notifyDataSetChanged(), 0, this);
    }

    void superNotifyDataSetChanged() {
        InvokeDynamicSupport.bootstrap("superNotifyDataSetChanged", $$robo$$android_widget_RemoteViewsAdapter$superNotifyDataSetChanged(), 0, this);
    }

    @Override
    public boolean handleMessage(Message message) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_widget_RemoteViewsAdapter$handleMessage(android.os.Message ), 0, this, message);
    }

    private void requestBindService() {
        InvokeDynamicSupport.bootstrap("requestBindService", $$robo$$android_widget_RemoteViewsAdapter$requestBindService(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(RemoteViewsAdapter.class);
    }

    public /* synthetic */ RemoteViewsAdapter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RemoteViewsAdapter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class LoadingViewTemplate
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public RemoteViews remoteViews;
        public int defaultHeight;

        private void $$robo$$android_widget_RemoteViewsAdapter_LoadingViewTemplate$__constructor__(RemoteViews views, Context context) {
            this.remoteViews = views;
            float density = context.getResources().getDisplayMetrics().density;
            this.defaultHeight = Math.round(50.0f * density);
        }

        private final void $$robo$$android_widget_RemoteViewsAdapter_LoadingViewTemplate$loadFirstViewHeight(RemoteViews firstView, Context context, Executor executor) {
            firstView.applyAsync(context, new RemoteViewsFrameLayout(context, null), executor, new RemoteViews.OnViewAppliedListener(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ LoadingViewTemplate this$0;

                private void $$robo$$android_widget_RemoteViewsAdapter_LoadingViewTemplate_1$__constructor__(LoadingViewTemplate this$0) {
                }

                private final void $$robo$$android_widget_RemoteViewsAdapter_LoadingViewTemplate_1$onViewApplied(View v) {
                    try {
                        v.measure(View.MeasureSpec.makeMeasureSpec(0, 0), View.MeasureSpec.makeMeasureSpec(0, 0));
                        this.this$0.defaultHeight = v.getMeasuredHeight();
                    }
                    catch (Exception e) {
                        this.onError(e);
                    }
                }

                private final void $$robo$$android_widget_RemoteViewsAdapter_LoadingViewTemplate_1$onError(Exception e) {
                    Log.w("RemoteViewsAdapter", "Error inflating first RemoteViews", e);
                }

                private void __constructor__(LoadingViewTemplate loadingViewTemplate) {
                    this.$$robo$$android_widget_RemoteViewsAdapter_LoadingViewTemplate_1$__constructor__(loadingViewTemplate);
                }
                {
                    this.this$0 = loadingViewTemplate;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViewsAdapter_LoadingViewTemplate_1$__constructor__(android.widget.RemoteViewsAdapter$LoadingViewTemplate ), 0, this, loadingViewTemplate);
                }

                @Override
                public void onViewApplied(View view) {
                    InvokeDynamicSupport.bootstrap("onViewApplied", $$robo$$android_widget_RemoteViewsAdapter_LoadingViewTemplate_1$onViewApplied(android.view.View ), 0, this, view);
                }

                @Override
                public void onError(Exception exception) {
                    InvokeDynamicSupport.bootstrap("onError", $$robo$$android_widget_RemoteViewsAdapter_LoadingViewTemplate_1$onError(java.lang.Exception ), 0, this, exception);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private void __constructor__(RemoteViews remoteViews, Context context) {
            this.$$robo$$android_widget_RemoteViewsAdapter_LoadingViewTemplate$__constructor__(remoteViews, context);
        }

        LoadingViewTemplate(RemoteViews remoteViews, Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViewsAdapter_LoadingViewTemplate$__constructor__(android.widget.RemoteViews android.content.Context ), 0, this, remoteViews, context);
        }

        public void loadFirstViewHeight(RemoteViews remoteViews, Context context, Executor executor) {
            InvokeDynamicSupport.bootstrap("loadFirstViewHeight", $$robo$$android_widget_RemoteViewsAdapter_LoadingViewTemplate$loadFirstViewHeight(android.widget.RemoteViews android.content.Context java.util.concurrent.Executor ), 0, this, remoteViews, context, executor);
        }

        public /* synthetic */ LoadingViewTemplate() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LoadingViewTemplate)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class HandlerThreadExecutor
    implements Executor,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private HandlerThread mThread;

        private void $$robo$$android_widget_RemoteViewsAdapter_HandlerThreadExecutor$__constructor__(HandlerThread thread) {
            this.mThread = thread;
        }

        private final void $$robo$$android_widget_RemoteViewsAdapter_HandlerThreadExecutor$execute(Runnable runnable) {
            if (Thread.currentThread().getId() == this.mThread.getId()) {
                runnable.run();
            } else {
                new Handler(this.mThread.getLooper()).post(runnable);
            }
        }

        private void __constructor__(HandlerThread handlerThread) {
            this.$$robo$$android_widget_RemoteViewsAdapter_HandlerThreadExecutor$__constructor__(handlerThread);
        }

        HandlerThreadExecutor(HandlerThread handlerThread) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViewsAdapter_HandlerThreadExecutor$__constructor__(android.os.HandlerThread ), 0, this, handlerThread);
        }

        @Override
        public void execute(Runnable runnable) {
            InvokeDynamicSupport.bootstrap("execute", $$robo$$android_widget_RemoteViewsAdapter_HandlerThreadExecutor$execute(java.lang.Runnable ), 0, this, runnable);
        }

        public /* synthetic */ HandlerThreadExecutor() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HandlerThreadExecutor)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RemoteViewsCacheKey
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Intent.FilterComparison filter;
        int widgetId;

        private void $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsCacheKey$__constructor__(Intent.FilterComparison filter, int widgetId) {
            this.filter = filter;
            this.widgetId = widgetId;
        }

        private final boolean $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsCacheKey$equals(Object o) {
            if (!(o instanceof RemoteViewsCacheKey)) {
                return false;
            }
            RemoteViewsCacheKey other = (RemoteViewsCacheKey)o;
            return other.filter.equals(this.filter) && other.widgetId == this.widgetId;
        }

        private final int $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsCacheKey$hashCode() {
            return (this.filter == null ? 0 : this.filter.hashCode()) ^ this.widgetId << 2;
        }

        private void __constructor__(Intent.FilterComparison filterComparison, int n) {
            this.$$robo$$android_widget_RemoteViewsAdapter_RemoteViewsCacheKey$__constructor__(filterComparison, n);
        }

        RemoteViewsCacheKey(Intent.FilterComparison filterComparison, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsCacheKey$__constructor__(android.content.Intent$FilterComparison int ), 0, this, filterComparison, n);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsCacheKey$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsCacheKey$hashCode(), 0, this);
        }

        public /* synthetic */ RemoteViewsCacheKey() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RemoteViewsCacheKey)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class FixedSizeRemoteViewsCache
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private RemoteViewsMetaData mMetaData;
        private RemoteViewsMetaData mTemporaryMetaData;
        private SparseArray<RemoteViewsIndexMetaData> mIndexMetaData;
        private SparseArray<RemoteViews> mIndexRemoteViews;
        private SparseBooleanArray mIndicesToLoad;
        private int mLastRequestedIndex;
        private int mPreloadLowerBound;
        private int mPreloadUpperBound;
        private int mMaxCount;
        private int mMaxCountSlack;
        private static float sMaxCountSlackPercent = 0.75f;
        private static int sMaxMemoryLimitInBytes = 0x200000;

        private void $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$__constructor__(int maxCacheSize) {
            this.mMetaData = new RemoteViewsMetaData();
            this.mTemporaryMetaData = new RemoteViewsMetaData();
            this.mIndexMetaData = new SparseArray();
            this.mIndexRemoteViews = new SparseArray();
            this.mIndicesToLoad = new SparseBooleanArray();
            this.mMaxCount = maxCacheSize;
            this.mMaxCountSlack = Math.round(0.75f * (float)(this.mMaxCount / 2));
            this.mPreloadLowerBound = 0;
            this.mPreloadUpperBound = -1;
            this.mLastRequestedIndex = -1;
        }

        private final void $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$insert(int position, RemoteViews v, long itemId, int[] visibleWindow) {
            int trimIndex;
            int pruneFromPosition;
            if (this.mIndexRemoteViews.size() >= this.mMaxCount) {
                this.mIndexRemoteViews.remove(this.getFarthestPositionFrom(position, visibleWindow));
            }
            int n = pruneFromPosition = this.mLastRequestedIndex > -1 ? this.mLastRequestedIndex : position;
            while (this.getRemoteViewsBitmapMemoryUsage() >= 0x200000 && (trimIndex = this.getFarthestPositionFrom(pruneFromPosition, visibleWindow)) >= 0) {
                this.mIndexRemoteViews.remove(trimIndex);
            }
            RemoteViewsIndexMetaData metaData = this.mIndexMetaData.get(position);
            if (metaData != null) {
                metaData.set(v, itemId);
            } else {
                this.mIndexMetaData.put(position, new RemoteViewsIndexMetaData(v, itemId));
            }
            this.mIndexRemoteViews.put(position, v);
        }

        private final RemoteViewsMetaData $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$getMetaData() {
            return this.mMetaData;
        }

        private final RemoteViewsMetaData $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$getTemporaryMetaData() {
            return this.mTemporaryMetaData;
        }

        private final RemoteViews $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$getRemoteViewsAt(int position) {
            return this.mIndexRemoteViews.get(position);
        }

        private final RemoteViewsIndexMetaData $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$getMetaDataAt(int position) {
            return this.mIndexMetaData.get(position);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$commitTemporaryMetaData() {
            RemoteViewsMetaData remoteViewsMetaData = this.mTemporaryMetaData;
            synchronized (remoteViewsMetaData) {
                RemoteViewsMetaData remoteViewsMetaData2 = this.mMetaData;
                synchronized (remoteViewsMetaData2) {
                    this.mMetaData.set(this.mTemporaryMetaData);
                }
            }
        }

        private final int $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$getRemoteViewsBitmapMemoryUsage() {
            int mem = 0;
            for (int i = this.mIndexRemoteViews.size() - 1; i >= 0; --i) {
                RemoteViews v = this.mIndexRemoteViews.valueAt(i);
                if (v == null) continue;
                mem += v.estimateMemoryUsage();
            }
            return mem;
        }

        private final int $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$getFarthestPositionFrom(int pos, int[] visibleWindow) {
            int maxDist = 0;
            int maxDistIndex = -1;
            int maxDistNotVisible = 0;
            int maxDistIndexNotVisible = -1;
            for (int i = this.mIndexRemoteViews.size() - 1; i >= 0; --i) {
                int index = this.mIndexRemoteViews.keyAt(i);
                int dist = Math.abs(index - pos);
                if (dist > maxDistNotVisible && Arrays.binarySearch(visibleWindow, index) < 0) {
                    maxDistIndexNotVisible = index;
                    maxDistNotVisible = dist;
                }
                if (dist < maxDist) continue;
                maxDistIndex = index;
                maxDist = dist;
            }
            if (maxDistIndexNotVisible > -1) {
                return maxDistIndexNotVisible;
            }
            return maxDistIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$queueRequestedPositionToLoad(int position) {
            this.mLastRequestedIndex = position;
            SparseBooleanArray sparseBooleanArray = this.mIndicesToLoad;
            synchronized (sparseBooleanArray) {
                this.mIndicesToLoad.put(position, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$queuePositionsToBePreloadedFromRequestedPosition(int position) {
            int count;
            int center;
            if (this.mPreloadLowerBound <= position && position <= this.mPreloadUpperBound && Math.abs(position - (center = (this.mPreloadUpperBound + this.mPreloadLowerBound) / 2)) < this.mMaxCountSlack) {
                return false;
            }
            Object object = this.mMetaData;
            synchronized (object) {
                count = this.mMetaData.count;
            }
            object = this.mIndicesToLoad;
            synchronized (object) {
                for (int i = this.mIndicesToLoad.size() - 1; i >= 0; --i) {
                    if (this.mIndicesToLoad.valueAt(i)) continue;
                    this.mIndicesToLoad.removeAt(i);
                }
                int halfMaxCount = this.mMaxCount / 2;
                this.mPreloadLowerBound = position - halfMaxCount;
                this.mPreloadUpperBound = position + halfMaxCount;
                int effectiveLowerBound = Math.max(0, this.mPreloadLowerBound);
                int effectiveUpperBound = Math.min(this.mPreloadUpperBound, count - 1);
                for (int i = effectiveLowerBound; i <= effectiveUpperBound; ++i) {
                    if (this.mIndexRemoteViews.indexOfKey(i) >= 0 || this.mIndicesToLoad.get(i)) continue;
                    this.mIndicesToLoad.put(i, false);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$getNextIndexToLoad() {
            SparseBooleanArray sparseBooleanArray = this.mIndicesToLoad;
            synchronized (sparseBooleanArray) {
                int index = this.mIndicesToLoad.indexOfValue(true);
                if (index < 0) {
                    index = this.mIndicesToLoad.indexOfValue(false);
                }
                if (index < 0) {
                    return -1;
                }
                int key = this.mIndicesToLoad.keyAt(index);
                this.mIndicesToLoad.removeAt(index);
                return key;
            }
        }

        private final boolean $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$containsRemoteViewAt(int position) {
            return this.mIndexRemoteViews.indexOfKey(position) >= 0;
        }

        private final boolean $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$containsMetaDataAt(int position) {
            return this.mIndexMetaData.indexOfKey(position) >= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$reset() {
            this.mPreloadLowerBound = 0;
            this.mPreloadUpperBound = -1;
            this.mLastRequestedIndex = -1;
            this.mIndexRemoteViews.clear();
            this.mIndexMetaData.clear();
            SparseBooleanArray sparseBooleanArray = this.mIndicesToLoad;
            synchronized (sparseBooleanArray) {
                this.mIndicesToLoad.clear();
            }
        }

        private void __constructor__(int n) {
            this.$$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$__constructor__(n);
        }

        public FixedSizeRemoteViewsCache(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$__constructor__(int ), 0, this, n);
        }

        public void insert(int n, RemoteViews remoteViews, long l, int[] nArray) {
            InvokeDynamicSupport.bootstrap("insert", $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$insert(int android.widget.RemoteViews long int[] ), 0, this, n, remoteViews, l, nArray);
        }

        public RemoteViewsMetaData getMetaData() {
            return InvokeDynamicSupport.bootstrap("getMetaData", $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$getMetaData(), 0, this);
        }

        public RemoteViewsMetaData getTemporaryMetaData() {
            return InvokeDynamicSupport.bootstrap("getTemporaryMetaData", $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$getTemporaryMetaData(), 0, this);
        }

        public RemoteViews getRemoteViewsAt(int n) {
            return InvokeDynamicSupport.bootstrap("getRemoteViewsAt", $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$getRemoteViewsAt(int ), 0, this, n);
        }

        public RemoteViewsIndexMetaData getMetaDataAt(int n) {
            return InvokeDynamicSupport.bootstrap("getMetaDataAt", $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$getMetaDataAt(int ), 0, this, n);
        }

        public void commitTemporaryMetaData() {
            InvokeDynamicSupport.bootstrap("commitTemporaryMetaData", $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$commitTemporaryMetaData(), 0, this);
        }

        private int getRemoteViewsBitmapMemoryUsage() {
            return (int)InvokeDynamicSupport.bootstrap("getRemoteViewsBitmapMemoryUsage", $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$getRemoteViewsBitmapMemoryUsage(), 0, this);
        }

        private int getFarthestPositionFrom(int n, int[] nArray) {
            return (int)InvokeDynamicSupport.bootstrap("getFarthestPositionFrom", $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$getFarthestPositionFrom(int int[] ), 0, this, n, nArray);
        }

        public void queueRequestedPositionToLoad(int n) {
            InvokeDynamicSupport.bootstrap("queueRequestedPositionToLoad", $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$queueRequestedPositionToLoad(int ), 0, this, n);
        }

        public boolean queuePositionsToBePreloadedFromRequestedPosition(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("queuePositionsToBePreloadedFromRequestedPosition", $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$queuePositionsToBePreloadedFromRequestedPosition(int ), 0, this, n);
        }

        public int getNextIndexToLoad() {
            return (int)InvokeDynamicSupport.bootstrap("getNextIndexToLoad", $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$getNextIndexToLoad(), 0, this);
        }

        public boolean containsRemoteViewAt(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("containsRemoteViewAt", $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$containsRemoteViewAt(int ), 0, this, n);
        }

        public boolean containsMetaDataAt(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("containsMetaDataAt", $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$containsMetaDataAt(int ), 0, this, n);
        }

        public void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_widget_RemoteViewsAdapter_FixedSizeRemoteViewsCache$reset(), 0, this);
        }

        public /* synthetic */ FixedSizeRemoteViewsCache() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FixedSizeRemoteViewsCache)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class RemoteViewsIndexMetaData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int typeId;
        long itemId;

        private void $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsIndexMetaData$__constructor__(RemoteViews v, long itemId) {
            this.set(v, itemId);
        }

        private final void $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsIndexMetaData$set(RemoteViews v, long id2) {
            this.itemId = id2;
            this.typeId = v != null ? v.getLayoutId() : 0;
        }

        private void __constructor__(RemoteViews remoteViews, long l) {
            this.$$robo$$android_widget_RemoteViewsAdapter_RemoteViewsIndexMetaData$__constructor__(remoteViews, l);
        }

        public RemoteViewsIndexMetaData(RemoteViews remoteViews, long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsIndexMetaData$__constructor__(android.widget.RemoteViews long ), 0, this, remoteViews, l);
        }

        public void set(RemoteViews remoteViews, long l) {
            InvokeDynamicSupport.bootstrap("set", $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsIndexMetaData$set(android.widget.RemoteViews long ), 0, this, remoteViews, l);
        }

        public /* synthetic */ RemoteViewsIndexMetaData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RemoteViewsIndexMetaData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class RemoteViewsMetaData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int count;
        int viewTypeCount;
        boolean hasStableIds;
        LoadingViewTemplate loadingTemplate;
        private SparseIntArray mTypeIdIndexMap;

        private void $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsMetaData$__constructor__() {
            this.mTypeIdIndexMap = new SparseIntArray();
            this.reset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsMetaData$set(RemoteViewsMetaData d) {
            RemoteViewsMetaData remoteViewsMetaData = d;
            synchronized (remoteViewsMetaData) {
                this.count = d.count;
                this.viewTypeCount = d.viewTypeCount;
                this.hasStableIds = d.hasStableIds;
                this.loadingTemplate = d.loadingTemplate;
            }
        }

        private final void $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsMetaData$reset() {
            this.count = 0;
            this.viewTypeCount = 1;
            this.hasStableIds = true;
            this.loadingTemplate = null;
            this.mTypeIdIndexMap.clear();
        }

        private final int $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsMetaData$getMappedViewType(int typeId) {
            int mappedTypeId = this.mTypeIdIndexMap.get(typeId, -1);
            if (mappedTypeId == -1) {
                mappedTypeId = this.mTypeIdIndexMap.size() + 1;
                this.mTypeIdIndexMap.put(typeId, mappedTypeId);
            }
            return mappedTypeId;
        }

        private final boolean $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsMetaData$isViewTypeInRange(int typeId) {
            int mappedType = this.getMappedViewType(typeId);
            return mappedType < this.viewTypeCount;
        }

        private final synchronized LoadingViewTemplate $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsMetaData$getLoadingTemplate(Context context) {
            if (this.loadingTemplate == null) {
                this.loadingTemplate = new LoadingViewTemplate(null, context);
            }
            return this.loadingTemplate;
        }

        private void __constructor__() {
            this.$$robo$$android_widget_RemoteViewsAdapter_RemoteViewsMetaData$__constructor__();
        }

        public RemoteViewsMetaData() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsMetaData$__constructor__(), 0, this);
        }

        public void set(RemoteViewsMetaData remoteViewsMetaData) {
            InvokeDynamicSupport.bootstrap("set", $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsMetaData$set(android.widget.RemoteViewsAdapter$RemoteViewsMetaData ), 0, this, remoteViewsMetaData);
        }

        public void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsMetaData$reset(), 0, this);
        }

        public int getMappedViewType(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getMappedViewType", $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsMetaData$getMappedViewType(int ), 0, this, n);
        }

        public boolean isViewTypeInRange(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isViewTypeInRange", $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsMetaData$isViewTypeInRange(int ), 0, this, n);
        }

        public synchronized LoadingViewTemplate getLoadingTemplate(Context context) {
            return InvokeDynamicSupport.bootstrap("getLoadingTemplate", $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsMetaData$getLoadingTemplate(android.content.Context ), 0, this, context);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RemoteViewsMetaData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class RemoteViewsFrameLayoutRefSet
    extends SparseArray<LinkedList<RemoteViewsFrameLayout>> {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RemoteViewsAdapter this$0;

        private void $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsFrameLayoutRefSet$__constructor__(RemoteViewsAdapter remoteViewsAdapter) {
        }

        private final void $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsFrameLayoutRefSet$add(int position, RemoteViewsFrameLayout layout2) {
            LinkedList<RemoteViewsFrameLayout> refs = (LinkedList<RemoteViewsFrameLayout>)this.get(position);
            if (refs == null) {
                refs = new LinkedList<RemoteViewsFrameLayout>();
                this.put(position, refs);
            }
            layout2.cacheIndex = position;
            refs.add(layout2);
        }

        private final void $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsFrameLayoutRefSet$notifyOnRemoteViewsLoaded(int position, RemoteViews view) {
            if (view == null) {
                return;
            }
            LinkedList refs = (LinkedList)this.removeReturnOld(position);
            if (refs != null) {
                for (RemoteViewsFrameLayout ref : refs) {
                    ref.onRemoteViewsLoaded(view, this.this$0.mRemoteViewsOnClickHandler, true);
                }
            }
        }

        private final void $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsFrameLayoutRefSet$removeView(RemoteViewsFrameLayout rvfl) {
            if (rvfl.cacheIndex < 0) {
                return;
            }
            LinkedList refs = (LinkedList)this.get(rvfl.cacheIndex);
            if (refs != null) {
                refs.remove(rvfl);
            }
            rvfl.cacheIndex = -1;
        }

        private /* synthetic */ void $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsFrameLayoutRefSet$__constructor__(RemoteViewsAdapter x0, 1 x1) {
        }

        private void __constructor__(RemoteViewsAdapter remoteViewsAdapter) {
            this.$$robo$$android_widget_RemoteViewsAdapter_RemoteViewsFrameLayoutRefSet$__constructor__(remoteViewsAdapter);
        }

        private RemoteViewsFrameLayoutRefSet(RemoteViewsAdapter remoteViewsAdapter) {
            this.this$0 = remoteViewsAdapter;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsFrameLayoutRefSet$__constructor__(android.widget.RemoteViewsAdapter ), 0, this, remoteViewsAdapter);
        }

        public void add(int n, RemoteViewsFrameLayout remoteViewsFrameLayout) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsFrameLayoutRefSet$add(int android.widget.RemoteViewsAdapter$RemoteViewsFrameLayout ), 0, this, n, remoteViewsFrameLayout);
        }

        public void notifyOnRemoteViewsLoaded(int n, RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("notifyOnRemoteViewsLoaded", $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsFrameLayoutRefSet$notifyOnRemoteViewsLoaded(int android.widget.RemoteViews ), 0, this, n, remoteViews);
        }

        public void removeView(RemoteViewsFrameLayout remoteViewsFrameLayout) {
            InvokeDynamicSupport.bootstrap("removeView", $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsFrameLayoutRefSet$removeView(android.widget.RemoteViewsAdapter$RemoteViewsFrameLayout ), 0, this, remoteViewsFrameLayout);
        }

        private /* synthetic */ void __constructor__(RemoteViewsAdapter remoteViewsAdapter, 1 var2_2) {
            this.$$robo$$android_widget_RemoteViewsAdapter_RemoteViewsFrameLayoutRefSet$__constructor__(remoteViewsAdapter, var2_2);
        }

        public /* synthetic */ RemoteViewsFrameLayoutRefSet() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RemoteViewsFrameLayoutRefSet)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RemoteViewsFrameLayout
    extends AppWidgetHostView
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private FixedSizeRemoteViewsCache mCache;
        public int cacheIndex;

        private void $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsFrameLayout$__constructor__(Context context, FixedSizeRemoteViewsCache cache) {
            this.cacheIndex = -1;
            this.mCache = cache;
        }

        private final void $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsFrameLayout$onRemoteViewsLoaded(RemoteViews view, RemoteViews.OnClickHandler handler, boolean forceApplyAsync) {
            this.setOnClickHandler(handler);
            this.applyRemoteViews(view, forceApplyAsync || view != null && view.prefersAsyncApply());
        }

        private final View $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsFrameLayout$getDefaultView() {
            int viewHeight = this.mCache.getMetaData().getLoadingTemplate((Context)this.getContext()).defaultHeight;
            TextView loadingTextView = (TextView)LayoutInflater.from(this.getContext()).inflate(17367247, (ViewGroup)this, false);
            loadingTextView.setHeight(viewHeight);
            return loadingTextView;
        }

        private final Context $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsFrameLayout$getRemoteContext() {
            return null;
        }

        private final View $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsFrameLayout$getErrorView() {
            return this.getDefaultView();
        }

        private void __constructor__(Context context, FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache) {
            this.$$robo$$android_widget_RemoteViewsAdapter_RemoteViewsFrameLayout$__constructor__(context, fixedSizeRemoteViewsCache);
        }

        public RemoteViewsFrameLayout(Context context, FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache) {
            super(context);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsFrameLayout$__constructor__(android.content.Context android.widget.RemoteViewsAdapter$FixedSizeRemoteViewsCache ), 0, this, context, fixedSizeRemoteViewsCache);
        }

        public void onRemoteViewsLoaded(RemoteViews remoteViews, RemoteViews.OnClickHandler onClickHandler, boolean bl) {
            InvokeDynamicSupport.bootstrap("onRemoteViewsLoaded", $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsFrameLayout$onRemoteViewsLoaded(android.widget.RemoteViews android.widget.RemoteViews$OnClickHandler boolean ), 0, this, remoteViews, onClickHandler, bl);
        }

        @Override
        protected View getDefaultView() {
            return InvokeDynamicSupport.bootstrap("getDefaultView", $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsFrameLayout$getDefaultView(), 0, this);
        }

        @Override
        protected Context getRemoteContext() {
            return InvokeDynamicSupport.bootstrap("getRemoteContext", $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsFrameLayout$getRemoteContext(), 0, this);
        }

        @Override
        protected View getErrorView() {
            return InvokeDynamicSupport.bootstrap("getErrorView", $$robo$$android_widget_RemoteViewsAdapter_RemoteViewsFrameLayout$getErrorView(), 0, this);
        }

        public /* synthetic */ RemoteViewsFrameLayout() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RemoteViewsFrameLayout)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class RemoteServiceHandler
    extends Handler
    implements ServiceConnection,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<RemoteViewsAdapter> mAdapter;
        private Context mContext;
        private IRemoteViewsFactory mRemoteViewsFactory;
        private boolean mNotifyDataSetChangedPending;
        private boolean mBindRequested;

        private void $$robo$$android_widget_RemoteViewsAdapter_RemoteServiceHandler$__constructor__(Looper workerLooper, RemoteViewsAdapter adapter, Context context) {
            this.mNotifyDataSetChangedPending = false;
            this.mBindRequested = false;
            this.mAdapter = new WeakReference<RemoteViewsAdapter>(adapter);
            this.mContext = context;
        }

        private final void $$robo$$android_widget_RemoteViewsAdapter_RemoteServiceHandler$onServiceConnected(ComponentName name, IBinder service) {
            this.mRemoteViewsFactory = IRemoteViewsFactory.Stub.asInterface(service);
            this.enqueueDeferredUnbindServiceMessage();
            RemoteViewsAdapter adapter = (RemoteViewsAdapter)this.mAdapter.get();
            if (adapter == null) {
                return;
            }
            if (this.mNotifyDataSetChangedPending) {
                this.mNotifyDataSetChangedPending = false;
                Message msg = Message.obtain((Handler)this, 2);
                this.handleMessage(msg);
                msg.recycle();
            } else {
                if (!this.sendNotifyDataSetChange(false)) {
                    return;
                }
                adapter.updateTemporaryMetaData(this.mRemoteViewsFactory);
                adapter.mMainHandler.sendEmptyMessage(1);
                adapter.mMainHandler.sendEmptyMessage(3);
            }
        }

        private final void $$robo$$android_widget_RemoteViewsAdapter_RemoteServiceHandler$onServiceDisconnected(ComponentName name) {
            this.mRemoteViewsFactory = null;
            RemoteViewsAdapter adapter = (RemoteViewsAdapter)this.mAdapter.get();
            if (adapter != null) {
                adapter.mMainHandler.sendEmptyMessage(4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_widget_RemoteViewsAdapter_RemoteServiceHandler$handleMessage(Message msg) {
            RemoteViewsAdapter adapter = (RemoteViewsAdapter)this.mAdapter.get();
            switch (msg.what) {
                case 1: {
                    if (adapter == null || this.mRemoteViewsFactory != null) {
                        this.enqueueDeferredUnbindServiceMessage();
                    }
                    if (this.mBindRequested) {
                        return;
                    }
                    int flags = 0x2000001;
                    IServiceConnection sd = this.mContext.getServiceDispatcher(this, this, flags);
                    Intent intent = (Intent)msg.obj;
                    int appWidgetId = msg.arg1;
                    this.mBindRequested = AppWidgetManager.getInstance(this.mContext).bindRemoteViewsService(this.mContext, appWidgetId, intent, sd, flags);
                    return;
                }
                case 2: {
                    int[] visibleWindow;
                    int newCount;
                    this.enqueueDeferredUnbindServiceMessage();
                    if (adapter == null) {
                        return;
                    }
                    if (this.mRemoteViewsFactory == null) {
                        this.mNotifyDataSetChangedPending = true;
                        adapter.requestBindService();
                        return;
                    }
                    if (!this.sendNotifyDataSetChange(true)) {
                        return;
                    }
                    FixedSizeRemoteViewsCache flags = adapter.mCache;
                    synchronized (flags) {
                        adapter.mCache.reset();
                    }
                    adapter.updateTemporaryMetaData(this.mRemoteViewsFactory);
                    RemoteViewsMetaData remoteViewsMetaData = adapter.mCache.getTemporaryMetaData();
                    synchronized (remoteViewsMetaData) {
                        newCount = ((RemoteViewsAdapter)adapter).mCache.getTemporaryMetaData().count;
                        visibleWindow = adapter.getVisibleWindow(newCount);
                    }
                    for (Object position : (RemoteViewsMetaData)visibleWindow) {
                        if (position >= newCount) continue;
                        adapter.updateRemoteViews(this.mRemoteViewsFactory, (int)position, false);
                    }
                    adapter.mMainHandler.sendEmptyMessage(1);
                    adapter.mMainHandler.sendEmptyMessage(2);
                    return;
                }
                case 3: {
                    if (adapter == null || this.mRemoteViewsFactory == null) {
                        return;
                    }
                    this.removeMessages(4);
                    int position = adapter.mCache.getNextIndexToLoad();
                    if (position > -1) {
                        adapter.updateRemoteViews(this.mRemoteViewsFactory, position, true);
                        this.sendEmptyMessage(3);
                    } else {
                        this.enqueueDeferredUnbindServiceMessage();
                    }
                    return;
                }
                case 4: {
                    this.unbindNow();
                    return;
                }
            }
        }

        private final void $$robo$$android_widget_RemoteViewsAdapter_RemoteServiceHandler$unbindNow() {
            if (this.mBindRequested) {
                this.mBindRequested = false;
                this.mContext.unbindService(this);
            }
            this.mRemoteViewsFactory = null;
        }

        private final boolean $$robo$$android_widget_RemoteViewsAdapter_RemoteServiceHandler$sendNotifyDataSetChange(boolean always) {
            try {
                if (always || !this.mRemoteViewsFactory.isCreated()) {
                    this.mRemoteViewsFactory.onDataSetChanged();
                }
                return true;
            }
            catch (RemoteException | RuntimeException e) {
                Log.e("RemoteViewsAdapter", "Error in updateNotifyDataSetChanged(): " + e.getMessage());
                return false;
            }
        }

        private final void $$robo$$android_widget_RemoteViewsAdapter_RemoteServiceHandler$enqueueDeferredUnbindServiceMessage() {
            this.removeMessages(4);
            this.sendEmptyMessageDelayed(4, 5000L);
        }

        private void __constructor__(Looper looper, RemoteViewsAdapter remoteViewsAdapter, Context context) {
            this.$$robo$$android_widget_RemoteViewsAdapter_RemoteServiceHandler$__constructor__(looper, remoteViewsAdapter, context);
        }

        RemoteServiceHandler(Looper looper, RemoteViewsAdapter remoteViewsAdapter, Context context) {
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViewsAdapter_RemoteServiceHandler$__constructor__(android.os.Looper android.widget.RemoteViewsAdapter android.content.Context ), 0, this, looper, remoteViewsAdapter, context);
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_widget_RemoteViewsAdapter_RemoteServiceHandler$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_widget_RemoteViewsAdapter_RemoteServiceHandler$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_widget_RemoteViewsAdapter_RemoteServiceHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        protected void unbindNow() {
            InvokeDynamicSupport.bootstrap("unbindNow", $$robo$$android_widget_RemoteViewsAdapter_RemoteServiceHandler$unbindNow(), 0, this);
        }

        private boolean sendNotifyDataSetChange(boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("sendNotifyDataSetChange", $$robo$$android_widget_RemoteViewsAdapter_RemoteServiceHandler$sendNotifyDataSetChange(boolean ), 0, this, bl);
        }

        private void enqueueDeferredUnbindServiceMessage() {
            InvokeDynamicSupport.bootstrap("enqueueDeferredUnbindServiceMessage", $$robo$$android_widget_RemoteViewsAdapter_RemoteServiceHandler$enqueueDeferredUnbindServiceMessage(), 0, this);
        }

        public /* synthetic */ RemoteServiceHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RemoteServiceHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AsyncRemoteAdapterAction
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private RemoteAdapterConnectionCallback mCallback;
        private Intent mIntent;

        private void $$robo$$android_widget_RemoteViewsAdapter_AsyncRemoteAdapterAction$__constructor__(RemoteAdapterConnectionCallback callback, Intent intent) {
            this.mCallback = callback;
            this.mIntent = intent;
        }

        private final void $$robo$$android_widget_RemoteViewsAdapter_AsyncRemoteAdapterAction$run() {
            this.mCallback.setRemoteViewsAdapter(this.mIntent, true);
        }

        private void __constructor__(RemoteAdapterConnectionCallback remoteAdapterConnectionCallback, Intent intent) {
            this.$$robo$$android_widget_RemoteViewsAdapter_AsyncRemoteAdapterAction$__constructor__(remoteAdapterConnectionCallback, intent);
        }

        public AsyncRemoteAdapterAction(RemoteAdapterConnectionCallback remoteAdapterConnectionCallback, Intent intent) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViewsAdapter_AsyncRemoteAdapterAction$__constructor__(android.widget.RemoteViewsAdapter$RemoteAdapterConnectionCallback android.content.Intent ), 0, this, remoteAdapterConnectionCallback, intent);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_RemoteViewsAdapter_AsyncRemoteAdapterAction$run(), 0, this);
        }

        public /* synthetic */ AsyncRemoteAdapterAction() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AsyncRemoteAdapterAction)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface RemoteAdapterConnectionCallback
    extends InstrumentedInterface {
        public boolean onRemoteAdapterConnected();

        public void onRemoteAdapterDisconnected();

        public void deferNotifyDataSetChanged();

        public void setRemoteViewsAdapter(Intent var1, boolean var2);
    }
}

