/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.SearchManager;
import android.app.SearchableInfo;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.ImageView;
import android.widget.ResourceCursorAdapter;
import android.widget.SearchView;
import android.widget.TextView;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.WeakHashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SuggestionsAdapter
extends ResourceCursorAdapter
implements View.OnClickListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DBG = false;
    private static String LOG_TAG = "SuggestionsAdapter";
    private static int QUERY_LIMIT = 50;
    static int REFINE_NONE = 0;
    static int REFINE_BY_ENTRY = 1;
    static int REFINE_ALL = 2;
    private SearchManager mSearchManager;
    private SearchView mSearchView;
    private SearchableInfo mSearchable;
    private Context mProviderContext;
    private WeakHashMap<String, Drawable.ConstantState> mOutsideDrawablesCache;
    private int mCommitIconResId;
    private boolean mClosed;
    private int mQueryRefinement;
    private ColorStateList mUrlColor;
    static int INVALID_INDEX = -1;
    private int mText1Col;
    private int mText2Col;
    private int mText2UrlCol;
    private int mIconName1Col;
    private int mIconName2Col;
    private int mFlagsCol;
    private static long DELETE_KEY_POST_DELAY = 500L;

    private void $$robo$$android_widget_SuggestionsAdapter$__constructor__(Context context, SearchView searchView, SearchableInfo searchable, WeakHashMap<String, Drawable.ConstantState> outsideDrawablesCache) {
        this.mClosed = false;
        this.mQueryRefinement = 1;
        this.mText1Col = -1;
        this.mText2Col = -1;
        this.mText2UrlCol = -1;
        this.mIconName1Col = -1;
        this.mIconName2Col = -1;
        this.mFlagsCol = -1;
        this.mSearchManager = (SearchManager)this.mContext.getSystemService("search");
        this.mSearchView = searchView;
        this.mSearchable = searchable;
        this.mCommitIconResId = searchView.getSuggestionCommitIconResId();
        Context activityContext = this.mSearchable.getActivityContext(this.mContext);
        this.mProviderContext = this.mSearchable.getProviderContext(this.mContext, activityContext);
        this.mOutsideDrawablesCache = outsideDrawablesCache;
        this.getFilter().setDelayer(new Filter.Delayer(this){
            public transient /* synthetic */ Object __robo_data__;
            private int mPreviousLength;
            /* synthetic */ SuggestionsAdapter this$0;

            private void $$robo$$android_widget_SuggestionsAdapter_1$__constructor__(SuggestionsAdapter this$0) {
                this.mPreviousLength = 0;
            }

            private final long $$robo$$android_widget_SuggestionsAdapter_1$getPostingDelay(CharSequence constraint) {
                if (constraint == null) {
                    return 0L;
                }
                long delay = constraint.length() < this.mPreviousLength ? 500L : 0L;
                this.mPreviousLength = constraint.length();
                return delay;
            }

            private void __constructor__(SuggestionsAdapter suggestionsAdapter) {
                this.$$robo$$android_widget_SuggestionsAdapter_1$__constructor__(suggestionsAdapter);
            }
            {
                this.this$0 = suggestionsAdapter;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SuggestionsAdapter_1$__constructor__(android.widget.SuggestionsAdapter ), 0, this, suggestionsAdapter);
            }

            @Override
            public long getPostingDelay(CharSequence charSequence) {
                return (long)InvokeDynamicSupport.bootstrap("getPostingDelay", $$robo$$android_widget_SuggestionsAdapter_1$getPostingDelay(java.lang.CharSequence ), 0, this, charSequence);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_widget_SuggestionsAdapter$setQueryRefinement(int refineWhat) {
        this.mQueryRefinement = refineWhat;
    }

    private final int $$robo$$android_widget_SuggestionsAdapter$getQueryRefinement() {
        return this.mQueryRefinement;
    }

    private final boolean $$robo$$android_widget_SuggestionsAdapter$hasStableIds() {
        return false;
    }

    private final Cursor $$robo$$android_widget_SuggestionsAdapter$runQueryOnBackgroundThread(CharSequence constraint) {
        String query = constraint == null ? "" : constraint.toString();
        Cursor cursor = null;
        if (this.mSearchView.getVisibility() != 0 || this.mSearchView.getWindowVisibility() != 0) {
            return null;
        }
        try {
            cursor = this.mSearchManager.getSuggestions(this.mSearchable, query, 50);
            if (cursor != null) {
                cursor.getCount();
                return cursor;
            }
        }
        catch (RuntimeException e) {
            Log.w("SuggestionsAdapter", "Search suggestions query threw an exception.", e);
        }
        return null;
    }

    private final void $$robo$$android_widget_SuggestionsAdapter$close() {
        this.changeCursor(null);
        this.mClosed = true;
    }

    private final void $$robo$$android_widget_SuggestionsAdapter$notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.updateSpinnerState(this.getCursor());
    }

    private final void $$robo$$android_widget_SuggestionsAdapter$notifyDataSetInvalidated() {
        super.notifyDataSetInvalidated();
        this.updateSpinnerState(this.getCursor());
    }

    private final void $$robo$$android_widget_SuggestionsAdapter$updateSpinnerState(Cursor cursor) {
        Bundle extras;
        Bundle bundle = extras = cursor != null ? cursor.getExtras() : null;
        if (extras != null && extras.getBoolean("in_progress")) {
            return;
        }
    }

    private final void $$robo$$android_widget_SuggestionsAdapter$changeCursor(Cursor c) {
        if (this.mClosed) {
            Log.w("SuggestionsAdapter", "Tried to change cursor after adapter was closed.");
            if (c != null) {
                c.close();
            }
            return;
        }
        try {
            super.changeCursor(c);
            if (c != null) {
                this.mText1Col = c.getColumnIndex("suggest_text_1");
                this.mText2Col = c.getColumnIndex("suggest_text_2");
                this.mText2UrlCol = c.getColumnIndex("suggest_text_2_url");
                this.mIconName1Col = c.getColumnIndex("suggest_icon_1");
                this.mIconName2Col = c.getColumnIndex("suggest_icon_2");
                this.mFlagsCol = c.getColumnIndex("suggest_flags");
            }
        }
        catch (Exception e) {
            Log.e("SuggestionsAdapter", "error changing cursor and caching columns", e);
        }
    }

    private final View $$robo$$android_widget_SuggestionsAdapter$newView(Context context, Cursor cursor, ViewGroup parent) {
        View v = super.newView(context, cursor, parent);
        v.setTag(new ChildViewCache(v));
        ImageView iconRefine = (ImageView)v.findViewById(16908852);
        iconRefine.setImageResource(this.mCommitIconResId);
        return v;
    }

    private final void $$robo$$android_widget_SuggestionsAdapter$bindView(View view, Context context, Cursor cursor) {
        ChildViewCache views = (ChildViewCache)view.getTag();
        int flags = 0;
        if (this.mFlagsCol != -1) {
            flags = cursor.getInt(this.mFlagsCol);
        }
        if (views.mText1 != null) {
            String text1 = SuggestionsAdapter.getStringOrNull(cursor, this.mText1Col);
            this.setViewText(views.mText1, text1);
        }
        if (views.mText2 != null) {
            CharSequence text2 = SuggestionsAdapter.getStringOrNull(cursor, this.mText2UrlCol);
            text2 = text2 != null ? this.formatUrl(context, text2) : SuggestionsAdapter.getStringOrNull(cursor, this.mText2Col);
            if (TextUtils.isEmpty(text2)) {
                if (views.mText1 != null) {
                    views.mText1.setSingleLine(false);
                    views.mText1.setMaxLines(2);
                }
            } else if (views.mText1 != null) {
                views.mText1.setSingleLine(true);
                views.mText1.setMaxLines(1);
            }
            this.setViewText(views.mText2, text2);
        }
        if (views.mIcon1 != null) {
            this.setViewDrawable(views.mIcon1, this.getIcon1(cursor), 4);
        }
        if (views.mIcon2 != null) {
            this.setViewDrawable(views.mIcon2, this.getIcon2(cursor), 8);
        }
        if (this.mQueryRefinement == 2 || this.mQueryRefinement == 1 && (flags & 1) != 0) {
            views.mIconRefine.setVisibility(0);
            views.mIconRefine.setTag(views.mText1.getText());
            views.mIconRefine.setOnClickListener(this);
        } else {
            views.mIconRefine.setVisibility(8);
        }
    }

    private final void $$robo$$android_widget_SuggestionsAdapter$onClick(View v) {
        Object tag = v.getTag();
        if (tag instanceof CharSequence) {
            this.mSearchView.onQueryRefine((CharSequence)tag);
        }
    }

    private final CharSequence $$robo$$android_widget_SuggestionsAdapter$formatUrl(Context context, CharSequence url) {
        if (this.mUrlColor == null) {
            TypedValue colorValue = new TypedValue();
            context.getTheme().resolveAttribute(17891538, colorValue, true);
            this.mUrlColor = context.getColorStateList(colorValue.resourceId);
        }
        SpannableString text = new SpannableString(url);
        text.setSpan(new TextAppearanceSpan(null, 0, 0, this.mUrlColor, null), 0, url.length(), 33);
        return text;
    }

    private final void $$robo$$android_widget_SuggestionsAdapter$setViewText(TextView v, CharSequence text) {
        v.setText(text);
        if (TextUtils.isEmpty(text)) {
            v.setVisibility(8);
        } else {
            v.setVisibility(0);
        }
    }

    private final Drawable $$robo$$android_widget_SuggestionsAdapter$getIcon1(Cursor cursor) {
        if (this.mIconName1Col == -1) {
            return null;
        }
        String value = cursor.getString(this.mIconName1Col);
        Drawable drawable2 = this.getDrawableFromResourceValue(value);
        if (drawable2 != null) {
            return drawable2;
        }
        return this.getDefaultIcon1(cursor);
    }

    private final Drawable $$robo$$android_widget_SuggestionsAdapter$getIcon2(Cursor cursor) {
        if (this.mIconName2Col == -1) {
            return null;
        }
        String value = cursor.getString(this.mIconName2Col);
        return this.getDrawableFromResourceValue(value);
    }

    private final void $$robo$$android_widget_SuggestionsAdapter$setViewDrawable(ImageView v, Drawable drawable2, int nullVisibility) {
        v.setImageDrawable(drawable2);
        if (drawable2 == null) {
            v.setVisibility(nullVisibility);
        } else {
            v.setVisibility(0);
            drawable2.setVisible(false, false);
            drawable2.setVisible(true, false);
        }
    }

    private final CharSequence $$robo$$android_widget_SuggestionsAdapter$convertToString(Cursor cursor) {
        String text1;
        String data;
        if (cursor == null) {
            return null;
        }
        String query = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_query");
        if (query != null) {
            return query;
        }
        if (this.mSearchable.shouldRewriteQueryFromData() && (data = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_data")) != null) {
            return data;
        }
        if (this.mSearchable.shouldRewriteQueryFromText() && (text1 = SuggestionsAdapter.getColumnString(cursor, "suggest_text_1")) != null) {
            return text1;
        }
        return null;
    }

    private final View $$robo$$android_widget_SuggestionsAdapter$getView(int position, View convertView, ViewGroup parent) {
        try {
            return super.getView(position, convertView, parent);
        }
        catch (RuntimeException e) {
            Log.w("SuggestionsAdapter", "Search suggestions cursor threw exception.", e);
            View v = this.newView(this.mContext, this.mCursor, parent);
            if (v != null) {
                ChildViewCache views = (ChildViewCache)v.getTag();
                TextView tv = views.mText1;
                tv.setText(e.toString());
            }
            return v;
        }
    }

    private final View $$robo$$android_widget_SuggestionsAdapter$getDropDownView(int position, View convertView, ViewGroup parent) {
        try {
            return super.getDropDownView(position, convertView, parent);
        }
        catch (RuntimeException e) {
            Log.w("SuggestionsAdapter", "Search suggestions cursor threw exception.", e);
            Context context = this.mDropDownContext == null ? this.mContext : this.mDropDownContext;
            View v = this.newDropDownView(context, this.mCursor, parent);
            if (v != null) {
                ChildViewCache views = (ChildViewCache)v.getTag();
                TextView tv = views.mText1;
                tv.setText(e.toString());
            }
            return v;
        }
    }

    private final Drawable $$robo$$android_widget_SuggestionsAdapter$getDrawableFromResourceValue(String drawableId) {
        if (drawableId == null || drawableId.length() == 0 || "0".equals(drawableId)) {
            return null;
        }
        try {
            int resourceId = Integer.parseInt(drawableId);
            String drawableUri = "android.resource://" + this.mProviderContext.getPackageName() + "/" + resourceId;
            Drawable drawable2 = this.checkIconCache(drawableUri);
            if (drawable2 != null) {
                return drawable2;
            }
            drawable2 = this.mProviderContext.getDrawable(resourceId);
            this.storeInIconCache(drawableUri, drawable2);
            return drawable2;
        }
        catch (NumberFormatException nfe) {
            Drawable drawable3 = this.checkIconCache(drawableId);
            if (drawable3 != null) {
                return drawable3;
            }
            Uri uri = Uri.parse(drawableId);
            drawable3 = this.getDrawable(uri);
            this.storeInIconCache(drawableId, drawable3);
            return drawable3;
        }
        catch (Resources.NotFoundException nfe) {
            Log.w("SuggestionsAdapter", "Icon resource not found: " + drawableId);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Drawable $$robo$$android_widget_SuggestionsAdapter$getDrawable(Uri uri) {
        Drawable drawable2;
        String scheme = uri.getScheme();
        if ("android.resource".equals(scheme)) {
            ContentResolver.OpenResourceIdResult r = this.mProviderContext.getContentResolver().getResourceId(uri);
            try {
                return r.r.getDrawable(r.id, this.mProviderContext.getTheme());
            }
            catch (Resources.NotFoundException ex) {
                throw new FileNotFoundException("Resource does not exist: " + uri);
            }
        }
        InputStream stream = this.mProviderContext.getContentResolver().openInputStream(uri);
        if (stream == null) {
            throw new FileNotFoundException("Failed to open " + uri);
        }
        try {
            drawable2 = Drawable.createFromStream(stream, null);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (IOException ex) {
                    Log.e("SuggestionsAdapter", "Error closing icon stream for " + uri, ex);
                }
                throw throwable;
            }
            catch (FileNotFoundException fnfe) {
                Log.w("SuggestionsAdapter", "Icon not found: " + uri + ", " + fnfe.getMessage());
                return null;
            }
        }
        try {
            stream.close();
        }
        catch (IOException ex) {
            Log.e("SuggestionsAdapter", "Error closing icon stream for " + uri, ex);
        }
        return drawable2;
    }

    private final Drawable $$robo$$android_widget_SuggestionsAdapter$checkIconCache(String resourceUri) {
        Drawable.ConstantState cached = this.mOutsideDrawablesCache.get(resourceUri);
        if (cached == null) {
            return null;
        }
        return cached.newDrawable();
    }

    private final void $$robo$$android_widget_SuggestionsAdapter$storeInIconCache(String resourceUri, Drawable drawable2) {
        if (drawable2 != null) {
            this.mOutsideDrawablesCache.put(resourceUri, drawable2.getConstantState());
        }
    }

    private final Drawable $$robo$$android_widget_SuggestionsAdapter$getDefaultIcon1(Cursor cursor) {
        Drawable drawable2 = this.getActivityIconWithCache(this.mSearchable.getSearchActivity());
        if (drawable2 != null) {
            return drawable2;
        }
        return this.mContext.getPackageManager().getDefaultActivityIcon();
    }

    private final Drawable $$robo$$android_widget_SuggestionsAdapter$getActivityIconWithCache(ComponentName component) {
        String componentIconKey = component.flattenToShortString();
        if (this.mOutsideDrawablesCache.containsKey(componentIconKey)) {
            Drawable.ConstantState cached = this.mOutsideDrawablesCache.get(componentIconKey);
            return cached == null ? null : cached.newDrawable(this.mProviderContext.getResources());
        }
        Drawable drawable2 = this.getActivityIcon(component);
        Drawable.ConstantState toCache = drawable2 == null ? null : drawable2.getConstantState();
        this.mOutsideDrawablesCache.put(componentIconKey, toCache);
        return drawable2;
    }

    private final Drawable $$robo$$android_widget_SuggestionsAdapter$getActivityIcon(ComponentName component) {
        ActivityInfo activityInfo;
        PackageManager pm = this.mContext.getPackageManager();
        try {
            activityInfo = pm.getActivityInfo(component, 128);
        }
        catch (PackageManager.NameNotFoundException ex) {
            Log.w("SuggestionsAdapter", ex.toString());
            return null;
        }
        int iconId = activityInfo.getIconResource();
        if (iconId == 0) {
            return null;
        }
        String pkg = component.getPackageName();
        Drawable drawable2 = pm.getDrawable(pkg, iconId, activityInfo.applicationInfo);
        if (drawable2 == null) {
            Log.w("SuggestionsAdapter", "Invalid icon resource " + iconId + " for " + component.flattenToShortString());
            return null;
        }
        return drawable2;
    }

    private static final String $$robo$$android_widget_SuggestionsAdapter$getColumnString(Cursor cursor, String columnName) {
        int col = cursor.getColumnIndex(columnName);
        return SuggestionsAdapter.getStringOrNull(cursor, col);
    }

    private static final String $$robo$$android_widget_SuggestionsAdapter$getStringOrNull(Cursor cursor, int col) {
        if (col == -1) {
            return null;
        }
        try {
            return cursor.getString(col);
        }
        catch (Exception e) {
            Log.e("SuggestionsAdapter", "unexpected error retrieving valid column from cursor, did the remote process die?", e);
            return null;
        }
    }

    private void __constructor__(Context context, SearchView searchView, SearchableInfo searchableInfo, WeakHashMap<String, Drawable.ConstantState> weakHashMap) {
        this.$$robo$$android_widget_SuggestionsAdapter$__constructor__(context, searchView, searchableInfo, weakHashMap);
    }

    public SuggestionsAdapter(Context context, SearchView searchView, SearchableInfo searchableInfo, WeakHashMap<String, Drawable.ConstantState> weakHashMap) {
        super(context, searchView.getSuggestionRowLayout(), null, true);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SuggestionsAdapter$__constructor__(android.content.Context android.widget.SearchView android.app.SearchableInfo java.util.WeakHashMap<java.lang.String, android.graphics.drawable.Drawable$ConstantState> ), 0, this, context, searchView, searchableInfo, weakHashMap);
    }

    public void setQueryRefinement(int n) {
        InvokeDynamicSupport.bootstrap("setQueryRefinement", $$robo$$android_widget_SuggestionsAdapter$setQueryRefinement(int ), 0, this, n);
    }

    public int getQueryRefinement() {
        return (int)InvokeDynamicSupport.bootstrap("getQueryRefinement", $$robo$$android_widget_SuggestionsAdapter$getQueryRefinement(), 0, this);
    }

    @Override
    public boolean hasStableIds() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasStableIds", $$robo$$android_widget_SuggestionsAdapter$hasStableIds(), 0, this);
    }

    @Override
    public Cursor runQueryOnBackgroundThread(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("runQueryOnBackgroundThread", $$robo$$android_widget_SuggestionsAdapter$runQueryOnBackgroundThread(java.lang.CharSequence ), 0, this, charSequence);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_widget_SuggestionsAdapter$close(), 0, this);
    }

    @Override
    public void notifyDataSetChanged() {
        InvokeDynamicSupport.bootstrap("notifyDataSetChanged", $$robo$$android_widget_SuggestionsAdapter$notifyDataSetChanged(), 0, this);
    }

    @Override
    public void notifyDataSetInvalidated() {
        InvokeDynamicSupport.bootstrap("notifyDataSetInvalidated", $$robo$$android_widget_SuggestionsAdapter$notifyDataSetInvalidated(), 0, this);
    }

    private void updateSpinnerState(Cursor cursor) {
        InvokeDynamicSupport.bootstrap("updateSpinnerState", $$robo$$android_widget_SuggestionsAdapter$updateSpinnerState(android.database.Cursor ), 0, this, cursor);
    }

    @Override
    public void changeCursor(Cursor cursor) {
        InvokeDynamicSupport.bootstrap("changeCursor", $$robo$$android_widget_SuggestionsAdapter$changeCursor(android.database.Cursor ), 0, this, cursor);
    }

    @Override
    public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("newView", $$robo$$android_widget_SuggestionsAdapter$newView(android.content.Context android.database.Cursor android.view.ViewGroup ), 0, this, context, cursor, viewGroup);
    }

    @Override
    public void bindView(View view, Context context, Cursor cursor) {
        InvokeDynamicSupport.bootstrap("bindView", $$robo$$android_widget_SuggestionsAdapter$bindView(android.view.View android.content.Context android.database.Cursor ), 0, this, view, context, cursor);
    }

    @Override
    public void onClick(View view) {
        InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_SuggestionsAdapter$onClick(android.view.View ), 0, this, view);
    }

    private CharSequence formatUrl(Context context, CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("formatUrl", $$robo$$android_widget_SuggestionsAdapter$formatUrl(android.content.Context java.lang.CharSequence ), 0, this, context, charSequence);
    }

    private void setViewText(TextView textView, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setViewText", $$robo$$android_widget_SuggestionsAdapter$setViewText(android.widget.TextView java.lang.CharSequence ), 0, this, textView, charSequence);
    }

    private Drawable getIcon1(Cursor cursor) {
        return InvokeDynamicSupport.bootstrap("getIcon1", $$robo$$android_widget_SuggestionsAdapter$getIcon1(android.database.Cursor ), 0, this, cursor);
    }

    private Drawable getIcon2(Cursor cursor) {
        return InvokeDynamicSupport.bootstrap("getIcon2", $$robo$$android_widget_SuggestionsAdapter$getIcon2(android.database.Cursor ), 0, this, cursor);
    }

    private void setViewDrawable(ImageView imageView, Drawable drawable2, int n) {
        InvokeDynamicSupport.bootstrap("setViewDrawable", $$robo$$android_widget_SuggestionsAdapter$setViewDrawable(android.widget.ImageView android.graphics.drawable.Drawable int ), 0, this, imageView, drawable2, n);
    }

    @Override
    public CharSequence convertToString(Cursor cursor) {
        return InvokeDynamicSupport.bootstrap("convertToString", $$robo$$android_widget_SuggestionsAdapter$convertToString(android.database.Cursor ), 0, this, cursor);
    }

    @Override
    public View getView(int n, View view, ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("getView", $$robo$$android_widget_SuggestionsAdapter$getView(int android.view.View android.view.ViewGroup ), 0, this, n, view, viewGroup);
    }

    @Override
    public View getDropDownView(int n, View view, ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("getDropDownView", $$robo$$android_widget_SuggestionsAdapter$getDropDownView(int android.view.View android.view.ViewGroup ), 0, this, n, view, viewGroup);
    }

    private Drawable getDrawableFromResourceValue(String string2) {
        return InvokeDynamicSupport.bootstrap("getDrawableFromResourceValue", $$robo$$android_widget_SuggestionsAdapter$getDrawableFromResourceValue(java.lang.String ), 0, this, string2);
    }

    private Drawable getDrawable(Uri uri) {
        return InvokeDynamicSupport.bootstrap("getDrawable", $$robo$$android_widget_SuggestionsAdapter$getDrawable(android.net.Uri ), 0, this, uri);
    }

    private Drawable checkIconCache(String string2) {
        return InvokeDynamicSupport.bootstrap("checkIconCache", $$robo$$android_widget_SuggestionsAdapter$checkIconCache(java.lang.String ), 0, this, string2);
    }

    private void storeInIconCache(String string2, Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("storeInIconCache", $$robo$$android_widget_SuggestionsAdapter$storeInIconCache(java.lang.String android.graphics.drawable.Drawable ), 0, this, string2, drawable2);
    }

    private Drawable getDefaultIcon1(Cursor cursor) {
        return InvokeDynamicSupport.bootstrap("getDefaultIcon1", $$robo$$android_widget_SuggestionsAdapter$getDefaultIcon1(android.database.Cursor ), 0, this, cursor);
    }

    private Drawable getActivityIconWithCache(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getActivityIconWithCache", $$robo$$android_widget_SuggestionsAdapter$getActivityIconWithCache(android.content.ComponentName ), 0, this, componentName);
    }

    private Drawable getActivityIcon(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getActivityIcon", $$robo$$android_widget_SuggestionsAdapter$getActivityIcon(android.content.ComponentName ), 0, this, componentName);
    }

    public static String getColumnString(Cursor cursor, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getColumnString", $$robo$$android_widget_SuggestionsAdapter$getColumnString(android.database.Cursor java.lang.String ), 0, (Cursor)cursor, (String)string2);
    }

    private static String getStringOrNull(Cursor cursor, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getStringOrNull", $$robo$$android_widget_SuggestionsAdapter$getStringOrNull(android.database.Cursor int ), 0, (Cursor)cursor, (int)n);
    }

    public /* synthetic */ SuggestionsAdapter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SuggestionsAdapter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class ChildViewCache
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public TextView mText1;
        public TextView mText2;
        public ImageView mIcon1;
        public ImageView mIcon2;
        public ImageView mIconRefine;

        private void $$robo$$android_widget_SuggestionsAdapter_ChildViewCache$__constructor__(View v) {
            this.mText1 = (TextView)v.findViewById(16908308);
            this.mText2 = (TextView)v.findViewById(16908309);
            this.mIcon1 = (ImageView)v.findViewById(16908295);
            this.mIcon2 = (ImageView)v.findViewById(16908296);
            this.mIconRefine = (ImageView)v.findViewById(16908852);
        }

        private void __constructor__(View view) {
            this.$$robo$$android_widget_SuggestionsAdapter_ChildViewCache$__constructor__(view);
        }

        public ChildViewCache(View view) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SuggestionsAdapter_ChildViewCache$__constructor__(android.view.View ), 0, this, view);
        }

        public /* synthetic */ ChildViewCache() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChildViewCache)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

