/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Insets;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.AllCapsTransformationMethod;
import android.text.method.TransformationMethod2;
import android.util.AttributeSet;
import android.util.FloatProperty;
import android.util.MathUtils;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import android.view.ViewStructure;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.CompoundButton;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Switch
extends CompoundButton
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int THUMB_ANIMATION_DURATION = 250;
    private static int TOUCH_MODE_IDLE = 0;
    private static int TOUCH_MODE_DOWN = 1;
    private static int TOUCH_MODE_DRAGGING = 2;
    private static int SANS = 1;
    private static int SERIF = 2;
    private static int MONOSPACE = 3;
    private Drawable mThumbDrawable;
    private ColorStateList mThumbTintList;
    private PorterDuff.Mode mThumbTintMode;
    private boolean mHasThumbTint;
    private boolean mHasThumbTintMode;
    private Drawable mTrackDrawable;
    private ColorStateList mTrackTintList;
    private PorterDuff.Mode mTrackTintMode;
    private boolean mHasTrackTint;
    private boolean mHasTrackTintMode;
    private int mThumbTextPadding;
    private int mSwitchMinWidth;
    private int mSwitchPadding;
    private boolean mSplitTrack;
    private CharSequence mTextOn;
    private CharSequence mTextOff;
    private boolean mShowText;
    private boolean mUseFallbackLineSpacing;
    private int mTouchMode;
    private int mTouchSlop;
    private float mTouchX;
    private float mTouchY;
    private VelocityTracker mVelocityTracker;
    private int mMinFlingVelocity;
    private float mThumbPosition;
    private int mSwitchWidth;
    private int mSwitchHeight;
    private int mThumbWidth;
    private int mSwitchLeft;
    private int mSwitchTop;
    private int mSwitchRight;
    private int mSwitchBottom;
    private TextPaint mTextPaint;
    private ColorStateList mTextColors;
    private Layout mOnLayout;
    private Layout mOffLayout;
    private TransformationMethod2 mSwitchTransformationMethod;
    private ObjectAnimator mPositionAnimator;
    private Rect mTempRect;
    private static int[] CHECKED_STATE_SET;
    private static FloatProperty<Switch> THUMB_POS;

    private void $$robo$$android_widget_Switch$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_Switch$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_Switch$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_Switch$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        int appearance;
        PorterDuff.Mode trackTintMode;
        ColorStateList trackTintList;
        PorterDuff.Mode thumbTintMode;
        this.mThumbTintList = null;
        this.mThumbTintMode = null;
        this.mHasThumbTint = false;
        this.mHasThumbTintMode = false;
        this.mTrackTintList = null;
        this.mTrackTintMode = null;
        this.mHasTrackTint = false;
        this.mHasTrackTintMode = false;
        this.mVelocityTracker = VelocityTracker.obtain();
        this.mTempRect = new Rect();
        this.mTextPaint = new TextPaint(1);
        Resources res = this.getResources();
        this.mTextPaint.density = res.getDisplayMetrics().density;
        this.mTextPaint.setCompatibilityScaling(res.getCompatibilityInfo().applicationScale);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Switch, defStyleAttr, defStyleRes);
        this.mThumbDrawable = a.getDrawable(2);
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.setCallback(this);
        }
        this.mTrackDrawable = a.getDrawable(4);
        if (this.mTrackDrawable != null) {
            this.mTrackDrawable.setCallback(this);
        }
        this.mTextOn = a.getText(0);
        this.mTextOff = a.getText(1);
        this.mShowText = a.getBoolean(11, true);
        this.mThumbTextPadding = a.getDimensionPixelSize(7, 0);
        this.mSwitchMinWidth = a.getDimensionPixelSize(5, 0);
        this.mSwitchPadding = a.getDimensionPixelSize(6, 0);
        this.mSplitTrack = a.getBoolean(8, false);
        this.mUseFallbackLineSpacing = context.getApplicationInfo().targetSdkVersion >= 28;
        ColorStateList thumbTintList = a.getColorStateList(9);
        if (thumbTintList != null) {
            this.mThumbTintList = thumbTintList;
            this.mHasThumbTint = true;
        }
        if (this.mThumbTintMode != (thumbTintMode = Drawable.parseTintMode(a.getInt(10, -1), null))) {
            this.mThumbTintMode = thumbTintMode;
            this.mHasThumbTintMode = true;
        }
        if (this.mHasThumbTint || this.mHasThumbTintMode) {
            this.applyThumbTint();
        }
        if ((trackTintList = a.getColorStateList(12)) != null) {
            this.mTrackTintList = trackTintList;
            this.mHasTrackTint = true;
        }
        if (this.mTrackTintMode != (trackTintMode = Drawable.parseTintMode(a.getInt(13, -1), null))) {
            this.mTrackTintMode = trackTintMode;
            this.mHasTrackTintMode = true;
        }
        if (this.mHasTrackTint || this.mHasTrackTintMode) {
            this.applyTrackTint();
        }
        if ((appearance = a.getResourceId(3, 0)) != 0) {
            this.setSwitchTextAppearance(context, appearance);
        }
        a.recycle();
        ViewConfiguration config = ViewConfiguration.get(context);
        this.mTouchSlop = config.getScaledTouchSlop();
        this.mMinFlingVelocity = config.getScaledMinimumFlingVelocity();
        this.refreshDrawableState();
        this.setChecked(this.isChecked());
    }

    private final void $$robo$$android_widget_Switch$setSwitchTextAppearance(Context context, int resid) {
        TypedArray appearance = context.obtainStyledAttributes(resid, R.styleable.TextAppearance);
        ColorStateList colors = appearance.getColorStateList(3);
        this.mTextColors = colors != null ? colors : this.getTextColors();
        int ts = appearance.getDimensionPixelSize(0, 0);
        if (ts != 0 && (float)ts != this.mTextPaint.getTextSize()) {
            this.mTextPaint.setTextSize(ts);
            this.requestLayout();
        }
        int typefaceIndex = appearance.getInt(1, -1);
        int styleIndex = appearance.getInt(2, -1);
        this.setSwitchTypefaceByIndex(typefaceIndex, styleIndex);
        boolean allCaps = appearance.getBoolean(11, false);
        if (allCaps) {
            this.mSwitchTransformationMethod = new AllCapsTransformationMethod(this.getContext());
            this.mSwitchTransformationMethod.setLengthChangesAllowed(true);
        } else {
            this.mSwitchTransformationMethod = null;
        }
        appearance.recycle();
    }

    private final void $$robo$$android_widget_Switch$setSwitchTypefaceByIndex(int typefaceIndex, int styleIndex) {
        Typeface tf = null;
        switch (typefaceIndex) {
            case 1: {
                tf = Typeface.SANS_SERIF;
                break;
            }
            case 2: {
                tf = Typeface.SERIF;
                break;
            }
            case 3: {
                tf = Typeface.MONOSPACE;
            }
        }
        this.setSwitchTypeface(tf, styleIndex);
    }

    private final void $$robo$$android_widget_Switch$setSwitchTypeface(Typeface tf, int style2) {
        if (style2 > 0) {
            tf = tf == null ? Typeface.defaultFromStyle(style2) : Typeface.create(tf, style2);
            this.setSwitchTypeface(tf);
            int typefaceStyle = tf != null ? tf.getStyle() : 0;
            int need = style2 & ~typefaceStyle;
            this.mTextPaint.setFakeBoldText((need & 1) != 0);
            this.mTextPaint.setTextSkewX((need & 2) != 0 ? -0.25f : 0.0f);
        } else {
            this.mTextPaint.setFakeBoldText(false);
            this.mTextPaint.setTextSkewX(0.0f);
            this.setSwitchTypeface(tf);
        }
    }

    private final void $$robo$$android_widget_Switch$setSwitchTypeface(Typeface tf) {
        if (this.mTextPaint.getTypeface() != tf) {
            this.mTextPaint.setTypeface(tf);
            this.requestLayout();
            this.invalidate();
        }
    }

    private final void $$robo$$android_widget_Switch$setSwitchPadding(int pixels) {
        this.mSwitchPadding = pixels;
        this.requestLayout();
    }

    private final int $$robo$$android_widget_Switch$getSwitchPadding() {
        return this.mSwitchPadding;
    }

    private final void $$robo$$android_widget_Switch$setSwitchMinWidth(int pixels) {
        this.mSwitchMinWidth = pixels;
        this.requestLayout();
    }

    private final int $$robo$$android_widget_Switch$getSwitchMinWidth() {
        return this.mSwitchMinWidth;
    }

    private final void $$robo$$android_widget_Switch$setThumbTextPadding(int pixels) {
        this.mThumbTextPadding = pixels;
        this.requestLayout();
    }

    private final int $$robo$$android_widget_Switch$getThumbTextPadding() {
        return this.mThumbTextPadding;
    }

    private final void $$robo$$android_widget_Switch$setTrackDrawable(Drawable track) {
        if (this.mTrackDrawable != null) {
            this.mTrackDrawable.setCallback(null);
        }
        this.mTrackDrawable = track;
        if (track != null) {
            track.setCallback(this);
        }
        this.requestLayout();
    }

    private final void $$robo$$android_widget_Switch$setTrackResource(int resId) {
        this.setTrackDrawable(this.getContext().getDrawable(resId));
    }

    private final Drawable $$robo$$android_widget_Switch$getTrackDrawable() {
        return this.mTrackDrawable;
    }

    private final void $$robo$$android_widget_Switch$setTrackTintList(ColorStateList tint) {
        this.mTrackTintList = tint;
        this.mHasTrackTint = true;
        this.applyTrackTint();
    }

    private final ColorStateList $$robo$$android_widget_Switch$getTrackTintList() {
        return this.mTrackTintList;
    }

    private final void $$robo$$android_widget_Switch$setTrackTintMode(PorterDuff.Mode tintMode) {
        this.mTrackTintMode = tintMode;
        this.mHasTrackTintMode = true;
        this.applyTrackTint();
    }

    private final PorterDuff.Mode $$robo$$android_widget_Switch$getTrackTintMode() {
        return this.mTrackTintMode;
    }

    private final void $$robo$$android_widget_Switch$applyTrackTint() {
        if (this.mTrackDrawable != null && (this.mHasTrackTint || this.mHasTrackTintMode)) {
            this.mTrackDrawable = this.mTrackDrawable.mutate();
            if (this.mHasTrackTint) {
                this.mTrackDrawable.setTintList(this.mTrackTintList);
            }
            if (this.mHasTrackTintMode) {
                this.mTrackDrawable.setTintMode(this.mTrackTintMode);
            }
            if (this.mTrackDrawable.isStateful()) {
                this.mTrackDrawable.setState(this.getDrawableState());
            }
        }
    }

    private final void $$robo$$android_widget_Switch$setThumbDrawable(Drawable thumb) {
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.setCallback(null);
        }
        this.mThumbDrawable = thumb;
        if (thumb != null) {
            thumb.setCallback(this);
        }
        this.requestLayout();
    }

    private final void $$robo$$android_widget_Switch$setThumbResource(int resId) {
        this.setThumbDrawable(this.getContext().getDrawable(resId));
    }

    private final Drawable $$robo$$android_widget_Switch$getThumbDrawable() {
        return this.mThumbDrawable;
    }

    private final void $$robo$$android_widget_Switch$setThumbTintList(ColorStateList tint) {
        this.mThumbTintList = tint;
        this.mHasThumbTint = true;
        this.applyThumbTint();
    }

    private final ColorStateList $$robo$$android_widget_Switch$getThumbTintList() {
        return this.mThumbTintList;
    }

    private final void $$robo$$android_widget_Switch$setThumbTintMode(PorterDuff.Mode tintMode) {
        this.mThumbTintMode = tintMode;
        this.mHasThumbTintMode = true;
        this.applyThumbTint();
    }

    private final PorterDuff.Mode $$robo$$android_widget_Switch$getThumbTintMode() {
        return this.mThumbTintMode;
    }

    private final void $$robo$$android_widget_Switch$applyThumbTint() {
        if (this.mThumbDrawable != null && (this.mHasThumbTint || this.mHasThumbTintMode)) {
            this.mThumbDrawable = this.mThumbDrawable.mutate();
            if (this.mHasThumbTint) {
                this.mThumbDrawable.setTintList(this.mThumbTintList);
            }
            if (this.mHasThumbTintMode) {
                this.mThumbDrawable.setTintMode(this.mThumbTintMode);
            }
            if (this.mThumbDrawable.isStateful()) {
                this.mThumbDrawable.setState(this.getDrawableState());
            }
        }
    }

    private final void $$robo$$android_widget_Switch$setSplitTrack(boolean splitTrack) {
        this.mSplitTrack = splitTrack;
        this.invalidate();
    }

    private final boolean $$robo$$android_widget_Switch$getSplitTrack() {
        return this.mSplitTrack;
    }

    private final CharSequence $$robo$$android_widget_Switch$getTextOn() {
        return this.mTextOn;
    }

    private final void $$robo$$android_widget_Switch$setTextOn(CharSequence textOn) {
        this.mTextOn = textOn;
        this.requestLayout();
    }

    private final CharSequence $$robo$$android_widget_Switch$getTextOff() {
        return this.mTextOff;
    }

    private final void $$robo$$android_widget_Switch$setTextOff(CharSequence textOff) {
        this.mTextOff = textOff;
        this.requestLayout();
    }

    private final void $$robo$$android_widget_Switch$setShowText(boolean showText) {
        if (this.mShowText != showText) {
            this.mShowText = showText;
            this.requestLayout();
        }
    }

    private final boolean $$robo$$android_widget_Switch$getShowText() {
        return this.mShowText;
    }

    private final void $$robo$$android_widget_Switch$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int trackHeight;
        int thumbHeight;
        int thumbWidth;
        if (this.mShowText) {
            if (this.mOnLayout == null) {
                this.mOnLayout = this.makeLayout(this.mTextOn);
            }
            if (this.mOffLayout == null) {
                this.mOffLayout = this.makeLayout(this.mTextOff);
            }
        }
        Rect padding = this.mTempRect;
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.getPadding(padding);
            thumbWidth = this.mThumbDrawable.getIntrinsicWidth() - padding.left - padding.right;
            thumbHeight = this.mThumbDrawable.getIntrinsicHeight();
        } else {
            thumbWidth = 0;
            thumbHeight = 0;
        }
        int maxTextWidth = this.mShowText ? Math.max(this.mOnLayout.getWidth(), this.mOffLayout.getWidth()) + this.mThumbTextPadding * 2 : 0;
        this.mThumbWidth = Math.max(maxTextWidth, thumbWidth);
        if (this.mTrackDrawable != null) {
            this.mTrackDrawable.getPadding(padding);
            trackHeight = this.mTrackDrawable.getIntrinsicHeight();
        } else {
            padding.setEmpty();
            trackHeight = 0;
        }
        int paddingLeft = padding.left;
        int paddingRight = padding.right;
        if (this.mThumbDrawable != null) {
            Insets inset = this.mThumbDrawable.getOpticalInsets();
            paddingLeft = Math.max(paddingLeft, inset.left);
            paddingRight = Math.max(paddingRight, inset.right);
        }
        int switchWidth = Math.max(this.mSwitchMinWidth, 2 * this.mThumbWidth + paddingLeft + paddingRight);
        int switchHeight = Math.max(trackHeight, thumbHeight);
        this.mSwitchWidth = switchWidth;
        this.mSwitchHeight = switchHeight;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int measuredHeight = this.getMeasuredHeight();
        if (measuredHeight < switchHeight) {
            this.setMeasuredDimension(this.getMeasuredWidthAndState(), switchHeight);
        }
    }

    private final void $$robo$$android_widget_Switch$onPopulateAccessibilityEventInternal(AccessibilityEvent event) {
        CharSequence text;
        super.onPopulateAccessibilityEventInternal(event);
        CharSequence charSequence = text = this.isChecked() ? this.mTextOn : this.mTextOff;
        if (text != null) {
            event.getText().add(text);
        }
    }

    private final Layout $$robo$$android_widget_Switch$makeLayout(CharSequence text) {
        CharSequence transformed = this.mSwitchTransformationMethod != null ? this.mSwitchTransformationMethod.getTransformation(text, this) : text;
        int width = (int)Math.ceil(Layout.getDesiredWidth(transformed, 0, transformed.length(), this.mTextPaint, this.getTextDirectionHeuristic()));
        return StaticLayout.Builder.obtain(transformed, 0, transformed.length(), this.mTextPaint, width).setUseLineSpacingFromFallbacks(this.mUseFallbackLineSpacing).build();
    }

    private final boolean $$robo$$android_widget_Switch$hitThumb(float x, float y) {
        if (this.mThumbDrawable == null) {
            return false;
        }
        int thumbOffset = this.getThumbOffset();
        this.mThumbDrawable.getPadding(this.mTempRect);
        int thumbTop = this.mSwitchTop - this.mTouchSlop;
        int thumbLeft = this.mSwitchLeft + thumbOffset - this.mTouchSlop;
        int thumbRight = thumbLeft + this.mThumbWidth + this.mTempRect.left + this.mTempRect.right + this.mTouchSlop;
        int thumbBottom = this.mSwitchBottom + this.mTouchSlop;
        return x > (float)thumbLeft && x < (float)thumbRight && y > (float)thumbTop && y < (float)thumbBottom;
    }

    private final boolean $$robo$$android_widget_Switch$onTouchEvent(MotionEvent ev) {
        this.mVelocityTracker.addMovement(ev);
        int action = ev.getActionMasked();
        switch (action) {
            case 0: {
                float x = ev.getX();
                float y = ev.getY();
                if (!this.isEnabled() || !this.hitThumb(x, y)) break;
                this.mTouchMode = 1;
                this.mTouchX = x;
                this.mTouchY = y;
                break;
            }
            case 2: {
                switch (this.mTouchMode) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        float x = ev.getX();
                        float y = ev.getY();
                        if (!(Math.abs(x - this.mTouchX) > (float)this.mTouchSlop) && !(Math.abs(y - this.mTouchY) > (float)this.mTouchSlop)) break;
                        this.mTouchMode = 2;
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                        this.mTouchX = x;
                        this.mTouchY = y;
                        return true;
                    }
                    case 2: {
                        float newPos;
                        float dPos;
                        float x = ev.getX();
                        int thumbScrollRange = this.getThumbScrollRange();
                        float thumbScrollOffset = x - this.mTouchX;
                        if (thumbScrollRange != 0) {
                            dPos = thumbScrollOffset / (float)thumbScrollRange;
                        } else {
                            float f = dPos = thumbScrollOffset > 0.0f ? 1.0f : -1.0f;
                        }
                        if (this.isLayoutRtl()) {
                            dPos = -dPos;
                        }
                        if ((newPos = MathUtils.constrain(this.mThumbPosition + dPos, 0.0f, 1.0f)) != this.mThumbPosition) {
                            this.mTouchX = x;
                            this.setThumbPosition(newPos);
                        }
                        return true;
                    }
                }
                break;
            }
            case 1: 
            case 3: {
                if (this.mTouchMode == 2) {
                    this.stopDrag(ev);
                    super.onTouchEvent(ev);
                    return true;
                }
                this.mTouchMode = 0;
                this.mVelocityTracker.clear();
            }
        }
        return super.onTouchEvent(ev);
    }

    private final void $$robo$$android_widget_Switch$cancelSuperTouch(MotionEvent ev) {
        MotionEvent cancel = MotionEvent.obtain(ev);
        cancel.setAction(3);
        super.onTouchEvent(cancel);
        cancel.recycle();
    }

    private final void $$robo$$android_widget_Switch$stopDrag(MotionEvent ev) {
        boolean newState;
        this.mTouchMode = 0;
        boolean commitChange = ev.getAction() == 1 && this.isEnabled();
        boolean oldState = this.isChecked();
        if (commitChange) {
            this.mVelocityTracker.computeCurrentVelocity(1000);
            float xvel = this.mVelocityTracker.getXVelocity();
            newState = Math.abs(xvel) > (float)this.mMinFlingVelocity ? (this.isLayoutRtl() ? xvel < 0.0f : xvel > 0.0f) : this.getTargetCheckedState();
        } else {
            newState = oldState;
        }
        if (newState != oldState) {
            this.playSoundEffect(0);
        }
        this.setChecked(newState);
        this.cancelSuperTouch(ev);
    }

    private final void $$robo$$android_widget_Switch$animateThumbToCheckedState(boolean newCheckedState) {
        float targetPosition = newCheckedState ? 1.0f : 0.0f;
        this.mPositionAnimator = ObjectAnimator.ofFloat(this, THUMB_POS, targetPosition);
        this.mPositionAnimator.setDuration(250L);
        this.mPositionAnimator.setAutoCancel(true);
        this.mPositionAnimator.start();
    }

    private final void $$robo$$android_widget_Switch$cancelPositionAnimator() {
        if (this.mPositionAnimator != null) {
            this.mPositionAnimator.cancel();
        }
    }

    private final boolean $$robo$$android_widget_Switch$getTargetCheckedState() {
        return this.mThumbPosition > 0.5f;
    }

    private final void $$robo$$android_widget_Switch$setThumbPosition(float position) {
        this.mThumbPosition = position;
        this.invalidate();
    }

    private final void $$robo$$android_widget_Switch$toggle() {
        this.setChecked(!this.isChecked());
    }

    private final void $$robo$$android_widget_Switch$setChecked(boolean checked) {
        super.setChecked(checked);
        checked = this.isChecked();
        if (this.isAttachedToWindow() && this.isLaidOut()) {
            this.animateThumbToCheckedState(checked);
        } else {
            this.cancelPositionAnimator();
            this.setThumbPosition(checked ? 1.0f : 0.0f);
        }
    }

    private final void $$robo$$android_widget_Switch$onLayout(boolean changed, int left, int top, int right, int bottom) {
        int switchBottom;
        int switchTop;
        int switchRight;
        int switchLeft;
        super.onLayout(changed, left, top, right, bottom);
        int opticalInsetLeft = 0;
        int opticalInsetRight = 0;
        if (this.mThumbDrawable != null) {
            Rect trackPadding = this.mTempRect;
            if (this.mTrackDrawable != null) {
                this.mTrackDrawable.getPadding(trackPadding);
            } else {
                trackPadding.setEmpty();
            }
            Insets insets = this.mThumbDrawable.getOpticalInsets();
            opticalInsetLeft = Math.max(0, insets.left - trackPadding.left);
            opticalInsetRight = Math.max(0, insets.right - trackPadding.right);
        }
        if (this.isLayoutRtl()) {
            switchLeft = this.getPaddingLeft() + opticalInsetLeft;
            switchRight = switchLeft + this.mSwitchWidth - opticalInsetLeft - opticalInsetRight;
        } else {
            switchRight = this.getWidth() - this.getPaddingRight() - opticalInsetRight;
            switchLeft = switchRight - this.mSwitchWidth + opticalInsetLeft + opticalInsetRight;
        }
        switch (this.getGravity() & 0x70) {
            default: {
                switchTop = this.getPaddingTop();
                switchBottom = switchTop + this.mSwitchHeight;
                break;
            }
            case 16: {
                switchTop = (this.getPaddingTop() + this.getHeight() - this.getPaddingBottom()) / 2 - this.mSwitchHeight / 2;
                switchBottom = switchTop + this.mSwitchHeight;
                break;
            }
            case 80: {
                switchBottom = this.getHeight() - this.getPaddingBottom();
                switchTop = switchBottom - this.mSwitchHeight;
            }
        }
        this.mSwitchLeft = switchLeft;
        this.mSwitchTop = switchTop;
        this.mSwitchBottom = switchBottom;
        this.mSwitchRight = switchRight;
    }

    private final void $$robo$$android_widget_Switch$draw(Canvas c) {
        Rect padding = this.mTempRect;
        int switchLeft = this.mSwitchLeft;
        int switchTop = this.mSwitchTop;
        int switchRight = this.mSwitchRight;
        int switchBottom = this.mSwitchBottom;
        int thumbInitialLeft = switchLeft + this.getThumbOffset();
        Insets thumbInsets = this.mThumbDrawable != null ? this.mThumbDrawable.getOpticalInsets() : Insets.NONE;
        if (this.mTrackDrawable != null) {
            this.mTrackDrawable.getPadding(padding);
            thumbInitialLeft += padding.left;
            int trackLeft = switchLeft;
            int trackTop = switchTop;
            int trackRight = switchRight;
            int trackBottom = switchBottom;
            if (thumbInsets != Insets.NONE) {
                if (thumbInsets.left > padding.left) {
                    trackLeft += thumbInsets.left - padding.left;
                }
                if (thumbInsets.top > padding.top) {
                    trackTop += thumbInsets.top - padding.top;
                }
                if (thumbInsets.right > padding.right) {
                    trackRight -= thumbInsets.right - padding.right;
                }
                if (thumbInsets.bottom > padding.bottom) {
                    trackBottom -= thumbInsets.bottom - padding.bottom;
                }
            }
            this.mTrackDrawable.setBounds(trackLeft, trackTop, trackRight, trackBottom);
        }
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.getPadding(padding);
            int thumbLeft = thumbInitialLeft - padding.left;
            int thumbRight = thumbInitialLeft + this.mThumbWidth + padding.right;
            this.mThumbDrawable.setBounds(thumbLeft, switchTop, thumbRight, switchBottom);
            Drawable background = this.getBackground();
            if (background != null) {
                background.setHotspotBounds(thumbLeft, switchTop, thumbRight, switchBottom);
            }
        }
        super.draw(c);
    }

    private final void $$robo$$android_widget_Switch$onDraw(Canvas canvas) {
        Layout switchText;
        super.onDraw(canvas);
        Rect padding = this.mTempRect;
        Drawable trackDrawable = this.mTrackDrawable;
        if (trackDrawable != null) {
            trackDrawable.getPadding(padding);
        } else {
            padding.setEmpty();
        }
        int switchTop = this.mSwitchTop;
        int switchBottom = this.mSwitchBottom;
        int switchInnerTop = switchTop + padding.top;
        int switchInnerBottom = switchBottom - padding.bottom;
        Drawable thumbDrawable = this.mThumbDrawable;
        if (trackDrawable != null) {
            if (this.mSplitTrack && thumbDrawable != null) {
                Insets insets = thumbDrawable.getOpticalInsets();
                thumbDrawable.copyBounds(padding);
                padding.left += insets.left;
                padding.right -= insets.right;
                int saveCount = canvas.save();
                canvas.clipRect(padding, Region.Op.DIFFERENCE);
                trackDrawable.draw(canvas);
                canvas.restoreToCount(saveCount);
            } else {
                trackDrawable.draw(canvas);
            }
        }
        int saveCount = canvas.save();
        if (thumbDrawable != null) {
            thumbDrawable.draw(canvas);
        }
        Layout layout2 = switchText = this.getTargetCheckedState() ? this.mOnLayout : this.mOffLayout;
        if (switchText != null) {
            int cX;
            int[] drawableState = this.getDrawableState();
            if (this.mTextColors != null) {
                this.mTextPaint.setColor(this.mTextColors.getColorForState(drawableState, 0));
            }
            this.mTextPaint.drawableState = drawableState;
            if (thumbDrawable != null) {
                Rect bounds = thumbDrawable.getBounds();
                cX = bounds.left + bounds.right;
            } else {
                cX = this.getWidth();
            }
            int left = cX / 2 - switchText.getWidth() / 2;
            int top = (switchInnerTop + switchInnerBottom) / 2 - switchText.getHeight() / 2;
            canvas.translate(left, top);
            switchText.draw(canvas);
        }
        canvas.restoreToCount(saveCount);
    }

    private final int $$robo$$android_widget_Switch$getCompoundPaddingLeft() {
        if (!this.isLayoutRtl()) {
            return super.getCompoundPaddingLeft();
        }
        int padding = super.getCompoundPaddingLeft() + this.mSwitchWidth;
        if (!TextUtils.isEmpty(this.getText())) {
            padding += this.mSwitchPadding;
        }
        return padding;
    }

    private final int $$robo$$android_widget_Switch$getCompoundPaddingRight() {
        if (this.isLayoutRtl()) {
            return super.getCompoundPaddingRight();
        }
        int padding = super.getCompoundPaddingRight() + this.mSwitchWidth;
        if (!TextUtils.isEmpty(this.getText())) {
            padding += this.mSwitchPadding;
        }
        return padding;
    }

    private final int $$robo$$android_widget_Switch$getThumbOffset() {
        float thumbPosition = this.isLayoutRtl() ? 1.0f - this.mThumbPosition : this.mThumbPosition;
        return (int)(thumbPosition * (float)this.getThumbScrollRange() + 0.5f);
    }

    private final int $$robo$$android_widget_Switch$getThumbScrollRange() {
        if (this.mTrackDrawable != null) {
            Rect padding = this.mTempRect;
            this.mTrackDrawable.getPadding(padding);
            Insets insets = this.mThumbDrawable != null ? this.mThumbDrawable.getOpticalInsets() : Insets.NONE;
            return this.mSwitchWidth - this.mThumbWidth - padding.left - padding.right - insets.left - insets.right;
        }
        return 0;
    }

    private final int[] $$robo$$android_widget_Switch$onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.isChecked()) {
            Switch.mergeDrawableStates(drawableState, CHECKED_STATE_SET);
        }
        return drawableState;
    }

    private final void $$robo$$android_widget_Switch$drawableStateChanged() {
        Drawable trackDrawable;
        super.drawableStateChanged();
        int[] state = this.getDrawableState();
        boolean changed = false;
        Drawable thumbDrawable = this.mThumbDrawable;
        if (thumbDrawable != null && thumbDrawable.isStateful()) {
            changed |= thumbDrawable.setState(state);
        }
        if ((trackDrawable = this.mTrackDrawable) != null && trackDrawable.isStateful()) {
            changed |= trackDrawable.setState(state);
        }
        if (changed) {
            this.invalidate();
        }
    }

    private final void $$robo$$android_widget_Switch$drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.setHotspot(x, y);
        }
        if (this.mTrackDrawable != null) {
            this.mTrackDrawable.setHotspot(x, y);
        }
    }

    private final boolean $$robo$$android_widget_Switch$verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.mThumbDrawable || who == this.mTrackDrawable;
    }

    private final void $$robo$$android_widget_Switch$jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.jumpToCurrentState();
        }
        if (this.mTrackDrawable != null) {
            this.mTrackDrawable.jumpToCurrentState();
        }
        if (this.mPositionAnimator != null && this.mPositionAnimator.isStarted()) {
            this.mPositionAnimator.end();
            this.mPositionAnimator = null;
        }
    }

    private final CharSequence $$robo$$android_widget_Switch$getAccessibilityClassName() {
        return Switch.class.getName();
    }

    private final void $$robo$$android_widget_Switch$onProvideStructure(ViewStructure structure) {
        super.onProvideStructure(structure);
        this.onProvideAutoFillStructureForAssistOrAutofill(structure);
    }

    private final void $$robo$$android_widget_Switch$onProvideAutofillStructure(ViewStructure structure, int flags) {
        super.onProvideAutofillStructure(structure, flags);
        this.onProvideAutoFillStructureForAssistOrAutofill(structure);
    }

    private final void $$robo$$android_widget_Switch$onProvideAutoFillStructureForAssistOrAutofill(ViewStructure structure) {
        CharSequence switchText;
        CharSequence charSequence = switchText = this.isChecked() ? this.mTextOn : this.mTextOff;
        if (!TextUtils.isEmpty(switchText)) {
            CharSequence oldText = structure.getText();
            if (TextUtils.isEmpty(oldText)) {
                structure.setText(switchText);
            } else {
                StringBuilder newText = new StringBuilder();
                newText.append(oldText).append(' ').append(switchText);
                structure.setText(newText);
            }
        }
    }

    private final void $$robo$$android_widget_Switch$onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        CharSequence switchText;
        super.onInitializeAccessibilityNodeInfoInternal(info);
        CharSequence charSequence = switchText = this.isChecked() ? this.mTextOn : this.mTextOff;
        if (!TextUtils.isEmpty(switchText)) {
            CharSequence oldText = info.getText();
            if (TextUtils.isEmpty(oldText)) {
                info.setText(switchText);
            } else {
                StringBuilder newText = new StringBuilder();
                newText.append(oldText).append(' ').append(switchText);
                info.setText(newText);
            }
        }
    }

    static void __staticInitializer__() {
        CHECKED_STATE_SET = new int[]{0x10100A0};
        THUMB_POS = new FloatProperty<Switch>("thumbPos"){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_widget_Switch_1$__constructor__(String x0) {
            }

            private final Float $$robo$$android_widget_Switch_1$get(Switch object) {
                return Float.valueOf(object.mThumbPosition);
            }

            private final void $$robo$$android_widget_Switch_1$setValue(Switch object, float value) {
                object.setThumbPosition(value);
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_widget_Switch_1$__constructor__(string2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Switch_1$__constructor__(java.lang.String ), 0, this, string2);
            }

            @Override
            public Float get(Switch switch_) {
                return InvokeDynamicSupport.bootstrap("get", $$robo$$android_widget_Switch_1$get(android.widget.Switch ), 0, this, switch_);
            }

            @Override
            public void setValue(Switch switch_, float f) {
                InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_widget_Switch_1$setValue(android.widget.Switch float ), 0, this, switch_, f);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_Switch$__constructor__(context);
    }

    public Switch(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Switch$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_Switch$__constructor__(context, attributeSet);
    }

    public Switch(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843839);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Switch$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_Switch$__constructor__(context, attributeSet, n);
    }

    public Switch(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Switch$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_Switch$__constructor__(context, attributeSet, n, n2);
    }

    public Switch(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Switch$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    public void setSwitchTextAppearance(Context context, int n) {
        InvokeDynamicSupport.bootstrap("setSwitchTextAppearance", $$robo$$android_widget_Switch$setSwitchTextAppearance(android.content.Context int ), 0, this, context, n);
    }

    private void setSwitchTypefaceByIndex(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setSwitchTypefaceByIndex", $$robo$$android_widget_Switch$setSwitchTypefaceByIndex(int int ), 0, this, n, n2);
    }

    public void setSwitchTypeface(Typeface typeface, int n) {
        InvokeDynamicSupport.bootstrap("setSwitchTypeface", $$robo$$android_widget_Switch$setSwitchTypeface(android.graphics.Typeface int ), 0, this, typeface, n);
    }

    public void setSwitchTypeface(Typeface typeface) {
        InvokeDynamicSupport.bootstrap("setSwitchTypeface", $$robo$$android_widget_Switch$setSwitchTypeface(android.graphics.Typeface ), 0, this, typeface);
    }

    public void setSwitchPadding(int n) {
        InvokeDynamicSupport.bootstrap("setSwitchPadding", $$robo$$android_widget_Switch$setSwitchPadding(int ), 0, this, n);
    }

    public int getSwitchPadding() {
        return (int)InvokeDynamicSupport.bootstrap("getSwitchPadding", $$robo$$android_widget_Switch$getSwitchPadding(), 0, this);
    }

    public void setSwitchMinWidth(int n) {
        InvokeDynamicSupport.bootstrap("setSwitchMinWidth", $$robo$$android_widget_Switch$setSwitchMinWidth(int ), 0, this, n);
    }

    public int getSwitchMinWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getSwitchMinWidth", $$robo$$android_widget_Switch$getSwitchMinWidth(), 0, this);
    }

    public void setThumbTextPadding(int n) {
        InvokeDynamicSupport.bootstrap("setThumbTextPadding", $$robo$$android_widget_Switch$setThumbTextPadding(int ), 0, this, n);
    }

    public int getThumbTextPadding() {
        return (int)InvokeDynamicSupport.bootstrap("getThumbTextPadding", $$robo$$android_widget_Switch$getThumbTextPadding(), 0, this);
    }

    public void setTrackDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setTrackDrawable", $$robo$$android_widget_Switch$setTrackDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public void setTrackResource(int n) {
        InvokeDynamicSupport.bootstrap("setTrackResource", $$robo$$android_widget_Switch$setTrackResource(int ), 0, this, n);
    }

    public Drawable getTrackDrawable() {
        return InvokeDynamicSupport.bootstrap("getTrackDrawable", $$robo$$android_widget_Switch$getTrackDrawable(), 0, this);
    }

    public void setTrackTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTrackTintList", $$robo$$android_widget_Switch$setTrackTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    public ColorStateList getTrackTintList() {
        return InvokeDynamicSupport.bootstrap("getTrackTintList", $$robo$$android_widget_Switch$getTrackTintList(), 0, this);
    }

    public void setTrackTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setTrackTintMode", $$robo$$android_widget_Switch$setTrackTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    public PorterDuff.Mode getTrackTintMode() {
        return InvokeDynamicSupport.bootstrap("getTrackTintMode", $$robo$$android_widget_Switch$getTrackTintMode(), 0, this);
    }

    private void applyTrackTint() {
        InvokeDynamicSupport.bootstrap("applyTrackTint", $$robo$$android_widget_Switch$applyTrackTint(), 0, this);
    }

    public void setThumbDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setThumbDrawable", $$robo$$android_widget_Switch$setThumbDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public void setThumbResource(int n) {
        InvokeDynamicSupport.bootstrap("setThumbResource", $$robo$$android_widget_Switch$setThumbResource(int ), 0, this, n);
    }

    public Drawable getThumbDrawable() {
        return InvokeDynamicSupport.bootstrap("getThumbDrawable", $$robo$$android_widget_Switch$getThumbDrawable(), 0, this);
    }

    public void setThumbTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setThumbTintList", $$robo$$android_widget_Switch$setThumbTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    public ColorStateList getThumbTintList() {
        return InvokeDynamicSupport.bootstrap("getThumbTintList", $$robo$$android_widget_Switch$getThumbTintList(), 0, this);
    }

    public void setThumbTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setThumbTintMode", $$robo$$android_widget_Switch$setThumbTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    public PorterDuff.Mode getThumbTintMode() {
        return InvokeDynamicSupport.bootstrap("getThumbTintMode", $$robo$$android_widget_Switch$getThumbTintMode(), 0, this);
    }

    private void applyThumbTint() {
        InvokeDynamicSupport.bootstrap("applyThumbTint", $$robo$$android_widget_Switch$applyThumbTint(), 0, this);
    }

    public void setSplitTrack(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSplitTrack", $$robo$$android_widget_Switch$setSplitTrack(boolean ), 0, this, bl);
    }

    public boolean getSplitTrack() {
        return (boolean)InvokeDynamicSupport.bootstrap("getSplitTrack", $$robo$$android_widget_Switch$getSplitTrack(), 0, this);
    }

    public CharSequence getTextOn() {
        return InvokeDynamicSupport.bootstrap("getTextOn", $$robo$$android_widget_Switch$getTextOn(), 0, this);
    }

    public void setTextOn(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setTextOn", $$robo$$android_widget_Switch$setTextOn(java.lang.CharSequence ), 0, this, charSequence);
    }

    public CharSequence getTextOff() {
        return InvokeDynamicSupport.bootstrap("getTextOff", $$robo$$android_widget_Switch$getTextOff(), 0, this);
    }

    public void setTextOff(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setTextOff", $$robo$$android_widget_Switch$setTextOff(java.lang.CharSequence ), 0, this, charSequence);
    }

    public void setShowText(boolean bl) {
        InvokeDynamicSupport.bootstrap("setShowText", $$robo$$android_widget_Switch$setShowText(boolean ), 0, this, bl);
    }

    public boolean getShowText() {
        return (boolean)InvokeDynamicSupport.bootstrap("getShowText", $$robo$$android_widget_Switch$getShowText(), 0, this);
    }

    @Override
    public void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_Switch$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    public void onPopulateAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onPopulateAccessibilityEventInternal", $$robo$$android_widget_Switch$onPopulateAccessibilityEventInternal(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    private Layout makeLayout(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("makeLayout", $$robo$$android_widget_Switch$makeLayout(java.lang.CharSequence ), 0, this, charSequence);
    }

    private boolean hitThumb(float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hitThumb", $$robo$$android_widget_Switch$hitThumb(float float ), 0, this, f, f2);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_Switch$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void cancelSuperTouch(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("cancelSuperTouch", $$robo$$android_widget_Switch$cancelSuperTouch(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void stopDrag(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("stopDrag", $$robo$$android_widget_Switch$stopDrag(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void animateThumbToCheckedState(boolean bl) {
        InvokeDynamicSupport.bootstrap("animateThumbToCheckedState", $$robo$$android_widget_Switch$animateThumbToCheckedState(boolean ), 0, this, bl);
    }

    private void cancelPositionAnimator() {
        InvokeDynamicSupport.bootstrap("cancelPositionAnimator", $$robo$$android_widget_Switch$cancelPositionAnimator(), 0, this);
    }

    private boolean getTargetCheckedState() {
        return (boolean)InvokeDynamicSupport.bootstrap("getTargetCheckedState", $$robo$$android_widget_Switch$getTargetCheckedState(), 0, this);
    }

    private void setThumbPosition(float f) {
        InvokeDynamicSupport.bootstrap("setThumbPosition", $$robo$$android_widget_Switch$setThumbPosition(float ), 0, this, f);
    }

    @Override
    public void toggle() {
        InvokeDynamicSupport.bootstrap("toggle", $$robo$$android_widget_Switch$toggle(), 0, this);
    }

    @Override
    public void setChecked(boolean bl) {
        InvokeDynamicSupport.bootstrap("setChecked", $$robo$$android_widget_Switch$setChecked(boolean ), 0, this, bl);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_Switch$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_widget_Switch$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_widget_Switch$onDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    public int getCompoundPaddingLeft() {
        return (int)InvokeDynamicSupport.bootstrap("getCompoundPaddingLeft", $$robo$$android_widget_Switch$getCompoundPaddingLeft(), 0, this);
    }

    @Override
    public int getCompoundPaddingRight() {
        return (int)InvokeDynamicSupport.bootstrap("getCompoundPaddingRight", $$robo$$android_widget_Switch$getCompoundPaddingRight(), 0, this);
    }

    private int getThumbOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getThumbOffset", $$robo$$android_widget_Switch$getThumbOffset(), 0, this);
    }

    private int getThumbScrollRange() {
        return (int)InvokeDynamicSupport.bootstrap("getThumbScrollRange", $$robo$$android_widget_Switch$getThumbScrollRange(), 0, this);
    }

    @Override
    protected int[] onCreateDrawableState(int n) {
        return InvokeDynamicSupport.bootstrap("onCreateDrawableState", $$robo$$android_widget_Switch$onCreateDrawableState(int ), 0, this, n);
    }

    @Override
    protected void drawableStateChanged() {
        InvokeDynamicSupport.bootstrap("drawableStateChanged", $$robo$$android_widget_Switch$drawableStateChanged(), 0, this);
    }

    @Override
    public void drawableHotspotChanged(float f, float f2) {
        InvokeDynamicSupport.bootstrap("drawableHotspotChanged", $$robo$$android_widget_Switch$drawableHotspotChanged(float float ), 0, this, f, f2);
    }

    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        return (boolean)InvokeDynamicSupport.bootstrap("verifyDrawable", $$robo$$android_widget_Switch$verifyDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpDrawablesToCurrentState", $$robo$$android_widget_Switch$jumpDrawablesToCurrentState(), 0, this);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_Switch$getAccessibilityClassName(), 0, this);
    }

    @Override
    public void onProvideStructure(ViewStructure viewStructure) {
        InvokeDynamicSupport.bootstrap("onProvideStructure", $$robo$$android_widget_Switch$onProvideStructure(android.view.ViewStructure ), 0, this, viewStructure);
    }

    @Override
    public void onProvideAutofillStructure(ViewStructure viewStructure, int n) {
        InvokeDynamicSupport.bootstrap("onProvideAutofillStructure", $$robo$$android_widget_Switch$onProvideAutofillStructure(android.view.ViewStructure int ), 0, this, viewStructure, n);
    }

    private void onProvideAutoFillStructureForAssistOrAutofill(ViewStructure viewStructure) {
        InvokeDynamicSupport.bootstrap("onProvideAutoFillStructureForAssistOrAutofill", $$robo$$android_widget_Switch$onProvideAutoFillStructureForAssistOrAutofill(android.view.ViewStructure ), 0, this, viewStructure);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoInternal", $$robo$$android_widget_Switch$onInitializeAccessibilityNodeInfoInternal(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    static {
        RobolectricInternals.classInitializing(Switch.class);
    }

    public /* synthetic */ Switch() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Switch)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

