/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.TypedArray;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.Process;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.ViewDebug;
import android.view.ViewHierarchyEncoder;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.R;
import java.util.Calendar;
import java.util.TimeZone;
import libcore.icu.LocaleData;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@RemoteViews.RemoteView
public class TextClock
extends TextView
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    @Deprecated
    public static CharSequence DEFAULT_FORMAT_12_HOUR;
    @Deprecated
    public static CharSequence DEFAULT_FORMAT_24_HOUR;
    private CharSequence mFormat12;
    private CharSequence mFormat24;
    private CharSequence mDescFormat12;
    private CharSequence mDescFormat24;
    @ViewDebug.ExportedProperty
    private CharSequence mFormat;
    @ViewDebug.ExportedProperty
    private boolean mHasSeconds;
    private CharSequence mDescFormat;
    private boolean mRegistered;
    private boolean mShouldRunTicker;
    private Calendar mTime;
    private String mTimeZone;
    private boolean mShowCurrentUserTime;
    private ContentObserver mFormatChangeObserver;
    private boolean mStopTicking;
    private BroadcastReceiver mIntentReceiver;
    private Runnable mTicker;

    private void $$robo$$android_widget_TextClock$__constructor__(Context context) {
        this.mIntentReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TextClock this$0;

            private void $$robo$$android_widget_TextClock_1$__constructor__(TextClock this$0) {
            }

            private final void $$robo$$android_widget_TextClock_1$onReceive(Context context, Intent intent) {
                if (this.this$0.mStopTicking) {
                    return;
                }
                if (this.this$0.mTimeZone == null && "android.intent.action.TIMEZONE_CHANGED".equals(intent.getAction())) {
                    String timeZone = intent.getStringExtra("time-zone");
                    this.this$0.createTime(timeZone);
                }
                this.this$0.onTimeChanged();
            }

            private void __constructor__(TextClock textClock) {
                this.$$robo$$android_widget_TextClock_1$__constructor__(textClock);
            }
            {
                this.this$0 = textClock;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextClock_1$__constructor__(android.widget.TextClock ), 0, this, textClock);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_widget_TextClock_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mTicker = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TextClock this$0;

            private void $$robo$$android_widget_TextClock_2$__constructor__(TextClock this$0) {
            }

            private final void $$robo$$android_widget_TextClock_2$run() {
                if (this.this$0.mStopTicking) {
                    return;
                }
                this.this$0.onTimeChanged();
                long now = SystemClock.uptimeMillis();
                long next = now + (1000L - now % 1000L);
                this.this$0.getHandler().postAtTime(this.this$0.mTicker, next);
            }

            private void __constructor__(TextClock textClock) {
                this.$$robo$$android_widget_TextClock_2$__constructor__(textClock);
            }
            {
                this.this$0 = textClock;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextClock_2$__constructor__(android.widget.TextClock ), 0, this, textClock);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_TextClock_2$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.init();
    }

    private void $$robo$$android_widget_TextClock$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_TextClock$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_widget_TextClock$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mIntentReceiver = new /* invalid duplicate definition of identical inner class */;
        this.mTicker = new /* invalid duplicate definition of identical inner class */;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TextClock, defStyleAttr, defStyleRes);
        try {
            this.mFormat12 = a.getText(0);
            this.mFormat24 = a.getText(1);
            this.mTimeZone = a.getString(2);
        }
        finally {
            a.recycle();
        }
        this.init();
    }

    private final void $$robo$$android_widget_TextClock$init() {
        if (this.mFormat12 == null || this.mFormat24 == null) {
            LocaleData ld = LocaleData.get(this.getContext().getResources().getConfiguration().locale);
            if (this.mFormat12 == null) {
                this.mFormat12 = ld.timeFormat_hm;
            }
            if (this.mFormat24 == null) {
                this.mFormat24 = ld.timeFormat_Hm;
            }
        }
        this.createTime(this.mTimeZone);
        this.chooseFormat();
    }

    private final void $$robo$$android_widget_TextClock$createTime(String timeZone) {
        this.mTime = timeZone != null ? Calendar.getInstance(TimeZone.getTimeZone(timeZone)) : Calendar.getInstance();
    }

    @ViewDebug.ExportedProperty
    private final CharSequence $$robo$$android_widget_TextClock$getFormat12Hour() {
        return this.mFormat12;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextClock$setFormat12Hour(CharSequence format) {
        this.mFormat12 = format;
        this.chooseFormat();
        this.onTimeChanged();
    }

    private final void $$robo$$android_widget_TextClock$setContentDescriptionFormat12Hour(CharSequence format) {
        this.mDescFormat12 = format;
        this.chooseFormat();
        this.onTimeChanged();
    }

    @ViewDebug.ExportedProperty
    private final CharSequence $$robo$$android_widget_TextClock$getFormat24Hour() {
        return this.mFormat24;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextClock$setFormat24Hour(CharSequence format) {
        this.mFormat24 = format;
        this.chooseFormat();
        this.onTimeChanged();
    }

    private final void $$robo$$android_widget_TextClock$setContentDescriptionFormat24Hour(CharSequence format) {
        this.mDescFormat24 = format;
        this.chooseFormat();
        this.onTimeChanged();
    }

    private final void $$robo$$android_widget_TextClock$setShowCurrentUserTime(boolean showCurrentUserTime) {
        this.mShowCurrentUserTime = showCurrentUserTime;
        this.chooseFormat();
        this.onTimeChanged();
        this.unregisterObserver();
        this.registerObserver();
    }

    private final void $$robo$$android_widget_TextClock$refresh() {
        this.onTimeChanged();
        this.invalidate();
    }

    private final boolean $$robo$$android_widget_TextClock$is24HourModeEnabled() {
        if (this.mShowCurrentUserTime) {
            return DateFormat.is24HourFormat(this.getContext(), ActivityManager.getCurrentUser());
        }
        return DateFormat.is24HourFormat(this.getContext());
    }

    private final String $$robo$$android_widget_TextClock$getTimeZone() {
        return this.mTimeZone;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextClock$setTimeZone(String timeZone) {
        this.mTimeZone = timeZone;
        this.createTime(timeZone);
        this.onTimeChanged();
    }

    private final CharSequence $$robo$$android_widget_TextClock$getFormat() {
        return this.mFormat;
    }

    private final void $$robo$$android_widget_TextClock$chooseFormat() {
        boolean format24Requested = this.is24HourModeEnabled();
        LocaleData ld = LocaleData.get(this.getContext().getResources().getConfiguration().locale);
        if (format24Requested) {
            this.mFormat = TextClock.abc(this.mFormat24, this.mFormat12, ld.timeFormat_Hm);
            this.mDescFormat = TextClock.abc(this.mDescFormat24, this.mDescFormat12, this.mFormat);
        } else {
            this.mFormat = TextClock.abc(this.mFormat12, this.mFormat24, ld.timeFormat_hm);
            this.mDescFormat = TextClock.abc(this.mDescFormat12, this.mDescFormat24, this.mFormat);
        }
        boolean hadSeconds = this.mHasSeconds;
        this.mHasSeconds = DateFormat.hasSeconds(this.mFormat);
        if (this.mShouldRunTicker && hadSeconds != this.mHasSeconds) {
            if (hadSeconds) {
                this.getHandler().removeCallbacks(this.mTicker);
            } else {
                this.mTicker.run();
            }
        }
    }

    private static final CharSequence $$robo$$android_widget_TextClock$abc(CharSequence a, CharSequence b, CharSequence c) {
        return a == null ? (b == null ? c : b) : a;
    }

    private final void $$robo$$android_widget_TextClock$onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.mRegistered) {
            this.mRegistered = true;
            this.registerReceiver();
            this.registerObserver();
            this.createTime(this.mTimeZone);
        }
    }

    private final void $$robo$$android_widget_TextClock$onVisibilityAggregated(boolean isVisible) {
        super.onVisibilityAggregated(isVisible);
        if (!this.mShouldRunTicker && isVisible) {
            this.mShouldRunTicker = true;
            if (this.mHasSeconds) {
                this.mTicker.run();
            } else {
                this.onTimeChanged();
            }
        } else if (this.mShouldRunTicker && !isVisible) {
            this.mShouldRunTicker = false;
            this.getHandler().removeCallbacks(this.mTicker);
        }
    }

    private final void $$robo$$android_widget_TextClock$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mRegistered) {
            this.unregisterReceiver();
            this.unregisterObserver();
            this.mRegistered = false;
        }
    }

    private final void $$robo$$android_widget_TextClock$disableClockTick() {
        this.mStopTicking = true;
    }

    private final void $$robo$$android_widget_TextClock$registerReceiver() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.TIME_TICK");
        filter.addAction("android.intent.action.TIME_SET");
        filter.addAction("android.intent.action.TIMEZONE_CHANGED");
        this.getContext().registerReceiverAsUser(this.mIntentReceiver, Process.myUserHandle(), filter, null, this.getHandler());
    }

    private final void $$robo$$android_widget_TextClock$registerObserver() {
        if (this.mRegistered) {
            if (this.mFormatChangeObserver == null) {
                this.mFormatChangeObserver = new FormatChangeObserver(this, this.getHandler());
            }
            ContentResolver resolver = this.getContext().getContentResolver();
            Uri uri = Settings.System.getUriFor("time_12_24");
            if (this.mShowCurrentUserTime) {
                resolver.registerContentObserver(uri, true, this.mFormatChangeObserver, -1);
            } else {
                resolver.registerContentObserver(uri, true, this.mFormatChangeObserver);
            }
        }
    }

    private final void $$robo$$android_widget_TextClock$unregisterReceiver() {
        this.getContext().unregisterReceiver(this.mIntentReceiver);
    }

    private final void $$robo$$android_widget_TextClock$unregisterObserver() {
        if (this.mFormatChangeObserver != null) {
            ContentResolver resolver = this.getContext().getContentResolver();
            resolver.unregisterContentObserver(this.mFormatChangeObserver);
        }
    }

    private final void $$robo$$android_widget_TextClock$onTimeChanged() {
        if (this.mShouldRunTicker) {
            this.mTime.setTimeInMillis((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
            this.setText(DateFormat.format(this.mFormat, this.mTime));
            this.setContentDescription(DateFormat.format(this.mDescFormat, this.mTime));
        }
    }

    private final void $$robo$$android_widget_TextClock$encodeProperties(ViewHierarchyEncoder stream) {
        super.encodeProperties(stream);
        CharSequence s = this.getFormat12Hour();
        stream.addProperty("format12Hour", s == null ? null : s.toString());
        s = this.getFormat24Hour();
        stream.addProperty("format24Hour", s == null ? null : s.toString());
        stream.addProperty("format", this.mFormat == null ? null : this.mFormat.toString());
        stream.addProperty("hasSeconds", this.mHasSeconds);
    }

    static void __staticInitializer__() {
        DEFAULT_FORMAT_12_HOUR = "h:mm a";
        DEFAULT_FORMAT_24_HOUR = "H:mm";
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_TextClock$__constructor__(context);
    }

    public TextClock(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextClock$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_TextClock$__constructor__(context, attributeSet);
    }

    public TextClock(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextClock$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_TextClock$__constructor__(context, attributeSet, n);
    }

    public TextClock(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextClock$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_TextClock$__constructor__(context, attributeSet, n, n2);
    }

    public TextClock(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextClock$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private void init() {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_widget_TextClock$init(), 0, this);
    }

    private void createTime(String string2) {
        InvokeDynamicSupport.bootstrap("createTime", $$robo$$android_widget_TextClock$createTime(java.lang.String ), 0, this, string2);
    }

    @ViewDebug.ExportedProperty
    public CharSequence getFormat12Hour() {
        return InvokeDynamicSupport.bootstrap("getFormat12Hour", $$robo$$android_widget_TextClock$getFormat12Hour(), 0, this);
    }

    @RemotableViewMethod
    public void setFormat12Hour(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setFormat12Hour", $$robo$$android_widget_TextClock$setFormat12Hour(java.lang.CharSequence ), 0, this, charSequence);
    }

    public void setContentDescriptionFormat12Hour(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setContentDescriptionFormat12Hour", $$robo$$android_widget_TextClock$setContentDescriptionFormat12Hour(java.lang.CharSequence ), 0, this, charSequence);
    }

    @ViewDebug.ExportedProperty
    public CharSequence getFormat24Hour() {
        return InvokeDynamicSupport.bootstrap("getFormat24Hour", $$robo$$android_widget_TextClock$getFormat24Hour(), 0, this);
    }

    @RemotableViewMethod
    public void setFormat24Hour(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setFormat24Hour", $$robo$$android_widget_TextClock$setFormat24Hour(java.lang.CharSequence ), 0, this, charSequence);
    }

    public void setContentDescriptionFormat24Hour(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setContentDescriptionFormat24Hour", $$robo$$android_widget_TextClock$setContentDescriptionFormat24Hour(java.lang.CharSequence ), 0, this, charSequence);
    }

    public void setShowCurrentUserTime(boolean bl) {
        InvokeDynamicSupport.bootstrap("setShowCurrentUserTime", $$robo$$android_widget_TextClock$setShowCurrentUserTime(boolean ), 0, this, bl);
    }

    public void refresh() {
        InvokeDynamicSupport.bootstrap("refresh", $$robo$$android_widget_TextClock$refresh(), 0, this);
    }

    public boolean is24HourModeEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("is24HourModeEnabled", $$robo$$android_widget_TextClock$is24HourModeEnabled(), 0, this);
    }

    public String getTimeZone() {
        return InvokeDynamicSupport.bootstrap("getTimeZone", $$robo$$android_widget_TextClock$getTimeZone(), 0, this);
    }

    @RemotableViewMethod
    public void setTimeZone(String string2) {
        InvokeDynamicSupport.bootstrap("setTimeZone", $$robo$$android_widget_TextClock$setTimeZone(java.lang.String ), 0, this, string2);
    }

    public CharSequence getFormat() {
        return InvokeDynamicSupport.bootstrap("getFormat", $$robo$$android_widget_TextClock$getFormat(), 0, this);
    }

    private void chooseFormat() {
        InvokeDynamicSupport.bootstrap("chooseFormat", $$robo$$android_widget_TextClock$chooseFormat(), 0, this);
    }

    private static CharSequence abc(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        return InvokeDynamicSupport.bootstrapStatic("abc", $$robo$$android_widget_TextClock$abc(java.lang.CharSequence java.lang.CharSequence java.lang.CharSequence ), 0, (CharSequence)charSequence, (CharSequence)charSequence2, (CharSequence)charSequence3);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_widget_TextClock$onAttachedToWindow(), 0, this);
    }

    @Override
    public void onVisibilityAggregated(boolean bl) {
        InvokeDynamicSupport.bootstrap("onVisibilityAggregated", $$robo$$android_widget_TextClock$onVisibilityAggregated(boolean ), 0, this, bl);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_widget_TextClock$onDetachedFromWindow(), 0, this);
    }

    public void disableClockTick() {
        InvokeDynamicSupport.bootstrap("disableClockTick", $$robo$$android_widget_TextClock$disableClockTick(), 0, this);
    }

    private void registerReceiver() {
        InvokeDynamicSupport.bootstrap("registerReceiver", $$robo$$android_widget_TextClock$registerReceiver(), 0, this);
    }

    private void registerObserver() {
        InvokeDynamicSupport.bootstrap("registerObserver", $$robo$$android_widget_TextClock$registerObserver(), 0, this);
    }

    private void unregisterReceiver() {
        InvokeDynamicSupport.bootstrap("unregisterReceiver", $$robo$$android_widget_TextClock$unregisterReceiver(), 0, this);
    }

    private void unregisterObserver() {
        InvokeDynamicSupport.bootstrap("unregisterObserver", $$robo$$android_widget_TextClock$unregisterObserver(), 0, this);
    }

    private void onTimeChanged() {
        InvokeDynamicSupport.bootstrap("onTimeChanged", $$robo$$android_widget_TextClock$onTimeChanged(), 0, this);
    }

    @Override
    protected void encodeProperties(ViewHierarchyEncoder viewHierarchyEncoder) {
        InvokeDynamicSupport.bootstrap("encodeProperties", $$robo$$android_widget_TextClock$encodeProperties(android.view.ViewHierarchyEncoder ), 0, this, viewHierarchyEncoder);
    }

    static {
        RobolectricInternals.classInitializing(TextClock.class);
    }

    public /* synthetic */ TextClock() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextClock)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class FormatChangeObserver
    extends ContentObserver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ TextClock this$0;

        private void $$robo$$android_widget_TextClock_FormatChangeObserver$__constructor__(TextClock textClock, Handler handler) {
        }

        private final void $$robo$$android_widget_TextClock_FormatChangeObserver$onChange(boolean selfChange) {
            this.this$0.chooseFormat();
            this.this$0.onTimeChanged();
        }

        private final void $$robo$$android_widget_TextClock_FormatChangeObserver$onChange(boolean selfChange, Uri uri) {
            this.this$0.chooseFormat();
            this.this$0.onTimeChanged();
        }

        private void __constructor__(TextClock textClock, Handler handler) {
            this.$$robo$$android_widget_TextClock_FormatChangeObserver$__constructor__(textClock, handler);
        }

        public FormatChangeObserver(TextClock textClock, Handler handler) {
            this.this$0 = textClock;
            super(handler);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextClock_FormatChangeObserver$__constructor__(android.widget.TextClock android.os.Handler ), 0, this, textClock, handler);
        }

        @Override
        public void onChange(boolean bl) {
            InvokeDynamicSupport.bootstrap("onChange", $$robo$$android_widget_TextClock_FormatChangeObserver$onChange(boolean ), 0, this, bl);
        }

        @Override
        public void onChange(boolean bl, Uri uri) {
            InvokeDynamicSupport.bootstrap("onChange", $$robo$$android_widget_TextClock_FormatChangeObserver$onChange(boolean android.net.Uri ), 0, this, bl, uri);
        }

        public /* synthetic */ FormatChangeObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FormatChangeObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

