/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcelable;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.NumberPicker;
import android.widget.TextView;
import android.widget.TimePicker;
import com.android.internal.R;
import java.util.Calendar;
import libcore.icu.LocaleData;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TimePickerSpinnerDelegate
extends TimePicker.AbstractTimePickerDelegate
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEFAULT_ENABLED_STATE = true;
    private static int HOURS_IN_HALF_DAY = 12;
    private NumberPicker mHourSpinner;
    private NumberPicker mMinuteSpinner;
    private NumberPicker mAmPmSpinner;
    private EditText mHourSpinnerInput;
    private EditText mMinuteSpinnerInput;
    private EditText mAmPmSpinnerInput;
    private TextView mDivider;
    private Button mAmPmButton;
    private String[] mAmPmStrings;
    private Calendar mTempCalendar;
    private boolean mIsEnabled;
    private boolean mHourWithTwoDigit;
    private char mHourFormat;
    private boolean mIs24HourView;
    private boolean mIsAm;

    private void $$robo$$android_widget_TimePickerSpinnerDelegate$__constructor__(TimePicker delegator, Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mIsEnabled = true;
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyleAttr, defStyleRes);
        int layoutResourceId = a.getResourceId(13, 0x1090110);
        a.recycle();
        LayoutInflater inflater = LayoutInflater.from(this.mContext);
        View view = inflater.inflate(layoutResourceId, (ViewGroup)this.mDelegator, true);
        view.setSaveFromParentEnabled(false);
        this.mHourSpinner = (NumberPicker)delegator.findViewById(16908953);
        this.mHourSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TimePickerSpinnerDelegate this$0;

            private void $$robo$$android_widget_TimePickerSpinnerDelegate_1$__constructor__(TimePickerSpinnerDelegate this$0) {
            }

            private final void $$robo$$android_widget_TimePickerSpinnerDelegate_1$onValueChange(NumberPicker spinner, int oldVal, int newVal) {
                this.this$0.updateInputState();
                if (!this.this$0.is24Hour() && (oldVal == 11 && newVal == 12 || oldVal == 12 && newVal == 11)) {
                    this.this$0.mIsAm = !this.this$0.mIsAm;
                    this.this$0.updateAmPmControl();
                }
                this.this$0.onTimeChanged();
            }

            private void __constructor__(TimePickerSpinnerDelegate timePickerSpinnerDelegate) {
                this.$$robo$$android_widget_TimePickerSpinnerDelegate_1$__constructor__(timePickerSpinnerDelegate);
            }
            {
                this.this$0 = timePickerSpinnerDelegate;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerSpinnerDelegate_1$__constructor__(android.widget.TimePickerSpinnerDelegate ), 0, this, timePickerSpinnerDelegate);
            }

            @Override
            public void onValueChange(NumberPicker numberPicker, int n, int n2) {
                InvokeDynamicSupport.bootstrap("onValueChange", $$robo$$android_widget_TimePickerSpinnerDelegate_1$onValueChange(android.widget.NumberPicker int int ), 0, this, numberPicker, n, n2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.mHourSpinnerInput = (EditText)this.mHourSpinner.findViewById(16909131);
        this.mHourSpinnerInput.setImeOptions(5);
        this.mDivider = (TextView)this.mDelegator.findViewById(16908849);
        if (this.mDivider != null) {
            this.setDividerText();
        }
        this.mMinuteSpinner = (NumberPicker)this.mDelegator.findViewById(16909070);
        this.mMinuteSpinner.setMinValue(0);
        this.mMinuteSpinner.setMaxValue(59);
        this.mMinuteSpinner.setOnLongPressUpdateInterval(100L);
        this.mMinuteSpinner.setFormatter(NumberPicker.getTwoDigitFormatter());
        this.mMinuteSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TimePickerSpinnerDelegate this$0;

            private void $$robo$$android_widget_TimePickerSpinnerDelegate_2$__constructor__(TimePickerSpinnerDelegate this$0) {
            }

            private final void $$robo$$android_widget_TimePickerSpinnerDelegate_2$onValueChange(NumberPicker spinner, int oldVal, int newVal) {
                this.this$0.updateInputState();
                int minValue = this.this$0.mMinuteSpinner.getMinValue();
                int maxValue = this.this$0.mMinuteSpinner.getMaxValue();
                if (oldVal == maxValue && newVal == minValue) {
                    int newHour = this.this$0.mHourSpinner.getValue() + 1;
                    if (!this.this$0.is24Hour() && newHour == 12) {
                        this.this$0.mIsAm = !this.this$0.mIsAm;
                        this.this$0.updateAmPmControl();
                    }
                    this.this$0.mHourSpinner.setValue(newHour);
                } else if (oldVal == minValue && newVal == maxValue) {
                    int newHour = this.this$0.mHourSpinner.getValue() - 1;
                    if (!this.this$0.is24Hour() && newHour == 11) {
                        this.this$0.mIsAm = !this.this$0.mIsAm;
                        this.this$0.updateAmPmControl();
                    }
                    this.this$0.mHourSpinner.setValue(newHour);
                }
                this.this$0.onTimeChanged();
            }

            private void __constructor__(TimePickerSpinnerDelegate timePickerSpinnerDelegate) {
                this.$$robo$$android_widget_TimePickerSpinnerDelegate_2$__constructor__(timePickerSpinnerDelegate);
            }
            {
                this.this$0 = timePickerSpinnerDelegate;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerSpinnerDelegate_2$__constructor__(android.widget.TimePickerSpinnerDelegate ), 0, this, timePickerSpinnerDelegate);
            }

            @Override
            public void onValueChange(NumberPicker numberPicker, int n, int n2) {
                InvokeDynamicSupport.bootstrap("onValueChange", $$robo$$android_widget_TimePickerSpinnerDelegate_2$onValueChange(android.widget.NumberPicker int int ), 0, this, numberPicker, n, n2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.mMinuteSpinnerInput = (EditText)this.mMinuteSpinner.findViewById(16909131);
        this.mMinuteSpinnerInput.setImeOptions(5);
        this.mAmPmStrings = TimePickerSpinnerDelegate.getAmPmStrings(context);
        Object amPmView = this.mDelegator.findViewById(16908712);
        if (amPmView instanceof Button) {
            this.mAmPmSpinner = null;
            this.mAmPmSpinnerInput = null;
            this.mAmPmButton = (Button)amPmView;
            this.mAmPmButton.setOnClickListener(new View.OnClickListener(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ TimePickerSpinnerDelegate this$0;

                private void $$robo$$android_widget_TimePickerSpinnerDelegate_3$__constructor__(TimePickerSpinnerDelegate this$0) {
                }

                private final void $$robo$$android_widget_TimePickerSpinnerDelegate_3$onClick(View button) {
                    button.requestFocus();
                    this.this$0.mIsAm = !this.this$0.mIsAm;
                    this.this$0.updateAmPmControl();
                    this.this$0.onTimeChanged();
                }

                private void __constructor__(TimePickerSpinnerDelegate timePickerSpinnerDelegate) {
                    this.$$robo$$android_widget_TimePickerSpinnerDelegate_3$__constructor__(timePickerSpinnerDelegate);
                }
                {
                    this.this$0 = timePickerSpinnerDelegate;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerSpinnerDelegate_3$__constructor__(android.widget.TimePickerSpinnerDelegate ), 0, this, timePickerSpinnerDelegate);
                }

                @Override
                public void onClick(View view) {
                    InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_TimePickerSpinnerDelegate_3$onClick(android.view.View ), 0, this, view);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        } else {
            this.mAmPmButton = null;
            this.mAmPmSpinner = (NumberPicker)amPmView;
            this.mAmPmSpinner.setMinValue(0);
            this.mAmPmSpinner.setMaxValue(1);
            this.mAmPmSpinner.setDisplayedValues(this.mAmPmStrings);
            this.mAmPmSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ TimePickerSpinnerDelegate this$0;

                private void $$robo$$android_widget_TimePickerSpinnerDelegate_4$__constructor__(TimePickerSpinnerDelegate this$0) {
                }

                private final void $$robo$$android_widget_TimePickerSpinnerDelegate_4$onValueChange(NumberPicker picker, int oldVal, int newVal) {
                    this.this$0.updateInputState();
                    picker.requestFocus();
                    this.this$0.mIsAm = !this.this$0.mIsAm;
                    this.this$0.updateAmPmControl();
                    this.this$0.onTimeChanged();
                }

                private void __constructor__(TimePickerSpinnerDelegate timePickerSpinnerDelegate) {
                    this.$$robo$$android_widget_TimePickerSpinnerDelegate_4$__constructor__(timePickerSpinnerDelegate);
                }
                {
                    this.this$0 = timePickerSpinnerDelegate;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerSpinnerDelegate_4$__constructor__(android.widget.TimePickerSpinnerDelegate ), 0, this, timePickerSpinnerDelegate);
                }

                @Override
                public void onValueChange(NumberPicker numberPicker, int n, int n2) {
                    InvokeDynamicSupport.bootstrap("onValueChange", $$robo$$android_widget_TimePickerSpinnerDelegate_4$onValueChange(android.widget.NumberPicker int int ), 0, this, numberPicker, n, n2);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            this.mAmPmSpinnerInput = (EditText)this.mAmPmSpinner.findViewById(16909131);
            this.mAmPmSpinnerInput.setImeOptions(6);
        }
        if (this.isAmPmAtStart()) {
            ViewGroup amPmParent = (ViewGroup)delegator.findViewById(16909407);
            amPmParent.removeView((View)amPmView);
            amPmParent.addView((View)amPmView, 0);
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)((View)amPmView).getLayoutParams();
            int startMargin = lp.getMarginStart();
            int endMargin = lp.getMarginEnd();
            if (startMargin != endMargin) {
                lp.setMarginStart(endMargin);
                lp.setMarginEnd(startMargin);
            }
        }
        this.getHourFormatData();
        this.updateHourControl();
        this.updateMinuteControl();
        this.updateAmPmControl();
        this.mTempCalendar = Calendar.getInstance(this.mLocale);
        this.setHour(this.mTempCalendar.get(11));
        this.setMinute(this.mTempCalendar.get(12));
        if (!this.isEnabled()) {
            this.setEnabled(false);
        }
        this.setContentDescriptions();
        if (this.mDelegator.getImportantForAccessibility() == 0) {
            this.mDelegator.setImportantForAccessibility(1);
        }
    }

    private final boolean $$robo$$android_widget_TimePickerSpinnerDelegate$validateInput() {
        return true;
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$getHourFormatData() {
        String bestDateTimePattern = DateFormat.getBestDateTimePattern(this.mLocale, this.mIs24HourView ? "Hm" : "hm");
        int lengthPattern = bestDateTimePattern.length();
        this.mHourWithTwoDigit = false;
        boolean hourFormat = false;
        for (int i = 0; i < lengthPattern; ++i) {
            char c = bestDateTimePattern.charAt(i);
            if (c != 'H' && c != 'h' && c != 'K' && c != 'k') continue;
            this.mHourFormat = c;
            if (i + 1 >= lengthPattern || c != bestDateTimePattern.charAt(i + 1)) break;
            this.mHourWithTwoDigit = true;
            break;
        }
    }

    private final boolean $$robo$$android_widget_TimePickerSpinnerDelegate$isAmPmAtStart() {
        String bestDateTimePattern = DateFormat.getBestDateTimePattern(this.mLocale, "hm");
        return bestDateTimePattern.startsWith("a");
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$setDividerText() {
        int minuteIndex;
        String skeleton = this.mIs24HourView ? "Hm" : "hm";
        String bestDateTimePattern = DateFormat.getBestDateTimePattern(this.mLocale, skeleton);
        int hourIndex = bestDateTimePattern.lastIndexOf(72);
        if (hourIndex == -1) {
            hourIndex = bestDateTimePattern.lastIndexOf(104);
        }
        String separatorText = hourIndex == -1 ? ":" : ((minuteIndex = bestDateTimePattern.indexOf(109, hourIndex + 1)) == -1 ? Character.toString(bestDateTimePattern.charAt(hourIndex + 1)) : bestDateTimePattern.substring(hourIndex + 1, minuteIndex));
        this.mDivider.setText(separatorText);
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$setDate(int hour, int minute) {
        this.setCurrentHour(hour, false);
        this.setCurrentMinute(minute, false);
        this.onTimeChanged();
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$setHour(int hour) {
        this.setCurrentHour(hour, true);
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$setCurrentHour(int currentHour, boolean notifyTimeChanged) {
        if (currentHour == this.getHour()) {
            return;
        }
        this.resetAutofilledValue();
        if (!this.is24Hour()) {
            if (currentHour >= 12) {
                this.mIsAm = false;
                if (currentHour > 12) {
                    currentHour -= 12;
                }
            } else {
                this.mIsAm = true;
                if (currentHour == 0) {
                    currentHour = 12;
                }
            }
            this.updateAmPmControl();
        }
        this.mHourSpinner.setValue(currentHour);
        if (notifyTimeChanged) {
            this.onTimeChanged();
        }
    }

    private final int $$robo$$android_widget_TimePickerSpinnerDelegate$getHour() {
        int currentHour = this.mHourSpinner.getValue();
        if (this.is24Hour()) {
            return currentHour;
        }
        if (this.mIsAm) {
            return currentHour % 12;
        }
        return currentHour % 12 + 12;
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$setMinute(int minute) {
        this.setCurrentMinute(minute, true);
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$setCurrentMinute(int minute, boolean notifyTimeChanged) {
        if (minute == this.getMinute()) {
            return;
        }
        this.resetAutofilledValue();
        this.mMinuteSpinner.setValue(minute);
        if (notifyTimeChanged) {
            this.onTimeChanged();
        }
    }

    private final int $$robo$$android_widget_TimePickerSpinnerDelegate$getMinute() {
        return this.mMinuteSpinner.getValue();
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$setIs24Hour(boolean is24Hour) {
        if (this.mIs24HourView == is24Hour) {
            return;
        }
        int currentHour = this.getHour();
        this.mIs24HourView = is24Hour;
        this.getHourFormatData();
        this.updateHourControl();
        this.setCurrentHour(currentHour, false);
        this.updateMinuteControl();
        this.updateAmPmControl();
    }

    private final boolean $$robo$$android_widget_TimePickerSpinnerDelegate$is24Hour() {
        return this.mIs24HourView;
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$setEnabled(boolean enabled) {
        this.mMinuteSpinner.setEnabled(enabled);
        if (this.mDivider != null) {
            this.mDivider.setEnabled(enabled);
        }
        this.mHourSpinner.setEnabled(enabled);
        if (this.mAmPmSpinner != null) {
            this.mAmPmSpinner.setEnabled(enabled);
        } else {
            this.mAmPmButton.setEnabled(enabled);
        }
        this.mIsEnabled = enabled;
    }

    private final boolean $$robo$$android_widget_TimePickerSpinnerDelegate$isEnabled() {
        return this.mIsEnabled;
    }

    private final int $$robo$$android_widget_TimePickerSpinnerDelegate$getBaseline() {
        return this.mHourSpinner.getBaseline();
    }

    private final Parcelable $$robo$$android_widget_TimePickerSpinnerDelegate$onSaveInstanceState(Parcelable superState) {
        return new TimePicker.AbstractTimePickerDelegate.SavedState(superState, this.getHour(), this.getMinute(), this.is24Hour());
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$onRestoreInstanceState(Parcelable state) {
        if (state instanceof TimePicker.AbstractTimePickerDelegate.SavedState) {
            TimePicker.AbstractTimePickerDelegate.SavedState ss = (TimePicker.AbstractTimePickerDelegate.SavedState)state;
            this.setHour(ss.getHour());
            this.setMinute(ss.getMinute());
        }
    }

    private final boolean $$robo$$android_widget_TimePickerSpinnerDelegate$dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$onPopulateAccessibilityEvent(AccessibilityEvent event) {
        int flags = 1;
        flags = this.mIs24HourView ? (flags |= 0x80) : (flags |= 0x40);
        this.mTempCalendar.set(11, this.getHour());
        this.mTempCalendar.set(12, this.getMinute());
        String selectedDateUtterance = DateUtils.formatDateTime(this.mContext, this.mTempCalendar.getTimeInMillis(), flags);
        event.getText().add(selectedDateUtterance);
    }

    private final View $$robo$$android_widget_TimePickerSpinnerDelegate$getHourView() {
        return this.mHourSpinnerInput;
    }

    private final View $$robo$$android_widget_TimePickerSpinnerDelegate$getMinuteView() {
        return this.mMinuteSpinnerInput;
    }

    private final View $$robo$$android_widget_TimePickerSpinnerDelegate$getAmView() {
        return this.mAmPmSpinnerInput;
    }

    private final View $$robo$$android_widget_TimePickerSpinnerDelegate$getPmView() {
        return this.mAmPmSpinnerInput;
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$updateInputState() {
        InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
        if (inputMethodManager != null) {
            if (inputMethodManager.isActive(this.mHourSpinnerInput)) {
                this.mHourSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
            } else if (inputMethodManager.isActive(this.mMinuteSpinnerInput)) {
                this.mMinuteSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
            } else if (inputMethodManager.isActive(this.mAmPmSpinnerInput)) {
                this.mAmPmSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
            }
        }
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$updateAmPmControl() {
        if (this.is24Hour()) {
            if (this.mAmPmSpinner != null) {
                this.mAmPmSpinner.setVisibility(8);
            } else {
                this.mAmPmButton.setVisibility(8);
            }
        } else {
            int index;
            int n = index = this.mIsAm ? 0 : 1;
            if (this.mAmPmSpinner != null) {
                this.mAmPmSpinner.setValue(index);
                this.mAmPmSpinner.setVisibility(0);
            } else {
                this.mAmPmButton.setText(this.mAmPmStrings[index]);
                this.mAmPmButton.setVisibility(0);
            }
        }
        this.mDelegator.sendAccessibilityEvent(4);
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$onTimeChanged() {
        this.mDelegator.sendAccessibilityEvent(4);
        if (this.mOnTimeChangedListener != null) {
            this.mOnTimeChangedListener.onTimeChanged(this.mDelegator, this.getHour(), this.getMinute());
        }
        if (this.mAutoFillChangeListener != null) {
            this.mAutoFillChangeListener.onTimeChanged(this.mDelegator, this.getHour(), this.getMinute());
        }
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$updateHourControl() {
        if (this.is24Hour()) {
            if (this.mHourFormat == 'k') {
                this.mHourSpinner.setMinValue(1);
                this.mHourSpinner.setMaxValue(24);
            } else {
                this.mHourSpinner.setMinValue(0);
                this.mHourSpinner.setMaxValue(23);
            }
        } else if (this.mHourFormat == 'K') {
            this.mHourSpinner.setMinValue(0);
            this.mHourSpinner.setMaxValue(11);
        } else {
            this.mHourSpinner.setMinValue(1);
            this.mHourSpinner.setMaxValue(12);
        }
        this.mHourSpinner.setFormatter(this.mHourWithTwoDigit ? NumberPicker.getTwoDigitFormatter() : null);
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$updateMinuteControl() {
        if (this.is24Hour()) {
            this.mMinuteSpinnerInput.setImeOptions(6);
        } else {
            this.mMinuteSpinnerInput.setImeOptions(5);
        }
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$setContentDescriptions() {
        this.trySetContentDescription(this.mMinuteSpinner, 16908974, 17040977);
        this.trySetContentDescription(this.mMinuteSpinner, 16908836, 17040971);
        this.trySetContentDescription(this.mHourSpinner, 16908974, 17040976);
        this.trySetContentDescription(this.mHourSpinner, 16908836, 17040970);
        if (this.mAmPmSpinner != null) {
            this.trySetContentDescription(this.mAmPmSpinner, 16908974, 17040978);
            this.trySetContentDescription(this.mAmPmSpinner, 16908836, 17040972);
        }
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$trySetContentDescription(View root, int viewId, int contDescResId) {
        Object target = root.findViewById(viewId);
        if (target != null) {
            ((View)target).setContentDescription(this.mContext.getString(contDescResId));
        }
    }

    private static final String[] $$robo$$android_widget_TimePickerSpinnerDelegate$getAmPmStrings(Context context) {
        String[] result = new String[2];
        LocaleData d = LocaleData.get(context.getResources().getConfiguration().locale);
        result[0] = d.amPm[0].length() > 4 ? d.narrowAm : d.amPm[0];
        result[1] = d.amPm[1].length() > 4 ? d.narrowPm : d.amPm[1];
        return result;
    }

    private void __constructor__(TimePicker timePicker, Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_TimePickerSpinnerDelegate$__constructor__(timePicker, context, attributeSet, n, n2);
    }

    public TimePickerSpinnerDelegate(TimePicker timePicker, Context context, AttributeSet attributeSet, int n, int n2) {
        super(timePicker, context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerSpinnerDelegate$__constructor__(android.widget.TimePicker android.content.Context android.util.AttributeSet int int ), 0, this, timePicker, context, attributeSet, n, n2);
    }

    @Override
    public boolean validateInput() {
        return (boolean)InvokeDynamicSupport.bootstrap("validateInput", $$robo$$android_widget_TimePickerSpinnerDelegate$validateInput(), 0, this);
    }

    private void getHourFormatData() {
        InvokeDynamicSupport.bootstrap("getHourFormatData", $$robo$$android_widget_TimePickerSpinnerDelegate$getHourFormatData(), 0, this);
    }

    private boolean isAmPmAtStart() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAmPmAtStart", $$robo$$android_widget_TimePickerSpinnerDelegate$isAmPmAtStart(), 0, this);
    }

    private void setDividerText() {
        InvokeDynamicSupport.bootstrap("setDividerText", $$robo$$android_widget_TimePickerSpinnerDelegate$setDividerText(), 0, this);
    }

    @Override
    public void setDate(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setDate", $$robo$$android_widget_TimePickerSpinnerDelegate$setDate(int int ), 0, this, n, n2);
    }

    @Override
    public void setHour(int n) {
        InvokeDynamicSupport.bootstrap("setHour", $$robo$$android_widget_TimePickerSpinnerDelegate$setHour(int ), 0, this, n);
    }

    private void setCurrentHour(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setCurrentHour", $$robo$$android_widget_TimePickerSpinnerDelegate$setCurrentHour(int boolean ), 0, this, n, bl);
    }

    @Override
    public int getHour() {
        return (int)InvokeDynamicSupport.bootstrap("getHour", $$robo$$android_widget_TimePickerSpinnerDelegate$getHour(), 0, this);
    }

    @Override
    public void setMinute(int n) {
        InvokeDynamicSupport.bootstrap("setMinute", $$robo$$android_widget_TimePickerSpinnerDelegate$setMinute(int ), 0, this, n);
    }

    private void setCurrentMinute(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setCurrentMinute", $$robo$$android_widget_TimePickerSpinnerDelegate$setCurrentMinute(int boolean ), 0, this, n, bl);
    }

    @Override
    public int getMinute() {
        return (int)InvokeDynamicSupport.bootstrap("getMinute", $$robo$$android_widget_TimePickerSpinnerDelegate$getMinute(), 0, this);
    }

    @Override
    public void setIs24Hour(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIs24Hour", $$robo$$android_widget_TimePickerSpinnerDelegate$setIs24Hour(boolean ), 0, this, bl);
    }

    @Override
    public boolean is24Hour() {
        return (boolean)InvokeDynamicSupport.bootstrap("is24Hour", $$robo$$android_widget_TimePickerSpinnerDelegate$is24Hour(), 0, this);
    }

    @Override
    public void setEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_widget_TimePickerSpinnerDelegate$setEnabled(boolean ), 0, this, bl);
    }

    @Override
    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_widget_TimePickerSpinnerDelegate$isEnabled(), 0, this);
    }

    @Override
    public int getBaseline() {
        return (int)InvokeDynamicSupport.bootstrap("getBaseline", $$robo$$android_widget_TimePickerSpinnerDelegate$getBaseline(), 0, this);
    }

    @Override
    public Parcelable onSaveInstanceState(Parcelable parcelable) {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_widget_TimePickerSpinnerDelegate$onSaveInstanceState(android.os.Parcelable ), 0, this, parcelable);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_widget_TimePickerSpinnerDelegate$onRestoreInstanceState(android.os.Parcelable ), 0, this, parcelable);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchPopulateAccessibilityEvent", $$robo$$android_widget_TimePickerSpinnerDelegate$dispatchPopulateAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onPopulateAccessibilityEvent", $$robo$$android_widget_TimePickerSpinnerDelegate$onPopulateAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public View getHourView() {
        return InvokeDynamicSupport.bootstrap("getHourView", $$robo$$android_widget_TimePickerSpinnerDelegate$getHourView(), 0, this);
    }

    @Override
    public View getMinuteView() {
        return InvokeDynamicSupport.bootstrap("getMinuteView", $$robo$$android_widget_TimePickerSpinnerDelegate$getMinuteView(), 0, this);
    }

    @Override
    public View getAmView() {
        return InvokeDynamicSupport.bootstrap("getAmView", $$robo$$android_widget_TimePickerSpinnerDelegate$getAmView(), 0, this);
    }

    @Override
    public View getPmView() {
        return InvokeDynamicSupport.bootstrap("getPmView", $$robo$$android_widget_TimePickerSpinnerDelegate$getPmView(), 0, this);
    }

    private void updateInputState() {
        InvokeDynamicSupport.bootstrap("updateInputState", $$robo$$android_widget_TimePickerSpinnerDelegate$updateInputState(), 0, this);
    }

    private void updateAmPmControl() {
        InvokeDynamicSupport.bootstrap("updateAmPmControl", $$robo$$android_widget_TimePickerSpinnerDelegate$updateAmPmControl(), 0, this);
    }

    private void onTimeChanged() {
        InvokeDynamicSupport.bootstrap("onTimeChanged", $$robo$$android_widget_TimePickerSpinnerDelegate$onTimeChanged(), 0, this);
    }

    private void updateHourControl() {
        InvokeDynamicSupport.bootstrap("updateHourControl", $$robo$$android_widget_TimePickerSpinnerDelegate$updateHourControl(), 0, this);
    }

    private void updateMinuteControl() {
        InvokeDynamicSupport.bootstrap("updateMinuteControl", $$robo$$android_widget_TimePickerSpinnerDelegate$updateMinuteControl(), 0, this);
    }

    private void setContentDescriptions() {
        InvokeDynamicSupport.bootstrap("setContentDescriptions", $$robo$$android_widget_TimePickerSpinnerDelegate$setContentDescriptions(), 0, this);
    }

    private void trySetContentDescription(View view, int n, int n2) {
        InvokeDynamicSupport.bootstrap("trySetContentDescription", $$robo$$android_widget_TimePickerSpinnerDelegate$trySetContentDescription(android.view.View int int ), 0, this, view, n, n2);
    }

    public static String[] getAmPmStrings(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getAmPmStrings", $$robo$$android_widget_TimePickerSpinnerDelegate$getAmPmStrings(android.content.Context ), 0, (Context)context);
    }

    public /* synthetic */ TimePickerSpinnerDelegate() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimePickerSpinnerDelegate)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

