/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.phonenumbers.geocoding;

import com.android.i18n.phonenumbers.NumberParseException;
import com.android.i18n.phonenumbers.PhoneNumberUtil;
import com.android.i18n.phonenumbers.Phonenumber;
import com.android.i18n.phonenumbers.prefixmapper.PrefixFileReader;
import java.util.List;
import java.util.Locale;

public class PhoneNumberOfflineGeocoder {
    private static PhoneNumberOfflineGeocoder instance = null;
    private static final String MAPPING_DATA_DIRECTORY = "/com/android/i18n/phonenumbers/geocoding/data/";
    private PrefixFileReader prefixFileReader = null;
    private final PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();

    PhoneNumberOfflineGeocoder(String phonePrefixDataDirectory) {
        this.prefixFileReader = new PrefixFileReader(phonePrefixDataDirectory);
    }

    public static synchronized PhoneNumberOfflineGeocoder getInstance() {
        if (instance == null) {
            instance = new PhoneNumberOfflineGeocoder(MAPPING_DATA_DIRECTORY);
        }
        return instance;
    }

    private String getCountryNameForNumber(Phonenumber.PhoneNumber number, Locale language) {
        List<String> regionCodes = this.phoneUtil.getRegionCodesForCountryCode(number.getCountryCode());
        if (regionCodes.size() == 1) {
            return this.getRegionDisplayName(regionCodes.get(0), language);
        }
        String regionWhereNumberIsValid = "ZZ";
        for (String regionCode : regionCodes) {
            if (!this.phoneUtil.isValidNumberForRegion(number, regionCode)) continue;
            if (!regionWhereNumberIsValid.equals("ZZ")) {
                return "";
            }
            regionWhereNumberIsValid = regionCode;
        }
        return this.getRegionDisplayName(regionWhereNumberIsValid, language);
    }

    private String getRegionDisplayName(String regionCode, Locale language) {
        return regionCode == null || regionCode.equals("ZZ") || regionCode.equals("001") ? "" : new Locale("", regionCode).getDisplayCountry(language);
    }

    public String getDescriptionForValidNumber(Phonenumber.PhoneNumber number, Locale languageCode) {
        String areaDescription;
        String langStr = languageCode.getLanguage();
        String scriptStr = "";
        String regionStr = languageCode.getCountry();
        String mobileToken = PhoneNumberUtil.getCountryMobileToken(number.getCountryCode());
        String nationalNumber = this.phoneUtil.getNationalSignificantNumber(number);
        if (!mobileToken.equals("") && nationalNumber.startsWith(mobileToken)) {
            Phonenumber.PhoneNumber copiedNumber;
            nationalNumber = nationalNumber.substring(mobileToken.length());
            String region = this.phoneUtil.getRegionCodeForCountryCode(number.getCountryCode());
            try {
                copiedNumber = this.phoneUtil.parse(nationalNumber, region);
            }
            catch (NumberParseException e) {
                copiedNumber = number;
            }
            areaDescription = this.prefixFileReader.getDescriptionForNumber(copiedNumber, langStr, scriptStr, regionStr);
        } else {
            areaDescription = this.prefixFileReader.getDescriptionForNumber(number, langStr, scriptStr, regionStr);
        }
        return areaDescription.length() > 0 ? areaDescription : this.getCountryNameForNumber(number, languageCode);
    }

    public String getDescriptionForValidNumber(Phonenumber.PhoneNumber number, Locale languageCode, String userRegion) {
        String regionCode = this.phoneUtil.getRegionCodeForNumber(number);
        if (userRegion.equals(regionCode)) {
            return this.getDescriptionForValidNumber(number, languageCode);
        }
        return this.getRegionDisplayName(regionCode, languageCode);
    }

    public String getDescriptionForNumber(Phonenumber.PhoneNumber number, Locale languageCode) {
        PhoneNumberUtil.PhoneNumberType numberType = this.phoneUtil.getNumberType(number);
        if (numberType == PhoneNumberUtil.PhoneNumberType.UNKNOWN) {
            return "";
        }
        if (!this.phoneUtil.isNumberGeographical(numberType, number.getCountryCode())) {
            return this.getCountryNameForNumber(number, languageCode);
        }
        return this.getDescriptionForValidNumber(number, languageCode);
    }

    public String getDescriptionForNumber(Phonenumber.PhoneNumber number, Locale languageCode, String userRegion) {
        PhoneNumberUtil.PhoneNumberType numberType = this.phoneUtil.getNumberType(number);
        if (numberType == PhoneNumberUtil.PhoneNumberType.UNKNOWN) {
            return "";
        }
        if (!this.phoneUtil.isNumberGeographical(numberType, number.getCountryCode())) {
            return this.getCountryNameForNumber(number, languageCode);
        }
        return this.getDescriptionForValidNumber(number, languageCode, userRegion);
    }
}

