/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.accessibility;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.AlertDialog;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.database.ContentObserver;
import android.media.AudioAttributes;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Vibrator;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Slog;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.widget.Toast;
import com.android.internal.util.ArrayUtils;
import java.util.Collections;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AccessibilityShortcutController
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AccessibilityShortcutController";
    public static ComponentName COLOR_INVERSION_COMPONENT_NAME;
    public static ComponentName DALTONIZER_COMPONENT_NAME;
    private static AudioAttributes VIBRATION_ATTRIBUTES;
    private static Map<ComponentName, ToggleableFrameworkFeatureInfo> sFrameworkShortcutFeaturesMap;
    private Context mContext;
    private AlertDialog mAlertDialog;
    private boolean mIsShortcutEnabled;
    private boolean mEnabledOnLockScreen;
    private int mUserId;
    public FrameworkObjectProvider mFrameworkObjectProvider;

    private static final String $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$getTargetServiceComponentNameString(Context context, int userId) {
        String currentShortcutServiceId = Settings.Secure.getStringForUser(context.getContentResolver(), "accessibility_shortcut_target_service", userId);
        if (currentShortcutServiceId != null) {
            return currentShortcutServiceId;
        }
        return context.getString(17039649);
    }

    private static final Map<ComponentName, ToggleableFrameworkFeatureInfo> $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$getFrameworkShortcutFeaturesMap() {
        if (sFrameworkShortcutFeaturesMap == null) {
            ArrayMap<ComponentName, ToggleableFrameworkFeatureInfo> featuresMap = new ArrayMap<ComponentName, ToggleableFrameworkFeatureInfo>(2);
            featuresMap.put(COLOR_INVERSION_COMPONENT_NAME, new ToggleableFrameworkFeatureInfo("accessibility_display_inversion_enabled", "1", "0", 17039624));
            featuresMap.put(DALTONIZER_COMPONENT_NAME, new ToggleableFrameworkFeatureInfo("accessibility_display_daltonizer_enabled", "1", "0", 17039623));
            sFrameworkShortcutFeaturesMap = Collections.unmodifiableMap(featuresMap);
        }
        return sFrameworkShortcutFeaturesMap;
    }

    private void $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$__constructor__(Context context, Handler handler, int initialUserId) {
        this.mFrameworkObjectProvider = new FrameworkObjectProvider();
        this.mContext = context;
        this.mUserId = initialUserId;
        ShadowedObject co = new ShadowedObject(this, handler){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AccessibilityShortcutController this$0;

            private void $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_1$__constructor__(AccessibilityShortcutController this$0, Handler x0) {
            }

            private final void $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_1$onChange(boolean selfChange, Uri uri, int userId) {
                if (userId == this.this$0.mUserId) {
                    this.this$0.onSettingsChanged();
                }
            }

            private void __constructor__(AccessibilityShortcutController accessibilityShortcutController, Handler handler) {
                this.$$robo$$com_android_internal_accessibility_AccessibilityShortcutController_1$__constructor__(accessibilityShortcutController, handler);
            }
            {
                this.this$0 = accessibilityShortcutController;
                super(handler);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_1$__constructor__(com.android.internal.accessibility.AccessibilityShortcutController android.os.Handler ), 0, this, accessibilityShortcutController, handler);
            }

            @Override
            public void onChange(boolean bl, Uri uri, int n) {
                InvokeDynamicSupport.bootstrap("onChange", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_1$onChange(boolean android.net.Uri int ), 0, this, bl, uri, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("accessibility_shortcut_target_service"), false, (ContentObserver)co, -1);
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("accessibility_shortcut_enabled"), false, (ContentObserver)co, -1);
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("accessibility_shortcut_on_lock_screen"), false, (ContentObserver)co, -1);
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("accessibility_shortcut_dialog_shown"), false, (ContentObserver)co, -1);
        this.setCurrentUser(this.mUserId);
    }

    private final void $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$setCurrentUser(int currentUserId) {
        this.mUserId = currentUserId;
        this.onSettingsChanged();
    }

    private final boolean $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$isAccessibilityShortcutAvailable(boolean phoneLocked) {
        return this.mIsShortcutEnabled && (!phoneLocked || this.mEnabledOnLockScreen);
    }

    private final void $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$onSettingsChanged() {
        boolean haveValidService = !TextUtils.isEmpty(AccessibilityShortcutController.getTargetServiceComponentNameString(this.mContext, this.mUserId));
        ContentResolver cr = this.mContext.getContentResolver();
        boolean enabled = Settings.Secure.getIntForUser(cr, "accessibility_shortcut_enabled", 1, this.mUserId) == 1;
        int dialogAlreadyShown = Settings.Secure.getIntForUser(cr, "accessibility_shortcut_dialog_shown", 0, this.mUserId);
        this.mEnabledOnLockScreen = Settings.Secure.getIntForUser(cr, "accessibility_shortcut_on_lock_screen", dialogAlreadyShown, this.mUserId) == 1;
        this.mIsShortcutEnabled = enabled && haveValidService;
    }

    private final void $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$performAccessibilityShortcut() {
        Vibrator vibrator;
        Slog.d("AccessibilityShortcutController", "Accessibility shortcut activated");
        ContentResolver cr = this.mContext.getContentResolver();
        int userId = ActivityManager.getCurrentUser();
        int dialogAlreadyShown = Settings.Secure.getIntForUser(cr, "accessibility_shortcut_dialog_shown", 0, userId);
        int audioAttributesUsage = this.hasFeatureLeanback() ? 11 : 10;
        Ringtone tone = RingtoneManager.getRingtone(this.mContext, Settings.System.DEFAULT_NOTIFICATION_URI);
        if (tone != null) {
            tone.setAudioAttributes(new AudioAttributes.Builder().setUsage(audioAttributesUsage).build());
            tone.play();
        }
        if ((vibrator = (Vibrator)this.mContext.getSystemService("vibrator")) != null && vibrator.hasVibrator()) {
            long[] vibePattern = ArrayUtils.convertToLongArray(this.mContext.getResources().getIntArray(17236017));
            vibrator.vibrate(vibePattern, -1, VIBRATION_ATTRIBUTES);
        }
        if (dialogAlreadyShown == 0) {
            this.mAlertDialog = this.createShortcutWarningDialog(userId);
            if (this.mAlertDialog == null) {
                return;
            }
            Window w = this.mAlertDialog.getWindow();
            WindowManager.LayoutParams attr2 = w.getAttributes();
            attr2.type = 2009;
            w.setAttributes(attr2);
            this.mAlertDialog.show();
            Settings.Secure.putIntForUser(cr, "accessibility_shortcut_dialog_shown", 1, userId);
        } else {
            String serviceName;
            if (this.mAlertDialog != null) {
                this.mAlertDialog.dismiss();
                this.mAlertDialog = null;
            }
            if ((serviceName = this.getShortcutFeatureDescription(false)) == null) {
                Slog.e("AccessibilityShortcutController", "Accessibility shortcut set to invalid service");
                return;
            }
            AccessibilityServiceInfo serviceInfo = this.getInfoForTargetService();
            if (serviceInfo != null) {
                String toastMessageFormatString = this.mContext.getString(this.isServiceEnabled(serviceInfo) ? 0x1040041 : 17039426);
                String toastMessage = String.format(toastMessageFormatString, serviceName);
                Toast warningToast = this.mFrameworkObjectProvider.makeToastFromText(this.mContext, toastMessage, 1);
                warningToast.getWindowParams().privateFlags |= 0x10;
                warningToast.show();
            }
            this.mFrameworkObjectProvider.getAccessibilityManagerInstance(this.mContext).performAccessibilityShortcut();
        }
    }

    private final AlertDialog $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$createShortcutWarningDialog(int userId) {
        String serviceDescription = this.getShortcutFeatureDescription(true);
        if (serviceDescription == null) {
            return null;
        }
        String warningMessage = String.format(this.mContext.getString(17039427), serviceDescription);
        AlertDialog alertDialog = this.mFrameworkObjectProvider.getAlertDialogBuilder(this.mFrameworkObjectProvider.getSystemUiContext()).setTitle(0x1040044).setMessage(warningMessage).setCancelable(false).setPositiveButton(17040127, null).setNegativeButton(17039799, (d, which) -> Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "accessibility_shortcut_target_service", "", userId)).setOnCancelListener(d -> Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "accessibility_shortcut_dialog_shown", 0, userId)).create();
        return alertDialog;
    }

    private final AccessibilityServiceInfo $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$getInfoForTargetService() {
        String currentShortcutServiceString = AccessibilityShortcutController.getTargetServiceComponentNameString(this.mContext, -2);
        if (currentShortcutServiceString == null) {
            return null;
        }
        AccessibilityManager accessibilityManager = this.mFrameworkObjectProvider.getAccessibilityManagerInstance(this.mContext);
        return accessibilityManager.getInstalledServiceInfoWithComponentName(ComponentName.unflattenFromString(currentShortcutServiceString));
    }

    private final String $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$getShortcutFeatureDescription(boolean includeSummary) {
        String currentShortcutServiceString = AccessibilityShortcutController.getTargetServiceComponentNameString(this.mContext, -2);
        if (currentShortcutServiceString == null) {
            return null;
        }
        ComponentName targetComponentName = ComponentName.unflattenFromString(currentShortcutServiceString);
        ToggleableFrameworkFeatureInfo frameworkFeatureInfo = AccessibilityShortcutController.getFrameworkShortcutFeaturesMap().get(targetComponentName);
        if (frameworkFeatureInfo != null) {
            return frameworkFeatureInfo.getLabel(this.mContext);
        }
        AccessibilityServiceInfo serviceInfo = this.mFrameworkObjectProvider.getAccessibilityManagerInstance(this.mContext).getInstalledServiceInfoWithComponentName(targetComponentName);
        if (serviceInfo == null) {
            return null;
        }
        PackageManager pm = this.mContext.getPackageManager();
        String label = serviceInfo.getResolveInfo().loadLabel(pm).toString();
        CharSequence summary = serviceInfo.loadSummary(pm);
        if (!includeSummary || TextUtils.isEmpty(summary)) {
            return label;
        }
        return String.format("%s\n%s", label, summary);
    }

    private final boolean $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$isServiceEnabled(AccessibilityServiceInfo serviceInfo) {
        AccessibilityManager accessibilityManager = this.mFrameworkObjectProvider.getAccessibilityManagerInstance(this.mContext);
        return accessibilityManager.getEnabledAccessibilityServiceList(-1).contains(serviceInfo);
    }

    private final boolean $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$hasFeatureLeanback() {
        return this.mContext.getPackageManager().hasSystemFeature("android.software.leanback");
    }

    static void __staticInitializer__() {
        COLOR_INVERSION_COMPONENT_NAME = new ComponentName("com.android.server.accessibility", "ColorInversion");
        DALTONIZER_COMPONENT_NAME = new ComponentName("com.android.server.accessibility", "Daltonizer");
        VIBRATION_ATTRIBUTES = new AudioAttributes.Builder().setContentType(4).setUsage(11).build();
    }

    public static String getTargetServiceComponentNameString(Context context, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getTargetServiceComponentNameString", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$getTargetServiceComponentNameString(android.content.Context int ), 0, (Context)context, (int)n);
    }

    public static Map<ComponentName, ToggleableFrameworkFeatureInfo> getFrameworkShortcutFeaturesMap() {
        return InvokeDynamicSupport.bootstrapStatic("getFrameworkShortcutFeaturesMap", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$getFrameworkShortcutFeaturesMap(), 0);
    }

    private void __constructor__(Context context, Handler handler, int n) {
        this.$$robo$$com_android_internal_accessibility_AccessibilityShortcutController$__constructor__(context, handler, n);
    }

    public AccessibilityShortcutController(Context context, Handler handler, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$__constructor__(android.content.Context android.os.Handler int ), 0, this, context, handler, n);
    }

    public void setCurrentUser(int n) {
        InvokeDynamicSupport.bootstrap("setCurrentUser", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$setCurrentUser(int ), 0, this, n);
    }

    public boolean isAccessibilityShortcutAvailable(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAccessibilityShortcutAvailable", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$isAccessibilityShortcutAvailable(boolean ), 0, this, bl);
    }

    public void onSettingsChanged() {
        InvokeDynamicSupport.bootstrap("onSettingsChanged", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$onSettingsChanged(), 0, this);
    }

    public void performAccessibilityShortcut() {
        InvokeDynamicSupport.bootstrap("performAccessibilityShortcut", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$performAccessibilityShortcut(), 0, this);
    }

    private AlertDialog createShortcutWarningDialog(int n) {
        return InvokeDynamicSupport.bootstrap("createShortcutWarningDialog", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$createShortcutWarningDialog(int ), 0, this, n);
    }

    private AccessibilityServiceInfo getInfoForTargetService() {
        return InvokeDynamicSupport.bootstrap("getInfoForTargetService", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$getInfoForTargetService(), 0, this);
    }

    private String getShortcutFeatureDescription(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getShortcutFeatureDescription", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$getShortcutFeatureDescription(boolean ), 0, this, bl);
    }

    private boolean isServiceEnabled(AccessibilityServiceInfo accessibilityServiceInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("isServiceEnabled", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$isServiceEnabled(android.accessibilityservice.AccessibilityServiceInfo ), 0, this, accessibilityServiceInfo);
    }

    private boolean hasFeatureLeanback() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFeatureLeanback", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController$hasFeatureLeanback(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(AccessibilityShortcutController.class);
    }

    public /* synthetic */ AccessibilityShortcutController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityShortcutController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class FrameworkObjectProvider
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_FrameworkObjectProvider$__constructor__() {
        }

        private final AccessibilityManager $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_FrameworkObjectProvider$getAccessibilityManagerInstance(Context context) {
            return AccessibilityManager.getInstance(context);
        }

        private final AlertDialog.Builder $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_FrameworkObjectProvider$getAlertDialogBuilder(Context context) {
            return new AlertDialog.Builder(context);
        }

        private final Toast $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_FrameworkObjectProvider$makeToastFromText(Context context, CharSequence charSequence, int duration) {
            return Toast.makeText(context, charSequence, duration);
        }

        private final Context $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_FrameworkObjectProvider$getSystemUiContext() {
            return ActivityThread.currentActivityThread().getSystemUiContext();
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_accessibility_AccessibilityShortcutController_FrameworkObjectProvider$__constructor__();
        }

        public FrameworkObjectProvider() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_FrameworkObjectProvider$__constructor__(), 0, this);
        }

        public AccessibilityManager getAccessibilityManagerInstance(Context context) {
            return InvokeDynamicSupport.bootstrap("getAccessibilityManagerInstance", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_FrameworkObjectProvider$getAccessibilityManagerInstance(android.content.Context ), 0, this, context);
        }

        public AlertDialog.Builder getAlertDialogBuilder(Context context) {
            return InvokeDynamicSupport.bootstrap("getAlertDialogBuilder", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_FrameworkObjectProvider$getAlertDialogBuilder(android.content.Context ), 0, this, context);
        }

        public Toast makeToastFromText(Context context, CharSequence charSequence, int n) {
            return InvokeDynamicSupport.bootstrap("makeToastFromText", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_FrameworkObjectProvider$makeToastFromText(android.content.Context java.lang.CharSequence int ), 0, this, context, charSequence, n);
        }

        public Context getSystemUiContext() {
            return InvokeDynamicSupport.bootstrap("getSystemUiContext", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_FrameworkObjectProvider$getSystemUiContext(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FrameworkObjectProvider)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ToggleableFrameworkFeatureInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mSettingKey;
        private String mSettingOnValue;
        private String mSettingOffValue;
        private int mLabelStringResourceId;
        private int mIconDrawableId;

        private void $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_ToggleableFrameworkFeatureInfo$__constructor__(String settingKey, String settingOnValue, String settingOffValue, int labelStringResourceId) {
            this.mSettingKey = settingKey;
            this.mSettingOnValue = settingOnValue;
            this.mSettingOffValue = settingOffValue;
            this.mLabelStringResourceId = labelStringResourceId;
        }

        private final String $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_ToggleableFrameworkFeatureInfo$getSettingKey() {
            return this.mSettingKey;
        }

        private final String $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_ToggleableFrameworkFeatureInfo$getSettingOnValue() {
            return this.mSettingOnValue;
        }

        private final String $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_ToggleableFrameworkFeatureInfo$getSettingOffValue() {
            return this.mSettingOffValue;
        }

        private final String $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_ToggleableFrameworkFeatureInfo$getLabel(Context context) {
            return context.getString(this.mLabelStringResourceId);
        }

        private void __constructor__(String string2, String string3, String string4, int n) {
            this.$$robo$$com_android_internal_accessibility_AccessibilityShortcutController_ToggleableFrameworkFeatureInfo$__constructor__(string2, string3, string4, n);
        }

        ToggleableFrameworkFeatureInfo(String string2, String string3, String string4, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_ToggleableFrameworkFeatureInfo$__constructor__(java.lang.String java.lang.String java.lang.String int ), 0, this, string2, string3, string4, n);
        }

        public String getSettingKey() {
            return InvokeDynamicSupport.bootstrap("getSettingKey", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_ToggleableFrameworkFeatureInfo$getSettingKey(), 0, this);
        }

        public String getSettingOnValue() {
            return InvokeDynamicSupport.bootstrap("getSettingOnValue", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_ToggleableFrameworkFeatureInfo$getSettingOnValue(), 0, this);
        }

        public String getSettingOffValue() {
            return InvokeDynamicSupport.bootstrap("getSettingOffValue", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_ToggleableFrameworkFeatureInfo$getSettingOffValue(), 0, this);
        }

        public String getLabel(Context context) {
            return InvokeDynamicSupport.bootstrap("getLabel", $$robo$$com_android_internal_accessibility_AccessibilityShortcutController_ToggleableFrameworkFeatureInfo$getLabel(android.content.Context ), 0, this, context);
        }

        public /* synthetic */ ToggleableFrameworkFeatureInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ToggleableFrameworkFeatureInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

