/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.alsa;

import android.util.Slog;
import com.android.internal.alsa.LineTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AlsaCardsParser
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AlsaCardsParser";
    protected static boolean DEBUG = false;
    private static String kAlsaFolderPath = "/proc/asound";
    private static String kCardsFilePath = "/proc/asound/cards";
    private static String kDeviceAddressPrefix = "/dev/bus/usb/";
    private static LineTokenizer mTokenizer;
    private ArrayList<AlsaCardRecord> mCardRecords;
    public static int SCANSTATUS_NOTSCANNED = -1;
    public static int SCANSTATUS_SUCCESS = 0;
    public static int SCANSTATUS_FAIL = 1;
    public static int SCANSTATUS_EMPTY = 2;
    private int mScanStatus;

    private void $$robo$$com_android_internal_alsa_AlsaCardsParser$__constructor__() {
        this.mCardRecords = new ArrayList();
        this.mScanStatus = -1;
    }

    private final int $$robo$$com_android_internal_alsa_AlsaCardsParser$scan() {
        this.mCardRecords = new ArrayList();
        File cardsFile = new File("/proc/asound/cards");
        try {
            FileReader reader = new FileReader(cardsFile);
            BufferedReader bufferedReader = new BufferedReader(reader);
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                AlsaCardRecord cardRecord = new AlsaCardRecord(this);
                cardRecord.parse(line, 0);
                line = bufferedReader.readLine();
                if (line == null) break;
                cardRecord.parse(line, 1);
                int cardNum = cardRecord.mCardNum;
                String cardFolderPath = "/proc/asound/card" + cardNum;
                File usbbusFile = new File(cardFolderPath + "/usbbus");
                if (usbbusFile.exists()) {
                    FileReader usbbusReader = new FileReader(usbbusFile);
                    String deviceAddress = new BufferedReader(usbbusReader).readLine();
                    if (deviceAddress != null) {
                        cardRecord.setDeviceAddress("/dev/bus/usb/" + deviceAddress);
                    }
                    usbbusReader.close();
                }
                this.mCardRecords.add(cardRecord);
            }
            reader.close();
            this.mScanStatus = this.mCardRecords.size() > 0 ? 0 : 2;
        }
        catch (FileNotFoundException e) {
            this.mScanStatus = 1;
        }
        catch (IOException e) {
            this.mScanStatus = 1;
        }
        return this.mScanStatus;
    }

    private final int $$robo$$com_android_internal_alsa_AlsaCardsParser$getScanStatus() {
        return this.mScanStatus;
    }

    private final AlsaCardRecord $$robo$$com_android_internal_alsa_AlsaCardsParser$findCardNumFor(String deviceAddress) {
        for (AlsaCardRecord cardRec : this.mCardRecords) {
            if (!cardRec.isUsb() || !cardRec.mUsbDeviceAddress.equals(deviceAddress)) continue;
            return cardRec;
        }
        return null;
    }

    private final void $$robo$$com_android_internal_alsa_AlsaCardsParser$Log(String heading) {
    }

    static void __staticInitializer__() {
        mTokenizer = new LineTokenizer(" :[]");
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_alsa_AlsaCardsParser$__constructor__();
    }

    public AlsaCardsParser() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_alsa_AlsaCardsParser$__constructor__(), 0, this);
    }

    public int scan() {
        return (int)InvokeDynamicSupport.bootstrap("scan", $$robo$$com_android_internal_alsa_AlsaCardsParser$scan(), 0, this);
    }

    public int getScanStatus() {
        return (int)InvokeDynamicSupport.bootstrap("getScanStatus", $$robo$$com_android_internal_alsa_AlsaCardsParser$getScanStatus(), 0, this);
    }

    public AlsaCardRecord findCardNumFor(String string2) {
        return InvokeDynamicSupport.bootstrap("findCardNumFor", $$robo$$com_android_internal_alsa_AlsaCardsParser$findCardNumFor(java.lang.String ), 0, this, string2);
    }

    private void Log(String string2) {
        InvokeDynamicSupport.bootstrap("Log", $$robo$$com_android_internal_alsa_AlsaCardsParser$Log(java.lang.String ), 0, this, string2);
    }

    static {
        RobolectricInternals.classInitializing(AlsaCardsParser.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AlsaCardsParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class AlsaCardRecord
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String TAG = "AlsaCardRecord";
        private static String kUsbCardKeyStr = "at usb-";
        int mCardNum;
        String mField1;
        String mCardName;
        String mCardDescription;
        private String mUsbDeviceAddress;
        /* synthetic */ AlsaCardsParser this$0;

        private void $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$__constructor__(AlsaCardsParser this$0) {
            this.mCardNum = -1;
            this.mField1 = "";
            this.mCardName = "";
            this.mCardDescription = "";
            this.mUsbDeviceAddress = null;
        }

        private final int $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$getCardNum() {
            return this.mCardNum;
        }

        private final String $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$getCardName() {
            return this.mCardName;
        }

        private final String $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$getCardDescription() {
            return this.mCardDescription;
        }

        private final void $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$setDeviceAddress(String usbDeviceAddress) {
            this.mUsbDeviceAddress = usbDeviceAddress;
        }

        private final boolean $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$parse(String line, int lineIndex) {
            int tokenIndex = 0;
            int delimIndex = 0;
            if (lineIndex == 0) {
                tokenIndex = mTokenizer.nextToken(line, tokenIndex);
                delimIndex = mTokenizer.nextDelimiter(line, tokenIndex);
                try {
                    this.mCardNum = Integer.parseInt(line.substring(tokenIndex, delimIndex));
                }
                catch (NumberFormatException e) {
                    Slog.e("AlsaCardRecord", "Failed to parse line " + lineIndex + " of " + "/proc/asound/cards" + ": " + line.substring(tokenIndex, delimIndex));
                    return false;
                }
                tokenIndex = mTokenizer.nextToken(line, delimIndex);
                delimIndex = mTokenizer.nextDelimiter(line, tokenIndex);
                this.mField1 = line.substring(tokenIndex, delimIndex);
                tokenIndex = mTokenizer.nextToken(line, delimIndex);
                this.mCardName = line.substring(tokenIndex);
            } else if (lineIndex == 1 && (tokenIndex = mTokenizer.nextToken(line, 0)) != -1) {
                boolean isUsb;
                int keyIndex = line.indexOf("at usb-");
                boolean bl = isUsb = keyIndex != -1;
                if (isUsb) {
                    this.mCardDescription = line.substring(tokenIndex, keyIndex - 1);
                }
            }
            return true;
        }

        private final boolean $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$isUsb() {
            return this.mUsbDeviceAddress != null;
        }

        private final String $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$textFormat() {
            return this.mCardName + " : " + this.mCardDescription + " [addr:" + this.mUsbDeviceAddress + "]";
        }

        private final void $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$log(int listIndex) {
            Slog.d("AlsaCardRecord", "" + listIndex + " [" + this.mCardNum + " " + this.mCardName + " : " + this.mCardDescription + " usb:" + this.isUsb());
        }

        private void __constructor__(AlsaCardsParser alsaCardsParser) {
            this.$$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$__constructor__(alsaCardsParser);
        }

        public AlsaCardRecord(AlsaCardsParser alsaCardsParser) {
            this.this$0 = alsaCardsParser;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$__constructor__(com.android.internal.alsa.AlsaCardsParser ), 0, this, alsaCardsParser);
        }

        public int getCardNum() {
            return (int)InvokeDynamicSupport.bootstrap("getCardNum", $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$getCardNum(), 0, this);
        }

        public String getCardName() {
            return InvokeDynamicSupport.bootstrap("getCardName", $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$getCardName(), 0, this);
        }

        public String getCardDescription() {
            return InvokeDynamicSupport.bootstrap("getCardDescription", $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$getCardDescription(), 0, this);
        }

        public void setDeviceAddress(String string2) {
            InvokeDynamicSupport.bootstrap("setDeviceAddress", $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$setDeviceAddress(java.lang.String ), 0, this, string2);
        }

        private boolean parse(String string2, int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("parse", $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$parse(java.lang.String int ), 0, this, string2, n);
        }

        boolean isUsb() {
            return (boolean)InvokeDynamicSupport.bootstrap("isUsb", $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$isUsb(), 0, this);
        }

        public String textFormat() {
            return InvokeDynamicSupport.bootstrap("textFormat", $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$textFormat(), 0, this);
        }

        public void log(int n) {
            InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_alsa_AlsaCardsParser_AlsaCardRecord$log(int ), 0, this, n);
        }

        public /* synthetic */ AlsaCardRecord() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AlsaCardRecord)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

