/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.metrics.LogMaker;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.Slog;
import com.android.internal.logging.MetricsLogger;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ColorDisplayController
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ColorDisplayController";
    private static boolean DEBUG = false;
    public static int AUTO_MODE_DISABLED = 0;
    public static int AUTO_MODE_CUSTOM = 1;
    public static int AUTO_MODE_TWILIGHT = 2;
    public static int COLOR_MODE_NATURAL = 0;
    public static int COLOR_MODE_BOOSTED = 1;
    public static int COLOR_MODE_SATURATED = 2;
    public static int COLOR_MODE_AUTOMATIC = 3;
    private Context mContext;
    private int mUserId;
    private ContentObserver mContentObserver;
    private Callback mCallback;
    private MetricsLogger mMetricsLogger;

    private void $$robo$$com_android_internal_app_ColorDisplayController$__constructor__(Context context) {
    }

    private void $$robo$$com_android_internal_app_ColorDisplayController$__constructor__(Context context, int userId) {
        this.mContext = context.getApplicationContext();
        this.mUserId = userId;
        this.mContentObserver = new ShadowedObject(this, new Handler(Looper.getMainLooper())){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ColorDisplayController this$0;

            private void $$robo$$com_android_internal_app_ColorDisplayController_1$__constructor__(ColorDisplayController this$0, Handler x0) {
            }

            private final void $$robo$$com_android_internal_app_ColorDisplayController_1$onChange(boolean selfChange, Uri uri) {
                String setting;
                super.onChange(selfChange, uri);
                String string2 = setting = uri == null ? null : uri.getLastPathSegment();
                if (setting != null) {
                    this.this$0.onSettingChanged(setting);
                }
            }

            private void __constructor__(ColorDisplayController colorDisplayController, Handler handler) {
                this.$$robo$$com_android_internal_app_ColorDisplayController_1$__constructor__(colorDisplayController, handler);
            }
            {
                this.this$0 = colorDisplayController;
                super(handler);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ColorDisplayController_1$__constructor__(com.android.internal.app.ColorDisplayController android.os.Handler ), 0, this, colorDisplayController, handler);
            }

            @Override
            public void onChange(boolean bl, Uri uri) {
                InvokeDynamicSupport.bootstrap("onChange", $$robo$$com_android_internal_app_ColorDisplayController_1$onChange(boolean android.net.Uri ), 0, this, bl, uri);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final boolean $$robo$$com_android_internal_app_ColorDisplayController$isActivated() {
        return Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "night_display_activated", 0, this.mUserId) == 1;
    }

    private final boolean $$robo$$com_android_internal_app_ColorDisplayController$setActivated(boolean activated) {
        if (this.isActivated() != activated) {
            Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "night_display_last_activated_time", LocalDateTime.now().toString(), this.mUserId);
        }
        return Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "night_display_activated", activated ? 1 : 0, this.mUserId);
    }

    private final LocalDateTime $$robo$$com_android_internal_app_ColorDisplayController$getLastActivatedTime() {
        ContentResolver cr = this.mContext.getContentResolver();
        String lastActivatedTime = Settings.Secure.getStringForUser(cr, "night_display_last_activated_time", this.mUserId);
        if (lastActivatedTime != null) {
            try {
                return LocalDateTime.parse(lastActivatedTime);
            }
            catch (DateTimeParseException dateTimeParseException) {
                try {
                    return LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(lastActivatedTime)), ZoneId.systemDefault());
                }
                catch (NumberFormatException | DateTimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private final int $$robo$$com_android_internal_app_ColorDisplayController$getAutoMode() {
        int autoMode = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "night_display_auto_mode", -1, this.mUserId);
        if (autoMode == -1) {
            autoMode = this.mContext.getResources().getInteger(17694765);
        }
        if (autoMode != 0 && autoMode != 1 && autoMode != 2) {
            Slog.e("ColorDisplayController", "Invalid autoMode: " + autoMode);
            autoMode = 0;
        }
        return autoMode;
    }

    private final int $$robo$$com_android_internal_app_ColorDisplayController$getAutoModeRaw() {
        return Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "night_display_auto_mode", -1, this.mUserId);
    }

    private final boolean $$robo$$com_android_internal_app_ColorDisplayController$setAutoMode(int autoMode) {
        if (autoMode != 0 && autoMode != 1 && autoMode != 2) {
            throw new IllegalArgumentException("Invalid autoMode: " + autoMode);
        }
        if (this.getAutoMode() != autoMode) {
            Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "night_display_last_activated_time", null, this.mUserId);
            this.getMetricsLogger().write(new LogMaker(1309).setType(4).setSubtype(autoMode));
        }
        return Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "night_display_auto_mode", autoMode, this.mUserId);
    }

    private final LocalTime $$robo$$com_android_internal_app_ColorDisplayController$getCustomStartTime() {
        int startTimeValue = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "night_display_custom_start_time", -1, this.mUserId);
        if (startTimeValue == -1) {
            startTimeValue = this.mContext.getResources().getInteger(17694767);
        }
        return LocalTime.ofSecondOfDay(startTimeValue / 1000);
    }

    private final boolean $$robo$$com_android_internal_app_ColorDisplayController$setCustomStartTime(LocalTime startTime) {
        if (startTime == null) {
            throw new IllegalArgumentException("startTime cannot be null");
        }
        this.getMetricsLogger().write(new LogMaker(1310).setType(4).setSubtype(0));
        return Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "night_display_custom_start_time", startTime.toSecondOfDay() * 1000, this.mUserId);
    }

    private final LocalTime $$robo$$com_android_internal_app_ColorDisplayController$getCustomEndTime() {
        int endTimeValue = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "night_display_custom_end_time", -1, this.mUserId);
        if (endTimeValue == -1) {
            endTimeValue = this.mContext.getResources().getInteger(17694766);
        }
        return LocalTime.ofSecondOfDay(endTimeValue / 1000);
    }

    private final boolean $$robo$$com_android_internal_app_ColorDisplayController$setCustomEndTime(LocalTime endTime) {
        if (endTime == null) {
            throw new IllegalArgumentException("endTime cannot be null");
        }
        this.getMetricsLogger().write(new LogMaker(1310).setType(4).setSubtype(1));
        return Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "night_display_custom_end_time", endTime.toSecondOfDay() * 1000, this.mUserId);
    }

    private final int $$robo$$com_android_internal_app_ColorDisplayController$getColorTemperature() {
        int colorTemperature = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "night_display_color_temperature", -1, this.mUserId);
        if (colorTemperature == -1) {
            colorTemperature = this.getDefaultColorTemperature();
        }
        int minimumTemperature = this.getMinimumColorTemperature();
        int maximumTemperature = this.getMaximumColorTemperature();
        if (colorTemperature < minimumTemperature) {
            colorTemperature = minimumTemperature;
        } else if (colorTemperature > maximumTemperature) {
            colorTemperature = maximumTemperature;
        }
        return colorTemperature;
    }

    private final boolean $$robo$$com_android_internal_app_ColorDisplayController$setColorTemperature(int colorTemperature) {
        return Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "night_display_color_temperature", colorTemperature, this.mUserId);
    }

    private final int $$robo$$com_android_internal_app_ColorDisplayController$getCurrentColorModeFromSystemProperties() {
        int displayColorSetting = SystemProperties.getInt("persist.sys.sf.native_mode", 0);
        if (displayColorSetting == 0) {
            return "1.0".equals(SystemProperties.get("persist.sys.sf.color_saturation")) ? 0 : 1;
        }
        if (displayColorSetting == 1) {
            return 2;
        }
        if (displayColorSetting == 2) {
            return 3;
        }
        return -1;
    }

    private final boolean $$robo$$com_android_internal_app_ColorDisplayController$isColorModeAvailable(int colorMode) {
        int[] availableColorModes = this.mContext.getResources().getIntArray(17235987);
        if (availableColorModes != null) {
            for (int mode : availableColorModes) {
                if (mode != colorMode) continue;
                return true;
            }
        }
        return false;
    }

    private final int $$robo$$com_android_internal_app_ColorDisplayController$getColorMode() {
        int colorMode;
        if (this.getAccessibilityTransformActivated()) {
            if (this.isColorModeAvailable(2)) {
                return 2;
            }
            if (this.isColorModeAvailable(3)) {
                return 3;
            }
        }
        if ((colorMode = Settings.System.getIntForUser(this.mContext.getContentResolver(), "display_color_mode", -1, this.mUserId)) == -1) {
            colorMode = this.getCurrentColorModeFromSystemProperties();
        }
        if (!this.isColorModeAvailable(colorMode)) {
            colorMode = colorMode == 1 && this.isColorModeAvailable(0) ? 0 : (colorMode == 2 && this.isColorModeAvailable(3) ? 3 : (colorMode == 3 && this.isColorModeAvailable(2) ? 2 : -1));
        }
        return colorMode;
    }

    private final void $$robo$$com_android_internal_app_ColorDisplayController$setColorMode(int colorMode) {
        if (!this.isColorModeAvailable(colorMode)) {
            throw new IllegalArgumentException("Invalid colorMode: " + colorMode);
        }
        Settings.System.putIntForUser(this.mContext.getContentResolver(), "display_color_mode", colorMode, this.mUserId);
    }

    private final int $$robo$$com_android_internal_app_ColorDisplayController$getMinimumColorTemperature() {
        return this.mContext.getResources().getInteger(17694835);
    }

    private final int $$robo$$com_android_internal_app_ColorDisplayController$getMaximumColorTemperature() {
        return this.mContext.getResources().getInteger(17694834);
    }

    private final int $$robo$$com_android_internal_app_ColorDisplayController$getDefaultColorTemperature() {
        return this.mContext.getResources().getInteger(17694833);
    }

    private final boolean $$robo$$com_android_internal_app_ColorDisplayController$getAccessibilityTransformActivated() {
        ContentResolver cr = this.mContext.getContentResolver();
        return Settings.Secure.getIntForUser(cr, "accessibility_display_inversion_enabled", 0, this.mUserId) == 1 || Settings.Secure.getIntForUser(cr, "accessibility_display_daltonizer_enabled", 0, this.mUserId) == 1;
    }

    private final void $$robo$$com_android_internal_app_ColorDisplayController$onSettingChanged(String setting) {
        if (this.mCallback != null) {
            switch (setting) {
                case "night_display_activated": {
                    this.mCallback.onActivated(this.isActivated());
                    break;
                }
                case "night_display_auto_mode": {
                    this.mCallback.onAutoModeChanged(this.getAutoMode());
                    break;
                }
                case "night_display_custom_start_time": {
                    this.mCallback.onCustomStartTimeChanged(this.getCustomStartTime());
                    break;
                }
                case "night_display_custom_end_time": {
                    this.mCallback.onCustomEndTimeChanged(this.getCustomEndTime());
                    break;
                }
                case "night_display_color_temperature": {
                    this.mCallback.onColorTemperatureChanged(this.getColorTemperature());
                    break;
                }
                case "display_color_mode": {
                    this.mCallback.onDisplayColorModeChanged(this.getColorMode());
                    break;
                }
                case "accessibility_display_inversion_enabled": 
                case "accessibility_display_daltonizer_enabled": {
                    this.mCallback.onAccessibilityTransformChanged(this.getAccessibilityTransformActivated());
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_app_ColorDisplayController$setListener(Callback callback) {
        Callback oldCallback = this.mCallback;
        if (oldCallback != callback) {
            this.mCallback = callback;
            if (callback == null) {
                this.mContext.getContentResolver().unregisterContentObserver(this.mContentObserver);
            } else if (oldCallback == null) {
                ContentResolver cr = this.mContext.getContentResolver();
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_activated"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_auto_mode"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_custom_start_time"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_custom_end_time"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_color_temperature"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.System.getUriFor("display_color_mode"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.Secure.getUriFor("accessibility_display_inversion_enabled"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.Secure.getUriFor("accessibility_display_daltonizer_enabled"), false, this.mContentObserver, this.mUserId);
            }
        }
    }

    private final MetricsLogger $$robo$$com_android_internal_app_ColorDisplayController$getMetricsLogger() {
        if (this.mMetricsLogger == null) {
            this.mMetricsLogger = new MetricsLogger();
        }
        return this.mMetricsLogger;
    }

    private static final boolean $$robo$$com_android_internal_app_ColorDisplayController$isAvailable(Context context) {
        return context.getResources().getBoolean(17956997);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_app_ColorDisplayController$__constructor__(context);
    }

    public ColorDisplayController(Context context) {
        this(context, ActivityManager.getCurrentUser());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ColorDisplayController$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, int n) {
        this.$$robo$$com_android_internal_app_ColorDisplayController$__constructor__(context, n);
    }

    public ColorDisplayController(Context context, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ColorDisplayController$__constructor__(android.content.Context int ), 0, this, context, n);
    }

    public boolean isActivated() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActivated", $$robo$$com_android_internal_app_ColorDisplayController$isActivated(), 0, this);
    }

    public boolean setActivated(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setActivated", $$robo$$com_android_internal_app_ColorDisplayController$setActivated(boolean ), 0, this, bl);
    }

    public LocalDateTime getLastActivatedTime() {
        return InvokeDynamicSupport.bootstrap("getLastActivatedTime", $$robo$$com_android_internal_app_ColorDisplayController$getLastActivatedTime(), 0, this);
    }

    public int getAutoMode() {
        return (int)InvokeDynamicSupport.bootstrap("getAutoMode", $$robo$$com_android_internal_app_ColorDisplayController$getAutoMode(), 0, this);
    }

    public int getAutoModeRaw() {
        return (int)InvokeDynamicSupport.bootstrap("getAutoModeRaw", $$robo$$com_android_internal_app_ColorDisplayController$getAutoModeRaw(), 0, this);
    }

    public boolean setAutoMode(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setAutoMode", $$robo$$com_android_internal_app_ColorDisplayController$setAutoMode(int ), 0, this, n);
    }

    public LocalTime getCustomStartTime() {
        return InvokeDynamicSupport.bootstrap("getCustomStartTime", $$robo$$com_android_internal_app_ColorDisplayController$getCustomStartTime(), 0, this);
    }

    public boolean setCustomStartTime(LocalTime localTime) {
        return (boolean)InvokeDynamicSupport.bootstrap("setCustomStartTime", $$robo$$com_android_internal_app_ColorDisplayController$setCustomStartTime(java.time.LocalTime ), 0, this, localTime);
    }

    public LocalTime getCustomEndTime() {
        return InvokeDynamicSupport.bootstrap("getCustomEndTime", $$robo$$com_android_internal_app_ColorDisplayController$getCustomEndTime(), 0, this);
    }

    public boolean setCustomEndTime(LocalTime localTime) {
        return (boolean)InvokeDynamicSupport.bootstrap("setCustomEndTime", $$robo$$com_android_internal_app_ColorDisplayController$setCustomEndTime(java.time.LocalTime ), 0, this, localTime);
    }

    public int getColorTemperature() {
        return (int)InvokeDynamicSupport.bootstrap("getColorTemperature", $$robo$$com_android_internal_app_ColorDisplayController$getColorTemperature(), 0, this);
    }

    public boolean setColorTemperature(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setColorTemperature", $$robo$$com_android_internal_app_ColorDisplayController$setColorTemperature(int ), 0, this, n);
    }

    private int getCurrentColorModeFromSystemProperties() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentColorModeFromSystemProperties", $$robo$$com_android_internal_app_ColorDisplayController$getCurrentColorModeFromSystemProperties(), 0, this);
    }

    private boolean isColorModeAvailable(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isColorModeAvailable", $$robo$$com_android_internal_app_ColorDisplayController$isColorModeAvailable(int ), 0, this, n);
    }

    public int getColorMode() {
        return (int)InvokeDynamicSupport.bootstrap("getColorMode", $$robo$$com_android_internal_app_ColorDisplayController$getColorMode(), 0, this);
    }

    public void setColorMode(int n) {
        InvokeDynamicSupport.bootstrap("setColorMode", $$robo$$com_android_internal_app_ColorDisplayController$setColorMode(int ), 0, this, n);
    }

    public int getMinimumColorTemperature() {
        return (int)InvokeDynamicSupport.bootstrap("getMinimumColorTemperature", $$robo$$com_android_internal_app_ColorDisplayController$getMinimumColorTemperature(), 0, this);
    }

    public int getMaximumColorTemperature() {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumColorTemperature", $$robo$$com_android_internal_app_ColorDisplayController$getMaximumColorTemperature(), 0, this);
    }

    public int getDefaultColorTemperature() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultColorTemperature", $$robo$$com_android_internal_app_ColorDisplayController$getDefaultColorTemperature(), 0, this);
    }

    public boolean getAccessibilityTransformActivated() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAccessibilityTransformActivated", $$robo$$com_android_internal_app_ColorDisplayController$getAccessibilityTransformActivated(), 0, this);
    }

    private void onSettingChanged(String string2) {
        InvokeDynamicSupport.bootstrap("onSettingChanged", $$robo$$com_android_internal_app_ColorDisplayController$onSettingChanged(java.lang.String ), 0, this, string2);
    }

    public void setListener(Callback callback) {
        InvokeDynamicSupport.bootstrap("setListener", $$robo$$com_android_internal_app_ColorDisplayController$setListener(com.android.internal.app.ColorDisplayController$Callback ), 0, this, callback);
    }

    private MetricsLogger getMetricsLogger() {
        return InvokeDynamicSupport.bootstrap("getMetricsLogger", $$robo$$com_android_internal_app_ColorDisplayController$getMetricsLogger(), 0, this);
    }

    public static boolean isAvailable(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAvailable", $$robo$$com_android_internal_app_ColorDisplayController$isAvailable(android.content.Context ), 0, (Context)context);
    }

    public /* synthetic */ ColorDisplayController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ColorDisplayController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface Callback
    extends InstrumentedInterface {
        default public void onActivated(boolean activated) {
        }

        default public void onAutoModeChanged(int autoMode) {
        }

        default public void onCustomStartTimeChanged(LocalTime startTime) {
        }

        default public void onCustomEndTimeChanged(LocalTime endTime) {
        }

        default public void onColorTemperatureChanged(int colorTemperature) {
        }

        default public void onDisplayColorModeChanged(int displayColorMode) {
        }

        default public void onAccessibilityTransformChanged(boolean state) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ColorMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AutoMode {
    }
}

