/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.media.MediaRouter;
import android.os.Bundle;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MediaRouteControllerDialog
extends AlertDialog
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int VOLUME_UPDATE_DELAY_MILLIS = 250;
    private MediaRouter mRouter;
    private MediaRouterCallback mCallback;
    private MediaRouter.RouteInfo mRoute;
    private boolean mCreated;
    private Drawable mMediaRouteButtonDrawable;
    private int[] mMediaRouteConnectingState;
    private int[] mMediaRouteOnState;
    private Drawable mCurrentIconDrawable;
    private boolean mVolumeControlEnabled;
    private LinearLayout mVolumeLayout;
    private SeekBar mVolumeSlider;
    private boolean mVolumeSliderTouched;
    private View mControlView;
    private boolean mAttachedToWindow;

    private void $$robo$$com_android_internal_app_MediaRouteControllerDialog$__constructor__(Context context, int theme) {
        this.mMediaRouteConnectingState = new int[]{0x10100A0, 16842910};
        this.mMediaRouteOnState = new int[]{16843518, 16842910};
        this.mVolumeControlEnabled = true;
        this.mRouter = (MediaRouter)context.getSystemService("media_router");
        this.mCallback = new MediaRouterCallback(this);
        this.mRoute = this.mRouter.getSelectedRoute();
    }

    private final MediaRouter.RouteInfo $$robo$$com_android_internal_app_MediaRouteControllerDialog$getRoute() {
        return this.mRoute;
    }

    private final View $$robo$$com_android_internal_app_MediaRouteControllerDialog$onCreateMediaControlView(Bundle savedInstanceState) {
        return null;
    }

    private final View $$robo$$com_android_internal_app_MediaRouteControllerDialog$getMediaControlView() {
        return this.mControlView;
    }

    private final void $$robo$$com_android_internal_app_MediaRouteControllerDialog$setVolumeControlEnabled(boolean enable) {
        if (this.mVolumeControlEnabled != enable) {
            this.mVolumeControlEnabled = enable;
            if (this.mCreated) {
                this.updateVolume();
            }
        }
    }

    private final boolean $$robo$$com_android_internal_app_MediaRouteControllerDialog$isVolumeControlEnabled() {
        return this.mVolumeControlEnabled;
    }

    private final void $$robo$$com_android_internal_app_MediaRouteControllerDialog$onCreate(Bundle savedInstanceState) {
        this.setTitle(this.mRoute.getName());
        Resources res = this.getContext().getResources();
        this.setButton(-2, (CharSequence)res.getString(17040207), new DialogInterface.OnClickListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaRouteControllerDialog this$0;

            private void $$robo$$com_android_internal_app_MediaRouteControllerDialog_1$__constructor__(MediaRouteControllerDialog this$0) {
            }

            private final void $$robo$$com_android_internal_app_MediaRouteControllerDialog_1$onClick(DialogInterface dialogInterface, int id2) {
                if (this.this$0.mRoute.isSelected()) {
                    if (this.this$0.mRoute.isBluetooth()) {
                        this.this$0.mRouter.getDefaultRoute().select();
                    } else {
                        this.this$0.mRouter.getFallbackRoute().select();
                    }
                }
                this.this$0.dismiss();
            }

            private void __constructor__(MediaRouteControllerDialog mediaRouteControllerDialog) {
                this.$$robo$$com_android_internal_app_MediaRouteControllerDialog_1$__constructor__(mediaRouteControllerDialog);
            }
            {
                this.this$0 = mediaRouteControllerDialog;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_MediaRouteControllerDialog_1$__constructor__(com.android.internal.app.MediaRouteControllerDialog ), 0, this, mediaRouteControllerDialog);
            }

            @Override
            public void onClick(DialogInterface dialogInterface, int n) {
                InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_app_MediaRouteControllerDialog_1$onClick(android.content.DialogInterface int ), 0, this, dialogInterface, n);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        View customView = this.getLayoutInflater().inflate(17367175, null);
        this.setView(customView, 0, 0, 0, 0);
        super.onCreate(savedInstanceState);
        Object customPanelView = this.getWindow().findViewById(16908820);
        if (customPanelView != null) {
            ((View)customPanelView).setMinimumHeight(0);
        }
        this.mVolumeLayout = (LinearLayout)customView.findViewById(16909056);
        this.mVolumeSlider = (SeekBar)customView.findViewById(16909057);
        this.mVolumeSlider.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(this){
            public transient /* synthetic */ Object __robo_data__;
            private Runnable mStopTrackingTouch;
            /* synthetic */ MediaRouteControllerDialog this$0;

            private void $$robo$$com_android_internal_app_MediaRouteControllerDialog_2$__constructor__(MediaRouteControllerDialog this$0) {
                this.mStopTrackingTouch = new Runnable(this){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ 2 this$1;

                    private void $$robo$$com_android_internal_app_MediaRouteControllerDialog_2_1$__constructor__(2 this$1) {
                    }

                    private final void $$robo$$com_android_internal_app_MediaRouteControllerDialog_2_1$run() {
                        if (this.this$1.this$0.mVolumeSliderTouched) {
                            this.this$1.this$0.mVolumeSliderTouched = false;
                            this.this$1.this$0.updateVolume();
                        }
                    }

                    private void __constructor__(2 var1_1) {
                        this.$$robo$$com_android_internal_app_MediaRouteControllerDialog_2_1$__constructor__(var1_1);
                    }
                    {
                        this.this$1 = var1_1;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_MediaRouteControllerDialog_2_1$__constructor__(com.android.internal.app.MediaRouteControllerDialog$2 ), 0, this, var1_1);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_app_MediaRouteControllerDialog_2_1$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
            }

            private final void $$robo$$com_android_internal_app_MediaRouteControllerDialog_2$onStartTrackingTouch(SeekBar seekBar) {
                if (this.this$0.mVolumeSliderTouched) {
                    this.this$0.mVolumeSlider.removeCallbacks(this.mStopTrackingTouch);
                } else {
                    this.this$0.mVolumeSliderTouched = true;
                }
            }

            private final void $$robo$$com_android_internal_app_MediaRouteControllerDialog_2$onStopTrackingTouch(SeekBar seekBar) {
                this.this$0.mVolumeSlider.postDelayed(this.mStopTrackingTouch, 250L);
            }

            private final void $$robo$$com_android_internal_app_MediaRouteControllerDialog_2$onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (fromUser) {
                    this.this$0.mRoute.requestSetVolume(progress);
                }
            }

            private void __constructor__(MediaRouteControllerDialog mediaRouteControllerDialog) {
                this.$$robo$$com_android_internal_app_MediaRouteControllerDialog_2$__constructor__(mediaRouteControllerDialog);
            }
            {
                this.this$0 = mediaRouteControllerDialog;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_MediaRouteControllerDialog_2$__constructor__(com.android.internal.app.MediaRouteControllerDialog ), 0, this, mediaRouteControllerDialog);
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
                InvokeDynamicSupport.bootstrap("onStartTrackingTouch", $$robo$$com_android_internal_app_MediaRouteControllerDialog_2$onStartTrackingTouch(android.widget.SeekBar ), 0, this, seekBar);
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                InvokeDynamicSupport.bootstrap("onStopTrackingTouch", $$robo$$com_android_internal_app_MediaRouteControllerDialog_2$onStopTrackingTouch(android.widget.SeekBar ), 0, this, seekBar);
            }

            @Override
            public void onProgressChanged(SeekBar seekBar, int n, boolean bl) {
                InvokeDynamicSupport.bootstrap("onProgressChanged", $$robo$$com_android_internal_app_MediaRouteControllerDialog_2$onProgressChanged(android.widget.SeekBar int boolean ), 0, this, seekBar, n, bl);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.mMediaRouteButtonDrawable = this.obtainMediaRouteButtonDrawable();
        this.mCreated = true;
        if (this.update()) {
            this.mControlView = this.onCreateMediaControlView(savedInstanceState);
            FrameLayout controlFrame = (FrameLayout)customView.findViewById(16909053);
            if (this.mControlView != null) {
                controlFrame.addView(this.mControlView);
                controlFrame.setVisibility(0);
            } else {
                controlFrame.setVisibility(8);
            }
        }
    }

    private final void $$robo$$com_android_internal_app_MediaRouteControllerDialog$onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttachedToWindow = true;
        this.mRouter.addCallback(0, this.mCallback, 2);
        this.update();
    }

    private final void $$robo$$com_android_internal_app_MediaRouteControllerDialog$onDetachedFromWindow() {
        this.mRouter.removeCallback(this.mCallback);
        this.mAttachedToWindow = false;
        super.onDetachedFromWindow();
    }

    private final boolean $$robo$$com_android_internal_app_MediaRouteControllerDialog$onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 25 || keyCode == 24) {
            this.mRoute.requestUpdateVolume(keyCode == 25 ? -1 : 1);
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    private final boolean $$robo$$com_android_internal_app_MediaRouteControllerDialog$onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 25 || keyCode == 24) {
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    private final boolean $$robo$$com_android_internal_app_MediaRouteControllerDialog$update() {
        if (!this.mRoute.isSelected() || this.mRoute.isDefault()) {
            this.dismiss();
            return false;
        }
        this.setTitle(this.mRoute.getName());
        this.updateVolume();
        Drawable icon = this.getIconDrawable();
        if (icon != this.mCurrentIconDrawable) {
            this.mCurrentIconDrawable = icon;
            if (icon instanceof AnimationDrawable) {
                AnimationDrawable animDrawable = (AnimationDrawable)icon;
                if (!this.mAttachedToWindow && !this.mRoute.isConnecting()) {
                    if (animDrawable.isRunning()) {
                        animDrawable.stop();
                    }
                    icon = animDrawable.getFrame(animDrawable.getNumberOfFrames() - 1);
                } else if (!animDrawable.isRunning()) {
                    animDrawable.start();
                }
            }
            this.setIcon(icon);
        }
        return true;
    }

    private final Drawable $$robo$$com_android_internal_app_MediaRouteControllerDialog$obtainMediaRouteButtonDrawable() {
        Context context = this.getContext();
        TypedValue value = new TypedValue();
        if (!context.getTheme().resolveAttribute(16843693, value, true)) {
            return null;
        }
        int[] drawableAttrs = new int[]{17891378};
        TypedArray a = context.obtainStyledAttributes(value.data, drawableAttrs);
        Drawable drawable2 = a.getDrawable(0);
        a.recycle();
        return drawable2;
    }

    private final Drawable $$robo$$com_android_internal_app_MediaRouteControllerDialog$getIconDrawable() {
        if (!(this.mMediaRouteButtonDrawable instanceof StateListDrawable)) {
            return this.mMediaRouteButtonDrawable;
        }
        if (this.mRoute.isConnecting()) {
            StateListDrawable stateListDrawable = (StateListDrawable)this.mMediaRouteButtonDrawable;
            stateListDrawable.setState(this.mMediaRouteConnectingState);
            return stateListDrawable.getCurrent();
        }
        StateListDrawable stateListDrawable = (StateListDrawable)this.mMediaRouteButtonDrawable;
        stateListDrawable.setState(this.mMediaRouteOnState);
        return stateListDrawable.getCurrent();
    }

    private final void $$robo$$com_android_internal_app_MediaRouteControllerDialog$updateVolume() {
        if (!this.mVolumeSliderTouched) {
            if (this.isVolumeControlAvailable()) {
                this.mVolumeLayout.setVisibility(0);
                this.mVolumeSlider.setMax(this.mRoute.getVolumeMax());
                this.mVolumeSlider.setProgress(this.mRoute.getVolume());
            } else {
                this.mVolumeLayout.setVisibility(8);
            }
        }
    }

    private final boolean $$robo$$com_android_internal_app_MediaRouteControllerDialog$isVolumeControlAvailable() {
        return this.mVolumeControlEnabled && this.mRoute.getVolumeHandling() == 1;
    }

    private void __constructor__(Context context, int n) {
        this.$$robo$$com_android_internal_app_MediaRouteControllerDialog$__constructor__(context, n);
    }

    public MediaRouteControllerDialog(Context context, int n) {
        super(context, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_MediaRouteControllerDialog$__constructor__(android.content.Context int ), 0, this, context, n);
    }

    public MediaRouter.RouteInfo getRoute() {
        return InvokeDynamicSupport.bootstrap("getRoute", $$robo$$com_android_internal_app_MediaRouteControllerDialog$getRoute(), 0, this);
    }

    public View onCreateMediaControlView(Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("onCreateMediaControlView", $$robo$$com_android_internal_app_MediaRouteControllerDialog$onCreateMediaControlView(android.os.Bundle ), 0, this, bundle);
    }

    public View getMediaControlView() {
        return InvokeDynamicSupport.bootstrap("getMediaControlView", $$robo$$com_android_internal_app_MediaRouteControllerDialog$getMediaControlView(), 0, this);
    }

    public void setVolumeControlEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setVolumeControlEnabled", $$robo$$com_android_internal_app_MediaRouteControllerDialog$setVolumeControlEnabled(boolean ), 0, this, bl);
    }

    public boolean isVolumeControlEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVolumeControlEnabled", $$robo$$com_android_internal_app_MediaRouteControllerDialog$isVolumeControlEnabled(), 0, this);
    }

    @Override
    protected void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_app_MediaRouteControllerDialog$onCreate(android.os.Bundle ), 0, this, bundle);
    }

    @Override
    public void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$com_android_internal_app_MediaRouteControllerDialog$onAttachedToWindow(), 0, this);
    }

    @Override
    public void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$com_android_internal_app_MediaRouteControllerDialog$onDetachedFromWindow(), 0, this);
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$com_android_internal_app_MediaRouteControllerDialog$onKeyDown(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyUp", $$robo$$com_android_internal_app_MediaRouteControllerDialog$onKeyUp(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    private boolean update() {
        return (boolean)InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_app_MediaRouteControllerDialog$update(), 0, this);
    }

    private Drawable obtainMediaRouteButtonDrawable() {
        return InvokeDynamicSupport.bootstrap("obtainMediaRouteButtonDrawable", $$robo$$com_android_internal_app_MediaRouteControllerDialog$obtainMediaRouteButtonDrawable(), 0, this);
    }

    private Drawable getIconDrawable() {
        return InvokeDynamicSupport.bootstrap("getIconDrawable", $$robo$$com_android_internal_app_MediaRouteControllerDialog$getIconDrawable(), 0, this);
    }

    private void updateVolume() {
        InvokeDynamicSupport.bootstrap("updateVolume", $$robo$$com_android_internal_app_MediaRouteControllerDialog$updateVolume(), 0, this);
    }

    private boolean isVolumeControlAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVolumeControlAvailable", $$robo$$com_android_internal_app_MediaRouteControllerDialog$isVolumeControlAvailable(), 0, this);
    }

    public /* synthetic */ MediaRouteControllerDialog() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaRouteControllerDialog)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class MediaRouterCallback
    extends MediaRouter.SimpleCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ MediaRouteControllerDialog this$0;

        private void $$robo$$com_android_internal_app_MediaRouteControllerDialog_MediaRouterCallback$__constructor__(MediaRouteControllerDialog mediaRouteControllerDialog) {
        }

        private final void $$robo$$com_android_internal_app_MediaRouteControllerDialog_MediaRouterCallback$onRouteUnselected(MediaRouter router, int type, MediaRouter.RouteInfo info) {
            this.this$0.update();
        }

        private final void $$robo$$com_android_internal_app_MediaRouteControllerDialog_MediaRouterCallback$onRouteChanged(MediaRouter router, MediaRouter.RouteInfo route) {
            this.this$0.update();
        }

        private final void $$robo$$com_android_internal_app_MediaRouteControllerDialog_MediaRouterCallback$onRouteVolumeChanged(MediaRouter router, MediaRouter.RouteInfo route) {
            if (route == this.this$0.mRoute) {
                this.this$0.updateVolume();
            }
        }

        private final void $$robo$$com_android_internal_app_MediaRouteControllerDialog_MediaRouterCallback$onRouteGrouped(MediaRouter router, MediaRouter.RouteInfo info, MediaRouter.RouteGroup group, int index) {
            this.this$0.update();
        }

        private final void $$robo$$com_android_internal_app_MediaRouteControllerDialog_MediaRouterCallback$onRouteUngrouped(MediaRouter router, MediaRouter.RouteInfo info, MediaRouter.RouteGroup group) {
            this.this$0.update();
        }

        private /* synthetic */ void $$robo$$com_android_internal_app_MediaRouteControllerDialog_MediaRouterCallback$__constructor__(MediaRouteControllerDialog x0, 1 x1) {
        }

        private void __constructor__(MediaRouteControllerDialog mediaRouteControllerDialog) {
            this.$$robo$$com_android_internal_app_MediaRouteControllerDialog_MediaRouterCallback$__constructor__(mediaRouteControllerDialog);
        }

        private MediaRouterCallback(MediaRouteControllerDialog mediaRouteControllerDialog) {
            this.this$0 = mediaRouteControllerDialog;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_MediaRouteControllerDialog_MediaRouterCallback$__constructor__(com.android.internal.app.MediaRouteControllerDialog ), 0, this, mediaRouteControllerDialog);
        }

        @Override
        public void onRouteUnselected(MediaRouter mediaRouter, int n, MediaRouter.RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("onRouteUnselected", $$robo$$com_android_internal_app_MediaRouteControllerDialog_MediaRouterCallback$onRouteUnselected(android.media.MediaRouter int android.media.MediaRouter$RouteInfo ), 0, this, mediaRouter, n, routeInfo);
        }

        @Override
        public void onRouteChanged(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("onRouteChanged", $$robo$$com_android_internal_app_MediaRouteControllerDialog_MediaRouterCallback$onRouteChanged(android.media.MediaRouter android.media.MediaRouter$RouteInfo ), 0, this, mediaRouter, routeInfo);
        }

        @Override
        public void onRouteVolumeChanged(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("onRouteVolumeChanged", $$robo$$com_android_internal_app_MediaRouteControllerDialog_MediaRouterCallback$onRouteVolumeChanged(android.media.MediaRouter android.media.MediaRouter$RouteInfo ), 0, this, mediaRouter, routeInfo);
        }

        @Override
        public void onRouteGrouped(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo, MediaRouter.RouteGroup routeGroup, int n) {
            InvokeDynamicSupport.bootstrap("onRouteGrouped", $$robo$$com_android_internal_app_MediaRouteControllerDialog_MediaRouterCallback$onRouteGrouped(android.media.MediaRouter android.media.MediaRouter$RouteInfo android.media.MediaRouter$RouteGroup int ), 0, this, mediaRouter, routeInfo, routeGroup, n);
        }

        @Override
        public void onRouteUngrouped(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo, MediaRouter.RouteGroup routeGroup) {
            InvokeDynamicSupport.bootstrap("onRouteUngrouped", $$robo$$com_android_internal_app_MediaRouteControllerDialog_MediaRouterCallback$onRouteUngrouped(android.media.MediaRouter android.media.MediaRouter$RouteInfo android.media.MediaRouter$RouteGroup ), 0, this, mediaRouter, routeInfo, routeGroup);
        }

        private /* synthetic */ void __constructor__(MediaRouteControllerDialog mediaRouteControllerDialog, 1 var2_2) {
            this.$$robo$$com_android_internal_app_MediaRouteControllerDialog_MediaRouterCallback$__constructor__(mediaRouteControllerDialog, var2_2);
        }

        public /* synthetic */ MediaRouterCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaRouterCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

